/* putenv.c (emx+gcc) -- Copyright (c) 1990-1996 by Eberhard Mattes */

#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <emx/startup.h>
#include <emx/time.h>           /* _tzset_flag */

int _putenv (const char *string)
{
  char *s, **p;
  int len, env_size;

  if (string == NULL)
    {
      errno = EINVAL;
      return -1;
    }
  _tzset_flag = 0;              /* Call tzset() */
  s = strchr (string, '=');
  if (s == NULL)
    len = strlen (string);        /* Use complete string */
  else
    len = s - string;
  p = _environ;
  env_size = 0;
  if (p != NULL)
    while (*p != NULL)
      {
        s = *p;
        if (strncmp (s, string, len) == 0 && (s[len] == 0 || s[len] == '='))
          break;
        ++p; ++env_size;
      }
  if (p == NULL || *p == NULL)
    {
      if (_environ == _org_environ)
        {
          p = malloc ((env_size+2) * sizeof (char *));
          if (p == NULL) return -1;
          _environ = p;
          if (env_size != 0)
            memcpy (_environ, _org_environ, env_size * sizeof (char *));
        }
      else
        {
          p = realloc (_environ, (env_size+2) * sizeof (char *));
          if (p == NULL) return -1;
          _environ = p;
        }
      _environ[env_size+0] = (char *)string;
      _environ[env_size+1] = NULL;
    }
  else
    *p = (char *)string;
  return 0;
}
