/*----------------------------------------------------------------------*
 * Bounds Checking for GCC.						*
 * Copyright (C) 1995 Richard W.M. Jones <rwmj@doc.ic.ac.uk>.		*
 *----------------------------------------------------------------------*
 * This program is free software; you can redistribute it and/or modify	*
 * it under the terms of the GNU General Public License as published by	*
 * the Free Software Foundation; either version 2 of the License, or	*
 * (at your option) any later version.					*
 *									*
 * This program is distributed in the hope that it will be useful,	*
 * but WITHOUT ANY WARRANTY; without even the implied warranty of	*
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the	*
 * GNU General Public License for more details.				*
 *									*
 * You should have received a copy of the GNU General Public License	*
 * along with this program; if not, write to the Free Software		*
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.		*
 *----------------------------------------------------------------------*
 * File:
 *	lib/ext-tree.h
 * Summary:
 *	Describes the external representation of the splay tree used in
 *	the `splaytree.aa' etc. files.
 * Other notes:
 *	
 * Author      	Date		Notes
 * RWMJ		28/5/95		Initial implementation.
 *----------------------------------------------------------------------*/

#ifndef _EXT_TREE_H_
#define _EXT_TREE_H_

struct ext_tree {
  char magic [8];			/* Contains `EXT_TREE_MAGIC'. */
  unsigned index;			/* Index of file in time. */
  unsigned dump_every;			/* Frequency of dump operations. */
  unsigned add_operations;
  unsigned del_operations;
  unsigned splay_operations;
  unsigned look_up_operations;
  unsigned nlook_up_operations;
  unsigned splay_steps;
  unsigned look_up_steps;
  unsigned nlook_up_steps;
  unsigned splay_look_up_operations;
  unsigned splay_look_up_steps;
  unsigned splay_add_operations;
  unsigned splay_add_steps;
  unsigned splay_del_operations;
  unsigned splay_del_steps;
};

#define EXT_TREE_MAGIC "STD-003"	/* Magic & version #. */

#endif /* _EXT_TREE_H_ */
