#define INCL_DOSPROCESS
#define INCL_DOSERRORS
#include <os2.h>
#include <errno.h>
#include <process.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>

extern int __vfork_active;
extern int __vfork_result;
extern int __vfork_tid;

int execv (const char *path, char * const *argv)
{
   int i;
   ULONG rc;
   int total_length;
   char *arg_strings;
   char *ptr;
   RESULTCODES ReturnCodes;
   char ObjNameBuf[512];
   char exe_name[512];
   PTIB ptib;
   PPIB ppib;

   if (__vfork_active) {
      DosGetInfoBlocks (&ptib, &ppib);
      if (__vfork_tid != ptib -> tib_ptib2 -> tib2_ultid) {
         errno = EPERM;
         return (-1);
      }
   } else {
      errno = EPERM;
      return (-1);
   }

   strcpy (exe_name, path);

   if (strstr (exe_name, ".exe") == 0 && strstr (exe_name, ".EXE") == 0)
      strcat (exe_name, ".EXE");

   /* construct the command args for DosExecPgm */

   if (argv) {
      for (i = 0, total_length = 1; argv[i]; ++i)
         total_length += strlen (argv[i]) + 1;

      arg_strings = (char *)malloc (total_length);

      for (i = 0, ptr = arg_strings; argv[i]; ++i)
      {
         bcopy (argv[i], ptr, strlen (argv[i])+1);
         ptr += strlen (argv[i]);
         if (i == 0)
            ptr++;
         else
            *ptr++ = ' ';
      }

      *ptr = '\0';
   } else {
      arg_strings = (char *) malloc (2);
      arg_strings[0] = '\0';
      arg_strings[1] = '\0';
   }

   rc = DosExecPgm (&ObjNameBuf[0],
                    512,
                    EXEC_ASYNCRESULT,
                    arg_strings,
                    NULL,
                    &ReturnCodes,
                    exe_name);

   if (rc)
   {
      if (rc == ERROR_FILE_NOT_FOUND || rc == ERROR_PATH_NOT_FOUND)
      {
         errno = ENOENT;
         return (-1);
      }

      errno = EIO;
      return (-1);
   }

   __vfork_result = ReturnCodes.codeTerminate;
   __vfork_active = 0;
   DosExit (EXIT_THREAD, ReturnCodes.codeTerminate);
   return (-1); /* for lint */
}

