#define INCL_DOSFILEMGR
#include <os2.h>
#include <sys/fcntl.h>
#include <errno.h>
#include <stdarg.h>

int fcntl (int fd, int cmd, ...)
{
   ULONG rc;
   ULONG FileHandleState;
   va_list ap;
   int arg;

   va_start(ap, cmd);
   arg = *(int*)ap;
   va_end(ap);

   switch (cmd) {

      case F_GETFD:
          rc = DosQueryFHState (fd, &FileHandleState);

          if (rc) {
             errno = EBADF;
             return (-1);
          }

          if (FileHandleState & OPEN_FLAGS_NOINHERIT) {
             return (1);
          } else {
             return (0);
          }
          break;

      case F_SETFD:
          rc = DosQueryFHState (fd, &FileHandleState);

          if (rc) {
             errno = EBADF;
             return (-1);
          }

          if (arg & 1) {
             FileHandleState |= OPEN_FLAGS_NOINHERIT;
          } else {
             FileHandleState &= ~OPEN_FLAGS_NOINHERIT;
          }

          DosSetFHState (fd, FileHandleState);

          return (arg & 1);

          break;

   }

   return (0x7FFFFFFF);
}


