# Step 1:
#	Set CC to the C compiler you want to use.  On Sun, gcc 
#	produces faster code.  Your mileage may vary.
#CC            = gcc
CC            = cc

# Step 2:
#	Set INCLUDEDIR equal to -I followed by include directory
#	path for X11 include files. 

INCLUDEDIR    = 

#
# Step 3:
#	Set CFLAGS.  Below are def's for some machines.  Uncomment the
#	appropriate one or make one of your own. If you want the player
#       to gather statistics about the video stream, add -DANALYSIS to
#       CFLAGS. If you do NOT want to use shared memory, remove 
#       -DSH_MEM from CFLAGS.
#
#Sun C Flags
#CFLAGS	      =  -O3 -DSH_MEM -DNDEBUG -DBSD -DNONANSI_INCLUDES $(INCLUDEDIR)

#HP C Flags 
#CFLAGS        = -Ac +O3 -DSH_MEM -DNDEBUG $(INCLUDEDIR)

#DEC C Flags
#CFLAGS        = -O -DSH_MEM -DNDEBUG $(INCLUDEDIR)

#RS6000 C Flags
#CFLAGS        = -O -DSH_MEM $(INCLUDEDIR)

#SGI C Flags
#CFLAGS        = -O -cckr -DSH_MEM $(INCLUDEDIR)

#MIPGS RISC/os 4.5{1,2} C Flags
#CFLAGS        = -O -systype sysv -DSH_MEM -DNONANSI_INCLUDES -DMIPS

#PTX Flags (Dynix)
#CFLAGS        = -O -DNDEBUG $(INCLUDEDIR)

#NEWS C Flags
#CFLAGS	       = -O2 -DSh_MEM -DNO_LRAND48 -DNDEBUG -DBSD -DNONANSI_INCUDES $(INCLUDEDIR)

#
#NeXT C Flags
#CFLAGS	       = -O -DNO_LRAND48 -DNDEBUG $(INCLUDEDIR)

#CETIA Unigraph/X C Flags
#CFLAGS	       = -O -DNDEBUGS $(INCLUDEDIR) -DBSDCOMPAT -DBSD_LARGE -DCETIA -DX_NOT_STDC_ENV

#
# Step 4:
#	Set LIBS equal to path of libX11.a and libXext.a or the loader
#	flag equivalents (i.e. -lX11 -lXext).
#       If you are NOT using shared memory, libXext.a is unecessary.
#       NOTE: below the default definition are
#             a few definitions for specific architectures.

LIBS	      = /usr/lib/libX11.a /usr/lib/libXext.a

# LIBS for MIPS RISC/os 4.5{1,2}
#LIBS         = -systype sysv -lX11 -lXext -lbsd

# LIBS for PTX/Dynix
#LIBS         = -lX11 -lsocket -linet -lnsl -lXext -lseq

# LIBS for CETIA Unigraph/X
#LIBS	      = -lX11 -lbsd

#
# Step 5:
#	Set DEST to pathname of final destination of player...
#
DEST	      = .

#
# That's it!  The rest of this shouldn't need any modifications...
#
EXTHDRS	      =

HDRS	      = util.h video.h decoders.h fs2.h dither.h fs4.h

INSTALL	      = /etc/install

LD	      = $(CC)

LDFLAGS	      =

MAKEFILE      = Makefile

OBJS          = util.o video.o parseblock.o motionvector.o decoders.o \
                fs2.o fs2fast.o fs4.o hybrid.o hybriderr.o 2x2.o \
		gdith.o gray.o mono.o main.o jrevdct.o 24bit.o util32.o ordered.o \
		ordered2.o mb_ordered.o

PRINT	      = pr

PROGRAM       = mpeg_play

SHELL	      = /bin/sh

SRCS	      = util.c video.c parseblock.c motionvector.c decoders.c \
		main.c gdith.c fs2.c fs2fast.c fs4.c hybrid.c hybriderr.c \
		2x2.c gray.c mono.c jrevdct.c 24bit.c util32.c ordered.c \
		ordered2.c mb_ordered.c

SYSHDRS	      = 

all:		$(PROGRAM)

$(PROGRAM):	$(OBJS)
		$(LD) $(LDFLAGS) $(OBJS) $(LIBS) -lm -o mpeg_play

clean:;		@rm -f *.o core
 
clobber:;	@rm -f $(OBJS) $(PROGRAM) core tags

depend:;	@mkmf -f $(MAKEFILE) ROOT=$(ROOT)

echo:;		@echo $(HDRS) $(SRCS)

index:;		@ctags -wx $(HDRS) $(SRCS)

install:	$(PROGRAM)
		@echo Installing $(PROGRAM) in $(DEST)
		@-strip $(PROGRAM)
		@if [ $(DEST) != . ]; then \
		(rm -f $(DEST)/$(PROGRAM); $(INSTALL) -f $(DEST) $(PROGRAM)); fi

print:;		@$(PRINT) $(HDRS) $(SRCS)

tags:           $(HDRS) $(SRCS); @ctags $(HDRS) $(SRCS)

update:		$(DEST)/$(PROGRAM)









