* **********************************************************************
* ** NOAA/USGS GENERAL MAP PROJECTION PACKAGE ..... DR. A. A. ELASSAL **
* ** GCTP/II                 VERSION 1.0.2           SEPTEMBER 1,1986 **
* **********************************************************************
      DOUBLE PRECISION FUNCTION SPAKZ0 (ANG,IPFILE,IFLG)
*
* FUNCTION TO CONVERT SECONDS OF ARC TO PACKED DMS
*
      IMPLICIT REAL*8 (A-H,M-Z)
      DIMENSION CODE(2)
      DATA CODE /10000.0D0,100.0D0/
      DATA ZERO,ONE /0.0D0,1.0D0/
      DATA C1,C2 /3600.0D0,60.0D0/
*
* SEPERATE DEGREE FIELD.
*
      IFLG = 0
      FACTOR = ONE
      IF (ANG .LT. ZERO) FACTOR = - ONE
      SEC = DABS(ANG)
      I = SEC / C1
      IF (I .GT. 360) GO TO 020
      DEG = I
*
* SEPERATE MINUTES FIELD.
*
      SEC = SEC - DEG * C1
      I = SEC / C2
      MIN = I
*
* SEPERATE SECONDS FIELD.
*
      SEC = SEC - MIN * C2
      SEC = FACTOR * (DEG * CODE(1) + MIN * CODE(2) + SEC)
      GO TO 040
*
* ERROR DETECTED IN DMS FORM.
*
  020 IF (IPFILE .NE. 0) WRITE (IPFILE,2000) ANG
 2000 FORMAT (' ANGLE G.T. 360 DEGREES = ',F15.3)
      IFLG = 13
      RETURN
*
  040 SPAKZ0 = SEC
*
      RETURN
      END
