#ifndef GTOOLKIT_GTKOBJECT_H
#define GTOOLKIT_GTKOBJECT_H

#include <GToolKit/GTK.h>
#include <gtk/gtkobject.h>

@interface GTKObject : GTK
+ (GtkType	) getType;
+ (void	) classAddSignals:(GtkObjectClass	*) klass signals:(guint *) signals nsignals:(guint) nsignals;
+ objectvWithType:(GtkType	) type nargs:(guint) nargs args:(GtkArg *) args;
- initvWithType:(GtkType	) type nargs:(guint) nargs args:(GtkArg *) args;
- (void) sink;
- (void) ref;
- (void) unref;
- (void) weakref:(GtkDestroyNotify) notify data:(gpointer) data;
- (void) weakunref:(GtkDestroyNotify) notify data:(gpointer) data;
- (void) destroy;
- (void	) getv:(guint) nargs args:(GtkArg *) args;
- (void	) setv:(guint) nargs args:(GtkArg *) args;
+ (GtkArg*) queryArgs:(GtkType	) class_type argFlags:(guint32	**) arg_flags nargs:(guint *) nargs;
+ (void	) addArgType:(const NSString *) arg_name argType:(GtkType	) arg_type argFlags:(guint) arg_flags argId:(guint) arg_id;
+ (GtkType	) getArgType:(const NSString *) arg_name;
- (void) setData:(const NSString *) key data:(gpointer) data;
- (void) setDataFull:(const NSString *) key data:(gpointer) data destroy:(GtkDestroyNotify) destroy;
- (gpointer) getData:(const NSString *) key;
- (void) removeData:(const NSString *) key;
- (void) setDataById:(guint) data_id data:(gpointer) data;
- (void) setDataByIdFull:(guint) data_id data:(gpointer) data destroy:(GtkDestroyNotify) destroy;
- (gpointer) getDataById:(guint) data_id;
- (void) removeDataById:(guint) data_id;
+ (guint) dataTryKey:(const NSString *) key;
+ (guint) dataForceId:(const NSString *) key;
- (void) setUserData:(gpointer) data;
- (gpointer) getUserData;
- (GTKObject*) checkCast:(GtkType) cast_type;
+ (GtkObjectClass*) checkClassCast:(GtkObjectClass *) klass castType:(GtkType) cast_type;
@end

#endif
