#include <Foundation/NSAutoreleasePool.h>
#include <GToolKit/GToolKit.h>

static GTKText *text;

@interface Foo : NSObject
{
    GTKFileSelection *filesel;
}

- (void) openFile:(id) sender;
- (void) help:(id) sender;
- (void) ok:(id) sender;
- (void) cancel:(id) sender;
- (BOOL) windowShouldClose:(GTKWindow *) sender;
- (BOOL) applicationShouldTerminate:(GTKApplication *) sender;
@end

@implementation Foo

- (void) openFile:(id) sender
{
    if (filesel) return;

    filesel = [GTKFileSelection fileSelectionWithTitle:@"Choose a File..."];

    [[filesel okButton] connectSignal:@"clicked" withTarget:self
	sel:@selector(ok:)];
    [[filesel cancelButton] connectSignal:@"clicked" withTarget:self
	sel:@selector(cancel:)];
    [filesel show];
}

- (void) help:(id) sender
{
    GTKRunMessageBox(@"Oops", @"No help available!", @"Cry", @"Ignore",
		     @"Panic");
}

- (void) ok:(id) sender
{
    NSString *file = [[[NSString alloc] initWithContentsOfFile:
			[filesel getFilename]] autorelease];

    [filesel destroy];
    filesel = nil;

    if (file)
    {
	[text deleteText:0 endPos:-1];
	[text insert:NULL fore:NULL back:NULL chars:file length:-1];
    }
}

- (void) cancel:(id) sender
{
    [filesel destroy];
    filesel = nil;
}

- (BOOL) windowShouldClose:(GTKWindow *) sender
{
    [GTKApp terminate:self];
    return NO;			// return NO => cancel window close
}

- (BOOL) applicationShouldTerminate:(GTKApplication *) sender
{
    static int bar;

    if (bar++) return YES;

    GTKRunMessageBox(nil, @"--==>> Try again <<==--", @"Continue", nil, nil);
    return NO;
}
@end

int main (int argc, char *argv[])
{
    NSAutoreleasePool *pool = [NSAutoreleasePool new];
    Foo *foo = [[Foo new] autorelease];
    GTKWindow *window;
    GTKVBox *box;
    GTKScrolledWindow *scroll;
    GTKHandleBox *hbox;
    GTKToolbar *toolbar;
    GTKMenuBar *menubar;
    GTKMenuItem *item;
    GTKMenu *menu;

    [[GTKApplication alloc] initWithArgc:&argc argv:&argv];
    [GTKApp setDelegate:foo];

    window = [GTKWindow windowWithType:GTK_WINDOW_TOPLEVEL];
    box = [GTKVBox vBoxWithHomogeneous:NO spacing:0];
    scroll = [GTKScrolledWindow scrolledWindowWithHadjustment:nil
				vadjustment:nil];
    menubar = [GTKMenuBar menuBar];
    toolbar = [GTKToolbar toolbarWithOrientation:GTK_ORIENTATION_HORIZONTAL
			  style:GTK_TOOLBAR_TEXT];
    menu = [GTKMenu menu];
    hbox = [GTKHandleBox handleBox];
    text = [GTKText textWithHadj:nil vadj:nil];

    item = [GTKMenuItem menuItemWithLabel:@"File"];
    [item setSubmenu:menu];
    [menubar append:item];
    item = [GTKMenuItem menuItemWithLabel:@"Help"];
    [item connectSignal:@"activate" withTarget:foo sel:@selector(help:)];
    [item rightJustify];
    [menubar append:item];

    [menu append:[GTKTearoffMenuItem tearoffMenuItem]];	// tearoff
    item = [GTKMenuItem menuItemWithLabel:@"Open..."];
    [item connectSignal:@"activate" withTarget:foo sel:@selector(openFile:)];
    [menu append:item];
    [menu append:[GTKMenuItem menuItem]];		// separator
    item = [GTKMenuItem menuItemWithLabel:@"Close"];
    [item connectSignal:@"activate" withTarget:window
	  sel:@selector(performClose:)];
    [menu append:item];

    [[toolbar appendItem:@"Open..." tooltipText:@"Open File"
	      tooltipPrivateText:nil icon:nil callback:NULL userData:NULL]
	connectSignal:@"clicked" withTarget:foo sel:@selector(openFile:)];
    [[toolbar appendItem:@"Close" tooltipText:@"Close File"
	      tooltipPrivateText:nil icon:nil callback:NULL userData:NULL]
	connectSignal:@"clicked" withTarget:window
	sel:@selector(performClose:)];

    [hbox add:toolbar];
    [scroll add:text];
    [text setEditable:YES];
    [box packStart:menubar expand:NO fill:YES padding:0];
    [box packStart:hbox expand:NO fill:YES padding:0];
    [box packStartDefaults:scroll];

    [window setDelegate:foo];
    [window setUsize:400 height:240];
    [window add:box];
    [window show];

    [GTKApp run];
    [pool release];
    return 0;
}
