#!/usr/bin/python

import string

objects = ( "Adjustment", "Alignment", "Arrow", "AspectFrame", "Bin", "Box",
  "Button",
  "ButtonBox", "CheckButton", "CheckMenuItem", "CList", "ColorSelection",
  "ColorSelectionDialog", "Combo", "Container", "Curve", "Data", "Dialog",
  "DrawingArea", "Editable", "Entry", "EventBox", "FileSelection", "Fixed",
  "Frame",
  "GammaCurve", "HandleBox", "HBox", "HButtonBox", "HPaned", "HRuler",
  "HScale", "HScrollbar", "HSeparator", "Image", "InputDialog", "Item",
  "Label", "List", "ListItem", "Menu", "MenuBar", "MenuItem", "MenuShell",
  "Misc", "Notebook", "Object", "OptionMenu", "Paned", "Pixmap", "Preview",
  "ProgressBar", "RadioButton", "RadioMenuItem", "Range", "Ruler", "Scale",
  "Scrollbar", "ScrolledWindow", "Separator", "SpinButton", "Statusbar",
  "Table", "Text", "TipsQuery",
  "ToggleButton", "Toolbar", "Tooltips", "Tree", "TreeItem", "VBox",
  "VButtonBox",
  "Viewport", "VPaned", "VRuler", "VScale", "VScrollbar", "VSeparator",
  "Widget", "Window" )

f = open("obj_typemap.i", "w")

f.write("# typemaps for Gtk objects to Python equivalents\n\n");

for obj in objects:
	OBJ = ''
	for c in obj:
		if c in string.uppercase:
			OBJ = OBJ + '_' + c
		else:
			OBJ = OBJ + string.upper(c)
	if obj == 'CList': OBJ = '_CLIST'
	f.write("%%typemap(python,in) Gtk%s * {\n" % (obj,))
	f.write("        if (PyGtk_Check($source))\n")
	f.write("            $target = GTK%s(PyGtk_Get($source));\n" % (OBJ,))
	f.write("        else {\n")
	f.write('            PyErr_SetString(PyExc_TypeError, "object not a Gtk Object");\n')
	f.write("            return NULL;\n")
	f.write("        }\n")
	f.write("    }\n\n")
	f.write("%%typemap(python,out) Gtk%s * {\n" % (obj,))
	f.write("        $target = PyGtk_New((GtkObject *)$source);\n")
	f.write("    }\n\n")

f.close()

