#ifndef Clipper_hpp
#define Clipper_hpp

#include "XVertex.hpp"
#include "Plane.hpp"

namespace swShader
{
	class Clipper
	{
	public:
		enum ClipFlags
		{
			CLIP_NEAR    = 1 << 0,
			CLIP_FAR     = 1 << 1,
			CLIP_LEFT    = 1 << 2,
			CLIP_RIGHT   = 1 << 3,
			CLIP_TOP     = 1 << 4,
			CLIP_BOTTOM  = 1 << 5,

			CLIP_ALL     = CLIP_NEAR  |
			               CLIP_FAR   |
		                   CLIP_LEFT  |
		                   CLIP_RIGHT |
		                   CLIP_TOP   |
		                   CLIP_BOTTOM,

			// User-defined clipping planes
			CLIP_PLANE0	= 1 << 6,
			CLIP_PLANE1	= 1 << 7,
			CLIP_PLANE2	= 1 << 8,
			CLIP_PLANE3	= 1 << 9,
			CLIP_PLANE4	= 1 << 10,
			CLIP_PLANE5	= 1 << 11,
		};

		Clipper();

		~Clipper();

		XVertex **clipTriangle(XVertex &V1, XVertex &V2, XVertex &V3, FVFFlags FVF);
		int getNumVertices() const;

		void setClipFlags(int flags);
		void setClipPlane(int index, const Plane &plane);
		int getClipFlags();
		Plane getClipPlane(int index);

	private:
		void clipNear();
		void clipFar();
		void clipLeft();
		void clipRight();
		void clipTop();
		void clipBottom();
		void clipPlane(int index);

		XVertex clipEdge(const XVertex &Vi, const XVertex &Vj, float d) const;

		FVFFlags FVF;
		int clipFlags;

		Plane plane[6];

		XVertex B[16][16];    // Buffer for clipped vertices
		XVertex *P[16][16];   // Pointers to polygon's vertices
		int numVertices;
		int stage;
	};
}

#endif   // Clipper_hpp