// This may look like C code, but it is really -*- C++ -*-
// 
// <copyright> 
//  
//  Copyright (c) 1993 
//  Institute for Information Processing and Computer Supported New Media (IICM), 
//  Graz University of Technology, Austria. 
//  
// </copyright> 
// 
// 
// <file> 
// 
// Name:        dcerror.h
// 
// Purpose:     
// 
// Created:     3 Dec 93   Joerg Faschingbauer
// 
// Modified:    
// 
// Description: 
// 
// 
// </file> 
#ifndef hg_hyperg_dcerror_h
#define hg_hyperg_dcerror_h

#include <hyperg/hyperg/error.h>
#include <hyperg/hyperg/language.h>


// <class> 
//  
// Name:             DcErrorBase
// 
// Purpose:          
// 
// Public Interface: 
// 
// Description:      
// 
// </class> 
class DcErrorBase : public ErrorBase {
public:
   enum DcCode {
      OK,

         // connection part
         REQUESTPENDING,
         NOCONNECTION,
         WRONGVERSION,

         // server part
         NOTINITIALIZED,
         BADREQUEST,

         BADLRN,
         OPENSTORE_WRITE,
         OPENSTORE_READ,
         READSTORE,
         WRITESTORE,
         CLOSESTORE,

         BADPATH,
         NOPATH,
         OPENFILE,
         READFILE,
         WRITEFILE, 

         CONNECTCLIENT,
         ACCEPT,
         READSOCKET,
         WRITESOCKET,

         NOHEADER,
         TOOMUCHDATA,
         TOOFEWDATA,

         SERVERTIMEOUT, // the server did not response for a certain amount of time (see DcStub)
         NOTIMPLEMENTED,
         USERBREAK,

         INTERNAL, // e.g.parsing the objects sent by the server (or even something more nasty)
         INVALIDOBJECT,
         JOBTIMEOUT, // the client did not read/write for a certain amount of time 
         // (see From-/ToSocket)

         OPENPORT, // see RemoteHgToXXX, ReceivePort (receiver.[hC])
         NODATA,
         NOPORT,
         NOTCACHED,
         BADCACHETYPE,
         OPENCACHE_WRITE,
         OPENCACHE_READ,
         NOSOURCE, // neither a CacheKey nor a port specified
         CLOSECACHE,
         CONNECTREMOTE,
         LOCKREFUSED,
         CREATESTORE,
         CREATECACHE,
         CONNECT, // general connect error. dont know if client or remote server.
         INVALIDADDRESS,

         // these two take effect if the client requested children and
         // the document turned out to be data, or turned around,
         // respectively
         AINTNOCHILDREN,
         AINTNODATA,

         NERRORS
         } ;

   DcErrorBase() {}

   static DcCode dcCode (int code) ;

   virtual ErrorBase::ErrorClass getClassId() const ; 
   virtual const char* getClassName (int language=HgLanguage::Default) const ;
   virtual const char* getDescription (int code, int language=HgLanguage::Default) const ;
   virtual boolean getOk (int code) const ;
   virtual int okDigit() const { return OK; }
} ;

// <class> 
//  
// Name:             DcError
// 
// Purpose:           
// 
// Public Interface: 
// 
// Description:      
// 
// </class> 
class DcError : public Error, public DcErrorBase {
public:
   DcError (DcErrorBase::DcCode c=DcErrorBase::OK) ;
   DcError (const DcError& err) ;
   DcError (int code) ;

   DcError& operator = (const DcError& err) ; 
   DcError& operator = (DcErrorBase::DcCode c) ; 
   DcError& operator = (int c) ; 

   DcErrorBase::DcCode dcCode() const { return DcErrorBase::dcCode(code_); }

   ErrorBase::ErrorClass classId() const ;
   const char* className (int language) const ;
   const char* description (int language=HgLanguage::Default) const ;

   boolean ok() const ;
   boolean operator !() const ;
   operator void*() const ;

   boolean operator != (DcErrorBase::DcCode err) const ;
   boolean operator == (DcErrorBase::DcCode err) const ;
} ;







#endif
