// This may look like C code, but it is really -*- C++ -*-

// <copyright>
// 
// Copyright (c) 1993-1995
// Institute for Information Processing and Computer Supported New Media (IICM),
// Graz University of Technology, Austria.
// 
// </copyright>

//<file>
//
// Name:       hgunistd.h
//
// Purpose:    Machine independent unistd.h
//
// Created:    24 Jun 94    Gerald Pani
//
// Description:
//
// Includes unistd.h or sysent.h depending on the current platform.
//
// Functions sysread and syswrite behaves like read and write,
// but don't return on interrupts.
//
// Function hg_signal replaces signal.
// 
//</file>

// $Log: hgunistd.h,v $
// Revision 1.3  1995/08/24 13:39:32  gpani
// ultrix adjustments
//

#ifndef hg_utils_hgunistd_h
#define hg_utils_hgunistd_h

#ifdef BSD
#  ifdef SUN
#    ifdef  __GNUC__
#      include <sysent.h>
extern "C" int gethostname(char*, int);
extern "C" int sethostent(int);
#      include <errno.h>
extern "C" int sys_nerr;
extern "C" char *sys_errlist[];
#    else
#      include <sysent.h>
#      define KERNEL
extern "C" {
#      include <cc/unistd.h>
     
     extern long sysconf( int);
}
#      undef KERNEL
#      include <errno.h>
#    endif
#  endif

#  ifdef ULTRIX
#    ifdef  __GNUC__
#      include <sys/types.h>
extern "C" {
        void _exit(int);
        int acct(const char*);
        int chroot(const char*);
        int ioctl(int, int ...);
        int kill(int, int);
        int nice(int);
        int pipe(int*);
        void sync();
        long ulimit(int, long);
        int unlink(const char*);
        int system(const char*);
        int mknod(const char*, int, int);
        int rmdir(const char*);
        int rename(const char*, const char*);
        int sethostid(long);
        int fchmod(int, int);
        int fchown(int, int, int);
        int fsync(int);
        int getdomainname(char*, int);
        int gethostname(char*, int);
        void profil(const char*, int, int, int);
        int readlink(const char*, char*, int);
        int setdomainname(const char*, int);
        int setgroups(int, const int*);
        int sethostname(const char*, int);
        int shutdown(int, int);
        int swapon(const char*);
        int symlink(const char*, const char*);
        int vfork();
        caddr_t brk(caddr_t);
        off_t lseek(int, off_t, int);
        int ftruncate(int, off_t);
        int truncate(const char*, off_t);
        int getdtablesize();
        int flock(int, int);
        long gethostid();
        int getpagesize();
        int killpg(int, int);
        int syscall(int ...);
        int vadvise(int);
        int mount(const char*, const char*, int);
        int umount(const char*);
        int getpgrp(int);
        caddr_t sbrk(int);
        int setegid(int);
        int seteuid(int);
        int setpgrp(int, int);
        int setreuid(int, int);
        int setregid(int, int);
        int setrgid(int);
        int setruid(int);
        void vhangup();
	void tzset();
	void sethostent(int);
}
#      include <unistd.h>
#      include <errno.h>
extern "C" int sys_nerr;
extern "C" char *sys_errlist[];
#    else
#      include <sysent.h>
#      define KERNEL
extern "C" {
#      include <cc/unistd.h>
     
       extern long sysconf( int);
}
#      undef KERNEL
#      include <errno.h>
#    endif
#  endif

#  ifdef OSF1
#    include <unistd.h>
#    include <errno.h>
#  endif

#else
// not BSD
#  include <unistd.h>
#  include <errno.h>
#endif


#include <sys/time.h>

#if defined(OSF1) && defined(__DECCXX)
extern "C" {
     extern int select( int nfds, fd_set *rfds, fd_set *wfds, fd_set *efds, struct timeval *tmout);
}
#endif

// functions of hgunistd.C
extern int syswrite( int fd, const char* buf, int nbyte);
extern int sysread( int fd, char* buf, int nbyte);
typedef void Sigfunc(int);
extern Sigfunc* hg_signal( int sig, Sigfunc* handler);



// jfasch 9 Aug 1995
// motivation for these see in hunistd.C

// - return < 0 on errors. In this case, the return value is that of the
//   underlying fcntl(). You may use errno to check the kind of the error afterwards.
// - return == 0 if ok.
int set_blocking (int fd, int bl /*interpret as "boolean"*/) ; 

// - return < 0 on error. As above.
// - return == 0 if non-blocking.
// - return > 0 if blocking.
int get_blocking (int fd) ;


#endif





