// This may look like C code, but it is really -*- C++ -*-
// <copyright> 
//  
//  Copyright (c) 1993 
//  Institute for Information Processing and Computer Supported New Media (IICM), 
//  Graz University of Technology, Austria. 
//  
// </copyright> 

// <file> 
// 
// Name:        verbose.h
// 
// Purpose:     verbose (debugging) output
// 
// Created:     11 Jan 94   Michael Pichler
// 
// Modified:    26 Jan 94   Michael Pichler 
// 
// Description: if VERBOSE is defined, debug output is written to cerr,
//              but only if the  global variable verbose is set non zero;
//              DEBUG appends a space, DEBUGNL a newline,
//              several output may be written at once, separated with <<;
//              if VERBOSE is not defined, DEBUG does nothing;
//              variable verbose has to be defined in the program.
// 
// </file> 


#ifndef hg_hyperg_verbose_h
#define hg_hyperg_verbose_h


#ifdef VERBOSE

#include <iostream.h>

extern int verbose;

#define DBNR(x,nr)  \
{ if (::verbose>0 && nr<=::verbose)   \
    cerr << x << ' ';  \
}

#define DBNRNL(x,nr)  \
{ if (::verbose>0 && nr<=::verbose)   \
    cerr << x << endl;  \
}

#define DEBUG(x) DBNR(x,1)

#define DEBUGNL(x) DBNRNL(x,1)

#else

#define DBNR(x, y)  
#define DBNRNL(x, y)  
#define DEBUG(x)  
#define DEBUGNL(x)  


#endif



#endif
