#!/usr/bin/awk -f

# The caller must set -v helpfile=help-NAME.h and pass arg NAME.NUM.md

BEGIN {
    heading = "/* DO NOT EDIT THIS FILE!  It is auto-generated from the option list in " ARGV[1] "! */"
    findcomment = helpfile
    sub("\\.", "\\.", findcomment)
    findcomment = "\\[comment\\].*" findcomment
    backtick_cnt = 0
    prints = ""
}

/^```/ {
    backtick_cnt++
    next
}

foundcomment {
    if (backtick_cnt > 1) exit
    if (backtick_cnt == 1) {
	gsub(/"/, "\\\"")
	prints = prints "\n  rprintf(F,\"" $0 "\\n\");"
    }
    next
}

$0 ~ findcomment {
    foundcomment = 1
    backtick_cnt = 0
}

END {
    if (foundcomment && backtick_cnt > 1)
	print heading "\n" prints > helpfile
    else {
	print "Failed to find " helpfile " section in " ARGV[1]
	exit 1
    }
}
