#define NBUCKETS 16
#define NPROTOS 6
#define HASHSIZE 256
#define NDPROTO 0
#define ICMPPROTO 1
#define UDPPROTO 2
#define TCPPROTO 3
#define ARPPROTO 4
#define OTHERPROTO 5
#define MINPACKETLEN 60
#define MAXPACKETLEN 1514

struct ethertimeval {
	u_int tv_seconds;
	u_int tv_useconds;
};
typedef struct ethertimeval ethertimeval;
bool_t xdr_ethertimeval();


struct etherstat {
	ethertimeval e_time;
	u_int e_bytes;
	u_int e_packets;
	u_int e_bcast;
	u_int e_size[NBUCKETS];
	u_int e_proto[NPROTOS];
};
typedef struct etherstat etherstat;
bool_t xdr_etherstat();


struct etherhmem_node {
	int h_addr;
	u_int h_cnt;
	struct etherhmem_node *h_nxt;
};
typedef struct etherhmem_node etherhmem_node;
bool_t xdr_etherhmem_node();


typedef etherhmem_node *etherhmem;
bool_t xdr_etherhmem();


struct etheraddrs {
	ethertimeval e_time;
	u_int e_bytes;
	u_int e_packets;
	u_int e_bcast;
	etherhmem e_addrs[HASHSIZE];
};
typedef struct etheraddrs etheraddrs;
bool_t xdr_etheraddrs();


struct addrmask {
	int a_addr;
	int a_mask;
};
typedef struct addrmask addrmask;
bool_t xdr_addrmask();


#define ETHERPROG ((u_long)100010)
#define ETHERVERS ((u_long)1)
#define ETHERPROC_GETDATA ((u_long)1)
extern etherstat *etherproc_getdata_1();
#define ETHERPROC_ON ((u_long)2)
extern void *etherproc_on_1();
#define ETHERPROC_OFF ((u_long)3)
extern void *etherproc_off_1();
#define ETHERPROC_GETSRCDATA ((u_long)4)
extern etheraddrs *etherproc_getsrcdata_1();
#define ETHERPROC_GETDSTDATA ((u_long)5)
extern etheraddrs *etherproc_getdstdata_1();
#define ETHERPROC_SELECTSRC ((u_long)6)
extern void *etherproc_selectsrc_1();
#define ETHERPROC_SELECTDST ((u_long)7)
extern void *etherproc_selectdst_1();
#define ETHERPROC_SELECTPROTO ((u_long)8)
extern void *etherproc_selectproto_1();
#define ETHERPROC_SELECTLNTH ((u_long)9)
extern void *etherproc_selectlnth_1();

