/*
 * defines for the system specific memory routines
 *
 * Copyright 1993 by the Antaire Corporation
 *
 * This file is part of the malloc-debug package.
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose and without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies, and that
 * the name of Antaire not be used in advertising or publicity pertaining to
 * distribution of the document or software without specific, written prior
 * permission.
 *
 * The Antaire Corporation makes no representations about the suitability of
 * the software described herein for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * The author may be contacted at gray.watson@antaire.com
 *
 * $Id: heap.h,v 1.21 1994/04/07 21:16:19 gray Exp $
 */

#ifndef __HEAP_H__
#define __HEAP_H__

#include "malloc_loc.h"				/* for LOCAL and BLOCK_SIZE */

/*
 * error code returned by heap allocation routine
 */
#define HEAP_ALLOC_ERROR	0L

/*
 * probably machine specific defines used for certain calculations
 */
#if HEAP_GROWS_UP

/* test whether pointer P is in the heap space */
#define IS_IN_HEAP(p)		\
  ((char *)(p) >= (char *)_heap_base && (char *)(p) < (char *)_heap_last)

/* turn pointer P into a block index */
#define WHICH_BLOCK(p)		\
  (((char *)(p) - (char *)_heap_base) / BLOCK_SIZE)

/* get a pointer to the memory block number C */
#define BLOCK_POINTER(c)	((char *)_heap_base + (c) * BLOCK_SIZE)

/* test whether pointer P is on a block boundary */
#define ON_BLOCK(p)		\
  (((char *)(p) - (char *)_heap_base) % BLOCK_SIZE == 0)

/* calculate the size of heap */
#define HEAP_SIZE		((char *)_heap_last - (char *)_heap_base)

#else /* ! HEAP_GROWS_UP */

/* test whether pointer P is in the heap space */
#define IS_IN_HEAP(p)		\
  ((char *)(p) <= (char *)_heap_base && (char *)(p) > (char *)_heap_last)

/* turn pointer P into a block index */
#define WHICH_BLOCK(p)		\
  (((char *)(_heap_base) - (char *)p) / BLOCK_SIZE)

/* get a pointer to the memory block number C */
#define BLOCK_POINTER(c)	((char *)_heap_base - (c) * BLOCK_SIZE)

/* test whether pointer P is on a block boundary */
#define ON_BLOCK(p)		\
  (((char *)(_heap_base) - (char *)p) % BLOCK_SIZE == 0)

/* calculate the size of heap */
#define HEAP_SIZE		((char *)_heap_base - (char *)_heap_last)

#endif /* ! HEAP_GROWS_UP */

/*<<<<<<<<<<  The below prototypes are auto-generated by fillproto */

IMPORT	void		*_heap_base;  /* base of our heap */

IMPORT	void		*_heap_last;  /* end of our heap */

/*
 * check to make sure the heap is still linear.  avoids race conditions
 * returns [NO]ERROR
 */
IMPORT	int	_heap_check(void);

/*
 * function to get SIZE memory bytes from the end of the heap
 */
IMPORT	void	*_heap_alloc(const unsigned int size);

/*
 * return a pointer to the current end of the heap
 */
IMPORT	void	*_heap_end(void);

/*
 * initialize heap pointers.  returns [NO]ERROR
 */
IMPORT	int	_heap_startup(void);

/*
 * align (by extending) _heap_base to block_size byte boundary
 */
IMPORT	void	*_heap_align_base(void);

/*<<<<<<<<<<   This is end of the auto-generated output from fillproto. */

#endif /* ! __HEAP_H__ */
