/* ==== syscall.S ============================================================
 * Copyright (c) 1994 Chris Provenzano, proven@mit.edu
 * All rights reserved.
 *
 */

#ifndef lint
	.text
	.asciz "syscall-sparc-sunos-4.1.3.S,v 1.50.2.1 1994/08/27 04:05:13 proven Exp";
#endif
 
#include <sys/syscall.h>

#define	SYSCALL(x)					\
	.globl _machdep_sys_##x;		\
									\
_machdep_sys_##x:;					\
									\
	mov SYS_##x, %g1;   			\
	ta 0;							\
	bcs,a 2b;						\
	sub %r0,%o0,%o0;				\
	retl							


/*
 * Initial asm stuff for all functions.
 */
	.text
	.align	4

/* ==========================================================================
 * error code for all syscalls. The error value is returned as the negative
 * of the errno value.
 */

1:
	sub		%r0, %o0, %o0
2:
	retl
	nop

/* ==========================================================================
 * machdep_sys_write()
 */
SYSCALL(write)

/* ==========================================================================
 * machdep_sys_read()
 */
SYSCALL(read)

/* ==========================================================================
 * machdep_sys_open()
 */
SYSCALL(open)

/* ==========================================================================
 * machdep_sys_creat()
 */
SYSCALL(creat)

/* ==========================================================================
 * machdep_sys_close()
 */
SYSCALL(close)

/* ==========================================================================
 * machdep_sys_fcntl()
 */
SYSCALL(fcntl)

/* ==========================================================================
 * machdep_sys_lseek()
 */
SYSCALL(lseek)

/* ==========================================================================
 * machdep_sys_dup2()
 */
SYSCALL(dup2)

/* ==========================================================================
 * machdep_sys_dup()
 */
SYSCALL(dup)

/* ==========================================================================
 * machdep_sys_pipe()
 */
SYSCALL(pipe)

/* ==========================================================================
 * machdep_sys_fchmod()
 */
SYSCALL(fchmod)

/* ==========================================================================
 * machdep_sys_fchown()
 */
SYSCALL(fchown)

/* ==========================================================================
 * machdep_sys_fork()
 */
    .globl _machdep_sys_fork;

_machdep_sys_fork:;

    mov SYS_fork, %g1;
    ta 0;
    bcs 1b;
    nop;
    tst %o1
    bne,a __fork_parent
    mov  %g0, %o0
__fork_parent:;
    retl

/* ==========================================================================
 * machdep_sys_execve()
 */
SYSCALL(execve)

/* ==========================================================================
 * machdep_sys_fstat()
 */
SYSCALL(fstat)

/* ==========================================================================
 * machdep_sys_link()
 */
SYSCALL(link)

/* ==========================================================================
 * machdep_sys_unlink()
 */
SYSCALL(unlink)

/* ==========================================================================
 * machdep_sys_chdir()
 */
SYSCALL(chdir)

/* ==========================================================================
 * machdep_sys_chown()
 */
SYSCALL(chown)

/* ==========================================================================
 * machdep_sys_chmod()
 */
SYSCALL(chmod)

/* ==========================================================================
 * machdep_sys_stat()
 */
SYSCALL(stat)

/* ==========================================================================
 * machdep_sys_rename()
 */
SYSCALL(rename)

/* ========================================================================== 
 * Nonstandard calls used to make the system work
 *
 * ==========================================================================
 * machdep_sys_select()
 */
SYSCALL(select)

/* ==========================================================================
 * machdep_sys_getdents()
 */
SYSCALL(getdents)

/* ==========================================================================
 * machdep_sys_wait4()
 */
SYSCALL(wait4)

/* ========================================================================== 
 * Berkeley socket stuff
 * 
 * ==========================================================================
 * machdep_sys_socket()
 */
SYSCALL(socket)

/* ==========================================================================
 * machdep_sys_bind()
 */
SYSCALL(bind)

/* ==========================================================================
 * machdep_sys_connect()
 */
SYSCALL(connect)

/* ==========================================================================
 * machdep_sys_accept()
 */
SYSCALL(accept)

/* ==========================================================================
 * machdep_sys_listen()
 */
SYSCALL(listen)

/* ==========================================================================
 * machdep_sys_getsockopt()
 */
SYSCALL(getsockopt)

/* ==========================================================================
 * machdep_sys_readv()
 */
SYSCALL(readv)

/* ==========================================================================
 * machdep_sys_writev()
 */
SYSCALL(writev)

/* ==========================================================================
 * machdep_sys_send()
 */
SYSCALL(send)

/* ==========================================================================
 * machdep_sys_sendto()
 */
SYSCALL(sendto)

/* ==========================================================================
 * machdep_sys_sendmsg()
 */
SYSCALL(sendmsg)

/* ==========================================================================
 * machdep_sys_recv()
 */
SYSCALL(recv)

/* ==========================================================================
 * machdep_sys_recvfrom()
 */
SYSCALL(recvfrom)

/* ==========================================================================
 * machdep_sys_recvmsg()
 */
SYSCALL(recvmsg)

/* ==========================================================================
 * machdep_sys_getpeername()
 */
SYSCALL(getpeername)

/* ==========================================================================
 * machdep_sys_getsockname()
 */
SYSCALL(getsockname)

/* ==========================================================================
 * machdep_sys_shutdown()
 */
SYSCALL(shutdown)

/* ==========================================================================
 * machdep_sys_getpgrp()
 *
 * POSIX-compliant getpgrp() takes no arguments.  The SunOS syscall wants
 * one, and gives the POSIXy result if that argument is zero.
 */
	.globl _getpgrp
_getpgrp:
	mov SYS_getpgrp, %g1
	mov 0, %i0
	ta 0
	bcs 1b
	nop
	retl
	nop


