/* ==== test_pthread_join.c =================================================
 * Copyright (c) 1993 by Chris Provenzano, proven@athena.mit.edu
 *
 * Description : Test pthread_join(). Run this after test_create()
 *
 *  1.23 94/05/04 proven
 *      -Started coding this file.
 */

#define PTHREAD_KERNEL
#include <pthread.h>
#include <stdio.h>

void* new_thread(void * new_buf)
{
	int i;

	sprintf((char *)new_buf, "New thread %%d stack at %x\n", &i);
	return(new_buf);
	PANIC();
}

main()
{
	char buf[256], *status;
	pthread_t thread;
	int i = 0;

	pthread_init(); 

	printf("Original thread stack at %x\n", &i);
	if (pthread_create(&thread, NULL, new_thread, (void *)buf) == OK) {
		if (pthread_join(thread, &status) == OK) {
			printf(status, ++i);
			/* Now have the created thread finishing before the join. */
			if (pthread_create(&thread, NULL, new_thread, (void *)buf) == OK) {
				if (pthread_join(thread, &status) == OK) {
					printf(status, ++i);
				} else {
					printf("Error: joining with new thread #2.\n");
				} 
			} else {
				printf("Error: creating new thread #2.\n");
			}
		} else {
			printf("Error: joining with new thread #1.\n");
		} 
	} else {
		printf("Error: creating new thread #1.\n");
	}
	pthread_exit(NULL);
	PANIC();
}
