/*-
 * Copyright (c) 2017 John Baldwin <jhb@FreeBSD.org>
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#include <sys/cdefs.h>
__FBSDID("$FreeBSD: stable/11/sys/arm/arm/ptrace_machdep.c 367457 2020-11-07 18:10:59Z dim $");

#include <sys/types.h>
#include <sys/proc.h>
#include <sys/ptrace.h>
#ifdef VFP
#include <machine/vfp.h>
#endif

int
cpu_ptrace(struct thread *td, int req, void *addr, int data)
{
#ifdef VFP
	mcontext_vfp_t vfp;
#endif
	int error;

	switch (req) {
#ifdef VFP
	case PT_GETVFPREGS:
		get_vfpcontext(td, &vfp);
		error = copyout(&vfp, addr, sizeof(vfp));
		break;
	case PT_SETVFPREGS:
		error = copyin(addr, &vfp, sizeof(vfp));
		if (error == 0)
			set_vfpcontext(td, &vfp);
		break;
#endif
	default:
		error = EINVAL;
	}

	return (error);
}
