#include <libecc/lib_ecc_config.h>
#ifdef WITH_CURVE_BRAINPOOLP512T1

#ifndef __EC_PARAMS_BRAINPOOLP512T1_H__
#define __EC_PARAMS_BRAINPOOLP512T1_H__
#include <libecc/curves/known/ec_params_external.h>
static const u8 brainpoolp512t1_p[] = {
	0xaa, 0xdd, 0x9d, 0xb8, 0xdb, 0xe9, 0xc4, 0x8b,
	0x3f, 0xd4, 0xe6, 0xae, 0x33, 0xc9, 0xfc, 0x07,
	0xcb, 0x30, 0x8d, 0xb3, 0xb3, 0xc9, 0xd2, 0x0e,
	0xd6, 0x63, 0x9c, 0xca, 0x70, 0x33, 0x08, 0x71,
	0x7d, 0x4d, 0x9b, 0x00, 0x9b, 0xc6, 0x68, 0x42,
	0xae, 0xcd, 0xa1, 0x2a, 0xe6, 0xa3, 0x80, 0xe6,
	0x28, 0x81, 0xff, 0x2f, 0x2d, 0x82, 0xc6, 0x85,
	0x28, 0xaa, 0x60, 0x56, 0x58, 0x3a, 0x48, 0xf3,
};

TO_EC_STR_PARAM(brainpoolp512t1_p);

#define CURVE_BRAINPOOLP512T1_P_BITLEN 512
static const u8 brainpoolp512t1_p_bitlen[] = {
	0x02, 0x00,
};

TO_EC_STR_PARAM(brainpoolp512t1_p_bitlen);

#if (WORD_BYTES == 8)     /* 64-bit words */
static const u8 brainpoolp512t1_r[] = {
	0x55, 0x22, 0x62, 0x47, 0x24, 0x16, 0x3b, 0x74,
	0xc0, 0x2b, 0x19, 0x51, 0xcc, 0x36, 0x03, 0xf8,
	0x34, 0xcf, 0x72, 0x4c, 0x4c, 0x36, 0x2d, 0xf1,
	0x29, 0x9c, 0x63, 0x35, 0x8f, 0xcc, 0xf7, 0x8e,
	0x82, 0xb2, 0x64, 0xff, 0x64, 0x39, 0x97, 0xbd,
	0x51, 0x32, 0x5e, 0xd5, 0x19, 0x5c, 0x7f, 0x19,
	0xd7, 0x7e, 0x00, 0xd0, 0xd2, 0x7d, 0x39, 0x7a,
	0xd7, 0x55, 0x9f, 0xa9, 0xa7, 0xc5, 0xb7, 0x0d,
};

TO_EC_STR_PARAM(brainpoolp512t1_r);

static const u8 brainpoolp512t1_r_square[] = {
	0x3c, 0x4c, 0x9d, 0x05, 0xa9, 0xff, 0x64, 0x50,
	0x20, 0x2e, 0x19, 0x40, 0x20, 0x56, 0xee, 0xcc,
	0xa1, 0x6d, 0xaa, 0x5f, 0xd4, 0x2b, 0xff, 0x83,
	0x19, 0x48, 0x6f, 0xd8, 0xd5, 0x89, 0x80, 0x57,
	0xe0, 0xc1, 0x9a, 0x77, 0x83, 0x51, 0x4a, 0x25,
	0x53, 0xb7, 0xf9, 0xbc, 0x90, 0x5a, 0xff, 0xd3,
	0x79, 0x3f, 0xb1, 0x30, 0x27, 0x15, 0x79, 0x05,
	0x49, 0xad, 0x14, 0x4a, 0x61, 0x58, 0xf2, 0x05,
};

TO_EC_STR_PARAM(brainpoolp512t1_r_square);

static const u8 brainpoolp512t1_mpinv[] = {
	0x83, 0x9b, 0x32, 0x20, 0x7d, 0x89, 0xef, 0xc5,
};

TO_EC_STR_PARAM(brainpoolp512t1_mpinv);

static const u8 brainpoolp512t1_p_shift[] = {
	0x00,
};

TO_EC_STR_PARAM(brainpoolp512t1_p_shift);

static const u8 brainpoolp512t1_p_normalized[] = {
	0xaa, 0xdd, 0x9d, 0xb8, 0xdb, 0xe9, 0xc4, 0x8b,
	0x3f, 0xd4, 0xe6, 0xae, 0x33, 0xc9, 0xfc, 0x07,
	0xcb, 0x30, 0x8d, 0xb3, 0xb3, 0xc9, 0xd2, 0x0e,
	0xd6, 0x63, 0x9c, 0xca, 0x70, 0x33, 0x08, 0x71,
	0x7d, 0x4d, 0x9b, 0x00, 0x9b, 0xc6, 0x68, 0x42,
	0xae, 0xcd, 0xa1, 0x2a, 0xe6, 0xa3, 0x80, 0xe6,
	0x28, 0x81, 0xff, 0x2f, 0x2d, 0x82, 0xc6, 0x85,
	0x28, 0xaa, 0x60, 0x56, 0x58, 0x3a, 0x48, 0xf3,
};

TO_EC_STR_PARAM(brainpoolp512t1_p_normalized);

static const u8 brainpoolp512t1_p_reciprocal[] = {
	0x7f, 0x8d, 0x7f, 0x4e, 0xd6, 0xda, 0xeb, 0x8a,
};

TO_EC_STR_PARAM(brainpoolp512t1_p_reciprocal);

#elif (WORD_BYTES == 4)   /* 32-bit words */
static const u8 brainpoolp512t1_r[] = {
	0x55, 0x22, 0x62, 0x47, 0x24, 0x16, 0x3b, 0x74,
	0xc0, 0x2b, 0x19, 0x51, 0xcc, 0x36, 0x03, 0xf8,
	0x34, 0xcf, 0x72, 0x4c, 0x4c, 0x36, 0x2d, 0xf1,
	0x29, 0x9c, 0x63, 0x35, 0x8f, 0xcc, 0xf7, 0x8e,
	0x82, 0xb2, 0x64, 0xff, 0x64, 0x39, 0x97, 0xbd,
	0x51, 0x32, 0x5e, 0xd5, 0x19, 0x5c, 0x7f, 0x19,
	0xd7, 0x7e, 0x00, 0xd0, 0xd2, 0x7d, 0x39, 0x7a,
	0xd7, 0x55, 0x9f, 0xa9, 0xa7, 0xc5, 0xb7, 0x0d,
};

TO_EC_STR_PARAM(brainpoolp512t1_r);

static const u8 brainpoolp512t1_r_square[] = {
	0x3c, 0x4c, 0x9d, 0x05, 0xa9, 0xff, 0x64, 0x50,
	0x20, 0x2e, 0x19, 0x40, 0x20, 0x56, 0xee, 0xcc,
	0xa1, 0x6d, 0xaa, 0x5f, 0xd4, 0x2b, 0xff, 0x83,
	0x19, 0x48, 0x6f, 0xd8, 0xd5, 0x89, 0x80, 0x57,
	0xe0, 0xc1, 0x9a, 0x77, 0x83, 0x51, 0x4a, 0x25,
	0x53, 0xb7, 0xf9, 0xbc, 0x90, 0x5a, 0xff, 0xd3,
	0x79, 0x3f, 0xb1, 0x30, 0x27, 0x15, 0x79, 0x05,
	0x49, 0xad, 0x14, 0x4a, 0x61, 0x58, 0xf2, 0x05,
};

TO_EC_STR_PARAM(brainpoolp512t1_r_square);

static const u8 brainpoolp512t1_mpinv[] = {
	0x7d, 0x89, 0xef, 0xc5,
};

TO_EC_STR_PARAM(brainpoolp512t1_mpinv);

static const u8 brainpoolp512t1_p_shift[] = {
	0x00,
};

TO_EC_STR_PARAM(brainpoolp512t1_p_shift);

static const u8 brainpoolp512t1_p_normalized[] = {
	0xaa, 0xdd, 0x9d, 0xb8, 0xdb, 0xe9, 0xc4, 0x8b,
	0x3f, 0xd4, 0xe6, 0xae, 0x33, 0xc9, 0xfc, 0x07,
	0xcb, 0x30, 0x8d, 0xb3, 0xb3, 0xc9, 0xd2, 0x0e,
	0xd6, 0x63, 0x9c, 0xca, 0x70, 0x33, 0x08, 0x71,
	0x7d, 0x4d, 0x9b, 0x00, 0x9b, 0xc6, 0x68, 0x42,
	0xae, 0xcd, 0xa1, 0x2a, 0xe6, 0xa3, 0x80, 0xe6,
	0x28, 0x81, 0xff, 0x2f, 0x2d, 0x82, 0xc6, 0x85,
	0x28, 0xaa, 0x60, 0x56, 0x58, 0x3a, 0x48, 0xf3,
};

TO_EC_STR_PARAM(brainpoolp512t1_p_normalized);

static const u8 brainpoolp512t1_p_reciprocal[] = {
	0x7f, 0x8d, 0x7f, 0x4e,
};

TO_EC_STR_PARAM(brainpoolp512t1_p_reciprocal);

#elif (WORD_BYTES == 2)   /* 16-bit words */
static const u8 brainpoolp512t1_r[] = {
	0x55, 0x22, 0x62, 0x47, 0x24, 0x16, 0x3b, 0x74,
	0xc0, 0x2b, 0x19, 0x51, 0xcc, 0x36, 0x03, 0xf8,
	0x34, 0xcf, 0x72, 0x4c, 0x4c, 0x36, 0x2d, 0xf1,
	0x29, 0x9c, 0x63, 0x35, 0x8f, 0xcc, 0xf7, 0x8e,
	0x82, 0xb2, 0x64, 0xff, 0x64, 0x39, 0x97, 0xbd,
	0x51, 0x32, 0x5e, 0xd5, 0x19, 0x5c, 0x7f, 0x19,
	0xd7, 0x7e, 0x00, 0xd0, 0xd2, 0x7d, 0x39, 0x7a,
	0xd7, 0x55, 0x9f, 0xa9, 0xa7, 0xc5, 0xb7, 0x0d,
};

TO_EC_STR_PARAM(brainpoolp512t1_r);

static const u8 brainpoolp512t1_r_square[] = {
	0x3c, 0x4c, 0x9d, 0x05, 0xa9, 0xff, 0x64, 0x50,
	0x20, 0x2e, 0x19, 0x40, 0x20, 0x56, 0xee, 0xcc,
	0xa1, 0x6d, 0xaa, 0x5f, 0xd4, 0x2b, 0xff, 0x83,
	0x19, 0x48, 0x6f, 0xd8, 0xd5, 0x89, 0x80, 0x57,
	0xe0, 0xc1, 0x9a, 0x77, 0x83, 0x51, 0x4a, 0x25,
	0x53, 0xb7, 0xf9, 0xbc, 0x90, 0x5a, 0xff, 0xd3,
	0x79, 0x3f, 0xb1, 0x30, 0x27, 0x15, 0x79, 0x05,
	0x49, 0xad, 0x14, 0x4a, 0x61, 0x58, 0xf2, 0x05,
};

TO_EC_STR_PARAM(brainpoolp512t1_r_square);

static const u8 brainpoolp512t1_mpinv[] = {
	0xef, 0xc5,
};

TO_EC_STR_PARAM(brainpoolp512t1_mpinv);

static const u8 brainpoolp512t1_p_shift[] = {
	0x00,
};

TO_EC_STR_PARAM(brainpoolp512t1_p_shift);

static const u8 brainpoolp512t1_p_normalized[] = {
	0xaa, 0xdd, 0x9d, 0xb8, 0xdb, 0xe9, 0xc4, 0x8b,
	0x3f, 0xd4, 0xe6, 0xae, 0x33, 0xc9, 0xfc, 0x07,
	0xcb, 0x30, 0x8d, 0xb3, 0xb3, 0xc9, 0xd2, 0x0e,
	0xd6, 0x63, 0x9c, 0xca, 0x70, 0x33, 0x08, 0x71,
	0x7d, 0x4d, 0x9b, 0x00, 0x9b, 0xc6, 0x68, 0x42,
	0xae, 0xcd, 0xa1, 0x2a, 0xe6, 0xa3, 0x80, 0xe6,
	0x28, 0x81, 0xff, 0x2f, 0x2d, 0x82, 0xc6, 0x85,
	0x28, 0xaa, 0x60, 0x56, 0x58, 0x3a, 0x48, 0xf3,
};

TO_EC_STR_PARAM(brainpoolp512t1_p_normalized);

static const u8 brainpoolp512t1_p_reciprocal[] = {
	0x7f, 0x8d,
};

TO_EC_STR_PARAM(brainpoolp512t1_p_reciprocal);

#else                     /* unknown word size */
#error "Unsupported word size"
#endif

static const u8 brainpoolp512t1_a[] = {
	0xaa, 0xdd, 0x9d, 0xb8, 0xdb, 0xe9, 0xc4, 0x8b,
	0x3f, 0xd4, 0xe6, 0xae, 0x33, 0xc9, 0xfc, 0x07,
	0xcb, 0x30, 0x8d, 0xb3, 0xb3, 0xc9, 0xd2, 0x0e,
	0xd6, 0x63, 0x9c, 0xca, 0x70, 0x33, 0x08, 0x71,
	0x7d, 0x4d, 0x9b, 0x00, 0x9b, 0xc6, 0x68, 0x42,
	0xae, 0xcd, 0xa1, 0x2a, 0xe6, 0xa3, 0x80, 0xe6,
	0x28, 0x81, 0xff, 0x2f, 0x2d, 0x82, 0xc6, 0x85,
	0x28, 0xaa, 0x60, 0x56, 0x58, 0x3a, 0x48, 0xf0,
};

TO_EC_STR_PARAM(brainpoolp512t1_a);

static const u8 brainpoolp512t1_b[] = {
	0x7c, 0xbb, 0xbc, 0xf9, 0x44, 0x1c, 0xfa, 0xb7,
	0x6e, 0x18, 0x90, 0xe4, 0x68, 0x84, 0xea, 0xe3,
	0x21, 0xf7, 0x0c, 0x0b, 0xcb, 0x49, 0x81, 0x52,
	0x78, 0x97, 0x50, 0x4b, 0xec, 0x3e, 0x36, 0xa6,
	0x2b, 0xcd, 0xfa, 0x23, 0x04, 0x97, 0x65, 0x40,
	0xf6, 0x45, 0x00, 0x85, 0xf2, 0xda, 0xe1, 0x45,
	0xc2, 0x25, 0x53, 0xb4, 0x65, 0x76, 0x36, 0x89,
	0x18, 0x0e, 0xa2, 0x57, 0x18, 0x67, 0x42, 0x3e,
};

TO_EC_STR_PARAM(brainpoolp512t1_b);

#define CURVE_BRAINPOOLP512T1_CURVE_ORDER_BITLEN 512
static const u8 brainpoolp512t1_curve_order[] = {
	0xaa, 0xdd, 0x9d, 0xb8, 0xdb, 0xe9, 0xc4, 0x8b,
	0x3f, 0xd4, 0xe6, 0xae, 0x33, 0xc9, 0xfc, 0x07,
	0xcb, 0x30, 0x8d, 0xb3, 0xb3, 0xc9, 0xd2, 0x0e,
	0xd6, 0x63, 0x9c, 0xca, 0x70, 0x33, 0x08, 0x70,
	0x55, 0x3e, 0x5c, 0x41, 0x4c, 0xa9, 0x26, 0x19,
	0x41, 0x86, 0x61, 0x19, 0x7f, 0xac, 0x10, 0x47,
	0x1d, 0xb1, 0xd3, 0x81, 0x08, 0x5d, 0xda, 0xdd,
	0xb5, 0x87, 0x96, 0x82, 0x9c, 0xa9, 0x00, 0x69,
};

TO_EC_STR_PARAM(brainpoolp512t1_curve_order);

static const u8 brainpoolp512t1_gx[] = {
	0x64, 0x0e, 0xce, 0x5c, 0x12, 0x78, 0x87, 0x17,
	0xb9, 0xc1, 0xba, 0x06, 0xcb, 0xc2, 0xa6, 0xfe,
	0xba, 0x85, 0x84, 0x24, 0x58, 0xc5, 0x6d, 0xde,
	0x9d, 0xb1, 0x75, 0x8d, 0x39, 0xc0, 0x31, 0x3d,
	0x82, 0xba, 0x51, 0x73, 0x5c, 0xdb, 0x3e, 0xa4,
	0x99, 0xaa, 0x77, 0xa7, 0xd6, 0x94, 0x3a, 0x64,
	0xf7, 0xa3, 0xf2, 0x5f, 0xe2, 0x6f, 0x06, 0xb5,
	0x1b, 0xaa, 0x26, 0x96, 0xfa, 0x90, 0x35, 0xda,
};

TO_EC_STR_PARAM(brainpoolp512t1_gx);

static const u8 brainpoolp512t1_gy[] = {
	0x5b, 0x53, 0x4b, 0xd5, 0x95, 0xf5, 0xaf, 0x0f,
	0xa2, 0xc8, 0x92, 0x37, 0x6c, 0x84, 0xac, 0xe1,
	0xbb, 0x4e, 0x30, 0x19, 0xb7, 0x16, 0x34, 0xc0,
	0x11, 0x31, 0x15, 0x9c, 0xae, 0x03, 0xce, 0xe9,
	0xd9, 0x93, 0x21, 0x84, 0xbe, 0xef, 0x21, 0x6b,
	0xd7, 0x1d, 0xf2, 0xda, 0xdf, 0x86, 0xa6, 0x27,
	0x30, 0x6e, 0xcf, 0xf9, 0x6d, 0xbb, 0x8b, 0xac,
	0xe1, 0x98, 0xb6, 0x1e, 0x00, 0xf8, 0xb3, 0x32,
};

TO_EC_STR_PARAM(brainpoolp512t1_gy);

static const u8 brainpoolp512t1_gz[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
};

TO_EC_STR_PARAM(brainpoolp512t1_gz);

static const u8 brainpoolp512t1_gen_order[] = {
	0xaa, 0xdd, 0x9d, 0xb8, 0xdb, 0xe9, 0xc4, 0x8b,
	0x3f, 0xd4, 0xe6, 0xae, 0x33, 0xc9, 0xfc, 0x07,
	0xcb, 0x30, 0x8d, 0xb3, 0xb3, 0xc9, 0xd2, 0x0e,
	0xd6, 0x63, 0x9c, 0xca, 0x70, 0x33, 0x08, 0x70,
	0x55, 0x3e, 0x5c, 0x41, 0x4c, 0xa9, 0x26, 0x19,
	0x41, 0x86, 0x61, 0x19, 0x7f, 0xac, 0x10, 0x47,
	0x1d, 0xb1, 0xd3, 0x81, 0x08, 0x5d, 0xda, 0xdd,
	0xb5, 0x87, 0x96, 0x82, 0x9c, 0xa9, 0x00, 0x69,
};

TO_EC_STR_PARAM(brainpoolp512t1_gen_order);

#define CURVE_BRAINPOOLP512T1_Q_BITLEN 512
static const u8 brainpoolp512t1_gen_order_bitlen[] = {
	0x02, 0x00,
};

TO_EC_STR_PARAM(brainpoolp512t1_gen_order_bitlen);

static const u8 brainpoolp512t1_cofactor[] = {
	0x01,
};

TO_EC_STR_PARAM(brainpoolp512t1_cofactor);

static const u8 brainpoolp512t1_alpha_montgomery[] = {
	0x00,
};
TO_EC_STR_PARAM_FIXED_SIZE(brainpoolp512t1_alpha_montgomery, 0);

static const u8 brainpoolp512t1_gamma_montgomery[] = {
	0x00,
};
TO_EC_STR_PARAM_FIXED_SIZE(brainpoolp512t1_gamma_montgomery, 0);

static const u8 brainpoolp512t1_alpha_edwards[] = {
	0x00,
};
TO_EC_STR_PARAM_FIXED_SIZE(brainpoolp512t1_alpha_edwards, 0);

static const u8 brainpoolp512t1_name[] = "BRAINPOOLP512T1";
TO_EC_STR_PARAM(brainpoolp512t1_name);

static const u8 brainpoolp512t1_oid[] = "1.3.36.3.3.2.8.1.1.14";
TO_EC_STR_PARAM(brainpoolp512t1_oid);

static const ec_str_params brainpoolp512t1_str_params = {
	.p = &brainpoolp512t1_p_str_param,
	.p_bitlen = &brainpoolp512t1_p_bitlen_str_param,
	.r = &brainpoolp512t1_r_str_param,
	.r_square = &brainpoolp512t1_r_square_str_param,
	.mpinv = &brainpoolp512t1_mpinv_str_param,
	.p_shift = &brainpoolp512t1_p_shift_str_param,
	.p_normalized = &brainpoolp512t1_p_normalized_str_param,
	.p_reciprocal = &brainpoolp512t1_p_reciprocal_str_param,
	.a = &brainpoolp512t1_a_str_param,
	.b = &brainpoolp512t1_b_str_param,
	.curve_order = &brainpoolp512t1_curve_order_str_param,
	.gx = &brainpoolp512t1_gx_str_param,
	.gy = &brainpoolp512t1_gy_str_param,
	.gz = &brainpoolp512t1_gz_str_param,
	.gen_order = &brainpoolp512t1_gen_order_str_param,
	.gen_order_bitlen = &brainpoolp512t1_gen_order_bitlen_str_param,
	.cofactor = &brainpoolp512t1_cofactor_str_param,
	.alpha_montgomery = &brainpoolp512t1_alpha_montgomery_str_param,
	.gamma_montgomery = &brainpoolp512t1_gamma_montgomery_str_param,
	.alpha_edwards = &brainpoolp512t1_alpha_edwards_str_param,
	.oid = &brainpoolp512t1_oid_str_param,
	.name = &brainpoolp512t1_name_str_param,
};

/*
 * Compute max bit length of all curves for p and q
 */
#ifndef CURVES_MAX_P_BIT_LEN
#define CURVES_MAX_P_BIT_LEN    0
#endif
#if (CURVES_MAX_P_BIT_LEN < CURVE_BRAINPOOLP512T1_P_BITLEN)
#undef CURVES_MAX_P_BIT_LEN
#define CURVES_MAX_P_BIT_LEN CURVE_BRAINPOOLP512T1_P_BITLEN
#endif
#ifndef CURVES_MAX_Q_BIT_LEN
#define CURVES_MAX_Q_BIT_LEN    0
#endif
#if (CURVES_MAX_Q_BIT_LEN < CURVE_BRAINPOOLP512T1_Q_BITLEN)
#undef CURVES_MAX_Q_BIT_LEN
#define CURVES_MAX_Q_BIT_LEN CURVE_BRAINPOOLP512T1_Q_BITLEN
#endif
#ifndef CURVES_MAX_CURVE_ORDER_BIT_LEN
#define CURVES_MAX_CURVE_ORDER_BIT_LEN    0
#endif
#if (CURVES_MAX_CURVE_ORDER_BIT_LEN < CURVE_BRAINPOOLP512T1_CURVE_ORDER_BITLEN)
#undef CURVES_MAX_CURVE_ORDER_BIT_LEN
#define CURVES_MAX_CURVE_ORDER_BIT_LEN CURVE_BRAINPOOLP512T1_CURVE_ORDER_BITLEN
#endif

/*
 * Compute and adapt max name and oid length
 */
#ifndef MAX_CURVE_OID_LEN
#define MAX_CURVE_OID_LEN 0
#endif
#ifndef MAX_CURVE_NAME_LEN
#define MAX_CURVE_NAME_LEN 0
#endif
#if (MAX_CURVE_OID_LEN < 1)
#undef MAX_CURVE_OID_LEN
#define MAX_CURVE_OID_LEN 1
#endif
#if (MAX_CURVE_NAME_LEN < 29)
#undef MAX_CURVE_NAME_LEN
#define MAX_CURVE_NAME_LEN 29
#endif

#endif /* __EC_PARAMS_BRAINPOOLP512T1_H__ */

#endif /* WITH_CURVE_BRAINPOOLP512T1 */
