#include <libecc/lib_ecc_config.h>
#ifdef WITH_CURVE_GOST_R3410_2012_512_PARAMSETA

#ifndef __EC_PARAMS_GOST_R3410_2012_512_PARAMSETA_H__
#define __EC_PARAMS_GOST_R3410_2012_512_PARAMSETA_H__
#include <libecc/curves/known/ec_params_external.h>
static const u8 gost_R3410_2012_512_paramSetA_p[] = {
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd, 0xc7,
};

TO_EC_STR_PARAM(gost_R3410_2012_512_paramSetA_p);

#define CURVE_GOST_R3410_2012_512_PARAMSETA_P_BITLEN 512
static const u8 gost_R3410_2012_512_paramSetA_p_bitlen[] = {
	0x02, 0x00,
};

TO_EC_STR_PARAM(gost_R3410_2012_512_paramSetA_p_bitlen);

#if (WORD_BYTES == 8)     /* 64-bit words */
static const u8 gost_R3410_2012_512_paramSetA_r[] = {
	0x02, 0x39,
};

TO_EC_STR_PARAM(gost_R3410_2012_512_paramSetA_r);

static const u8 gost_R3410_2012_512_paramSetA_r_square[] = {
	0x04, 0xf0, 0xb1,
};

TO_EC_STR_PARAM(gost_R3410_2012_512_paramSetA_r_square);

static const u8 gost_R3410_2012_512_paramSetA_mpinv[] = {
	0x58, 0xa1, 0xf7, 0xe6, 0xce, 0x0f, 0x4c, 0x09,
};

TO_EC_STR_PARAM(gost_R3410_2012_512_paramSetA_mpinv);

static const u8 gost_R3410_2012_512_paramSetA_p_shift[] = {
	0x00,
};

TO_EC_STR_PARAM(gost_R3410_2012_512_paramSetA_p_shift);

static const u8 gost_R3410_2012_512_paramSetA_p_normalized[] = {
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd, 0xc7,
};

TO_EC_STR_PARAM(gost_R3410_2012_512_paramSetA_p_normalized);

static const u8 gost_R3410_2012_512_paramSetA_p_reciprocal[] = {
	0x00,
};

TO_EC_STR_PARAM(gost_R3410_2012_512_paramSetA_p_reciprocal);

#elif (WORD_BYTES == 4)   /* 32-bit words */
static const u8 gost_R3410_2012_512_paramSetA_r[] = {
	0x02, 0x39,
};

TO_EC_STR_PARAM(gost_R3410_2012_512_paramSetA_r);

static const u8 gost_R3410_2012_512_paramSetA_r_square[] = {
	0x04, 0xf0, 0xb1,
};

TO_EC_STR_PARAM(gost_R3410_2012_512_paramSetA_r_square);

static const u8 gost_R3410_2012_512_paramSetA_mpinv[] = {
	0xce, 0x0f, 0x4c, 0x09,
};

TO_EC_STR_PARAM(gost_R3410_2012_512_paramSetA_mpinv);

static const u8 gost_R3410_2012_512_paramSetA_p_shift[] = {
	0x00,
};

TO_EC_STR_PARAM(gost_R3410_2012_512_paramSetA_p_shift);

static const u8 gost_R3410_2012_512_paramSetA_p_normalized[] = {
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd, 0xc7,
};

TO_EC_STR_PARAM(gost_R3410_2012_512_paramSetA_p_normalized);

static const u8 gost_R3410_2012_512_paramSetA_p_reciprocal[] = {
	0x00,
};

TO_EC_STR_PARAM(gost_R3410_2012_512_paramSetA_p_reciprocal);

#elif (WORD_BYTES == 2)   /* 16-bit words */
static const u8 gost_R3410_2012_512_paramSetA_r[] = {
	0x02, 0x39,
};

TO_EC_STR_PARAM(gost_R3410_2012_512_paramSetA_r);

static const u8 gost_R3410_2012_512_paramSetA_r_square[] = {
	0x04, 0xf0, 0xb1,
};

TO_EC_STR_PARAM(gost_R3410_2012_512_paramSetA_r_square);

static const u8 gost_R3410_2012_512_paramSetA_mpinv[] = {
	0x4c, 0x09,
};

TO_EC_STR_PARAM(gost_R3410_2012_512_paramSetA_mpinv);

static const u8 gost_R3410_2012_512_paramSetA_p_shift[] = {
	0x00,
};

TO_EC_STR_PARAM(gost_R3410_2012_512_paramSetA_p_shift);

static const u8 gost_R3410_2012_512_paramSetA_p_normalized[] = {
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd, 0xc7,
};

TO_EC_STR_PARAM(gost_R3410_2012_512_paramSetA_p_normalized);

static const u8 gost_R3410_2012_512_paramSetA_p_reciprocal[] = {
	0x00,
};

TO_EC_STR_PARAM(gost_R3410_2012_512_paramSetA_p_reciprocal);

#else                     /* unknown word size */
#error "Unsupported word size"
#endif

static const u8 gost_R3410_2012_512_paramSetA_a[] = {
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xfd, 0xc4,
};

TO_EC_STR_PARAM(gost_R3410_2012_512_paramSetA_a);

static const u8 gost_R3410_2012_512_paramSetA_b[] = {
	0xe8, 0xc2, 0x50, 0x5d, 0xed, 0xfc, 0x86, 0xdd,
	0xc1, 0xbd, 0x0b, 0x2b, 0x66, 0x67, 0xf1, 0xda,
	0x34, 0xb8, 0x25, 0x74, 0x76, 0x1c, 0xb0, 0xe8,
	0x79, 0xbd, 0x08, 0x1c, 0xfd, 0x0b, 0x62, 0x65,
	0xee, 0x3c, 0xb0, 0x90, 0xf3, 0x0d, 0x27, 0x61,
	0x4c, 0xb4, 0x57, 0x40, 0x10, 0xda, 0x90, 0xdd,
	0x86, 0x2e, 0xf9, 0xd4, 0xeb, 0xee, 0x47, 0x61,
	0x50, 0x31, 0x90, 0x78, 0x5a, 0x71, 0xc7, 0x60,
};

TO_EC_STR_PARAM(gost_R3410_2012_512_paramSetA_b);

#define CURVE_GOST_R3410_2012_512_PARAMSETA_CURVE_ORDER_BITLEN 512
static const u8 gost_R3410_2012_512_paramSetA_curve_order[] = {
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0x27, 0xe6, 0x95, 0x32, 0xf4, 0x8d, 0x89, 0x11,
	0x6f, 0xf2, 0x2b, 0x8d, 0x4e, 0x05, 0x60, 0x60,
	0x9b, 0x4b, 0x38, 0xab, 0xfa, 0xd2, 0xb8, 0x5d,
	0xca, 0xcd, 0xb1, 0x41, 0x1f, 0x10, 0xb2, 0x75,
};

TO_EC_STR_PARAM(gost_R3410_2012_512_paramSetA_curve_order);

static const u8 gost_R3410_2012_512_paramSetA_gx[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03,
};

TO_EC_STR_PARAM(gost_R3410_2012_512_paramSetA_gx);

static const u8 gost_R3410_2012_512_paramSetA_gy[] = {
	0x75, 0x03, 0xcf, 0xe8, 0x7a, 0x83, 0x6a, 0xe3,
	0xa6, 0x1b, 0x88, 0x16, 0xe2, 0x54, 0x50, 0xe6,
	0xce, 0x5e, 0x1c, 0x93, 0xac, 0xf1, 0xab, 0xc1,
	0x77, 0x80, 0x64, 0xfd, 0xcb, 0xef, 0xa9, 0x21,
	0xdf, 0x16, 0x26, 0xbe, 0x4f, 0xd0, 0x36, 0xe9,
	0x3d, 0x75, 0xe6, 0xa5, 0x0e, 0x3a, 0x41, 0xe9,
	0x80, 0x28, 0xfe, 0x5f, 0xc2, 0x35, 0xf5, 0xb8,
	0x89, 0xa5, 0x89, 0xcb, 0x52, 0x15, 0xf2, 0xa4,
};

TO_EC_STR_PARAM(gost_R3410_2012_512_paramSetA_gy);

static const u8 gost_R3410_2012_512_paramSetA_gz[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
};

TO_EC_STR_PARAM(gost_R3410_2012_512_paramSetA_gz);

static const u8 gost_R3410_2012_512_paramSetA_gen_order[] = {
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff,
	0x27, 0xe6, 0x95, 0x32, 0xf4, 0x8d, 0x89, 0x11,
	0x6f, 0xf2, 0x2b, 0x8d, 0x4e, 0x05, 0x60, 0x60,
	0x9b, 0x4b, 0x38, 0xab, 0xfa, 0xd2, 0xb8, 0x5d,
	0xca, 0xcd, 0xb1, 0x41, 0x1f, 0x10, 0xb2, 0x75,
};

TO_EC_STR_PARAM(gost_R3410_2012_512_paramSetA_gen_order);

#define CURVE_GOST_R3410_2012_512_PARAMSETA_Q_BITLEN 512
static const u8 gost_R3410_2012_512_paramSetA_gen_order_bitlen[] = {
	0x02, 0x00,
};

TO_EC_STR_PARAM(gost_R3410_2012_512_paramSetA_gen_order_bitlen);

static const u8 gost_R3410_2012_512_paramSetA_cofactor[] = {
	0x01,
};

TO_EC_STR_PARAM(gost_R3410_2012_512_paramSetA_cofactor);

static const u8 gost_R3410_2012_512_paramSetA_alpha_montgomery[] = {
	0x00,
};
TO_EC_STR_PARAM_FIXED_SIZE(gost_R3410_2012_512_paramSetA_alpha_montgomery, 0);

static const u8 gost_R3410_2012_512_paramSetA_gamma_montgomery[] = {
	0x00,
};
TO_EC_STR_PARAM_FIXED_SIZE(gost_R3410_2012_512_paramSetA_gamma_montgomery, 0);

static const u8 gost_R3410_2012_512_paramSetA_alpha_edwards[] = {
	0x00,
};
TO_EC_STR_PARAM_FIXED_SIZE(gost_R3410_2012_512_paramSetA_alpha_edwards, 0);

static const u8 gost_R3410_2012_512_paramSetA_name[] = "GOST_R3410_2012_512_PARAMSETA";
TO_EC_STR_PARAM(gost_R3410_2012_512_paramSetA_name);

static const u8 gost_R3410_2012_512_paramSetA_oid[] = "1.2.643.7.1.2.1.2.1";
TO_EC_STR_PARAM(gost_R3410_2012_512_paramSetA_oid);

static const ec_str_params gost_R3410_2012_512_paramSetA_str_params = {
	.p = &gost_R3410_2012_512_paramSetA_p_str_param,
	.p_bitlen = &gost_R3410_2012_512_paramSetA_p_bitlen_str_param,
	.r = &gost_R3410_2012_512_paramSetA_r_str_param,
	.r_square = &gost_R3410_2012_512_paramSetA_r_square_str_param,
	.mpinv = &gost_R3410_2012_512_paramSetA_mpinv_str_param,
	.p_shift = &gost_R3410_2012_512_paramSetA_p_shift_str_param,
	.p_normalized = &gost_R3410_2012_512_paramSetA_p_normalized_str_param,
	.p_reciprocal = &gost_R3410_2012_512_paramSetA_p_reciprocal_str_param,
	.a = &gost_R3410_2012_512_paramSetA_a_str_param,
	.b = &gost_R3410_2012_512_paramSetA_b_str_param,
	.curve_order = &gost_R3410_2012_512_paramSetA_curve_order_str_param,
	.gx = &gost_R3410_2012_512_paramSetA_gx_str_param,
	.gy = &gost_R3410_2012_512_paramSetA_gy_str_param,
	.gz = &gost_R3410_2012_512_paramSetA_gz_str_param,
	.gen_order = &gost_R3410_2012_512_paramSetA_gen_order_str_param,
	.gen_order_bitlen = &gost_R3410_2012_512_paramSetA_gen_order_bitlen_str_param,
	.cofactor = &gost_R3410_2012_512_paramSetA_cofactor_str_param,
	.alpha_montgomery = &gost_R3410_2012_512_paramSetA_alpha_montgomery_str_param,
	.gamma_montgomery = &gost_R3410_2012_512_paramSetA_gamma_montgomery_str_param,
	.alpha_edwards = &gost_R3410_2012_512_paramSetA_alpha_edwards_str_param,
	.oid = &gost_R3410_2012_512_paramSetA_oid_str_param,
	.name = &gost_R3410_2012_512_paramSetA_name_str_param,
};

/*
 * Compute max bit length of all curves for p and q
 */
#ifndef CURVES_MAX_P_BIT_LEN
#define CURVES_MAX_P_BIT_LEN    0
#endif
#if (CURVES_MAX_P_BIT_LEN < CURVE_GOST_R3410_2012_512_PARAMSETA_P_BITLEN)
#undef CURVES_MAX_P_BIT_LEN
#define CURVES_MAX_P_BIT_LEN CURVE_GOST_R3410_2012_512_PARAMSETA_P_BITLEN
#endif
#ifndef CURVES_MAX_Q_BIT_LEN
#define CURVES_MAX_Q_BIT_LEN    0
#endif
#if (CURVES_MAX_Q_BIT_LEN < CURVE_GOST_R3410_2012_512_PARAMSETA_Q_BITLEN)
#undef CURVES_MAX_Q_BIT_LEN
#define CURVES_MAX_Q_BIT_LEN CURVE_GOST_R3410_2012_512_PARAMSETA_Q_BITLEN
#endif
#ifndef CURVES_MAX_CURVE_ORDER_BIT_LEN
#define CURVES_MAX_CURVE_ORDER_BIT_LEN    0
#endif
#if (CURVES_MAX_CURVE_ORDER_BIT_LEN < CURVE_GOST_R3410_2012_512_PARAMSETA_CURVE_ORDER_BITLEN)
#undef CURVES_MAX_CURVE_ORDER_BIT_LEN
#define CURVES_MAX_CURVE_ORDER_BIT_LEN CURVE_GOST_R3410_2012_512_PARAMSETA_CURVE_ORDER_BITLEN
#endif

/*
 * Compute and adapt max name and oid length
 */
#ifndef MAX_CURVE_OID_LEN
#define MAX_CURVE_OID_LEN 0
#endif
#ifndef MAX_CURVE_NAME_LEN
#define MAX_CURVE_NAME_LEN 0
#endif
#if (MAX_CURVE_OID_LEN < 20)
#undef MAX_CURVE_OID_LEN
#define MAX_CURVE_OID_LEN 20
#endif
#if (MAX_CURVE_NAME_LEN < 50)
#undef MAX_CURVE_NAME_LEN
#define MAX_CURVE_NAME_LEN 50
#endif

#endif /* __EC_PARAMS_GOST_R3410_2012_512_PARAMSETA_H__ */

#endif /* WITH_CURVE_GOST_R3410_2012_512_PARAMSETA */
