.\" $Id: at.man,v 1.3 1994/06/16 16:49:46 kernel Exp $
.Dd April 12, 1995
.Dt "AT" 1
.Os "FreeBSD 2.1"
.Sh NAME
.Nm at, batch, atq, atrm
.Nd queue, examine or delete jobs for later execution
.Sh SYNOPSIS
.Nm at
.Op Fl V
.Op Fl q Ar queue
.Op Fl f Ar file
.Op Fl mldbv
.Ar time
.Pp
.Nm atq
.Op Fl V
.Op Fl q Ar queue
.Op Fl v
.Pp
.Nm atrm
.Op Fl V
.Ar job
.Op Ar job ...
.Pp
.Nm batch
.Op Fl V
.Op Fl q Ar queue
.Op Fl f Ar file
.Op Fl mv
.Op Ar time
.Sh DESCRIPTION
.Nm At
and
.Nm batch
read commands from standard input or a specified file which are to
be executed at a later time, using
.Xr sh 1 .
.Bl -tag -width indent
.It Nm at
executes commands at a specified time;
.It Nm atq
lists the user's pending jobs, unless the user is the superuser; in that
case, everybody's jobs are listed;
.It Nm atrm
deletes jobs;
.It Nm batch
executes commands when system load levels permit; in other words, when the load average
drops below _LOADAVG_MX, or the value specified in the invocation of
.Nm atrun .
.El
.Pp
.Nm At
allows some moderately complex
.Ar time
specifications.  It accepts times of the form
.Ar HHMM
or
.Ar HH:MM
to run a job at a specific time of day.
(If that time is already past, the next day is assumed.)
You may also specify
.Nm midnight ,
.Nm noon ,
or
.Nm teatime
(4pm)
and you can have a time-of-day suffixed with
.Nm AM
or
.Nm PM
for running in the morning or the evening.
You can also say what day the job will be run,
by giving a date in the form
.Ar \%month-name day
with an optional
.Ar year ,
or giving a date of the form
.Ar MMDDYY
or
.Ar MM/DD/YY
or
.Ar DD.MM.YY .
You can also give times like
.Op Nm now
.Nm + Ar count \%time-units ,
where the time-units can be
.Nm minutes ,
.Nm hours ,
.Nm days ,
or
.Nm weeks
and you can tell
.Nm at
to run the job today by suffixing the time with
.Nm today
and to run the job tomorrow by suffixing the time with
.Nm tomorrow.
.Pp
For example, to run a job at 4pm three days from now, you would do
.Nm at 4pm + 3 days ,
to run a job at 10:00am on July 31, you would do
.Nm at 10am Jul 31
and to run a job at 1am tomorrow, you would do
.Nm at 1am tomorrow.
.Pp
For both
.Nm at
and
.Nm batch ,
commands are read from standard input or the file specified
with the
.Fl f
option and executed.
The working directory, the environment (except for the variables
.Nm TERM ,
.Nm TERMCAP ,
.Nm DISPLAY
and
.Nm _ )
and the
.Ar umask
are retained from the time of invocation.
An
.Nm at
or
.Nm batch
command invoked from a 
.Xr su 1
shell will retain the current userid.
The user will be mailed standard error and standard output from his
commands, if any. Mail will be sent using the command
.Xr sendmail 8 .
If
.Nm at
is executed from a 
.Xr su 1
shell, the owner of the login shell will receive the mail.
.Pp
The superuser may use these commands in any case.
For other users, permission to use at is determined by the files
.Pa _PERM_PATH/at.allow
and
.Pa _PERM_PATH/at.deny .
.Pp
If the file
.Pa _PERM_PATH/at.allow
exists, only usernames mentioned in it are allowed to use
.Nm at .
.Pp
If
.Pa _PERM_PATH/at.allow
does not exist,
.Pa _PERM_PATH/at.deny
is checked, every username not mentioned in it is then allowed
to use
.Nm at .
.Pp
If neither exists, only the superuser is allowed use of
.Nm at .
.Pp
An empty 
.Pa _PERM_PATH/at.deny
means that every user is allowed use these commands, this is the
default configuration.
.Sh OPTIONS
.Bl -tag -width indent
.It Fl V
prints the version number to standard error.
.It Fl q Ar queue
uses the specified queue.
A queue designation consists of a single letter; valid queue designations
range from
.Nm a
to 
.Nm z .
and
.Nm A
to
.Nm Z .
The
.Nm _DEFAULT_AT_QUEUE
queue is the default for
.Nm at
and the
.Nm _DEFAULT_BATCH_QUEUE
queue for
.Nm batch .
Queues with higher letters run with increased niceness.
If a job is submitted to a queue designated with an uppercase letter, it
is treated as if it had been submitted to batch at that time.
If
.Nm atq
is given a specific queue, it will only show jobs pending in that queue.
.It Fl m
Send mail to the user when the job has completed even if there was no
output.
.It Fl f Ar file
Reads the job from
.Ar file
rather than standard input.
.It Fl l
Is an alias for
.Nm atq.
.It Fl d
Is an alias for
.Nm atrm.
.It Fl b
Is an alias for
.Nm batch.
.It Fl v
For
.Nm atq ,
shows completed but not yet deleted jobs in the queue; otherwise
shows the time the job will be executed.
.Sh FILES
.Bl -tag -width _ATJOB_DIR/_LOCKFILE -compact
.It Pa _ATJOB_DIR
Directory containing job files
.It Pa _ATSPOOL_DIR
Directory containing output spool files
.It Pa /var/run/utmp
Login records
.It Pa _PERM_PATH/at.allow
Allow permission control
.It Pa _PERM_PATH/at.deny
Deny permission control
.It Pa _ATJOB_DIR/_LOCKFILE
Job-creation lock file.
.Sh SEE ALSO
.Xr cron 8 ,
.Xr nice 1 ,
.Xr umask 2 ,
.Xr sh 1 ,
.Xr sendmail 8 ,
.Xr atrun 8 .
.El
.Sh BUGS
.Pp
If the file
.Pa /var/run/utmp
is not available or corrupted, or if the user is not logged on at the
time 
.Nm at
is invoked, the mail is sent to the userid found
in the environment variable
.Nm LOGNAME .
If that is undefined or empty, the current userid is assumed.
.Pp
.Nm At
and
.Nm batch
as presently implemented are not suitable when users are competing for
resources.
If this is the case for your site, you might want to consider another
batch system, such as
.Nm nqs .
.Sh AUTHOR
At was mostly written by Thomas Koenig, ig25@rz.uni-karlsruhe.de.
The time parsing routines are by David Parsons, orc@pell.chi.il.us.
