#include <rpc/rpc.h>
#include "rstat.h"

/* Default timeout can be changed using clnt_control() */
static struct timeval TIMEOUT = { 25, 0 };

statstime *
rstatproc_stats_3(argp, clnt)
	void *argp;
	CLIENT *clnt;
{
	static statstime res;

	bzero((char *)&res, sizeof(res));
	if (clnt_call(clnt, RSTATPROC_STATS, xdr_void, argp, xdr_statstime, &res, TIMEOUT) != RPC_SUCCESS) {
		return (NULL);
	}
	return (&res);
}


u_int *
rstatproc_havedisk_3(argp, clnt)
	void *argp;
	CLIENT *clnt;
{
	static u_int res;

	bzero((char *)&res, sizeof(res));
	if (clnt_call(clnt, RSTATPROC_HAVEDISK, xdr_void, argp, xdr_u_int, &res, TIMEOUT) != RPC_SUCCESS) {
		return (NULL);
	}
	return (&res);
}


statsswtch *
rstatproc_stats_2(argp, clnt)
	void *argp;
	CLIENT *clnt;
{
	static statsswtch res;

	bzero((char *)&res, sizeof(res));
	if (clnt_call(clnt, RSTATPROC_STATS, xdr_void, argp, xdr_statsswtch, &res, TIMEOUT) != RPC_SUCCESS) {
		return (NULL);
	}
	return (&res);
}


u_int *
rstatproc_havedisk_2(argp, clnt)
	void *argp;
	CLIENT *clnt;
{
	static u_int res;

	bzero((char *)&res, sizeof(res));
	if (clnt_call(clnt, RSTATPROC_HAVEDISK, xdr_void, argp, xdr_u_int, &res, TIMEOUT) != RPC_SUCCESS) {
		return (NULL);
	}
	return (&res);
}


stats *
rstatproc_stats_1(argp, clnt)
	void *argp;
	CLIENT *clnt;
{
	static stats res;

	bzero((char *)&res, sizeof(res));
	if (clnt_call(clnt, RSTATPROC_STATS, xdr_void, argp, xdr_stats, &res, TIMEOUT) != RPC_SUCCESS) {
		return (NULL);
	}
	return (&res);
}


u_int *
rstatproc_havedisk_1(argp, clnt)
	void *argp;
	CLIENT *clnt;
{
	static u_int res;

	bzero((char *)&res, sizeof(res));
	if (clnt_call(clnt, RSTATPROC_HAVEDISK, xdr_void, argp, xdr_u_int, &res, TIMEOUT) != RPC_SUCCESS) {
		return (NULL);
	}
	return (&res);
}

