/*
 * Copyright 1992 by Kevin E. Martin, Chapel Hill, North Carolina.
 *
 * Permission to use, copy, modify, distribute, and sell this software and its
 * documentation for any purpose is hereby granted without fee, provided that
 * the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Kevin E. Martin not be used in
 * advertising or publicity pertaining to distribution of the software without
 * specific, written prior permission.  Kevin E. Martin makes no
 * representations about the suitability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.
 *
 * KEVIN E. MARTIN DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
 * EVENT SHALL KEVIN E. MARTIN BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *
 */
#ifndef IBM8514_H
#define IBM8514_H
#ifndef __Proto
# ifdef __STDC__
#  define __Proto(x) x
# else
#  define __Proto(x) ()
# endif
#endif

#include "X.h"
#include "misc.h"
#include "x386.h"
#include "regionstr.h"
#include "colormapst.h"
#include "windowstr.h"
#include "scrnintstr.h"
#include "fontstruct.h"
#include "dixfontstr.h"


typedef struct _CacheInfo {
    int id;
    int x;
    int y;
    int w;
    int h;
    int nx;
    int ny;
    int pix_w;
    int pix_h;
    unsigned int lru;
} CacheInfo, *CacheInfoPtr;


extern Bool ibm8514ScreenInit __Proto((ScreenPtr, pointer, int, int, int, int,
				       int));
extern Bool ibm8514Probe __Proto((void));
extern Bool ibm8514Initialize __Proto((int, ScreenPtr, int, char **));
extern void ibm8514EnterLeaveVT __Proto((Bool));

extern Bool ibm8514SaveScreen __Proto((ScreenPtr, Bool));
extern Bool ibm8514CloseScreen __Proto((void));

extern int ibm8514ListInstalledColormaps __Proto((ScreenPtr, Colormap *));
extern void ibm8514StoreColors __Proto((ColormapPtr, int, xColorItem *));
extern void ibm8514InstallColormap __Proto((ColormapPtr));
extern void ibm8514UninstallColormap __Proto((ColormapPtr));
extern void ibm8514RestoreColor0 __Proto((ScreenPtr));

extern Bool ibm8514RealizeFont __Proto((ScreenPtr, FontPtr));
extern Bool ibm8514UnrealizeFont __Proto((ScreenPtr, FontPtr));

extern void ibm8514ImageInit __Proto((void));
extern void ibm8514ImageRead __Proto((int, int, int, int, unsigned char *,
				     int, int, int));
extern void ibm8514ImageWrite __Proto((int, int, int, int, unsigned char *,
				     int, int, int, short, short));
extern void ibm8514ImageFill __Proto((int, int, int, int, unsigned char *,
									  int, int, int, int, int, short, short));
extern void ibm8514ImageStipple __Proto((int, int, int, int, unsigned char *,
					 int, int, int, int, int, int,
					 short, short));
extern void ibm8514ImageOpStipple __Proto((int, int, int, int, unsigned char *,
					   int, int, int, int, int, int, int,
					   short, short));

extern void ibm8514CacheInit __Proto((int, int));
extern void ibm8514CacheFreeSlot __Proto((PixmapPtr));
extern int  DoCachePixmap __Proto((PixmapPtr, void (*)() ));
extern void DoCacheTile __Proto((PixmapPtr, int));
extern void DoCacheOpStipple __Proto((PixmapPtr, int));
extern void DoCacheExpandPixmap __Proto((CacheInfo *));
extern void DoCacheImageFill __Proto((int, int, int, int, int, int, int,
				      short, short, short, short, short));
extern void ibm8514FontCache8Init __Proto((int, int));
extern void ibm8514ImageInit __Proto((void));

extern int ibm8514CacheTile __Proto((PixmapPtr));
extern int ibm8514CacheStipple __Proto((PixmapPtr));
extern int ibm8514CacheOpStipple __Proto((PixmapPtr));
extern void ibm8514CImageFill __Proto((int, int, int, int, int, int, int,
				       short, short));
extern void ibm8514CImageStipple __Proto((int, int, int, int, int, int, int,
					  int, short, short));
extern void ibm8514CImageOpStipple __Proto((int, int, int, int, int, int, int,
					    int, int, short, short));
extern void ibm8514CacheFreeSlot __Proto((PixmapPtr));


extern int ibm8514CacheFont8 __Proto((FontPtr));
extern void ibm8514UnCacheFont8 __Proto((FontPtr));
extern int ibm8514IsCached __Proto((FontPtr));
extern int ibm8514CPolyText8 __Proto((DrawablePtr, GCPtr, int, int, int,
				      unsigned char *, int));
extern void ibm8514CImageText8 __Proto((DrawablePtr, GCPtr, int, int, int,
					char *, int));
					
extern void ibm8514PolyPoint __Proto((DrawablePtr, GCPtr, int, int, xPoint *));
extern void ibm8514Line __Proto((DrawablePtr, GCPtr, int, int, DDXPointPtr));
extern void ibm8514Segment __Proto((DrawablePtr, GCPtr, int, xSegment *));

extern void ibm8514SetSpans __Proto((DrawablePtr, GCPtr, unsigned char *,
				     DDXPointPtr, int *, int, int));
extern void ibm8514GetSpans __Proto((DrawablePtr, int, DDXPointPtr, int *,
				     int, unsigned long *));

extern void ibm8514SolidFSpans __Proto((DrawablePtr, GCPtr, int, DDXPointPtr,
					int *, int));
extern void ibm8514TiledFSpans __Proto((DrawablePtr, GCPtr, int, DDXPointPtr,
					int *, int));
extern void ibm8514StipFSpans __Proto((DrawablePtr, GCPtr, int, DDXPointPtr,
					int *, int));
extern void ibm8514OStipFSpans __Proto((DrawablePtr, GCPtr, int, DDXPointPtr,
					int *, int));

extern void ibm8514PolyFillRect __Proto((DrawablePtr, GCPtr,
					 int, xRectangle *));

extern int ibm8514PolyText8 __Proto((DrawablePtr, GCPtr, int, int, int,
									 char *));
extern int ibm8514PolyText16 __Proto((DrawablePtr, GCPtr, int, int, int,
									  unsigned short *));
extern void ibm8514ImageText8 __Proto((DrawablePtr, GCPtr, int, int, int,
									   char *));
extern void ibm8514ImageText16 __Proto((DrawablePtr, GCPtr, int, int, int,
										unsigned short *));

extern void ibm8514FindOrdering __Proto((DrawablePtr, DrawablePtr, GCPtr, int,
					 BoxPtr, int, int, int, int,
					 unsigned int *ordering));
extern RegionPtr ibm8514CopyArea __Proto((DrawablePtr, DrawablePtr, GCPtr,
					   int, int, int,int, int, int));
extern void ibm8514CopyWindow __Proto((WindowPtr, DDXPointRec, RegionPtr));

extern void ibm8514SaveAreas __Proto((PixmapPtr, RegionPtr, int, int));
extern void ibm8514RestoreAreas __Proto((PixmapPtr, RegionPtr, int, int));

extern Bool ibm8514CreateGC __Proto((GCPtr));

extern ScrnInfoRec vga256InfoRec;

extern short ibm8514alu[];
#endif
