static char SCCSID[] = "@(#)tiledrects.c	1.2 89/02/22";
/*
 * Copyright 1989 Siemens
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that the above copyright notice appear in all copies and that both that
 * copyright notice and this permission notice appear in supporting
 * documentation, and that the name of Siemens not be used in advertising or
 * publicity pertaining to distribution of the software without specific,
 * written prior permission.  Siemens makes no representations about the
 * suitability of this software for any purpose.  It is provided "as is"
 * without express or implied warranty.
 *
 * Author:  Claus Gittinger, Siemens Munich, unido!sinix!claus@uunet.uu.net
 */

#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>

#include "externals.h"
#include "tile1.bit"
#include "tile2.bit"

static GC myGC1, myGC2;
static Pixmap tile1, tile2;
static XRectangle *rectangles;
#define NRECT   64

/*
 * tiled rectangles
 *
 * backgrounds, draw programs
 */
tiledrects_setup(dpy, win, len)
Display *dpy;
Window win;
{
	int screen = DefaultScreen(dpy);
	int depth;
	int i;
	XRectangle *rp;

	depth = DefaultDepth(dpy, screen);
	myGC1 = XCreateGC(dpy, win, 0L, NULL);
	if (! myGC1) return 1;
	myGC2 = XCreateGC(dpy, win, 0L, NULL);
	if (! myGC2) return 1;
	XSetForeground(dpy, myGC1, WhitePixel(dpy, screen));
	XSetBackground(dpy, myGC1, BlackPixel(dpy, screen));
	XSetForeground(dpy, myGC2, WhitePixel(dpy, screen));
	XSetBackground(dpy, myGC2, BlackPixel(dpy, screen));

	tile1 = XCreatePixmapFromBitmapData(dpy, win,
						tile1_bits,
						tile1_width,
						tile1_height,
						WhitePixel(dpy, screen),
						BlackPixel(dpy, screen),
						depth);
	if (!tile1) return 1;

	XSetTile(dpy, myGC1, tile1);
	XSetFillStyle(dpy, myGC1, FillTiled);

	tile2 = XCreatePixmapFromBitmapData(dpy, win,
						tile2_bits,
						tile2_width,
						tile2_height,
						WhitePixel(dpy, screen),
						BlackPixel(dpy, screen),
						depth);
	if (!tile2) return 1;

	XSetTile(dpy, myGC2, tile2);
	XSetFillStyle(dpy, myGC2, FillTiled);

	rectangles = (XRectangle *)malloc(sizeof(XRectangle) * NRECT);
	if (rectangles == (XRectangle *)0)
	    return 1;

	rp = rectangles;
	for (i=0; i<NRECT; i++) {
	    rp->x = i; rp->y = i;
	    rp->width = len; rp->height = len;
	    rp++;
	}
	return 0;
}

tiledrects_cleanup(dpy, win, dummy)
Display *dpy;
Window win;
{
	XFreeGC(dpy, myGC1);
	XFreePixmap(dpy, tile1);
	XFreeGC(dpy, myGC2);
	XFreePixmap(dpy, tile2);
	free(rectangles);
}

tiledrects_bench(dpy, win, len)
Display *dpy;
Window win;
{
	int nrects;

	nrects = 0;
	while (benchRunning) {
	    XFillRectangles(dpy, win, myGC1, rectangles, NRECT);
	    XFillRectangles(dpy, win, myGC2, rectangles, NRECT);
	    if (sync) XSync(dpy, 0);
	    nrects += NRECT*2;
	}
	return nrects;
}

tiledrects_msg(deltaT, nrects, len, rate)
double rate;
{
	printf("TILE-FILLED RECTANGLES\n");
	printf("\n");
	printf("%d rectangles with %d pixel sides in %d secs\n",
				nrects, len, deltaT);
	printf("rate = %8.2f rectangles/sec (%d Pixels/sec)\n",
				rate, (nrects*len*len)/deltaT);
}
