/* cmd.h */

#ifndef _cmd_h_
#define _cmd_h_

/* Verbosity levels. */
#define V_QUIET		-1
#define V_ERRS		0
#define V_TERSE		1
#define V_VERBOSE	2
#define V_IMPLICITCD 4
#define IS_VQUIET	(verbose <= V_QUIET)
#define IS_VERRS	(verbose == V_ERRS)
#define IS_VTERSE	(verbose == V_TERSE)
#define IS_VVERBOSE	(verbose == V_VERBOSE)
#define NOT_VQUIET	(verbose > V_QUIET)

/* Open modes. */
#define OPEN_A 1
#define OPEN_U 0

/* For 'Getopt.' */
#define BADCH   (int)'?'
#define EMSG    ""

/* For 'set.' */
#define INT 1
#define LONG 2
#define STR 3
typedef void (*setvarproc)(char *, int);
struct var {
	char			*name;
	short			type;
	short			conn_required;
	void			*var;
	setvarproc		proc;
};

#define LS_FLAGS_AND_FILE '\1'

/*
 * Format of command table.
 */
struct cmd {
	char	*c_name;	/* name of command */
	char	*c_help;	/* help string */
	char	c_bell;		/* give bell when command completes */
	char	c_conn;		/* must be connected to use command */
	char	c_proxy;	/* proxy server may execute */
	char	c_hidden;	/* a hidden command or alias (won't show up in help) */
	int		(*c_handler)(int, char **);	/* function to call */
};

struct macel {
	char mac_name[9];	/* macro name */
	char *mac_start;	/* start of macro in macbuf */
	char *mac_end;		/* end of macro in macbuf */
};

struct types {
	char	*t_name;
	char	*t_mode;
	int		t_type;
	char	*t_arg;
};

#ifdef REDIR
struct lslist {
	char			*string;
	struct lslist	*next;
};
#endif

/* cmds.c */
char **re_makeargv(char *promptstr, int *argc);
int setpeer(int argc, char **argv);
int settype(int argc, char **argv);
void _settype(char *typename);
int setbinary(int argc, char **argv);
int setascii(int argc, char **argv);
void set_prompt(char *new, int unset);
void set_log(char *fname, int unset);
void set_ldir(char *ldir, int unset);
void set_pager(char *new, int unset);
void set_verbose(char *new, int unset);
void set_type(char *newtype, int unset);
int set(int argc, char **argv);
int put(int argc, char **argv);
int mput(int argc, char **argv);
int rem_glob_one(char *pattern);
int get(int argc, char **argv);
void mabort(int unused);
int mget(int argc, char **argv);
char *remglob(char *argv[]);
char *onoff(int);
int StrToBool(char *s);
int setverbose(int argc, char **argv);
int setprompt(int argc, char **argv);
int setdebug(int argc, char **argv);
void fix_options(void);
int cd(int argc, char **argv);
int implicit_cd(char *dir);
int _cd(char *dir);
int lcd(int argc, char **argv);
int do_delete(int argc, char **argv);
int mdelete(int argc, char **argv);
int renamefile(int argc, char **argv);
int ls(int argc, char **argv);
int mls(int argc, char **argv);
int shell(int argc, char **argv);
int do_user(int argc, char **argv);
int pwd(int argc, char **argv);
int makedir(int argc, char **argv);
int removedir(int argc, char **argv);
int quote(int argc, char **argv);
int rmthelp(int argc, char **argv);
int quit(int argc, char **argv);
void close_streams(int wantShutDown);
int disconnect(int argc, char **argv);
int confirm(char *cmd, char *file);
void fatal(char *msg);
void close_up_shop(void);
int globulize(char **cpp);
int cdup(int argc, char **argv);
int syst(int argc, char **argv);
int make_macro(char *name, FILE *fp);
int macdef(int argc, char **argv);
int domacro(int argc, char **argv);
int sizecmd(int argc, char **argv);
int modtime(int argc, char **argv);
int lookup(int argc, char **argv);
int rmtstatus(int argc, char **argv);
int create(int argc, char **argv);
char *get_cwd(char *buf, int size);
int tmp_name(char *str);
int getlocalhostname(char *host, size_t size);
int show_version(int argc, char **argv);
void Perror(char *s);
#ifdef REDIR
int showlsbuffer(int argc, char **argv);
#endif
int Getopt(int argc, char **argv, char *opstring);
void Getopt_Reset(void);
char *Gets(char *line, size_t size);
#ifdef TERM
int toggle_compress();
#endif

#endif	/* _cmd_h_ */
