
/*
 *
 * $Log: setup.c,v $
 * Revision 1.6  1993/07/01  14:15:45  wade
 * minor clean compilation stuff
 *
 * Revision 1.5  1993/02/22  16:04:47  wade
 * added finger demo support
 *
 * Revision 1.4  1992/12/17  21:42:00  wade
 * removed clearing of download list on restart
 *
 * Revision 1.3  1992/12/15  21:06:05  wade
 * using text instead of bitmaps for contextual help
 *
 * Revision 1.2  1992/12/05  16:59:50  larose
 * added logging.
 *
 *
 */

#include "xnl.h"

#include <X11/Xaw/SmeLine.h>

Widget prettyIconsParent;
Widget *prettyIcons;

static Widget updatedownloadButton, hostListWidget, bulletMenu,
		keywordServerLabel, whoServerLabel, saveButton,
		newEntryDialog;

void acceptNewEntry();

static Boolean gettingIndexFiles = False;
static int currentItem = -1;

static unsigned long elapsedTime;

static void hostListCB(), menuCB(), newEntryCB(), saveChangesCB();

static void
updateDownload(w, call_data, client_data)
Widget w;
XtPointer call_data, client_data;
{
    Arg args[3];
    char filename[MAXLINE], line[MAXLINE];
	register int i, j, howMany, numBroke;

	if (gettingIndexFiles) { /* they want to cancel */
		gettingIndexFiles = False;
		return;
	}

	numBroke = 0;
	elapsedTime = what_time();

	howMany = 0; while (FileList[howMany]) 	howMany++;
	i = 0; while (mainclassFileList[i]) 	i++;
	howMany += i;

	gettingIndexFiles = True;

	i = 0;
	while (FileList[i]) {

      sprintf(filename, "%s/%s", XNL_PATH, FileList[i]);

	  sprintf(line, "%s (%d of %d), press to cancel\n", FileList[i], i+1, howMany);
	  XtSetArg(args[0], XtNlabel, line);
	  XtSetValues(w, args, 1);

	  soak_events(); /* process X events */

	  if (gettingIndexFiles == False) { /* somebody just hit cancel */
		XtSetArg(args[0], XtNlabel, "Press to Check Each Index File");
		XtSetValues(w, args, 1);
		return;
	  }

      if (!confirmFile(filename, (PUBDATA) ? 1 : 0, False, False)) {
        printf("couldn't get  %s\n", FileList[i]);
		numBroke++;
      }
	  i++;
	}

	j=i;

    i = 0;
    while (mainclassFileList[i]) {

      sprintf(filename, "%s/%s", XNL_PATH, mainclassFileList[i]);

	  sprintf(line, "%s (%d of %d), press to cancel\n", mainclassFileList[i], i+1+j, howMany);
	  XtSetArg(args[0], XtNlabel, line);
	  XtSetValues(w, args, 1);

	  soak_events(); /* process X events */

	  if (gettingIndexFiles == False) { /* somebody just hit cancel */
		XtSetArg(args[0], XtNlabel, "Press to Check Each Index File");
		XtSetValues(w, args, 1);
		return;
	  }

      if (!confirmFile(filename, (PUBDATA) ? 1 : 0, False, False)) {
        printf("couldn't get  %s\n", mainclassFileList[i]);
		numBroke++;
      }
      i++;
    }

	elapsedTime = what_time() - elapsedTime;

/*
	printf("time for all indexfiles %d, %d per\n", elapsedTime,
		elapsedTime/(i+j));
*/


	/* all done */
	gettingIndexFiles = False;
	XtSetArg(args[0], XtNlabel, "Press to Check Each Index File");
	XtSetValues(w, args, 1);

	if (numBroke)
		sprintf(line, "got all index files but %d", numBroke);
	else
		strcpy(line, "got all index files");
	set_status(line, GREEN);
}




void updateCB(w, call_data, client_data)
Widget w;
XtPointer call_data, client_data;
{
        Mode_desired = MODE_UPDATE;
}

Popup_update(w)
Widget w;
{
    Arg args[5];
    Dimension formHeight;

    grey_the_button(updateButton, False);

    XtManageChild(updateForm);

    XtSetArg(args[0], XtNheight, &formHeight); 
    XtGetValues(updateForm, args, 1);

    set_status(UPDATE_HEADER, GREEN);
	return 1;
}

make_update(w)
Widget w;
{
	Widget last, entry;
    Arg args[20];
    register int n;
    static char text_translations[] = 
		"<BtnDown>: Set() Notify() XawPositionSimpleMenu(bulletMenu) \
           MenuPopup(bulletMenu) ";
    XtTranslations translations;

	con_help[MODE_UPDATE] = "\n\
At present, 2 main functions may be performed while\n\
in Set Up mode.\n\
\n\
Clicking 'Press to Check Each Index File' causes\n\
every index file (library description file) to be downloaded\n\
from the server. Files you already have will be checked\n\
to be sure they are up to date.\n\
\n\
The collection of machine pictures are decoration, they\n\
don't do anything useful.\n\
\n\
Under the pictures is a table of servers, there may only\n\
be one listed now. To add a new server, click on the\n\
'New Entry' button.\n\
\n\
Clicking on a server in the table pops up a menu of actions.\n\
on, turns on the server so that its libraries will appear in\n\
the main menu. An asterisk (*) appears next to servers that\n\
are 'on'.\n\
off, turns off the server.\n\
move to top, brings the entry to the top of the list making\n\
it the primary server. In the case of duplicate libraries\n\
offer by different servers, the server highest in the list is\n\
consulted first.\n\
keyword server causes keyword requests to be directed to\n\
this server.\n\
who server causes who requests to be directed to this server.\n\
remove this entry forever, deletes the server entry.\n\
\n\
Commit and Save Changes, causes the changes you make to\n\
actually take effect. The altered host list is saved to disk.\n";


    n = 0;
    XtSetArg(args[n], XtNwidth, XNL_WIDTH); n++;
    XtSetArg(args[n], XtNheight, XNL_HEIGHT); n++;
    XtSetArg(args[n], XtNborderWidth, 0); n++;
    updateForm = XtCreateManagedWidget("setupForm", formWidgetClass, 
        topPane, args, n);

#define FIX \
    XtSetArg(args[n], XtNbottom, XtChainTop); n++; \
    XtSetArg(args[n], XtNtop, XtChainTop); n++;    \
    XtSetArg(args[n], XtNleft, XtChainLeft); n++;  \
    XtSetArg(args[n], XtNright, XtChainLeft); n++;

    n = 0;
    XtSetArg(args[n], XtNvertDistance, 10); n++; 
    XtSetArg(args[n], XtNwidth, XNL_WIDTH -10); n++;
    XtSetArg(args[n], XtNlabel, "Press to Check Each Index File"); n++;
    FIX
    last = updatedownloadButton = XtCreateManagedWidget("setupCheck", 
            commandWidgetClass, updateForm, args, n);
    setfasthelpmessage( updatedownloadButton, "update every index file");
    XtAddCallback(updatedownloadButton, XtNcallback, updateDownload, 
        (XtPointer)NULL);

    n = 0;
    XtSetArg(args[n], XtNresizable, True); n++;
    XtSetArg(args[n], XtNfromVert, last); n++;
    XtSetArg(args[n], XtNvertDistance, 20); n++;
    XtSetArg(args[n], XtNborderWidth, 0); n++;
    XtSetArg(args[n], XtNheight, 40); n++;
    XtSetArg(args[n], XtNorientation, "horizontal"); n++;
    FIX
    last = XtCreateManagedWidget("prettyPicBox",
            boxWidgetClass, updateForm, args, n);

	make_siteIcons(last);


    translations = XtParseTranslationTable(text_translations);
    n = 0;
    XtSetArg(args[n], XtNvertDistance, 10); n++;
    XtSetArg(args[n], XtNfromVert, last); n++;
    FIX
    XtSetArg(args[n], XtNtranslations, translations); n++;
	XtSetArg(args[n], XtNlist, HostList); n++;
	XtSetArg(args[n], XtNresizable, True); n++;
	XtSetArg(args[n], XtNwidth, XNL_WIDTH -10); n++;
	XtSetArg(args[n], XtNdefaultColumns, 4); n++; 
	XtSetArg(args[n], XtNforceColumns, False); n++;
    last = hostListWidget = XtCreateManagedWidget("setupHostList", 
            listWidgetClass, updateForm, args, n);
	XtAddCallback(hostListWidget, XtNcallback, hostListCB, (XtPointer)NULL);

	/* now make the bullet menu */
	bulletMenu = XtCreatePopupShell("bulletMenu",
        simpleMenuWidgetClass, hostListWidget, NULL, 0);

	entry = XtCreateManagedWidget("on", smeBSBObjectClass,
		bulletMenu, NULL, 0);
	XtAddCallback(entry, XtNcallback, menuCB, (XtPointer)1);
	entry = XtCreateManagedWidget("off", smeBSBObjectClass,
		bulletMenu, NULL, 0);
	XtAddCallback(entry, XtNcallback, menuCB, (XtPointer)2);
	entry = XtCreateManagedWidget("move to top", smeBSBObjectClass,
		bulletMenu, NULL, 0);
	XtAddCallback(entry, XtNcallback, menuCB, (XtPointer)3);

	XtCreateManagedWidget("line", smeLineObjectClass, bulletMenu, NULL, 0);

	entry = XtCreateManagedWidget("keyword server", smeBSBObjectClass,
		bulletMenu, NULL, 0);
	XtAddCallback(entry, XtNcallback, menuCB, (XtPointer)4);
	entry = XtCreateManagedWidget("who server", smeBSBObjectClass,
		bulletMenu, NULL, 0);
	XtAddCallback(entry, XtNcallback, menuCB, (XtPointer)5);

	XtCreateManagedWidget("line", smeLineObjectClass, bulletMenu, NULL, 0);

	entry = XtCreateManagedWidget("remove entry forever", smeBSBObjectClass,
		bulletMenu, NULL, 0);
	XtAddCallback(entry, XtNcallback, menuCB, (XtPointer)6);

	/* make the 'new entry' and 'save' buttons */
    n = 0;
    XtSetArg(args[n], XtNfromVert, last); n++;
    FIX
    XtSetArg(args[n], XtNlabel, "New Server Entry"); n++;
    entry = XtCreateManagedWidget("setupNewEntry",
            commandWidgetClass, updateForm, args, n);
	XtAddCallback(entry, XtNcallback, newEntryCB, (XtPointer)NULL);
	setfasthelpmessage( entry, "add a new server to the list");
    n = 0;
    XtSetArg(args[n], XtNfromHoriz, entry); n++;
    XtSetArg(args[n], XtNfromVert, last); n++;
    FIX
    XtSetArg(args[n], XtNsensitive, False); n++;
    XtSetArg(args[n], XtNlabel, "Commit and Save Changes"); n++;
    last = saveButton = XtCreateManagedWidget("setupSave",
            commandWidgetClass, updateForm, args, n);
    XtAddCallback(saveButton, XtNcallback, saveChangesCB, (XtPointer)NULL);
	setfasthelpmessage( saveButton, "allow changes to take effect");


	/* make the keyword and whois server labels */
	n = 0;
    XtSetArg(args[n], XtNfromVert, last); n++;
    FIX
    XtSetArg(args[n], XtNborderWidth, 0); n++;
	XtSetArg(args[n], XtNlabel, "keyword server:"); n++;
	keywordServerLabel = XtCreateManagedWidget("setupKeyServLabel",
            labelWidgetClass, updateForm, args, n);
	n = 0;
    XtSetArg(args[n], XtNfromVert, last); n++;
    FIX
    XtSetArg(args[n], XtNborderWidth, 0); n++;
    XtSetArg(args[n], XtNresizable, True); n++;
	XtSetArg(args[n], XtNlabel, KeywordServer); n++;
    XtSetArg(args[n], XtNfromHoriz, keywordServerLabel); n++;
	last = keywordServerLabel = XtCreateManagedWidget("setupKeyServ",
            labelWidgetClass, updateForm, args, n);

	n = 0;
    XtSetArg(args[n], XtNfromVert, last); n++;
    FIX
    XtSetArg(args[n], XtNborderWidth, 0); n++;
	XtSetArg(args[n], XtNlabel, "    who server:"); n++;
	whoServerLabel = XtCreateManagedWidget("setupWhoServLabel",
            labelWidgetClass, updateForm, args, n);
	n = 0;
    XtSetArg(args[n], XtNfromVert, last); n++;
    XtSetArg(args[n], XtNresizable, True); n++;
    XtSetArg(args[n], XtNfromHoriz, whoServerLabel); n++;
    FIX
    XtSetArg(args[n], XtNborderWidth, 0); n++;
	XtSetArg(args[n], XtNlabel, WhoisServer); n++;
	last = whoServerLabel = XtCreateManagedWidget("setupWhoServ",
            labelWidgetClass, updateForm, args, n);

    return 1;
}

Popdown_update(w)
Widget w;
{
    grey_the_button(updateButton, True);

    XtUnmanageChild(updateForm);

    return 1;
}


loadHostFile()
{
	FILE *fp;
	int numHosts;
	char line[MAXLINE];

	numHosts = 0;

	KeywordServer[0] = '\0';
	WhoisServer[0] = '\0';

    if ((FINGER_DEMO == False) && (fp = fopen(HOST_FILE, "r"))) {
		while (fgets(line, MAXLINE, fp)) {
			line[ strlen(line) -1 ] = '\0'; /* eat \n */
			if (line[0] == 'k') {
				strcpy(KeywordServer, line +1);
			} else if (line[0] == 'w') {
				strcpy(WhoisServer, line +1);
			} else {
				HostList[numHosts] = XtNewString(line);
				numHosts++;
			}
		}
		fclose(fp);
		HostList[numHosts] = NULL;
	} else {
		numHosts = 3;
		HostList[0] = XtNewString(SURFER_ADDR);
		HostList[1] = XtNewString(" netlib.brl.mil");
		if (FINGER_DEMO)
		  HostList[2] = XtNewString("*softlib.cs.rice.edu");
		else
		  HostList[2] = XtNewString(" softlib.cs.rice.edu");
		HostList[3] = NULL;
		strcpy(KeywordServer, "netlib.cs.utk.edu");
		strcpy(WhoisServer, "netlib.cs.utk.edu");
	}

	/* if they aren't indicated in the host list use the primary server */
	if (!KeywordServer[0])
		strcpy(KeywordServer, HostList[0] +1);
	if (!WhoisServer[0])
		strcpy(WhoisServer, HostList[0] +1);
}

saveHostFile()
{
    FILE *fp;
	int i;

    fp = fopen(HOST_FILE, "w");
    if (fp) {
		fprintf(fp,"k%s\nw%s\n", KeywordServer, WhoisServer);
		i = 0; while (HostList[i]) {
			fprintf(fp,"%s\n", HostList[i]);
			i++;
		}
		fclose(fp);
	} else {
		printf("couldn't write host file <%s>\n", HOST_FILE);
	}
}

dumpHostfile()
{
    int i;

        printf("k%s\nw%s\n", KeywordServer, WhoisServer);
        i = 0; while (HostList[i]) {
            printf("%s\n", HostList[i]);
            i++;
        }
}



static void
hostListCB(w, closure, call_data)
Widget w;
XtPointer closure, call_data;
{
    XawListReturnStruct *item = (XawListReturnStruct*)call_data;

	currentItem = item->list_index;
}


static void
menuCB(w, closure, call_data)
Widget w;
XtPointer closure, call_data;
{
	char buf[MAXLINE];
	String tmp;
	register int i;
	Arg args[3];
/*
printf("menuCB: %d\n", (int)closure);
*/
	if (currentItem == -1) /* nonthing */
		return;

	XtSetArg(args[0], XtNwidth, XNL_WIDTH -10);

	grey_the_button(saveButton, True); /* turn the 'save' button on */

	switch ((int)closure) {
	case 1: /* on */
/*
printf("turn on %s\n", HostList[currentItem]);
*/
	  strcpy(buf, "*");
	  strcat(buf, HostList[currentItem] +1);
	  strcpy(HostList[currentItem], buf); 
	  XawListChange(hostListWidget, HostList, 0,0, True);
	  XtSetValues(hostListWidget, args, 1);
	  break;
	case 2: /* off */
/*
printf("turn off %s\n", HostList[currentItem]);
*/
	  strcpy(buf, " ");
	  strcat(buf, HostList[currentItem] +1);
	  strcpy(HostList[currentItem], buf); 
	  XawListChange(hostListWidget, HostList, 0,0, True);
	  XtSetValues(hostListWidget, args, 1);
	  break;
	case 3: /* go to top */
/*
printf("move to top %s\n", HostList[currentItem]);
*/
	  tmp = HostList[currentItem];
	  for (i=currentItem; i; i--)
		HostList[i] = HostList[i -1];
	  HostList[0] = tmp;
	  XawListChange(hostListWidget, HostList, 0,0, True);
	  XtSetValues(hostListWidget, args, 1);
	  break;
	case 4: /* keyword */
/*
printf("make keyword server %s\n", HostList[currentItem]);
*/
      strcpy(KeywordServer, HostList[currentItem] +1);
	  set_label(keywordServerLabel, KeywordServer);
	  break;
	case 5: /* whois server */
/*
printf("make whois server %s\n", HostList[currentItem]);
*/
      strcpy(WhoisServer, HostList[currentItem] +1);
	  set_label(whoServerLabel, WhoisServer);
	  break;
    case 6: /* remove entry */
/*
printf("make whois server %s\n", HostList[currentItem]);
*/
	  /* free the entry, then slide each below it up one */
	  XtFree(HostList[currentItem]);
	  for (i=currentItem; HostList[i]; i++)
		HostList[i] = HostList[i +1];
	  XawListChange(hostListWidget, HostList, 0,0, True);
	  XtSetValues(hostListWidget, args, 1);
      break;
	default:
	  break;
	}

	currentItem = -1;
}



static void
newEntryCB(w, closure, call_data)
Widget w;
XtPointer closure, call_data;
{
	Widget popup;
    Arg     args[5];
    Position    x, y;
    Dimension   width, height;
    register int n;

/*
printf("newEntryCB\n");
*/
	
	n = 0;
	XtSetArg(args[0], XtNwidth, &width); n++;
	XtSetArg(args[1], XtNheight, &height); n++;
	XtGetValues(w, args, n);
	XtTranslateCoords(w, (Position) (width / 2),
			(Position) (height / 2), &x, &y);

	n = 0;
	XtSetArg(args[n], XtNx, x);             n++;
	XtSetArg(args[n], XtNy, y);             n++;

	popup = XtCreatePopupShell("newEntry",
		transientShellWidgetClass, w, args, n);
	n = 0;
	XtSetArg(args[n], XtNlabel, "New host name...");    n++;
	XtSetArg(args[n], XtNvalue, "");    n++;
	newEntryDialog = XtCreateManagedWidget("newEntryDialog",
		dialogWidgetClass, popup, args, n);

	XawDialogAddButton(newEntryDialog, "ok", acceptNewEntry,
		(XtPointer) NULL);
	XawDialogAddButton(newEntryDialog, "cancel", Destroy_form,
		(XtPointer)newEntryDialog);

	XtPopup(popup, XtGrabExclusive);
}

static void
saveChangesCB(w, closure, call_data)
Widget w;
XtPointer closure, call_data;
{
/*
printf("saveChangesCB\n");
*/
	set_cursor(CURSOR_BUSY, 0);
    grey_the_bar(False);
	grey_the_button(updatedownloadButton, False);


	grey_the_button(saveButton, False);

	soak_events();

	saveHostFile();

	kick_start_server_list();

    set_cursor(CURSOR_NORMAL, 0);
    grey_the_bar(True);
	grey_the_button(updatedownloadButton, True);
}

kick_start_server_list()
{
    int old_manyservers;

    old_manyservers = Many_servers;

    parseServerList(); /* loads server_list from HostList, sets Many_servers */

    restart_index(old_manyservers);
    restart_motd(old_manyservers);
    restart_library();
    restart_class();
	restart_setup(old_manyservers);
}


void
acceptNewEntry(w, closure, call_data)
Widget w;
XtPointer closure, call_data;
{
	char buf[MAXLINE];
    Widget popup = XtParent( (Widget) newEntryDialog);
	String s;
	register int i;
	Arg args[3];

/*
printf("acceptNewEntry\n");
*/

	s = XawDialogGetValueString(newEntryDialog);

	if (strlen(s) < 1) {
		XtDestroyWidget(popup);
		return;
	}

	grey_the_button(saveButton, True);

	strcpy(buf, "*");
	strcat(buf, s);

	i=0; while (HostList[i])	i++;
    HostList[i] = XtNewString(buf);
	HostList[i+1] = NULL;

	XawListChange(hostListWidget, HostList, 0,0, True);
    XtSetArg(args[0], XtNwidth, XNL_WIDTH -10);
	XtSetValues(hostListWidget, args, 1);

    XtDestroyWidget(popup);
}

make_siteIcons(box)
Widget box; /* parent */
{
	register int i, n;
	char filename[2550];
	Pixmap bitmap;
	int xh, yh;
	unsigned int w,h;
	Arg args[5];

	prettyIconsParent = box;

	prettyIcons = (Widget*)malloc(Many_servers * sizeof(Widget) );

	for (i=0; i < Many_servers; i++) {
        sprintf(filename, "%s/%s/%s", XNL_PATH, server_list[i], SITE_ICON);
        confirmFile(filename, (PUBDATA) ? 1 : 0, False, True);

        if (XReadBitmapFile(XtDisplay(toplevel),
			DefaultRootWindow( XtDisplay(toplevel)),
			filename, &w, &h, &bitmap, &xh, &yh) == BitmapSuccess) {

			n = 0;
			XtSetArg(args[n], XtNborderWidth, 0); n++;
			XtSetArg(args[n], XtNbitmap, bitmap); n++;
			FIX
			prettyIcons[i] = XtCreateManagedWidget("prettyPic",
					labelWidgetClass, box, args, n);
        } else {
			prettyIcons[i] = (Widget)NULL;
		}
	}
}


restart_setup(old_manyservers)
int old_manyservers;
{
	register int i;
    for (i=0; i < old_manyservers; i++)
		if (prettyIcons[i] != NULL)
			XtDestroyWidget(prettyIcons[i]);
	XtFree((char *)prettyIcons);

	make_siteIcons(prettyIconsParent);
}


