# coding: utf-8

"""
    CLOUD API

    IONOS Enterprise-grade Infrastructure as a Service (IaaS) solutions can be managed through the Cloud API, in addition or as an alternative to the \"Data Center Designer\" (DCD) browser-based tool.    Both methods employ consistent concepts and features, deliver similar power and flexibility, and can be used to perform a multitude of management tasks, including adding servers, volumes, configuring networks, and so on.  # noqa: E501

    The version of the OpenAPI document: 6.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from ionoscloud.configuration import Configuration


class LocationProperties(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {

        'cpu_architecture': 'list[CpuArchitectureProperties]',

        'features': 'list[str]',

        'image_aliases': 'list[str]',

        'name': 'str',
    }

    attribute_map = {

        'cpu_architecture': 'cpuArchitecture',

        'features': 'features',

        'image_aliases': 'imageAliases',

        'name': 'name',
    }

    def __init__(self, cpu_architecture=None, features=None, image_aliases=None, name=None, local_vars_configuration=None):  # noqa: E501
        """LocationProperties - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._cpu_architecture = None
        self._features = None
        self._image_aliases = None
        self._name = None
        self.discriminator = None

        if cpu_architecture is not None:
            self.cpu_architecture = cpu_architecture
        if features is not None:
            self.features = features
        if image_aliases is not None:
            self.image_aliases = image_aliases
        if name is not None:
            self.name = name


    @property
    def cpu_architecture(self):
        """Gets the cpu_architecture of this LocationProperties.  # noqa: E501

        A list of available CPU types and related resources available in the location.  # noqa: E501

        :return: The cpu_architecture of this LocationProperties.  # noqa: E501
        :rtype: list[CpuArchitectureProperties]
        """
        return self._cpu_architecture

    @cpu_architecture.setter
    def cpu_architecture(self, cpu_architecture):
        """Sets the cpu_architecture of this LocationProperties.

        A list of available CPU types and related resources available in the location.  # noqa: E501

        :param cpu_architecture: The cpu_architecture of this LocationProperties.  # noqa: E501
        :type cpu_architecture: list[CpuArchitectureProperties]
        """

        self._cpu_architecture = cpu_architecture

    @property
    def features(self):
        """Gets the features of this LocationProperties.  # noqa: E501

        A list of available features in the location.  # noqa: E501

        :return: The features of this LocationProperties.  # noqa: E501
        :rtype: list[str]
        """
        return self._features

    @features.setter
    def features(self, features):
        """Sets the features of this LocationProperties.

        A list of available features in the location.  # noqa: E501

        :param features: The features of this LocationProperties.  # noqa: E501
        :type features: list[str]
        """

        self._features = features

    @property
    def image_aliases(self):
        """Gets the image_aliases of this LocationProperties.  # noqa: E501

        A list of image aliases available in the location.  # noqa: E501

        :return: The image_aliases of this LocationProperties.  # noqa: E501
        :rtype: list[str]
        """
        return self._image_aliases

    @image_aliases.setter
    def image_aliases(self, image_aliases):
        """Sets the image_aliases of this LocationProperties.

        A list of image aliases available in the location.  # noqa: E501

        :param image_aliases: The image_aliases of this LocationProperties.  # noqa: E501
        :type image_aliases: list[str]
        """

        self._image_aliases = image_aliases

    @property
    def name(self):
        """Gets the name of this LocationProperties.  # noqa: E501

        The location name.  # noqa: E501

        :return: The name of this LocationProperties.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this LocationProperties.

        The location name.  # noqa: E501

        :param name: The name of this LocationProperties.  # noqa: E501
        :type name: str
        """

        self._name = name
    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, LocationProperties):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, LocationProperties):
            return True

        return self.to_dict() != other.to_dict()
