/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.value;

import javax.xml.transform.TransformerException;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.om.AbstractNode;
import net.sf.saxon.om.ArrayIterator;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.EmptyIterator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SingletonIterator;
import net.sf.saxon.pattern.NodeTest;

public final class TextFragmentValue
extends AbstractNode
implements DocumentInfo {
    private String text;
    private String systemId;
    private TextFragmentTextNode textNode = null;
    private NamePool namePool;
    private int documentNumber;

    public TextFragmentValue(String string, String string2) {
        this.text = string;
        this.systemId = string2;
    }

    public void setNamePool(NamePool namePool) {
        this.namePool = namePool;
        this.documentNumber = namePool.allocateDocumentNumber(this);
    }

    public NamePool getNamePool() {
        return this.namePool;
    }

    public int getDocumentNumber() {
        return this.documentNumber;
    }

    public final int getNodeKind() {
        return 9;
    }

    public String getStringValue() {
        return this.text;
    }

    public boolean isSameNode(NodeInfo nodeInfo) {
        return this == nodeInfo;
    }

    public String generateId() {
        return "tt" + this.getDocumentNumber();
    }

    public void setSystemId(String string) {
        this.systemId = string;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public String getBaseURI() {
        return this.systemId;
    }

    public int compareOrder(NodeInfo nodeInfo) {
        if (this == nodeInfo) {
            return 0;
        }
        return -1;
    }

    public int getNameCode() {
        return -1;
    }

    public int getFingerprint() {
        return -1;
    }

    public String getPrefix() {
        return "";
    }

    public String getURI() {
        return "";
    }

    public String getDisplayName() {
        return "";
    }

    public String getLocalPart() {
        return "";
    }

    public boolean hasChildNodes() {
        return !"".equals(this.text);
    }

    public boolean hasAttributes() {
        return false;
    }

    public String getAttributeValue(int n) {
        return null;
    }

    public AxisIterator iterateAxis(byte by) {
        switch (by) {
            case 0: 
            case 2: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: {
                return EmptyIterator.getInstance();
            }
            case 1: 
            case 12: {
                return SingletonIterator.makeIterator(this);
            }
            case 3: 
            case 4: {
                return SingletonIterator.makeIterator(this.getTextNode());
            }
            case 5: {
                Item[] itemArray = new Item[]{this, this.getTextNode()};
                return new ArrayIterator(itemArray);
            }
        }
        throw new IllegalArgumentException("Unknown axis number " + by);
    }

    public AxisIterator iterateAxis(byte by, NodeTest nodeTest) {
        switch (by) {
            case 0: 
            case 2: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: {
                return EmptyIterator.getInstance();
            }
            case 1: 
            case 12: {
                return SingletonIterator.makeIterator(this);
            }
            case 3: 
            case 4: {
                TextFragmentTextNode textFragmentTextNode = this.getTextNode();
                if (nodeTest.matches(textFragmentTextNode.getNodeKind(), textFragmentTextNode.getFingerprint(), -1)) {
                    return SingletonIterator.makeIterator(textFragmentTextNode);
                }
                return EmptyIterator.getInstance();
            }
            case 5: {
                TextFragmentTextNode textFragmentTextNode = this.getTextNode();
                if (nodeTest.matches(textFragmentTextNode.getNodeKind(), textFragmentTextNode.getFingerprint(), -1)) {
                    Item[] itemArray = new Item[]{this, textFragmentTextNode};
                    return new ArrayIterator(itemArray);
                }
                return SingletonIterator.makeIterator(this);
            }
        }
        throw new IllegalArgumentException("Unknown axis number " + by);
    }

    public NodeInfo getParent() {
        return null;
    }

    public NodeInfo getRoot() {
        return this;
    }

    public DocumentInfo getDocumentRoot() {
        return this;
    }

    public void copy(Receiver receiver, int n, boolean bl) throws TransformerException {
        receiver.characters(this.text, 0);
    }

    public NodeInfo selectID(String string) {
        return null;
    }

    public String[] getUnparsedEntity(String string) {
        return null;
    }

    private TextFragmentTextNode getTextNode() {
        if (this.textNode == null) {
            this.textNode = new TextFragmentTextNode();
        }
        return this.textNode;
    }

    private class TextFragmentTextNode
    extends AbstractNode {
        private TextFragmentTextNode() {
        }

        public void setSystemId(String string) {
        }

        public NamePool getNamePool() {
            return TextFragmentValue.this.namePool;
        }

        public final int getNodeKind() {
            return 3;
        }

        public String getStringValue() {
            return TextFragmentValue.this.text;
        }

        public boolean isSameNode(NodeInfo nodeInfo) {
            return this == nodeInfo;
        }

        public String generateId() {
            return "tt" + this.getDocumentNumber() + "t1";
        }

        public String getSystemId() {
            return TextFragmentValue.this.systemId;
        }

        public String getBaseURI() {
            return TextFragmentValue.this.systemId;
        }

        public int compareOrder(NodeInfo nodeInfo) {
            if (this == nodeInfo) {
                return 0;
            }
            return 1;
        }

        public int getNameCode() {
            return -1;
        }

        public int getFingerprint() {
            return -1;
        }

        public String getPrefix() {
            return "";
        }

        public String getURI() {
            return "";
        }

        public String getDisplayName() {
            return "";
        }

        public String getLocalPart() {
            return "";
        }

        public boolean hasChildNodes() {
            return false;
        }

        public boolean hasAttributes() {
            return false;
        }

        public String getAttributeValue(int n) {
            return null;
        }

        public AxisIterator iterateAxis(byte by) {
            switch (by) {
                case 0: 
                case 9: 
                case 13: {
                    return SingletonIterator.makeIterator(TextFragmentValue.this);
                }
                case 1: {
                    Item[] itemArray = new Item[]{this, TextFragmentValue.this};
                    return new ArrayIterator(itemArray);
                }
                case 2: 
                case 3: 
                case 4: 
                case 6: 
                case 7: 
                case 8: 
                case 10: 
                case 11: {
                    return EmptyIterator.getInstance();
                }
                case 5: 
                case 12: {
                    return SingletonIterator.makeIterator(this);
                }
            }
            throw new IllegalArgumentException("Unknown axis number " + by);
        }

        public AxisIterator iterateAxis(byte by, NodeTest nodeTest) {
            switch (by) {
                case 0: 
                case 9: 
                case 13: {
                    if (nodeTest.matches(9, TextFragmentValue.this.getFingerprint(), -1)) {
                        return SingletonIterator.makeIterator(TextFragmentValue.this);
                    }
                    return EmptyIterator.getInstance();
                }
                case 1: {
                    boolean bl = nodeTest.matches(9, TextFragmentValue.this.getFingerprint(), -1);
                    boolean bl2 = nodeTest.matches(3, this.getFingerprint(), -1);
                    if (bl && bl2) {
                        Item[] itemArray = new Item[]{this, TextFragmentValue.this};
                        return new ArrayIterator(itemArray);
                    }
                    if (bl && !bl2) {
                        return SingletonIterator.makeIterator(TextFragmentValue.this);
                    }
                    if (bl2 && !bl) {
                        return SingletonIterator.makeIterator(this);
                    }
                    return EmptyIterator.getInstance();
                }
                case 2: 
                case 3: 
                case 4: 
                case 6: 
                case 7: 
                case 8: 
                case 10: 
                case 11: {
                    return EmptyIterator.getInstance();
                }
                case 5: 
                case 12: {
                    if (nodeTest.matches(3, this.getFingerprint(), -1)) {
                        return SingletonIterator.makeIterator(this);
                    }
                    return EmptyIterator.getInstance();
                }
            }
            throw new IllegalArgumentException("Unknown axis number " + by);
        }

        public NodeInfo getParent() {
            return TextFragmentValue.this;
        }

        public NodeInfo getRoot() {
            return TextFragmentValue.this;
        }

        public DocumentInfo getDocumentRoot() {
            return TextFragmentValue.this;
        }

        public void copy(Receiver receiver, int n, boolean bl) throws TransformerException {
            receiver.characters(TextFragmentValue.this.text, 0);
        }
    }
}

