#include <stdio.h>

unsigned long long data[32] = {
   0x0000000000000000ull, 0x0000000000000000ull,
   0xffffffffffffffffull, 0xffffffffffffffffull,
   0x0000000080000000ull, 0x8000000000000000ull,
   0x8000800080008000ull, 0x7fff7fff7fff7fffull,
   0x8080808080808080ull, 0x8080808080808080ull,
   0x7070707070707070ull, 0x7070707070707070ull,
   0x7f7f7f7f7f7f7f7full, 0x7f7f7f7f7f7f7f7full,
   0x0706050403020100ull, 0x0f0e0d0c0b0a0908ull,
   0x77665544332211ffull, 0xeeddccbbaa998877ull,
   0x0000000000000001ull, 0x00000000000001ffull,
   0x0000000000000001ull, 0x00000000000000ffull,
   0xffffffffffffffffull, 0x0000000000000000ull,
   0x0000000100000001ull, 0x0000000100000001ull,
   0x1234567890abcdefull, 0xfedbca9876543210ull,
   0x0403020114131211ull, 0x2423222134333231ull,
   0x8483828194939291ull, 0xa4a3a2a1b4b3b2b1ull,
};

unsigned long long out[2];
unsigned int outi;

#define TEST_3R(instruction, offset1, offset2, WD, WS, WT)             \
{                                                                      \
   __asm__ volatile (                                                  \
      ".set push;\n\t"                                                 \
      ".set noreorder;\n\t"                                            \
      "move $t0, %0\n\t"                                               \
      "ld.d $"#WD", "#offset1"($t0)\n\t"                               \
      "xori.b $"#WD", $"#WD", 0xff\n\t"                                \
      "ld.d $"#WS", "#offset1"($t0)\n\t"                               \
      "ld.d $"#WT", "#offset2"($t0)\n\t"                               \
      instruction" $"#WD", $"#WS", $"#WT"\n\t"                         \
      "move $t0, %1\n\t"                                               \
      "st.d $"#WD", 0($t0)\n\t"                                        \
      ".set pop;\n\t"                                                  \
      :                                                                \
      : "r" (data), "r" (out)                                          \
      : "t0", "memory"                                                 \
   );                                                                  \
   printf(instruction" $"#WD", $"#WS", $"#WT" "#WD":"                  \
          " %016llx%016llx  "#WS": %016llx%016llx  "#WT": "            \
          "%016llx%016llx\n", out[1], out[0], data[offset1 / 8 + 1],   \
          data[offset1 / 8], data[offset2 / 8 + 1], data[offset2 / 8]);\
}

//32 bit only
#define TEST_COP1(instruction, offset, WT)                              \
{                                                                       \
   __asm__ volatile (                                                   \
      ".set push;\n\t"                                                  \
      ".set noreorder;\n\t"                                             \
      "move $t0, %0\n\t"                                                \
      "beq $zero, $zero, start"instruction#WT"\n\t"                     \
      "move $t1, $zero\n\t"                                             \
      "l1"instruction#WT": beq $zero, $zero, end"instruction#WT"\n\t"   \
      "addiu $t1, 9\n\t"                                                \
      "start"instruction#WT": ld.d $"#WT", "#offset"($t0)\n\t"          \
      instruction" $"#WT", l2"instruction#WT"\n\t"                      \
      "addiu $t1, 3\n\t"                                                \
      "addiu $t1, 5\n\t"                                                \
      "l2"instruction#WT": "instruction" $"#WT", l1"instruction#WT"\n\t"\
      "addiu $t1, 7\n\t"                                                \
      "end"instruction#WT": move $t0, %1\n\t"                           \
      "sw $t1, 0($t0)\n\t"                                              \
      ".set pop;\n\t"                                                   \
      :                                                                 \
      : "r" (data), "r" (&outi)                                         \
      : "t0", "t1", "memory"                                            \
   );                                                                   \
   printf(instruction" $"#WT", _xxx_ "#WT":"                            \
          " %016llx%016llx sum: %02x\n",                                \
          data[offset / 8 + 1], data[offset / 8], outi);                \
}

#define TEST_I5(instruction, offset, WD, WS, imm)                      \
{                                                                      \
   __asm__ volatile (                                                  \
      ".set push;\n\t"                                                 \
      ".set noreorder;\n\t"                                            \
      "move $t0, %0\n\t"                                               \
      "ld.d $"#WD", "#offset"($t0)\n\t"                                \
      "xori.b $"#WD", $"#WD", 0xff\n\t"                                \
      "ld.d $"#WS", "#offset"($t0)\n\t"                                \
      instruction" $"#WD", $"#WS", "#imm"\n\t"                         \
      "move $t0, %1\n\t"                                               \
      "st.d $"#WD", 0($t0)\n\t"                                        \
      ".set pop;\n\t"                                                  \
      :                                                                \
      : "r" (data), "r" (out)                                          \
      : "t0", "memory"                                                 \
   );                                                                  \
   printf(instruction" $"#WD", $"#WS", "#imm" "#WD":"                  \
          " %016llx%016llx  "#WS": %016llx%016llx\n",                  \
          out[1], out[0], data[offset / 8 + 1], data[offset / 8]);     \
}

int main(int argc, char **argv) {
#if defined(__mips_msa)
   TEST_3R("ceq.b",   0, 128, w0,  w3,  w3);
   TEST_3R("ceq.b",   8, 208, w1,  w12, w27);
   TEST_3R("ceq.b",  16, 144, w2,  w11, w22);
   TEST_3R("ceq.b",  24, 136, w3,  w18, w17);
   TEST_3R("ceq.b",  32,  80, w4,  w5,  w2);
   TEST_3R("ceq.b",  40, 144, w5,  w3,  w18);
   TEST_3R("ceq.b",  48,  96, w6,  w12, w21);
   TEST_3R("ceq.b",  56,  96, w7,  w16, w14);
   TEST_3R("ceq.b",  64,  48, w8,  w18, w30);
   TEST_3R("ceq.b",  72,  96, w9,  w14, w15);
   TEST_3R("ceq.b",  80,  40, w10, w24, w10);
   TEST_3R("ceq.b",  88, 216, w11, w22, w27);
   TEST_3R("ceq.b",  96, 184, w12, w17, w7);
   TEST_3R("ceq.b", 104,  88, w13, w13, w20);
   TEST_3R("ceq.b", 112, 136, w14, w25, w31);
   TEST_3R("ceq.b", 120,  56, w15, w4,  w2);
   TEST_3R("ceq.b", 128,  32, w16, w21, w14);
   TEST_3R("ceq.b", 136,   0, w17, w17, w17);
   TEST_3R("ceq.b", 144, 160, w18, w30, w25);
   TEST_3R("ceq.b", 152,  56, w19, w16, w31);
   TEST_3R("ceq.b", 160,  88, w20, w31, w18);
   TEST_3R("ceq.b", 168, 112, w21, w15, w8);
   TEST_3R("ceq.b", 176, 112, w22, w11, w26);
   TEST_3R("ceq.b", 184,  24, w23, w18, w2);
   TEST_3R("ceq.b", 192, 176, w24, w12, w27);
   TEST_3R("ceq.b", 200, 184, w25, w11, w23);
   TEST_3R("ceq.b", 208,  96, w26, w13, w6);
   TEST_3R("ceq.b", 216,  88, w27, w10, w8);
   TEST_3R("ceq.b", 224, 168, w28, w1,  w11);
   TEST_3R("ceq.b", 232,  40, w29, w0,  w10);
   TEST_3R("ceq.b", 240, 200, w30, w18, w2);
   TEST_3R("ceq.b",   0, 208, w31, w27, w22);
   TEST_3R("ceq.h",   0,  40, w0,  w26, w26);
   TEST_3R("ceq.h",   8,  64, w1,  w23, w19);
   TEST_3R("ceq.h",  16, 144, w2,  w18, w26);
   TEST_3R("ceq.h",  24, 120, w3,  w10, w5);
   TEST_3R("ceq.h",  32, 152, w4,  w16, w6);
   TEST_3R("ceq.h",  40,   0, w5,  w26, w14);
   TEST_3R("ceq.h",  48, 120, w6,  w22, w16);
   TEST_3R("ceq.h",  56,  72, w7,  w3,  w16);
   TEST_3R("ceq.h",  64, 216, w8,  w16, w3);
   TEST_3R("ceq.h",  72,   0, w9,  w11, w30);
   TEST_3R("ceq.h",  80, 176, w10, w18, w10);
   TEST_3R("ceq.h",  88,  56, w11, w28, w10);
   TEST_3R("ceq.h",  96, 152, w12, w16, w28);
   TEST_3R("ceq.h", 104, 192, w13, w13, w1);
   TEST_3R("ceq.h", 112, 112, w14, w15, w0);
   TEST_3R("ceq.h", 120, 144, w15, w21, w26);
   TEST_3R("ceq.h", 128, 192, w16, w4,  w14);
   TEST_3R("ceq.h", 136,   0, w17, w17, w17);
   TEST_3R("ceq.h", 144,  32, w18, w13, w10);
   TEST_3R("ceq.h", 152,  48, w19, w22, w26);
   TEST_3R("ceq.h", 160, 224, w20, w2,  w6);
   TEST_3R("ceq.h", 168,  40, w21, w4,  w24);
   TEST_3R("ceq.h", 176,   0, w22, w1,  w3);
   TEST_3R("ceq.h", 184, 120, w23, w16, w19);
   TEST_3R("ceq.h", 192,  80, w24, w26, w21);
   TEST_3R("ceq.h", 200,  72, w25, w9,  w21);
   TEST_3R("ceq.h", 208, 216, w26, w30, w15);
   TEST_3R("ceq.h", 216,  48, w27, w2,  w29);
   TEST_3R("ceq.h", 224, 216, w28, w22, w10);
   TEST_3R("ceq.h", 232, 184, w29, w27, w0);
   TEST_3R("ceq.h", 240, 232, w30, w2,  w3);
   TEST_3R("ceq.h",  96,   0, w31, w8,  w7);
   TEST_3R("ceq.w",   0, 120, w0,  w8,  w8);
   TEST_3R("ceq.w",   8,  40, w1,  w3,  w25);
   TEST_3R("ceq.w",  16, 152, w2,  w19, w7);
   TEST_3R("ceq.w",  24,  64, w3,  w23, w26);
   TEST_3R("ceq.w",  32,   0, w4,  w16, w29);
   TEST_3R("ceq.w",  40,  40, w5,  w3,  w19);
   TEST_3R("ceq.w",  48, 136, w6,  w1,  w14);
   TEST_3R("ceq.w",  56, 144, w7,  w26, w17);
   TEST_3R("ceq.w",  64,  56, w8,  w24, w25);
   TEST_3R("ceq.w",  72, 128, w9,  w15, w25);
   TEST_3R("ceq.w",  80, 152, w10, w8,  w10);
   TEST_3R("ceq.w",  88, 120, w11, w25, w21);
   TEST_3R("ceq.w",  96, 152, w12, w23, w6);
   TEST_3R("ceq.w", 104, 168, w13, w13, w14);
   TEST_3R("ceq.w", 112,  24, w14, w3,  w20);
   TEST_3R("ceq.w", 120,  40, w15, w0,  w23);
   TEST_3R("ceq.w", 128,  40, w16, w19, w4);
   TEST_3R("ceq.w", 136,  48, w17, w17, w17);
   TEST_3R("ceq.w", 144, 176, w18, w24, w19);
   TEST_3R("ceq.w", 152, 104, w19, w17, w12);
   TEST_3R("ceq.w", 160, 104, w20, w0,  w5);
   TEST_3R("ceq.w", 168, 160, w21, w8,  w2);
   TEST_3R("ceq.w", 176, 160, w22, w30, w0);
   TEST_3R("ceq.w", 184, 184, w23, w21, w6);
   TEST_3R("ceq.w", 192, 168, w24, w4,  w16);
   TEST_3R("ceq.w", 200,  88, w25, w24, w9);
   TEST_3R("ceq.w", 208,  64, w26, w16, w6);
   TEST_3R("ceq.w", 216, 224, w27, w20, w5);
   TEST_3R("ceq.w", 224, 176, w28, w6,  w29);
   TEST_3R("ceq.w", 232, 224, w29, w9,  w14);
   TEST_3R("ceq.w", 240,  80, w30, w3,  w14);
   TEST_3R("ceq.w",   0, 104, w31, w30, w23);
   TEST_3R("ceq.d",   0, 120, w0,  w21, w21);
   TEST_3R("ceq.d",   8,  56, w1,  w20, w10);
   TEST_3R("ceq.d",  16, 168, w2,  w29, w14);
   TEST_3R("ceq.d",  24, 184, w3,  w10, w7);
   TEST_3R("ceq.d",  32, 232, w4,  w22, w23);
   TEST_3R("ceq.d",  40,  96, w5,  w22, w11);
   TEST_3R("ceq.d",  48,  48, w6,  w24, w18);
   TEST_3R("ceq.d",  56, 160, w7,  w13, w27);
   TEST_3R("ceq.d",  64, 104, w8,  w14, w30);
   TEST_3R("ceq.d",  72,  80, w9,  w21, w29);
   TEST_3R("ceq.d",  80,  96, w10, w29, w10);
   TEST_3R("ceq.d",  88, 128, w11, w27, w6);
   TEST_3R("ceq.d",  96, 112, w12, w5,  w22);
   TEST_3R("ceq.d", 104,   0, w13, w13, w20);
   TEST_3R("ceq.d", 112, 184, w14, w11, w27);
   TEST_3R("ceq.d", 120, 184, w15, w2,  w18);
   TEST_3R("ceq.d", 128, 160, w16, w24, w29);
   TEST_3R("ceq.d", 136, 224, w17, w17, w17);
   TEST_3R("ceq.d", 144, 200, w18, w15, w20);
   TEST_3R("ceq.d", 152,  40, w19, w10, w21);
   TEST_3R("ceq.d", 160, 208, w20, w9,  w4);
   TEST_3R("ceq.d", 168, 104, w21, w6,  w10);
   TEST_3R("ceq.d", 176, 216, w22, w5,  w6);
   TEST_3R("ceq.d", 184, 200, w23, w10, w28);
   TEST_3R("ceq.d", 192,  96, w24, w30, w17);
   TEST_3R("ceq.d", 200,  24, w25, w16, w9);
   TEST_3R("ceq.d", 208,  72, w26, w30, w1);
   TEST_3R("ceq.d", 216, 168, w27, w0,  w18);
   TEST_3R("ceq.d", 224,  48, w28, w21, w17);
   TEST_3R("ceq.d", 232, 184, w29, w10, w30);
   TEST_3R("ceq.d", 240, 176, w30, w14, w0);
   TEST_3R("ceq.d", 224,  56, w31, w24, w8);
   TEST_3R("cle_s.b",   0,  48, w0,  w6,  w19);
   TEST_3R("cle_s.b",   8,  48, w1,  w31, w1);
   TEST_3R("cle_s.b",  16, 152, w2,  w2,  w2);
   TEST_3R("cle_s.b",  24, 200, w3,  w11, w1);
   TEST_3R("cle_s.b",  32,   0, w4,  w20, w1);
   TEST_3R("cle_s.b",  40, 224, w5,  w12, w22);
   TEST_3R("cle_s.b",  48,  16, w6,  w15, w0);
   TEST_3R("cle_s.b",  56,  40, w7,  w7,  w27);
   TEST_3R("cle_s.b",  64,  80, w8,  w16, w13);
   TEST_3R("cle_s.b",  72, 144, w9,  w16, w21);
   TEST_3R("cle_s.b",  80,  56, w10, w21, w23);
   TEST_3R("cle_s.b",  88,  80, w11, w23, w21);
   TEST_3R("cle_s.b",  96, 192, w12, w10, w25);
   TEST_3R("cle_s.b", 104, 232, w13, w7,  w27);
   TEST_3R("cle_s.b", 112, 120, w14, w22, w15);
   TEST_3R("cle_s.b", 120, 112, w15, w23, w28);
   TEST_3R("cle_s.b", 128, 192, w16, w10, w11);
   TEST_3R("cle_s.b", 136, 112, w17, w26, w7);
   TEST_3R("cle_s.b", 144, 200, w18, w11, w20);
   TEST_3R("cle_s.b", 152, 216, w19, w27, w10);
   TEST_3R("cle_s.b", 160,  40, w20, w16, w1);
   TEST_3R("cle_s.b", 168, 120, w21, w7,  w22);
   TEST_3R("cle_s.b", 176, 184, w22, w17, w16);
   TEST_3R("cle_s.b", 184,  72, w23, w30, w7);
   TEST_3R("cle_s.b", 192, 200, w24, w13, w22);
   TEST_3R("cle_s.b", 200,  80, w25, w4,  w18);
   TEST_3R("cle_s.b", 208, 152, w26, w14, w30);
   TEST_3R("cle_s.b", 216,  24, w27, w9,  w5);
   TEST_3R("cle_s.b", 224, 104, w28, w20, w25);
   TEST_3R("cle_s.b", 232, 128, w29, w15, w15);
   TEST_3R("cle_s.b", 240, 176, w30, w24, w31);
   TEST_3R("cle_s.b", 232, 232, w31, w2,  w7);
   TEST_3R("cle_s.h",   0, 184, w0,  w24, w11);
   TEST_3R("cle_s.h",   8,  64, w1,  w23, w1);
   TEST_3R("cle_s.h",  16, 200, w2,  w2,  w2);
   TEST_3R("cle_s.h",  24, 168, w3,  w15, w6);
   TEST_3R("cle_s.h",  32, 128, w4,  w20, w24);
   TEST_3R("cle_s.h",  40, 152, w5,  w2,  w22);
   TEST_3R("cle_s.h",  48,  48, w6,  w11, w27);
   TEST_3R("cle_s.h",  56,   0, w7,  w7,  w31);
   TEST_3R("cle_s.h",  64,   8, w8,  w0,  w14);
   TEST_3R("cle_s.h",  72, 184, w9,  w24, w14);
   TEST_3R("cle_s.h",  80,  56, w10, w26, w21);
   TEST_3R("cle_s.h",  88, 160, w11, w23, w13);
   TEST_3R("cle_s.h",  96, 224, w12, w0,  w4);
   TEST_3R("cle_s.h", 104,  48, w13, w15, w8);
   TEST_3R("cle_s.h", 112, 184, w14, w21, w7);
   TEST_3R("cle_s.h", 120,  40, w15, w14, w9);
   TEST_3R("cle_s.h", 128,  40, w16, w4,  w19);
   TEST_3R("cle_s.h", 136, 232, w17, w0,  w26);
   TEST_3R("cle_s.h", 144, 176, w18, w21, w27);
   TEST_3R("cle_s.h", 152, 120, w19, w13, w20);
   TEST_3R("cle_s.h", 160, 176, w20, w14, w9);
   TEST_3R("cle_s.h", 168, 104, w21, w5,  w23);
   TEST_3R("cle_s.h", 176, 200, w22, w5,  w27);
   TEST_3R("cle_s.h", 184,  16, w23, w21, w3);
   TEST_3R("cle_s.h", 192,  80, w24, w10, w11);
   TEST_3R("cle_s.h", 200, 232, w25, w24, w20);
   TEST_3R("cle_s.h", 208,  32, w26, w29, w7);
   TEST_3R("cle_s.h", 216, 136, w27, w29, w1);
   TEST_3R("cle_s.h", 224, 104, w28, w18, w20);
   TEST_3R("cle_s.h", 232, 104, w29, w16, w16);
   TEST_3R("cle_s.h", 240,  40, w30, w10, w18);
   TEST_3R("cle_s.h", 120,  16, w31, w3,  w9);
   TEST_3R("cle_s.w",   0, 120, w0,  w5,  w6);
   TEST_3R("cle_s.w",   8, 120, w1,  w8,  w1);
   TEST_3R("cle_s.w",  16,  40, w2,  w2,  w2);
   TEST_3R("cle_s.w",  24, 144, w3,  w19, w29);
   TEST_3R("cle_s.w",  32,  72, w4,  w7,  w26);
   TEST_3R("cle_s.w",  40,  72, w5,  w14, w16);
   TEST_3R("cle_s.w",  48, 232, w6,  w16, w30);
   TEST_3R("cle_s.w",  56,  80, w7,  w7,  w12);
   TEST_3R("cle_s.w",  64, 184, w8,  w12, w28);
   TEST_3R("cle_s.w",  72, 216, w9,  w23, w26);
   TEST_3R("cle_s.w",  80,  24, w10, w5,  w30);
   TEST_3R("cle_s.w",  88, 168, w11, w28, w7);
   TEST_3R("cle_s.w",  96, 224, w12, w3,  w5);
   TEST_3R("cle_s.w", 104,  88, w13, w15, w25);
   TEST_3R("cle_s.w", 112,  88, w14, w0,  w7);
   TEST_3R("cle_s.w", 120, 136, w15, w23, w7);
   TEST_3R("cle_s.w", 128, 104, w16, w22, w20);
   TEST_3R("cle_s.w", 136, 136, w17, w9,  w1);
   TEST_3R("cle_s.w", 144,  96, w18, w5,  w24);
   TEST_3R("cle_s.w", 152,  56, w19, w29, w0);
   TEST_3R("cle_s.w", 160, 104, w20, w26, w7);
   TEST_3R("cle_s.w", 168,  88, w21, w29, w12);
   TEST_3R("cle_s.w", 176,  32, w22, w12, w26);
   TEST_3R("cle_s.w", 184,  64, w23, w25, w8);
   TEST_3R("cle_s.w", 192, 224, w24, w0,  w21);
   TEST_3R("cle_s.w", 200, 128, w25, w23, w28);
   TEST_3R("cle_s.w", 208, 112, w26, w13, w17);
   TEST_3R("cle_s.w", 216,   8, w27, w22, w18);
   TEST_3R("cle_s.w", 224, 216, w28, w27, w10);
   TEST_3R("cle_s.w", 232, 176, w29, w15, w15);
   TEST_3R("cle_s.w", 240, 192, w30, w12, w26);
   TEST_3R("cle_s.w",  96, 200, w31, w19, w3);
   TEST_3R("cle_s.d",   0, 152, w0,  w17, w11);
   TEST_3R("cle_s.d",   8,  96, w1,  w24, w1);
   TEST_3R("cle_s.d",  16, 224, w2,  w2,  w2);
   TEST_3R("cle_s.d",  24, 128, w3,  w31, w4);
   TEST_3R("cle_s.d",  32, 208, w4,  w22, w27);
   TEST_3R("cle_s.d",  40,  64, w5,  w11, w9);
   TEST_3R("cle_s.d",  48, 176, w6,  w12, w31);
   TEST_3R("cle_s.d",  56, 136, w7,  w7,  w21);
   TEST_3R("cle_s.d",  64,  88, w8,  w1,  w10);
   TEST_3R("cle_s.d",  72, 152, w9,  w13, w4);
   TEST_3R("cle_s.d",  80, 120, w10, w0,  w7);
   TEST_3R("cle_s.d",  88, 224, w11, w0,  w24);
   TEST_3R("cle_s.d",  96, 192, w12, w26, w16);
   TEST_3R("cle_s.d", 104,  88, w13, w29, w16);
   TEST_3R("cle_s.d", 112,  32, w14, w20, w6);
   TEST_3R("cle_s.d", 120,  80, w15, w8,  w17);
   TEST_3R("cle_s.d", 128,  72, w16, w13, w30);
   TEST_3R("cle_s.d", 136, 216, w17, w4,  w19);
   TEST_3R("cle_s.d", 144, 160, w18, w5,  w20);
   TEST_3R("cle_s.d", 152, 200, w19, w14, w1);
   TEST_3R("cle_s.d", 160,  80, w20, w24, w2);
   TEST_3R("cle_s.d", 168, 120, w21, w0,  w2);
   TEST_3R("cle_s.d", 176, 120, w22, w20, w29);
   TEST_3R("cle_s.d", 184, 152, w23, w11, w26);
   TEST_3R("cle_s.d", 192,  72, w24, w7,  w14);
   TEST_3R("cle_s.d", 200, 144, w25, w30, w23);
   TEST_3R("cle_s.d", 208,  88, w26, w30, w4);
   TEST_3R("cle_s.d", 216,  64, w27, w29, w9);
   TEST_3R("cle_s.d", 224, 144, w28, w24, w14);
   TEST_3R("cle_s.d", 232, 152, w29, w28, w28);
   TEST_3R("cle_s.d", 240, 176, w30, w8,  w5);
   TEST_3R("cle_s.d", 184, 192, w31, w10, w22);
   TEST_3R("cle_u.b",   0,  64, w0,  w20, w4);
   TEST_3R("cle_u.b",   8,  16, w1,  w27, w18);
   TEST_3R("cle_u.b",  16,  32, w2,  w25, w9);
   TEST_3R("cle_u.b",  24, 128, w3,  w23, w14);
   TEST_3R("cle_u.b",  32, 192, w4,  w21, w23);
   TEST_3R("cle_u.b",  40,  24, w5,  w13, w11);
   TEST_3R("cle_u.b",  48, 104, w6,  w2,  w19);
   TEST_3R("cle_u.b",  56, 144, w7,  w22, w30);
   TEST_3R("cle_u.b",  64, 192, w8,  w11, w4);
   TEST_3R("cle_u.b",  72,  88, w9,  w9,  w21);
   TEST_3R("cle_u.b",  80,  40, w10, w9,  w10);
   TEST_3R("cle_u.b",  88, 232, w11, w30, w4);
   TEST_3R("cle_u.b",  96, 128, w12, w16, w30);
   TEST_3R("cle_u.b", 104, 144, w13, w2,  w21);
   TEST_3R("cle_u.b", 112,  56, w14, w20, w10);
   TEST_3R("cle_u.b", 120,   8, w15, w24, w23);
   TEST_3R("cle_u.b", 128,   0, w16, w3,  w1);
   TEST_3R("cle_u.b", 136,  56, w17, w22, w16);
   TEST_3R("cle_u.b", 144, 176, w18, w20, w21);
   TEST_3R("cle_u.b", 152,   8, w19, w31, w25);
   TEST_3R("cle_u.b", 160, 232, w20, w21, w1);
   TEST_3R("cle_u.b", 168, 232, w21, w20, w5);
   TEST_3R("cle_u.b", 176, 232, w22, w4,  w3);
   TEST_3R("cle_u.b", 184, 144, w23, w6,  w25);
   TEST_3R("cle_u.b", 192, 208, w24, w26, w26);
   TEST_3R("cle_u.b", 200, 120, w25, w11, w18);
   TEST_3R("cle_u.b", 208,  56, w26, w10, w21);
   TEST_3R("cle_u.b", 216,   0, w27, w12, w4);
   TEST_3R("cle_u.b", 224, 208, w28, w1,  w7);
   TEST_3R("cle_u.b", 232,  48, w29, w26, w31);
   TEST_3R("cle_u.b", 240, 160, w30, w15, w0);
   TEST_3R("cle_u.b",  64,  32, w31, w31, w31);
   TEST_3R("cle_u.h",   0,  24, w0,  w27, w7);
   TEST_3R("cle_u.h",   8,  80, w1,  w9,  w14);
   TEST_3R("cle_u.h",  16, 160, w2,  w26, w8);
   TEST_3R("cle_u.h",  24,  48, w3,  w5,  w27);
   TEST_3R("cle_u.h",  32, 104, w4,  w15, w16);
   TEST_3R("cle_u.h",  40,  88, w5,  w27, w28);
   TEST_3R("cle_u.h",  48,   8, w6,  w31, w29);
   TEST_3R("cle_u.h",  56,  80, w7,  w29, w4);
   TEST_3R("cle_u.h",  64, 128, w8,  w17, w19);
   TEST_3R("cle_u.h",  72, 224, w9,  w9,  w19);
   TEST_3R("cle_u.h",  80,  24, w10, w13, w10);
   TEST_3R("cle_u.h",  88,  48, w11, w30, w22);
   TEST_3R("cle_u.h",  96, 112, w12, w25, w17);
   TEST_3R("cle_u.h", 104, 176, w13, w31, w22);
   TEST_3R("cle_u.h", 112, 128, w14, w0,  w6);
   TEST_3R("cle_u.h", 120, 184, w15, w29, w1);
   TEST_3R("cle_u.h", 128, 136, w16, w6,  w1);
   TEST_3R("cle_u.h", 136,  32, w17, w16, w8);
   TEST_3R("cle_u.h", 144, 232, w18, w20, w14);
   TEST_3R("cle_u.h", 152, 104, w19, w7,  w21);
   TEST_3R("cle_u.h", 160,   8, w20, w30, w2);
   TEST_3R("cle_u.h", 168,  64, w21, w29, w25);
   TEST_3R("cle_u.h", 176, 160, w22, w9,  w18);
   TEST_3R("cle_u.h", 184,  24, w23, w30, w17);
   TEST_3R("cle_u.h", 192,  64, w24, w14, w14);
   TEST_3R("cle_u.h", 200,  72, w25, w16, w15);
   TEST_3R("cle_u.h", 208, 160, w26, w17, w12);
   TEST_3R("cle_u.h", 216,  16, w27, w18, w6);
   TEST_3R("cle_u.h", 224, 168, w28, w26, w29);
   TEST_3R("cle_u.h", 232,  24, w29, w9,  w5);
   TEST_3R("cle_u.h", 240, 168, w30, w1,  w12);
   TEST_3R("cle_u.h",  56,  40, w31, w31, w31);
   TEST_3R("cle_u.w",   0, 224, w0,  w4,  w12);
   TEST_3R("cle_u.w",   8,   8, w1,  w3,  w29);
   TEST_3R("cle_u.w",  16, 216, w2,  w17, w14);
   TEST_3R("cle_u.w",  24, 184, w3,  w0,  w28);
   TEST_3R("cle_u.w",  32, 200, w4,  w12, w16);
   TEST_3R("cle_u.w",  40,  56, w5,  w18, w20);
   TEST_3R("cle_u.w",  48, 176, w6,  w15, w12);
   TEST_3R("cle_u.w",  56,  96, w7,  w21, w11);
   TEST_3R("cle_u.w",  64,  16, w8,  w22, w9);
   TEST_3R("cle_u.w",  72, 192, w9,  w9,  w2);
   TEST_3R("cle_u.w",  80,  32, w10, w28, w10);
   TEST_3R("cle_u.w",  88,  16, w11, w9,  w8);
   TEST_3R("cle_u.w",  96, 200, w12, w5,  w29);
   TEST_3R("cle_u.w", 104, 216, w13, w19, w25);
   TEST_3R("cle_u.w", 112,  88, w14, w15, w6);
   TEST_3R("cle_u.w", 120, 168, w15, w31, w5);
   TEST_3R("cle_u.w", 128,  24, w16, w19, w31);
   TEST_3R("cle_u.w", 136, 128, w17, w31, w2);
   TEST_3R("cle_u.w", 144, 216, w18, w11, w4);
   TEST_3R("cle_u.w", 152, 184, w19, w20, w6);
   TEST_3R("cle_u.w", 160,  88, w20, w25, w3);
   TEST_3R("cle_u.w", 168, 104, w21, w2,  w11);
   TEST_3R("cle_u.w", 176, 120, w22, w14, w17);
   TEST_3R("cle_u.w", 184,   0, w23, w11, w4);
   TEST_3R("cle_u.w", 192, 224, w24, w9,  w9);
   TEST_3R("cle_u.w", 200, 200, w25, w20, w19);
   TEST_3R("cle_u.w", 208,  40, w26, w17, w7);
   TEST_3R("cle_u.w", 216, 176, w27, w29, w6);
   TEST_3R("cle_u.w", 224,  32, w28, w31, w17);
   TEST_3R("cle_u.w", 232, 152, w29, w23, w6);
   TEST_3R("cle_u.w", 240, 200, w30, w17, w31);
   TEST_3R("cle_u.w", 128, 184, w31, w31, w31);
   TEST_3R("cle_u.d",   0,  72, w0,  w26, w25);
   TEST_3R("cle_u.d",   8, 232, w1,  w11, w20);
   TEST_3R("cle_u.d",  16,   0, w2,  w15, w7);
   TEST_3R("cle_u.d",  24, 176, w3,  w1,  w24);
   TEST_3R("cle_u.d",  32,   8, w4,  w0,  w9);
   TEST_3R("cle_u.d",  40, 224, w5,  w30, w6);
   TEST_3R("cle_u.d",  48, 128, w6,  w31, w5);
   TEST_3R("cle_u.d",  56, 104, w7,  w4,  w28);
   TEST_3R("cle_u.d",  64, 232, w8,  w16, w14);
   TEST_3R("cle_u.d",  72,  56, w9,  w9,  w30);
   TEST_3R("cle_u.d",  80, 232, w10, w28, w10);
   TEST_3R("cle_u.d",  88,  24, w11, w4,  w3);
   TEST_3R("cle_u.d",  96, 184, w12, w5,  w19);
   TEST_3R("cle_u.d", 104, 176, w13, w9,  w22);
   TEST_3R("cle_u.d", 112,   0, w14, w1,  w13);
   TEST_3R("cle_u.d", 120, 104, w15, w10, w11);
   TEST_3R("cle_u.d", 128, 224, w16, w17, w30);
   TEST_3R("cle_u.d", 136, 128, w17, w6,  w3);
   TEST_3R("cle_u.d", 144, 128, w18, w2,  w19);
   TEST_3R("cle_u.d", 152,  56, w19, w29, w17);
   TEST_3R("cle_u.d", 160, 152, w20, w25, w10);
   TEST_3R("cle_u.d", 168, 176, w21, w4,  w13);
   TEST_3R("cle_u.d", 176, 128, w22, w9,  w0);
   TEST_3R("cle_u.d", 184, 112, w23, w19, w7);
   TEST_3R("cle_u.d", 192, 184, w24, w4,  w4);
   TEST_3R("cle_u.d", 200, 160, w25, w31, w16);
   TEST_3R("cle_u.d", 208, 192, w26, w16, w0);
   TEST_3R("cle_u.d", 216,  40, w27, w6,  w8);
   TEST_3R("cle_u.d", 224,  40, w28, w8,  w27);
   TEST_3R("cle_u.d", 232,  96, w29, w5,  w13);
   TEST_3R("cle_u.d", 240, 144, w30, w23, w21);
   TEST_3R("cle_u.d",  72,  48, w31, w31, w31);
   TEST_3R("clt_s.b",   0,  64, w0,  w28, w11);
   TEST_3R("clt_s.b",   8, 112, w1,  w0,  w19);
   TEST_3R("clt_s.b",  16,  32, w2,  w16, w26);
   TEST_3R("clt_s.b",  24,  56, w3,  w16, w0);
   TEST_3R("clt_s.b",  32,   8, w4,  w22, w4);
   TEST_3R("clt_s.b",  40,   8, w5,  w5,  w2);
   TEST_3R("clt_s.b",  48, 128, w6,  w4,  w28);
   TEST_3R("clt_s.b",  56,  96, w7,  w17, w2);
   TEST_3R("clt_s.b",  64, 200, w8,  w24, w3);
   TEST_3R("clt_s.b",  72,  96, w9,  w21, w15);
   TEST_3R("clt_s.b",  80, 120, w10, w25, w13);
   TEST_3R("clt_s.b",  88, 192, w11, w11, w11);
   TEST_3R("clt_s.b",  96,  40, w12, w0,  w14);
   TEST_3R("clt_s.b", 104,  48, w13, w18, w30);
   TEST_3R("clt_s.b", 112,  16, w14, w20, w15);
   TEST_3R("clt_s.b", 120, 136, w15, w29, w5);
   TEST_3R("clt_s.b", 128, 136, w16, w31, w4);
   TEST_3R("clt_s.b", 136, 160, w17, w27, w7);
   TEST_3R("clt_s.b", 144,  72, w18, w30, w9);
   TEST_3R("clt_s.b", 152,  32, w19, w22, w12);
   TEST_3R("clt_s.b", 160,   0, w20, w11, w27);
   TEST_3R("clt_s.b", 168,   0, w21, w4,  w9);
   TEST_3R("clt_s.b", 176, 176, w22, w8,  w9);
   TEST_3R("clt_s.b", 184,  64, w23, w0,  w28);
   TEST_3R("clt_s.b", 192,  40, w24, w19, w16);
   TEST_3R("clt_s.b", 200, 144, w25, w5,  w13);
   TEST_3R("clt_s.b", 208,  24, w26, w0,  w12);
   TEST_3R("clt_s.b", 216, 144, w27, w31, w8);
   TEST_3R("clt_s.b", 224, 232, w28, w15, w6);
   TEST_3R("clt_s.b", 232,  80, w29, w7,  w28);
   TEST_3R("clt_s.b", 240, 144, w30, w12, w12);
   TEST_3R("clt_s.b", 152, 136, w31, w1,  w2);
   TEST_3R("clt_s.h",   0, 144, w0,  w5,  w19);
   TEST_3R("clt_s.h",   8, 168, w1,  w23, w20);
   TEST_3R("clt_s.h",  16, 128, w2,  w7,  w0);
   TEST_3R("clt_s.h",  24, 152, w3,  w12, w13);
   TEST_3R("clt_s.h",  32,   8, w4,  w13, w4);
   TEST_3R("clt_s.h",  40, 104, w5,  w5,  w19);
   TEST_3R("clt_s.h",  48, 216, w6,  w2,  w3);
   TEST_3R("clt_s.h",  56,  32, w7,  w8,  w28);
   TEST_3R("clt_s.h",  64, 120, w8,  w4,  w1);
   TEST_3R("clt_s.h",  72,  96, w9,  w11, w2);
   TEST_3R("clt_s.h",  80,  64, w10, w22, w12);
   TEST_3R("clt_s.h",  88,  88, w11, w11, w11);
   TEST_3R("clt_s.h",  96,   8, w12, w0,  w14);
   TEST_3R("clt_s.h", 104,  80, w13, w15, w21);
   TEST_3R("clt_s.h", 112, 176, w14, w15, w27);
   TEST_3R("clt_s.h", 120, 200, w15, w29, w5);
   TEST_3R("clt_s.h", 128, 184, w16, w23, w24);
   TEST_3R("clt_s.h", 136,  32, w17, w25, w27);
   TEST_3R("clt_s.h", 144,  72, w18, w1,  w23);
   TEST_3R("clt_s.h", 152, 200, w19, w5,  w25);
   TEST_3R("clt_s.h", 160,  56, w20, w16, w27);
   TEST_3R("clt_s.h", 168,   0, w21, w6,  w8);
   TEST_3R("clt_s.h", 176,  96, w22, w15, w8);
   TEST_3R("clt_s.h", 184, 144, w23, w13, w5);
   TEST_3R("clt_s.h", 192,  80, w24, w7,  w0);
   TEST_3R("clt_s.h", 200,  48, w25, w4,  w5);
   TEST_3R("clt_s.h", 208, 232, w26, w27, w30);
   TEST_3R("clt_s.h", 216,  32, w27, w20, w25);
   TEST_3R("clt_s.h", 224, 104, w28, w21, w17);
   TEST_3R("clt_s.h", 232, 176, w29, w26, w10);
   TEST_3R("clt_s.h", 240, 192, w30, w10, w10);
   TEST_3R("clt_s.h", 112, 104, w31, w0,  w16);
   TEST_3R("clt_s.w",   0, 208, w0,  w31, w21);
   TEST_3R("clt_s.w",   8, 224, w1,  w12, w13);
   TEST_3R("clt_s.w",  16, 192, w2,  w30, w20);
   TEST_3R("clt_s.w",  24,  24, w3,  w0,  w24);
   TEST_3R("clt_s.w",  32, 192, w4,  w1,  w4);
   TEST_3R("clt_s.w",  40,   8, w5,  w5,  w26);
   TEST_3R("clt_s.w",  48,  40, w6,  w7,  w20);
   TEST_3R("clt_s.w",  56,  24, w7,  w28, w5);
   TEST_3R("clt_s.w",  64, 200, w8,  w22, w15);
   TEST_3R("clt_s.w",  72,  72, w9,  w0,  w20);
   TEST_3R("clt_s.w",  80, 192, w10, w16, w2);
   TEST_3R("clt_s.w",  88, 184, w11, w11, w11);
   TEST_3R("clt_s.w",  96,  56, w12, w23, w2);
   TEST_3R("clt_s.w", 104,  72, w13, w4,  w25);
   TEST_3R("clt_s.w", 112,  40, w14, w24, w16);
   TEST_3R("clt_s.w", 120,  56, w15, w16, w12);
   TEST_3R("clt_s.w", 128,  64, w16, w3,  w7);
   TEST_3R("clt_s.w", 136, 112, w17, w10, w27);
   TEST_3R("clt_s.w", 144,   8, w18, w6,  w0);
   TEST_3R("clt_s.w", 152, 216, w19, w28, w15);
   TEST_3R("clt_s.w", 160,  56, w20, w28, w3);
   TEST_3R("clt_s.w", 168, 120, w21, w12, w5);
   TEST_3R("clt_s.w", 176, 152, w22, w28, w29);
   TEST_3R("clt_s.w", 184, 176, w23, w24, w1);
   TEST_3R("clt_s.w", 192, 160, w24, w18, w26);
   TEST_3R("clt_s.w", 200,  48, w25, w12, w10);
   TEST_3R("clt_s.w", 208,  56, w26, w8,  w14);
   TEST_3R("clt_s.w", 216, 128, w27, w15, w24);
   TEST_3R("clt_s.w", 224,  32, w28, w20, w31);
   TEST_3R("clt_s.w", 232, 160, w29, w18, w27);
   TEST_3R("clt_s.w", 240,   0, w30, w24, w24);
   TEST_3R("clt_s.w", 144,   8, w31, w24, w4);
   TEST_3R("clt_s.d",   0,  72, w0,  w24, w14);
   TEST_3R("clt_s.d",   8, 136, w1,  w26, w19);
   TEST_3R("clt_s.d",  16,   0, w2,  w20, w8);
   TEST_3R("clt_s.d",  24, 168, w3,  w30, w10);
   TEST_3R("clt_s.d",  32,   0, w4,  w12, w4);
   TEST_3R("clt_s.d",  40,  16, w5,  w5,  w14);
   TEST_3R("clt_s.d",  48,   0, w6,  w22, w3);
   TEST_3R("clt_s.d",  56, 152, w7,  w25, w21);
   TEST_3R("clt_s.d",  64, 160, w8,  w12, w20);
   TEST_3R("clt_s.d",  72, 168, w9,  w2,  w12);
   TEST_3R("clt_s.d",  80, 120, w10, w29, w15);
   TEST_3R("clt_s.d",  88, 192, w11, w11, w11);
   TEST_3R("clt_s.d",  96, 160, w12, w29, w21);
   TEST_3R("clt_s.d", 104, 192, w13, w17, w31);
   TEST_3R("clt_s.d", 112,  80, w14, w25, w22);
   TEST_3R("clt_s.d", 120, 120, w15, w3,  w21);
   TEST_3R("clt_s.d", 128,  16, w16, w22, w4);
   TEST_3R("clt_s.d", 136,  24, w17, w12, w7);
   TEST_3R("clt_s.d", 144, 176, w18, w5,  w28);
   TEST_3R("clt_s.d", 152, 216, w19, w17, w16);
   TEST_3R("clt_s.d", 160, 152, w20, w19, w29);
   TEST_3R("clt_s.d", 168, 144, w21, w17, w12);
   TEST_3R("clt_s.d", 176, 104, w22, w7,  w9);
   TEST_3R("clt_s.d", 184,  56, w23, w26, w28);
   TEST_3R("clt_s.d", 192, 136, w24, w20, w18);
   TEST_3R("clt_s.d", 200, 136, w25, w23, w8);
   TEST_3R("clt_s.d", 208, 160, w26, w13, w12);
   TEST_3R("clt_s.d", 216, 184, w27, w25, w19);
   TEST_3R("clt_s.d", 224,   0, w28, w31, w15);
   TEST_3R("clt_s.d", 232, 216, w29, w16, w0);
   TEST_3R("clt_s.d", 240,  24, w30, w4,  w4);
   TEST_3R("clt_s.d", 160, 152, w31, w10, w21);
   TEST_3R("clt_u.b",   0, 120, w0,  w13, w10);
   TEST_3R("clt_u.b",   8, 232, w1,  w28, w11);
   TEST_3R("clt_u.b",  16, 112, w2,  w4,  w24);
   TEST_3R("clt_u.b",  24,  56, w3,  w16, w24);
   TEST_3R("clt_u.b",  32, 104, w4,  w3,  w17);
   TEST_3R("clt_u.b",  40,  88, w5,  w19, w1);
   TEST_3R("clt_u.b",  48, 224, w6,  w19, w0);
   TEST_3R("clt_u.b",  56, 232, w7,  w16, w10);
   TEST_3R("clt_u.b",  64,  64, w8,  w25, w27);
   TEST_3R("clt_u.b",  72,  88, w9,  w11, w23);
   TEST_3R("clt_u.b",  80, 120, w10, w19, w5);
   TEST_3R("clt_u.b",  88, 160, w11, w16, w18);
   TEST_3R("clt_u.b",  96,  48, w12, w8,  w24);
   TEST_3R("clt_u.b", 104,  40, w13, w1,  w23);
   TEST_3R("clt_u.b", 112,  16, w14, w18, w14);
   TEST_3R("clt_u.b", 120, 224, w15, w27, w19);
   TEST_3R("clt_u.b", 128, 216, w16, w14, w19);
   TEST_3R("clt_u.b", 136,  80, w17, w30, w29);
   TEST_3R("clt_u.b", 144,  24, w18, w18, w23);
   TEST_3R("clt_u.b", 152,  48, w19, w4,  w4);
   TEST_3R("clt_u.b", 160,   8, w20, w2,  w27);
   TEST_3R("clt_u.b", 168,  80, w21, w0,  w5);
   TEST_3R("clt_u.b", 176,  24, w22, w7,  w26);
   TEST_3R("clt_u.b", 184, 128, w23, w31, w26);
   TEST_3R("clt_u.b", 192, 152, w24, w7,  w12);
   TEST_3R("clt_u.b", 200, 144, w25, w3,  w31);
   TEST_3R("clt_u.b", 208, 232, w26, w17, w18);
   TEST_3R("clt_u.b", 216, 184, w27, w16, w15);
   TEST_3R("clt_u.b", 224,  48, w28, w28, w28);
   TEST_3R("clt_u.b", 232, 104, w29, w7,  w13);
   TEST_3R("clt_u.b", 240, 112, w30, w9,  w8);
   TEST_3R("clt_u.b", 232, 192, w31, w8,  w27);
   TEST_3R("clt_u.h",   0, 128, w0,  w2,  w30);
   TEST_3R("clt_u.h",   8,  96, w1,  w29, w12);
   TEST_3R("clt_u.h",  16,  16, w2,  w5,  w24);
   TEST_3R("clt_u.h",  24,  32, w3,  w8,  w23);
   TEST_3R("clt_u.h",  32, 136, w4,  w25, w9);
   TEST_3R("clt_u.h",  40, 200, w5,  w9,  w24);
   TEST_3R("clt_u.h",  48,  32, w6,  w17, w31);
   TEST_3R("clt_u.h",  56,  24, w7,  w27, w9);
   TEST_3R("clt_u.h",  64,  56, w8,  w1,  w7);
   TEST_3R("clt_u.h",  72,  56, w9,  w12, w0);
   TEST_3R("clt_u.h",  80,  24, w10, w11, w18);
   TEST_3R("clt_u.h",  88, 128, w11, w8,  w30);
   TEST_3R("clt_u.h",  96,  24, w12, w13, w22);
   TEST_3R("clt_u.h", 104, 216, w13, w21, w16);
   TEST_3R("clt_u.h", 112, 184, w14, w22, w14);
   TEST_3R("clt_u.h", 120, 152, w15, w24, w14);
   TEST_3R("clt_u.h", 128, 184, w16, w9,  w13);
   TEST_3R("clt_u.h", 136,  88, w17, w5,  w22);
   TEST_3R("clt_u.h", 144, 184, w18, w18, w6);
   TEST_3R("clt_u.h", 152,  56, w19, w3,  w3);
   TEST_3R("clt_u.h", 160,  64, w20, w19, w1);
   TEST_3R("clt_u.h", 168,  88, w21, w5,  w1);
   TEST_3R("clt_u.h", 176, 152, w22, w3,  w24);
   TEST_3R("clt_u.h", 184,  48, w23, w25, w19);
   TEST_3R("clt_u.h", 192, 144, w24, w6,  w3);
   TEST_3R("clt_u.h", 200,  24, w25, w28, w19);
   TEST_3R("clt_u.h", 208, 112, w26, w10, w11);
   TEST_3R("clt_u.h", 216, 144, w27, w24, w25);
   TEST_3R("clt_u.h", 224,  88, w28, w28, w28);
   TEST_3R("clt_u.h", 232,  40, w29, w5,  w30);
   TEST_3R("clt_u.h", 240, 104, w30, w25, w1);
   TEST_3R("clt_u.h", 192,  40, w31, w12, w2);
   TEST_3R("clt_u.w",   0,  32, w0,  w3,  w12);
   TEST_3R("clt_u.w",   8,  72, w1,  w27, w24);
   TEST_3R("clt_u.w",  16,  16, w2,  w14, w26);
   TEST_3R("clt_u.w",  24, 160, w3,  w18, w10);
   TEST_3R("clt_u.w",  32,  56, w4,  w5,  w19);
   TEST_3R("clt_u.w",  40,   0, w5,  w16, w6);
   TEST_3R("clt_u.w",  48,  96, w6,  w9,  w29);
   TEST_3R("clt_u.w",  56, 144, w7,  w14, w27);
   TEST_3R("clt_u.w",  64, 120, w8,  w7,  w28);
   TEST_3R("clt_u.w",  72, 160, w9,  w20, w31);
   TEST_3R("clt_u.w",  80, 176, w10, w6,  w2);
   TEST_3R("clt_u.w",  88, 216, w11, w27, w30);
   TEST_3R("clt_u.w",  96,  48, w12, w10, w21);
   TEST_3R("clt_u.w", 104, 208, w13, w30, w31);
   TEST_3R("clt_u.w", 112,  64, w14, w3,  w14);
   TEST_3R("clt_u.w", 120,  72, w15, w14, w19);
   TEST_3R("clt_u.w", 128,  96, w16, w3,  w28);
   TEST_3R("clt_u.w", 136,  16, w17, w6,  w11);
   TEST_3R("clt_u.w", 144, 128, w18, w18, w22);
   TEST_3R("clt_u.w", 152,   8, w19, w14, w14);
   TEST_3R("clt_u.w", 160,  48, w20, w6,  w13);
   TEST_3R("clt_u.w", 168,  96, w21, w12, w16);
   TEST_3R("clt_u.w", 176,  80, w22, w8,  w14);
   TEST_3R("clt_u.w", 184,  16, w23, w18, w26);
   TEST_3R("clt_u.w", 192, 192, w24, w18, w25);
   TEST_3R("clt_u.w", 200, 136, w25, w4,  w28);
   TEST_3R("clt_u.w", 208,  80, w26, w19, w16);
   TEST_3R("clt_u.w", 216, 184, w27, w22, w12);
   TEST_3R("clt_u.w", 224,  40, w28, w28, w28);
   TEST_3R("clt_u.w", 232, 176, w29, w23, w26);
   TEST_3R("clt_u.w", 240,  64, w30, w10, w9);
   TEST_3R("clt_u.w",  24, 112, w31, w16, w22);
   TEST_3R("clt_u.d",   0,  96, w0,  w6,  w26);
   TEST_3R("clt_u.d",   8, 192, w1,  w20, w12);
   TEST_3R("clt_u.d",  16, 104, w2,  w15, w18);
   TEST_3R("clt_u.d",  24,  88, w3,  w8,  w24);
   TEST_3R("clt_u.d",  32, 224, w4,  w17, w1);
   TEST_3R("clt_u.d",  40,  32, w5,  w3,  w23);
   TEST_3R("clt_u.d",  48,  56, w6,  w12, w19);
   TEST_3R("clt_u.d",  56,  96, w7,  w6,  w5);
   TEST_3R("clt_u.d",  64, 112, w8,  w15, w21);
   TEST_3R("clt_u.d",  72,  16, w9,  w6,  w25);
   TEST_3R("clt_u.d",  80, 112, w10, w12, w20);
   TEST_3R("clt_u.d",  88, 184, w11, w1,  w0);
   TEST_3R("clt_u.d",  96,  48, w12, w16, w18);
   TEST_3R("clt_u.d", 104,  16, w13, w24, w11);
   TEST_3R("clt_u.d", 112,  56, w14, w28, w14);
   TEST_3R("clt_u.d", 120, 176, w15, w6,  w17);
   TEST_3R("clt_u.d", 128, 104, w16, w30, w18);
   TEST_3R("clt_u.d", 136,  64, w17, w10, w18);
   TEST_3R("clt_u.d", 144,  48, w18, w18, w13);
   TEST_3R("clt_u.d", 152, 144, w19, w12, w12);
   TEST_3R("clt_u.d", 160, 160, w20, w8,  w6);
   TEST_3R("clt_u.d", 168, 144, w21, w20, w26);
   TEST_3R("clt_u.d", 176,  96, w22, w21, w26);
   TEST_3R("clt_u.d", 184,  24, w23, w5,  w12);
   TEST_3R("clt_u.d", 192,  40, w24, w29, w23);
   TEST_3R("clt_u.d", 200, 160, w25, w26, w20);
   TEST_3R("clt_u.d", 208,  64, w26, w11, w20);
   TEST_3R("clt_u.d", 216, 144, w27, w29, w0);
   TEST_3R("clt_u.d", 224,  80, w28, w28, w28);
   TEST_3R("clt_u.d", 232, 112, w29, w18, w26);
   TEST_3R("clt_u.d", 240,  16, w30, w20, w6);
   TEST_3R("clt_u.d",  48,  48, w31, w28, w12);
   TEST_COP1("bnz.b",  48, w0);
   TEST_COP1("bnz.b",  56, w1);
   TEST_COP1("bnz.b",  64, w2);
   TEST_COP1("bnz.b",  72, w3);
   TEST_COP1("bnz.b",  80, w4);
   TEST_COP1("bnz.b",  88, w5);
   TEST_COP1("bnz.b",  96, w6);
   TEST_COP1("bnz.b", 104, w7);
   TEST_COP1("bnz.b", 112, w8);
   TEST_COP1("bnz.b", 120, w9);
   TEST_COP1("bnz.b", 128, w10);
   TEST_COP1("bnz.b", 136, w11);
   TEST_COP1("bnz.b", 144, w12);
   TEST_COP1("bnz.b", 152, w13);
   TEST_COP1("bnz.b", 160, w14);
   TEST_COP1("bnz.b", 168, w15);
   TEST_COP1("bnz.b", 176, w16);
   TEST_COP1("bnz.b", 184, w17);
   TEST_COP1("bnz.b", 192, w18);
   TEST_COP1("bnz.b", 200, w19);
   TEST_COP1("bnz.b", 208, w20);
   TEST_COP1("bnz.b", 216, w21);
   TEST_COP1("bnz.b", 224, w22);
   TEST_COP1("bnz.b", 232, w23);
   TEST_COP1("bnz.b", 240, w24);
   TEST_COP1("bnz.b",  16, w25);
   TEST_COP1("bnz.b",   0, w26);
   TEST_COP1("bnz.b",   8, w27);
   TEST_COP1("bnz.b",  16, w28);
   TEST_COP1("bnz.b",  24, w29);
   TEST_COP1("bnz.b",  32, w30);
   TEST_COP1("bnz.b", 216, w31);
   TEST_COP1("bnz.h",  48, w0);
   TEST_COP1("bnz.h",  56, w1);
   TEST_COP1("bnz.h",  64, w2);
   TEST_COP1("bnz.h",  72, w3);
   TEST_COP1("bnz.h",  80, w4);
   TEST_COP1("bnz.h",  88, w5);
   TEST_COP1("bnz.h",  96, w6);
   TEST_COP1("bnz.h", 104, w7);
   TEST_COP1("bnz.h", 112, w8);
   TEST_COP1("bnz.h", 120, w9);
   TEST_COP1("bnz.h", 128, w10);
   TEST_COP1("bnz.h", 136, w11);
   TEST_COP1("bnz.h", 144, w12);
   TEST_COP1("bnz.h", 152, w13);
   TEST_COP1("bnz.h", 160, w14);
   TEST_COP1("bnz.h", 168, w15);
   TEST_COP1("bnz.h", 176, w16);
   TEST_COP1("bnz.h", 184, w17);
   TEST_COP1("bnz.h", 192, w18);
   TEST_COP1("bnz.h", 200, w19);
   TEST_COP1("bnz.h", 208, w20);
   TEST_COP1("bnz.h", 216, w21);
   TEST_COP1("bnz.h", 224, w22);
   TEST_COP1("bnz.h", 232, w23);
   TEST_COP1("bnz.h", 240, w24);
   TEST_COP1("bnz.h",  16, w25);
   TEST_COP1("bnz.h",   0, w26);
   TEST_COP1("bnz.h",   8, w27);
   TEST_COP1("bnz.h",  16, w28);
   TEST_COP1("bnz.h",  24, w29);
   TEST_COP1("bnz.h",  32, w30);
   TEST_COP1("bnz.h",  24, w31);
   TEST_COP1("bnz.w",  48, w0);
   TEST_COP1("bnz.w",  56, w1);
   TEST_COP1("bnz.w",  64, w2);
   TEST_COP1("bnz.w",  72, w3);
   TEST_COP1("bnz.w",  80, w4);
   TEST_COP1("bnz.w",  88, w5);
   TEST_COP1("bnz.w",  96, w6);
   TEST_COP1("bnz.w", 104, w7);
   TEST_COP1("bnz.w", 112, w8);
   TEST_COP1("bnz.w", 120, w9);
   TEST_COP1("bnz.w", 128, w10);
   TEST_COP1("bnz.w", 136, w11);
   TEST_COP1("bnz.w", 144, w12);
   TEST_COP1("bnz.w", 152, w13);
   TEST_COP1("bnz.w", 160, w14);
   TEST_COP1("bnz.w", 168, w15);
   TEST_COP1("bnz.w", 176, w16);
   TEST_COP1("bnz.w", 184, w17);
   TEST_COP1("bnz.w", 192, w18);
   TEST_COP1("bnz.w", 200, w19);
   TEST_COP1("bnz.w", 208, w20);
   TEST_COP1("bnz.w", 216, w21);
   TEST_COP1("bnz.w", 224, w22);
   TEST_COP1("bnz.w", 232, w23);
   TEST_COP1("bnz.w", 240, w24);
   TEST_COP1("bnz.w",  16, w25);
   TEST_COP1("bnz.w",   0, w26);
   TEST_COP1("bnz.w",   8, w27);
   TEST_COP1("bnz.w",  16, w28);
   TEST_COP1("bnz.w",  24, w29);
   TEST_COP1("bnz.w",  32, w30);
   TEST_COP1("bnz.w",  64, w31);
   TEST_COP1("bnz.d",  48, w0);
   TEST_COP1("bnz.d",  56, w1);
   TEST_COP1("bnz.d",  64, w2);
   TEST_COP1("bnz.d",  72, w3);
   TEST_COP1("bnz.d",  80, w4);
   TEST_COP1("bnz.d",  88, w5);
   TEST_COP1("bnz.d",  96, w6);
   TEST_COP1("bnz.d", 104, w7);
   TEST_COP1("bnz.d", 112, w8);
   TEST_COP1("bnz.d", 120, w9);
   TEST_COP1("bnz.d", 128, w10);
   TEST_COP1("bnz.d", 136, w11);
   TEST_COP1("bnz.d", 144, w12);
   TEST_COP1("bnz.d", 152, w13);
   TEST_COP1("bnz.d", 160, w14);
   TEST_COP1("bnz.d", 168, w15);
   TEST_COP1("bnz.d", 176, w16);
   TEST_COP1("bnz.d", 184, w17);
   TEST_COP1("bnz.d", 192, w18);
   TEST_COP1("bnz.d", 200, w19);
   TEST_COP1("bnz.d", 208, w20);
   TEST_COP1("bnz.d", 216, w21);
   TEST_COP1("bnz.d", 224, w22);
   TEST_COP1("bnz.d", 232, w23);
   TEST_COP1("bnz.d", 240, w24);
   TEST_COP1("bnz.d",  16, w25);
   TEST_COP1("bnz.d",   0, w26);
   TEST_COP1("bnz.d",   8, w27);
   TEST_COP1("bnz.d",  16, w28);
   TEST_COP1("bnz.d",  24, w29);
   TEST_COP1("bnz.d",  32, w30);
   TEST_COP1("bnz.d",  56, w31);
   TEST_COP1("bnz.v",   0, w0);
   TEST_COP1("bnz.v",   8, w1);
   TEST_COP1("bnz.v",  16, w2);
   TEST_COP1("bnz.v",  24, w3);
   TEST_COP1("bnz.v",  32, w4);
   TEST_COP1("bnz.v",  40, w5);
   TEST_COP1("bnz.v",  48, w6);
   TEST_COP1("bnz.v",  56, w7);
   TEST_COP1("bnz.v",  64, w8);
   TEST_COP1("bnz.v",  72, w9);
   TEST_COP1("bnz.v",  80, w10);
   TEST_COP1("bnz.v",  88, w11);
   TEST_COP1("bnz.v",  96, w12);
   TEST_COP1("bnz.v", 104, w13);
   TEST_COP1("bnz.v", 112, w14);
   TEST_COP1("bnz.v", 120, w15);
   TEST_COP1("bnz.v", 128, w16);
   TEST_COP1("bnz.v", 136, w17);
   TEST_COP1("bnz.v", 144, w18);
   TEST_COP1("bnz.v", 152, w19);
   TEST_COP1("bnz.v", 160, w20);
   TEST_COP1("bnz.v", 168, w21);
   TEST_COP1("bnz.v", 176, w22);
   TEST_COP1("bnz.v", 184, w23);
   TEST_COP1("bnz.v", 192, w24);
   TEST_COP1("bnz.v", 200, w25);
   TEST_COP1("bnz.v", 208, w26);
   TEST_COP1("bnz.v", 216, w27);
   TEST_COP1("bnz.v", 224, w28);
   TEST_COP1("bnz.v", 232, w29);
   TEST_COP1("bnz.v", 240, w30);
   TEST_COP1("bnz.v", 160, w31);
   TEST_COP1("bz.b", 128, w0);
   TEST_COP1("bz.b", 136, w1);
   TEST_COP1("bz.b", 144, w2);
   TEST_COP1("bz.b", 152, w3);
   TEST_COP1("bz.b", 160, w4);
   TEST_COP1("bz.b", 168, w5);
   TEST_COP1("bz.b", 176, w6);
   TEST_COP1("bz.b", 184, w7);
   TEST_COP1("bz.b", 192, w8);
   TEST_COP1("bz.b", 200, w9);
   TEST_COP1("bz.b", 208, w10);
   TEST_COP1("bz.b", 216, w11);
   TEST_COP1("bz.b", 224, w12);
   TEST_COP1("bz.b", 232, w13);
   TEST_COP1("bz.b", 240, w14);
   TEST_COP1("bz.b",  16, w15);
   TEST_COP1("bz.b",   0, w16);
   TEST_COP1("bz.b",   8, w17);
   TEST_COP1("bz.b",  16, w18);
   TEST_COP1("bz.b",  24, w19);
   TEST_COP1("bz.b",  32, w20);
   TEST_COP1("bz.b",  40, w21);
   TEST_COP1("bz.b",  48, w22);
   TEST_COP1("bz.b",  56, w23);
   TEST_COP1("bz.b",  64, w24);
   TEST_COP1("bz.b",  72, w25);
   TEST_COP1("bz.b",  80, w26);
   TEST_COP1("bz.b",  88, w27);
   TEST_COP1("bz.b",  96, w28);
   TEST_COP1("bz.b", 104, w29);
   TEST_COP1("bz.b", 112, w30);
   TEST_COP1("bz.b", 208, w31);
   TEST_COP1("bz.h", 128, w0);
   TEST_COP1("bz.h", 136, w1);
   TEST_COP1("bz.h", 144, w2);
   TEST_COP1("bz.h", 152, w3);
   TEST_COP1("bz.h", 160, w4);
   TEST_COP1("bz.h", 168, w5);
   TEST_COP1("bz.h", 176, w6);
   TEST_COP1("bz.h", 184, w7);
   TEST_COP1("bz.h", 192, w8);
   TEST_COP1("bz.h", 200, w9);
   TEST_COP1("bz.h", 208, w10);
   TEST_COP1("bz.h", 216, w11);
   TEST_COP1("bz.h", 224, w12);
   TEST_COP1("bz.h", 232, w13);
   TEST_COP1("bz.h", 240, w14);
   TEST_COP1("bz.h",  16, w15);
   TEST_COP1("bz.h",   0, w16);
   TEST_COP1("bz.h",   8, w17);
   TEST_COP1("bz.h",  16, w18);
   TEST_COP1("bz.h",  24, w19);
   TEST_COP1("bz.h",  32, w20);
   TEST_COP1("bz.h",  40, w21);
   TEST_COP1("bz.h",  48, w22);
   TEST_COP1("bz.h",  56, w23);
   TEST_COP1("bz.h",  64, w24);
   TEST_COP1("bz.h",  72, w25);
   TEST_COP1("bz.h",  80, w26);
   TEST_COP1("bz.h",  88, w27);
   TEST_COP1("bz.h",  96, w28);
   TEST_COP1("bz.h", 104, w29);
   TEST_COP1("bz.h", 112, w30);
   TEST_COP1("bz.h", 184, w31);
   TEST_COP1("bz.w", 128, w0);
   TEST_COP1("bz.w", 136, w1);
   TEST_COP1("bz.w", 144, w2);
   TEST_COP1("bz.w", 152, w3);
   TEST_COP1("bz.w", 160, w4);
   TEST_COP1("bz.w", 168, w5);
   TEST_COP1("bz.w", 176, w6);
   TEST_COP1("bz.w", 184, w7);
   TEST_COP1("bz.w", 192, w8);
   TEST_COP1("bz.w", 200, w9);
   TEST_COP1("bz.w", 208, w10);
   TEST_COP1("bz.w", 216, w11);
   TEST_COP1("bz.w", 224, w12);
   TEST_COP1("bz.w", 232, w13);
   TEST_COP1("bz.w", 240, w14);
   TEST_COP1("bz.w",  16, w15);
   TEST_COP1("bz.w",   0, w16);
   TEST_COP1("bz.w",   8, w17);
   TEST_COP1("bz.w",  16, w18);
   TEST_COP1("bz.w",  24, w19);
   TEST_COP1("bz.w",  32, w20);
   TEST_COP1("bz.w",  40, w21);
   TEST_COP1("bz.w",  48, w22);
   TEST_COP1("bz.w",  56, w23);
   TEST_COP1("bz.w",  64, w24);
   TEST_COP1("bz.w",  72, w25);
   TEST_COP1("bz.w",  80, w26);
   TEST_COP1("bz.w",  88, w27);
   TEST_COP1("bz.w",  96, w28);
   TEST_COP1("bz.w", 104, w29);
   TEST_COP1("bz.w", 112, w30);
   TEST_COP1("bz.w", 232, w31);
   TEST_COP1("bz.d", 128, w0);
   TEST_COP1("bz.d", 136, w1);
   TEST_COP1("bz.d", 144, w2);
   TEST_COP1("bz.d", 152, w3);
   TEST_COP1("bz.d", 160, w4);
   TEST_COP1("bz.d", 168, w5);
   TEST_COP1("bz.d", 176, w6);
   TEST_COP1("bz.d", 184, w7);
   TEST_COP1("bz.d", 192, w8);
   TEST_COP1("bz.d", 200, w9);
   TEST_COP1("bz.d", 208, w10);
   TEST_COP1("bz.d", 216, w11);
   TEST_COP1("bz.d", 224, w12);
   TEST_COP1("bz.d", 232, w13);
   TEST_COP1("bz.d", 240, w14);
   TEST_COP1("bz.d",  16, w15);
   TEST_COP1("bz.d",   0, w16);
   TEST_COP1("bz.d",   8, w17);
   TEST_COP1("bz.d",  16, w18);
   TEST_COP1("bz.d",  24, w19);
   TEST_COP1("bz.d",  32, w20);
   TEST_COP1("bz.d",  40, w21);
   TEST_COP1("bz.d",  48, w22);
   TEST_COP1("bz.d",  56, w23);
   TEST_COP1("bz.d",  64, w24);
   TEST_COP1("bz.d",  72, w25);
   TEST_COP1("bz.d",  80, w26);
   TEST_COP1("bz.d",  88, w27);
   TEST_COP1("bz.d",  96, w28);
   TEST_COP1("bz.d", 104, w29);
   TEST_COP1("bz.d", 112, w30);
   TEST_COP1("bz.d", 120, w31);
   TEST_COP1("bz.v",   0, w0);
   TEST_COP1("bz.v",   8, w1);
   TEST_COP1("bz.v",  16, w2);
   TEST_COP1("bz.v",  24, w3);
   TEST_COP1("bz.v",  32, w4);
   TEST_COP1("bz.v",  40, w5);
   TEST_COP1("bz.v",  48, w6);
   TEST_COP1("bz.v",  56, w7);
   TEST_COP1("bz.v",  64, w8);
   TEST_COP1("bz.v",  72, w9);
   TEST_COP1("bz.v",  80, w10);
   TEST_COP1("bz.v",  88, w11);
   TEST_COP1("bz.v",  96, w12);
   TEST_COP1("bz.v", 104, w13);
   TEST_COP1("bz.v", 112, w14);
   TEST_COP1("bz.v", 120, w15);
   TEST_COP1("bz.v", 128, w16);
   TEST_COP1("bz.v", 136, w17);
   TEST_COP1("bz.v", 144, w18);
   TEST_COP1("bz.v", 152, w19);
   TEST_COP1("bz.v", 160, w20);
   TEST_COP1("bz.v", 168, w21);
   TEST_COP1("bz.v", 176, w22);
   TEST_COP1("bz.v", 184, w23);
   TEST_COP1("bz.v", 192, w24);
   TEST_COP1("bz.v", 200, w25);
   TEST_COP1("bz.v", 208, w26);
   TEST_COP1("bz.v", 216, w27);
   TEST_COP1("bz.v", 224, w28);
   TEST_COP1("bz.v", 232, w29);
   TEST_COP1("bz.v", 240, w30);
   TEST_COP1("bz.v",  32, w31);
   TEST_I5("ceqi.b",   0, w0,  w1,  -12);
   TEST_I5("ceqi.b",   8, w1,  w16, 0);
   TEST_I5("ceqi.b",  16, w2,  w24, -12);
   TEST_I5("ceqi.b",  24, w3,  w27, -5);
   TEST_I5("ceqi.b",  32, w4,  w14, 1);
   TEST_I5("ceqi.b",  40, w5,  w8,  -14);
   TEST_I5("ceqi.b",  48, w6,  w6,  -8);
   TEST_I5("ceqi.b",  56, w7,  w6,  6);
   TEST_I5("ceqi.b",  64, w8,  w5,  -6);
   TEST_I5("ceqi.b",  72, w9,  w28, -16);
   TEST_I5("ceqi.b",  80, w10, w24, -12);
   TEST_I5("ceqi.b",  88, w11, w28, -11);
   TEST_I5("ceqi.b",  96, w12, w31, 13);
   TEST_I5("ceqi.b", 104, w13, w11, 9);
   TEST_I5("ceqi.b", 112, w14, w27, -9);
   TEST_I5("ceqi.b", 120, w15, w12, 0);
   TEST_I5("ceqi.b", 128, w16, w15, 8);
   TEST_I5("ceqi.b", 136, w17, w21, -2);
   TEST_I5("ceqi.b", 144, w18, w26, 8);
   TEST_I5("ceqi.b", 152, w19, w22, -7);
   TEST_I5("ceqi.b", 160, w20, w23, 10);
   TEST_I5("ceqi.b", 168, w21, w27, 12);
   TEST_I5("ceqi.b", 176, w22, w1,  -3);
   TEST_I5("ceqi.b", 184, w23, w30, -13);
   TEST_I5("ceqi.b", 192, w24, w23, -12);
   TEST_I5("ceqi.b", 200, w25, w30, -3);
   TEST_I5("ceqi.b", 208, w26, w26, -2);
   TEST_I5("ceqi.b", 216, w27, w16, -10);
   TEST_I5("ceqi.b", 224, w28, w5,  -8);
   TEST_I5("ceqi.b", 232, w29, w20, -10);
   TEST_I5("ceqi.b", 240, w30, w13, -16);
   TEST_I5("ceqi.b",  64, w31, w22, 3);
   TEST_I5("ceqi.h",   0, w0,  w8,  -4);
   TEST_I5("ceqi.h",   8, w1,  w9,  10);
   TEST_I5("ceqi.h",  16, w2,  w8,  13);
   TEST_I5("ceqi.h",  24, w3,  w31, -14);
   TEST_I5("ceqi.h",  32, w4,  w30, 15);
   TEST_I5("ceqi.h",  40, w5,  w15, -1);
   TEST_I5("ceqi.h",  48, w6,  w6,  3);
   TEST_I5("ceqi.h",  56, w7,  w20, -9);
   TEST_I5("ceqi.h",  64, w8,  w19, 4);
   TEST_I5("ceqi.h",  72, w9,  w11, 6);
   TEST_I5("ceqi.h",  80, w10, w30, 15);
   TEST_I5("ceqi.h",  88, w11, w0,  -8);
   TEST_I5("ceqi.h",  96, w12, w16, 0);
   TEST_I5("ceqi.h", 104, w13, w25, 0);
   TEST_I5("ceqi.h", 112, w14, w23, -2);
   TEST_I5("ceqi.h", 120, w15, w22, 10);
   TEST_I5("ceqi.h", 128, w16, w5,  -3);
   TEST_I5("ceqi.h", 136, w17, w25, 5);
   TEST_I5("ceqi.h", 144, w18, w13, -7);
   TEST_I5("ceqi.h", 152, w19, w22, 4);
   TEST_I5("ceqi.h", 160, w20, w13, -1);
   TEST_I5("ceqi.h", 168, w21, w12, 6);
   TEST_I5("ceqi.h", 176, w22, w20, 8);
   TEST_I5("ceqi.h", 184, w23, w5,  7);
   TEST_I5("ceqi.h", 192, w24, w21, 8);
   TEST_I5("ceqi.h", 200, w25, w3,  -8);
   TEST_I5("ceqi.h", 208, w26, w26, 13);
   TEST_I5("ceqi.h", 216, w27, w0,  -5);
   TEST_I5("ceqi.h", 224, w28, w26, -12);
   TEST_I5("ceqi.h", 232, w29, w0,  15);
   TEST_I5("ceqi.h", 240, w30, w9,  -12);
   TEST_I5("ceqi.h",  72, w31, w29, -8);
   TEST_I5("ceqi.w",   0, w0,  w22, -13);
   TEST_I5("ceqi.w",   8, w1,  w11, 11);
   TEST_I5("ceqi.w",  16, w2,  w16, 2);
   TEST_I5("ceqi.w",  24, w3,  w5,  -6);
   TEST_I5("ceqi.w",  32, w4,  w8,  -5);
   TEST_I5("ceqi.w",  40, w5,  w18, -9);
   TEST_I5("ceqi.w",  48, w6,  w6,  -10);
   TEST_I5("ceqi.w",  56, w7,  w11, -3);
   TEST_I5("ceqi.w",  64, w8,  w10, -6);
   TEST_I5("ceqi.w",  72, w9,  w15, 5);
   TEST_I5("ceqi.w",  80, w10, w23, -5);
   TEST_I5("ceqi.w",  88, w11, w2,  6);
   TEST_I5("ceqi.w",  96, w12, w1,  -10);
   TEST_I5("ceqi.w", 104, w13, w20, 14);
   TEST_I5("ceqi.w", 112, w14, w30, -7);
   TEST_I5("ceqi.w", 120, w15, w16, 5);
   TEST_I5("ceqi.w", 128, w16, w23, 11);
   TEST_I5("ceqi.w", 136, w17, w3,  -8);
   TEST_I5("ceqi.w", 144, w18, w13, 3);
   TEST_I5("ceqi.w", 152, w19, w28, -8);
   TEST_I5("ceqi.w", 160, w20, w19, 3);
   TEST_I5("ceqi.w", 168, w21, w22, 7);
   TEST_I5("ceqi.w", 176, w22, w24, -11);
   TEST_I5("ceqi.w", 184, w23, w12, -13);
   TEST_I5("ceqi.w", 192, w24, w10, -4);
   TEST_I5("ceqi.w", 200, w25, w27, -14);
   TEST_I5("ceqi.w", 208, w26, w26, 2);
   TEST_I5("ceqi.w", 216, w27, w18, 5);
   TEST_I5("ceqi.w", 224, w28, w12, -10);
   TEST_I5("ceqi.w", 232, w29, w3,  9);
   TEST_I5("ceqi.w", 240, w30, w31, -15);
   TEST_I5("ceqi.w", 104, w31, w19, 4);
   TEST_I5("ceqi.d",   0, w0,  w17, -16);
   TEST_I5("ceqi.d",   8, w1,  w10, -11);
   TEST_I5("ceqi.d",  16, w2,  w22, -8);
   TEST_I5("ceqi.d",  24, w3,  w1,  5);
   TEST_I5("ceqi.d",  32, w4,  w28, -13);
   TEST_I5("ceqi.d",  40, w5,  w23, 5);
   TEST_I5("ceqi.d",  48, w6,  w6,  -12);
   TEST_I5("ceqi.d",  56, w7,  w1,  -9);
   TEST_I5("ceqi.d",  64, w8,  w1,  -10);
   TEST_I5("ceqi.d",  72, w9,  w12, 9);
   TEST_I5("ceqi.d",  80, w10, w7,  -14);
   TEST_I5("ceqi.d",  88, w11, w25, -13);
   TEST_I5("ceqi.d",  96, w12, w3,  -8);
   TEST_I5("ceqi.d", 104, w13, w25, 1);
   TEST_I5("ceqi.d", 112, w14, w26, -10);
   TEST_I5("ceqi.d", 120, w15, w22, 13);
   TEST_I5("ceqi.d", 128, w16, w5,  1);
   TEST_I5("ceqi.d", 136, w17, w9,  -4);
   TEST_I5("ceqi.d", 144, w18, w16, 15);
   TEST_I5("ceqi.d", 152, w19, w22, 4);
   TEST_I5("ceqi.d", 160, w20, w16, 13);
   TEST_I5("ceqi.d", 168, w21, w18, -12);
   TEST_I5("ceqi.d", 176, w22, w21, 11);
   TEST_I5("ceqi.d", 184, w23, w30, 12);
   TEST_I5("ceqi.d", 192, w24, w15, 8);
   TEST_I5("ceqi.d", 200, w25, w21, 7);
   TEST_I5("ceqi.d", 208, w26, w26, 2);
   TEST_I5("ceqi.d", 216, w27, w21, -13);
   TEST_I5("ceqi.d", 224, w28, w30, -16);
   TEST_I5("ceqi.d", 232, w29, w15, 6);
   TEST_I5("ceqi.d", 240, w30, w15, 9);
   TEST_I5("ceqi.d",  80, w31, w3,  -13);
   TEST_I5("clei_s.b",   0, w0,  w30, 6);
   TEST_I5("clei_s.b",   8, w1,  w21, -10);
   TEST_I5("clei_s.b",  16, w2,  w3,  4);
   TEST_I5("clei_s.b",  24, w3,  w15, 14);
   TEST_I5("clei_s.b",  32, w4,  w17, 1);
   TEST_I5("clei_s.b",  40, w5,  w8,  5);
   TEST_I5("clei_s.b",  48, w6,  w3,  -9);
   TEST_I5("clei_s.b",  56, w7,  w14, 3);
   TEST_I5("clei_s.b",  64, w8,  w23, -4);
   TEST_I5("clei_s.b",  72, w9,  w14, -3);
   TEST_I5("clei_s.b",  80, w10, w2,  -13);
   TEST_I5("clei_s.b",  88, w11, w23, -7);
   TEST_I5("clei_s.b",  96, w12, w26, 13);
   TEST_I5("clei_s.b", 104, w13, w9,  11);
   TEST_I5("clei_s.b", 112, w14, w27, -4);
   TEST_I5("clei_s.b", 120, w15, w3,  13);
   TEST_I5("clei_s.b", 128, w16, w24, 14);
   TEST_I5("clei_s.b", 136, w17, w31, 13);
   TEST_I5("clei_s.b", 144, w18, w16, -16);
   TEST_I5("clei_s.b", 152, w19, w25, -14);
   TEST_I5("clei_s.b", 160, w20, w31, -1);
   TEST_I5("clei_s.b", 168, w21, w21, -3);
   TEST_I5("clei_s.b", 176, w22, w24, -5);
   TEST_I5("clei_s.b", 184, w23, w23, 5);
   TEST_I5("clei_s.b", 192, w24, w29, 0);
   TEST_I5("clei_s.b", 200, w25, w24, 12);
   TEST_I5("clei_s.b", 208, w26, w27, 9);
   TEST_I5("clei_s.b", 216, w27, w19, 7);
   TEST_I5("clei_s.b", 224, w28, w18, -12);
   TEST_I5("clei_s.b", 232, w29, w4,  -13);
   TEST_I5("clei_s.b", 240, w30, w5,  -9);
   TEST_I5("clei_s.b", 120, w31, w29, -15);
   TEST_I5("clei_s.h",   0, w0,  w22, 4);
   TEST_I5("clei_s.h",   8, w1,  w21, 1);
   TEST_I5("clei_s.h",  16, w2,  w17, -7);
   TEST_I5("clei_s.h",  24, w3,  w17, -12);
   TEST_I5("clei_s.h",  32, w4,  w26, 7);
   TEST_I5("clei_s.h",  40, w5,  w17, -7);
   TEST_I5("clei_s.h",  48, w6,  w3,  -2);
   TEST_I5("clei_s.h",  56, w7,  w2,  -4);
   TEST_I5("clei_s.h",  64, w8,  w0,  4);
   TEST_I5("clei_s.h",  72, w9,  w29, 5);
   TEST_I5("clei_s.h",  80, w10, w8,  -7);
   TEST_I5("clei_s.h",  88, w11, w29, 11);
   TEST_I5("clei_s.h",  96, w12, w14, -12);
   TEST_I5("clei_s.h", 104, w13, w31, -7);
   TEST_I5("clei_s.h", 112, w14, w26, -16);
   TEST_I5("clei_s.h", 120, w15, w11, -6);
   TEST_I5("clei_s.h", 128, w16, w14, 8);
   TEST_I5("clei_s.h", 136, w17, w21, -7);
   TEST_I5("clei_s.h", 144, w18, w2,  -6);
   TEST_I5("clei_s.h", 152, w19, w22, -6);
   TEST_I5("clei_s.h", 160, w20, w11, 2);
   TEST_I5("clei_s.h", 168, w21, w21, 4);
   TEST_I5("clei_s.h", 176, w22, w16, -1);
   TEST_I5("clei_s.h", 184, w23, w23, 14);
   TEST_I5("clei_s.h", 192, w24, w30, 14);
   TEST_I5("clei_s.h", 200, w25, w19, 8);
   TEST_I5("clei_s.h", 208, w26, w24, -13);
   TEST_I5("clei_s.h", 216, w27, w6,  1);
   TEST_I5("clei_s.h", 224, w28, w17, -10);
   TEST_I5("clei_s.h", 232, w29, w30, -8);
   TEST_I5("clei_s.h", 240, w30, w11, 14);
   TEST_I5("clei_s.h", 184, w31, w22, -7);
   TEST_I5("clei_s.w",   0, w0,  w29, 14);
   TEST_I5("clei_s.w",   8, w1,  w24, -3);
   TEST_I5("clei_s.w",  16, w2,  w23, -15);
   TEST_I5("clei_s.w",  24, w3,  w21, 14);
   TEST_I5("clei_s.w",  32, w4,  w13, 12);
   TEST_I5("clei_s.w",  40, w5,  w16, -13);
   TEST_I5("clei_s.w",  48, w6,  w1,  -9);
   TEST_I5("clei_s.w",  56, w7,  w31, 0);
   TEST_I5("clei_s.w",  64, w8,  w11, -2);
   TEST_I5("clei_s.w",  72, w9,  w1,  8);
   TEST_I5("clei_s.w",  80, w10, w9,  6);
   TEST_I5("clei_s.w",  88, w11, w2,  -13);
   TEST_I5("clei_s.w",  96, w12, w25, -11);
   TEST_I5("clei_s.w", 104, w13, w14, -13);
   TEST_I5("clei_s.w", 112, w14, w27, 15);
   TEST_I5("clei_s.w", 120, w15, w11, -13);
   TEST_I5("clei_s.w", 128, w16, w12, -10);
   TEST_I5("clei_s.w", 136, w17, w19, 2);
   TEST_I5("clei_s.w", 144, w18, w3,  1);
   TEST_I5("clei_s.w", 152, w19, w18, -2);
   TEST_I5("clei_s.w", 160, w20, w10, 6);
   TEST_I5("clei_s.w", 168, w21, w21, -16);
   TEST_I5("clei_s.w", 176, w22, w24, -13);
   TEST_I5("clei_s.w", 184, w23, w23, 1);
   TEST_I5("clei_s.w", 192, w24, w25, 15);
   TEST_I5("clei_s.w", 200, w25, w1,  10);
   TEST_I5("clei_s.w", 208, w26, w17, -11);
   TEST_I5("clei_s.w", 216, w27, w17, 1);
   TEST_I5("clei_s.w", 224, w28, w18, -12);
   TEST_I5("clei_s.w", 232, w29, w19, -8);
   TEST_I5("clei_s.w", 240, w30, w24, -5);
   TEST_I5("clei_s.w", 120, w31, w6,  -15);
   TEST_I5("clei_s.d",   0, w0,  w4,  9);
   TEST_I5("clei_s.d",   8, w1,  w18, -6);
   TEST_I5("clei_s.d",  16, w2,  w11, -7);
   TEST_I5("clei_s.d",  24, w3,  w12, -13);
   TEST_I5("clei_s.d",  32, w4,  w30, -8);
   TEST_I5("clei_s.d",  40, w5,  w15, 9);
   TEST_I5("clei_s.d",  48, w6,  w2,  13);
   TEST_I5("clei_s.d",  56, w7,  w21, -11);
   TEST_I5("clei_s.d",  64, w8,  w19, 15);
   TEST_I5("clei_s.d",  72, w9,  w30, -13);
   TEST_I5("clei_s.d",  80, w10, w31, 8);
   TEST_I5("clei_s.d",  88, w11, w17, -14);
   TEST_I5("clei_s.d",  96, w12, w28, -5);
   TEST_I5("clei_s.d", 104, w13, w9,  -2);
   TEST_I5("clei_s.d", 112, w14, w7,  6);
   TEST_I5("clei_s.d", 120, w15, w22, -1);
   TEST_I5("clei_s.d", 128, w16, w24, -3);
   TEST_I5("clei_s.d", 136, w17, w13, 2);
   TEST_I5("clei_s.d", 144, w18, w1,  2);
   TEST_I5("clei_s.d", 152, w19, w31, 5);
   TEST_I5("clei_s.d", 160, w20, w31, -5);
   TEST_I5("clei_s.d", 168, w21, w21, 7);
   TEST_I5("clei_s.d", 176, w22, w28, 10);
   TEST_I5("clei_s.d", 184, w23, w23, 9);
   TEST_I5("clei_s.d", 192, w24, w11, -14);
   TEST_I5("clei_s.d", 200, w25, w6,  -7);
   TEST_I5("clei_s.d", 208, w26, w8,  15);
   TEST_I5("clei_s.d", 216, w27, w1,  8);
   TEST_I5("clei_s.d", 224, w28, w4,  -11);
   TEST_I5("clei_s.d", 232, w29, w24, -10);
   TEST_I5("clei_s.d", 240, w30, w21, -10);
   TEST_I5("clei_s.d",  72, w31, w1,  -3);
   TEST_I5("clei_u.b",   0, w0,  w21, 4);
   TEST_I5("clei_u.b",   8, w1,  w27, 13);
   TEST_I5("clei_u.b",  16, w2,  w3,  26);
   TEST_I5("clei_u.b",  24, w3,  w13, 20);
   TEST_I5("clei_u.b",  32, w4,  w5,  27);
   TEST_I5("clei_u.b",  40, w5,  w10, 21);
   TEST_I5("clei_u.b",  48, w6,  w17, 0);
   TEST_I5("clei_u.b",  56, w7,  w23, 28);
   TEST_I5("clei_u.b",  64, w8,  w4,  24);
   TEST_I5("clei_u.b",  72, w9,  w9,  13);
   TEST_I5("clei_u.b",  80, w10, w10, 15);
   TEST_I5("clei_u.b",  88, w11, w16, 11);
   TEST_I5("clei_u.b",  96, w12, w20, 27);
   TEST_I5("clei_u.b", 104, w13, w2,  21);
   TEST_I5("clei_u.b", 112, w14, w15, 10);
   TEST_I5("clei_u.b", 120, w15, w20, 5);
   TEST_I5("clei_u.b", 128, w16, w30, 26);
   TEST_I5("clei_u.b", 136, w17, w15, 27);
   TEST_I5("clei_u.b", 144, w18, w6,  28);
   TEST_I5("clei_u.b", 152, w19, w2,  28);
   TEST_I5("clei_u.b", 160, w20, w27, 5);
   TEST_I5("clei_u.b", 168, w21, w10, 4);
   TEST_I5("clei_u.b", 176, w22, w21, 13);
   TEST_I5("clei_u.b", 184, w23, w29, 15);
   TEST_I5("clei_u.b", 192, w24, w26, 30);
   TEST_I5("clei_u.b", 200, w25, w28, 18);
   TEST_I5("clei_u.b", 208, w26, w6,  16);
   TEST_I5("clei_u.b", 216, w27, w16, 0);
   TEST_I5("clei_u.b", 224, w28, w16, 6);
   TEST_I5("clei_u.b", 232, w29, w7,  2);
   TEST_I5("clei_u.b", 240, w30, w3,  11);
   TEST_I5("clei_u.b",  72, w31, w8,  3);
   TEST_I5("clei_u.h",   0, w0,  w3,  10);
   TEST_I5("clei_u.h",   8, w1,  w19, 4);
   TEST_I5("clei_u.h",  16, w2,  w24, 29);
   TEST_I5("clei_u.h",  24, w3,  w0,  15);
   TEST_I5("clei_u.h",  32, w4,  w6,  0);
   TEST_I5("clei_u.h",  40, w5,  w23, 0);
   TEST_I5("clei_u.h",  48, w6,  w7,  6);
   TEST_I5("clei_u.h",  56, w7,  w15, 15);
   TEST_I5("clei_u.h",  64, w8,  w17, 19);
   TEST_I5("clei_u.h",  72, w9,  w9,  28);
   TEST_I5("clei_u.h",  80, w10, w10, 1);
   TEST_I5("clei_u.h",  88, w11, w0,  4);
   TEST_I5("clei_u.h",  96, w12, w16, 23);
   TEST_I5("clei_u.h", 104, w13, w16, 16);
   TEST_I5("clei_u.h", 112, w14, w13, 24);
   TEST_I5("clei_u.h", 120, w15, w29, 21);
   TEST_I5("clei_u.h", 128, w16, w29, 1);
   TEST_I5("clei_u.h", 136, w17, w29, 24);
   TEST_I5("clei_u.h", 144, w18, w3,  22);
   TEST_I5("clei_u.h", 152, w19, w10, 6);
   TEST_I5("clei_u.h", 160, w20, w7,  8);
   TEST_I5("clei_u.h", 168, w21, w7,  12);
   TEST_I5("clei_u.h", 176, w22, w23, 23);
   TEST_I5("clei_u.h", 184, w23, w4,  27);
   TEST_I5("clei_u.h", 192, w24, w20, 0);
   TEST_I5("clei_u.h", 200, w25, w12, 12);
   TEST_I5("clei_u.h", 208, w26, w1,  14);
   TEST_I5("clei_u.h", 216, w27, w2,  24);
   TEST_I5("clei_u.h", 224, w28, w27, 17);
   TEST_I5("clei_u.h", 232, w29, w17, 28);
   TEST_I5("clei_u.h", 240, w30, w9,  10);
   TEST_I5("clei_u.h", 152, w31, w17, 1);
   TEST_I5("clei_u.w",   0, w0,  w1,  1);
   TEST_I5("clei_u.w",   8, w1,  w9,  21);
   TEST_I5("clei_u.w",  16, w2,  w30, 20);
   TEST_I5("clei_u.w",  24, w3,  w1,  0);
   TEST_I5("clei_u.w",  32, w4,  w2,  14);
   TEST_I5("clei_u.w",  40, w5,  w11, 0);
   TEST_I5("clei_u.w",  48, w6,  w26, 17);
   TEST_I5("clei_u.w",  56, w7,  w29, 26);
   TEST_I5("clei_u.w",  64, w8,  w6,  4);
   TEST_I5("clei_u.w",  72, w9,  w9,  23);
   TEST_I5("clei_u.w",  80, w10, w10, 5);
   TEST_I5("clei_u.w",  88, w11, w20, 29);
   TEST_I5("clei_u.w",  96, w12, w22, 11);
   TEST_I5("clei_u.w", 104, w13, w10, 13);
   TEST_I5("clei_u.w", 112, w14, w26, 15);
   TEST_I5("clei_u.w", 120, w15, w25, 20);
   TEST_I5("clei_u.w", 128, w16, w4,  20);
   TEST_I5("clei_u.w", 136, w17, w30, 6);
   TEST_I5("clei_u.w", 144, w18, w27, 0);
   TEST_I5("clei_u.w", 152, w19, w1,  5);
   TEST_I5("clei_u.w", 160, w20, w24, 10);
   TEST_I5("clei_u.w", 168, w21, w13, 8);
   TEST_I5("clei_u.w", 176, w22, w3,  15);
   TEST_I5("clei_u.w", 184, w23, w25, 25);
   TEST_I5("clei_u.w", 192, w24, w30, 19);
   TEST_I5("clei_u.w", 200, w25, w3,  12);
   TEST_I5("clei_u.w", 208, w26, w22, 16);
   TEST_I5("clei_u.w", 216, w27, w17, 15);
   TEST_I5("clei_u.w", 224, w28, w4,  10);
   TEST_I5("clei_u.w", 232, w29, w11, 12);
   TEST_I5("clei_u.w", 240, w30, w10, 4);
   TEST_I5("clei_u.w",  72, w31, w11, 17);
   TEST_I5("clei_u.d",   0, w0,  w18, 30);
   TEST_I5("clei_u.d",   8, w1,  w11, 23);
   TEST_I5("clei_u.d",  16, w2,  w9,  30);
   TEST_I5("clei_u.d",  24, w3,  w11, 9);
   TEST_I5("clei_u.d",  32, w4,  w23, 9);
   TEST_I5("clei_u.d",  40, w5,  w8,  29);
   TEST_I5("clei_u.d",  48, w6,  w23, 3);
   TEST_I5("clei_u.d",  56, w7,  w17, 13);
   TEST_I5("clei_u.d",  64, w8,  w17, 24);
   TEST_I5("clei_u.d",  72, w9,  w9,  27);
   TEST_I5("clei_u.d",  80, w10, w10, 7);
   TEST_I5("clei_u.d",  88, w11, w13, 5);
   TEST_I5("clei_u.d",  96, w12, w24, 28);
   TEST_I5("clei_u.d", 104, w13, w1,  7);
   TEST_I5("clei_u.d", 112, w14, w13, 31);
   TEST_I5("clei_u.d", 120, w15, w12, 3);
   TEST_I5("clei_u.d", 128, w16, w9,  26);
   TEST_I5("clei_u.d", 136, w17, w0,  29);
   TEST_I5("clei_u.d", 144, w18, w17, 11);
   TEST_I5("clei_u.d", 152, w19, w2,  3);
   TEST_I5("clei_u.d", 160, w20, w29, 10);
   TEST_I5("clei_u.d", 168, w21, w10, 15);
   TEST_I5("clei_u.d", 176, w22, w2,  21);
   TEST_I5("clei_u.d", 184, w23, w12, 15);
   TEST_I5("clei_u.d", 192, w24, w19, 18);
   TEST_I5("clei_u.d", 200, w25, w18, 30);
   TEST_I5("clei_u.d", 208, w26, w25, 7);
   TEST_I5("clei_u.d", 216, w27, w23, 7);
   TEST_I5("clei_u.d", 224, w28, w23, 24);
   TEST_I5("clei_u.d", 232, w29, w4,  27);
   TEST_I5("clei_u.d", 240, w30, w3,  24);
   TEST_I5("clei_u.d", 112, w31, w5,  3);
   TEST_I5("clti_s.b",   0, w0,  w4,  9);
   TEST_I5("clti_s.b",   8, w1,  w22, 9);
   TEST_I5("clti_s.b",  16, w2,  w20, 12);
   TEST_I5("clti_s.b",  24, w3,  w27, 10);
   TEST_I5("clti_s.b",  32, w4,  w2,  5);
   TEST_I5("clti_s.b",  40, w5,  w5,  11);
   TEST_I5("clti_s.b",  48, w6,  w1,  6);
   TEST_I5("clti_s.b",  56, w7,  w4,  -6);
   TEST_I5("clti_s.b",  64, w8,  w24, -6);
   TEST_I5("clti_s.b",  72, w9,  w28, 7);
   TEST_I5("clti_s.b",  80, w10, w31, -16);
   TEST_I5("clti_s.b",  88, w11, w4,  9);
   TEST_I5("clti_s.b",  96, w12, w26, 3);
   TEST_I5("clti_s.b", 104, w13, w15, -1);
   TEST_I5("clti_s.b", 112, w14, w10, -7);
   TEST_I5("clti_s.b", 120, w15, w13, 7);
   TEST_I5("clti_s.b", 128, w16, w30, 8);
   TEST_I5("clti_s.b", 136, w17, w25, 13);
   TEST_I5("clti_s.b", 144, w18, w30, -9);
   TEST_I5("clti_s.b", 152, w19, w22, 1);
   TEST_I5("clti_s.b", 160, w20, w18, 0);
   TEST_I5("clti_s.b", 168, w21, w21, 5);
   TEST_I5("clti_s.b", 176, w22, w20, -2);
   TEST_I5("clti_s.b", 184, w23, w15, -15);
   TEST_I5("clti_s.b", 192, w24, w30, 1);
   TEST_I5("clti_s.b", 200, w25, w8,  10);
   TEST_I5("clti_s.b", 208, w26, w21, 9);
   TEST_I5("clti_s.b", 216, w27, w29, 2);
   TEST_I5("clti_s.b", 224, w28, w27, 0);
   TEST_I5("clti_s.b", 232, w29, w8,  -9);
   TEST_I5("clti_s.b", 240, w30, w6,  9);
   TEST_I5("clti_s.b", 160, w31, w27, 7);
   TEST_I5("clti_s.h",   0, w0,  w6,  14);
   TEST_I5("clti_s.h",   8, w1,  w21, -16);
   TEST_I5("clti_s.h",  16, w2,  w19, 1);
   TEST_I5("clti_s.h",  24, w3,  w28, -5);
   TEST_I5("clti_s.h",  32, w4,  w17, -12);
   TEST_I5("clti_s.h",  40, w5,  w5,  -1);
   TEST_I5("clti_s.h",  48, w6,  w21, -6);
   TEST_I5("clti_s.h",  56, w7,  w31, -1);
   TEST_I5("clti_s.h",  64, w8,  w14, 1);
   TEST_I5("clti_s.h",  72, w9,  w8,  3);
   TEST_I5("clti_s.h",  80, w10, w3,  -13);
   TEST_I5("clti_s.h",  88, w11, w9,  -14);
   TEST_I5("clti_s.h",  96, w12, w31, -14);
   TEST_I5("clti_s.h", 104, w13, w18, 3);
   TEST_I5("clti_s.h", 112, w14, w5,  -16);
   TEST_I5("clti_s.h", 120, w15, w14, -13);
   TEST_I5("clti_s.h", 128, w16, w15, 10);
   TEST_I5("clti_s.h", 136, w17, w25, -15);
   TEST_I5("clti_s.h", 144, w18, w12, -12);
   TEST_I5("clti_s.h", 152, w19, w3,  8);
   TEST_I5("clti_s.h", 160, w20, w6,  11);
   TEST_I5("clti_s.h", 168, w21, w21, 11);
   TEST_I5("clti_s.h", 176, w22, w29, 3);
   TEST_I5("clti_s.h", 184, w23, w31, -13);
   TEST_I5("clti_s.h", 192, w24, w18, -8);
   TEST_I5("clti_s.h", 200, w25, w17, 6);
   TEST_I5("clti_s.h", 208, w26, w20, 9);
   TEST_I5("clti_s.h", 216, w27, w14, 12);
   TEST_I5("clti_s.h", 224, w28, w15, -2);
   TEST_I5("clti_s.h", 232, w29, w31, 1);
   TEST_I5("clti_s.h", 240, w30, w23, 7);
   TEST_I5("clti_s.h",  72, w31, w15, -10);
   TEST_I5("clti_s.w",   0, w0,  w25, 13);
   TEST_I5("clti_s.w",   8, w1,  w25, -16);
   TEST_I5("clti_s.w",  16, w2,  w11, -8);
   TEST_I5("clti_s.w",  24, w3,  w28, 14);
   TEST_I5("clti_s.w",  32, w4,  w16, 7);
   TEST_I5("clti_s.w",  40, w5,  w5,  14);
   TEST_I5("clti_s.w",  48, w6,  w11, -2);
   TEST_I5("clti_s.w",  56, w7,  w15, -3);
   TEST_I5("clti_s.w",  64, w8,  w24, -11);
   TEST_I5("clti_s.w",  72, w9,  w24, -7);
   TEST_I5("clti_s.w",  80, w10, w20, 14);
   TEST_I5("clti_s.w",  88, w11, w14, 11);
   TEST_I5("clti_s.w",  96, w12, w7,  11);
   TEST_I5("clti_s.w", 104, w13, w18, -13);
   TEST_I5("clti_s.w", 112, w14, w15, -15);
   TEST_I5("clti_s.w", 120, w15, w31, -7);
   TEST_I5("clti_s.w", 128, w16, w24, 4);
   TEST_I5("clti_s.w", 136, w17, w12, -3);
   TEST_I5("clti_s.w", 144, w18, w25, -16);
   TEST_I5("clti_s.w", 152, w19, w30, -7);
   TEST_I5("clti_s.w", 160, w20, w18, 9);
   TEST_I5("clti_s.w", 168, w21, w21, 7);
   TEST_I5("clti_s.w", 176, w22, w30, 14);
   TEST_I5("clti_s.w", 184, w23, w25, 0);
   TEST_I5("clti_s.w", 192, w24, w26, 15);
   TEST_I5("clti_s.w", 200, w25, w15, 15);
   TEST_I5("clti_s.w", 208, w26, w24, 13);
   TEST_I5("clti_s.w", 216, w27, w13, -7);
   TEST_I5("clti_s.w", 224, w28, w17, -3);
   TEST_I5("clti_s.w", 232, w29, w28, -15);
   TEST_I5("clti_s.w", 240, w30, w6,  -6);
   TEST_I5("clti_s.w", 152, w31, w4,  14);
   TEST_I5("clti_s.d",   0, w0,  w31, 6);
   TEST_I5("clti_s.d",   8, w1,  w16, 15);
   TEST_I5("clti_s.d",  16, w2,  w15, -6);
   TEST_I5("clti_s.d",  24, w3,  w14, -3);
   TEST_I5("clti_s.d",  32, w4,  w11, 12);
   TEST_I5("clti_s.d",  40, w5,  w5,  4);
   TEST_I5("clti_s.d",  48, w6,  w23, 7);
   TEST_I5("clti_s.d",  56, w7,  w4,  8);
   TEST_I5("clti_s.d",  64, w8,  w6,  -5);
   TEST_I5("clti_s.d",  72, w9,  w16, 10);
   TEST_I5("clti_s.d",  80, w10, w15, 8);
   TEST_I5("clti_s.d",  88, w11, w31, 0);
   TEST_I5("clti_s.d",  96, w12, w21, -15);
   TEST_I5("clti_s.d", 104, w13, w20, -14);
   TEST_I5("clti_s.d", 112, w14, w30, 12);
   TEST_I5("clti_s.d", 120, w15, w11, -5);
   TEST_I5("clti_s.d", 128, w16, w2,  15);
   TEST_I5("clti_s.d", 136, w17, w26, 6);
   TEST_I5("clti_s.d", 144, w18, w30, -2);
   TEST_I5("clti_s.d", 152, w19, w4,  10);
   TEST_I5("clti_s.d", 160, w20, w21, -7);
   TEST_I5("clti_s.d", 168, w21, w21, -13);
   TEST_I5("clti_s.d", 176, w22, w8,  3);
   TEST_I5("clti_s.d", 184, w23, w29, 4);
   TEST_I5("clti_s.d", 192, w24, w18, 7);
   TEST_I5("clti_s.d", 200, w25, w16, 3);
   TEST_I5("clti_s.d", 208, w26, w28, 5);
   TEST_I5("clti_s.d", 216, w27, w3,  -1);
   TEST_I5("clti_s.d", 224, w28, w3,  -2);
   TEST_I5("clti_s.d", 232, w29, w24, 2);
   TEST_I5("clti_s.d", 240, w30, w8,  -9);
   TEST_I5("clti_s.d", 208, w31, w19, -2);
   TEST_I5("clti_u.b",   0, w0,  w29, 12);
   TEST_I5("clti_u.b",   8, w1,  w20, 6);
   TEST_I5("clti_u.b",  16, w2,  w22, 2);
   TEST_I5("clti_u.b",  24, w3,  w12, 29);
   TEST_I5("clti_u.b",  32, w4,  w5,  12);
   TEST_I5("clti_u.b",  40, w5,  w9,  26);
   TEST_I5("clti_u.b",  48, w6,  w1,  10);
   TEST_I5("clti_u.b",  56, w7,  w7,  26);
   TEST_I5("clti_u.b",  64, w8,  w20, 24);
   TEST_I5("clti_u.b",  72, w9,  w9,  19);
   TEST_I5("clti_u.b",  80, w10, w30, 1);
   TEST_I5("clti_u.b",  88, w11, w25, 23);
   TEST_I5("clti_u.b",  96, w12, w14, 13);
   TEST_I5("clti_u.b", 104, w13, w21, 25);
   TEST_I5("clti_u.b", 112, w14, w18, 26);
   TEST_I5("clti_u.b", 120, w15, w31, 7);
   TEST_I5("clti_u.b", 128, w16, w25, 13);
   TEST_I5("clti_u.b", 136, w17, w6,  8);
   TEST_I5("clti_u.b", 144, w18, w27, 0);
   TEST_I5("clti_u.b", 152, w19, w30, 30);
   TEST_I5("clti_u.b", 160, w20, w8,  31);
   TEST_I5("clti_u.b", 168, w21, w19, 22);
   TEST_I5("clti_u.b", 176, w22, w10, 19);
   TEST_I5("clti_u.b", 184, w23, w2,  17);
   TEST_I5("clti_u.b", 192, w24, w20, 11);
   TEST_I5("clti_u.b", 200, w25, w19, 18);
   TEST_I5("clti_u.b", 208, w26, w13, 0);
   TEST_I5("clti_u.b", 216, w27, w19, 8);
   TEST_I5("clti_u.b", 224, w28, w14, 8);
   TEST_I5("clti_u.b", 232, w29, w12, 6);
   TEST_I5("clti_u.b", 240, w30, w20, 5);
   TEST_I5("clti_u.b", 208, w31, w7,  28);
   TEST_I5("clti_u.h",   0, w0,  w27, 9);
   TEST_I5("clti_u.h",   8, w1,  w29, 2);
   TEST_I5("clti_u.h",  16, w2,  w26, 25);
   TEST_I5("clti_u.h",  24, w3,  w5,  5);
   TEST_I5("clti_u.h",  32, w4,  w29, 18);
   TEST_I5("clti_u.h",  40, w5,  w17, 6);
   TEST_I5("clti_u.h",  48, w6,  w29, 20);
   TEST_I5("clti_u.h",  56, w7,  w7,  0);
   TEST_I5("clti_u.h",  64, w8,  w1,  14);
   TEST_I5("clti_u.h",  72, w9,  w9,  28);
   TEST_I5("clti_u.h",  80, w10, w19, 11);
   TEST_I5("clti_u.h",  88, w11, w15, 6);
   TEST_I5("clti_u.h",  96, w12, w31, 4);
   TEST_I5("clti_u.h", 104, w13, w1,  22);
   TEST_I5("clti_u.h", 112, w14, w26, 27);
   TEST_I5("clti_u.h", 120, w15, w23, 8);
   TEST_I5("clti_u.h", 128, w16, w7,  6);
   TEST_I5("clti_u.h", 136, w17, w7,  6);
   TEST_I5("clti_u.h", 144, w18, w15, 17);
   TEST_I5("clti_u.h", 152, w19, w29, 13);
   TEST_I5("clti_u.h", 160, w20, w16, 24);
   TEST_I5("clti_u.h", 168, w21, w0,  31);
   TEST_I5("clti_u.h", 176, w22, w31, 3);
   TEST_I5("clti_u.h", 184, w23, w0,  25);
   TEST_I5("clti_u.h", 192, w24, w26, 20);
   TEST_I5("clti_u.h", 200, w25, w17, 26);
   TEST_I5("clti_u.h", 208, w26, w0,  0);
   TEST_I5("clti_u.h", 216, w27, w7,  6);
   TEST_I5("clti_u.h", 224, w28, w22, 23);
   TEST_I5("clti_u.h", 232, w29, w19, 5);
   TEST_I5("clti_u.h", 240, w30, w4,  29);
   TEST_I5("clti_u.h",   0, w31, w4,  28);
   TEST_I5("clti_u.w",   0, w0,  w16, 3);
   TEST_I5("clti_u.w",   8, w1,  w3,  24);
   TEST_I5("clti_u.w",  16, w2,  w29, 13);
   TEST_I5("clti_u.w",  24, w3,  w14, 7);
   TEST_I5("clti_u.w",  32, w4,  w15, 8);
   TEST_I5("clti_u.w",  40, w5,  w6,  15);
   TEST_I5("clti_u.w",  48, w6,  w5,  6);
   TEST_I5("clti_u.w",  56, w7,  w7,  13);
   TEST_I5("clti_u.w",  64, w8,  w6,  21);
   TEST_I5("clti_u.w",  72, w9,  w9,  29);
   TEST_I5("clti_u.w",  80, w10, w24, 1);
   TEST_I5("clti_u.w",  88, w11, w6,  4);
   TEST_I5("clti_u.w",  96, w12, w22, 7);
   TEST_I5("clti_u.w", 104, w13, w26, 4);
   TEST_I5("clti_u.w", 112, w14, w8,  19);
   TEST_I5("clti_u.w", 120, w15, w25, 23);
   TEST_I5("clti_u.w", 128, w16, w31, 7);
   TEST_I5("clti_u.w", 136, w17, w4,  13);
   TEST_I5("clti_u.w", 144, w18, w24, 7);
   TEST_I5("clti_u.w", 152, w19, w3,  31);
   TEST_I5("clti_u.w", 160, w20, w12, 6);
   TEST_I5("clti_u.w", 168, w21, w17, 28);
   TEST_I5("clti_u.w", 176, w22, w21, 22);
   TEST_I5("clti_u.w", 184, w23, w18, 30);
   TEST_I5("clti_u.w", 192, w24, w28, 14);
   TEST_I5("clti_u.w", 200, w25, w22, 5);
   TEST_I5("clti_u.w", 208, w26, w21, 12);
   TEST_I5("clti_u.w", 216, w27, w26, 12);
   TEST_I5("clti_u.w", 224, w28, w19, 19);
   TEST_I5("clti_u.w", 232, w29, w23, 18);
   TEST_I5("clti_u.w", 240, w30, w3,  24);
   TEST_I5("clti_u.w", 136, w31, w20, 21);
   TEST_I5("clti_u.d",   0, w0,  w5,  28);
   TEST_I5("clti_u.d",   8, w1,  w27, 10);
   TEST_I5("clti_u.d",  16, w2,  w24, 24);
   TEST_I5("clti_u.d",  24, w3,  w14, 8);
   TEST_I5("clti_u.d",  32, w4,  w29, 10);
   TEST_I5("clti_u.d",  40, w5,  w30, 3);
   TEST_I5("clti_u.d",  48, w6,  w10, 3);
   TEST_I5("clti_u.d",  56, w7,  w7,  29);
   TEST_I5("clti_u.d",  64, w8,  w22, 15);
   TEST_I5("clti_u.d",  72, w9,  w9,  17);
   TEST_I5("clti_u.d",  80, w10, w8,  4);
   TEST_I5("clti_u.d",  88, w11, w29, 9);
   TEST_I5("clti_u.d",  96, w12, w8,  4);
   TEST_I5("clti_u.d", 104, w13, w18, 8);
   TEST_I5("clti_u.d", 112, w14, w10, 17);
   TEST_I5("clti_u.d", 120, w15, w8,  2);
   TEST_I5("clti_u.d", 128, w16, w18, 14);
   TEST_I5("clti_u.d", 136, w17, w21, 13);
   TEST_I5("clti_u.d", 144, w18, w25, 4);
   TEST_I5("clti_u.d", 152, w19, w0,  29);
   TEST_I5("clti_u.d", 160, w20, w17, 11);
   TEST_I5("clti_u.d", 168, w21, w22, 2);
   TEST_I5("clti_u.d", 176, w22, w31, 21);
   TEST_I5("clti_u.d", 184, w23, w4,  0);
   TEST_I5("clti_u.d", 192, w24, w12, 26);
   TEST_I5("clti_u.d", 200, w25, w29, 24);
   TEST_I5("clti_u.d", 208, w26, w31, 20);
   TEST_I5("clti_u.d", 216, w27, w13, 26);
   TEST_I5("clti_u.d", 224, w28, w27, 29);
   TEST_I5("clti_u.d", 232, w29, w31, 16);
   TEST_I5("clti_u.d", 240, w30, w28, 10);
   TEST_I5("clti_u.d", 168, w31, w7,  2);
#else
   printf("This test requires MSA extension.\n");
#endif
   return 0;
}
