/*
 *  linux/arch/arm/lib/getuser.S
 *
 *  Copyright (C) 2001 Russell King
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 *  Idea from x86 version, (C) Copyright 1998 Linus Torvalds
 *
 * These functions have a non-standard call interface to make them more
 * efficient, especially as they return an error value in addition to
 * the "real" return value.
 *
 * __get_user_X
 *
 * Inputs:	r0 contains the address
 * Outputs:	r0 is the error code
 *		r1, r2 contains the zero-extended value
 *		lr corrupted
 *
 * No other registers must be altered.  (see include/asm-arm/uaccess.h
 * for specific ASM register usage).
 *
 * Note that ADDR_LIMIT is either 0 or 0xc0000000.
 * Note also that it is intended that __get_user_bad is not global.
 */
#include <asm/constants.h>
#include <asm/thread_info.h>
#include <asm/errno.h>

	.global	__get_user_1
__get_user_1:
1:	ldrbt	r1, [r0]
	mov	r0, #0
	mov	pc, lr

	.global	__get_user_2
__get_user_2:
2:	ldrbt	r1, [r0], #1
3:	ldrbt	r2, [r0]
#ifndef __ARMEB__
	orr	r1, r1, r2, lsl #8
#else
	orr	r1, r2, r1, lsl #8
#endif
	mov	r0, #0
	mov	pc, lr

	.global	__get_user_4
__get_user_4:
4:	ldrt	r1, [r0]
	mov	r0, #0
	mov	pc, lr

	.global	__get_user_8
__get_user_8:
5:	ldrt	r1, [r0], #4
6:	ldrt	r2, [r0]
	mov	r0, #0
	mov	pc, lr

__get_user_bad_8:
	mov	r2, #0
__get_user_bad:
	mov	r1, #0
	mov	r0, #-EFAULT
	mov	pc, lr

.section __ex_table, "a"
	.long	1b, __get_user_bad
	.long	2b, __get_user_bad
	.long	3b, __get_user_bad
	.long	4b, __get_user_bad
	.long	5b, __get_user_bad_8
	.long	6b, __get_user_bad_8
.previous
