/*
 * drx3973d_map_firm.h
 *
 * Copyright (C) 2006-2007 Micronas
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * version 2 only, as published by the Free Software Foundation.
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA
 * Or, point your browser to http://www.gnu.org/copyleft/gpl.html
 */

#ifndef __DRX3973D_MAP__H__
#define __DRX3973D_MAP__H__

/*
 * Note: originally, this file contained 12000+ lines of data
 * Probably a few lines for every firwmare assembler instruction. However,
 * only a few defines were actually used. So, removed all uneeded lines.
 * If ever needed, the other lines can be easily obtained via git history.
 */

#define HI_COMM_EXEC__A                                              0x400000
#define HI_COMM_MB__A                                                0x400002
#define HI_CT_REG_COMM_STATE__A                                      0x410001
#define HI_RA_RAM_SRV_RES__A                                         0x420031
#define HI_RA_RAM_SRV_CMD__A                                         0x420032
#define   HI_RA_RAM_SRV_CMD_RESET                                    0x2
#define   HI_RA_RAM_SRV_CMD_CONFIG                                   0x3
#define   HI_RA_RAM_SRV_CMD_EXECUTE                                  0x6
#define HI_RA_RAM_SRV_RST_KEY__A                                     0x420033
#define   HI_RA_RAM_SRV_RST_KEY_ACT                                  0x3973
#define HI_RA_RAM_SRV_CFG_KEY__A                                     0x420033
#define HI_RA_RAM_SRV_CFG_DIV__A                                     0x420034
#define HI_RA_RAM_SRV_CFG_BDL__A                                     0x420035
#define HI_RA_RAM_SRV_CFG_WUP__A                                     0x420036
#define HI_RA_RAM_SRV_CFG_ACT__A                                     0x420037
#define     HI_RA_RAM_SRV_CFG_ACT_SLV0_ON                            0x1
#define   HI_RA_RAM_SRV_CFG_ACT_BRD__M                               0x4
#define     HI_RA_RAM_SRV_CFG_ACT_BRD_OFF                            0x0
#define     HI_RA_RAM_SRV_CFG_ACT_BRD_ON                             0x4
#define     HI_RA_RAM_SRV_CFG_ACT_PWD_EXE                            0x8
#define HI_RA_RAM_USR_BEGIN__A                                       0x420040
#define HI_IF_RAM_TRP_BPT0__AX                                       0x430000
#define HI_IF_RAM_USR_BEGIN__A                                       0x430200
#define SC_COMM_EXEC__A                                              0x800000
#define     SC_COMM_EXEC_CTL_STOP                                    0x0
#define SC_COMM_STATE__A                                             0x800001
#define SC_RA_RAM_PARAM0__A                                          0x820040
#define SC_RA_RAM_PARAM1__A                                          0x820041
#define SC_RA_RAM_CMD_ADDR__A                                        0x820042
#define SC_RA_RAM_CMD__A                                             0x820043
#define   SC_RA_RAM_CMD_PROC_START                                   0x1
#define   SC_RA_RAM_CMD_SET_PREF_PARAM                               0x3
#define   SC_RA_RAM_CMD_GET_OP_PARAM                                 0x5
#define   SC_RA_RAM_SW_EVENT_RUN_NMASK__M                            0x1
#define   SC_RA_RAM_LOCKTRACK_MIN                                    0x1
#define     SC_RA_RAM_OP_PARAM_MODE_2K                               0x0
#define     SC_RA_RAM_OP_PARAM_MODE_8K                               0x1
#define     SC_RA_RAM_OP_PARAM_GUARD_32                              0x0
#define     SC_RA_RAM_OP_PARAM_GUARD_16                              0x4
#define     SC_RA_RAM_OP_PARAM_GUARD_8                               0x8
#define     SC_RA_RAM_OP_PARAM_GUARD_4                               0xC
#define     SC_RA_RAM_OP_PARAM_CONST_QPSK                            0x0
#define     SC_RA_RAM_OP_PARAM_CONST_QAM16                           0x10
#define     SC_RA_RAM_OP_PARAM_CONST_QAM64                           0x20
#define     SC_RA_RAM_OP_PARAM_HIER_NO                               0x0
#define     SC_RA_RAM_OP_PARAM_HIER_A1                               0x40
#define     SC_RA_RAM_OP_PARAM_HIER_A2                               0x80
#define     SC_RA_RAM_OP_PARAM_HIER_A4                               0xC0
#define     SC_RA_RAM_OP_PARAM_RATE_1_2                              0x0
#define     SC_RA_RAM_OP_PARAM_RATE_2_3                              0x200
#define     SC_RA_RAM_OP_PARAM_RATE_3_4                              0x400
#define     SC_RA_RAM_OP_PARAM_RATE_5_6                              0x600
#define     SC_RA_RAM_OP_PARAM_RATE_7_8                              0x800
#define     SC_RA_RAM_OP_PARAM_PRIO_HI                               0x0
#define     SC_RA_RAM_OP_PARAM_PRIO_LO                               0x1000
#define   SC_RA_RAM_OP_AUTO_MODE__M                                  0x1
#define   SC_RA_RAM_OP_AUTO_GUARD__M                                 0x2
#define   SC_RA_RAM_OP_AUTO_CONST__M                                 0x4
#define   SC_RA_RAM_OP_AUTO_HIER__M                                  0x8
#define   SC_RA_RAM_OP_AUTO_RATE__M                                  0x10
#define SC_RA_RAM_LOCK__A                                            0x82004B
#define   SC_RA_RAM_LOCK_DEMOD__M                                    0x1
#define   SC_RA_RAM_LOCK_FEC__M                                      0x2
#define   SC_RA_RAM_LOCK_MPEG__M                                     0x4
#define SC_RA_RAM_BE_OPT_ENA__A                                      0x82004C
#define   SC_RA_RAM_BE_OPT_ENA_CP_OPT                                0x1
#define SC_RA_RAM_BE_OPT_DELAY__A                                    0x82004D
#define SC_RA_RAM_CONFIG__A                                          0x820050
#define   SC_RA_RAM_CONFIG_FR_ENABLE__M                              0x4
#define   SC_RA_RAM_CONFIG_FREQSCAN__M                               0x10
#define   SC_RA_RAM_CONFIG_SLAVE__M                                  0x20
#define SC_RA_RAM_IF_SAVE__AX                                        0x82008E
#define SC_RA_RAM_IR_COARSE_2K_LENGTH__A                             0x8200D1
#define SC_RA_RAM_IR_COARSE_2K_LENGTH__PRE                           0x9
#define SC_RA_RAM_IR_COARSE_2K_FREQINC__A                            0x8200D2
#define SC_RA_RAM_IR_COARSE_2K_FREQINC__PRE                          0x4
#define SC_RA_RAM_IR_COARSE_2K_KAISINC__A                            0x8200D3
#define SC_RA_RAM_IR_COARSE_2K_KAISINC__PRE                          0x100
#define SC_RA_RAM_IR_COARSE_8K_LENGTH__A                             0x8200D4
#define SC_RA_RAM_IR_COARSE_8K_LENGTH__PRE                           0x8
#define SC_RA_RAM_IR_COARSE_8K_FREQINC__A                            0x8200D5
#define SC_RA_RAM_IR_COARSE_8K_FREQINC__PRE                          0x8
#define SC_RA_RAM_IR_COARSE_8K_KAISINC__A                            0x8200D6
#define SC_RA_RAM_IR_COARSE_8K_KAISINC__PRE                          0x200
#define SC_RA_RAM_IR_FINE_2K_LENGTH__A                               0x8200D7
#define SC_RA_RAM_IR_FINE_2K_LENGTH__PRE                             0x9
#define SC_RA_RAM_IR_FINE_2K_FREQINC__A                              0x8200D8
#define SC_RA_RAM_IR_FINE_2K_FREQINC__PRE                            0x4
#define SC_RA_RAM_IR_FINE_2K_KAISINC__A                              0x8200D9
#define SC_RA_RAM_IR_FINE_2K_KAISINC__PRE                            0x100
#define SC_RA_RAM_IR_FINE_8K_LENGTH__A                               0x8200DA
#define SC_RA_RAM_IR_FINE_8K_LENGTH__PRE                             0xB
#define SC_RA_RAM_IR_FINE_8K_FREQINC__A                              0x8200DB
#define SC_RA_RAM_IR_FINE_8K_FREQINC__PRE                            0x1
#define SC_RA_RAM_IR_FINE_8K_KAISINC__A                              0x8200DC
#define SC_RA_RAM_IR_FINE_8K_KAISINC__PRE                            0x40
#define SC_RA_RAM_ECHO_SHIFT_LIM__A                                  0x8200DD
#define SC_RA_RAM_SAMPLE_RATE_COUNT__A                               0x8200E8
#define SC_RA_RAM_SAMPLE_RATE_STEP__A                                0x8200E9
#define SC_RA_RAM_BAND__A                                            0x8200EC
#define SC_RA_RAM_LC_ABS_2K__A                                       0x8200F4
#define SC_RA_RAM_LC_ABS_2K__PRE                                     0x1F
#define SC_RA_RAM_LC_ABS_8K__A                                       0x8200F5
#define SC_RA_RAM_LC_ABS_8K__PRE                                     0x1F
#define SC_RA_RAM_EQ_IS_GAIN_UNKNOWN_MAN__PRE                        0x1D6
#define SC_RA_RAM_EQ_IS_GAIN_UNKNOWN_EXP__PRE                        0x4
#define SC_RA_RAM_EQ_IS_GAIN_QPSK_MAN__PRE                           0x1BB
#define SC_RA_RAM_EQ_IS_GAIN_QPSK_EXP__PRE                           0x5
#define SC_RA_RAM_EQ_IS_GAIN_16QAM_MAN__PRE                          0x1EF
#define SC_RA_RAM_EQ_IS_GAIN_16QAM_EXP__PRE                          0x5
#define SC_RA_RAM_EQ_IS_GAIN_16QAM_A2_MAN__PRE                       0x15E
#define SC_RA_RAM_EQ_IS_GAIN_16QAM_A2_EXP__PRE                       0x5
#define SC_RA_RAM_EQ_IS_GAIN_16QAM_A4_MAN__PRE                       0x11A
#define SC_RA_RAM_EQ_IS_GAIN_16QAM_A4_EXP__PRE                       0x6
#define SC_RA_RAM_EQ_IS_GAIN_64QAM_MAN__PRE                          0x1FB
#define SC_RA_RAM_EQ_IS_GAIN_64QAM_EXP__PRE                          0x5
#define SC_RA_RAM_EQ_IS_GAIN_64QAM_A2_MAN__PRE                       0x12F
#define SC_RA_RAM_EQ_IS_GAIN_64QAM_A2_EXP__PRE                       0x5
#define SC_RA_RAM_EQ_IS_GAIN_64QAM_A4_MAN__PRE                       0x197
#define SC_RA_RAM_EQ_IS_GAIN_64QAM_A4_EXP__PRE                       0x5
#define SC_RA_RAM_DRIVER_VERSION__AX                                 0x8201FE
#define   SC_RA_RAM_PROC_LOCKTRACK                                   0x0
#define FE_COMM_EXEC__A                                              0xC00000
#define FE_AD_REG_COMM_EXEC__A                                       0xC10000
#define FE_AD_REG_FDB_IN__A                                          0xC10012
#define FE_AD_REG_PD__A                                              0xC10013
#define FE_AD_REG_INVEXT__A                                          0xC10014
#define FE_AD_REG_CLKNEG__A                                          0xC10015
#define FE_AG_REG_COMM_EXEC__A                                       0xC20000
#define FE_AG_REG_AG_MODE_LOP__A                                     0xC20010
#define   FE_AG_REG_AG_MODE_LOP_MODE_4__M                            0x10
#define     FE_AG_REG_AG_MODE_LOP_MODE_4_STATIC                      0x0
#define     FE_AG_REG_AG_MODE_LOP_MODE_4_DYNAMIC                     0x10
#define   FE_AG_REG_AG_MODE_LOP_MODE_5__M                            0x20
#define     FE_AG_REG_AG_MODE_LOP_MODE_5_STATIC                      0x0
#define   FE_AG_REG_AG_MODE_LOP_MODE_C__M                            0x1000
#define     FE_AG_REG_AG_MODE_LOP_MODE_C_STATIC                      0x0
#define     FE_AG_REG_AG_MODE_LOP_MODE_C_DYNAMIC                     0x1000
#define   FE_AG_REG_AG_MODE_LOP_MODE_E__M                            0x4000
#define     FE_AG_REG_AG_MODE_LOP_MODE_E_STATIC                      0x0
#define     FE_AG_REG_AG_MODE_LOP_MODE_E_DYNAMIC                     0x4000
#define FE_AG_REG_AG_MODE_HIP__A                                     0xC20011
#define FE_AG_REG_AG_PGA_MODE__A                                     0xC20012
#define   FE_AG_REG_AG_PGA_MODE_PFY_PCY_AFY_REN                      0x0
#define   FE_AG_REG_AG_PGA_MODE_PFN_PCN_AFY_REN                      0x1
#define FE_AG_REG_AG_AGC_SIO__A                                      0xC20013
#define   FE_AG_REG_AG_AGC_SIO_AGC_SIO_2__M                          0x2
#define     FE_AG_REG_AG_AGC_SIO_AGC_SIO_2_OUTPUT                    0x0
#define     FE_AG_REG_AG_AGC_SIO_AGC_SIO_2_INPUT                     0x2
#define FE_AG_REG_AG_PWD__A                                          0xC20015
#define   FE_AG_REG_AG_PWD_PWD_PD2__M                                0x2
#define     FE_AG_REG_AG_PWD_PWD_PD2_DISABLE                         0x0
#define     FE_AG_REG_AG_PWD_PWD_PD2_ENABLE                          0x2
#define FE_AG_REG_DCE_AUR_CNT__A                                     0xC20016
#define FE_AG_REG_DCE_RUR_CNT__A                                     0xC20017
#define FE_AG_REG_ACE_AUR_CNT__A                                     0xC2001A
#define FE_AG_REG_ACE_RUR_CNT__A                                     0xC2001B
#define FE_AG_REG_CDR_RUR_CNT__A                                     0xC20020
#define FE_AG_REG_EGC_RUR_CNT__A                                     0xC20024
#define FE_AG_REG_EGC_SET_LVL__A                                     0xC20025
#define FE_AG_REG_EGC_SET_LVL__M                                     0x1FF
#define FE_AG_REG_EGC_FLA_RGN__A                                     0xC20026
#define FE_AG_REG_EGC_SLO_RGN__A                                     0xC20027
#define FE_AG_REG_EGC_JMP_PSN__A                                     0xC20028
#define FE_AG_REG_EGC_FLA_INC__A                                     0xC20029
#define FE_AG_REG_EGC_FLA_DEC__A                                     0xC2002A
#define FE_AG_REG_EGC_SLO_INC__A                                     0xC2002B
#define FE_AG_REG_EGC_SLO_DEC__A                                     0xC2002C
#define FE_AG_REG_EGC_FAS_INC__A                                     0xC2002D
#define FE_AG_REG_EGC_FAS_DEC__A                                     0xC2002E
#define FE_AG_REG_PM1_AGC_WRI__A                                     0xC20030
#define FE_AG_REG_PM1_AGC_WRI__M                                     0x7FF
#define FE_AG_REG_GC1_AGC_RIC__A                                     0xC20031
#define FE_AG_REG_GC1_AGC_OFF__A                                     0xC20032
#define FE_AG_REG_GC1_AGC_MAX__A                                     0xC20033
#define FE_AG_REG_GC1_AGC_MIN__A                                     0xC20034
#define FE_AG_REG_GC1_AGC_DAT__A                                     0xC20035
#define FE_AG_REG_GC1_AGC_DAT__M                                     0x3FF
#define FE_AG_REG_PM2_AGC_WRI__A                                     0xC20036
#define FE_AG_REG_IND_WIN__A                                         0xC2003C
#define FE_AG_REG_IND_THD_LOL__A                                     0xC2003D
#define FE_AG_REG_IND_THD_HIL__A                                     0xC2003E
#define FE_AG_REG_IND_DEL__A                                         0xC2003F
#define FE_AG_REG_IND_PD1_WRI__A                                     0xC20040
#define FE_AG_REG_PDA_AUR_CNT__A                                     0xC20041
#define FE_AG_REG_PDA_RUR_CNT__A                                     0xC20042
#define FE_AG_REG_PDA_AVE_DAT__A                                     0xC20043
#define FE_AG_REG_PDC_RUR_CNT__A                                     0xC20044
#define FE_AG_REG_PDC_SET_LVL__A                                     0xC20045
#define FE_AG_REG_PDC_FLA_RGN__A                                     0xC20046
#define FE_AG_REG_PDC_JMP_PSN__A                                     0xC20047
#define FE_AG_REG_PDC_FLA_STP__A                                     0xC20048
#define FE_AG_REG_PDC_SLO_STP__A                                     0xC20049
#define FE_AG_REG_PDC_PD2_WRI__A                                     0xC2004A
#define FE_AG_REG_PDC_MAP_DAT__A                                     0xC2004B
#define FE_AG_REG_PDC_MAX__A                                         0xC2004C
#define FE_AG_REG_TGA_AUR_CNT__A                                     0xC2004D
#define FE_AG_REG_TGA_RUR_CNT__A                                     0xC2004E
#define FE_AG_REG_TGA_AVE_DAT__A                                     0xC2004F
#define FE_AG_REG_TGC_RUR_CNT__A                                     0xC20050
#define FE_AG_REG_TGC_SET_LVL__A                                     0xC20051
#define FE_AG_REG_TGC_SET_LVL__M                                     0x3F
#define FE_AG_REG_TGC_FLA_RGN__A                                     0xC20052
#define FE_AG_REG_TGC_JMP_PSN__A                                     0xC20053
#define FE_AG_REG_TGC_FLA_STP__A                                     0xC20054
#define FE_AG_REG_TGC_SLO_STP__A                                     0xC20055
#define FE_AG_REG_TGC_MAP_DAT__A                                     0xC20056
#define FE_AG_REG_FGA_AUR_CNT__A                                     0xC20057
#define FE_AG_REG_FGA_RUR_CNT__A                                     0xC20058
#define FE_AG_REG_FGM_WRI__A                                         0xC20061
#define FE_AG_REG_BGC_FGC_WRI__A                                     0xC20068
#define FE_AG_REG_BGC_CGC_WRI__A                                     0xC20069
#define FE_FS_REG_COMM_EXEC__A                                       0xC30000
#define FE_FS_REG_ADD_INC_LOP__A                                     0xC30010
#define FE_FD_REG_COMM_EXEC__A                                       0xC40000
#define FE_FD_REG_SCL__A                                             0xC40010
#define FE_FD_REG_MAX_LEV__A                                         0xC40011
#define FE_FD_REG_NR__A                                              0xC40012
#define FE_FD_REG_MEAS_VAL__A                                        0xC40014
#define FE_IF_REG_COMM_EXEC__A                                       0xC50000
#define FE_IF_REG_INCR0__A                                           0xC50010
#define FE_IF_REG_INCR0__W                                           16
#define FE_IF_REG_INCR0__M                                           0xFFFF
#define FE_IF_REG_INCR1__A                                           0xC50011
#define FE_IF_REG_INCR1__M                                           0xFF
#define FE_CF_REG_COMM_EXEC__A                                       0xC60000
#define FE_CF_REG_SCL__A                                             0xC60010
#define FE_CF_REG_MAX_LEV__A                                         0xC60011
#define FE_CF_REG_NR__A                                              0xC60012
#define FE_CF_REG_IMP_VAL__A                                         0xC60013
#define FE_CF_REG_MEAS_VAL__A                                        0xC60014
#define FE_CU_REG_COMM_EXEC__A                                       0xC70000
#define FE_CU_REG_FRM_CNT_RST__A                                     0xC70011
#define FE_CU_REG_FRM_CNT_STR__A                                     0xC70012
#define FT_COMM_EXEC__A                                              0x1000000
#define FT_REG_COMM_EXEC__A                                          0x1010000
#define CP_COMM_EXEC__A                                              0x1400000
#define CP_REG_COMM_EXEC__A                                          0x1410000
#define CP_REG_INTERVAL__A                                           0x1410011
#define CP_REG_BR_SPL_OFFSET__A                                      0x1410023
#define CP_REG_BR_STR_DEL__A                                         0x1410024
#define CP_REG_RT_ANG_INC0__A                                        0x1410030
#define CP_REG_RT_ANG_INC1__A                                        0x1410031
#define CP_REG_RT_DETECT_ENA__A                                      0x1410032
#define CP_REG_RT_DETECT_TRH__A                                      0x1410033
#define CP_REG_RT_EXP_MARG__A                                        0x141003E
#define CP_REG_AC_NEXP_OFFS__A                                       0x1410040
#define CP_REG_AC_AVER_POW__A                                        0x1410041
#define CP_REG_AC_MAX_POW__A                                         0x1410042
#define CP_REG_AC_WEIGHT_MAN__A                                      0x1410043
#define CP_REG_AC_WEIGHT_EXP__A                                      0x1410044
#define CP_REG_AC_AMP_MODE__A                                        0x1410047
#define CP_REG_AC_AMP_FIX__A                                         0x1410048
#define CP_REG_AC_ANG_MODE__A                                        0x141004A
#define CE_COMM_EXEC__A                                              0x1800000
#define CE_REG_COMM_EXEC__A                                          0x1810000
#define CE_REG_TAPSET__A                                             0x1810011
#define CE_REG_AVG_POW__A                                            0x1810012
#define CE_REG_MAX_POW__A                                            0x1810013
#define CE_REG_ATT__A                                                0x1810014
#define CE_REG_NRED__A                                               0x1810015
#define CE_REG_NE_ERR_SELECT__A                                      0x1810043
#define CE_REG_NE_TD_CAL__A                                          0x1810044
#define CE_REG_NE_MIXAVG__A                                          0x1810046
#define CE_REG_NE_NUPD_OFS__A                                        0x1810047
#define CE_REG_PE_NEXP_OFFS__A                                       0x1810050
#define CE_REG_PE_TIMESHIFT__A                                       0x1810051
#define CE_REG_TP_A0_TAP_NEW__A                                      0x1810064
#define CE_REG_TP_A0_TAP_NEW_VALID__A                                0x1810065
#define CE_REG_TP_A0_MU_LMS_STEP__A                                  0x1810066
#define CE_REG_TP_A1_TAP_NEW__A                                      0x1810068
#define CE_REG_TP_A1_TAP_NEW_VALID__A                                0x1810069
#define CE_REG_TP_A1_MU_LMS_STEP__A                                  0x181006A
#define CE_REG_TI_NEXP_OFFS__A                                       0x1810070
#define CE_REG_FI_SHT_INCR__A                                        0x1810090
#define CE_REG_FI_EXP_NORM__A                                        0x1810091
#define CE_REG_IR_INPUTSEL__A                                        0x18100A0
#define CE_REG_IR_STARTPOS__A                                        0x18100A1
#define CE_REG_IR_NEXP_THRES__A                                      0x18100A2
#define CE_REG_FR_TREAL00__A                                         0x1820010
#define CE_REG_FR_TIMAG00__A                                         0x1820011
#define CE_REG_FR_TREAL01__A                                         0x1820012
#define CE_REG_FR_TIMAG01__A                                         0x1820013
#define CE_REG_FR_TREAL02__A                                         0x1820014
#define CE_REG_FR_TIMAG02__A                                         0x1820015
#define CE_REG_FR_TREAL03__A                                         0x1820016
#define CE_REG_FR_TIMAG03__A                                         0x1820017
#define CE_REG_FR_TREAL04__A                                         0x1820018
#define CE_REG_FR_TIMAG04__A                                         0x1820019
#define CE_REG_FR_TREAL05__A                                         0x182001A
#define CE_REG_FR_TIMAG05__A                                         0x182001B
#define CE_REG_FR_TREAL06__A                                         0x182001C
#define CE_REG_FR_TIMAG06__A                                         0x182001D
#define CE_REG_FR_TREAL07__A                                         0x182001E
#define CE_REG_FR_TIMAG07__A                                         0x182001F
#define CE_REG_FR_TREAL08__A                                         0x1820020
#define CE_REG_FR_TIMAG08__A                                         0x1820021
#define CE_REG_FR_TREAL09__A                                         0x1820022
#define CE_REG_FR_TIMAG09__A                                         0x1820023
#define CE_REG_FR_TREAL10__A                                         0x1820024
#define CE_REG_FR_TIMAG10__A                                         0x1820025
#define CE_REG_FR_TREAL11__A                                         0x1820026
#define CE_REG_FR_TIMAG11__A                                         0x1820027
#define CE_REG_FR_MID_TAP__A                                         0x1820028
#define CE_REG_FR_SQS_G00__A                                         0x1820029
#define CE_REG_FR_SQS_G01__A                                         0x182002A
#define CE_REG_FR_SQS_G02__A                                         0x182002B
#define CE_REG_FR_SQS_G03__A                                         0x182002C
#define CE_REG_FR_SQS_G04__A                                         0x182002D
#define CE_REG_FR_SQS_G05__A                                         0x182002E
#define CE_REG_FR_SQS_G06__A                                         0x182002F
#define CE_REG_FR_SQS_G07__A                                         0x1820030
#define CE_REG_FR_SQS_G08__A                                         0x1820031
#define CE_REG_FR_SQS_G09__A                                         0x1820032
#define CE_REG_FR_SQS_G10__A                                         0x1820033
#define CE_REG_FR_SQS_G11__A                                         0x1820034
#define CE_REG_FR_SQS_G12__A                                         0x1820035
#define CE_REG_FR_RIO_G00__A                                         0x1820036
#define CE_REG_FR_RIO_G01__A                                         0x1820037
#define CE_REG_FR_RIO_G02__A                                         0x1820038
#define CE_REG_FR_RIO_G03__A                                         0x1820039
#define CE_REG_FR_RIO_G04__A                                         0x182003A
#define CE_REG_FR_RIO_G05__A                                         0x182003B
#define CE_REG_FR_RIO_G06__A                                         0x182003C
#define CE_REG_FR_RIO_G07__A                                         0x182003D
#define CE_REG_FR_RIO_G08__A                                         0x182003E
#define CE_REG_FR_RIO_G09__A                                         0x182003F
#define CE_REG_FR_RIO_G10__A                                         0x1820040
#define CE_REG_FR_MODE__A                                            0x1820041
#define CE_REG_FR_SQS_TRH__A                                         0x1820042
#define CE_REG_FR_RIO_GAIN__A                                        0x1820043
#define CE_REG_FR_BYPASS__A                                          0x1820044
#define CE_REG_FR_PM_SET__A                                          0x1820045
#define CE_REG_FR_ERR_SH__A                                          0x1820046
#define CE_REG_FR_MAN_SH__A                                          0x1820047
#define CE_REG_FR_TAP_SH__A                                          0x1820048
#define EQ_COMM_EXEC__A                                              0x1C00000
#define EQ_REG_COMM_EXEC__A                                          0x1C10000
#define EQ_REG_COMM_MB__A                                            0x1C10002
#define EQ_REG_IS_GAIN_MAN__A                                        0x1C10015
#define EQ_REG_IS_GAIN_EXP__A                                        0x1C10016
#define EQ_REG_IS_CLIP_EXP__A                                        0x1C10017
#define EQ_REG_SN_CEGAIN__A                                          0x1C1002A
#define EQ_REG_SN_OFFSET__A                                          0x1C1002B
#define EQ_REG_RC_SEL_CAR__A                                         0x1C10032
#define   EQ_REG_RC_SEL_CAR_INIT                                     0x0
#define     EQ_REG_RC_SEL_CAR_DIV_ON                                 0x1
#define     EQ_REG_RC_SEL_CAR_PASS_A_CC                              0x0
#define     EQ_REG_RC_SEL_CAR_PASS_B_CE                              0x2
#define     EQ_REG_RC_SEL_CAR_LOCAL_A_CC                             0x0
#define     EQ_REG_RC_SEL_CAR_LOCAL_B_CE                             0x8
#define     EQ_REG_RC_SEL_CAR_MEAS_A_CC                              0x0
#define     EQ_REG_RC_SEL_CAR_MEAS_B_CE                              0x20
#define EQ_REG_OT_CONST__A                                           0x1C10046
#define EQ_REG_OT_ALPHA__A                                           0x1C10047
#define EQ_REG_OT_QNT_THRES0__A                                      0x1C10048
#define EQ_REG_OT_QNT_THRES1__A                                      0x1C10049
#define EQ_REG_OT_CSI_STEP__A                                        0x1C1004A
#define EQ_REG_OT_CSI_OFFSET__A                                      0x1C1004B
#define EQ_REG_TD_REQ_SMB_CNT__A                                     0x1C10061
#define EQ_REG_TD_TPS_PWR_OFS__A                                     0x1C10062
#define EC_SB_REG_COMM_EXEC__A                                       0x2010000
#define EC_SB_REG_TR_MODE__A                                         0x2010010
#define   EC_SB_REG_TR_MODE_8K                                       0x0
#define   EC_SB_REG_TR_MODE_2K                                       0x1
#define EC_SB_REG_CONST__A                                           0x2010011
#define   EC_SB_REG_CONST_QPSK                                       0x0
#define   EC_SB_REG_CONST_16QAM                                      0x1
#define   EC_SB_REG_CONST_64QAM                                      0x2
#define EC_SB_REG_ALPHA__A                                           0x2010012
#define EC_SB_REG_PRIOR__A                                           0x2010013
#define   EC_SB_REG_PRIOR_HI                                         0x0
#define   EC_SB_REG_PRIOR_LO                                         0x1
#define EC_SB_REG_CSI_HI__A                                          0x2010014
#define EC_SB_REG_CSI_LO__A                                          0x2010015
#define EC_SB_REG_SMB_TGL__A                                         0x2010016
#define EC_SB_REG_SNR_HI__A                                          0x2010017
#define EC_SB_REG_SNR_MID__A                                         0x2010018
#define EC_SB_REG_SNR_LO__A                                          0x2010019
#define EC_SB_REG_SCALE_MSB__A                                       0x201001A
#define EC_SB_REG_SCALE_BIT2__A                                      0x201001B
#define EC_SB_REG_SCALE_LSB__A                                       0x201001C
#define EC_SB_REG_CSI_OFS__A                                         0x201001D
#define EC_VD_REG_COMM_EXEC__A                                       0x2090000
#define EC_VD_REG_FORCE__A                                           0x2090010
#define EC_VD_REG_SET_CODERATE__A                                    0x2090011
#define   EC_VD_REG_SET_CODERATE_C1_2                                0x0
#define   EC_VD_REG_SET_CODERATE_C2_3                                0x1
#define   EC_VD_REG_SET_CODERATE_C3_4                                0x2
#define   EC_VD_REG_SET_CODERATE_C5_6                                0x3
#define   EC_VD_REG_SET_CODERATE_C7_8                                0x4
#define EC_VD_REG_REQ_SMB_CNT__A                                     0x2090012
#define EC_VD_REG_RLK_ENA__A                                         0x2090014
#define EC_OD_REG_COMM_EXEC__A                                       0x2110000
#define EC_OD_REG_SYNC__A                                            0x2110010
#define EC_OD_DEINT_RAM__A                                           0x2120000
#define EC_RS_REG_COMM_EXEC__A                                       0x2130000
#define EC_RS_REG_REQ_PCK_CNT__A                                     0x2130010
#define EC_RS_REG_VAL__A                                             0x2130011
#define   EC_RS_REG_VAL_PCK                                          0x1
#define EC_RS_EC_RAM__A                                              0x2140000
#define EC_OC_REG_COMM_EXEC__A                                       0x2150000
#define     EC_OC_REG_COMM_EXEC_CTL_ACTIVE                           0x1
#define     EC_OC_REG_COMM_EXEC_CTL_HOLD                             0x2
#define EC_OC_REG_COMM_INT_STA__A                                    0x2150007
#define EC_OC_REG_OC_MODE_LOP__A                                     0x2150010
#define   EC_OC_REG_OC_MODE_LOP_PAR_ENA__M                           0x1
#define     EC_OC_REG_OC_MODE_LOP_PAR_ENA_ENABLE                     0x0
#define     EC_OC_REG_OC_MODE_LOP_PAR_ENA_DISABLE                    0x1
#define   EC_OC_REG_OC_MODE_LOP_DTO_CTR_SRC__M                       0x4
#define     EC_OC_REG_OC_MODE_LOP_DTO_CTR_SRC_STATIC                 0x0
#define   EC_OC_REG_OC_MODE_LOP_MPG_TRM_MDE__M                       0x80
#define     EC_OC_REG_OC_MODE_LOP_MPG_TRM_MDE_SERIAL                 0x80
#define EC_OC_REG_OC_MODE_HIP__A                                     0x2150011
#define     EC_OC_REG_OC_MODE_HIP_MPG_BUS_SRC_MONITOR                0x10
#define   EC_OC_REG_OC_MODE_HIP_MPG_PAR_VAL__M                       0x200
#define     EC_OC_REG_OC_MODE_HIP_MPG_PAR_VAL_DISABLE                0x0
#define     EC_OC_REG_OC_MODE_HIP_MPG_PAR_VAL_ENABLE                 0x200
#define EC_OC_REG_OC_MPG_SIO__A                                      0x2150012
#define EC_OC_REG_OC_MPG_SIO__M                                      0xFFF
#define EC_OC_REG_OC_MON_SIO__A                                      0x2150013
#define EC_OC_REG_DTO_INC_LOP__A                                     0x2150014
#define EC_OC_REG_DTO_INC_HIP__A                                     0x2150015
#define EC_OC_REG_SNC_ISC_LVL__A                                     0x2150016
#define   EC_OC_REG_SNC_ISC_LVL_OSC__M                               0xF0
#define EC_OC_REG_TMD_TOP_MODE__A                                    0x215001D
#define EC_OC_REG_TMD_TOP_CNT__A                                     0x215001E
#define EC_OC_REG_TMD_HIL_MAR__A                                     0x215001F
#define EC_OC_REG_TMD_LOL_MAR__A                                     0x2150020
#define EC_OC_REG_TMD_CUR_CNT__A                                     0x2150021
#define EC_OC_REG_AVR_ASH_CNT__A                                     0x2150023
#define EC_OC_REG_AVR_BSH_CNT__A                                     0x2150024
#define EC_OC_REG_RCN_MODE__A                                        0x2150027
#define EC_OC_REG_RCN_CRA_LOP__A                                     0x2150028
#define EC_OC_REG_RCN_CRA_HIP__A                                     0x2150029
#define EC_OC_REG_RCN_CST_LOP__A                                     0x215002A
#define EC_OC_REG_RCN_CST_HIP__A                                     0x215002B
#define EC_OC_REG_RCN_SET_LVL__A                                     0x215002C
#define EC_OC_REG_RCN_GAI_LVL__A                                     0x215002D
#define EC_OC_REG_RCN_CLP_LOP__A                                     0x2150032
#define EC_OC_REG_RCN_CLP_HIP__A                                     0x2150033
#define EC_OC_REG_RCN_MAP_LOP__A                                     0x2150034
#define EC_OC_REG_RCN_MAP_HIP__A                                     0x2150035
#define EC_OC_REG_OCR_MPG_UOS__A                                     0x2150036
#define EC_OC_REG_OCR_MPG_UOS__M                                     0xFFF
#define   EC_OC_REG_OCR_MPG_UOS_INIT                                 0x0
#define EC_OC_REG_OCR_MPG_USR_DAT__A                                 0x2150038
#define EC_OC_REG_OCR_MON_UOS__A                                     0x2150039
#define     EC_OC_REG_OCR_MON_UOS_DAT_0_ENABLE                       0x1
#define     EC_OC_REG_OCR_MON_UOS_DAT_1_ENABLE                       0x2
#define     EC_OC_REG_OCR_MON_UOS_DAT_2_ENABLE                       0x4
#define     EC_OC_REG_OCR_MON_UOS_DAT_3_ENABLE                       0x8
#define     EC_OC_REG_OCR_MON_UOS_DAT_4_ENABLE                       0x10
#define     EC_OC_REG_OCR_MON_UOS_DAT_5_ENABLE                       0x20
#define     EC_OC_REG_OCR_MON_UOS_DAT_6_ENABLE                       0x40
#define     EC_OC_REG_OCR_MON_UOS_DAT_7_ENABLE                       0x80
#define     EC_OC_REG_OCR_MON_UOS_DAT_8_ENABLE                       0x100
#define     EC_OC_REG_OCR_MON_UOS_DAT_9_ENABLE                       0x200
#define     EC_OC_REG_OCR_MON_UOS_VAL_ENABLE                         0x400
#define     EC_OC_REG_OCR_MON_UOS_CLK_ENABLE                         0x800
#define EC_OC_REG_OCR_MON_WRI__A                                     0x215003A
#define   EC_OC_REG_OCR_MON_WRI_INIT                                 0x0
#define EC_OC_REG_IPR_INV_MPG__A                                     0x2150045
#define CC_REG_OSC_MODE__A                                           0x2410010
#define   CC_REG_OSC_MODE_M20                                        0x1
#define CC_REG_PLL_MODE__A                                           0x2410011
#define     CC_REG_PLL_MODE_BYPASS_PLL                               0x1
#define     CC_REG_PLL_MODE_PUMP_CUR_12                              0x14
#define CC_REG_REF_DIVIDE__A                                         0x2410012
#define CC_REG_PWD_MODE__A                                           0x2410015
#define   CC_REG_PWD_MODE_DOWN_PLL                                   0x2
#define CC_REG_UPDATE__A                                             0x2410017
#define   CC_REG_UPDATE_KEY                                          0x3973
#define CC_REG_JTAGID_L__A                                           0x2410019
#define LC_COMM_EXEC__A                                              0x2800000
#define LC_RA_RAM_IFINCR_NOM_L__A                                    0x282000C
#define LC_RA_RAM_FILTER_SYM_SET__A                                  0x282001A
#define LC_RA_RAM_FILTER_SYM_SET__PRE                                0x3E8
#define LC_RA_RAM_FILTER_CRMM_A__A                                   0x2820060
#define LC_RA_RAM_FILTER_CRMM_A__PRE                                 0x4
#define LC_RA_RAM_FILTER_CRMM_B__A                                   0x2820061
#define LC_RA_RAM_FILTER_CRMM_B__PRE                                 0x1
#define LC_RA_RAM_FILTER_SRMM_A__A                                   0x2820068
#define LC_RA_RAM_FILTER_SRMM_A__PRE                                 0x4
#define LC_RA_RAM_FILTER_SRMM_B__A                                   0x2820069
#define LC_RA_RAM_FILTER_SRMM_B__PRE                                 0x1
#define B_HI_COMM_EXEC__A                                            0x400000
#define B_HI_COMM_MB__A                                              0x400002
#define B_HI_CT_REG_COMM_STATE__A                                    0x410001
#define B_HI_RA_RAM_SRV_RES__A                                       0x420031
#define B_HI_RA_RAM_SRV_CMD__A                                       0x420032
#define   B_HI_RA_RAM_SRV_CMD_RESET                                  0x2
#define   B_HI_RA_RAM_SRV_CMD_CONFIG                                 0x3
#define   B_HI_RA_RAM_SRV_CMD_EXECUTE                                0x6
#define B_HI_RA_RAM_SRV_RST_KEY__A                                   0x420033
#define   B_HI_RA_RAM_SRV_RST_KEY_ACT                                0x3973
#define B_HI_RA_RAM_SRV_CFG_KEY__A                                   0x420033
#define B_HI_RA_RAM_SRV_CFG_DIV__A                                   0x420034
#define B_HI_RA_RAM_SRV_CFG_BDL__A                                   0x420035
#define B_HI_RA_RAM_SRV_CFG_WUP__A                                   0x420036
#define B_HI_RA_RAM_SRV_CFG_ACT__A                                   0x420037
#define     B_HI_RA_RAM_SRV_CFG_ACT_SLV0_ON                          0x1
#define   B_HI_RA_RAM_SRV_CFG_ACT_BRD__M                             0x4
#define     B_HI_RA_RAM_SRV_CFG_ACT_BRD_OFF                          0x0
#define     B_HI_RA_RAM_SRV_CFG_ACT_BRD_ON                           0x4
#define     B_HI_RA_RAM_SRV_CFG_ACT_PWD_EXE                          0x8
#define B_HI_RA_RAM_USR_BEGIN__A                                     0x420040
#define B_HI_IF_RAM_TRP_BPT0__AX                                     0x430000
#define B_HI_IF_RAM_USR_BEGIN__A                                     0x430200
#define B_SC_COMM_EXEC__A                                            0x800000
#define     B_SC_COMM_EXEC_CTL_STOP                                  0x0
#define B_SC_COMM_STATE__A                                           0x800001
#define B_SC_RA_RAM_PARAM0__A                                        0x820040
#define B_SC_RA_RAM_PARAM1__A                                        0x820041
#define B_SC_RA_RAM_CMD_ADDR__A                                      0x820042
#define B_SC_RA_RAM_CMD__A                                           0x820043
#define   B_SC_RA_RAM_CMD_PROC_START                                 0x1
#define   B_SC_RA_RAM_CMD_SET_PREF_PARAM                             0x3
#define   B_SC_RA_RAM_CMD_GET_OP_PARAM                               0x5
#define   B_SC_RA_RAM_SW_EVENT_RUN_NMASK__M                          0x1
#define   B_SC_RA_RAM_LOCKTRACK_MIN                                  0x1
#define     B_SC_RA_RAM_OP_PARAM_MODE_2K                             0x0
#define     B_SC_RA_RAM_OP_PARAM_MODE_8K                             0x1
#define     B_SC_RA_RAM_OP_PARAM_GUARD_32                            0x0
#define     B_SC_RA_RAM_OP_PARAM_GUARD_16                            0x4
#define     B_SC_RA_RAM_OP_PARAM_GUARD_8                             0x8
#define     B_SC_RA_RAM_OP_PARAM_GUARD_4                             0xC
#define     B_SC_RA_RAM_OP_PARAM_CONST_QPSK                          0x0
#define     B_SC_RA_RAM_OP_PARAM_CONST_QAM16                         0x10
#define     B_SC_RA_RAM_OP_PARAM_CONST_QAM64                         0x20
#define     B_SC_RA_RAM_OP_PARAM_HIER_NO                             0x0
#define     B_SC_RA_RAM_OP_PARAM_HIER_A1                             0x40
#define     B_SC_RA_RAM_OP_PARAM_HIER_A2                             0x80
#define     B_SC_RA_RAM_OP_PARAM_HIER_A4                             0xC0
#define     B_SC_RA_RAM_OP_PARAM_RATE_1_2                            0x0
#define     B_SC_RA_RAM_OP_PARAM_RATE_2_3                            0x200
#define     B_SC_RA_RAM_OP_PARAM_RATE_3_4                            0x400
#define     B_SC_RA_RAM_OP_PARAM_RATE_5_6                            0x600
#define     B_SC_RA_RAM_OP_PARAM_RATE_7_8                            0x800
#define     B_SC_RA_RAM_OP_PARAM_PRIO_HI                             0x0
#define     B_SC_RA_RAM_OP_PARAM_PRIO_LO                             0x1000
#define   B_SC_RA_RAM_OP_AUTO_MODE__M                                0x1
#define   B_SC_RA_RAM_OP_AUTO_GUARD__M                               0x2
#define   B_SC_RA_RAM_OP_AUTO_CONST__M                               0x4
#define   B_SC_RA_RAM_OP_AUTO_HIER__M                                0x8
#define   B_SC_RA_RAM_OP_AUTO_RATE__M                                0x10
#define B_SC_RA_RAM_LOCK__A                                          0x82004B
#define   B_SC_RA_RAM_LOCK_DEMOD__M                                  0x1
#define   B_SC_RA_RAM_LOCK_FEC__M                                    0x2
#define   B_SC_RA_RAM_LOCK_MPEG__M                                   0x4
#define B_SC_RA_RAM_BE_OPT_ENA__A                                    0x82004C
#define   B_SC_RA_RAM_BE_OPT_ENA_CP_OPT                              0x1
#define B_SC_RA_RAM_BE_OPT_DELAY__A                                  0x82004D
#define B_SC_RA_RAM_CONFIG__A                                        0x820050
#define   B_SC_RA_RAM_CONFIG_FR_ENABLE__M                            0x4
#define   B_SC_RA_RAM_CONFIG_FREQSCAN__M                             0x10
#define   B_SC_RA_RAM_CONFIG_SLAVE__M                                0x20
#define   B_SC_RA_RAM_CONFIG_DIV_BLANK_ENABLE__M                     0x200
#define   B_SC_RA_RAM_CONFIG_DIV_ECHO_ENABLE__M                      0x400
#define B_SC_RA_RAM_CO_TD_CAL_2K__A                                  0x82005D
#define B_SC_RA_RAM_CO_TD_CAL_8K__A                                  0x82005E
#define B_SC_RA_RAM_IF_SAVE__AX                                      0x82008E
#define B_SC_RA_RAM_DIVERSITY_DELAY_2K_32__A                         0x820098
#define B_SC_RA_RAM_DIVERSITY_DELAY_2K_16__A                         0x820099
#define B_SC_RA_RAM_DIVERSITY_DELAY_2K_8__A                          0x82009A
#define B_SC_RA_RAM_DIVERSITY_DELAY_2K_4__A                          0x82009B
#define B_SC_RA_RAM_DIVERSITY_DELAY_8K_32__A                         0x82009C
#define B_SC_RA_RAM_DIVERSITY_DELAY_8K_16__A                         0x82009D
#define B_SC_RA_RAM_DIVERSITY_DELAY_8K_8__A                          0x82009E
#define B_SC_RA_RAM_DIVERSITY_DELAY_8K_4__A                          0x82009F
#define B_SC_RA_RAM_IR_COARSE_2K_LENGTH__A                           0x8200D1
#define B_SC_RA_RAM_IR_COARSE_2K_LENGTH__PRE                         0x9
#define B_SC_RA_RAM_IR_COARSE_2K_FREQINC__A                          0x8200D2
#define B_SC_RA_RAM_IR_COARSE_2K_FREQINC__PRE                        0x4
#define B_SC_RA_RAM_IR_COARSE_2K_KAISINC__A                          0x8200D3
#define B_SC_RA_RAM_IR_COARSE_2K_KAISINC__PRE                        0x100
#define B_SC_RA_RAM_IR_COARSE_8K_LENGTH__A                           0x8200D4
#define B_SC_RA_RAM_IR_COARSE_8K_LENGTH__PRE                         0x8
#define B_SC_RA_RAM_IR_COARSE_8K_FREQINC__A                          0x8200D5
#define B_SC_RA_RAM_IR_COARSE_8K_FREQINC__PRE                        0x8
#define B_SC_RA_RAM_IR_COARSE_8K_KAISINC__A                          0x8200D6
#define B_SC_RA_RAM_IR_COARSE_8K_KAISINC__PRE                        0x200
#define B_SC_RA_RAM_IR_FINE_2K_LENGTH__A                             0x8200D7
#define B_SC_RA_RAM_IR_FINE_2K_LENGTH__PRE                           0x9
#define B_SC_RA_RAM_IR_FINE_2K_FREQINC__A                            0x8200D8
#define B_SC_RA_RAM_IR_FINE_2K_FREQINC__PRE                          0x4
#define B_SC_RA_RAM_IR_FINE_2K_KAISINC__A                            0x8200D9
#define B_SC_RA_RAM_IR_FINE_2K_KAISINC__PRE                          0x100
#define B_SC_RA_RAM_IR_FINE_8K_LENGTH__A                             0x8200DA
#define B_SC_RA_RAM_IR_FINE_8K_LENGTH__PRE                           0xB
#define B_SC_RA_RAM_IR_FINE_8K_FREQINC__A                            0x8200DB
#define B_SC_RA_RAM_IR_FINE_8K_FREQINC__PRE                          0x1
#define B_SC_RA_RAM_IR_FINE_8K_KAISINC__A                            0x8200DC
#define B_SC_RA_RAM_IR_FINE_8K_KAISINC__PRE                          0x40
#define B_SC_RA_RAM_ECHO_SHIFT_LIM__A                                0x8200DD
#define B_SC_RA_RAM_SAMPLE_RATE_COUNT__A                             0x8200E8
#define B_SC_RA_RAM_SAMPLE_RATE_STEP__A                              0x8200E9
#define B_SC_RA_RAM_BAND__A                                          0x8200EC
#define B_SC_RA_RAM_LC_ABS_2K__A                                     0x8200F4
#define B_SC_RA_RAM_LC_ABS_2K__PRE                                   0x1F
#define B_SC_RA_RAM_LC_ABS_8K__A                                     0x8200F5
#define B_SC_RA_RAM_LC_ABS_8K__PRE                                   0x1F
#define B_SC_RA_RAM_EQ_IS_GAIN_UNKNOWN_MAN__PRE                      0x100
#define B_SC_RA_RAM_EQ_IS_GAIN_UNKNOWN_EXP__PRE                      0x4
#define B_SC_RA_RAM_EQ_IS_GAIN_QPSK_MAN__PRE                         0x1E2
#define B_SC_RA_RAM_EQ_IS_GAIN_QPSK_EXP__PRE                         0x4
#define B_SC_RA_RAM_EQ_IS_GAIN_16QAM_MAN__PRE                        0x10D
#define B_SC_RA_RAM_EQ_IS_GAIN_16QAM_EXP__PRE                        0x5
#define B_SC_RA_RAM_EQ_IS_GAIN_16QAM_A2_MAN__PRE                     0x17D
#define B_SC_RA_RAM_EQ_IS_GAIN_16QAM_A2_EXP__PRE                     0x4
#define B_SC_RA_RAM_EQ_IS_GAIN_16QAM_A4_MAN__PRE                     0x133
#define B_SC_RA_RAM_EQ_IS_GAIN_16QAM_A4_EXP__PRE                     0x5
#define B_SC_RA_RAM_EQ_IS_GAIN_64QAM_MAN__PRE                        0x114
#define B_SC_RA_RAM_EQ_IS_GAIN_64QAM_EXP__PRE                        0x5
#define B_SC_RA_RAM_EQ_IS_GAIN_64QAM_A2_MAN__PRE                     0x14A
#define B_SC_RA_RAM_EQ_IS_GAIN_64QAM_A2_EXP__PRE                     0x4
#define B_SC_RA_RAM_EQ_IS_GAIN_64QAM_A4_MAN__PRE                     0x1BB
#define B_SC_RA_RAM_EQ_IS_GAIN_64QAM_A4_EXP__PRE                     0x4
#define B_SC_RA_RAM_DRIVER_VERSION__AX                               0x8201FE
#define   B_SC_RA_RAM_PROC_LOCKTRACK                                 0x0
#define B_FE_COMM_EXEC__A                                            0xC00000
#define B_FE_AD_REG_COMM_EXEC__A                                     0xC10000
#define B_FE_AD_REG_FDB_IN__A                                        0xC10012
#define B_FE_AD_REG_PD__A                                            0xC10013
#define B_FE_AD_REG_INVEXT__A                                        0xC10014
#define B_FE_AD_REG_CLKNEG__A                                        0xC10015
#define B_FE_AG_REG_COMM_EXEC__A                                     0xC20000
#define B_FE_AG_REG_AG_MODE_LOP__A                                   0xC20010
#define   B_FE_AG_REG_AG_MODE_LOP_MODE_4__M                          0x10
#define     B_FE_AG_REG_AG_MODE_LOP_MODE_4_STATIC                    0x0
#define     B_FE_AG_REG_AG_MODE_LOP_MODE_4_DYNAMIC                   0x10
#define   B_FE_AG_REG_AG_MODE_LOP_MODE_5__M                          0x20
#define     B_FE_AG_REG_AG_MODE_LOP_MODE_5_STATIC                    0x0
#define   B_FE_AG_REG_AG_MODE_LOP_MODE_C__M                          0x1000
#define     B_FE_AG_REG_AG_MODE_LOP_MODE_C_STATIC                    0x0
#define     B_FE_AG_REG_AG_MODE_LOP_MODE_C_DYNAMIC                   0x1000
#define   B_FE_AG_REG_AG_MODE_LOP_MODE_E__M                          0x4000
#define     B_FE_AG_REG_AG_MODE_LOP_MODE_E_STATIC                    0x0
#define     B_FE_AG_REG_AG_MODE_LOP_MODE_E_DYNAMIC                   0x4000
#define B_FE_AG_REG_AG_MODE_HIP__A                                   0xC20011
#define   B_FE_AG_REG_AG_MODE_HIP_MODE_J__M                          0x8
#define     B_FE_AG_REG_AG_MODE_HIP_MODE_J_STATIC                    0x0
#define     B_FE_AG_REG_AG_MODE_HIP_MODE_J_DYNAMIC                   0x8
#define B_FE_AG_REG_AG_PGA_MODE__A                                   0xC20012
#define   B_FE_AG_REG_AG_PGA_MODE_PFY_PCY_AFY_REN                    0x0
#define   B_FE_AG_REG_AG_PGA_MODE_PFN_PCN_AFY_REN                    0x1
#define B_FE_AG_REG_AG_AGC_SIO__A                                    0xC20013
#define   B_FE_AG_REG_AG_AGC_SIO_AGC_SIO_2__M                        0x2
#define     B_FE_AG_REG_AG_AGC_SIO_AGC_SIO_2_OUTPUT                  0x0
#define     B_FE_AG_REG_AG_AGC_SIO_AGC_SIO_2_INPUT                   0x2
#define B_FE_AG_REG_AG_PWD__A                                        0xC20015
#define   B_FE_AG_REG_AG_PWD_PWD_PD2__M                              0x2
#define     B_FE_AG_REG_AG_PWD_PWD_PD2_DISABLE                       0x0
#define     B_FE_AG_REG_AG_PWD_PWD_PD2_ENABLE                        0x2
#define B_FE_AG_REG_DCE_AUR_CNT__A                                   0xC20016
#define B_FE_AG_REG_DCE_RUR_CNT__A                                   0xC20017
#define B_FE_AG_REG_ACE_AUR_CNT__A                                   0xC2001A
#define B_FE_AG_REG_ACE_RUR_CNT__A                                   0xC2001B
#define B_FE_AG_REG_CDR_RUR_CNT__A                                   0xC20020
#define B_FE_AG_REG_EGC_RUR_CNT__A                                   0xC20024
#define B_FE_AG_REG_EGC_SET_LVL__A                                   0xC20025
#define B_FE_AG_REG_EGC_SET_LVL__M                                   0x1FF
#define B_FE_AG_REG_EGC_FLA_RGN__A                                   0xC20026
#define B_FE_AG_REG_EGC_SLO_RGN__A                                   0xC20027
#define B_FE_AG_REG_EGC_JMP_PSN__A                                   0xC20028
#define B_FE_AG_REG_EGC_FLA_INC__A                                   0xC20029
#define B_FE_AG_REG_EGC_FLA_DEC__A                                   0xC2002A
#define B_FE_AG_REG_EGC_SLO_INC__A                                   0xC2002B
#define B_FE_AG_REG_EGC_SLO_DEC__A                                   0xC2002C
#define B_FE_AG_REG_EGC_FAS_INC__A                                   0xC2002D
#define B_FE_AG_REG_EGC_FAS_DEC__A                                   0xC2002E
#define B_FE_AG_REG_PM1_AGC_WRI__A                                   0xC20030
#define B_FE_AG_REG_PM1_AGC_WRI__M                                   0x7FF
#define B_FE_AG_REG_GC1_AGC_RIC__A                                   0xC20031
#define B_FE_AG_REG_GC1_AGC_OFF__A                                   0xC20032
#define B_FE_AG_REG_GC1_AGC_MAX__A                                   0xC20033
#define B_FE_AG_REG_GC1_AGC_MIN__A                                   0xC20034
#define B_FE_AG_REG_GC1_AGC_DAT__A                                   0xC20035
#define B_FE_AG_REG_GC1_AGC_DAT__M                                   0x3FF
#define B_FE_AG_REG_PM2_AGC_WRI__A                                   0xC20036
#define B_FE_AG_REG_IND_WIN__A                                       0xC2003C
#define B_FE_AG_REG_IND_THD_LOL__A                                   0xC2003D
#define B_FE_AG_REG_IND_THD_HIL__A                                   0xC2003E
#define B_FE_AG_REG_IND_DEL__A                                       0xC2003F
#define B_FE_AG_REG_IND_PD1_WRI__A                                   0xC20040
#define B_FE_AG_REG_PDA_AUR_CNT__A                                   0xC20041
#define B_FE_AG_REG_PDA_RUR_CNT__A                                   0xC20042
#define B_FE_AG_REG_PDA_AVE_DAT__A                                   0xC20043
#define B_FE_AG_REG_PDC_RUR_CNT__A                                   0xC20044
#define B_FE_AG_REG_PDC_SET_LVL__A                                   0xC20045
#define B_FE_AG_REG_PDC_FLA_RGN__A                                   0xC20046
#define B_FE_AG_REG_PDC_JMP_PSN__A                                   0xC20047
#define B_FE_AG_REG_PDC_FLA_STP__A                                   0xC20048
#define B_FE_AG_REG_PDC_SLO_STP__A                                   0xC20049
#define B_FE_AG_REG_PDC_PD2_WRI__A                                   0xC2004A
#define B_FE_AG_REG_PDC_MAP_DAT__A                                   0xC2004B
#define B_FE_AG_REG_PDC_MAX__A                                       0xC2004C
#define B_FE_AG_REG_TGA_AUR_CNT__A                                   0xC2004D
#define B_FE_AG_REG_TGA_RUR_CNT__A                                   0xC2004E
#define B_FE_AG_REG_TGA_AVE_DAT__A                                   0xC2004F
#define B_FE_AG_REG_TGC_RUR_CNT__A                                   0xC20050
#define B_FE_AG_REG_TGC_SET_LVL__A                                   0xC20051
#define B_FE_AG_REG_TGC_SET_LVL__M                                   0x3F
#define B_FE_AG_REG_TGC_FLA_RGN__A                                   0xC20052
#define B_FE_AG_REG_TGC_JMP_PSN__A                                   0xC20053
#define B_FE_AG_REG_TGC_FLA_STP__A                                   0xC20054
#define B_FE_AG_REG_TGC_SLO_STP__A                                   0xC20055
#define B_FE_AG_REG_TGC_MAP_DAT__A                                   0xC20056
#define B_FE_AG_REG_FGM_WRI__A                                       0xC20061
#define B_FE_AG_REG_BGC_FGC_WRI__A                                   0xC20068
#define B_FE_AG_REG_BGC_CGC_WRI__A                                   0xC20069
#define B_FE_FS_REG_COMM_EXEC__A                                     0xC30000
#define B_FE_FS_REG_ADD_INC_LOP__A                                   0xC30010
#define B_FE_FD_REG_COMM_EXEC__A                                     0xC40000
#define B_FE_FD_REG_SCL__A                                           0xC40010
#define B_FE_FD_REG_MAX_LEV__A                                       0xC40011
#define B_FE_FD_REG_NR__A                                            0xC40012
#define B_FE_FD_REG_MEAS_VAL__A                                      0xC40014
#define B_FE_IF_REG_COMM_EXEC__A                                     0xC50000
#define B_FE_IF_REG_INCR0__A                                         0xC50010
#define B_FE_IF_REG_INCR0__W                                         16
#define B_FE_IF_REG_INCR0__M                                         0xFFFF
#define B_FE_IF_REG_INCR1__A                                         0xC50011
#define B_FE_IF_REG_INCR1__M                                         0xFF
#define B_FE_CF_REG_COMM_EXEC__A                                     0xC60000
#define B_FE_CF_REG_SCL__A                                           0xC60010
#define B_FE_CF_REG_MAX_LEV__A                                       0xC60011
#define B_FE_CF_REG_NR__A                                            0xC60012
#define B_FE_CF_REG_IMP_VAL__A                                       0xC60013
#define B_FE_CF_REG_MEAS_VAL__A                                      0xC60014
#define B_FE_CU_REG_COMM_EXEC__A                                     0xC70000
#define B_FE_CU_REG_FRM_CNT_RST__A                                   0xC70011
#define B_FE_CU_REG_FRM_CNT_STR__A                                   0xC70012
#define B_FE_CU_REG_CTR_NFC_ICR__A                                   0xC70020
#define B_FE_CU_REG_CTR_NFC_OCR__A                                   0xC70021
#define B_FE_CU_REG_DIV_NFC_CLP__A                                   0xC70027
#define B_FT_COMM_EXEC__A                                            0x1000000
#define B_FT_REG_COMM_EXEC__A                                        0x1010000
#define B_CP_COMM_EXEC__A                                            0x1400000
#define B_CP_REG_COMM_EXEC__A                                        0x1410000
#define B_CP_REG_INTERVAL__A                                         0x1410011
#define B_CP_REG_BR_SPL_OFFSET__A                                    0x1410023
#define B_CP_REG_BR_STR_DEL__A                                       0x1410024
#define B_CP_REG_RT_ANG_INC0__A                                      0x1410030
#define B_CP_REG_RT_ANG_INC1__A                                      0x1410031
#define B_CP_REG_RT_DETECT_TRH__A                                    0x1410033
#define B_CP_REG_AC_NEXP_OFFS__A                                     0x1410040
#define B_CP_REG_AC_AVER_POW__A                                      0x1410041
#define B_CP_REG_AC_MAX_POW__A                                       0x1410042
#define B_CP_REG_AC_WEIGHT_MAN__A                                    0x1410043
#define B_CP_REG_AC_WEIGHT_EXP__A                                    0x1410044
#define B_CP_REG_AC_AMP_MODE__A                                      0x1410047
#define B_CP_REG_AC_AMP_FIX__A                                       0x1410048
#define B_CP_REG_AC_ANG_MODE__A                                      0x141004A
#define B_CE_COMM_EXEC__A                                            0x1800000
#define B_CE_REG_COMM_EXEC__A                                        0x1810000
#define B_CE_REG_TAPSET__A                                           0x1810011
#define B_CE_REG_AVG_POW__A                                          0x1810012
#define B_CE_REG_MAX_POW__A                                          0x1810013
#define B_CE_REG_ATT__A                                              0x1810014
#define B_CE_REG_NRED__A                                             0x1810015
#define B_CE_REG_NE_ERR_SELECT__A                                    0x1810043
#define B_CE_REG_NE_TD_CAL__A                                        0x1810044
#define B_CE_REG_NE_MIXAVG__A                                        0x1810046
#define B_CE_REG_NE_NUPD_OFS__A                                      0x1810047
#define B_CE_REG_PE_NEXP_OFFS__A                                     0x1810050
#define B_CE_REG_PE_TIMESHIFT__A                                     0x1810051
#define B_CE_REG_TP_A0_TAP_NEW__A                                    0x1810064
#define B_CE_REG_TP_A0_TAP_NEW_VALID__A                              0x1810065
#define B_CE_REG_TP_A0_MU_LMS_STEP__A                                0x1810066
#define B_CE_REG_TP_A1_TAP_NEW__A                                    0x1810068
#define B_CE_REG_TP_A1_TAP_NEW_VALID__A                              0x1810069
#define B_CE_REG_TP_A1_MU_LMS_STEP__A                                0x181006A
#define B_CE_REG_TI_PHN_ENABLE__A                                    0x1810073
#define B_CE_REG_FI_SHT_INCR__A                                      0x1810090
#define B_CE_REG_FI_EXP_NORM__A                                      0x1810091
#define B_CE_REG_IR_INPUTSEL__A                                      0x18100A0
#define B_CE_REG_IR_STARTPOS__A                                      0x18100A1
#define B_CE_REG_IR_NEXP_THRES__A                                    0x18100A2
#define B_CE_REG_FR_TREAL00__A                                       0x1820010
#define B_CE_REG_FR_TIMAG00__A                                       0x1820011
#define B_CE_REG_FR_TREAL01__A                                       0x1820012
#define B_CE_REG_FR_TIMAG01__A                                       0x1820013
#define B_CE_REG_FR_TREAL02__A                                       0x1820014
#define B_CE_REG_FR_TIMAG02__A                                       0x1820015
#define B_CE_REG_FR_TREAL03__A                                       0x1820016
#define B_CE_REG_FR_TIMAG03__A                                       0x1820017
#define B_CE_REG_FR_TREAL04__A                                       0x1820018
#define B_CE_REG_FR_TIMAG04__A                                       0x1820019
#define B_CE_REG_FR_TREAL05__A                                       0x182001A
#define B_CE_REG_FR_TIMAG05__A                                       0x182001B
#define B_CE_REG_FR_TREAL06__A                                       0x182001C
#define B_CE_REG_FR_TIMAG06__A                                       0x182001D
#define B_CE_REG_FR_TREAL07__A                                       0x182001E
#define B_CE_REG_FR_TIMAG07__A                                       0x182001F
#define B_CE_REG_FR_TREAL08__A                                       0x1820020
#define B_CE_REG_FR_TIMAG08__A                                       0x1820021
#define B_CE_REG_FR_TREAL09__A                                       0x1820022
#define B_CE_REG_FR_TIMAG09__A                                       0x1820023
#define B_CE_REG_FR_TREAL10__A                                       0x1820024
#define B_CE_REG_FR_TIMAG10__A                                       0x1820025
#define B_CE_REG_FR_TREAL11__A                                       0x1820026
#define B_CE_REG_FR_TIMAG11__A                                       0x1820027
#define B_CE_REG_FR_MID_TAP__A                                       0x1820028
#define B_CE_REG_FR_SQS_G00__A                                       0x1820029
#define B_CE_REG_FR_SQS_G01__A                                       0x182002A
#define B_CE_REG_FR_SQS_G02__A                                       0x182002B
#define B_CE_REG_FR_SQS_G03__A                                       0x182002C
#define B_CE_REG_FR_SQS_G04__A                                       0x182002D
#define B_CE_REG_FR_SQS_G05__A                                       0x182002E
#define B_CE_REG_FR_SQS_G06__A                                       0x182002F
#define B_CE_REG_FR_SQS_G07__A                                       0x1820030
#define B_CE_REG_FR_SQS_G08__A                                       0x1820031
#define B_CE_REG_FR_SQS_G09__A                                       0x1820032
#define B_CE_REG_FR_SQS_G10__A                                       0x1820033
#define B_CE_REG_FR_SQS_G11__A                                       0x1820034
#define B_CE_REG_FR_SQS_G12__A                                       0x1820035
#define B_CE_REG_FR_RIO_G00__A                                       0x1820036
#define B_CE_REG_FR_RIO_G01__A                                       0x1820037
#define B_CE_REG_FR_RIO_G02__A                                       0x1820038
#define B_CE_REG_FR_RIO_G03__A                                       0x1820039
#define B_CE_REG_FR_RIO_G04__A                                       0x182003A
#define B_CE_REG_FR_RIO_G05__A                                       0x182003B
#define B_CE_REG_FR_RIO_G06__A                                       0x182003C
#define B_CE_REG_FR_RIO_G07__A                                       0x182003D
#define B_CE_REG_FR_RIO_G08__A                                       0x182003E
#define B_CE_REG_FR_RIO_G09__A                                       0x182003F
#define B_CE_REG_FR_RIO_G10__A                                       0x1820040
#define B_CE_REG_FR_MODE__A                                          0x1820041
#define B_CE_REG_FR_SQS_TRH__A                                       0x1820042
#define B_CE_REG_FR_RIO_GAIN__A                                      0x1820043
#define B_CE_REG_FR_BYPASS__A                                        0x1820044
#define B_CE_REG_FR_PM_SET__A                                        0x1820045
#define B_CE_REG_FR_ERR_SH__A                                        0x1820046
#define B_CE_REG_FR_MAN_SH__A                                        0x1820047
#define B_CE_REG_FR_TAP_SH__A                                        0x1820048
#define B_EQ_COMM_EXEC__A                                            0x1C00000
#define B_EQ_REG_COMM_EXEC__A                                        0x1C10000
#define B_EQ_REG_COMM_MB__A                                          0x1C10002
#define B_EQ_REG_IS_GAIN_MAN__A                                      0x1C10015
#define B_EQ_REG_IS_GAIN_EXP__A                                      0x1C10016
#define B_EQ_REG_IS_CLIP_EXP__A                                      0x1C10017
#define B_EQ_REG_SN_CEGAIN__A                                        0x1C1002A
#define B_EQ_REG_SN_OFFSET__A                                        0x1C1002B
#define B_EQ_REG_RC_SEL_CAR__A                                       0x1C10032
#define   B_EQ_REG_RC_SEL_CAR_INIT                                   0x2
#define     B_EQ_REG_RC_SEL_CAR_DIV_ON                               0x1
#define     B_EQ_REG_RC_SEL_CAR_PASS_A_CC                            0x0
#define     B_EQ_REG_RC_SEL_CAR_PASS_B_CE                            0x2
#define     B_EQ_REG_RC_SEL_CAR_LOCAL_A_CC                           0x0
#define     B_EQ_REG_RC_SEL_CAR_LOCAL_B_CE                           0x8
#define     B_EQ_REG_RC_SEL_CAR_MEAS_A_CC                            0x0
#define     B_EQ_REG_RC_SEL_CAR_MEAS_B_CE                            0x20
#define   B_EQ_REG_RC_SEL_CAR_FFTMODE__M                             0x80
#define B_EQ_REG_OT_CONST__A                                         0x1C10046
#define B_EQ_REG_OT_ALPHA__A                                         0x1C10047
#define B_EQ_REG_OT_QNT_THRES0__A                                    0x1C10048
#define B_EQ_REG_OT_QNT_THRES1__A                                    0x1C10049
#define B_EQ_REG_OT_CSI_STEP__A                                      0x1C1004A
#define B_EQ_REG_OT_CSI_OFFSET__A                                    0x1C1004B
#define B_EQ_REG_TD_REQ_SMB_CNT__A                                   0x1C10061
#define B_EQ_REG_TD_TPS_PWR_OFS__A                                   0x1C10062
#define B_EC_SB_REG_COMM_EXEC__A                                     0x2010000
#define B_EC_SB_REG_TR_MODE__A                                       0x2010010
#define   B_EC_SB_REG_TR_MODE_8K                                     0x0
#define   B_EC_SB_REG_TR_MODE_2K                                     0x1
#define B_EC_SB_REG_CONST__A                                         0x2010011
#define   B_EC_SB_REG_CONST_QPSK                                     0x0
#define   B_EC_SB_REG_CONST_16QAM                                    0x1
#define   B_EC_SB_REG_CONST_64QAM                                    0x2
#define B_EC_SB_REG_ALPHA__A                                         0x2010012
#define B_EC_SB_REG_PRIOR__A                                         0x2010013
#define   B_EC_SB_REG_PRIOR_HI                                       0x0
#define   B_EC_SB_REG_PRIOR_LO                                       0x1
#define B_EC_SB_REG_CSI_HI__A                                        0x2010014
#define B_EC_SB_REG_CSI_LO__A                                        0x2010015
#define B_EC_SB_REG_SMB_TGL__A                                       0x2010016
#define B_EC_SB_REG_SNR_HI__A                                        0x2010017
#define B_EC_SB_REG_SNR_MID__A                                       0x2010018
#define B_EC_SB_REG_SNR_LO__A                                        0x2010019
#define B_EC_SB_REG_SCALE_MSB__A                                     0x201001A
#define B_EC_SB_REG_SCALE_BIT2__A                                    0x201001B
#define B_EC_SB_REG_SCALE_LSB__A                                     0x201001C
#define B_EC_SB_REG_CSI_OFS0__A                                      0x201001D
#define B_EC_SB_REG_CSI_OFS1__A                                      0x201001E
#define B_EC_SB_REG_CSI_OFS2__A                                      0x201001F
#define B_EC_VD_REG_COMM_EXEC__A                                     0x2090000
#define B_EC_VD_REG_FORCE__A                                         0x2090010
#define B_EC_VD_REG_SET_CODERATE__A                                  0x2090011
#define   B_EC_VD_REG_SET_CODERATE_C1_2                              0x0
#define   B_EC_VD_REG_SET_CODERATE_C2_3                              0x1
#define   B_EC_VD_REG_SET_CODERATE_C3_4                              0x2
#define   B_EC_VD_REG_SET_CODERATE_C5_6                              0x3
#define   B_EC_VD_REG_SET_CODERATE_C7_8                              0x4
#define B_EC_VD_REG_REQ_SMB_CNT__A                                   0x2090012
#define B_EC_VD_REG_RLK_ENA__A                                       0x2090014
#define B_EC_OD_REG_COMM_EXEC__A                                     0x2110000
#define B_EC_OD_REG_SYNC__A                                          0x2110664
#define B_EC_OD_DEINT_RAM__A                                         0x2120000
#define B_EC_RS_REG_COMM_EXEC__A                                     0x2130000
#define B_EC_RS_REG_REQ_PCK_CNT__A                                   0x2130010
#define B_EC_RS_REG_VAL__A                                           0x2130011
#define   B_EC_RS_REG_VAL_PCK                                        0x1
#define B_EC_RS_EC_RAM__A                                            0x2140000
#define B_EC_OC_REG_COMM_EXEC__A                                     0x2150000
#define     B_EC_OC_REG_COMM_EXEC_CTL_ACTIVE                         0x1
#define     B_EC_OC_REG_COMM_EXEC_CTL_HOLD                           0x2
#define B_EC_OC_REG_COMM_INT_STA__A                                  0x2150007
#define B_EC_OC_REG_OC_MODE_LOP__A                                   0x2150010
#define   B_EC_OC_REG_OC_MODE_LOP_PAR_ENA__M                         0x1
#define     B_EC_OC_REG_OC_MODE_LOP_PAR_ENA_ENABLE                   0x0
#define     B_EC_OC_REG_OC_MODE_LOP_PAR_ENA_DISABLE                  0x1
#define   B_EC_OC_REG_OC_MODE_LOP_DTO_CTR_SRC__M                     0x4
#define     B_EC_OC_REG_OC_MODE_LOP_DTO_CTR_SRC_STATIC               0x0
#define   B_EC_OC_REG_OC_MODE_LOP_MPG_TRM_MDE__M                     0x80
#define     B_EC_OC_REG_OC_MODE_LOP_MPG_TRM_MDE_SERIAL               0x80
#define B_EC_OC_REG_OC_MODE_HIP__A                                   0x2150011
#define     B_EC_OC_REG_OC_MODE_HIP_MPG_BUS_SRC_MONITOR              0x10
#define   B_EC_OC_REG_OC_MODE_HIP_MPG_PAR_VAL__M                     0x200
#define     B_EC_OC_REG_OC_MODE_HIP_MPG_PAR_VAL_DISABLE              0x0
#define     B_EC_OC_REG_OC_MODE_HIP_MPG_PAR_VAL_ENABLE               0x200
#define B_EC_OC_REG_OC_MPG_SIO__A                                    0x2150012
#define B_EC_OC_REG_OC_MPG_SIO__M                                    0xFFF
#define B_EC_OC_REG_DTO_INC_LOP__A                                   0x2150014
#define B_EC_OC_REG_DTO_INC_HIP__A                                   0x2150015
#define B_EC_OC_REG_SNC_ISC_LVL__A                                   0x2150016
#define   B_EC_OC_REG_SNC_ISC_LVL_OSC__M                             0xF0
#define B_EC_OC_REG_TMD_TOP_MODE__A                                  0x215001D
#define B_EC_OC_REG_TMD_TOP_CNT__A                                   0x215001E
#define B_EC_OC_REG_TMD_HIL_MAR__A                                   0x215001F
#define B_EC_OC_REG_TMD_LOL_MAR__A                                   0x2150020
#define B_EC_OC_REG_TMD_CUR_CNT__A                                   0x2150021
#define B_EC_OC_REG_AVR_ASH_CNT__A                                   0x2150023
#define B_EC_OC_REG_AVR_BSH_CNT__A                                   0x2150024
#define B_EC_OC_REG_RCN_MODE__A                                      0x2150027
#define B_EC_OC_REG_RCN_CRA_LOP__A                                   0x2150028
#define B_EC_OC_REG_RCN_CRA_HIP__A                                   0x2150029
#define B_EC_OC_REG_RCN_CST_LOP__A                                   0x215002A
#define B_EC_OC_REG_RCN_CST_HIP__A                                   0x215002B
#define B_EC_OC_REG_RCN_SET_LVL__A                                   0x215002C
#define B_EC_OC_REG_RCN_GAI_LVL__A                                   0x215002D
#define B_EC_OC_REG_RCN_CLP_LOP__A                                   0x2150032
#define B_EC_OC_REG_RCN_CLP_HIP__A                                   0x2150033
#define B_EC_OC_REG_RCN_MAP_LOP__A                                   0x2150034
#define B_EC_OC_REG_RCN_MAP_HIP__A                                   0x2150035
#define B_EC_OC_REG_OCR_MPG_UOS__A                                   0x2150036
#define B_EC_OC_REG_OCR_MPG_UOS__M                                   0xFFF
#define   B_EC_OC_REG_OCR_MPG_UOS_INIT                               0x0
#define B_EC_OC_REG_OCR_MPG_USR_DAT__A                               0x2150038
#define B_EC_OC_REG_IPR_INV_MPG__A                                   0x2150045
#define B_EC_OC_REG_DTO_CLKMODE__A                                   0x2150047
#define B_EC_OC_REG_DTO_PER__A                                       0x2150048
#define B_EC_OC_REG_DTO_BUR__A                                       0x2150049
#define B_EC_OC_REG_RCR_CLKMODE__A                                   0x215004A
#define B_CC_REG_OSC_MODE__A                                         0x2410010
#define   B_CC_REG_OSC_MODE_M20                                      0x1
#define B_CC_REG_PLL_MODE__A                                         0x2410011
#define     B_CC_REG_PLL_MODE_BYPASS_PLL                             0x1
#define     B_CC_REG_PLL_MODE_PUMP_CUR_12                            0x14
#define B_CC_REG_REF_DIVIDE__A                                       0x2410012
#define B_CC_REG_PWD_MODE__A                                         0x2410015
#define   B_CC_REG_PWD_MODE_DOWN_PLL                                 0x2
#define B_CC_REG_UPDATE__A                                           0x2410017
#define   B_CC_REG_UPDATE_KEY                                        0x3973
#define B_CC_REG_JTAGID_L__A                                         0x2410019
#define B_CC_REG_DIVERSITY__A                                        0x241001B
#define B_LC_COMM_EXEC__A                                            0x2800000
#define B_LC_RA_RAM_IFINCR_NOM_L__A                                  0x282000C
#define B_LC_RA_RAM_FILTER_SYM_SET__A                                0x282001A
#define B_LC_RA_RAM_FILTER_SYM_SET__PRE                              0x3E8
#define B_LC_RA_RAM_FILTER_CRMM_A__A                                 0x2820060
#define B_LC_RA_RAM_FILTER_CRMM_A__PRE                               0x4
#define B_LC_RA_RAM_FILTER_CRMM_B__A                                 0x2820061
#define B_LC_RA_RAM_FILTER_CRMM_B__PRE                               0x1
#define B_LC_RA_RAM_FILTER_SRMM_A__A                                 0x2820068
#define B_LC_RA_RAM_FILTER_SRMM_A__PRE                               0x4
#define B_LC_RA_RAM_FILTER_SRMM_B__A                                 0x2820069
#define B_LC_RA_RAM_FILTER_SRMM_B__PRE                               0x1

#endif
