/*
 * Autogenerated file by GPU Top : https://github.com/rib/gputop
 * DO NOT EDIT manually!
 *
 *
 * Copyright (c) 2015 Intel Corporation
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
 * IN THE SOFTWARE.
 *
 */

#include <linux/sysfs.h>

#include "i915_drv.h"
#include "i915_oa_sklgt4.h"

enum metric_set_id {
	METRIC_SET_ID_RENDER_BASIC = 1,
	METRIC_SET_ID_COMPUTE_BASIC,
	METRIC_SET_ID_RENDER_PIPE_PROFILE,
	METRIC_SET_ID_MEMORY_READS,
	METRIC_SET_ID_MEMORY_WRITES,
	METRIC_SET_ID_COMPUTE_EXTENDED,
	METRIC_SET_ID_COMPUTE_L3_CACHE,
	METRIC_SET_ID_HDC_AND_SF,
	METRIC_SET_ID_L3_1,
	METRIC_SET_ID_L3_2,
	METRIC_SET_ID_L3_3,
	METRIC_SET_ID_RASTERIZER_AND_PIXEL_BACKEND,
	METRIC_SET_ID_SAMPLER,
	METRIC_SET_ID_TDL_1,
	METRIC_SET_ID_TDL_2,
	METRIC_SET_ID_COMPUTE_EXTRA,
	METRIC_SET_ID_VME_PIPE,
	METRIC_SET_ID_TEST_OA,
};

int i915_oa_n_builtin_metric_sets_sklgt4 = 18;

static const struct i915_oa_reg b_counter_config_render_basic[] = {
	{ _MMIO(0x2710), 0x00000000 },
	{ _MMIO(0x2714), 0x00800000 },
	{ _MMIO(0x2720), 0x00000000 },
	{ _MMIO(0x2724), 0x00800000 },
	{ _MMIO(0x2740), 0x00000000 },
};

static const struct i915_oa_reg flex_eu_config_render_basic[] = {
	{ _MMIO(0xe458), 0x00005004 },
	{ _MMIO(0xe558), 0x00010003 },
	{ _MMIO(0xe658), 0x00012011 },
	{ _MMIO(0xe758), 0x00015014 },
	{ _MMIO(0xe45c), 0x00051050 },
	{ _MMIO(0xe55c), 0x00053052 },
	{ _MMIO(0xe65c), 0x00055054 },
};

static const struct i915_oa_reg mux_config_render_basic[] = {
	{ _MMIO(0x9888), 0x166c01e0 },
	{ _MMIO(0x9888), 0x12170280 },
	{ _MMIO(0x9888), 0x12370280 },
	{ _MMIO(0x9888), 0x16ec01e0 },
	{ _MMIO(0x9888), 0x176c01e0 },
	{ _MMIO(0x9888), 0x11930317 },
	{ _MMIO(0x9888), 0x159303df },
	{ _MMIO(0x9888), 0x3f900003 },
	{ _MMIO(0x9888), 0x1a4e03b0 },
	{ _MMIO(0x9888), 0x0a6c0053 },
	{ _MMIO(0x9888), 0x106c0000 },
	{ _MMIO(0x9888), 0x1c6c0000 },
	{ _MMIO(0x9888), 0x0a1b4000 },
	{ _MMIO(0x9888), 0x1c1c0001 },
	{ _MMIO(0x9888), 0x002f1000 },
	{ _MMIO(0x9888), 0x042f1000 },
	{ _MMIO(0x9888), 0x004c4000 },
	{ _MMIO(0x9888), 0x0a4ca400 },
	{ _MMIO(0x9888), 0x0c4c0002 },
	{ _MMIO(0x9888), 0x000d2000 },
	{ _MMIO(0x9888), 0x060d8000 },
	{ _MMIO(0x9888), 0x080da000 },
	{ _MMIO(0x9888), 0x0a0da000 },
	{ _MMIO(0x9888), 0x0c0f0400 },
	{ _MMIO(0x9888), 0x0e0f5600 },
	{ _MMIO(0x9888), 0x100f0001 },
	{ _MMIO(0x9888), 0x002c8000 },
	{ _MMIO(0x9888), 0x162caa00 },
	{ _MMIO(0x9888), 0x062d8000 },
	{ _MMIO(0x9888), 0x00133000 },
	{ _MMIO(0x9888), 0x08133000 },
	{ _MMIO(0x9888), 0x00170020 },
	{ _MMIO(0x9888), 0x08170021 },
	{ _MMIO(0x9888), 0x10170000 },
	{ _MMIO(0x9888), 0x0633c000 },
	{ _MMIO(0x9888), 0x06370800 },
	{ _MMIO(0x9888), 0x10370000 },
	{ _MMIO(0x9888), 0x1ace0230 },
	{ _MMIO(0x9888), 0x0aec5300 },
	{ _MMIO(0x9888), 0x10ec0000 },
	{ _MMIO(0x9888), 0x1cec0000 },
	{ _MMIO(0x9888), 0x0a9b8000 },
	{ _MMIO(0x9888), 0x1c9c0002 },
	{ _MMIO(0x9888), 0x0acc2000 },
	{ _MMIO(0x9888), 0x0ccc0002 },
	{ _MMIO(0x9888), 0x088d8000 },
	{ _MMIO(0x9888), 0x0a8d8000 },
	{ _MMIO(0x9888), 0x0e8f1000 },
	{ _MMIO(0x9888), 0x108f0001 },
	{ _MMIO(0x9888), 0x16ac8800 },
	{ _MMIO(0x9888), 0x1b4e0020 },
	{ _MMIO(0x9888), 0x096c5300 },
	{ _MMIO(0x9888), 0x116c0000 },
	{ _MMIO(0x9888), 0x1d6c0000 },
	{ _MMIO(0x9888), 0x091b8000 },
	{ _MMIO(0x9888), 0x1b1c8000 },
	{ _MMIO(0x9888), 0x0b4c2000 },
	{ _MMIO(0x9888), 0x090d8000 },
	{ _MMIO(0x9888), 0x0f0f1000 },
	{ _MMIO(0x9888), 0x172c0800 },
	{ _MMIO(0x9888), 0x0d933031 },
	{ _MMIO(0x9888), 0x0f933e3f },
	{ _MMIO(0x9888), 0x01933d00 },
	{ _MMIO(0x9888), 0x0393073c },
	{ _MMIO(0x9888), 0x0593000e },
	{ _MMIO(0x9888), 0x1d930000 },
	{ _MMIO(0x9888), 0x19930000 },
	{ _MMIO(0x9888), 0x1b930000 },
	{ _MMIO(0x9888), 0x1d900157 },
	{ _MMIO(0x9888), 0x1f900158 },
	{ _MMIO(0x9888), 0x35900000 },
	{ _MMIO(0x9888), 0x2b908000 },
	{ _MMIO(0x9888), 0x2d908000 },
	{ _MMIO(0x9888), 0x2f908000 },
	{ _MMIO(0x9888), 0x31908000 },
	{ _MMIO(0x9888), 0x15908000 },
	{ _MMIO(0x9888), 0x17908000 },
	{ _MMIO(0x9888), 0x19908000 },
	{ _MMIO(0x9888), 0x1b908000 },
	{ _MMIO(0x9888), 0x1190003f },
	{ _MMIO(0x9888), 0x5190ff30 },
	{ _MMIO(0x9888), 0x41900060 },
	{ _MMIO(0x9888), 0x55903033 },
	{ _MMIO(0x9888), 0x45901421 },
	{ _MMIO(0x9888), 0x47900803 },
	{ _MMIO(0x9888), 0x5790fff1 },
	{ _MMIO(0x9888), 0x49900001 },
	{ _MMIO(0x9888), 0x37900000 },
	{ _MMIO(0x9888), 0x33900000 },
	{ _MMIO(0x9888), 0x4b900000 },
	{ _MMIO(0x9888), 0x5990000f },
	{ _MMIO(0x9888), 0x43900000 },
	{ _MMIO(0x9888), 0x5390ffff },
};

static int
get_render_basic_mux_config(struct drm_i915_private *dev_priv,
			    const struct i915_oa_reg **regs,
			    int *lens)
{
	int n = 0;

	BUILD_BUG_ON(ARRAY_SIZE(dev_priv->perf.oa.mux_regs) < 1);
	BUILD_BUG_ON(ARRAY_SIZE(dev_priv->perf.oa.mux_regs_lens) < 1);

	regs[n] = mux_config_render_basic;
	lens[n] = ARRAY_SIZE(mux_config_render_basic);
	n++;

	return n;
}

static const struct i915_oa_reg b_counter_config_compute_basic[] = {
	{ _MMIO(0x2710), 0x00000000 },
	{ _MMIO(0x2714), 0x00800000 },
	{ _MMIO(0x2720), 0x00000000 },
	{ _MMIO(0x2724), 0x00800000 },
	{ _MMIO(0x2740), 0x00000000 },
};

static const struct i915_oa_reg flex_eu_config_compute_basic[] = {
	{ _MMIO(0xe458), 0x00005004 },
	{ _MMIO(0xe558), 0x00000003 },
	{ _MMIO(0xe658), 0x00002001 },
	{ _MMIO(0xe758), 0x00778008 },
	{ _MMIO(0xe45c), 0x00088078 },
	{ _MMIO(0xe55c), 0x00808708 },
	{ _MMIO(0xe65c), 0x00a08908 },
};

static const struct i915_oa_reg mux_config_compute_basic[] = {
	{ _MMIO(0x9888), 0x104f00e0 },
	{ _MMIO(0x9888), 0x124f1c00 },
	{ _MMIO(0x9888), 0x106c00e0 },
	{ _MMIO(0x9888), 0x37906800 },
	{ _MMIO(0x9888), 0x3f900003 },
	{ _MMIO(0x9888), 0x004e8000 },
	{ _MMIO(0x9888), 0x1a4e0820 },
	{ _MMIO(0x9888), 0x1c4e0002 },
	{ _MMIO(0x9888), 0x064f0900 },
	{ _MMIO(0x9888), 0x084f0032 },
	{ _MMIO(0x9888), 0x0a4f1891 },
	{ _MMIO(0x9888), 0x0c4f0e00 },
	{ _MMIO(0x9888), 0x0e4f003c },
	{ _MMIO(0x9888), 0x004f0d80 },
	{ _MMIO(0x9888), 0x024f003b },
	{ _MMIO(0x9888), 0x006c0002 },
	{ _MMIO(0x9888), 0x086c0100 },
	{ _MMIO(0x9888), 0x0c6c000c },
	{ _MMIO(0x9888), 0x0e6c0b00 },
	{ _MMIO(0x9888), 0x186c0000 },
	{ _MMIO(0x9888), 0x1c6c0000 },
	{ _MMIO(0x9888), 0x1e6c0000 },
	{ _MMIO(0x9888), 0x001b4000 },
	{ _MMIO(0x9888), 0x081b8000 },
	{ _MMIO(0x9888), 0x0c1b4000 },
	{ _MMIO(0x9888), 0x0e1b8000 },
	{ _MMIO(0x9888), 0x101c8000 },
	{ _MMIO(0x9888), 0x1a1c8000 },
	{ _MMIO(0x9888), 0x1c1c0024 },
	{ _MMIO(0x9888), 0x065b8000 },
	{ _MMIO(0x9888), 0x085b4000 },
	{ _MMIO(0x9888), 0x0a5bc000 },
	{ _MMIO(0x9888), 0x0c5b8000 },
	{ _MMIO(0x9888), 0x0e5b4000 },
	{ _MMIO(0x9888), 0x005b8000 },
	{ _MMIO(0x9888), 0x025b4000 },
	{ _MMIO(0x9888), 0x1a5c6000 },
	{ _MMIO(0x9888), 0x1c5c001b },
	{ _MMIO(0x9888), 0x125c8000 },
	{ _MMIO(0x9888), 0x145c8000 },
	{ _MMIO(0x9888), 0x004c8000 },
	{ _MMIO(0x9888), 0x0a4c2000 },
	{ _MMIO(0x9888), 0x0c4c0208 },
	{ _MMIO(0x9888), 0x000da000 },
	{ _MMIO(0x9888), 0x060d8000 },
	{ _MMIO(0x9888), 0x080da000 },
	{ _MMIO(0x9888), 0x0a0da000 },
	{ _MMIO(0x9888), 0x0c0da000 },
	{ _MMIO(0x9888), 0x0e0da000 },
	{ _MMIO(0x9888), 0x020d2000 },
	{ _MMIO(0x9888), 0x0c0f5400 },
	{ _MMIO(0x9888), 0x0e0f5500 },
	{ _MMIO(0x9888), 0x100f0155 },
	{ _MMIO(0x9888), 0x002c8000 },
	{ _MMIO(0x9888), 0x0e2cc000 },
	{ _MMIO(0x9888), 0x162cfb00 },
	{ _MMIO(0x9888), 0x182c00be },
	{ _MMIO(0x9888), 0x022cc000 },
	{ _MMIO(0x9888), 0x042cc000 },
	{ _MMIO(0x9888), 0x19900157 },
	{ _MMIO(0x9888), 0x1b900158 },
	{ _MMIO(0x9888), 0x1d900105 },
	{ _MMIO(0x9888), 0x1f900103 },
	{ _MMIO(0x9888), 0x35900000 },
	{ _MMIO(0x9888), 0x11900fff },
	{ _MMIO(0x9888), 0x51900000 },
	{ _MMIO(0x9888), 0x41900800 },
	{ _MMIO(0x9888), 0x55900000 },
	{ _MMIO(0x9888), 0x45900821 },
	{ _MMIO(0x9888), 0x47900802 },
	{ _MMIO(0x9888), 0x57900000 },
	{ _MMIO(0x9888), 0x49900802 },
	{ _MMIO(0x9888), 0x33900000 },
	{ _MMIO(0x9888), 0x4b900002 },
	{ _MMIO(0x9888), 0x59900000 },
	{ _MMIO(0x9888), 0x43900422 },
	{ _MMIO(0x9888), 0x53905555 },
};

static int
get_compute_basic_mux_config(struct drm_i915_private *dev_priv,
			     const struct i915_oa_reg **regs,
			     int *lens)
{
	int n = 0;

	BUILD_BUG_ON(ARRAY_SIZE(dev_priv->perf.oa.mux_regs) < 1);
	BUILD_BUG_ON(ARRAY_SIZE(dev_priv->perf.oa.mux_regs_lens) < 1);

	regs[n] = mux_config_compute_basic;
	lens[n] = ARRAY_SIZE(mux_config_compute_basic);
	n++;

	return n;
}

static const struct i915_oa_reg b_counter_config_render_pipe_profile[] = {
	{ _MMIO(0x2724), 0xf0800000 },
	{ _MMIO(0x2720), 0x00000000 },
	{ _MMIO(0x2714), 0xf0800000 },
	{ _MMIO(0x2710), 0x00000000 },
	{ _MMIO(0x2740), 0x00000000 },
	{ _MMIO(0x2770), 0x0007ffea },
	{ _MMIO(0x2774), 0x00007ffc },
	{ _MMIO(0x2778), 0x0007affa },
	{ _MMIO(0x277c), 0x0000f5fd },
	{ _MMIO(0x2780), 0x00079ffa },
	{ _MMIO(0x2784), 0x0000f3fb },
	{ _MMIO(0x2788), 0x0007bf7a },
	{ _MMIO(0x278c), 0x0000f7e7 },
	{ _MMIO(0x2790), 0x0007fefa },
	{ _MMIO(0x2794), 0x0000f7cf },
	{ _MMIO(0x2798), 0x00077ffa },
	{ _MMIO(0x279c), 0x0000efdf },
	{ _MMIO(0x27a0), 0x0006fffa },
	{ _MMIO(0x27a4), 0x0000cfbf },
	{ _MMIO(0x27a8), 0x0003fffa },
	{ _MMIO(0x27ac), 0x00005f7f },
};

static const struct i915_oa_reg flex_eu_config_render_pipe_profile[] = {
	{ _MMIO(0xe458), 0x00005004 },
	{ _MMIO(0xe558), 0x00015014 },
	{ _MMIO(0xe658), 0x00025024 },
	{ _MMIO(0xe758), 0x00035034 },
	{ _MMIO(0xe45c), 0x00045044 },
	{ _MMIO(0xe55c), 0x00055054 },
	{ _MMIO(0xe65c), 0x00065064 },
};

static const struct i915_oa_reg mux_config_render_pipe_profile[] = {
	{ _MMIO(0x9888), 0x0c0e001f },
	{ _MMIO(0x9888), 0x0a0f0000 },
	{ _MMIO(0x9888), 0x10116800 },
	{ _MMIO(0x9888), 0x178a03e0 },
	{ _MMIO(0x9888), 0x11824c00 },
	{ _MMIO(0x9888), 0x11830020 },
	{ _MMIO(0x9888), 0x13840020 },
	{ _MMIO(0x9888), 0x11850019 },
	{ _MMIO(0x9888), 0x11860007 },
	{ _MMIO(0x9888), 0x01870c40 },
	{ _MMIO(0x9888), 0x17880000 },
	{ _MMIO(0x9888), 0x022f4000 },
	{ _MMIO(0x9888), 0x0a4c0040 },
	{ _MMIO(0x9888), 0x0c0d8000 },
	{ _MMIO(0x9888), 0x040d4000 },
	{ _MMIO(0x9888), 0x060d2000 },
	{ _MMIO(0x9888), 0x020e5400 },
	{ _MMIO(0x9888), 0x000e0000 },
	{ _MMIO(0x9888), 0x080f0040 },
	{ _MMIO(0x9888), 0x000f0000 },
	{ _MMIO(0x9888), 0x100f0000 },
	{ _MMIO(0x9888), 0x0e0f0040 },
	{ _MMIO(0x9888), 0x0c2c8000 },
	{ _MMIO(0x9888), 0x06104000 },
	{ _MMIO(0x9888), 0x06110012 },
	{ _MMIO(0x9888), 0x06131000 },
	{ _MMIO(0x9888), 0x01898000 },
	{ _MMIO(0x9888), 0x0d890100 },
	{ _MMIO(0x9888), 0x03898000 },
	{ _MMIO(0x9888), 0x09808000 },
	{ _MMIO(0x9888), 0x0b808000 },
	{ _MMIO(0x9888), 0x0380c000 },
	{ _MMIO(0x9888), 0x0f8a0075 },
	{ _MMIO(0x9888), 0x1d8a0000 },
	{ _MMIO(0x9888), 0x118a8000 },
	{ _MMIO(0x9888), 0x1b8a4000 },
	{ _MMIO(0x9888), 0x138a8000 },
	{ _MMIO(0x9888), 0x1d81a000 },
	{ _MMIO(0x9888), 0x15818000 },
	{ _MMIO(0x9888), 0x17818000 },
	{ _MMIO(0x9888), 0x0b820030 },
	{ _MMIO(0x9888), 0x07828000 },
	{ _MMIO(0x9888), 0x0d824000 },
	{ _MMIO(0x9888), 0x0f828000 },
	{ _MMIO(0x9888), 0x05824000 },
	{ _MMIO(0x9888), 0x0d830003 },
	{ _MMIO(0x9888), 0x0583000c },
	{ _MMIO(0x9888), 0x09830000 },
	{ _MMIO(0x9888), 0x03838000 },
	{ _MMIO(0x9888), 0x07838000 },
	{ _MMIO(0x9888), 0x0b840980 },
	{ _MMIO(0x9888), 0x03844d80 },
	{ _MMIO(0x9888), 0x11840000 },
	{ _MMIO(0x9888), 0x09848000 },
	{ _MMIO(0x9888), 0x09850080 },
	{ _MMIO(0x9888), 0x03850003 },
	{ _MMIO(0x9888), 0x01850000 },
	{ _MMIO(0x9888), 0x07860000 },
	{ _MMIO(0x9888), 0x0f860400 },
	{ _MMIO(0x9888), 0x09870032 },
	{ _MMIO(0x9888), 0x01888052 },
	{ _MMIO(0x9888), 0x11880000 },
	{ _MMIO(0x9888), 0x09884000 },
	{ _MMIO(0x9888), 0x1b931001 },
	{ _MMIO(0x9888), 0x1d930001 },
	{ _MMIO(0x9888), 0x19934000 },
	{ _MMIO(0x9888), 0x1b958000 },
	{ _MMIO(0x9888), 0x1d950094 },
	{ _MMIO(0x9888), 0x19958000 },
	{ _MMIO(0x9888), 0x09e58000 },
	{ _MMIO(0x9888), 0x0be58000 },
	{ _MMIO(0x9888), 0x03e5c000 },
	{ _MMIO(0x9888), 0x0592c000 },
	{ _MMIO(0x9888), 0x0b928000 },
	{ _MMIO(0x9888), 0x0d924000 },
	{ _MMIO(0x9888), 0x0f924000 },
	{ _MMIO(0x9888), 0x11928000 },
	{ _MMIO(0x9888), 0x1392c000 },
	{ _MMIO(0x9888), 0x09924000 },
	{ _MMIO(0x9888), 0x01985000 },
	{ _MMIO(0x9888), 0x07988000 },
	{ _MMIO(0x9888), 0x09981000 },
	{ _MMIO(0x9888), 0x0b982000 },
	{ _MMIO(0x9888), 0x0d982000 },
	{ _MMIO(0x9888), 0x0f989000 },
	{ _MMIO(0x9888), 0x05982000 },
	{ _MMIO(0x9888), 0x13904000 },
	{ _MMIO(0x9888), 0x21904000 },
	{ _MMIO(0x9888), 0x23904000 },
	{ _MMIO(0x9888), 0x25908000 },
	{ _MMIO(0x9888), 0x27904000 },
	{ _MMIO(0x9888), 0x29908000 },
	{ _MMIO(0x9888), 0x2b904000 },
	{ _MMIO(0x9888), 0x2f904000 },
	{ _MMIO(0x9888), 0x31904000 },
	{ _MMIO(0x9888), 0x15904000 },
	{ _MMIO(0x9888), 0x17908000 },
	{ _MMIO(0x9888), 0x19908000 },
	{ _MMIO(0x9888), 0x1b904000 },
	{ _MMIO(0x9888), 0x1190c080 },
	{ _MMIO(0x9888), 0x51901110 },
	{ _MMIO(0x9888), 0x41900440 },
	{ _MMIO(0x9888), 0x55901111 },
	{ _MMIO(0x9888), 0x45900400 },
	{ _MMIO(0x9888), 0x47900c21 },
	{ _MMIO(0x9888), 0x57901411 },
	{ _MMIO(0x9888), 0x49900042 },
	{ _MMIO(0x9888), 0x37900000 },
	{ _MMIO(0x9888), 0x33900000 },
	{ _MMIO(0x9888), 0x4b900024 },
	{ _MMIO(0x9888), 0x59900001 },
	{ _MMIO(0x9888), 0x43900841 },
	{ _MMIO(0x9888), 0x53900411 },
};

static int
get_render_pipe_profile_mux_config(struct drm_i915_private *dev_priv,
				   const struct i915_oa_reg **regs,
				   int *lens)
{
	int n = 0;

	BUILD_BUG_ON(ARRAY_SIZE(dev_priv->perf.oa.mux_regs) < 1);
	BUILD_BUG_ON(ARRAY_SIZE(dev_priv->perf.oa.mux_regs_lens) < 1);

	regs[n] = mux_config_render_pipe_profile;
	lens[n] = ARRAY_SIZE(mux_config_render_pipe_profile);
	n++;

	return n;
}

static const struct i915_oa_reg b_counter_config_memory_reads[] = {
	{ _MMIO(0x272c), 0xffffffff },
	{ _MMIO(0x2728), 0xffffffff },
	{ _MMIO(0x2724), 0xf0800000 },
	{ _MMIO(0x2720), 0x00000000 },
	{ _MMIO(0x271c), 0xffffffff },
	{ _MMIO(0x2718), 0xffffffff },
	{ _MMIO(0x2714), 0xf0800000 },
	{ _MMIO(0x2710), 0x00000000 },
	{ _MMIO(0x274c), 0x86543210 },
	{ _MMIO(0x2748), 0x86543210 },
	{ _MMIO(0x2744), 0x00006667 },
	{ _MMIO(0x2740), 0x00000000 },
	{ _MMIO(0x275c), 0x86543210 },
	{ _MMIO(0x2758), 0x86543210 },
	{ _MMIO(0x2754), 0x00006465 },
	{ _MMIO(0x2750), 0x00000000 },
	{ _MMIO(0x2770), 0x0007f81a },
	{ _MMIO(0x2774), 0x0000fe00 },
	{ _MMIO(0x2778), 0x0007f82a },
	{ _MMIO(0x277c), 0x0000fe00 },
	{ _MMIO(0x2780), 0x0007f872 },
	{ _MMIO(0x2784), 0x0000fe00 },
	{ _MMIO(0x2788), 0x0007f8ba },
	{ _MMIO(0x278c), 0x0000fe00 },
	{ _MMIO(0x2790), 0x0007f87a },
	{ _MMIO(0x2794), 0x0000fe00 },
	{ _MMIO(0x2798), 0x0007f8ea },
	{ _MMIO(0x279c), 0x0000fe00 },
	{ _MMIO(0x27a0), 0x0007f8e2 },
	{ _MMIO(0x27a4), 0x0000fe00 },
	{ _MMIO(0x27a8), 0x0007f8f2 },
	{ _MMIO(0x27ac), 0x0000fe00 },
};

static const struct i915_oa_reg flex_eu_config_memory_reads[] = {
	{ _MMIO(0xe458), 0x00005004 },
	{ _MMIO(0xe558), 0x00015014 },
	{ _MMIO(0xe658), 0x00025024 },
	{ _MMIO(0xe758), 0x00035034 },
	{ _MMIO(0xe45c), 0x00045044 },
	{ _MMIO(0xe55c), 0x00055054 },
	{ _MMIO(0xe65c), 0x00065064 },
};

static const struct i915_oa_reg mux_config_memory_reads[] = {
	{ _MMIO(0x9888), 0x11810c00 },
	{ _MMIO(0x9888), 0x1381001a },
	{ _MMIO(0x9888), 0x37906800 },
	{ _MMIO(0x9888), 0x3f900064 },
	{ _MMIO(0x9888), 0x03811300 },
	{ _MMIO(0x9888), 0x05811b12 },
	{ _MMIO(0x9888), 0x0781001a },
	{ _MMIO(0x9888), 0x1f810000 },
	{ _MMIO(0x9888), 0x17810000 },
	{ _MMIO(0x9888), 0x19810000 },
	{ _MMIO(0x9888), 0x1b810000 },
	{ _MMIO(0x9888), 0x1d810000 },
	{ _MMIO(0x9888), 0x1b930055 },
	{ _MMIO(0x9888), 0x03e58000 },
	{ _MMIO(0x9888), 0x05e5c000 },
	{ _MMIO(0x9888), 0x07e54000 },
	{ _MMIO(0x9888), 0x13900150 },
	{ _MMIO(0x9888), 0x21900151 },
	{ _MMIO(0x9888), 0x23900152 },
	{ _MMIO(0x9888), 0x25900153 },
	{ _MMIO(0x9888), 0x27900154 },
	{ _MMIO(0x9888), 0x29900155 },
	{ _MMIO(0x9888), 0x2b900156 },
	{ _MMIO(0x9888), 0x2d900157 },
	{ _MMIO(0x9888), 0x2f90015f },
	{ _MMIO(0x9888), 0x31900105 },
	{ _MMIO(0x9888), 0x15900103 },
	{ _MMIO(0x9888), 0x17900101 },
	{ _MMIO(0x9888), 0x35900000 },
	{ _MMIO(0x9888), 0x19908000 },
	{ _MMIO(0x9888), 0x1b908000 },
	{ _MMIO(0x9888), 0x1d908000 },
	{ _MMIO(0x9888), 0x1f908000 },
	{ _MMIO(0x9888), 0x11900000 },
	{ _MMIO(0x9888), 0x51900000 },
	{ _MMIO(0x9888), 0x41900c60 },
	{ _MMIO(0x9888), 0x55900000 },
	{ _MMIO(0x9888), 0x45900c00 },
	{ _MMIO(0x9888), 0x47900c63 },
	{ _MMIO(0x9888), 0x57900000 },
	{ _MMIO(0x9888), 0x49900c63 },
	{ _MMIO(0x9888), 0x33900000 },
	{ _MMIO(0x9888), 0x4b900063 },
	{ _MMIO(0x9888), 0x59900000 },
	{ _MMIO(0x9888), 0x43900003 },
	{ _MMIO(0x9888), 0x53900000 },
};

static int
get_memory_reads_mux_config(struct drm_i915_private *dev_priv,
			    const struct i915_oa_reg **regs,
			    int *lens)
{
	int n = 0;

	BUILD_BUG_ON(ARRAY_SIZE(dev_priv->perf.oa.mux_regs) < 1);
	BUILD_BUG_ON(ARRAY_SIZE(dev_priv->perf.oa.mux_regs_lens) < 1);

	regs[n] = mux_config_memory_reads;
	lens[n] = ARRAY_SIZE(mux_config_memory_reads);
	n++;

	return n;
}

static const struct i915_oa_reg b_counter_config_memory_writes[] = {
	{ _MMIO(0x272c), 0xffffffff },
	{ _MMIO(0x2728), 0xffffffff },
	{ _MMIO(0x2724), 0xf0800000 },
	{ _MMIO(0x2720), 0x00000000 },
	{ _MMIO(0x271c), 0xffffffff },
	{ _MMIO(0x2718), 0xffffffff },
	{ _MMIO(0x2714), 0xf0800000 },
	{ _MMIO(0x2710), 0x00000000 },
	{ _MMIO(0x274c), 0x86543210 },
	{ _MMIO(0x2748), 0x86543210 },
	{ _MMIO(0x2744), 0x00006667 },
	{ _MMIO(0x2740), 0x00000000 },
	{ _MMIO(0x275c), 0x86543210 },
	{ _MMIO(0x2758), 0x86543210 },
	{ _MMIO(0x2754), 0x00006465 },
	{ _MMIO(0x2750), 0x00000000 },
	{ _MMIO(0x2770), 0x0007f81a },
	{ _MMIO(0x2774), 0x0000fe00 },
	{ _MMIO(0x2778), 0x0007f82a },
	{ _MMIO(0x277c), 0x0000fe00 },
	{ _MMIO(0x2780), 0x0007f822 },
	{ _MMIO(0x2784), 0x0000fe00 },
	{ _MMIO(0x2788), 0x0007f8ba },
	{ _MMIO(0x278c), 0x0000fe00 },
	{ _MMIO(0x2790), 0x0007f87a },
	{ _MMIO(0x2794), 0x0000fe00 },
	{ _MMIO(0x2798), 0x0007f8ea },
	{ _MMIO(0x279c), 0x0000fe00 },
	{ _MMIO(0x27a0), 0x0007f8e2 },
	{ _MMIO(0x27a4), 0x0000fe00 },
	{ _MMIO(0x27a8), 0x0007f8f2 },
	{ _MMIO(0x27ac), 0x0000fe00 },
};

static const struct i915_oa_reg flex_eu_config_memory_writes[] = {
	{ _MMIO(0xe458), 0x00005004 },
	{ _MMIO(0xe558), 0x00015014 },
	{ _MMIO(0xe658), 0x00025024 },
	{ _MMIO(0xe758), 0x00035034 },
	{ _MMIO(0xe45c), 0x00045044 },
	{ _MMIO(0xe55c), 0x00055054 },
	{ _MMIO(0xe65c), 0x00065064 },
};

static const struct i915_oa_reg mux_config_memory_writes[] = {
	{ _MMIO(0x9888), 0x11810c00 },
	{ _MMIO(0x9888), 0x1381001a },
	{ _MMIO(0x9888), 0x37906800 },
	{ _MMIO(0x9888), 0x3f901000 },
	{ _MMIO(0x9888), 0x03811300 },
	{ _MMIO(0x9888), 0x05811b12 },
	{ _MMIO(0x9888), 0x0781001a },
	{ _MMIO(0x9888), 0x1f810000 },
	{ _MMIO(0x9888), 0x17810000 },
	{ _MMIO(0x9888), 0x19810000 },
	{ _MMIO(0x9888), 0x1b810000 },
	{ _MMIO(0x9888), 0x1d810000 },
	{ _MMIO(0x9888), 0x1b930055 },
	{ _MMIO(0x9888), 0x03e58000 },
	{ _MMIO(0x9888), 0x05e5c000 },
	{ _MMIO(0x9888), 0x07e54000 },
	{ _MMIO(0x9888), 0x13900160 },
	{ _MMIO(0x9888), 0x21900161 },
	{ _MMIO(0x9888), 0x23900162 },
	{ _MMIO(0x9888), 0x25900163 },
	{ _MMIO(0x9888), 0x27900164 },
	{ _MMIO(0x9888), 0x29900165 },
	{ _MMIO(0x9888), 0x2b900166 },
	{ _MMIO(0x9888), 0x2d900167 },
	{ _MMIO(0x9888), 0x2f900150 },
	{ _MMIO(0x9888), 0x31900105 },
	{ _MMIO(0x9888), 0x15900103 },
	{ _MMIO(0x9888), 0x17900101 },
	{ _MMIO(0x9888), 0x35900000 },
	{ _MMIO(0x9888), 0x19908000 },
	{ _MMIO(0x9888), 0x1b908000 },
	{ _MMIO(0x9888), 0x1d908000 },
	{ _MMIO(0x9888), 0x1f908000 },
	{ _MMIO(0x9888), 0x11900000 },
	{ _MMIO(0x9888), 0x51900000 },
	{ _MMIO(0x9888), 0x41900c60 },
	{ _MMIO(0x9888), 0x55900000 },
	{ _MMIO(0x9888), 0x45900c00 },
	{ _MMIO(0x9888), 0x47900c63 },
	{ _MMIO(0x9888), 0x57900000 },
	{ _MMIO(0x9888), 0x49900c63 },
	{ _MMIO(0x9888), 0x33900000 },
	{ _MMIO(0x9888), 0x4b900063 },
	{ _MMIO(0x9888), 0x59900000 },
	{ _MMIO(0x9888), 0x43900003 },
	{ _MMIO(0x9888), 0x53900000 },
};

static int
get_memory_writes_mux_config(struct drm_i915_private *dev_priv,
			     const struct i915_oa_reg **regs,
			     int *lens)
{
	int n = 0;

	BUILD_BUG_ON(ARRAY_SIZE(dev_priv->perf.oa.mux_regs) < 1);
	BUILD_BUG_ON(ARRAY_SIZE(dev_priv->perf.oa.mux_regs_lens) < 1);

	regs[n] = mux_config_memory_writes;
	lens[n] = ARRAY_SIZE(mux_config_memory_writes);
	n++;

	return n;
}

static const struct i915_oa_reg b_counter_config_compute_extended[] = {
	{ _MMIO(0x2724), 0xf0800000 },
	{ _MMIO(0x2720), 0x00000000 },
	{ _MMIO(0x2714), 0xf0800000 },
	{ _MMIO(0x2710), 0x00000000 },
	{ _MMIO(0x2740), 0x00000000 },
	{ _MMIO(0x2770), 0x0007fc2a },
	{ _MMIO(0x2774), 0x0000bf00 },
	{ _MMIO(0x2778), 0x0007fc6a },
	{ _MMIO(0x277c), 0x0000bf00 },
	{ _MMIO(0x2780), 0x0007fc92 },
	{ _MMIO(0x2784), 0x0000bf00 },
	{ _MMIO(0x2788), 0x0007fca2 },
	{ _MMIO(0x278c), 0x0000bf00 },
	{ _MMIO(0x2790), 0x0007fc32 },
	{ _MMIO(0x2794), 0x0000bf00 },
	{ _MMIO(0x2798), 0x0007fc9a },
	{ _MMIO(0x279c), 0x0000bf00 },
	{ _MMIO(0x27a0), 0x0007fe6a },
	{ _MMIO(0x27a4), 0x0000bf00 },
	{ _MMIO(0x27a8), 0x0007fe7a },
	{ _MMIO(0x27ac), 0x0000bf00 },
};

static const struct i915_oa_reg flex_eu_config_compute_extended[] = {
	{ _MMIO(0xe458), 0x00005004 },
	{ _MMIO(0xe558), 0x00000003 },
	{ _MMIO(0xe658), 0x00002001 },
	{ _MMIO(0xe758), 0x00778008 },
	{ _MMIO(0xe45c), 0x00088078 },
	{ _MMIO(0xe55c), 0x00808708 },
	{ _MMIO(0xe65c), 0x00a08908 },
};

static const struct i915_oa_reg mux_config_compute_extended[] = {
	{ _MMIO(0x9888), 0x106c00e0 },
	{ _MMIO(0x9888), 0x141c8160 },
	{ _MMIO(0x9888), 0x161c8015 },
	{ _MMIO(0x9888), 0x181c0120 },
	{ _MMIO(0x9888), 0x004e8000 },
	{ _MMIO(0x9888), 0x0e4e8000 },
	{ _MMIO(0x9888), 0x184e8000 },
	{ _MMIO(0x9888), 0x1a4eaaa0 },
	{ _MMIO(0x9888), 0x1c4e0002 },
	{ _MMIO(0x9888), 0x024e8000 },
	{ _MMIO(0x9888), 0x044e8000 },
	{ _MMIO(0x9888), 0x064e8000 },
	{ _MMIO(0x9888), 0x084e8000 },
	{ _MMIO(0x9888), 0x0a4e8000 },
	{ _MMIO(0x9888), 0x0e6c0b01 },
	{ _MMIO(0x9888), 0x006c0200 },
	{ _MMIO(0x9888), 0x026c000c },
	{ _MMIO(0x9888), 0x1c6c0000 },
	{ _MMIO(0x9888), 0x1e6c0000 },
	{ _MMIO(0x9888), 0x1a6c0000 },
	{ _MMIO(0x9888), 0x0e1bc000 },
	{ _MMIO(0x9888), 0x001b8000 },
	{ _MMIO(0x9888), 0x021bc000 },
	{ _MMIO(0x9888), 0x001c0041 },
	{ _MMIO(0x9888), 0x061c4200 },
	{ _MMIO(0x9888), 0x081c4443 },
	{ _MMIO(0x9888), 0x0a1c4645 },
	{ _MMIO(0x9888), 0x0c1c7647 },
	{ _MMIO(0x9888), 0x041c7357 },
	{ _MMIO(0x9888), 0x1c1c0030 },
	{ _MMIO(0x9888), 0x101c0000 },
	{ _MMIO(0x9888), 0x1a1c0000 },
	{ _MMIO(0x9888), 0x121c8000 },
	{ _MMIO(0x9888), 0x004c8000 },
	{ _MMIO(0x9888), 0x0a4caa2a },
	{ _MMIO(0x9888), 0x0c4c02aa },
	{ _MMIO(0x9888), 0x084ca000 },
	{ _MMIO(0x9888), 0x000da000 },
	{ _MMIO(0x9888), 0x060d8000 },
	{ _MMIO(0x9888), 0x080da000 },
	{ _MMIO(0x9888), 0x0a0da000 },
	{ _MMIO(0x9888), 0x0c0da000 },
	{ _MMIO(0x9888), 0x0e0da000 },
	{ _MMIO(0x9888), 0x020da000 },
	{ _MMIO(0x9888), 0x040da000 },
	{ _MMIO(0x9888), 0x0c0f5400 },
	{ _MMIO(0x9888), 0x0e0f5515 },
	{ _MMIO(0x9888), 0x100f0155 },
	{ _MMIO(0x9888), 0x002c8000 },
	{ _MMIO(0x9888), 0x0e2c8000 },
	{ _MMIO(0x9888), 0x162caa00 },
	{ _MMIO(0x9888), 0x182c00aa },
	{ _MMIO(0x9888), 0x022c8000 },
	{ _MMIO(0x9888), 0x042c8000 },
	{ _MMIO(0x9888), 0x062c8000 },
	{ _MMIO(0x9888), 0x082c8000 },
	{ _MMIO(0x9888), 0x0a2c8000 },
	{ _MMIO(0x9888), 0x11907fff },
	{ _MMIO(0x9888), 0x51900000 },
	{ _MMIO(0x9888), 0x41900040 },
	{ _MMIO(0x9888), 0x55900000 },
	{ _MMIO(0x9888), 0x45900802 },
	{ _MMIO(0x9888), 0x47900842 },
	{ _MMIO(0x9888), 0x57900000 },
	{ _MMIO(0x9888), 0x49900842 },
	{ _MMIO(0x9888), 0x37900000 },
	{ _MMIO(0x9888), 0x33900000 },
	{ _MMIO(0x9888), 0x4b900000 },
	{ _MMIO(0x9888), 0x59900000 },
	{ _MMIO(0x9888), 0x43900800 },
	{ _MMIO(0x9888), 0x53900000 },
};

static int
get_compute_extended_mux_config(struct drm_i915_private *dev_priv,
				const struct i915_oa_reg **regs,
				int *lens)
{
	int n = 0;

	BUILD_BUG_ON(ARRAY_SIZE(dev_priv->perf.oa.mux_regs) < 1);
	BUILD_BUG_ON(ARRAY_SIZE(dev_priv->perf.oa.mux_regs_lens) < 1);

	regs[n] = mux_config_compute_extended;
	lens[n] = ARRAY_SIZE(mux_config_compute_extended);
	n++;

	return n;
}

static const struct i915_oa_reg b_counter_config_compute_l3_cache[] = {
	{ _MMIO(0x2710), 0x00000000 },
	{ _MMIO(0x2714), 0x30800000 },
	{ _MMIO(0x2720), 0x00000000 },
	{ _MMIO(0x2724), 0x30800000 },
	{ _MMIO(0x2740), 0x00000000 },
	{ _MMIO(0x2770), 0x0007fffa },
	{ _MMIO(0x2774), 0x0000fefe },
	{ _MMIO(0x2778), 0x0007fffa },
	{ _MMIO(0x277c), 0x0000fefd },
	{ _MMIO(0x2790), 0x0007fffa },
	{ _MMIO(0x2794), 0x0000fbef },
	{ _MMIO(0x2798), 0x0007fffa },
	{ _MMIO(0x279c), 0x0000fbdf },
};

static const struct i915_oa_reg flex_eu_config_compute_l3_cache[] = {
	{ _MMIO(0xe458), 0x00005004 },
	{ _MMIO(0xe558), 0x00000003 },
	{ _MMIO(0xe658), 0x00002001 },
	{ _MMIO(0xe758), 0x00101100 },
	{ _MMIO(0xe45c), 0x00201200 },
	{ _MMIO(0xe55c), 0x00301300 },
	{ _MMIO(0xe65c), 0x00401400 },
};

static const struct i915_oa_reg mux_config_compute_l3_cache[] = {
	{ _MMIO(0x9888), 0x166c0760 },
	{ _MMIO(0x9888), 0x1593001e },
	{ _MMIO(0x9888), 0x3f900003 },
	{ _MMIO(0x9888), 0x004e8000 },
	{ _MMIO(0x9888), 0x0e4e8000 },
	{ _MMIO(0x9888), 0x184e8000 },
	{ _MMIO(0x9888), 0x1a4e8020 },
	{ _MMIO(0x9888), 0x1c4e0002 },
	{ _MMIO(0x9888), 0x006c0051 },
	{ _MMIO(0x9888), 0x066c5000 },
	{ _MMIO(0x9888), 0x086c5c5d },
	{ _MMIO(0x9888), 0x0e6c5e5f },
	{ _MMIO(0x9888), 0x106c0000 },
	{ _MMIO(0x9888), 0x186c0000 },
	{ _MMIO(0x9888), 0x1c6c0000 },
	{ _MMIO(0x9888), 0x1e6c0000 },
	{ _MMIO(0x9888), 0x001b4000 },
	{ _MMIO(0x9888), 0x061b8000 },
	{ _MMIO(0x9888), 0x081bc000 },
	{ _MMIO(0x9888), 0x0e1bc000 },
	{ _MMIO(0x9888), 0x101c8000 },
	{ _MMIO(0x9888), 0x1a1ce000 },
	{ _MMIO(0x9888), 0x1c1c0030 },
	{ _MMIO(0x9888), 0x004c8000 },
	{ _MMIO(0x9888), 0x0a4c2a00 },
	{ _MMIO(0x9888), 0x0c4c0280 },
	{ _MMIO(0x9888), 0x000d2000 },
	{ _MMIO(0x9888), 0x060d8000 },
	{ _MMIO(0x9888), 0x080da000 },
	{ _MMIO(0x9888), 0x0e0da000 },
	{ _MMIO(0x9888), 0x0c0f0400 },
	{ _MMIO(0x9888), 0x0e0f1500 },
	{ _MMIO(0x9888), 0x100f0140 },
	{ _MMIO(0x9888), 0x002c8000 },
	{ _MMIO(0x9888), 0x0e2c8000 },
	{ _MMIO(0x9888), 0x162c0a00 },
	{ _MMIO(0x9888), 0x182c00a0 },
	{ _MMIO(0x9888), 0x03933300 },
	{ _MMIO(0x9888), 0x05930032 },
	{ _MMIO(0x9888), 0x11930000 },
	{ _MMIO(0x9888), 0x1b930000 },
	{ _MMIO(0x9888), 0x1d900157 },
	{ _MMIO(0x9888), 0x1f900158 },
	{ _MMIO(0x9888), 0x35900000 },
	{ _MMIO(0x9888), 0x19908000 },
	{ _MMIO(0x9888), 0x1b908000 },
	{ _MMIO(0x9888), 0x1190030f },
	{ _MMIO(0x9888), 0x51900000 },
	{ _MMIO(0x9888), 0x41900000 },
	{ _MMIO(0x9888), 0x55900000 },
	{ _MMIO(0x9888), 0x45900021 },
	{ _MMIO(0x9888), 0x47900000 },
	{ _MMIO(0x9888), 0x37900000 },
	{ _MMIO(0x9888), 0x33900000 },
	{ _MMIO(0x9888), 0x57900000 },
	{ _MMIO(0x9888), 0x4b900000 },
	{ _MMIO(0x9888), 0x59900000 },
	{ _MMIO(0x9888), 0x53905555 },
	{ _MMIO(0x9888), 0x43900000 },
};

static int
get_compute_l3_cache_mux_config(struct drm_i915_private *dev_priv,
				const struct i915_oa_reg **regs,
				int *lens)
{
	int n = 0;

	BUILD_BUG_ON(ARRAY_SIZE(dev_priv->perf.oa.mux_regs) < 1);
	BUILD_BUG_ON(ARRAY_SIZE(dev_priv->perf.oa.mux_regs_lens) < 1);

	regs[n] = mux_config_compute_l3_cache;
	lens[n] = ARRAY_SIZE(mux_config_compute_l3_cache);
	n++;

	return n;
}

static const struct i915_oa_reg b_counter_config_hdc_and_sf[] = {
	{ _MMIO(0x2740), 0x00000000 },
	{ _MMIO(0x2744), 0x00800000 },
	{ _MMIO(0x2710), 0x00000000 },
	{ _MMIO(0x2714), 0x10800000 },
	{ _MMIO(0x2720), 0x00000000 },
	{ _MMIO(0x2724), 0x00800000 },
	{ _MMIO(0x2770), 0x00000002 },
	{ _MMIO(0x2774), 0x0000fdff },
};

static const struct i915_oa_reg flex_eu_config_hdc_and_sf[] = {
	{ _MMIO(0xe458), 0x00005004 },
	{ _MMIO(0xe558), 0x00010003 },
	{ _MMIO(0xe658), 0x00012011 },
	{ _MMIO(0xe758), 0x00015014 },
	{ _MMIO(0xe45c), 0x00051050 },
	{ _MMIO(0xe55c), 0x00053052 },
	{ _MMIO(0xe65c), 0x00055054 },
};

static const struct i915_oa_reg mux_config_hdc_and_sf[] = {
	{ _MMIO(0x9888), 0x104f0232 },
	{ _MMIO(0x9888), 0x124f4640 },
	{ _MMIO(0x9888), 0x106c0232 },
	{ _MMIO(0x9888), 0x11834400 },
	{ _MMIO(0x9888), 0x0a4e8000 },
	{ _MMIO(0x9888), 0x0c4e8000 },
	{ _MMIO(0x9888), 0x004f1880 },
	{ _MMIO(0x9888), 0x024f08bb },
	{ _MMIO(0x9888), 0x044f001b },
	{ _MMIO(0x9888), 0x046c0100 },
	{ _MMIO(0x9888), 0x066c000b },
	{ _MMIO(0x9888), 0x1a6c0000 },
	{ _MMIO(0x9888), 0x041b8000 },
	{ _MMIO(0x9888), 0x061b4000 },
	{ _MMIO(0x9888), 0x1a1c1800 },
	{ _MMIO(0x9888), 0x005b8000 },
	{ _MMIO(0x9888), 0x025bc000 },
	{ _MMIO(0x9888), 0x045b4000 },
	{ _MMIO(0x9888), 0x125c8000 },
	{ _MMIO(0x9888), 0x145c8000 },
	{ _MMIO(0x9888), 0x165c8000 },
	{ _MMIO(0x9888), 0x185c8000 },
	{ _MMIO(0x9888), 0x0a4c00a0 },
	{ _MMIO(0x9888), 0x000d8000 },
	{ _MMIO(0x9888), 0x020da000 },
	{ _MMIO(0x9888), 0x040da000 },
	{ _MMIO(0x9888), 0x060d2000 },
	{ _MMIO(0x9888), 0x0c0f5000 },
	{ _MMIO(0x9888), 0x0e0f0055 },
	{ _MMIO(0x9888), 0x022cc000 },
	{ _MMIO(0x9888), 0x042cc000 },
	{ _MMIO(0x9888), 0x062cc000 },
	{ _MMIO(0x9888), 0x082cc000 },
	{ _MMIO(0x9888), 0x0a2c8000 },
	{ _MMIO(0x9888), 0x0c2c8000 },
	{ _MMIO(0x9888), 0x0f828000 },
	{ _MMIO(0x9888), 0x0f8305c0 },
	{ _MMIO(0x9888), 0x09830000 },
	{ _MMIO(0x9888), 0x07830000 },
	{ _MMIO(0x9888), 0x1d950080 },
	{ _MMIO(0x9888), 0x13928000 },
	{ _MMIO(0x9888), 0x0f988000 },
	{ _MMIO(0x9888), 0x31904000 },
	{ _MMIO(0x9888), 0x1190fc00 },
	{ _MMIO(0x9888), 0x37900000 },
	{ _MMIO(0x9888), 0x59900001 },
	{ _MMIO(0x9888), 0x4b900040 },
	{ _MMIO(0x9888), 0x51900000 },
	{ _MMIO(0x9888), 0x41900800 },
	{ _MMIO(0x9888), 0x43900842 },
	{ _MMIO(0x9888), 0x53900000 },
	{ _MMIO(0x9888), 0x45900000 },
	{ _MMIO(0x9888), 0x33900000 },
};

static int
get_hdc_and_sf_mux_config(struct drm_i915_private *dev_priv,
			  const struct i915_oa_reg **regs,
			  int *lens)
{
	int n = 0;

	BUILD_BUG_ON(ARRAY_SIZE(dev_priv->perf.oa.mux_regs) < 1);
	BUILD_BUG_ON(ARRAY_SIZE(dev_priv->perf.oa.mux_regs_lens) < 1);

	regs[n] = mux_config_hdc_and_sf;
	lens[n] = ARRAY_SIZE(mux_config_hdc_and_sf);
	n++;

	return n;
}

static const struct i915_oa_reg b_counter_config_l3_1[] = {
	{ _MMIO(0x2740), 0x00000000 },
	{ _MMIO(0x2744), 0x00800000 },
	{ _MMIO(0x2710), 0x00000000 },
	{ _MMIO(0x2714), 0xf0800000 },
	{ _MMIO(0x2720), 0x00000000 },
	{ _MMIO(0x2724), 0xf0800000 },
	{ _MMIO(0x2770), 0x00100070 },
	{ _MMIO(0x2774), 0x0000fff1 },
	{ _MMIO(0x2778), 0x00014002 },
	{ _MMIO(0x277c), 0x0000c3ff },
	{ _MMIO(0x2780), 0x00010002 },
	{ _MMIO(0x2784), 0x0000c7ff },
	{ _MMIO(0x2788), 0x00004002 },
	{ _MMIO(0x278c), 0x0000d3ff },
	{ _MMIO(0x2790), 0x00100700 },
	{ _MMIO(0x2794), 0x0000ff1f },
	{ _MMIO(0x2798), 0x00001402 },
	{ _MMIO(0x279c), 0x0000fc3f },
	{ _MMIO(0x27a0), 0x00001002 },
	{ _MMIO(0x27a4), 0x0000fc7f },
	{ _MMIO(0x27a8), 0x00000402 },
	{ _MMIO(0x27ac), 0x0000fd3f },
};

static const struct i915_oa_reg flex_eu_config_l3_1[] = {
	{ _MMIO(0xe458), 0x00005004 },
	{ _MMIO(0xe558), 0x00010003 },
	{ _MMIO(0xe658), 0x00012011 },
	{ _MMIO(0xe758), 0x00015014 },
	{ _MMIO(0xe45c), 0x00051050 },
	{ _MMIO(0xe55c), 0x00053052 },
	{ _MMIO(0xe65c), 0x00055054 },
};

static const struct i915_oa_reg mux_config_l3_1[] = {
	{ _MMIO(0x9888), 0x126c7b40 },
	{ _MMIO(0x9888), 0x166c0020 },
	{ _MMIO(0x9888), 0x0a603444 },
	{ _MMIO(0x9888), 0x0a613400 },
	{ _MMIO(0x9888), 0x1a4ea800 },
	{ _MMIO(0x9888), 0x1c4e0002 },
	{ _MMIO(0x9888), 0x024e8000 },
	{ _MMIO(0x9888), 0x044e8000 },
	{ _MMIO(0x9888), 0x064e8000 },
	{ _MMIO(0x9888), 0x084e8000 },
	{ _MMIO(0x9888), 0x0a4e8000 },
	{ _MMIO(0x9888), 0x064f4000 },
	{ _MMIO(0x9888), 0x0c6c5327 },
	{ _MMIO(0x9888), 0x0e6c5425 },
	{ _MMIO(0x9888), 0x006c2a00 },
	{ _MMIO(0x9888), 0x026c285b },
	{ _MMIO(0x9888), 0x046c005c },
	{ _MMIO(0x9888), 0x106c0000 },
	{ _MMIO(0x9888), 0x1c6c0000 },
	{ _MMIO(0x9888), 0x1e6c0000 },
	{ _MMIO(0x9888), 0x1a6c0800 },
	{ _MMIO(0x9888), 0x0c1bc000 },
	{ _MMIO(0x9888), 0x0e1bc000 },
	{ _MMIO(0x9888), 0x001b8000 },
	{ _MMIO(0x9888), 0x021bc000 },
	{ _MMIO(0x9888), 0x041bc000 },
	{ _MMIO(0x9888), 0x1c1c003c },
	{ _MMIO(0x9888), 0x121c8000 },
	{ _MMIO(0x9888), 0x141c8000 },
	{ _MMIO(0x9888), 0x161c8000 },
	{ _MMIO(0x9888), 0x181c8000 },
	{ _MMIO(0x9888), 0x1a1c0800 },
	{ _MMIO(0x9888), 0x065b4000 },
	{ _MMIO(0x9888), 0x1a5c1000 },
	{ _MMIO(0x9888), 0x10600000 },
	{ _MMIO(0x9888), 0x04600000 },
	{ _MMIO(0x9888), 0x0c610044 },
	{ _MMIO(0x9888), 0x10610000 },
	{ _MMIO(0x9888), 0x06610000 },
	{ _MMIO(0x9888), 0x0c4c02a8 },
	{ _MMIO(0x9888), 0x084ca000 },
	{ _MMIO(0x9888), 0x0a4c002a },
	{ _MMIO(0x9888), 0x0c0da000 },
	{ _MMIO(0x9888), 0x0e0da000 },
	{ _MMIO(0x9888), 0x000d8000 },
	{ _MMIO(0x9888), 0x020da000 },
	{ _MMIO(0x9888), 0x040da000 },
	{ _MMIO(0x9888), 0x060d2000 },
	{ _MMIO(0x9888), 0x100f0154 },
	{ _MMIO(0x9888), 0x0c0f5000 },
	{ _MMIO(0x9888), 0x0e0f0055 },
	{ _MMIO(0x9888), 0x182c00aa },
	{ _MMIO(0x9888), 0x022c8000 },
	{ _MMIO(0x9888), 0x042c8000 },
	{ _MMIO(0x9888), 0x062c8000 },
	{ _MMIO(0x9888), 0x082c8000 },
	{ _MMIO(0x9888), 0x0a2c8000 },
	{ _MMIO(0x9888), 0x0c2cc000 },
	{ _MMIO(0x9888), 0x1190ffc0 },
	{ _MMIO(0x9888), 0x57900000 },
	{ _MMIO(0x9888), 0x49900420 },
	{ _MMIO(0x9888), 0x37900000 },
	{ _MMIO(0x9888), 0x33900000 },
	{ _MMIO(0x9888), 0x4b900021 },
	{ _MMIO(0x9888), 0x59900000 },
	{ _MMIO(0x9888), 0x51900000 },
	{ _MMIO(0x9888), 0x41900400 },
	{ _MMIO(0x9888), 0x43900421 },
	{ _MMIO(0x9888), 0x53900000 },
	{ _MMIO(0x9888), 0x45900040 },
};

static int
get_l3_1_mux_config(struct drm_i915_private *dev_priv,
		    const struct i915_oa_reg **regs,
		    int *lens)
{
	int n = 0;

	BUILD_BUG_ON(ARRAY_SIZE(dev_priv->perf.oa.mux_regs) < 1);
	BUILD_BUG_ON(ARRAY_SIZE(dev_priv->perf.oa.mux_regs_lens) < 1);

	regs[n] = mux_config_l3_1;
	lens[n] = ARRAY_SIZE(mux_config_l3_1);
	n++;

	return n;
}

static const struct i915_oa_reg b_counter_config_l3_2[] = {
	{ _MMIO(0x2740), 0x00000000 },
	{ _MMIO(0x2744), 0x00800000 },
	{ _MMIO(0x2710), 0x00000000 },
	{ _MMIO(0x2714), 0xf0800000 },
	{ _MMIO(0x2720), 0x00000000 },
	{ _MMIO(0x2724), 0x00800000 },
	{ _MMIO(0x2770), 0x00100070 },
	{ _MMIO(0x2774), 0x0000fff1 },
	{ _MMIO(0x2778), 0x00028002 },
	{ _MMIO(0x277c), 0x000087ff },
	{ _MMIO(0x2780), 0x00020002 },
	{ _MMIO(0x2784), 0x00008fff },
	{ _MMIO(0x2788), 0x00008002 },
	{ _MMIO(0x278c), 0x0000a7ff },
};

static const struct i915_oa_reg flex_eu_config_l3_2[] = {
	{ _MMIO(0xe458), 0x00005004 },
	{ _MMIO(0xe558), 0x00010003 },
	{ _MMIO(0xe658), 0x00012011 },
	{ _MMIO(0xe758), 0x00015014 },
	{ _MMIO(0xe45c), 0x00051050 },
	{ _MMIO(0xe55c), 0x00053052 },
	{ _MMIO(0xe65c), 0x00055054 },
};

static const struct i915_oa_reg mux_config_l3_2[] = {
	{ _MMIO(0x9888), 0x126c02e0 },
	{ _MMIO(0x9888), 0x146c0001 },
	{ _MMIO(0x9888), 0x0a623400 },
	{ _MMIO(0x9888), 0x044e8000 },
	{ _MMIO(0x9888), 0x064e8000 },
	{ _MMIO(0x9888), 0x084e8000 },
	{ _MMIO(0x9888), 0x0a4e8000 },
	{ _MMIO(0x9888), 0x064f4000 },
	{ _MMIO(0x9888), 0x026c3324 },
	{ _MMIO(0x9888), 0x046c3422 },
	{ _MMIO(0x9888), 0x106c0000 },
	{ _MMIO(0x9888), 0x1a6c0000 },
	{ _MMIO(0x9888), 0x021bc000 },
	{ _MMIO(0x9888), 0x041bc000 },
	{ _MMIO(0x9888), 0x141c8000 },
	{ _MMIO(0x9888), 0x161c8000 },
	{ _MMIO(0x9888), 0x181c8000 },
	{ _MMIO(0x9888), 0x1a1c0800 },
	{ _MMIO(0x9888), 0x065b4000 },
	{ _MMIO(0x9888), 0x1a5c1000 },
	{ _MMIO(0x9888), 0x06614000 },
	{ _MMIO(0x9888), 0x0c620044 },
	{ _MMIO(0x9888), 0x10620000 },
	{ _MMIO(0x9888), 0x06620000 },
	{ _MMIO(0x9888), 0x084c8000 },
	{ _MMIO(0x9888), 0x0a4c002a },
	{ _MMIO(0x9888), 0x020da000 },
	{ _MMIO(0x9888), 0x040da000 },
	{ _MMIO(0x9888), 0x060d2000 },
	{ _MMIO(0x9888), 0x0c0f4000 },
	{ _MMIO(0x9888), 0x0e0f0055 },
	{ _MMIO(0x9888), 0x042c8000 },
	{ _MMIO(0x9888), 0x062c8000 },
	{ _MMIO(0x9888), 0x082c8000 },
	{ _MMIO(0x9888), 0x0a2c8000 },
	{ _MMIO(0x9888), 0x0c2cc000 },
	{ _MMIO(0x9888), 0x1190f800 },
	{ _MMIO(0x9888), 0x37900000 },
	{ _MMIO(0x9888), 0x51900000 },
	{ _MMIO(0x9888), 0x43900000 },
	{ _MMIO(0x9888), 0x53900000 },
	{ _MMIO(0x9888), 0x45900000 },
	{ _MMIO(0x9888), 0x33900000 },
};

static int
get_l3_2_mux_config(struct drm_i915_private *dev_priv,
		    const struct i915_oa_reg **regs,
		    int *lens)
{
	int n = 0;

	BUILD_BUG_ON(ARRAY_SIZE(dev_priv->perf.oa.mux_regs) < 1);
	BUILD_BUG_ON(ARRAY_SIZE(dev_priv->perf.oa.mux_regs_lens) < 1);

	regs[n] = mux_config_l3_2;
	lens[n] = ARRAY_SIZE(mux_config_l3_2);
	n++;

	return n;
}

static const struct i915_oa_reg b_counter_config_l3_3[] = {
	{ _MMIO(0x2740), 0x00000000 },
	{ _MMIO(0x2744), 0x00800000 },
	{ _MMIO(0x2710), 0x00000000 },
	{ _MMIO(0x2714), 0xf0800000 },
	{ _MMIO(0x2720), 0x00000000 },
	{ _MMIO(0x2724), 0x00800000 },
	{ _MMIO(0x2770), 0x00100070 },
	{ _MMIO(0x2774), 0x0000fff1 },
	{ _MMIO(0x2778), 0x00028002 },
	{ _MMIO(0x277c), 0x000087ff },
	{ _MMIO(0x2780), 0x00020002 },
	{ _MMIO(0x2784), 0x00008fff },
	{ _MMIO(0x2788), 0x00008002 },
	{ _MMIO(0x278c), 0x0000a7ff },
};

static const struct i915_oa_reg flex_eu_config_l3_3[] = {
	{ _MMIO(0xe458), 0x00005004 },
	{ _MMIO(0xe558), 0x00010003 },
	{ _MMIO(0xe658), 0x00012011 },
	{ _MMIO(0xe758), 0x00015014 },
	{ _MMIO(0xe45c), 0x00051050 },
	{ _MMIO(0xe55c), 0x00053052 },
	{ _MMIO(0xe65c), 0x00055054 },
};

static const struct i915_oa_reg mux_config_l3_3[] = {
	{ _MMIO(0x9888), 0x126c4e80 },
	{ _MMIO(0x9888), 0x146c0000 },
	{ _MMIO(0x9888), 0x0a633400 },
	{ _MMIO(0x9888), 0x044e8000 },
	{ _MMIO(0x9888), 0x064e8000 },
	{ _MMIO(0x9888), 0x084e8000 },
	{ _MMIO(0x9888), 0x0a4e8000 },
	{ _MMIO(0x9888), 0x0c4e8000 },
	{ _MMIO(0x9888), 0x026c3321 },
	{ _MMIO(0x9888), 0x046c342f },
	{ _MMIO(0x9888), 0x106c0000 },
	{ _MMIO(0x9888), 0x1a6c2000 },
	{ _MMIO(0x9888), 0x021bc000 },
	{ _MMIO(0x9888), 0x041bc000 },
	{ _MMIO(0x9888), 0x061b4000 },
	{ _MMIO(0x9888), 0x141c8000 },
	{ _MMIO(0x9888), 0x161c8000 },
	{ _MMIO(0x9888), 0x181c8000 },
	{ _MMIO(0x9888), 0x1a1c1800 },
	{ _MMIO(0x9888), 0x06604000 },
	{ _MMIO(0x9888), 0x0c630044 },
	{ _MMIO(0x9888), 0x10630000 },
	{ _MMIO(0x9888), 0x06630000 },
	{ _MMIO(0x9888), 0x084c8000 },
	{ _MMIO(0x9888), 0x0a4c00aa },
	{ _MMIO(0x9888), 0x020da000 },
	{ _MMIO(0x9888), 0x040da000 },
	{ _MMIO(0x9888), 0x060d2000 },
	{ _MMIO(0x9888), 0x0c0f4000 },
	{ _MMIO(0x9888), 0x0e0f0055 },
	{ _MMIO(0x9888), 0x042c8000 },
	{ _MMIO(0x9888), 0x062c8000 },
	{ _MMIO(0x9888), 0x082c8000 },
	{ _MMIO(0x9888), 0x0a2c8000 },
	{ _MMIO(0x9888), 0x0c2c8000 },
	{ _MMIO(0x9888), 0x1190f800 },
	{ _MMIO(0x9888), 0x37900000 },
	{ _MMIO(0x9888), 0x51900000 },
	{ _MMIO(0x9888), 0x43900842 },
	{ _MMIO(0x9888), 0x53900000 },
	{ _MMIO(0x9888), 0x45900002 },
	{ _MMIO(0x9888), 0x33900000 },
};

static int
get_l3_3_mux_config(struct drm_i915_private *dev_priv,
		    const struct i915_oa_reg **regs,
		    int *lens)
{
	int n = 0;

	BUILD_BUG_ON(ARRAY_SIZE(dev_priv->perf.oa.mux_regs) < 1);
	BUILD_BUG_ON(ARRAY_SIZE(dev_priv->perf.oa.mux_regs_lens) < 1);

	regs[n] = mux_config_l3_3;
	lens[n] = ARRAY_SIZE(mux_config_l3_3);
	n++;

	return n;
}

static const struct i915_oa_reg b_counter_config_rasterizer_and_pixel_backend[] = {
	{ _MMIO(0x2740), 0x00000000 },
	{ _MMIO(0x2744), 0x00800000 },
	{ _MMIO(0x2710), 0x00000000 },
	{ _MMIO(0x2714), 0x30800000 },
	{ _MMIO(0x2720), 0x00000000 },
	{ _MMIO(0x2724), 0x00800000 },
	{ _MMIO(0x2770), 0x00000002 },
	{ _MMIO(0x2774), 0x0000efff },
	{ _MMIO(0x2778), 0x00006000 },
	{ _MMIO(0x277c), 0x0000f3ff },
};

static const struct i915_oa_reg flex_eu_config_rasterizer_and_pixel_backend[] = {
	{ _MMIO(0xe458), 0x00005004 },
	{ _MMIO(0xe558), 0x00010003 },
	{ _MMIO(0xe658), 0x00012011 },
	{ _MMIO(0xe758), 0x00015014 },
	{ _MMIO(0xe45c), 0x00051050 },
	{ _MMIO(0xe55c), 0x00053052 },
	{ _MMIO(0xe65c), 0x00055054 },
};

static const struct i915_oa_reg mux_config_rasterizer_and_pixel_backend[] = {
	{ _MMIO(0x9888), 0x102f3800 },
	{ _MMIO(0x9888), 0x144d0500 },
	{ _MMIO(0x9888), 0x120d03c0 },
	{ _MMIO(0x9888), 0x140d03cf },
	{ _MMIO(0x9888), 0x0c0f0004 },
	{ _MMIO(0x9888), 0x0c4e4000 },
	{ _MMIO(0x9888), 0x042f0480 },
	{ _MMIO(0x9888), 0x082f0000 },
	{ _MMIO(0x9888), 0x022f0000 },
	{ _MMIO(0x9888), 0x0a4c0090 },
	{ _MMIO(0x9888), 0x064d0027 },
	{ _MMIO(0x9888), 0x004d0000 },
	{ _MMIO(0x9888), 0x000d0d40 },
	{ _MMIO(0x9888), 0x020d803f },
	{ _MMIO(0x9888), 0x040d8023 },
	{ _MMIO(0x9888), 0x100d0000 },
	{ _MMIO(0x9888), 0x060d2000 },
	{ _MMIO(0x9888), 0x020f0010 },
	{ _MMIO(0x9888), 0x000f0000 },
	{ _MMIO(0x9888), 0x0e0f0050 },
	{ _MMIO(0x9888), 0x0a2c8000 },
	{ _MMIO(0x9888), 0x0c2c8000 },
	{ _MMIO(0x9888), 0x1190fc00 },
	{ _MMIO(0x9888), 0x37900000 },
	{ _MMIO(0x9888), 0x51900000 },
	{ _MMIO(0x9888), 0x41901400 },
	{ _MMIO(0x9888), 0x43901485 },
	{ _MMIO(0x9888), 0x53900000 },
	{ _MMIO(0x9888), 0x45900001 },
	{ _MMIO(0x9888), 0x33900000 },
};

static int
get_rasterizer_and_pixel_backend_mux_config(struct drm_i915_private *dev_priv,
					    const struct i915_oa_reg **regs,
					    int *lens)
{
	int n = 0;

	BUILD_BUG_ON(ARRAY_SIZE(dev_priv->perf.oa.mux_regs) < 1);
	BUILD_BUG_ON(ARRAY_SIZE(dev_priv->perf.oa.mux_regs_lens) < 1);

	regs[n] = mux_config_rasterizer_and_pixel_backend;
	lens[n] = ARRAY_SIZE(mux_config_rasterizer_and_pixel_backend);
	n++;

	return n;
}

static const struct i915_oa_reg b_counter_config_sampler[] = {
	{ _MMIO(0x2740), 0x00000000 },
	{ _MMIO(0x2744), 0x00800000 },
	{ _MMIO(0x2710), 0x00000000 },
	{ _MMIO(0x2714), 0x70800000 },
	{ _MMIO(0x2720), 0x00000000 },
	{ _MMIO(0x2724), 0x00800000 },
	{ _MMIO(0x2770), 0x0000c000 },
	{ _MMIO(0x2774), 0x0000e7ff },
	{ _MMIO(0x2778), 0x00003000 },
	{ _MMIO(0x277c), 0x0000f9ff },
	{ _MMIO(0x2780), 0x00000c00 },
	{ _MMIO(0x2784), 0x0000fe7f },
};

static const struct i915_oa_reg flex_eu_config_sampler[] = {
	{ _MMIO(0xe458), 0x00005004 },
	{ _MMIO(0xe558), 0x00010003 },
	{ _MMIO(0xe658), 0x00012011 },
	{ _MMIO(0xe758), 0x00015014 },
	{ _MMIO(0xe45c), 0x00051050 },
	{ _MMIO(0xe55c), 0x00053052 },
	{ _MMIO(0xe65c), 0x00055054 },
};

static const struct i915_oa_reg mux_config_sampler[] = {
	{ _MMIO(0x9888), 0x14152c00 },
	{ _MMIO(0x9888), 0x16150005 },
	{ _MMIO(0x9888), 0x121600a0 },
	{ _MMIO(0x9888), 0x14352c00 },
	{ _MMIO(0x9888), 0x16350005 },
	{ _MMIO(0x9888), 0x123600a0 },
	{ _MMIO(0x9888), 0x14552c00 },
	{ _MMIO(0x9888), 0x16550005 },
	{ _MMIO(0x9888), 0x125600a0 },
	{ _MMIO(0x9888), 0x062f6000 },
	{ _MMIO(0x9888), 0x022f2000 },
	{ _MMIO(0x9888), 0x0c4c0050 },
	{ _MMIO(0x9888), 0x0a4c0010 },
	{ _MMIO(0x9888), 0x0c0d8000 },
	{ _MMIO(0x9888), 0x0e0da000 },
	{ _MMIO(0x9888), 0x000d8000 },
	{ _MMIO(0x9888), 0x020da000 },
	{ _MMIO(0x9888), 0x040da000 },
	{ _MMIO(0x9888), 0x060d2000 },
	{ _MMIO(0x9888), 0x100f0350 },
	{ _MMIO(0x9888), 0x0c0fb000 },
	{ _MMIO(0x9888), 0x0e0f00da },
	{ _MMIO(0x9888), 0x182c0028 },
	{ _MMIO(0x9888), 0x0a2c8000 },
	{ _MMIO(0x9888), 0x022dc000 },
	{ _MMIO(0x9888), 0x042d4000 },
	{ _MMIO(0x9888), 0x0c138000 },
	{ _MMIO(0x9888), 0x0e132000 },
	{ _MMIO(0x9888), 0x0413c000 },
	{ _MMIO(0x9888), 0x1c140018 },
	{ _MMIO(0x9888), 0x0c157000 },
	{ _MMIO(0x9888), 0x0e150078 },
	{ _MMIO(0x9888), 0x10150000 },
	{ _MMIO(0x9888), 0x04162180 },
	{ _MMIO(0x9888), 0x02160000 },
	{ _MMIO(0x9888), 0x04174000 },
	{ _MMIO(0x9888), 0x0233a000 },
	{ _MMIO(0x9888), 0x04333000 },
	{ _MMIO(0x9888), 0x14348000 },
	{ _MMIO(0x9888), 0x16348000 },
	{ _MMIO(0x9888), 0x02357870 },
	{ _MMIO(0x9888), 0x10350000 },
	{ _MMIO(0x9888), 0x04360043 },
	{ _MMIO(0x9888), 0x02360000 },
	{ _MMIO(0x9888), 0x04371000 },
	{ _MMIO(0x9888), 0x0e538000 },
	{ _MMIO(0x9888), 0x00538000 },
	{ _MMIO(0x9888), 0x06533000 },
	{ _MMIO(0x9888), 0x1c540020 },
	{ _MMIO(0x9888), 0x12548000 },
	{ _MMIO(0x9888), 0x0e557000 },
	{ _MMIO(0x9888), 0x00557800 },
	{ _MMIO(0x9888), 0x10550000 },
	{ _MMIO(0x9888), 0x06560043 },
	{ _MMIO(0x9888), 0x02560000 },
	{ _MMIO(0x9888), 0x06571000 },
	{ _MMIO(0x9888), 0x1190ff80 },
	{ _MMIO(0x9888), 0x57900000 },
	{ _MMIO(0x9888), 0x49900000 },
	{ _MMIO(0x9888), 0x37900000 },
	{ _MMIO(0x9888), 0x33900000 },
	{ _MMIO(0x9888), 0x4b900060 },
	{ _MMIO(0x9888), 0x59900000 },
	{ _MMIO(0x9888), 0x51900000 },
	{ _MMIO(0x9888), 0x41900c00 },
	{ _MMIO(0x9888), 0x43900842 },
	{ _MMIO(0x9888), 0x53900000 },
	{ _MMIO(0x9888), 0x45900060 },
};

static int
get_sampler_mux_config(struct drm_i915_private *dev_priv,
		       const struct i915_oa_reg **regs,
		       int *lens)
{
	int n = 0;

	BUILD_BUG_ON(ARRAY_SIZE(dev_priv->perf.oa.mux_regs) < 1);
	BUILD_BUG_ON(ARRAY_SIZE(dev_priv->perf.oa.mux_regs_lens) < 1);

	regs[n] = mux_config_sampler;
	lens[n] = ARRAY_SIZE(mux_config_sampler);
	n++;

	return n;
}

static const struct i915_oa_reg b_counter_config_tdl_1[] = {
	{ _MMIO(0x2740), 0x00000000 },
	{ _MMIO(0x2744), 0x00800000 },
	{ _MMIO(0x2710), 0x00000000 },
	{ _MMIO(0x2714), 0xf0800000 },
	{ _MMIO(0x2720), 0x00000000 },
	{ _MMIO(0x2724), 0x30800000 },
	{ _MMIO(0x2770), 0x00000002 },
	{ _MMIO(0x2774), 0x00007fff },
	{ _MMIO(0x2778), 0x00000000 },
	{ _MMIO(0x277c), 0x00009fff },
	{ _MMIO(0x2780), 0x00000002 },
	{ _MMIO(0x2784), 0x0000efff },
	{ _MMIO(0x2788), 0x00000000 },
	{ _MMIO(0x278c), 0x0000f3ff },
	{ _MMIO(0x2790), 0x00000002 },
	{ _MMIO(0x2794), 0x0000fdff },
	{ _MMIO(0x2798), 0x00000000 },
	{ _MMIO(0x279c), 0x0000fe7f },
};

static const struct i915_oa_reg flex_eu_config_tdl_1[] = {
	{ _MMIO(0xe458), 0x00005004 },
	{ _MMIO(0xe558), 0x00010003 },
	{ _MMIO(0xe658), 0x00012011 },
	{ _MMIO(0xe758), 0x00015014 },
	{ _MMIO(0xe45c), 0x00051050 },
	{ _MMIO(0xe55c), 0x00053052 },
	{ _MMIO(0xe65c), 0x00055054 },
};

static const struct i915_oa_reg mux_config_tdl_1[] = {
	{ _MMIO(0x9888), 0x12120000 },
	{ _MMIO(0x9888), 0x12320000 },
	{ _MMIO(0x9888), 0x12520000 },
	{ _MMIO(0x9888), 0x002f8000 },
	{ _MMIO(0x9888), 0x022f3000 },
	{ _MMIO(0x9888), 0x0a4c0015 },
	{ _MMIO(0x9888), 0x0c0d8000 },
	{ _MMIO(0x9888), 0x0e0da000 },
	{ _MMIO(0x9888), 0x000d8000 },
	{ _MMIO(0x9888), 0x020da000 },
	{ _MMIO(0x9888), 0x040da000 },
	{ _MMIO(0x9888), 0x060d2000 },
	{ _MMIO(0x9888), 0x100f03a0 },
	{ _MMIO(0x9888), 0x0c0ff000 },
	{ _MMIO(0x9888), 0x0e0f0095 },
	{ _MMIO(0x9888), 0x062c8000 },
	{ _MMIO(0x9888), 0x082c8000 },
	{ _MMIO(0x9888), 0x0a2c8000 },
	{ _MMIO(0x9888), 0x0c2d8000 },
	{ _MMIO(0x9888), 0x0e2d4000 },
	{ _MMIO(0x9888), 0x062d4000 },
	{ _MMIO(0x9888), 0x02108000 },
	{ _MMIO(0x9888), 0x0410c000 },
	{ _MMIO(0x9888), 0x02118000 },
	{ _MMIO(0x9888), 0x0411c000 },
	{ _MMIO(0x9888), 0x02121880 },
	{ _MMIO(0x9888), 0x041219b5 },
	{ _MMIO(0x9888), 0x00120000 },
	{ _MMIO(0x9888), 0x02134000 },
	{ _MMIO(0x9888), 0x04135000 },
	{ _MMIO(0x9888), 0x0c308000 },
	{ _MMIO(0x9888), 0x0e304000 },
	{ _MMIO(0x9888), 0x06304000 },
	{ _MMIO(0x9888), 0x0c318000 },
	{ _MMIO(0x9888), 0x0e314000 },
	{ _MMIO(0x9888), 0x06314000 },
	{ _MMIO(0x9888), 0x0c321a80 },
	{ _MMIO(0x9888), 0x0e320033 },
	{ _MMIO(0x9888), 0x06320031 },
	{ _MMIO(0x9888), 0x00320000 },
	{ _MMIO(0x9888), 0x0c334000 },
	{ _MMIO(0x9888), 0x0e331000 },
	{ _MMIO(0x9888), 0x06331000 },
	{ _MMIO(0x9888), 0x0e508000 },
	{ _MMIO(0x9888), 0x00508000 },
	{ _MMIO(0x9888), 0x02504000 },
	{ _MMIO(0x9888), 0x0e518000 },
	{ _MMIO(0x9888), 0x00518000 },
	{ _MMIO(0x9888), 0x02514000 },
	{ _MMIO(0x9888), 0x0e521880 },
	{ _MMIO(0x9888), 0x00521a80 },
	{ _MMIO(0x9888), 0x02520033 },
	{ _MMIO(0x9888), 0x0e534000 },
	{ _MMIO(0x9888), 0x00534000 },
	{ _MMIO(0x9888), 0x02531000 },
	{ _MMIO(0x9888), 0x1190ff80 },
	{ _MMIO(0x9888), 0x57900000 },
	{ _MMIO(0x9888), 0x49900800 },
	{ _MMIO(0x9888), 0x37900000 },
	{ _MMIO(0x9888), 0x33900000 },
	{ _MMIO(0x9888), 0x4b900062 },
	{ _MMIO(0x9888), 0x59900000 },
	{ _MMIO(0x9888), 0x51900000 },
	{ _MMIO(0x9888), 0x41900c00 },
	{ _MMIO(0x9888), 0x43900003 },
	{ _MMIO(0x9888), 0x53900000 },
	{ _MMIO(0x9888), 0x45900040 },
};

static int
get_tdl_1_mux_config(struct drm_i915_private *dev_priv,
		     const struct i915_oa_reg **regs,
		     int *lens)
{
	int n = 0;

	BUILD_BUG_ON(ARRAY_SIZE(dev_priv->perf.oa.mux_regs) < 1);
	BUILD_BUG_ON(ARRAY_SIZE(dev_priv->perf.oa.mux_regs_lens) < 1);

	regs[n] = mux_config_tdl_1;
	lens[n] = ARRAY_SIZE(mux_config_tdl_1);
	n++;

	return n;
}

static const struct i915_oa_reg b_counter_config_tdl_2[] = {
	{ _MMIO(0x2740), 0x00000000 },
	{ _MMIO(0x2744), 0x00800000 },
	{ _MMIO(0x2710), 0x00000000 },
	{ _MMIO(0x2714), 0x00800000 },
	{ _MMIO(0x2720), 0x00000000 },
	{ _MMIO(0x2724), 0x00800000 },
};

static const struct i915_oa_reg flex_eu_config_tdl_2[] = {
	{ _MMIO(0xe458), 0x00005004 },
	{ _MMIO(0xe558), 0x00010003 },
	{ _MMIO(0xe658), 0x00012011 },
	{ _MMIO(0xe758), 0x00015014 },
	{ _MMIO(0xe45c), 0x00051050 },
	{ _MMIO(0xe55c), 0x00053052 },
	{ _MMIO(0xe65c), 0x00055054 },
};

static const struct i915_oa_reg mux_config_tdl_2[] = {
	{ _MMIO(0x9888), 0x12124d60 },
	{ _MMIO(0x9888), 0x12322e60 },
	{ _MMIO(0x9888), 0x12524d60 },
	{ _MMIO(0x9888), 0x022f3000 },
	{ _MMIO(0x9888), 0x0a4c0014 },
	{ _MMIO(0x9888), 0x000d8000 },
	{ _MMIO(0x9888), 0x020da000 },
	{ _MMIO(0x9888), 0x040da000 },
	{ _MMIO(0x9888), 0x060d2000 },
	{ _MMIO(0x9888), 0x0c0fe000 },
	{ _MMIO(0x9888), 0x0e0f0097 },
	{ _MMIO(0x9888), 0x082c8000 },
	{ _MMIO(0x9888), 0x0a2c8000 },
	{ _MMIO(0x9888), 0x002d8000 },
	{ _MMIO(0x9888), 0x062d4000 },
	{ _MMIO(0x9888), 0x0410c000 },
	{ _MMIO(0x9888), 0x0411c000 },
	{ _MMIO(0x9888), 0x04121fb7 },
	{ _MMIO(0x9888), 0x00120000 },
	{ _MMIO(0x9888), 0x04135000 },
	{ _MMIO(0x9888), 0x00308000 },
	{ _MMIO(0x9888), 0x06304000 },
	{ _MMIO(0x9888), 0x00318000 },
	{ _MMIO(0x9888), 0x06314000 },
	{ _MMIO(0x9888), 0x00321b80 },
	{ _MMIO(0x9888), 0x0632003f },
	{ _MMIO(0x9888), 0x00334000 },
	{ _MMIO(0x9888), 0x06331000 },
	{ _MMIO(0x9888), 0x0250c000 },
	{ _MMIO(0x9888), 0x0251c000 },
	{ _MMIO(0x9888), 0x02521fb7 },
	{ _MMIO(0x9888), 0x00520000 },
	{ _MMIO(0x9888), 0x02535000 },
	{ _MMIO(0x9888), 0x1190fc00 },
	{ _MMIO(0x9888), 0x37900000 },
	{ _MMIO(0x9888), 0x51900000 },
	{ _MMIO(0x9888), 0x41900800 },
	{ _MMIO(0x9888), 0x43900063 },
	{ _MMIO(0x9888), 0x53900000 },
	{ _MMIO(0x9888), 0x45900040 },
	{ _MMIO(0x9888), 0x33900000 },
};

static int
get_tdl_2_mux_config(struct drm_i915_private *dev_priv,
		     const struct i915_oa_reg **regs,
		     int *lens)
{
	int n = 0;

	BUILD_BUG_ON(ARRAY_SIZE(dev_priv->perf.oa.mux_regs) < 1);
	BUILD_BUG_ON(ARRAY_SIZE(dev_priv->perf.oa.mux_regs_lens) < 1);

	regs[n] = mux_config_tdl_2;
	lens[n] = ARRAY_SIZE(mux_config_tdl_2);
	n++;

	return n;
}

static const struct i915_oa_reg b_counter_config_compute_extra[] = {
};

static const struct i915_oa_reg flex_eu_config_compute_extra[] = {
};

static const struct i915_oa_reg mux_config_compute_extra[] = {
	{ _MMIO(0x9888), 0x121203e0 },
	{ _MMIO(0x9888), 0x123203e0 },
	{ _MMIO(0x9888), 0x125203e0 },
	{ _MMIO(0x9888), 0x129203e0 },
	{ _MMIO(0x9888), 0x12b203e0 },
	{ _MMIO(0x9888), 0x12d203e0 },
	{ _MMIO(0x9888), 0x131203e0 },
	{ _MMIO(0x9888), 0x133203e0 },
	{ _MMIO(0x9888), 0x135203e0 },
	{ _MMIO(0x9888), 0x1a4ef000 },
	{ _MMIO(0x9888), 0x1c4e0003 },
	{ _MMIO(0x9888), 0x024ec000 },
	{ _MMIO(0x9888), 0x044ec000 },
	{ _MMIO(0x9888), 0x064ec000 },
	{ _MMIO(0x9888), 0x022f4000 },
	{ _MMIO(0x9888), 0x0c4c02a0 },
	{ _MMIO(0x9888), 0x084ca000 },
	{ _MMIO(0x9888), 0x0a4c0042 },
	{ _MMIO(0x9888), 0x0c0d8000 },
	{ _MMIO(0x9888), 0x0e0da000 },
	{ _MMIO(0x9888), 0x000d8000 },
	{ _MMIO(0x9888), 0x020da000 },
	{ _MMIO(0x9888), 0x040da000 },
	{ _MMIO(0x9888), 0x060d2000 },
	{ _MMIO(0x9888), 0x100f0150 },
	{ _MMIO(0x9888), 0x0c0f5000 },
	{ _MMIO(0x9888), 0x0e0f006d },
	{ _MMIO(0x9888), 0x182c00a8 },
	{ _MMIO(0x9888), 0x022c8000 },
	{ _MMIO(0x9888), 0x042c8000 },
	{ _MMIO(0x9888), 0x062c8000 },
	{ _MMIO(0x9888), 0x0c2c8000 },
	{ _MMIO(0x9888), 0x042d8000 },
	{ _MMIO(0x9888), 0x06104000 },
	{ _MMIO(0x9888), 0x06114000 },
	{ _MMIO(0x9888), 0x06120033 },
	{ _MMIO(0x9888), 0x00120000 },
	{ _MMIO(0x9888), 0x06131000 },
	{ _MMIO(0x9888), 0x04308000 },
	{ _MMIO(0x9888), 0x04318000 },
	{ _MMIO(0x9888), 0x04321980 },
	{ _MMIO(0x9888), 0x00320000 },
	{ _MMIO(0x9888), 0x04334000 },
	{ _MMIO(0x9888), 0x04504000 },
	{ _MMIO(0x9888), 0x04514000 },
	{ _MMIO(0x9888), 0x04520033 },
	{ _MMIO(0x9888), 0x00520000 },
	{ _MMIO(0x9888), 0x04531000 },
	{ _MMIO(0x9888), 0x1acef000 },
	{ _MMIO(0x9888), 0x1cce0003 },
	{ _MMIO(0x9888), 0x00af8000 },
	{ _MMIO(0x9888), 0x0ccc02a0 },
	{ _MMIO(0x9888), 0x0acc0001 },
	{ _MMIO(0x9888), 0x0c8d8000 },
	{ _MMIO(0x9888), 0x0e8da000 },
	{ _MMIO(0x9888), 0x008d8000 },
	{ _MMIO(0x9888), 0x028da000 },
	{ _MMIO(0x9888), 0x108f0150 },
	{ _MMIO(0x9888), 0x0c8fb000 },
	{ _MMIO(0x9888), 0x0e8f0001 },
	{ _MMIO(0x9888), 0x18ac00a8 },
	{ _MMIO(0x9888), 0x06ac8000 },
	{ _MMIO(0x9888), 0x02ad4000 },
	{ _MMIO(0x9888), 0x02908000 },
	{ _MMIO(0x9888), 0x02918000 },
	{ _MMIO(0x9888), 0x02921980 },
	{ _MMIO(0x9888), 0x00920000 },
	{ _MMIO(0x9888), 0x02934000 },
	{ _MMIO(0x9888), 0x02b04000 },
	{ _MMIO(0x9888), 0x02b14000 },
	{ _MMIO(0x9888), 0x02b20033 },
	{ _MMIO(0x9888), 0x00b20000 },
	{ _MMIO(0x9888), 0x02b31000 },
	{ _MMIO(0x9888), 0x00d08000 },
	{ _MMIO(0x9888), 0x00d18000 },
	{ _MMIO(0x9888), 0x00d21980 },
	{ _MMIO(0x9888), 0x00d34000 },
	{ _MMIO(0x9888), 0x072f8000 },
	{ _MMIO(0x9888), 0x0d4c0100 },
	{ _MMIO(0x9888), 0x0d0d8000 },
	{ _MMIO(0x9888), 0x0f0da000 },
	{ _MMIO(0x9888), 0x110f01b0 },
	{ _MMIO(0x9888), 0x192c0080 },
	{ _MMIO(0x9888), 0x0f2d4000 },
	{ _MMIO(0x9888), 0x0f108000 },
	{ _MMIO(0x9888), 0x0f118000 },
	{ _MMIO(0x9888), 0x0f121980 },
	{ _MMIO(0x9888), 0x01120000 },
	{ _MMIO(0x9888), 0x0f134000 },
	{ _MMIO(0x9888), 0x0f304000 },
	{ _MMIO(0x9888), 0x0f314000 },
	{ _MMIO(0x9888), 0x0f320033 },
	{ _MMIO(0x9888), 0x01320000 },
	{ _MMIO(0x9888), 0x0f331000 },
	{ _MMIO(0x9888), 0x0d508000 },
	{ _MMIO(0x9888), 0x0d518000 },
	{ _MMIO(0x9888), 0x0d521980 },
	{ _MMIO(0x9888), 0x01520000 },
	{ _MMIO(0x9888), 0x0d534000 },
	{ _MMIO(0x9888), 0x1190ff80 },
	{ _MMIO(0x9888), 0x57900000 },
	{ _MMIO(0x9888), 0x49900c00 },
	{ _MMIO(0x9888), 0x37900000 },
	{ _MMIO(0x9888), 0x33900000 },
	{ _MMIO(0x9888), 0x4b900002 },
	{ _MMIO(0x9888), 0x59900000 },
	{ _MMIO(0x9888), 0x51901100 },
	{ _MMIO(0x9888), 0x41901000 },
	{ _MMIO(0x9888), 0x43901423 },
	{ _MMIO(0x9888), 0x53903331 },
	{ _MMIO(0x9888), 0x45900044 },
};

static int
get_compute_extra_mux_config(struct drm_i915_private *dev_priv,
			     const struct i915_oa_reg **regs,
			     int *lens)
{
	int n = 0;

	BUILD_BUG_ON(ARRAY_SIZE(dev_priv->perf.oa.mux_regs) < 1);
	BUILD_BUG_ON(ARRAY_SIZE(dev_priv->perf.oa.mux_regs_lens) < 1);

	regs[n] = mux_config_compute_extra;
	lens[n] = ARRAY_SIZE(mux_config_compute_extra);
	n++;

	return n;
}

static const struct i915_oa_reg b_counter_config_vme_pipe[] = {
	{ _MMIO(0x2740), 0x00000000 },
	{ _MMIO(0x2710), 0x00000000 },
	{ _MMIO(0x2714), 0xf0800000 },
	{ _MMIO(0x2720), 0x00000000 },
	{ _MMIO(0x2724), 0x30800000 },
	{ _MMIO(0x2770), 0x00100030 },
	{ _MMIO(0x2774), 0x0000fff9 },
	{ _MMIO(0x2778), 0x00000002 },
	{ _MMIO(0x277c), 0x0000fffc },
	{ _MMIO(0x2780), 0x00000002 },
	{ _MMIO(0x2784), 0x0000fff3 },
	{ _MMIO(0x2788), 0x00100180 },
	{ _MMIO(0x278c), 0x0000ffcf },
	{ _MMIO(0x2790), 0x00000002 },
	{ _MMIO(0x2794), 0x0000ffcf },
	{ _MMIO(0x2798), 0x00000002 },
	{ _MMIO(0x279c), 0x0000ff3f },
};

static const struct i915_oa_reg flex_eu_config_vme_pipe[] = {
	{ _MMIO(0xe458), 0x00005004 },
	{ _MMIO(0xe558), 0x00008003 },
};

static const struct i915_oa_reg mux_config_vme_pipe[] = {
	{ _MMIO(0x9888), 0x141a5800 },
	{ _MMIO(0x9888), 0x161a00c0 },
	{ _MMIO(0x9888), 0x12180240 },
	{ _MMIO(0x9888), 0x14180002 },
	{ _MMIO(0x9888), 0x149a5800 },
	{ _MMIO(0x9888), 0x169a00c0 },
	{ _MMIO(0x9888), 0x12980240 },
	{ _MMIO(0x9888), 0x14980002 },
	{ _MMIO(0x9888), 0x1a4e3fc0 },
	{ _MMIO(0x9888), 0x002f1000 },
	{ _MMIO(0x9888), 0x022f8000 },
	{ _MMIO(0x9888), 0x042f3000 },
	{ _MMIO(0x9888), 0x004c4000 },
	{ _MMIO(0x9888), 0x0a4c9500 },
	{ _MMIO(0x9888), 0x0c4c002a },
	{ _MMIO(0x9888), 0x000d2000 },
	{ _MMIO(0x9888), 0x060d8000 },
	{ _MMIO(0x9888), 0x080da000 },
	{ _MMIO(0x9888), 0x0a0da000 },
	{ _MMIO(0x9888), 0x0c0da000 },
	{ _MMIO(0x9888), 0x0c0f0400 },
	{ _MMIO(0x9888), 0x0e0f5500 },
	{ _MMIO(0x9888), 0x100f0015 },
	{ _MMIO(0x9888), 0x002c8000 },
	{ _MMIO(0x9888), 0x0e2c8000 },
	{ _MMIO(0x9888), 0x162caa00 },
	{ _MMIO(0x9888), 0x182c000a },
	{ _MMIO(0x9888), 0x04193000 },
	{ _MMIO(0x9888), 0x081a28c1 },
	{ _MMIO(0x9888), 0x001a0000 },
	{ _MMIO(0x9888), 0x00133000 },
	{ _MMIO(0x9888), 0x0613c000 },
	{ _MMIO(0x9888), 0x0813f000 },
	{ _MMIO(0x9888), 0x00172000 },
	{ _MMIO(0x9888), 0x06178000 },
	{ _MMIO(0x9888), 0x0817a000 },
	{ _MMIO(0x9888), 0x00180037 },
	{ _MMIO(0x9888), 0x06180940 },
	{ _MMIO(0x9888), 0x08180000 },
	{ _MMIO(0x9888), 0x02180000 },
	{ _MMIO(0x9888), 0x04183000 },
	{ _MMIO(0x9888), 0x04afc000 },
	{ _MMIO(0x9888), 0x06af3000 },
	{ _MMIO(0x9888), 0x0acc4000 },
	{ _MMIO(0x9888), 0x0ccc0015 },
	{ _MMIO(0x9888), 0x0a8da000 },
	{ _MMIO(0x9888), 0x0c8da000 },
	{ _MMIO(0x9888), 0x0e8f4000 },
	{ _MMIO(0x9888), 0x108f0015 },
	{ _MMIO(0x9888), 0x16aca000 },
	{ _MMIO(0x9888), 0x18ac000a },
	{ _MMIO(0x9888), 0x06993000 },
	{ _MMIO(0x9888), 0x0c9a28c1 },
	{ _MMIO(0x9888), 0x009a0000 },
	{ _MMIO(0x9888), 0x0a93f000 },
	{ _MMIO(0x9888), 0x0c93f000 },
	{ _MMIO(0x9888), 0x0a97a000 },
	{ _MMIO(0x9888), 0x0c97a000 },
	{ _MMIO(0x9888), 0x0a980977 },
	{ _MMIO(0x9888), 0x08980000 },
	{ _MMIO(0x9888), 0x04980000 },
	{ _MMIO(0x9888), 0x06983000 },
	{ _MMIO(0x9888), 0x119000ff },
	{ _MMIO(0x9888), 0x51900010 },
	{ _MMIO(0x9888), 0x41900060 },
	{ _MMIO(0x9888), 0x55900111 },
	{ _MMIO(0x9888), 0x45900c00 },
	{ _MMIO(0x9888), 0x47900821 },
	{ _MMIO(0x9888), 0x57900000 },
	{ _MMIO(0x9888), 0x49900002 },
	{ _MMIO(0x9888), 0x37900000 },
	{ _MMIO(0x9888), 0x33900000 },
};

static int
get_vme_pipe_mux_config(struct drm_i915_private *dev_priv,
			const struct i915_oa_reg **regs,
			int *lens)
{
	int n = 0;

	BUILD_BUG_ON(ARRAY_SIZE(dev_priv->perf.oa.mux_regs) < 1);
	BUILD_BUG_ON(ARRAY_SIZE(dev_priv->perf.oa.mux_regs_lens) < 1);

	regs[n] = mux_config_vme_pipe;
	lens[n] = ARRAY_SIZE(mux_config_vme_pipe);
	n++;

	return n;
}

static const struct i915_oa_reg b_counter_config_test_oa[] = {
	{ _MMIO(0x2740), 0x00000000 },
	{ _MMIO(0x2744), 0x00800000 },
	{ _MMIO(0x2714), 0xf0800000 },
	{ _MMIO(0x2710), 0x00000000 },
	{ _MMIO(0x2724), 0xf0800000 },
	{ _MMIO(0x2720), 0x00000000 },
	{ _MMIO(0x2770), 0x00000004 },
	{ _MMIO(0x2774), 0x00000000 },
	{ _MMIO(0x2778), 0x00000003 },
	{ _MMIO(0x277c), 0x00000000 },
	{ _MMIO(0x2780), 0x00000007 },
	{ _MMIO(0x2784), 0x00000000 },
	{ _MMIO(0x2788), 0x00100002 },
	{ _MMIO(0x278c), 0x0000fff7 },
	{ _MMIO(0x2790), 0x00100002 },
	{ _MMIO(0x2794), 0x0000ffcf },
	{ _MMIO(0x2798), 0x00100082 },
	{ _MMIO(0x279c), 0x0000ffef },
	{ _MMIO(0x27a0), 0x001000c2 },
	{ _MMIO(0x27a4), 0x0000ffe7 },
	{ _MMIO(0x27a8), 0x00100001 },
	{ _MMIO(0x27ac), 0x0000ffe7 },
};

static const struct i915_oa_reg flex_eu_config_test_oa[] = {
};

static const struct i915_oa_reg mux_config_test_oa[] = {
	{ _MMIO(0x9888), 0x11810000 },
	{ _MMIO(0x9888), 0x07810013 },
	{ _MMIO(0x9888), 0x1f810000 },
	{ _MMIO(0x9888), 0x1d810000 },
	{ _MMIO(0x9888), 0x1b930040 },
	{ _MMIO(0x9888), 0x07e54000 },
	{ _MMIO(0x9888), 0x1f908000 },
	{ _MMIO(0x9888), 0x11900000 },
	{ _MMIO(0x9888), 0x37900000 },
	{ _MMIO(0x9888), 0x53900000 },
	{ _MMIO(0x9888), 0x45900000 },
	{ _MMIO(0x9888), 0x33900000 },
};

static int
get_test_oa_mux_config(struct drm_i915_private *dev_priv,
		       const struct i915_oa_reg **regs,
		       int *lens)
{
	int n = 0;

	BUILD_BUG_ON(ARRAY_SIZE(dev_priv->perf.oa.mux_regs) < 1);
	BUILD_BUG_ON(ARRAY_SIZE(dev_priv->perf.oa.mux_regs_lens) < 1);

	regs[n] = mux_config_test_oa;
	lens[n] = ARRAY_SIZE(mux_config_test_oa);
	n++;

	return n;
}

int i915_oa_select_metric_set_sklgt4(struct drm_i915_private *dev_priv)
{
	dev_priv->perf.oa.n_mux_configs = 0;
	dev_priv->perf.oa.b_counter_regs = NULL;
	dev_priv->perf.oa.b_counter_regs_len = 0;
	dev_priv->perf.oa.flex_regs = NULL;
	dev_priv->perf.oa.flex_regs_len = 0;

	switch (dev_priv->perf.oa.metrics_set) {
	case METRIC_SET_ID_RENDER_BASIC:
		dev_priv->perf.oa.n_mux_configs =
			get_render_basic_mux_config(dev_priv,
						    dev_priv->perf.oa.mux_regs,
						    dev_priv->perf.oa.mux_regs_lens);
		if (dev_priv->perf.oa.n_mux_configs == 0) {
			DRM_DEBUG_DRIVER("No suitable MUX config for \"RENDER_BASIC\" metric set\n");

			/* EINVAL because *_register_sysfs already checked this
			 * and so it wouldn't have been advertised to userspace and
			 * so shouldn't have been requested
			 */
			return -EINVAL;
		}

		dev_priv->perf.oa.b_counter_regs =
			b_counter_config_render_basic;
		dev_priv->perf.oa.b_counter_regs_len =
			ARRAY_SIZE(b_counter_config_render_basic);

		dev_priv->perf.oa.flex_regs =
			flex_eu_config_render_basic;
		dev_priv->perf.oa.flex_regs_len =
			ARRAY_SIZE(flex_eu_config_render_basic);

		return 0;
	case METRIC_SET_ID_COMPUTE_BASIC:
		dev_priv->perf.oa.n_mux_configs =
			get_compute_basic_mux_config(dev_priv,
						     dev_priv->perf.oa.mux_regs,
						     dev_priv->perf.oa.mux_regs_lens);
		if (dev_priv->perf.oa.n_mux_configs == 0) {
			DRM_DEBUG_DRIVER("No suitable MUX config for \"COMPUTE_BASIC\" metric set\n");

			/* EINVAL because *_register_sysfs already checked this
			 * and so it wouldn't have been advertised to userspace and
			 * so shouldn't have been requested
			 */
			return -EINVAL;
		}

		dev_priv->perf.oa.b_counter_regs =
			b_counter_config_compute_basic;
		dev_priv->perf.oa.b_counter_regs_len =
			ARRAY_SIZE(b_counter_config_compute_basic);

		dev_priv->perf.oa.flex_regs =
			flex_eu_config_compute_basic;
		dev_priv->perf.oa.flex_regs_len =
			ARRAY_SIZE(flex_eu_config_compute_basic);

		return 0;
	case METRIC_SET_ID_RENDER_PIPE_PROFILE:
		dev_priv->perf.oa.n_mux_configs =
			get_render_pipe_profile_mux_config(dev_priv,
							   dev_priv->perf.oa.mux_regs,
							   dev_priv->perf.oa.mux_regs_lens);
		if (dev_priv->perf.oa.n_mux_configs == 0) {
			DRM_DEBUG_DRIVER("No suitable MUX config for \"RENDER_PIPE_PROFILE\" metric set\n");

			/* EINVAL because *_register_sysfs already checked this
			 * and so it wouldn't have been advertised to userspace and
			 * so shouldn't have been requested
			 */
			return -EINVAL;
		}

		dev_priv->perf.oa.b_counter_regs =
			b_counter_config_render_pipe_profile;
		dev_priv->perf.oa.b_counter_regs_len =
			ARRAY_SIZE(b_counter_config_render_pipe_profile);

		dev_priv->perf.oa.flex_regs =
			flex_eu_config_render_pipe_profile;
		dev_priv->perf.oa.flex_regs_len =
			ARRAY_SIZE(flex_eu_config_render_pipe_profile);

		return 0;
	case METRIC_SET_ID_MEMORY_READS:
		dev_priv->perf.oa.n_mux_configs =
			get_memory_reads_mux_config(dev_priv,
						    dev_priv->perf.oa.mux_regs,
						    dev_priv->perf.oa.mux_regs_lens);
		if (dev_priv->perf.oa.n_mux_configs == 0) {
			DRM_DEBUG_DRIVER("No suitable MUX config for \"MEMORY_READS\" metric set\n");

			/* EINVAL because *_register_sysfs already checked this
			 * and so it wouldn't have been advertised to userspace and
			 * so shouldn't have been requested
			 */
			return -EINVAL;
		}

		dev_priv->perf.oa.b_counter_regs =
			b_counter_config_memory_reads;
		dev_priv->perf.oa.b_counter_regs_len =
			ARRAY_SIZE(b_counter_config_memory_reads);

		dev_priv->perf.oa.flex_regs =
			flex_eu_config_memory_reads;
		dev_priv->perf.oa.flex_regs_len =
			ARRAY_SIZE(flex_eu_config_memory_reads);

		return 0;
	case METRIC_SET_ID_MEMORY_WRITES:
		dev_priv->perf.oa.n_mux_configs =
			get_memory_writes_mux_config(dev_priv,
						     dev_priv->perf.oa.mux_regs,
						     dev_priv->perf.oa.mux_regs_lens);
		if (dev_priv->perf.oa.n_mux_configs == 0) {
			DRM_DEBUG_DRIVER("No suitable MUX config for \"MEMORY_WRITES\" metric set\n");

			/* EINVAL because *_register_sysfs already checked this
			 * and so it wouldn't have been advertised to userspace and
			 * so shouldn't have been requested
			 */
			return -EINVAL;
		}

		dev_priv->perf.oa.b_counter_regs =
			b_counter_config_memory_writes;
		dev_priv->perf.oa.b_counter_regs_len =
			ARRAY_SIZE(b_counter_config_memory_writes);

		dev_priv->perf.oa.flex_regs =
			flex_eu_config_memory_writes;
		dev_priv->perf.oa.flex_regs_len =
			ARRAY_SIZE(flex_eu_config_memory_writes);

		return 0;
	case METRIC_SET_ID_COMPUTE_EXTENDED:
		dev_priv->perf.oa.n_mux_configs =
			get_compute_extended_mux_config(dev_priv,
							dev_priv->perf.oa.mux_regs,
							dev_priv->perf.oa.mux_regs_lens);
		if (dev_priv->perf.oa.n_mux_configs == 0) {
			DRM_DEBUG_DRIVER("No suitable MUX config for \"COMPUTE_EXTENDED\" metric set\n");

			/* EINVAL because *_register_sysfs already checked this
			 * and so it wouldn't have been advertised to userspace and
			 * so shouldn't have been requested
			 */
			return -EINVAL;
		}

		dev_priv->perf.oa.b_counter_regs =
			b_counter_config_compute_extended;
		dev_priv->perf.oa.b_counter_regs_len =
			ARRAY_SIZE(b_counter_config_compute_extended);

		dev_priv->perf.oa.flex_regs =
			flex_eu_config_compute_extended;
		dev_priv->perf.oa.flex_regs_len =
			ARRAY_SIZE(flex_eu_config_compute_extended);

		return 0;
	case METRIC_SET_ID_COMPUTE_L3_CACHE:
		dev_priv->perf.oa.n_mux_configs =
			get_compute_l3_cache_mux_config(dev_priv,
							dev_priv->perf.oa.mux_regs,
							dev_priv->perf.oa.mux_regs_lens);
		if (dev_priv->perf.oa.n_mux_configs == 0) {
			DRM_DEBUG_DRIVER("No suitable MUX config for \"COMPUTE_L3_CACHE\" metric set\n");

			/* EINVAL because *_register_sysfs already checked this
			 * and so it wouldn't have been advertised to userspace and
			 * so shouldn't have been requested
			 */
			return -EINVAL;
		}

		dev_priv->perf.oa.b_counter_regs =
			b_counter_config_compute_l3_cache;
		dev_priv->perf.oa.b_counter_regs_len =
			ARRAY_SIZE(b_counter_config_compute_l3_cache);

		dev_priv->perf.oa.flex_regs =
			flex_eu_config_compute_l3_cache;
		dev_priv->perf.oa.flex_regs_len =
			ARRAY_SIZE(flex_eu_config_compute_l3_cache);

		return 0;
	case METRIC_SET_ID_HDC_AND_SF:
		dev_priv->perf.oa.n_mux_configs =
			get_hdc_and_sf_mux_config(dev_priv,
						  dev_priv->perf.oa.mux_regs,
						  dev_priv->perf.oa.mux_regs_lens);
		if (dev_priv->perf.oa.n_mux_configs == 0) {
			DRM_DEBUG_DRIVER("No suitable MUX config for \"HDC_AND_SF\" metric set\n");

			/* EINVAL because *_register_sysfs already checked this
			 * and so it wouldn't have been advertised to userspace and
			 * so shouldn't have been requested
			 */
			return -EINVAL;
		}

		dev_priv->perf.oa.b_counter_regs =
			b_counter_config_hdc_and_sf;
		dev_priv->perf.oa.b_counter_regs_len =
			ARRAY_SIZE(b_counter_config_hdc_and_sf);

		dev_priv->perf.oa.flex_regs =
			flex_eu_config_hdc_and_sf;
		dev_priv->perf.oa.flex_regs_len =
			ARRAY_SIZE(flex_eu_config_hdc_and_sf);

		return 0;
	case METRIC_SET_ID_L3_1:
		dev_priv->perf.oa.n_mux_configs =
			get_l3_1_mux_config(dev_priv,
					    dev_priv->perf.oa.mux_regs,
					    dev_priv->perf.oa.mux_regs_lens);
		if (dev_priv->perf.oa.n_mux_configs == 0) {
			DRM_DEBUG_DRIVER("No suitable MUX config for \"L3_1\" metric set\n");

			/* EINVAL because *_register_sysfs already checked this
			 * and so it wouldn't have been advertised to userspace and
			 * so shouldn't have been requested
			 */
			return -EINVAL;
		}

		dev_priv->perf.oa.b_counter_regs =
			b_counter_config_l3_1;
		dev_priv->perf.oa.b_counter_regs_len =
			ARRAY_SIZE(b_counter_config_l3_1);

		dev_priv->perf.oa.flex_regs =
			flex_eu_config_l3_1;
		dev_priv->perf.oa.flex_regs_len =
			ARRAY_SIZE(flex_eu_config_l3_1);

		return 0;
	case METRIC_SET_ID_L3_2:
		dev_priv->perf.oa.n_mux_configs =
			get_l3_2_mux_config(dev_priv,
					    dev_priv->perf.oa.mux_regs,
					    dev_priv->perf.oa.mux_regs_lens);
		if (dev_priv->perf.oa.n_mux_configs == 0) {
			DRM_DEBUG_DRIVER("No suitable MUX config for \"L3_2\" metric set\n");

			/* EINVAL because *_register_sysfs already checked this
			 * and so it wouldn't have been advertised to userspace and
			 * so shouldn't have been requested
			 */
			return -EINVAL;
		}

		dev_priv->perf.oa.b_counter_regs =
			b_counter_config_l3_2;
		dev_priv->perf.oa.b_counter_regs_len =
			ARRAY_SIZE(b_counter_config_l3_2);

		dev_priv->perf.oa.flex_regs =
			flex_eu_config_l3_2;
		dev_priv->perf.oa.flex_regs_len =
			ARRAY_SIZE(flex_eu_config_l3_2);

		return 0;
	case METRIC_SET_ID_L3_3:
		dev_priv->perf.oa.n_mux_configs =
			get_l3_3_mux_config(dev_priv,
					    dev_priv->perf.oa.mux_regs,
					    dev_priv->perf.oa.mux_regs_lens);
		if (dev_priv->perf.oa.n_mux_configs == 0) {
			DRM_DEBUG_DRIVER("No suitable MUX config for \"L3_3\" metric set\n");

			/* EINVAL because *_register_sysfs already checked this
			 * and so it wouldn't have been advertised to userspace and
			 * so shouldn't have been requested
			 */
			return -EINVAL;
		}

		dev_priv->perf.oa.b_counter_regs =
			b_counter_config_l3_3;
		dev_priv->perf.oa.b_counter_regs_len =
			ARRAY_SIZE(b_counter_config_l3_3);

		dev_priv->perf.oa.flex_regs =
			flex_eu_config_l3_3;
		dev_priv->perf.oa.flex_regs_len =
			ARRAY_SIZE(flex_eu_config_l3_3);

		return 0;
	case METRIC_SET_ID_RASTERIZER_AND_PIXEL_BACKEND:
		dev_priv->perf.oa.n_mux_configs =
			get_rasterizer_and_pixel_backend_mux_config(dev_priv,
								    dev_priv->perf.oa.mux_regs,
								    dev_priv->perf.oa.mux_regs_lens);
		if (dev_priv->perf.oa.n_mux_configs == 0) {
			DRM_DEBUG_DRIVER("No suitable MUX config for \"RASTERIZER_AND_PIXEL_BACKEND\" metric set\n");

			/* EINVAL because *_register_sysfs already checked this
			 * and so it wouldn't have been advertised to userspace and
			 * so shouldn't have been requested
			 */
			return -EINVAL;
		}

		dev_priv->perf.oa.b_counter_regs =
			b_counter_config_rasterizer_and_pixel_backend;
		dev_priv->perf.oa.b_counter_regs_len =
			ARRAY_SIZE(b_counter_config_rasterizer_and_pixel_backend);

		dev_priv->perf.oa.flex_regs =
			flex_eu_config_rasterizer_and_pixel_backend;
		dev_priv->perf.oa.flex_regs_len =
			ARRAY_SIZE(flex_eu_config_rasterizer_and_pixel_backend);

		return 0;
	case METRIC_SET_ID_SAMPLER:
		dev_priv->perf.oa.n_mux_configs =
			get_sampler_mux_config(dev_priv,
					       dev_priv->perf.oa.mux_regs,
					       dev_priv->perf.oa.mux_regs_lens);
		if (dev_priv->perf.oa.n_mux_configs == 0) {
			DRM_DEBUG_DRIVER("No suitable MUX config for \"SAMPLER\" metric set\n");

			/* EINVAL because *_register_sysfs already checked this
			 * and so it wouldn't have been advertised to userspace and
			 * so shouldn't have been requested
			 */
			return -EINVAL;
		}

		dev_priv->perf.oa.b_counter_regs =
			b_counter_config_sampler;
		dev_priv->perf.oa.b_counter_regs_len =
			ARRAY_SIZE(b_counter_config_sampler);

		dev_priv->perf.oa.flex_regs =
			flex_eu_config_sampler;
		dev_priv->perf.oa.flex_regs_len =
			ARRAY_SIZE(flex_eu_config_sampler);

		return 0;
	case METRIC_SET_ID_TDL_1:
		dev_priv->perf.oa.n_mux_configs =
			get_tdl_1_mux_config(dev_priv,
					     dev_priv->perf.oa.mux_regs,
					     dev_priv->perf.oa.mux_regs_lens);
		if (dev_priv->perf.oa.n_mux_configs == 0) {
			DRM_DEBUG_DRIVER("No suitable MUX config for \"TDL_1\" metric set\n");

			/* EINVAL because *_register_sysfs already checked this
			 * and so it wouldn't have been advertised to userspace and
			 * so shouldn't have been requested
			 */
			return -EINVAL;
		}

		dev_priv->perf.oa.b_counter_regs =
			b_counter_config_tdl_1;
		dev_priv->perf.oa.b_counter_regs_len =
			ARRAY_SIZE(b_counter_config_tdl_1);

		dev_priv->perf.oa.flex_regs =
			flex_eu_config_tdl_1;
		dev_priv->perf.oa.flex_regs_len =
			ARRAY_SIZE(flex_eu_config_tdl_1);

		return 0;
	case METRIC_SET_ID_TDL_2:
		dev_priv->perf.oa.n_mux_configs =
			get_tdl_2_mux_config(dev_priv,
					     dev_priv->perf.oa.mux_regs,
					     dev_priv->perf.oa.mux_regs_lens);
		if (dev_priv->perf.oa.n_mux_configs == 0) {
			DRM_DEBUG_DRIVER("No suitable MUX config for \"TDL_2\" metric set\n");

			/* EINVAL because *_register_sysfs already checked this
			 * and so it wouldn't have been advertised to userspace and
			 * so shouldn't have been requested
			 */
			return -EINVAL;
		}

		dev_priv->perf.oa.b_counter_regs =
			b_counter_config_tdl_2;
		dev_priv->perf.oa.b_counter_regs_len =
			ARRAY_SIZE(b_counter_config_tdl_2);

		dev_priv->perf.oa.flex_regs =
			flex_eu_config_tdl_2;
		dev_priv->perf.oa.flex_regs_len =
			ARRAY_SIZE(flex_eu_config_tdl_2);

		return 0;
	case METRIC_SET_ID_COMPUTE_EXTRA:
		dev_priv->perf.oa.n_mux_configs =
			get_compute_extra_mux_config(dev_priv,
						     dev_priv->perf.oa.mux_regs,
						     dev_priv->perf.oa.mux_regs_lens);
		if (dev_priv->perf.oa.n_mux_configs == 0) {
			DRM_DEBUG_DRIVER("No suitable MUX config for \"COMPUTE_EXTRA\" metric set\n");

			/* EINVAL because *_register_sysfs already checked this
			 * and so it wouldn't have been advertised to userspace and
			 * so shouldn't have been requested
			 */
			return -EINVAL;
		}

		dev_priv->perf.oa.b_counter_regs =
			b_counter_config_compute_extra;
		dev_priv->perf.oa.b_counter_regs_len =
			ARRAY_SIZE(b_counter_config_compute_extra);

		dev_priv->perf.oa.flex_regs =
			flex_eu_config_compute_extra;
		dev_priv->perf.oa.flex_regs_len =
			ARRAY_SIZE(flex_eu_config_compute_extra);

		return 0;
	case METRIC_SET_ID_VME_PIPE:
		dev_priv->perf.oa.n_mux_configs =
			get_vme_pipe_mux_config(dev_priv,
						dev_priv->perf.oa.mux_regs,
						dev_priv->perf.oa.mux_regs_lens);
		if (dev_priv->perf.oa.n_mux_configs == 0) {
			DRM_DEBUG_DRIVER("No suitable MUX config for \"VME_PIPE\" metric set\n");

			/* EINVAL because *_register_sysfs already checked this
			 * and so it wouldn't have been advertised to userspace and
			 * so shouldn't have been requested
			 */
			return -EINVAL;
		}

		dev_priv->perf.oa.b_counter_regs =
			b_counter_config_vme_pipe;
		dev_priv->perf.oa.b_counter_regs_len =
			ARRAY_SIZE(b_counter_config_vme_pipe);

		dev_priv->perf.oa.flex_regs =
			flex_eu_config_vme_pipe;
		dev_priv->perf.oa.flex_regs_len =
			ARRAY_SIZE(flex_eu_config_vme_pipe);

		return 0;
	case METRIC_SET_ID_TEST_OA:
		dev_priv->perf.oa.n_mux_configs =
			get_test_oa_mux_config(dev_priv,
					       dev_priv->perf.oa.mux_regs,
					       dev_priv->perf.oa.mux_regs_lens);
		if (dev_priv->perf.oa.n_mux_configs == 0) {
			DRM_DEBUG_DRIVER("No suitable MUX config for \"TEST_OA\" metric set\n");

			/* EINVAL because *_register_sysfs already checked this
			 * and so it wouldn't have been advertised to userspace and
			 * so shouldn't have been requested
			 */
			return -EINVAL;
		}

		dev_priv->perf.oa.b_counter_regs =
			b_counter_config_test_oa;
		dev_priv->perf.oa.b_counter_regs_len =
			ARRAY_SIZE(b_counter_config_test_oa);

		dev_priv->perf.oa.flex_regs =
			flex_eu_config_test_oa;
		dev_priv->perf.oa.flex_regs_len =
			ARRAY_SIZE(flex_eu_config_test_oa);

		return 0;
	default:
		return -ENODEV;
	}
}

static ssize_t
show_render_basic_id(struct device *kdev, struct device_attribute *attr, char *buf)
{
	return sprintf(buf, "%d\n", METRIC_SET_ID_RENDER_BASIC);
}

static struct device_attribute dev_attr_render_basic_id = {
	.attr = { .name = "id", .mode = 0444 },
	.show = show_render_basic_id,
	.store = NULL,
};

static struct attribute *attrs_render_basic[] = {
	&dev_attr_render_basic_id.attr,
	NULL,
};

static struct attribute_group group_render_basic = {
	.name = "bad77c24-cc64-480d-99bf-e7b740713800",
	.attrs =  attrs_render_basic,
};

static ssize_t
show_compute_basic_id(struct device *kdev, struct device_attribute *attr, char *buf)
{
	return sprintf(buf, "%d\n", METRIC_SET_ID_COMPUTE_BASIC);
}

static struct device_attribute dev_attr_compute_basic_id = {
	.attr = { .name = "id", .mode = 0444 },
	.show = show_compute_basic_id,
	.store = NULL,
};

static struct attribute *attrs_compute_basic[] = {
	&dev_attr_compute_basic_id.attr,
	NULL,
};

static struct attribute_group group_compute_basic = {
	.name = "7277228f-e7f3-4743-945a-6a2049d11377",
	.attrs =  attrs_compute_basic,
};

static ssize_t
show_render_pipe_profile_id(struct device *kdev, struct device_attribute *attr, char *buf)
{
	return sprintf(buf, "%d\n", METRIC_SET_ID_RENDER_PIPE_PROFILE);
}

static struct device_attribute dev_attr_render_pipe_profile_id = {
	.attr = { .name = "id", .mode = 0444 },
	.show = show_render_pipe_profile_id,
	.store = NULL,
};

static struct attribute *attrs_render_pipe_profile[] = {
	&dev_attr_render_pipe_profile_id.attr,
	NULL,
};

static struct attribute_group group_render_pipe_profile = {
	.name = "463c668c-3f60-49b6-8f85-d995b635b3b2",
	.attrs =  attrs_render_pipe_profile,
};

static ssize_t
show_memory_reads_id(struct device *kdev, struct device_attribute *attr, char *buf)
{
	return sprintf(buf, "%d\n", METRIC_SET_ID_MEMORY_READS);
}

static struct device_attribute dev_attr_memory_reads_id = {
	.attr = { .name = "id", .mode = 0444 },
	.show = show_memory_reads_id,
	.store = NULL,
};

static struct attribute *attrs_memory_reads[] = {
	&dev_attr_memory_reads_id.attr,
	NULL,
};

static struct attribute_group group_memory_reads = {
	.name = "3ae6e74c-72c3-4040-9bd0-7961430b8cc8",
	.attrs =  attrs_memory_reads,
};

static ssize_t
show_memory_writes_id(struct device *kdev, struct device_attribute *attr, char *buf)
{
	return sprintf(buf, "%d\n", METRIC_SET_ID_MEMORY_WRITES);
}

static struct device_attribute dev_attr_memory_writes_id = {
	.attr = { .name = "id", .mode = 0444 },
	.show = show_memory_writes_id,
	.store = NULL,
};

static struct attribute *attrs_memory_writes[] = {
	&dev_attr_memory_writes_id.attr,
	NULL,
};

static struct attribute_group group_memory_writes = {
	.name = "055f256d-4052-467c-8dec-6064a4806433",
	.attrs =  attrs_memory_writes,
};

static ssize_t
show_compute_extended_id(struct device *kdev, struct device_attribute *attr, char *buf)
{
	return sprintf(buf, "%d\n", METRIC_SET_ID_COMPUTE_EXTENDED);
}

static struct device_attribute dev_attr_compute_extended_id = {
	.attr = { .name = "id", .mode = 0444 },
	.show = show_compute_extended_id,
	.store = NULL,
};

static struct attribute *attrs_compute_extended[] = {
	&dev_attr_compute_extended_id.attr,
	NULL,
};

static struct attribute_group group_compute_extended = {
	.name = "753972d4-87cd-4460-824d-754463ac5054",
	.attrs =  attrs_compute_extended,
};

static ssize_t
show_compute_l3_cache_id(struct device *kdev, struct device_attribute *attr, char *buf)
{
	return sprintf(buf, "%d\n", METRIC_SET_ID_COMPUTE_L3_CACHE);
}

static struct device_attribute dev_attr_compute_l3_cache_id = {
	.attr = { .name = "id", .mode = 0444 },
	.show = show_compute_l3_cache_id,
	.store = NULL,
};

static struct attribute *attrs_compute_l3_cache[] = {
	&dev_attr_compute_l3_cache_id.attr,
	NULL,
};

static struct attribute_group group_compute_l3_cache = {
	.name = "4e4392e9-8f73-457b-ab44-b49f7a0c733b",
	.attrs =  attrs_compute_l3_cache,
};

static ssize_t
show_hdc_and_sf_id(struct device *kdev, struct device_attribute *attr, char *buf)
{
	return sprintf(buf, "%d\n", METRIC_SET_ID_HDC_AND_SF);
}

static struct device_attribute dev_attr_hdc_and_sf_id = {
	.attr = { .name = "id", .mode = 0444 },
	.show = show_hdc_and_sf_id,
	.store = NULL,
};

static struct attribute *attrs_hdc_and_sf[] = {
	&dev_attr_hdc_and_sf_id.attr,
	NULL,
};

static struct attribute_group group_hdc_and_sf = {
	.name = "730d95dd-7da8-4e1c-ab8d-c0eb1e4c1805",
	.attrs =  attrs_hdc_and_sf,
};

static ssize_t
show_l3_1_id(struct device *kdev, struct device_attribute *attr, char *buf)
{
	return sprintf(buf, "%d\n", METRIC_SET_ID_L3_1);
}

static struct device_attribute dev_attr_l3_1_id = {
	.attr = { .name = "id", .mode = 0444 },
	.show = show_l3_1_id,
	.store = NULL,
};

static struct attribute *attrs_l3_1[] = {
	&dev_attr_l3_1_id.attr,
	NULL,
};

static struct attribute_group group_l3_1 = {
	.name = "d9e86d70-462b-462a-851e-fd63e8c13d63",
	.attrs =  attrs_l3_1,
};

static ssize_t
show_l3_2_id(struct device *kdev, struct device_attribute *attr, char *buf)
{
	return sprintf(buf, "%d\n", METRIC_SET_ID_L3_2);
}

static struct device_attribute dev_attr_l3_2_id = {
	.attr = { .name = "id", .mode = 0444 },
	.show = show_l3_2_id,
	.store = NULL,
};

static struct attribute *attrs_l3_2[] = {
	&dev_attr_l3_2_id.attr,
	NULL,
};

static struct attribute_group group_l3_2 = {
	.name = "52200424-6ee9-48b3-b7fa-0afcf1975e4d",
	.attrs =  attrs_l3_2,
};

static ssize_t
show_l3_3_id(struct device *kdev, struct device_attribute *attr, char *buf)
{
	return sprintf(buf, "%d\n", METRIC_SET_ID_L3_3);
}

static struct device_attribute dev_attr_l3_3_id = {
	.attr = { .name = "id", .mode = 0444 },
	.show = show_l3_3_id,
	.store = NULL,
};

static struct attribute *attrs_l3_3[] = {
	&dev_attr_l3_3_id.attr,
	NULL,
};

static struct attribute_group group_l3_3 = {
	.name = "1988315f-0a26-44df-acb0-df7ec86b1456",
	.attrs =  attrs_l3_3,
};

static ssize_t
show_rasterizer_and_pixel_backend_id(struct device *kdev, struct device_attribute *attr, char *buf)
{
	return sprintf(buf, "%d\n", METRIC_SET_ID_RASTERIZER_AND_PIXEL_BACKEND);
}

static struct device_attribute dev_attr_rasterizer_and_pixel_backend_id = {
	.attr = { .name = "id", .mode = 0444 },
	.show = show_rasterizer_and_pixel_backend_id,
	.store = NULL,
};

static struct attribute *attrs_rasterizer_and_pixel_backend[] = {
	&dev_attr_rasterizer_and_pixel_backend_id.attr,
	NULL,
};

static struct attribute_group group_rasterizer_and_pixel_backend = {
	.name = "f1f17ca7-286e-4ae5-9d15-9fccad6c665d",
	.attrs =  attrs_rasterizer_and_pixel_backend,
};

static ssize_t
show_sampler_id(struct device *kdev, struct device_attribute *attr, char *buf)
{
	return sprintf(buf, "%d\n", METRIC_SET_ID_SAMPLER);
}

static struct device_attribute dev_attr_sampler_id = {
	.attr = { .name = "id", .mode = 0444 },
	.show = show_sampler_id,
	.store = NULL,
};

static struct attribute *attrs_sampler[] = {
	&dev_attr_sampler_id.attr,
	NULL,
};

static struct attribute_group group_sampler = {
	.name = "00a9e0fb-3d2e-4405-852c-dce6334ffb3b",
	.attrs =  attrs_sampler,
};

static ssize_t
show_tdl_1_id(struct device *kdev, struct device_attribute *attr, char *buf)
{
	return sprintf(buf, "%d\n", METRIC_SET_ID_TDL_1);
}

static struct device_attribute dev_attr_tdl_1_id = {
	.attr = { .name = "id", .mode = 0444 },
	.show = show_tdl_1_id,
	.store = NULL,
};

static struct attribute *attrs_tdl_1[] = {
	&dev_attr_tdl_1_id.attr,
	NULL,
};

static struct attribute_group group_tdl_1 = {
	.name = "13dcc50a-7ec0-409b-99d6-a3f932cedcb3",
	.attrs =  attrs_tdl_1,
};

static ssize_t
show_tdl_2_id(struct device *kdev, struct device_attribute *attr, char *buf)
{
	return sprintf(buf, "%d\n", METRIC_SET_ID_TDL_2);
}

static struct device_attribute dev_attr_tdl_2_id = {
	.attr = { .name = "id", .mode = 0444 },
	.show = show_tdl_2_id,
	.store = NULL,
};

static struct attribute *attrs_tdl_2[] = {
	&dev_attr_tdl_2_id.attr,
	NULL,
};

static struct attribute_group group_tdl_2 = {
	.name = "97875e21-6624-4aee-9191-682feb3eae21",
	.attrs =  attrs_tdl_2,
};

static ssize_t
show_compute_extra_id(struct device *kdev, struct device_attribute *attr, char *buf)
{
	return sprintf(buf, "%d\n", METRIC_SET_ID_COMPUTE_EXTRA);
}

static struct device_attribute dev_attr_compute_extra_id = {
	.attr = { .name = "id", .mode = 0444 },
	.show = show_compute_extra_id,
	.store = NULL,
};

static struct attribute *attrs_compute_extra[] = {
	&dev_attr_compute_extra_id.attr,
	NULL,
};

static struct attribute_group group_compute_extra = {
	.name = "a5aa857d-e8f0-4dfa-8981-ce340fa748fd",
	.attrs =  attrs_compute_extra,
};

static ssize_t
show_vme_pipe_id(struct device *kdev, struct device_attribute *attr, char *buf)
{
	return sprintf(buf, "%d\n", METRIC_SET_ID_VME_PIPE);
}

static struct device_attribute dev_attr_vme_pipe_id = {
	.attr = { .name = "id", .mode = 0444 },
	.show = show_vme_pipe_id,
	.store = NULL,
};

static struct attribute *attrs_vme_pipe[] = {
	&dev_attr_vme_pipe_id.attr,
	NULL,
};

static struct attribute_group group_vme_pipe = {
	.name = "0e8d8b86-4ee7-4cdd-aaaa-58adc92cb29e",
	.attrs =  attrs_vme_pipe,
};

static ssize_t
show_test_oa_id(struct device *kdev, struct device_attribute *attr, char *buf)
{
	return sprintf(buf, "%d\n", METRIC_SET_ID_TEST_OA);
}

static struct device_attribute dev_attr_test_oa_id = {
	.attr = { .name = "id", .mode = 0444 },
	.show = show_test_oa_id,
	.store = NULL,
};

static struct attribute *attrs_test_oa[] = {
	&dev_attr_test_oa_id.attr,
	NULL,
};

static struct attribute_group group_test_oa = {
	.name = "882fa433-1f4a-4a67-a962-c741888fe5f5",
	.attrs =  attrs_test_oa,
};

int
i915_perf_register_sysfs_sklgt4(struct drm_i915_private *dev_priv)
{
	const struct i915_oa_reg *mux_regs[ARRAY_SIZE(dev_priv->perf.oa.mux_regs)];
	int mux_lens[ARRAY_SIZE(dev_priv->perf.oa.mux_regs_lens)];
	int ret = 0;

	if (get_render_basic_mux_config(dev_priv, mux_regs, mux_lens)) {
		ret = sysfs_create_group(dev_priv->perf.metrics_kobj, &group_render_basic);
		if (ret)
			goto error_render_basic;
	}
	if (get_compute_basic_mux_config(dev_priv, mux_regs, mux_lens)) {
		ret = sysfs_create_group(dev_priv->perf.metrics_kobj, &group_compute_basic);
		if (ret)
			goto error_compute_basic;
	}
	if (get_render_pipe_profile_mux_config(dev_priv, mux_regs, mux_lens)) {
		ret = sysfs_create_group(dev_priv->perf.metrics_kobj, &group_render_pipe_profile);
		if (ret)
			goto error_render_pipe_profile;
	}
	if (get_memory_reads_mux_config(dev_priv, mux_regs, mux_lens)) {
		ret = sysfs_create_group(dev_priv->perf.metrics_kobj, &group_memory_reads);
		if (ret)
			goto error_memory_reads;
	}
	if (get_memory_writes_mux_config(dev_priv, mux_regs, mux_lens)) {
		ret = sysfs_create_group(dev_priv->perf.metrics_kobj, &group_memory_writes);
		if (ret)
			goto error_memory_writes;
	}
	if (get_compute_extended_mux_config(dev_priv, mux_regs, mux_lens)) {
		ret = sysfs_create_group(dev_priv->perf.metrics_kobj, &group_compute_extended);
		if (ret)
			goto error_compute_extended;
	}
	if (get_compute_l3_cache_mux_config(dev_priv, mux_regs, mux_lens)) {
		ret = sysfs_create_group(dev_priv->perf.metrics_kobj, &group_compute_l3_cache);
		if (ret)
			goto error_compute_l3_cache;
	}
	if (get_hdc_and_sf_mux_config(dev_priv, mux_regs, mux_lens)) {
		ret = sysfs_create_group(dev_priv->perf.metrics_kobj, &group_hdc_and_sf);
		if (ret)
			goto error_hdc_and_sf;
	}
	if (get_l3_1_mux_config(dev_priv, mux_regs, mux_lens)) {
		ret = sysfs_create_group(dev_priv->perf.metrics_kobj, &group_l3_1);
		if (ret)
			goto error_l3_1;
	}
	if (get_l3_2_mux_config(dev_priv, mux_regs, mux_lens)) {
		ret = sysfs_create_group(dev_priv->perf.metrics_kobj, &group_l3_2);
		if (ret)
			goto error_l3_2;
	}
	if (get_l3_3_mux_config(dev_priv, mux_regs, mux_lens)) {
		ret = sysfs_create_group(dev_priv->perf.metrics_kobj, &group_l3_3);
		if (ret)
			goto error_l3_3;
	}
	if (get_rasterizer_and_pixel_backend_mux_config(dev_priv, mux_regs, mux_lens)) {
		ret = sysfs_create_group(dev_priv->perf.metrics_kobj, &group_rasterizer_and_pixel_backend);
		if (ret)
			goto error_rasterizer_and_pixel_backend;
	}
	if (get_sampler_mux_config(dev_priv, mux_regs, mux_lens)) {
		ret = sysfs_create_group(dev_priv->perf.metrics_kobj, &group_sampler);
		if (ret)
			goto error_sampler;
	}
	if (get_tdl_1_mux_config(dev_priv, mux_regs, mux_lens)) {
		ret = sysfs_create_group(dev_priv->perf.metrics_kobj, &group_tdl_1);
		if (ret)
			goto error_tdl_1;
	}
	if (get_tdl_2_mux_config(dev_priv, mux_regs, mux_lens)) {
		ret = sysfs_create_group(dev_priv->perf.metrics_kobj, &group_tdl_2);
		if (ret)
			goto error_tdl_2;
	}
	if (get_compute_extra_mux_config(dev_priv, mux_regs, mux_lens)) {
		ret = sysfs_create_group(dev_priv->perf.metrics_kobj, &group_compute_extra);
		if (ret)
			goto error_compute_extra;
	}
	if (get_vme_pipe_mux_config(dev_priv, mux_regs, mux_lens)) {
		ret = sysfs_create_group(dev_priv->perf.metrics_kobj, &group_vme_pipe);
		if (ret)
			goto error_vme_pipe;
	}
	if (get_test_oa_mux_config(dev_priv, mux_regs, mux_lens)) {
		ret = sysfs_create_group(dev_priv->perf.metrics_kobj, &group_test_oa);
		if (ret)
			goto error_test_oa;
	}

	return 0;

error_test_oa:
	if (get_vme_pipe_mux_config(dev_priv, mux_regs, mux_lens))
		sysfs_remove_group(dev_priv->perf.metrics_kobj, &group_vme_pipe);
error_vme_pipe:
	if (get_compute_extra_mux_config(dev_priv, mux_regs, mux_lens))
		sysfs_remove_group(dev_priv->perf.metrics_kobj, &group_compute_extra);
error_compute_extra:
	if (get_tdl_2_mux_config(dev_priv, mux_regs, mux_lens))
		sysfs_remove_group(dev_priv->perf.metrics_kobj, &group_tdl_2);
error_tdl_2:
	if (get_tdl_1_mux_config(dev_priv, mux_regs, mux_lens))
		sysfs_remove_group(dev_priv->perf.metrics_kobj, &group_tdl_1);
error_tdl_1:
	if (get_sampler_mux_config(dev_priv, mux_regs, mux_lens))
		sysfs_remove_group(dev_priv->perf.metrics_kobj, &group_sampler);
error_sampler:
	if (get_rasterizer_and_pixel_backend_mux_config(dev_priv, mux_regs, mux_lens))
		sysfs_remove_group(dev_priv->perf.metrics_kobj, &group_rasterizer_and_pixel_backend);
error_rasterizer_and_pixel_backend:
	if (get_l3_3_mux_config(dev_priv, mux_regs, mux_lens))
		sysfs_remove_group(dev_priv->perf.metrics_kobj, &group_l3_3);
error_l3_3:
	if (get_l3_2_mux_config(dev_priv, mux_regs, mux_lens))
		sysfs_remove_group(dev_priv->perf.metrics_kobj, &group_l3_2);
error_l3_2:
	if (get_l3_1_mux_config(dev_priv, mux_regs, mux_lens))
		sysfs_remove_group(dev_priv->perf.metrics_kobj, &group_l3_1);
error_l3_1:
	if (get_hdc_and_sf_mux_config(dev_priv, mux_regs, mux_lens))
		sysfs_remove_group(dev_priv->perf.metrics_kobj, &group_hdc_and_sf);
error_hdc_and_sf:
	if (get_compute_l3_cache_mux_config(dev_priv, mux_regs, mux_lens))
		sysfs_remove_group(dev_priv->perf.metrics_kobj, &group_compute_l3_cache);
error_compute_l3_cache:
	if (get_compute_extended_mux_config(dev_priv, mux_regs, mux_lens))
		sysfs_remove_group(dev_priv->perf.metrics_kobj, &group_compute_extended);
error_compute_extended:
	if (get_memory_writes_mux_config(dev_priv, mux_regs, mux_lens))
		sysfs_remove_group(dev_priv->perf.metrics_kobj, &group_memory_writes);
error_memory_writes:
	if (get_memory_reads_mux_config(dev_priv, mux_regs, mux_lens))
		sysfs_remove_group(dev_priv->perf.metrics_kobj, &group_memory_reads);
error_memory_reads:
	if (get_render_pipe_profile_mux_config(dev_priv, mux_regs, mux_lens))
		sysfs_remove_group(dev_priv->perf.metrics_kobj, &group_render_pipe_profile);
error_render_pipe_profile:
	if (get_compute_basic_mux_config(dev_priv, mux_regs, mux_lens))
		sysfs_remove_group(dev_priv->perf.metrics_kobj, &group_compute_basic);
error_compute_basic:
	if (get_render_basic_mux_config(dev_priv, mux_regs, mux_lens))
		sysfs_remove_group(dev_priv->perf.metrics_kobj, &group_render_basic);
error_render_basic:
	return ret;
}

void
i915_perf_unregister_sysfs_sklgt4(struct drm_i915_private *dev_priv)
{
	const struct i915_oa_reg *mux_regs[ARRAY_SIZE(dev_priv->perf.oa.mux_regs)];
	int mux_lens[ARRAY_SIZE(dev_priv->perf.oa.mux_regs_lens)];

	if (get_render_basic_mux_config(dev_priv, mux_regs, mux_lens))
		sysfs_remove_group(dev_priv->perf.metrics_kobj, &group_render_basic);
	if (get_compute_basic_mux_config(dev_priv, mux_regs, mux_lens))
		sysfs_remove_group(dev_priv->perf.metrics_kobj, &group_compute_basic);
	if (get_render_pipe_profile_mux_config(dev_priv, mux_regs, mux_lens))
		sysfs_remove_group(dev_priv->perf.metrics_kobj, &group_render_pipe_profile);
	if (get_memory_reads_mux_config(dev_priv, mux_regs, mux_lens))
		sysfs_remove_group(dev_priv->perf.metrics_kobj, &group_memory_reads);
	if (get_memory_writes_mux_config(dev_priv, mux_regs, mux_lens))
		sysfs_remove_group(dev_priv->perf.metrics_kobj, &group_memory_writes);
	if (get_compute_extended_mux_config(dev_priv, mux_regs, mux_lens))
		sysfs_remove_group(dev_priv->perf.metrics_kobj, &group_compute_extended);
	if (get_compute_l3_cache_mux_config(dev_priv, mux_regs, mux_lens))
		sysfs_remove_group(dev_priv->perf.metrics_kobj, &group_compute_l3_cache);
	if (get_hdc_and_sf_mux_config(dev_priv, mux_regs, mux_lens))
		sysfs_remove_group(dev_priv->perf.metrics_kobj, &group_hdc_and_sf);
	if (get_l3_1_mux_config(dev_priv, mux_regs, mux_lens))
		sysfs_remove_group(dev_priv->perf.metrics_kobj, &group_l3_1);
	if (get_l3_2_mux_config(dev_priv, mux_regs, mux_lens))
		sysfs_remove_group(dev_priv->perf.metrics_kobj, &group_l3_2);
	if (get_l3_3_mux_config(dev_priv, mux_regs, mux_lens))
		sysfs_remove_group(dev_priv->perf.metrics_kobj, &group_l3_3);
	if (get_rasterizer_and_pixel_backend_mux_config(dev_priv, mux_regs, mux_lens))
		sysfs_remove_group(dev_priv->perf.metrics_kobj, &group_rasterizer_and_pixel_backend);
	if (get_sampler_mux_config(dev_priv, mux_regs, mux_lens))
		sysfs_remove_group(dev_priv->perf.metrics_kobj, &group_sampler);
	if (get_tdl_1_mux_config(dev_priv, mux_regs, mux_lens))
		sysfs_remove_group(dev_priv->perf.metrics_kobj, &group_tdl_1);
	if (get_tdl_2_mux_config(dev_priv, mux_regs, mux_lens))
		sysfs_remove_group(dev_priv->perf.metrics_kobj, &group_tdl_2);
	if (get_compute_extra_mux_config(dev_priv, mux_regs, mux_lens))
		sysfs_remove_group(dev_priv->perf.metrics_kobj, &group_compute_extra);
	if (get_vme_pipe_mux_config(dev_priv, mux_regs, mux_lens))
		sysfs_remove_group(dev_priv->perf.metrics_kobj, &group_vme_pipe);
	if (get_test_oa_mux_config(dev_priv, mux_regs, mux_lens))
		sysfs_remove_group(dev_priv->perf.metrics_kobj, &group_test_oa);
}
