/* SPDX-License-Identifier: GPL-2.0-or-later */
/*
 * Copyright (C) 2025 ROHM Semiconductors
 *
 * The digital interface of trhe BD96802 PMIC is a reduced version of the
 * BD96801. Hence the BD96801 definitions are used for registers and masks
 * while this header only holds the IRQ definitions - mainly to avoid gaps in
 * IRQ numbers caused by the lack of some BUCKs / LDOs and their respective
 * IRQs.
 */

#ifndef __LINUX_MFD_BD96802_H__
#define __LINUX_MFD_BD96802_H__

/* ERRB IRQs */
enum {
	/* Reg 0x52, 0x53, 0x54 - ERRB system IRQs */
	BD96802_OTP_ERR_STAT,
	BD96802_DBIST_ERR_STAT,
	BD96802_EEP_ERR_STAT,
	BD96802_ABIST_ERR_STAT,
	BD96802_PRSTB_ERR_STAT,
	BD96802_DRMOS1_ERR_STAT,
	BD96802_DRMOS2_ERR_STAT,
	BD96802_SLAVE_ERR_STAT,
	BD96802_VREF_ERR_STAT,
	BD96802_TSD_ERR_STAT,
	BD96802_UVLO_ERR_STAT,
	BD96802_OVLO_ERR_STAT,
	BD96802_OSC_ERR_STAT,
	BD96802_PON_ERR_STAT,
	BD96802_POFF_ERR_STAT,
	BD96802_CMD_SHDN_ERR_STAT,
	BD96802_INT_SHDN_ERR_STAT,

	/* Reg 0x55 BUCK1 ERR IRQs */
	BD96802_BUCK1_PVIN_ERR_STAT,
	BD96802_BUCK1_OVP_ERR_STAT,
	BD96802_BUCK1_UVP_ERR_STAT,
	BD96802_BUCK1_SHDN_ERR_STAT,

	/* Reg 0x56 BUCK2 ERR IRQs */
	BD96802_BUCK2_PVIN_ERR_STAT,
	BD96802_BUCK2_OVP_ERR_STAT,
	BD96802_BUCK2_UVP_ERR_STAT,
	BD96802_BUCK2_SHDN_ERR_STAT,
};

/* INTB IRQs */
enum {
	/* Reg 0x5c (System INTB) */
	BD96802_TW_STAT,
	BD96802_WDT_ERR_STAT,
	BD96802_I2C_ERR_STAT,
	BD96802_CHIP_IF_ERR_STAT,

	/* Reg 0x5d (BUCK1 INTB) */
	BD96802_BUCK1_OCPH_STAT,
	BD96802_BUCK1_OCPL_STAT,
	BD96802_BUCK1_OCPN_STAT,
	BD96802_BUCK1_OVD_STAT,
	BD96802_BUCK1_UVD_STAT,
	BD96802_BUCK1_TW_CH_STAT,

	/* Reg 0x5e (BUCK2 INTB) */
	BD96802_BUCK2_OCPH_STAT,
	BD96802_BUCK2_OCPL_STAT,
	BD96802_BUCK2_OCPN_STAT,
	BD96802_BUCK2_OVD_STAT,
	BD96802_BUCK2_UVD_STAT,
	BD96802_BUCK2_TW_CH_STAT,
};

#endif
