#
#	MN_digest.pl
#
#	Mail-Net digestifier.
#		* makes digests, and replaces function
#			MN_global.pl: SendFileToChannel
#		* MN_scheduler sends digests out.
#
#	Created: Mon Dec  7 05:28:04 1992
#	Last modified: Sat Jan 23 04:37:02 1993
#
#	@ arl // 1992
#
#	Copyright (C) FRL
#		All rights reserved, free for use of
#		non-commercial purposes given.		
#

sub
TakeDigestLock
{
	local($channel)	= pop(@_);

ReDo:	if ( -f $DIGEST_DIRECTORY . $channel . ".digest.lock" )
	{
		sleep( 10 );
		goto ReDo;
	}
	else
	{
		open( DIGEST_LOCKFILE, ">" . $DIGEST_DIRECTORY . $channel . 
				".digest.lock" );
		print DIGEST_LOCKFILE $$,time;
		close( DIGEST_LOCKFILE );
	}
}

sub
ReleaseDigestLock
{
	local($channel)	= pop(@_);

	unlink( $DIGEST_DIRECTORY . $channel . ".digest.lock" );
}

sub
SendFileToDigest
{
	local($WhoAmI)			= pop(@_);
	local($message_filename)	= pop(@_);
	local($channel)			= pop(@_);
	local($firstline)		= 1;
	local($header)			= 1;
	local($FromLine)		= '';
	local($SubjectLine)		= '';
	local($DateLine)		= '';
	local($ReplyToAddress)		= '';

	&TakeDigestLock( $channel );

	open( DIGEST_BODY, ">>" . $DIGEST_DIRECTORY .
		$channel . ".digest.body" );

	if ( -f $DIGEST_DIRECTORY . $channel . ".digest" )
	{
		open( DIGEST_FILE, ">>" . $DIGEST_DIRECTORY .
			$channel . ".digest" );
	}
	else
	{
		($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) =
					   gmtime(time);
		open( DIGEST_FILE, ">>" . $DIGEST_DIRECTORY .
			$channel . ".digest" );
		print DIGEST_FILE "From: \"Linux Activists\" <", $WhoAmI,
			"@niksula.hut.fi>\n";
		print DIGEST_FILE "To: \"Linux-Activists\" <",
			$WhoAmI, "@niksula.hut.fi>\n";
		print DIGEST_FILE "Reply-To: \"Linux-Activists\" <",
			$WhoAmI, "@niksula.hut.fi>\n";
		print DIGEST_FILE "X-Note1: Remember to put \'X-Mn-Key: ",
			$channel, "\' to your mail body or header\n";
		print DIGEST_FILE "Subject: Linux-Activists - ",
			$channel, " Channel digest. ",
			$year,"-",$mon,"-",$mday,"-",$hour,":",$min,"\n";
		print DIGEST_FILE "X-Mn-Key: ", $channel, "\n";
		print DIGEST_FILE "Sender: owner-", $WhoAmI,
			"@niksula.hut.fi\n";
		print DIGEST_FILE "\n\n";
		print DIGEST_FILE "Topics:\n";
	}

	open( MESSAGE_FILE, "<" . $message_filename );

	while ( <MESSAGE_FILE> )
	{
		if ( $header )
		{
			if ( length($_) eq 1 )
			{
				print DIGEST_BODY $FromLine;
				if ( length($SubjectLine) > 0 )
				{
					print DIGEST_BODY $SubjectLine;
				}
				else
				{
					print DIGEST_BODY "Subject: <none>\n";
				}
				print DIGEST_BODY $DateLine;
				if ( length($ReplyToAddress) > 0 )
				{
					print DIGEST_BODY $ReplyToLine;
				}
				print DIGEST_BODY $_;
				$header = 0;
				next;
			}
			if ( /^Subject:/ )
			{
				$SubjectLine = $_;
			}
			elsif ( /^From:/ )
			{
				$FromLine = $_;
			}
			elsif ( /^Reply-To:/ )
			{
				$ReplyToLine = $_;
			}
			elsif ( /^Date:/ )
			{
				$DateLine = $_;
			}
		}
		else
		{
			if ( $firstline )
			{
				if ( length($_) > 1 )
				{
					if ( /^X-Mn-Key:/ || /^Mn-Key:/ )
					{
#	Try to get rid of all X-Mn-Key: or Mn-Key: lines (even multiple).
						next;
					}
					$firstline = 0;
				}
			}
			print DIGEST_BODY $_;
		}
	}

	($dummy,$SubjectField) = split( /[:]/, $SubjectLine, 2 );
	if ( length($SubjectField) > 0 )
	{
		if ( index($SubjectField,"\t") ne 0 )
		{
			print DIGEST_FILE "\t";
		}
		print DIGEST_FILE $SubjectField;
	}
	else
	{
		print DIGEST_FILE "\t<none>\n";
	}
	print DIGEST_BODY "\n\n------------------------------\n\n";

	close( MESSAGE_FILE );
	close( DIGEST_BODY );
	close( DIGEST_FILE );

	&ReleaseDigestLock( $channel );

}

sub
SendDigestToChannel
{
	local($WhoAmI)			= pop(@_);
	local($channel)			= pop(@_);
	local($DigestFileName)		= $DIGEST_DIRECTORY;
	local($DigestOutFileName)	= $DIGEST_DIRECTORY;
	local($DigestBodyFileName)	= $DIGEST_DIRECTORY;
	local($DigestOutBodyFileName)	= $DIGEST_DIRECTORY;
	local($DigestSendFileName)	= '';
	local($DigestEndLine)		= '';

	&TakeDigestLock( $channel );

	$DigestFileName .= $channel . ".digest";
	$DigestOutFileName .= $channel . ".digest.out";
	link( $DigestFileName, $DigestOutFileName );
	unlink( $DigestFileName );

	$DigestSendFileName = $DigestOutFileName . "." . time;
	open( DIGEST_SEND, ">" . $DigestSendFileName );

	$DigestBodyFileName .= $channel . ".digest.body";
	$DigestOutBodyFileName .= $channel . ".digest.body.out";
	link( $DigestBodyFileName, $DigestOutBodyFileName );
	unlink( $DigestBodyFileName );

	open( DIGEST_FILE, "<" . $DigestOutFileName );
	while (<DIGEST_FILE>)
	{
		print DIGEST_SEND $_;
	}
	close( DIGEST_FILE );

	print DIGEST_SEND "\n\n", "-" x 70, "\n\n";

	open( DIGEST_BODY, "<" . $DigestOutBodyFileName );
	while (<DIGEST_BODY>)
	{
		print DIGEST_SEND $_;
	}
	close( DIGEST_BODY );

#	Needed for emacs rmail to handle digests.
	$DigestEndLine = "End of " . $channel . " Digest";
	print DIGEST_SEND $DigestEndLine,"\n";
	print DIGEST_SEND "*" x length($DigestEndLine), "\n";
	print DIGEST_SEND "-" x 7, "\n";

	close( DIGEST_SEND );

#	Send the file to channel.
	&SendFileToChannel( $channel, $DigestSendFileName, $WhoAmI );

#	For debugging purposes...
	link( $DigestSendFileName, &tmpfile( $DONE_TMPFILE ) );
	unlink( $DigestSendFileName );
#	link( $DigestOutFileName, &tmpfile( $DONE_TMPFILE ) );
	unlink( $DigestOutFileName );
#	sleep(2);
#	link( $DigestOutBodyFileName, &tmpfile( $DONE_TMPFILE ) );
	unlink( $DigestOutBodyFileName );

	&ReleaseDigestLock( $channel );
}

1;
