#include <stddef.h>
#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <sys/types.h>
#include <sys/socket.h>

#include "atm.h"


void data_exchange(int s) {
    /* BEGIN_data */
    const char msg[] = "Hello, world !\n";
    char *buffer,*start;
    struct atm_buffconst bc;
    ptrdiff_t pos;
    size_t length,buf_len;
    ssize_t size;

    length = sizeof(bc);
    if (getsockopt(s,SOL_SOCKET,SO_BCTXOPT,(char *) &bc,&length) < 0) {
	perror("getsockopt");
	exit(1);
    }
    buf_len = sizeof(msg)-bc.size_off+bc.size_fac-1;
    buf_len = buf_len-(buf_len % bc.size_fac)+bc.size_off;
    if (buf_len < bc.min_size) buf_len = bc.min_size;
    if (!(buffer = malloc(buf_len+bc.size_fac-1))) {
	perror("malloc");
	exit(1);
    }
    pos = (ptrdiff_t) (buffer-bc.buf_off+bc.buf_fac-1);
    start = (char *) (pos-(pos % bc.buf_fac)+bc.buf_off);
    if (sizeof(msg) != buf_len)
	memset(start+sizeof(msg),0,buf_len-sizeof(msg));
    if ((size = write(s,start,buf_len)) < 0) {
	perror("write");
	exit(1);
    }
    if (size != buf_len)
	fprintf(stderr,"Wrote only %d of %d bytes\n",size,
	  sizeof(msg));
    /* END_data */
}

void main(void) {
    /* BEGIN_prep */
    struct sockaddr_atmpvc addr;
    int s;

    if ((s = socket(PF_ATMPVC,SOCK_DGRAM,ATM_AAL5)) < 0) {
	perror("socket");
	exit(1);
    }
    memset(&addr,0,sizeof(addr));
    addr.sap_family = AF_ATMPVC;
    addr.sap_txtp.class = ATM_UBR;
    addr.sap_txtp.min_pcr = ATM_MAX_PCR;
    addr.sap_txtp.max_sdu = 8192;
    addr.sap_rxtp = addr.sap_txtp;
    /* END_prep */

    /* BEGIN_setup */
    addr.sap_addr.itf = 0;
    addr.sap_addr.vpi = ATM_VPI_UNSPEC;
    if (connect(s,(struct sockaddr *) &addr,sizeof(addr)) < 0) {
	perror("connect(1)");
	exit(1);
    }
    /* some other activities */
    addr.sap_addr.vpi = 0;
    addr.sap_addr.vci = 42;
    if (connect(s,(struct sockaddr *) &addr,sizeof(addr)) < 0) {
	perror("connect(2)");
	exit(1);
    }
    /* END_setup */

    data_exchange(s);

    /* BEGIN_teardown */
    (void) close(s);
    /* END_teardown */
}
