.TH WLANCFG 8
.SH NAME
wlancfg \- manupulate linux-wlan-ng MIB values
.SH SYNOPSIS
.B wlancfg query dev
.P
.B wlancfg show dev [all]
.P
.B wlancfg set dev
.P
.B wlancfg list
.P
.B wlancfg version
.SH DESCRIPTION
The wlancfg utility program provides an alternative method to
.B wlanctl-ng (1)
, for manipulating MIB values.  It was designed to provide
an easier mechanism for saving and restoring the complete wireless
configuration (i.e. when re-starting the device driver) and to provide
a more efficient mechanism for GUI's to query multiple MIB's.
.SH OPTIONS
.TP
.B dev
The name of the device (e.g., wlan0).
.TP
.B query
Read MIB names (separated by whitespace) from stdin
and output their values (separated by carriage returns)
to stdout.  The MIB's may be either read/write or
read-only.
.TP
.B show
Query the values of all supported read/write MIB's and
output their values (separated by carriage returns) to
stdout. The syntax of the output will be:
  name=value
.RS
If the "all" parameter is specified, then all supported
MIB's (i.e. read-only MIB's as well) are output.
.RE
.TP
.B set
Read MIB name/value pairs (separated by carriage returns)
from stdin and set the values of the specified MIB's.  The
pairs must have the same syntax as above.  The MIB's must
be read/write.
.TP
.B list
Display a list of all supported MIB's.
.TP
.B version
Display the compiled version of wlancfg.
.SH AUTHOR
This minimal man page was written by Joey Hess.
