/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

public final class Double
extends Number
implements Comparable {
    private static final long serialVersionUID = -9172774392245257468L;
    public static final double MAX_VALUE = 1.7976931348623157E308;
    public static final double MIN_VALUE = 4.9E-324;
    public static final double NEGATIVE_INFINITY = -1.0 / 0.0;
    public static final double POSITIVE_INFINITY = 1.0 / 0.0;
    public static final double NaN = 0.0 / 0.0;
    public static final Class TYPE = VMClassLoader.getPrimitiveClass('D');
    private final double value;

    public Double(double value) {
        this.value = value;
    }

    public Double(String s) {
        this.value = Double.parseDouble(s);
    }

    public static String toString(double d) {
        return Double.toString(d, false);
    }

    public static Double valueOf(String s) {
        return new Double(Double.parseDouble(s));
    }

    public static native double parseDouble(String var0);

    public static boolean isNaN(double v) {
        return v != v;
    }

    public static boolean isInfinite(double v) {
        return v > Double.MAX_VALUE || v < -1.7976931348623157E308;
    }

    public boolean isNaN() {
        return Double.isNaN(this.value);
    }

    public boolean isInfinite() {
        return Double.isInfinite(this.value);
    }

    public String toString() {
        return Double.toString(this.value);
    }

    public byte byteValue() {
        return (byte)this.value;
    }

    public short shortValue() {
        return (short)this.value;
    }

    public int intValue() {
        return (int)this.value;
    }

    public long longValue() {
        return (long)this.value;
    }

    public float floatValue() {
        return (float)this.value;
    }

    public double doubleValue() {
        return this.value;
    }

    public int hashCode() {
        long v = Double.doubleToLongBits(this.value);
        return (int)v ^ (int)(v >>> 32);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Double)) {
            return false;
        }
        double d = ((Double)obj).value;
        if (this.value == d) {
            return this.value != 0.0 || 1.0 / this.value == 1.0 / d;
        }
        return Double.isNaN(this.value) && Double.isNaN(d);
    }

    public static native long doubleToLongBits(double var0);

    public static native long doubleToRawLongBits(double var0);

    public static native double longBitsToDouble(long var0);

    public int compareTo(Double d) {
        return Double.compare(this.value, d.value);
    }

    public int compareTo(Object o) {
        return Double.compare(this.value, ((Double)o).value);
    }

    public static int compare(double x, double y) {
        if (Double.isNaN(x)) {
            if (Double.isNaN(y)) {
                return 0;
            }
            return 1;
        }
        if (Double.isNaN(y)) {
            return -1;
        }
        if (x == 0.0 && y == 0.0) {
            return (int)(1.0 / x - 1.0 / y);
        }
        if (x == y) {
            return 0;
        }
        if (x > y) {
            return 1;
        }
        return -1;
    }

    static native String toString(double var0, boolean var2);

    private static native void initIDs();
}

