#!/bin/sh
config() {
  NEW="$1"
  OLD="`dirname $NEW`/`basename $NEW .new`"
  # If there's no config file by that name, mv it over:
  if [ ! -r $OLD ]; then
    mv $NEW $OLD
  elif [ "`cat $OLD | md5sum`" = "`cat $NEW | md5sum`" ]; then # toss the redundant copy
    rm $NEW
  fi
  # Otherwise, we leave the .new copy for the admin to consider...
}
config etc/rc.d/rc.serial.new
config etc/fdprm.new
config etc/serial.conf.new

# Make symlinks:
( cd sbin ; rm -rf ramsize )
( cd sbin ; ln -sf rdev ramsize )
( cd sbin ; rm -rf swapoff )
( cd sbin ; ln -sf swapon swapoff )
( cd sbin ; rm -rf vidmode )
( cd sbin ; ln -sf rdev vidmode )
( cd sbin ; rm -rf mount )
( cd sbin ; ln -sf /bin/mount mount )
( cd sbin ; rm -rf umount )
( cd sbin ; ln -sf /bin/umount umount )
( cd sbin ; rm -rf rootflags )
( cd sbin ; ln -sf rdev rootflags )
( cd usr/bin ; rm -rf more )
( cd usr/bin ; ln -sf /bin/more more )
( cd bin ; rm -rf getoptprog )
( cd bin ; ln -sf getopt getoptprog )
( cd bin ; rm -rf domainname )
( cd bin ; ln -sf hostname domainname )
( cd bin ; rm -rf ypdomainname )
( cd bin ; ln -sf hostname ypdomainname )
( cd bin ; rm -rf dnsdomainname )
( cd bin ; ln -sf hostname dnsdomainname )
( cd bin ; rm -rf nisdomainname )
( cd bin ; ln -sf hostname nisdomainname )
( cd sbin ; rm -rf jaztool )
( cd sbin ; ln -sf ziptool jaztool )
( cd usr/man/man1 ; rm -rf jaztool.1.gz )
( cd usr/man/man1 ; ln -sf ziptool.1.gz jaztool.1.gz )
( cd sbin ; rm -rf clock )
( cd sbin ; ln -sf hwclock clock )
