.\" Copyright (c) 1999 - Sun Microsystems, Inc.
.\" All rights reserved.
.\" 
.\" Permission is hereby granted, free of charge, to any person obtaining a
.\" copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, and/or sell copies of the Software, and to permit persons
.\" to whom the Software is furnished to do so, provided that the above
.\" copyright notice(s) and this permission notice appear in all copies of
.\" the Software and that both the above copyright notice(s) and this
.\" permission notice appear in supporting documentation.
.\" 
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT
.\" OF THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
.\" HOLDERS INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL
.\" INDIRECT OR CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING
.\" FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT,
.\" NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION
.\" WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
.\" 
.\" Except as contained in this notice, the name of a copyright holder
.\" shall not be used in advertising or otherwise to promote the sale, use
.\" or other dealings in this Software without prior written authorization
.\" of the copyright holder.
.\"
.TH XkbGetState __libmansuffix__ __xorgversion__ "XKB FUNCTIONS"
.SH NAME
XkbGetState \-  Obtains the keyboard state 
.SH SYNOPSIS
.B Bool XkbGetState
(
.I display,
.I device_spec,
.I state_return
)
.br
      Display *\fIdisplay\fP\^;
.br
      unsigned int \fIdevice_spec\fP\^;
.br
      XkbStatePtr \fIstate_return\fP\^;
.if n .ti +5n
.if t .ti +.5i
.SH ARGUMENTS
.TP
.I display
connection to the X server 
.TP
.I device_spec
device ID, or XkbUseCoreKbd
.TP
.I state_return
backfilled with Xkb state
.SH DESCRIPTION
.LP
The 
.I XkbGetState 
function queries the server for the current keyboard state, waits 
for a reply, and then backfills 
.I state_return 
with the results.

All group values are expressed as group indices in the range [0..3]. Modifiers 
and the compatibility modifier state values are expressed as the bitwise union 
of the core X11 modifier masks. The pointer button state is reported as in the 
core X11 protocol.
