/* WARNING: This file is generated!
 * Do not edit this file, but edit config.xml instead and run
 * python configgen.py to regenerate this file!
 */

#include "configoptions.h"
#include "config.h"
#include "portable.h"

void addConfigOptions(Config *cfg)
{
  ConfigString *cs;
  ConfigEnum   *ce;
  ConfigList   *cl;
  ConfigInt    *ci;
  ConfigBool   *cb;

  //---------------------------------------------------------------------------
  cfg->addInfo("Project","Project related configuration options");
  //---------------------------------------------------------------------------

  //----
  cs = cfg->addString(
                 "DOXYFILE_ENCODING",
                 "This tag specifies the encoding used for all characters in the config file\n"
                 "that follow. The default is UTF-8 which is also the encoding used for all\n"
                 "text before the first occurrence of this tag. Doxygen uses libiconv (or the\n"
                 "iconv built into libc) for the transcoding. See\n"
                 "http://www.gnu.org/software/libiconv for the list of possible encodings."
                );
  cs->setDefaultValue("UTF-8");
  //----
  cs = cfg->addString(
                 "PROJECT_NAME",
                 "The PROJECT_NAME tag is a single word (or sequence of words) that should\n"
                 "identify the project. Note that if you do not use Doxywizard you need\n"
                 "to put quotes around the project name if it contains spaces."
                );
  cs->setDefaultValue("My Project");
  //----
  cs = cfg->addString(
                 "PROJECT_NUMBER",
                 "The PROJECT_NUMBER tag can be used to enter a project or revision number.\n"
                 "This could be handy for archiving the generated documentation or\n"
                 "if some version control system is used."
                );
  //----
  cs = cfg->addString(
                 "PROJECT_BRIEF",
                 "Using the PROJECT_BRIEF tag one can provide an optional one line description\n"
                 "for a project that appears at the top of each page and should give viewer\n"
                 "a quick idea about the purpose of the project. Keep the description short."
                );
  //----
  cs = cfg->addString(
                 "PROJECT_LOGO",
                 "With the PROJECT_LOGO tag one can specify an logo or icon that is\n"
                 "included in the documentation. The maximum height of the logo should not\n"
                 "exceed 55 pixels and the maximum width should not exceed 200 pixels.\n"
                 "Doxygen will copy the logo to the output directory."
                );
  cs->setWidgetType(ConfigString::File);
  //----
  cs = cfg->addString(
                 "OUTPUT_DIRECTORY",
                 "The OUTPUT_DIRECTORY tag is used to specify the (relative or absolute)\n"
                 "base path where the generated documentation will be put.\n"
                 "If a relative path is entered, it will be relative to the location\n"
                 "where doxygen was started. If left blank the current directory will be used."
                );
  cs->setWidgetType(ConfigString::Dir);
  //----
  cb = cfg->addBool(
                 "CREATE_SUBDIRS",
                 "If the CREATE_SUBDIRS tag is set to YES, then doxygen will create\n"
                 "4096 sub-directories (in 2 levels) under the output directory of each output\n"
                 "format and will distribute the generated files over these directories.\n"
                 "Enabling this option can be useful when feeding doxygen a huge amount of\n"
                 "source files, where putting all generated files in the same directory would\n"
                 "otherwise cause performance problems for the file system.",
                 FALSE
                );
  //----
  ce = cfg->addEnum(
                 "OUTPUT_LANGUAGE",
                 "The OUTPUT_LANGUAGE tag is used to specify the language in which all\n"
                 "documentation generated by doxygen is written. Doxygen will use this\n"
                 "information to generate all constant output in the proper language.\n"
                 "The default language is English, other supported languages are:\n"
                 "Afrikaans, Arabic, Brazilian, Catalan, Chinese, Chinese-Traditional,\n"
                 "Croatian, Czech, Danish, Dutch, Esperanto, Farsi, Finnish, French, German,\n"
                 "Greek, Hungarian, Italian, Japanese, Japanese-en (Japanese with English\n"
                 "messages), Korean, Korean-en, Lithuanian, Norwegian, Macedonian, Persian,\n"
                 "Polish, Portuguese, Romanian, Russian, Serbian, Serbian-Cyrillic, Slovak,\n"
                 "Slovene, Spanish, Swedish, Ukrainian, and Vietnamese.",
                 "English"
                );
  ce->addValue("Afrikaans");
  ce->addValue("Arabic");
  ce->addValue("Brazilian");
  ce->addValue("Catalan");
  ce->addValue("Chinese");
  ce->addValue("Chinese-Traditional");
  ce->addValue("Croatian");
  ce->addValue("Czech");
  ce->addValue("Danish");
  ce->addValue("Dutch");
  ce->addValue("English");
  ce->addValue("Esperanto");
  ce->addValue("Farsi");
  ce->addValue("Finnish");
  ce->addValue("French");
  ce->addValue("German");
  ce->addValue("Greek");
  ce->addValue("Hungarian");
  ce->addValue("Italian");
  ce->addValue("Japanese");
  ce->addValue("Japanese-en");
  ce->addValue("Korean");
  ce->addValue("Korean-en");
  ce->addValue("Norwegian");
  ce->addValue("Macedonian");
  ce->addValue("Persian");
  ce->addValue("Polish");
  ce->addValue("Portuguese");
  ce->addValue("Romanian");
  ce->addValue("Russian");
  ce->addValue("Serbian");
  ce->addValue("Slovak");
  ce->addValue("Slovene");
  ce->addValue("Spanish");
  ce->addValue("Swedish");
  ce->addValue("Turkish");
  ce->addValue("Ukrainian");
  ce->addValue("Vietnamese");
  //----
  cb = cfg->addBool(
                 "BRIEF_MEMBER_DESC",
                 "If the BRIEF_MEMBER_DESC tag is set to YES (the default) Doxygen will\n"
                 "include brief member descriptions after the members that are listed in\n"
                 "the file and class documentation (similar to JavaDoc).\n"
                 "Set to NO to disable this.",
                 TRUE
                );
  //----
  cb = cfg->addBool(
                 "REPEAT_BRIEF",
                 "If the REPEAT_BRIEF tag is set to YES (the default) Doxygen will prepend\n"
                 "the brief description of a member or function before the detailed description.\n"
                 "Note: if both HIDE_UNDOC_MEMBERS and BRIEF_MEMBER_DESC are set to NO, the\n"
                 "brief descriptions will be completely suppressed.",
                 TRUE
                );
  //----
  cl = cfg->addList(
                 "ABBREVIATE_BRIEF",
                 "This tag implements a quasi-intelligent brief description abbreviator\n"
                 "that is used to form the text in various listings. Each string\n"
                 "in this list, if found as the leading text of the brief description, will be\n"
                 "stripped from the text and the result after processing the whole list, is\n"
                 "used as the annotated text. Otherwise, the brief description is used as-is.\n"
                 "If left blank, the following values are used (\"$name\" is automatically\n"
                 "replaced with the name of the entity): \"The $name class\" \"The $name widget\"\n"
                 "\"The $name file\" \"is\" \"provides\" \"specifies\" \"contains\"\n"
                 "\"represents\" \"a\" \"an\" \"the\""
                );
  cl->addValue("The $name class");
  cl->addValue("The $name widget");
  cl->addValue("The $name file");
  cl->addValue("is");
  cl->addValue("provides");
  cl->addValue("specifies");
  cl->addValue("contains");
  cl->addValue("represents");
  cl->addValue("a");
  cl->addValue("an");
  cl->addValue("the");
  //----
  cb = cfg->addBool(
                 "ALWAYS_DETAILED_SEC",
                 "If the ALWAYS_DETAILED_SEC and REPEAT_BRIEF tags are both set to YES then\n"
                 "Doxygen will generate a detailed section even if there is only a brief\n"
                 "description.",
                 FALSE
                );
  //----
  cb = cfg->addBool(
                 "INLINE_INHERITED_MEMB",
                 "If the INLINE_INHERITED_MEMB tag is set to YES, doxygen will show all\n"
                 "inherited members of a class in the documentation of that class as if those\n"
                 "members were ordinary class members. Constructors, destructors and assignment\n"
                 "operators of the base classes will not be shown.",
                 FALSE
                );
  //----
  cb = cfg->addBool(
                 "FULL_PATH_NAMES",
                 "If the FULL_PATH_NAMES tag is set to YES then Doxygen will prepend the full\n"
                 "path before files name in the file list and in the header files. If set\n"
                 "to NO the shortest path that makes the file name unique will be used.",
                 TRUE
                );
  //----
  cl = cfg->addList(
                 "STRIP_FROM_PATH",
                 "If the FULL_PATH_NAMES tag is set to YES then the STRIP_FROM_PATH tag\n"
                 "can be used to strip a user-defined part of the path. Stripping is\n"
                 "only done if one of the specified strings matches the left-hand part of\n"
                 "the path. The tag can be used to show relative paths in the file list.\n"
                 "If left blank the directory from which doxygen is run is used as the\n"
                 "path to strip."
                );
  cl->addValue("");
  cl->addDependency("FULL_PATH_NAMES");
  //----
  cl = cfg->addList(
                 "STRIP_FROM_INC_PATH",
                 "The STRIP_FROM_INC_PATH tag can be used to strip a user-defined part of\n"
                 "the path mentioned in the documentation of a class, which tells\n"
                 "the reader which header file to include in order to use a class.\n"
                 "If left blank only the name of the header file containing the class\n"
                 "definition is used. Otherwise one should specify the include paths that\n"
                 "are normally passed to the compiler using the -I flag."
                );
  //----
  cb = cfg->addBool(
                 "SHORT_NAMES",
                 "If the SHORT_NAMES tag is set to YES, doxygen will generate much shorter\n"
                 "(but less readable) file names. This can be useful if your file system\n"
                 "doesn't support long names like on DOS, Mac, or CD-ROM.",
                 FALSE
                );
  //----
  cb = cfg->addBool(
                 "JAVADOC_AUTOBRIEF",
                 "If the JAVADOC_AUTOBRIEF tag is set to YES then Doxygen\n"
                 "will interpret the first line (until the first dot) of a JavaDoc-style\n"
                 "comment as the brief description. If set to NO, the JavaDoc\n"
                 "comments will behave just like regular Qt-style comments\n"
                 "(thus requiring an explicit @brief command for a brief description.)",
                 FALSE
                );
  //----
  cb = cfg->addBool(
                 "QT_AUTOBRIEF",
                 "If the QT_AUTOBRIEF tag is set to YES then Doxygen will\n"
                 "interpret the first line (until the first dot) of a Qt-style\n"
                 "comment as the brief description. If set to NO, the comments\n"
                 "will behave just like regular Qt-style comments (thus requiring\n"
                 "an explicit \\brief command for a brief description.)",
                 FALSE
                );
  //----
  cb = cfg->addBool(
                 "MULTILINE_CPP_IS_BRIEF",
                 "The MULTILINE_CPP_IS_BRIEF tag can be set to YES to make Doxygen\n"
                 "treat a multi-line C++ special comment block (i.e. a block of //! or ///\n"
                 "comments) as a brief description. This used to be the default behaviour.\n"
                 "The new default is to treat a multi-line C++ comment block as a detailed\n"
                 "description. Set this tag to YES if you prefer the old behaviour instead.",
                 FALSE
                );
  //----
  cb = cfg->addBool(
                 "INHERIT_DOCS",
                 "If the INHERIT_DOCS tag is set to YES (the default) then an undocumented\n"
                 "member inherits the documentation from any documented member that it\n"
                 "re-implements.",
                 TRUE
                );
  //----
  cb = cfg->addBool(
                 "SEPARATE_MEMBER_PAGES",
                 "If the SEPARATE_MEMBER_PAGES tag is set to YES, then doxygen will produce\n"
                 "a new page for each member. If set to NO, the documentation of a member will\n"
                 "be part of the file/class/namespace that contains it.",
                 FALSE
                );
  //----
  ci = cfg->addInt(
                 "TAB_SIZE",
                 "The TAB_SIZE tag can be used to set the number of spaces in a tab.\n"
                 "Doxygen uses this value to replace tabs by spaces in code fragments.",
                 1,16,8
                );
  //----
  cl = cfg->addList(
                 "ALIASES",
                 "This tag can be used to specify a number of aliases that acts\n"
                 "as commands in the documentation. An alias has the form \"name=value\".\n"
                 "For example adding \"sideeffect=\\par Side Effects:\\n\" will allow you to\n"
                 "put the command \\sideeffect (or @sideeffect) in the documentation, which\n"
                 "will result in a user-defined paragraph with heading \"Side Effects:\".\n"
                 "You can put \\n's in the value part of an alias to insert newlines."
                );
  //----
  cl = cfg->addList(
                 "TCL_SUBST",
                 "This tag can be used to specify a number of word-keyword mappings (TCL only).\n"
                 "A mapping has the form \"name=value\". For example adding\n"
                 "\"class=itcl::class\" will allow you to use the command class in the\n"
                 "itcl::class meaning."
                );
  //----
  cb = cfg->addBool(
                 "OPTIMIZE_OUTPUT_FOR_C",
                 "Set the OPTIMIZE_OUTPUT_FOR_C tag to YES if your project consists of C\n"
                 "sources only. Doxygen will then generate output that is more tailored for C.\n"
                 "For instance, some of the names that are used will be different. The list\n"
                 "of all members will be omitted, etc.",
                 FALSE
                );
  //----
  cb = cfg->addBool(
                 "OPTIMIZE_OUTPUT_JAVA",
                 "Set the OPTIMIZE_OUTPUT_JAVA tag to YES if your project consists of Java\n"
                 "sources only. Doxygen will then generate output that is more tailored for\n"
                 "Java. For instance, namespaces will be presented as packages, qualified\n"
                 "scopes will look different, etc.",
                 FALSE
                );
  //----
  cb = cfg->addBool(
                 "OPTIMIZE_FOR_FORTRAN",
                 "Set the OPTIMIZE_FOR_FORTRAN tag to YES if your project consists of Fortran\n"
                 "sources only. Doxygen will then generate output that is more tailored for\n"
                 "Fortran.",
                 FALSE
                );
  //----
  cb = cfg->addBool(
                 "OPTIMIZE_OUTPUT_VHDL",
                 "Set the OPTIMIZE_OUTPUT_VHDL tag to YES if your project consists of VHDL\n"
                 "sources. Doxygen will then generate output that is tailored for\n"
                 "VHDL.",
                 FALSE
                );
  //----
  cl = cfg->addList(
                 "EXTENSION_MAPPING",
                 "Doxygen selects the parser to use depending on the extension of the files it\n"
                 "parses. With this tag you can assign which parser to use for a given extension.\n"
                 "Doxygen has a built-in mapping, but you can override or extend it using this\n"
                 "tag. The format is ext=language, where ext is a file extension, and language\n"
                 "is one of the parsers supported by doxygen: IDL, Java, Javascript, CSharp, C,\n"
                 "C++, D, PHP, Objective-C, Python, Fortran, VHDL, C, C++. For instance to make\n"
                 "doxygen treat .inc files as Fortran files (default is PHP), and .f files as C\n"
                 "(default is Fortran), use: inc=Fortran f=C. Note that for custom extensions\n"
                 "you also need to set FILE_PATTERNS otherwise the files are not read by doxygen."
                );
  //----
  cb = cfg->addBool(
                 "MARKDOWN_SUPPORT",
                 "If MARKDOWN_SUPPORT is enabled (the default) then doxygen pre-processes all\n"
                 "comments according to the Markdown format, which allows for more readable\n"
                 "documentation. See http://daringfireball.net/projects/markdown/ for details.\n"
                 "The output of markdown processing is further processed by doxygen, so you\n"
                 "can mix doxygen, HTML, and XML commands with Markdown formatting.\n"
                 "Disable only in case of backward compatibilities issues.",
                 TRUE
                );
  //----
  cb = cfg->addBool(
                 "BUILTIN_STL_SUPPORT",
                 "If you use STL classes (i.e. std::string, std::vector, etc.) but do not want\n"
                 "to include (a tag file for) the STL sources as input, then you should\n"
                 "set this tag to YES in order to let doxygen match functions declarations and\n"
                 "definitions whose arguments contain STL classes (e.g. func(std::string); v.s.\n"
                 "func(std::string) {}). This also makes the inheritance and collaboration\n"
                 "diagrams that involve STL classes more complete and accurate.",
                 FALSE
                );
  //----
  cb = cfg->addBool(
                 "CPP_CLI_SUPPORT",
                 "If you use Microsoft's C++/CLI language, you should set this option to YES to\n"
                 "enable parsing support.",
                 FALSE
                );
  //----
  cb = cfg->addBool(
                 "SIP_SUPPORT",
                 "Set the SIP_SUPPORT tag to YES if your project consists of sip sources only.\n"
                 "Doxygen will parse them like normal C++ but will assume all classes use public\n"
                 "instead of private inheritance when no explicit protection keyword is present.",
                 FALSE
                );
  //----
  cb = cfg->addBool(
                 "IDL_PROPERTY_SUPPORT",
                 "For Microsoft's IDL there are propget and propput attributes to indicate getter\n"
                 "and setter methods for a property. Setting this option to YES (the default)\n"
                 "will make doxygen replace the get and set methods by a property in the\n"
                 "documentation. This will only work if the methods are indeed getting or\n"
                 "setting a simple type. If this is not the case, or you want to show the\n"
                 "methods anyway, you should set this option to NO.",
                 TRUE
                );
  //----
  cb = cfg->addBool(
                 "DISTRIBUTE_GROUP_DOC",
                 "If member grouping is used in the documentation and the DISTRIBUTE_GROUP_DOC\n"
                 "tag is set to YES, then doxygen will reuse the documentation of the first\n"
                 "member in the group (if any) for the other members of the group. By default\n"
                 "all members of a group must be documented explicitly.",
                 FALSE
                );
  //----
  cb = cfg->addBool(
                 "SUBGROUPING",
                 "Set the SUBGROUPING tag to YES (the default) to allow class member groups of\n"
                 "the same type (for instance a group of public functions) to be put as a\n"
                 "subgroup of that type (e.g. under the Public Functions section). Set it to\n"
                 "NO to prevent subgrouping. Alternatively, this can be done per class using\n"
                 "the \\nosubgrouping command.",
                 TRUE
                );
  //----
  cb = cfg->addBool(
                 "INLINE_GROUPED_CLASSES",
                 "When the INLINE_GROUPED_CLASSES tag is set to YES, classes, structs and\n"
                 "unions are shown inside the group in which they are included (e.g. using\n"
                 "@ingroup) instead of on a separate page (for HTML and Man pages) or\n"
                 "section (for LaTeX and RTF).",
                 FALSE
                );
  //----
  cb = cfg->addBool(
                 "INLINE_SIMPLE_STRUCTS",
                 "When the INLINE_SIMPLE_STRUCTS tag is set to YES, structs, classes, and\n"
                 "unions with only public data fields will be shown inline in the documentation\n"
                 "of the scope in which they are defined (i.e. file, namespace, or group\n"
                 "documentation), provided this scope is documented. If set to NO (the default),\n"
                 "structs, classes, and unions are shown on a separate page (for HTML and Man\n"
                 "pages) or section (for LaTeX and RTF).",
                 FALSE
                );
  //----
  cb = cfg->addBool(
                 "TYPEDEF_HIDES_STRUCT",
                 "When TYPEDEF_HIDES_STRUCT is enabled, a typedef of a struct, union, or enum\n"
                 "is documented as struct, union, or enum with the name of the typedef. So\n"
                 "typedef struct TypeS {} TypeT, will appear in the documentation as a struct\n"
                 "with name TypeT. When disabled the typedef will appear as a member of a file,\n"
                 "namespace, or class. And the struct will be named TypeS. This can typically\n"
                 "be useful for C code in case the coding convention dictates that all compound\n"
                 "types are typedef'ed and only the typedef is referenced, never the tag name.",
                 FALSE
                );
  //----
  ci = cfg->addInt(
                 "SYMBOL_CACHE_SIZE",
                 "The SYMBOL_CACHE_SIZE determines the size of the internal cache use to\n"
                 "determine which symbols to keep in memory and which to flush to disk.\n"
                 "When the cache is full, less often used symbols will be written to disk.\n"
                 "For small to medium size projects (<1000 input files) the default value is\n"
                 "probably good enough. For larger projects a too small cache size can cause\n"
                 "doxygen to be busy swapping symbols to and from disk most of the time\n"
                 "causing a significant performance penalty.\n"
                 "If the system has enough physical memory increasing the cache will improve the\n"
                 "performance by keeping more symbols in memory. Note that the value works on\n"
                 "a logarithmic scale so increasing the size by one will roughly double the\n"
                 "memory usage. The cache size is given by this formula:\n"
                 "2^(16+SYMBOL_CACHE_SIZE). The valid range is 0..9, the default is 0,\n"
                 "corresponding to a cache size of 2^16 = 65536 symbols.",
                 0,9,0
                );
  //----
  ci = cfg->addInt(
                 "LOOKUP_CACHE_SIZE",
                 "Similar to the SYMBOL_CACHE_SIZE the size of the symbol lookup cache can be\n"
                 "set using LOOKUP_CACHE_SIZE. This cache is used to resolve symbols given\n"
                 "their name and scope. Since this can be an expensive process and often the\n"
                 "same symbol appear multiple times in the code, doxygen keeps a cache of\n"
                 "pre-resolved symbols. If the cache is too small doxygen will become slower.\n"
                 "If the cache is too large, memory is wasted. The cache size is given by this\n"
                 "formula: 2^(16+LOOKUP_CACHE_SIZE). The valid range is 0..9, the default is 0,\n"
                 "corresponding to a cache size of 2^16 = 65536 symbols.",
                 0,9,0
                );
  //---------------------------------------------------------------------------
  cfg->addInfo("Build","Build related configuration options");
  //---------------------------------------------------------------------------

  //----
  cb = cfg->addBool(
                 "EXTRACT_ALL",
                 "If the EXTRACT_ALL tag is set to YES doxygen will assume all entities in\n"
                 "documentation are documented, even if no documentation was available.\n"
                 "Private class members and static file members will be hidden unless\n"
                 "the EXTRACT_PRIVATE and EXTRACT_STATIC tags are set to YES",
                 FALSE
                );
  //----
  cb = cfg->addBool(
                 "EXTRACT_PRIVATE",
                 "If the EXTRACT_PRIVATE tag is set to YES all private members of a class\n"
                 "will be included in the documentation.",
                 FALSE
                );
  //----
  cb = cfg->addBool(
                 "EXTRACT_PACKAGE",
                 "If the EXTRACT_PACKAGE tag is set to YES all members with package or internal scope will be included in the documentation.",
                 FALSE
                );
  //----
  cb = cfg->addBool(
                 "EXTRACT_STATIC",
                 "If the EXTRACT_STATIC tag is set to YES all static members of a file\n"
                 "will be included in the documentation.",
                 FALSE
                );
  //----
  cb = cfg->addBool(
                 "EXTRACT_LOCAL_CLASSES",
                 "If the EXTRACT_LOCAL_CLASSES tag is set to YES classes (and structs)\n"
                 "defined locally in source files will be included in the documentation.\n"
                 "If set to NO only classes defined in header files are included.",
                 TRUE
                );
  //----
  cb = cfg->addBool(
                 "EXTRACT_LOCAL_METHODS",
                 "This flag is only useful for Objective-C code. When set to YES local\n"
                 "methods, which are defined in the implementation section but not in\n"
                 "the interface are included in the documentation.\n"
                 "If set to NO (the default) only methods in the interface are included.",
                 FALSE
                );
  //----
  cb = cfg->addBool(
                 "EXTRACT_ANON_NSPACES",
                 "If this flag is set to YES, the members of anonymous namespaces will be\n"
                 "extracted and appear in the documentation as a namespace called\n"
                 "'anonymous_namespace{file}', where file will be replaced with the base\n"
                 "name of the file that contains the anonymous namespace. By default\n"
                 "anonymous namespaces are hidden.",
                 FALSE
                );
  //----
  cb = cfg->addBool(
                 "HIDE_UNDOC_MEMBERS",
                 "If the HIDE_UNDOC_MEMBERS tag is set to YES, Doxygen will hide all\n"
                 "undocumented members of documented classes, files or namespaces.\n"
                 "If set to NO (the default) these members will be included in the\n"
                 "various overviews, but no documentation section is generated.\n"
                 "This option has no effect if EXTRACT_ALL is enabled.",
                 FALSE
                );
  //----
  cb = cfg->addBool(
                 "HIDE_UNDOC_CLASSES",
                 "If the HIDE_UNDOC_CLASSES tag is set to YES, Doxygen will hide all\n"
                 "undocumented classes that are normally visible in the class hierarchy.\n"
                 "If set to NO (the default) these classes will be included in the various\n"
                 "overviews. This option has no effect if EXTRACT_ALL is enabled.",
                 FALSE
                );
  //----
  cb = cfg->addBool(
                 "HIDE_FRIEND_COMPOUNDS",
                 "If the HIDE_FRIEND_COMPOUNDS tag is set to YES, Doxygen will hide all\n"
                 "friend (class|struct|union) declarations.\n"
                 "If set to NO (the default) these declarations will be included in the\n"
                 "documentation.",
                 FALSE
                );
  //----
  cb = cfg->addBool(
                 "HIDE_IN_BODY_DOCS",
                 "If the HIDE_IN_BODY_DOCS tag is set to YES, Doxygen will hide any\n"
                 "documentation blocks found inside the body of a function.\n"
                 "If set to NO (the default) these blocks will be appended to the\n"
                 "function's detailed documentation block.",
                 FALSE
                );
  //----
  cb = cfg->addBool(
                 "INTERNAL_DOCS",
                 "The INTERNAL_DOCS tag determines if documentation\n"
                 "that is typed after a \\internal command is included. If the tag is set\n"
                 "to NO (the default) then the documentation will be excluded.\n"
                 "Set it to YES to include the internal documentation.",
                 FALSE
                );
  //----
  cb = cfg->addBool(
                 "CASE_SENSE_NAMES",
                 "If the CASE_SENSE_NAMES tag is set to NO then Doxygen will only generate\n"
                 "file names in lower-case letters. If set to YES upper-case letters are also\n"
                 "allowed. This is useful if you have classes or files whose names only differ\n"
                 "in case and if your file system supports case sensitive file names. Windows\n"
                 "and Mac users are advised to set this option to NO.",
                 portable_fileSystemIsCaseSensitive()
                );
  //----
  cb = cfg->addBool(
                 "HIDE_SCOPE_NAMES",
                 "If the HIDE_SCOPE_NAMES tag is set to NO (the default) then Doxygen\n"
                 "will show members with their full class and namespace scopes in the\n"
                 "documentation. If set to YES the scope will be hidden.",
                 FALSE
                );
  //----
  cb = cfg->addBool(
                 "SHOW_INCLUDE_FILES",
                 "If the SHOW_INCLUDE_FILES tag is set to YES (the default) then Doxygen\n"
                 "will put a list of the files that are included by a file in the documentation\n"
                 "of that file.",
                 TRUE
                );
  //----
  cb = cfg->addBool(
                 "FORCE_LOCAL_INCLUDES",
                 "If the FORCE_LOCAL_INCLUDES tag is set to YES then Doxygen\n"
                 "will list include files with double quotes in the documentation\n"
                 "rather than with sharp brackets.",
                 FALSE
                );
  //----
  cb = cfg->addBool(
                 "INLINE_INFO",
                 "If the INLINE_INFO tag is set to YES (the default) then a tag [inline]\n"
                 "is inserted in the documentation for inline members.",
                 TRUE
                );
  //----
  cb = cfg->addBool(
                 "SORT_MEMBER_DOCS",
                 "If the SORT_MEMBER_DOCS tag is set to YES (the default) then doxygen\n"
                 "will sort the (detailed) documentation of file and class members\n"
                 "alphabetically by member name. If set to NO the members will appear in\n"
                 "declaration order.",
                 TRUE
                );
  //----
  cb = cfg->addBool(
                 "SORT_BRIEF_DOCS",
                 "If the SORT_BRIEF_DOCS tag is set to YES then doxygen will sort the\n"
                 "brief documentation of file, namespace and class members alphabetically\n"
                 "by member name. If set to NO (the default) the members will appear in\n"
                 "declaration order.",
                 FALSE
                );
  //----
  cb = cfg->addBool(
                 "SORT_MEMBERS_CTORS_1ST",
                 "If the SORT_MEMBERS_CTORS_1ST tag is set to YES then doxygen\n"
                 "will sort the (brief and detailed) documentation of class members so that\n"
                 "constructors and destructors are listed first. If set to NO (the default)\n"
                 "the constructors will appear in the respective orders defined by\n"
                 "SORT_MEMBER_DOCS and SORT_BRIEF_DOCS.\n"
                 "This tag will be ignored for brief docs if SORT_BRIEF_DOCS is set to NO\n"
                 "and ignored for detailed docs if SORT_MEMBER_DOCS is set to NO.",
                 FALSE
                );
  //----
  cb = cfg->addBool(
                 "SORT_GROUP_NAMES",
                 "If the SORT_GROUP_NAMES tag is set to YES then doxygen will sort the\n"
                 "hierarchy of group names into alphabetical order. If set to NO (the default)\n"
                 "the group names will appear in their defined order.",
                 FALSE
                );
  //----
  cb = cfg->addBool(
                 "SORT_BY_SCOPE_NAME",
                 "If the SORT_BY_SCOPE_NAME tag is set to YES, the class list will be\n"
                 "sorted by fully-qualified names, including namespaces. If set to\n"
                 "NO (the default), the class list will be sorted only by class name,\n"
                 "not including the namespace part.\n"
                 "Note: This option is not very useful if HIDE_SCOPE_NAMES is set to YES.\n"
                 "Note: This option applies only to the class list, not to the\n"
                 "alphabetical list.",
                 FALSE
                );
  //----
  cb = cfg->addBool(
                 "STRICT_PROTO_MATCHING",
                 "If the STRICT_PROTO_MATCHING option is enabled and doxygen fails to\n"
                 "do proper type resolution of all parameters of a function it will reject a\n"
                 "match between the prototype and the implementation of a member function even\n"
                 "if there is only one candidate or it is obvious which candidate to choose\n"
                 "by doing a simple string match. By disabling STRICT_PROTO_MATCHING doxygen\n"
                 "will still accept a match between prototype and implementation in such cases.",
                 FALSE
                );
  //----
  cb = cfg->addBool(
                 "GENERATE_TODOLIST",
                 "The GENERATE_TODOLIST tag can be used to enable (YES) or\n"
                 "disable (NO) the todo list. This list is created by putting \\todo\n"
                 "commands in the documentation.",
                 TRUE
                );
  //----
  cb = cfg->addBool(
                 "GENERATE_TESTLIST",
                 "The GENERATE_TESTLIST tag can be used to enable (YES) or\n"
                 "disable (NO) the test list. This list is created by putting \\test\n"
                 "commands in the documentation.",
                 TRUE
                );
  //----
  cb = cfg->addBool(
                 "GENERATE_BUGLIST",
                 "The GENERATE_BUGLIST tag can be used to enable (YES) or\n"
                 "disable (NO) the bug list. This list is created by putting \\bug\n"
                 "commands in the documentation.",
                 TRUE
                );
  //----
  cb = cfg->addBool(
                 "GENERATE_DEPRECATEDLIST",
                 "The GENERATE_DEPRECATEDLIST tag can be used to enable (YES) or\n"
                 "disable (NO) the deprecated list. This list is created by putting\n"
                 "\\deprecated commands in the documentation.",
                 TRUE
                );
  //----
  cl = cfg->addList(
                 "ENABLED_SECTIONS",
                 "The ENABLED_SECTIONS tag can be used to enable conditional\n"
                 "documentation sections, marked by \\if sectionname ... \\endif."
                );
  //----
  ci = cfg->addInt(
                 "MAX_INITIALIZER_LINES",
                 "The MAX_INITIALIZER_LINES tag determines the maximum number of lines\n"
                 "the initial value of a variable or macro consists of for it to appear in\n"
                 "the documentation. If the initializer consists of more lines than specified\n"
                 "here it will be hidden. Use a value of 0 to hide initializers completely.\n"
                 "The appearance of the initializer of individual variables and macros in the\n"
                 "documentation can be controlled using \\showinitializer or \\hideinitializer\n"
                 "command in the documentation regardless of this setting.",
                 0,10000,30
                );
  //----
  cb = cfg->addBool(
                 "SHOW_USED_FILES",
                 "Set the SHOW_USED_FILES tag to NO to disable the list of files generated\n"
                 "at the bottom of the documentation of classes and structs. If set to YES the\n"
                 "list will mention the files that were used to generate the documentation.",
                 TRUE
                );
  //----
  cb = cfg->addBool(
                 "SHOW_FILES",
                 "Set the SHOW_FILES tag to NO to disable the generation of the Files page.\n"
                 "This will remove the Files entry from the Quick Index and from the\n"
                 "Folder Tree View (if specified). The default is YES.",
                 TRUE
                );
  //----
  cb = cfg->addBool(
                 "SHOW_NAMESPACES",
                 "Set the SHOW_NAMESPACES tag to NO to disable the generation of the\n"
                 "Namespaces page.\n"
                 "This will remove the Namespaces entry from the Quick Index\n"
                 "and from the Folder Tree View (if specified). The default is YES.",
                 TRUE
                );
  //----
  cs = cfg->addString(
                 "FILE_VERSION_FILTER",
                 "The FILE_VERSION_FILTER tag can be used to specify a program or script that\n"
                 "doxygen should invoke to get the current version for each file (typically from\n"
                 "the version control system). Doxygen will invoke the program by executing (via\n"
                 "popen()) the command <command> <input-file>, where <command> is the value of\n"
                 "the FILE_VERSION_FILTER tag, and <input-file> is the name of an input file\n"
                 "provided by doxygen. Whatever the program writes to standard output\n"
                 "is used as the file version. See the manual for examples."
                );
  cs->setWidgetType(ConfigString::File);
  //----
  cs = cfg->addString(
                 "LAYOUT_FILE",
                 "The LAYOUT_FILE tag can be used to specify a layout file which will be parsed\n"
                 "by doxygen. The layout file controls the global structure of the generated\n"
                 "output files in an output format independent way. To create the layout file\n"
                 "that represents doxygen's defaults, run doxygen with the -l option.\n"
                 "You can optionally specify a file name after the option, if omitted\n"
                 "DoxygenLayout.xml will be used as the name of the layout file."
                );
  cs->setWidgetType(ConfigString::File);
  //----
  cl = cfg->addList(
                 "CITE_BIB_FILES",
                 "The CITE_BIB_FILES tag can be used to specify one or more bib files\n"
                 "containing the references data. This must be a list of .bib files. The\n"
                 ".bib extension is automatically appended if omitted. Using this command\n"
                 "requires the bibtex tool to be installed. See also\n"
                 "http://en.wikipedia.org/wiki/BibTeX for more info. For LaTeX the style\n"
                 "of the bibliography can be controlled using LATEX_BIB_STYLE. To use this\n"
                 "feature you need bibtex and perl available in the search path."
                );
  cl->setWidgetType(ConfigList::File);
  //---------------------------------------------------------------------------
  cfg->addInfo("Messages","configuration options related to warning and progress messages");
  //---------------------------------------------------------------------------

  //----
  cb = cfg->addBool(
                 "QUIET",
                 "The QUIET tag can be used to turn on/off the messages that are generated\n"
                 "by doxygen. Possible values are YES and NO. If left blank NO is used.",
                 FALSE
                );
  //----
  cb = cfg->addBool(
                 "WARNINGS",
                 "The WARNINGS tag can be used to turn on/off the warning messages that are\n"
                 "generated by doxygen. Possible values are YES and NO. If left blank\n"
                 "NO is used.",
                 TRUE
                );
  //----
  cb = cfg->addBool(
                 "WARN_IF_UNDOCUMENTED",
                 "If WARN_IF_UNDOCUMENTED is set to YES, then doxygen will generate warnings\n"
                 "for undocumented members. If EXTRACT_ALL is set to YES then this flag will\n"
                 "automatically be disabled.",
                 TRUE
                );
  //----
  cb = cfg->addBool(
                 "WARN_IF_DOC_ERROR",
                 "If WARN_IF_DOC_ERROR is set to YES, doxygen will generate warnings for\n"
                 "potential errors in the documentation, such as not documenting some\n"
                 "parameters in a documented function, or documenting parameters that\n"
                 "don't exist or using markup commands wrongly.",
                 TRUE
                );
  //----
  cb = cfg->addBool(
                 "WARN_NO_PARAMDOC",
                 "The WARN_NO_PARAMDOC option can be enabled to get warnings for\n"
                 "functions that are documented, but have no documentation for their parameters\n"
                 "or return value. If set to NO (the default) doxygen will only warn about\n"
                 "wrong or incomplete parameter documentation, but not about the absence of\n"
                 "documentation.",
                 FALSE
                );
  //----
  cs = cfg->addString(
                 "WARN_FORMAT",
                 "The WARN_FORMAT tag determines the format of the warning messages that\n"
                 "doxygen can produce. The string should contain the $file, $line, and $text\n"
                 "tags, which will be replaced by the file and line number from which the\n"
                 "warning originated and the warning text. Optionally the format may contain\n"
                 "$version, which will be replaced by the version of the file (if it could\n"
                 "be obtained via FILE_VERSION_FILTER)"
                );
  cs->setDefaultValue("$file:$line: $text");
  //----
  cs = cfg->addString(
                 "WARN_LOGFILE",
                 "The WARN_LOGFILE tag can be used to specify a file to which warning\n"
                 "and error messages should be written. If left blank the output is written\n"
                 "to stderr."
                );
  cs->setWidgetType(ConfigString::File);
  //---------------------------------------------------------------------------
  cfg->addInfo("Input","configuration options related to the input files");
  //---------------------------------------------------------------------------

  //----
  cl = cfg->addList(
                 "INPUT",
                 "The INPUT tag can be used to specify the files and/or directories that contain\n"
                 "documented source files. You may enter file names like \"myfile.cpp\" or\n"
                 "directories like \"/usr/src/myproject\". Separate the files or directories\n"
                 "with spaces."
                );
  cl->addValue("");
  cl->setWidgetType(ConfigList::FileAndDir);
  //----
  cs = cfg->addString(
                 "INPUT_ENCODING",
                 "This tag can be used to specify the character encoding of the source files\n"
                 "that doxygen parses. Internally doxygen uses the UTF-8 encoding, which is\n"
                 "also the default input encoding. Doxygen uses libiconv (or the iconv built\n"
                 "into libc) for the transcoding. See http://www.gnu.org/software/libiconv for\n"
                 "the list of possible encodings."
                );
  cs->setDefaultValue("UTF-8");
  //----
  cl = cfg->addList(
                 "FILE_PATTERNS",
                 "If the value of the INPUT tag contains directories, you can use the\n"
                 "FILE_PATTERNS tag to specify one or more wildcard pattern (like *.cpp\n"
                 "and *.h) to filter out the source-files in the directories. If left\n"
                 "blank the following patterns are tested:\n"
                 "*.c *.cc *.cxx *.cpp *.c++ *.d *.java *.ii *.ixx *.ipp *.i++ *.inl *.h *.hh\n"
                 "*.hxx *.hpp *.h++ *.idl *.odl *.cs *.php *.php3 *.inc *.m *.mm *.dox *.py\n"
                 "*.f90 *.f *.for *.vhd *.vhdl"
                );
  cl->addValue("*.c");
  cl->addValue("*.cc");
  cl->addValue("*.cxx");
  cl->addValue("*.cpp");
  cl->addValue("*.c++");
  cl->addValue("*.d");
  cl->addValue("*.java");
  cl->addValue("*.ii");
  cl->addValue("*.ixx");
  cl->addValue("*.ipp");
  cl->addValue("*.i++");
  cl->addValue("*.inl");
  cl->addValue("*.h");
  cl->addValue("*.hh");
  cl->addValue("*.hxx");
  cl->addValue("*.hpp");
  cl->addValue("*.h++");
  cl->addValue("*.idl");
  cl->addValue("*.odl");
  cl->addValue("*.cs");
  cl->addValue("*.php");
  cl->addValue("*.php3");
  cl->addValue("*.inc");
  cl->addValue("*.m");
  cl->addValue("*.markdown");
  cl->addValue("*.md");
  cl->addValue("*.mm");
  cl->addValue("*.dox");
  cl->addValue("*.py");
  cl->addValue("*.f90");
  cl->addValue("*.f");
  cl->addValue("*.for");
  cl->addValue("*.vhd");
  cl->addValue("*.vhdl");
  //----
  cb = cfg->addBool(
                 "RECURSIVE",
                 "The RECURSIVE tag can be used to turn specify whether or not subdirectories\n"
                 "should be searched for input files as well. Possible values are YES and NO.\n"
                 "If left blank NO is used.",
                 FALSE
                );
  //----
  cl = cfg->addList(
                 "EXCLUDE",
                 "The EXCLUDE tag can be used to specify files and/or directories that should be\n"
                 "excluded from the INPUT source files. This way you can easily exclude a\n"
                 "subdirectory from a directory tree whose root is specified with the INPUT tag.\n"
                 "Note that relative paths are relative to the directory from which doxygen is\n"
                 "run."
                );
  cl->setWidgetType(ConfigList::FileAndDir);
  //----
  cb = cfg->addBool(
                 "EXCLUDE_SYMLINKS",
                 "The EXCLUDE_SYMLINKS tag can be used to select whether or not files or\n"
                 "directories that are symbolic links (a Unix file system feature) are excluded\n"
                 "from the input.",
                 FALSE
                );
  //----
  cl = cfg->addList(
                 "EXCLUDE_PATTERNS",
                 "If the value of the INPUT tag contains directories, you can use the\n"
                 "EXCLUDE_PATTERNS tag to specify one or more wildcard patterns to exclude\n"
                 "certain files from those directories. Note that the wildcards are matched\n"
                 "against the file with absolute path, so to exclude all test directories\n"
                 "for example use the pattern */test/*"
                );
  //----
  cl = cfg->addList(
                 "EXCLUDE_SYMBOLS",
                 "The EXCLUDE_SYMBOLS tag can be used to specify one or more symbol names\n"
                 "(namespaces, classes, functions, etc.) that should be excluded from the\n"
                 "output. The symbol name can be a fully qualified name, a word, or if the\n"
                 "wildcard * is used, a substring. Examples: ANamespace, AClass,\n"
                 "AClass::ANamespace, ANamespace::*Test"
                );
  //----
  cl = cfg->addList(
                 "EXAMPLE_PATH",
                 "The EXAMPLE_PATH tag can be used to specify one or more files or\n"
                 "directories that contain example code fragments that are included (see\n"
                 "the \\include command)."
                );
  cl->setWidgetType(ConfigList::Dir);
  //----
  cl = cfg->addList(
                 "EXAMPLE_PATTERNS",
                 "If the value of the EXAMPLE_PATH tag contains directories, you can use the\n"
                 "EXAMPLE_PATTERNS tag to specify one or more wildcard pattern (like *.cpp\n"
                 "and *.h) to filter out the source-files in the directories. If left\n"
                 "blank all files are included."
                );
  cl->addValue("*");
  //----
  cb = cfg->addBool(
                 "EXAMPLE_RECURSIVE",
                 "If the EXAMPLE_RECURSIVE tag is set to YES then subdirectories will be\n"
                 "searched for input files to be used with the \\include or \\dontinclude\n"
                 "commands irrespective of the value of the RECURSIVE tag.\n"
                 "Possible values are YES and NO. If left blank NO is used.",
                 FALSE
                );
  //----
  cl = cfg->addList(
                 "IMAGE_PATH",
                 "The IMAGE_PATH tag can be used to specify one or more files or\n"
                 "directories that contain image that are included in the documentation (see\n"
                 "the \\image command)."
                );
  cl->setWidgetType(ConfigList::Dir);
  //----
  cs = cfg->addString(
                 "INPUT_FILTER",
                 "The INPUT_FILTER tag can be used to specify a program that doxygen should\n"
                 "invoke to filter for each input file. Doxygen will invoke the filter program\n"
                 "by executing (via popen()) the command <filter> <input-file>, where <filter>\n"
                 "is the value of the INPUT_FILTER tag, and <input-file> is the name of an\n"
                 "input file. Doxygen will then use the output that the filter program writes\n"
                 "to standard output.\n"
                 "If FILTER_PATTERNS is specified, this tag will be\n"
                 "ignored."
                );
  cs->setWidgetType(ConfigString::File);
  //----
  cl = cfg->addList(
                 "FILTER_PATTERNS",
                 "The FILTER_PATTERNS tag can be used to specify filters on a per file pattern\n"
                 "basis.\n"
                 "Doxygen will compare the file name with each pattern and apply the\n"
                 "filter if there is a match.\n"
                 "The filters are a list of the form:\n"
                 "pattern=filter (like *.cpp=my_cpp_filter). See INPUT_FILTER for further\n"
                 "info on how filters are used. If FILTER_PATTERNS is empty or if\n"
                 "non of the patterns match the file name, INPUT_FILTER is applied."
                );
  //----
  cb = cfg->addBool(
                 "FILTER_SOURCE_FILES",
                 "If the FILTER_SOURCE_FILES tag is set to YES, the input filter (if set using\n"
                 "INPUT_FILTER) will be used to filter the input files when producing source\n"
                 "files to browse (i.e. when SOURCE_BROWSER is set to YES).",
                 FALSE
                );
  //----
  cl = cfg->addList(
                 "FILTER_SOURCE_PATTERNS",
                 "The FILTER_SOURCE_PATTERNS tag can be used to specify source filters per file\n"
                 "pattern. A pattern will override the setting for FILTER_PATTERN (if any)\n"
                 "and it is also possible to disable source filtering for a specific pattern\n"
                 "using *.ext= (so without naming a filter). This option only has effect when\n"
                 "FILTER_SOURCE_FILES is enabled."
                );
  cl->addDependency("FILTER_SOURCE_FILES");
  //---------------------------------------------------------------------------
  cfg->addInfo("Source Browser","configuration options related to source browsing");
  //---------------------------------------------------------------------------

  //----
  cb = cfg->addBool(
                 "SOURCE_BROWSER",
                 "If the SOURCE_BROWSER tag is set to YES then a list of source files will\n"
                 "be generated. Documented entities will be cross-referenced with these sources.\n"
                 "Note: To get rid of all source code in the generated output, make sure also\n"
                 "VERBATIM_HEADERS is set to NO.",
                 FALSE
                );
  //----
  cb = cfg->addBool(
                 "INLINE_SOURCES",
                 "Setting the INLINE_SOURCES tag to YES will include the body\n"
                 "of functions and classes directly in the documentation.",
                 FALSE
                );
  //----
  cb = cfg->addBool(
                 "STRIP_CODE_COMMENTS",
                 "Setting the STRIP_CODE_COMMENTS tag to YES (the default) will instruct\n"
                 "doxygen to hide any special comment blocks from generated source code\n"
                 "fragments. Normal C, C++ and Fortran comments will always remain visible.",
                 TRUE
                );
  //----
  cb = cfg->addBool(
                 "REFERENCED_BY_RELATION",
                 "If the REFERENCED_BY_RELATION tag is set to YES\n"
                 "then for each documented function all documented\n"
                 "functions referencing it will be listed.",
                 FALSE
                );
  //----
  cb = cfg->addBool(
                 "REFERENCES_RELATION",
                 "If the REFERENCES_RELATION tag is set to YES\n"
                 "then for each documented function all documented entities\n"
                 "called/used by that function will be listed.",
                 FALSE
                );
  //----
  cb = cfg->addBool(
                 "REFERENCES_LINK_SOURCE",
                 "If the REFERENCES_LINK_SOURCE tag is set to YES (the default)\n"
                 "and SOURCE_BROWSER tag is set to YES, then the hyperlinks from\n"
                 "functions in REFERENCES_RELATION and REFERENCED_BY_RELATION lists will\n"
                 "link to the source code.\n"
                 "Otherwise they will link to the documentation.",
                 TRUE
                );
  //----
  cb = cfg->addBool(
                 "USE_HTAGS",
                 "If the USE_HTAGS tag is set to YES then the references to source code\n"
                 "will point to the HTML generated by the htags(1) tool instead of doxygen\n"
                 "built-in source browser. The htags tool is part of GNU's global source\n"
                 "tagging system (see http://www.gnu.org/software/global/global.html). You\n"
                 "will need version 4.8.6 or higher.",
                 FALSE
                );
  cb->addDependency("SOURCE_BROWSER");
  //----
  cb = cfg->addBool(
                 "VERBATIM_HEADERS",
                 "If the VERBATIM_HEADERS tag is set to YES (the default) then Doxygen\n"
                 "will generate a verbatim copy of the header file for each class for\n"
                 "which an include is specified. Set to NO to disable this.",
                 TRUE
                );
  //---------------------------------------------------------------------------
  cfg->addInfo("Index","configuration options related to the alphabetical class index");
  //---------------------------------------------------------------------------

  //----
  cb = cfg->addBool(
                 "ALPHABETICAL_INDEX",
                 "If the ALPHABETICAL_INDEX tag is set to YES, an alphabetical index\n"
                 "of all compounds will be generated. Enable this if the project\n"
                 "contains a lot of classes, structs, unions or interfaces.",
                 TRUE
                );
  //----
  ci = cfg->addInt(
                 "COLS_IN_ALPHA_INDEX",
                 "If the alphabetical index is enabled (see ALPHABETICAL_INDEX) then\n"
                 "the COLS_IN_ALPHA_INDEX tag can be used to specify the number of columns\n"
                 "in which this list will be split (can be a number in the range [1..20])",
                 1,20,5
                );
  //----
  cl = cfg->addList(
                 "IGNORE_PREFIX",
                 "In case all classes in a project start with a common prefix, all\n"
                 "classes will be put under the same header in the alphabetical index.\n"
                 "The IGNORE_PREFIX tag can be used to specify one or more prefixes that\n"
                 "should be ignored while generating the index headers."
                );
  //---------------------------------------------------------------------------
  cfg->addInfo("HTML","configuration options related to the HTML output");
  //---------------------------------------------------------------------------

  //----
  cb = cfg->addBool(
                 "GENERATE_HTML",
                 "If the GENERATE_HTML tag is set to YES (the default) Doxygen will\n"
                 "generate HTML output.",
                 TRUE
                );
  //----
  cs = cfg->addString(
                 "HTML_OUTPUT",
                 "The HTML_OUTPUT tag is used to specify where the HTML docs will be put.\n"
                 "If a relative path is entered the value of OUTPUT_DIRECTORY will be\n"
                 "put in front of it. If left blank `html' will be used as the default path."
                );
  cs->setDefaultValue("html");
  cs->setWidgetType(ConfigString::Dir);
  cs->addDependency("GENERATE_HTML");
  //----
  cs = cfg->addString(
                 "HTML_FILE_EXTENSION",
                 "The HTML_FILE_EXTENSION tag can be used to specify the file extension for\n"
                 "each generated HTML page (for example: .htm,.php,.asp). If it is left blank\n"
                 "doxygen will generate files with .html extension."
                );
  cs->setDefaultValue(".html");
  cs->addDependency("GENERATE_HTML");
  //----
  cs = cfg->addString(
                 "HTML_HEADER",
                 "The HTML_HEADER tag can be used to specify a personal HTML header for\n"
                 "each generated HTML page. If it is left blank doxygen will generate a\n"
                 "standard header. Note that when using a custom header you are responsible\n"
                 " for the proper inclusion of any scripts and style sheets that doxygen\n"
                 "needs, which is dependent on the configuration options used.\n"
                 "It is advised to generate a default header using \"doxygen -w html\n"
                 "header.html footer.html stylesheet.css YourConfigFile\" and then modify\n"
                 "that header. Note that the header is subject to change so you typically\n"
                 "have to redo this when upgrading to a newer version of doxygen or when\n"
                 "changing the value of configuration settings such as GENERATE_TREEVIEW!"
                );
  cs->setWidgetType(ConfigString::File);
  cs->addDependency("GENERATE_HTML");
  //----
  cs = cfg->addString(
                 "HTML_FOOTER",
                 "The HTML_FOOTER tag can be used to specify a personal HTML footer for\n"
                 "each generated HTML page. If it is left blank doxygen will generate a\n"
                 "standard footer."
                );
  cs->setWidgetType(ConfigString::File);
  cs->addDependency("GENERATE_HTML");
  //----
  cs = cfg->addString(
                 "HTML_STYLESHEET",
                 "The HTML_STYLESHEET tag can be used to specify a user-defined cascading\n"
                 "style sheet that is used by each HTML page. It can be used to\n"
                 "fine-tune the look of the HTML output. If the tag is left blank doxygen\n"
                 "will generate a default style sheet. Note that doxygen will try to copy\n"
                 "the style sheet file to the HTML output directory, so don't put your own\n"
                 "style sheet in the HTML output directory as well, or it will be erased!"
                );
  cs->setWidgetType(ConfigString::File);
  cs->addDependency("GENERATE_HTML");
  //----
  cl = cfg->addList(
                 "HTML_EXTRA_FILES",
                 "The HTML_EXTRA_FILES tag can be used to specify one or more extra images or\n"
                 "other source files which should be copied to the HTML output directory. Note\n"
                 "that these files will be copied to the base HTML output directory. Use the\n"
                 "$relpath$ marker in the HTML_HEADER and/or HTML_FOOTER files to load these\n"
                 "files. In the HTML_STYLESHEET file, use the file name only. Also note that\n"
                 "the files will be copied as-is; there are no commands or markers available."
                );
  cl->addDependency("GENERATE_HTML");
  cl->setWidgetType(ConfigList::File);
  //----
  ci = cfg->addInt(
                 "HTML_COLORSTYLE_HUE",
                 "The HTML_COLORSTYLE_HUE tag controls the color of the HTML output.\n"
                 "Doxygen will adjust the colors in the style sheet and background images\n"
                 "according to this color. Hue is specified as an angle on a colorwheel,\n"
                 "see http://en.wikipedia.org/wiki/Hue for more information.\n"
                 "For instance the value 0 represents red, 60 is yellow, 120 is green,\n"
                 "180 is cyan, 240 is blue, 300 purple, and 360 is red again.\n"
                 "The allowed range is 0 to 359.",
                 0,359,220
                );
  ci->addDependency("GENERATE_HTML");
  //----
  ci = cfg->addInt(
                 "HTML_COLORSTYLE_SAT",
                 "The HTML_COLORSTYLE_SAT tag controls the purity (or saturation) of\n"
                 "the colors in the HTML output. For a value of 0 the output will use\n"
                 "grayscales only. A value of 255 will produce the most vivid colors.",
                 0,255,100
                );
  ci->addDependency("GENERATE_HTML");
  //----
  ci = cfg->addInt(
                 "HTML_COLORSTYLE_GAMMA",
                 "The HTML_COLORSTYLE_GAMMA tag controls the gamma correction applied to\n"
                 "the luminance component of the colors in the HTML output. Values below\n"
                 "100 gradually make the output lighter, whereas values above 100 make\n"
                 "the output darker. The value divided by 100 is the actual gamma applied,\n"
                 "so 80 represents a gamma of 0.8, The value 220 represents a gamma of 2.2,\n"
                 "and 100 does not change the gamma.",
                 40,240,80
                );
  //----
  cb = cfg->addBool(
                 "HTML_TIMESTAMP",
                 "If the HTML_TIMESTAMP tag is set to YES then the footer of each generated HTML\n"
                 "page will contain the date and time when the page was generated. Setting\n"
                 "this to NO can help when comparing the output of multiple runs.",
                 TRUE
                );
  cb->addDependency("GENERATE_HTML");
  //----
  cb = cfg->addBool(
                 "HTML_DYNAMIC_SECTIONS",
                 "If the HTML_DYNAMIC_SECTIONS tag is set to YES then the generated HTML\n"
                 "documentation will contain sections that can be hidden and shown after the\n"
                 "page has loaded.",
                 FALSE
                );
  cb->addDependency("GENERATE_HTML");
  //----
  ci = cfg->addInt(
                 "HTML_INDEX_NUM_ENTRIES",
                 "With HTML_INDEX_NUM_ENTRIES one can control the preferred number of\n"
                 "entries shown in the various tree structured indices initially; the user\n"
                 "can expand and collapse entries dynamically later on. Doxygen will expand\n"
                 "the tree to such a level that at most the specified number of entries are\n"
                 "visible (unless a fully collapsed tree already exceeds this amount).\n"
                 "So setting the number of entries 1 will produce a full collapsed tree by\n"
                 "default. 0 is a special value representing an infinite number of entries\n"
                 "and will result in a full expanded tree by default.",
                 0,9999,100
                );
  //----
  cb = cfg->addBool(
                 "GENERATE_DOCSET",
                 "If the GENERATE_DOCSET tag is set to YES, additional index files\n"
                 "will be generated that can be used as input for Apple's Xcode 3\n"
                 "integrated development environment, introduced with OSX 10.5 (Leopard).\n"
                 "To create a documentation set, doxygen will generate a Makefile in the\n"
                 "HTML output directory. Running make will produce the docset in that\n"
                 "directory and running \"make install\" will install the docset in\n"
                 "~/Library/Developer/Shared/Documentation/DocSets so that Xcode will find\n"
                 "it at startup.\n"
                 "See http://developer.apple.com/tools/creatingdocsetswithdoxygen.html\n"
                 "for more information.",
                 FALSE
                );
  cb->addDependency("GENERATE_HTML");
  //----
  cs = cfg->addString(
                 "DOCSET_FEEDNAME",
                 "When GENERATE_DOCSET tag is set to YES, this tag determines the name of the\n"
                 "feed. A documentation feed provides an umbrella under which multiple\n"
                 "documentation sets from a single provider (such as a company or product suite)\n"
                 "can be grouped."
                );
  cs->setDefaultValue("Doxygen generated docs");
  cs->addDependency("GENERATE_DOCSET");
  //----
  cs = cfg->addString(
                 "DOCSET_BUNDLE_ID",
                 "When GENERATE_DOCSET tag is set to YES, this tag specifies a string that\n"
                 "should uniquely identify the documentation set bundle. This should be a\n"
                 "reverse domain-name style string, e.g. com.mycompany.MyDocSet. Doxygen\n"
                 "will append .docset to the name."
                );
  cs->setDefaultValue("org.doxygen.Project");
  cs->addDependency("GENERATE_DOCSET");
  //----
  cs = cfg->addString(
                 "DOCSET_PUBLISHER_ID",
                 "When GENERATE_PUBLISHER_ID tag specifies a string that should uniquely identify\n"
                 "the documentation publisher. This should be a reverse domain-name style\n"
                 "string, e.g. com.mycompany.MyDocSet.documentation."
                );
  cs->setDefaultValue("org.doxygen.Publisher");
  cs->addDependency("GENERATE_DOCSET");
  //----
  cs = cfg->addString(
                 "DOCSET_PUBLISHER_NAME",
                 "The GENERATE_PUBLISHER_NAME tag identifies the documentation publisher."
                );
  cs->setDefaultValue("Publisher");
  cs->addDependency("GENERATE_DOCSET");
  //----
  cb = cfg->addBool(
                 "GENERATE_HTMLHELP",
                 "If the GENERATE_HTMLHELP tag is set to YES, additional index files\n"
                 "will be generated that can be used as input for tools like the\n"
                 "Microsoft HTML help workshop to generate a compiled HTML help file (.chm)\n"
                 "of the generated HTML documentation.",
                 FALSE
                );
  cb->addDependency("GENERATE_HTML");
  //----
  cs = cfg->addString(
                 "CHM_FILE",
                 "If the GENERATE_HTMLHELP tag is set to YES, the CHM_FILE tag can\n"
                 "be used to specify the file name of the resulting .chm file. You\n"
                 "can add a path in front of the file if the result should not be\n"
                 "written to the html output directory."
                );
  cs->setWidgetType(ConfigString::File);
  cs->addDependency("GENERATE_HTMLHELP");
  //----
  cs = cfg->addString(
                 "HHC_LOCATION",
                 "If the GENERATE_HTMLHELP tag is set to YES, the HHC_LOCATION tag can\n"
                 "be used to specify the location (absolute path including file name) of\n"
                 "the HTML help compiler (hhc.exe). If non-empty doxygen will try to run\n"
                 "the HTML help compiler on the generated index.hhp."
                );
  cs->setWidgetType(ConfigString::File);
  cs->addDependency("GENERATE_HTMLHELP");
  //----
  cb = cfg->addBool(
                 "GENERATE_CHI",
                 "If the GENERATE_HTMLHELP tag is set to YES, the GENERATE_CHI flag\n"
                 "controls if a separate .chi index file is generated (YES) or that\n"
                 "it should be included in the master .chm file (NO).",
                 FALSE
                );
  cb->addDependency("GENERATE_HTMLHELP");
  //----
  cs = cfg->addString(
                 "CHM_INDEX_ENCODING",
                 "If the GENERATE_HTMLHELP tag is set to YES, the CHM_INDEX_ENCODING\n"
                 "is used to encode HtmlHelp index (hhk), content (hhc) and project file\n"
                 "content."
                );
  cs->addDependency("GENERATE_HTMLHELP");
  //----
  cb = cfg->addBool(
                 "BINARY_TOC",
                 "If the GENERATE_HTMLHELP tag is set to YES, the BINARY_TOC flag\n"
                 "controls whether a binary table of contents is generated (YES) or a\n"
                 "normal table of contents (NO) in the .chm file.",
                 FALSE
                );
  cb->addDependency("GENERATE_HTMLHELP");
  //----
  cb = cfg->addBool(
                 "TOC_EXPAND",
                 "The TOC_EXPAND flag can be set to YES to add extra items for group members\n"
                 "to the contents of the HTML help documentation and to the tree view.",
                 FALSE
                );
  cb->addDependency("GENERATE_HTMLHELP");
  //----
  cb = cfg->addBool(
                 "GENERATE_QHP",
                 "If the GENERATE_QHP tag is set to YES and both QHP_NAMESPACE and\n"
                 "QHP_VIRTUAL_FOLDER are set, an additional index file will be generated\n"
                 "that can be used as input for Qt's qhelpgenerator to generate a\n"
                 "Qt Compressed Help (.qch) of the generated HTML documentation.",
                 FALSE
                );
  cb->addDependency("GENERATE_HTML");
  //----
  cs = cfg->addString(
                 "QCH_FILE",
                 "If the QHG_LOCATION tag is specified, the QCH_FILE tag can\n"
                 "be used to specify the file name of the resulting .qch file.\n"
                 "The path specified is relative to the HTML output folder."
                );
  cs->setWidgetType(ConfigString::File);
  cs->addDependency("GENERATE_QHP");
  //----
  cs = cfg->addString(
                 "QHP_NAMESPACE",
                 "The QHP_NAMESPACE tag specifies the namespace to use when generating\n"
                 "Qt Help Project output. For more information please see\n"
                 "http://doc.trolltech.com/qthelpproject.html#namespace"
                );
  cs->setDefaultValue("org.doxygen.Project");
  cs->addDependency("GENERATE_QHP");
  //----
  cs = cfg->addString(
                 "QHP_VIRTUAL_FOLDER",
                 "The QHP_VIRTUAL_FOLDER tag specifies the namespace to use when generating\n"
                 "Qt Help Project output. For more information please see\n"
                 "http://doc.trolltech.com/qthelpproject.html#virtual-folders"
                );
  cs->setDefaultValue("doc");
  cs->addDependency("GENERATE_QHP");
  //----
  cs = cfg->addString(
                 "QHP_CUST_FILTER_NAME",
                 "If QHP_CUST_FILTER_NAME is set, it specifies the name of a custom filter to\n"
                 "add. For more information please see\n"
                 "http://doc.trolltech.com/qthelpproject.html#custom-filters"
                );
  cs->addDependency("GENERATE_QHP");
  //----
  cs = cfg->addString(
                 "QHP_CUST_FILTER_ATTRS",
                 "The QHP_CUST_FILT_ATTRS tag specifies the list of the attributes of the\n"
                 "custom filter to add. For more information please see\n"
                 "<a href=\"http://doc.trolltech.com/qthelpproject.html#custom-filters\">\n"
                 "Qt Help Project / Custom Filters</a>."
                );
  cs->addDependency("GENERATE_QHP");
  //----
  cs = cfg->addString(
                 "QHP_SECT_FILTER_ATTRS",
                 "The QHP_SECT_FILTER_ATTRS tag specifies the list of the attributes this\n"
                 "project's\n"
                 "filter section matches.\n"
                 "<a href=\"http://doc.trolltech.com/qthelpproject.html#filter-attributes\">\n"
                 "Qt Help Project / Filter Attributes</a>."
                );
  cs->addDependency("GENERATE_QHP");
  //----
  cs = cfg->addString(
                 "QHG_LOCATION",
                 "If the GENERATE_QHP tag is set to YES, the QHG_LOCATION tag can\n"
                 "be used to specify the location of Qt's qhelpgenerator.\n"
                 "If non-empty doxygen will try to run qhelpgenerator on the generated\n"
                 ".qhp file."
                );
  cs->setWidgetType(ConfigString::File);
  cs->addDependency("GENERATE_QHP");
  //----
  cb = cfg->addBool(
                 "GENERATE_ECLIPSEHELP",
                 "If the GENERATE_ECLIPSEHELP tag is set to YES, additional index files\n"
                 " will be generated, which together with the HTML files, form an Eclipse help\n"
                 "plugin. To install this plugin and make it available under the help contents\n"
                 "menu in Eclipse, the contents of the directory containing the HTML and XML\n"
                 "files needs to be copied into the plugins directory of eclipse. The name of\n"
                 "the directory within the plugins directory should be the same as\n"
                 "the ECLIPSE_DOC_ID value. After copying Eclipse needs to be restarted before\n"
                 "the help appears.",
                 FALSE
                );
  cb->addDependency("GENERATE_HTML");
  //----
  cs = cfg->addString(
                 "ECLIPSE_DOC_ID",
                 "A unique identifier for the eclipse help plugin. When installing the plugin\n"
                 "the directory name containing the HTML and XML files should also have\n"
                 "this name."
                );
  cs->setDefaultValue("org.doxygen.Project");
  cs->addDependency("GENERATE_ECLIPSEHELP");
  //----
  cb = cfg->addBool(
                 "DISABLE_INDEX",
                 "The DISABLE_INDEX tag can be used to turn on/off the condensed index (tabs)\n"
                 "at top of each HTML page. The value NO (the default) enables the index and\n"
                 "the value YES disables it. Since the tabs have the same information as the\n"
                 "navigation tree you can set this option to NO if you already set\n"
                 "GENERATE_TREEVIEW to YES.",
                 FALSE
                );
  cb->addDependency("GENERATE_HTML");
  //----
  cb = cfg->addBool(
                 "GENERATE_TREEVIEW",
                 "The GENERATE_TREEVIEW tag is used to specify whether a tree-like index\n"
                 "structure should be generated to display hierarchical information.\n"
                 "If the tag value is set to YES, a side panel will be generated\n"
                 "containing a tree-like index structure (just like the one that\n"
                 "is generated for HTML Help). For this to work a browser that supports\n"
                 "JavaScript, DHTML, CSS and frames is required (i.e. any modern browser).\n"
                 "Windows users are probably better off using the HTML help feature.\n"
                 "Since the tree basically has the same information as the tab index you\n"
                 "could consider to set DISABLE_INDEX to NO when enabling this option.",
                 FALSE
                );
  cb->addDependency("GENERATE_HTML");
  //----
  ci = cfg->addInt(
                 "ENUM_VALUES_PER_LINE",
                 "The ENUM_VALUES_PER_LINE tag can be used to set the number of enum values\n"
                 "(range [0,1..20]) that doxygen will group on one line in the generated HTML\n"
                 "documentation. Note that a value of 0 will completely suppress the enum\n"
                 "values from appearing in the overview section.",
                 0,20,4
                );
  ci->addDependency("GENERATE_HTML");
  //----
  ci = cfg->addInt(
                 "TREEVIEW_WIDTH",
                 "If the treeview is enabled (see GENERATE_TREEVIEW) then this tag can be\n"
                 "used to set the initial width (in pixels) of the frame in which the tree\n"
                 "is shown.",
                 0,1500,250
                );
  ci->addDependency("GENERATE_HTML");
  //----
  cb = cfg->addBool(
                 "EXT_LINKS_IN_WINDOW",
                 "When the EXT_LINKS_IN_WINDOW option is set to YES doxygen will open\n"
                 "links to external symbols imported via tag files in a separate window.",
                 FALSE
                );
  cb->addDependency("GENERATE_HTML");
  //----
  ci = cfg->addInt(
                 "FORMULA_FONTSIZE",
                 "Use this tag to change the font size of Latex formulas included\n"
                 "as images in the HTML documentation. The default is 10. Note that\n"
                 "when you change the font size after a successful doxygen run you need\n"
                 "to manually remove any form_*.png images from the HTML output directory\n"
                 "to force them to be regenerated.",
                 8,50,10
                );
  ci->addDependency("GENERATE_HTML");
  //----
  cb = cfg->addBool(
                 "FORMULA_TRANSPARENT",
                 "Use the FORMULA_TRANPARENT tag to determine whether or not the images\n"
                 "generated for formulas are transparent PNGs. Transparent PNGs are\n"
                 "not supported properly for IE 6.0, but are supported on all modern browsers.\n"
                 "Note that when changing this option you need to delete any form_*.png files\n"
                 "in the HTML output before the changes have effect.",
                 TRUE
                );
  cb->addDependency("GENERATE_HTML");
  //----
  cb = cfg->addBool(
                 "USE_MATHJAX",
                 "Enable the USE_MATHJAX option to render LaTeX formulas using MathJax\n"
                 "(see http://www.mathjax.org) which uses client side Javascript for the\n"
                 "rendering instead of using prerendered bitmaps. Use this if you do not\n"
                 "have LaTeX installed or if you want to formulas look prettier in the HTML\n"
                 "output. When enabled you may also need to install MathJax separately and\n"
                 "configure the path to it using the MATHJAX_RELPATH option.",
                 FALSE
                );
  //----
  cs = cfg->addString(
                 "MATHJAX_RELPATH",
                 "When MathJax is enabled you need to specify the location relative to the\n"
                 "HTML output directory using the MATHJAX_RELPATH option. The destination\n"
                 "directory should contain the MathJax.js script. For instance, if the mathjax\n"
                 "directory is located at the same level as the HTML output directory, then\n"
                 "MATHJAX_RELPATH should be ../mathjax. The default value points to\n"
                 "the MathJax Content Delivery Network so you can quickly see the result without\n"
                 "installing MathJax.\n"
                 "However, it is strongly recommended to install a local\n"
                 "copy of MathJax from http://www.mathjax.org before deployment."
                );
  cs->setDefaultValue("http://cdn.mathjax.org/mathjax/latest");
  //----
  cl = cfg->addList(
                 "MATHJAX_EXTENSIONS",
                 "The MATHJAX_EXTENSIONS tag can be used to specify one or MathJax extension\n"
                 "names that should be enabled during MathJax rendering."
                );
  cl->addDependency("USE_MATHJAX");
  //----
  cb = cfg->addBool(
                 "SEARCHENGINE",
                 "When the SEARCHENGINE tag is enabled doxygen will generate a search box\n"
                 "for the HTML output. The underlying search engine uses javascript\n"
                 "and DHTML and should work on any modern browser. Note that when using\n"
                 "HTML help (GENERATE_HTMLHELP), Qt help (GENERATE_QHP), or docsets\n"
                 "(GENERATE_DOCSET) there is already a search function so this one should\n"
                 "typically be disabled. For large projects the javascript based search engine\n"
                 "can be slow, then enabling SERVER_BASED_SEARCH may provide a better solution.",
                 TRUE
                );
  cb->addDependency("GENERATE_HTML");
  //----
  cb = cfg->addBool(
                 "SERVER_BASED_SEARCH",
                 "When the SERVER_BASED_SEARCH tag is enabled the search engine will be\n"
                 "implemented using a PHP enabled web server instead of at the web client\n"
                 "using Javascript. Doxygen will generate the search PHP script and index\n"
                 "file to put on the web server. The advantage of the server\n"
                 "based approach is that it scales better to large projects and allows\n"
                 "full text search. The disadvantages are that it is more difficult to setup\n"
                 "and does not have live searching capabilities.",
                 FALSE
                );
  cb->addDependency("SEARCHENGINE");
  //---------------------------------------------------------------------------
  cfg->addInfo("LaTeX","configuration options related to the LaTeX output");
  //---------------------------------------------------------------------------

  //----
  cb = cfg->addBool(
                 "GENERATE_LATEX",
                 "If the GENERATE_LATEX tag is set to YES (the default) Doxygen will\n"
                 "generate Latex output.",
                 TRUE
                );
  //----
  cs = cfg->addString(
                 "LATEX_OUTPUT",
                 "The LATEX_OUTPUT tag is used to specify where the LaTeX docs will be put.\n"
                 "If a relative path is entered the value of OUTPUT_DIRECTORY will be\n"
                 "put in front of it. If left blank `latex' will be used as the default path."
                );
  cs->setDefaultValue("latex");
  cs->setWidgetType(ConfigString::Dir);
  cs->addDependency("GENERATE_LATEX");
  //----
  cs = cfg->addString(
                 "LATEX_CMD_NAME",
                 "The LATEX_CMD_NAME tag can be used to specify the LaTeX command name to be\n"
                 "invoked. If left blank `latex' will be used as the default command name.\n"
                 "Note that when enabling USE_PDFLATEX this option is only used for\n"
                 "generating bitmaps for formulas in the HTML output, but not in the\n"
                 "Makefile that is written to the output directory."
                );
  cs->setDefaultValue("latex");
  cs->setWidgetType(ConfigString::File);
  cs->addDependency("GENERATE_LATEX");
  //----
  cs = cfg->addString(
                 "MAKEINDEX_CMD_NAME",
                 "The MAKEINDEX_CMD_NAME tag can be used to specify the command name to\n"
                 "generate index for LaTeX. If left blank `makeindex' will be used as the\n"
                 "default command name."
                );
  cs->setDefaultValue("makeindex");
  cs->setWidgetType(ConfigString::File);
  cs->addDependency("GENERATE_LATEX");
  //----
  cb = cfg->addBool(
                 "COMPACT_LATEX",
                 "If the COMPACT_LATEX tag is set to YES Doxygen generates more compact\n"
                 "LaTeX documents. This may be useful for small projects and may help to\n"
                 "save some trees in general.",
                 FALSE
                );
  cb->addDependency("GENERATE_LATEX");
  //----
  ce = cfg->addEnum(
                 "PAPER_TYPE",
                 "The PAPER_TYPE tag can be used to set the paper type that is used\n"
                 "by the printer. Possible values are: a4, letter, legal and\n"
                 "executive. If left blank a4wide will be used.",
                 "a4"
                );
  ce->addValue("a4");
  ce->addValue("a4wide");
  ce->addValue("letter");
  ce->addValue("legal");
  ce->addValue("executive");
  ce->addDependency("GENERATE_LATEX");
  //----
  cl = cfg->addList(
                 "EXTRA_PACKAGES",
                 "The EXTRA_PACKAGES tag can be to specify one or more names of LaTeX\n"
                 "packages that should be included in the LaTeX output."
                );
  cl->addDependency("GENERATE_LATEX");
  //----
  cs = cfg->addString(
                 "LATEX_HEADER",
                 "The LATEX_HEADER tag can be used to specify a personal LaTeX header for\n"
                 "the generated latex document. The header should contain everything until\n"
                 "the first chapter. If it is left blank doxygen will generate a\n"
                 "standard header. Notice: only use this tag if you know what you are doing!"
                );
  cs->setWidgetType(ConfigString::File);
  cs->addDependency("GENERATE_LATEX");
  //----
  cs = cfg->addString(
                 "LATEX_FOOTER",
                 "The LATEX_FOOTER tag can be used to specify a personal LaTeX footer for\n"
                 "the generated latex document. The footer should contain everything after\n"
                 "the last chapter. If it is left blank doxygen will generate a\n"
                 "standard footer. Notice: only use this tag if you know what you are doing!"
                );
  cs->setWidgetType(ConfigString::File);
  cs->addDependency("GENERATE_LATEX");
  //----
  cb = cfg->addBool(
                 "PDF_HYPERLINKS",
                 "If the PDF_HYPERLINKS tag is set to YES, the LaTeX that is generated\n"
                 "is prepared for conversion to pdf (using ps2pdf). The pdf file will\n"
                 "contain links (just like the HTML output) instead of page references\n"
                 "This makes the output suitable for online browsing using a pdf viewer.",
                 TRUE
                );
  cb->addDependency("GENERATE_LATEX");
  //----
  cb = cfg->addBool(
                 "USE_PDFLATEX",
                 "If the USE_PDFLATEX tag is set to YES, pdflatex will be used instead of\n"
                 "plain latex in the generated Makefile. Set this option to YES to get a\n"
                 "higher quality PDF documentation.",
                 TRUE
                );
  cb->addDependency("GENERATE_LATEX");
  //----
  cb = cfg->addBool(
                 "LATEX_BATCHMODE",
                 "If the LATEX_BATCHMODE tag is set to YES, doxygen will add the \\\\batchmode.\n"
                 "command to the generated LaTeX files. This will instruct LaTeX to keep\n"
                 "running if errors occur, instead of asking the user for help.\n"
                 "This option is also used when generating formulas in HTML.",
                 FALSE
                );
  cb->addDependency("GENERATE_LATEX");
  //----
  cb = cfg->addBool(
                 "LATEX_HIDE_INDICES",
                 "If LATEX_HIDE_INDICES is set to YES then doxygen will not\n"
                 "include the index chapters (such as File Index, Compound Index, etc.)\n"
                 "in the output.",
                 FALSE
                );
  cb->addDependency("GENERATE_LATEX");
  //----
  cb = cfg->addBool(
                 "LATEX_SOURCE_CODE",
                 "If LATEX_SOURCE_CODE is set to YES then doxygen will include\n"
                 "source code with syntax highlighting in the LaTeX output.\n"
                 "Note that which sources are shown also depends on other settings\n"
                 "such as SOURCE_BROWSER.",
                 FALSE
                );
  cb->addDependency("GENERATE_LATEX");
  //----
  cs = cfg->addString(
                 "LATEX_BIB_STYLE",
                 "The LATEX_BIB_STYLE tag can be used to specify the style to use for the\n"
                 "bibliography, e.g. plainnat, or ieeetr. The default style is \"plain\". See\n"
                 "http://en.wikipedia.org/wiki/BibTeX for more info."
                );
  cs->setDefaultValue("plain");
  //---------------------------------------------------------------------------
  cfg->addInfo("RTF","configuration options related to the RTF output");
  //---------------------------------------------------------------------------

  //----
  cb = cfg->addBool(
                 "GENERATE_RTF",
                 "If the GENERATE_RTF tag is set to YES Doxygen will generate RTF output\n"
                 "The RTF output is optimized for Word 97 and may not look very pretty with\n"
                 "other RTF readers or editors.",
                 FALSE
                );
  //----
  cs = cfg->addString(
                 "RTF_OUTPUT",
                 "The RTF_OUTPUT tag is used to specify where the RTF docs will be put.\n"
                 "If a relative path is entered the value of OUTPUT_DIRECTORY will be\n"
                 "put in front of it. If left blank `rtf' will be used as the default path."
                );
  cs->setDefaultValue("rtf");
  cs->setWidgetType(ConfigString::Dir);
  cs->addDependency("GENERATE_RTF");
  //----
  cb = cfg->addBool(
                 "COMPACT_RTF",
                 "If the COMPACT_RTF tag is set to YES Doxygen generates more compact\n"
                 "RTF documents. This may be useful for small projects and may help to\n"
                 "save some trees in general.",
                 FALSE
                );
  cb->addDependency("GENERATE_RTF");
  //----
  cb = cfg->addBool(
                 "RTF_HYPERLINKS",
                 "If the RTF_HYPERLINKS tag is set to YES, the RTF that is generated\n"
                 "will contain hyperlink fields. The RTF file will\n"
                 "contain links (just like the HTML output) instead of page references.\n"
                 "This makes the output suitable for online browsing using WORD or other\n"
                 "programs which support those fields.\n"
                 "Note: wordpad (write) and others do not support links.",
                 FALSE
                );
  cb->addDependency("GENERATE_RTF");
  //----
  cs = cfg->addString(
                 "RTF_STYLESHEET_FILE",
                 "Load style sheet definitions from file. Syntax is similar to doxygen's\n"
                 "config file, i.e. a series of assignments. You only have to provide\n"
                 "replacements, missing definitions are set to their default value."
                );
  cs->setWidgetType(ConfigString::File);
  cs->addDependency("GENERATE_RTF");
  //----
  cs = cfg->addString(
                 "RTF_EXTENSIONS_FILE",
                 "Set optional variables used in the generation of an rtf document.\n"
                 "Syntax is similar to doxygen's config file."
                );
  cs->setWidgetType(ConfigString::File);
  cs->addDependency("GENERATE_RTF");
  //---------------------------------------------------------------------------
  cfg->addInfo("Man","configuration options related to the man page output");
  //---------------------------------------------------------------------------

  //----
  cb = cfg->addBool(
                 "GENERATE_MAN",
                 "If the GENERATE_MAN tag is set to YES (the default) Doxygen will\n"
                 "generate man pages",
                 FALSE
                );
  //----
  cs = cfg->addString(
                 "MAN_OUTPUT",
                 "The MAN_OUTPUT tag is used to specify where the man pages will be put.\n"
                 "If a relative path is entered the value of OUTPUT_DIRECTORY will be\n"
                 "put in front of it. If left blank `man' will be used as the default path."
                );
  cs->setDefaultValue("man");
  cs->setWidgetType(ConfigString::Dir);
  cs->addDependency("GENERATE_MAN");
  //----
  cs = cfg->addString(
                 "MAN_EXTENSION",
                 "The MAN_EXTENSION tag determines the extension that is added to\n"
                 "the generated man pages (default is the subroutine's section .3)"
                );
  cs->setDefaultValue(".3");
  cs->addDependency("GENERATE_MAN");
  //----
  cb = cfg->addBool(
                 "MAN_LINKS",
                 "If the MAN_LINKS tag is set to YES and Doxygen generates man output,\n"
                 "then it will generate one additional man file for each entity\n"
                 "documented in the real man page(s). These additional files\n"
                 "only source the real man page, but without them the man command\n"
                 "would be unable to find the correct page. The default is NO.",
                 FALSE
                );
  cb->addDependency("GENERATE_MAN");
  //---------------------------------------------------------------------------
  cfg->addInfo("XML","configuration options related to the XML output");
  //---------------------------------------------------------------------------

  //----
  cb = cfg->addBool(
                 "GENERATE_XML",
                 "If the GENERATE_XML tag is set to YES Doxygen will\n"
                 "generate an XML file that captures the structure of\n"
                 "the code including all documentation.",
                 FALSE
                );
  //----
  cs = cfg->addString(
                 "XML_OUTPUT",
                 "The XML_OUTPUT tag is used to specify where the XML pages will be put.\n"
                 "If a relative path is entered the value of OUTPUT_DIRECTORY will be\n"
                 "put in front of it. If left blank `xml' will be used as the default path."
                );
  cs->setDefaultValue("xml");
  cs->setWidgetType(ConfigString::Dir);
  cs->addDependency("GENERATE_XML");
  //----
  cs = cfg->addString(
                 "XML_SCHEMA",
                 "The XML_SCHEMA tag can be used to specify an XML schema,\n"
                 "which can be used by a validating XML parser to check the\n"
                 "syntax of the XML files."
                );
  cs->addDependency("GENERATE_XML");
  //----
  cs = cfg->addString(
                 "XML_DTD",
                 "The XML_DTD tag can be used to specify an XML DTD,\n"
                 "which can be used by a validating XML parser to check the\n"
                 "syntax of the XML files."
                );
  cs->addDependency("GENERATE_XML");
  //----
  cb = cfg->addBool(
                 "XML_PROGRAMLISTING",
                 "If the XML_PROGRAMLISTING tag is set to YES Doxygen will\n"
                 "dump the program listings (including syntax highlighting\n"
                 "and cross-referencing information) to the XML output. Note that\n"
                 "enabling this will significantly increase the size of the XML output.",
                 TRUE
                );
  cb->addDependency("GENERATE_XML");
  //---------------------------------------------------------------------------
  cfg->addInfo("DEF","configuration options for the AutoGen Definitions output");
  //---------------------------------------------------------------------------

  //----
  cb = cfg->addBool(
                 "GENERATE_AUTOGEN_DEF",
                 "If the GENERATE_AUTOGEN_DEF tag is set to YES Doxygen will\n"
                 "generate an AutoGen Definitions (see autogen.sf.net) file\n"
                 "that captures the structure of the code including all\n"
                 "documentation. Note that this feature is still experimental\n"
                 "and incomplete at the moment.",
                 FALSE
                );
  //---------------------------------------------------------------------------
  cfg->addInfo("PerlMod","configuration options related to the Perl module output");
  //---------------------------------------------------------------------------

  //----
  cb = cfg->addBool(
                 "GENERATE_PERLMOD",
                 "If the GENERATE_PERLMOD tag is set to YES Doxygen will\n"
                 "generate a Perl module file that captures the structure of\n"
                 "the code including all documentation. Note that this\n"
                 "feature is still experimental and incomplete at the\n"
                 "moment.",
                 FALSE
                );
  //----
  cb = cfg->addBool(
                 "PERLMOD_LATEX",
                 "If the PERLMOD_LATEX tag is set to YES Doxygen will generate\n"
                 "the necessary Makefile rules, Perl scripts and LaTeX code to be able\n"
                 "to generate PDF and DVI output from the Perl module output.",
                 FALSE
                );
  cb->addDependency("GENERATE_PERLMOD");
  //----
  cb = cfg->addBool(
                 "PERLMOD_PRETTY",
                 "If the PERLMOD_PRETTY tag is set to YES the Perl module output will be\n"
                 "nicely formatted so it can be parsed by a human reader.\n"
                 "This is useful\n"
                 "if you want to understand what is going on.\n"
                 "On the other hand, if this\n"
                 "tag is set to NO the size of the Perl module output will be much smaller\n"
                 "and Perl will parse it just the same.",
                 TRUE
                );
  cb->addDependency("GENERATE_PERLMOD");
  //----
  cs = cfg->addString(
                 "PERLMOD_MAKEVAR_PREFIX",
                 "The names of the make variables in the generated doxyrules.make file\n"
                 "are prefixed with the string contained in PERLMOD_MAKEVAR_PREFIX.\n"
                 "This is useful so different doxyrules.make files included by the same\n"
                 "Makefile don't overwrite each other's variables."
                );
  cs->addDependency("GENERATE_PERLMOD");
  //---------------------------------------------------------------------------
  cfg->addInfo("Preprocessor","Configuration options related to the preprocessor");
  //---------------------------------------------------------------------------

  //----
  cb = cfg->addBool(
                 "ENABLE_PREPROCESSING",
                 "If the ENABLE_PREPROCESSING tag is set to YES (the default) Doxygen will\n"
                 "evaluate all C-preprocessor directives found in the sources and include\n"
                 "files.",
                 TRUE
                );
  //----
  cb = cfg->addBool(
                 "MACRO_EXPANSION",
                 "If the MACRO_EXPANSION tag is set to YES Doxygen will expand all macro\n"
                 "names in the source code. If set to NO (the default) only conditional\n"
                 "compilation will be performed. Macro expansion can be done in a controlled\n"
                 "way by setting EXPAND_ONLY_PREDEF to YES.",
                 FALSE
                );
  cb->addDependency("ENABLE_PREPROCESSING");
  //----
  cb = cfg->addBool(
                 "EXPAND_ONLY_PREDEF",
                 "If the EXPAND_ONLY_PREDEF and MACRO_EXPANSION tags are both set to YES\n"
                 "then the macro expansion is limited to the macros specified with the\n"
                 "PREDEFINED and EXPAND_AS_DEFINED tags.",
                 FALSE
                );
  cb->addDependency("ENABLE_PREPROCESSING");
  //----
  cb = cfg->addBool(
                 "SEARCH_INCLUDES",
                 "If the SEARCH_INCLUDES tag is set to YES (the default) the includes files\n"
                 "pointed to by INCLUDE_PATH will be searched when a #include is found.",
                 TRUE
                );
  cb->addDependency("ENABLE_PREPROCESSING");
  //----
  cl = cfg->addList(
                 "INCLUDE_PATH",
                 "The INCLUDE_PATH tag can be used to specify one or more directories that\n"
                 "contain include files that are not input files but should be processed by\n"
                 "the preprocessor."
                );
  cl->addDependency("ENABLE_PREPROCESSING");
  cl->setWidgetType(ConfigList::Dir);
  //----
  cl = cfg->addList(
                 "INCLUDE_FILE_PATTERNS",
                 "You can use the INCLUDE_FILE_PATTERNS tag to specify one or more wildcard\n"
                 "patterns (like *.h and *.hpp) to filter out the header-files in the\n"
                 "directories. If left blank, the patterns specified with FILE_PATTERNS will\n"
                 "be used."
                );
  cl->addDependency("ENABLE_PREPROCESSING");
  //----
  cl = cfg->addList(
                 "PREDEFINED",
                 "The PREDEFINED tag can be used to specify one or more macro names that\n"
                 "are defined before the preprocessor is started (similar to the -D option of\n"
                 "gcc). The argument of the tag is a list of macros of the form: name\n"
                 "or name=definition (no spaces). If the definition and the = are\n"
                 "omitted =1 is assumed. To prevent a macro definition from being\n"
                 "undefined via #undef or recursively expanded use the := operator\n"
                 "instead of the = operator."
                );
  cl->addDependency("ENABLE_PREPROCESSING");
  //----
  cl = cfg->addList(
                 "EXPAND_AS_DEFINED",
                 "If the MACRO_EXPANSION and EXPAND_ONLY_PREDEF tags are set to YES then\n"
                 "this tag can be used to specify a list of macro names that should be expanded.\n"
                 "The macro definition that is found in the sources will be used.\n"
                 "Use the PREDEFINED tag if you want to use a different macro definition that\n"
                 "overrules the definition found in the source code."
                );
  cl->addDependency("ENABLE_PREPROCESSING");
  //----
  cb = cfg->addBool(
                 "SKIP_FUNCTION_MACROS",
                 "If the SKIP_FUNCTION_MACROS tag is set to YES (the default) then\n"
                 "doxygen's preprocessor will remove all references to function-like macros\n"
                 "that are alone on a line, have an all uppercase name, and do not end with a\n"
                 "semicolon, because these will confuse the parser if not removed.",
                 TRUE
                );
  cb->addDependency("ENABLE_PREPROCESSING");
  //---------------------------------------------------------------------------
  cfg->addInfo("External","Configuration::additions related to external references");
  //---------------------------------------------------------------------------

  //----
  cl = cfg->addList(
                 "TAGFILES",
                 "The TAGFILES option can be used to specify one or more tagfiles. For each\n"
                 "tag file the location of the external documentation should be added. The\n"
                 "format of a tag file without this location is as follows:\n"
                 "\n"
                 "TAGFILES = file1 file2 ...\n"
                 "Adding location for the tag files is done as follows:\n"
                 "\n"
                 "TAGFILES = file1=loc1 \"file2 = loc2\" ...\n"
                 "where \"loc1\" and \"loc2\" can be relative or absolute paths\n"
                 "or URLs. Note that each tag file must have a unique name (where the name does\n"
                 "NOT include the path). If a tag file is not located in the directory in which\n"
                 "doxygen is run, you must also specify the path to the tagfile here."
                );
  cl->setWidgetType(ConfigList::File);
  //----
  cs = cfg->addString(
                 "GENERATE_TAGFILE",
                 "When a file name is specified after GENERATE_TAGFILE, doxygen will create\n"
                 "a tag file that is based on the input files it reads."
                );
  cs->setWidgetType(ConfigString::File);
  //----
  cb = cfg->addBool(
                 "ALLEXTERNALS",
                 "If the ALLEXTERNALS tag is set to YES all external classes will be listed\n"
                 "in the class index. If set to NO only the inherited external classes\n"
                 "will be listed.",
                 FALSE
                );
  //----
  cb = cfg->addBool(
                 "EXTERNAL_GROUPS",
                 "If the EXTERNAL_GROUPS tag is set to YES all external groups will be listed\n"
                 "in the modules index. If set to NO, only the current project's groups will\n"
                 "be listed.",
                 TRUE
                );
  //----
  cs = cfg->addString(
                 "PERL_PATH",
                 "The PERL_PATH should be the absolute path and name of the perl script\n"
                 "interpreter (i.e. the result of `which perl')."
                );
  cs->setDefaultValue("/usr/bin/perl");
  cs->setWidgetType(ConfigString::Dir);
  //---------------------------------------------------------------------------
  cfg->addInfo("Dot","Configuration options related to the dot tool");
  //---------------------------------------------------------------------------

  //----
  cb = cfg->addBool(
                 "CLASS_DIAGRAMS",
                 "If the CLASS_DIAGRAMS tag is set to YES (the default) Doxygen will\n"
                 "generate a inheritance diagram (in HTML, RTF and LaTeX) for classes with base\n"
                 "or super classes. Setting the tag to NO turns the diagrams off. Note that\n"
                 "this option also works with HAVE_DOT disabled, but it is recommended to\n"
                 "install and use dot, since it yields more powerful graphs.",
                 TRUE
                );
  //----
  cs = cfg->addString(
                 "MSCGEN_PATH",
                 "You can define message sequence charts within doxygen comments using the \\msc\n"
                 "command. Doxygen will then run the mscgen tool (see\n"
                 "http://www.mcternan.me.uk/mscgen/) to produce the chart and insert it in the\n"
                 "documentation. The MSCGEN_PATH tag allows you to specify the directory where\n"
                 "the mscgen tool resides. If left empty the tool is assumed to be found in the\n"
                 "default search path."
                );
  //----
  cb = cfg->addBool(
                 "HIDE_UNDOC_RELATIONS",
                 "If set to YES, the inheritance and collaboration graphs will hide\n"
                 "inheritance and usage relations if the target is undocumented\n"
                 "or is not a class.",
                 TRUE
                );
  //----
  cb = cfg->addBool(
                 "HAVE_DOT",
                 "If you set the HAVE_DOT tag to YES then doxygen will assume the dot tool is\n"
                 "available from the path. This tool is part of Graphviz, a graph visualization\n"
                 "toolkit from AT&T and Lucent Bell Labs. The other options in this section\n"
                 "have no effect if this option is set to NO (the default)",
                 FALSE
                );
  //----
  ci = cfg->addInt(
                 "DOT_NUM_THREADS",
                 "The DOT_NUM_THREADS specifies the number of dot invocations doxygen is\n"
                 "allowed to run in parallel. When set to 0 (the default) doxygen will\n"
                 "base this on the number of processors available in the system. You can set it\n"
                 "explicitly to a value larger than 0 to get control over the balance\n"
                 "between CPU load and processing speed.",
                 0,32,0
                );
  //----
  cs = cfg->addString(
                 "DOT_FONTNAME",
                 "By default doxygen will use the Helvetica font for all dot files that\n"
                 "doxygen generates. When you want a differently looking font you can specify\n"
                 "the font name using DOT_FONTNAME. You need to make sure dot is able to find\n"
                 "the font, which can be done by putting it in a standard location or by setting\n"
                 "the DOTFONTPATH environment variable or by setting DOT_FONTPATH to the\n"
                 "directory containing the font."
                );
  cs->setDefaultValue("Helvetica");
  cs->addDependency("HAVE_DOT");
  //----
  ci = cfg->addInt(
                 "DOT_FONTSIZE",
                 "The DOT_FONTSIZE tag can be used to set the size of the font of dot graphs.\n"
                 "The default size is 10pt.",
                 4,24,10
                );
  ci->addDependency("HAVE_DOT");
  //----
  cs = cfg->addString(
                 "DOT_FONTPATH",
                 "By default doxygen will tell dot to use the Helvetica font.\n"
                 "If you specify a different font using DOT_FONTNAME you can use DOT_FONTPATH to\n"
                 "set the path where dot can find it."
                );
  cs->addDependency("HAVE_DOT");
  //----
  cb = cfg->addBool(
                 "CLASS_GRAPH",
                 "If the CLASS_GRAPH and HAVE_DOT tags are set to YES then doxygen\n"
                 "will generate a graph for each documented class showing the direct and\n"
                 "indirect inheritance relations. Setting this tag to YES will force the\n"
                 "CLASS_DIAGRAMS tag to NO.",
                 TRUE
                );
  cb->addDependency("HAVE_DOT");
  //----
  cb = cfg->addBool(
                 "COLLABORATION_GRAPH",
                 "If the COLLABORATION_GRAPH and HAVE_DOT tags are set to YES then doxygen\n"
                 "will generate a graph for each documented class showing the direct and\n"
                 "indirect implementation dependencies (inheritance, containment, and\n"
                 "class references variables) of the class with other documented classes.",
                 TRUE
                );
  cb->addDependency("HAVE_DOT");
  //----
  cb = cfg->addBool(
                 "GROUP_GRAPHS",
                 "If the GROUP_GRAPHS and HAVE_DOT tags are set to YES then doxygen\n"
                 "will generate a graph for groups, showing the direct groups dependencies",
                 TRUE
                );
  cb->addDependency("HAVE_DOT");
  //----
  cb = cfg->addBool(
                 "UML_LOOK",
                 "If the UML_LOOK tag is set to YES doxygen will generate inheritance and\n"
                 "collaboration diagrams in a style similar to the OMG's Unified Modeling\n"
                 "Language.",
                 FALSE
                );
  cb->addDependency("HAVE_DOT");
  //----
  ci = cfg->addInt(
                 "UML_LIMIT_NUM_FIELDS",
                 "If the UML_LOOK tag is enabled, the fields and methods are shown inside\n"
                 "the class node. If there are many fields or methods and many nodes the\n"
                 "graph may become too big to be useful. The UML_LIMIT_NUM_FIELDS\n"
                 "threshold limits the number of items for each type to make the size more\n"
                 "managable. Set this to 0 for no limit. Note that the threshold may be\n"
                 "exceeded by 50% before the limit is enforced.",
                 0,100,10
                );
  ci->addDependency("HAVE_DOT");
  //----
  cb = cfg->addBool(
                 "TEMPLATE_RELATIONS",
                 "If set to YES, the inheritance and collaboration graphs will show the\n"
                 "relations between templates and their instances.",
                 FALSE
                );
  cb->addDependency("HAVE_DOT");
  //----
  cb = cfg->addBool(
                 "INCLUDE_GRAPH",
                 "If the ENABLE_PREPROCESSING, SEARCH_INCLUDES, INCLUDE_GRAPH, and HAVE_DOT\n"
                 "tags are set to YES then doxygen will generate a graph for each documented\n"
                 "file showing the direct and indirect include dependencies of the file with\n"
                 "other documented files.",
                 TRUE
                );
  cb->addDependency("HAVE_DOT");
  //----
  cb = cfg->addBool(
                 "INCLUDED_BY_GRAPH",
                 "If the ENABLE_PREPROCESSING, SEARCH_INCLUDES, INCLUDED_BY_GRAPH, and\n"
                 "HAVE_DOT tags are set to YES then doxygen will generate a graph for each\n"
                 "documented header file showing the documented files that directly or\n"
                 "indirectly include this file.",
                 TRUE
                );
  cb->addDependency("HAVE_DOT");
  //----
  cb = cfg->addBool(
                 "CALL_GRAPH",
                 "If the CALL_GRAPH and HAVE_DOT options are set to YES then\n"
                 "doxygen will generate a call dependency graph for every global function\n"
                 "or class method. Note that enabling this option will significantly increase\n"
                 "the time of a run. So in most cases it will be better to enable call graphs\n"
                 "for selected functions only using the \\callgraph command.",
                 FALSE
                );
  cb->addDependency("HAVE_DOT");
  //----
  cb = cfg->addBool(
                 "CALLER_GRAPH",
                 "If the CALLER_GRAPH and HAVE_DOT tags are set to YES then\n"
                 "doxygen will generate a caller dependency graph for every global function\n"
                 "or class method. Note that enabling this option will significantly increase\n"
                 "the time of a run. So in most cases it will be better to enable caller\n"
                 "graphs for selected functions only using the \\callergraph command.",
                 FALSE
                );
  cb->addDependency("HAVE_DOT");
  //----
  cb = cfg->addBool(
                 "GRAPHICAL_HIERARCHY",
                 "If the GRAPHICAL_HIERARCHY and HAVE_DOT tags are set to YES then doxygen\n"
                 "will generate a graphical hierarchy of all classes instead of a textual one.",
                 TRUE
                );
  cb->addDependency("HAVE_DOT");
  //----
  cb = cfg->addBool(
                 "DIRECTORY_GRAPH",
                 "If the DIRECTORY_GRAPH and HAVE_DOT tags are set to YES\n"
                 "then doxygen will show the dependencies a directory has on other directories\n"
                 "in a graphical way. The dependency relations are determined by the #include\n"
                 "relations between the files in the directories.",
                 TRUE
                );
  cb->addDependency("HAVE_DOT");
  //----
  ce = cfg->addEnum(
                 "DOT_IMAGE_FORMAT",
                 "The DOT_IMAGE_FORMAT tag can be used to set the image format of the images\n"
                 "generated by dot. Possible values are svg, png, jpg, or gif.\n"
                 "If left blank png will be used. If you choose svg you need to set\n"
                 "HTML_FILE_EXTENSION to xhtml in order to make the SVG files\n"
                 "visible in IE 9+ (other browsers do not have this requirement).",
                 "png"
                );
  ce->addValue("png");
  ce->addValue("jpg");
  ce->addValue("gif");
  ce->addValue("svg");
  ce->addDependency("HAVE_DOT");
  //----
  cb = cfg->addBool(
                 "INTERACTIVE_SVG",
                 "If DOT_IMAGE_FORMAT is set to svg, then this option can be set to YES to\n"
                 "enable generation of interactive SVG images that allow zooming and panning.\n"
                 "Note that this requires a modern browser other than Internet Explorer.\n"
                 "Tested and working are Firefox, Chrome, Safari, and Opera. For IE 9+ you\n"
                 "need to set HTML_FILE_EXTENSION to xhtml in order to make the SVG files\n"
                 "visible. Older versions of IE do not have SVG support.",
                 FALSE
                );
  cb->addDependency("HAVE_DOT");
  //----
  cs = cfg->addString(
                 "DOT_PATH",
                 "The tag DOT_PATH can be used to specify the path where the dot tool can be\n"
                 "found. If left blank, it is assumed the dot tool can be found in the path."
                );
  cs->setWidgetType(ConfigString::Dir);
  cs->addDependency("HAVE_DOT");
  //----
  cl = cfg->addList(
                 "DOTFILE_DIRS",
                 "The DOTFILE_DIRS tag can be used to specify one or more directories that\n"
                 "contain dot files that are included in the documentation (see the\n"
                 "\\dotfile command)."
                );
  cl->addDependency("HAVE_DOT");
  cl->setWidgetType(ConfigList::Dir);
  //----
  cl = cfg->addList(
                 "MSCFILE_DIRS",
                 "The MSCFILE_DIRS tag can be used to specify one or more directories that\n"
                 "contain msc files that are included in the documentation (see the\n"
                 "\\mscfile command)."
                );
  cl->setWidgetType(ConfigList::Dir);
  //----
  ci = cfg->addInt(
                 "DOT_GRAPH_MAX_NODES",
                 "The DOT_GRAPH_MAX_NODES tag can be used to set the maximum number of\n"
                 "nodes that will be shown in the graph. If the number of nodes in a graph\n"
                 "becomes larger than this value, doxygen will truncate the graph, which is\n"
                 "visualized by representing a node as a red box. Note that doxygen if the\n"
                 "number of direct children of the root node in a graph is already larger than\n"
                 "DOT_GRAPH_MAX_NODES then the graph will not be shown at all. Also note\n"
                 "that the size of a graph can be further restricted by MAX_DOT_GRAPH_DEPTH.",
                 0,10000,50
                );
  ci->addDependency("HAVE_DOT");
  //----
  ci = cfg->addInt(
                 "MAX_DOT_GRAPH_DEPTH",
                 "The MAX_DOT_GRAPH_DEPTH tag can be used to set the maximum depth of the\n"
                 "graphs generated by dot. A depth value of 3 means that only nodes reachable\n"
                 "from the root by following a path via at most 3 edges will be shown. Nodes\n"
                 "that lay further from the root node will be omitted. Note that setting this\n"
                 "option to 1 or 2 may greatly reduce the computation time needed for large\n"
                 "code bases. Also note that the size of a graph can be further restricted by\n"
                 "DOT_GRAPH_MAX_NODES. Using a depth of 0 means no depth restriction.",
                 0,1000,0
                );
  ci->addDependency("HAVE_DOT");
  //----
  cb = cfg->addBool(
                 "DOT_TRANSPARENT",
                 "Set the DOT_TRANSPARENT tag to YES to generate images with a transparent\n"
                 "background. This is disabled by default, because dot on Windows does not\n"
                 "seem to support this out of the box. Warning: Depending on the platform used,\n"
                 "enabling this option may lead to badly anti-aliased labels on the edges of\n"
                 "a graph (i.e. they become hard to read).",
                 FALSE
                );
  cb->addDependency("HAVE_DOT");
  //----
  cb = cfg->addBool(
                 "DOT_MULTI_TARGETS",
                 "Set the DOT_MULTI_TARGETS tag to YES allow dot to generate multiple output\n"
                 "files in one run (i.e. multiple -o and -T options on the command line). This\n"
                 "makes dot run faster, but since only newer versions of dot (>1.8.10)\n"
                 "support this, this feature is disabled by default.",
                 FALSE
                );
  cb->addDependency("HAVE_DOT");
  //----
  cb = cfg->addBool(
                 "GENERATE_LEGEND",
                 "If the GENERATE_LEGEND tag is set to YES (the default) Doxygen will\n"
                 "generate a legend page explaining the meaning of the various boxes and\n"
                 "arrows in the dot generated graphs.",
                 TRUE
                );
  cb->addDependency("HAVE_DOT");
  //----
  cb = cfg->addBool(
                 "DOT_CLEANUP",
                 "If the DOT_CLEANUP tag is set to YES (the default) Doxygen will\n"
                 "remove the intermediate dot files that are used to generate\n"
                 "the various graphs.",
                 TRUE
                );
  cb->addDependency("HAVE_DOT");
  //----
  cfg->addObsolete("USE_WINDOWS_ENCODING");
  //----
  cfg->addObsolete("DETAILS_AT_TOP");
  //----
  cfg->addObsolete("QTHELP_FILE");
  //----
  cfg->addObsolete("QTHELP_CONFIG");
  //----
  cfg->addObsolete("DOXYGEN2QTHELP_LOC");
  //----
  cfg->addObsolete("MAX_DOT_GRAPH_WIDTH");
  //----
  cfg->addObsolete("MAX_DOT_GRAPH_HEIGHT");
  //----
  cfg->addObsolete("CGI_NAME");
  //----
  cfg->addObsolete("CGI_URL");
  //----
  cfg->addObsolete("DOC_URL");
  //----
  cfg->addObsolete("DOC_ABSPATH");
  //----
  cfg->addObsolete("BIN_ABSPATH");
  //----
  cfg->addObsolete("EXT_DOC_PATHS");
  //----
  cfg->addObsolete("USE_INLINE_TREES");
  //----
  cfg->addObsolete("SHOW_DIRECTORIES");
  //----
  cfg->addObsolete("HTML_ALIGN_MEMBERS");
}
