/*
 * MetaSound decoder
 * Copyright (c) 2013 Konstantin Shishkov
 *
 * This file is part of FFmpeg.
 *
 * FFmpeg is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * FFmpeg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with FFmpeg; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

#include "metasound_data.h"

static const int16_t cb0806sl0[] = {
      -417,   -225,    -84,     16,   -106,    -34,   -246,   -164,
       112,     48,    -47,     36,    -65,    -68,   -172,  -1655,
       -36,    140,     -3,     -2,     -2,      2,      0,      0,
       178,      7,   -181,   -177,    120,    -64,   -129,     80,
     -6826,    -38,    -25,    147,    148,    -13,    -25,    110,
        21,     21,     -1,      0,      0,      0,      0,      0,
      3319,    632,   -734,   -187,     40,   -249,   -155,     -1,
      -173,     95,     28,     -2,     20,    -44,     35,    120,
       -47,   -221,     -5,      2,     -7,      1,      0,      0,
        63,    268,   -260,   -419,    187,    -75,   -228,    296,
      -470,    177,   -515,    318,    124,    308,     92,    371,
      3046,    362,     -1,     -1,    -10,      1,      0,      0,
      -356,    -16,   -199,    117,    -75,     46,   -108,    -14,
      -124,   -173,   4914,    -75,   -474,    105,     87,    190,
      -183,   -208,      0,      0,      1,      1,      0,     -1,
       162,     89,     49,   -314,  -2788,    265,   -263,     -3,
     -3156,    316,    112,    128,   -333,   -138,   -114,   -141,
      -287,   -234,     -1,      0,      0,      0,      0,      1,
       733,    126,   -424,   -389,    642,    432,    134,   -251,
       407,    -51,   -151,   -491,   -308,     91,     50,   3836,
        87,    100,     -5,     -6,      0,      1,      0,      0,
       304,   1727,     83,     -8,    216,    -81,   -189,    152,
       -67,     15,    310,    -93,      6,    -37,     54,   -110,
       -15,     78,      0,      0,      1,     12,      0,     -1,
       129,   -198,      1,    -48,    -66,   -147,     30,    264,
       -84,    102,     42,    126,      1,  -6451,    225,    -51,
         8,    123,      0,     -1,      0,     -1,      0,      0,
      -374,     66,   -256,    -80,  -1139,    303,   2002,   -199,
       -98,    -98,    -39,    -76,    180,     15,   -456,    148,
      -183,    118,     -2,      1,      0,      0,      0,      0,
       151,     13,   -114,     65,   6156,     76,    -82,    -30,
       -26,    163,     81,    167,    -83,   -101,     55,    -40,
       161,   -793,     -8,      0,      0,     -1,     -1,      0,
      -102,    -33,     55,   -131,    434,    108,     70,     68,
        62,   1913,   -109,    235,    110,    124,    -25,    -58,
       -76,     18,     -1,     -1,      0,      0,      0,      0,
      -105,  -7322,     -9,     82,     53,    -43,     -5,     18,
        90,     91,     20,    -34,     26,    -93,    -50,    -46,
       -77,    105,      0,      6,    -12,     -6,      1,      0,
     -1334,    980,   -163,   -351,   -514,    537,     62,   -300,
        80,   -318,     14,  -3570,    -52,   -116,   -280,    540,
       250,   -775,     -7,      0,      0,      0,      0,      0,
       507,    317,   -417,   -236,  -2438,    -72,   -346,   2507,
       302,   -185,     30,   1539,    205,     87,   -112,   -482,
      -296,    132,     -1,      0,     -1,      1,      0,      0,
       -64,   -208,   -159,      1,    336,    -62,    -14,     13,
        81,    101,    382,     32,    116,     -5,    -41,     25,
      -175,  -7829,      1,      0,      1,      0,      0,      0,
      7551,     -7,     86,   -165,    -57,    -17,    183,   -207,
        69,     54,    -99,    -25,    167,    -58,    107,    -81,
       165,    172,      2,     -2,      0,      1,      0,     -9,
        26,     28,     86,   -183,   -320,    -32,    116,    -53,
       -49,    -15,    133,   -283,   -152,    576,   6630,    185,
        44,     25,     20,      1,    -12,      1,     -1,      0,
      -145,    -51,   -114,    -29,   -228,     78,   -409,    235,
       147,     45,   -192,    177,    -91,     68,  -2572,    -52,
        81,    181,     -5,     13,     -1,     -1,    -17,      0,
       -65,    -23,    -28,      9,    242,     14,    -35,     88,
        77,    -20,     37,  -7097,    -58,     51,    137,    126,
       -90,    136,      0,      4,     -1,      0,      0,      0,
      -266,    -82,   -205,    816,   -309,   3267,   1053,    369,
      -216,   -302,     18,    168,    395,    273,    343,    243,
       -98,    -53,      1,      0,      0,      1,      0,      0,
       -65,    -76,   1850,   -991,   -454,   -535,   2927,   -145,
       101,     23,     20,    234,    -74,     77,    114,      4,
      -106,    527,    -11,      4,      0,      1,     -1,      0,
       573,    -46,    207,   2640,   -956,     47,     26,    -10,
       317,   -217,     -5,   -867,     -3,    213,     52,     53,
      -428,   -175,      0,      0,     -1,     -1,      0,     -1,
      -223,    -55,    135,    184,    313,      0,   2868,    245,
     -3187,   -721,   -291,      9,   -265,   -120,   -105,    -36,
       454,     55,     -1,     49,      0,      1,     -1,      0,
      -291,     41,     84,    557,   -201,  -2300,    429,    283,
        21,     -2,    132,    286,   -124,    149,    -14,    146,
       320,   -298,      0,     -1,      1,     -2,      0,      0,
       -86,  -3493,    131,  -3581,    185,     26,   -197,    -65,
       -96,    147,    -53,   -150,    -35,    -35,    179,     68,
      -157,      0,      0,      2,      0,      1,      2,     -1,
       -22,   -218,     13,  -1447,   -400,    288,  -1295,      0,
      -119,     69,    -56,   -139,    157,    -26,   -122,    -61,
       -38,   -108,     -1,      1,      0,      0,      0,      0,
      -229,   3335,    103,   -108,     10,   3008,   -712,     50,
        27,    152,   -307,   -106,    148,    -77,   -178,    -46,
         7,   -114,      0,     -9,      0,      0,      1,      0,
       932,   -443,    311,    -75,     62,    -80,   -179,    459,
      -232,   -160,      2,    169,    134,   -260,     41,   -149,
        23,     92,     -2,      0,     11,      1,      0,      0,
        16,    -90,   -574,   -171,    163,    261,   -299,   2994,
        74,  -3818,   -396,   -171,     13,    -29,    -45,   -168,
      -287,   -390,      1,      0,      0,     -4,      0,     -1,
        89,   -702,   2223,    101,   -249,   2983,     36,   -333,
      -382,    410,   -262,    185,   -146,     98,     -8,   -317,
      -279,   -879,      0,      0,      0,      0,      4,      0,
       -98,   -325,     75,   -229,    -13,    112,  -5743,    -34,
       -89,    263,   -155,     80,    140,    -50,     33,    143,
       -60,    -77,      1,     -2,      0,     -1,      1,      0,
        52,   -576,   -543,  -1142,   -947,   -184,    449,    -71,
       -75,   -156,  -3412,    -50,   -487,    307,    663,  -1000,
      -415,  -2348,     -7,     -1,     -1,      0,      0,      0,
        64,      3,    -35,     11,     14,   -198,     -2,  -8042,
       140,    -11,    -93,     29,    -65,    330,     34,    110,
       -19,   -137,      2,      0,      0,      0,      0,      0,
      1236,    303,   2681,    234,   -217,   -406,   -395,   -380,
       247,    349,   -101,    -33,    370,    -39,    139,     59,
        18,     24,      0,      0,      0,      0,      0,      0,
       166,    -21,  -5392,   -117,   -296,    114,    230,   -255,
       131,    -53,     13,    -45,    200,      7,    -56,     87,
        46,    223,    -59,      0,     -1,      0,      0,     -1,
       214,   -511,    175,    204,   -123,    -47,   -440,      6,
        23,     92,   -355,     80,  -4885,   -238,    -37,     78,
      -218,    175,      0,      2,      0,      0,      0,      0,
      -146,     74,    -13,     -4,     27,    -45,     51,     81,
       -80,     53,    -18,    173,   -146,    -64,     -8,   8192,
        79,     15,      0,     -3,      0,      1,      0,      0,
        -3,    -16,    -28,    288,    -61,      4,   -187,      6,
        -5,    -14,     77,    -12,    -53,     16,    -41,     -7,
       -10,     -2,      7,     -1,     -9,      1,      0,      0,
      -285,    -35,     -8,    221,    -68,    114,    135,     -8,
      -203,   -181,    -91,   2043,    -58,    127,    201,    111,
        46,   -344,    -11,    -49,      0,      1,      0,     -1,
      -160,   -186,     58,   4761,    289,     51,   -145,     51,
       -32,     71,     62,    175,    -13,    181,    203,    141,
      -200,    106,     -1,      4,     -2,      0,      0,      0,
       803,    -76,    -96,   -940,    300,   3429,    -84,   3037,
       262,     -9,    -39,    120,   -629,   -309,    233,   -374,
       398,    894,    -12,      1,      1,      1,      0,      0,
      -282,   2525,    -31,   -176,  -2473,     53,    102,   -610,
       180,   -145,     42,    -51,    223,     27,    -69,    727,
       -14,    -51,      0,      0,      0,     -3,      0,    -40,
       214,     72,     41,      1,    190,     78,   -228,   -235,
       105,  -4619,   -140,    -46,     -7,     49,      9,    -19,
       137,     -2,      9,      1,      0,      0,      0,      0,
      -142,   -262,     29,   -142,     39,    -39,    -92,     95,
        50,   -282,      2,   -106,    114,      8,     35,     78,
      -121,   2589,      1,     -4,    -10,      1,      1,      0,
      -192,     59,    287,    400,    -67,  -6989,   -301,    446,
       115,      7,     33,    -60,    111,    102,      8,    206,
        46,    -31,     -1,     -1,     -2,      0,      0,      0,
      -104,    332,   -223,   1066,   -188,   1270,   -222,    309,
      -296,    259,    780,   -460,  -1914,    218,   -556,    210,
      2962,    130,      1,     -2,      2,      0,      1,      0,
      -320,   -365,   -266,    822,   -119,    824,   -312,     58,
     -1857,    235,     48,  -3985,    118,   -307,   -703,   -931,
      -560,    105,     -2,     -3,      0,      0,      0,      1,
       156,    -48,    187,    214,   -212,    180,    342,    373,
      1973,    128,     -5,    146,    -40,    -11,     71,    -60,
        76,     17,      0,      0,     -1,      2,      0,      7,
       214,     63,    274,   2876,    -65,    314,    400,    344,
       140,     39,    193,   -226,    124,  -3177,     68,     46,
       -60,   -317,      2,      0,     -1,      0,      7,      0,
      -160,    118,    233,    239,   -465,     96,    253,   3178,
       -88,    299,    368,   -220,    197,    397,   -353,   -463,
      -202,   -103,     -4,      0,      0,      0,      0,      0,
       687,   -448,   -749,     87,    -35,    112,    309,    -33,
       -16,     88,    141,     63,    -51,    274,   -113,    -76,
        46,   -273,     -1,      1,      0,      1,      0,      1,
      -298,   -206,    670,    303,   -451,   -277,   -493,    404,
      -173,    284,    148,    626,   -322,   -296,    -68,   3044,
      -442,   1138,     -7,      2,      0,      1,      0,      0,
     -1338,     18,   2862,    223,    250,    260,    144,    259,
       -38,   -647,    602,   -160,     75,     -5,     -8,     34,
       237,     50,      2,      0,      1,     -1,     -1,      0,
      -412,   2153,    933,    478,    768,    186,   -424,   -657,
     -3458,   -443,    294,    224,   -468,    -58,   -120,  -1565,
       211,   -420,      0,      0,      1,     -1,      0,      0,
       198,    227,   -112,    350,    297,   -303,    108,   -192,
       153,     32,  -2717,   -111,  -1093,   -200,    476,    326,
      -271,    627,      0,     -4,      0,      0,      0,     -1,
       462,   -616,    126,    316,  -2413,    204,   -350,  -3549,
      -263,   -386,   -112,    483,  -1339,    636,     70,   -531,
        96,     38,      8,     -1,      0,     -3,      0,      0,
      -310,  -1128,    616,   -339,   -168,   -124,   -905,   -151,
      -383,     76,    137,    -44,   3689,   -388,    184,   1799,
      -102,   -930,      6,     -1,     -1,     -1,      0,      0,
      -284,    280,     39,   -728,    143,     15,    181,    798,
       382,     10,   2267,    -12,  -3582,    -27,    357,    514,
      -565,   -121,      0,     -1,      0,     -9,     -1,      0,
       429,    -16,   2993,  -2903,     47,   -136,     30,    792,
      -327,   -347,    -69,    -50,    -93,   -223,   -438,    158,
       203,   -475,      0,     -4,     -1,      2,      0,      0,
     -3465,    415,   -963,    252,    397,   -945,   -448,   -231,
      -130,    673,    504,     55,   -355,    221,     29,    167,
       -19,    134,     -1,     -1,     -4,      0,    -14,     -2,
        44,    433,   -535,   -216,   2485,     33,     19,   -100,
      -185,   -171,     91,    336,   -208,    140,     -3,     46,
       -67,   -116,     32,      0,      5,      3,      0,      0,
       220,     91,    -65,    -15,   -169,    217,   -183,   -169,
       -47,    181,   -272,    138,   -166,    110,     -9,     41,
     -6957,     33,     -5,     -2,      1,      1,      0,     -1,
       164,  -4062,   -109,    230,   -220,   1748,  -1338,   -246,
      -242,    -98,    300,    217,   -202,   -130,    157,     -3,
       -19,   -453,      0,      2,      0,      0,      0,      0,
};

static const int16_t cb0806sl1[] = {
        75,     87,    -31,    607,   -132,   5963,   -262,    494,
       134,     -4,    141,     19,    225,    229,    239,     93,
       -20,   -189,      2,      0,     -3,     -1,     -1,      0,
       214,   -206,    877,     83,   -588,     83,    132,     78,
         5,    -85,     66,    -24,     47,    -11,     25,     26,
        -3,     46,      2,     -5,      0,      1,     -1,      0,
      -113,    295,    -81,     74,    223,    -50,    -93,  -5671,
       -28,    115,    256,   -228,    -31,   -539,    300,   -278,
       -59,    426,   -110,     -1,      1,      1,      0,      0,
       -95,   -116,    266,    176,    761,     -3,     90,    -91,
        98,   -209,   -414,    -27,    -56,     26,    -76,      6,
       -32,   4634,      1,      0,     -4,      0,      0,      0,
       177,    147,   -236,    -93,  -7925,     11,   -111,    -74,
        36,    176,    352,     88,    112,     16,    144,   -110,
        91,    329,     -1,      2,      0,      1,      0,      1,
       119,    304,    -94,   -422,    113,    129,    -70,    155,
       247,   -116,   -139,    327,   -355,     77,    143,  -5362,
        27,   -377,     -1,      7,      2,      1,      0,      0,
       179,    127,   1500,   -324,    -15,    673,    184,  -1382,
       167,   1833,  -3058,    200,  -1203,    459,  -1905,   1020,
      -259,   -120,     10,     -4,      0,      1,      0,      0,
       995,   -112,     37,   -160,    -21,  -4011,    172,    228,
      -210,     80,   -131,      1,     20,   -128,   -252,   -288,
      -132,    337,     -1,      0,     -1,      0,      1,     -1,
       -60,     61,    197,   -185,    -40,  -2951,   -592,    -57,
       210,  -3248,   -226,    -44,    391,   -167,     -7,    219,
       -15,    172,      0,     -1,      1,      0,      0,      0,
       106,    -70,   -291,    192,     45,    162,     37,    143,
        91,     21,  -7032,     12,   -173,    -30,      1,    259,
      -286,    387,    -36,      0,      0,      0,      0,      0,
     -1593,   -210,     83,     47,    194,     61,     85,   -182,
       -23,     40,    -74,     22,     12,    216,     59,   -165,
      -163,   -159,     -8,      0,      0,      2,      0,      0,
        -3,    182,    -80,   2068,    702,    115,   -164,    -85,
        21,   -124,   -191,   -113,    263,    138,   4235,     37,
       204,   -436,      0,     24,      1,     -1,      0,      0,
       147,     83,   -177,   -168,   -609,     -9,    -16,    -46,
       127,    120,    -25,   3435,     51,     31,     49,    366,
        31,   -129,      1,    -32,      0,     -1,      0,     -2,
       295,    158,    116,     11,   -280,    471,    169,     29,
     -2589,    338,     32,    299,    172,   -187,    -32,    437,
       -38,    359,     -1,     -1,      1,      0,      0,      0,
       243,    413,    -29,  -4774,    187,     12,   -117,    168,
      -114,   -208,    -55,      5,      0,    -31,    436,    545,
       -45,    272,      0,     -4,      0,      0,      1,      0,
       127,     38,   6620,    -33,   -103,     34,     84,    -35,
        30,   -131,     -8,    -79,   -126,    -98,     17,    -75,
       -31,   -176,     14,     -1,      0,      0,     -1,     -1,
       273,   -219,    176,    -83,    187,    -36,      1,   2639,
       158,   3812,    127,   -233,    175,    310,    148,    387,
       -14,    308,      0,     -3,      0,      0,      0,      0,
      3321,   -447,    153,   -128,    254,   -275,     79,   -181,
        17,    146,     61,     46,    -48,    253,     51,    -17,
         1,      1,      0,      1,     -1,     -2,      0,    -13,
       791,   -130,     40,     78,    -64,   -179,     42,   -455,
       422,    112,    -19,  -4499,   -113,   -341,     52,     69,
        67,    254,     -6,     -1,      4,      0,      0,      1,
       -98,   -976,     68,   1563,    228,   1018,    458,  -1020,
       411,    249,   -627,   2321,    738,   -460,  -1469,    362,
       884,   -261,      0,     -1,      1,      1,      0,      0,
      -601,    378,    -71,     61,   -160,    800,   -386,   -773,
       303,    -53,    248,    -22,     59,  -3809,    -61,    102,
       -45,    395,      0,      0,     28,      0,    -12,      0,
       717,   -424,    499,    296,    -15,     11,   2732,   -103,
      -119,   -116,    107,    -50,    462,     73,    -82,     75,
        41,    131,      0,      3,      1,     -1,      0,      0,
      -134,    109,     48,  -1847,   -205,     -6,     20,   -203,
       136,    197,    113,    -77,   -124,    -50,    184,    225,
      -175,   -295,     -1,     -1,     -6,     -1,     -1,      0,
       -59,  -2017,   -193,   -237,    226,    630,   1950,     -2,
       179,  -3666,    -34,    140,     88,    157,     51,     81,
      -263,   -169,      1,      0,      0,      0,      0,      0,
       229,    -14,  -1590,   -123,    162,     63,   -224,   -332,
       119,   2931,     21,    -48,    406,     15,    320,    -51,
        64,   -228,     -9,     -1,      0,     -1,      0,      0,
      -453,     84,   -320,   -654,     -4,    -91,    -61,    558,
       -61,   -233,     31,   -224,   -105,     63,     86,   3771,
       162,  -1535,      3,     -3,      1,      1,      0,      1,
     -1992,   -279,    -59,  -3048,  -1696,    102,   -168,    194,
       172,   -142,     55,    134,    116,   -146,    -29,   -287,
       102,    265,     -3,      1,      0,      1,      0,      0,
       -96,     46,    -16,   2474,    -58,   -712,    -25,   -294,
       187,     22,    -39,   -102,     62,   2666,   -237,     -1,
        32,    -41,      0,      0,      0,      0,      0,      0,
      -282,    -25,   -198,   -862,   -127,   -379,   -210,    -20,
        45,    -79,  -2805,   -364,    575,    106,    215,   -410,
       -76,    511,     15,    -44,     -1,      1,      0,      0,
       329,    224,    130,     43,     -1,   -255,    -51,   -297,
      4529,     52,    186,    757,    -68,    -89,     46,    250,
        46,    -79,      5,      1,      0,      1,      0,    -19,
        79,     74,     65,    256,    260,    492,   -106,   -217,
      -357,     20,    166,    233,    132,    165,     18,     -1,
      4445,    -22,      5,      3,     -7,      0,      0,     -6,
      -922,   2156,    269,   1385,    235,   -206,    -94,    130,
       112,    145,   -126,    166,      1,     45,     83,     36,
      -153,   -255,      0,     -1,      0,      0,      1,      0,
       241,   -237,   -117,   -510,     85,      7,  -4418,     30,
        94,    -92,     99,    -71,    140,   -265,    149,     69,
       286,    104,      0,     -2,      1,      0,      0,      0,
      -165,     22,   -245,     29,     50,    145,    -53,   1641,
       -40,   -128,   -112,   -190,     47,     53,   -247,    -50,
        88,     39,      1,     -1,      0,      0,      0,      0,
      -288,    130,     88,   -132,   4055,     -7,     55,   -105,
       277,     81,     69,    -66,    -53,     52,    -56,     90,
       160,    386,      1,     -4,      0,     -2,      0,      0,
       107,    124,    -39,     40,     25,     -6,   -248,    -81,
        70,    -13,     46,      5,     20,     24,     -5,     -2,
       -41,    -34,      1,      1,     -8,      0,     -4,      0,
       -61,      1,    457,    454,    768,     89,    640,     61,
        66,   -360,  -2727,   -155,   -370,    -44,   -292,    570,
        34,  -3209,     -5,     -1,      1,      0,     -1,      0,
        22,    -82,    -20,   -125,    -91,     98,   7843,     25,
        -2,    -31,      2,    -52,    -73,    -25,     31,    -35,
        -6,   -114,      1,     -1,      2,      0,      0,      0,
       217,  -5202,     86,    -76,    -76,    109,    389,    -95,
      -253,    124,    130,     58,    190,    -44,    -67,   -142,
        54,      6,     -1,      1,      1,      1,      0,      0,
      -183,    547,   -200,    348,    372,    437,    425,    547,
      -457,    388,     87,     38,   -522,   -210,   -556,     41,
     -2979,    -17,      7,     -4,      6,      0,      0,      0,
       189,    196,    240,    -75,     46,    -50,    101,   -160,
       -16,   -223,     92,     71,  -7633,     78,     90,     69,
       190,    -75,      2,      1,     -2,     -1,      0,      1,
       205,   -433,   -267,   -175,   3068,   -210,   -514,    330,
     -3099,   -273,    155,    132,   -306,    361,    316,    -53,
      -421,   -125,     -3,      0,    -11,      0,      0,      0,
       179,    -38,    151,    -36,    215,   -102,   -145,    139,
        50,    200,    383,     37,   3102,    -27,      9,   -157,
       -68,    367,      1,      1,      0,      0,      1,      0,
       -50,    177,    -24,     24,    119,      4,     76,     99,
      -111,  -7367,     26,     51,    -11,   -146,   -125,    -48,
        54,     50,      1,      0,      0,      0,     -1,      0,
       -71,    -16,   -184,    -61,    -36,   -151,     79,   -128,
      -102,    135,   -228,    190,    -79,    -10,   -176,   -113,
      1008,   -856,    -13,     -4,      8,     28,      0,      1,
     -4909,    -93,   -167,   -141,     51,   -203,     71,   -199,
       -49,    106,   -142,    -94,    126,   -225,    158,     36,
       269,    159,      0,      1,      1,      0,      0,     -5,
       -61,    -79,    -20,    306,     67,   -621,   1774,    346,
      -442,    125,    305,   -170,     55,  -2537,   -103,    118,
        87,    505,     16,     -7,     -2,      0,     20,      0,
        35,   -154,   -158,    224,    -36,   -344,     79,   4232,
       234,   -219,    -71,    204,   -484,   -131,   1153,     23,
       111,    499,      5,      0,    -17,      0,      0,      1,
      1135,  -3469,   -489,   2572,   -450,   -432,   -358,    -34,
       -78,    -10,   -775,     17,   -131,   -154,    218,     82,
      -312,    279,      1,      0,      1,      0,      0,      0,
        96,    230,     18,     47,     -5,   -102,    646,   -122,
        35,    -81,    183,    171,  -1479,    201,     84,    -24,
       143,    302,      1,      5,      0,      0,      0,      0,
       -34,    -48,     89,   7789,    -85,    -27,    -56,     46,
        39,     30,     98,    -40,    138,   -147,    104,    -35,
       -41,   -151,      1,      9,      1,      0,      0,      0,
      -140,  -1970,   -170,    273,    226,     33,   -324,    -38,
        11,    188,    603,    188,   -183,     98,    -58,    -67,
       -63,      7,      0,      0,      0,      0,      1,      0,
       384,    899,    493,    765,  -1062,    646,    275,  -2699,
        93,    796,    120,    -25,    177,    -85,    721,   -189,
      -295,   -436,      0,     -1,      0,      0,     -1,      0,
      -358,    117,  -2435,    325,  -3137,   -158,     23,     97,
         6,    204,    288,   -426,    156,     22,   -101,    171,
       -56,    235,      0,     -1,      0,     -1,      0,      0,
       656,   3878,   -286,   -383,     75,    -50,    114,   -377,
      -105,    106,    154,    -30,   -204,   -105,    171,    -56,
       230,   -587,      0,      1,      0,      8,      1,     -1,
       -58,    177,     -7,     45,   -159,    405,     45,     84,
      -206,     77,    277,   -259,    121,   3719,    140,     79,
      -202,    843,     -8,      0,     -1,      1,     -2,      0,
      -248,    560,   2651,    -49,   -625,   -147,  -2416,    119,
       -70,     87,    137,     18,   -401,   -147,   -598,   -150,
       239,  -1004,      7,      3,     13,      1,      1,      1,
       276,    342,     97,    600,    230,     95,    213,    159,
      -259,    -25,   -176,   3360,   -283,   -325,    -37,  -2626,
      -151,    178,     -1,    -18,      0,      0,      0,      0,
      -233,    237,    -78,    290,   -284,    141,    -20,    146,
        58,    -21,     73,    -35,   -101,    -23,  -4068,   -116,
        49,   -196,     -5,     -2,      0,      1,     -1,      0,
      -292,   -195,     51,   -714,    172,     44,   -119,    134,
       168,    107,    -74,  -2379,    308,    173,   -252,  -3470,
      -135,    641,    -10,      0,      0,      1,      0,      0,
       146,   2060,    -84,   -164,   -247,     26,  -1724,    216,
       226,  -2499,    312,    -66,    850,     41,     -1,     20,
     -1339,    411,      0,      0,     -1,    -12,      0,      0,
       921,     17,  -3510,   -119,    325,     34,    -97,   -205,
         3,   -188,    252,     91,      0,   -135,    -76,    208,
       199,   -202,     -1,      1,      1,      2,      0,     -1,
       -88,   -461,    319,   -963,    266,   1540,    643,  -3424,
        76,  -1058,    501,    342,    297,    268,   -158,   -103,
        26,    -30,      0,     -1,     -1,      0,      0,      0,
       211,    245,    183,   1579,    106,     26,  -3450,    -22,
     -1053,   -266,   -736,    113,    475,   -241,    117,    -85,
      -492,    372,      0,      1,      1,      0,      0,      0,
};

static const int16_t cb0806ss0[] = {
      -381,  -1638,  -8192,      5,    983,  -1481,    -20,   -719,
      -238,    767,    571,   -200,    754,    460,   1678,   1376,
      -155,  -1998,    294,   -455,     80,      2,     26,      3,
        10,     25,   -931,  -1098,  -1166,  -3221,  -1995,    702,
       104,  -2429,  -2270,   1372,   2326,    -37,  -1492,   1692,
       644,  -1283,    363,    624,   -483,    -15,    346,     -6,
         2,      0,      1,      3,      2,  -2429,  -8192,   -956,
      1190,    706,   -955,    367,    959,   -194,   -723,  -1104,
       375,    554,   -962,   -229,     66,    368,     18,   -150,
        56,    968,    -15,      0,     -1,     -5,      0,      9,
      -250,   -720,   1910,    827,    198,   -645,   2021,     32,
     -1972,   -705,    441,    373,    800,  -2293,   1747,   1504,
      -537,  -1731,  -1192,   1597,  -4031,     24,      0,     -2,
         1,      1,      1,   -131,   1594,   -153,   1127,   2732,
       469,   -558,    -11,   1190,    115,   -933,   1988,   1841,
     -4530,   1385,    571,   2399,   1709,    -63,  -3663,  -2681,
        57,     -4,     11,     -4,      0,     -3,    426,  -4257,
      2755,    -76,  -1667,   2450,   -373,   3375,    -91,   -232,
       511,    648,    886,   1182,   1667,     65,  -3029,   -579,
       865,   2186,   2911,    537,      0,      2,     -3,      0,
         7,    585,   8192,  -2855,   8192,   5527,  -5491,  -1926,
     -4231,  -1204,   1953,  -1193,    191,   3278,  -1726,    259,
     -2794,   4205,   4315,  -6121,   -606,  -1922,   3666,   -324,
      -238,   -313,   -720,  -1447,   -539,   -794,   3151,  -1726,
      3444,    876,    584,   -671,   -497,    407,    909,  -2183,
      2575,    246,   -673,    270,    824,   1784,   -201,   7329,
       589,    -70,     -1,      4,     -5,     -3,     -8,   -417,
       382,   2786,   -972,    520,   1154,    886,    521,   6032,
      -687,   3791,   -522,  -1226,    608,    428,    891,  -1524,
     -1015,   1147,   1278,    559,     -6,      3,      0,      6,
         2,     -3,    115,   3586,  -2847,     95,    460,   2832,
      2326,  -1665,   1720,    453,    965,   1154,    452,  -1721,
     -1375,   -269,   2138,  -2032,     55,   -674,   -870,   -124,
         0,      5,      0,     -5,     -3,   -283,   1077,   2604,
      1270,  -1082,  -1753,   6840,  -2502,    988,  -1790,   1378,
      1231,    438,  -1188,    286,    540,   -138,   1054,   -111,
     -2321,     74,     56,     -3,     -2,      0,    -32,      5,
      1539,  -1399,   7413,   -903,  -1698,   1781,   -255,   -466,
     -1436,   3419,   1916,    852,    590,  -1126,  -1617,  -1309,
     -5560,   -241,   3363,  -1225,   2682,    620,     -6,     58,
         2,   -186,    -17,  -2959,    619,   2228,  -2627,  -3119,
       730,   3716,   -538,   -101,  -1863,   -516,    142,  -2384,
     -1514,  -5506,   -825,    514,    714,    746,  -2790,    569,
      -425,      4,    -68,     70,     24,     12,    817,   -276,
     -3363,  -2942,    103,   -581,   -925,    651,    561,     43,
       434,    712,   -541,  -2042,  -1291,   -453,   -443,  -4312,
     -1344,   1277,    605,     -4,      0,     -1,     -1,      1,
         2,   -930,    276,   3219,   -404,   -944,   -497,    840,
       278,    -98,  -1432,  -1136,  -1975,  -1863,  -1102,  -1446,
       938,    693,  -5186,     -1,   1085,  -2275,      1,      1,
        -1,     -1,     -2,      3,  -1194,   -312,  -1257,   1973,
      1570,  -1703,  -1637,    639,   -855,   1925,    970,    604,
      1313,    780,  -5170,   -603,    220,   -731,   2952,   -872,
       166,     30,      0,     -2,     -1,      3,     -1,   -743,
       504,   1363,   1436,   1632,   -634,   -709,  -2346,     87,
      1149,   3468,   2132,   3028,  -1039,    -92,   2087,   -990,
      -301,    966,   -773,  -1057,     42,      0,     -2,      0,
         2,      2,    252,    217,   3625,  -2323,    212,   -381,
     -1121,   1664,   -307,   1680,   2193,  -1854,   -187,  -3100,
       254,   -673,    595,   1995,    669,   -687,   -509,     13,
         0,      8,     -3,     11,     -3,   -552,    -87,      6,
      2933,   -267,  -1392,     40,    644,     32,   2966,  -1386,
     -2480,   -956,   1160,   1399,   1049,   3902,  -2092,   -525,
      1724,     69,    -33,      0,     -2,      0,      2,      2,
      -452,  -4739,  -3237,   -510,   -598,  -1397,    855,   1573,
      2143,    -79,  -1546,    -17,   -973,  -2400,   1689,    133,
     -1213,    784,    726,    916,   -388,   -390,      1,     -1,
        -3,     -1,      0,    170,   -205,  -2905,   8192,   -465,
      3119,   4407,   -709,   -403,    859,   -373,  -1301,  -1397,
      -750,    -88,    277,  -2097,   -222,   -134,    -88,  -1189,
       974,    -56,    -57,    -83,    -21,    102,    626,   -114,
     -2304,    979,  -1836,   -868,   1261,   2226,   -261,    579,
       983,    655,  -2578,   1803,    117,  -1128,    365,   3971,
      3539,    -21,   -790,    -62,      2,      3,     23,     -3,
        31,   1273,   3212,  -1617,   4116,   -281,    725,   -284,
      1079,    293,  -3759,   2581,  -1617,   -259,    -19,  -1999,
      3040,  -3077,  -1522,   1056,    -92,    897,    243,     -1,
        36,    -19,    -10,    -46,    231,   1129,    363,  -1978,
      -882,  -1788,    319,   4807,  -1707,  -1379,  -1465,   2327,
      -827,   -681,    410,  -1816,  -2507,   1036,    740,    730,
      -687,    100,     -1,     -1,     -1,      1,     -4,   -276,
       303,  -2331,  -2912,  -1864,  -3694,    412,  -1218,   1642,
      4448,    658,   -213,    872,   2867,    227,    868,   -590,
      2293,   1759,  -1666,  -1585,   -140,      1,     -3,     -1,
        26,    -10,   -287,    898,  -2442,   3997,  -1655,  -1341,
       -56,    689,  -1869,    572,  -2044,    616,  -2603,   -278,
      2987,   2397,  -2055,    247,    128,    598,   1732,   -146,
         0,      3,     -1,     -3,      5,    842,    597,    779,
     -1529,   -802,   2142,  -1668,   2339,  -3550,  -2651,   1733,
     -1531,    -46,    600,    618,   -867,   -665,   1524,    392,
     -1386,  -3279,     45,      0,      9,     -7,     -3,     -8,
      -224,  -2632,   -147,   -505,   2223,   1773,   1799,  -1696,
       194,  -1186,   -543,    775,  -1171,   5491,  -2319,  -3193,
      -313,   -355,   -133,  -1097,    125,    -22,     -2,      2,
         1,     -3,    -10,   -354,  -1447,   -662,   -313,  -4302,
      3888,   -121,   -323,   1112,   -801,  -1513,   -814,  -1646,
      -616,  -1207,    347,    483,    670,    900,    -35,   -885,
        14,      1,      0,      1,     -2,      7,   -432,   -486,
     -1539,    785,   4853,    904,    925,    895,  -1223,  -2464,
      3395,   -506,   -808,    207,    197,    874,   -928,   1347,
      -107,   1512,   1063,   -182,      1,     -4,     -1,     -6,
         3,  -1236,  -1047,    774,     26,   -630,    863,   1055,
     -2632,  -1187,   -534,   -619,  -1079,  -2574,  -2037,    658,
      1229,   -262,   2702,  -3393,  -2187,   1764,     66,      0,
         7,      0,      7,     -3,    677,   -444,  -2111,  -5256,
     -4485,  -1667,   2077,   1613,   1483,  -1520,   1600,   1767,
      1148,   2054,   1676,   1866,    783,  -2199,    765,    568,
      2779,   -683,      4,     17,      0,    -32,     15,     45,
       228,  -2445,    752,   2510,  -1657,  -1039,    113,   1107,
     -1054,  -1765,  -1245,  -2527,    589,    455,    328,    640,
      -579,   2370,   1313,   -540,     31,      1,     -1,     -4,
         2,     -3,   -235,   -560,    455,   3809,    102,    403,
       -21,   1844,    402,    148,    -32,   5573,  -3765,   -265,
      -718,   -399,   -349,    366,  -1105,     91,   1881,     34,
         1,      1,      5,      0,      9,    289,  -1146,    795,
     -2504,    412,   1156,   -302,   -946,   2063,  -2569,   -273,
     -1434,    141,    642,   -631,   4856,  -1008,    169,    -40,
       191,  -2293,    -86,      6,      1,     -2,      0,      1,
       139,   1955,  -1111,   -944,    140,  -1074,   1071,  -1312,
      -541,    664,   1801,   -892,   1605,  -1750,   -654,   -680,
     -8102,    120,    -24,   1014,   -351,   -120,      0,     -2,
         1,     -1,     -1,   1038,   5199,    779,  -1195,    128,
       462,    184,   3705,  -1292,  -2247,  -2481,   2610,   4396,
      4161,   4039,   1111,    838,    188,   -571,   2811,  -1915,
     -1909,     13,     99,    -20,     -2,     11,    395,    155,
      2667,   -202,  -2639,   1303,   -912,  -1734,   1097,   -583,
      3532,   -218,  -1514,  -3881,    378,    -46,  -1189,   -957,
     -3010,   -743,   -648,     15,      1,      3,      3,      4,
        -4,    330,    198,   -275,   -677,  -8192,   -629,   1953,
      -783,    592,    926,   1487,    -39,  -1002,   1134,   1560,
       -27,   -118,  -1363,   -360,   2163,    442,     92,      1,
         1,     -2,      5,      1,   -670,    326,   2773,   1346,
       -26,    327,    184,  -1091,   -121,    576,  -1324,    212,
      -645,    860,  -2111,   -493,  -2119,    316,   -688,    475,
      -652,    -33,      0,      1,      2,      0,     -3,     92,
       170,   6224,   2162,    761,  -1994,   2176,   1692,  -1773,
       561,   -966,   3406,    -20,   -593,    574,   -681,   1121,
      -335,   -412,  -2651,  -4712,    -79,      1,      2,     -1,
         4,     -6,    932,  -2579,    344,  -2614,   1119,   6623,
      -314,  -1068,    338,   1977,  -1375,  -1338,  -1996,   1310,
       118,   -500,   -393,    622,  -1798,  -1232,      3,    -75,
         0,     17,      0,     -2,     -9,    715,   8135,    400,
      3748,   2156,   1882,    772,   2728,   -403,   -775,   2110,
      1603,   -766,  -2592,    767,   -618,   4727,    668,   2280,
     -1157,   1246,   -794,    -14,     -2,      2,      5,     16,
      -107,    642,  -1806,   -158,  -2447,    309,   -764,   2313,
      -101,   -766,    209,   -691,   2001,    268,   -273,    615,
       803,   6062,   -434,   1287,   -543,     -3,      0,      0,
         1,      1,      0,    503,   -598,  -2043,  -1160,   1074,
      1255,   3269,   1405,   1182,    197,   3098,   -138,   2326,
      -244,   -772,    901,   -225,    337,    -65,   -536,   -331,
        15,      2,     13,      8,     -3,     20,    -32,    -52,
     -1012,    232,   1502,    -17,  -1574,   -741,    -57,    164,
       -22,     74,   -181,   1616,    296,  -1483,   1387,   -357,
     -5380,   -322,  -1346,      6,     -3,      2,     -3,      1,
         0,   -392,   -811,   -650,   -485,   3038,   2750,   -776,
      -503,  -1664,   -323,    253,   -280,  -3459,  -1313,    541,
      2182,   1287,   -782,   1785,   -695,    -49,     72,     -4,
         0,    -15,      3,    -21,   -211,   1382,   -149,    684,
      2210,   2654,  -1440,  -1209,    152,   1080,  -3078,   -694,
      4738,    985,  -1337,    819,   -518,   1799,   -671,   3201,
      2636,      7,      1,     -6,     14,    -31,      0,    -34,
      4296,    -23,    194,   1976,   -993,   1353,    709,   -342,
     -1142,   -140,   -271,   2291,   -709,   1734,    818,  -3571,
      1125,    912,   -590,    784,   -275,     -2,     -1,     -5,
        -1,      0,   -381,   2754,   1545,  -2270,   3608,   2308,
     -1899,    178,    391,   1826,   -127,  -1417,   -822,   -712,
      1682,   2225,   2247,    446,    994,     56,    734,    196,
         7,      3,      8,      0,      7,    639,    833,  -3313,
       675,   -263,   -648,   3016,   -701,    235,  -1304,   -582,
     -2930,   -210,  -1243,    374,  -3095,  -2013,    354,    599,
     -1469,    140,    -17,     -1,     -3,      2,      0,     -2,
      -183,    399,   -603,    796,  -1424,   2685,  -3929,    416,
     -2291,   1737,   1906,   1667,    810,   -222,   3242,  -3636,
      5196,  -1542,    940,   -124,   2047,    -67,     -4,      6,
        -1,     13,      2,   -161,    417,   4132,    492,  -1068,
      -817,   2732,   -250,  -1457,   1723,   2104,   1121,  -1276,
      1147,    990,   -523,  -1533,    297,   1219,   3901,  -2549,
       -22,      0,      0,      0,      0,      2,  -1632,    172,
       829,   -747,  -1229,  -1990,  -1070,   1134,   1623,    228,
      3689,    625,   -757,   8192,    -82,    738,    213,   1900,
     -1200,     91,    892,    -45,     15,     -1,      5,     -4,
         5,    392,  -3067,  -1903,    139,    661,     43,   2174,
     -1919,   -270,  -1490,   -569,      2,     85,  -1091,   6740,
       886,     85,  -1052,   -647,   -563,  -2971,   -145,     -1,
        39,     -5,     -6,     -7,  -1023,  -1104,  -1774,  -3154,
     -1058,   3488,  -2551,   3547,   -253,   -204,   -235,  -1544,
       -73,   -584,   -302,  -3118,  -2314,   -308,   1790,    916,
       152,   -155,    -11,      6,    -26,     -1,    -31,     21,
       919,  -1856,   -456,  -1050,    663,   1454,  -1515,  -2606,
     -4287,   1553,   3564,   1334,   1797,   1540,   -392,   -701,
      -971,  -3442,    281,   -271,    133,      1,      5,      4,
        32,      3,   -521,  -1530,  -1368,   1787,   -515,   -913,
     -2391,     93,   2690,   -578,   -576,  -1656,    554,    649,
     -1509,   -258,   -605,   1233,  -2258,    640,    837,    -43,
         1,     -3,      0,      5,      3,    148,  -4761,   1783,
      3244,   -277,  -1139,   1539,  -2016,   1898,  -1276,   -776,
     -1725,  -1900,    -51,    559,    311,   1737,   -928,   3687,
     -1087,   1329,    134,      2,     -2,     -7,      9,      5,
       -77,  -1116,   4986,   -940,   -905,  -3229,   -773,   3335,
       -23,    578,  -2376,    386,    122,   1253,    363,  -2748,
      -512,  -4612,   1690,    848,  -1116,    195,      5,      2,
        11,      1,     18,    659,  -1282,    562,   1170,   4701,
       903,    490,  -3508,   3468,    -39,    654,  -1196,   -909,
      -268,    980,    283,   3221,    348,   1121,   -897,  -1011,
      -103,    -11,     -2,     -9,     16,     -8,   -274,  -4100,
     -2312,  -2379,    617,   1629,   2154,   3026,  -1737,   -603,
      -803,   -366,    977,   1035,  -1835,   -255,   -275,  -1245,
      1274,   -161,  -4476,   -181,     -4,      0,     -2,      1,
         2,    156,    551,   -832,   -630,   3740,  -2115,    344,
       229,   1295,     65,    290,  -1462,  -1794,   3297,  -1049,
      2451,    322,  -2642,  -2810,  -1246,    613,     90,     -1,
        -1,      0,      0,      0,   -277,    854,   1259,   1542,
      -433,   3601,   -453,   1091,   -113,   1438,    994,  -2746,
      -786,    867,   1422,   1093,  -1723,  -1167,  -1389,  -1062,
      -436,    -81,      2,      1,     11,      1,     26,   -197,
};

static const int16_t cb0806ss1[] = {
      1760,  -4335,   6384,  -2036,   2874,  -2504,  -1529,    102,
      6995,  -1267,  -3141,   1050,    -59,   1556,  -1002,   1536,
      1024,   1867,     40,  -1156,  -2627,   -213,  -1034,   -660,
       291,   -963,   -323,    462,   -804,   2219,   -859,   1709,
       550,  -3390,    319,     24,    644,   3154,   4503,  -1961,
       744,    194,   -151,  -1255,  -1318,   3033,   -899,    -18,
         1,      0,      2,      0,     28,  -1213,  -3725,  -2525,
      -177,  -1164,    361,   -357,   -649,   -459,   1324,   2463,
     -3108,  -3323,   -575,  -2744,   -108,   -121,   -508,   -564,
      -849,   -773,   -288,      0,      8,      0,     -2,      5,
       691,   -602,   2269,   2373,  -2027,    786,   3011,   3234,
     -1387,   -310,    659,   -358,   1058,  -1554,   1031,    795,
      2254,   -549,    334,    325,    599,    -36,     -1,     -1,
        -2,      3,      4,   -450,   -533,  -1657,  -1928,  -1034,
      -636,  -1446,   -320,   2695,   1184,    697,   1126,   1159,
      2970,    449,    -30,  -2058,  -1171,   -684,    -66,    905,
       -43,      1,      0,      3,      0,      3,    228,    272,
       -79,   -718,   1978,    667,  -2760,   1507,  -1893,   -796,
      1164,     35,  -4440,  -4492,  -1667,   4189,   6485,   -495,
      1721,  -1639,   -526,    458,      0,    385,   -183,    511,
      -153,  -2025,   -376,   2948,  -2606,   -910,   -741,   -427,
     -1080,   2128,    565,   -483,   1791,  -2222,    -45,  -1204,
       799,    512,  -4790,   1462,    511,  -1906,     15,      0,
         0,      1,      3,      8,   -867,   -685,   -140,   5299,
       376,   -891,   1657,   1843,  -1465,  -1297,    518,  -4640,
       303,   -277,   -650,    -97,   2308,   -679,    720,   -171,
      -475,   -269,      0,     -5,      4,     -1,      9,  -1155,
     -4954,   1684,  -2045,    939,    819,   -751,   -165,    -93,
     -2327,    306,    965,   4999,    557,    -55,   -999,     30,
       -36,    989,  -1680,  -1594,    318,     -3,     -8,     -4,
         1,     -9,   -402,   8192,    475,   2080,   -418,  -1739,
      -273,    -55,   -441,    794,    -79,    272,  -2039,    789,
      2266,    874,   2495,    627,   2203,   1212,  -1052,    389,
        14,    -24,    -59,     10,    133,   -535,  -1160,  -1139,
      -146,    180,   1064,   3718,  -1412,   1153,   1873,   -549,
     -1698,  -1479,    209,    725,   -940,   2152,   1848,    678,
      2493,   4608,    -11,      0,     -1,     -3,     -3,      2,
       334,    681,    673,  -8192,   3958,  -3111,   1641,   1500,
      1184,   -268,  -3147,    571,    958,   -663,  -1031,   -870,
      -674,  -1098,   -529,     78,   1212,    120,     -8,    -13,
        -5,    -42,    -37,   -498,   1304,  -2541,   1730,   -355,
      1462,   2315,   2017,   -403,  -2010,    555,   1391,    887,
      2039,    366,    135,     85,    371,   1291,   -225,    335,
       -45,      0,      1,      2,     -1,      2,  -1095,   -261,
      3249,   3212,  -1877,    934,  -1671,  -1289,   1398,  -2287,
      -205,   1659,    642,   1105,    751,   2864,   1171,  -1001,
       318,   -290,     60,    -54,      5,      3,      5,      2,
         1,   -105,    590,     36,   -194,   1832,   -639,    777,
      3243,    578,   2820,    428,   2020,    623,  -2104,    -52,
      -331,  -1015,   3064,   -347,   -303,  -1100,     61,     -1,
        -1,      0,      2,     -1,    592,    127,    887,  -1094,
     -2819,   2573,  -2670,  -1693,  -2775,     48,   -266,   -961,
      1220,   -472,    167,   3201,   1118,   -173,   1304,    -26,
      -899,     76,      0,      3,      0,      1,     -1,   -718,
      -746,    947,   -524,    142,    958,  -1609,   -777,  -1362,
       385,   -578,  -6947,    157,   -290,   1357,  -1703,    484,
       117,  -2224,  -3736,   -838,    -96,     -1,     11,      5,
         4,      2,    475,   -426,    500,   -767,  -2304,   1248,
      2200,  -1829,   -992,   -225,   -573,  -1107,   -832,   2555,
     -2866,   3453,   4335,    -88,  -1160,  -1666,    -94,    -33,
         0,      0,      1,     -2,     -7,   -147,  -8192,   1204,
     -1181,   -702,   -604,   -770,   1032,   -173,    770,    861,
       611,   -509,    802,   -467,    839,    491,   -785,    523,
      -669,     73,    -34,      0,      0,     -2,     -3,     -3,
       286,  -2183,  -1238,   1743,    387,  -2228,  -1404,  -3439,
     -1701,  -2371,   -451,   2294,   2061,   3062,  -1122,  -1489,
     -1274,     51,   5649,   -170,   2197,    365,     -1,    -13,
         4,      3,     -5,    -15,  -4099,    789,   4132,   4982,
     -1996,    784,    748,   2123,   3535,  -1493,  -1454,   -344,
      -867,     40,    831,  -1198,     66,    542,   1633,  -2402,
       117,   -119,    -18,     49,     18,     40,   -500,    808,
      -726,   1192,   3623,   1526,   -484,   1080,  -2502,   -579,
      1315,  -1887,     84,   1771,  -2902,   1387,  -1098,   1559,
     -1126,    652,   -896,     32,     -1,      3,      1,      3,
        -2,    233,    782,   8192,    566,   -701,   -352,   1047,
       581,  -1070,   3159,  -1157,  -1585,   1599,   -978,   -663,
      -931,  -2581,   5074,    781,   -551,   -590,   -247,    -63,
       -54,    -50,    253,   -138,   -313,    387,  -3004,  -1136,
       654,  -1283,   1318,    434,     80,  -1486,    694,   -512,
       393,   -238,   -700,   -232,    706,   1478,  -8192,    377,
       601,     18,     -1,     -3,      0,     -6,     -3,   2221,
      3531,   -862,   1792,   -242,  -3686,    420,   1891,    918,
      1324,    234,   -819,   -601,   2363,  -1097,   2355,    754,
      -125,    245,   -615,   3285,    204,      0,      6,     -4,
        -3,     -1,   -637,    673,   1233,   2886,    265,   -195,
      -226,   2521,    281,   -210,   1809,  -2733,  -3865,  -2287,
       641,  -2604,  -4235,    107,    789,   1163,  -2600,   -463,
        -5,     10,      2,    -10,     39,   1380,    754,  -5077,
      4061,  -1633,  -1738,  -1604,   1937,   1815,   1039,   3696,
      -593,   2218,  -1061,   1081,  -1217,   2062,   -637,  -1580,
       149,   -626,   -253,     -3,    -17,      2,     33,      1,
       118,    525,    158,   1213,    910,   -105,  -1437,  -1311,
      2255,   -419,  -2394,   1542,  -3830,  -1167,   -998,  -1099,
      1635,   1678,  -1112,   -275,    122,    -50,      0,      3,
         0,     -1,     -1,    998,  -4020,  -1913,  -1083,   -159,
      1853,   -436,   -683,    298,    211,    711,   4128,  -1977,
      -958,   1048,    642,   -420,    329,  -1150,    459,   2161,
        29,     -4,      0,     -1,     -6,      1,   1365,   1053,
      1032,    952,    854,   2405,   5106,   1863,   3049,    981,
      -863,   -397,    508,  -1283,   -631,     17,    532,  -1453,
     -1056,     66,    501,    -27,     -1,      3,     -1,    -13,
        -2,   -273,  -2924,    839,   -433,   -395,   -252,   1945,
       195,   -307,  -1297,  -1474,   -985,   4412,  -1017,   1074,
      2711,    996,    919,    183,    -10,   -605,     38,      1,
        -1,     -1,      2,      1,   2115,   -422,   3655,  -1972,
      1473,  -2033,   2461,  -1112,  -1267,    179,   -394,   -906,
     -1273,   -432,   1082,    367,   -720,   1746,   -657,    595,
       701,     16,     -1,      0,      0,      2,     -3,   -255,
       443,  -1840,  -2379,    296,    258,   -675,   -221,    406,
      -216,  -6295,  -1041,   1062,    199,   1705,  -1032,  -1627,
     -2399,    198,  -1097,   -271,    -99,      0,      1,     -2,
         2,    -13,    343,   -219,  -1447,   1779,    630,  -1944,
     -1093,  -1578,    -62,  -1334,   2811,   -815,   1311,  -3102,
      -300,     67,     24,     98,    764,  -1246,    203,      6,
         0,     -4,      0,      1,      0,    -18,  -1704,  -1427,
      -352,  -2665,   -588,    287,    715,   -454,    688,   -424,
      1736,  -1124,   1028,  -7581,   -752,   -482,   -363,    -75,
      -720,   -619,    449,      0,      3,      0,     16,     -3,
     -1211,   2484,   3490,   -547,   -705,   1776,   -286,  -1580,
      2896,  -2257,   -214,  -1784,  -1266,   -562,  -1170,   -542,
       785,   1606,    535,     51,  -1405,     -7,     -1,     -1,
         0,     -1,      2,   -428,   -579,  -1091,  -2627,   2287,
      -757,   1445,   -411,   -160,    567,    108,  -1305,  -4356,
      -390,   -917,    345,  -2169,   -896,   3772,   1224,    691,
       -25,      1,      1,      1,     -2,      1,    281,   1365,
     -1628,   -585,   3485,    169,    746,   -395,   1072,   1569,
     -1073,    744,   1274,  -3472,   1035,   -906,  -3394,  -1537,
      -869,   2841,    401,      4,     -1,     -3,     -3,     -1,
        -3,    -37,  -1628,   -888,    785,   3328,   1105,   3551,
      6946,  -1688,   2690,  -2051,  -2212,  -3750,  -1903,   -497,
      1251,   1187,  -6198,   3930,     85,  -1077,     16,    -23,
       -80,   -130,     43,     66,   -974,    579,  -2047,  -3607,
      -666,  -2248,   4619,   6846,     88,   -649,   1129,   -255,
      3567,   -124,     41,     58,    634,  -1252,    696,   2536,
     -1590,    209,     12,   -102,   -275,     27,    216,   1110,
       259,  -2091,   1775,  -3768,    598,    441,  -1809,   -431,
        22,   -991,   -621,     84,  -1803,   1585,    559,  -1101,
        42,    456,   -392,   -874,     -4,      0,      0,      1,
        -1,      0,   -371,   -211,   -339,  -1232,    438,  -2683,
     -1007,   1250,   5343,    861,  -1305,   -577,   2107,  -2649,
     -3227,   1020,   -127,    562,   5495,  -3136,   -414,   -529,
        12,    -53,    -34,    151,    106,  -2946,   -575,  -1796,
      3095,   -257,   -591,    126,    967,   -547,   -271,    560,
       974,  -3335,  -2110,  -1403,   5915,  -1108,    388,  -1266,
      -522,    336,    167,      1,     -3,     -2,      2,     -3,
      -312,     19,   3356,   1123,   -676,   -247,    697,    548,
      1768,   1174,   -525,   -253,   -423,    546,  -2373,  -2940,
     -1055,  -2304,    203,   1309,   -574,     -8,      0,     -3,
         4,      0,      4,   -215,   8192,   -670,  -1289,  -1547,
      -304,   1498,   -967,   -529,   -582,  -2205,   1752,    321,
       573,  -1096,     64,   1152,    -87,    574,   -250,    539,
        62,      7,      2,     -1,     -3,      3,   -465,    243,
     -1179,    828,  -2501,   -223,    198,   -883,   -740,   1113,
     -1821,  -2068,  -3234,   1715,   1989,   1817,    727,   1640,
      3386,  -1538,   -864,     45,      0,     -4,      0,      0,
         2,    608,  -1495,   1259,   -132,   1311,    350,    537,
      2735,   1428,    151,   1324,    547,  -3983,  -1892,    104,
      2023,   1908,  -1042,   1130,   1252,   -701,      9,      0,
        -2,     -1,      1,      1,    602,  -8192,  -2776,   -661,
      1640,    443,   3452,   -738,    829,    637,    292,    232,
      1352,   4879,   1429,    912,    649,   1593,    308,   -330,
        68,     63,     -3,      4,    -57,     26,     25,   1250,
       400,  -4839,    211,  -2748,   -664,    996,    341,  -1053,
       321,   2458,    764,    743,   -729,     12,   -283,   -346,
       118,   -249,   -153,  -2329,    -37,      0,     -1,      0,
         1,      1,    352,   -878,   2336,   -634,  -2690,  -3415,
     -2949,   -531,   1259,    394,    163,   -994,    845,   1259,
       890,   1400,    279,   1908,    161,  -2174,   1876,     76,
         1,     -1,     -1,     10,      0,     47,  -1123,   1611,
       489,    618,   -816,     -7,   2001,  -1190,   1857,  -2749,
      -311,   -331,    733,   1412,   1390,  -1525,   1262,  -1393,
      -263,   3124,    -98,      0,      1,      0,      1,     -2,
       514,  -3533,  -2394,   3623,    249,  -1056,    515,   1279,
      2821,    477,    183,    689,   1182,   1378,   1287,   -711,
      1264,   -713,   -278,    217,   -664,   -225,     -1,      0,
         6,      2,      9,  -1171,   3119,   1340,  -1229,  -1929,
      1984,  -1333,   1018,     10,   1205,     63,    358,  -1108,
      -455,   -413,    854,  -1550,   -423,   -180,   2529,  -8192,
       -18,      0,     -2,     -1,      0,      0,   -678,   3819,
     -1316,   1159,    590,   -231,   2203,  -1533,    986,   4289,
      1114,   1135,  -1162,   -921,    -58,    691,     11,  -1718,
      -270,   -531,    530,     65,      0,     -1,      1,      4,
         0,  -1184,  -1359,   7230,   -533,  -2077,  -1188,    113,
     -1472,    490,   1518,   1476,  -1885,    934,    244,   1840,
      -696,   -480,  -2476,   3324,  -2433,   1102,    120,      1,
       -11,     -2,     18,     -3,  -1016,    189,  -3835,  -1659,
       -46,   -180,  -2659,   1998,  -1437,   1107,  -2248,    165,
      -657,  -5079,   -224,   1246,    469,    421,   1145,   1148,
        84,    -18,      3,      0,      0,     -6,      0,    -66,
      -206,   2279,   -220,   1606,   -421,  -1482,   -413,  -1237,
       374,   3691,    491,   -774,    410,    791,    380,   3385,
       615,   -950,   -620,   -197,     65,     -1,      3,     -3,
         2,     -1,   -484,   1396,    273,  -3591,   1317,  -1013,
      1563,   -134,    602,  -1069,    733,  -1167,    233,    319,
      -262,    350,    780,   -407,   -496,  -1285,   1326,    -13,
         0,      2,     -1,      0,     -1,   -328,   -626,   -848,
       745,  -1047,   4048,   -380,   -456,  -1894,    869,  -1085,
      -373,   2829,    622,    473,    394,    237,  -2175,   1167,
     -4942,    246,    100,     -1,      1,     -6,      1,     -6,
       -70,     35,   1613,   2597,   1307,   1756,  -1184,   1082,
       971,  -2004,  -1459,   -494,    -40,    745,   2788,   -830,
        76,    536,  -2002,    401,    -57,    -20,      0,      0,
         0,      0,      0,     -8,    244,   1927,   1162,  -2416,
     -1414,    463,    -89,   1217,   -798,    394,  -1527,   -719,
      -666,    998,   1518,  -2455,  -3049,  -1174,  -2696,  -3119,
         2,      0,     -2,      2,      2,      3,   1093,   -623,
      1660,  -1635,   1457,   2560,    763,  -2750,    931,   1798,
      2550,   1402,    914,   -919,   1931,   -383,   -435,   -583,
       439,      9,  -1106,    -12,     -1,      0,      0,      0,
        -2,   -335,   -730,  -2102,  -1414,   2576,  -3869,   1025,
     -1657,     -2,    857,   -336,  -3011,    205,   1108,    364,
      -789,   -179,    171,    331,   2204,    527,    -13,      1,
        -3,      2,      1,     -4,   -565,   -211,   -139,   1799,
       195,   -877,   -632,    358,   -244,  -1459,   1398,   2271,
       550,   1987,   2206,   -337,    199,  -7036,    589,    195,
      -466,     72,     -1,      2,      1,      0,      0,    -27,
};

static const int16_t cb0806sm0[] = {
     -8192,    389,    245,    -67,    -42,     79,    503,   -488,
      -310,    107,    -13,   -431,   -203,     96,    510,    151,
       270,      0,      0,      0,      0,      0,   -463,    -23,
       -72,   -322,     74,   1589,   -152,   -198,     81,   1120,
      -125,   -434,  -3275,  -2210,   -348,   -344,     91,      0,
         0,      0,      0,      0,   -254,   -224,     46,   -154,
      -131,   -465,    -57,   8192,    345,    112,   -725,    -49,
       183,   -191,    246,    263,    370,      0,      0,      0,
         0,      0,     39,   -739,  -6603,  -2454,    -95,    312,
       -53,   -392,     63,   -165,     31,   -505,    111,    484,
      -535,    179,    143,      0,      0,      0,      0,      0,
      1279,   -139,  -1769,    244,     59,   -135,   -429,    707,
       809,  -4355,   -354,    428,   -300,    108,   -799,  -1421,
       599,      0,      0,      0,      0,      0,      4,     -5,
         7,     75,     49,   8192,    276,    200,    191,   -167,
       -14,     82,    222,   -277,   -483,   -216,   -441,      0,
         0,      0,      0,      0,    171,   -423,    174,    401,
      -517,   -377,   -234,   -644,   -829,   -350,   -976,   -146,
      -928,    296,   3003,   3545,    -30,      0,      0,      0,
         0,      0,    161,  -6753,   1138,   -855,   -132,   -242,
       559,   -225,   -346,   -168,     10,   -481,     -6,  -1208,
       252,   -323,   -191,      0,      0,      0,      0,      0,
      -262,    574,    433,   -145,    622,    329,  -2634,   -439,
     -1178,    351,   -433,   -842,   4125,    296,    305,    359,
       -22,      0,      0,      0,      0,      0,    -34,    -56,
     -1019,   -247,   -163,    305,    574,    -51,   -179,     24,
     -1097,    248,   -166,    -18,    303,    252,   -555,      0,
         0,      0,      0,      0,   -400,   -254,   -256,   2783,
      -296,  -1904,    552,   1284,   -336,  -2371,   3396,  -1092,
       102,    176,    140,    640,   -359,      0,      0,      0,
         0,      0,    373,    473,  -2167,   -774,   -388,    405,
     -1402,  -1391,  -1319,   -155,   1104,   -533,    382,   1561,
     -2958,    406,    787,      0,      0,      0,      0,      0,
     -3800,    -58,   2098,   -181,   -570,    385,  -4125,    759,
     -1584,      9,   -278,    201,   -528,   -527,   -435,    436,
       681,      0,      0,      0,      0,      0,     30,    -80,
       -60,  -4031,    -70,  -3367,    316,   -861,     67,   -169,
      -144,   1598,    966,     32,  -1263,   -434,   -738,      0,
         0,      0,      0,      0,    181,     12,    115,     91,
       253,    518,    517,    216,    830,    336,   -568,  -3125,
      -796,   -847,   1627,     58,   -158,      0,      0,      0,
         0,      0,     48,   -851,   -286,    393,    390,    707,
       595,    427,   -235,   -116,    814,   -198,   6145,  -1590,
       647,     15,   -259,      0,      0,      0,      0,      0,
      -621,    152,    590,    -16,    215,   -633,   -784,   -140,
      1087,    723,  -4191,   2701,    951,   -972,    273,   -554,
       387,      0,      0,      0,      0,      0,   -124,  -2939,
       -38,    383,    234,    687,  -2873,   -466,     61,   -472,
       854,   -396,    305,   -233,     82,  -2677,   -206,      0,
         0,      0,      0,      0,   -120,   -246,   -614,   -394,
      8192,     75,   -450,    177,   -251,     45,   -142,     65,
     -1248,    -14,    389,    375,    114,      0,      0,      0,
         0,      0,   2870,    158,   -473,   -166,    928,   -618,
     -1909,    224,   -931,   1898,    -16,    427,    447,  -1044,
        85,   -333,    197,      0,      0,      0,      0,      0,
        78,    114,   -167,     73,  -1070,    -80,   3512,  -3004,
     -1553,    769,    213,    851,   -377,    978,   1097,     71,
        66,      0,      0,      0,      0,      0,   -129,    248,
       455,   -376,    344,    128,    -60,    546,   -321,  -7898,
      -719,    -55,   -941,   1242,    207,    215,    323,      0,
         0,      0,      0,      0,    -24,   -225,    136,    142,
      -739,   -117,      2,    242,   -152,    -20,  -1775,   -484,
       -36,   -408,  -2767,   -471,    251,      0,      0,      0,
         0,      0,     22,    111,   -180,  -7417,    365,    293,
      -313,   1031,   -191,    154,   -210,   -239,    121,   -333,
     -1504,    209,    146,      0,      0,      0,      0,      0,
       898,   -643,   3080,    528,    -91,   -718,   -512,    275,
     -3564,    396,    160,   -850,    346,   -595,   1558,    684,
      -310,      0,      0,      0,      0,      0,    234,   -419,
      -724,   -433,    292,  -1003,    682,   -117,  -1318,   -914,
     -5137,    128,     53,    291,    408,   1269,   -284,      0,
         0,      0,      0,      0,   -252,    190,  -2911,    130,
       255,   -172,  -4331,     26,   -267,    280,   -133,   -613,
     -1063,  -1135,    759,  -1290,    216,      0,      0,      0,
         0,      0,    133,   -177,   4069,   -311,   -197,   3260,
       341,    201,   -117,   -515,    105,   -658,    975,     81,
      -333,   -333,    262,      0,      0,      0,      0,      0,
       273,    -87,    321,    190,   1385,    274,    182,  -2553,
      -150,    164,   -830,     89,   -459,  -5279,   -624,   -336,
       399,      0,      0,      0,      0,      0,   -172,   -232,
        11,     45,    121,   -254,   -457,    196,  -3487,   -838,
       512,   -310,  -2831,    -85,     98,   -145,   -331,      0,
         0,      0,      0,      0,    -55,   -149,   2068,    -61,
      3087,   -143,   1574,  -1381,   2853,   1899,   -453,   -580,
      -137,   1211,  -1413,    171,    125,      0,      0,      0,
         0,      0,   -228,     30,   -956,   5569,    209,    -89,
        25,    573,  -1669,    507,    182,   -132,    697,   -132,
     -2964,   -637,    139,      0,      0,      0,      0,      0,
     -3078,  -3278,   -771,    928,    -38,   -463,    820,   1141,
     -1234,    620,    652,  -1710,   -382,  -1618,   -409,    179,
       483,      0,      0,      0,      0,      0,   -102,   4256,
       -20,   -162,   2021,    730,   1439,   2776,    459,    498,
      -152,    482,     35,   -271,    810,  -1345,   -249,      0,
         0,      0,      0,      0,    131,      5,   -281,    431,
     -2498,  -1046,    482,    842,    297,   -311,  -1260,    148,
      -906,  -4217,  -1411,   -102,   -361,      0,      0,      0,
         0,      0,    116,  -3083,    235,  -1195,    -19,   -646,
        42,    487,    309,   1654,   1051,  -1643,    689,   -823,
      2279,   1488,    571,      0,      0,      0,      0,      0,
        42,    -95,     -3,     36,   -170,   -114,   8104,    217,
       140,   -217,    599,   -774,    -64,   -675,   -211,    166,
       204,      0,      0,      0,      0,      0,     99,    594,
       -48,    224,     52,  -1499,    271,   2224,   -219,   3184,
      -165,    828,  -1345,   -785,    181,    133,    124,      0,
         0,      0,      0,      0,   -235,   -286,    254,   -171,
     -4980,   -453,  -1432,     12,    734,   -391,   -640,    339,
       537,    313,   -700,   1016,    148,      0,      0,      0,
         0,      0,    -49,    -19,    803,    935,    520,    -90,
       641,   1053,   -454,   2338,  -6071,   -478,    616,   -559,
      -339,    445,  -1464,      0,      0,      0,      0,      0,
      -175,    111,   -132,     65,   -264,    732,    221,    231,
     -1972,   -305,    325,   -859,    583,   1272,   -441,   2651,
       229,      0,      0,      0,      0,      0,   -286,  -4646,
      -262,    593,    613,    936,    310,   -615,     83,    223,
      -816,   1910,   2041,    281,   -190,   -434,    114,      0,
         0,      0,      0,      0,   -123,    684,   -208,    524,
      -606,  -1223,    264,   -983,   -109,  -1057,    696,    195,
      -521,    945,  -7503,    193,   -120,      0,      0,      0,
         0,      0,     98,   -358,  -2165,    244,    277,    393,
       771,   3360,   -258,  -1218,   -122,  -1253,  -2297,    806,
      -198,    540,      7,      0,      0,      0,      0,      0,
        78,   -281,   -368,   2809,    159,   2611,    833,   -120,
     -3987,    933,    360,    -49,   -515,   -106,   -360,    650,
      -125,      0,      0,      0,      0,      0,    203,   1369,
       749,   -502,  -2295,   -326,    448,   -309,    630,    -84,
       345,   -520,     -4,   -623,   1066,  -3915,    373,      0,
         0,      0,      0,      0,  -4603,   -794,   -625,   -355,
      1071,   -601,   -553,    593,   -296,    626,   -328,    621,
        85,   1348,     92,   -288,    204,      0,      0,      0,
         0,      0,     -9,    602,   -162,   -749,   -104,    464,
      -372,  -1375,  -1905,   2200,     61,  -3308,   -897,    634,
      1036,  -2112,   -182,      0,      0,      0,      0,      0,
       -76,   2341,   -675,    -72,    -29,    704,   -536,   1656,
      -541,   -736,  -1420,  -1539,   2458,   -228,    674,  -1258,
        -3,      0,      0,      0,      0,      0,   -133,   1111,
        63,    327,    470,   1226,    541,   -276,  -3042,  -1594,
     -3192,    357,   -617,    658,   -315,   -978,    631,      0,
         0,      0,      0,      0,    111,   -188,    619,    236,
       104,     54,    545,    424,   5912,   -332,    711,  -1249,
      -533,    291,  -1544,   -216,    113,      0,      0,      0,
         0,      0,   -199,    267,    152,   -301,   -172,   1294,
      2311,   -482,  -2451,    -82,   1833,    214,    130,  -1183,
     -2212,    403,   -625,      0,      0,      0,      0,      0,
      -106,    662,    -48,   -131,    324,   2337,    445,    462,
      -349,   -189,    669,   4945,  -1797,     16,    268,   -602,
         2,      0,      0,      0,      0,      0,     55,    154,
       892,    -35,   -145,    357,    562,     42,     -9,   -284,
       177,     84,    422,   -181,   -358,   7618,     29,      0,
         0,      0,      0,      0,   -353,     68,    -41,  -4096,
       177,    -20,   -267,    782,    954,   -430,   1573,   -696,
      1785,  -3611,     89,   -243,    683,      0,      0,      0,
         0,      0,   -220,   1983,   -891,    614,    226,   -202,
        67,    761,   1904,    179,    226,    416,   -657,  -3409,
      1026,   2834,   -438,      0,      0,      0,      0,      0,
      -551,   -229,   -304,   -462,  -2277,   -419,    451,   -122,
      -108,    258,    784,   1105,    382,    137,   5695,   -241,
      -491,      0,      0,      0,      0,      0,     34,   -272,
     -1687,   1769,   -332,    365,     33,  -2594,   3729,    325,
        85,   -295,   -290,   -152,   2238,   -611,    -41,      0,
         0,      0,      0,      0,    102,    166,    241,   1098,
      -107,    775,   -414,   4256,   -277,    935,   -200,    495,
       255,   1144,    468,   -184,    -59,      0,      0,      0,
         0,      0,     94,   -282,    -57,     12,   -390,    245,
      1872,   -620,   1089,   3754,    432,    947,   -509,   -284,
     -3836,     26,    482,      0,      0,      0,      0,      0,
         9,    971,   -373,   1111,   -480,   2342,   -182,    528,
       802,   1196,  -1017,   -879,    499,   2800,   -830,   -230,
        -4,      0,      0,      0,      0,      0,   -382,   -815,
     -1669,  -2437,   -593,    193,   -688,    632,    479,   2883,
       565,    540,      5,   1598,   1618,   -640,   -246,      0,
         0,      0,      0,      0,   -421,   -103,   1482,  -3026,
       -65,   -101,      4,   3921,    688,   -941,   -234,     49,
       202,   1905,    935,  -1155,     -4,      0,      0,      0,
         0,      0,    210,   -625,   -118,  -3215,    344,    978,
       -10,    773,   -126,   -804,  -1534,    182,  -1146,   -646,
      -146,   2011,    463,      0,      0,      0,      0,      0,
};

static const int16_t cb0806sm1[] = {
        35,   -237,    547,    705,     -9,   1612,    382,    195,
      -191,   -250,   -101,   -357,    709,    153,    850,  -5091,
      -100,      0,      0,      0,      0,      0,  -6406,   -158,
      -527,    137,   -330,    580,   -484,     63,    541,  -1245,
      -205,    138,    247,   -489,   -147,   -132,   -863,      0,
         0,      0,      0,      0,     53,    -38,    283,    -22,
     -1506,   -467,   -418,    117,    133,  -2152,    -48,   -991,
       808,  -1047,   2402,    261,    423,      0,      0,      0,
         0,      0,    -14,    500,   4697,   -174,   -544,     87,
      -379,   -243,    577,    682,    258,  -1190,  -1984,    599,
       607,   -123,   -290,      0,      0,      0,      0,      0,
        60,   4254,    194,    888,    -81,   -395,    422,  -1786,
       916,    288,   1191,   -658,    502,   2177,   -977,   -301,
       587,      0,      0,      0,      0,      0,    232,    204,
      -452,   -853,  -4266,   -219,   1164,     92,     91,   1561,
       950,   -705,  -1217,   -734,   1617,    120,   -324,      0,
         0,      0,      0,      0,  -3442,   -456,   -667,    987,
       -89,   1383,   -704,   -187,   -280,   -583,    341,   -732,
       649,  -2129,  -3505,   -175,   -215,      0,      0,      0,
         0,      0,    200,   -635,   -471,  -1221,    215,   2844,
      1633,    522,   -720,   1722,   -272,    473,    198,   -604,
       480,    -88,    169,      0,      0,      0,      0,      0,
      -160,   -268,    130,    284,   -612,     95,     43,     42,
       641,   -258,  -6884,   -167,   -689,    123,    276,   -592,
       717,      0,      0,      0,      0,      0,    313,    -90,
     -4310,   2706,  -1708,    648,   -796,    791,    998,   -468,
       632,   1893,     43,   1937,  -1279,    -22,    -64,      0,
         0,      0,      0,      0,   -106,    135,   -287,    335,
     -7999,     51,   -250,   -388,     16,    285,   -101,    685,
      -944,    604,   -624,   -792,    209,      0,      0,      0,
         0,      0,    496,   -205,    422,     49,    274,   -229,
       220,     73,   -734,    381,   -394,  -8192,   -405,    755,
        -9,     46,    116,      0,      0,      0,      0,      0,
       -28,    332,   1152,   -129,    244,     84,  -2193,    632,
     -1854,   -384,    110,   -302,   -270,    435,  -1689,   -797,
       686,      0,      0,      0,      0,      0,  -1660,    624,
      -664,   2611,     30,  -1155,   -419,  -3539,   -568,   1719,
     -1374,   -676,    -55,  -1934,    863,   1391,    433,      0,
         0,      0,      0,      0,  -1012,    290,   2302,   -330,
       -95,  -2355,    -55,   -763,  -1995,   -298,   -680,    715,
       -85,   1615,   1011,  -1989,  -1028,      0,      0,      0,
         0,      0,     21,  -5001,    507,    -58,    229,    -37,
      -113,    632,   1809,    -62,    334,  -1201,   -893,   -344,
        98,    438,    -65,      0,      0,      0,      0,      0,
         0,    143,    131,    -18,   -135,   -306,    392,    232,
       265,    543,    376,   -562,    362,   2458,    785,   3653,
      -456,      0,      0,      0,      0,      0,    855,  -4009,
     -1207,    118,    -86,   -223,    266,    154,  -1886,  -1145,
       241,   -397,    246,    244,   -776,    808,   -132,      0,
         0,      0,      0,      0,      2,   -633,    113,    -94,
      -154,   -173,   -162,   -168,    439,  -6548,    778,   -392,
       -60,     99,  -1901,    171,   -130,      0,      0,      0,
         0,      0,    -11,   -324,    711,   -903,    560,  -1654,
      1473,   -300,   1048,    137,  -1140,  -1115,  -1302,  -1008,
      -792,  -3264,   -540,      0,      0,      0,      0,      0,
      -347,     78,   -103,     -7,     -3,    437,   6053,    299,
      -435,    323,    664,    477,   1097,    158,    656,    273,
       200,      0,      0,      0,      0,      0,   -101,     80,
      -153,    144,   -235,    492,   -399,     -3,   4958,    699,
      -586,   -162,    153,   -860,    161,    665,      4,      0,
         0,      0,      0,      0,    -87,   -189,   1744,   -350,
     -1840,    325,  -2354,   1193,   1386,  -1589,     80,   1055,
      -188,    273,    807,   2038,   -419,      0,      0,      0,
         0,      0,     50,   -185,     68,    -59,     -9,     78,
      -585,   -121,  -7888,    771,   -908,   -284,    349,    158,
     -1122,   -139,   -189,      0,      0,      0,      0,      0,
       310,   -286,    235,   -687,   -919,   -364,   -697,   -253,
       492,    300,   -238,    272,    518,   -525,  -5863,   -190,
       -59,      0,      0,      0,      0,      0,    151,    616,
     -4420,    227,    240,   -252,    516,   -250,     68,    411,
      -192,    -87,   -607,    671,   1281,   -317,   -305,      0,
         0,      0,      0,      0,     -9,    817,   -451,  -1079,
        86,   5060,  -1157,  -1159,   -421,    302,   1636,   -316,
       -66,   -518,   1010,   1068,     96,      0,      0,      0,
         0,      0,   -576,   -362,    107,   3516,    303,   -364,
      -402,    805,    574,    993,   -554,    298,   -925,    410,
      1898,     13,    138,      0,      0,      0,      0,      0,
      -340,   -150,    528,    142,   -464,   1034,   -397,   3944,
      -697,    962,    902,   1393,   2212,  -1021,  -1034,   -961,
      -319,      0,      0,      0,      0,      0,     58,     38,
       382,    221,   -212,    826,  -1373,  -4559,   1329,   -123,
       216,    -23,   -736,     95,   -300,   -418,     -4,      0,
         0,      0,      0,      0,    -58,   7814,    218,    141,
       -90,   -124,    455,    -27,     49,   -311,   -364,     80,
      -136,  -1257,     96,    332,   -287,      0,      0,      0,
         0,      0,     -8,    624,    127,   1857,   -480,   -869,
      -575,  -1461,   -493,   -261,     97,     32,   -328,   -467,
       173,  -2588,    132,      0,      0,      0,      0,      0,
      5257,  -1037,    191,   -844,    247,    130,   -571,   -548,
      -496,    216,   -161,    336,     62,    990,    130,    517,
       -65,      0,      0,      0,      0,      0,    -89,      9,
      -138,    405,   -701,   -479,   3605,    699,   -629,   -102,
        27,  -1374,  -1059,    -18,  -2707,   -172,   -557,      0,
         0,      0,      0,      0,    -67,    209,    571,    -93,
      -405,   -172,   -260,    -19,     86,     22,    659,   -630,
       222,  -8192,    106,    -34,     60,      0,      0,      0,
         0,      0,    -10,  -3386,    336,    651,  -1377,    681,
       -16,    -45,   -382,   1102,   -280,    169,   -822,    522,
       434,  -1111,   -299,      0,      0,      0,      0,      0,
       194,   -445,   -231,   -532,   -438,   -180,   -591,  -1680,
       179,   5921,   -184,   -685,   -467,    875,   -573,    282,
       235,      0,      0,      0,      0,      0,    339,    139,
      -745,    -68,   -201,    467,   -743,    477,    -23,  -1177,
      1384,   -357,  -1254,  -3760,    454,   1175,    252,      0,
         0,      0,      0,      0,    109,   -252,   8027,   -765,
       136,    111,    -86,   -593,    -84,   -750,   -121,    782,
       739,   -296,    284,    213,  -1196,      0,      0,      0,
         0,      0,    -40,     69,   1992,    452,    -75,    -84,
       683,   1678,  -1350,  -1846,   3068,   -749,  -1410,   -271,
       536,   1120,    117,      0,      0,      0,      0,      0,
      4053,    340,    108,    -88,    411,    990,    217,   3675,
       755,    752,   -206,    205,   -297,   -573,    188,    127,
      -313,      0,      0,      0,      0,      0,     47,  -2870,
     -3417,    216,   1730,    -83,    189,  -1615,   1016,    -44,
      -502,   2151,      6,  -1057,    550,    194,   -498,      0,
         0,      0,      0,      0,   -133,      1,   -387,   -497,
       586,    173,    923,  -4078,  -1232,    329,  -2086,   -185,
       592,    681,   3320,   -914,   -327,      0,      0,      0,
         0,      0,   -132,    493,   -179,    220,    142,  -4345,
       422,   -173,    357,   1317,    240,   -525,   1613,   -178,
     -1584,   -734,    549,      0,      0,      0,      0,      0,
      -337,    111,  -1238,    116,    302,    325,    189,    610,
     -3180,   -284,   -817,   1383,   1559,   -802,    422,    438,
       460,      0,      0,      0,      0,      0,    -96,    372,
       335,   -843,   3967,    221,    380,    227,    309,    447,
      -199,   -257,    372,   -397,   -534,    736,   -152,      0,
         0,      0,      0,      0,   -144,    463,    -54,   -288,
       -83,    115,   -574,   -229,    485,  -2643,     58,   4312,
     -1155,    642,   -647,   1122,    118,      0,      0,      0,
         0,      0,    157,      6,  -1017,  -1155,    687,   -288,
       918,   -212,   -332,  -2486,   -197,  -1025,   -546,   4099,
       155,   -731,   -333,      0,      0,      0,      0,      0,
       -43,   -496,   -546,   -541,    283,   -521,    -47,    -18,
       208,   -552,   1899,   2107,    588,    818,   -911,  -1104,
       -84,      0,      0,      0,      0,      0,    -71,     40,
      -326,     92,    216,   -106,   -255,     28,    120,    -58,
     -2720,   -133,   -288,    -28,  -1157,   1563,    400,      0,
         0,      0,      0,      0,     40,     -4,    559,   1350,
        30,   3905,   -675,  -1092,   -587,  -1524,  -1987,  -1031,
      1892,   -679,   -623,   1051,    -33,      0,      0,      0,
         0,      0,    -98,    106,    105,  -5887,   -463,    424,
       -42,   -506,   -589,    376,    840,    140,   -640,    771,
        23,   -441,     -6,      0,      0,      0,      0,      0,
        22,    203,  -3452,   -635,   -605,   1668,    422,   2973,
       394,  -1605,   -968,   -739,    344,  -1438,    820,  -1318,
       -26,      0,      0,      0,      0,      0,    258,    -32,
      1061,    643,   -152,     92,   -454,  -1305,   1621,    554,
       344,     82,   -404,   5222,   -344,    286,    177,      0,
         0,      0,      0,      0,     63,   -360,   -127,    814,
      3639,  -3322,    390,     12,   -515,   -493,   1515,   1706,
      -727,    394,   1164,    357,   -208,      0,      0,      0,
         0,      0,    -27,    648,   -342,   -125,   -327,    194,
     -3639,    598,     29,    244,    898,   -493,    372,   -635,
       567,     31,   -237,      0,      0,      0,      0,      0,
      -160,   2798,  -1768,  -2186,    493,    517,    -82,   -468,
      -290,   2890,   -460,    450,    414,   -265,  -1121,    219,
     -1115,      0,      0,      0,      0,      0,     14,     76,
     -2806,    338,  -1429,   -402,    253,   -130,   -235,   -799,
       309,   -525,   3823,    175,     36,    113,    247,      0,
         0,      0,      0,      0,    352,    521,    213,   -107,
       -71,   -762,    790,   -856,   -252,   -246,   -729,   -631,
      1258,  -3276,   1534,   -436,   -635,      0,      0,      0,
         0,      0,    -54,    118,   -453,   -124,    -32,    539,
       356,   -169,   -202,   -590,    721,   -444,  -6260,   -275,
      -239,   -105,    -52,      0,      0,      0,      0,      0,
      -464,    507,   -796,   1273,   2297,    790,    652,    392,
      3364,  -1949,   2154,   -701,   -229,     99,     88,    471,
      -524,      0,      0,      0,      0,      0,     71,   -914,
      1835,   -156,   -242,   -196,    513,    431,   -481,    -84,
      -734,   4501,   -510,    115,    461,   -428,     83,      0,
         0,      0,      0,      0,  -3987,   1063,   -717,  -2640,
      -963,   -667,   -147,    536,    -68,    422,    341,  -1916,
      -616,    996,    522,    568,   1174,      0,      0,      0,
         0,      0,      8,    112,    693,    392,    445,   5309,
       259,    121,   1670,    343,    176,    472,    197,    419,
      -240,  -1178,   -107,      0,      0,      0,      0,      0,
};

static const int16_t cb0808l0[] = {
       164,  -3637,  -3563,   -243,   -123,    -47,    -87,    -32,
        62,    129,     -2,    131,    -36,   -202,   -197,     37,
       -35,   -442,   -139,    -69,    -59,     29,    -62,    -67,
       -17,    -42,     74,     10,    107,     74,   -109,     40,
    -10210,    -33,  -3210,   -410,   -106,    512,     40,    -17,
       109,     67,     99,    170,     53,     34,    -68,    -16,
      3895,    -71,   -116,      1,    608,     66,   -215,     34,
        77,     50,    -45,    -73,      3,     11,    -33,     18,
       -34,     58,     25,   4420,     96,     77,    -67,     23,
       -83,  -6724,    226,    -32,   -150,   -154,     30,    -12,
        -8,     -7,     89,     42,    173,    -51,     38,  -1852,
        40,    -48,    -40,     81,     34,     81,     66,     16,
        20,      3,     99,     41,    123,     52,    154,     20,
       -38,      6,  10889,    -44,     22,    -39,     55,    -34,
        25,    -45,    -22,    139,     19,    -20,    -64,  -2242,
      -473,   -113,    316,    127,    -31,    128,   -363,   -124,
       196,    259,    -60,  -3792,    -41,   -103,    104,    -80,
      -389,    179,    110,     83,   3174,     60,   -197,    101,
        66,    -47,   -107,     96,    -27,     45,    -21,      6,
       116,    -51,     -8,   -594,    377,   -279,    158,   -159,
      4595,   -163,   -210,     19,      3,   -292,    -67,     14,
       115,    -41,   -125,   -154,   -263,   -101,      4,    -11,
       -89,    130,     58,     32,     92,     16,    126,    -93,
       -99,  -4239,    -69,     88,      5,   -113,    -18,     35,
        31,    -48,    -16,     35,     62,  -2839,     14,    121,
        19,     41,    125,   -102,     26, -13144,      6,    -30,
        -7,     60,      4,     36,    -40,    -26,     54,    -57,
        -9,    -30,     13,     -1,     73,   -131,     29,    256,
        39,    -51,    -12,   1788,      4,     10,    -58,     17,
       -36,     -2,     13,     59,    -20,    -21,    173,    129,
      -435,   -107,   -214,     33,   3078,     13,     31,    148,
     -2975,   -311,     38,     25,   -247,   -542,     34,    106,
      -392,     85,   -203,    182,   -232,    423,    629,   -183,
       800,   -466,   3145,  -2498,   -305,     39,     22,     41,
         0,    -14,    671,   -181,   3197,    109,   2900,     72,
       -64,      8,    414,    133,    244,   -263,     53,    -69,
        70, -13756,    -13,     21,     50,     12,    -14,    -12,
        -7,     97,    -32,     24,     51,    -24,    -29,     53,
        34,    -19,  -2341,    976,     25,    -58,     18,    -48,
     -2490,    -55,    -31,   -165,    -36,     28,    -26,     92,
        60,    137,     69,  -5341,   -125,   1966,   -154,    -66,
       -13,    -84,    -13,     81,    -46,    -96,     50,    -50,
      -114,     15,     30,   -211,   -147,   -555,   3998,     88,
       358,   -159,   -105,    -51,   -109,    -16,     70,     91,
       268,    125,    -95,    -62,     38,  -3227,   3591,    -15,
        92,    -72,    115,    144,    -40,    142,    172,     72,
       -17,     23,      1,     28,    -38,   -135,    220,    -80,
      -179,      9,    -32,     -6,     37,    -33,     -3,    -89,
      7314,      5,    194,    -13,     23,     31,     42,     84,
       197,   -163,   -251,   -273,    193,    206,   -613,    394,
      3469,   2587,   -701,     62,    301,   -104,    200,    164,
      -201,   -473,     52,   -473,    128,   -381,    404,    -69,
      -230,   -537,    157,    389,     -7,   2783,   3058,     95,
       -59,   1618,      1,      4,     53,     -6,     28,     10,
         2,     82,     28,     -8,    -14,     25,     59,     10,
        -4,     36,   -777,  -4984,     29,      8,     85,    -43,
      -137,    -34,     53,    -58,      1,    -27,     91,     15,
        80,    -19,   -186,    467,     94,   -382,    129,    327,
      3053,   -221,    399,  -2821,   1090,    278,     -2,   -163,
      -398,    126,   -266,    180,   -235,     70,    -18,    -34,
       -45,    159,    -32,     66,     11,   3177,   -188,     27,
        35,    -52,    114,    -28,   -136,    186,   2146,    100,
        92,      6,     58,    -70,    159,    -14,    -32,      9,
         6,    -27,    -73,     28,     23,    -24,    101,    148,
        80,    -52,    -27,    -53,    -36,      4,    -74,     47,
       -30,   -108,     34,   7213,     12,     31,    -17,   -185,
      3318,    199,    192,   3450,    -87,      3,     47,     46,
      -141,     49,     83,    -82,   -132,    -82,     68,    138,
     -1031,   -236,    390,    -37,     23,    -94,     -7,      9,
     -2958,  -1846,    -43,     23,     25,    -79,   -193,    -77,
     -3332,  -3355,   -139,     56,    163,  -3302,    -82,    -25,
        35,     96,     73,    166,   -154,    174,   -121,     14,
       -89,    101,  -3751,   -344,   -240,    -35,    401,    -14,
        47,    -49,     24,    -78,     24,      6,     68,     51,
      -145,     20,     83,     57,    147,   -100,     60,     33,
       -53,     11,     37,  -5793,    -93,    -67,     -9,    117,
       112,    -51,     60,     48,     49,    328,    293,    127,
      -314,  -3022,    374,   3283,    -86,    588,   -346,    436,
        -7,    -26,    -88,    104,    205,    150,    147,     34,
       126,     85,     46,   -125,   -119,     75,     13,    144,
      3721,    275,    -71,     43,    163,    -73,   -292,   -381,
       -79,     33,     79,    -79,     34,    -94,     18,    229,
        63,     28,    -44,     97,  -3606,     77,    -95,   -162,
       163,     62,   6180,     81,    -51,    -19,     -5,    109,
        71,      7,    -37,   -100,    -31,    -94,    188,    169,
       -14,   2606,   -417,     18,  -4371,    -25,    180,    108,
        17,     33,     48,    -46,    -93,    -77,     32,    -37,
       -71,   -271,    -48,   -273,    -14,    115,    -59,   -312,
     -3334,  -3046,     71,   -166,    379,    209,   -142,     22,
        89,    -41,    -40,     -7,    -50,      8,    -15,     12,
       -70,    -27,    -27,     25,    -31,     38,     -5,   2831,
       -89,     -8,    -50,   -110,   1368,    -59,  -2307,      6,
       179,     75,    189,    170,    -55,    330,    -70,    172,
        67,   -492,    -57,  -3408,      9,    -93, -11400,     14,
        -1,    -21,     65,    -15,     45,    -22,     40,    -10,
       -41,     23,    -29,    -96,    -55,    -66,    -57,    -61,
       -29,    -15,   -101,  -9831,     33,     42,    -35,     42,
       -44,    -58,     11,    -40,     27,     21,    715,   -315,
      -255,   -115,   1736,      4,     41,    -70,    -51,   -108,
       160,     -9,     87,     -6,     36,    -20,    -68,     10,
        82,    -33,    -42,     15,    -57,    -40,    -31,     21,
     10023,     62,    -41,    -10,     85,    -65,    -12,    -61,
       -72,   -610,    128,    -76,    198,    367,  -4564,     60,
       158,    -13,   -134,    -45,    -33,    -11,    -51,    -72,
       111,   -188,    232,   -494,    -27,     42,     46,    -23,
       137,   3174,  -3598,    211,    152,    155,   -299,     56,
       -23,   -123,    132,     50,     28,    -64,     28,      9,
       -17,     31,    112,    -19,      4,     45,  -7175,     54,
       -61,     -7,     87,    164,    195,    -29,    -48,     28,
       -60,     70,    -69,    112,   -295,      5,    -89,     38,
        36, -11501,     17,    -26,    -64,   -222,     91,    -23,
       -89,      0,    -94,   2191,    -74,    -84,    -61,    -41,
        57,     24,    -35,    -28,    -37,    486,    131,   3699,
      -277,     64,   -125,   -243,    270,    313,   -112,    145,
        47,  -2862,   -254,   -110,    -27,    -69,   -342,   -120,
       216,     35,     24,     62,    -39,    -29,   2402,     -7,
        -3,     14,    -47,    -27,      4,     27,     20,     81,
       138,     75,    178,    421,  -2943,  -3080,    -84,    -40,
       -58,   -195,   -182,    101,   -187,      6,    -83,    269,
       -32,    -99,     51,    -38,     44,     82,    -14,    -35,
         0,      8,    -23,  10754,    -73,    -57,     68,    107,
        85,     77,    101,      1,    -28,    103,    -10,     48,
        55,     33,    -93,    -18,      8,     28,    -14,   -575,
        28, -11712,     90,   -186,     58,     38,    -42,   2156,
       -82,     28,    -23,     43,     43,      8,     25,     65,
         0,    -53,     28,    -88,    388,    -36,    363,     64,
      3068,     56,    320,   -202,  -3433,     73,   -339,   -157,
       373,   -216,    -43,    171,    140,   -437,   -143,  -2820,
      -101,     53,   -111,     65,    -39,     65,    -30,     69,
       -55,     49,     45,    126,    174,    220,     73,   -101,
       -60,   -151,    -13,    -41,    -48,     -9,     25,   -122,
       -80,  -2450,     19,     94,     14,    -18,    -19,     60,
     -3252,    -10,   3390,    -15,   -365,    -15,    -73,   -222,
       307,     70,    -95,    237,   -142,   -163,    -44,   -138,
        -7,      6,    -36,    -67,      9,    -22,  10235,    -56,
        -8,     44,   -155,   -117,    -22,    -32,    -74,    -14,
};

static const int16_t cb0808l1[] = {
       -58,    222,   -154,    -74,    -53,   4939,    421,     67,
        26,    132,     60,    -97,     -1,    -43,    328,      2,
       460,    -66,    -11,    -45,    -56,    -86, -10569,   -129,
        58,    -25,     39,     28,     26,     45,    -61,   -139,
       -22,   -135,   -282,   -517,   -368,     55,    -47,     30,
      -110,     47,     75,    -13,     65,    -41,    104,   4745,
      -149,    -99,     28,    421,    517,    -56,     81,   -309,
        67,    -42,     -6,     17,    -60,   -151,     50,    -84,
        -9,     29,    -72,  -3019,     82,   -195,     41,    -14,
      -206,    -34,    -58,    -18,     30,   2154,    -20,      2,
        -1,     41,    -10,      7,     86,    494,    123,    328,
        73,    213,    -29,     17,     43,    -92,    -61,     -9,
      -130,   -113,     33,    -28,  -6677,   -198,   -185,   -236,
       183,   -108,    739,     60,     98,   -314,     66,     10,
     -3161,   -159,  -2850,    118,     37,    -41,   -119,   3087,
        43,    -36,     42,    106,   -174,  -3379,    -92,   -142,
      -237,     94,    -59,   -123,   -117,    144,    -75,    146,
      -268,    561,  -1160,    336,   1477,    207,     89,    130,
       127,   3763,   -372,     48,     99,    204,     84,    209,
       103,    118,    125,    326,    -29,   -206,    139,    -61,
        94,     77,   6624,   -163,     23,     27,   -104,    150,
       -76,   -205,   -186,    -30,   -227,    -58,     17,     25,
     -6536,    -19,    -66,    -45,    -72,     41,     49,    -79,
       105,     -4,   -117,    -37,   -183,    216,    -27,    -23,
       -31,  -2720,     53,    -23,    -46,     -9,    -10,     50,
       -12,    -50,    -56,     35,   5498,   -110,     -2,     44,
        -1,     13,     52,    -18,    -61,    -80,    -29,     25,
        61,    -37,     93,    -19,     67,     75,    -41,    254,
       161,    118,  -3379,    398,     -9,   -208,   -143,    207,
      -135,    -32,    171,    187,   -194,    466,    -55,    158,
        34,    105,   4986,     27,    -41,     20,     87,   -110,
        39,     80,    -37,      8,    -25,    -44,   -108,   -171,
      -366,    208,   -225,      1,   -124,     21,     81, -10349,
       -51,     33,    -51,    141,    -36,    106,   -100,    320,
       122,      3,    266,     72,     -8,   -112,     55,   -107,
     -4154,    -69,      0,     71,   -153,    -80,    -50,     20,
      -112,    225,  -1982,    273,    -19,   -127,    109,    -25,
        47,     57,    -98,    -10,     42,    -25,     10,     24,
        41,    -73,     45,  -3523,   -370,   3213,     54,    -87,
        67,   -185,    100,    -33,    -41,      3,    -38,     70,
      -108,   -120,    -67,   -144,   -181,    -33,   -104,    429,
        89,    849,   3022,  -2765,   -341,    184,   -248,    610,
       408,   -222,    184,     84,    -64,    479,   -146,     47,
      -100,     13,     17,     -7,     58,    -13,    -36,    -23,
        -1,    -25,     10,   2666,   -113,    -41,   -140,   3064,
       105,     31,   3042,    -75,   -132,   -113,     80,   -100,
       -39,    216,     -4,      7,    -43,    242,     19,  -1031,
       731,  -3659,    -24,    -20,    109,    126,   2980,     19,
       -11,    -48,     57,   -138,    -11,   -211,   -151,    540,
      -113,   -110,      0,   -415,    150,    -80,    -80,    209,
       -82,  -5212,   -125,    376,      8,    131,   -138,     30,
      -922,   -320,    181,    -75,    138,   -112,    146,    -72,
        64,    -75,   -262,   4872,    -11,    -61,     37,   -205,
        48,  -2257,     82,    106,     93,    -66,     48,     71,
        29,     72,     32,     29,     17,      5,     34,     29,
       -29,    -72,     50,  -7702,   -114,   -117,     47,     11,
        19,    100,     48,    -28,     -8,     53,     21,     80,
       -43,     37,    164,     22,    -15,  -5258,    -23,    -32,
       108,     52,      7,   -161,     11,     84,    141,     -8,
       -12,    -25,    111,    146,    -96,     66,   7388,     54,
        17,    -54,     62,     44,    -66,    -13,     26,     13,
        85,    -79,    -21,     98,    156,    181,   -103,   -188,
       -35,   -179,     83,    117,    -92,     49,   -185,   3800,
       -90,     14,     42,     94,    -83,   -178,   -156,     -8,
        33,     42,    204,     42,      1,    -85,     47,     10,
     10804,     36,      8,     26,    -47,    -51,   -189,     83,
       -47,    -23,    104,  -7142,    -67,     55,     21,     68,
         8,    -84,    -60,    -43,    142,    -41,     27,    -72,
       -70,   -170,   -141,    202,   -198,   -105,     41,  -3553,
       -34,   -148,     34,    -62,   -161,    -20,    -73,    128,
       162,  -8343,      4,    -71,    -46,     12,     27,     48,
       -41,     50,    -19,    -88,      7,     79,     29,    -19,
       -31,    -49,   -147,  -1886,   -103,   -213,     28,   -183,
      4119,     87,      6,     -6,     51,   -190,   -167,   -116,
        23,    -26,      7,    -38,   5442,  -1869,    -81,    197,
       105,   -122,     65,    220,     32,    -57,    -39,    -15,
         4,    112,    -55,   -139,   -825,    985,   -109,   2558,
       218,     94,     65,   -184,   3269,    101,    -65,     42,
       372,    -38,     58,      8,   -143,   -544,   -268,    121,
        38,     61,    -63,    -10,    -30,    -52,    -76,    -74,
     -6690,     -5,   -160,     76,    -77,     74,    374,   -917,
       239,   -203,    550,    -84,   -305,    292,    -51,     36,
       135,    -79,     27,    -69,   -309,   4561,    -67,     11,
       -60,     43,     18,     -2,      8,    -15,     20,     22,
        -2,    -41,  -2396,     37,    -79,     67,     27,    -84,
       353,   -213,  -2336,     58,     39,    126,    -78,    -98,
       -90,     -3,     -9,    -43,     -2,    -29,     -5,   -149,
        42,     98,   -109,    137,     58,    -83,    -38,     51,
      6525,     50,     97,    -31,      8,    132,    -71,    -55,
        11,    120,      2,    -43,    136,    -37,    -85,    150,
       133,     67,    -41,   -452,   -104,      4,    126,    100,
     -2660,   -108,   -109,    -64,    615,    -75,     45,     10,
       -57,    -57,   -108,    167,   -218,    -10,   -331,    -26,
       -21,   6561,     73,   -599,    126,    -23,    250,   -103,
        -4,    -28,    -20,    -35,    -19,     51,      9,    -25,
       -40, -11220,     -2,     28,    -12,     23,   3481,    169,
       159,   -217,    -48,    114,    -93,    -34,   -191,    -63,
        31,    182,     79,     90,     55,     67,   -145,    409,
       190,  -7791,    -26,     18,     71,   -113,    -80,     69,
       -21,    -27,   -121,     51,   -148,    103,    196,   2726,
       -67,   3022,    -28,     26,    -99,     51,     24,     61,
       104,     89,    -57,    -23,   -112,     43,      6,     13,
      -184,   -168,    117,    -29,   1865,     -3,     20,      8,
        30,     32,    -81,     80,    -20,    -59,     37,     19,
      -107,  -3920,   -259,     44,     23,   -129,     24,    -66,
       -27,  -3071,    116,      9,    -76,     56,    -83,     25,
        54,    -20,      2,    230,     56,    -41,    131,    -15,
       -62,     61,     56,     74,    -34,    110,   4606,     -4,
        18,    -47,    331,   -106,    -78,     70,     53,     70,
       -22,     77,    -71,    -60,   -101,     70,      7,    104,
        -7,     39,    -27,   7210,    253,    -15,      0,    -96,
        32,     50,    -10,     33,   2058,     11,    -15,     42,
       -14,     51,      4,     -3,    -11,    -86,     10,     33,
        21,    -18,    -31,     -7,     53,     -7,     95,      7,
        75, -11314,      7,     17,    -16,    -83,   -475,   -887,
     -1141,      1,   -101,      5,    -46,    110,    -90,    -47,
       -15,     19,     66,  -4078,    104,     43,    105,   -126,
       181,     43,  -1655,    -81,    -11,     33,    -33,     33,
        28,    -44,     35,     -6,    -38,     68,    -40,     67,
        73,    -29,    171,  11982,     42,     -8,    -66,    -66,
        40,    -19,     14,     33,    -63,     24,     94,    -94,
      -106,    584,    330,   -108,  -3841,    782,   -300,    -11,
      -303,   -174,   -217,     -3,     24,    168,    187,   -166,
        54,    238,   -269,    -27,    182,     -4,    -72,    -47,
        32,     39,   7622,    -46,    -67,    -53,     56,    123,
       -50,     69,    -36,   -275,    628,    -55,    195,    -56,
      -265,   -132,    -39,     -4,    169,    113,   -180,    -19,
        88,  -6427,     42,   -257,   1180,    359,    335,   3821,
       116,     79,      3,    -93,     67,    -44,     58,    -16,
       265,    172,    -39,    -44,     18,     92,      4,    218,
       122,  -2993,    150,    138,    618,     66,   -618,    402,
      2227,     10,     38,    308,    338,    -70,    265,   1047,
      -104,   -182,    305,   -162,    -99,    510,    -20,   -114,
       529,    -42,  -3569,     52,    -80,   -314,    716,    -31,
       259,     59,    -73,   -117,     38,    -44,    -16,    -74,
     -5060,     35,     10,    -30,     54,    217,     36,   -205,
};

static const int16_t cb0808s0[] = {
     -2191,   -865,  -1906,   -251,    274,    594,  -1214,    677,
       482,  -1176,     43,  -1098,   -203,   -537,   1834,   1332,
       308,    432,   -191,   3091,   1892,    926,   -446,  -1206,
      -613,    198,    575,    -38,    264,    375,    278,   -691,
      -107,     17,   -239,    261,    848,   -620,    183,    624,
       122,   -358,    -50,   1017,  -1075,   -705,   -346,    337,
      -121,    100,   -218,  -1051,   -463,  -4728,   -513,  -1151,
       737,   4356,    684,  -1374,   1630,    521,   -520,    -52,
        90,    119,    -43,   -131,     24,     -2,   -184,    -65,
       614,    371,   -448,   -414,   1415,   -687,   -224,    584,
      -768,  -1210,   2941,  -3057,    132,    406,   -952,    291,
       295,   -798,    608,  -1476,   -516,     21,   -302,   2085,
     -1700,  -2655,   -355,    175,   -409,    662,     46,   -247,
      -201,   -580,    179,    -54,    458,    836,   1543,   1829,
      -282,   -278,    412,   2422,   2077,    197,   -897,    451,
       595,   1547,    538,    825,    563,    443,   -576,   -854,
      -572,    241,   -471,    201,   -311,   -529,    112,  -5128,
      -173,   -233,   -435,    340,    158,    -41,    273,   -224,
       919,  -1570,   1075,    265,   -282,   1256,   1007,    231,
       720,    417,   -401,  -4589,   -747,   -453,  -1112,     54,
       156,   -561,   2746,   -422,    -83,    -91,   -381,   -270,
     -1226,    987,   -965,    625,   -474,    565,   2890,    -85,
      1291,   -280,    626,    -26,    840,   1122,  -1915,    780,
      -702,    792,   -578,   -122,     -9,   1175,   -194,   -571,
      2940,    540,     31,   1817,   -352,    264,    953,  -2035,
       238,   3250,  -1561,    653,   -331,   -393,    827,   -382,
       323,    281,  -1339,   -819,    545,    207,     14,    338,
       432,    860,   1691,    142,    711,    381,  -1151,   4164,
      -867,   -241,    111,   -513,   -863,     78,   1453,   -363,
      -128,   -232,  -1853,   2373,  -1156,    210,    698,   1134,
      -869,   -177,   -352,   1514,  -1370,   -789,  -1193,    819,
       348,     80,    492,    179,   -909,    591,   -600,   -377,
     -1709,     59,   -539,    557,    -45,   -362,    778,  -4919,
      -647,    203,    865,   -313,   -257,    173,  -2415,   1005,
     -1771,    843,   -474,   1619,   1193,   -186,    305,    636,
      -662,   1976,    546,    -82,   -108,   -751,    850,    521,
     -1625,  -3135,   -388,     64,    249,  -1189,  -1552,   2629,
         2,   -221,   -105,    754,    251,    219,   -270,   -202,
       545,    147,   1019,    108,  -1358,  -1317,   1362,  -1323,
     -3322,   -405,   -371,   -554,   -334,    296,    493,    248,
        -4,   1340,    123,   -584,   -804,   -766,   -164,   -470,
       295,    218,     -3,     62,   -194,   -657,   5016,    280,
        -4,    -69,   -281,   -994,    209,    307,   8648,    -37,
      -138,     45,   -329,   -101,    -65,     98,     58,    714,
        56,   -170,     60,   -203,   -248,    103,    107,   -408,
       596,    170,     61,    584,    727,   -434,   -181,  -5116,
      -502,    494,     52,     83,   -105,    325,     68,   -561,
      -274,    371,  -1833,    -78,  -2990,    320,    141,   -748,
      1764,   1157,   -538,   -276,  -1594,   -152,    838,    -45,
      1137,     13,   -803,   -162,   -838,  -1199,   2003,    580,
      3687,   -844,   -552,   -271,   -462,  -1034,    -29,    273,
       862,    269,     95,    186,   -222,   -124,     79,    -34,
      -684,    808,  -1061,   -916,    610,    539,   1289,    782,
      1216,   3213,    -38,   -546,  -1209,   -398,     98,    -39,
        58,  -1271,   -611,    573,    499,  -2170,   -157,   -943,
      -595,    436,   1203,    487,  -1419,   -570,   1468,    711,
      -589,   -101,   3299,    -45,  -1432,   -453,   1820,    677,
      1052,  -1793,   1071,   -400,    268,   -464,    443,    508,
      -273,   -736,   -233,    270,  -1187,  -1931,  -1208,   -519,
      -879,    325,   1032,    280,    565,    294,   2588,   -303,
       640,  -1398,   1070,    674,     57,   -165,    -46,    512,
       757,  -3471,   -812,   -854,     45,    101,   3195,   -786,
       -61,    122,  -1234,    -74,    119,   -389,    254,    -84,
       829,   1465,   -930,    171,   -248,    201,    939,      1,
        52,  -3517,  -1854,    147,   -843,    310,    502,    729,
       191,    525,    333,   -669,  -3358,    215,    552,    156,
     -1771,    982,   -746,    523,   -187,   -684,    456,    123,
     -1544,   -145,     58,  -1083,  -1646,  -1309,    775,   1436,
      1409,  -1114,   -171,     26,  -1775,   1103,   -392,  -2053,
     -1221,    100,  -1120,     25,   -295,    306,   -105,   -514,
     -4362,    156,  -2172,   -191,    -90,      7,    -62,    244,
      -107,    521,    309,     22,   -663,    239,   -213,   -226,
       100,   2228,   -330,   -197,  -1247,   -876,   1561,     -1,
      -354,    439,   -163,   -318,    -61,  -1184,  -3022,   1434,
        65,     87,    806,  -2093,   3016,   1022,   -779,   -391,
       -18,  -1371,   -548,    910,   -910,   -438,    673,     48,
      1028,    548,    153,   -337,    554,    353,   1686,    468,
      -190,   -113,   -560,    542,     94,   -140,   -194,    -58,
       165,   -154,   -311,   4744,   -148,     49,   -253,    180,
       -65,   -125,   -139,    -49,   -115,   -270,    439,    139,
       210,    202,   -207,    -65,   -477,    168,  -4720,    -96,
     -1091,  -2071,   -567,  -1330,    237,    411,   -123,   1197,
      2625,   1348,   -230,    362,   -147,   -139,   -699,   1210,
      -299,     92,   2835,    -36,   -296,    287,   2426,  -1171,
      -218,    884,   -320,   1130,  -1085,   1177,   -953,   -776,
       609,    827,    -90,    131,  -2757,    567,    885,  -2359,
       955,   -200,  -1883,    131,    282,    -80,    141,     -8,
       -33,    333,    809,    357,    -13,    499,    597,    923,
     -1725,  -1533,    465,    -93,   2187,   -841,    751,     74,
     -2158,     99,  -1078,   -459,    648,   -258,    349,   -917,
      1200,    374,  -1741,  -1013,    724,    -61,    182,   4032,
      -581,   1123,   -400,   -459,   -443,   -316,      3,   -271,
      -248,    -17,    595,    206,  -1188,   2869,   1338,   -253,
       316,   -474,   1680,   -856,  -1487,    547,    679,    425,
      -258,     92,     -4,    -24,    117,   -157,    385,   -257,
      -332,  -5597,    -68,   -329,    -65,   -108,   -277,    202,
      -400,    124,    -51,      5,     71,     90,   -927,    966,
       780,    305,    703,    802,  -1661,  -1415,    -66,    437,
      -610,    317,    795,    599,   -189,    322,   -519,  -4010,
       729,   -620,  -2127,    351,    506,    -68,    162,   -983,
      -288,   3167,   -140,    991,   -599,    128,   1868,     64,
       -63,     -1,   2047,    155,   -871,   -130,    226,    508,
       499,    882,   3762,   -383,    -23,      0,   -345,   -488,
       167,    648,    395,    114,   1121,    343,    232,   -538,
        15,    342,   -820,     38,    435,   -468,   -282,   -415,
     -5021,   -293,    147,    533,   -128,    -70,    503,    844,
       -86,   1836,  -2103,  -1143,    -70,   -510,    576,   -689,
       410,  -2101,    433,    339,   -417,    820,    157,    173,
       454,   -586,   1219,    -73,  -5123,    344,    397,     53,
       105,    501,    -59,    515,    194,    356,     78,    706,
       303,    332,   4532,    739,    961,   -521,   -392,     20,
      -697,    823,    607,   -243,    332,    365,   -330,    307,
       429,   -865,     -8,    545,     -3,   6041,   -310,    272,
       464,     22,   -156,    142,    -63,    -87,    297,    -24,
       562,     -9,    147,    341,    -21,    119,   1386,    947,
     -1738,   -500,   -655,     95,     32,     32,    187,    518,
      1330,     95,   -324,   3620,    737,    -54,     55,    670,
     -1252,    995,    484,   1347,   -745,    244,    262,    -83,
      -122,   1194,   -653,  -1111,   -327,   -325,   3579,   -214,
       -37,   -412,   -267,   -377,    -62,    131,    360,    203,
     -5713,    -42,     94,    279,    406,   -355,     34,   -144,
       156,   -256,    -48,    -98,  -1392,   1273,    202,  -1249,
     -3457,   -710,   1007,     37,  -1788,     86,   -570,    535,
        17,   -369,   1640,    816,   -117,    128,   -969,  -1381,
       224,   1519,   -996,   -833,    931,    185,    804,    465,
        82,     69,   -247,   3312,   -430,    -23,    173,   -223,
      3080,   1848,  -1187,  -1494,   -485,  -1131,    496,   -517,
      -596,    320,   -853,  -1303,    240,   -298,    159,    527,
      -257,    412,    839,  -1020,    706,  -3499,   -175,  -1089,
      -717,   -325,    261,    310,  -1740,  -1035,   -403,   -229,
      -861,   -970,    -62,   -192,    535,  -2154,   -364,  -1133,
       979,  -3299,    353,    982,   -517,   1144,   -563,    675,
       285,     63,     17,  -1957,     82,     28,   -513,    501,
     -1183,   1476,   -813,   -254,  -1584,  -1181,   -426,    -56,
      -916,    203,  -2693,    209,  -1066,  -1174,    279,    439,
       201,   1179,    797,    407,    851,    927,    316,   -640,
      1398,   -128,   2741,    563,  -1789,    989,    932,    247,
         6,   -617,    268,   -691,   1112,   -569,    883,    298,
        37,   -362,   -661,    -17,   -154,   -574,    721,   4578,
       205,    507,     77,    -90,   -433,  -1613,    270,   -500,
     -1061,   1634,   -388,   -432,   -648,  -1985,    629,   2887,
      -201,    -32,    223,    621,    143,    446,   1384,   1109,
       299,    329,  -1002,   -356,   1504,    -77,     49,    952,
      4166,   -544,    -85,   -412,   -249,    474,     27,   -107,
};

static const int16_t cb0808s1[] = {
      2632,   1511,    944,   -180,  -2377,     54,   -470,   -187,
      -710,   -998,   -516,   -916,   -440,   -842,    285,     22,
      -282,   -459,   -299,  -2769,  -2285,   -380,  -2194,    801,
      -595,   -252,    504,    -69,   -752,    972,    639,    277,
       502,    117,  -1072,   -145,   1462,   -528,   2165,    880,
      -182,  -2953,    750,  -1090,    596,    105,    187,    555,
      -153,   -113,    830,    161,    308,    -44,   -250,    -58,
      -507,   -406,   -626,   1453,   1357,    116,   -456,   3242,
      -607,     94,    390,    393,    114,   1069,     -2,      2,
      2497,   1405,   -755,   1353,    192,   1288,   -187,    262,
      1722,     91,    885,   -622,   -321,    246,  -1835,     17,
       213,    -80,   -658,  -1940,    275,    845,   -365,    276,
      2142,   -216,  -3402,   -646,    549,    -78,   -176,    -52,
       785,  -1335,     44,    163,   -409,   1273,    679,   -377,
       788,  -1355,  -1721,    332,    223,   1409,   -104,    165,
       354,    322,   2414,  -1611,    216,     -6,   -232,  -1770,
     -1931,   2496,   -530,    228,   -924,   -173,   -329,   -575,
     -1709,   -900,    199,    223,    690,   -636,     73,   -367,
       460,   -823,  -5105,    435,    957,    224,    246,    406,
      -673,    752,    412,   -158,   -267,      4,    694,     10,
       -45,    219,   1040,    778,  -1910,   1886,   -691,    674,
      1085,   -537,    376,   1048,    858,   -161,    613,    376,
       535,  -1349,  -1913,   -518,   -850,    665,    772,  -2985,
       -66,    -42,   2142,   -848,  -1151,    237,   -211,   -161,
     -2753,    603,    507,     39,   -575,    -61,  -1053,   -273,
       290,   -258,   -162,    139,     95,    -12,   -201,   -236,
       709,   -328,   -314,   -130,  -5337,    100,    -18,    -97,
      -206,   1827,   1722,    302,    924,   -203,    761,   -715,
       -24,    372,   -600,   2115,   1197,  -1406,    676,  -2068,
      -167,   -221,   -936,   1419,    353,   -317,    245,  -2890,
       623,    265,   -622,    204,   2549,    596,    239,    -25,
      -672,    583,    117,    -13,  -2251,  -1325,   1984,   1431,
     -1335,  -1268,    735,    245,    105,    593,   -193,   -614,
       909,   -339,  -1033,    383,    102,    363,    732,   1439,
      1028,   1275,    442,    987,  -3901,   -257,    -36,    224,
      -116,   -402,    200,   -596,   -125,    372,   -572,    398,
      -543,   1024,   1746,   -736,  -1056,  -1736,    953,   1026,
      -965,    442,  -1565,   -448,    -96,   1498,     30,   -231,
      -483,     73,  -3185,   1765,   1313,   -100,    477,   -198,
       782,    316,    364,   -107,   -431,  -1795,   -244,    122,
      -423,   -385,    457,   -872,   -535,  -1098,     80,   -110,
      1420,    646,     33,  -3226,    648,    861,    328,  -1269,
      -558,    495,    881,    112,    479,    170,   -309,   1904,
     -1412,   -768,  -1220,    -34,    995,   -649,    162,      1,
       153,    985,    762,   -263,   -188,     77,    760,  -2346,
      3430,   -450,   1677,   1090,   1771,   2109,    -14,   -119,
      -995,    268,    141,     33,     35,     31,    537,     65,
      -345,     69,    192,    763,    -18,   1078,   3829,    274,
       442,   -173,   -412,    434,   -695,    924,      2,   1551,
       566,    -85,    217,    976,   2196,   -503,  -1401,    759,
       922,  -3024,   -963,     -3,    600,   -452,   -193,   -787,
         7,    186,    828,    515,    148,   -225,  -1250,   -985,
       443,   -511,   2037,   1560,   3230,    647,   1418,   -165,
      -261,   -369,    224,    450,   -100,   -271,   -122,   -511,
      -691,  -1444,    906,   -144,    248,    452,    957,    -70,
      -517,    116,  -3559,   -877,   -399,    418,  -1300,   -415,
      -177,    770,  -2566,   -371,  -1673,  -1042,   -500,   -290,
      -708,   -631,    193,   2494,    319,    545,    767,    102,
       231,    -43,   -139,    -97,   -700,  -1592,    282,   1325,
     -1419,   -647,    449,   1995,   -737,    661,   1617,    725,
     -1464,    615,    906,    202,   -154,   -228,  -2194,   -231,
       299,    110,   1318,   1053,   -312,    843,   -937,  -1697,
      -592,  -1224,   -633,    -50,    792,   1600,  -1187,   -171,
       211,   -744,   -306,    186,   1914,  -3119,   -904,   -159,
       178,   -596,   -654,    817,     94,   -242,  -2376,   -218,
      -421,   -365,   -699,    177,   -427,    -32,    265,    -33,
       245,    -34,   5309,   -307,   -262,   -299,     86,    278,
        33,   -200,   -180,    -56,    337,   1034,   -229,   4952,
       306,   -609,    189,    -22,    280,   -160,   -507,    135,
     -1265,   -252,    434,   -427,    158,   -546,   -130,  -2500,
       597,    908,    918,    706,   1227,   3390,    995,    298,
      -558,   1307,    765,   -144,    -37,   -286,    122,    215,
     -1251,   1090,     85,   -914,    522,    316,   1829,   -701,
      -365,  -3311,    312,     22,    680,  -1351,    220,    243,
       166,    -36,    780,   2395,    -64,    836,   1037,    735,
       966,    173,   1114,    192,    510,  -1054,   1341,   -616,
      1559,    897,    338,     -3,   -194,   -214,   -573,   -265,
       328,   -365,    433,   -505,    -86,     33,   -156,   -129,
      -137,    119,    143,   5773,    -76,     68,    820,   1215,
      1315,    713,     12,   1590,    131,   -193,   -881,   -227,
       736,    581,    736,    -37,   -434,   -449,   -348,   4189,
      2180,  -1360,  -1663,    -74,   1215,    278,   2092,    -66,
       313,    388,  -1373,     25,    599,    888,    -87,    293,
        30,    367,   1010,   -883,    818,   -910,  -1918,    864,
       482,   -968,  -1249,    222,   1100,     23,    -87,   2493,
      -248,   -622,    240,    151,    873,  -2735,   1325,   -700,
      -411,    282,  -2361,  -1843,   -631,   -208,    103,   -411,
       831,   -446,   -292,    450,    184,   -158,    484,  -1964,
      4663,    123,     18,    174,    621,    158,   -788,    233,
       302,    441,   -339,    200,    -62,   -197,     -9,   -236,
       984,    584,   -521,   -373,   -205,    910,    392,    850,
     -2968,     68,   -727,   1330,    578,     36,   -385,    754,
      -538,    -36,    271,    418,   -548,   1775,  -1045,   -879,
     -1407,    524,  -1085,  -1479,    371,     19,    873,    171,
      2932,   -216,     42,     71,  -1187,   -570,   -524,    344,
      -770,  -4086,   -735,   -515,   1055,   -551,    945,  -1408,
       913,  -1005,   -222,   -443,     60,   -194,   -734,   1908,
      -534,  -1351,     72,   -938,    -66,  -2756,   1313,   -169,
     -1550,    450,   -610,    893,   1100,   -583,     87,   -145,
      -210,    281,   1402,    674,      0,    -38,    874,   -363,
      2436,   2156,  -1659,   -481,   -130,    -63,   -669,   -316,
      -761,   -413,    108,   2362,    354,     76,  -1725,   -924,
     -1443,   1251,    871,  -2058,    518,    955,   -283,    680,
       -85,   -560,   -464,    127,   -216,  -1382,   1908,    238,
      -182,    459,  -1227,   1144,   2266,    -96,    595,   -750,
       912,   -198,   1786,  -1423,   -618,   -450,    185,  -1212,
       706,   -689,   -154,   -365,   -681,  -1378,    914,  -1200,
      -253,   -532,   3244,    444,      1,    -96,   -404,    -64,
      -412,  -1400,  -2830,   -785,    940,   -217,    358,    618,
       208,  -2974,   -365,    -32,    -63,   -233,   -868,   -413,
       358,   -451,   1310,   -751,  -1329,  -2480,     63,    458,
      -273,   1270,    316,     93,   -453,   -463,  -1258,    -57,
     -1073,  -2037,     46,   -160,   4609,  -1193,    192,   -355,
      -963,    -92,    752,    593,    102,    -80,   -121,    166,
      -606,   -274,     28,    258,     45,    -45,    928,   -949,
      -134,   -268,    -77,    242,   1623,  -1290,    739,    109,
       285,    175,    -92,  -4053,   -482,    366,    217,   -126,
      -843,    950,  -1068,    777,   1818,    550,   -891,    -34,
      -995,   1976,   2677,   -764,     45,    -40,  -1800,    569,
      -323,   -102,  -1064,   4000,   -109,   -423,   -289,    738,
      -872,    808,   -977,    504,   -901,     41,    -45,   -287,
      -140,   -444,    477,   -271,   -876,    301,  -2421,   1633,
      -918,   -660,   -149,  -2542,   -503,   -265,   -107,   -623,
      -447,   -782,   -858,   -535,   -220,    442,    661,   -209,
       878,  -1601,   3610,    149,   -331,    190,    102,    270,
      1451,    237,     13,  -1026,    178,   1290,   -281,   -217,
        11,  -1728,   1043,  -2992,   -718,   -776,    357,   -615,
      -231,    813,   -473,   1634,    539,   -513,    240,   1158,
       144,     57,   1249,   1479,   -481,   -733,   1663,   -757,
       641,    680,   -468,  -2697,    -29,    -62,   1253,   1142,
       292,    245,    -96,    295,   -664,   -264,   -308,   -670,
      -705,    155,  -4024,    330,    191,    -77,  -1502,    326,
         9,    295,   -567,     34,   -104,   -123,   -320,   -255,
      1124,    320,     98,   1299,   -436,   1491,   -341,    908,
        11,      8,    988,  -1921,      5,  -1391,    859,  -1291,
      -581,    546,    -95,    272,   -441,    185,   -256,    313,
       466,   -393,    -50,   4430,   -940,     87,   -224,    390,
      -539,   -290,  -1046,    531,  -2329,   1275,   -586,  -1046,
     -1682,   1159,    908,   2023,    951,   -273,    -68,    713,
      -556,    770,    783,    223,     60,   -881,    -97,    760,
       556,   -237,   -263,   -246,   -240,    165,    526,    832,
     -4761,    432,   -339,    186,    492,     81,   -136,   -827,
      -390,  -1026,   -371,   -292,    937,   -243,   -136,      6,
        49,   -223,   -600,   -355,   5306,    140,     34,    -84,
};

static const int16_t cb0808m0[] = {
     -3555,   -106,   -131,    -53,   -156,    196,   -206,   -104,
        18,  -2948,    122,    146,   -520,      2,    294,   -419,
        -1,    -25,   -257,   9334,     87,    -55,    -42,     30,
        92,     35,    195,     31,     59,     88,     47,     47,
      -220,    564,  -1686,    426,    106,    396,     97,   1315,
      2331,    167,  -1261,   1003,    732,   -300,   -342,    418,
        87,    236,   -245,   2235,     11,    725,    -24,   -169,
      -480,   2845,     96,    -34,     67,    857,     28,     50,
        92,   2100,    -84,   -600,  -1990,  -2208,   -163,    299,
       431,   -825,   -283,    299,    -98,    391,    -65,    -92,
      -200,   -689,   2236,    -82,    -81,    -52,    127,     86,
      -137,   -319,  -2561,    -90,    547,   -198,     10,    195,
      -366,  -2688,    -77,   -234,   -112,   -245,    270,    199,
      2674,    -57,   -673,     -9,   1029,    -31,    311,    -50,
      -160,   -175,   2371,   2711,    409,    -19,     22,   -244,
       312,   -158,    270,   -125,   -247,    118,    -91,   -602,
        86,    174,   -216,     18,   3048,  -1953,    171,  -1985,
      -297,    295,    -38,   -198,   -229,    363,    -13,    127,
        13,   -202,   -117,     65,     74,     63,    125,    -62,
        -2,   -543,   -680,  -4269,   -130,    325,    -49,   -245,
       -50,   -509,   -151,    -19,      3,    152,   -980,   -129,
      -234,    399,    349,    171,   -196,   4952,     -2,     36,
       288,    771,   2313,    231,    -39,    572,  -3012,     77,
      -501,   -215,   -228,   -444,    830,    200,   -188,   -157,
      3248,    279,  -3319,      0,     76,     10,    160,    -80,
       135,    102,   -349,    174,    -30,    -88,   -145,   -205,
        10,   -185,    177,    -34,     25,     31,    218,     -4,
       191,    172,    228,   -136,   -178,    268,    638,   3559,
        55,    198,    145,    342,    -25,  -1940,   2866,   -334,
      -921,   1941,   -464,    273,   -181,   -506,    -21,   -410,
       116,   -179,    -49,   -273,    -22,    -36,  -1298,    274,
     -1831,    321,   -382,    238,  -3464,    -68,   -194,     32,
       -95,   -506,     72,     64,   -329,     19,    -39,    347,
      -302,    204,    145,    -72,    855,   -112,  -3596,    989,
     -2801,    386,  -2623,   -471,    101,   -155,    257,    291,
        30,   -153,    185,    172,    511,     20,    166,    274,
        29,  -3023,    129,     33,   -219,   -205,      6,     47,
      -407,    137,    563,   -106,  -2065,     76,    201,    -99,
      -170,    -77,    170,  -4536,   -440,    -96,   -940,  -1066,
        81,    205,    358,    435,    -78,   -148,   -201,    -85,
      -307,   -306,     14,    -47,   -101,   -187,   -136,    380,
        -4,    -32,    -34,    -54,    528,    -58,   6389,    302,
       -79,     52,    -28,    -65,    -77,    -12,   9024,   -100,
       262,     20,    -67,    -31,     50,    -33,    -30,   -140,
       326,  -1170,   -304,   -136,   -233,    170,     60,    314,
      -166,   -208,   -105,   -245,   -169,    -72,    137,  -7173,
        -2,    375,    152,    226,   -206,   -341,    303,     47,
      1010,   -188,    577,   -292,  -3581,    -12,   -195,     20,
      2165,   -206,    -88,    -83,   -132,    -40,   -443,    236,
      -333,    179,   -211,    -56,    318,   -409,   3106,     95,
     11636,    340,    204,   -323,    167,     76,     61,     65,
      -157,     71,    -21,     38,     66,    391,    -52,     20,
       -17,     11,    259,     45,   -194,    440,   3432,    122,
       468,   -595,  -1856,     94,   -427,   -133,    149,   -273,
        61,  -6622,     48,     97,   -162,     93,    402,   -104,
      -207,     64,   -278,     92,    387,      3,     96,     -2,
       -27,    -30,     84,     64,     35,    -65,     98,     85,
       -16,   -248,   7930,     74,      4,   -104,     83,    -48,
        40,  -2104,    -86,    -89,     99,   -142,     65,  -2713,
        63,   -431,    523,    687,    212,  -1515,      3,     59,
        55,     -6,     22,     -8,   -148,    180,     78,   7833,
       -63,    -83,     13,   -187,   -116,    156,    -29,   -186,
      -160,    148,    -82,   -303,   -166,    112,   -103,    -39,
      -165,   2827,    -54,    -26,     24,  -3055,     78,     21,
       128,    -81,    -25,   -122,     51,    -54,    -19,    188,
       -18,     -1,   -140,    -18,  -8085,    124,    -46,     45,
      -574,     12,   -150,    147,     65,   -209,   -396,   -444,
     -3882,   -291,   -231,    296,    244,     76,    180,     36,
     -2575,    659,    -63,   3277,    -85,     48,   -518,   -353,
       130,     50,     13,    338,   -343,   -276,    -16,    353,
     -6036,    -77,     18,    139,     43,    335,    294,     99,
       219,    442,    -25,    -53,     40,    271,    175,   -282,
       -91,    430,  -4428,    -15,  -2857,    -62,    -27,   -170,
        33,   -681,   -110,    -76,    153,     42,   -134,   -145,
       222,   -177,    -39,    314,   2270,    526,    500,   2417,
       339,   1808,    -17,    464,   -525,    -97,    124,    -32,
       370,     48,  -1675,    -62,   -169,   2642,   2511,    -43,
     -1037,   -184,     54,   -569,   -504,   -247,    -40,    327,
         7,     82,   -197,   2774,    -34,  -2931,   -204,   -112,
       194,   -362,    187,     65,   -166,    115,   -125,     14,
       210,    144,    -75,     57,   -255,   -151,  -3566,   -153,
       182,     89,  -2530,     98,   -265,   -173,   -133,    260,
       -25,  -1292,     35,    131,    -98,    -85,   -237,     82,
      1353,     47,   3842,    148,    171,    183,    234,     89,
       -93,     47,    102,     -4,     90,   2980,    289,   -231,
       353,    497,   -109,    190,  -2869,    697,    136,     90,
      -244,    298,   -119,   -519,    -50,    207,    -43,  -1376,
       356,   1934,    701,  -2323,    671,     71,    -56,   -167,
     -3793,  -3749,   -103,    134,   -228,    -13,     27,    -45,
      -105,    172,    -77,    -23,     53,    110,   -118,    -80,
      -164,   -192,   -563,    393,    -58,   -428,   -360,   3696,
       162,   -173,   1683,   -430,    452,    -92,    107,    -41,
        28,    -85,    421,    -66,    354,    -88,    723,   2751,
     -2955,   -481,   -134,   -231,   -145,      3,     65,    -88,
       189,    187,    151,    174,    -36,    240,   -253,   -235,
      -194,  -5410,    -47,    -98,    338,   -487,    -81,    -35,
       -82,   -440,     31,    109,    217,    276,  -1805,    278,
       273,   -369,    629,   -293,   -525,  -3832,     73,    -56,
      -363,   1709,    177,  -2813,    796,   -162,   -341,   1176,
       -75,    533,    854,    719,    242,   -194,     90,   -147,
       203,   -136,   -138,   -764,      6,  -2787,    -13,   1104,
      1497,   1097,     90,   -867,   -718,   -317,    119,    180,
       160,    257,   2532,   -557,    -62,     14,    665,   1520,
       456,    826,    394,   -605,    908,    222,   -140,    121,
       121,    232,    124,     96,    -87,     48,    -51,     41,
     -7821,    -37,    130,    -11,    -33,   -137,     16,     42,
      1509,     -8,    119,    -83,    -18,     64,     41,   -178,
       -28,    182,    532,    678,    -75,    277,   -230,    -70,
       -71,     -8,   -150,    321,  -6298,    -20,   -131,    -65,
       139,   -215,   -155,    -27,   -110,   -257,     32,    201,
       215,    184,   8932,   -106,    -50,     66,     15,    -44,
       203,    -38,     19,    -78,     65,    135,   -123,    166,
       117,     76,      4,     34,    -90,   5984,     59,    -72,
       356,    -64,      6,    -62,     43,    -86,   -175,   -106,
        10,     25,   3812,   -135,  -3313,    142,    348,   -101,
       -35,    378,   -250,   -106,   -299,    237,     40,    -32,
       236,   -521,     63,   -143,    538,   -256,     43,    -45,
      1642,    726,  -3225,    109,   -997,      3,   -256,    -27,
      -182,    -78,  -4092,     -9,    231,     34,      9,     -6,
       155,   2842,     53,   -130,   -390,   -146,    168,    -74,
     -2023,   -955,    576,   -629,    -76,     70,    140,   -287,
      -401,    966,    359,   1185,   -226,    713,    753,   -739,
     -4238,   3364,     75,   -213,     27,   -172,    -34,    171,
      -118,    -46,   -164,    -13,    -54,   -203,   -154,    -12,
        65,  -3777,  -3452,    297,   -104,    -93,    -81,     69,
      -179,   -321,     51,     47,    242,    -15,   -144,    -43,
      2827,     67,   -305,     54,  -3044,     57,    -15,   -427,
       311,   -205,    226,   -490,     37,    363,    -88,   -408,
};

static const int16_t cb0808m1[] = {
      3329,     59,    195,    -91,    -70,   3262,   -132,    360,
       157,   -410,    184,    -99,   -138,    337,    289,    317,
       156,   -589,   -127,   -204,     37,   -175,  -5661,    -52,
       942,    156,     -1,   -197,    353,     90,     57,   -287,
      -218,    438,     -4,   -262,      9,    322,   -167,   2904,
       -12,  -2647,   -248,   -203,   -267,   -116,   -135,    333,
      -220,   -200,     40,    228,   2677,   -462,   -183,   -129,
      2898,   -728,    793,    422,    541,   -350,     28,    222,
      2790,   -231,   -195,   -191,   3002,    182,   -610,    145,
      -226,   -102,    285,    344,   -357,    217,   -146,    -98,
        18,   -255,     96,   -151,    266,    208,   -459,   -132,
      -345,   4059,   -371,     79,     44,    -63,   -233,    334,
        44,   3884,     49,  -3303,     88,    -23,   -287,   -461,
        57,     94,    -53,   -129,    104,    167,    -25,    -79,
      -125,   -630,  -2352,    150,   -419,     40,    -63,    603,
        67,    209,    321,  -1765,   -200,     68,    473,    622,
         5,  -2883,    112,    188,   -189,  -2765,    169,    397,
      -330,   -642,   -798,    129,   -110,   -164,    -20,    176,
      -213,  -5415,     39,     31,     13,    270,   -477,    166,
       167,      4,    216,    -12,   -528,    -75,   -291,    396,
      -499,  -2011,   -172,   -265,     96,     83,   -279,    114,
      -166,    833,     30,   2493,     94,    130,   -183,   -659,
         1,   -227,     75,    349,  -2757,     82,   -116,      9,
       952,   -112,  -2444,   -333,   -206,   -406,    201,     15,
      -768,     88,   1390,    -33,   -558,     97,   -201,     29,
      3470,     50,    -40,   -271,   -171,    -26,     47,    485,
      -250,   3318,    112,    639,  -2911,    123,   -264,      3,
         8,    379,     73,     54,     88,    227,     73,     58,
      -572,    782,   -183,    305,     49,    -23,  -2968,    -41,
       291,    -25,    157,    295,  -2118,    125,      5,   -193,
      -159,   -543,    -75,   1181,   -191,   -547,    -93,    117,
     -1831,    265,   -607,    -30,    194,  -3929,    -70,    159,
        79,  -1519,     38,    201,     14,    -24,    -76,   -366,
        14,  -2748,      0,   -372,    405,     39,   -170,    320,
      -257,   2153,    -12,    158,    322,  -4013,     22,   -101,
       217,    637,    273,   -430,    228,   -428,    102,   -356,
      -266,     82,    -31,     14,   -223,  -2595,   -360,   2094,
      -379,    624,   -192,    245,    294,   1484,   -117,    156,
       -53,   3668,  -3573,   -118,   -213,    257,   -211,     66,
       -62,   -173,   -166,   -123,    163,    -81,    -39,    -74,
       -21,    126,    722,   -136,   2050,   -206,     86,    275,
        76,   -249,     55,  -2508,     95,    -60,    -34,   -360,
        -9,    187,     34,    -87,    -30,    137,     48,   4761,
       109,    511,   -496,    104,    399,   -361,    162,     78,
       -29,    159,   -112,    182,    246,     52,    255,    338,
       -35,     -1,    -68,      5,    182,   7675,   -119,    -14,
     -1901,   -111,   -106,     22,    -16,     81,    159,  -2423,
       -71,    -24,   -153,   -520,    126,    370,   -186,    230,
       -51,   -401,    206,    -32,     52,    -71,    -79,    503,
      -239,   -231,     55,   -133,   5226,    -45,   -165,     57,
      2314,   -209,    302,     78,    154,  -3092,   -605,   -498,
       410,    159,    336,   -147,   -120,    143,     36,    587,
      -182,   -182,   1457,   1008,   2524,   -446,   2333,   -497,
      -761,   -162,    125,    420,    225,   -117,   -324,    437,
       -50,    190,    129,    259,     33,     -2,     -9,     32,
       -24,     91,     97,    201,     19,    169,   3535,    485,
      -144,    330,   -193,  -2715,    603,    303,   1124,    107,
     -1386,  -1437,   -203,    180,    -81,    303,    209,    -21,
       -65,     26,     91,     98,  -1349,    196,   2103,    917,
      -732,    834,   1456,    -92,   -455,   -130,   -732,   -288,
        39,    -85,   -557,    -39,   3213,    297,    392,   -378,
      -520,    795,  -2407,      6,      7,    406,    203,    -73,
      -247,    317,  -3336,   3166,    206,    -36,    159,   -279,
       442,     54,   -324,    -18,    544,   -250,    142,   -440,
       100,   -145,  -3772,   -199,    139,   -156,    -11,     34,
      -178,   -233,   -370,    601,    -58,   1679,   -170,     76,
       684,    -35,    -73,    -52,    -33,     -3,    -89,     -5,
       -82,     73,    -11,     51,    -48,    -12,   -376,   4348,
      -203,   -432,    189,    -35,    144,     31,    181,   -106,
     -5112,    552,    480,      0,     63,     31,     33,    504,
      1055,  -3007,   -214,    154,   -100,    246,    269,   -423,
       579,     63,   1668,   -296,    390,    109,     21,     -6,
        71,   3321,    246,    197,    355,   -198,    472,    135,
       437,  -1734,   1299,    227,   -618,    -48,   -199,    217,
      -230,     70,     99,   2632,   -203,   3105,    -87,    149,
       303,    124,    362,   -322,    -44,     38,    104,    -28,
        48,   -175,   -468,   -410,  -4451,   -152,   2157,     26,
      -281,   -581,     36,   -205,    101,    230,    192,   -129,
       319,     20,     65,   4879,    123,   -236,   -178,   -128,
      -387,   -124,    528,    142,   -775,   -301,    -88,   -380,
       120,    -42,    -17,     64,  -1074,  -3350,   1335,  -1078,
       -14,   -462,   -113,    253,    450,     36,     -8,   -346,
       -54,     -7,     52,   -100,     74,   8266,   -193,    -36,
       -51,     12,     59,    -68,    190,    -36,     89,     38,
       -59,     13,    269,    109,    -15,   -141,    -64,    -60,
       238,      6,  -4338,    381,   1252,    354,    -41,     41,
       191,   -236,    122,  -2712,    352,   -117,   -121,   -284,
      1516,    473,   -332,   -277,  -1792,   -335,     84,     64,
      9595,   -246,   -278,    446,    -95,    -32,     60,   -146,
       104,    -84,     -3,    107,   -116,   -377,    101,   -149,
       -45,    364,    104,   -193,   -254,   2929,   -164,    -93,
       324,    749,   -928,    435,   2357,    350,    -40,   -153,
       -48,   -626,    390,    -48,  -4248,   -458,   -930,   -218,
      -486,   1769,    335,    152,    165,    111,    118,   -407,
       -87,   -373,   -333,   -134,     86,    -32,   -144,    -18,
       -16,  -7549,   -146,     49,   -184,    116,    -28,    -51,
       190,    115,     80,     68,    129,    206,    294,    331,
       179,   -270,    174,   2444,     55,  -3271,     70,   -124,
       228,    330,    -21,   -419,     62,   -140,  -2388,      7,
     -2683,   -129,  -1050,   -548,    811,    189,    359,   -385,
       -82,   9031,     95,     77,    -69,    164,    261,     61,
       -73,    230,   -163,    141,    -38,    -43,   -150,    164,
        28,    164,     59,    -58,   -312,   -134,    102,    -67,
       166,   -163,     63,  -6795,   -103,   -147,     81,    273,
       133,    122,   -162,   -207,    127,    -60,   4628,     -1,
      1315,    518,   -163,   -246,     54,    239,    154,   -154,
       265,   2000,     25,    227,     42,    179,     88,  -3446,
      -214,    182,    438,     90,    196,    -69,    134,    -56,
      -451,    716,  -1120,   -287,    118,    230,    -37,    145,
       284,   -250,    139,   -947,    203,  -3176,    -57,    151,
      3201,    818,    -87,    347,   -486,   -201,   1176,   -325,
      -966,   -263,   -184,    238,   -156,   -396,    152,    959,
       -59,    -33,   -159,     -3,   9394,   -119,    -81,    -50,
        67,      9,     27,    -62,   -121,   -210,     48,   -211,
         5,    396,    633,     34,    -16,     67,   -247,    -77,
       128,    441,   3896,    251,    970,    119,   -387,    -35,
       124,    -64,   -664,  -6550,    101,    -52,     19,     44,
      -132,     79,    731,   -155,   -262,   -140,    -31,   -191,
      -110,    276,   -162,    -49,     81,   -117,     15,   -570,
       420,  -1232,   -125,   3737,    -95,    544,   -149,    463,
      -129,   -345,    350,    183,    173,    197,    464,    180,
      -249,   -365,   -785,     -9,  -3411,   -235,   -124,    225,
     -4516,    196,   -150,    -89,    -89,     54,   -110,    137,
      -431,    272,    -12,     -7,    114,   -201,    166,   1570,
       -74,    -88,   6019,    350,    -75,     68,    -29,    -81,
       -50,     57,    -62,    103,     61,    276,     22,   -131,
      -134,  -3347,    -60,  -3397,   -311,   -105,     90,   -159,
      -222,    151,    224,   -210,    264,    192,     29,    -84,
};

static const int16_t cb0808sl0[] = {
        24,  -3148,  -3111,    106,     45,   -114,    -85,   -211,
       154,    172,    246,    368,   -130,     58,   -135,     70,
       102,   -150,    -76,     -7,     13,     -1,    -29,     20,
        -7,    112,   -234,   -115,   -138,    -40,    106,    178,
     -7276,   -537,     25,    856,    460,   3107,    146,   -520,
      -631,   -118,    393,    179,    144,    -86,     47,     82,
      3031,     28,    164,   -308,   -411,     72,    138,    378,
       242,    253,     12,    158,    -28,    -60,    -29,    -46,
        -5,    -11,     84,   2753,   -113,    -65,      3,      5,
        13,  -5110,    -74,   -126,   -129,    -82,    -58,    116,
        15,     68,    243,    -32,    126,    -48,     11,     -7,
        75,     10,    166,   -153,      8,    -43,    -38,     81,
       -41,     13,    100,     27,     46,   -441,    -56,     35,
         4,     51,   7528,     52,   -141,   -153,     39,    -36,
       -86,     80,    -35,     50,    -46,     23,    178,  -3986,
     -3350,     59,   -278,     37,     -2,     14,   -157,   -208,
      -317,    218,     15,   -296,    -32,    -51,     36,    -27,
     -2062,     28,    -37,    322,   2286,    214,   -196,   -171,
       -64,   -163,    265,    -50,      3,   -177,    -22,     68,
       124,     37,    -15,  -2202,     60,    133,      4,    371,
      2753,   -111,    480,   -446,    484,     43,    150,   -331,
      1410,   -791,    123,   -136,   -192,    267,      0,    -89,
      -105,    421,     68,   -126,     79,    279,    202,   -132,
      -208,  -3345,   -105,     59,    118,   -647,    -48,    -12,
       145,   -403,    200,      7,     -4,  -3192,   -223,     64,
         0,    415,    366,    136,     49,  -7611,     79,   -105,
       127,    -69,    -43,    103,    -95,    -93,    -10,    -30,
        94,    108,   -109,      0,    -87,    -70,    300,    -93,
       113,     25,    -17,   2263,     41,    192,     18,     73,
       179,    129,    149,    -81,     -1,      0,    201,    184,
       651,      8,     18,    114,   2820,    383,    -71,    376,
     -2281,  -1190,   -143,    121,    -45,  -2157,   -410,     81,
       -14,   1537,   -833,     29,   1150,   -494,     -8,    -14,
       210,    188,   3073,  -1775,   -123,     80,   -103,    227,
       296,    111,   1637,   -197,   1349,    174,   3276,     49,
       -98,     74,    660,      3,   -252,   -356,     -9,    527,
       -63,  -7995,    -16,     85,    249,     74,     26,      2,
         3,     26,   -124,    -61,    -26,   -144,      4,    -52,
         6,   -517,    -95,   2566,    -26,   -190,   -196,   -509,
     -2982,      4,   -178,     -9,    -67,    -25,      1,    193,
       -68,    -46,    -82,  -3734,    -14,   -339,    -44,   -151,
        55,    230,     -3,    100,    -47,    -69,     35,    107,
       127,   -175,    -11,    -10,   -158,   -140,   2934,   -132,
      2571,   -158,   -217,    106,    137,   -222,     74,    -42,
        64,    559,    122,     73,   -112,  -2964,   2502,     13,
       301,    -41,    203,   -382,   -151,   -221,   -147,    -24,
        83,     37,    -45,     56,     89,     71,    109,    -14,
       -43,   -130,   -108,    -18,     74,    -23,    -34,     79,
      7662,    -88,     70,     21,   -110,    147,     26,    250,
        74,    165,     49,     43,     45,    -22,    -14,    293,
      5275,     57,    -72,     93,     40,    115,   -139,   -332,
        95,     92,    -26,     26,    169,    -94,    332,     71,
      -482,    137,    190,    114,     14,    151,   3125,      6,
       109,      6,      7,   1543,    282,    -24,     24,    142,
        33,    123,     41,    -72,   -253,    -33,    309,   -107,
       -64,   -131,     56,  -3528,     82,    -17,    417,    -47,
      -588,    274,    155,    158,   -245,    186,    147,     -7,
       -50,   -218,     12,    118,    -62,    652,    145,     64,
      2473,   -146,    220,  -2973,     97,    284,     29,    268,
        29,   -208,    -40,   -251,   -175,    -16,    -58,    -65,
        28,     26,     55,     74,    -12,   1911,     43,    -82,
      -150,    -13,   -119,      8,    119,    156,   1550,    -88,
      -102,     46,    226,   -132,     95,    100,     87,      7,
       -46,      8,    -32,    -16,    -12,    317,    -33,    -27,
       291,    -88,    169,      1,   -101,    -61,    161,    162,
       -33,     -1,     11,   5097,    -34,    142,     31,     94,
      3619,    -94,     67,   3379,    -65,     28,    254,    189,
       110,    138,    -41,     52,     32,   -104,    154,    172,
     -2365,   -464,    281,    207,    -66,   -190,    399,   -158,
        13,   -155,   -223,     92,   -108,    -25,    468,    189,
     -4359,     42,   -135,    138,     36,  -1403,   -264,   -336,
      -164,    -49,     54,   -125,    -61,     62,     16,    172,
       182,   3134,  -1373,     63,   -227,   -106,   -133,   -165,
       -69,    -57,   -184,    -46,      9,    -57,     50,     -3,
       -62,    -15,   -123,    108,    111,     91,   -161,     23,
       -81,      7,    208,  -5385,   -244,     24,     95,     12,
      -264,     62,    -44,     21,   -240,   -299,    -12,    117,
       -61,  -2551,    389,   2816,   -179,    203,   -421,    899,
        -7,    174,   -200,     98,   1036,   -166,     11,   -137,
        78,     -7,   -121,    245,    -77,    124,    102,     51,
      3136,     74,   -310,     40,    212,   -239,   -373,   -154,
       398,   2967,    654,    488,    103,   -230,   -330,    831,
       -63,   -473,    152,   -556,  -2186,   -371,      4,     86,
       -12,   -141,   5503,    -87,   -123,    -17,    -15,    154,
       192,    -86,     97,    165,    352,     56,    154,     43,
      -331,   1004,    -52,   -131,  -3311,      3,    110,   -153,
       -70,    137,   -168,    -20,    115,    140,    -25,    -54,
       -13,   -300,     57,   -131,    214,    261,    -92,    618,
     -2752,  -3146,     61,    -51,    210,   -230,     87,   -184,
       330,     22,    -19,   -107,   -477,    -39,      1,    127,
       178,    -73,    425,     56,    -25,    -41,    135,   2423,
        59,    -46,    -10,     49,   -116,    -51,  -2239,   -228,
       -75,     48,      3,    181,    161,   -133,   -355,     81,
         5,     84,   -222,    -83,     92,     33,  -7558,    -38,
        -3,    159,     33,    -58,    -37,   -107,     16,    -61,
       -94,     93,     97,     49,   -275,     29,   -198,     -4,
       -68,     87,    116,  -7039,     46,     81,    -25,      0,
        -7,    -46,    152,     64,    -40,   -143,    -56,    147,
       403,    257,   2380,   -538,   -400,   -132,    -89,    -29,
     -2878,    457,   -552,    -12,   -189,   -370,   -357,  -3679,
       422,     63,    200,    116,     -9,   -229,    -72,   -100,
      3346,     88,    -18,     28,    -47,    159,    108,   -160,
       253,     58,   2938,     55,    366,    -33,  -3209,     31,
      -148,    -10,    -40,   -443,    127,    120,    106,      9,
         4,   -240,    200,    129,    328,   -102,    187,    182,
       112,   2757,  -3260,    314,   -163,     -3,   -185,    354,
       -97,    -69,   -199,     41,   -143,     19,    108,    -22,
       -32,    -18,   -149,     35,     31,     -5,  -5083,     52,
         9,      5,    -44,    -52,     76,      7,   -100,      7,
       -79,      0,    -33,    110,   -208,     20,   -159,    -76,
         2,  -8192,    156,    118,   -306,    -88,    136,   -293,
      -176,    163,      8,   1871,   -112,    229,    311,    -95,
       -75,     17,    217,    152,     62,     17,   -246,   3579,
         5,    -87,    -21,     92,    114,   -185,    118,      8,
       196,   -124,   -220,    175,    104,     54,    104,    -40,
       -45,   -152,    392,    216,    -24,    -28,   2024,     -6,
        42,    -91,   -201,     -9,   -192,     35,    -43,   1661,
      -356,   1207,  -1322,    340,  -2937,    -16,    163,   -801,
      -423,    197,   -512,    -70,    229,   -412,    291,    511,
       -36,   -179,    -98,    -54,     93,     87,    263,    -44,
       167,     77,     -4,   7278,   -101,   -193,     91,   -251,
      -131,    269,     15,   -168,    -22,    -26,     44,     24,
       154,    115,    -11,   -124,     28,     37,    -14,    -46,
       -67,  -8192,    -51,   -169,     41,   -302,    -81,   1991,
       -11,    136,   -175,     71,   -104,     89,     60,    137,
        17,    106,     96,   -238,    -83,    -52,   -113,     53,
      2903,    -47,      9,   -227,  -2784,   -245,    146,   -196,
      -216,     41,     -6,   -128,    -53,      1,   -128,   -145,
       149,     32,     25,    -57,    -14,     72,   -135,     10,
     -1946,    -67,     74,   -127,    141,   -299,     55,      8,
       947,  -2239,   -271,     74,   -227,    -81,     31,    291,
       -86,  -2914,     22,     -7,    293,      2,    -25,      9,
     -2997,     89,   3158,    192,    -46,   -246,   -140,     46,
       287,    133,   -110,    308,   -114,    -33,   -106,      9,
       -89,    105,    364,   -172,    185,    -61,   4464,    -92,
      -264,    -66,   -161,    102,   -178,   -264,    -21,    114,
};

static const int16_t cb0808sl1[] = {
       246,     -6,   -180,     90,    127,   3322,    598,    182,
        81,     82,     67,    -39,     87,    -60,     -8,    -89,
       185,     99,    -25,     27,      9,    -59,  -7421,     49,
       -17,    116,    -85,      6,   -305,     88,   -164,     99,
        61,   -415,   -114,   -288,      1,   -165,    -12,      5,
      -143,   -142,   -521,   -245,    -53,     38,    -99,   3709,
       -52,      0,    -41,   -135,    147,   -217,     62,  -2144,
       255,    132,    264,     65,    -37,    204,   -338,   -280,
       192,   -184,   -158,  -3685,    -26,    203,    430,    -29,
       -16,     77,    230,   -311,    597,   2553,  -1126,    -63,
       154,   -431,   -161,    315,    286,   -147,    177,     -3,
        93,    449,    253,    -37,    101,   -244,    -77,     42,
      -384,     22,     36,    235,  -4973,    243,   -120,   -105,
      -226,   -114,   -455,   -404,    164,   -505,    476,   -124,
     -2837,    -82,  -2920,     -3,      0,    134,    -94,    264,
       -53,    -53,    108,     -3,   -845,  -2813,    228,   -179,
       -60,     -2,     65,     33,   -153,    -16,   -149,  -2135,
       209,   -929,   -288,    227,   2656,   -125,    -42,     17,
        30,   3375,   -367,     53,   -262,   -351,    108,   -270,
        11,    -57,   -182,    -51,   -149,   -287,   -115,    -24,
        99,    -76,   6954,    -75,     -4,     38,   -168,    138,
       109,   -239,    -45,     49,     28,  -1376,     49,     66,
       -83,   -129,    -61,    -99,    135,     14,    -93,    111,
        37,    -16,      2,    -76,    360,    -77,     82,    161,
       149,  -1660,     18,     98,    -34,    -12,    -36,    -65,
       126,    -57,     28,    519,   2044,    297,     73,   -218,
        51,     17,     21,    -70,    -32,    -73,    -39,    -38,
       -11,     60,     38,   -129,   -105,   -173,    200,      7,
       124,    -74,  -2780,   2608,    -57,   -213,     54,   -200,
       134,    208,    -34,    236,    143,    101,    327,    558,
        75,    317,   3090,   -188,    544,   -186,     15,    116,
       237,     76,   -105,     29,   -300,    -27,   -211,     71,
      -144,    183,    -77,     38,    -16,     39,     56,  -7308,
      -113,   -116,    -32,    222,     60,     76,    -21,     59,
        52,    104,    383,     73,    149,     88,    127,     34,
     -1819,    -46,     50,     11,   -159,   -223,   -163,   -149,
        95,   -163,  -2168,    -19,   -937,   -183,     66,   -465,
      -257,    341,    -70,    111,    228,     52,     83,     63,
       -52,   -187,     16,  -2539,    -51,   3240,    -81,     87,
      -116,   -183,   -182,     96,    -22,   -191,   -107,    217,
       -10,   -215,      9,     -7,    -97,   -331,    -55,    513,
      -398,   1378,   2627,  -2129,    563,   1462,   -369,    498,
      1176,   -469,    220,   -953,   -122,   -236,   -306,   -276,
        31,     35,   -167,    558,   -134,     45,    -54,     16,
        36,     18,    300,   2438,     62,   -177,     77,   2638,
      -108,   -115,   3392,    274,   -123,    -66,    201,   -400,
       170,    142,    151,    332,     53,   -507,     81,   -653,
       -93,  -3204,     -5,     10,    -43,     79,   3879,     77,
       191,     24,     23,   -208,      6,   -109,    -97,    126,
      -306,    629,     26,   -516,     79,     21,    131,     43,
      -253,  -3463,    840,    653,    -95,    -48,    300,  -1026,
      -324,   -909,   -383,    195,    342,   -136,   -192,    422,
       262,    -13,    534,   3125,      8,   1672,    176,   -293,
       211,  -1213,    537,    637,    -10,   -116,   -149,     44,
        53,    105,      7,    -97,      3,     17,      8,    -21,
        -7,    -41,    -38,  -4959,    -81,      1,    165,    196,
        98,     35,    -35,      8,    -28,    113,    -20,    108,
      -130,    -65,    172,   2858,     41,  -3295,    138,     10,
       -95,    -30,   -173,     85,     42,     30,   -119,    161,
       195,    125,    -32,    136,    319,    -33,   5142,     50,
       100,    128,    -90,    -53,    -67,   -203,     28,     19,
        37,   -137,   -124,   -105,    -25,  -3405,   -250,    294,
       409,    -99,  -1072,   -383,    -12,    212,   -276,   3389,
      -101,    171,    -41,   -554,   -295,   -437,     86,    158,
      -242,    167,    135,      7,   -149,     48,     -4,    -84,
      4911,    283,      5,    -14,    105,   -107,   -384,    102,
       183,     47,     67,  -5105,     -5,     16,   -155,    181,
       110,     24,    -77,    -32,    120,      1,     22,    167,
       -90,   -150,     -5,    163,    -44,    -28,     54,  -3058,
      -174,     58,    152,    -31,   -179,   -122,    -57,    232,
      -395,  -4961,     61,   -115,     31,     14,     82,   -109,
       -39,     59,    -49,   -133,     52,     17,     57,     52,
       -63,    275,    146,    104,     53,     47,    -55,    311,
      4871,    -26,     48,    -94,    -11,    -58,     63,    140,
       -74,    -94,   -269,    -77,   3372,  -3116,     16,    -47,
       -74,   -161,    115,     58,   -247,   -119,    399,     42,
      -181,    154,   -218,    -24,   -237,     58,   -275,   2979,
       187,   -124,    312,    301,   2767,     -8,     40,    -23,
        -6,    -38,    -52,   -363,   -265,    -78,   -230,    286,
      -135,   -337,    -81,    170,    -13,    -58,   -117,    519,
     -4784,    157,   -193,      9,     62,    -21,    180,    128,
       326,    213,   2440,     62,   -601,    -55,      2,    -18,
      -342,    142,    358,   -632,   -377,   3590,   -248,   -278,
      -235,    -28,    242,   -133,    144,     26,   -261,    113,
        45,    -23,  -1984,    -77,    128,    249,     -8,   -266,
       -38,     -6,  -1672,    -45,    -84,   -377,    154,     17,
       -83,    -44,    156,   -137,     43,     91,    253,     17,
       -71,    -92,    178,     12,     18,     -8,   -105,    101,
      7068,     71,    -81,     84,    -33,     79,     53,     -7,
       -85,   -265,    117,    317,    114,     72,   -482,   -418,
      -185,    -97,    268,  -1543,    -79,   -146,    -48,    -45,
     -3259,   -212,   1149,   -165,    177,   -158,    -77,    100,
        86,    -69,    107,    219,   -512,   -253,   -418,    -45,
        16,   5501,   -184,    207,     67,     46,    109,    -28,
        -9,     33,     63,    -16,     39,     92,     27,     23,
       -10,  -8192,      0,     50,    -57,     68,   -444,   1082,
       247,   -138,    120,    472,   -692,    212,  -1576,     66,
      3061,    402,   -160,    337,   -685,   -519,    227,   -279,
        92,  -4135,   -393,    -44,      6,   -129,     59,    239,
       151,    153,    -39,    116,    134,    -40,    171,    118,
       207,   2615,     38,   -167,  -1671,     85,   -135,   -182,
       -88,    246,     53,     29,     -2,     16,    232,    544,
       -46,   -138,    122,    -52,   1312,      9,     92,     13,
         4,     66,    -35,   -134,    -56,     85,    -43,    -31,
        28,  -3187,    100,   -103,     70,     -3,    186,    -43,
       122,  -3040,    -27,    -46,   -121,      1,     37,      0,
       -60,      2,   -100,   -152,   -218,    175,   -406,    175,
      -193,     68,   -208,    -23,   -230,    221,   3397,     45,
        48,     37,    337,     11,     15,    -69,     -4,    -82,
        53,     33,    -56,     75,    -98,    -69,    -11,    -19,
       -12,     81,    -52,   5428,    121,     82,    465,     10,
      -229,    126,     32,    119,    439,    126,   1996,    -85,
       -81,    -57,     88,    232,    108,    -22,    -24,     27,
      -136,     91,    -32,     18,    226,    -33,     15,    117,
       145,  -7737,      9,     58,   -102,   -113,     26,  -2174,
        28,   -421,    -11,    -70,    -23,    -70,   -119,    -96,
      -133,    208,     20,  -3750,    -14,     23,     41,   -180,
      2097,   -103,   -599,    146,    251,    -77,   -557,    -76,
       -96,     69,    266,    316,     74,    -17,   -227,    223,
        33,   -261,    135,   8126,    250,     -5,    -57,     35,
       382,    -44,    136,     81,     42,    -80,    179,    -73,
       -75,    -57,    274,    -15,  -3140,   3236,    196,    150,
       -51,    222,   -190,     13,     83,   -313,   -149,     89,
      -281,    -12,    -42,    293,    567,     19,    -43,    146,
       102,    -39,   3666,     95,     76,     -1,     12,     27,
         7,     -5,    261,    132,   -215,   -295,    -51,    496,
        77,    100,     16,   -285,    649,    -95,    280,     77,
       121,  -2676,     25,  -1148,   2912,   -341,    -91,   2380,
       -80,     -6,    269,    -34,   -686,   -208,     19,    228,
        24,     -5,   -150,     11,    214,   -316,   1187,    599,
       -62,  -2274,   -240,     48,    -86,     87,     86,    477,
      3832,     67,    135,     68,    747,    339,    385,   -255,
      -224,    184,     70,    171,   -134,   2604,   -231,     72,
       170,     51,  -2785,   -580,    -86,   -393,    -63,    -79,
      -151,    334,     78,    329,   -278,    102,    -26,    -55,
     -3531,   -378,   -247,    176,   -202,    147,    169,     87,
};

static const int16_t cb0808ss0[] = {
     -1872,   -332,  -1311,   -512,   -934,    -11,    112,    389,
      -189,  -1513,   1508,  -1081,    185,    -87,   3092,    529,
      -166,   -171,  -1648,   2544,   2144,   -259,   -688,  -1113,
       -71,    387,   1194,   -733,    175,    856,   -976,    268,
       589,  -1773,   -426,   -109,   1210,   -486,    297,    195,
      -991,  -1543,   -432,   1190,  -1089,   -531,   -421,     80,
      -225,    354,   -231,   -670,   -299,  -3694,   -510,   -882,
        31,   2804,    476,   -478,   1897,    686,  -1066,  -1222,
      -882,   -374,   -427,  -1464,    957,    549,  -1211,   -204,
      -218,  -1412,   -545,   -968,    943,   -342,     80,   -281,
      -249,   -968,   3424,  -2342,   -212,    949,   -167,   -271,
       607,   -838,   -418,   -891,   -398,   -877,    138,   1653,
     -1034,  -2515,  -1363,  -1535,   -364,    432,   -324,  -1120,
      1531,    407,   -698,    396,    325,   1432,    646,   2777,
       174,   -836,   -605,   2257,   1086,   -888,    348,     36,
       513,   2229,   1543,   1293,     94,   2444,   -574,  -1030,
       933,     -9,   -668,    555,    346,    511,    715,  -4033,
       409,   -299,   -166,    700,   -560,    950,  -1265,   -245,
      1418,  -1362,    -20,    870,    152,    942,   -331,    -66,
       227,   -186,    251,  -3632,  -1057,   -989,  -1798,    923,
       542,   -630,   2889,   -128,   1475,    -97,   -964,   -860,
       534,   -217,   -746,    181,    321,  -1007,   2595,   -411,
      1298,    635,    310,   1955,    -17,    846,   -824,    -11,
      -952,    208,    328,   -547,  -1086,   1481,   -264,  -1574,
      3579,    500,    242,   1038,  -1030,    353,    -75,  -2100,
      -347,   2662,  -2378,    261,    210,  -1151,    525,    291,
       368,   -200,   -702,    105,   -140,    -81,    663,   -716,
       334,   1220,    239,     21,    114,    301,  -1898,   3647,
      -302,    550,   -489,   -484,   -853,   -274,   1509,   -419,
      -330,  -1121,  -2666,   2507,   -621,   -818,   1188,    -69,
      -885,    231,    316,   1837,   -740,   -187,   -102,   1148,
      1219,   -123,    852,   1154,     27,    139,   -344,   -404,
     -1133,    425,    353,    145,   -123,    179,     49,  -5836,
      -571,     39,    274,    -38,   -457,    172,    -80,    593,
     -1977,   -331,   -421,   1965,   1768,   -113,     64,   2272,
       475,   2165,    210,    873,   -819,    757,   -119,   -530,
     -1431,  -2167,  -1517,   -864,   1060,   -752,  -1366,   2349,
      -671,   1180,   -179,     10,   -450,    781,   -799,  -1303,
      -393,    -61,   -113,   2053,   -550,   -843,   1028,  -2044,
     -2631,  -1388,   1078,    171,    517,    496,   -928,  -1695,
       298,    708,   -557,    122,   -917,   -197,   -423,   1142,
       116,   -528,   -585,   -470,    480,    400,   4605,    384,
      -142,     57,  -2340,  -1507,    -67,    907,   8192,    356,
       -18,   -704,    528,    -32,   -379,   -611,    418,    703,
      -396,    531,    155,    642,    678,   -427,     85,    814,
       212,    845,   -579,   -590,   -456,    103,   -624,  -4541,
      -306,    638,   -760,     36,   -149,   1929,   1229,   -717,
      -543,    530,   -694,    169,  -2996,    423,   -346,   -897,
      1077,    255,  -1054,    -63,  -1773,   -479,    479,   -701,
      1547,  -1683,   -342,   -926,    112,   -663,   1638,     -9,
      2587,    311,   -561,   -932,   -539,   -335,    589,    779,
      2345,   -432,    788,   -967,    319,     -4,    192,   -588,
      -103,    357,  -3508,   -257,    707,   -473,   1521,     -9,
       130,   3290,    274,   -296,   -802,   -139,   -814,    -19,
       971,    849,    253,    486,     40,  -1216,   1179,  -1772,
      -996,   1400,    838,   1955,  -1432,  -1925,   2324,    767,
       896,   1314,   3407,  -1003,   -552,   -967,   -166,    -26,
      1099,  -1965,      9,    239,    -10,   -243,    864,   1251,
        91,  -2279,   -691,   -542,   -473,  -1908,  -1208,  -1447,
      -891,   -311,  -1136,   1638,   1150,    586,   1656,    260,
       538,  -1746,   1460,   -478,   -860,    297,   -605,   -139,
       822,  -3718,   -194,    307,    609,     30,   3418,    226,
      -338,    161,   -387,   -344,   -472,    354,   -170,   -421,
       433,    601,  -1446,    821,    -48,    -31,    493,    916,
      -347,  -3740,   -899,   1389,   -355,     71,    382,   -644,
       485,    218,    975,   -542,  -3191,    742,   -102,   -783,
     -1607,    473,    196,   1692,    -71,    258,   2446,   1507,
      -968,  -1025,  -1087,    637,   -921,  -1405,   1192,    -88,
      2044,  -1813,    922,    156,  -1096,   1007,   -695,   -485,
     -1015,   -468,   -316,   1825,    190,   2132,   -205,   -218,
     -3556,   -286,  -1350,   -212,   -634,    120,    417,   -311,
       -90,    219,    870,   -334,  -1304,    523,    999,   -144,
        98,   2157,    205,     45,   -247,   1401,   2423,    278,
      -766,    -66,    309,   -121,    316,   -543,  -3418,    932,
      -803,    637,    436,  -2341,   2016,    928,   -836,  -1212,
       702,  -1179,   -544,      6,  -1429,   1014,    464,   1166,
       581,   -291,    136,      0,    983,   -799,    693,   -230,
      -727,   -186,   -310,    -76,    698,     -6,   -660,    762,
       814,    451,   -328,   4469,   -454,     14,   -423,   -116,
      -134,   -568,   1535,   -562,   -629,   -269,    826,    380,
        68,    282,   -409,    640,   -384,    218,  -5702,   -280,
      -638,  -2586,   -557,   -877,     49,    648,    434,   1178,
      3442,    883,    -78,   2024,   -253,   -210,  -1090,    198,
       -67,    -52,   3226,   -671,  -1606,     49,   1775,   -422,
      -173,    309,   -720,   -667,   -505,   2073,   -678,  -1152,
      -231,   -519,   -719,    422,  -2614,   -394,    543,   -993,
      1449,    437,   -463,  -1286,   1191,  -1274,   -710,   -463,
       659,   1493,     45,   -832,   -414,    306,     94,   1284,
      -669,  -1312,   1082,   -917,   2489,   -494,    547,    738,
     -1696,   -174,    282,  -1442,  -1455,   1633,    912,   -428,
       964,     12,  -2404,   -485,    631,   -311,   1810,   2912,
       -16,    576,     50,   -927,   -175,     37,    673,   -201,
       995,    684,   -244,   -251,  -1444,   3195,   1863,    -88,
     -1183,   -966,   1769,     36,   -825,    766,    489,    -86,
      -365,   -106,  -1477,   -330,    125,   -253,   -250,   -523,
      -731,  -5130,    653,    395,     99,   -845,   -721,    127,
      -287,    850,    479,     25,    -30,     36,   -782,    611,
       448,     99,    933,    -20,   -853,   -949,   -286,   -379,
      -654,   -385,   1298,    547,    235,   1242,   -583,  -4147,
        81,   -547,  -1142,   1280,   -223,  -1712,  -1501,    458,
      -142,   2065,    208,    855,  -1115,   -187,    861,   1090,
      -760,  -2551,   2326,   -378,  -1205,    488,   -241,    893,
       113,    176,   4060,   -225,    -41,   -717,    -26,   -442,
      -445,   -312,    813,    494,    314,   -210,    -98,   -788,
       255,    632,   -506,    166,   -704,   -334,   -214,   -860,
     -5281,     60,    -34,   -238,   -147,    643,    520,   2038,
        28,   2433,  -1694,  -1316,   -615,    572,   -150,   -107,
       349,  -1763,   -307,     78,  -1124,   -631,   1162,   -326,
      -277,   -591,    558,   1016,  -4668,   -324,   -815,   -251,
     -1284,     52,    294,  -1283,    598,    630,   -345,    641,
       -34,   1085,   4247,    637,   1695,   -858,    212,   -243,
       -64,    327,    557,    426,   -321,    363,   -652,    372,
       777,   -567,   -749,  -1704,    414,   5299,    389,    242,
        39,     31,   -315,    179,   -102,     11,     62,    248,
       557,    706,    359,    -85,    303,   -403,   1531,    409,
     -2092,    144,  -1354,     54,    -48,     51,  -1787,   1278,
       942,   1264,  -1495,   1671,     92,   -899,  -1149,   1908,
      -903,   -596,    342,   1749,   -825,    -13,    509,  -1163,
      1065,   2405,   -253,   -741,   1099,   -528,   2971,   -412,
      -235,   -869,   -136,   -352,   -489,   -384,    745,   -398,
     -4197,     84,   1152,   -497,    955,   -161,    461,    -16,
      -871,    801,    -93,    -15,   -352,   1826,   -490,   -536,
     -2853,   -633,    128,  -1537,  -1670,    538,    788,   1276,
       554,   -340,    565,   1216,  -1758,    384,  -1313,   -628,
        24,    835,   -862,   -927,   1792,  -1042,    209,   -784,
       807,   -383,  -1399,   3531,     52,   -537,    205,   -271,
      3071,   1678,   -694,  -2313,  -1279,  -1656,   -428,  -1063,
     -1576,   -323,   -342,   -257,   -227,   -716,   -458,   1161,
      -180,    -71,    -40,  -1276,   1778,  -3123,   -378,  -1363,
      -827,    880,    275,   -274,   -581,   -186,     -8,    661,
     -1114,   -199,   -171,    379,    429,  -1551,   1645,   -857,
      -163,  -2623,   1217,   1458,   -596,    -68,    383,    973,
      -485,   -354,   -597,  -2875,   -516,    234,    -83,    340,
      -396,   1365,   -574,   -816,  -2086,  -1059,  -1589,   -593,
      -779,    334,   -546,     49,  -1065,  -1959,   1736,   1134,
       187,   1833,     17,    -82,     68,    803,   -456,    -89,
      1760,    836,   1570,    122,   -985,   2549,   1616,     82,
      1102,    227,    222,  -1236,   -155,  -1012,    633,    467,
       163,    445,    166,    766,   -253,   -347,   1041,   5121,
       -21,    792,     81,   -478,    128,   -158,    316,  -1180,
      -372,   1692,   -828,    -31,   1122,  -2583,   1346,   2483,
       195,     72,    549,    424,    947,   -470,   1940,    -75,
       505,   1377,    550,     58,   1785,    343,   -817,    874,
      3483,   -307,   -576,    240,     35,    837,   -717,   -247,
};

static const int16_t cb0808ss1[] = {
      2328,    183,   1652,   -907,  -3005,   1329,    -61,   -465,
         0,   -453,  -1621,    223,    232,    -59,    254,   -312,
      -117,    -59,   -477,  -2648,  -1176,   -227,  -1937,    962,
       141,  -1489,    849,     93,  -1284,   1000,    295,    192,
      -139,   -468,   -736,   -436,   2155,    371,   2475,   -348,
       856,  -1985,     38,     94,    496,    758,    954,   -243,
       134,  -1759,    491,  -1406,   1114,  -2554,   -447,   -692,
     -2128,     44,   -923,   1610,    787,    150,   -500,   3442,
      -698,    276,   -517,  -1555,    379,    -72,    810,  -1373,
      2897,    936,   -586,   -438,    925,   1881,   -419,    211,
      1724,    721,    885,    614,    253,    613,  -1440,    509,
       842,  -2407,   -216,  -1765,    451,   1419,    599,    689,
      1473,   -175,  -2974,  -1015,   1983,    -68,    640,     21,
       140,  -1295,   -556,    -89,   -836,    718,   -343,  -1903,
       443,    502,  -1064,   1328,     86,   2049,   1235,    130,
       892,   1105,    692,  -2968,   -755,    473,    423,  -1371,
     -2032,   1885,    -29,   -516,  -1118,    285,    482,    164,
     -1932,   -685,   -819,    695,    715,  -1520,   1300,  -1188,
      -121,   -197,  -4233,   -141,   1279,    299,    208,   1071,
        20,    772,    692,    531,    257,    428,     78,    202,
      -399,    -27,    793,   1150,   -736,    388,  -1922,    155,
      -410,     85,   1135,    835,    133,    -88,     65,     62,
      -534,   -136,  -4590,   -162,   -968,   1378,   -445,  -2825,
       -93,   -519,    402,     12,  -1110,   -637,   -765,    210,
     -2305,    654,    447,     26,   -265,    -91,     71,   -886,
       126,   -109,      7,    346,     19,   -713,   -257,    774,
      1080,   -579,    185,    200,  -5691,    541,    228,    424,
        37,    512,    -78,   -201,    848,   -369,   1099,  -1001,
       214,   -336,    266,   2502,   1583,  -2131,   -654,  -2476,
       -97,   -787,   -738,   1056,   1385,    124,    944,  -3421,
      1172,   -547,   -226,   1249,   1552,   1194,   -308,    489,
     -1152,    751,    -92,   -168,  -3112,  -1451,   2038,     35,
       371,  -1585,    535,    308,      5,    -53,    523,   -169,
       591,   -175,  -1028,     91,    743,   -144,    230,   1831,
      -177,    509,   1291,   1808,  -3322,   -815,   -227,   -475,
     -1064,   -647,     79,   1223,    174,    -10,   -412,    393,
      -305,   1224,   1310,     12,   -521,  -1267,   1911,   2245,
       407,    724,  -1232,  -2017,    566,    506,   -467,    813,
       660,   -196,  -3643,   2495,    870,   -561,    289,    662,
       654,   -508,   -734,   -325,    622,    220,   -309,   -307,
      -181,   -445,    131,  -1655,   -835,   -631,    883,    211,
       737,    552,   -881,  -3103,   -766,    595,    112,    151,
     -1177,    601,    479,    -14,     37,   -926,   -505,   1062,
     -1755,   -799,   -178,   -555,   2509,   -694,   -792,    662,
       737,    847,   1611,    397,    -67,   -134,    474,  -2251,
      2698,   -245,   2054,   1603,   1291,   1188,     40,    763,
      -216,   1554,   -297,  -1769,    410,   1270,   1089,    440,
      -967,    294,    -37,    270,    471,   1287,   3773,   -108,
      -610,   -275,   -298,    270,   -384,   2072,   -675,   1002,
       174,     18,    171,    704,   3311,   -105,  -1774,    108,
       511,  -3001,    -69,    543,   -227,  -1196,   1431,    -63,
         6,   1279,     -1,    671,    239,  -2127,  -1924,   -934,
       168,   -300,   1075,   1071,   3088,   -590,   1439,    329,
      1073,    127,    762,   -131,    274,    837,   -134,   -610,
      -399,  -1415,   1047,   -156,    415,    765,    698,    428,
      -748,    241,  -4226,    152,   -829,   1040,   -937,    145,
      -852,    -85,  -2957,   -130,   -406,    726,    168,    -37,
     -1321,  -1069,  -1255,   1159,   1575,    552,    649,  -1953,
       -17,   1027,   1078,   -385,  -2761,   -553,   -201,     58,
     -1900,    -24,    283,   1248,    -90,    419,   1122,    902,
     -1548,    -32,     34,   -360,    707,     45,  -3458,   -246,
       287,    308,    397,    393,    822,   1323,   -565,    505,
     -1553,  -1902,   -677,    625,   1079,   -135,  -2132,   -187,
      -163,  -1001,  -1479,   -932,   1131,  -2588,   -316,     53,
      1270,   -747,   -966,    980,    242,   -266,  -1575,  -1146,
      -605,   -523,   -221,    585,   -787,   1365,   -286,   -183,
       411,    546,   4779,   -286,   -578,   -101,    309,    896,
        34,    451,  -1022,   -699,    170,    935,    458,   4143,
       229,   -572,   -912,   -397,    -40,   -132,   -198,     98,
     -1858,    612,    101,    -98,    -18,   -349,    322,  -1626,
      1304,    273,   -235,    418,   -509,   3961,   -493,   1040,
      -416,   1808,    161,   1443,   1052,   -460,     55,    -67,
        41,    514,   1305,   -836,  -1636,   1353,    379,    147,
       398,  -3814,   -679,    235,    327,  -2293,   -716,   1234,
      -728,   -323,    698,   1992,      4,   -275,    944,    895,
       212,    334,    285,   -710,   -891,  -1325,   3107,      3,
       367,  -1779,    300,   -868,    -59,   -644,   -326,    111,
       267,    -43,    421,    976,     57,   1461,   -172,    245,
      -188,    296,   -215,   5269,    -46,    177,    199,   -539,
        92,   -542,    251,    951,   -231,    117,   -580,   -898,
       402,    847,      4,    384,   -215,    161,  -1991,   4422,
      2461,  -1219,   -751,   1843,   1483,   1072,   2621,    -16,
     -1157,    243,   -557,    651,    953,    476,   -417,   -533,
       505,   -590,    713,    153,   1268,   -312,   -217,   -124,
       870,   -484,   -751,   -161,    897,    755,   -823,   4117,
     -1311,   -729,    447,   -642,    929,  -2408,   -338,   -967,
      -104,  -1048,  -2216,  -1722,   -124,   -204,   -196,  -1156,
      1460,    391,   -543,    120,     70,    204,   1185,  -2490,
      2950,   -507,   -615,   1243,   -150,   -363,   -475,   -531,
       783,    671,   -205,   -591,    217,   -523,    263,    -14,
        71,    958,  -1185,  -1029,   -330,    327,   -705,   1229,
     -2925,    131,   -495,   1756,   2101,    441,    -11,    133,
      1274,   1253,   -154,    772,    522,   1725,   -277,  -1012,
      -726,   1339,  -1200,   -241,   1676,    974,   2256,    347,
      2743,   1482,   -738,   -241,   -868,  -1294,   -664,    855,
     -1329,  -4174,  -1647,   -104,    101,    307,   -647,   -823,
       347,      4,   -120,  -1112,    334,     27,    265,    990,
       319,  -1414,    313,   -603,     52,  -3138,   1552,   -612,
      -854,    626,    212,    773,   2334,    662,    614,    560,
       589,   -533,   1337,    229,    557,    -26,   1458,   -626,
      1890,   2392,  -1525,   1023,    667,   -431,     72,   1691,
      1015,    -97,   -515,   1380,    796,   1192,    -39,    162,
     -2821,   2960,   1558,  -1058,   1327,    793,   1231,   -743,
     -1190,   -245,     29,    486,   -494,  -1371,   1633,    -66,
     -1806,    231,   -664,   -147,   2402,   -584,    473,   -527,
      1272,    464,   1991,  -1007,   -235,    357,    201,  -1176,
      -341,    223,    -47,  -2089,    815,     49,    192,   -719,
     -1041,   -248,   3046,    -40,   -501,   -346,  -1347,   -401,
        57,  -1588,  -1039,    443,    590,  -1089,   -182,  -1365,
     -1013,  -3917,   -382,    -98,   1025,    -51,    698,   -197,
       848,    -75,   1596,   -408,  -1796,  -3191,   1155,    234,
      -100,    698,    571,  -1233,   -315,  -1502,   -647,   -571,
      -322,    842,  -1048,  -1115,   8192,   -784,   -472,     17,
      -718,     37,   1190,   -393,    146,   -547,     90,   -433,
      -321,  -1143,   -501,    468,    235,   -486,    -64,  -2214,
      -330,   -837,   1214,   -127,    709,     -3,    623,   -384,
       221,    297,   -783,  -3802,   -408,    -11,   -707,     92,
      -275,   -268,   -117,   1580,   1466,    710,  -1300,    142,
      -746,   1647,   2399,  -1231,    114,   1220,  -1112,    882,
       467,   -973,   -976,   3855,   -647,   -150,  -1244,    973,
      -364,   -154,    473,   -675,   -817,   -346,   -266,   -769,
      -613,   -476,   1181,     -8,  -1054,    405,   -768,   1385,
     -1598,   -892,    672,  -2185,     83,    -27,    582,   -434,
      -944,     99,   -888,  -1658,  -1516,   2392,    726,   -222,
       284,    324,   4848,    -67,   -782,    -45,    424,   -203,
      -194,  -1229,   -114,   -189,   -216,    275,   -935,    -93,
       117,  -1725,    360,  -2561,  -1555,  -1199,   -769,   -285,
        74,   1267,   -387,   1368,    179,   -113,    952,   1025,
       725,   -542,   -186,   1258,  -1396,   -747,    572,    603,
      1965,   -668,    -12,  -2512,   1337,   -255,    254,   2285,
      1136,   1397,    557,   -671,  -1149,   -614,   -462,   -913,
      -452,   1206,  -2922,    485,   -882,    270,  -1309,   -605,
       -21,   -580,  -1284,   -194,    169,  -2314,   -216,   -229,
      1124,    103,  -1205,   1500,   1118,   1456,  -1149,    780,
      -467,   -385,    585,  -1062,    289,  -3356,    198,   -309,
      -310,     91,     44,   -377,   -632,   -737,   -516,     30,
      -779,     73,   -482,   4661,   -275,     38,   -632,    479,
      -345,   -406,     76,   -208,   -230,     80,   -220,   -313,
       203,     -3,   1740,   -131,    773,    -30,    372,    767,
      1673,   -770,   3326,   1586,    234,    408,   -257,    474,
      -584,   -990,   1378,    696,     47,   -612,   -313,    189,
     -3964,    795,   -289,    202,   -437,  -1648,    373,   -780,
       -24,   -952,    123,    438,    797,    539,   -481,    191,
       291,     37,   -790,   -321,   4520,    -49,   -281,    211,
};

static const int16_t cb0808sm0[] = {
     -4664,   -115,     59,   -280,   -199,    -25,    213,   -937,
       344,  -2137,   -841,   -370,    256,    512,   1098,   -130,
        58,   -121,   -414,   8192,    489,   -296,    -33,     98,
        49,   -217,    721,    -42,   -418,   -227,     -8,    205,
      -276,    407,  -1218,   -146,   -292,   -143,    113,    978,
      2693,     -9,  -1032,   1781,   1777,   -215,   -978,   -824,
        68,   -162,     55,   2991,   -844,    682,    497,    406,
      -922,   2471,    599,    774,   -129,   1292,  -1004,    777,
        42,    314,   -102,   -963,  -2794,  -2620,    510,    355,
       372,   -248,   -391,   -163,   -298,    561,    117,   1183,
        38,    182,   1811,     -4,    328,    -13,   -456,    305,
       368,  -1691,  -2818,  -1074,   1029,    261,  -1446,    343,
        12,  -2757,   1021,   -375,     -3,   -155,    116,    195,
      3420,     64,    139,    780,    187,   -464,    261,   -313,
      -128,    185,   3703,   3160,    960,    706,     41,    405,
        10,   1191,    353,   -549,    131,    164,    105,      1,
        23,    386,     73,   -509,   2651,  -1441,   -834,  -1657,
      -645,   1005,   -777,    695,    212,   1420,     65,    701,
        25,    335,    136,    359,   -112,   -150,    191,    392,
      -258,  -1140,    651,  -4551,    411,    251,   -169,    804,
       -83,   -208,   -363,     81,    152,     75,  -1194,   -203,
        -9,    157,    413,    -62,   -210,   5393,    -22,   -407,
       132,   -288,   2360,    131,  -1535,    553,  -2524,   -140,
       250,   1259,    -30,     -1,   1766,     99,   -529,     91,
      3948,   -262,  -3752,   -382,   -339,   -701,   -140,   -787,
        67,    -11,    331,   -828,   -443,    596,     47,   1634,
        31,   -318,     39,    147,   -670,   -776,    707,   -921,
       172,    971,   1163,     48,    -81,  -1357,   -181,   2872,
      -152,    898,   1075,    529,     91,  -2279,   2925,   -848,
       589,   1910,    549,   1088,    743,   -631,     42,  -1528,
        23,    380,     -5,    389,  -1147,   -209,  -2041,    224,
     -1998,    520,   -776,    193,  -2648,    -78,    -34,   -131,
        22,   -200,    -28,     18,    328,    215,     67,     61,
        50,    -72,    301,   -207,    413,    720,  -6194,    967,
     -3275,    149,  -2444,   -521,   -772,   -278,    137,   -159,
       932,   -111,   1219,    525,     17,   -684,  -1229,  -1776,
        66,  -2307,   -195,   -527,    272,   -470,   -356,     -7,
      -338,    146,   1021,   -893,  -2980,    591,    129,   -257,
       209,    -58,    538,  -3973,    576,   -905,   -642,  -2092,
       153,    737,   -596,    573,    236,   -887,  -1692,   -370,
      -189,   -216,    -58,    714,     10,   -582,    517,    -86,
       450,   -147,   -310,    162,   1747,   -656,   3577,    700,
       190,   -685,   -170,    241,     91,   -126,   5567,    441,
       -50,   -688,    -73,    938,    320,   -130,   -839,   1154,
       149,   -446,    -10,    -11,     12,   -659,   -138,    637,
      -470,    933,   -431,    235,    -86,     -2,   -407,  -5851,
      -250,   1414,    525,    110,    421,    255,   -149,     86,
       378,   -321,   1380,    118,  -2849,  -1138,    180,   1175,
      1932,     32,   -488,   -121,   -412,   -441,    397,    249,
      -172,    -95,    420,    375,   -132,   -215,   -167,   -206,
      8192,   -116,    -61,   -311,    269,    615,   -353,   -115,
      -383,    366,   -651,   -196,    -98,     85,    861,    543,
      -231,    237,    493,    380,   -766,   -168,   3227,    659,
       701,    181,  -3004,     -7,    154,    298,    298,   -257,
       -32,  -5713,     48,    102,   -776,   -148,   -110,    316,
      -645,    212,    213,    575,    -69,     31,    553,   -673,
        -5,    -48,   -148,   -133,     11,    143,     10,    159,
       319,     43,   7462,    162,    228,    -90,     75,    151,
       103,  -2542,    -13,   -338,     11,   -442,    123,  -3039,
      -452,      7,    106,    502,    227,  -2034,     90,    500,
       -28,   -646,   -262,    -62,    -78,     40,    419,   6761,
       -11,     40,    209,     61,   -151,    -68,   -245,   -401,
        26,   -123,    189,    -57,    611,      6,  -1285,    -99,
      -890,   3609,   -302,   -808,    639,  -3245,   -226,    107,
        54,   -108,   -316,    -61,    -56,    228,    -16,    195,
       275,    214,    -60,     77,  -7157,    130,      8,    244,
     -2160,   -760,    450,   -186,   -378,     32,   -797,    214,
     -3569,   -450,    307,    -17,   -141,     16,   1024,    404,
     -2063,   -288,   -160,   4056,    877,   -346,   -970,    -87,
       336,    961,    666,    585,   -465,  -1329,    350,   -338,
     -5421,   -173,   -295,     72,   -201,    533,    462,   -133,
      -937,   1891,    264,     71,   -935,    640,    687,    852,
      -386,    -85,  -5644,    306,    240,    640,     67,     94,
      -902,   -351,   -417,     -3,    284,     38,   -156,    359,
        53,    139,    185,    274,   2613,    213,   1282,   2867,
        30,   1234,   -911,    343,    -93,  -1671,     57,   -814,
       -19,    326,   -256,   -113,     72,   3177,   3393,   -125,
       460,   -261,   -503,  -1019,   -681,   -253,   -957,   -157,
      -117,   -231,   -212,   1446,    225,  -3009,    313,   -435,
       387,   -928,    696,   -857,   -452,     66,  -2063,    782,
        14,    -94,     51,    242,   -422,    236,  -3825,   -666,
       348,    196,  -2770,    429,   -416,   -266,  -1215,   -586,
        84,    328,   -302,    219,   -457,   -532,   -764,     85,
      2008,   -806,   2906,  -1405,    367,    835,    715,   -986,
      -217,     88,   -328,    569,   -586,   3096,    249,   -615,
       453,    176,   -540,    792,  -2472,   2189,    876,   -353,
       111,    212,     -7,    597,   -154,    818,   -401,  -1408,
       748,   2502,   1426,  -2897,   1069,    326,   -605,    120,
     -4149,  -3087,    729,     82,    224,    320,    353,    -77,
      -163,   -322,    220,  -1073,     10,    545,   -518,   -453,
        50,   -386,  -2002,    614,   -705,   -806,   -928,   2941,
      -520,    -35,   1208,    413,    900,    138,   -414,   -289,
       -15,    -75,    185,   -373,    649,   -251,    666,   2708,
     -2817,   -749,   -159,   -112,    454,   -385,   1037,    -46,
       -25,    -14,     66,    552,    160,    -40,   -552,   -156,
       151,  -5287,    541,   -242,    -82,  -1164,    849,   -773,
      -136,   -162,    -76,     23,   -371,   -222,  -2245,    468,
       425,   -356,    418,     -3,   -322,  -3573,    148,    260,
      -155,   3301,   -165,  -3186,   -709,   -458,    870,    386,
        59,   -161,    533,   -150,    598,    384,    900,  -1233,
       -74,   -464,   -519,   -661,    -55,  -2562,    290,   1489,
      1739,   2277,    874,  -1483,   -447,     93,    309,    311,
      -203,    -19,   2271,  -1280,   -125,   -443,   -538,   2650,
       -42,    290,    245,   -149,     24,     38,   -133,   1638,
       210,   -239,   -180,    516,    -12,   -719,    -19,   -517,
     -6190,   -181,    -89,    318,    485,    631,     11,   -205,
       -57,    257,    573,    -72,    273,   -579,    107,     -5,
       112,    425,   2449,   2741,    758,    656,   -663,   -282,
       -48,    -45,   -294,   -448,  -5562,     61,     -1,   -464,
      -263,   -688,   -115,    -15,   -108,   -569,   -448,    -48,
      -180,   -105,     14,   -180,    490,    274,    625,   -588,
      -120,   -196,   -305,   -126,    435,  -2490,  -2693,  -3414,
        31,     97,   -167,   -114,    247,   7695,   -189,   -580,
       219,    241,    188,    327,    179,   -193,    135,   -176,
       127,    479,    529,    234,    112,    234,   -358,   -286,
      1109,   2940,   -610,    -13,  -2650,    495,   1355,   -574,
       -43,  -1497,   -292,   -503,    564,   -363,     24,   -313,
      1387,    221,  -3612,    783,    637,     43,   1351,    217,
       -21,    149,  -3104,    190,   -259,   -201,   -342,   -201,
       166,   2411,  -1082,    283,   -382,   -725,    157,    155,
     -1609,   -592,    527,  -2959,      9,    216,    526,     79,
        54,   -132,    202,    785,    929,   1755,   -663,    366,
     -3735,   3282,    305,    572,    -36,   -111,   -231,    119,
       603,   1357,   -153,    553,    363,   -760,  -1188,    890,
       147,  -3844,  -3788,    150,    257,   -588,   -234,    497,
       361,   -543,    255,   -175,   -377,     49,   -616,   -200,
      4115,   -541,    130,    678,  -3458,   -506,   -218,  -1317,
       889,     29,   -104,     -2,    532,   -393,    513,   -792,
};

static const int16_t cb0808sm1[] = {
      4123,    -74,    639,    326,   -110,   1896,    826,   -855,
      -299,   -452,    536,   -323,    262,     79,    486,    144,
       270,    -64,    277,    154,    399,     50,  -7270,    -61,
        14,     -8,     19,   -104,    333,    119,    374,    389,
      -196,     77,   -322,    261,     75,    386,    162,   2360,
       644,  -2785,    355,    277,   -121,   -148,    156,   2136,
       112,   -453,    429,    171,   2405,  -1245,   -775,   -181,
      2110,   -583,    127,    889,   -290,   -550,   -165,   1027,
      2155,   -351,   -936,    432,   2689,    217,    -20,    646,
      -785,    908,    654,    970,   -294,    -41,    466,   -245,
       138,     50,   -108,   -366,    177,    481,  -2118,    968,
      -594,   3892,    528,    188,   -613,     18,    283,    733,
       -35,   1598,    387,      1,    156,   -206,   -437,    203,
      -244,   -347,    325,    296,    100,   1171,     49,    920,
      -418,    -54,  -2756,     24,    123,   1018,    303,   -501,
       901,   -447,    322,  -2361,   1039,  -1067,    877,   1329,
      -143,  -2773,    269,   1560,    398,  -3193,    102,    990,
       279,    379,   -204,   -144,   -174,    139,    411,   -234,
        21,  -5064,   -188,    365,    278,    353,   -189,     94,
       593,   -402,   -353,   -257,   -788,    383,  -1036,    569,
       -72,  -1764,    571,   1003,    629,    670,  -1400,      0,
      -435,     64,    189,   2874,    239,   1128,    992,   1213,
        69,   -128,    207,    713,  -2436,   -931,   -387,   -111,
      1064,   -170,  -2853,  -1072,   -367,  -1048,   -238,    -60,
       -49,    340,   2382,    370,   -245,    351,    248,    -64,
      2331,    458,   -484,    -34,    281,    689,    483,    636,
       199,   3153,    607,   -124,  -3296,    953,   -407,     49,
       455,   1083,    690,   -169,   -725,    311,   -493,  -1761,
     -3054,    376,   -544,    479,     91,    159,  -2837,  -1257,
      -830,   -948,   -254,    289,  -1039,    856,     86,   1123,
       203,   -768,   1089,     73,   -866,    308,    437,    674,
     -2067,   -240,  -1079,     33,  -1069,  -3502,    756,   -676,
        45,  -2544,    378,   -365,   -275,   -293,   -394,   -649,
      -507,  -2850,    672,    370,    186,   -417,    682,    185,
       -15,   2863,     21,   -165,    356,  -3776,   -103,    535,
      -416,   -345,    -31,     24,    -90,   -205,     96,   -966,
        94,    424,     -5,   -188,    149,  -2193,   -183,   2342,
       425,   -647,  -1697,   -627,   -444,   1248,   -967,   -702,
       -48,   3616,  -3484,    774,   -299,     94,    421,    472,
        71,   -144,   -523,    114,   -172,    349,   -285,   -106,
       101,     59,    429,    512,   3362,    -38,    -62,     50,
      -225,  -1408,    780,  -2747,   -404,    489,   -975,    840,
       357,    982,    488,   -275,   -109,    393,    375,   4794,
       183,   -110,    922,   -760,     61,  -1067,     -8,    322,
        74,   -101,    554,   -350,   -486,     66,    384,    748,
        14,    223,    -45,   -386,     69,   6231,    247,    325,
      -320,    -47,    -50,   -165,    153,   -380,    589,  -3243,
      -173,   -140,    341,   -747,  -1559,    639,  -1658,    356,
       110,   -150,   -273,     76,   -632,   -425,   -227,    640,
       211,    192,   -747,   -165,   4608,    290,   -160,   1268,
      2754,     -3,    578,    189,   -485,  -2747,   -123,  -1309,
       662,    601,     43,   -136,     84,   1625,  -1113,   1400,
        75,   -126,   3581,   -243,   2339,   -514,   2203,   -400,
      -483,    521,     30,   -246,    -76,    359,    101,    663,
       -40,     57,     52,    360,   -447,   -290,    254,    104,
       102,    113,    215,   -163,   -388,    299,   4570,     31,
       108,    -41,     41,  -2633,   2891,   1188,   -505,   1061,
      -349,   -604,   -449,   -374,   -320,    969,   -304,   -192,
       246,   -152,    441,    -46,  -1416,    137,   1987,    495,
       -63,   1087,    875,    699,    201,    211,  -3157,   -273,
       -60,    195,  -2813,   -239,   2486,    -55,    294,    315,
      -133,    448,  -1849,    363,   1063,     76,   -928,   -574,
       -72,    -57,    168,   5673,   -156,   -116,    400,   -124,
        82,    218,   -487,     37,    112,     53,   -544,    178,
        99,    480,  -7179,   -196,    271,   -160,    308,    -62,
       393,    394,   -220,   -740,    -14,     92,    408,   -364,
       299,   -305,     76,   -239,     26,   -312,   -234,     34,
      -189,    871,   -297,    364,    282,   -321,   -927,   4511,
         2,      6,    308,    -82,     87,   -128,    518,     82,
     -4509,   1145,    960,   -109,   -186,     83,   -144,    752,
        84,  -2876,   -162,    877,   -249,    317,    510,    338,
       298,    744,   2892,   -791,    363,   1088,    630,  -2506,
        -1,   3150,    219,    130,    119,    313,   -822,   -668,
      1201,  -2948,   -237,   -106,   -711,    405,    276,   -255,
         0,    440,    161,   2587,   -734,   3376,    276,    154,
       287,   -200,    594,    -29,    198,   -237,   -608,   -445,
      -286,    202,   -783,    112,  -3879,     78,   2809,   -337,
      -606,   -684,   -434,    559,    273,    201,    331,    903,
       -53,    346,    700,   2599,    302,   -590,  -2551,   -498,
       -26,   -667,    576,   -546,    457,   -289,  -1408,  -1021,
       -63,     78,    153,    -83,   -696,  -3105,   2498,  -1502,
     -1249,   -238,    254,   -287,    215,    313,    279,   -517,
        67,    -58,   -148,  -1111,     58,   5151,    346,    283,
      -367,   -900,    542,    209,   -438,   -128,   -135,     54,
         7,    869,    291,  -1073,    775,    -61,   -145,    457,
       562,   1332,  -4589,     99,   1366,    184,    980,   -920,
        80,   -266,   -152,  -1877,   -266,    364,  -1432,    272,
      2275,    567,     60,     50,  -2504,   -386,   -700,    373,
      6775,    -15,   -434,    347,    215,   -369,    -20,   -281,
      -243,   -325,    227,   -283,   -665,    -74,    336,   -674,
      -112,   -369,    -53,   -396,    328,   3588,   -541,   -557,
      -164,   1305,   -817,   -462,   1986,   1249,   -574,    130,
       152,  -2375,   -425,    442,  -3827,    322,   -728,    563,
      -179,    534,    620,   -937,    590,     -1,    -59,    584,
       175,   -193,   -168,     -5,   -150,    156,   -175,   -178,
      -245,  -7481,   -273,    212,    -35,    318,   -178,    446,
       -55,    -26,     42,    -46,   -265,    767,    330,    295,
       910,    -54,    490,   2952,    598,  -2578,   -644,    403,
       149,    -88,    549,   -510,    596,   -225,  -2341,   -286,
     -2724,      5,  -1960,   -262,    922,    537,    646,    -62,
       -18,   8192,    484,    112,   -222,   -211,   -224,    317,
       112,     82,   -853,      1,    176,   -475,   -162,    200,
      -193,    166,   -228,   -214,     72,    417,    -27,    -16,
         4,    395,   -515,  -6832,     28,    -47,    626,   -173,
        63,     90,    141,    217,   1037,    335,   4520,   -896,
       111,     91,   -656,   -103,   -729,    -29,    653,   -599,
       -11,   2734,   -378,   -291,     60,    228,     47,  -3670,
      -192,    653,    733,   -597,    898,   -420,   1572,   -133,
      -154,    329,   -259,   -225,    218,    -82,    117,    300,
      -479,    277,    787,  -1719,    136,  -3603,    702,   1357,
      3340,    362,   -438,    131,  -1463,    367,   -467,   1722,
     -2186,    343,   -379,   1221,   -562,   -260,   1157,   2692,
        37,    -89,   -322,   -322,   8192,   -284,    235,   -528,
       113,   -359,     44,     74,    119,   -917,    403,    410,
      -150,    157,    514,    168,    407,   -246,    -31,    510,
       105,    449,   4612,    635,    -90,  -1260,    774,   -284,
       -80,    456,      7,  -3000,   -324,   -212,   -104,   -374,
      -440,   1268,   2736,     53,  -1178,   -403,   -438,   -534,
       121,    261,   -497,    -73,     10,   -262,     17,  -1870,
       178,  -1339,    224,   3115,   -436,   -448,    385,    894,
        -1,    105,    -18,    268,    342,    270,    891,    367,
       121,   -325,  -1610,    -75,  -3233,   -189,  -1050,    961,
     -2833,   -304,    -51,    400,   -284,   -810,    824,    -71,
      -135,    194,    297,   -297,   1129,    660,    518,   2426,
      -225,    251,   4677,   -176,   -464,    296,  -1208,   -423,
      -875,   -581,   -707,  -1150,    499,   -778,     28,     29,
       101,  -4213,   -127,  -3681,    425,    481,   -529,   -679,
        11,    266,    127,   -445,    527,   -577,    310,   1465,
};

static const int16_t cb1110l0[] = {
     -3748,  -3820,   -105,     16,    -22,     -7,    112,    -14,
        52,     28,    -42,   -113,    132,    -81,     -8,   -112,
        19,     33,   -251,    117,    -33,     -9,    -13,    -28,
        60,    -30,     29,     27,    -58,     -7,      4,     43,
    -10108,    -38,     -3,     48,      3,    -23,    202,   -175,
      -202,     71,  -2143,      3,    -82,    -38,   -113,    141,
        38,    -66,   -118,    -38,    -14,    148,   -264,    143,
       -13,    -56,     -9,    -21,    -28,   8930,    -23,     53,
       -40,     30,     72,    -46,     26,     66,     22,     32,
        44,     22,    -50,    -66,   -115,   -141,     24,  -3013,
     -3460,    492,    207,    -62,   -567,    134,    -26,    -64,
       287,    343,   -213,     42,   -274,   -144,   -144,    -77,
       -26,    -39,      4,     -4,     42,     43,     30,    -16,
        34,    113,   9291,   -171,    -17,     24,    -53,    -27,
        45,     42,    533,    146,    -65,     32,    156,   -144,
      2821,    889,     -7,    614,     11,      1,   -473,    434,
       659,   -323,  -2448,     23,   -138,   -582,    436,   -152,
       -30,     29,   -290,   -302,   3127,    496,     14,   -346,
       -70,    457,  -1976,   -229,     53,  -2077,   -313,     58,
        33,    -91,   -175,    141,   2728,   3232,  -2150,    245,
      -142,     13,   -318,     70,   -152,    -64,    132,   -322,
        44,     30,    -70,   -184,    433,    -25,    -97,  -2035,
       145,     47,    640,    179,   -441,     48,   -108,   1742,
      -280,     33,  -3259,     79,   -147,    324,    -80,     65,
        48,     90,     -7,    -21,     22,      3,     56,    -30,
        14,     -2,   -111,     22,     -8,  -8252,   -103,    -36,
        57,   -203,    287,  -2761,   -220,    143,     11,  -3597,
        21,    -81,     62,    -99,     41,   -172,    108,     29,
       351,   -370,     15,   -122,   -207,    275,    -93,  -2760,
       400,   -212,    225,    230,   -239,  -3530,    -73,    211,
       288,     85,     -6,   -634,     57,    -78,    361,   -149,
     -1843,    -23,     17,    -37,    -71,   -174,   -237,     42,
       -22,   -243,     63,   -101,    131,     35,    136,  -4025,
        41,   -262,    -57,    197,   -290,    307,     35,    -16,
         3,     -5,     45,     -7,      1,    -47,     41,    -19,
        79,     78,     42,    -85,     74,   -414,   1696,    703,
       297,  -3296,    108,   -546,   1129,     44,    447,   -433,
       315,  -1012,    133,    141,   1051,    601,    -18,   -532,
       -30,    712,   -127,   -210,     10,   2442,    -95,    -46,
       -14,     77,     32,    -11,     10,   -103,    -15,    637,
       -60,    352,    694,   -202,    284,  -5524,     92,    -82,
         5,    140,    -54,   -115,     45,    287,    -14,   -307,
      -342,     10,   -181,     50,    -30,     -6,  10144,     77,
        42,     13,     26,    -20,     34,     10,     37,    -37,
       -47,     90,     -5,    -44,    -85,    -64,    -51,     -1,
        16,   -152,    -91,    212,      4,    -25,   -237,  -6124,
        22,   -120,     -1,    171,    -17,    -43,    141,    -13,
       -57,   -185,     80,    273,   -493,    178,     45,     11,
       -57,     16,    -23,    -30,    -37,     82,      4,    -13,
      -130,     98,    272,   -450,   -161,    133,   5104,     14,
      4576,   -193,     11,     55,    -30,      1,    123,   -265,
       -84,   -340,    -18,    152,    -24,   -266,     33,    -90,
      -108,   -639,   1662,    299,    -14,   -389,   4679,   -226,
        21,    311,   -294,    159,   -209,    172,    184,    292,
      -373,    169,     84,     55,   -269,   1453,    -50,     41,
        68,     -9,    -62,     35,     23,   -132,     96,     58,
      -122,  -3956,   -318,    210,   -117,    678,   -104,    378,
      -842,     61,   2549,     37,    149,   -512,     70,  -2971,
       225,   -411,    230,   -214,    697,    -58,   -871,   -281,
      -128,   -204,    -37,   -128,     51,   -174,   -405,    497,
     -4455,   -219,    124,   -120,     63,    135,    201,   -122,
      -435,   -677,    221,    138,    486,    535,   3153,    165,
        11,   -275,     94,   -100,     69,     52,    -67,   -742,
       212,     16,    -93,   -428,    863,    -17,  -2465,    767,
       -35,   -130,     97,   1387,     34,     72,    -23,    -17,
      2845,    -90,    -71,    213,    291,     87,    826,    -63,
       189,    641,   -256,    832,   2087,   -199,   -170,   -193,
       -62,     -7,     37,    -60,  -4277,    -43,     24,    -69,
       574,   -163,   -113,    263,    -86,     45,    171,   1075,
      -154,    -39,    121,     74,   -132,    182,     34,     13,
      -278,    -41,     96,    716,   -221,   -626,   1205,    244,
      -351,   3914,    -78,    -32,   2833,   -150,    -37,     95,
      -227,    -84,  -3432,     57,    238,   -143,   -365,     39,
        27,   -238,   -307,   -170,    124,     66,   -133,     40,
        62,    -19,     42,    -66,      2,    -80,     -2,     60,
         7,     10,    263,  -4987,    -69,   -389,     62,    -53,
       -66,     24,    -87,     13,     34,    -15,    -25,    -20,
       197,      9,    101,    -83,    -79,   -156,   -100,      2,
      -108,   5687,   -157,    878,  -1728,     32,     72,    -66,
        70,     -2,    -46,   -163,    206,     17,    247,   2974,
       -66,   1354,    335,    238,   -249,   -410,   -553,    354,
       -41,    132,    -96,     68,   2174,   -329,    -58,    -76,
         6,   3089,    284,   -274,   -398,    471,    283,    427,
      -220,     81,   2676,     40,    -23,    -46,    251,    109,
     -3059,     50,    -25,   -551,    124,   -389,    228,     95,
        56,  -1320,    -79,   1027,  -4938,   -105,    -82,     13,
      -159,     52,   -101,     23,   -220,    -77,   -153,    113,
      -282,     42,    185,   -144,   -402,     46,   -144,    -99,
     -2862,  -3432,     -2,     16,    -32,     23,    -25,   -145,
       181,     49,      6,   -236,   -226,    -28,    234,    -26,
       -89,    -14,   -355,    146,    117,    -50,     76,    -10,
       441,    -95,     -2,    346,   -242,  -3745,    884,   -305,
      -184,    350,     18,   -293,   -328,    257,    109,     49,
       157,    -44,    -70,     35,      6,     89,  -4085,   -167,
      -263,    -59,     35,    -13,    430,   -212,     17,   -618,
        -5,  -8968,    114,     41,     73,    -85,    122,      5,
        38,     19,    -60,     14,    -36,    -42,    -89,     20,
        85,    -17,     20,    282,  -3396,    -25,   3722,    151,
      -183,    100,   -150,     19,   -221,    126,     34,    -21,
        72,     28,    138,    -90,     30,    162,     46,     40,
        27,     15,    -55,    -21,     38,     55,     32,     83,
      9675,     31,     26,     -2,      4,     96,    -51,    120,
      -132,    213,   2106,     39,   -251,     98,  -2572,   -429,
      -331,   1436,   2078,    335,   -381,    371,    299,    339,
       300,   -141,    -99,   -303,   2952,     49,     93,     40,
     -3949,    -45,     50,   -215,     73,    -39,   -165,   -283,
        46,   -123,   -347,     23,   -158,     41,     20,     41,
       -46,     19,     34,     86,  -8770,     40,     20,    -32,
       -30,    -16,     77,     72,     -4,     92,    -34,    103,
       -77,    128,   -532,   -314,     24,    728,     49,    -36,
      -178,     76,     22,    -14,   -164,   -194,     69,   3133,
      1007,   -130,   -280,   2502,    482,     -2,     45,    -62,
        -7,    -94,     17,     23,     -4,   9516,    -27,     11,
        22,     54,    -13,      2,     -2,      6,    -22,    -63,
        67,   -686,    130,  -2180,   -124,     57,    -61,   -158,
      3364,    518,      4,    315,   -367,   -103,   -295,    259,
      -597,     56,     -6,     72,    -86,    -45,    -13,    -47,
       -13,    -27,     -3,     48,    -12,    -52,     -6,    -14,
       -26,    -16,    -34,   9554,     80,     91,   -270,      1,
      -121,    117,     33,      8,     40,    -99,    -79,     43,
     -3451,    -92,    -70,    -57,     43,     68,     64,    284,
      -639,    458,    118,    -54,  -2755,    370,    -66,     54,
        27,   -198,    331,    115,    -40,   -209,   -312,     82,
       -16,      8,    230,    212,   1853,    -94,   1957,   -118,
       153,    -13,    -73,     71,    116,    -72,  -3285,    106,
        19,   -121,    177,   -300,    455,    -29,     94,    190,
       -21,     -8,    201,     16,      2,     83,  -6280,     32,
       -18,     59,    -18,    -41,   -132,     22,      1,    -39,
      -212,   -198,    186,   3154,   -102,   3463,   -280,   -118,
      -132,   -132,     63,    -19,    353,    -24,    -77,    224,
        82,    143,    -65,    165,    -16,  -3774,   3543,    -28,
       -44,     93,    -45,    -13,    -24,     -5,    -40,     58,
         3,     89,     71,    113,     46,     62,     44,    160,
       -77,     -8,    -59,  -6505,    134,    -42,    -73,      0,
        85,      2,     16,     34,    157,    -34,    -60,     78,
        24,     64,     96,    478,    231,   -125,   -217,     13,
        21,     44,     83,    198,    -69,     21,   -167,    -52,
      4085,   -234,   -393,     17,   -446,   -354,    -28,     42,
        53,    -37,     28,     15,    -16,    -10,    -85,   9471,
       -16,    -89,    -87,    -56,     52,    -97,     86,     -7,
      -103,    -12,     71,    -39,     17,    -40,     23,     63,
        65,    -19,    -14,   -106,     29,   9707,     -1,    -12,
         1,    -86,    100,      7,   1097,    266,    252,    197,
       -64,   -214,   -197,    -28,   3843,  -1577,    310,   -117,
       594,     13,     90,   -309,   -384,    134,    -90,   -194,
      -316,   2884,    156,   -185,    196,   -103,     75,   1009,
        69,    768,    -75,   -605,  -1488,    389,    242,    368,
       278,   -122,  -2500,    121,      7,   -303,     91,    -10,
      3642,     23,   -109,    -13,    138,   -405,     18,    -43,
         3,     42,    194,   -112,    237,  -2241,     23,    296,
       -83,    -14,    -58,   -163,     -8,   -174,   -239,     85,
      -108,    -82,    -79,    344,    236,   -427,    127,     52,
};

static const int16_t cb1110l1[] = {
       -64,     11,    -74,    -96,     39,   6072,     16,     46,
      -215,    137,     77,    128,   -195,   -192,    -87,     96,
       379,    -73,    367,    437,   -366,     84,   -155,    -29,
       -69,    -61,    -34,   -129,    260,   -177,   3738,    739,
      -221,    -14,    -40,      2,   -483,   -269,   2664,    166,
        29,   -256,     30,     92,     51,    111,    -45,   3893,
        90,    -30,    -99,     12,     74,    201,    -52,    -96,
      -196,    -85,    -36,    123,    -44,    -68,      2,   8666,
        33,    -41,     24,    -12,    -52,     69,     59,    -27,
        38,   -148,    -55,    -20,    -60,     50,   3363,     30,
      3749,    -92,    228,    173,   -239,   -167,    -75,    -79,
       -86,   -217,     32,     34,   -137,    -13,     17,   -128,
     -1462,   -170,   -224,   -393,  -3383,  -1243,    -47,     24,
      -223,     26,    311,   -343,    -47,    784,    459,   -548,
       558,    983,    103,    269,     32,     13,     19,    -84,
       -37,    -29,    -47,  -6286,      7,     48,   -100,     13,
        11,   -271,    -86,    115,    -17,    183,   3247,  -3336,
        57,    -67,   -117,    -87,     19,     74,   -271,    237,
       -24,    242,     49,   -179,    298,     85,    -69,    328,
      -238,    -34,    103,    -50,     79,      2,    -27,    -16,
      -103,    -61,   5868,   -105,   -262,     74,    -74,   -158,
       263,   -110,    154,    212,     -3,    -84,   -126,     25,
       -67,  -2501,    -12,    -35,    139,    259,    -95,   -141,
       137,     90,     12,   -244,   -142,    314,     15,   -124,
         1,    -25,    -27,     -2,     -6,     28,    -48,    -17,
        -2,     43,     67,     42,   9023,    -25,     19,    -13,
       -23,    -43,     73,    -30,    143,     -1,   2884,   -142,
        -4,   3549,    -49,   -366,    110,    314,     19,    -55,
       363,    204,    469,    189,    217,   -181,    119,     41,
      -133,     29,    -55,    -94,     71,    -49,     41,     85,
       -14,   6140,     71,   -142,     10,     18,    169,    136,
       282,    -49,     36,    446,    -99,    263,     92,   2201,
      -127,     43,   -143,   -350,     36,    389,   -208,     15,
     -3610,   -275,    383,   1599,   -179,   -177,  -1100,     -4,
        67,    -38,      2,    278,     39,    107,   -120,    465,
       204,   -397,    305,    416,      7,   -262,     68,   2341,
       189,    -75,    -23,     25,    -20,    -74,     56,    -43,
      -125,    170,    509,     63,     26,    263,   -741,    -31,
         8,   -296,    101,     20,   -149,   2846,   -218,    379,
      -310,    151,    901,     84,    -85,    -83,   -387,    161,
     -3102,   -158,   -438,     38,    191,    -58,   -202,    127,
       126,    -88,   -430,  -3077,  -1829,   -332,     61,   -152,
       -14,    -32,   -156,     -5,   -375,  -1083,  -5130,    110,
        77,   -201,    -15,      4,     13,     86,    119,     67,
       149,     80,    264,   -253,   -121,     63,    193,   -103,
      -129,     63,    120,   -226,   -100,   3196,     72,    -11,
         8,    -56,    279,    -73,   -192,     47,    -87,    125,
       -43,   -108,    277,    188,   -107,    289,   5966,    -20,
      -303,    -78,    -21,     40,   -139,     44,     28,      6,
      -254,   -244,     47,     -1,   -151,     29,   -344,  -2318,
        30,  -3767,    114,     84,   -155,     85,    -90,    155,
       111,   -506,      6,    453,   -241,    215,    131,   -802,
        15,   -343,    176,   -430,    251,    -74,      6,    -41,
       -44,   -131,   -105,   -248,    346,     39,  -4524,     93,
      -120,    -79,   -777,   -416,   -570,   -221,     21,     28,
       -52,     56,     71,   -187,   2949,  -2531,    666,    799,
      -137,    970,    243,   -695,   -148,   -281,    326,    450,
      -734,    -99,  -2078,    112,    -83,    -90,    -78,    262,
      -138,    -31,     -5,    -74,   -171,    -99,    344,    143,
      4035,     56,   -121,   -921,     -8,     46,   4576,     97,
      -219,    -34,    123,    -44,     -1,     85,    -36,    399,
      -260,   -231,    132,   -318,     55,   -181,    156,  -3093,
       142,     -9,  -3418,    -31,     43,    126,    136,    309,
       -50,    -20,    170,    -90,    188,   -173,    175,     50,
       144,   -244,     22,     64,   -476,    -22,    -66,    272,
      3839,    715,   -188,    -82,   -250,   -587,     10,    368,
      -507,    242,    -40,   -531,    451,     35,    560,   -107,
       138,     15,    113,     56,    242,     33,    -23,    -27,
        81,   -157,    301,   -327,    359,   3648,     62,  -1489,
      -167,    136,    -39,    183,     53,   -151,    -16,    -60,
       -65,  -5182,    -17,   -257,    -10,     56,   -104,    713,
        -2,    328,     72,    353,     43,    -51,  -5949,     40,
        32,    -82,    -36,    -22,     57,     56,     55,    112,
      -104,     76,      5,     80,    -29,    173,   -360,   -113,
        42,   -119,    180,    -26,    120,    250,  -3024,    198,
       115,   -140,     22,    136,    275,    698,   -149,    699,
       426,   -220,    279,     63,     55,    -63,   -108,    -51,
       -70,    -70,    419,   -156,   5870,     33,    -57,   -114,
      -388,   -213,   -164,   1543,    117,    165,   1944,    223,
       -83,     46,    201,     12,   -103,    228,    139,   -207,
       136,  -1218,   -544,   -723,     90,   -652,    793,     -1,
      -100,    -32,   -236,     49,    164,    138,     16,     82,
     -3221,    -62,   -168,     62,   -313,     98,   -652,   -484,
       684,    -91,     33,  -2926,  -3453,    566,     34,     35,
       104,     13,    189,    235,    -49,   -324,    126,    226,
      -102,    123,   -253,   -403,     38,    160,     -5,    100,
       -30,     16,    -19,    -44,      2,    -70,    -30,     82,
       118,      6,    132,    -15,    -36,     59,  -8835,   -448,
      3707,    324,     87,     67,   -110,    114,    -76,    294,
       354,      7,    140,     11,    340,   -117,   -559,     67,
       129,    201,   -314,    328,   -209,    102,   -121,    378,
     -5010,    140,     53,     15,   -253,    -14,    414,   -183,
       -70,    -25,    -51,     34,   -347,   -171,    146,    -98,
      -101,     -3,    -99,     96,     66,     50,     -5,   -115,
       -23,    -45,   -351,  -4202,    143,    480,    -46,    140,
        17,  -6312,   -110,    -23,    150,     60,    -39,     -9,
       -48,    -60,     -8,    -20,     37,     57,   -162,     60,
      -137,     55,   -101,     65,    100,  -8952,      3,    -49,
        -3,     -9,     28,     15,    -89,   -136,     59,    125,
       -73,    -35,   -111,    -69,    -28,    111,    -16,     48,
        27,   9272,     55,     34,    -92,     66,      3,      3,
       -38,     12,     59,     95,   -100,      3,     51,    121,
       146,   -200,    142,   -254,     65,      3,   -169,     -8,
       -65,     44,     10,     15,    -99,     56,     -6,   -108,
       -20,  -5461,    -89,    395,   2085,    486,    -48,    324,
       422,  -3703,    468,    198,    239,      0,   -277,   -115,
      -227,    227,    -29,    159,   -128,   -447,   -291,  -1953,
      -110,     25,   2274,    141,    177,    204,     38,   -258,
        90,     -8,   -131,  -2636,     55,    561,    -99,   -220,
       -33,    142,   -334,   -160,   -117,    -12,    -33,      6,
        72,     -3,    -11,     50,      1,    -45,      8,     23,
       -15,    -33,    -15,     30,    -32,    107,    145,     14,
        60,    114,     45,     24,   8811,     -9,     61,    192,
        16,    124,     46,    -54,    -31,     89,   -147,   -112,
      3341,   -395,     91,   -323,     45,   -156,     25,    -18,
        34,   -534,    118,     83,   -187,    -92,    180,     34,
       659,    135,    103,  -2342,     54,      6,    179,     40,
       143,    232,  -3858,   -201,    179,     32,    -56,    406,
      -236,    541,    -70,    -88,   -121,    447,   3028,   -223,
       138,   -557,    230,   3457,     96,     -4,    -22,    -13,
      -136,    -45,   -123,     -8,    107,    270,    132,    -64,
       -32,    464,    -33,    -44,  -2544,   -251,   -246,    -71,
     -4063,     40,    107,    384,    -22,   -197,     64,    166,
      -137,    -44,     98,    -35,    193,      4,  -2103,     57,
      -109,    245,   3487,    -55,    -60,     21,    187,   -267,
       279,      3,    166,    -78,    108,   -135,    126,   -122,
       171,   -133,    -21,   -134,    183,     25,    -56,  -6210,
       107,    109,     22,    -93,     39,     95,     43,    -11,
       -44,     -5,    -82,      6,    -54,    -27,   -116,    -16,
        84,     44,     22,    -68,     -1,    -57,     78,     35,
        83,   4664,     46,      1,   -164,   3301,   -358,  -3757,
       236,    104,    -81,   -121,   -278,   -112,    -20,     89,
      -123,     35,    113,     17,   -331,    273,   -172,    125,
       -73,     77,   2515,  -3944,   -170,    -87,    174,     84,
       142,    138,     13,    227,    127,    146,    141,    196,
        38,    -40,   -112,    136,   2311,    328,     87,    -22,
       -77,    -34,   -195,     58,   -333,    337,   -159,    626,
     -3008,    408,    523,   -316,    539,   -587,    -81,  -2824,
        98,    200,    613,   -107,   -170,  -1190,   1121,    521,
       229,   -217,    143,    144,  -1248,   -384,   1535,    470,
      -655,    492,   -429,    -26,   -132,   -180,     52,     97,
        10,    -35,    -60,      7,  -5422,    -26,    154,   -132,
      -221,    124,    136,    -17,    -68,     25,     29,      4,
         5,    -15,      9,     69,    -16,    -47,    -76,      5,
        41,      6,    -22,     63,     -8,   9709,    -33,    650,
      -545,   -159,     81,    -75,     54,    -92,    -49,    -80,
        14,    -78,   -145,   -399,  -3935,    186,  -1144,    207,
        60,    286,   2642,     44,    117,   3758,   -154,    426,
       331,   -615,   -216,    271,   -121,   -109,    495,     42,
       813,    -19,    545,   -149,    633,  -2424,  -2089,    265,
      -136,    -58,      4,    -28,    147,      2,   -123,    -93,
        14,    -50,    317,    131,   -130,   -152,    322,   1023,
};

static const int16_t cb1110s0[] = {
     -6433,    495,   -277,   -630,    411,   1241,   -326,   -425,
       523,    114,   -225,    -53,   -538,   -702,   -260,   -417,
      -401,   -222,   -263,   -416,    163,  -1256,    590,  -1176,
      1865,   1483,   -927,    -65,   -674,   1303,   -147,   -750,
      -132,    407,   -283,    852,   1788,  -2257,    210,   -450,
       303,   -272,  -2536,     94,   2010,    428,   -921,     -3,
       -71,   -875,    156,   -681,    521,     49,     51,   -523,
      1532,   1619,   -690,    402,   -923,    318,    865,    193,
     -2187,   -662,    553,  -1104,    -70,  -1313,    462,  -1045,
       320,    937,  -1453,   -514,    404,   -231,  -1748,  -1592,
     -2039,   -217,   -364,  -1313,   -428,   2419,   1257,  -1292,
        19,   2867,   -278,  -1832,   -239,   -691,   -383,     62,
       185,   -455,  -1589,    116,    419,   -319,   -418,    537,
      -280,  -1834,   2681,   -857,   -210,   -156,  -1143,   -104,
     -1774,   1702,    184,   1017,   -135,   -610,    525,    335,
      -355,   -494,   -231,   -154,    986,    434,   1134,   1213,
       914,   1457,   -258,  -1086,    477,  -2247,    498,  -1741,
      -975,   -262,    812,    108,    834,   -412,    120,  -1032,
      -533,   -456,    139,   -301,   -387,   -690,    798,      3,
     -1556,   1261,    745,  -4486,      8,    213,    977,   -151,
      -269,   -344,     13,    544,   -270,   -166,   -706,    672,
       184,   -943,  -1714,   1510,   -739,   1891,   -477,    528,
      1847,  -1572,    420,    103,    -85,    508,    231,   2024,
     -1343,     20,    238,   -655,    668,  -1561,   -743,   -651,
       709,  -1136,   -208,    979,    258,   -693,   -535,  -1126,
      -283,   -944,   -209,    603,  -1797,  -2998,    253,   -296,
       842,     63,   -203,   -468,    675,    337,   1458,    114,
       259,   3202,    145,    419,    631,    352,   2309,   1337,
       815,    -99,   -824,   -779,  -1839,  -1455,    166,  -2092,
      1299,    162,  -1026,   -914,    128,   1321,    896,   -209,
       255,  -1144,    807,  -2870,   -632,   -588,    866,     81,
       453,    154,  -1258,   -499,   -452,    -98,   2599,   3070,
       540,   -834,   -228,  -1268,   -313,   1269,    -65,    -56,
      1035,   -499,   -507,   -657,    447,     26,     96,   -175,
       133,   -291,   -538,   -259,      7,   -206,    411,    145,
        25,    215,    267,  -4354,   -442,    250,   -814,   -143,
      -459,   -182,   -640,  -1258,    169,    379,  -1196,    429,
      -128,  -1971,   2681,    -45,   1641,    152,   -556,    909,
       365,   -618,   -417,   -363,   -434,    270,  -1388,   -473,
        62,     58,    509,  -3909,   1327,   1571,    482,   1081,
      -896,    459,    480,   -557,   -267,    390,    -15,    484,
       248,     52,     49,    702,    -10,    162,    245,   -416,
      1397,     23,    183,    325,    591,   -816,   4429,    674,
      -332,  -1243,     68,    285,    235,    759,   -315,    799,
       313,   -331,   -182,   -629,    394,  -1079,   3879,    -81,
       651,   -774,    -21,   -297,    231,  -1826,     47,    104,
       284,   -171,   -198,   -110,   -193,    881,   -715,    294,
      -490,    395,  -1261,   2859,  -3175,  -1477,    668,   -215,
       310,     10,    762,   -837,    101,    142,    201,   -940,
       453,    -82,    493,   -983,     23,   -211,    990,   1327,
      4664,    -27,    821,    809,    500,    243,     41,    568,
        44,   -320,    105,    461,    306,   -408,   -793,    -35,
       -18,    229,    -12,   -416,    577,   -301,   4870,   -520,
       499,     57,   -544,    -21,    611,    226,    -20,   -412,
       440,   -680,    448,    430,    226,   -610,   -310,   -218,
      1161,    523,   -400,   -148,    783,    395,   -126,    370,
       686,   -497,   -301,    161,     -5,    238,    375,    357,
      -126,    954,   5952,    -53,    121,   -405,   1571,    435,
       461,  -1166,  -1163,   1347,   1394,    170,   2035,  -1580,
      -958,    276,   -680,   -968,    275,   -323,    524,     48,
     -1896,     46,   -495,    548,   -929,   -859,    224,   1079,
       863,   3080,  -1594,   -379,    302,   -403,    710,    655,
      -293,   -719,   -683,   -944,    228,   -341,    563,   -495,
       920,    738,   -614,    552,   -249,   -402,   -164,   -262,
      -425,  -4025,    164,   -984,   -518,    157,  -1156,   -729,
      1024,   -768,   1003,    481,   -116,    319,   -918,   1563,
      -662,   4852,    617,   -250,    549,   -265,    -93,    680,
       470,    925,   -293,    629,    142,    231,     44,    133,
        12,     40,   -867,    269,    -77,    445,  -1132,   -985,
     -1304,    728,    424,    530,   -258,   -625,    377,  -1400,
     -2538,   -470,  -1711,    413,  -1603,    -81,   -393,  -1013,
      1130,    906,    287,    640,   3785,   -463,   -159,     43,
      -165,   -441,   -513,   -287,   -554,   1547,    848,   -275,
       936,    653,    769,    -58,  -1007,   -698,   -792,   2175,
       398,   1382,   -122,    459,     -7,    281,   2785,   -637,
       632,   -279,    293,  -1078,   -996,     96,   -293,  -1335,
       -74,   -587,   -286,   -565,   -977,   -228,   5080,      3,
       171,    111,    -34,   -177,   -619,    577,    448,   -280,
       189,   1033,   -579,    134,   -713,   -947,   -249,  -1897,
       364,   1748,  -2098,     21,    859,    -73,  -1881,    116,
        36,   1591,   1386,  -1128,   -346,  -1015,    -25,    -90,
      -691,   -984,   -120,     29,   -635,   -236,     26,   -691,
      -742,   -203,    294,   -472,   -901,   2582,   -171,   -357,
       406,    162,   1561,   -913,    308,  -3319,    461,    779,
      -305,   -927,    290,   -941,    615,   -688,   -508,    222,
      -432,    387,    170,   -115,  -5338,    508,   -212,    150,
        26,    -38,    306,    -15,     50,   2008,  -1112,   -187,
        44,    591,   -280,   1187,    934,   -228,    554,     65,
     -1387,  -1999,   -805,   2555,  -1225,   -283,   -435,   -430,
       -50,   -655,   -103,    248,   -234,     32,   -826,   -708,
      -704,  -1006,    176,    784,    274,    626,  -2353,    707,
      1852,   -132,   -196,   -169,   -463,  -2117,     56,    413,
      -141,   -818,   -365,    921,   -816,   -126,   -135,    438,
      -948,   -145,   -349,    700,    205,   1001,  -3626,    314,
      -493,  -1182,    131,    733,   2404,  -1244,    564,   -960,
       328,  -1137,   -108,   -755,   -168,   -995,    966,  -1706,
      -565,    806,   -693,   1369,   -269,   -428,    675,    768,
       341,   -794,   2265,   -208,  -1883,   -801,  -1889,    961,
       182,   -504,   -595,    871,  -1280,    952,   1351,    665,
       474,   1032,     58,    451,   -198,    345,    176,   -853,
     -2891,   2250,    624,   -616,    183,    144,    736,      0,
      -198,   -138,  -1218,   -501,   -658,    -24,   1232,   -286,
      -233,   -937,   2150,  -1035,    449,   -623,  -2748,  -2176,
       918,   -170,    421,   1376,     93,    153,    627,    493,
        28,    549,   -292,   -175,   1066,   1037,   -475,    413,
     -2006,  -2022,   -334,    365,    901,    945,   -663,    515,
      -351,   -597,    155,   1318,   -153,    417,   -425,     44,
       338,  -1958,   -355,   -596,  -2134,    360,    341,   2501,
       824,  -2106,   -282,  -1723,   -735,   -550,   -743,    113,
      1027,   -479,  -2114,    -16,   -631,   -282,  -1054,   1320,
      -158,   -234,   3479,     28,   1818,    627,   1464,   -795,
       -22,    897,     -6,    392,   -234,   -170,    714,   -382,
      1262,     67,   -618,    145,     25,   -710,   -247,   -545,
     -1386,  -1797,   -995,    865,    465,   -364,    830,    -53,
     -1108,   -383,   -538,     85,    731,   -188,   -813,      2,
     -1667,   3379,    289,    425,   1319,   -259,   -592,   -212,
       271,   -268,   -126,   1282,    306,   3859,  -1423,    607,
        20,    755,    174,   -782,     72,   -234,    675,  -1177,
      1101,   -635,  -1641,   2574,   -978,  -1390,  -1743,   2183,
        53,     75,    650,    -97,   -456,   -126,   -719,   -675,
       557,   -375,    643,    853,    -81,   -192,  -1174,  -1288,
      -954,   -883,   -806,  -2182,  -2111,  -1426,    180,   -266,
      -301,    626,   -443,     61,   -149,   -443,   -935,    -48,
       642,    250,     17,    596,   1342,  -2127,    323,  -1456,
      1995,    837,  -1456,  -1683,    945,   -722,  -1445,    452,
       178,   -441,   -250,   -137,   -128,    -50,   -311,   -600,
      2237,    922,    139,   -107,   -637,   1770,  -2503,    413,
      -803,    496,    209,   -391,    401,    412,   -552,    605,
       -37,   -667,  -1609,    -19,  -1073,   1522,   -705,    670,
      -992,    882,  -1213,   -854,   2150,   -371,     73,  -1167,
      -592,   -153,   -509,   -584,   -495,    -83,   2075,  -1489,
       719,   1245,  -1138,     72,    950,   -950,    542,   -590,
       988,   1646,    -64,    562,   -223,     73,    583,   -151,
       215,    914,   1391,  -2997,    161,    436,     49,   2225,
       271,   -283,   3844,   -578,    335,    -90,   -698,   -162,
      1236,   -117,    470,    383,   -718,    520,    295,     29,
       292,   -179,    774,    204,    372,   -251,   -824,   -487,
     -1822,   -312,   -731,    568,  -1008,   -255,    189,  -1195,
       657,   -227,   3422,    651,   -220,  -1204,   -590,    713,
       365,   -977,    204,   3118,    321,    922,   -347,   1505,
       375,    -77,  -1520,  -1411,   -680,   -507,    543,   -492,
     -1844,    135,    689,    384,   -408,    140,    633,  -1192,
       475,    220,  -1711,  -1318,    606,   -103,   -712,  -1734,
      -218,   -855,   -835,  -3071,   -109,   1391,     62,     21,
       -75,    -77,    369,    216,  -1484,   2057,    661,    314,
       275,   1048,    175,   1842,    743,    808,   -594,    338,
     -1217,   1606,   -531,  -1360,  -1073,    452,   -531,   -798,
      -771,  -1292,   -918,    606,  -1776,   -509,    178,   1422,
      3424,    634,    722,   -257,    525,    437,   -197,   -130,
       291,   -411,   -259,   -890,    -84,    368,   1117,  -1321,
      -324,  -2122,    515,   1158,   1749,   -963,    681,     39,
       268,    549,    324,   -601,    151,   -200,    829,   3881,
       797,    660,   -572,   -693,    633,   1023,   -147,   -581,
       102,   -207,   -163,   -511,    -30,   -102,    379,    776,
       494,   -510,     55,  -1811,   1073,   4384,   -318,   3277,
      1958,   -209,   -539,   1823,   1200,   -182,   -186,    213,
       123,    506,   -471,   -431,   -698,   -331,  -1168,     88,
       276,   -184,    733,   -295,  -1053,   -717,    862,  -1453,
     -4235,   1063,   1049,   -621,   -429,    372,   1043,    599,
       271,   -693,   -689,    122,    466,   -323,    332,   -533,
       645,    516,   -371,   -207,  -2046,     72,  -1125,   -229,
     -2769,   -330,   1387,    -89,    342,   2786,   -730,    152,
       629,    809,   -459,   -248,   -266,    111,    380,    724,
      -411,    640,    -72,    323,     34,   -277,    443,    289,
       151,  -4816,    402,   -171,   -731,    635,    -84,   -133,
      -310,    397,    904,   1193,  -1512,    -25,  -1306,    587,
       322,  -3762,    537,   -306,   -981,    917,    190,    787,
      -613,    149,    301,   -376,    366,    350,     18,    893,
};

static const int16_t cb1110s1[] = {
      -332,   1306,   1626,   1555,  -3510,   -225,    418,   1520,
      -969,    -74,   -286,    233,   -313,    -97,    375,    181,
      -309,   1348,    969,   -504,   -141,    789,  -1224,   -137,
      -704,     98,   1003,    466,   2259,   1485,   -225,     61,
       272,   -223,   -347,    -23,   -368,     96,   2345,    112,
       363,   -552,     -6,   -806,  -1637,  -1703,   1597,  -2114,
      -196,    293,  -1173,   -630,   -863,  -1224,    784,   -722,
       744,    885,    798,   -384,     92,    298,   -873,   1808,
      1389,    488,  -1569,  -1541,  -3064,   -734,      3,    467,
      -987,    346,   1915,   -683,    205,   -487,    341,   -330,
       274,    -25,     49,    -83,   1246,   -405,   -777,    266,
       121,   -250,    466,  -1232,  -3197,   -871,   -638,   -332,
      1563,   1900,   -470,    556,   -465,   -412,    901,    -86,
      -683,   -577,  -1033,    808,   -863,   1212,   -724,   2222,
       429,   2733,    413,    891,   1669,    515,   -439,    187,
      -359,    414,    176,   -706,    679,    -63,   1247,  -1721,
       779,  -2770,   -484,   -633,   -993,   -243,   1442,   -312,
      -324,   -370,    392,   -407,    229,     97,   1267,    -18,
        46,   -303,   -684,    515,   -166,   4212,   -775,    -23,
       -53,     23,   1966,   -465,    231,   1195,    252,  -1036,
        16,   -824,   -116,   -582,   -286,    470,   -159,    217,
      -456,    549,    648,     60,  -1119,    221,   -747,    354,
      -628,   -486,    894,   1280,  -2631,    247,    430,  -1703,
        69,   -236,    147,   1445,    540,   -936,    181,   -163,
       931,  -1044,    669,   2457,    519,    597,  -2031,     11,
     -1319,     -4,  -1190,     85,    254,  -1494,    230,   1583,
      -547,    277,  -2006,   -103,   1195,  -2522,   1301,   -633,
      -104,   -511,    573,   1628,   -451,  -1022,    564,   -692,
       255,   1029,   -408,    757,    172,   -395,   -472,  -1703,
     -1856,   -379,    289,    509,   -628,  -1349,   -207,    404,
      -399,   1671,    392,   -935,   -190,    952,  -1267,   1150,
      1562,   -609,    491,   -346,   -270,   -483,    310,   1420,
     -1017,   1714,   -645,    897,  -1327,   3154,  -1046,   -857,
      -499,   -496,  -1348,    399,     63,   -653,   -315,    820,
      1645,    614,   2202,    779,   3001,   1382,    387,   -843,
     -1840,    422,  -1017,    246,   -219,   -550,    105,   -608,
       426,   -346,   -224,    375,     22,   -448,   -270,  -1150,
      -897,   4298,   -882,     49,    633,   -937,   -694,    675,
      -322,   -793,   -516,   -360,   -248,   1190,    575,   -843,
       -13,     50,   -801,   1181,    452,   -335,   -495,   -102,
     -1057,    506,   -206,     66,   -647,    991,    259,    259,
      -468,    197,    373,  -4216,   -750,    224,   -182,    520,
      -530,   1888,  -2018,  -1492,    656,  -1447,    993,   -790,
      -785,    792,   1658,    373,    131,   -460,   -703,   1080,
      -875,   -212,   -694,    747,   -639,  -2267,   1263,   -415,
      -749,  -1278,    591,   -745,   -225,  -1677,     69,    625,
      -146,    212,    345,    728,   -553,   1117,    471,    550,
      -498,   -729,  -2070,   1006,   -330,    939,   3636,     34,
       349,    761,   -131,    372,    610,   -399,     10,     86,
       110,    931,  -1159,   -175,    633,    568,    140,    712,
      2800,  -1558,   2343,      3,   -974,   -673,    233,   1436,
      -783,    599,   -442,    852,    639,    447,   -976,   -564,
      1511,     36,    529,    433,    677,   1971,   2777,   -820,
      -655,  -1463,  -1392,  -1142,   -352,    432,    730,    439,
      -273,    844,    108,    115,    408,   -361,    504,    337,
        58,   1074,  -1645,  -1623,   -493,    -70,  -1585,   2878,
      -741,    636,   -224,   -974,    722,   -147,    149,    135,
      -107,   -154,  -1027,    -18,   -989,    282,   3173,   1123,
      -778,   1389,   -591,    337,   1660,   -288,   1162,    -65,
       660,    326,    141,    358,    679,   -222,    460,    105,
       512,     36,   -854,   -477,   -942,  -2362,    265,   2252,
      -164,  -2059,    106,    666,   -420,    521,   -178,    396,
     -1836,    475,     82,    356,    207,    433,  -1005,     97,
       385,   -304,   -853,   1282,   -239,  -2134,     83,     84,
       201,  -1894,  -1603,    683,  -1957,   -113,    839,   1187,
      -313,    774,   -754,    941,   -739,    748,    116,    716,
      1134,   -530,  -2178,     71,   -611,   1544,   3527,     -3,
       283,    527,    457,    399,    762,     17,   -279,    196,
      -518,   -160,  -1204,   -289,  -1354,    132,   -315,   -290,
     -2179,    676,  -1474,  -1010,  -1397,    363,    -45,    783,
      1326,    -33,   -109,   -617,   -271,   -967,   -103,   1867,
       769,    740,   -818,   1011,   1411,   -693,  -2458,    808,
       806,   -213,    468,     31,    -70,    166,    230,   -405,
       163,     70,    652,   1077,   -190,   -622,   2343,  -1328,
       601,    928,  -1661,    174,    429,  -2479,    501,    503,
       -41,   1365,    671,   1006,  -1968,      7,    103,   -399,
      -382,    573,    -27,    554,  -2263,  -3174,    277,    177,
       807,   -328,   -816,    453,  -1548,    828,   -327,    187,
      -393,   -745,    -76,   -808,    575,     -8,   -326,  -2062,
       601,    566,    755,    775,    595,    419,  -3925,   -226,
       272,    368,    395,     59,   1117,    548,   -649,   -429,
       321,    549,   -744,    319,     82,    135,     73,     14,
       374,     93,   -270,   -453,    177,   4991,    569,    169,
       111,   -246,   -362,    -88,    -49,    583,    -35,     60,
      -759,   1327,   1768,    766,   -350,   -880,   -106,   -449,
      -113,   -683,   -418,   -999,    992,    559,   -290,   -147,
      -324,     93,   -947,  -3932,    -37,    307,   1087,   -314,
      -293,    432,    830,   -130,   -208,     59,    719,   -348,
      4511,    224,    488,   -174,    588,    795,   -301,   -246,
      -447,    682,    917,  -1207,   -503,   -450,    575,   -116,
      -126,    594,    -22,   -101,      5,  -1188,   -431,   1146,
     -3869,    -72,    402,   -417,   -390,    350,   1141,   -138,
       697,     77,  -3255,   -268,   -786,   -106,  -1386,    400,
      -856,   -691,   -438,  -1550,   -228,   2162,    236,     64,
      -382,      1,   1032,    153,   -659,   1563,   -410,   1280,
      1573,  -3675,  -1041,    240,    401,    215,   -353,  -1140,
       265,   -103,   -824,    -93,   -319,   -849,    253,   -477,
      -463,    153,  -1017,    538,   1233,  -1041,     11,    998,
      -437,   -569,   -970,   2118,  -1577,      1,    321,   1784,
      -298,   2315,     72,    -20,     83,    905,  -1289,   -246,
       731,   4076,  -1477,    602,   -911,    978,    698,   -239,
       391,   -729,   -276,    225,    143,   -417,   -500,    -27,
     -1220,     89,   -403,  -1453,  -2546,   1015,     70,     78,
      2364,   -159,   -775,     29,     37,   -231,     73,    433,
       426,   -529,    420,   -613,   -100,   -605,   1463,   1001,
      1159,  -4082,   -553,    348,   -806,    624,   -162,  -1121,
       -25,    919,    -62,     90,   -275,    233,    203,     32,
       745,   -221,    458,    529,    901,   1088,     38,   1209,
       450,    451,   2250,   -411,   -205,    761,    249,  -1226,
      -266,  -3195,   -801,    -31,   1015,   -324,   -596,    -42,
       150,    207,   2597,   1041,  -1045,  -2254,  -1428,    250,
       217,     69,   -933,   1424,    280,    446,    524,    540,
       639,  -1027,     23,    412,     36,    -67,    475,  -1126,
      -739,   1160,    514,   -157,  -2832,  -1432,    559,     77,
       740,   -888,    134,   1304,   -267,   -267,    329,      8,
      1721,   1488,    -29,  -1760,  -1904,  -2634,  -1342,   -528,
      2233,   -219,   -194,  -2919,    128,   1203,   -623,   -127,
       488,   -386,   -133,   -329,     62,     85,   1271,   -185,
      -479,   -588,  -2964,    546,   1651,   1526,   -830,   1046,
       347,     63,  -1048,    239,   1402,    -22,    307,  -1606,
       768,    999,    304,   -512,   -175,   -246,   -373,    529,
        93,   -521,   1310,   -508,  -4366,     27,   -768,   -358,
      -575,     -2,   -593,    -21,   -838,    635,    197,    634,
       321,   -263,   -377,   -549,     20,    739,    395,     -9,
      -392,     70,   5679,   -133,   -130,   -240,   -678,    421,
      -101,    412,    143,    209,    194,    216,    200,    -22,
      -748,   -399,   2863,    284,    231,    691,    571,  -3460,
      -200,    312,    480,  -1338,   -603,    435,   -308,   -615,
       520,    178,     68,   -716,     45,   -593,    -32,  -1393,
      -554,  -1000,   -867,    613,    288,    507,    202,   -113,
        17,     93,   -141,    -47,    665,    559,   -808,  -4091,
      -575,   -193,   -873,   -790,    673,   -608,   -941,    745,
      1562,  -1060,    988,   1192,     29,  -1207,    207,    653,
      -622,   -132,    370,   1435,   1977,  -1878,   -119,    101,
      -100,   -154,   -869,  -2375,   1254,    122,    188,    877,
       188,   -838,   -355,    667,   3813,   1076,    369,   -771,
      -712,   -669,    -14,    107,   1027,    112,   2306,   1418,
       133,   1055,    377,    249,   1023,   -927,     12,  -1983,
      1174,    223,    385,    827,   1425,  -1694,  -1178,    -94,
      -593,   -286,   1263,   -671,   -425,   2002,    701,   1546,
       547,    182,   1013,    128,    351,   -243,    407,   2349,
      -376,    445,    -93,    968,   -337,   -601,   1342,    987,
     -1499,   -644,    521,    327,   -557,   1800,     12,    285,
       127,   -269,  -1989,   -449,     87,  -1042,    184,   -499,
      1231,  -1664,   -352,      4,   1253,    403,  -1064,    837,
     -1702,    133,   1687,  -1300,   2248,    179,   -847,   -617,
       460,    450,   -260,     94,   -780,   -675,   1209,     38,
       453,    857,   -631,    317,    535,   1086,   -196,    638,
      -288,   -389,    688,    -93,   1271,  -4290,    -96,    445,
        64,   -211,    148,    -74,    486,  -1873,   1214,   1836,
      -708,   1800,   1644,    576,  -1088,  -1212,   1147,   -456,
       173,   -911,    489,   -443,    644,    534,    846,  -1522,
      -786,    497,   -401,  -1087,   1410,   1391,    837,   -253,
       124,   -598,   -254,  -3945,  -1169,    103,   -193,     50,
       846,  -1014,    353,    455,    784,   1343,   3055,    178,
      -628,   -148,   -266,   -324,    -96,   -190,   -930,    115,
       475,   -651,   -314,    -82,   -236,    -88,  -3753,  -1048,
      -283,   -178,    351,   -671,    325,   1054,     28,    540,
       113,    -73,    763,    844,    543,     -6,    799,    245,
       176,    124,    262,   -112,   1010,    361,   -843,   3290,
     -3741,    914,  -1835,   -259,   2467,    297,  -1205,    168,
     -1917,    156,     87,    637,   -677,   -955,    312,   1246,
      -219,     92,   1090,   -292,   -773,    343,   -523,    299,
      -513,   1321,   -536,    586,  -1324,   2345,   2384,   -719,
      -936,   1389,    -27,    880,    338,   -127,   -666,   -441,
      1603,    143,   -218,   2167,  -1335,    469,  -1224,   2489,
      1365,    568,     19,  -1322,   -736,    208,   -494,   -454,
       990,   -250,    305,   -575,    206,   -168,  -1177,    282,
};

static const int16_t cb1110m0[] = {
       429,   -104,   -210,    216,    361,  -2586,    253,  -1350,
       145,   2795,     -5,    663,   -262,     37,   -122,    205,
       270,    321,   2623,    256,      4,    -42,    -37,    112,
      -346,     20,    -51,      9,    -90,  -3342,     78,     52,
      -239,   -454,   -207,    355,   -136,    -19,    394,   -212,
      -166,    -73,    -68,   1049,  -2945,    385,   -545,   -211,
       116,    -15,    687,   -232,   1824,    -66,    133,   -403,
       -63,      3,     46,   -104,   -101,    136,    -61,    420,
       149,    -24,     -9,   4277,   -149,   -166,     96,    -35,
      1786,  -1044,    115,  -1326,   3381,   -520,     70,   -134,
      -433,   -198,    146,   -615,   -143,    201,    342,    412,
      -162,     22,    111,     16,    -85,     14,   -120,     79,
       -30,    -84,     56,    -34,    -52,   -147,     19,    155,
        17,   -120,   5853,     96,    767,    262,   -194,    124,
      -180,     13,   3081,     39,    402,     90,    292,     84,
      1999,    -16,    866,    292,    416,   -314,    177,     -1,
        68,      3,    -28,    -56,    -54,     10,     -5,    -63,
        89,    -69,   -251,     70,   7523,    -83,     67,     62,
       178,  -1723,    -76,    101,    369,   -139,     58,    135,
       -32,    138,   3393,   -575,    586,    292,   -296,   -505,
      -634,     52,    280,     78,     14,    117,    -39,     77,
       231,    136,     14,     51,    173,    -96,      5,    378,
       -52,  -4340,   -263,     61,     22,  -2896,    -20,    180,
        21,   3636,   -138,    104,   -279,     56,   -407,     -8,
      -123,    134,    -95,   -500,    266,    -64,    -43,      1,
      -170,     31,    110,     53,     56,  -5938,    151,     49,
       -76,   -166,     34,     -8,    193,    198,   -118,     -4,
       -44,    249,    -28,   -102,  -3614,     49,    464,   -388,
      -744,   -500,    603,    -88,    -19,   1606,    325,   -227,
      -277,   -142,    232,  -1835,    150,    -89,     29,      9,
        76,    425,   -320,    179,    231,   1720,    424,  -2730,
      -298,    666,     72,   -428,  -1243,   -299,     93,    -12,
       -20,    -96,   -123,     18,    188,     -1,   -235,     -2,
      3328,    107,  -1489,    199,    893,    -63,     46,   3799,
        22,   -118,   -127,    283,    254,  -2091,    293,    331,
       857,    -92,     46,     13,   -457,    169,    851,    -19,
      -231,  -8735,    -62,     69,   -190,   -103,    -31,    108,
        66,     95,     53,     -6,     12,     19,    -73,    105,
       -40,    -29,     60,   -263,   -107,   2233,   -246,    485,
       342,   1732,     76,   2489,     40,     44,   -300,    280,
      -109,   -107,   -990,    -45,   1014,  -5073,      1,   -169,
        25,    -55,   -340,   -427,    603,    206,    151,    360,
       312,    -44,   -106,    514,    683,     98,   3331,     19,
      -106,    106,  -3383,     85,   -161,    -88,      8,     12,
      -163,    183,   -393,    117,   -243,   -498,    -60,    292,
      -322,  -2105,    920,    301,     41,    -19,   -142,  -2485,
       631,   -289,   -849,    132,    800,   -255,   -390,    137,
      -850,   -411,     41,    -93,  -8653,      9,    -25,    134,
       -66,    222,    152,     59,     29,   -193,   -129,   -105,
        39,    -21,    188,    111,     25,     -3,      0,    -79,
      8907,    -24,    -18,     37,    -33,    -42,     87,    -44,
        56,    -79,    -67,    -52,     18,   -132,   1925,    309,
       145,   -443,   1279,    200,   1215,    281,   3343,    311,
       390,   -154,   -119,   -523,     19,   -529,    190,    272,
       541,   -393,    278,    161,     13,    161,    891,    -65,
      -199,  -1376,   -350,  -1409,    340,   2115,   -209,   2459,
        30,   -509,    141,     11,   -557,  -1560,  -1912,   -234,
        76,    787,   2781,     45,   -158,    330,   -623,    655,
      -845,   -463,   -119,   -252,   -299,  -1940,    145,     17,
      -183,    -71,     98,     67,    145,   -134,    -88,     -5,
     -3636,      3,     34,    231,    981,     33,   -953,   -403,
       129,    215,    -11,    109,   -188,     51,   5176,    -89,
      -113,     60,   -138,    -94,    142,    216,    322,    -33,
       350,   -285,    182,     92,    -16,     12,     15,    126,
       -27,      5,  -5220,   -154,     13,    109,     18,   -326,
      -257,    118,    313,    342,   2289,    -35,    -22,    115,
      -256,  -2908,     68,   1211,    203,   -735,   -380,   -134,
       249,    522,    109,    -48,  -5114,     32,    -42,     85,
       -99,    265,   -187,    -93,    373,    341,   -254,     16,
      -121,    -92,   -260,    -80,     -2,   -322,    234,    -96,
     -2834,    230,    146,   -264,  -3287,   -153,     41,   -349,
      -149,    -98,    140,   -115,    628,    -11,    292,      4,
      -166,     82,  -4548,    116,    -23,   -311,    612,   -334,
       451,    259,    559,    320,   -267,    517,   -139,   -166,
       126,     27,    -89,   -156,     14,     63,     -3,     31,
       109,    -43,     10,  -7682,     36,    -23,     73,    129,
         0,   -116,     66,      5,    137,    -17,   2523,    203,
       431,  -2729,    175,    540,    454,   -175,   -297,    -60,
       348,     53,    688,    -49,    133,    -72,    200,   -348,
       136,   -142,  -2259,  -3047,    -60,   -737,     48,   -331,
        85,   -134,    218,   -962,   -278,   -148,  -1077,   -131,
        53,   -127,  -2265,     82,    -31,   -262,    226,   -385,
        83,    756,  -2715,   -492,   -115,    663,   -312,    240,
      -318,   -819,   3040,   -181,    148,    165,    376,     92,
      -233,    188,   -100,    902,   -401,   1005,    -52,    162,
       219,   1831,    -68,    -66, -10023,    -90,    -23,     39,
       -91,   -231,     23,    174,     42,     79,    -57,    -58,
        18,    175,     32,    122,   -185,    266,    162,    300,
     -3158,  -3381,     -3,   -312,    178,    -24,   -234,    248,
        68,    293,    360,   -146,    -30,     -2,    177,    113,
     -1215,   -538,   -274,     79,     -2,    -17,   2791,     71,
     -1300,     93,   -818,   -558,   -331,    115,    215,   -603,
      -202,    113,    -87,     39,   -277,   3564,     75,   -444,
       201,    111,   -369,  -1072,    212,   -276,   -322,   -484,
      -700,     37,   -302,    177,     86,     10,    -87,     56,
        76,  -8941,    -27,    -73,   -133,    -51,   -106,    -28,
       -52,     49,     68,     26,     16,    -81,   -423,   2834,
         7,    -54,   -107,    144,  -3812,     17,   -355,      3,
       -32,    -24,     14,     76,    169,   -260,    349,   -159,
      3691,   -184,   4345,    -46,    146,    -14,    143,   -384,
       -75,     12,    144,    105,     47,    141,    -32,    -31,
        48,    187,     74,    139,    132,     86,    -15,   -317,
      -267,   3112,   1821,   -363,   -125,  -1152,   -294,   -449,
       277,   1151,   -341,     12,    -41,    210,    -51,      6,
        18,     53,     11,     37,    -36,    -70,     65,     44,
     -7302,     15,   -133,     56,    150,     63,    515,    271,
       -32,     47,     41,   -130,    168,   -158,   -239,    -60,
       226,    247,   -593,   -237,  -3559,     65,    623,     16,
      -212,     26,   -181,     81,     83,     26,    -25,    -92,
        -5,     36,    -31,    277,   -263,    135,     78,   -173,
       220,  -5260,   2239,    -96,    -19,    -95,     75,    -25,
       -64,    244,   -154,  -2646,   -446,    980,    512,    392,
      -402,  -1050,    276,   -456,  -1334,   1863,    636,  -1512,
       234,    199,    237,    363,     66,    284,    198,   -277,
      -267,   -540,   -329,    856,   -482,   -645,    178,   -240,
      -178,   6633,     -5,    127,    -80,   -167,    307,      7,
       248,     13,     53,    124,    215,   -310,    255,   -194,
     -3066,    -22,   3524,     51,    193,    165,     82,    -80,
        54,   -191,   -278,    -19,    379,    285,    -58,   -157,
      -168,   -183,    388,   -198,    191,    107,     10,     -2,
     -6148,     45,    -58,     48,   -150,    -72,    112,   -124,
       -41,   -129,     36,    -66,  -3311,  -4092,     15,    -11,
        93,    -54,     72,   -105,    131,     66,     29,    -54,
       201,   -210,    221,     47,     55,    -99,     31,  -3626,
     -3623,   -175,     91,    -53,     40,    -98,    -76,    224,
        15,    172,     85,    103,   -147,   -135,   -214,   -313,
      1304,    143,    190,     19,  -2526,    -91,   -168,    875,
       -27,    789,    791,   -462,    912,   -580,     70,   1523,
       787,   -150,    567,   2717,     -5,   2943,   -107,    155,
        32,     65,    158,    133,   -191,    -44,    141,   -149,
       199,    177,    270,    -14,    -57,  -3669,   3891,   -158,
       239,    -17,     52,    244,   -343,   -118,    186,    -54,
      -134,    106,   -133,   -116,    186,   -149,   -894,    -22,
      -399,      1,    288,  -3988,   -260,    113,     66,   -276,
       179,   -226,    119,    420,     51,   -483,    551,    129,
       245,   2013,    639,    -87,   5058,     41,    -53,   -116,
      -130,   -223,   -104,   -760,    276,    117,    338,   -137,
      -233,    -65,    119,    100,  -3245,      2,   3877,    126,
       172,     -2,    -72,   -153,    200,   -109,    -62,    135,
       194,    -82,   -150,     98,    550,   -251,   -274,     71,
       160,    121,    -13,   -365,    356,   -212,   -271,   5067,
      -203,   -251,    222,     75,   -131,     17,    103,   -911,
      -348,    -26,      6,    110,    120,   -645,    355,   -649,
      -132,  -3416,     65,  -1478,    461,   -109,    258,    -15,
};

static const int16_t cb1110m1[] = {
      -110,   2743,    -31,     86,    -11,   3705,    192,    -89,
        57,   -252,    -11,   -212,    163,      0,   -137,    405,
       -99,   -124,   -137,   -407,    125,    106,   -922,   1567,
        85,    165,    241,    110,   2918,    598,   -443,    812,
       159,    518,    555,  -1886,    -65,    -52,     -3,    -27,
        56,    -30,   -126,    126,     23,     74,    157,   6990,
       -34,     56,   -257,   -172,    115,    -23,   -616,   -243,
      -441,     34,    159,      6,     78,   -119,     49,     34,
      -133,    988,  -1007,    474,     77,   -274,    354,   4907,
       222,    -16,     69,     -4,    924,    -18,   3535,   -299,
       -38,    -83,   -111,    977,   -138,  -1075,   -444,    540,
       199,    202,   -502,   -194,   -198,    249,    101,    276,
       -89,     96,   -301,      6,  -4023,    -70,    174,     93,
       192,   -120,    755,   -560,    -22,     78,     56,     29,
        28,    -44,     65,     -4,      0,     49,   -250,     87,
        46,     44,    -41,  -7035,     14,    288,    632,   -259,
       -64,     20,   -178,   -343,   -274,    106,   2842,    336,
      -283,    245,   -612,     -5,    500,     77,   2492,   -250,
        64,    171,   -988,      4,    -51,    -34,   -555,   -171,
     -2629,    272,   2852,   -162,    -98,   -237,   -278,   -489,
       641,    -96,   7815,   -139,   -116,   -137,   -121,   -314,
      -161,    211,     76,    136,    -35,   -124,    -27,     76,
       -98,    133,     85,    332,  -4352,    507,    -14,   -275,
      -212,    308,    258,    129,   -165,   -197,   -104,   -150,
      -104,     60,    125,    568,     -3,   1694,     62,    -70,
       109,    122,    -57,    -18,   8642,    100,     50,     92,
        17,    -86,    -93,    -68,   -121,    -61,    -32,     27,
      -188,    502,    123,    -81,     37,     48,    187,     75,
       -30,    -22,   -224,   -292,     99,    -49,   4273,     10,
       834,    -25,    225,   2773,     78,  -3281,   -181,    234,
      -130,    -74,    101,    214,    -26,   -113,   -268,   -168,
       -90,   -435,    -26,     38,   -569,  -4009,     -1,     11,
        69,      3,    249,     98,    178,    131,    300,   -826,
        48,    337,   -828,   -371,     96,    312,    712,   -667,
       -70,  -2070,   -242,    519,   -676,    143,   -613,    893,
     -2193,    471,   1071,    213,  -1231,   -196,   -580,    155,
       401,     78,    -64,     27,   -238,     22,    -73,    -19,
       194,     60,    -87,   -210,   -155,    244,   -123,   -169,
     -4442,    169,   3132,   -181,     65,   3950,   -396,    209,
        39,    -52,    -26,    166,      1,   -164,    143,    -66,
       169,     46,    -16,   -295,     39,     42,     40,     67,
        25,     17,     -1,  -8920,    -82,    -42,     49,     81,
       -61,      1,     39,    -40,     18,     74,    206,   -131,
       -71,    106,      7,     88,    -13,     69,   -113,    -89,
       212,     -4,   4373,    -34,    283,    105,    252,     59,
     -2578,   -298,   1846,   -110,   -105,   -310,   -143,   -127,
       274,    225,    861,    262,   -815,   -311,    -26,   -685,
       243,   -620,   -374,   2992,   -112,    -35,   2903,    -94,
       -56,   -213,     65,    383,     41,    508,   -258,   -103,
      -440,   -237,    428,    132,   2793,    -77,   -113,    -58,
       -19,  -3857,    -25,     40,   -167,   -243,   -233,    -41,
      -279,    213,    -22,      8,    120,    126,    159,   -212,
      -244,    183,   1605,     62,    -12,   -244,    519,    780,
       116,  -3197,   -992,    341,    222,    681,   -357,   -669,
        55,   1213,    100,    441,      1,    -57,    232,     10,
      -114,    318,   -147,     89,    188,    448,   -327,   3735,
      -292,    875,   -216,    211,    111,    160,    172,    286,
     -3513,   -849,   -185,     -9,     31,    442,    747,  -1045,
       187,    704,   -219,    509,     48,     69,    -25,    -10,
        75,     23,     10,     23,    -32,     89,   8628,    -77,
       -19,     27,      0,   -232,     22,    -50,  -1904,   -137,
      -169,    128,    138,     78,   -443,    243,    157,  -3809,
       231,    277,   -341,     73,    -70,    596,    259,    157,
      2197,    575,   2445,     11,    -53,    118,   -115,    562,
       108,     30,   -241,     30,   -394,   -155,   -186,   -344,
      -237,   -319,  -2258,    343,   -311,     14,    169,     59,
       -15,    233,    732,    365,   -692,   -108,   1416,   -463,
      -279,   -248,  -1731,   -406,   -278,    298,    209,   5333,
      -198,   -167,     50,    439,    142,     91,   -523,    226,
       262,   -130,    -15,    573,     -4,    271,     -2,    -47,
         7,  -9106,    -69,    -44,   -144,    -98,    199,   -181,
         6,     45,     47,     37,    -51,    -68,    -50,   -116,
      -105,     49,    376,   -420,    187,   2894,     29,   -471,
      -221,    455,     -1,   -858,     55,   -197,    359,  -1972,
      -188,    921,   -134,    186,   -843,  -2542,    322,     -1,
      -158,   -352,   -307,   -578,    -60,    143,  -1302,    333,
       681,   1373,  -1021,     18,    284,    -28,      8,    -57,
       -16,     15,     58,     31,   8389,    -35,     18,     77,
       -78,     15,     36,     17,   -134,    -17,    316,   -680,
       491,     38,   -217,   -278,    276,   -299,    -75,  -4030,
      -293,   -507,    -62,   -344,     64,   -438,   -344,   -256,
       341,    199,    -66,     28,    -17,    -17,      2,    142,
         6,    -48,   -169,    -27,   -117,   6739,     42,    -61,
       140,    246,   3357,  -3243,     48,    -55,     49,     27,
         4,    172,   -169,      6,     69,   -265,     70,     25,
       223,     28,    129,    231,     57,  -1608,   2640,    -28,
      -197,     29,    -11,    138,    621,    427,     20,    514,
       663,    562,    447,   -158,   -909,    343,   -321,   -257,
      6641,     -1,    -20,    -70,     62,    241,     51,    -83,
       -48,   -156,   -266,   -335,    -43,    421,    350,    306,
       165,   -541,     47,      5,    -40,    364,     21,    190,
     -4584,   -125,   -441,    489,   -571,    -47,    -10,    205,
        60,    -73,   -584,    417,    233,    -34,   -109,     85,
        41,    134,    485,   -171,   -183,  -1522,    202,    390,
     -3112,    144,   1675,    651,    402,   1953,    120,     93,
      -276,  -1930,   -197,    -61,    100,     81,   -250,   -155,
       -19,    336,   -178,  -2340,     88,   -543,    226,  -2507,
       -60,    -62,    218,     -9,    158,  -3617,    -66,     32,
       314,   -192,   -121,    372,    334,    516,    412,    247,
      -609,  -1237,    312,   -120,    -39,     47,     61,    -63,
       -90,   4500,   -191,   -353,     10,     54,   -163,   -345,
       121,   -318,   -235,    190,    -99,    181,  -3369,      4,
      -188,    -87,    128,    167,   -507,  -1132,   -666,   -354,
       121,     43,   -546,    601,   -409,    181,    -47,   -315,
       127,  -2845,    487,    186,  -2724,    343,    177,   -837,
       387,    -84,    259,    122,   -159,     88,    117,    137,
        79,    126,   1584,   -521,  -2448,   2648,   -246,    -75,
       567,    114,    244,    653,   -551,   -196,   -623,    205,
       816,     48,   -326,     66,    -94,    -33,    133,    412,
      -241,    491,    -32,   -712,   -249,  -3756,   -185,   -229,
       248,    268,    557,     73,    164,     24,    -70,    -27,
        54,   -156,    -51,    -47,    -26,     43,    187,    179,
       -38,   -137,    218,   1916,   4614,    435,    -15,     21,
       145,   1868,    241,    240,    299,   -204,     73,    -24,
      -118,   -372,    -89,     23,   -298,    479,   2837,    959,
       -76,    -85,     -2,     28,     94,  -3245,     28,   -130,
       159,    295,    264,   -419,    -98,    -16,   -159,    349,
       202,   -158,  -2680,   -210,   -390,    -18,     -8,    364,
      1367,   -110,    932,   -232,   1348,    -80,    865,   -291,
      -408,    406,   -118,   6462,    -55,     10,   -152,   -161,
      -132,    231,    258,    135,    -13,   -104,    247,    207,
      -238,    212,    -19,    -31,  -3303,   -160,    -24,   3402,
        50,    116,   -191,     97,   -139,   -100,     71,    -49,
      -293,    133,   -120,    -10,    197,    196,   -516,   -686,
        79,    -52,   6002,    -47,     88,   -201,    146,    136,
        54,    162,   -180,    287,     67,     70,    -55,    210,
     -1938,    635,   -162,     82,   -120,   -456,    -75,  -3753,
       -83,    176,    137,     18,     -6,   -281,    232,    137,
      -167,    373,     78,  -2622,    -38,   -293,     89,     69,
     -3476,      8,    152,    136,     32,    -15,   -140,     11,
         6,     13,    481,   -175,   -228,   -254,    158,  -3423,
       206,     22,    900,   2025,    266,   -402,    132,   -356,
       558,   -592,   -262,   -419,   1002,     73,   -246,    -24,
     -3145,   3220,    -33,    283,    398,    -31,    -25,     -7,
       103,    -93,   -143,      1,     32,   -497,    206,    -35,
      1424,    114,    140,   2393,   3245,   -218,   -163,    113,
       191,   -164,   -215,    504,   -256,    140,   -364,   -226,
      -340,     91,   -464,     32,    188,      4,     15,  -6068,
        69,    109,    219,     75,    196,    -24,    -84,   -218,
        27,     57,    -97,      8,   -338,     -4,    358,     23,
       -52,    -68,    552,   4023,   -255,    684,    144,    188,
       100,   -293,    462,    553,      9,    665,     12,   -640,
     -5099,   -158,   -245,    -74,   -168,    263,   -355,   -370,
      -653,   -163,   -473,   -394,   -233,    750,     17,    -31,
};

static const int16_t cb1110sl0[] = {
     -3736,  -3737,    -18,   -285,    383,   -144,   -155,   -204,
       296,   -399,   -663,    356,   -364,    329,   -330,     -5,
       -52,    -88,    -41,    228,    -21,    -45,   -136,   -280,
      -109,    -86,     57,     91,   -212,    158,   -106,    -90,
     -8192,     70,   -255,     78,     -8,    -89,   -110,    -58,
       104,    -51,  -2598,    411,    -94,   -567,    209,   -464,
       139,   -234,   -336,    754,    863,    399,    345,    117,
     -3435,   -219,    369,     59,   -325,   2439,   -148,      6,
       -48,     84,    -14,     71,     94,     10,      6,     73,
       106,   -490,   -200,    186,    345,     -8,     99,  -3687,
     -1571,   1836,  -1593,   1111,  -3700,    470,     -6,    401,
      -182,   -119,    438,   -263,    228,    785,   -361,    -56,
      -492,    465,    333,     61,     53,    234,    -23,    -87,
        39,    105,   7282,     59,    -47,    -57,    -77,    -45,
      -172,     12,    179,   -134,     37,   -157,    -19,   -206,
         9,   1186,   -264,    600,    350,    374,    115,    -55,
       727,   -164,  -3903,   -735,    586,    -24,    145,   -786,
      -118,    943,    514,    396,   3435,    -35,     83,    294,
       107,     16,  -3636,    -93,    360,   -307,   -105,   -172,
       204,    320,   -148,    410,    175,    335,      0,   -178,
        12,     94,    -47,    -91,    -49,   -159,   -155,    -65,
       -17,   -159,   -316,     64,    155,   -260,     81,  -4766,
      -150,   -116,   -332,    128,    675,   -105,   -479,    563,
      -101,    101,   -379,     33,     37,      1,    106,    151,
        69,    140,     -6,    -74,    157,   -125,   -120,    -33,
      -178,   -286,     60,   -158,     43,  -7291,   -295,    -68,
       -34,    -68,    -58,      8,    176,    -42,   -212,    176,
      -533,    -62,    -27,    167,    291,     59,    311,  -3050,
       552,   -493,   -207,   2576,   -991,   -375,   -102,   -980,
      1130,   -565,   -199,    559,  -1390,   -428,   -618,     70,
      -437,   -245,  -1132,  -1302,   -453,     83,    222,  -1555,
      -178,  -1396,  -1176,   -228,    730,  -3121,  -1085,     84,
      -326,     71,   -185,   -315,    889,    803,  -2910,  -3609,
      -639,   -199,    187,    137,   -622,    473,    121,    181,
        85,    395,    523,    589,     71,    703,    123,    361,
        47,   -675,    299,   -446,    307,    591,   3341,     64,
       526,  -1541,    -50,  -1369,    701,   -144,   1720,   -713,
       562,    297,    146,    -34,   1315,    956,    761,   -415,
     -1311,    637,  -1263,  -1096,   -385,   3228,   -395,    317,
      -354,   -503,    255,   -526,    245,    598,    853,   -269,
      -110,   1354,    333,    110,    855,  -3346,    635,    636,
      -917,   -577,    260,    147,   1041,   1273,    385,   -862,
      1751,  -1099,     80,   -148,    120,   -118,   5565,   -484,
       -74,    326,    291,    234,    -41,    212,    192,    207,
      -108,    198,    118,   -389,    178,   -151,   -252,    -69,
      -243,   -800,   2640,   -531,     84,   -301,    157,  -3428,
         3,   -418,   -173,   -166,   -722,    207,    448,   -387,
      -504,    202,    453,    210,   -203,    304,    190,   -264,
       101,    -23,     36,     74,   -146,     26,     29,    -33,
        59,   -127,     22,    213,   -167,    103,   8192,    183,
      2709,   -125,    324,   -964,   -259,   -400,    -41,   -430,
       367,    127,    266,    369,   1081,   -190,   -220,  -1083,
       641,  -2733,    750,    525,   -623,    -18,   3159,    686,
      -278,  -2083,   1680,    587,    123,     -6,   -266,    376,
       522,   -433,   -499,    169,    106,   2041,    174,    571,
      -108,    129,   -116,    -87,   -252,     89,    -14,     14,
       120,  -7874,   -204,     15,     19,   -110,    -82,    -54,
        66,     31,    210,     55,    339,     61,   -219,  -3205,
      1292,     80,    344,   -733,   3172,    -21,    -55,    712,
      -192,     38,    408,    489,    388,   -343,   -763,    438,
     -1812,     -6,   -129,  -1392,   -382,    -28,    105,   -284,
      -168,   -462,   -284,     22,    113,   1203,   3253,   -589,
      -619,    348,    113,    847,      3,   -557,    460,   -636,
      -601,   -742,     46,   -111,     51,    -66,  -2867,    551,
       455,    898,     17,   2205,   1004,    -46,  -1475,   -367,
      2849,    766,    -32,   -119,    624,   -722,   3371,    172,
      -330,     93,   -221,    457,   -453,     84,   -281,   -360,
       108,    487,   -301,    166,  -2611,    577,    192,     34,
      1105,    705,     34,     29,  -3041,   -898,    172,    578,
       307,    483,   -439,   -327,    360,   -935,    -76,    387,
     -2485,    800,    333,    601,   -712,   -973,    -65,   -442,
       220,   3577,   -428,   -210,    565,    757,   -382,    289,
       726,    -19,   -182,    384,    -32,     38,   -810,   -181,
     -2978,    259,   -213,   -473,   -187,   -823,   -279,   1518,
        26,   -385,   1143,   -409,   1310,    676,  -2472,     64,
      -391,   -102,    455,  -5751,    278,     30,     64,   -177,
      -113,   -170,     94,   -234,   -167,    101,     -2,   -149,
      -131,    351,   -254,   -138,    149,    -42,    631,    -21,
       237,   2893,   -291,   2917,  -1240,    211,   -215,     22,
      -827,   -160,    140,   -213,    156,   -250,  -1233,    691,
       498,    -30,    350,    -28,    -12,    217,     34,   -348,
       -70,   -140,    103,    -60,    353,   -200,   -314,    -74,
       112,   4435,    -80,   -287,    413,    -99,   1407,   1519,
     -2230,    114,   3179,   -523,     39,    340,   -379,    373,
     -1552,   -138,   -446,   -106,   -762,  -1017,   -297,   -183,
       498,   -481,    374,    271,  -5609,    297,     98,   -378,
       187,    -78,   -125,    333,    114,    -81,     62,   -145,
        14,    362,    518,    134,    195,    130,    -34,    -72,
     -3088,  -2965,   -114,    585,    -78,      6,    552,   -633,
       -98,   -224,    980,    338,    -83,  -1064,     42,    106,
      -119,    644,   -293,    496,     67,    128,   -129,    620,
        20,    526,   -177,     68,    351,  -3703,   1465,    905,
      -245,     86,    511,     39,   -512,   -150,    239,     86,
        60,     39,    -79,     -9,    -65,     77,  -7993,     57,
       -19,     56,    -38,    161,   -221,   -129,      8,     93,
        52,  -5622,   -114,    133,     26,     64,   -194,   -316,
      -143,    225,    -66,    -81,    -74,    240,    130,    137,
      -549,     11,    352,    -53,  -4029,    513,   3164,   -205,
       127,     80,   -193,   -197,    -36,   -885,    223,   -858,
         5,   -458,    290,    459,    247,   -284,   -176,   -748,
       173,    191,    114,    406,    126,      3,     91,     84,
      8027,    379,    -56,     47,     35,    246,   -143,     65,
       -36,      8,     59,     67,    -69,   -421,  -3492,    312,
      -252,    261,   3367,    319,    -67,     77,   -346,    386,
        34,    237,     18,    111,    348,   -547,    186,    -93,
     -3558,   -178,  -3801,   -133,    -27,   -561,   -308,    112,
      -224,    272,   -195,   -270,   -179,   -165,    199,   -524,
       681,   -117,   -429,     37,  -5891,     94,    -55,   -433,
      -354,    122,    -60,     67,   -200,    -80,    267,   -136,
       -42,    130,   -324,    -25,    156,    167,    -47,    178,
         8,    289,    157,     88,    -28,    -39,   -262,    -11,
         9,   -113,     76,   8192,     89,    115,   -298,    137,
        34,      0,    261,    -30,     49,    274,    130,    824,
      -944,    -56,   1074,   -314,    -76,    527,     75,  -3321,
       733,   -798,   -352,  -1038,   1049,     72,   -233,    312,
      3363,     69,    104,   -149,     22,    283,    -20,   -101,
     -3350,    164,   -328,   -362,   -993,    430,     78,    125,
       269,    -29,    362,    -73,    -30,  -1189,   1396,     59,
     -1285,   -216,   -121,   3893,     84,   -464,    -38,   -113,
      -369,   -181,   -930,  -1012,    394,    120,    274,   -552,
      -800,    105,   -141,    -12,    241,   -667,    543,   -416,
        28,   -182,     51,    905,  -3964,  -1213,     12,   -271,
       378,   -234,    838,   -113,     56,    567,     35,     48,
       490,   -180,   1097,    170,   2596,    -28,   3098,   -220,
       424,    885,    -42,    783,    -30,    907,     63,     46,
      -131,     28,    -55,     54,    -46,    -25,     30,     58,
       -15,   -200,     -6,     11,    -70,     66,  -8089,     86,
      -136,     96,    -56,   -101,    300,   -661,    -41,   -201,
       760,   -252,    955,    189,   1459,   3562,   -457,     35,
       -54,   -164,   -329,  -1245,   -830,   -365,   -399,    -23,
       616,   -238,  -1301,   -198,    335,  -3400,    149,    175,
       -97,   -279,   -594,    -92,   -915,   -830,    468,    628,
       728,   1024,   -549,   1073,    222,   -142,    296,    -75,
      -168,     -5,    -67,  -7311,    -50,   -256,   -321,    121,
       358,   -272,     30,    258,    105,   -161,   -291,    462,
        -7,   -211,   -227,   -104,   -151,   -152,    -72,    -98,
       -59,    -23,    -98,   -203,    103,     89,    239,   -484,
      7749,    110,     35,    345,    282,   -578,    140,    -51,
       -62,   -238,    102,    454,     64,   -107,   -223,   -174,
       285,    110,   -190,    -16,   1624,    142,   3813,   -849,
        43,    234,     84,      0,   -132,    131,   -135,    -70,
        -1,    125,    -83,    171,    109,   8044,     97,    -38,
       143,     64,     13,      4,   -225,    181,    712,    626,
        20,    167,   -467,    186,   3801,  -2179,   -647,   -119,
      -112,   -183,   -223,    295,   -438,   -407,    -29,     36,
       -34,   2536,    -47,   -402,    -33,    -62,   -136,   2444,
      -152,   -717,   -868,     86,  -2323,    931,    659,  -1281,
       -98,    638,   -162,    195,     -5,    -40,    -88,   3019,
      3466,   -323,    316,   -784,   -715,      5,    188,     42,
       155,   -608,    500,    185,    475,    100,    -51,    879,
      -891,   -158,     18,   -453,    380,   -207,   -143,    401,
      -153,    926,   -184,   2775,   3176,   -797,   -198,   -888,
       405,    460,    309,    304,   -114,   2386,   2319,    658,
     -2200,    216,    435,  -1210,   -655,    154,     81,    538,
       908,    220,   -118,    482,   -864,   -526,   -241,    857,
      -473,    774,   -288,   -886,     46,    250,    -96,    301,
       120,   -488,   -128,   -233,    422,     38,  -3416,   -974,
      -243,   -226,    381,   2394,    652,   3124,   -205,  -1303,
      1484,   -159,   -152,  -1037,   -105,   -121,   -466,    -76,
       605,    181,    -55,   -326,   -527,   -126,   1691,   1316,
};

static const int16_t cb1110sl1[] = {
      -743,   -300,   -347,   -441,     85,   5282,   -250,     32,
        28,   -306,   -434,     78,   -178,   -112,    -28,   -162,
      -188,    -43,     17,     94,   -242,   -258,  -2691,   -471,
      -556,   -815,    120,    -57,    -36,   -325,   3282,   -765,
       355,      2,   -162,   -454,    -72,    192,     86,    219,
      -123,    237,    135,    -42,    492,   -471,   -114,   5146,
      -164,     28,     77,     70,    276,   -148,    333,     64,
       -89,    -46,   -135,    474,   -218,   -119,    351,   7619,
        93,    -80,    -84,    -51,   -110,   -223,    -13,   -116,
      -160,   -102,    -64,   -140,   -376,    156,   -143,   -421,
       105,    102,    519,   1256,    786,   -284,  -3029,  -3021,
      -365,   -515,  -1358,   -273,    394,    489,   -242,     31,
       239,  -1328,    169,   -488,  -3069,   -398,    303,   -274,
       498,  -2758,   -748,   -208,   -324,   -285,     78,   -386,
     -1063,    298,      5,    693,    160,   -629,   1656,    186,
       457,    742,    422,  -3723,   1997,   1025,    -24,    291,
      -588,     16,   -327,    459,   -521,    421,   1279,   -408,
        -2,  -1320,    101,   -372,    -66,    100,   -605,   3214,
      -374,   -660,   -371,    207,    175,   -553,   -574,   2962,
       119,   -551,   -140,    -62,     50,   -608,   -237,   -100,
       108,    101,   3258,    -31,    -45,    375,   -161,    132,
      2842,   1458,    235,    800,   -113,    719,   -291,    -29,
      -512,   -267,     53,    780,    -59,   3387,   -175,     88,
       -78,   -475,   -536,    584,  -3025,    -19,   -105,     91,
       875,    -55,   -771,    143,    384,    810,   -372,   -253,
       160,   -128,    232,     98,   7755,    181,    -19,   -177,
        46,    -39,    -30,   -212,   -289,     75,    127,   -114,
        80,     79,    325,   -128,   -436,   2547,    -73,    -29,
      1046,    344,   3340,   -335,    458,    637,   -175,   -695,
      -366,    294,   -322,    564,    542,    209,    524,    -62,
       444,   2827,    -53,     66,   -959,     84,    484,   -147,
       158,    259,   -479,   3216,    232,    -68,    583,   -810,
       107,     93,    629,   -168,    143,   -552,     96,    -71,
     -3903,   -438,    335,   -133,   -186,   -278,     73,   -575,
      -253,   -733,    -91,     -8,  -1149,    350,    140,     12,
      3935,   -236,    103,    469,    610,   -536,   -305,   3112,
        13,   -182,   -686,    637,    525,    327,    102,    -49,
      -450,    -16,   -480,    233,    -82,   -132,  -3979,    426,
       757,     54,    152,   -701,    513,   2330,    148,    242,
      1709,    162,   -168,    146,      0,    891,   -644,    109,
      -549,    104,    -50,    275,   -193,    -55,   -144,   -117,
        31,   -234,     68,  -5369,     72,     54,     54,    119,
      -140,    192,    286,    -42,   -278,  -3524,  -3609,    692,
      -366,    -15,    343,   -885,   -267,    294,   -387,   -215,
       -83,   -469,    790,     85,    428,   -613,    114,    634,
       279,   -570,    616,   -813,   -117,   3073,   3121,   -717,
      -200,    285,  -1061,    -44,    945,    386,   -166,    494,
       776,     36,    -25,   -444,   -260,    407,   3885,   1049,
      1348,    185,    454,   -136,  -2275,   1064,   -271,   -316,
       645,  -1050,    483,    430,     32,    569,   -676,   -335,
      -328,  -2982,   -370,     50,    189,    155,   1058,   -119,
      -407,   -310,    461,   3293,   -604,    195,     48,     68,
       196,    194,    547,   -210,    785,   -383,   -410,   -268,
      -149,    192,    -88,    -13,     20,    -80,  -5146,    -86,
      -111,     40,    -36,   -138,     12,    239,    -36,    -84,
      -512,    149,   -237,   -672,   3477,  -3446,   1198,    220,
       146,   -747,    242,     48,   -146,   -196,   -335,   -777,
      -405,    620,   -340,   -367,   -389,   -108,    -27,   -184,
     -2024,    518,    241,   -104,    417,  -1356,  -1961,    134,
      3221,   -423,    286,    -60,   -110,   -568,     14,     76,
      -144,    159,    704,   -410,    542,    -43,    223,    105,
      -154,   -141,    -84,   -132,   -271,   -235,   -285,   -248,
       480,    430,  -4711,   -487,    -86,    482,     80,     46,
      -239,    -93,   -115,    -54,     -1,      7,     97,    -12,
       151,   -180,    159,    -63,     65,   -215,     54,   5712,
      2886,   -115,   -236,    113,    -25,   -301,   -450,   -276,
       -78,    197,    -55,   -278,   -511,    163,   3442,   -910,
       -74,   -225,   -103,     63,   -204,    -43,   -126,   -334,
       223,    192,   -131,    202,    -83,   5000,    -66,    441,
        33,      0,   -116,    237,   -238,    -37,    445,    -48,
         7,  -1855,  -1154,   -251,   -117,   -185,    125,   1877,
       375,    388,   -904,    202,    649,    376,  -3231,    897,
       101,   -637,    376,     16,      1,    845,   -550,   -610,
      -380,  -1363,   -955,     71,   1303,    296,   -264,   -584,
       247,   3247,     98,   1035,   -670,    416,  -2008,   -448,
       -56,   -169,  -1787,   3314,    408,   2541,   -833,     -2,
      -169,   -184,    193,   -575,    -81,    410,   -293,   -478,
        21,    194,    223,   -111,   4648,     60,    354,   -593,
     -2429,   -671,    150,   -350,    151,   -448,     -5,    386,
      -441,    131,   -339,     87,    815,    279,     51,    131,
        56,  -3194,   -170,  -3899,   -297,    270,     21,   -215,
         7,    205,   -305,    141,    577,     83,   -289,   -502,
       -66,    -96,    433,   -106,   -685,   -194,    -82,     33,
        98,    315,    258,  -2453,  -2957,    608,    672,    152,
      -681,   1804,    -74,   -459,   -423,    114,  -1183,   -100,
      -798,    357,    -79,  -3418,   -676,    580,  -1637,   -506,
       306,    437,   1001,    731,   -885,  -1276,   -583,   -359,
       650,     15,   -189,    190,     86,     39,  -7987,   -133,
       324,    174,     22,     86,   -144,   -125,    -43,    -81,
       -49,     68,     39,   -204,   -159,   -291,   -217,    -68,
       264,    193,    406,    247,     27,   -272,   -168,    536,
     -5740,   -141,     38,     18,     -7,    258,   -111,    125,
       476,   -364,      5,     72,  -2668,   -197,   -605,   -671,
       -82,    201,   -752,    227,    240,    345,    -11,   -138,
       551,   -351,   -228,  -2774,   -132,   1115,  -1038,    -18,
       791,  -3136,     81,    219,    357,    755,    579,     26,
     -3129,   -398,   -719,    193,    495,    290,  -1123,    854,
      -381,   -535,     33,    232,   2340,  -4577,    -94,   1023,
      -117,     39,    -54,     15,   -161,   -860,     64,   -209,
      -597,    415,   -135,   -407,   1068,    894,   -784,    108,
       267,   7506,    140,     67,    198,     74,     52,   -388,
      -184,    -24,    -54,    -24,    172,    172,    -50,   -184,
      -113,    164,    128,    -39,    252,     90,    356,   -313,
       -90,   -313,   -355,    -73,     19,    139,    141,   -122,
      -231,  -4548,   -157,   -227,     47,    231,   -421,     60,
       -80,  -3619,   4252,   -354,     69,    148,    336,    446,
      -183,     86,    248,     35,     73,    120,    157,    156,
      -291,   -523,     35,   -264,   3434,    189,    495,    -59,
       533,   -343,   -554,  -3014,   -415,     17,    436,    552,
      -240,   -394,   -761,     43,   -766,     46,  -1119,   -254,
      1540,    195,   -298,   -833,     45,    -93,     61,     40,
      -171,    167,     82,    107,     16,     40,   -166,    -46,
       120,   -185,     13,    151,   8151,   -235,     92,    -23,
       214,    206,    260,     93,    163,     78,    184,    -60,
       -12,   -171,   -499,   -151,   -219,     11,   -221,    221,
      3253,   -376,  -1079,   -481,    763,   -257,   -120,    -10,
        34,   -640,    341,  -2953,    528,    567,   -672,   -335,
      -175,    -61,    581,   -260,   1159,   -802,   1070,     12,
       168,   2305,    291,    203,    -15,   -569,   3247,   -179,
       620,    339,    224,    710,   -416,    512,    -86,    571,
       439,   -167,    571,    -72,   -144,    236,   -382,     11,
       268,   -176,   -136,   -337,    220,     64,    341,    361,
     -4474,     25,    385,    453,   -153,     89,   -572,    245,
      -197,     33,     75,    588,     51,   -199,    -74,   -149,
       224,    210,   4689,    282,     20,    -47,    129,    221,
       -72,     27,     76,     93,    331,    215,     -5,    -20,
        74,    -80,    169,    126,    -40,   -137,    -24,  -8101,
       -23,    165,    271,    403,    -34,    -19,    290,   -199,
       -14,    205,    657,    301,   -885,   2457,  -1965,  -2266,
     -1004,   -224,   -554,    182,   -220,   -467,   -611,   1012,
      -122,   3303,    -73,   -205,     93,   3549,    217,   -223,
        55,   -459,    541,    286,    -46,    128,    354,    137,
       824,   -313,     32,    301,    139,   -492,    170,    136,
       -35,   -752,   4613,   -830,    -34,     41,    344,    279,
       643,   -394,   -461,    163,   -330,    199,   -215,     83,
      1096,    613,   -473,    816,   3534,    210,   -772,    935,
      -275,   -600,   -341,    602,    104,   -598,   -217,   -789,
     -2428,    870,   -351,    474,     50,    321,   -148,  -2929,
        25,   -135,    -46,     11,   -566,  -3057,   -664,    700,
      -300,    256,   -960,    350,   -480,    414,    431,     24,
       -51,   -228,    407,    142,   -321,    316,   -290,    149,
        56,    -84,   -359,   -118,  -4948,    138,    373,    -49,
       142,     71,   -163,    -13,   -279,     38,   -121,     35,
       -47,    -70,    -43,    116,      3,   -159,    -11,     97,
      -116,    -62,    156,    307,   -173,   7294,   -143,    288,
       -34,    671,    613,     16,   -240,   -229,   -414,   -494,
       -43,   -169,   -854,    336,   -991,    719,   -353,   -163,
      -750,   2685,   2837,   -558,    129,   2076,    -47,    641,
       -37,    -93,    226,    -69,    598,   -284,    127,    106,
      -426,   -555,   -947,    485,     54,  -3175,    622,   -341,
      -544,    278,   -205,   -689,    391,    238,      9,    152,
      -233,   -392,     28,     36,   -394,  -1059,    132,   3761,
      -480,     87,   -656,   1304,    478,   -272,     65,   -147,
        91,    520,   -896,    166,     62,    -30,    -28,    194,
       542,      3,    625,   1795,   3613,   1097,   1030,    906,
       400,    133,   -127,    219,    958,     93,   -546,   -702,
      2937,   -524,   -270,   -767,   -192,    725,   -897,   -643,
      2502,    141,  -1147,    257,    279,    470,  -3001,   -104,
        79,    508,    450,    265,    -21,    -74,   -437,    647,
     -2755,   -407,   -816,    620,     24,    537,   -668,    604,
};

static const int16_t cb1110ss0[] = {
     -8187,     90,   -694,   -168,   -452,     -4,   -259,   -332,
       352,   -554,     43,    389,    236,    508,   -175,    461,
      -277,    118,    651,   -245,    696,  -1423,    368,  -1417,
      1782,   1650,   -540,     27,   -461,    516,   -599,   -185,
       422,    -11,   -181,     19,   1809,  -3226,   -839,   -191,
       468,    180,   -550,    198,   2487,   -923,  -1335,  -1008,
      1029,   1716,    588,    371,    902,  -1214,    179,   1026,
      1560,   1815,  -1714,   1230,   -712,   1675,   1867,   -154,
     -2860,   -484,   2289,  -1018,     33,  -1494,    614,  -2340,
      -724,  -1088,  -1930,   -775,   -876,    642,  -1358,   -144,
     -2518,     62,    543,  -1049,  -1081,    672,   1305,  -1506,
       -86,   2920,    518,  -1836,   -546,   -132,    -45,   -642,
       381,   -404,  -2206,  -1211,    698,   -703,   -667,   -606,
      -677,  -2246,    526,  -1157,    177,    510,  -1420,   -617,
     -1819,   1710,   1631,   1049,  -1697,   -495,    961,  -1250,
        39,    482,    445,   -956,    -71,    977,    426,   1826,
       286,     36,    295,   1786,    794,  -3456,   1645,   -766,
     -1580,  -2435,   1108,   -286,    731,   -659,    960,  -1759,
      -978,    316,   -350,     91,    -35,   -222,  -1417,    -53,
      -529,   -679,    681,  -4700,   -524,    -39,   -350,    196,
       199,    191,    653,   1344,   -942,   -428,    156,    173,
       636,  -1538,   1795,   1709,   -190,   1265,    164,    650,
      2302,  -1757,   1762,    413,   -851,     44,  -1371,    343,
     -3845,   -122,   1864,   -489,    601,   -748,   -402,    590,
      -124,  -1988,  -1536,   -999,    399,   -753,    295,   -384,
     -1316,     55,   -669,    262,  -1157,  -3766,    992,   -111,
     -2928,  -1424,    -98,    -62,   -334,  -1848,    377,   1560,
       947,   1568,   1554,    206,    664,   2014,   2098,   -164,
      -640,  -2897,   -647,  -1675,  -2307,   -254,   -555,  -2426,
      1497,    465,  -1525,  -1148,     55,    632,    554,   2068,
       451,  -1532,   -715,  -2065,  -1177,   -623,    478,    -88,
     -1140,    -72,   -450,   -248,  -1111,   -250,   1356,   2717,
     -1841,    420,  -1299,  -1715,    746,   -101,    600,   1130,
      -903,   -473,   1225,   -876,    193,    694,   -193,   -482,
     -1838,     94,    157,   1131,    267,   -242,   2021,    -39,
       795,   -285,    438,  -4322,   1097,   -621,   -518,   -338,
      -289,   -114,   -671,   1700,   -477,    449,  -1664,   -693,
      1403,  -3629,   1480,   -991,   -234,   -213,    354,   -269,
     -1140,    -40,   1455,   -758,   1273,    497,   -686,   -945,
        59,    -66,   -769,  -2930,   2343,   2452,  -1576,    995,
      -734,   1009,     98,   -350,  -1116,    545,    189,     99,
       566,   -916,     20,    117,   -807,    986,   -428,    177,
      1247,    485,   -680,   1139,  -1263,   -256,   4828,     89,
        27,  -1339,  -1091,    149,   -641,   -703,   -570,   -112,
       346,    -93,   -641,    -97,   -991,  -2247,   2284,    847,
      2110,  -1393,   -315,  -1468,    514,  -1493,    -46,   1135,
     -1231,     39,   -913,   -278,   -762,   1775,   -684,    735,
     -1676,    386,  -2030,   2534,  -2371,  -1661,   1204,   -111,
        -8,   -607,   1233,  -1532,  -1263,   1530,   -537,  -1728,
      -335,    269,   -614,     12,  -1187,   -770,    471,    373,
      4743,     12,    197,    610,   -101,    417,   -350,    551,
       544,   -898,    387,   -682,  -1216,    126,     96,     94,
      -268,    535,    126,   -778,   1595,  -1379,   3366,     49,
       460,   1772,    198,   -896,     75,    253,  -1376,     68,
       838,  -1121,   -578,   -630,   -718,   -975,   -565,   1303,
       354,   -769,    -38,   -246,   -193,   -408,     41,    165,
       374,    -87,   -155,     -8,   -746,   -430,   -869,  -1842,
      -385,    281,   5119,    432,   1119,   -807,   1756,    816,
       131,   -548,   -528,   1347,    478,   1482,   2942,   -290,
       650,   1012,    163,    840,   -804,     94,   2507,   1514,
      -953,   -289,     23,   1128,   -895,  -1009,   1871,   -370,
       699,    659,  -3069,   -695,  -1559,   1435,    672,     94,
      1496,   -637,  -2208,   1083,    688,    485,    251,   -828,
      1313,    -21,  -1948,    230,   -603,    783,   -829,    524,
     -1142,  -3845,  -1383,    323,   1295,    732,    759,    591,
        68,  -1869,   -756,   1727,    339,  -1565,   -510,   2623,
       358,   3071,    281,   -790,   1129,    243,   -588,   -431,
       492,    372,     96,    890,   -935,   -727,   -236,   -416,
       171,    226,  -1090,   1257,  -1063,   -303,   -817,  -1506,
      -947,   2282,   -659,   -406,     79,    772,   -816,  -2610,
     -1802,  -1019,   -816,  -1886,  -1306,   1365,    624,  -2314,
       -57,   1012,    215,   -130,   3404,   -864,    959,    202,
       -26,  -1015,  -1212,    -34,   -408,   3494,   -284,    845,
       275,  -1005,    458,    840,  -2258,    -13,   -129,   2536,
      1269,   1216,   2071,   -243,    624,    584,   2192,    720,
       604,  -1397,    766,    984,  -1050,    157,   -246,    438,
       240,   -587,   1251,   -649,    -22,     33,   5818,    608,
      -996,    474,   -523,   -454,   1252,   -791,    631,   -465,
       663,    452,   1793,    853,     39,   3732,    758,  -1329,
        11,   2217,   -136,   -540,   1335,     65,  -2047,    943,
       701,   1886,   2085,   -890,    -16,   -184,    325,  -1077,
      -271,  -1246,    391,  -1686,   -651,    -77,    319,    292,
      -160,   1204,   1093,    776,   -310,   1512,  -1196,    149,
        46,    593,   1738,   -566,     97,  -3667,   -485,   -683,
      -121,   -216,   -149,   -344,    406,   -989,   -311,    383,
       979,   -828,    394,    -22,  -5143,  -1368,    -18,   -433,
       359,    607,    996,  -1144,   -229,   1365,  -1243,    413,
      -591,   -621,    803,   1356,   -625,   1149,   -234,    182,
     -1285,  -2487,    359,   2640,  -1426,    -66,   -688,    237,
      1307,   -361,    108,    207,   1026,   -500,  -1156,  -1043,
     -2192,  -2232,   1790,   1135,   1742,   1494,  -1156,   -698,
      2520,  -2596,   -620,    431,    748,     88,    912,    832,
      1122,   -483,   1837,   1821,   -826,   1112,   -424,   -306,
      -750,   1085,    260,    152,   -114,  -1065,  -4518,   -300,
      -976,    143,   1452,   1395,   1677,     59,    -51,  -1072,
       868,   -171,    -26,   -914,   -109,  -2420,    -48,     69,
      -230,    630,   -522,   2274,   1265,  -1612,   2570,    836,
     -2042,  -1922,   2970,    775,   -320,  -2486,  -2935,    553,
       178,    994,  -1054,  -1321,    699,    749,   1002,    513,
       586,   1550,     35,    654,   -995,   1743,  -1049,   -405,
     -3431,   1943,    700,    555,    111,    -67,   1007,    111,
       -57,    661,    404,   -628,    425,   2185,    860,   -516,
      -523,    452,    238,  -1778,   -378,   -721,  -2197,    218,
       864,  -1031,   -832,    135,  -2543,   -447,    789,   1117,
     -1491,    120,   1294,   -702,    627,   -412,   -902,    404,
     -1843,   -786,   -597,    900,   1963,     22,   -843,   1168,
     -1045,   -797,    764,   -423,    329,   2308,  -1950,    331,
     -1090,  -2466,   -483,   2023,  -3363,   2126,    495,   2812,
      1922,  -1488,  -1041,   -798,    135,    408,     33,    563,
      1333,    -36,  -2181,   -787,    709,    287,   -971,     93,
      -459,   -975,   2412,    280,   2555,     32,   2217,  -1825,
       650,    313,    585,   -947,   1170,     45,   1108,   -435,
      1092,    220,   -155,    512,    460,    211,   -231,   -627,
      -836,  -2205,   -181,   -113,    130,    226,   -321,   -765,
     -1327,  -1190,   -676,   -357,    691,    232,   -365,  -1818,
     -3007,   2210,    997,    601,   2156,   -782,   1626,  -1081,
       -49,   -616,    685,    -12,     40,   3480,    563,    515,
       245,     51,    290,   1227,    171,  -1078,    520,   -483,
       280,  -1517,  -1331,   2132,  -1176,  -1381,  -1546,   1436,
      -852,   -505,    672,   -807,    623,   -244,   -125,  -1958,
       516,    798,   1185,    922,    441,    651,   -610,  -1430,
     -1887,    114,   -869,  -2024,  -1627,  -2276,   2008,  -1224,
       125,   -609,    371,  -1104,   -506,   -942,   -624,   -478,
       197,    141,   -242,  -1051,   1532,  -1269,    666,  -1055,
      1689,    444,   1720,     16,    301,  -2311,   1196,   1108,
      1298,   -564,  -1197,  -1858,    439,   -198,    324,  -1884,
      3193,   2281,    201,    587,  -2028,   1969,  -1087,   -352,
       -87,   -632,    144,    165,     68,   1150,    173,    478,
      -837,   -470,   -464,   -195,   -205,   2111,     15,    643,
      -453,   -339,  -1128,  -1368,   1182,    822,    654,  -2331,
     -1668,   -215,   -678,  -2460,   1169,   -664,    777,   -348,
      2570,   -767,   -563,    254,    562,   -557,      4,    -97,
      1990,    373,   -780,   -677,   1996,  -1527,   -365,   -416,
      -325,    587,    910,  -3780,   -553,    104,   1705,    240,
      -719,  -1717,   2765,   -582,    -76,    399,  -1152,   2379,
      3169,  -1153,   -725,    -35,  -1214,    362,   1600,   -724,
       424,   -722,    472,    872,    694,   -126,  -1649,  -1314,
     -1814,    -95,   -312,    -34,    780,   -884,    824,   -864,
       526,   -100,   3820,    -56,   -452,     43,    564,    487,
       177,    890,  -1423,    894,   -552,   1438,    204,   1015,
        -4,    327,  -3327,   -433,   -335,   -869,   1312,   -488,
     -1287,   -169,   2018,    435,     73,    508,   1160,  -1060,
      -134,  -1304,   -341,    623,    125,    -15,  -1120,    108,
       -71,  -1487,   -189,  -3640,   1424,   1740,   1116,    579,
      1603,  -3294,   1241,   -225,   1481,   2775,   1326,   -242,
      -632,  -1560,    563,    559,    138,    115,   -557,   2004,
     -1771,    717,  -1052,  -1115,  -1634,    889,   -441,   1954,
      -164,  -1507,  -1312,   -407,    662,   -867,   -896,    225,
      2576,   -224,   -107,    237,   -694,    859,    192,  -1033,
      2255,  -1225,   -891,  -1994,    -90,    339,   -382,   -774,
      1460,  -1553,    648,   -521,   2370,    160,    714,     54,
      -906,   1435,  -1752,   -274,   -523,    -36,   1208,   1553,
      -339,   1000,   -178,    209,  -1001,    916,    495,    310,
       726,    127,   -391,    107,   -513,  -1052,   -376,    297,
      -307,    933,   -233,   -253,   1196,   4619,  -1278,    762,
       -13,   -387,   -973,   2153,     68,    362,   -887,  -1922,
      -106,    298,  -1127,  -2601,  -2184,   -111,    111,  -1588,
      1002,   -365,  -2226,   -290,   -599,    610,    551,  -1368,
     -4344,    618,   -172,    349,   -914,   -530,   -192,    718,
       348,   -675,   -884,    913,    -94,    215,   -834,    353,
       753,   -811,    -84,   -905,   -128,   -483,  -1782,  -1255,
     -2333,  -1110,    477,   -566,    346,   2018,  -1644,   -325,
      1365,  -1223,    158,  -1786,    566,    203,    742,    281,
      -555,    573,   -978,   -459,  -1671,    378,   -689,    349,
       606,  -5961,    562,    -13,   -223,   -419,   -442,   -447,
       125,  -1052,     53,   2594,  -1377,    209,  -1549,    533,
      -118,  -2538,   1808,   -364,    -37,   1221,    607,    593,
       309,   -240,   1574,    254,    434,   -141,   -220,  -2018,
};

static const int16_t cb1110ss1[] = {
       631,   3041,   1215,   2376,  -1843,   -103,    750,    144,
       -87,   -249,    715,   -201,    758,    202,   -197,   -135,
      -523,   1243,    457,   -717,   -700,   1662,    918,    -48,
     -1008,    180,    411,    948,   2192,   2607,   -826,   -962,
     -1130,    -59,  -1047,   -305,   -325,  -1032,   2096,   -287,
       395,  -1543,   -268,  -1218,  -2045,  -1674,    951,  -1846,
      -636,    263,   -138,   -287,   -327,  -2208,   -664,    496,
      2179,   1645,    340,   -601,    473,    670,    950,   2774,
       364,    613,  -1896,  -1876,  -3177,   -105,    506,   -164,
       281,    718,   2419,  -1077,    -50,    365,  -1631,   -134,
      -384,    231,    767,   -285,   1268,    321,  -1408,    217,
      -409,   -725,   1225,  -2551,  -2622,   -274,    473,   2752,
       -11,    342,   -495,   1627,     79,    240,      2,  -1021,
       640,   -508,   -269,    648,   -116,  -1283,   -217,     13,
     -1674,   2402,   -879,   1791,   2753,   2386,   1195,   -700,
      -282,   -428,   -671,    -92,   1187,   -672,   1037,  -1913,
       246,   -816,    -69,  -2284,   -712,   -996,   2498,    902,
       809,   -149,     66,    775,    -44,   -566,    955,  -1073,
     -1438,   -894,   -978,    274,   -390,   5528,   1153,     17,
      -750,     63,    545,   -725,   -301,   -323,    661,   -813,
      -347,    739,    335,    136,    203,    342,    802,   -199,
      -818,   -679,   -282,   2195,  -1714,   -757,   -154,    182,
       132,  -1737,    405,   2394,  -3727,   1349,    213,   -193,
     -2495,  -1354,   -629,  -1171,   1429,    -16,    834,  -1260,
       160,  -1892,    874,   1754,   -567,    344,  -3499,   1612,
      -987,   -424,   -997,  -1640,    594,   1058,   -783,    511,
      -604,  -1480,  -1754,   -424,   2262,  -1991,   1297,   -638,
       350,   -588,    -55,   1483,   -456,   -567,    146,   -946,
       731,   1541,   -759,    592,   1231,   -270,    171,  -1975,
     -2707,   -456,   -227,    392,   -891,   1008,  -1066,   -487,
       231,   1372,    -51,   -599,   -227,    696,   -820,    354,
      1928,    -48,  -1302,   -570,    316,   -283,   -848,   2563,
      -266,   2821,    540,    553,  -1272,   1120,  -1164,   -451,
       384,  -1058,  -1018,   1735,    992,  -1220,    -83,   1490,
      2304,    122,   1630,   1108,   1997,   2346,   -647,    301,
     -1746,   -218,    313,    462,   1486,   -536,   -508,   -463,
       104,    930,    605,   2116,    793,   2881,   -724,  -1379,
       -53,   4458,    793,    275,   -180,   -516,   -489,   -774,
      -265,    704,    112,    175,    112,   -121,    652,    310,
       564,   -440,    773,   1885,    927,   -672,   -773,   1726,
      -614,    818,   1589,   -372,   -207,    499,   -894,    987,
       796,    652,  -1228,  -4010,  -2208,    458,    645,    498,
      -279,   -852,  -1897,  -1820,    -35,    674,    201,    474,
        77,     94,   2327,    723,  -1081,    261,    209,   1179,
     -1175,    623,  -1293,   2154,   -117,  -3707,    940,    813,
     -1059,   -335,   1306,    525,   -191,  -2066,   -425,     19,
      -366,    529,   -145,    822,   -913,    254,    424,   -354,
      -167,  -2437,  -1433,    603,   -318,  -1517,   4250,    541,
     -1360,    450,   -531,    200,    534,   1200,   -222,   -535,
      -162,  -1211,   -116,   -144,   -462,   -139,   -482,    511,
      2068,  -2100,    971,  -1487,  -1050,  -3150,   -701,    119,
        16,   1535,    272,  -1184,   2242,    488,   -492,   -915,
      1660,    212,   -826,   -444,   1003,   2705,   3591,   -174,
      -333,   -431,    -59,   -903,     61,    751,   1087,    -45,
     -1031,    617,    686,    -15,    848,   -348,    947,    396,
       931,   1785,   -552,   -920,   -669,    -63,  -1869,   2357,
     -1549,    807,    889,  -1581,  -1071,   1587,  -1108,   1300,
      -658,   -625,    300,   -285,   -977,   1656,   4183,   1487,
      -191,    658,   -300,    497,   1378,   -300,   1031,    322,
       114,   -449,    666,   1250,    264,    125,   -109,    748,
      -503,    -40,    199,  -1212,  -1643,  -2522,    151,    121,
     -1128,  -3200,    876,   -446,    878,   -989,   1510,   2261,
     -1507,   1793,   -402,     30,    228,    -50,    985,  -1568,
       755,   1559,   -688,   1342,   -423,  -1507,     96,   -501,
       474,  -2926,  -2493,   -131,   -656,    450,   1035,    812,
       -14,   -933,    941,   1396,   -957,   -621,   -516,    379,
      -225,  -2063,  -2048,    669,    287,   1688,   1727,    299,
      -658,    852,    745,   -260,    993,    158,  -1236,  -1422,
        33,    611,   -112,   -323,   -194,    839,  -1407,  -1505,
     -2010,   1267,   -355,   -675,  -3779,    768,   -228,   -643,
       661,   1313,   -529,    962,   -948,   -212,   1043,   1560,
      -174,   1744,   -938,    289,   1942,  -2228,  -1932,   1056,
      -590,   -940,    922,    601,   -853,   -791,   -637,     -2,
       -52,    -83,   -209,   1422,    856,  -1141,   2500,  -1195,
       773,   1087,  -1389,    409,    439,  -3674,    453,   1637,
       -15,   1013,   2635,   1530,  -1104,    440,    895,   -210,
      1118,     -6,     45,     65,  -1110,  -3307,   -331,    478,
      -155,   -410,   -721,  -1234,    129,   -971,  -1117,    -27,
     -1132,  -1289,   1888,  -1112,    203,  -1091,    442,  -2207,
       501,   -343,    468,    -52,    385,    269,  -3102,   -366,
      -469,    391,    505,    176,    356,    -69,   -929,   1155,
      -280,  -1264,   -897,   1006,   -494,    155,     36,   -627,
       924,   -816,    154,   -750,   -837,   5263,  -1099,     91,
      -481,     71,   -681,   -574,   1229,    675,   1217,   1073,
      -695,    274,   -381,   -140,   1372,   -524,   1164,    341,
      -149,   -856,    793,  -1294,    981,   -961,    371,   1178,
      1463,    373,   1375,  -4384,    239,    136,     67,  -1196,
      -126,  -1001,   -228,    150,    437,  -1830,    477,    498,
      4246,    793,   -661,    260,  -1810,   1405,     76,    902,
      -844,    908,   1830,     27,   -124,    257,    765,    -98,
       592,    487,   -132,    202,    675,   -669,   -679,   1309,
     -4002,   -206,    -66,   -390,   -253,   -190,   -921,    -83,
      1411,   -417,  -2560,   -646,   1853,   -148,    548,   -370,
      -723,    959,   -906,  -3058,   -276,    467,  -1280,    970,
       687,    484,    506,   1143,  -1509,    828,  -2169,   2931,
      1322,   -579,   1033,    209,   -979,    217,   -434,  -1438,
       314,   2384,   -906,    -29,  -1478,    -31,    574,   -373,
      1478,   -124,   -680,    330,    794,   -753,   -977,   1151,
     -1190,  -1479,   -642,   1658,  -2201,  -1469,   1589,    587,
        52,   1298,   2092,  -1483,    678,   1988,    918,   -648,
       328,   2096,  -1090,   2153,  -1416,    295,    537,    261,
       398,  -1389,   -399,   1105,     10,   -395,   1169,   -431,
      -423,  -1617,    766,  -1900,  -3205,    131,   -746,   -852,
      2215,   -317,   -232,   1079,    293,   -727,     50,   -446,
      -713,   -897,    768,   -896,   -667,   -281,    377,    115,
      1695,  -4870,    713,   -393,    251,   1268,    477,   -497,
       294,     18,   -359,    556,    308,   -752,   -863,   -216,
       151,   -163,    695,    587,    810,   2107,   -107,    921,
      1203,   -472,   1280,    372,    110,   -581,   -225,   -714,
       -58,  -2587,  -1980,   -186,   -372,  -1410,  -1504,  -1020,
      -745,    -88,   2373,   -568,  -2841,  -2041,  -1841,   2065,
       389,   -430,   1163,   -208,    569,    375,    650,    317,
      1114,  -1036,   -959,   -896,   1060,   1014,   -599,  -1743,
      1121,    808,   1556,    326,  -2876,  -1556,  -1283,    384,
     -1102,    378,   1433,    702,   1454,  -1243,   -725,    224,
      -610,   -455,   1413,  -1747,  -2516,   -572,  -1455,   -313,
       231,    780,   1531,  -2475,    -34,    921,  -1650,    269,
       818,      5,    835,   -209,   -911,   -432,  -1104,    165,
     -1638,    -46,  -2031,   -445,   1308,   1519,  -1992,   1606,
       956,    757,   1139,    116,    829,  -1376,    209,   -893,
       963,   -569,   -466,   -185,  -1345,   1524,   1714,    269,
       219,   -161,    482,  -1178,  -3621,   -831,   -668,   1871,
      -529,   -983,    558,   -818,     81,    555,     33,   -473,
      -187,    113,    899,   -577,  -1093,   1408,    902,   -258,
      -111,   -648,   4340,   -780,   -651,    789,    -92,   2310,
      -401,    669,   -213,    369,   -104,   -820,   -290,     48,
      -917,     71,   1070,   -239,   -744,    891,     23,  -5130,
      -761,    312,    319,    842,    280,     78,   -149,    352,
      -594,   -361,    354,   -906,     42,  -1610,    835,    157,
      -631,   1100,   -297,   1081,    -96,    484,   -825,  -2132,
       549,   1305,    128,   -314,  -1733,   -265,   1285,  -4061,
      -348,   -136,   -940,   -507,   -232,  -1511,   -876,     78,
      2120,    175,   2216,   1179,    497,    335,    350,    -18,
     -1307,   -387,  -2207,    587,   3209,   -370,   1155,   1501,
     -1687,   -796,  -1417,   -733,   -269,    801,     83,   1173,
       718,  -2702,     19,   -315,   4501,   1025,   -365,    348,
      -417,   -510,   -172,  -1201,   1478,    671,   1933,   1759,
       676,    416,     30,    400,    531,    351,  -1176,  -2807,
      1969,  -1398,   1159,   -568,    754,   -149,  -1880,   -274,
     -1203,    -43,   1391,    383,    702,   2116,   1299,   1952,
       646,   -719,   1735,   -986,    100,   -956,   1040,   2287,
     -1606,    612,   1760,    733,  -2453,    531,    -14,     -1,
     -3214,  -1993,    371,    227,     45,   2011,   -531,   1089,
     -1029,    282,  -2426,   -525,    989,   -469,    285,   1787,
       927,   -335,   1127,   -305,   1143,   -412,  -1626,   1759,
     -2567,    -82,   1170,  -3051,   1266,   1522,   -124,  -1935,
       552,   1122,    -51,    347,   -674,   -360,   1183,    223,
      3015,    955,   -826,   1108,   2325,    868,   1152,   1079,
       223,    217,   -428,    382,    642,  -2849,   -767,    -70,
       407,    147,   -392,   -407,    -55,   -508,   1785,   -683,
      -885,    851,   3879,    471,   -674,   -231,   1493,   1621,
     -1698,    528,    623,    300,   1367,   -588,    816,    -24,
       600,   -182,   -841,    854,    370,    715,    116,    714,
     -1308,   1435,   1802,  -2627,   -814,    363,   -318,    -73,
       850,  -1744,   2509,   -303,   1077,    660,   2145,   2130,
      -730,    -88,   -115,   -517,   -154,    160,   -337,     27,
      1502,    509,    -70,    502,    820,   -309,  -3740,  -1294,
      -610,    241,   -662,   -524,   1319,    456,    926,    958,
      -111,  -1004,   1795,   -604,   1086,    462,   -127,   -125,
       264,  -1093,   1427,    334,    838,   1979,   -576,   3052,
     -3590,   1607,    356,    728,   1619,   -400,    279,    570,
      -434,    777,  -1448,   -888,    156,   -277,  -1529,   1122,
      2235,   -794,   3417,   -830,    -82,   -664,  -1837,    946,
      -370,   1434,    -50,    742,  -2368,   1438,   1264,   1172,
     -1338,   -108,   -226,   -958,  -2130,     -2,    917,    896,
      1563,   2181,   2684,   2343,    237,   -407,  -2685,   1447,
      1028,   -728,    109,   -620,    478,     46,   -542,   -789,
      -879,   -438,   1244,   1075,  -1730,    119,   -694,    137,
};

static const int16_t cb1110sm0[] = {
       916,   -269,    -44,    343,    623,  -2512,   -171,  -1904,
      1001,   2776,    226,   1487,    705,    763,   -616,    288,
      -212,   -535,   3080,   -352,   -367,    512,   -673,    620,
      -874,    769,   -956,    460,   -601,  -2793,   -102,   -765,
      -431,  -1369,    149,    481,    -49,    109,   -412,    670,
      -615,    287,    150,    321,  -3293,   -237,  -1627,    188,
      1867,   1481,    353,   -134,   2706,    147,     74,    -77,
      -148,   -224,    196,    -60,    179,    125,    -13,   1011,
      -189,   -172,    658,   4441,   -540,    531,    239,   -329,
      2782,    392,     97,   -660,   3488,    -78,   1308,   -574,
      -903,   -170,   -279,    173,    -70,    601,   -385,    123,
      -423,   -512,   -193,   -233,    106,    175,    210,    185,
       489,   -236,    153,   -670,     25,     61,   -196,    213,
        67,    339,   5443,    116,   -647,    149,   -130,    197,
       -11,    305,   2669,   1212,    298,     84,    219,    -26,
      2661,    650,   1348,    -65,    574,  -1482,   -268,    -30,
       626,    328,    279,   -245,     87,     94,   -202,      2,
       366,   -505,   -592,      2,   5666,    384,     22,    227,
       208,  -1221,     78,    155,    260,  -1111,    165,    396,
      -678,   -739,   2503,  -2395,   2025,   1424,   -343,   -759,
      -837,    101,     55,    274,   -481,     22,   -568,   1044,
      -271,   -124,   -609,   -833,   -206,     53,   -591,   1150,
     -1950,  -2875,   1949,     59,   -334,  -3230,    176,   1133,
      -372,   2937,   -803,   -663,    631,   -659,    -32,    -82,
       851,    113,    -60,   -625,    556,    177,    112,   -753,
       -33,    313,    -33,   -208,   -177,  -5496,     55,   -533,
      -815,    123,   -755,   -215,    638,    223,   -156,   -917,
      -166,    -33,    504,    704,  -3001,    124,   -153,  -1809,
      -977,   -717,   1718,    476,    212,   1661,    953,  -1422,
     -1014,    -94,   -524,  -2562,   -267,    371,    104,    -63,
      -546,    262,    193,  -1714,    261,   1867,    738,  -1878,
       400,   1754,   -445,   -405,   -841,   -439,    709,     44,
       675,    248,    640,   -138,   1217,    393,  -1402,    653,
      3110,   -938,  -2491,   -688,   1214,   -649,  -1356,   2506,
       203,    172,    679,   1003,    772,  -3010,     82,   -998,
      1011,   -980,    -28,   -138,   -430,    614,    427,   -341,
       201,  -8082,   -118,    224,  -1167,    195,   -920,   -352,
      -657,      5,     46,    -39,    -72,    698,   -136,    -40,
       391,    287,    157,  -1197,    -60,   2808,   -123,    489,
       152,   2318,   -805,    958,     98,  -1496,   -835,   -846,
       589,    455,   -868,    245,    -10,  -5047,     12,    -50,
      1277,    -95,    456,    -49,    570,    608,   -658,   -352,
      -277,   -268,    214,    388,   1865,      2,   3033,   -269,
       259,    -75,  -3437,    800,   -190,    668,   -263,   -111,
       229,    -43,   -139,    659,   -290,    782,    -18,   -854,
       271,  -2223,     30,   -162,     71,     47,    756,  -1269,
       336,    863,  -1998,    -16,   1172,    236,    929,   -477,
     -2446,    -92,   -425,   -193,  -8192,    321,   -102,     85,
       -85,    108,    318,    149,    -27,   -182,     69,   -237,
        35,    451,   -263,   -890,   -348,   -295,     64,    410,
      6427,    569,    604,    543,     38,     31,    -15,    148,
       249,    -83,    -67,    457,    -76,   -560,    694,   -797,
       190,   -113,   2006,    136,   1705,   -428,   3549,   -550,
        70,     -3,   -147,   -288,   1142,   -919,    493,  -1305,
      -460,   -151,    831,    623,   -768,   -211,     31,   -296,
       167,  -2721,    -16,   -654,    243,   2555,   -311,   1845,
      -531,   -576,    143,   -574,    490,  -1089,  -2302,   1080,
       701,    472,   2782,    320,  -1455,   -632,   -218,    281,
     -1492,   -661,  -1379,   -538,   -236,  -1928,   -502,   -565,
      -480,    525,    -81,     38,    263,      3,    366,    163,
     -3140,    882,    189,   1123,    382,  -1748,  -1210,    371,
      -602,    696,   -413,   -207,    358,   -616,   4725,   -473,
      -784,    249,    621,    764,   -265,  -1004,   -570,    339,
      -643,   -123,    302,    284,      1,   -159,   -321,    250,
      -297,    -43,  -3512,  -1064,   -493,    556,  -1184,   -263,
      1314,   2028,   1074,      9,   2941,   -998,   -271,    966,
      -754,  -2589,     88,    741,   -307,    134,    152,    -86,
       311,    904,   -917,   1199,  -5090,    118,    181,   -311,
      -412,    475,   -647,   -717,   -637,   -221,   -291,   -469,
        77,    946,  -1196,   -119,   -175,    530,   -465,    383,
     -1253,    589,    826,    835,  -3578,   -319,    -80,    488,
      -238,   -497,    360,    839,   1870,    762,  -1669,   -769,
       429,    778,  -3121,   -325,    -55,   -128,   2606,   -874,
      1043,   -902,   1746,   -725,    115,    167,    142,    604,
      -101,   -725,    -11,   -458,    -27,    450,    293,      2,
      -383,     23,    172,  -6725,    400,   -205,    165,     45,
       -38,     86,    372,    354,    -68,    390,   2444,    521,
         4,  -3586,    357,    129,    665,   -328,    524,    113,
      -446,   -514,   1132,    289,   -560,    239,    167,   -349,
      -724,    101,  -3165,  -3139,   -163,   -147,    865,   -617,
         0,   -789,    797,  -1026,    432,    359,   -460,   -105,
      1119,    486,   -233,   -360,   -175,   -349,    837,    469,
      -250,   -521,  -4470,   -108,   1009,   -575,    283,     22,
      -555,   -682,   -234,   -249,    -33,   -106,    521,    515,
      -283,    -78,    101,   -135,   -648,    506,    181,    392,
      -517,   5405,    442,   -106,  -8168,     51,   -310,   -813,
        49,   -314,    586,   -479,    376,    113,    337,   -151,
       245,    270,     -1,    619,   -312,    -37,   -215,   -482,
     -3055,  -3261,   -346,   -493,   -357,    306,   -160,    -21,
       258,    872,   -577,   -141,     18,    -84,    693,    151,
       218,   -533,    -37,    540,     61,     40,   3150,    157,
     -2549,   -324,    267,   -456,  -1236,    798,    517,   -224,
      -196,    587,   -495,     18,    258,   3147,    -15,   -568,
       957,   -444,    637,   -354,    828,   1182,   -769,   -137,
     -2130,    408,  -1667,    252,    282,    201,    239,    154,
       125,  -7882,   -332,    198,    -47,    265,   -289,    358,
        -4,    103,   -795,    207,     82,    229,    429,    361,
       263,   -409,   -451,  -1036,  -3419,    899,   -568,  -1480,
       898,    284,    -53,    179,    975,  -1283,    759,   -150,
      3244,    408,   2579,   -418,   -117,    226,    583,    210,
       -62,  -1513,   -148,   -820,   1073,   1290,   -263,   -454,
       653,    555,    286,    218,   -105,   -135,    231,   -892,
      -284,   2513,   2715,  -1530,   -165,  -1419,   -223,    -66,
       525,   1556,    -18,   -664,    -19,    856,    179,    535,
      -339,   -245,    498,    193,    235,    328,   -491,    231,
     -5629,     65,    -85,    313,   -395,      6,    344,    267,
       672,   -991,    178,  -1335,    -64,      9,  -1508,    -69,
        57,   -310,  -1793,   -850,  -3669,    427,    -79,   -720,
       219,    366,    131,    523,    141,  -1055,    -66,     13,
      -843,    -55,   -794,    661,    112,   -407,   -496,    550,
       931,  -3938,   1780,   -509,   -543,   -157,   -270,  -1015,
       564,   -231,   -854,  -3372,   -327,    869,   -196,   -981,
      -205,   -215,    605,    746,  -2188,   2250,     74,  -2979,
      -242,    832,   -190,    365,  -1327,    453,     95,     76,
       158,   -683,    628,    297,   -867,   -542,   -143,   -568,
      -414,   6018,    -40,    -35,   -456,   -632,   -779,   -226,
      -442,   -295,    310,   -766,    578,   -197,     84,   -961,
     -3346,   -106,   3266,     -3,   -477,     -8,    652,    122,
      -606,     49,     34,    686,    385,   -258,    214,   -572,
       -72,   -193,    124,    440,     48,     45,     75,      9,
     -7724,    200,   -364,    578,    318,   -461,     84,   -233,
        46,   -404,    185,    470,  -3387,  -3397,    374,   -519,
      -320,   -378,     27,    921,   -280,    188,   -245,    -69,
      -322,    504,    -72,    460,    -80,    -35,   -220,  -3098,
     -3678,    477,    248,   -801,    580,    187,    468,   -636,
      -364,   -432,    183,    -82,    -79,    266,   -787,   -740,
       552,    228,    238,    482,  -2229,    275,    149,   -360,
      -350,   2774,    871,   -118,     55,   -961,   -165,   2429,
       982,    313,   -502,   3094,   -431,   3485,    473,   -347,
       171,    544,    253,   -324,    -50,    464,    116,    650,
      1102,    495,    420,   -404,     -1,  -2991,   4055,    207,
       374,   -187,   -121,    130,   -451,   -953,    822,    526,
       287,    120,   -979,    376,    594,    -79,   -130,   -362,
      -979,    166,    693,  -4108,     84,   -135,   -195,   -703,
     -1506,  -1098,   -611,    870,    935,   -156,    974,    286,
       -86,     83,   2975,   -681,   3218,   -286,   -452,    -70,
      -113,   -395,    137,  -1295,   -503,    853,    297,   -352,
     -1004,   -117,    476,   -431,  -2848,     -7,   3601,    402,
      -534,    312,     86,   1524,   -358,   -164,    -43,    913,
      1003,    239,   -364,    -88,   -468,   -672,    220,   -211,
      -326,   -431,    438,   -297,    380,    125,   -146,   4550,
      -271,   -831,    768,  -1360,    -45,    266,   -278,   -246,
       625,   -132,    153,    514,    115,  -1311,    707,   -361,
      -601,  -3224,    376,  -2107,   -259,  -1155,    426,   -646,
};

static const int16_t cb1110sm1[] = {
       360,   3106,   -518,    185,   -906,   3245,    508,    -91,
       938,  -1270,   -492,     36,    168,   -997,   -208,    991,
        99,   1553,   -294,    204,    -22,   -108,  -2405,   2893,
        49,     72,   -490,   -529,   -218,   1343,   -786,    903,
       411,    207,    131,   -636,   -129,   -134,    621,   -253,
       319,    135,   -234,    -75,   -293,     46,    207,   5985,
       280,    -86,    -78,    690,    984,   -770,   -565,   -226,
      -242,    374,     26,   -696,     81,   -277,     -9,    639,
      -730,    250,   -232,   -488,   -284,    460,   -398,   4336,
      -303,   -266,    546,   -292,   2936,     70,   2077,    373,
      -141,    292,   2102,    340,   -312,   -523,   -341,   1017,
       457,    224,    315,    271,   1080,    152,    192,    568,
      1014,    155,     85,    329,  -5235,    137,   -503,    141,
       275,     -7,    752,    282,   -267,    321,   -735,    746,
       489,    450,    478,    432,   -152,    451,  -1192,   1267,
      -341,   1136,    100,  -3538,  -1551,   1547,   -551,    294,
      -473,   -821,    -51,    718,   -655,    -11,   2817,    -26,
        73,   -459,  -1569,    181,    516,   -151,   2846,   -112,
       186,    714,   -228,   -210,   -451,    920,    -99,   -132,
     -2662,    589,   3040,    376,    662,   -834,    782,    542,
      1485,    538,   3531,    107,     47,     62,    398,    -11,
       -15,   -733,    471,   -231,    668,   -212,     38,   -536,
     -1905,   2769,   -149,   1623,  -3418,    237,     55,   -328,
      -770,    335,   2755,    340,     62,   -466,    267,   -946,
       427,    266,     80,   1134,     34,    949,    366,   -339,
      -112,      3,   -105,    442,   5117,    545,    -93,    611,
      -186,    566,    -39,   -172,    -59,  -1120,    388,    703,
       619,   -359,   -117,    -68,    569,    148,   -214,   -245,
       281,    617,  -2337,    -88,   -255,    124,   3292,    443,
       434,    -17,  -1157,   3090,   -205,   -245,   -983,    250,
     -1086,    643,   1392,    831,    733,    -59,  -1199,   1747,
      -415,   1073,    279,    428,   -512,  -3392,      0,     -6,
       526,    275,    -79,    477,    411,     85,   1485,    795,
      -209,    495,  -2628,    367,  -1734,    900,    301,    239,
       -53,  -2068,    403,   1333,  -1304,   -566,  -1420,   -771,
     -2300,    -15,    842,    342,  -2373,     61,  -1379,    303,
       733,   -108,   -316,     94,   -477,   -254,   -211,    807,
       273,   -792,    159,    -66,   -857,   1092,  -1001,    -69,
     -3770,    999,   2418,    854,    173,   2281,   -681,    485,
       578,    145,  -1245,    845,   -375,    219,   -259,    374,
       751,    226,  -1347,   -825,     66,    319,   -173,    191,
       445,    284,     62,  -8150,    -71,     53,    637,    -96,
       227,     75,     73,    -88,    654,    -24,   -466,    477,
       671,   -125,   -942,    104,    248,   -151,   -383,     11,
       322,    332,   4160,    108,   -301,    463,   -402,    352,
     -1799,    580,   1443,    396,    287,   -158,   -421,    340,
      -349,    109,     61,     47,  -2816,   -298,   -947,   -817,
       673,    189,     36,   4069,   -584,   -335,   2608,     10,
      -378,   -630,   -801,    228,    946,   -405,  -1186,    473,
       625,     -2,   -741,    523,   3747,    318,    733,    171,
       268,  -2554,    402,   -252,   -205,    292,   -351,     64,
       289,    801,    989,    435,   -100,   -163,  -1215,   -467,
       661,   -714,    165,   -228,   -637,   1357,   -498,    -52,
       488,  -3882,    130,  -1053,    796,   1040,    381,   -729,
       147,    803,    169,     46,   -157,    167,   -209,    126,
     -1016,     88,  -1018,   -458,   -527,   1259,    621,   3847,
      -525,   1247,     18,    253,    642,    340,   -705,    838,
     -2769,   -672,    153,    115,    453,    773,      9,  -2285,
      -291,      6,   -219,    628,    284,   -330,    568,   -240,
      -206,   -127,    273,    373,    367,   -494,   8192,   -595,
      -255,   -158,   -326,    -60,    513,    334,   -667,   -549,
      -110,      2,    573,   1086,   -610,   -368,    259,  -3611,
      -455,   1577,   -524,     11,    904,    390,    313,    707,
      2670,   -223,   2710,    593,    -25,    228,    540,    663,
       740,  -1108,    298,   1223,   -531,  -1978,    248,   -661,
      -341,   -910,  -2434,    111,    217,    748,    231,   -305,
      -419,   1873,   1094,   -936,  -1741,   1133,   1881,   -671,
        41,    268,  -1826,    466,    135,     37,   -200,   4623,
     -1212,   -969,    541,   1278,    652,   1061,   -759,   -747,
      -427,   -107,  -1329,   -583,   -255,    -67,   -311,    -10,
      -421,  -8192,    322,   -181,   -442,     76,    176,   -742,
      -175,    147,    385,   -275,    -87,   -704,   -545,   -315,
      -414,    569,     81,   -387,    628,   2954,   -604,  -1459,
       -29,   1693,    840,  -1024,    -66,   -317,    266,  -2465,
      -917,    -14,    151,   -369,    366,  -2388,      1,   -773,
      1333,    -99,    223,   -694,  -1169,    917,  -2496,  -1290,
      -286,  -1007,   -508,    734,    451,   -256,    266,   -105,
      -143,    439,   -120,   -146,   7690,   -183,    188,     68,
      -385,      7,   -278,    -24,    -66,    292,    137,    143,
        21,   -495,   -527,   -284,     89,  -1584,    -64,  -3664,
       286,  -2258,     80,   -932,   -771,   -338,   -830,  -1029,
       -99,    -32,   -800,    351,    -87,    600,    -93,    133,
       389,   -690,    269,    201,   -328,   5489,    558,   -702,
      -487,    210,   3107,  -3628,    -96,   -388,   -169,   -221,
       339,    403,   -816,    -24,    469,   -112,    560,    844,
      -441,    698,    169,   -378,   -283,   -924,   2842,   -479,
      -694,   -117,    -94,    523,    974,   1356,   -638,    590,
       820,   2164,    247,   -532,    648,   -243,   -599,    -67,
      5686,    174,     78,   -608,    230,   -172,    369,    342,
      -113,    111,   -345,   -311,    594,    350,   -260,  -1423,
      -425,   -407,  -1017,   -298,   -180,   -738,   -891,     66,
     -3312,  -1157,      1,    811,  -1431,    612,    797,  -1344,
      -890,   -959,    318,    392,   -190,    735,    196,   -347,
        61,   -116,    344,    243,   -411,   -446,     62,   -128,
     -3386,    476,   2695,   -193,    -39,   1960,     -7,    909,
      -118,  -2275,    -28,   -997,   -210,    374,   -586,    -82,
       914,    323,    -73,  -2743,    858,    -65,     43,  -2444,
      -246,    145,     78,   -638,    844,  -2079,    352,   -332,
       615,   -779,    270,   1799,    680,    500,    686,   1168,
      -397,  -2233,    -31,   -163,    -18,    602,   -232,   -915,
      -941,   3708,   -337,   -559,    315,   -401,     42,     26,
       316,   -100,   -191,     36,    206,    214,  -3336,   -407,
       494,    749,   -491,   -162,    -55,  -2902,  -1515,   -198,
      -311,   -359,    439,    359,   -935,    203,   -214,  -2401,
      -607,  -2843,    818,   -579,  -2066,    388,   -514,   -912,
       787,    564,    149,   -103,   -757,    389,    173,   -303,
       154,    814,   1631,   -393,  -2264,   1664,   -802,    904,
       541,    784,   1063,   1152,  -2510,    297,     84,   -154,
       160,   -497,    -78,   1503,   -598,   -543,     86,   1683,
      -330,     46,    -24,   -892,    747,  -3336,   -393,  -2268,
       107,    710,   1682,   -277,   -278,   -276,   1253,    327,
      -986,    802,    191,   -732,    286,   -761,   1008,    461,
      1615,  -1041,   2127,   2456,   3927,   -160,    187,     31,
      -101,   3258,    202,    -75,    330,    375,   -301,   -275,
      -782,    949,     12,   -621,   -617,    572,   1007,    414,
       -91,   -428,   -392,   -985,   -692,  -3422,    199,    845,
        91,    418,    290,   -983,    721,  -1265,    208,   1200,
        91,   -758,  -2649,   -451,   -814,   -623,   -458,    272,
      2777,    809,   1282,    763,   1122,     21,    520,     50,
     -1018,    428,    385,   6149,   -255,      8,    -12,     21,
        20,    293,   -315,   -446,   -423,    549,    428,    -56,
      -497,    101,    653,   -177,  -3975,     56,   -127,   3214,
       291,   -384,   -721,    478,   -314,   -231,   -469,   -362,
      -682,    765,   -308,    420,    456,    322,    -54,     -2,
        10,   -239,   6916,   -461,   -482,   -211,   -286,   -110,
      -877,   -711,   -470,    159,    260,     59,    252,    -97,
     -2978,   -646,    -35,    156,   -123,    360,    556,  -3254,
      -475,   -313,   -268,  -1771,   -538,    203,    967,    283,
      -653,   -565,    387,  -3097,   -255,     25,    295,    264,
     -3716,    505,   1024,   -315,   -215,   -222,   -780,    660,
       431,   -341,   -521,     46,    127,   -244,   -772,  -3741,
       190,   -335,    -17,   2135,    744,    -35,    627,  -1115,
       681,   -343,    123,  -1534,    -86,   -542,   -297,    -82,
     -2772,   3914,    -75,    526,    124,   -523,   -112,    500,
       863,    371,    190,   1036,    141,  -1011,    373,    796,
       421,   -682,    403,   2924,   3730,      6,    211,   -691,
      -167,   -391,   -655,    162,    348,    216,   -227,   -535,
      -147,    367,   -189,    331,   -191,    159,     49,  -4905,
      -252,   -290,    609,   -452,   1042,   1027,   -645,   -159,
      -633,   -542,   -925,   -262,    -91,    192,   1266,     -2,
      -164,    587,    188,   3434,  -1014,      2,   1373,   1832,
     -1224,   -965,    831,   -987,   1180,   1389,   -925,     48,
     -3239,    263,   -329,   -660,   -733,    262,   -988,    598,
     -2421,    630,    720,   -925,   -455,    208,   1092,   -294,
};

static const int16_t cb1616l0[] = {
       -15,  -7707,    115,     30,    -36,    -27,    -22,    -43,
         2,      5,     31,     -1,     87,      2,     41,     21,
       270,     16,   3747,   -773,   3027,    224,     92,   -168,
        -7,    -62,    -79,    -44,     -9,     -4,    -58,    -78,
      1063,    203,     -2,     76,    289,    -36,     92,    -29,
       -78,   -148,  -5176,    137,    219,    299,     89,   -233,
        62,   -129,     33,    123,    -30,    197,   4018,    -37,
       -38,    139,     41,    153,     71,    -26,     27,     53,
        72,   3358,    -68,   -122,    293,    -19,   -355,    104,
        34,   3121,     16,     29,   -344,     37,    174,    -28,
       -43,   -102,    -59,  -1661,     14,      5,    -62,     -1,
        14,     15,    -42,      4,    -31,     -2,     13,     23,
       957,   -419,     20,     31,    -14,     51,     24,    -46,
         8,    -16,     27,    -75,    -27,    -33,    -28,     18,
       -67,   -152,    -48,     47,     90,     48,    -74,   -103,
       -18,   4863,      3,    132,    414,    -86,    -60,    285,
        16,     32,    -44,      0,     22,   -163,     23,     -3,
        23,    -61,  13224,     52,   -139,    -13,    171,    215,
       -51,    -21,    -48,     33,    -10,    -17,    -21,  -7662,
       -57,    -44,    -51,     35,     35,     34,    105,    178,
       -77,     77,    147,     67,   -816,   2913,  -3087,    516,
      -112,   -296,     21,    133,    211,    162,     87,    -25,
      -535,   -830,    -12,     46,    -59,    -10,     -4,     42,
         0,    -91,     -9,     47,    -90,    -29,     74,    322,
      -106,     83,     44,   4693,   -788,    -73,    -85,   -105,
       -76,  -1031,     34,      6,     78,    -34,    160,    -48,
      -707,    -12,     -9,     39,     14,     23,     88,  -2286,
        21,    -25,     42,    130,     39,    251,     16,    -50,
       397,   -226,  -2570,     88,   -129,   -347,    159,     92,
         0,    -44,    -49,    235,   -196,    -24,    -36,    113,
     13387,     45,     22,     54,    -20,     29,     27,    -27,
        54,     38,    -63,    -12,    -74,     45,     -8,   -115,
       591,     46,      5,   -234,     57,    124,     86,  -3794,
       -51,    292,   -160,   -152,     96,   -334,    348,     96,
      -186,  -3870,  -3715,     54,      0,    -29,    -65,    -68,
         6,    132,     47,   -155,     62,     26,     66,    -10,
       -46,  -3093,     66,   3633,    183,   -171,   -132,    -24,
       154,    157,    129,   -185,     12,    -26,     96,    -12,
        88,    -34,     42,    -15,     37,  -6625,    -27,     13,
        41,    -30,     62,    142,    -93,   -168,     84,    -22,
       139,    -19,     18,  10590,   -111,     36,     13,    -44,
         4,    -45,     -3,     -3,     28,    -25,     -4,    115,
       119,    -49,     41,     33,     87,    -85,  12444,     73,
        71,   -111,     61,    -15,    117,     23,    -24,     -5,
       131,    -31,     -1,    -22,    -57,    -12,     50,     35,
     -1555,    -20,     38,     82,    -52,     27,   -128, -14106,
       808,    190,     89,    595,     63,   -291,    282,    -48,
        32,   -706,   -433,   -673,   3285,   1311,    830,   3745,
      -204,  -1185,   -584,    -51,    952,   1005,   -566,   1764,
       186,   1211,   -495,   -112,   1213,    192,   2320,    -43,
       -30,     24,  -1152,      2,      2,     32,    -55,    -25,
        -2,    -17,    -14,     -6,     22,    -54,     32,     45,
        10,    -85,    -26,    -16,    -66,    -60,   -210,   -104,
       208,   -248,     62,    -28, -14552,    -11,    -44,   1601,
        47,   -138,     46,    -35,   2647,    -81,     -3,    -38,
       -66,    -59,    -33,    -19,     43,    -17,    -79,     53,
      1821,  -1572,   2582,     85,     48,   -140,     78,   -155,
      -173,     96,    -32,    121,    -58,    201,   -174,    -54,
        74,  -2442,   -282,   -771,     37,  -2930,     15,   1762,
       154,    263,    -15,    -19,    139,    246,   -243,    -31,
        84,    145,      8,    152,     43,    128,    679,   1828,
      3476,     17,     92,    102,    258,    -29,   -275,    -39,
      -187,     88,     70,     28,      2,   2143,    274,    202,
       -67,    -13,    -22,     68,    -35,    135,    114,    108,
        27,      1, -11248,   -100,     14,     26,     59,     10,
       -24,     30,      1,    -38,     -9,     21,     18,     -1,
      2029,    -83,   -342,   3443,    -25,      7,      0,     54,
        78,    198,     45,    233,     -6,      0,   -109,   -172,
     -2250,     41,    -79,   2820,     44,    216,     39,     59,
       -41,     52,     79,    -52,     12,     23,    -72,   -125,
        83,     17,    -28,    -32,     13,      2,     28,      0,
       -26,     75,    -81,     66,     25,    -81,   6516,      9,
       -93,     49,  -4036,  -2484,    -42,    -71,    178,     99,
      -133,     79,    -41,   -112,     57,     66,    -28,     13,
        39,     64,   -123,   3174,   3061,    259,     55,    123,
      -123,    246,   -138,    139,     75,     31,   -215,   -154,
      -218,     26,     16,     21,    126,     26,    -33,    -10,
       -15,     16,    -20,    -53,     21,  15526,    -35,    -59,
       -50,    -11,    -58,     67,    -11,    107,    -24,    -37,
      8155,     31,   -111,    -62,    138,    -60,    -10,     84,
      -128,     37,     24,    -45,    -10,    129,    -68,    -37,
        42,    -80,   -205,    -79,   5994,    -93,   -270,   -400,
        20,    -89,    -39,   -200,    230,    197,    325,   -305,
      -294,     94,   3207,    128,   3119,    226,     28,    -49,
       264,    186,      8,    -29,    -13,     27,     22,    -63,
        43,     84,    -19,     57,  -2605,    316,    259,    -43,
        50,  -2241,    105,    -12,    -23,    -36,     89,     41,
       -15,    145,     10,    -81,      7,    -50,     70,     60,
       -23,     55,    -62,      0,     52,    -77,    180,     74,
        79, -14297,      6,     24,    299,   -107,      4,    -29,
     -3252,    -51,     40,   -143,   3550,    -28,    102,     24,
       215,    147,   -169,    -60,    -43,   -486,      5,     -1,
        62,   -116,  -2917,    430,     50,   2927,    139,    127,
        63,    -53,    141,   -255,    -85,     95,   -101,   -176,
       195,    104,  -3066,    -56,   3239,   -161,   -214,     57,
        24,   -375,   -181,      0,   -259,    130,   -120,     -2,
        -6,    175,   -147,   -185,     68,    219,    425,   2685,
     -3120,    266,    246,   -270,    -70,    273,    168,    121,
      -143,   2641,   -553,   -547,    638,    113,   2965,   -161,
        29,   -374,    105,   -869,    108,     70,     15,    230,
       -54,   -106,    -21,     -4,     86,     85,    155,   -120,
       -17,    -21,  -2534,     57,    149,   -129,     21,   -169,
     -2289,   -127,    -19,    -26,      3,     60,     35,      1,
       -28,     -7,     36,   -180,    -13,     87,    -68,     56,
        80,     64,     -8,    -73,   6691,    -32,     47,     48,
        -6,     61,     36,     -8,    -41,     -1,     13,     68,
       140,    -51,     25,     12,      3,     57,    -54,    -33,
       -19,     12,     28,    -60,    -56,  -2399,    -14,    127,
      1935,     84,    127,   -193,     -3,   3307,    -56,     15,
        31,   -116,   -187,    236,   -289,    261,     69,    144,
      1723,     79,    -68,    102,    727,     69,    654,    -60,
        21,    124,   3497,    248,   -684,   1469,    368,   -254,
      -211,  -2600,    771,   -138,    368,   3089,     52,   -206,
       147,    200,    -15,   -136,    194,   -164,   -352,   -152,
     -4870,      5,    191,     -3,    -97,     28,    -41,    107,
         2,     11,     60,    -76,    -35,    -42,    129,    -77,
     -2610,   -295,   -218,   -369,     10,    253,     15,   -125,
        74,    -87,    -70,   3366,    115,    240,   -106,    -93,
       121,     10,     36,      9,    -18,    -66,    -77,      7,
        37,    -76,    -22,   2913,    242,     22,    172,    102,
       186,   -231,     90,    -11,    -57,     45,    -10,    -44,
       -84,     44,   -117,    -43,     49,   5585,     18,   -166,
       -43,     64,     28,     -9,     26,   -160,     31,    -28,
        29,     56,     29,    -57,    109,    -25,   3140,   -131,
        57,    -20,     27,    -27,     -5,    -42,    -52,     18,
        23,    -56,    -38,    -14,    213,    -33,    -86,  -4741,
      -151,    -46,      1,    -17,     46,      7,    -13,      0,
        50,     28,    -57,  -7291,    -20,     12,     66,    214,
};

static const int16_t cb1616l1[] = {
       -81,      5,    -16,     34,     19,  10938,    141,    -21,
        27,   -105,   -110,     32,    -67,    -75,     19,   -138,
         3,    -14,   -408,   -302,     36,  -4612,     23,   -579,
       -35,     19,   -312,     35,    120,     97,     82,   -109,
        41,  -1745,   -158,    299,  -3069,     84,     18,   -447,
       -33,     65,    -32,     45,     -7,    144,     86,    100,
     -1738,    250,   -226,   -137,    159,    -45,    134,    438,
       102,     37,    -15,   -161,    -23,   4221,    174,     47,
      -264,   -182,   -182,    686,   -248,     89,    -41,     80,
     -2687,   -194,   2552,    407,  -1106,   -970,   -181,   -228,
      4395,    118,   1027,   -255,    136,    100,    -43,    246,
        80,     15,     34,     82,    -54,   -367,    698,    232,
      -177,     45,    -67,     49,    138,   -158,    168,    202,
        43,    -70,   -101,     20,    -97,  -3465,   -342,   -255,
       127,     25,    -52,     -5,      7,     76,     -3,     19,
       -19,     42,     10,    -63,     16,    121,    732,  -3127,
       -43,    116,     36,  -2519,     23,     18,    181,     41,
       -32,    -11,     22,     51,     35,     16,    -34,    -62,
      1744,     94,    173,  -1243,   -262,     11,   3218,    239,
       149,   -219,     29,    118,   -382,   -289,    -42,    161,
        17,     -1,   2551,    -83,     90,   -128,    138,   3238,
        43,    -29,   -112,    110,   -268,    293,     23,   -117,
       -64,   -137,     79,    -70, -10747,    -66,     73,     90,
        35,     90,    -29,    -78,   -111,     75,     48,      8,
      -169,   2944,     16,     89,    186,    -34,     82,    241,
       -46,    257,   -243,     93,   2966,    178,   -256,    -18,
       -33,    103,   -320,   -271,   3088,   2893,   -250,    102,
       696,    124,   -211,     18,   -143,     97,    216,    -99,
       195,     40,    -35,    144,     26,    135,   -152,   -215,
       120,     25,   -254,  -1875,    657,    197,  -3527,   -332,
       310,    -11,   1958,    102,    -12,    -45,      2,   -127,
         4,      1,    -19,     47,    -20,    -52,     97,    -30,
     -7738,     51,     26,      5,    -21,     18,     15,     15,
        66,     30,     -8,     -7,    -31,     -1,    -33,     38,
       164,     90,   6798,    -33,    -90,    -17,     -5,     14,
       -42,     21,    -20,    -41,     48,     -6,    -36,      6,
      -207,  -4363,   5075,     31,      6,    100,     65,     86,
        19,   -158,     28,   -134,    -91,    -68,      9,    -26,
       -37,   2588,    307,   3467,   -451,    101,   -441,    323,
        62,    188,   -132,   -294,     98,    -22,    152,    -46,
        65,    -39,    -37,    -82,     -9,     18,     43,     17,
         8,     56,     97, -11564,     21,     15,     75,     85,
       155,     15,     32,      0,     20,    -45,   7412,     48,
         3,     38,     72,     30,     23,     42,    -20,   -110,
      -454,   -233,    653,   -325,   -276,    504,   -481,    583,
       270,   -649,    481,  -3166,   1619,    164,    -90,    150,
        32,    -96,    -47,     49,    -13,    115,   -183,     75,
        62,  -9026,     12,    -93,   -715,      6,    137,   -338,
       810,    -39,   -277,   -108,    -20,    315,    572,     -3,
     -4570,   1053,   -132,     13,    388,   -223,   -355,     31,
       -47,     61,   -113,      5,    -38,     43,    -47,    -80,
      2550,     27,    247,    277,    -86,    336,    139,    146,
      -111,    -73,    187,   -312,     68,   -276,     72,    638,
        73,    792,   -170,   1383,    421,   -703,  -3813,    112,
       391,   -195,   -162,    -28,    -25,    317,    228,    -83,
      4611,    654,    353,   -380,   -283,   -627,   -301,    161,
      -156,    -81,      5,    -15,    -13,    -17,     53,    -50,
        36,    -66,  -7921,     -2,    -54,    -41,    -26,     47,
        -3,     22,     -6,     11,     63,      2,     42,     71,
       -50,    -87,    -39,      2,    -56,     -2,  11165,     44,
      -119,    -74,    131,    134,      5,    115,    -39,    144,
       -23,      0,    186,   4648,    351,     36,    -70,    -71,
      1706,   2131,   -228,     42,      6,      8,      4,    -43,
       -12,    -40,    -44,     -7,    -14,     11,     83,    -93,
      -144,    186,    -46,     -9,     13,    -87,   -120,     70,
      -209,    115,  -3513,    139,    -46,    133,     96,     25,
       215,    -35,   -437,    126,    403,   -115,    145,    203,
       -69,   -334,     37,    934,   -481,   3163,  -2528,    -49,
        57,    100,     76,     82,    251,    288,   -114,     46,
      -201,   -161,   -161,   -716,  -4080,    378,   -830,   -254,
        12,  -2110,   -300,     78,    288,     48,    -90,    -99,
       -31,   -110,    201,     66,    327,    119,   -180,    148,
       633,     71,  -4100,     33,     57,     -9,    -48,    151,
       -20,     72,     71,    -11,     39,    -67,    176,     27,
       143,    198,    383,    155,   3182,   -128,   -152,  -3209,
      -172,   -262,    -13,    129,   -167,   -128,     55,     46,
       -37,     70,    107,      7,    -23,  -2082,    241,    236,
       -47,    -85,    105,    -47,   -202,    208,    201,     30,
      -106,    -14,    -38,     14,    -45,     24,    -24,  12083,
        22,    151,    -58,     -9,     59,    170,    113,    -82,
       369,   -155,     53,     97,   -185,    -57,    203,    311,
       236,   4789,    -24,   -591,  -1463,    118,     94,   -274,
      3188,   -145,   -406,    183,      0,    -54,     17,    -22,
        37,    -55,    -34,     63,   -340,    175,   -300,    106,
      -190,    -38,     67,     -2,     19,    -46,    -42,     11,
       -33,    -33,    -28,    -10,    -27,  -9235,     29,     62,
      -927,   1285,     49,     72,     65,     89,     57,    -44,
        -9,    -15,     85,     -1,     74,     81,   -123,    160,
        69,  -2803,    -22,     47,   -467,    -74,    748,    168,
        -9,    235,  -3155,   -154,     48,    483,   -341,     74,
      2403,     97,     93,   -106,    219,    136,   -191,    -50,
         7,     71,   -103,    261,   3283,   -124,   -624,  -2570,
        73,    -31,     10,    -73,     30,    -15,  -2256,     -2,
       -73,     55,     73,     14,    -74,    -81,     38,    352,
       108,    -18,     25,     61,     54,      1,     -5,    109,
        25,  -2676,    -25,    -52,   -316,      2,     36,    -36,
      -355,     40,    -19,    120,     27,     -4,    -51,     -8,
        42,    -10,    -28,    -90,   -143,     29,    -10,  -8442,
       -22,   -566,     59,    -39,     -1,     27,     29,    -20,
         6,     19,      0,    -36,     38,     68,    -43,     35,
        22,    -47,   -146,   3567,     13,     12,   3230,    -18,
       -32,     75,   -112,     -8,   -157,    -23,    101,    165,
       198,     93,    383,   1236,   1077,  -3592,  -1401,   1135,
       844,   -266,    -74,    -70,   -280,    -98,     67,   -109,
        38,  -5109,    -66,    -57,     89,    -21,      6,     19,
       -21,     70,     60,     76,     35,     18,     44,     51,
        45,     40,     54,  -6685,    -67,      9,    113,    -29,
       -10,    -96,     80,     98,    103,    -40,     -8,    -20,
      -131,     15,    262,     47,   -253,   -116,    -12,  -4807,
         2,    -81,     76,    -46,     37,    353,   -130,   -191,
      -127,    -10,    -35,     91,   -122,    173,   -165,     -8,
    -15179,     86,   -186,    123,   -295,    -25,     21,     63,
       -93,    730,     20,   -120,  -4624,    340,   -253,   -473,
        44,    -18,    -99,    -37,    -54,   -317,     65,    -52,
      2167,     68,   -245,    224,    117,   -180,  -4695,   -276,
       118,    142,   -101,    202,   -301,    -33,   -129,   -303,
       -90,    -75,     50,     98,    -56,    -68,   -153,    -38,
       168,   -278,    -22,    -64,   9757,    -91,    -23,   1284,
        53,     56,    -11,    -46,  -1645,     11,     15,     12,
         8,    -40,     -2,     84,    -56,     17,     -7,    -30,
     -4010,  -3557,   -252,     56,    -79,    -87,     -7,      8,
        79,     16,     21,     51,    -63,    -22,    118,    228,
     -1525,    -78,    -22,     -2,     16,    -49,     17,    -37,
        -3,    -14,     10,     31,     17,   -111,     32,   -144,
     -3612,   3473,     79,     23,    -89,     74,     33,    -29,
        11,    -42,    -42,   -129,    -41,    155,     52,     31,
      -162,  12609,    147,     17,     68,      2,     15,    -12,
       -39,     50,   -108,    -66,    121,     69,    -27,     94,
};

static const int16_t cb1616s0[] = {
      1213,  -1302,  -1130,     90,    -69,     22,   -360,    360,
       -55,    453,   -705,   4416,    227,    173,     -8,    149,
       210,   -118,     51,  -3759,    949,   2418,   -238,    201,
      -597,     94,   -253,     24,    225,   -497,    -59,    273,
       576,    651,    608,   -483,    335,   -125,    256,  -2873,
       318,   -146,   -650,   -306,  -2021,   1044,     41,   -455,
     -1120,    832,    978,    212,   -463,   -209,     12,   -275,
       -20,    118,     31,    639,   5933,   -180,   -121,   -285,
        65,    212,    439,   -135,    538,    116,   -302,   -245,
      2534,   -623,   1549,    -34,    727,  -1750,   1477,     79,
      1669,   -828,    618,   -856,    773,   -286,    343,    -94,
       107,   -320,  -3144,   -380,    694,    -80,    843,    103,
      -700,   -269,    452,  -6847,    -12,   -527,     97,    -21,
       -76,   -246,      2,   -104,    -68,     98,    312,    117,
      -342,   1025,    207,    838,    -71,   2463,     60,  -1294,
      1549,  -1310,   -202,  -1585,    682,    327,    608,    649,
       664,   -801,    588,    137,   -468,    286,    234,  -6726,
      -107,    177,   -147,    278,    118,    -81,   -242,     97,
      -235,   1599,   -877,   1985,    448,   -319,   -745,   -504,
      -433,  -1859,    -35,    286,   -665,  -1449,   -124,    -97,
       930,   2622,    682,    698,   1898,   1120,   -323,   -142,
      -679,    294,   -162,   -539,  -1649,    152,     23,   -414,
      1493,    602,    913,   1428,  -3212,   -103,   -330,    557,
       463,     92,    251,    339,     16,    936,   -116,    229,
      -827,   -504,   2015,   1553,   -503,   -350,    214,    386,
       295,   2697,    429,     72,   -705,   -120,    427,   -139,
      -334,   -318,  -6613,   -468,     10,   -122,     59,   -322,
      -165,   -144,     45,   -427,    -12,    -79,   -202,   -266,
       981,   -273,    240,   -454,    -30,   -119,    340,     92,
      -251,    247,    189,     71,    243,  -5648,   -601,   -434,
      -674,    867,   -713,   -428,   -101,   -231,   1144,    -89,
       -10,     57,    302,    154,    362,   -425,   2014,   2577,
     -8659,    389,    -90,     76,     15,    147,     30,   -202,
       -99,   -255,   -242,   -165,    257,     97,     41,    -72,
       263,    613,    272,    400,   5020,   -199,   -196,   -177,
      -276,    -25,     28,     97,   -155,    119,    763,     33,
     -3540,  -1447,     16,   -169,    148,   -143,    707,  -2483,
       178,     83,    -83,    154,    -75,    -15,    153,    283,
      -323,   -139,  -1390,     69,    725,  -1744,    331,  -3665,
       415,   -514,   -366,    124,    660,   -295,    180,     77,
      -228,    192,    684,   -193,      4,   4409,    298,    427,
       591,    290,   -159,   -166,   -372,   -514,  -1840,   -562,
       795,  -1765,   -349,   1178,  -1619,   -391,    615,   -784,
      1353,    746,   -871,   -994,    182,   -464,   -498,    -96,
      -306,   -729,    743,    270,    223,   -731,     73,   2692,
      1110,  -2354,   -328,    -21,   -172,   -339,   -528,     93,
      -338,    548,   1498,    309,   -134,    160,   -247,   -619,
      1127,    783,  -1557,    400,   1035,   -445,   -155,  -2443,
       590,   -790,    137,    388,   1188,    844,   -395,   1005,
        55,   1141,   -122,  -3174,    138,    155,   -506,    306,
     -3255,   2432,   -116,  -1289,   -744,   -350,      3,    192,
      -156,     95,   -552,    -57,    329,   -405,    737,    138,
      -835,   4096,  -1037,    797,   -417,   -418,   -507,   -694,
      -256,     78,    -94,    -63,    -93,    754,   -555,    -90,
     -1518,   -878,    167,   -392,   -100,    -78,    -80,    -45,
      4774,    114,   -284,   -560,    -21,    275,     15,   -195,
     -1692,   -711,  -1057,    167,  -1555,   -690,   -263,   -267,
       310,   -229,    -14,   -880,    426,  -2826,    320,    -49,
     -1223,   -725,   3538,   -270,   -606,  -1812,    481,   -703,
       176,   -284,   -173,    271,    847,    711,    239,    314,
      1233,    -61,    477,    429,   -691,   -156,   6712,    850,
       365,    229,   -197,   -355,    298,    250,    207,   -437,
     -1647,   -261,    165,    114,    165,   1165,    -58,   -597,
     -3290,   -517,   -478,   -842,   -187,   -448,   -302,   -204,
       410,    544,    669,  -2012,    476,    434,    214,    698,
       302,    100,     61,     63,   -386,    918,   4434,   -230,
       157,  -1019,  -1487,   2239,   -774,   -234,   -378,    772,
      -190,    270,    -61,    -19,    322,    488,    937,  -3582,
      -415,   2091,   1862,     81,   -134,   1285,  -2732,    221,
      -235,    388,   -216,    -63,    664,   -105,    -37,    165,
       899,   -373,    284,   -375,    286,   -263,   -295,    276,
      -246,    188,   5285,   -303,    290,    -60,     -1,     95,
      -703,   -288,     74,   -717,   -127,    -53,   -422,   -452,
       166,    -54,    -15,    268,    238,    -31,   -279,  -5872,
       863,   -907,   -101,    885,    552,    442,  -2336,  -2142,
      -804,   -147,   -791,   1000,     96,    250,   -306,    134,
       743,  -1648,   -867,    673,   1594,   3725,    527,   -676,
      -661,    238,    262,    560,    277,    -58,    444,    166,
     -1039,   -702,    558,   -970,  -1763,  -1198,    580,    378,
      -421,   -972,    630,   -279,  -2456,  -1222,   -232,   -749,
     -3325,    174,    789,    729,   -487,    583,   -157,   1503,
      -801,    -38,    -11,    556,     81,   1508,   -140,     74,
      1373,    912,   1471,      4,  -1080,   -105,    -58,   -104,
       -54,   -544,  -2392,   1550,    318,   -506,    -11,   -180,
     -1891,   -230,   -259,  -1182,   -154,    524,   -568,   1972,
       546,    469,   -720,   1089,  -1530,   -680,   1349,    429,
        82,  -1524,   1894,    -90,    188,   -145,     15,  -1113,
        15,     53,    282,   2212,   -736,   -941,  -1148,   -344,
      1473,    344,    392,   -333,   -556,   -480,  -3833,     35,
      -160,   -525,    151,   -534,   -782,     38,    520,   -416,
      -384,   7582,   -158,    -29,     74,    -57,    -23,     73,
      -393,   -245,    -12,   -260,   -154,   -319,    357,    247,
      -306,    351,    273,    755,    227,     89,    283,   -152,
        17,   5129,    191,   -213,   -531,    255,   -468,   -209,
      1128,     72,   -807,    225,   -319,   1638,     42,     20,
       935,    -52,   -326,    541,  -1174,    130,    284,   -112,
       444,   3959,    262,   -631,   -262,    275,   1025,    190,
      1125,   -265,    -95,    265,     35,    270,    -92,    -30,
      -141,    325,   -435,     45,   -659,    149,   3648,    339,
     -1701,  -1338,   -144,   -989,   -604,     84,   -394,    168,
      -302,  -1294,   -433,   -921,   1271,     77,    374,   -604,
      -230,     97,    206,   -138,   2909,    478,    707,      0,
      1242,   -340,  -1659,    349,   2751,  -1175,   -146,   1038,
        65,   -775,   -423,     14,     22,     41,   -905,    287,
       280,   -933,    195,  -1817,    540,  -2374,   -661,  -1102,
       879,   1232,     29,  -1683,    286,   -136,    658,   -395,
     -1782,  -2823,   -624,   -223,   -299,   2859,   -103,    -45,
       544,     82,    -21,   -263,   -666,   -362,   -732,    249,
      1087,   -242,     30,    663,   -386,   -350,   1240,   -492,
      -868,     69,    -41,     35,     30,  -1791,   3870,   -455,
      1355,   1098,   2933,    347,    361,     79,   2855,    -26,
       -66,   -598,    -43,     21,   -386,   -802,    -81,   -436,
       846,   -673,    377,   -326,  -1217,   1465,   -480,   -205,
     -2168,  -1689,    690,    355,   1192,    734,   -113,     39,
      -486,   -644,    438,   1096,   -723,   -524,  -1634,   -621,
      -394,    226,    167,   -625,   -709,    854,   3005,   -910,
        13,   -793,  -1517,  -1254,     18,   -440,   -836,    651,
       -31,    229,  -1081,   -126,   -191,  -3612,    487,    451,
      -292,    943,  -2018,   -618,   -259,   -649,   -723,   -447,
      -238,   1096,  -2228,    675,    563,   -316,  -1248,     32,
       -28,    293,  -1817,    226,    267,   1291,    624,  -2279,
       143,    650,      5,   -563,   -504,  -2124,    -94,  -1613,
     -3050,    708,  -3458,    442,     30,     65,    -80,     89,
       204,   -245,     94,     28,     -2,   -231,    623,   -189,
      -405,  -2147,   1147,   3124,    806,   1048,   1145,    653,
        47,     86,     -4,     46,    437,    229,   -190,    310,
      1995,    -48,  -1015,  -1806,   -266,   -941,    361,    179,
       172,    397,    182,    323,   -516,   3435,      7,     -5,
};

static const int16_t cb1616s1[] = {
     -2521,   -518,   1830,    985,   -500,    109,   -807,   -197,
       543,  -1036,    104,   1989,    428,    740,   1110,   -366,
      1482,    899,  -1828,    159,  -3015,   -311,   -792,    -42,
         3,   -412,   -157,    -13,    863,   -248,    261,   -187,
      -409,    156,    772,    271,    318,   -262,     78,   -571,
        28,    370,    119,    302,  -4794,    106,   -123,   -153,
      1857,   -702,   1090,   -319,    415,   -327,   2124,   -170,
      -411,    174,     62,     -7,    921,   -128,    735,   -127,
       972,   1678,    166,  -1471,   -208,   -224,    871,   -900,
      -223,   -817,    288,   -472,     10,     31,   -401,  -3201,
     -1290,     -3,   -301,    183,    730,    473,    438,    -81,
       882,    -64,   2898,   -242,    408,   -211,   -333,   -254,
      -820,    612,  -1128,    -60,    -73,  -2516,     45,    637,
      -130,    459,   -312,   -223,   -629,   1490,   1792,   -199,
       -21,   -545,   1772,  -1084,   -173,    381,    380,   1289,
      -117,    483,    138,  -1200,   -519,    598,  -3453,    349,
     -3102,   1260,   -170,    238,   -684,     48,   -483,   -883,
      -879,    139,    298,   -110,   -203,   -955,    195,     57,
      -550,   1945,   -711,   -688,  -1470,   1527,     58,    317,
       656,    310,     57,    162,   2006,   1387,    845,   -127,
      -398,    318,   2520,   2002,   -906,   -323,   -194,    907,
       588,   -228,   -357,   -316,    557,   -596,  -1559,     -3,
      1614,   1317,  -1701,    936,    -89,  -2270,   1327,   1046,
       400,   -233,     18,   -730,    -23,   -181,   -593,     74,
      -570,   -969,    432,   -261,   -833,    -90,  -4675,    786,
      -566,   -183,   -859,   -554,    346,   -493,   -201,   -220,
       241,   -919,  -1896,    265,   -802,   1380,   -718,  -1103,
      -574,    307,    138,  -1260,    175,   2540,    -82,     58,
      1046,  -1381,   2486,    582,    455,    485,   -824,   -150,
        57,    -45,   -155,   -490,  -1108,  -2191,    833,    423,
     -2011,    267,    779,    140,    -28,     57,     94,      6,
      -301,      5,   -833,  -1226,   -193,   1110,    -63,     79,
      -492,  -1465,  -2733,    444,     56,  -1116,   -601,     20,
      -618,  -1315,   -695,   1146,    -66,    336,   -166,    158,
       530,    -53,   -371,   -594,   -685,    114,   -146,    373,
       174,     -1,     47,    119,   -124,   -121,  -6697,    -94,
     -3544,   1506,   1221,   -101,   2160,    558,   -254,   -728,
       511,    378,   -383,     12,    626,    172,    183,    354,
        49,   1669,   1188,   3810,    409,    152,    694,  -2520,
       342,     61,    -85,    -38,   -170,      5,    305,    154,
      -348,    699,    332,   2542,    673,  -1130,  -2601,    554,
      1483,    466,    271,    490,   -644,    822,    -96,    477,
       131,  -2051,   -111,     43,    -31,    -62,   -767,  -3257,
       663,    488,   1823,    522,   -525,   -249,    481,     -7,
     -1298,   -941,   -335,   -566,    305,    534,   -735,    207,
       709,  -3170,     19,    -20,  -1888,    271,  -1697,    117,
      1837,   2690,    305,   -483,   -463,    407,   -706,    467,
       518,   1806,    244,    -80,   -453,   -505,    882,    843,
      1328,   -280,    175,    319,   -842,    192,   -680,   -469,
      5440,   -205,   -187,     53,    332,    204,   -184,     96,
      1026,   -525,     20,    975,    125,  -1562,  -1873,   -757,
      -137,    133,    -10,   -340,   -783,  -1484,  -2206,   1238,
     -5212,   -466,    129,   -224,     17,    497,    -41,    846,
        88,    -41,    285,    284,   -155,     21,   -225,    150,
       223,   -807,   -444,  -1141,   -908,    292,   -326,    559,
      -446,   -283,    -41,   -277,  -3479,   -667,    532,     83,
       257,    383,  -2986,   1685,    697,    777,   1551,   -142,
      1786,    579,   -531,    787,    712,   -984,    603,   -174,
      -459,   1303,   -943,    741,   1103,    -73,    600,   -403,
       -42,   -169,    -90,    220,    208,    105,  -4083,  -1069,
       981,   -926,    124,    273,   -145,   -133,    307,   4720,
       209,    324,    -79,     12,    -41,   -220,    211,   -184,
       435,    307,  -1544,     83,   1565,   -445,   -217,   -648,
      -379,  -1270,  -1590,  -2337,   -860,    348,    648,   -157,
      -785,   3318,   -123,   -138,   -412,   -876,    358,   -173,
      -280,    -81,   -149,   -167,   -160,  -2113,     20,    -40,
      1022,    432,   -721,     55,   -651,     17,  -1135,   -380,
      -542,  -1128,   2919,   -475,   -143,    -53,    176,   -152,
         7,    -29,   -172,    174,    195,  -8005,    277,    105,
        35,    115,   -314,    137,   -253,     75,   -278,     90,
     -1508,     79,   -153,   -560,   1027,   -349,   -292,   -466,
     -1101,   -324,    -84,   4251,    822,   -420,     55,     43,
      1886,    281,    964,   2408,    425,   1187,    -27,    -84,
     -1277,     63,   -978,   -143,    506,    727,   -155,   -384,
      3434,    592,   -262,   -438,    -30,   2849,    -69,    -58,
      -181,    -87,     20,    299,    412,   -263,    702,    131,
      -271,    -10,    736,    121,  -6299,   -132,   -116,     26,
      -253,   -586,     32,   -145,   -251,    -12,    471,    135,
       585,    604,     29,    873,    363,     -2,  -1595,     41,
     -1147,   -142,    665,  -2752,   1302,   -358,   -134,     29,
      -691,    -12,   -702,   -459,    100,    278,      9,     54,
        66,   -458,     53,    213,    193,     14,   -400,   4870,
      -950,   -209,     50,    470,    449,      3,   -118,   2287,
      -469,    -58,    126,   1011,   -826,    386,  -1019,  -2390,
      -586,  -1401,    137,    760,    141,    -89,    117,   -252,
      3106,   -936,   -198,    390,    463,   -245,   -509,   -123,
      3057,   1200,   3451,    282,   -332,   -585,   -662,   -955,
       165,   -276,     73,    373,    202,    506,    356,    125,
       141,   -613,   -670,    446,   2031,   1521,   -446,   1339,
       198,   -112,    214,     70,    265,  -1310,   2492,   -133,
     -1880,   -347,   -961,    312,  -3714,   -475,    102,    391,
        64,   1091,   -686,   -101,    144,    447,    173,     66,
      -374,    342,     69,  -3379,  -1331,   1160,   -889,   -858,
       982,  -1613,   -223,     57,    186,    428,    226,   -477,
       449,  -1052,   -661,   -382,    459,    277,   -277,   -250,
        12,   4077,   -260,   -161,   -163,     38,    159,    243,
       131,    457,  -2253,   -301,  -1626,     37,    806,    104,
       191,   1899,    346,    398,  -1108,   -623,   -391,   1092,
      1252,   1126,     81,   -116,   1192,    674,  -1321,    -32,
      1739,   -708,   -230,   -844,   -507,    415,    261,    211,
      -619,   -191,   5460,      8,    139,    197,    392,   -556,
      -215,     66,     64,   -808,      0,   -136,    151,    156,
       260,     94,    418,  -1446,   1815,   -540,   -793,    451,
      -477,   1788,   -124,    330,   1638,    342,   -503,   -384,
     -1201,   -762,    929,  -2886,    888,    -63,    318,    598,
        42,  -1226,   -400,   -462,   -136,    321,   1872,    376,
      1260,    142,    -79,   4377,      9,    294,    -71,   -190,
       -21,  -2612,   -240,     26,    -18,   -227,    864,     79,
      2588,   -882,     87,  -2976,      9,    480,  -1573,   -170,
      -429,    201,   -124,    171,    632,    -60,   -447,     64,
       -37,  -1182,    -86,   -105,   2901,  -3557,   -134,    486,
       141,   -259,    239,    465,    467,   1009,   -409,     34,
       254,   2469,   1002,    834,    557,   -845,    149,   -747,
      -504,    494,   1382,   1067,    353,    191,  -1105,   1705,
      -586,   1472,   -444,  -1303,    198,    602,    471,    468,
      4855,    127,   -141,    487,   -454,   -138,   -392,   -118,
      -491,   -948,     58,   -290,     -7,   -662,    229,   -268,
        -2,   -537,   -620,  -4770,   1152,   -173,    166,    -69,
        32,  -2555,    433,   -583,  -2219,   1107,   1082,   -942,
      -173,    399,   -601,    250,    423,    125,   -448,    352,
      -571,   -406,      0,   4735,   -264,   -174,  -1020,   1105,
     -1149,   -171,   -252,   -130,   -202,    -74,    601,    601,
       570,  -2742,  -1403,   3129,   -349,    194,    309,    130,
       261,     93,    154,   -117,   -418,   -657,    270,   -160,
      1660,   -818,    613,  -1458,   -653,  -3763,   -232,     90,
      -265,    -99,    -28,    -13,   -281,   -553,     11,   -142,
     -1764,  -4548,    936,    -21,   -683,    -88,   -806,   -187,
        28,     78,    -70,    -99,     -2,   -493,    -16,     48,
};

static const int16_t cb1616m0[] = {
     -3821,  -3397,    203,    -25,    -22,     68,    189,    -13,
      -286,     94,     18,    288,     29,     -5,      3,   -414,
      1483,   -172,  -1275,   -180,  -3792,    360,    145,   -143,
       444,   -139,   -198,     70,    -17,   -353,   -121,     -6,
        76,    -50,   2987,    173,  -3070,   -229,    -16,    192,
       134,    -55,    -86,   -200,    128,  -2052,    -59,    -11,
        -4,    309,    179,    494,   -138,   -363,   -336,    119,
      -127,   2497,   -169,   -316,    -87,   -538,     42,   -534,
       315,   2364,     61,    269,    -87,    -94,     82,  -2069,
        18,   1238,     -7,     79,     -9,     41,     70,     50,
       209,   -158,   -136,     28,   -275,     62,    296,     77,
      6269,   -184,     73,    -19,    -25,    -57,    134,    -52,
      8569,   -176,     -8,     17,     15,     79,     36,   -137,
        12,     44,   -270,   2335,    111,    517,    -83,    207,
      -276,   2577,   -198,     83,    376,    -75,   -273,     62,
       109,      4,    -48,    122,    -41,     99,    -87,     14,
     -7696,   -118,    -66,    171,     96,    -31,    123,   -217,
      -676,   -439,    407,     97,   -281,   1873,    626,   -148,
      -548,   1634,    704,     97,  -2076,   -336,    632,   -371,
       113,    544,    -88,    184,  -2200,   -420,   -592,   -168,
       759,    291,   2215,    704,   -140,   -145,  -4088,    295,
       186,   -270,    283,    294,    -42,     76,     69,     41,
      -140,   1635,   -200,   -682,    302,   -192,    902,   -540,
      -843,   -494,   -529,    102,   -759,   -165,   3160,   -180,
     -1450,   -424,    -16,      6,   -548,    296,  -3056,    219,
     -1883,   -109,   -566,   -431,     95,   -422,   -532,    -26,
       120,    -46,     23,    174,    175,   -369,    110,     -2,
        25,    132,     -1,  -3338,    -67,   2140,    -25,    566,
      -129,     35,   1187,    337,   1999,   2712,    -71,     45,
      -177,     94,   -321,   -197,   -573,     98,    225,     46,
        53,     78,    -40,     82,     23,   2718,   2534,     89,
       -65,     77,    206,    343,    527,    102,   -191,     94,
       463,    111,  -4529,     97,    876,   -205,   -944,    181,
      -132,    467,    366,     85,   -302,   -100,    -33,    -76,
     -3087,  -2546,    215,    277,    -52,    352,    137,    -45,
       162,    590,    406,    382,     85,  -2824,    141,    219,
     -3790,     40,    126,     32,     30,    100,    121,   -210,
       196,   -268,    178,    102,   1229,    -80,   -750,    -11,
       -57,     84,    238,   3571,    274,   -254,     55,  -1616,
      -176,   -755,     46,  -1306,   -201,   -228,    101,    197,
       -93,   -156,    319,     82,   -385,    -17,  -4660,    180,
      1278,   -113,   -215,    103,    832,   -233,    412,    249,
      -900,   -132,  -3427,     52,    416,    267,    317,   -384,
       130,     78,     91,   -360,     75,    386,   2219,   -360,
     -2975,     17,    286,   -294,   -213,    231,    131,    821,
      -358,    222,   -230,    -44,    -93,  -1151,    294,   -316,
        -8,    129,    231,   -993,    -58,   3319,     48,  -2546,
      -213,    -14,   3208,    162,   -240,   -176,    307,   -165,
       -20,    348,   -113,    -78,    -91,     -8,   -261,   8033,
      -179,     64,     -7,   -113,    -59,    -32,   -170,     52,
        55,    -80,    140,     64,    -39,    915,     28,    416,
        38,  -2328,    206,    115,    366,    -92,    652,    110,
     -2838,    -59,    613,     23,    109,   -151,   -198,    185,
      3033,   -122,   2863,   -273,     86,     41,    114,    -99,
       315,    372,     14,   2191,   -171,    531,    -18,    -34,
      -352,    130,   -360,    117,  -2896,      2,   -564,     51,
       223,     57,   -257,   3161,   3130,   -384,    126,    -40,
      -160,   -232,   -138,     81,    -34,    -96,     82,      9,
        62,   -161,    344,    100,    790,   -243,   -344,   -393,
      -531,    401,     90,    171,    144,   -329,      7,  -4639,
      -135,     -6,    351,    -21,   -195,    224,    -25,   6027,
       224,    -14,    344,    170,   -169,    -97,    252,   -488,
      -379,    -73,    629,     -9,    266,    152,    -64,    330,
        -8,   2080,    -91,  -3315,    229,     25,     45,   -528,
      -123,   2951,     40,    -85,     -4,  -2695,    -38,   -112,
        84,    -30,     79,    762,    151,  -4089,    -95,   -151,
         9,    138,   -206,     -3,  -2114,     99,   -100,    116,
      -403,    -56,     -8,    -36,    115,    -18,   -195,    -38,
      -240,      8,    -32,    122,    125,  -7406,     45,   -210,
       111,   -152,   -152,    -35,    -72,     28,   -154,    303,
     -3147,    459,  -2881,    -14,    -13,    -56,   -126,    -69,
      -213,    -97,    202,    -88,   -277,   -557,    451,   -376,
       -91,    319,    141,   2728,     23,   2506,   -101,    632,
        62,   -314,    159,     44,   1231,    -65,    -37,    192,
      3118,   -186,   -396,   -108,     71,   2111,    586,     95,
        15,    -28,    176,     20,    -67,      3,   -265,    101,
      -182,    -21,   -455,    -15,  -6225,    -45,   -353,   -384,
       -22,    113,    -40,    -47,     57,    -73,   -503,    134,
       736,    -70,   -125,     -5,   -250,     62,    165,    182,
       185,   -132,    426,   -276,    100,   -497,    -23,     81,
      -112,  -3528,  -1997,   -234,   -154,    -91,   -125,    -26,
       179,   -611,    655,    767,  -1064,    130,   -264,    107,
      2811,  -1391,    298,    -20,     37,    -74,    -12,   -157,
      -270,   -106,   2559,    -89,  -3107,     55,    187,   -265,
       195,    140,      1,   -484,    713,    171,  -1123,   -226,
      3666,   -367,   -516,   -249,     38,    195,    236,   -378,
      -383,   -205,    -72,     -7,     15,  -9329,     -6,    -26,
        56,    141,     48,      6,   -141,    -95,    -69,    -40,
       -99,    -80,     73,   -253,    456,   -174,     51,   -250,
       -48,  -2115,    -63,  -2555,    -25,  -2058,    -58,     66,
       176,     14, -10053,    -23,    -39,    -37,    -15,     38,
        82,     11,     97,    169,      5,    -67,     57,     61,
     -2248,    108,    -19,    256,   -169,   -122,   -336,   -431,
       -77,   -250,   -156,   -745,    184,    684,  10559,   -199,
       -34,    -37,     96,    -82,    -17,     60,     65,     21,
       -67,   -337,     62,     35,     74,   -214,     38,     47,
      -129,   6139,   -139,    -57,   -154,    261,      7,   -127,
       109,     40,    179,    -99,    198,    -51,     48,    -36,
     -2377,   -194,   -334,  -2826,    103,   -220,    -57,     41,
       979,   -895,     68,   -217,  -1712,   -430,    -98,     91,
      -107,  -1755,   2615,     84,   -500,    231,    480,    -31,
       146,   -157,   -120,    152,   2342,    -36,  -1969,     57,
      -109,    476,   -243,    261,    -58,   1998,      4,   1388,
       -98,     45,   -140,    400,    -76,   -321,    -22,     -9,
       210,    517,      5,  -4708,     66,   -330,   -405,    -19,
      2158,    -65,  -2163,    244,    -16,   -192,    494,   -381,
      -194,    413,     89,    220,    455,    -54,      4,    206,
       221,  -4998,     63,   -365,    354,    364,    677,    207,
       -66,    -27,   -477,   -182,    841,     85,    -40,    166,
      -185,    321,   -293,   -181,   -429,   -231,   1401,   -122,
       938,     67,   -185,     51,   3188,   -802,    421,  -3230,
      1432,   -432,   -658,   -587,   -843,    421,    177,    446,
       510,   -140,    -90,   -127,    -78,      2,   1089,   -185,
       301,   -393,   4100,   -152,    265,    224,     25,     95,
       534,    280,   -254,    -45,     -5,   -207,     49,   -126,
      8922,     43,      9,     21,     28,     21,    -42,    -84,
        38,     90,  -2014,     61,   -149,    188,  -3350,   -120,
       -43,     10,     14,    155,   -225,   -351,   -114,     28,
       -23,  -4400,    367,    -51,     76,    -89,   -113,    122,
      2007,     25,   -348,   -227,   -370,    -61,    135,    -79,
};

static const int16_t cb1616m1[] = {
      -321,     -7,  -6725,    -36,     77,    -20,   -101,   -529,
      -166,     97,    -76,   -232,    -70,     16,     13,     93,
       -50,    222,   -258,  -4424,   -125,    125,     83,    313,
      -246,   -325,    108,   -331,    484,   -188,    192,   -964,
      2603,    -38,  -2236,     58,    337,   -254,    -17,    -90,
       -88,     40,   -141,  -1293,    -56,   -811,    247,    -78,
       -34,    144,    112,     43,    142,   -137,   -147,     56,
      -406,     12,    210,    132,   3707,    109,   -896,   -268,
     -2295,   -509,     32,   -219,    113,   -104,    141,    273,
        18,   -358,     16,  -3354,   3474,   -167,    220,     10,
       104,   -175,     -8,    -71,    -77,    -48,    277,     82,
        86,     35,   -712,    -32,     36,    -65,    213,    121,
       -76,   -742,    291,  -4587,   -169,   -122,    -77,   -285,
        54,   -120,     89,     71,     12,   -133,     54,   -215,
     -1906,   -115,   3220,   -194,   -391,     87,    415,   -212,
      -210,   -138,    182,    590,    713,    944,    320,    142,
     -1970,    197,    -79,   -548,    458,   2836,     33,    -62,
      -183,   -149,   -640,    147,   -427,   -113,   -178,  -1631,
      -108,   2666,    -58,   2210,   -251,    288,     16,    382,
      2123,    636,     -4,   1118,    232,    335,    -33,   -114,
        24,    -68,   1309,    -38,   2080,    534,    288,   -162,
      -630,   -360,   -643,     10,     62,  -2229,    263,     19,
       310,    -44,    419,   2846,  -2579,   -159,   -246,    685,
       -67,    394,    314,   -356,   -158,     19,     90,    116,
     -2261,    163,    664,    163,   -191,    -49,    -18,   -308,
       -15,   2508,   -370,    693,    -62,    818,   -307,   -658,
       133,   1858,  -4900,     53,  -2485,    -48,     -9,    126,
       159,      6,    -71,    291,    102,   -367,    -62,     27,
        88,     -6,    204,    -65,   -725,     31,   -159,     -1,
        -5,     45,   -133,   -146,    261,  -4481,    -19,    694,
      -261,   -478,   -177,     88,    214,   -836,    -14,   -762,
      -111,    501,      0,    254,   1971,  -1024,   2678,   -141,
     -6064,     76,    430,    160,   -195,   -582,    280,    580,
       183,   -315,    -13,    665,    -53,    315,   -199,    438,
       220,   3267,    194,      2,   2808,    -88,     42,    150,
      -179,    237,   -155,    143,     46,     99,     27,     30,
     -6137,    -51,    -89,    201,    145,   -179,     13,   -358,
        55,     71,     -3,     28,     -9,    -16,    125,    160,
       159,    -21,  -5407,   -485,     -4,    -88,    -89,     44,
         3,    166,     22,   -413,    993,     80,    485,   -107,
       446,   -943,   1025,    261,     -3,   2991,    547,   -268,
      -109,    536,    -10,    187,     17,    388,   -120,    -71,
      -343,   -416,    162,     69,     -9,     46,   -477,     83,
      6134,    146,   -236,   -125,    -94,    -55,   -274,   -231,
      1120,    171,   -139,  -2714,     80,   -111,     20,   2475,
      -135,  -1710,    317,   -762,    155,   1222,     68,   1192,
       -15,   1825,    -36,    -45,   -120,   -484,   -131,   -162,
      -128,    163,   -407,     72,   -222,    -46,   -222,  -5319,
       278,   -373,   -436,    284,    138,   -243,   -104,     28,
       -77,   3022,     93,    -15,   -581,   -498,    292,   -165,
     -1740,    121,    195,  -1368,   -134,    -68,    -20,    -75,
       -10,    113,    128,   -381,   -507,   -237,   -709,     13,
       -22,    155,  -5065,    -95,    246,   -226,    193,    687,
      1839,    246,   -232,   -359,    475,    106,    297,    205,
     -2702,   -378,   -219,    -20,    140,  -3198,    192,  -3077,
      -135,    -38,    -23,    213,    -72,    255,    -90,   -130,
      -150,     62,   -484,    -94,  -2625,    -89,    344,   -129,
      2655,    369,    -35,     17,   -697,    251,   -343,     68,
        53,    176,   3104,    237,    -75,  -3020,    178,     45,
       -86,     45,   -115,    183,     49,     26,    140,     77,
        40,  -2315,    249,   1791,     48,   -755,    -12,    201,
      -455,   -250,    -62,   1729,   -113,   -959,    238,   -114,
       289,   -135,  -2208,   2748,     65,    306,    -83,      3,
      -513,   -481,    -49,   -163,   -568,    -88,    668,    -51,
     -2586,    106,    -22,    584,   -453,   -350,    333,   -177,
      -236,   -657,    536,   -349,    394,    -56,     14,    133,
       -55,    -84,    210,    -19,  -8647,    154,     80,     27,
        -7,    -76,   -117,    100,   -201,      1,    296,   -101,
        -6,   5642,    137,    -59,    -93,     95,   -110,   -280,
       -61,   -300,     25,    887,     43,    -30,   2493,     76,
       -22,   -343,    489,    266,    308,    163,    132,   -349,
      2021,     18,  15536,     61,     11,    -41,    -42,     41,
        -4,   -183,    -40,    -24,     26,    241,   -102,   -115,
      -164,   2044,    -35,   -217,   -226,    734,   -228,  -2546,
       218,      0,    122,   -150,   -528,   -188,  -1273,    155,
       107,    -33,    -37,   -293,      6,    112,   -155,   -228,
       192,  -2378,    153,  -1045,    213,   2975,     39,   -159,
       -10,    -41,     34,   -125,      4,    -30,   3907,    -41,
       848,   -346,    191,   -195,   -292,   -126,   3421,    -24,
      -244,     92,    693,     64,   -193,    192,    121,    -33,
      -141,    523,   -162,   2754,     71,     59,     40,    -63,
      -142,   -100,   -338,    379,   -136,    -64,   -196,     11,
      3198,    162,   2097,   -132,  -2359,   -193,   -398,   -318,
       842,   -635,   -168,    425,   2001,   -136,    290,    206,
       562,    -96,     -8,   -214,    -45,    -11,      4,     52,
       177,   -148,    229,     33,    -48,    -46,   6538,   -106,
       -27,    -22,   6527,     20,   -405,    157,     87,    208,
      -117,     -4,     30,     87,     28,   -356,    -76,   -108,
       -33,   -568,   -270,    177,     49,   -457,  -3210,    119,
       103,    256,   -180,    211,  -1209,   -369,   -256,     37,
       -47,   4976,     84,    207,    225,    224,   -425,    396,
       921,     58,   -150,    104,   1509,     15,    -58,   1724,
        47,    -24,     21,    376,    353,    482,   -236,    634,
       306,   3179,     73,    -33,    -54,   -169,   -214,    146,
      4322,   -216,   -644,    305,    305,   -453,     53,    143,
        -9,  -1472,   -141,   1314,     57,     40,    -55,    -80,
        67,   9264,     57,     86,     22,   -147,      1,     -6,
         0,     39,      7,    114,    -51,   -137,    155,    -15,
      -122,      5,    137,    125,    213,     -6,   7158,     36,
       -52,    -54,    149,    901,    859,    703,    366,    673,
       -13,   1186,    588,   -202,   -451,     18,   -585,   -250,
     -2632,   -134,     61,  -3038,   1022,     78,   -672,   -276,
        96,    838,    533,   -254,   -525,   -106,   -378,   1627,
        12,     31,    317,   -118,     81,    313,   -186,    197,
       452,  -2971,     83,   1326,    419,  -2366,   -328,    -87,
      -103,   -243,   -280,     25,   -240,    590,   -232,    105,
     -2966,  -2391,   -326,    338,     80,   -392,   -243,    271,
        -7,   1127,      1,   1901,  -2279,   -207,     32,    -99,
       560,   -193,    371,    494,    506,    255,    332,  10737,
        48,      8,    -33,    -33,     32,    -33,     45,   -104,
      -259,    -99,    -37,   -134,     72,    -50,    138,    428,
     -2258,     77,    744,      5,     96,   3020,   -269,     49,
       112,   -223,    186,     48,    224,   2571,    340,   -129,
       -39,  -1900,    -45,   1978,   -261,    223,    294,     22,
      -108,    -58,    109,    -31,  -3252,   -138,  -2969,    -19,
      -133,    190,    -36,    132,   -136,     63,   -175,    351,
       -76,    232,  -2708,    -17,    -24,   -130,   -474,     74,
     -2978,     45,   -139,    -23,    227,    -42,   -141,    278,
        81,      8,  -2491,   -446,    315,    -64,   -167,   -643,
      -275,    100,      0,   2484,   -482,   -128,   -144,   -206,
};

static const int16_t cb1616sl0[] = {
       -46,  -5073,    119,    -68,      8,   -160,    201,    -15,
        55,     44,     44,   -197,   -110,    -83,    -90,    -66,
       -29,   -128,   2449,   -182,   2226,    298,    -69,    189,
      -167,    199,    -78,     60,   -154,   -169,   -242,    189,
       214,    132,    -41,    169,    222,   -130,    209,     20,
      -154,   -327,  -3458,    186,   1356,    672,    133,    100,
       375,   -491,    -52,    -87,    153,    537,   2513,   -349,
        47,    -27,    118,   -301,    250,     45,    191,   -150,
       279,   2367,    -70,    191,   -301,   -206,     -5,    -40,
      -201,   3680,    -67,     36,   -341,   -133,   -197,   -383,
      -101,     21,    -68,  -1240,     69,     -8,     -7,    -16,
        28,    -47,   -145,   -169,     32,    170,    246,    149,
      3039,  -2617,    -42,    -95,    184,    -74,     71,    -56,
       -22,    -85,   -203,    129,     97,   -105,    -91,   -304,
         4,     93,     89,   2724,   2809,   -178,     52,   -155,
      -152,    149,     47,    182,    124,    -75,     24,    256,
       -38,     53,   -135,     63,     70,     59,    -59,      7,
         6,     46,   8192,   -157,    142,     81,    121,    136,
       -87,   -147,    -71,     59,     57,    119,     21,  -1938,
        46,    186,    100,   -158,    -52,     34,     95,     22,
        20,    179,    112,    116,    234,   2551,  -3012,   -167,
       -93,   -379,    -90,     24,    208,    257,    253,     23,
     -1361,    209,     75,    191,    -23,   -115,   2024,    264,
        77,   -159,     77,   -219,   -237,   -154,     13,    273,
     -3338,    122,   -205,   3796,    -96,    103,   -136,    -60,
       115,    -81,     19,     69,    396,    225,   -280,     86,
       329,    284,    505,    403,    -37,    203,    310,  -2587,
     -2374,   -241,    -17,    492,    -42,    -32,    261,    112,
       123,    -33,  -1271,   -112,    -41,     12,     82,     67,
       -71,     56,    -10,    -83,    -28,     15,    -12,     42,
      2292,    297,   -235,     -3,    528,    -57,    159,   -185,
       -54,    -84,   -152,    775,     15,     54,    451,   -294,
        53,     -2,    141,     39,    -65,     75,    149,  -5460,
        17,    -58,   -126,   -281,    264,    151,    362,    -98,
        62,  -2361,  -2560,    173,     42,   -290,   -161,    -96,
       -52,     82,    130,    -86,   -150,     48,     20,    -57,
        52,  -2263,    -96,   2662,    -66,     21,     74,    -37,
        22,    323,     64,    270,   -141,   -599,   -300,   -121,
       -12,   -128,    -96,     -3,   -129,  -4339,   -293,    -55,
        31,    -82,      8,     82,    -20,     58,     15,   -238,
       140,   -125,    -98,   7632,    -14,     96,   -129,    -12,
       -39,     85,      0,   -104,   -225,     24,      3,     95,
       -87,    115,    168,     19,     22,     95,   8056,     36,
       -12,    106,    -99,    -15,    -87,    112,   -122,     55,
        14,    282,    -31,     80,     42,     -4,     81,    -73,
        74,    -10,     82,     35,    173,    -20,    -40,  -8192,
       -35,   -386,    270,    263,   -231,   -142,     42,   -445,
       204,    177,   -330,   -859,    715,   2731,     59,   2578,
       220,   -478,      3,    410,    -47,     61,   -214,   2765,
      -206,    174,     56,    427,    442,    118,   2708,    -66,
       -40,     41,    119,    -65,    -71,    -21,    124,    106,
       -18,  -2586,    -35,    106,   -364,    286,    -16,   -178,
      -146,    -82,    157,     92,     -4,   -437,   -131,    -85,
       -27,    -90,     23,    -58,  -5332,    115,    -69,    -25,
       -14,     13,     52,     14,   -286,    -13,    -60,     16,
        19,     53,     35,      7,    -21,      7,    231,     48,
      2495,    -82,   2836,     44,   -134,    -76,     33,   -394,
        47,   -124,   -175,     95,    103,    161,     57,    -37,
       174,   -499,    131,   -394,   2007,  -2596,   -481,    294,
       152,    601,    144,   -438,    109,   -204,    317,     37,
       362,   -153,    216,    269,    -39,   1250,    505,    505,
      2571,   -115,   -595,   -806,   -998,   1226,    -71,     26,
       -67,    262,     51,   -161,    183,   1622,    -32,    233,
         3,   -217,     19,    -16,    209,     51,     40,    -40,
       -43,    -27,  -7227,     13,   -128,    -18,     82,    154,
       133,   -121,     33,    -66,      8,   -102,     71,      8,
      2780,    -43,     79,   3212,   -282,   -165,    125,     78,
      -101,    -59,     59,   -136,    308,    -61,   -295,   -241,
       -29,     27,   -326,   2932,   -563,    308,   -269,    -34,
      -158,    -26,    -64,   -411,    -75,    420,   -294,   -239,
       -11,    429,     44,     36,     69,   -200,    -56,    279,
        80,   -218,   -294,   -294,    252,     64,   7793,      7,
      -155,    -56,  -3118,  -2749,   -178,     62,    441,    105,
       -45,     23,     23,   -101,   -109,    -26,   -149,    566,
       -29,   -394,   -850,   1699,   1986,    243,   -665,    565,
       155,  -1746,     96,   -344,   -651,    387,   -363,    283,
       241,    101,     71,    -18,     -9,     43,    114,    -22,
         9,   -109,   -119,    -92,    117,   8192,    -67,     87,
       174,    -42,   -195,    527,   -155,   -195,   -167,  -1619,
      2638,   -824,    121,     44,    138,   -808,    407,    584,
      -217,    -90,   -278,    549,   -118,  -1278,    837,    220,
       142,   -956,   -294,     89,   2627,    269,   -129,    253,
        10,     15,    167,    163,     87,   -262,     89,     48,
        14,     24,   2967,   -175,   2550,     51,     11,   -152,
      -111,    230,   -267,    -79,    321,   -641,    507,    -32,
       -20,   -238,     23,   -322,  -2506,    173,   2205,    -91,
       -21,  -1594,    420,   -157,     97,     64,    126,    -38,
       -84,     10,    -85,     93,    -21,    272,   -427,     30,
       -60,     61,    -81,    -40,     27,     18,    -29,   -208,
       -70,  -8192,     16,     15,     53,     34,     49,    -26,
     -2512,   -152,     23,    -77,   3015,     87,   -164,    247,
       119,     91,    444,    -43,   -166,    -26,    253,    -93,
        50,    408,  -3274,    913,    104,    119,     17,    -54,
        42,     19,   -294,   -298,   -416,    -82,     38,   -263,
       137,    132,  -2609,    -44,   2783,    -34,     -9,    266,
         8,     18,   -183,    520,    515,    -93,   -159,    -21,
       186,     27,    -89,    137,     77,    -60,    -33,     34,
     -5115,    -44,   -172,   -122,     -9,   -104,     69,     16,
        94,   2813,   -200,   -142,    -50,    375,   3276,   -272,
       -44,     47,    -41,   -188,    263,   -237,    -24,    312,
       120,   -326,    823,    193,    410,    -95,    356,    565,
       296,   1202,  -2737,   -968,     87,   -204,  -1329,   -826,
      -827,    584,    194,    -31,    -12,   -109,    -39,     -7,
        73,     29,     24,    -12,    256,    -98,    -46,     63,
       207,     -8,     73,   -342,   4578,    -37,     60,    -66,
         8,    -39,   -176,   -125,    -34,     57,   -141,    -52,
       -39,   -128,    -50,   -143,    -85,   -107,     19,    -38,
        74,    -40,   -161,    -54,    -63,  -3452,    176,    116,
      5274,     19,    -42,    198,      3,     33,     80,    -99,
      -111,     11,    -90,     97,     -6,     -3,    -52,    301,
      2335,    148,   -171,    -88,     44,   -404,    124,      4,
       -80,    189,   2838,     62,   -247,    394,   -230,    -91,
        92,  -2587,     84,   -139,    -31,   3014,     25,    201,
      -137,    -64,    383,      2,    -70,   -115,   -210,     43,
     -1111,   -403,   -379,     -9,    243,     77,   -220,    -60,
       -38,    -15,      7,    109,     41,    143,     56,   -211,
     -2492,    -48,   -218,   -115,   -321,   -358,    388,    -10,
      -172,    -52,    177,   2996,    -96,    480,    -23,    -15,
       177,   -225,    217,     10,    367,    129,    -45,   -114,
        23,    257,    -48,   2497,    236,     12,    197,    245,
        19,   -173,   -321,    310,    406,   -280,    -72,   -279,
        73,   3307,    245,     78,   -186,   2928,    264,    263,
      -227,     50,    172,     91,    293,     24,   -148,   -245,
       -61,    219,    -88,    169,    220,    -99,   3222,      3,
         0,    103,     19,    116,     69,   -180,     -7,    -49,
        26,    -59,    -93,    -68,    123,    357,    241,  -3308,
      -297,    198,     40,    -80,    285,    161,     90,    -46,
      -165,    -32,     87,  -5676,    254,    -37,      7,    -20,
};

static const int16_t cb1616sl1[] = {
        73,     78,    -64,     76,     17,   6250,     -4,   -167,
        52,      4,     -3,     11,   -189,    -19,   -136,   -220,
        15,      6,   -420,  -2205,     38,  -2944,     16,    118,
      -116,     61,    119,   -390,    217,    548,     24,    161,
       -24,  -2342,   -148,   -159,  -2783,    225,    401,   -226,
       210,    643,   -366,    240,    264,    167,    115,    827,
       -39,   -161,     30,   -173,     42,     29,     98,    377,
       -58,   -163,    -41,     27,     25,   4368,     87,  -2836,
      -175,    -71,    -62,    -84,   -476,      4,   2466,    113,
     -2830,   -916,    593,    276,   -356,   -427,   -686,   -215,
      2752,    395,     -9,   -345,    117,   -122,   -327,     92,
       107,   -106,     32,    270,    271,    171,   3138,    198,
       -46,    -70,     46,    502,     91,     77,    -19,    216,
        94,    122,    -64,   -392,    -31,  -2696,   -364,   -131,
      -315,    129,   -461,    229,    192,    236,    185,   -263,
      -173,     44,     24,   -267,    -40,   -177,   -149,  -2471,
        26,    113,   -183,  -1693,   -188,     48,     22,    -73,
        50,   -133,     58,    -70,   -173,   -308,   -442,   -188,
        92,    389,    -35,    167,    235,     66,   2593,   2435,
       244,    630,    -22,    235,    112,    -32,    533,   -158,
        81,     71,     44,    -59,   -158,    -23,     28,   8192,
       -58,   -181,     39,    220,    -54,   -124,    -59,   -277,
        71,     41,    -82,   -157,  -6860,     -4,     44,    -84,
       -48,    134,   -193,    159,    -45,    218,    -47,   -133,
       147,   1749,    765,    -84,    184,   -317,   -286,    -17,
      -340,   -262,   -244,    -21,   3122,    290,   -127,   -119,
       179,   -128,   -125,   -439,   2766,   1917,     85,     57,
       -32,    373,    -16,    170,    -74,     31,    425,    626,
         1,   -511,     64,    387,    142,   -621,    183,   -224,
       220,   1195,    386,  -3360,    332,    484,  -1112,    -96,
       187,     43,   1838,     39,    -36,     13,   -132,     -8,
        -1,    -43,     29,   -132,    -19,     10,     10,   -218,
     -3659,    119,   -103,    -27,    -29,   -108,     13,    181,
        39,   -117,     92,     37,    -17,   -198,    330,    538,
        17,    113,   4758,      1,     28,    -10,     87,     22,
        96,    -14,    -99,    -56,   -130,      0,    -55,     45,
       -63,  -2845,   2751,    464,    -31,    -62,     76,   -154,
        88,     81,    125,    373,   -348,    587,   -314,   -278,
       -53,   2039,   -516,   2437,    191,   -212,     87,     -2,
       181,   -242,    117,     23,    -63,    334,    145,    454,
       343,   -235,     91,     69,     -8,      2,   -106,   -108,
        -5,    137,   -168,  -7818,   -231,     25,     37,     75,
      -138,     56,    142,   -596,    130,   -114,   3293,   -366,
       290,    160,     -2,   -219,     83,    843,    -18,   1289,
      -177,    226,    667,    252,   -683,    816,     26,    157,
       168,   -487,    -49,  -3282,    432,    184,   1207,     23,
       164,    544,    965,     -1,     61,   -118,     92,   1359,
        89,  -3234,     15,    496,    244,    177,   -613,   -160,
       -23,   -195,   -111,   -372,   -115,    278,     96,     77,
     -2567,     49,   -423,   -468,     13,   -484,   1345,   -298,
       194,   -123,   -248,   -139,    738,    102,   1154,   -335,
      2694,   1326,    213,    758,     17,    154,    609,   -518,
      -367,    201,   -144,     61,     66,   2288,     50,   2688,
       -87,     45,    -13,   -101,    127,   -190,    -40,   -286,
         6,    121,     32,     31,    119,    -85,     28,     93,
      8192,    273,    169,     44,     37,    255,   -224,    219,
       -34,   -127,   -134,    165,    169,    126,   -188,    -52,
        98,     15,  -5820,   -193,   -331,   -395,     -1,     49,
      -187,     55,   -121,   -196,    114,     10,    258,   -145,
       -14,   -385,    105,   -187,     59,    383,   5322,    147,
      -110,    -69,    378,    138,   -352,    -69,     15,   -267,
        75,    162,     -6,   3148,    515,    231,    -74,   -436,
      1288,   1234,   -105,     68,    -96,   -166,    -49,    -64,
       144,    -67,    135,    258,    -71,   -162,    156,   -366,
        -7,    -67,   -133,    -20,   -119,     71,    -84,     31,
        26,    116,  -2237,    212,     43,    380,    -74,     13,
        -7,    774,  -1276,   -103,   -124,    -48,   -178,   -319,
        26,    435,   -111,    858,    295,   1601,  -2727,   -242,
         8,     36,    -61,    -20,    -19,    -19,     31,    258,
        21,    -14,    381,   -153,  -8192,    -99,    327,     72,
       175,  -1181,   -271,    104,    -30,   -135,   -169,     21,
        29,   -182,    -25,    125,    165,    -82,     73,    -26,
      2311,    -85,  -2983,   -125,     85,   -206,   -100,   -100,
        36,     -3,    -77,   -180,     35,      0,   -170,    123,
       168,   -302,    366,   -334,   2936,    -70,    404,  -2870,
        13,     79,    226,   -163,   -242,   -124,    -40,   -171,
      -109,    189,     20,    -52,    144,  -1869,    -88,    230,
        -8,    -27,     45,    131,    -11,   -188,     93,   -227,
      -452,   -229,    158,    377,     -9,  -1736,     16,   3268,
      -164,     41,    305,   -414,   -642,   -111,   -100,    118,
      -155,   -236,    936,   -114,     51,     31,     60,   1299,
         5,   3048,    274,    273,   -197,   -289,   -245,   -288,
      1927,     -7,     27,    307,    174,   -243,    -95,   -134,
        14,     24,   -119,   -132,  -2811,   -254,     35,     95,
        22,    135,     21,   -155,    -80,   -143,    -60,     -6,
       182,     77,     11,   -197,     -8,  -6080,     28,    155,
        11,    -27,     22,    -48,     -8,    -50,   -122,     11,
       -34,    342,     -1,     40,   -208,    117,    -35,    -69,
       150,  -3944,   -425,     46,    456,    182,   -451,   -219,
        38,     15,   -203,    766,   -232,    243,    -70,    179,
      2107,   -222,    346,   -166,    143,    239,    245,     59,
      -137,     17,    475,    -68,   2679,   -423,     20,   -313,
        74,    152,    171,   -269,     68,     39,  -4743,     94,
        -3,    110,    134,   -168,     73,    180,   -116,    276,
       -74,   -203,      2,    -83,     17,    170,     96,    169,
        75,  -5541,     46,     20,   -168,    -22,     35,    -74,
       104,   -153,    264,      4,    -57,     94,   -192,    161,
        15,      7,     45,   -186,     15,   -125,    121,  -4981,
      -254,    179,    282,     72,    543,    -97,    363,     -5,
       -67,   -389,    -66,    178,    427,   -276,  -2675,    447,
        -2,   -125,   -223,   2869,   -502,    117,   2017,    -71,
        41,      9,    124,     19,    357,   -562,     25,   -385,
        80,    -53,   -175,   2532,    -73,  -2990,   -164,     57,
      -128,   -254,     53,   -150,   -180,     16,    -45,    322,
       266,  -2418,   -264,    317,    371,      5,    197,      7,
     -2476,    -93,    152,     90,   -165,     11,   -259,    -24,
       -55,    -16,     98,  -4904,   -116,     53,    205,    -45,
       -57,    116,     75,    161,    -55,     97,   -292,     27,
     -1396,    105,   -127,    133,   -265,    -33,      5,  -3622,
        25,     -3,   -104,      8,   -283,   -229,    236,   -208,
       145,    627,   -240,    118,    296,    108,   -309,     48,
     -3345,    582,    498,    259,     20,    785,   -138,    421,
        97,    370,    161,    141,  -2793,    106,   -246,   -140,
      -172,     42,   -194,   -202,   -319,   -107,    -24,    423,
      7293,   -109,    -13,   -242,     55,    171,     13,    -93,
       131,   -141,     88,    132,     76,    176,     78,    153,
       -63,    -55,   -410,    -39,      6,     27,   -223,   -174,
        61,    645,    167,    -35,   3079,   -173,    950,      1,
      -109,   -118,   -106,     15,  -1345,    -14,     50,    -70,
       -69,     24,    109,    182,     84,     31,   -179,    -93,
     -3152,  -3013,    -60,     56,    -60,     58,    166,   -161,
        24,    129,      1,    181,    128,    -12,    273,    -43,
     -1256,    134,    159,    -36,    175,     43,    -49,     41,
        48,    -38,    -45,     59,    -36,    -82,     48,    -74,
      -104,   2944,   -124,    -24,     98,    248,   -146,   -231,
      -241,     72,   -114,    776,   -498,    242,   -357,    250,
      -102,   7121,    109,     11,     94,    -53,     37,    -37,
      -133,     24,   -157,     47,    -46,    -69,     62,    -79,
};

static const int16_t cb1616ss0[] = {
      1401,    373,   -516,    330,   -711,   -752,   -475,   -224,
       139,    492,   -556,   4629,   1039,    333,    872,   -542,
       474,   -360,   -378,  -3459,    254,   1199,    113,   -525,
     -1705,    231,     46,    188,    -50,  -1038,     32,   -198,
      -109,    619,   1071,  -1601,   1002,   -411,   -189,  -3276,
       615,   -468,   -467,   -275,  -1286,    736,    541,  -1107,
       423,    191,    439,   -205,     17,    -87,    500,    176,
       262,   -341,   -142,    268,   8164,     -2,    112,   -190,
       227,    -50,   -143,   -326,    647,    601,    482,    443,
      2761,   -497,    979,   -298,    454,  -2927,    746,   -735,
      3921,    480,   -167,   -317,   1303,    111,    216,   -961,
       110,   -595,    244,    246,   -222,   -205,     46,     61,
      -798,    258,    360,  -7038,   -654,    -95,     75,    498,
       -24,   -250,     71,    138,    527,    240,   -215,    250,
      -408,    552,   -325,    333,   -989,   2648,   -483,  -1121,
      2344,  -1647,   -116,   -901,    615,    327,      1,    497,
       411,   -138,    332,    281,   -145,    337,    163,  -7379,
        70,    265,    365,    238,    604,     99,   -149,    233,
       109,    827,   -704,   1367,   1208,   -717,    -17,   -223,
        15,  -3259,     53,   -485,   -631,    285,    511,     -8,
       242,    547,    129,    145,   2046,    520,     44,   -177,
       382,    283,   -169,   -346,  -2737,    294,  -1311,    145,
      1873,    815,   1078,    677,  -3419,   -434,    484,    144,
       -27,    669,    153,   -242,   -242,    814,    350,    361,
      -462,    -63,   2317,   1259,   -373,   -489,   -534,    300,
       867,   2621,   -117,   -168,   -414,   -239,    812,    840,
       112,   -463,  -6286,   -693,   -830,    140,   -168,    448,
       549,   -149,    418,   -105,    137,     31,    -40,    -43,
       422,    -99,    297,      3,   -220,    -15,     81,     45,
      -647,   -535,   -448,   -731,    250,  -6742,   -320,   -350,
      -192,   1540,  -1112,  -1043,   1317,  -1203,   1035,   -506,
       673,    721,    854,  -1487,    780,   -294,   1173,   2142,
     -8192,   -170,   -138,    -54,    -54,   -233,   -127,    145,
      -233,   -185,     87,     20,    530,   -305,    141,   -394,
       310,     40,    645,    809,   4801,   -186,   -432,   -451,
       312,   -144,    -65,     65,    135,    -64,    -15,   -357,
     -3546,  -1299,    216,    249,    261,   -207,    117,  -3138,
       527,     14,   -142,    286,    100,    340,    581,    157,
       234,    739,  -2521,     -3,    639,  -1440,    131,  -3796,
       159,     39,     41,   -659,    284,    165,   1100,   -346,
      -481,    295,    806,   -227,   -288,   4520,    253,    487,
      -252,     88,    -43,  -1612,     -5,    -57,    -66,     18,
        19,    557,   -337,   1526,  -2897,    144,    844,   -404,
      1976,    787,    246,    264,   -406,    778,   -918,     51,
      -113,   -235,    518,    602,   -307,  -2046,   -692,   2775,
       400,  -2165,   -184,    139,    403,  -1855,  -1317,    289,
       710,   1124,   1888,   -517,    276,    190,    637,   -441,
       717,    972,   -370,    478,    626,   -354,    241,  -3651,
       145,      7,   -738,    397,    991,   -343,   -826,    142,
       672,   2425,   -616,  -3278,    751,   -193,   -944,    -35,
     -1061,   1258,    631,   -721,    145,   -112,    -69,    828,
       -39,   -196,   -237,    -73,    771,   -195,    239,   -533,
     -1673,   3477,   -559,    104,   -647,   -798,    167,   -497,
      -559,    591,    259,    300,    -25,    422,     93,     39,
       -63,    233,    144,  -1170,    142,   -456,     73,    411,
      6920,   -338,   -307,    436,    143,    420,    152,     -9,
     -1788,  -1096,  -2998,   -727,   -524,    128,    460,    782,
      -102,   -576,   -138,   -976,   1035,  -3196,   -436,    -27,
     -1047,  -1389,   3244,   -143,   -883,  -1012,      4,    327,
        16,    411,   -497,   1444,    516,   1183,    252,    510,
      -698,   -676,    569,    -70,   -397,   -227,   7829,    312,
      -410,     20,     41,    -65,   -219,    175,    297,     40,
     -1534,   -498,    194,    871,    409,    280,   1098,  -1471,
     -2825,    931,   -105,   -545,   -801,   -795,   -372,     73,
       331,    100,    488,  -2101,    560,     44,    885,   1065,
       380,   -195,    276,    124,    -87,    193,   3979,     30,
        95,   -509,   -931,   2737,   -457,    805,     10,     53,
       -73,   -203,   -587,   -177,    242,    238,    656,  -3403,
      -380,   2364,   2902,   -226,    204,   1559,  -2219,    -40,
      -442,    111,   -703,   -424,   -252,   -241,    461,    749,
       658,   -481,    125,   -366,    601,   -246,   -286,    132,
       297,   -232,   5231,   -141,    196,   -121,   -235,    406,
      -199,   -174,     87,   -107,    363,    272,   -563,   -620,
       235,    223,   -627,   -339,   -467,    349,  -1596,  -5496,
       644,    -96,    -81,   1938,    749,   -160,  -1976,  -1436,
     -1056,  -1045,  -1098,   2327,    976,    -57,   -124,   1139,
       275,   -209,   -636,    298,   2484,   2764,    962,    -39,
       108,   -718,   -442,      9,    797,   1123,   1092,   1179,
     -1170,   -701,   -381,   -237,  -1266,  -1045,   -337,   -351,
      -274,   -981,   -272,   -111,  -3409,   -387,    421,   -406,
     -2123,    623,    -18,   2473,    617,    176,     26,   1402,
     -1351,    212,     23,   -172,    296,   1572,    -63,   -402,
       837,   -521,   2209,   -613,   -329,   -309,   -180,  -1152,
      -535,  -1380,  -2617,    475,    385,   -672,    182,     92,
     -2211,    320,    109,   -633,   -582,   1208,  -1536,   1009,
       896,   1991,   -374,   1750,  -1259,   -341,   1774,   1063,
       678,  -2084,    987,   -337,     48,   -205,    -82,   -288,
       388,    217,   1263,   2427,  -1472,  -1073,   -964,   -836,
      2086,   -161,    438,   -449,    -37,   -926,  -3706,    164,
      -372,   -616,    160,   -572,   -725,    727,     11,     53,
       -84,   7494,    -74,    523,   -172,    464,    452,   -426,
       803,    106,   -262,     32,    298,   -491,   -181,   -760,
      -908,    303,    747,   1316,    272,    906,    767,    105,
       247,   6120,    948,   -557,   -928,   -595,   -342,   -450,
       686,   -815,  -1243,   -157,    572,   1414,    166,   -229,
      3317,   1940,   -283,    623,   -781,    717,   -212,   -707,
        30,   3635,   1147,   -696,   -928,   -637,    925,    797,
       843,  -1359,    214,   1096,   1031,    852,    -84,   -228,
       -34,   1067,  -1109,    392,    292,   -755,   3495,    -40,
     -1806,   -637,   -236,   -602,   -264,   -147,    -68,   -233,
       -55,  -2005,   -271,   -647,    963,    309,     -5,     56,
      -275,   -398,     34,   -496,   2556,   1249,    -87,   -112,
      1663,   -554,  -1926,    627,   2515,  -1128,   -566,   1539,
       740,     38,   -614,    272,   -232,   -152,   -782,   -420,
      -304,  -2313,    -33,   -944,    -77,  -3468,    -69,  -1730,
       -21,    665,   -314,  -1640,    660,    661,    106,    -21,
     -1505,  -2888,   -427,   -866,   -666,   3128,    786,    -55,
       739,    112,      8,    567,   -602,   -350,    165,    108,
       767,     64,   -715,    980,    673,   -186,    768,   -545,
      -298,   -233,   -524,    -70,    511,  -2051,   3816,  -1104,
       529,   1012,   2577,    777,    342,   -387,   2730,    247,
       -20,   -227,   -432,   -263,   -885,  -1192,   -644,   -259,
      2314,     38,    108,    614,   -386,    470,    -78,    681,
     -3334,  -1049,   -300,    177,   -174,   -422,    110,   -641,
      -406,   -472,    468,    885,   -730,   -877,  -1972,  -1372,
      -410,    545,    543,   -800,  -1156,    279,   3290,  -1305,
      -213,   -262,   -832,   -994,  -1110,    718,   -364,   1416,
        -7,    963,    452,    680,    165,  -3815,    903,    806,
       149,     11,  -1332,   -622,   -451,    152,   -618,   -309,
       246,    435,  -2098,    487,    469,   -451,  -1574,   -204,
      -187,    552,   -333,    515,   -331,   1452,    278,  -2691,
      -146,   1009,    353,   -839,      6,  -3206,  -1080,   -572,
     -2698,    752,  -1726,   -318,    397,   -152,   -128,    -77,
       -36,   -506,    456,   1094,    281,   -158,    -19,   -149,
        48,  -2831,   2042,   2545,   -161,    619,   1129,    274,
        24,      1,    313,   -164,    655,    157,    770,    182,
      1942,    241,   -898,  -1748,   -589,    256,    322,    683,
       -65,    -73,    621,     74,   -317,   2585,    185,   -465,
};

static const int16_t cb1616ss1[] = {
     -3218,   -607,   1665,   1100,   -563,    421,    377,    445,
      -270,     -3,  -1503,    224,   -593,   -316,     31,    362,
      1186,    389,  -1817,    589,  -2842,    289,  -1925,   -356,
      -228,   -148,    618,    135,    358,    238,      1,   -767,
      -266,      1,    101,    245,    231,   -167,    408,      1,
       162,    -35,    241,    215,  -4702,    486,    546,   -339,
       349,   -292,   1342,   -881,    184,   -675,   2639,   -284,
      -995,    346,   -499,   1499,   1616,    578,    445,    -78,
       844,   1800,   -686,   -414,  -1425,    795,    754,  -1418,
      -178,  -2226,    515,   -143,     43,    569,    967,  -2333,
     -1991,    282,    528,   1410,   -377,    736,    394,   -230,
      -365,   -242,   2773,    136,   -738,    -36,  -1171,    -76,
      -132,   -300,   -223,   -680,   -416,  -2738,     93,    414,
       490,   -346,     75,  -1089,  -1132,   2237,   1844,    395,
       325,  -1514,   1913,  -1850,   1162,   -442,    689,    -66,
       -71,    -83,    342,   -197,   -940,    206,  -3381,  -1275,
      -423,    -87,   -455,    498,    865,    355,   1225,   -115,
     -3333,   -404,   -588,   1021,  -2180,  -1470,   1225,    728,
        59,   2592,   -335,    194,   -649,   3586,   -951,   -142,
      -947,    898,    -99,   -269,    977,   1520,    488,   -364,
      -253,    127,   2524,    849,  -1166,   -191,    627,    372,
       772,    145,    -21,    279,    402,   -863,  -2695,   1217,
      1543,   1005,  -1419,   1712,    110,  -2191,    969,   1563,
       183,    811,   -218,  -1078,   -220,  -1092,   -322,    803,
      -533,   -359,    405,    -70,   -771,   -267,  -4730,    235,
      -607,   -387,   -285,    -68,     48,    -60,   -222,    229,
     -1087,  -1261,  -2249,   1265,  -1624,    864,    -65,    223,
      -322,    337,   -262,  -3170,    -12,   4571,     19,    198,
       458,  -1029,   2560,     -3,   -115,    619,   -645,   -836,
      -399,    246,    -81,    -12,  -1057,  -2119,   2780,     25,
     -1559,    291,    592,   -513,     62,    157,    553,    570,
      -657,     72,   -118,   -284,   -454,   3853,    145,    259,
     -1709,  -2161,  -3167,    189,   -233,  -1099,    141,    114,
      -506,  -1012,   -775,    474,    331,    798,    469,   1915,
        96,   -266,   -385,   -329,   -658,    192,     16,     97,
       -47,    284,   -163,    200,    189,     18,  -7453,    160,
     -2988,   2725,    520,   -132,   2593,    627,   -694,    -26,
      -558,     44,   -209,     40,    377,    491,    -68,    384,
       271,   2117,    642,   3166,   -569,    702,    513,  -1858,
       108,    944,    248,    166,    681,    408,   -908,    525,
      -145,   1035,    189,   2812,    135,   -356,  -2551,    401,
       150,   -508,   -265,    244,    461,    958,   -233,   -204,
       744,  -1603,    397,   -229,   -174,    539,   -139,  -4473,
       837,   -310,    253,   -635,    397,    -80,    601,   -371,
     -2015,   -261,   -364,     50,    331,     89,   -938,    709,
      1444,  -2910,   -228,   -162,    419,     62,   -319,   -266,
       584,   3728,     57,    220,   -543,    768,   -630,    361,
       361,    642,   -313,    182,   -488,    -48,   3001,   -397,
       640,    179,      8,   1081,  -1161,    -58,    -70,    -64,
      4456,    323,    883,   -191,    -16,     61,    419,    429,
       627,   -898,   -883,    750,    499,  -1335,   -467,  -1410,
        -5,    283,   -301,    276,  -1636,    310,    114,   -428,
     -8192,     12,   -114,     74,    215,    511,    317,   -314,
       -86,    198,    138,    315,   -271,    246,   -363,    426,
       608,   -714,    367,  -1356,  -2217,   1178,   -385,   1442,
        28,   -642,   -371,    -87,  -2895,   -710,    303,   -150,
      -398,   -868,  -1727,   1548,    982,   1177,    332,   -377,
      1580,    962,  -1028,   1922,   1494,   -824,     93,  -1362,
      -552,   1641,  -1729,    228,   1054,    421,   -185,   -536,
        51,     87,   -204,     88,   -847,   -754,  -3761,  -2706,
      -138,  -1242,     35,     64,    418,   -460,    713,   3960,
       733,    468,   -150,   -823,   -211,   -674,    366,   -269,
       180,   -294,   -384,    604,   1829,   -121,    271,    241,
       192,   -211,  -2672,  -1483,  -1102,    960,     90,     49,
     -1144,   2552,   -887,    -32,   -301,     62,   -183,    193,
        78,   -781,    193,   -606,   -285,  -3082,    240,    392,
       704,     20,  -1103,   -195,    166,    577,   -105,    -45,
      -310,   -106,   3035,     28,   -369,    725,     53,     87,
      -232,   -191,      7,   -282,   -572,  -8192,    325,     99,
       162,   -113,   -237,   -209,    412,   -573,    295,   -389,
     -1603,    -66,   -485,   -867,    466,   -882,    862,   -216,
       221,     50,    -51,   3927,    557,    441,    223,    234,
      4048,   -173,    420,   1670,    436,    341,    175,   -441,
      -201,     75,   -549,    315,    172,    418,   -159,      7,
      2973,     -3,   -220,  -1360,     26,   2781,    132,    295,
       -15,    217,   -166,    187,   -282,    357,   -121,    480,
      -216,    294,    263,     95,  -7367,    589,    -63,   -412,
      -103,   -201,    335,    -96,   -203,    240,    223,   -435,
       366,   -467,    118,    528,   -472,   -559,   -417,   -189,
      -641,    339,   1546,  -2741,   1413,   -265,    637,  -1556,
       -49,    422,   -195,    392,    -21,      3,     -2,    282,
      -130,   -272,   -483,   -860,   -675,    762,  -1455,   5212,
       178,    197,   -468,    270,   -310,   1038,    406,   2699,
      -537,    -33,    272,    225,  -1986,   1295,   -857,  -2906,
      -904,  -1861,   -206,    866,   -145,   -207,    252,   -825,
      3051,  -1361,   -441,     85,   -186,   -127,    139,    285,
      3067,   -332,   1163,    248,   -483,   -177,    268,    691,
       733,   -104,    -54,   2541,  -1042,   -226,    165,    250,
         7,   -259,   -383,    327,   2164,   2272,   -750,   2482,
      -930,   -139,   1203,    766,    150,    320,    970,     28,
     -1351,    467,    544,    521,  -2908,    -75,   -902,    611,
       575,   1216,   -209,     -7,    541,    330,    528,    347,
      -185,   -306,   -432,  -3384,  -1844,   -380,    155,  -1230,
       629,  -1085,   -413,    119,    114,   1093,    198,    806,
       491,   -137,   -518,    536,    -64,    387,  -1712,    608,
       -24,   4961,    149,    299,   -342,    505,    503,   -387,
      -944,   -297,  -2423,    -98,  -1027,   -432,   -259,    736,
       127,   3561,   -473,   -623,   -751,    114,   -438,    657,
      2448,    863,   -413,    -81,   2066,    988,   -539,   -528,
      -111,    314,    390,  -1228,   -863,     19,    763,   2227,
      -844,    -24,   4164,    139,    130,   -111,   -630,   -428,
       538,   -606,    940,   -877,    122,    526,    194,   -104,
       127,    117,    907,   -789,   2865,    526,   -548,   -253,
       289,   2329,    176,    -70,    775,    681,     21,     38,
     -1481,    766,   2093,  -2974,   -289,   -571,   -445,   1833,
       333,    -84,   -243,   -413,    188,   -492,    -22,   -867,
       605,   -333,    904,   3192,    -29,    491,   -411,    370,
      -556,  -2671,   -294,    132,   -243,   -233,    180,    181,
       383,    -79,     26,  -3539,    642,   1127,  -2125,   -170,
      -386,   -135,   -703,   -290,   -157,   -444,   -885,   -341,
      -920,    460,   -407,   -176,   3153,  -3084,   -505,    543,
         7,     79,   1191,   1148,   -401,    -17,    289,   -735,
       300,   1971,    626,   -146,    110,  -1281,   -613,   -649,
      -206,   1850,    701,   1138,   -803,    742,  -1392,    147,
       554,   1861,   -658,  -1481,    108,    856,   1021,    574,
      3314,    518,  -1156,   -307,     42,    -92,   -132,    278,
      -352,    -37,     35,    146,    -93,   -662,    216,    125,
       823,   -876,   -170,  -5027,    444,   -182,    844,    189,
      -490,  -1441,   -335,   -907,   -173,   1138,   -472,  -1505,
     -1641,    648,     66,    627,     64,  -1096,   -620,   1588,
      -506,    309,   -100,   5702,   -555,   -157,   -179,    -85,
      -299,   -114,    -20,    178,    415,    118,   -581,   -132,
      1025,  -2631,  -1154,   2623,   -286,    201,    340,    949,
       235,    171,    649,    328,    397,   -142,   1369,     -7,
      2305,   -373,    658,  -1681,   -744,  -3574,     34,   -183,
      -504,    165,     81,     21,    635,   -307,    428,   -520,
       164,  -4701,    744,    249,   -844,     -7,   -334,     38,
       539,    267,   -213,     73,    134,   -251,   -248,   -923,
};

static const int16_t cb1616sm0[] = {
     -4119,  -2861,    -76,    -49,   -192,   -542,      0,     94,
      -550,      6,    601,    236,   -446,   -202,    167,    238,
      2609,   -688,   -406,    265,  -3078,    321,     59,   -601,
       157,    200,   -265,     78,   -699,   -679,     18,    -54,
       203,   -687,   2683,   -111,  -3037,   -627,   -493,    413,
      -480,     54,     75,    276,    206,  -1861,     17,   -420,
      -169,    312,    361,   -277,    -12,   -363,   -592,    758,
      -123,   3267,     78,   -862,     81,   -356,    596,   -536,
       729,   2239,    -49,    553,    112,    444,    652,  -2990,
       -70,   1084,   -436,     34,     53,    -10,    -23,     41,
        -3,   -126,    207,   -130,   -208,     63,    480,    191,
      6229,    -45,    -33,    -82,     35,     56,    259,      1,
      8034,    -97,     52,   -159,   -334,    -41,     50,    -57,
        56,   -194,   -567,   2050,    146,    987,   -383,    416,
      -258,   2846,     51,      8,    690,   -126,   -704,    316,
        16,     -4,    -90,    159,     34,    126,     65,    218,
     -7037,   -261,    -87,    -21,   -185,     14,    112,     42,
      -164,    274,   -269,   1138,   -208,    574,    589,   -143,
      -479,   2745,    782,    -13,  -2492,   -132,    498,   -406,
       260,    828,   -580,    558,  -2861,   -600,   -447,   -313,
      1316,    800,   1772,   1131,    323,    -48,  -3972,    697,
         5,   -403,     46,     95,    130,     84,    -39,    219,
       117,   1629,   -189,  -1371,     25,   -116,   2311,   -681,
      -411,   -685,  -1340,   -409,    223,   -462,   2530,   -816,
     -1118,    314,   -893,   -109,   -262,    376,  -2795,    -48,
     -2878,     -6,    180,     53,   -500,   -181,    125,   -291,
      -265,   -154,    -23,   -184,    185,   -563,  -1159,    675,
        24,   -213,    273,  -2905,   -242,   2373,     -6,   -166,
        92,    276,   1375,    -28,   1879,   2572,    205,   -121,
        51,    356,   -873,   -308,  -1060,    952,    719,    456,
       106,    116,   -107,   -211,    -21,   3319,   2109,   -172,
      -172,    143,   -718,   -138,   1135,    232,  -1361,    157,
       -99,    522,  -4367,     84,    605,    319,   -937,   -397,
       117,   -434,     82,    633,    274,  -1555,   -221,    -59,
     -2419,  -2486,   -112,    136,   -182,   -480,     27,   -548,
      -237,    817,    530,    656,    252,  -2685,    -26,    703,
     -3268,    381,   -383,   -323,    105,   -500,     66,   -299,
     -1056,   -363,    -69,     21,    292,    398,   -379,   -106,
      -356,     38,    169,   2866,    206,   -523,   -277,  -2875,
      -582,    -69,    649,     -3,    198,    -30,     98,    145,
      -125,   -186,    -19,   -107,   -102,   -173,  -7299,    -62,
      -503,   -231,     24,    145,   1367,   -355,   -175,    373,
      -953,   -704,  -3454,    170,    899,    386,    592,   -754,
       620,     81,     86,    -65,     84,    683,   3054,   -280,
     -2825,   -757,     53,    -10,    441,   -145,    138,   1364,
        -2,    -92,   -300,    225,   -199,  -2087,   1095,   -363,
       -75,    288,    765,   -869,     -7,   3261,      9,  -2860,
      -330,   -382,   3309,     28,    629,    244,   -143,   -298,
      -512,   -409,   -241,    104,     -6,   -271,     -2,   8192,
      -137,    139,   -304,    -14,     81,    262,    -36,     51,
       380,     11,    101,    100,   -153,   2167,   -271,    267,
       306,  -3008,    579,   -277,    316,    327,   1168,     71,
     -1401,    389,    -25,   -265,    101,    -53,   -170,   -226,
      2861,    145,   3040,   -159,     77,    -16,    233,   -570,
       490,    661,    452,   1986,   -522,    212,   -107,    196,
      -247,    308,   -353,    186,  -2689,    486,    -46,    813,
       -24,    233,   -166,   3305,   2832,   -343,    -82,    475,
       267,   -385,     26,    -35,   -226,     27,    416,    231,
        12,     88,   -209,   -139,    404,   -239,   -109,   -182,
      -851,    260,    242,    109,     11,  -1096,     85,  -4226,
      -124,     12,   -139,   -100,   -604,    -87,     89,   5820,
        59,    -43,    -84,    264,   -543,      0,    428,    -16,
      -146,   -556,   -195,   -159,    875,     27,    261,    207,
      -182,   2367,   -622,  -3193,    481,   -289,     52,     12,
        34,   3014,     10,   -345,    -94,  -2883,    -62,    400,
       249,     51,   -178,   1190,   -128,  -3940,     41,   -296,
       -48,     13,    -26,    223,  -2392,    516,   -384,     33,
       -46,   -161,    -43,   -224,    -89,     -4,   -349,    135,
       540,   -120,   -276,   -198,    129,  -5113,    175,    -45,
       -34,   -109,    419,    -45,   -104,   -185,   -393,    416,
     -3514,    149,  -3088,   -115,    -78,    431,   -172,     21,
      -290,   -162,    216,     41,    -56,   -487,    705,   -194,
     -1003,    100,    172,   2793,    -83,   2584,   -189,   1198,
       551,   -119,    -73,    -91,   2103,   -619,    124,    128,
      2628,    192,    160,   -110,    270,   1739,   1062,   -568,
       -73,    -56,    328,    100,    384,   -173,     83,     39,
      -236,    -25,   -457,     53,  -6413,    345,   -459,   -110,
        28,   -127,   -109,   -593,     32,    141,   -879,    254,
      2132,   -410,   -623,   1103,  -2302,    528,    156,     28,
        81,    613,    602,    171,    500,  -2356,    620,     17,
      -523,  -2961,   -921,   -107,   -405,   -230,   -129,     18,
       363,   -881,   1282,   1427,   -363,    658,    205,    -51,
      2835,  -2003,    188,    -26,     73,   -231,    352,     74,
      -490,   -222,   2423,   -341,  -2762,    -14,    -56,   -260,
       -41,     33,    169,   -190,   1248,    -77,  -2322,   -607,
      3610,   -104,   -200,    -90,    -81,    719,    -52,   -359,
       394,   -301,     66,    -39,    -56,  -8192,     87,     56,
      -291,     50,    231,    284,   -211,    -16,    -86,    -84,
       -28,     52,      3,    -51,    304,   -224,    228,   -374,
       458,  -1958,   -210,  -2613,    401,  -2128,   -119,    -12,
       -60,    -14,  -8192,     53,     27,    113,    289,     -7,
        22,     60,   -192,    333,     72,   -344,    238,    147,
     -2235,    324,    124,    176,   -415,    450,   -476,   -558,
      -429,   -246,   -551,   -287,    672,   2145,   8192,    161,
      -165,    -34,    193,   -108,   -137,    -96,    -68,    156,
       308,   -182,      5,    438,    -71,    -27,   -164,    187,
      -110,   5786,    -82,   -130,   -126,    197,   -262,   -182,
      -118,   -110,    121,    -93,    235,    -56,    -99,   -212,
     -3013,   -193,    -10,  -2944,     58,   -135,   -624,   -170,
        84,    339,    115,    -85,  -1886,    250,    123,   -104,
      -374,  -2241,   2454,   -438,   -168,    632,   -136,   -725,
      -329,   -394,    -60,     19,   2795,    438,   -796,    141,
      -143,    132,    251,     37,    286,   1858,     39,   2381,
        -9,    -85,   -110,    149,   -415,    355,   -172,     -9,
      -149,    554,   -324,  -4931,   -537,   -261,   -585,   -291,
       764,    -92,   -139,     -8,    -80,     65,     -6,    -26,
       -81,     37,    -14,     45,    115,    171,   -321,    313,
       308,  -4637,   -128,   -120,   -174,    148,    768,    490,
        81,   -175,   -261,   -136,   1501,    345,     25,    -56,
      -212,   -324,   -836,    207,   -652,   -752,   2406,   -332,
       489,   -275,   -932,    284,   3103,   -315,    614,  -2711,
      1706,  -1072,   -163,    -75,  -1104,    163,   -421,   1532,
       -92,   -163,   -811,   -118,    -38,   -754,    466,   -314,
       232,   -595,   3613,    -30,    570,    -62,    785,   1626,
      1080,    553,   -407,     32,   -105,     82,   -156,    -75,
      8063,    -67,    114,    -65,    -65,   -242,     98,   -124,
        38,    441,  -2645,    -92,     69,     17,  -3284,   -278,
      -278,    116,    567,   -742,    182,   -304,    432,    261,
        86,  -4109,    389,    795,   -138,    151,    111,   -223,
      2392,    399,   -135,   -545,    182,   -226,     61,    234,
};

static const int16_t cb1616sm1[] = {
       -29,    -13,  -6217,   -136,   -196,     24,   -228,   -301,
      -155,    -37,    -54,    -91,     -4,   -130,   -424,    -89,
      -181,    657,    110,  -4526,   -391,    762,   1033,   -310,
      -808,   -282,   -721,   -690,    258,   -259,     16,   -555,
      2675,   -379,  -2580,    356,    198,   -455,     95,   -194,
      -754,    383,   -263,   -873,    271,   -107,   -191,    -28,
        11,    -66,     91,     25,   -215,      9,    152,     11,
      -124,     66,    422,    521,   5401,    103,   -179,   -291,
      -821,  -1265,   -396,    150,    -69,    -15,    154,   1504,
      -445,    116,   -136,  -3528,   2819,     -5,    174,    166,
       289,    -60,    158,   -701,     83,   -636,   -407,    194,
      -240,   -138,    124,    -94,    132,   -105,   -106,     72,
       139,    101,     97,  -7928,      6,    112,    164,    -83,
      -329,     41,    124,    389,    -22,   -194,    157,   -378,
     -2255,   -431,   3176,   -199,   -310,     49,    483,   -208,
      -235,     11,     45,    637,   1220,   2309,     93,    514,
     -1939,    136,    276,   -165,    137,   2496,     56,     31,
       238,   -538,   -433,    690,   -318,    -44,    834,  -1684,
      -132,   2619,   -157,   1959,   -566,    119,    183,    227,
      2066,    401,    -48,   1257,    604,   1306,    149,    273,
       586,   -199,   2166,    257,   2047,    -46,   -377,   -761,
       -25,   -454,  -1592,    -42,    432,  -2312,    222,   -528,
       -87,   -287,    532,   2906,  -2011,    720,    554,    423,
      -576,    425,    280,   -894,   -232,   -179,    485,    628,
     -2918,    405,    229,     -2,   -146,    127,   -329,   -243,
       194,   2443,   -531,    592,    -14,   1679,    292,   -914,
      -332,   2382,  -3040,    297,  -2856,    -88,    236,   -485,
       438,    241,   -283,    448,    579,   -660,    277,    233,
       201,    126,     15,   -411,   -560,   -582,   -389,   -392,
        -7,    238,      1,    344,   -216,  -4601,   -457,   1027,
      -114,     13,   -301,    288,    172,   -488,   -124,  -2721,
       100,   -105,    434,    -13,   2791,   -827,   1600,   -219,
     -4992,   -100,    411,    326,   -608,   -779,     94,    974,
       453,  -1326,   -236,    429,   -189,    830,     32,    187,
       459,   2489,    476,    165,   3261,   -445,    169,    179,
      -113,    168,   -393,     52,   -383,    -33,     73,    137,
     -6021,   -259,   -121,    -29,    -46,   -156,     68,   -225,
       217,    152,   -280,      7,     62,      3,     17,    295,
       221,   -158,  -5406,   -335,    232,   -454,   -320,    467,
       -45,     96,   -170,   -267,   1273,    287,    258,    536,
      -695,   -953,   1134,    428,    251,   3331,    717,   -804,
       627,   1099,    120,      4,     42,    191,     -9,    259,
      -335,   -337,    -25,    -56,    116,   -228,   -351,   -463,
      5942,    193,   -114,    -64,   -268,    300,    146,    -15,
       657,    367,     -2,  -2911,    838,   -251,     -1,   2897,
       -78,   -609,   -545,   -588,    488,   1383,    486,   1820,
       126,   2971,   -151,     11,     10,   -349,   -279,   -260,
      -265,    142,   -683,   -191,    172,     30,   -293,  -5103,
       -61,   -247,    -38,    722,    275,   -326,    -34,    132,
       297,   3305,    -46,    227,  -1052,  -1114,    562,     62,
     -1618,    699,    362,  -1624,   -455,    150,   -110,     61,
      -266,   -168,   -168,   -391,    136,   -569,   -772,   -203,
       467,     20,  -4747,   -170,    142,   -138,    129,   1719,
      1896,    210,  -1008,    206,    585,   -325,    295,    175,
     -2542,   -489,    121,    -94,    -38,  -2766,   -115,  -3206,
      -305,    320,   -179,    503,     83,    -72,   -122,    -52,
      -181,     98,     39,   -506,  -2751,    -93,     -1,    -59,
      2645,    248,   -309,   -203,    138,    324,   -567,    696,
      -493,    170,   2440,    919,   -420,  -3029,   -335,   -593,
       -72,    536,    -82,    202,     78,    510,    184,     -2,
       227,  -2830,     19,   1590,   -281,    387,    -46,    408,
      -463,   -536,    262,   2214,   -115,  -1614,   -385,    203,
        32,   -885,  -2606,   2338,     97,    292,   -449,    449,
     -1038,   -582,      0,    -68,    211,   -160,     62,   -286,
     -2466,   -421,    -48,   1903,  -1037,   -173,   1339,   -591,
       152,  -1231,    792,    524,    214,    -92,     29,    181,
      -225,   -150,     -1,    139,  -8135,    238,   -119,    189,
        34,   -140,   -188,    141,   -112,     56,   -176,    154,
        91,   5653,    298,   -316,    -23,    232,    -74,   -317,
        -4,   -630,   -506,    105,  -1655,   -126,   2417,    113,
       -95,   -472,    134,    290,   -755,    152,  -1222,    -58,
       981,   -236,   8192,   -154,     75,    218,   -185,    107,
       -10,     39,    265,   -225,    -87,      9,    123,   -906,
      -382,   2544,     44,  -1985,   -102,    407,    -91,  -1835,
      -108,    122,    142,    169,    134,   -721,  -1530,     -4,
      -133,     45,    374,  -1049,    -76,     16,   -357,    277,
       158,  -2596,     -4,  -1484,    -13,   2660,   -198,      9,
      -218,    408,    -63,    177,    -71,   -195,   4293,     -8,
       228,     34,   -421,    695,  -1409,     85,   2740,    350,
        44,    473,    141,    -93,    144,    -59,   -220,   -154,
      -148,   -168,   -205,   3049,    229,    194,   -107,     90,
      -353,    508,   -343,    473,   -446,    457,   -452,   -116,
      3493,    504,   2152,   -228,  -1832,   -463,   -657,    555,
       657,    540,    546,    604,   2214,    -68,    254,    563,
       267,    227,     92,   -107,    143,    260,     23,     42,
        64,    -67,    138,   -167,     72,    457,   4958,     61,
      -933,      1,   5341,    -32,     89,    161,    504,    823,
       311,     11,   -184,   -574,    -79,  -1654,    -74,   -366,
       164,   -363,    117,     53,    706,   -701,  -2966,    233,
        11,    165,    394,    462,  -2632,    703,   -291,    -65,
       -49,   4080,   -862,    -65,    -19,   -110,   -872,    323,
       833,   -154,    369,    475,   2211,     20,   -212,   1711,
       -24,    -28,    -58,     32,   1746,     41,   -779,    614,
       508,   3050,    687,    423,   -182,   -484,    -60,    242,
      3895,   -565,   -453,    110,    547,   -961,    320,    -34,
      -347,  -1963,   -116,    730,   -435,    -34,     41,     26,
       -51,   8192,   -115,    312,    184,   -148,   -199,    157,
       153,     82,     99,    138,    -32,    -19,    -64,   -139,
       107,     43,    133,    -87,     42,   -148,   7080,   -158,
      -335,   -249,    -64,     81,    157,    813,   -279,   2226,
       -16,   1191,   -705,    607,    205,    -11,  -1341,   -548,
     -2251,   -326,   -149,  -2536,    139,   -750,     73,   -394,
      -218,    -35,    181,    925,   -557,    226,    -63,   2582,
      -737,    164,    181,   -167,   -230,    413,    328,    406,
      -287,  -2992,    539,   1133,    -85,  -2162,   -154,   -357,
      -245,     -8,    162,   -118,    111,   1275,     47,   -314,
     -2043,  -2732,  -1052,    -28,    625,   -810,   -487,     40,
      -131,    273,    105,   2605,  -2974,    268,    -19,   -257,
       842,   -662,    855,    505,    590,   -243,     68,   6978,
       118,   -101,    349,   -232,   -258,   -318,    212,     55,
      -686,   -177,   -173,   -102,    480,     35,    149,    263,
     -2838,   -198,    942,    392,    135,   2980,     34,     92,
      -237,   -672,    224,   -298,    298,   2128,    359,    254,
       150,   -839,   1001,   3234,   -169,    261,   -302,     74,
      -277,    498,    321,    194,  -3275,   -152,  -2786,     33,
        70,    236,   -222,     88,   -393,     47,   -636,    869,
      -754,    842,  -2326,   -460,    133,      0,    264,    172,
     -2955,   -286,   -243,    399,    882,   -722,   -382,    872,
      -119,    -65,  -2403,   -119,   -246,   -890,   -185,    102,
       -32,   -573,    225,   3044,   -484,    -40,   -809,    403,
};

static const int16_t cb2224l0[] = {
     -3546,   -433,    -76,     46,     24,   -641,    214,    114,
      -779,   -930,    -57,   -462,   -569,   -848,   -413,     53,
        45,  -3172,   2915,   -734,    152,    487,   -113,    246,
      -196,   -187,   -136,    469,    475,    382,    213,   -886,
      -275,    313,   3148,    -62,   -773,    785,    -24,  -1499,
       -65,   -175,  -1942,   -325,     78,    -15,    -38,      2,
         6,    -29,    -16,   9690,    -15,    -49,    -13,     12,
       -21,     11,    -45,    -63,   -528,    192,   -137,    201,
       138,   -154,     57,    -88,  -1695,    155,    105,    121,
      4249,    -59,    467,   -439,   4483,   -130,    -39,    262,
       -21,   -377,    441,   -353,   -768,    366,     23,    841,
       529,    195,   2722,   2892,   -255,    -67,    628,   -498,
        33,    241,    212,  -1020,    -97,   -723,    594,     35,
       -31,   1459,     19,    -75,    -27,     -1,     48,     28,
       267,   -275,   3780,   -515,   -467,     36,   -405,   -272,
     -1968,     60,     44,    449,  -2877,   -124,  -1524,   1195,
      1042,    117,    115,   -305,    225,    215,   -357,    144,
        35,    -23,     89,   2133,      2,     65,    -27,    -48,
      -243,   -216,   -807,    700,   1258,      6,   -140,      4,
       -31,    -21,     42,     67,     97,     -2,    104,    -10,
     -7734,    134,    -50,    -95,    -88,   -269,    105,    -18,
      -229,    453,   1038,  -2609,  -2944,    -57,     27,    372,
        59,   -556,    -87,   -242,    114,   1083,   -119,   -139,
       175,    146,    -55,   1689,    342,    501,   2722,  -1273,
      1626,    868,   -290,   -145,     62,    194,    -23,   -179,
      1540,    -85,    360,    254,    339,   -681,   2081,   2730,
       838,   -128,     31,  -2133,   -173,    483,   -138,   2706,
      2007,     91,    293,   -642,     35,    280,   -132,    454,
       -66,  -6263,    -24,     82,    -31,    -39,      5,     41,
        66,    239,     18,    -57,     61,   -117,    103,     16,
     -1231,   1384,   -164,    104,    370,  -1891,   2237,   -440,
     -1399,  -1394,      3,    274,    223,    -30,    -70,    579,
       361,    423,    355,   -176,   -164,   -443,   -306,  -2382,
       713,  -2987,   -340,   -691,   1407,     -5,    439,   -264,
       -86,   1964,    -17,     88,    175,     56,   -119,     31,
       466,   1980,    176,    513,   1809,     17,   3000,   1861,
       -71,    314,   -255,   2041,    576,    203,    443,   -392,
      -539,   -380,   -685,   -204,   -161,    287,    378,   -502,
      1898,   1540,   1073,   2282,    573,    867,    122,   1064,
      -628,   -564,     97,    280,    -36,   1601,    -90,   -174,
       -10,     45,    -57,    159,   -496,    641,   -959,    -91,
       -90,   3057,   1680,    -83,     80,     19,     63,   -119,
         1,    -72,    466,   -335,    453,   -177,   3930,    -21,
       327,   -199,   -651,    -38,     -6,    -13,      7,    -77,
         1,      8,     40,   -125,     36,   -136,    272,   6266,
     -3299,   3331,     24,     18,    -71,      9,    -79,   -374,
      -277,    128,   -233,   -175,   -350,   -216,     81,   -693,
       -49,     33,    -44,    -37,  -4260,    -70,     96,    177,
      -319,    133,    178,   -377,    -45,    182,    156,   -155,
       -34,     10,     22,     53,   -211,      4,   5740,     48,
       -42,    114,    149,    -30,    122,   -106,   -309,   -148,
       -82,     20,    130,   2734,    -40,   -596,   1309,   1163,
     -1470,    396,   -264,    884,    142,  -1818,     67,     -1,
        38,    -52,    -73,      1,    279,    143,    278,    -45,
      1541,   -886,   -677,  -2609,    -88,  -3766,   -201,    237,
       -40,    195,    -50,   -366,     88,    166,    403,    236,
      -130,    205,    -45,  -8636,    -13,    -27,    -50,      8,
        40,     21,     41,    -36,    -25,    -40,    -14,    -14,
        42,    296,   2495,    372,   -361,   -501,   1951,  -2141,
       220,   -847,     98,    228,   -250,    563,  -1121,    -29,
      2888,   -196,    151,    -19,   -287,  -2298,     65,   -482,
      -124,   -186,   1215,    468,   -781,   -227,    621,    298,
       -42,    -44,   -115,      0,     50,    179,     23,      9,
       -65,     -8,     10,   -101,  -4998,     77,   1181,   -304,
       139,    250,  -2257,    -97,    847,    433,    385,  -2411,
       800,   -852,   -528,    435,   -953,    -23,      4,    928,
      -108,   -634,   -273,   -879,   2566,  -2609,    621,    807,
       295,    -77,    627,  -1114,   -297,   -109,   2103,    -53,
        -9,     44,     32,    339,    679,     77,  -3186,   -416,
      1234,   -801,    472,    408,    153,    465,   1703,    879,
     -2411,   -553,    440,   2099,   -899,   -288,    310,    665,
       -47,   -148,   1457,   3932,   -213,    243,  -1763,     -2,
       288,   -425,   -972,    478,   -302,    552,   -377,   -352,
       179,   -480,   1466,   2019,   2817,      5,    824,     13,
      -384,   -582,   -297,  -1165,    689,   -120,    703,   -118,
       663,    206,    -49,  -2853,    -76,     32,    170,     11,
        42,   -503,  -1139,   1548,   -287,  -1112,    765,   -455,
       -35,   2452,     22,   -134,    144,   1867,   -149,   2771,
        19,    264,    700,    -48,    286,   -593,  -2637,    408,
      2304,    -14,    187,   -135,   -210,    745,    282,    724,
       861,     21,   -414,    606,    836,   -564,    212,    203,
        64,   4706,    -30,    -43,    -85,    -61,    -90,    644,
      -281,    287,   -122,   -340,   -137,     36,     -4,    -22,
         8,   9486,     -3,      4,     10,      4,     86,     58,
        -8,      6,   -105,    -15,     15,    -63,    -58,    -30,
        15,      0,    -19,     78,  -8267,   -134,     -8,    -45,
       163,    -19,    149,   -298,   -167,     34,    190,    -39,
     -2229,   2821,    126,    185,   -791,  -1229,   1003,   -331,
       980,    659,    -60,    -60,    -48,     20,     12,   -167,
       -60,    -39,     66,    180,    -22,    -20,     84,   -108,
       131,    -10,  -8493,     -1,    -18,     -4,    -53,     25,
       -63,    -14,     20,     25,    -41,     40,     -5,  -2330,
       -74,     59,     -7,   -154,   -293,    -64,  -2702,    819,
        75,    977,   -602,   1138,    160,    262,     26,    -81,
        18,   5558,    118,   -167,     98,    110,     -5,    -44,
       -27,     72,     51,   -189,      0,   1868,    743,   -275,
      2530,      6,    180,  -1019,  -1307,    710,    303,   -152,
      -115,  -1498,   -501,   -495,   -103,    -76,     78,     -7,
     -9337,     -6,     31,    -21,     16,    -14,     57,     36,
       -81,    -67,    -30,   -535,    216,    313,    310,   -157,
      2830,   -914,    122,   1353,  -1842,    298,  -1165,    -13,
      -253,   -100,   -560,    -61,     40,     24,      3,     56,
       -18,   5709,     41,     13,    -23,    -55,    -98,    214,
       109,   -205,    -45,     27,    -26,    177,   -290,     89,
         8,   1315,   3102,   1657,    210,  -1032,    774,   -211,
      -581,    -51,    896,    852,    331,    349,   -474,   -119,
      -865,   -145,   2270,    703,  -1967,  -2088,    610,   -700,
       113,   -231,   2062,   -152,   -599,   -474,    -38,   -601,
       432,   -983,   -731,    744,  -2880,    156,   -240,  -1903,
      2497,    -89,   -963,  -2179,  -1208,    189,    318,    150,
       204,     29,   -167,   -138,    -93,     73,    292,  -3225,
      -310,   -510,    173,    -90,    154,   1831,    380,  -1191,
      -976,  -1460,   -514,    235,     13,  -2950,     22,    -95,
       228,     85,     10,    264,  -3165,     46,   -184,   -782,
       143,     -9,     37,     12,    108,    -65,    -64,    115,
        86,   5039,    -55,   -203,   -163,   -462,     77,    -92,
       423,    139,    239,     -5,   1887,    426,    729,    118,
      -159,  -2821,   -124,   2147,   -167,  -1023,     92,    -23,
       162,   -159,    -47,     -3,     14,    -34,     37,    -29,
       -97,     41,    -92,    -75,  -6983,   -224,    250,    -80,
};

static const int16_t cb2224l1[] = {
     -2888,   -183,   3606,      0,     33,     99,    -76,   -264,
      -351,   -508,   -546,   -103,    252,    -49,     46,    -32,
        48,   -245,     67,  -2408,    340,   3153,   -154,   -280,
      -440,    374,   -224,    -39,   -720,   -289,   -136,  -3095,
       -98,    -37,    -86,    145,     51,    132,    773,  -1158,
      -330,   -449,   -141,  -1831,    666,  -2680,   -110,   -906,
      -307,  -3299,    287,     55,   -521,   -173,   -431,   -383,
        67,    -28,     34,    247,   2814,   1479,     32,  -2196,
     -1625,    135,     72,      3,    634,     76,    502,   -306,
      -366,   -120,   -219,   1934,    372,   -130,   -113,    255,
       -14,     30,   -687,   -576,    797,    306,  -2360,   -242,
      2062,     69,   2273,     26,    -20,    -21,    -68,    -69,
     -4618,     60,   -171,   -235,   -271,    175,   -110,    147,
       100,   1628,   -197,     -2,  -4002,    520,  -1236,    -21,
        62,   -396,    513,   -369,   -168,    285,    561,    131,
      1347,     83,   -101,     89,    206,      5,   4556,    -23,
      1191,     39,    352,   -158,     99,   -195,    -33,    481,
      -446,   -125,    181,   2678,   2860,   -524,   -239,     55,
      -360,   -358,   -560,     93,    307,    285,     77,   -295,
       -90,    114,    -45,     54,   -328,     94,   -222,    -30,
     -5004,   -164,    100,    379,    208,    424,    -11,     26,
        10,    -26,    -32,    114,     30,     18,    -44,   -221,
      -184,    -32,      0,    -99,  -9001,     -7,    -33,      1,
        41,     -3,     13,      9,    -46,    -86,     47,     56,
        72,     -7,      5,  -1162,    101,    456,   -217,   3440,
      -220,    400,    100,   1503,    365,    655,   -230,     42,
      1129,    767,    192,    -16,  -3440,    -79,   -236,      3,
       -80,     51,    -11,   -984,   -142,     29,    554,    339,
      1851,    105,   -279,  -2915,    116,   3090,   -431,    233,
       337,     61,    927,     32,   -174,    237,    255,   -250,
       604,    115,   2036,     78,    -79,    -50,   -349,    338,
       285,    169,    394,    -49,   1194,  -2966,    447,     57,
     -2591,    415,   -586,  -2616,   -197,    -61,    596,  -1159,
       130,   -441,    356,     47,   1192,    496,  -1801,    -15,
      -142,    -23,    132,     21,     84,    234,   -137,     23,
      -147,  -3254,    407,    107,   1132,    130,     74,    153,
      3148,   2184,   -464,   1294,    222,    589,    457,   -397,
       -87,   -605,   -631,    311,   -703,    110,     20,    -23,
       -75,     18,    -43,   -182,      8,    -94,    151,   4989,
      -619,    662,     82,      8,     69,     -4,    126,    -35,
       -99,   -277,   -227,  -2212,   3188,   1115,   -467,   -618,
      -989,    681,    218,    -25,    -37,     -9,     32,    -46,
        97,     15,    -23,    -95,     -6,     55,     19,   7904,
       -14,   -508,      3,     14,    -12,    -58,     28,    154,
        11,    271,   -593,    344,   -336,   3489,    -41,  -2998,
       622,  -2739,   2796,   1536,    310,    176,   -318,    399,
       -70,   -298,   -509,    256,   -381,   -158,    322,   -197,
         3,    -53,     37,     98,  -6136,    -25,    -54,     57,
       138,    -74,    239,    -46,    -18,     29,   -265,  -2278,
        22,    110,    -21,   -147,    266,     85,   -286,    137,
      3434,   -485,     68,    475,     -3,    159,   -181,   -237,
      1595,    759,    786,   1490,    926,  -2841,   -160,   1092,
        -7,    130,    895,   -345,    -95,    -31,    -35,    139,
       -98,   2106,    305,    672,    -66,    349,    229,  -1561,
     -1694,  -1786,   -743,    -76,    -67,   1666,     76,     10,
       -22,     60,    -45,      5,    409,   -458,    583,   -405,
      2586,   -264,    175,    633,    842,   3208,  -1488,   -802,
        40,   -119,   -197,    -84,   1645,    328,    823,   -175,
       342,     12,   -217,     67,    124,   -180,   -106,  -2877,
      -336,    171,    185,    132,  -2263,    -75,   -622,   -631,
     -2404,    176,   -132,     35,    179,  -1498,    182,     68,
       699,    597,  -2728,    325,     52,    421,   -863,    609,
        53,   -159,    258,   -307,   2919,     44,   -826,   -467,
        91,    542,   1883,    815,   -682,    548,   -419,    593,
        82,  -2108,   -158,    -75,   -524,   2440,   -528,   -469,
       723,    -14,  -1817,   -487,    448,      4,   -155,    -70,
     -1715,     34,    -55,    134,      0,     19,    107,    419,
       334,     74,    446,   1241,  -4288,     61,    -65,     21,
        71,    133,      2,    -88,   -238,    322,   -283,     -6,
       404,     98,     78,  -1951,    412,  -1942,    418,    257,
       -42,  -2444,    -97,   1491,    464,    346,    229,   -154,
        96,    261,     29,    302,     39,   -201,    -40,    -98,
      -157,    335,  -3624,   -349,   -573,    633,   -116,   -312,
       -82,    263,     -2,   -101,    -57,   1817,   -424,      3,
      -245,    386,     74,    609,   2171,    -77,  -2604,  -1036,
      -117,   1585,     -2,      9,    -23,     31,    -12,     48,
       215,     84,     13,    219,    419,   -275,   4373,    -91,
        -6,     18,   2228,    -46,    157,   -408,   2288,    654,
      -725,   -245,    -10,  -1182,   1726,    324,    367,   3013,
      3429,   -140,    360,   -122,   -574,   -165,    109,   -330,
       -82,    340,   -133,    210,    355,     -8,     47,    -52,
      8064,      5,     60,    -42,    -95,     -3,     91,    -69,
       -47,    -42,    101,    118,    -44,    -16,    -14,     -9,
        27,      8,    -33,     -3,  -9302,     27,     49,     -6,
        61,     74,    204,    430,    252,   -259,     73,    125,
       366,   -458,  -2846,     89,  -2694,   -106,   -344,   -702,
       809,    451,     69,    585,  -1897,    608,  -1138,     52,
       618,    106,    771,   2992,    266,   1007,    184,   -486,
        36,   3317,   -311,     38,    105,    -89,     16,     97,
       -88,     28,    183,  -2834,    -44,    387,    -49,    467,
     -2524,     77,    -56,  -3727,     81,   -308,     63,   -137,
       203,    -77,    139,    254,    -65,   -264,    -58,    631,
     -2559,    739,  -1343,    595,   -117,   -193,  -2572,    322,
       267,    185,    669,   -110,    641,    212,     45,    -16,
        12,     14,     -3,    -12,     78,    -48,   -196,   -128,
       179,    146,  -7348,    177,   -138,    -48,    142,    -33,
        34,  -6037,     15,   -105,    103,    136,    -48,    217,
      -169,     88,    -31,      9,     24,     41,   1733,  -2757,
      -335,   1783,    988,   -161,   1014,    633,    -66,  -1114,
       525,   -266,    461,   1137,    -26,   -173,     89,     82,
     -3365,     67,   -198,   -107,     44,    352,   -793,    867,
      -807,   -166,    107,      4,     71,     61,    124,     27,
     -2477,    178,    -32,   -172,   2895,   1301,    798,    707,
       267,   -720,   -403,    167,   -157,   2572,   -210,    527,
      -312,  -1664,   -214,  -1556,   -332,    595,  -1634,    -58,
       203,  -1777,   -469,     24,    188,    -59,   -860,    879,
        15,    855,  -1534,   2910,    534,    -71,    276,    471,
        41,    -25,    105,    -37,   -150,    110,    226,   -277,
     -4687,    574,    139,   -152,   -586,     67,  -1082,    261,
       -68,     25,   -216,    110,     46,  -3703,    281,    355,
      -506,     80,   -218,    164,   -398,     75,    -97,   5782,
        39,    -68,     26,     76,     74,     38,   -103,    105,
        44,    116,    187,    288,     90,   5847,    -41,     28,
       -19,     20,    129,    -99,    258,     22,    -28,   -120,
      -101,   -121,     79,   -180,    -23,     22,     -5,    -60,
        63,     35,  -8987,    -11,      2,    -15,     -3,    -28,
        47,     29,    241,    132,   -166,   -259,    -48,    102,
        70,   2830,   3163,    285,   -813,      0,    105,    176,
      -455,    141,   1382,   -481,  -2282,   2971,   -200,   -473,
        37,   -930,  -1162,    930,    890,    412,    190,   -160,
};

static const int16_t cb2224s0[] = {
     -5789,   1229,   -138,   1010,    823,   -602,   -987,   -237,
        47,    -29,    428,    210,     87,    -11,    -20,   -261,
     -3148,   1219,  -2074,   -132,   -258,    707,   -634,    878,
      -486,    989,   -276,   -137,   -263,    592,   1248,    474,
      -293,   -981,   2125,   -653,  -1451,   -833,  -1522,    387,
      -269,    349,    698,    295,    870,    661,   1532,    202,
       654,    362,  -1265,   3972,   -651,    224,    213,   -728,
       -83,    575,   -503,   -766,    559,   -657,     86,    941,
      1498,    -72,   2297,   1413,   -376,    697,   -738,    384,
      -807,   -354,   1141,    374,   1186,   -597,    222,    630,
      -717,  -1653,    106,  -1377,   -929,    982,  -3469,   -321,
      -201,  -1185,   -147,    -13,    268,    103,   2967,  -2083,
      -416,    702,    377,  -1126,     92,    963,   -494,    -94,
      -436,   1893,   1401,    -40,  -1464,  -1608,   1980,     44,
       254,    676,    529,   -891,    -95,      9,   -172,   -129,
       158,   -403,  -1147,   1026,   -410,     86,   2593,  -1060,
      -621,    480,    254,   -780,    691,  -1020,     79,   -192,
     -2264,  -1219,   -748,    602,    243,    338,    550,   -444,
      -130,     79,     24,   3396,    124,   -572,    749,    976,
        33,   -883,   -368,   -609,    694,   -569,   -560,    192,
       868,    644,    173,     86,  -4302,    633,   7899,   -360,
       478,    493,   -306,     14,    244,     96,     71,   -169,
       336,    346,     74,    -52,   1779,    828,   -252,    739,
     -1005,   -755,     31,    -46,    200,    581,    -11,    802,
      1104,   3252,  -1053,    723,   -491,  -2492,  -2330,   -245,
       308,  -1021,   -312,    563,    -85,    991,    -16,    224,
       -85,   -957,   2262,  -4585,  -1475,    102,    310,    298,
      -875,     -6,   -268,      8,   -284,    324,   -471,   -224,
       133,   1502,  -1714,  -1095,   -104,    809,   2584,   -273,
     -1014,   -296,    130,    732,   -259,   -335,   -745,   -619,
      -716,    247,    503,    862,   -277,   -137,   -224,  -4897,
       124,    277,    298,    -40,    169,    678,    557,   4379,
       677,  -2016,   -506,   -108,    -47,     49,   -115,   -260,
      -300,    206,   1196,    -17,    202,    365,   -808,   -473,
      -160,   -609,    526,  -1124,   1629,  -2924,    713,   -487,
      -109,    540,   -511,    221,   -394,  -1420,   1023,   -460,
       424,    -86,   -875,  -1557,    -88,   -244,  -1597,  -3015,
       355,    166,    330,   -334,   -325,    505,   3632,  -1760,
      1626,   -427,    573,   1197,   -317,   -566,   -663,    460,
       338,   -442,   -597,   1565,   -854,   -534,   -219,   -128,
     -2175,    739,   1064,   2050,    -61,   -349,    361,   -375,
      1111,   -122,   -121,   -164,  -2573,    938,   1758,    -15,
       884,    865,   -630,   -573,    994,   1112,    -26,      9,
       -30,   3893,    -38,   1386,    605,    568,   -680,    117,
        37,    572,    245,    -53,  -1030,   -241,    397,    363,
     -1632,   -567,    -26,   -698,  -2109,  -1033,  -1389,   1381,
      -418,    402,   -534,      9,   1143,    991,    693,   2557,
     -1268,   1273,   -192,   1225,    876,    472,    835,    509,
      -452,  -1519,    482,   1103,   -626,   -299,   1580,  -1532,
       599,   2245,    503,   -110,  -1879,    978,  -1158,   -130,
      -665,    448,  -1247,    604,   -528,   -677,   -711,     78,
      -563,   -349,    -53,    261,    952,   -338,   -534,     43,
        -2,  -2555,   1976,   2393,   1715,    996,   5628,   1036,
       171,    -28,   -199,    -83,   -126,    -35,   -248,   -393,
        36,    209,     77,  -1793,    244,   -108,   -130,    -41,
      -578,  -2347,   -687,   1650,    131,   -138,    407,   -228,
     -1348,   -209,   -841,   1332,   -542,    220,   -193,    843,
      -103,    853,    261,   -653,    217,   -107,   -113,    -54,
     -4151,  -1303,   -287,   4065,   -376,    -71,     43,  -1481,
      -359,   -481,     78,    529,    689,   -194,    178,     60,
      -997,  -1555,   1687,    345,    169,    266,   2894,     83,
      -500,   -425,   -396,   -245,      6,    517,    112,    129,
       725,   -121,   -404,    234,     47,    -61,   -122,    710,
     -4283,    985,     56,   -105,    -45,   1043,    720,     73,
       321,   4452,  -1614,     91,   -620,   -299,    506,    766,
      -882,    650,   -138,    123,   -608,    210,  -1582,   -538,
       -62,    246,    464,   -332,  -1560,   2271,   1559,   -199,
      -832,  -1133,   -797,    341,   1860,   1628,  -1133,   -607,
       637,   -404,    437,  -1148,    542,   -474,   -882,   -610,
     -1340,   -159,   1524,   1424,    169,     -6,     52,    447,
     -5513,   -592,    244,   -294,     44,    164,    -51,    147,
       202,    -48,    139,    113,   -399,    -17,   -173,   -199,
         1,     17,   -166,     15,   -258,     -7,    238,  -5748,
      -394,   -852,   -248,    -46,    192,    -32,  -1033,   -349,
       151,    483,    130,  -1628,  -3391,   1527,    694,   -305,
       740,   -357,   -491,   -186,  -1649,  -1394,   -873,    213,
       652,  -1975,    319,  -1131,   -103,    -48,    673,    155,
      -627,   1115,    469,  -1122,   1901,   -184,   -237,   -296,
     -2887,   -120,    211,    835,     57,   -826,   1272,   -255,
      -937,    242,   -525,    836,   -334,    393,   -624,    111,
      -347,   -178,  -3441,    219,   -352,   1831,   -296,    587,
      -357,  -1099,      5,    313,  -3806,   -394,    814,   -118,
      -233,    -23,   -125,    -21,  -1414,    813,   -403,   2482,
       442,   -184,    934,    340,    472,    374,   1073,   -283,
     -2348,    477,   -387,   -713,   1071,   -899,    252,  -1299,
      -502,   -375,   -410,  -1785,    686,   -605,   -141,   -871,
     -1777,   2780,     53,   -237,   -237,   2701,    944,     44,
       595,      3,   1263,  -1558,  -2267,   -998,    221,    355,
      -319,   -739,  -1160,   -594,   2977,    191,    -41,   -284,
        83,    484,    481,    -73,    -13,    138,  -2761,   -909,
      -578,   -139,  -1056,    189,   -645,   -147,    -61,   -168,
       368,    130,    390,   4187,    101,     79,    -45,    451,
     -1374,  -1941,   -534,   -301,   -979,   -668,   -533,  -2978,
       386,    574,   -454,     -4,    554,   -120,    366,     83,
      1079,   -351,    156,    389,   7724,     83,    102,   -191,
     -1059,   -255,    -86,    451,   -211,    175,    774,    306,
      -253,   2386,   1166,  -2025,    223,    438,   1279,   1721,
       -23,    -91,    606,  -1285,   -775,  -3228,   -536,    543,
       877,   1140,  -1616,   -603,    550,   -678,   -462,    248,
       209,   -515,   -310,  -2538,  -2002,    231,   -495,    319,
       538,    509,   -113,    -17,    143,  -3062,    -29,    -52,
       299,    681,    595,    390,    530,   -398,   -969,    472,
     -1145,    860,   4113,    329,  -1183,   -691,   -605,    859,
       305,    986,    -81,   2029,    408,      2,  -2442,     59,
       -85,   -911,   -285,   -532,     28,    434,  -2295,    -76,
     -2977,     51,    824,  -1786,   2301,    622,   -593,     -9,
       643,    246,    427,    193,     51,    118,      4,    234,
       459,     31,   -408,    710,   -264,    144,   -404,   -476,
       278,  -4836,   -113,    382,    -29,    177,    345,    -33,
       -17,    -85,   6027,     72,   -165,    544,   -198,     75,
      -278,   -262,    155,    501,   -305,   -279,   -439,   1506,
       827,   -875,  -2592,  -1196,  -1201,    149,     16,    547,
      1020,   -616,    374,   -193,   -155,  -3627,    231,    264,
     -2143,     90,    419,    574,   -795,    177,    328,    752,
      -295,    210,   -360,  -1250,   2639,  -3172,    -13,    -34,
       489,    484,   -390,   -159,   -285,     27,    444,   -252,
       265,    530,  -2714,   -340,  -1543,   2330,  -1152,   -114,
       452,    304,   -224,   -451,   -317,   -579,    301,   -567,
      1214,   -594,   -621,  -2718,     59,    257,    410,     -3,
       145,     70,    877,  -3103,    244,  -1134,    236,  -1148,
};

static const int16_t cb2224s1[] = {
      8488,    277,     63,    173,    224,    -30,   -158,     64,
       133,   -133,    234,    205,    -65,    408,    249,   -546,
       -30,     -1,   -430,     80,    102,   -450,   -160,  -5634,
       145,   -406,   -351,     37,    282,    232,   -898,    430,
      3301,  -1175,   -559,    495,   2685,    -21,   -215,    -87,
       728,    -55,    235,    430,   -250,   -505,    506,   -128,
       -72,   3288,   1588,    291,      7,    -39,   -944,    478,
      1719,    168,  -1085,    225,    330,   1480,   -183,   -597,
     -6131,    668,   -387,    672,   -173,    -55,    113,     40,
      -113,    -44,    341,   -340,   -594,  -1001,   1757,    127,
       -59,    537,  -1834,   1401,    856,  -1153,   -234,   1232,
      -562,    476,    110,   2188,    146,    119,   2119,   -872,
       450,    597,   -371,  -1350,   -996,   -120,   -495,    829,
       111,   -897,  -5445,   -670,    390,   -118,      4,    109,
       772,    495,    196,    410,   -125,    812,    426,    900,
       436,   1155,   -553,  -1223,    275,    266,   -891,     63,
     -1267,    523,   -548,  -2445,    239,   1163,     72,    -68,
     -1576,   2212,   -340,   1499,    494,   -671,    -73,   -281,
       598,   1901,  -1652,   -845,    266,    795,   -545,   -574,
        19,   -461,    371,    288,  -3959,    421,    299,   -121,
     -2561,    -65,    118,    181,   -227,    719,    -92,  -2334,
     -3178,  -2497,   -198,     58,   1279,   -309,    152,   -715,
       466,   -316,     10,     98,   1568,  -1015,    -18,   -435,
       -42,   2606,   1971,   -119,    705,    254,    443,     36,
       788,   1135,   1234,   2281,    942,    115,    581,   -113,
      -194,   -694,    434,    -30,   2835,   -423,    436,    522,
       406,   1329,   1191,  -2628,    421,  -2601,    646,   -202,
       637,    610,   -584,    357,  -1586,   -499,  -1230,    134,
       -83,  -1264,   2434,    -58,  -2924,    641,   -285,    172,
      -478,   -402,    584,  -1180,   -137,   -238,   -151,   -679,
      -619,   -495,   1044,   1281,  -1180,   -444,    376,   1969,
      -693,   -283,    618,    128,  -2622,    -90,   -115,    672,
      1738,   -459,    519,   -924,   2582,    937,   -555,    672,
       131,     31,    775,    307,   -282,   -527,  -1299,   -516,
        10,    239,  -4069,    118,     10,   -665,    -15,   -484,
       472,    262,    279,    677,   -755,   1288,  -1278,    403,
       666,   -394,  -1230,  -2819,   -221,    109,    603,    754,
       951,    488,   -147,   -107,   -426,   1875,   2056,   -129,
       239,   -561,     81,   -324,    243,    349,    197,   -811,
      -146,   -929,   1193,   1433,   -776,   3209,    434,     -6,
      2465,   -231,    -57,    312,    899,   -396,   -170,   -549,
       346,    135,     17,   -596,    401,    269,    499,    -64,
      -321,   -342,   -132,   -312,   5845,    276,   -104,     -9,
       -50,   -678,   -478,  -1125,  -1477,   2058,    156,    538,
       451,   2572,    495,    101,     74,   -753,     98,    685,
      2424,  -1999,   1050,   -280,  -1030,     29,   -178,   -244,
      -134,    130,   -137,   -103,   -245,   2161,   -446,  -1016,
       464,    573,   -473,    446,  -3822,    942,  -1261,   -334,
       568,   -528,   -301,    415,   -740,    661,   -813,    849,
      1491,    774,   -774,   1637,   -977,   -246,    647,   -572,
      -140,  -2946,   -654,   -650,   -311,    339,   -165,    757,
       803,   -958,    704,    171,    380,    763,    159,   2721,
     -1599,   1006,   -118,   -597,   2985,   2699,     69,    395,
       523,    657,    438,    190,     72,    164,   -268,   -145,
       506,   -550,    222,  -3641,      5,   -173,     60,   -194,
       677,    686,    724,   -107,    882,   -339,     14,    -54,
       555,    483,   1523,    119,   -142,   -394,  -1683,   -984,
        18,   -108,   -190,    141,    540,    281,  -1238,  -2195,
      -341,   -327,  -1014,   -990,   4694,     46,  -1018,    360,
      -671,    -83,    218,    857,    144,   -188,    463,   -379,
      -571,   -865,  -1345,   -447,    -18,    -64,   5201,    132,
        90,   -158,   -132,    381,    -85,   -107,   -103,    970,
      -555,  -1204,   1802,   1230,    253,    540,   -372,  -2347,
      -386,    835,   -705,   -437,    941,    795,   -182,   -368,
      1088,    168,    256,    210,   -667,    290,   1783,   -636,
       165,   -363,    638,  -3527,   1872,   1997,   1503,   -189,
     -2587,   -359,    384,    493,   -384,   -658,  -1758,    993,
      -306,    148,    198,    163,    430,   -313,   -149,   -337,
       352,   -354,    484,    358,   -264,  -4525,   -560,    -55,
       154,    374,   -317,   -426,   1446,   -161,   -285,   -110,
       209,    299,   2329,     99,   1406,   1374,    993,   1178,
      -413,   -642,   -103,   3678,  -1829,   -754,  -1358,   -349,
       648,   -492,    755,    188,    114,   -444,   -930,   -224,
       319,    212,   1223,   -648,    593,   1293,  -1289,     24,
      -712,   2591,   -494,   1503,     -9,    534,    923,   1490,
       985,    491,    272,    988,    348,   -503,   -454,    893,
       409,   -422,  -1187,   3097,    602,   -402,    462,   1598,
      -219,    982,    319,    125,    558,   -100,   -261,    108,
       -59,  -3435,     76,  -1065,   -150,  -1758,  -1997,   1921,
      1239,    426,    507,    173,   -856,   -829,   -538,    247,
     -1203,    488,  -1094,    453,  -1104,   1021,   2185,  -2855,
       427,    177,   -778,   -182,    641,   -670,     91,    569,
        50,    -90,    571,    108,   -374,    174,   1997,    964,
       644,   -428,  -1868,    668,    171,    320,    676,    121,
      -218,   1901,   -857,   -721,   -194,  -2433,    -34,  -1671,
       352,   -644,    295,    571,    253,   -288,  -1786,     32,
        74,    -73,   -902,  -1954,  -1126,  -3427,    168,   -318,
        23,   -755,   -441,    201,    -84,    499,    367,   -153,
      -426,    716,    650,   -457,     80,   -709,    859,  -2098,
      -723,   -197,  -1030,   -253,    283,  -1187,   -899,   1403,
      -117,    -25,   7617,    -63,   -355,   -283,   -560,    -85,
      -358,    -45,     63,    179,   -193,    130,   -294,   -676,
      -525,   -907,   -430,   -627,  -5267,   -539,    257,    594,
      -173,    890,    203,    -33,   -136,   -803,    479,    -56,
      -634,    464,   -919,   -146,    306,      5,    198,    -90,
      -138,   -337,   4826,   -310,    259,   1651,   -687,  -1676,
       424,   2729,   -966,    -61,    386,     60,    769,    -72,
     -1652,     49,    106,    503,  -1462,  -1056,    892,    359,
       209,   -129,    260,   -130,  -2081,    798,    488,    846,
      -836,   -366,   1786,  -2237,   -484,     72,  -2680,   -828,
      -857,    920,    560,    930,   -197,     56,   -872,    -34,
      -355,    929,     35,   -449,    514,     70,  -1277,    208,
       353,   3654,   -256,    134,   -895,   -184,    375,    402,
      1576,   1515,   -100,   -438,   -679,    384,   1143,    -24,
       100,  -2818,    554,   -219,    105,    652,  -2778,   -108,
        44,    306,    445,   -470,  -1151,  -1170,   1305,   -741,
      1223,   -443,   -838,    374,  -3000,     72,   -590,   -587,
      3686,     76,   -493,    246,   1348,  -1215,    473,   -244,
      -304,   1937,    -68,   -626,    278,    392,   1167,  -1899,
      -309,    474,    226,   -421,    -95,   -483,    105,   -148,
       749,   -430,  -3057,   -789,  -1793,  -1857,   -158,   -489,
      -676,   -204,    806,   -930,  -3192,   -204,   -106,   -812,
      1159,    648,    119,    -93,   -205,   -139,    280,  -7786,
      -388,   -132,    -12,   -332,     32,   -174,    100,    153,
        -7,    289,    -29,   -984,   -329,   -592,   2568,    704,
       544,     66,    521,   -661,  -1632,   -868,   -310,    313,
      -466,   -347,   -146,    197,    266,    765,   -240,   -201,
      -265,  -1129,    -35,   -563,   -356,    172,    862,   3831,
      1547,  -1618,  -1445,  -3726,    388,    548,   -457,    143,
       -38,    402,    255,    840,   -703,   -154,    776,  -1038,
};

static const int16_t cb2224m0[] = {
     -7078,   2846,     79,   -111,    -20,    330,    227,    -36,
       305,     45,     81,    148,    -13,     68,    364,   -317,
       -72,   2021,     28,     93,    328,   -256,   -181,   2547,
       235,  -1102,    130,   -577,   -164,   1290,   1885,   -171,
      -147,  -3247,    324,    -72,   -313,    -62,     32,    284,
      -138,     -9,   -146,   1709,   -390,   1833,    289,    125,
      2369,     60,    223,   -137,    642,   -113,    204,    288,
     -1516,   -138,    228,    368,    219,   -622,    273,   3211,
      -215,   -423,    139,     65,     85,   -203,   -953,     11,
       193,    294,    279,   3267,    246,  -2377,    -59,   -324,
       136,   -492,     23,    -56,     79,    307,    115,   -146,
      2229,    325,  -1680,   -597,   -423,   2200,    -44,     48,
       386,    396,   -122,    -36,     35,   9763,     33,    -67,
        19,    -34,     15,     41,    -25,    -30,    -61,     20,
      -121,    117,   -155,    -28,    -65,    -27,     40,    137,
       188,   -211,   -240,     71,    -33,  -4873,   1992,     56,
     -2701,     -1,    151,    -96,    286,   -398,   -418,   -221,
       295,   -394,   -119,   -182,   -124,     77,      7,    -44,
       168,    -34,   -154,    257,      4,   -114,    634,    131,
      4930,   -118,  -2364,     46,   -204,   -129,  -3168,   -138,
      -489,    454,    -96,    120,   -447,      9,   -230,    174,
     11359,    456,   -261,    -74,   -249,    -28,    149,    -79,
       -36,    211,    -10,    213,   -110,    337,  -3800,      4,
      -223,    -18,    136,   -290,   -155,   -235,     57,    447,
      -495,   -231,    -15,  -1036,    -85,   -154,  -4421,    -19,
      -237,  -1191,     12,    -19,      2,    -88,    -84,    269,
        -7,    431,    -26,  -2676,   -100,    287,    -31,  -2916,
      -160,    -83,   -198,      9,    183,   -279,    -68,    -23,
       -55,   2955,   -121,    -71,    183,   -702,   -323,   1689,
      -132,    309,    136,  -1217,    440,   -125,  -1671,   1569,
      -161,   -108,    232,    269,   -516,     37,     21,   -260,
      -230,    564,   -375,    224,    129,   4332,   -120,   3306,
       153,    -25,   -260,    -84,    123,     21,      5,    -17,
      -145,    -44,      7,     -1,    290,  -2394,   -182,     51,
       933,   1037,     26,    211,    187,  -1783,     68,   -749,
       -52,   1428,  -1571,   -261,     34,   -199,    722,   -127,
      -118,   -114,  -2385,    146,  -1042,    -71,  -1475,   -150,
     -2195,    151,    -29,      6,     96,  -1213,    282,    219,
       466,    144,   -300,    109,    -74,    125,   2863,      2,
     -2963,   -218,    235,      3,    359,    319,    372,   -500,
      -271,    494,   2695,    -65,    -29,     47,     74,    -34,
       -95,    -48,    -76,    -71,  -2985,    -30,    -11,     26,
      -176,    107,     96,     22,    -60,    114,    -70,   -147,
       -43,   6981,    110,    -86,     33,     66,      8,    -61,
        52,   -169,     82,    233,     56,   -115,   -295,    241,
     -1053,  -3914,    -79,    361,   -869,   -144,   -144,   -805,
       158,   -278,    515,      4,   -317,    917,   -669,   3314,
       253,   1316,    259,     12,   8170,     15,    129,   -200,
       120,    -11,     34,    -77,    -13,    257,     79,      9,
        23,     54,     73,      0,  -9972,      5,      7,     43,
        29,      4,   -104,     43,    -36,     76,   -228,      1,
       -77,   -156,    -69,   -209,     84,  -2826,    242,  -1461,
      -718,    -14,   1784,    527,    226,   9852,     83,    -15,
      -389,     34,     51,    -16,    -46,     -1,    232,    115,
        26,    -42,   -124,    -78,     58,   3092,  -2757,   -111,
       223,   -286,     23,   -170,   -166,   -264,    331,   -172,
       -49,    -26,    166,   2616,    128,   3118,     59,    844,
      -121,   -504,   -193,    -53,    -95,    282,    -21,     -8,
       -11,     58,    -48,   9830,     25,    -26,     53,    113,
        96,    125,     12,    -64,    185,    -31,     19,   -251,
      -307,   -136,   1383,    -37,   -128,     56,   4303,   -232,
      -272,     44,   -192,    531,   -143,   -697,  -2291,     70,
       229,   -432,   -592,   1262,    906,   -207,   1522,    261,
     -7848,    -39,   -976,    150,    115,   -139,     61,    -26,
      -211,    807,    -25,    311,    -98,   -297,    133,    461,
      -109,     -6,  -1031,    236,  -2851,     86,   2184,   -254,
       -83,   -119,    878,   -107,    -25,   1636,   1696,   1517,
       249,    -41,   -283,    -66,    741,    704,   -898,    302,
       470,    360,     -7,  -6002,     26,    268,   -109,    150,
       202,    196,   -262,    -57,    160,    155,      7,      9,
     -5770,     28,    127,    112,    -76,   -790,     45,   -118,
       201,   -831,     67,    -81,    199,    296,   1692,    -30,
      -126,   -121,     29,    387,    215,    269,   -518,   -232,
       155,   2735,   -235,    -82,    -33,   3089,  -3696,    -39,
       -51,    124,   -220,     37,     51,   -129,    194,    -80,
        81,      0,   -239,  -1924,   -244,    107,    372,    111,
       206,    418,     39,   -118,  -2059,   -446,   1378,    661,
     -2135,    122,   -105,     60,    272,    -91,   -227,     48,
     -3226,    -88,   -109,    199,    566,    158,   2412,  -4380,
      -177,    153,    252,     24,   -323,    264,   -116,    -12,
      -333,     99,   -181,   -124,    256,   -131,    -39,    -45,
       -88,     69,    -26,   -173,  -4820,    286,   -171,    -82,
       431,     18,   -827,   -107,    142,     60,    300,    422,
       263,     61,    350,     85,   1088,   -133,  -1284,     70,
     -4577,      5,    114,    -23,     23,   2907,    174,     43,
        18,     33,    -31,    320,     -9,    290,      2,     -7,
        39,    -11,     52,     32,     -4,   8454,     18,     10,
        67,     20,     22,     -3,   -209,   -103,   -212,   -101,
      -101,   -420,  -2837,    -28,    398,    140,   1027,   -187,
     -2338,    406,   -152,   -288,    723,   -412,  -1851,    185,
       641,   -190,    107,     -7,  -3194,   -128,   -382,    165,
      -256,     85,     96,    155,   -144,    431,   -356,    342,
     -2508,  -2190,   -265,   -320,  -1345,     27,  -1981,  -1949,
        95,    -78,   -456,   -359,    382,   -218,   -102,    164,
       382,    907,    599,    665,   2843,   4275,     17,   -156,
      -264,     73,    104,    -25,   -120,     91,     84,    325,
       170,    -65,   -245,    -23,     89,     52,   4651,    124,
       185,     30,    321,    145,    111,  -1265,    128,   -156,
        64,     24,  -1934,    133,    -84,    -10,     34,    801,
      -148,    -88,    169,  -1687,    419,   1739,   -204,    -70,
       185,    117,    379,   -420,    145,  -3650,   -264,   1118,
       331,   -818,   -665,   -420,     74,     32,   -152,   -226,
         6,    216,   4173,     23,   1230,    239,      2,    -57,
      -690,    516,     90,     58,    -24,    -61,    175,  -2796,
      -113,   -270,     94,  -2319,   -158,  -1075,   -275,   -647,
     -3839,     37,   4267,     20,    -49,    -88,     72,   -171,
      -195,     45,    -23,   -159,    -64,    110,   -211,     42,
      -211,   1591,    276,  -3662,    213,     54,   -180,    786,
       -92,   -329,    382,    344,    165,    -63,     14,     -7,
        66,     29,   8875,     43,    -50,     65,     13,     15,
        48,    -40,    114,    125,    -27,    158,      3,    843,
         8,   -646,    100,  -3121,   1720,     88,    898,    346,
};

static const int16_t cb2224m1[] = {
      9581,   -198,   -100,    -22,    237,    -15,   -101,    -23,
        46,    129,     63,   -143,      5,   -307,   -143,     -9,
        27,     50,     40,   6048,     25,     58,    -16,   -161,
      -109,   -157,    137,    115,    121,    164,      4,    -54,
      6477,    -68,   -120,    -29,     45,     -8,    -13,    334,
       -87,    105,  -1460,     28,   -334,   -163,    -64,  -3629,
       -71,    176,   -195,     53,     -1,    -96,   -560,    -21,
       135,    178,    -77,  -4202,     20,   2544,   -205,     85,
      -332,    158,     61,   -105,    398,    -88,     14,    241,
      -149,     62,   -124,   -136,   -153,     27,    190,   2595,
        25,  -2499,   -530,   1809,   -104,  -2753,    298,    145,
      -771,    139,    165,   2462,   -502,    860,   -174,    199,
        74,    163,   -686,    -25,     57,   -103,   -309,   -360,
        39,   -296,  -2765,   -319,   -950,   -678,  -1159,  -1743,
      1499,   1776,   -176,      9,     44,   -581,     69,     39,
       162,    326,    -96,    329,     -9,   1274,  -2443,   -105,
       -50,   4212,    -23,    146,   -231,    -22,    -50,   -128,
        11,     28,    116,   -215,     46,    217,    204,    153,
       -73,   -156,   -100,    -31,   2632,   -190,  -2258,    199,
     -1757,    194,     53,     38,  -5723,     66,    169,    352,
       -39,   -150,     -1,   -462,     41,    -98,   -110,    -40,
     -5763,   -190,   -158,  -1380,    205,   -227,   -402,     81,
      -171,    407,   -125,   -320,   -456,   -317,    489,    698,
      -308,   3989,   -172,    402,    196,   -457,  -1238,   -192,
      -581,    -63,   -235,    153,  -1094,    -53,    -45,    -86,
       240,   -192,  -2660,   2356,    153,    -60,    277,     33,
       198,    -57,   1221,  -2984,   -327,   -326,    -48,     61,
        93,    -34,   -167,   -311,    904,    348,    415,     57,
      2000,    -77,    238,     40,  -3072,    -36,    283,    -54,
      -655,   -250,    -22,   -569,   -584,    -18,    733,   -251,
       -72,    -28,     80,   -306,    211,    188,   -149,   4596,
       305,    372,    351,    -82,   -184,    -79,    -65,   2688,
      2670,    -54,    -81,   -170,     19,    -88,    122,   -117,
        33,     51,    -29,   -113,  -2973,     46,  -3294,     90,
         8,   -180,   -227,    -62,     43,    -25,    187,   -380,
       -29,    -89,    138,   -352,    231,   2632,    158,   1993,
       -15,    350,    107,   -982,    -16,  -1120,    136,   -171,
       -42,   2605,   -186,    110,    167,   1673,   1140,    -29,
      -689,     81,    909,   -455,   2979,     44,      1,   -260,
        26,     28,    -90,   -568,   -123,   -175,    232,    -38,
      2372,    111,    312,    529,    -65,    331,    100,    488,
        12,   -596,   -497,   2311,  -1097,   1242,    -94,  -2290,
      -158,  -2651,     16,   -232,   3352,     24,    -53,    -83,
        -5,    -52,    205,   -104,   -294,    217,   -196,    -37,
        -7,      0,    -28,    -45,     60,     13,     41,    111,
       142,  -7331,    -40,   -200,     18,   -166,  -1266,    -47,
      -250,   -592,   -604,     33,     83,   -204,  -1131,   -166,
      1348,  -1337,    184,     50, -10066,     30,     24,   -184,
       137,     53,     32,     87,    -27,    151,    100,     10,
       -47,     28,   -138,     12,  -2977,   -376,     58,    168,
      1642,    144,   1039,   -399,   -807,      5,  -1715,     12,
      -142,    -77,   -306,    758,    674,    -82,   3216,   -369,
        60,    480,    276,   -423,   5102,   3325,    169,     47,
       235,     37,     81,    -86,    -28,    -56,    -59,   -205,
      -126,     28,    279,  -8433,    137,    -26,   -409,    -19,
       106,   -163,    -76,    -57,    235,      7,    131,    -81,
      -197,   -318,   1281,    310,  -2934,    972,  -1335,     35,
      -308,    -93,   -128,    433,    527,   -193,  -1303,    162,
       -34,    -87,   -157,    262,   4999,     25,   -311,   -349,
        94,   -262,      0,   -219,     57,     12,     -4,     10,
       -17,     38,   -320,     48,    156,     80,   5880,     48,
        45,     31,  -1022,     31,    227,   -727,   -135,    261,
       -21,   -688,    307,   3196,    565,    627,   -546,    237,
     -2367,    -33,   1622,    -87,   1722,   -201,    720,   -539,
      -288,  -1012,    141,   -388,    -72,    -20,    -59,  -2042,
       -53,   -101,    208,   -233,   -835,    -16,   3092,      2,
       310,     94,   -362,   -163,   -128,     30,    -22,   -145,
       420,     -1,    322,   -524,   2742,   -276,    206,  -2475,
       575,   -653,   -342,   1412,      1,     75,    -14,     54,
       170,     66,    342,   -261,    709,    -75,   2240,   -134,
        32,    665,    171,   -134,   1822,    109,    569,   3129,
       168,   -356,     53,   1259,    -67,     43,    120,   -124,
      2185,   2461,    -17,   -255,   -349,   -167,   -158,    -19,
        84,   -732,   -972,    286,     87,   4603,   -160,      7,
       141,      1,    286,    310,   -315,    -99,    282,    384,
        68,     93,  -1815,     63,    -86,    121,   -293,    210,
       115,     63,   -174,    616,  -1848,   -124,   1275,    298,
       185,   -267,   3516,   -105,   -162,   -253,   -434,   -674,
       -90,  -2232,     38,    168,   -261,    289,     70,   3714,
      4096,    -81,     17,     56,     57,     68,    -20,   -146,
        28,   -152,    -17,    -97,   -131,   2648,     71,  -3359,
        40,   -277,    313,     85,    -26,     41,   -202,     76,
         8,    -80,   -160,   -102,    -17,    155,    189,   1552,
     -3498,   -446,   -103,   -232,   -205,   -574,   -132,    169,
       206,   1689,   1043,   -736,   -178,    -93,  -2969,     26,
      -251,   -148,    139,     70,   -325,    117,  -3073,      9,
        43,    -11,   -380,   -190,   -314,  -3012,     50,   -330,
       -26,    710,    153,     19,  -2943,     58,  -3052,    -56,
         7,     40,      9,    321,    -37,   -461,    -22,   -374,
        57,   -203,     16,    -15,    -25,    -16,    -37,     -8,
       -41,   -116,   7964,     70,    -59,     77,    200,      0,
       -43,    118,    -72,    -67,    104,     -6,     78,    171,
        13,   -103,    793,     98,  -4738,   -204,     11,     30,
       -72,     33,    -62,     47,    157,    236,   -147,   -416,
      -726,    578,      5,   4038,    162,     -2,   2367,   -138,
      -185,    470,   3121,     70,    185,    -22,   -205,     37,
       -63,   -335,   -397,     43,     10,  -6557,   -112,   -254,
       106,   -129,   -236,      0,   -250,     42,   -128,     84,
      -531,    -27,   2259,   -282,    -21,    -70,   -408,     19,
      -664,    945,   -196,  -1074,   1369,    -40,  -3233,     28,
        20,  -2133,    125,    343,    113,    584,    -14,     50,
      -130,   -464,    513,    807,  -4474,    -63,     57,   1120,
        64,    -30,    346,    462,    129,    219,    -30,    287,
       448,    384,    198,   -359,   1097,   -256,    828,  -2635,
      -314,    336,    506,   -144,    194,    167,   1323,   -273,
     -4168,   2805,   -118,     -8,    136,    -82,   -212,     53,
      -259,    -61,     94,    214,     11,     29,   -262,    -69,
        24,    102,     45,    -31,   -186,     58,    641,    659,
      -172,   3628,   -192,   -423,     34,      3,     45,     19,
       349,    117,     -5,  -4923,     99,   -148,    180,    631,
        50,   -204,    641,    -92,    156,  -1985,   1077,    201,
        56,   -405,    710,   -220,  -1917,   -273,   -234,    100,
};

static const int16_t cb2224sl0[] = {
     -3113,     97,    229,    309,   -156,   -226,   -469,    582,
     -3202,   -336,    102,     20,     96,   -960,    297,   -227,
       592,  -3352,   2798,   -637,   -133,    191,   -407,    170,
      -576,   -203,   -280,    808,    853,   -502,   -113,  -1704,
     -1025,    411,   2802,    233,   -568,    360,   -616,  -1715,
        47,    391,  -2117,   -458,   -291,   -149,    -82,     26,
       -29,    -88,   -156,   7905,     32,    -75,   -154,    -78,
       -44,    155,     -1,   -338,   -891,    170,    -75,    155,
       226,   -192,   -328,   -239,   -574,    -91,     95,   -600,
      4271,     25,    990,   -207,   4676,     59,   -324,    884,
       363,     65,    423,   -776,   -906,    -79,     -4,   1475,
       549,   -252,   3584,   3543,   -409,    282,    278,    125,
      -379,    125,   -180,   -123,   -252,   -316,   -193,    347,
        53,   2009,    195,    152,   -104,    233,    -75,   -546,
       564,   -177,   3243,   -865,   -924,    518,   -692,   -381,
     -1885,   -110,   -188,   1140,  -2043,   -438,  -1721,   1019,
      1678,     13,    273,   -751,    922,   -291,    -15,     75,
       232,   -112,     60,   2702,     88,    175,   -119,     43,
      -549,  -1094,  -1879,    401,   1587,   1287,    -41,     41,
      -116,    -23,    313,    168,    147,   -101,    -57,   -115,
     -6990,     54,    -14,   -240,   -164,    127,     25,   -703,
      -361,    769,   1555,  -2440,  -2616,   -192,     86,    769,
       -29,   -721,    554,   -663,    327,    659,    -31,    -79,
        91,    365,    -74,   1268,    115,    480,   3054,  -1758,
      1704,    759,   -657,   -272,   -329,     31,   -145,   -534,
      1265,     73,    435,    -54,    480,   -867,   2724,   2373,
       890,   -314,   -112,  -2576,   -598,    473,    121,   2764,
      1659,    105,    579,   -416,    -87,    158,    300,    447,
      -281,  -6109,     35,    217,    185,     56,   -357,    151,
       108,    -49,   -282,   -484,   -220,    -78,   -141,    256,
     -1095,   1812,   -985,   1115,    555,  -2116,   2317,  -1141,
      -792,   -866,   -119,    187,    615,   -194,     73,    -43,
       268,    437,    250,    -52,    477,   -249,   -475,  -2621,
       590,  -2987,   -603,   -652,    971,   -684,    337,   -140,
      -336,   2342,    390,   -204,    295,     85,    -44,    321,
       754,   2660,     61,    782,   1654,    -76,   2727,   1590,
     -1099,    354,     49,   2784,    443,   -762,    828,   -308,
      -493,   -755,   -370,   -336,   -207,    388,    630,   -127,
      1955,   1929,   1270,   2054,    525,    388,    562,    942,
      -789,   -453,    158,    995,    -99,   2258,   -317,   -493,
       385,    -90,    -79,    199,  -1187,    519,   -254,    179,
       573,   2803,   2341,    407,     95,    515,    332,      1,
        -6,   -337,    142,   -316,    418,    542,   3281,     10,
       604,   -542,  -1595,     43,     79,     10,     75,   -122,
       100,    -55,    212,   -223,   -353,   -557,    490,   4870,
     -3689,   3594,   -145,   -192,    -47,   -252,   -380,   -180,
      -221,    656,     78,   -188,    120,    135,   -253,   -437,
      -208,   -151,   -504,    217,  -3715,   -150,    528,    121,
     -1468,    383,    823,    -55,  -1167,     -8,   -198,   -515,
      -296,    -24,     84,    129,   -472,      7,   5071,   -114,
      -200,    -16,   -271,     59,   -430,   -142,   -315,     90,
       273,    -56,    370,   3342,   -159,    235,    934,   1605,
     -1499,    207,  -1650,   1137,    396,  -2250,    276,   -320,
      -317,    -23,    276,   -519,    163,    566,    366,     -6,
      2262,  -2035,   -662,  -3300,   -133,  -3811,   -362,   -348,
       113,    146,    -79,   -298,    238,    221,     99,    194,
       326,    325,   -112,  -8160,    -59,    -15,      8,    -41,
      -261,    -20,     -6,    -68,   -140,    -41,    167,   -125,
       129,    337,   2404,    281,   -336,   -475,   2085,  -2646,
       572,  -1308,    376,    114,   -506,   1062,   -575,   -529,
      3347,   -212,    520,    274,   -163,  -3058,    -93,   -203,
      -932,   -207,    -36,    303,   -117,    278,    287,    204,
       205,   -228,   -242,    227,      3,    611,   -190,   -458,
       -44,   -209,    122,   -390,  -4561,   -139,   1378,   -329,
       440,    989,  -1782,   -348,   1241,    967,   -477,  -2312,
       554,   -970,  -1103,    473,   -771,    -50,    150,    327,
       394,   -267,   -648,   -680,   2376,  -2543,    276,   1220,
       552,     10,   1399,  -1498,   -801,      9,   2351,    -55,
       155,    327,     88,    864,    428,    179,  -3234,      6,
       544,   -647,   -306,    132,    329,   1147,   1920,   1436,
     -2107,  -1122,    341,   2020,   -432,    -97,    117,    793,
       100,   -693,    174,   3639,   -570,    910,  -2771,    231,
      -148,   -960,  -1085,     57,    188,    744,   -709,   -441,
       533,   -295,   1287,   2939,   2987,    885,    611,    700,
       364,   -205,   -855,   -617,     48,   -162,   -244,   -318,
       208,    772,   -124,  -2505,    454,    330,   -220,    335,
      -362,   -899,   -827,   2188,    -40,  -1638,    356,   -160,
      -127,   2886,    -69,    -41,    209,   1847,   -236,   2752,
       -24,    387,    354,   -111,    526,   -237,  -2169,   1319,
      2211,    144,   -348,   -434,   -319,   1373,     78,    906,
       701,    539,   -134,    414,    496,   -325,    -36,    116,
       124,   4198,    -35,   -439,   -208,   -531,   -100,   1453,
      -175,    723,   -908,   -461,     87,    127,    -91,   -125,
      -140,   8012,   -186,     23,    -93,    107,    176,    218,
        35,    193,    174,    -27,     -4,     77,   -103,   -199,
       116,    -41,    -80,    186,  -6965,   -188,    125,    -54,
        43,      9,    -49,   -192,     69,   -136,    -24,   -117,
     -2244,   2289,    145,    226,  -1161,  -1950,    881,   -152,
      1611,   1015,   -174,   -277,   -158,    369,     49,   -233,
       221,    275,     69,    108,    136,   -124,      1,   -470,
       376,    149,  -7596,     55,     53,    213,   -247,     80,
      -217,    -11,    189,    125,    -17,   -141,    165,  -2890,
        14,    201,    106,    242,   -254,   -306,  -3157,    459,
       -10,     24,   -271,    877,    437,   -438,     18,   -126,
        -9,   5553,     63,     22,     55,    172,     21,   -335,
       127,    160,    208,    121,     13,   1989,    676,   -294,
      2208,    -78,    634,  -1518,  -1037,   1309,    124,    -39,
      -322,  -1420,   -404,    377,    -35,    -14,    178,    110,
     -8146,     26,    -98,   -153,   -243,    145,    280,     -8,
        29,    -57,     85,   -309,    281,    282,    -47,    -27,
      2827,   -947,    141,    856,  -2481,    406,   -638,   -362,
     -1031,    230,   -341,   -119,    -17,      1,    190,     41,
       -15,   5111,     59,     74,    123,   -282,    -25,   -300,
         4,   -460,   -216,    295,   -217,     26,    227,     62,
       385,    748,   2923,   1946,    391,  -1676,    599,    148,
      -456,    -96,   1066,    478,    117,    255,   -169,   -669,
     -1939,   -656,   2676,    677,  -2020,  -1314,    425,   -525,
       -89,   -522,   2707,    153,      5,   -207,    244,  -1045,
       331,  -1315,    -82,    449,  -2444,    326,   -484,  -2232,
      2380,   -591,   -999,  -2552,  -1581,    349,   -440,    217,
       298,   -729,     -6,   -396,    -74,    110,    -70,  -3543,
      -388,    -51,    596,    126,    295,   2075,   -123,   -693,
     -1072,  -1779,   -420,    127,    432,  -3241,   -231,   -246,
       105,   -437,    -67,   -119,  -2941,   -257,     47,   -969,
       379,    618,    -93,      7,    202,   -425,    -38,    140,
       458,   3599,    242,    -24,   -811,   -624,    -19,    524,
      2398,   -300,    111,    376,   2015,    431,    125,    231,
      -293,  -2379,   -634,   1842,     -1,  -1326,   -610,    -88,
       128,     80,     75,     30,    172,   -235,     34,    206,
       -79,    328,    128,   -283,  -6862,   -101,    260,     68,
};

static const int16_t cb2224sl1[] = {
     -3710,   -340,   3183,    200,   -124,    423,   -417,   -432,
       232,   -808,     85,   -145,     39,    196,   -197,    -60,
      -154,   -213,   -320,  -2941,    993,   3044,   -508,     61,
      -853,     75,     40,    873,   -765,   -365,   -621,  -2670,
       188,     57,   -403,   -230,   -137,     40,    565,  -1910,
     -1120,  -1019,   -603,  -1927,    150,  -3089,     23,   -416,
      -199,  -3265,     15,    128,   -525,   -531,     91,    -39,
       578,   -388,    315,     40,   2376,   1762,      2,  -1475,
     -1774,    111,    934,   -459,    777,   -582,    114,   -218,
       -82,   -195,    165,   2171,    632,    -67,    239,    345,
      -257,    104,    -34,   -879,    488,   -422,  -2156,   -823,
      1940,    699,   2911,   -233,   -125,   -218,   -111,   -335,
     -3475,    -61,    -71,   -445,    249,   -330,    102,    376,
      -116,   2667,   -453,     19,  -4129,     90,   -507,    236,
       418,     43,     79,     61,    296,    181,    190,    408,
       216,    198,     32,    -81,    245,   -157,   5555,   -162,
       318,    179,    339,   -463,   -448,   -254,   -526,   -192,
      -427,    575,    588,   2792,   2683,   -853,   -566,     19,
       -26,    106,   -220,    518,    734,   -233,     68,   -604,
      -231,    256,   -187,    -59,   -405,    206,    331,    -25,
     -4837,   -323,    146,    541,    723,    915,   -144,    450,
       102,   -371,     27,     88,    -80,    276,    239,    101,
       157,    -69,    -14,    234,  -8192,    -18,   -110,    -52,
        -8,     48,     79,    -43,    153,    187,    211,   -118,
      -111,    238,     11,  -2006,    680,    478,   -695,   3078,
       -30,    892,    -23,   1512,   -194,    423,    -16,   -318,
       895,    406,    634,     47,  -3277,   -205,   -764,    297,
      -357,    -61,   -188,  -1547,   -868,   -174,    342,    261,
      1926,     88,    -35,  -3250,    -20,   3168,   -368,    778,
       376,    167,    598,    442,    134,    487,    164,    -32,
       245,    436,   2067,    595,   -578,     49,   -163,    633,
       138,   -279,    -99,    118,   1141,  -3168,    580,    -90,
     -3192,    551,   -663,  -2673,    -55,    147,   1307,      9,
        15,    432,    307,    527,   1002,   -469,  -2380,   -342,
      -293,    -73,   -259,    410,    309,     76,   -320,   -161,
       282,  -3300,     -7,    160,    732,    484,    -65,    147,
      2923,   2321,   -840,   1933,    268,    684,   1172,   -377,
      -365,   -568,   -283,    492,   -538,    409,   -194,     17,
      -297,    -52,   -123,   -270,    161,    -94,     92,   4495,
      -396,    540,    229,    -30,   -108,     29,      1,    198,
       492,   -572,   -394,  -2386,   2787,    885,  -1175,   -129,
     -1137,    220,    148,    261,    -65,   -244,      1,     58,
       195,    -49,   -290,    -94,    -21,    105,     71,   6641,
      -200,   -407,   -496,    -75,    233,    222,    549,    363,
       188,    739,   -869,    122,   -355,   3326,    323,  -2366,
       115,  -3207,   2783,   2015,    148,    924,   -153,   -133,
      -175,   -287,    400,     73,   -181,   -174,     72,     45,
       219,    -92,    -11,     59,  -5407,   -362,   -188,   -120,
       239,    249,    133,   -229,    158,    180,   -575,  -2386,
      -354,    248,    532,   -590,    615,    -85,    -69,    394,
      3052,   -877,   -320,    484,    218,   -463,   -202,   -841,
      1729,    284,   1253,   2193,    526,  -2444,   -351,   1287,
      -373,    387,    440,   -203,    163,   -153,    206,    -57,
       -96,   2616,    -84,    552,     33,    705,   -731,   -843,
     -2197,  -2138,   -570,     22,   -264,   2143,    725,   -132,
      -392,    471,   -245,     51,    739,  -1057,   1049,   -760,
      2701,    456,     20,    484,    595,   3248,  -1415,   -862,
       332,   -417,    323,   -431,   2082,     78,    684,   -169,
       596,   -228,   -219,    172,    160,   -180,   -228,  -3193,
      -520,   -100,   -447,   -629,  -2178,   -259,   -246,  -1788,
     -2264,    223,    115,    -74,    230,  -2515,    212,   -179,
       456,    209,  -2379,   -246,   -345,   -102,   -559,    259,
      -270,   -426,    333,   -358,   2866,   -589,  -1494,   -418,
      -160,   -138,   2088,    683,  -1313,   1061,    -88,    916,
      -148,  -2329,   -301,   -271,   -249,   2822,   -525,   -405,
       592,   -322,  -1328,    -16,    135,   -582,   -676,   -503,
     -2162,   -327,   -237,    361,    166,    600,   1176,   1015,
        97,     -5,    465,   2321,  -4544,    202,   -350,    313,
       149,    544,   -420,    552,    183,    351,  -1663,    688,
       238,    587,    907,  -1719,   1267,  -2325,    368,    236,
       296,  -2608,    240,    997,    496,    105,     75,   -179,
       235,    125,    -40,     57,    -22,   -412,   -464,   -494,
       -81,    576,  -3461,  -1037,   -744,   1358,   -856,   -284,
      -536,    387,   -358,    184,    -85,   2150,  -1142,   -124,
       119,   1242,    648,    711,   2161,   -591,  -1864,   -672,
        62,   1879,    -13,     55,    285,   -167,    142,   -130,
       322,      8,    -35,   -230,    632,   -699,   4114,   -500,
      -189,    -48,   2746,     47,    421,  -1200,   2418,    460,
      -306,    331,    164,  -1358,    802,    453,    458,   3594,
      3065,    -24,   -134,   -437,   -892,   -110,    241,   -368,
       336,    673,   -147,    130,    154,     89,     81,   -341,
      7151,    175,    118,   -227,   -282,    262,    276,   -118,
      -118,   -245,      7,    144,    -87,   -136,   -146,   -484,
        70,    221,   -220,    -13,  -7638,     93,    -38,   -319,
      -478,     26,    -28,    281,   -180,    182,   -186,     90,
       192,     50,  -2919,    153,  -2651,    289,     47,   -783,
       768,    384,     39,    194,  -2358,   1242,  -1679,     80,
      1292,     28,    682,   2807,    342,    466,    299,   -380,
       376,   4466,     12,    553,    153,   -447,    733,     99,
         8,   -142,    606,  -2364,    168,    167,    -62,    404,
     -3144,    352,    115,  -3734,    360,   -202,   -462,   -196,
       464,   -412,    192,   -363,   -413,   -405,    254,    357,
     -2801,   1054,  -1602,    642,   -254,   -430,  -2259,    -97,
        16,   -311,    757,    -64,    412,    339,   -227,   -216,
       -29,    219,     67,     63,     26,   -232,   -138,   -301,
       241,    -52,  -6118,    223,   -379,   -157,   -221,   -201,
       -93,  -5630,   -286,   -194,    133,     46,    151,    444,
      -472,    103,   -115,   -259,    -53,    673,   1744,  -2374,
       359,   2541,    613,   -393,   1235,    221,   -117,   -842,
      1166,    105,   -142,   1426,      3,   -423,     36,    398,
     -2742,    723,   -740,    985,    498,    431,  -1312,    832,
     -1644,    146,    -69,   -110,    420,   -130,    335,    269,
     -2865,    -67,    -88,     50,   2735,   1038,    973,    371,
       654,   -169,   -112,    579,   -319,   2434,   -760,    710,
       241,  -1889,     39,  -1807,    -30,   1383,  -1080,    449,
       639,  -2478,   -760,    559,    298,     56,   -421,    818,
      -442,   1558,  -1610,   2136,    -12,    -11,    592,     73,
        77,   -172,     77,     92,   -113,    281,    581,   -584,
     -4448,    507,   -195,    183,   -508,    312,   -724,   1043,
       -18,    -10,   -776,   -534,    249,  -3178,    904,   1234,
      -482,    382,  -1040,   -448,   -579,    227,    -82,   5628,
      -165,    255,    109,   -141,      7,    -28,     63,     93,
      -211,      0,    162,    581,   -153,   5844,    -66,    122,
      -102,    -90,   -205,   -181,    243,    312,    111,   -435,
      -105,   -343,    272,   -141,      6,    -98,    -16,    -73,
       -26,   -125,  -7627,    -73,    -66,    108,   -175,    186,
      -189,   -102,   -240,    -37,   -354,   -260,   -120,     30,
        87,   2560,   3157,    369,   -662,    338,   -503,    -66,
     -1405,    178,   1100,   -683,  -2618,   2459,  -1291,   -248,
      -139,   -683,   -865,   1445,    165,    368,    507,   -585,
};

static const int16_t cb2224ss0[] = {
     -6880,    657,   -621,     69,    219,   -588,    681,    229,
       248,   -302,   -110,    734,     12,    253,   -454,   -890,
     -3596,    778,  -2600,   -256,    529,    332,    -69,    295,
      -455,    982,   -265,    -70,   -332,   -367,   1494,    586,
      -158,  -1054,   2529,   -313,   -661,  -1302,  -2486,    476,
         5,    126,    581,    361,   1618,    650,   2033,    202,
        76,   -265,   -161,   3659,   -800,   1069,   -167,  -1792,
       389,   -580,    597,   -268,    621,  -1035,    710,    854,
      2004,   -785,   2714,   1659,    785,    800,    -80,      9,
      -341,  -1032,    789,    651,   1068,   -609,    661,    747,
      -928,   -999,  -1369,  -1173,   -416,   1596,  -2800,    330,
       546,  -1275,   -746,   -392,   -529,   -378,   3571,  -2795,
      -731,   -183,   -330,  -1591,    371,    866,    323,   -516,
       -89,   2277,   1593,    960,  -1726,  -2229,    727,   -415,
       189,    500,   -145,   -177,    550,    467,    240,   1131,
       474,   -419,  -1236,    674,   -616,   -519,   2439,  -1213,
      -650,    867,    974,   -908,   1229,   -512,    932,   -495,
     -2521,   -865,   -466,      8,   -426,    912,    -77,   -236,
      -407,    433,    128,   3653,    854,    243,    770,    191,
       224,    -68,   -453,   -383,    279,   -701,   -691,    282,
      -449,   1148,   -783,    241,  -5021,    643,   8113,   -345,
        13,     90,    -57,    475,     64,   -268,   -163,   -100,
       -95,    518,    577,    541,   2055,    358,   -157,    360,
       280,   -840,  -1161,    500,     95,    302,   -662,   1134,
       827,   3300,    695,    775,   -798,  -2651,  -2891,  -1123,
       555,  -1125,    156,    328,    671,    751,   -347,   -972,
      -392,  -1216,   2725,  -5152,   -402,    -15,    150,     31,
      -182,   -278,    245,     81,     -3,    -46,    310,    -72,
      -138,   1511,  -1762,  -1840,   -364,    123,   2801,    -16,
      -543,  -1312,    562,   -262,    148,    521,   -711,     61,
      -863,    145,    329,    761,     76,   -155,    101,  -4986,
       192,    269,   -364,   -174,    640,   -261,    629,   3638,
       397,  -1757,  -1177,    342,    388,   1089,    824,    115,
       150,    125,    806,   1271,   -198,    800,   -175,   -897,
      -649,   -837,    690,   -755,   1416,  -2347,   1179,   -781,
       826,   1567,   -148,   -156,  -1036,  -1572,   1248,   -187,
       464,   -260,   -749,  -1070,     85,   -466,  -2160,  -2802,
       233,   -181,    447,   -482,    113,    548,   2957,  -1600,
      1341,   -559,    803,   2085,   -807,   -711,  -1169,   -456,
       657,    -76,   -147,   1932,  -1054,   -967,  -1100,    -49,
     -2829,   1412,    929,   1207,     58,   -146,     77,   -458,
       538,   -627,    -12,    214,  -2397,    692,   1284,    366,
      1286,   1997,   -856,    267,   1866,   1236,     25,    254,
     -1187,   3456,    283,    584,   2348,    604,  -1130,      7,
       500,    232,    -51,    120,   -695,   -930,    317,     67,
     -1346,   -500,    312,  -1060,  -2338,  -1860,  -1491,   1539,
     -1707,    778,   -653,    -41,    401,    311,    -13,   2155,
     -1011,   1163,    712,   2090,   1336,   -726,    574,   1200,
     -1254,  -1567,    723,    683,   -877,   -653,   1137,  -1594,
      1127,   2641,    465,    259,  -2095,    696,   -405,     40,
      -259,   -808,   -942,    395,   -180,  -1119,   -966,   -230,
      -534,   -114,     88,   -661,    757,     75,   -286,   -119,
       924,  -2925,   2483,   1662,   1823,    590,   4307,    810,
       447,    165,    243,   -184,   -162,    436,   -126,   -194,
       365,    601,   -354,  -1983,   -211,   -663,    276,    155,
      -696,  -2542,   -830,   2374,   -235,   -585,   -469,   -478,
        21,    867,  -1633,   1949,   -949,   -330,   -546,    328,
      -224,   1236,    266,  -1117,     36,    -61,    221,    153,
     -3491,  -1463,   -237,   4676,   -241,    273,    268,    347,
      -393,   -277,    168,    426,    155,    -65,   -605,   -569,
     -1416,  -1303,   1248,    595,   -148,    512,   3622,    291,
      -444,   -523,    616,    105,    101,   1357,    772,   -337,
       494,    570,     15,    150,   -400,    572,    590,   1674,
     -4106,    940,    167,   -327,   -336,    696,    591,    362,
       279,   4489,  -1325,    608,    294,    -41,    549,    982,
       -31,   -184,    367,     77,   -466,    398,  -1928,   -607,
       239,     55,     15,   1031,   -486,   2788,   2151,   -519,
     -1197,  -1144,    274,    671,   1620,   2079,  -1555,   -961,
       543,    -11,     26,   -627,    777,   -581,  -1060,  -1177,
      -808,    807,   2863,    607,    144,    195,   -274,     18,
     -5656,   -355,  -1026,     56,    116,   -431,   -493,    517,
       286,    353,    353,    199,   -651,   -863,   -276,   -556,
      -562,   -867,   -143,   -355,   -323,    -14,    -54,  -5354,
       -43,  -1592,      8,   -543,     24,     94,   -731,   -545,
       705,   -171,    504,  -1078,  -3367,   1349,    452,   -148,
      1183,  -1650,  -1400,   -246,  -1032,   -119,   -309,   -566,
       998,  -3240,   -444,   -658,   -605,   -186,    491,    439,
      -190,    688,    -29,   -965,   2562,   -112,   -329,    -25,
     -2593,    355,    -53,    692,     12,   -593,   1930,   -804,
       -82,    386,   -632,    927,   1006,   -229,  -1147,   -181,
     -1075,   -245,  -3678,    904,   -298,   2263,     50,    563,
       337,  -1051,    173,    310,  -3540,   -615,   -504,    749,
       192,    -90,   -113,   -730,  -1994,    802,    -45,   2234,
       167,    289,   1722,   -562,    682,    453,   1571,    171,
     -2429,   -441,   -230,  -1144,    985,  -1602,    358,   -685,
       -23,   -523,   -529,  -2438,    700,   -624,     37,  -1475,
     -1318,   3292,    702,    394,   -798,   2563,   1057,   -335,
       614,    270,   3135,  -1281,  -2089,   -250,   -140,     45,
      -517,   -470,  -1429,   -172,   2637,    267,     55,  -1037,
      -174,    912,   -865,   -786,   -406,    537,  -2805,   -642,
     -1599,    888,  -1044,   -175,    312,     28,  -1157,   -240,
      -181,    298,    521,   3802,    -87,     93,     48,   1336,
     -1071,  -1870,    339,  -1106,   -944,  -1036,    361,  -3719,
      -147,    625,    326,   -122,    407,   -217,    396,    273,
        -2,   -315,   -262,    632,   6868,    228,   -267,    207,
       -29,   -274,    192,     63,   -353,    588,    550,     -3,
       156,   2115,   1580,  -2366,    306,    633,   1354,   2313,
      -360,   -345,    270,   -499,   -976,  -3685,  -1305,    907,
      1431,   1545,  -1334,     18,   1159,    229,   -124,    157,
       470,   -105,    700,  -1786,  -1895,    795,  -1052,   -278,
       745,   -111,    -45,    694,    599,  -3469,    552,    -70,
      -222,     45,    896,   -251,      1,    250,   -769,    301,
     -1151,   1313,   4314,    710,    680,   -169,   -663,     40,
       399,   1171,    581,    775,    936,   -488,  -2918,    155,
      -169,  -1560,   -862,   -473,    783,    -72,  -1791,    567,
     -2109,   -156,   1250,  -1486,   3253,     61,    -50,   -374,
      -277,    942,    111,    607,   -316,    197,   -748,    871,
       612,   -242,   -296,     53,   -193,   1233,     11,   -962,
       505,  -4492,     21,    754,   -150,    451,    183,    881,
      -652,   -159,   6384,    170,    271,   1035,    401,     48,
      -463,   -240,    -95,   -625,    613,    -91,  -1138,   1172,
       542,  -1483,  -2638,  -1396,  -1173,    612,    512,   1355,
       977,   -362,    -22,    -17,    124,  -3178,   -532,    352,
     -2691,    610,    569,    740,  -1603,     -5,   -492,    704,
      -436,    -96,   -595,  -1495,   2730,  -3089,   -164,    565,
      1300,   -477,   -569,   1069,    294,   -233,   -133,    708,
       150,    388,  -2108,  -1042,  -1603,   2275,  -1722,    561,
       140,    507,   -899,   -281,    162,  -1297,   1504,   -158,
       193,   -730,   -944,  -2484,    615,    -30,     32,   -354,
      -383,     86,    329,  -3434,   -382,  -1604,   -299,    208,
};

static const int16_t cb2224ss1[] = {
      8192,   -187,   -471,   -201,    185,   -465,    976,    257,
        83,   -530,    310,    676,    341,     48,    265,   -351,
       306,    280,    302,     48,    496,   -339,    424,  -5250,
      -253,    604,   -317,   -289,    278,    573,   -579,     79,
      3218,   -574,   -377,    276,   2831,   -287,   -254,    332,
      -225,     42,    162,   -457,   -959,  -1421,    683,    -59,
       -33,   3362,    393,    606,    249,   -873,   -930,   1224,
      1469,     37,  -1592,   1665,   -582,   1729,    284,    106,
     -4753,   -120,   -475,    867,   -444,   -203,    431,    -11,
      -526,   -324,    732,  -1070,   -160,   -611,   1808,   -297,
      -536,   -194,   -822,   1224,   2220,  -2330,     72,   1004,
      -787,   -149,    557,   2925,     29,    809,   2397,  -1143,
       648,    904,   -568,   -707,   -839,   -274,  -1322,   1177,
      -467,   -482,  -5181,    234,    223,    354,    386,    737,
      1273,    234,   -353,     31,     -8,   -392,     85,   -234,
      1366,   1449,    120,   -695,    838,   -622,    -96,    382,
     -1421,    612,   -173,  -3199,   -150,    474,   -394,   -561,
     -1171,   2541,   -271,   2513,    670,    285,    636,   -452,
      -202,   1319,  -2182,   -935,   -586,    243,   -813,    -41,
       -53,  -1041,    212,     58,  -3424,    111,    268,    964,
     -3231,   -500,    867,   -191,    207,    543,    383,  -1509,
     -2712,  -2752,    201,    428,    721,    498,     19,   -747,
        67,     87,    500,   1200,   2244,  -1158,    466,  -1032,
      -153,   1197,   2737,   -324,   2002,   -338,     89,   -428,
        78,    575,    330,   2013,    175,    305,    567,   -539,
        17,    384,    485,    860,   3330,    173,    586,    649,
       388,    963,   1820,  -2610,    251,  -2966,   1383,   -153,
      -146,    564,   -718,    998,  -1283,   -566,   -619,    394,
       459,  -1233,   2566,   -357,  -2601,     98,   -929,   -367,
      -501,     96,   1217,  -1695,   -324,    393,    261,   1745,
     -1095,   -751,    924,   1044,   -337,  -1243,    393,   2454,
     -1499,   -245,    902,    925,  -2126,    167,    838,    638,
      2296,   -294,    306,   -715,   2794,   1522,   -339,     21,
       318,    -95,   1334,     75,   -173,    -91,  -2012,   -920,
      -801,    334,  -3363,   -348,    550,   -911,   -261,  -1073,
       185,   -425,    431,    515,   -339,   1817,  -1589,    241,
       548,   -337,   -471,  -3532,  -1166,    888,    141,   -277,
      1353,    310,   -654,    198,   -516,   2951,   2251,   -534,
       701,    237,     20,   -597,   -301,      3,    410,   -456,
      -581,  -1254,   1052,   1321,    165,   3108,    477,    196,
      2716,     85,      5,    -34,    721,   -562,      4,     84,
      -793,    744,    243,    134,   -385,   -129,   -122,   -128,
      -333,   -483,   -604,    269,   6209,      3,    515,    -63,
      -634,   -551,   -795,  -1696,  -2210,   2184,    348,     30,
       413,   2531,    214,    214,   -186,    -72,   -552,    958,
      1727,  -1639,    618,    -61,   -432,    365,   -753,     15,
       -14,     33,    976,   -940,   -355,   3318,    677,  -1938,
        21,    881,   -326,    -83,  -3355,   1483,  -1211,   -674,
       166,    139,   -276,    158,   -736,   1038,  -1005,   1129,
      1219,   1115,   -392,    558,     96,   -188,    314,    536,
      -423,  -3262,    395,   -130,   1099,    304,   -181,    853,
      -160,  -1272,    428,   -179,    634,    608,   -173,   2690,
     -2191,   1385,   -518,   -416,   3239,   3250,    313,    -23,
       200,    643,   -639,    -17,   -208,     27,   -182,    262,
      -203,   -671,    157,  -4131,    383,   -404,    337,     51,
       431,     92,    138,   -438,     29,    337,    488,   -252,
       656,    509,   2037,   -635,  -1074,  -1115,  -2135,   -772,
      -386,   -214,   -654,   -441,   1661,    542,   -383,  -1720,
        22,   -103,  -1474,  -1288,   4361,    282,  -1252,    734,
      -858,   -556,    294,    243,    293,    133,    848,     65,
      -727,   -887,  -1314,    443,    -96,   -422,   4268,    672,
       142,    608,   -442,    843,    365,   -866,   -157,    780,
       107,   -888,   2089,   1769,     73,    739,    -15,  -1730,
     -1235,    920,  -1713,    163,    552,   1479,   -692,   -755,
      1430,   -193,   -276,   -264,   -690,    772,   1403,    -40,
       679,   -260,    642,  -3562,    962,   2053,   1348,     36,
     -2974,    155,    303,    821,   -944,   -179,   -967,    632,
      -725,    411,   -447,   -463,    694,   -337,   -146,     59,
        -1,   -416,     12,    524,   -497,  -4682,   -745,    625,
      1011,     20,   -462,   -503,   2012,   -475,    -27,     85,
     -1190,    534,   2250,     87,   2591,   1195,   1665,    423,
      -813,   -571,   -372,   2601,  -2013,   -853,   -734,   -403,
       793,   -549,   1243,    312,    722,  -1013,  -1434,   -749,
      -571,    494,    -88,   -129,   1331,    806,  -1227,    326,
     -1164,   2487,    -59,   2346,    583,    519,    368,    793,
      1178,    661,    140,   1226,    378,   -429,  -1214,   1438,
      -319,    -77,  -1495,   3598,    361,     21,     39,   1930,
       198,   1050,    531,    274,     32,   -499,   -349,     -5,
      -133,  -3324,   -379,   -742,   -250,  -1618,  -1536,   2084,
      1369,    765,   -132,   -324,    406,  -2198,    314,    502,
     -1431,    759,   -729,    320,  -2120,   1484,   2468,  -3283,
         4,    272,     -2,    492,     91,   -803,     48,    691,
       375,     87,   -508,   -725,   -632,    268,   2929,   1302,
       -11,   -628,  -2225,    723,    533,    909,    934,    682,
       350,   1509,   -707,  -1142,    106,  -2174,    342,   -965,
       456,   -655,   1137,   -553,    415,   -418,  -2631,   -121,
       237,      3,  -1123,  -1555,  -1413,  -3333,    717,    115,
     -1030,  -1007,   -819,    130,   -851,    281,    -43,   -473,
     -1091,    326,    869,   -377,    278,   -148,    418,  -2104,
      -422,    623,  -1777,    633,   1033,  -2031,  -1221,   4126,
       -60,    -16,   8025,    243,   -340,   -599,   -501,   -289,
      -219,   -104,   -230,    464,    191,     18,    345,    -65,
       -68,   -481,    625,   -822,  -4011,   -516,    741,    734,
      -316,    530,    122,    945,    371,   -298,   1194,   -250,
      -167,    392,    -95,   -151,     -1,   -486,    189,     90,
      -140,     30,   4485,    581,     54,   1905,   -895,  -2032,
      -174,   2473,   -688,   -104,   -315,   -376,    830,    296,
      -548,    754,    195,   -901,  -1548,  -1931,    792,    510,
       294,    153,    619,  -1034,  -3038,   1134,    142,    -29,
      -806,   -118,    -29,  -2314,   -159,    770,  -2899,     23,
     -1045,   1037,   1496,   1104,   -527,    135,   -281,   -310,
       -59,    202,   -346,   -612,    206,     27,   -456,    758,
        67,   3547,    867,    227,     -3,    573,   1440,    421,
       170,   1491,   -691,    -43,     -8,    784,    307,    557,
       618,  -2387,    566,   -396,    182,    877,  -2666,   -163,
       553,   -155,    691,   -188,  -1584,  -1085,   1033,   -308,
      1356,   -570,   -721,   -232,  -3145,    104,    511,   -964,
      2783,   -685,   -168,    -51,   1554,  -1816,   2431,    327,
      -440,   1174,   -265,    -36,    120,   -397,   1094,  -1254,
      -973,    574,   1085,   -139,   -751,   -529,   -240,     25,
      1137,   -467,  -3471,    338,   -806,  -2028,     94,    -98,
      -336,   -537,   1189,   -880,  -3607,   -168,    -59,    100,
       309,   1097,    295,    262,    106,     -8,    210,  -7461,
       395,   -248,    461,    490,   -326,    264,    105,     13,
      -160,    608,   -443,  -1331,    835,  -1342,   3507,    763,
       966,    101,   1047,   -469,  -1455,  -1080,     28,     99,
       -44,    270,   -752,    130,      2,     57,    358,   -409,
         2,   -658,   -812,   -899,    155,    141,   2101,   3616,
        40,  -1957,  -1028,  -4137,    212,   1580,    578,   1019,
      -512,    167,    366,   -580,    448,    216,     79,   -149,
};

static const int16_t cb2224sm0[] = {
     -4334,   1434,   -228,   1477,  -1329,    230,    686,   -558,
       486,   -188,    424,   -454,   -568,   -141,   -326,   -132,
       -39,   2488,      9,    631,    513,    460,   -417,   2656,
       633,  -1404,    -81,   -283,   -287,    480,   2558,    -19,
      -158,  -2699,    405,    276,   -639,   -151,    529,    241,
      -941,   -796,   -213,   1125,   -391,   2515,     78,   -177,
      2677,    217,    955,   -687,    867,   -485,   -121,   1023,
     -1572,   -591,    139,    798,   1262,   -467,    722,   2643,
      -237,  -1048,    386,   -432,    180,   -788,   -178,    234,
       403,    267,    312,   2661,    585,  -2775,   -686,    -88,
       -16,  -1243,   -445,   -259,    303,    298,    285,    277,
      2355,    163,  -2399,   -416,    115,   2277,   -707,    194,
       283,   1183,     23,    119,     97,   8192,    -40,     67,
      -101,    151,    169,     21,   -147,   -160,     55,   -207,
       550,    -36,   -500,    -32,    225,    206,     72,    179,
       464,   -406,     52,    696,    -18,  -4827,   1547,   -516,
     -2275,    855,    430,   -523,     83,  -1633,  -1898,    285,
       202,   -645,   -167,    102,   -124,    382,     24,    236,
       830,    324,    -84,    491,    -95,   -154,    767,     25,
      4741,   -574,  -2576,   -297,   -250,   -346,  -2867,    -64,
     -1119,   1007,   -883,    457,   -328,   -854,   -981,    -55,
      6922,    569,   -307,    261,   -100,   -832,    129,    416,
      -154,    681,   -136,   1152,   -144,    -26,  -2266,   -320,
      -141,   -897,    544,   -206,    845,   -590,     88,    211,
     -1761,   -574,   -653,  -2788,    252,   -266,  -4252,    295,
        97,  -2112,    209,   -144,    655,    -89,   -369,    591,
       205,   1137,     30,  -2907,     88,     92,   -240,  -3106,
       -16,   -398,   -576,   -720,    421,    427,   -423,   -195,
       -18,   2503,   -133,   -918,    104,   -512,   -489,   2623,
      -314,    215,   -103,  -1014,    761,    382,  -1456,   1719,
      -980,    248,     55,    644,  -1945,     42,   -162,    -35,
      -852,   1993,   -189,    664,   -149,   3132,    -50,   3438,
       550,   -234,   -566,    434,     64,    379,   -169,   -291,
      -718,   -608,     31,   -207,    651,  -2567,   -790,    906,
       518,   1740,    373,   1158,    114,  -2044,    285,  -1136,
      -373,    932,  -2185,   -488,    148,      3,    724,    623,
      -568,   -359,  -2748,    751,  -1098,   -858,  -1140,   -253,
     -2377,   -402,   -312,   -398,    -47,  -2618,    816,   -568,
      1274,   -158,    118,    107,    181,    394,   2758,     80,
     -3057,     20,   -279,    110,    482,   1010,   -162,  -1081,
       -56,    685,   2207,    -10,     82,    440,    593,     43,
      1010,   -853,   -624,    288,  -3045,   -426,      9,    132,
       104,    157,    466,   -118,    116,    226,   -214,   -219,
       299,   6093,    122,      7,    174,    444,    200,    -42,
        -4,   -313,     99,    218,    292,   -159,   -409,    523,
     -1357,  -4098,    -96,    968,      8,   -172,   -444,  -1040,
       755,   -476,    967,    175,   -100,   1689,   -813,   3175,
       369,   1828,    248,   -161,   6693,    631,    536,   -125,
       274,   -467,    259,   -427,    130,   -523,    361,    584,
        27,     60,    -57,    -30,  -8192,    148,    -64,    217,
      -308,    163,   -116,     89,    108,    191,   -129,   -149,
       128,     60,    575,    253,   -385,  -2937,    888,  -1402,
      -543,   -607,   2639,    156,    251,   6966,   -147,   -382,
      -388,     39,    476,    260,  -1048,    575,    401,   -245,
      -441,    121,    389,   -666,     95,   2919,  -2212,   -765,
       169,   -161,    184,   -320,   -315,   -497,    136,   -470,
       479,   -541,    712,   2966,    519,   2595,    -77,   1089,
        18,   -697,   -616,    241,    -54,    388,    461,    368,
       144,   -149,    181,   7699,     11,      3,   -368,     65,
       304,    358,    -29,    255,   -162,   -169,   -470,    -16,
       198,     92,   2137,    233,    273,    255,   4078,   -279,
      -194,   -274,    101,     45,   -225,   -716,  -2522,   -188,
        10,   -590,   -745,    894,   1976,    -48,   2302,     -4,
     -4691,    -67,  -1325,   -506,    605,   -297,    317,   -271,
      -176,   1706,    541,      1,     31,   -580,    103,    148,
      -122,   -141,   -849,     76,  -3094,    -67,   2775,    -38,
      -598,   -314,    793,     40,    324,   1474,   1986,   1505,
       832,   -504,    739,  -1233,   1201,    695,  -1363,    670,
       805,    696,   -137,  -4977,   -306,    137,   -885,    455,
      1021,    600,  -1711,    536,    235,   -149,     31,     -5,
     -3747,   -405,    394,    140,    102,  -1576,    190,    408,
       663,  -2075,   -747,    466,    631,    807,   1867,   -655,
       102,    341,    435,    551,    500,    426,   -650,    -88,
       -26,   2672,  -1791,     34,    -86,   2963,  -3330,   -793,
      -307,    277,   -584,   -240,   -141,    258,    708,   -242,
      -499,    808,   -104,  -2061,   -518,    684,    889,    406,
       259,    211,    462,    428,  -2597,  -1147,   1729,    683,
     -2173,   -167,    392,    440,    599,   -815,   -624,   -368,
     -2962,   -172,    845,    423,    362,    711,   2131,  -3899,
        84,    147,    826,   -399,   -637,   1132,    108,   -480,
       230,    265,   -423,     48,     11,    239,   -599,   -281,
        10,    541,   -397,    142,  -4322,   1172,   -257,   -101,
       292,   -321,   -401,     60,   -309,    468,    267,    611,
       438,   -638,   2194,    346,   1421,  -1192,  -3109,   -170,
     -3336,    -49,    -69,    -75,    184,   3094,    591,     82,
      -373,    140,    -22,    848,    124,    589,    157,     -4,
       260,   -177,    147,     73,   -284,   6253,    111,    302,
       -74,    356,    381,   -547,    -16,   -275,   -500,     93,
       344,   -346,  -2837,    364,    -43,   -592,   1741,   -702,
     -2247,    848,   -203,    168,    758,   -849,  -2454,    562,
      1104,   -169,    463,   -398,  -2759,   -299,   -903,    647,
       -62,   -124,    301,    337,   -201,    463,    -86,   -139,
     -2189,  -2424,   -942,   -376,  -2043,    -80,  -1791,  -1580,
       513,     29,  -1115,   -582,   1214,   -642,    355,    240,
       285,   1759,   1209,    862,   1707,   3353,   -223,    245,
      -515,   -928,    794,   -190,   -282,   1097,    -32,   1675,
       857,   -730,    -15,    102,    356,   -309,   3867,     24,
        93,    899,   -608,   -497,   -215,  -2244,    735,   -194,
       102,    -51,  -1939,    846,     74,   -116,      7,   1981,
       512,    233,    574,  -2508,     83,   1966,   -251,    -96,
       532,     97,    897,  -1120,    390,  -3192,   -652,   2045,
       193,   -880,   -398,   -148,    548,   -281,    -19,   -987,
       467,   -326,   2777,    195,   1560,   1034,   -828,    102,
     -1531,   1292,   -126,    539,   -247,     36,     55,  -2487,
      -297,   -362,    482,  -2241,  -1021,  -1535,   -244,     38,
     -3416,    141,   3408,     35,    -67,     95,    333,   -427,
      -235,   -128,    304,   -548,    337,   -349,   -330,     23,
      -450,   1657,    327,  -3087,    695,   -273,  -1090,   1262,
      -111,   -868,   1516,    269,    119,    192,     14,    200,
       141,   -395,   7145,     48,    334,    143,   -139,    154,
      -102,   -312,     -2,    283,    238,    -30,    626,   1328,
       242,   -416,    442,  -3050,   1388,   -100,   1215,    817,
};

static const int16_t cb2224sm1[] = {
      8192,    -13,    346,    -52,      5,    131,   -294,   -167,
       -65,   -347,   -438,   -559,     57,    -86,   -223,   -224,
      -251,    629,    -58,   5249,    127,   -464,    644,    210,
      -154,   -480,    165,    211,     13,    318,    152,   -173,
      5451,    235,    170,   -100,     -6,   -460,   -249,    390,
        54,    993,  -1637,   -288,   -978,   -197,    234,  -2877,
      -570,   -151,    -82,    772,    199,   -385,  -1899,    345,
       -25,    527,   -477,  -2918,    385,   2784,     78,   -524,
      -759,    795,    433,    511,    856,   -275,    511,    136,
      -444,    151,    233,    208,   -589,   -375,    282,   2886,
        30,  -2749,   -930,   1079,     86,  -2285,    980,   -229,
     -1369,     93,    -80,   2314,   -170,   1224,    397,    405,
       463,   1014,   -377,    -90,   -269,    -82,   -376,   -773,
       684,    -94,  -2893,   -323,   -644,   -849,  -1892,  -2244,
       417,   2165,   -164,    221,    454,  -2337,    142,     99,
       418,    486,    -49,     97,    138,   2221,  -2301,   -156,
      -578,   3963,    196,    140,   -374,    180,    451,    354,
      -952,    946,   -479,   -874,   -159,    145,    290,    240,
      -240,   -233,   -418,    226,   2878,   -571,  -2491,    741,
     -1438,    557,    197,   -370,  -4720,    379,     32,    821,
        39,   -545,   -141,  -1507,    192,  -1150,    905,  -1095,
     -5028,   -169,    533,    -23,    371,    162,  -1198,    465,
      -369,    -14,   -861,   -656,   -701,   -296,     31,    450,
      -387,   3060,   -696,    597,     14,  -1019,  -2741,   -208,
     -1186,   -338,    712,    -64,   -344,     41,    327,      9,
       576,   -349,  -2808,   2428,    433,   -566,    908,   -108,
      -145,  -1011,    201,  -3042,   -327,    210,   -368,    230,
      -310,   -400,     12,  -1034,   1734,    992,   1842,   1022,
      2162,    588,    366,    154,  -3078,   -587,   1096,    215,
     -1072,   -784,    472,  -1089,     94,    487,     18,     72,
        34,    -15,   -374,   -607,    316,    830,   -146,   4377,
      -301,    390,    838,    121,   -110,   -143,    -93,   2988,
      2914,   -352,   -353,   -744,   -115,     99,    495,   -343,
       309,   1261,   -519,    101,  -2662,    -44,  -3139,   -491,
      1142,   -323,    -50,    776,     86,    187,    480,    271,
      -167,      1,   -267,    -99,    991,   2492,   -152,   2423,
      -225,     34,    576,  -1486,   -236,   -375,    160,   -176,
      -145,   2525,   -131,    194,    317,   1215,   1553,    295,
     -1408,    130,   2279,  -1185,   2671,   -137,   -324,    -23,
        26,   -779,   -431,     -4,    488,   -186,    174,   -119,
      3062,   -149,   -168,    191,    169,   1124,    301,   1471,
      -409,   -999,   -166,   2174,  -1405,    992,   -179,  -2606,
       -71,  -3151,     92,   -976,   3091,   -322,    310,   -374,
      -779,    599,    -55,    425,   -697,     63,     27,    -38,
        86,    170,    -11,   -616,    -97,    525,     78,     14,
       684,  -5556,   -308,   -444,    266,   -396,  -1665,     86,
      -722,  -1087,   -921,   -525,      3,   -439,  -1600,    -37,
      2038,  -2672,   -187,    361,  -8192,    425,    365,     54,
       343,   -703,    253,    284,    -57,   -327,   -154,    392,
        99,   -181,    213,    395,  -2412,   -303,    182,     82,
      2311,     45,   1801,   -209,   -988,     42,  -1430,     38,
      -721,    118,   -163,   1279,   2184,    -18,   2851,    274,
      -363,    297,    150,   -220,   3653,   3135,   -381,    335,
       254,    378,    -52,     52,    328,   -383,    -61,   -802,
      -409,    -49,     49,  -8192,    362,    -48,   -430,    -54,
       255,    243,   -525,     14,    152,     10,   -392,   -301,
      -594,   -539,   1200,    626,  -2979,    233,  -1504,    664,
      -728,  -1293,   -491,    394,   1317,    298,    169,    214,
      -429,  -1083,     42,    389,   4751,    510,    299,   -542,
       456,   -852,     30,    208,    -63,   -131,     72,   -425,
        73,    213,   -287,   -277,     43,    128,   5528,    165,
      -316,   -135,   -576,   -583,    217,  -1298,     47,    134,
       103,  -1894,    148,   3406,    880,    964,   -697,    -94,
     -1626,    223,   1256,   -514,   2079,   -529,   1917,  -1452,
      -616,   -605,    385,   -963,    395,    105,   -154,  -1627,
      -214,     40,    969,   -708,  -1492,   -824,   2457,    275,
       404,    876,   -781,  -1029,     34,     72,    229,   -137,
       264,   -387,    305,    -57,   2908,   -143,   -249,  -2473,
       202,  -1467,   -364,   2094,   -521,    -70,    260,    132,
       465,     71,    982,    -36,   1792,    306,   2907,    -55,
       254,    421,    231,    140,   1727,    474,    761,   3153,
       -18,   -356,    414,   2218,    564,   -247,   -510,     67,
      2390,   2531,    240,    117,   -487,   -310,    261,    222,
      -286,   -861,  -2180,    480,    -75,   4769,   -407,    248,
       227,   -224,    302,    901,  -1200,   -728,   1025,    734,
      -336,    115,  -1726,   -179,    131,     43,   -357,    364,
      -681,    283,   -189,    715,  -2793,   -692,   1367,    916,
        28,   -500,   3094,   -543,   -627,   -709,   -506,  -1094,
        34,  -2464,    434,    257,    357,     10,   -390,   3206,
      3483,    137,    147,    180,    231,   -260,   -707,   -818,
       476,   -528,    656,    824,     -8,   3073,    362,  -3034,
      -199,     47,    694,   -252,    819,   -147,   -479,    -32,
       530,   -141,    -91,    251,   -154,    376,   -603,   2305,
     -2853,   -622,    316,   -680,    402,   -819,    323,    471,
       -47,   1772,   1507,  -1052,   -685,     18,  -2509,   -418,
       377,    -31,   -412,    105,   -906,   -267,  -2806,   -189,
       -97,    198,   -802,    -82,   -658,  -2980,    795,   -447,
       646,   1037,    486,   -689,  -2654,     55,  -3534,    540,
       -68,    502,    -90,    277,    -87,   -497,     24,   -246,
       400,    392,    348,     76,   -345,   -231,    -71,    155,
        -7,   -226,   6553,    371,    261,   -290,     88,    -44,
       311,    470,     -5,    182,   -105,     56,   -324,    267,
       241,    327,    966,    218,  -4695,   -968,     27,   -352,
      -315,    202,   -204,    435,    360,   -539,   -375,   -527,
     -1157,   1010,   -241,   4171,   -292,     66,   2343,    310,
      -682,    595,   3040,    539,   -118,   -573,   -128,    952,
      -172,   -547,   -285,     -1,    345,  -5701,    345,   -153,
        77,    349,   -225,   -364,   -655,   -270,   -716,   -825,
        27,     55,   2179,   -154,   -275,    359,   -501,   -992,
      -665,   1538,   -218,  -1159,   2176,   -845,  -3018,    105,
      -459,  -3146,     67,   -197,   -293,    539,    115,    -74,
       119,   -158,    -89,   1449,  -3006,    104,    651,    886,
      -310,   -242,   1219,   1805,    176,   2235,    579,    294,
       634,   1345,     -1,   -454,    755,  -1030,   1760,  -2404,
      -406,    894,    614,    -74,    113,  -1325,   1843,   -392,
     -3239,   2440,    -54,    222,   1349,   -695,  -1009,    434,
      -468,   -509,   -280,    462,    228,    573,    213,     55,
       325,    557,    100,   -721,   -674,    600,    795,   1567,
       407,   3273,    -58,  -1330,    349,   -181,    417,   -503,
       911,    350,   -681,  -4502,   -127,    -26,    330,    618,
       241,   -147,    284,   -226,   -127,  -2692,    484,   -146,
       -18,   -416,    755,     85,  -3119,   -404,      0,   -478,
};

static const int16_t cb4432l0[] = {
     -3764,   -227,    184,   -258,  -1713,    122,    410,    -32,
      -244,  -1337,   -328,    -20,   -236,   -359,    -13,    -52,
       -75,   -260,    426,    -96,    -37,    -38,    117,   -938,
       487,     60,    286,    571,    368,   -551,    198,   -102,
        15,    -11,   4535,   -127,   -241,    114,    -77,   -316,
       302,    195,   -149,    -73,    357,   -128,    -23,     34,
       319,    -97,    189,   5918,    -20,   -134,    -47,   -249,
         7,      3,    116,      7,     48,     47,     92,     19,
        14,     31,   -388,   -329,  -1878,   -944,    958,    632,
      1973,    182,   -130,   -193,   2309,   -868,     63,    260,
       -12,    -89,    -88,   -208,    127,   -168,    237,     74,
      1153,    925,   2292,   2992,    -35,    204,    766,   -930,
       -87,    341,   -101,    501,     35,   -182,    112,     91,
       -28,     79,    193,    -73,    -71,     52,     82,   -427,
      -147,    -69,   4722,    468,   -187,     98,   -295,    292,
      -991,     43,     98,    225,   -555,   -595,    -66,   -181,
        91,   -152,     -3,     89,   -219,    356,   -375,   -114,
     -1546,   -620,    648,   1946,     39,   -608,   -942,    103,
       179,    170,  -2350,    157,   1132,   -944,   -283,     64,
      -393,     15,    -90,    761,   -185,    644,   -360,      5,
     -5212,    106,   -136,    -40,   -159,    -40,   -120,    -43,
        -8,   -195,    208,   -179,   -295,    -63,     19,     32,
      -104,    -23,    132,    660,   -460,    237,    523,   -676,
      -378,    -81,   -184,   2718,     64,    531,   2119,  -1564,
       614,    933,      6,     65,    -50,     55,    243,   -539,
      1168,    953,   -283,     45,    476,   -346,   2285,   1892,
       615,   -521,     23,  -2079,     57,    -11,    208,   1029,
       371,     28,    170,    -63,   -167,    184,   -217,     76,
      -320,  -2747,    542,  -2098,   -407,    -10,   -876,  -1477,
      -306,    565,     57,    -49,   -111,    185,   -250,    120,
      -186,    214,   -520,    463,    792,  -2420,   2760,   -383,
      -783,  -1097,   -441,   -535,   1070,     78,     96,    122,
      -193,    516,    114,    100,   -413,    100,    -23,   -153,
      1267,  -4210,   -742,    228,    659,    399,   -169,    412,
       -81,   1056,      4,   -254,    173,    109,   -218,    196,
        64,     26,   -113,    -60,     -8,     15,   5497,    -76,
       169,   -294,   -394,    596,    379,     12,    -64,   -203,
      -138,     41,   -249,    -53,    -44,    -19,     55,    -34,
        99,     36,    -70,      8,     46,   2787,    842,   1917,
      -693,   -424,    151,    464,  -1162,   1027,    148,  -1027,
      -173,    328,     23,    792,   -184,    395,   -684,    229,
      -139,     -7,   2788,    404,     43,  -1508,   -590,      6,
      -184,    904,    475,    -37,    276,   -361,   1924,   -188,
      -113,  -1334,   -176,     11,    -34,    -70,    -68,     95,
      -433,    225,    437,   -451,    471,   -272,   -385,   2793,
     -2685,    544,    881,    409,   -789,    700,     -5,   -144,
        66,    -17,    504,   -397,    264,     74,    -81,  -1803,
       444,   -573,    633,   -391,  -3339,    192,    484,   1126,
      -306,    153,    303,     61,   -253,   -255,    -57,   -277,
       -88,   -100,     32,     79,  -1320,   -857,   3080,   1178,
       323,    353,   -149,   1316,   -399,    236,   -129,    231,
       323,    696,     59,   1217,   -567,   -268,    642,    384,
      -327,    -47,    466,   1530,   1092,  -1176,    612,    257,
      -143,   -270,    487,    -62,    332,   1089,    961,   -706,
       938,     78,     97,  -2805,  -1088,   -871,   -273,     87,
      -345,    148,    113,    167,     97,     31,     68,    -47,
       -53,     53,     29,  -5723,    -53,    -12,    241,     92,
       131,    139,     48,    102,    -26,    -47,    664,   -580,
        -7,   1287,   2531,   1061,   -710,     24,   1389,  -1742,
       254,  -1147,    539,   -150,    -24,    495,   -204,   -171,
       955,    202,   -111,    147,  -1458,  -3973,    421,   -416,
      -544,    392,   1419,   -178,   -168,    -53,     50,   -537,
        -7,   -346,   -289,    -52,    -38,   -259,   -115,   -136,
      -138,    -89,   -205,   -661,  -4429,   -110,    380,   -721,
      -180,    127,  -1371,    -78,    276,    319,    229,   -934,
       267,   -353,     44,     65,    449,    -32,    159,    -11,
       -22,   -571,    100,   -676,   2892,  -2740,    907,    511,
       248,    441,    -62,   -517,   -347,   -235,    319,     -8,
      -140,    309,    258,   -106,    215,      1,  -3252,    426,
       455,  -2213,   1031,    430,    746,    367,    602,    187,
      -147,   -200,     97,    555,   -107,   -249,    -71,    101,
        59,    -94,    -64,    -33,    221,    184,   -791,    671,
      -191,    284,  -1311,    402,    -29,    250,   -190,   -503,
        38,    106,    586,   4767,    526,    147,   -182,    249,
       146,     17,    293,  -1095,   1079,   -161,    141,     -2,
       681,   -275,   -171,  -4504,     61,   -105,   -306,    -66,
       229,     20,   -102,    -93,    334,   -189,      5,     -6,
       417,   2551,    -63,   -852,   1608,   1820,    670,   1592,
       102,    203,    147,   -767,   -147,    310,   -718,    175,
       551,    -98,   -202,    309,     70,     81,    -55,   1518,
       222,    338,   -356,    349,     97,     86,    495,   -233,
      -121,   2936,    200,    935,   -381,   2474,     53,    494,
       248,   -139,    -45,    100,  -1287,   -181,   -370,    311,
       287,   3016,    -96,   -128,   2146,    567,   -383,   -551,
       -96,    144,    495,    428,    -32,    137,     27,   -272,
      -149,      9,    -61,    177,  -5236,     91,   -837,    611,
      -279,    -74,    652,     14,   -178,    -82,    -89,    347,
      -245,    647,    -62,     49,   -215,     29,    -55,    -27,
       178,     79,    -19,    -59,    177,   -152,      0,    189,
       -10,    128,   -115,     33,     61,   -106,     56,    -13,
       135,    116,  -5772,    157,     43,     26,    -11,    102,
        -4,    -52,    208,   -186,    198,     99,     81,    -29,
      -103,    193,    -35,    -84,     -4,   -111,  -5251,     84,
        71,    -85,    -77,     55,    234,     38,      0,    -35,
        60,   5875,     98,     36,   -219,    -17,   -419,   -136,
        47,     34,     55,    -21,    -17,     -1,     72,     94,
        52,     -3,   -703,  -1437,   -518,    557,    121,    356,
      -345,   -717,   -438,   -279,     13,     70,    -95,     -2,
     -4170,     40,    136,     17,   -153,      8,   -149,    -27,
      -559,    268,   -237,    -82,   -220,   -921,   -588,   -150,
      3481,  -1906,    647,    675,   -455,    598,   -386,    -52,
        -7,    222,   -201,     90,     54,     75,   -283,    118,
      -375,   5768,     20,   -126,   -141,    -99,     64,    116,
        16,    -58,      0,    -31,    -15,    250,   -104,    -30,
      -144,    115,     12,    117,   -482,  -1709,   -436,    122,
      -246,     -7,    271,   1961,    154,    149,    -86,    147,
       258,    531,   1760,    914,  -1196,  -1800,    812,   -621,
       125,   -161,   1361,     50,   -651,  -1307,    360,   -785,
       205,   -156,    294,     21,  -3484,    -18,    -79,   -266,
       770,    307,     29,   -765,   -250,    183,     55,    131,
      1452,    260,    224,    221,   -347,    360,   -352,  -2188,
      -664,   -503,    313,    406,   -251,   3268,    210,    -46,
       129,   -276,    343,   -143,    104,    -55,    461,     17,
      -576,   -287,   -289,     33,  -2500,    -85,   -428,  -1137,
       918,   -245,   -490,   -260,   -270,   -133,   -591,    199,
      -294,   2784,    102,     19,   -109,   -745,     91,   -524,
       -44,     28,    252,   -511,    -80,   -146,    271,    519,
      -216,  -2280,   -411,   3699,   -368,   -538,    427,   -158,
       114,    -50,   -589,   -340,   -180,    703,   -186,    487,
      -649,    668,   -916,   -436,  -3684,  -1016,    877,    -65,
      -153,    -62,   -148,    -17,   -106,    142,    -73,     -1,
       -68,    567,   -658,    815,   2270,   -563,   -519,   -226,
      -223,   -282,    584,    240,  -1522,  -1935,   1169,    880,
       127,  -1276,   -127,    399,     63,     25,  -1297,   2131,
       592,   1652,   2609,     69,   -581,   -179,    947,    597,
       150,     35,      0,   -255,   -232,   -728,    239,     91,
       130,   -234,    231,     56,  -2181,   1774,  -2196,   1633,
     -1065,   -662,    777,   -175,   -128,    267,     -7,     51,
        27,   -133,     95,   -500,    188,   -167,     94,   -176,
       -29,    -65,   -161,   -141,   -694,   -968,    594,   -269,
      -422,   -472,   -731,   1210,   -816,   2142,  -1321,  -1746,
      -149,   -983,   1310,   -839,    762,    284,     99,    -31,
     -1169,    -84,  -1119,    -55,   -720,   -944,  -1115,   -271,
     -1032,   1064,    187,  -1013,   2987,     26,   -209,    516,
        -8,    107,    -24,    188,    278,    -53,    624,    460,
      -275,  -1881,  -2001,    851,  -1740,   -407,   1643,   -352,
       -17,   -528,   -538,   -175,    179,    416,   -297,     54,
       132,   -491,    -76,     34,   -440,    175,   2065,  -2006,
      -164,     38,   -403,    902,   -129,    215,   1545,   -414,
     -1183,   -532,    578,    248,   -308,    189,   -563,   -345,
      -949,   -279,   1693,   -959,    101,    783,      9,   1641,
      1494,    167,   -294,   -538,    951,    115,    590,    105,
      -847,  -1003,    464,   -368,  -1268,    641,    254,    243,
       488,   2636,  -1209,   -272,    437,    445,    781,   -463,
      -415,    538,   -811,    588,   1083,    206,   -547,    171,
      -585,   -744,    343,   -604,    395,    -76,    910,   -523,
      -108,   -449,    625,   -325,  -1079,    273,  -1473,  -1096,
      -137,   -565,   2077,   -623,    214,   -342,   -273,    769,
      1137,   -879,   -731,     56,  -1098,    211,    822,    579,
      -839,    164,   -600,    -80,     61,    316,    644,   1445,
       891,  -1796,  -1798,   -162,  -1631,   -492,   -626,    593,
       544,     66,     63,   -857,  -1273,    406,   1665,    899,
      -467,     87,   -117,   -469,    126,     30,   -931,   1446,
      -190,    388,  -1608,   -316,  -2199,   -127,    484,    -51,
        56,   -524,   1524,   -103,   1231,   -740,    717,   -861,
       823,   -665,  -1790,    411,   -690,    303,  -1615,     63,
      -232,     19,   1090,    -96,    137,     80,  -1027,    581,
       -61,    672,    133,    444,   -767,    766,    -42,  -3174,
      -270,    -23,   -126,  -1111,     67,  -1367,      4,    315,
       -53,    -90,   -165,     48,  -1657,   -117,    392,    356,
       792,   -610,   -618,   -219,    446,    102,    374,    207,
      1026,   2480,   -461,   -782,   1161,  -1351,   1032,    486,
      -308,    290,   -272,    899,   1912,     36,   -624,    286,
      -428,   -623,   -665,     12,   -621,  -1985,    -34,    468,
       318,   -467,    127,   -972,    -39,   -663,   2307,    -26,
       406,   -468,   -657,  -1404,   -342,   2356,   -395,  -1422,
     -1243,    465,     90,   -665,   -280,   -290,    -21,  -1752,
       280,    271,    395,    240,   -402,     55,   1077,    148,
      -309,   1818,    483,  -1293,     43,    261,    566,   -131,
       947,   -815,   -872,  -1021,  -1001,   -395,    263,   -555,
        78,  -2193,   -360,    -76,  -1029,   -493,   -464,   1339,
       -53,    750,   -671,  -1349,    133,    -70,    114,    501,
       766,   -816,    703,   -992,   -122,   -520,  -1323,  -2539,
      -365,    -35,   -555,   -888,   1515,   -191,   1322,   1633,
      -674,    451,  -1246,    270,   -868,    703,   -394,    106,
      -779,    754,    650,   1066,   -417,  -1305,    149,   -165,
};

static const int16_t cb4432l1[] = {
     -3867,   -448,   2202,    129,   -100,    393,     37,   -267,
      -156,     23,   -274,    222,     33,   -191,    104,   -140,
       -50,    -28,   -148,   -181,    -22,      6,    489,    993,
     -2764,   1191,   -773,    781,   -460,    843,    -77,  -1417,
       390,    124,   -203,    205,    662,    -16,    569,   -963,
       609,   -155,     64,   -293,   2649,  -2533,     70,   -472,
      -482,  -1732,    235,     -5,   -485,    116,   -177,   -104,
       314,   -355,    118,     25,    921,    285,    130,    -94,
        77,    121,   1068,   -435,   1407,    447,   -427,  -1096,
      -757,    258,     19,   3236,    702,    362,   -928,   -348,
      -150,   -784,   -687,   -388,   -176,    -38,     16,    -14,
      1017,    879,    935,   1280,   1014,    -85,   -256,   -103,
     -3384,   -928,   -200,   -406,   -175,    304,    -54,    195,
       -78,    676,   -356,   -167,   -165,    -56,  -3133,    156,
      -171,   -684,   -698,   -135,    230,    -30,     32,    542,
      1959,   -124,    -76,    162,    182,   -174,   1011,    -97,
       678,     10,    188,     30,   1086,   -262,   -157,    250,
       241,    233,   -584,   3276,   2126,    -50,   -207,    637,
      -440,    331,   -434,    251,   -267,    269,   -392,     68,
      -244,      8,    928,    827,  -1096,   -309,   -356,   -375,
     -3204,    422,    695,      2,    240,    595,    641,    582,
       342,     42,      7,    539,    -64,   -116,     82,     16,
        26,   -136,   -122,   -114,  -5814,     22,   -272,     10,
       113,    186,   -422,    -95,    309,    308,   -118,   -208,
        52,   -175,     12,   -106,     -6,     20,     58,   6053,
      -101,    -20,     10,     70,    189,     57,    -11,    210,
        83,    239,     -6,    -79,   -233,    -59,     31,    -30,
       -62,     64,    -38,     25,    -78,   -202,   -215,   -115,
      1477,    255,    101,  -2575,    186,   3140,    -46,    -45,
        53,   -183,    -89,   -412,    183,   -222,     50,   -237,
        96,     35,   1684,   -521,   -169,   -436,   -295,   1390,
       261,     27,    163,    352,     68,  -3677,     12,    310,
      -599,    331,    138,   -333,   -269,   -130,    -44,    -14,
       265,   -626,    258,    -59,     31,    -17,    222,    -10,
      -364,    280,   -183,   -235,   -217,     73,    -67,    114,
       196,  -5132,    269,    159,     -6,    -36,   -248,    274,
      -328,   2712,   -393,   2763,    507,   -110,   -166,    -84,
       -72,  -1111,    -19,    370,     25,      5,    156,    -32,
       237,    -57,   -106,    -22,    370,   -229,   1099,   4297,
       152,     72,    -56,    347,     64,   -501,    -57,    178,
       175,    -14,    -84,   -626,    555,    155,     20,    -75,
        20,    -33,   -254,   -125,     -9,    150,     91,     -7,
       -45,    239,   -109,     72,    -66,   -172,   -211,   6063,
      -205,    171,    -75,     50,    -75,     22,    109,     21,
       -58,     58,   -105,   -432,    310,   3782,    -18,  -1071,
        19,     20,   1455,    337,   -257,   -288,    -52,    519,
        43,     80,   -175,   -218,      9,    176,    -28,   -418,
       200,   -514,    351,    119,  -5920,    -96,    -33,   -289,
        74,     26,    120,    -37,    113,     47,   -145,    -17,
       334,     46,     47,     19,    274,    172,    159,   -404,
      3151,   -408,   -559,    987,   -178,    253,    -90,   -498,
      1454,   1183,    392,    762,    220,  -1207,   -220,    -69,
       -85,     22,   1644,   1858,    725,   1084,      0,   -257,
       290,   1712,   -151,   -188,   -390,    638,   -327,  -2185,
      -322,  -1116,   -150,    120,   -140,    198,    162,    -83,
      1321,    232,    242,    -52,   -456,    778,   -288,     65,
      2431,     37,     85,   -489,    862,   2776,    260,    -72,
       792,    100,     17,   -210,    588,     49,    600,    246,
      -258,    128,    -51,   -492,   -395,   -489,     50,  -5308,
       -67,    314,    124,     46,   -188,    -64,   -101,     51,
      -535,    108,     56,     -4,   -191,   -923,    485,    578,
      1320,    228,   -535,    310,    227,    395,  -1441,   2660,
       226,   -392,    221,   -686,   1749,   -175,   -904,   -571,
      -129,    154,   2622,    609,   -247,   -240,   -893,     98,
       291,  -2277,    411,    260,   -160,   2061,   -203,   -437,
       359,     21,   -101,     19,     49,     15,    -98,     82,
         3,   -555,    164,   -152,    -58,     38,    175,   -439,
       -37,     68,    -21,   -181,  -5556,    -27,      8,     48,
        21,   -151,    381,      3,   -152,    -74,    202,    -29,
      1863,   1713,   -922,  -1976,    551,  -1522,    525,   -116,
       146,  -1730,   -238,    -72,   -183,    126,    234,   -240,
        82,    138,    -60,   -131,  -2226,    226,   -702,    183,
       -81,    462,  -2851,  -1419,  -1005,    124,    -81,   -252,
       -65,    147,    -58,   -179,    306,    154,    122,    -69,
        69,     11,    115,    296,   3340,   -501,  -2580,   -804,
         9,    591,    -86,     88,    127,    588,    183,     48,
        79,    -38,   -199,     63,   -140,     29,     88,    -28,
       259,     69,   1743,   -531,    110,    -18,    776,    -18,
      -177,    112,     36,   -243,   -208,    528,    -47,   4709,
       107,   -125,    140,     -1,     22,     15,    416,   -194,
      -267,    -49,     43,     -3,   -308,    214,   -128,    140,
      5372,   -123,     70,    275,    210,    182,   -147,   -131,
       -84,     69,    116,     29,   -401,   -162,   -236,   -173,
       378,     45,    -12,    -77,  -6209,   -103,    126,     54,
       -19,    -20,     43,     64,     92,     -8,    -12,    118,
      -123,     58,  -3628,   -414,  -2147,     76,     95,    -99,
       357,    -10,    278,      4,   -608,    504,    105,    -72,
      -109,    -92,    -55,    367,   -167,     40,    -34,     76,
       220,   3434,   -366,    191,    248,     29,    187,   -177,
       155,   -348,   -341,  -2466,    272,   -136,    510,    139,
        81,    184,     33,   -299,     92,    -44,   -402,   -583,
      -725,   -400,   -159,    751,   -225,    377,   -160,   1556,
     -2652,    685,  -1077,   1276,    332,   -257,  -1449,   -282,
      -231,   -145,     58,    173,    421,    271,    401,   -186,
        79,   -258,    127,    252,    214,     96,    157,    195,
       205,    118,  -4771,    -95,   -164,    217,    477,    -51,
        -4,      8,   1450,    -51,    -52,    952,    675,    929,
      -273,    475,      9,    282,   -249,    236,    746,  -1407,
      -272,   1845,    692,   -105,   2690,    168,      1,     -1,
       157,   -599,    305,    255,  -2252,     45,   -199,    119,
     -3489,   -161,      6,   -263,   -259,    338,   -251,     61,
       153,   -124,    432,     -7,    131,      5,    305,   -322,
     -3283,    -32,   -336,   -273,   2243,    863,     -1,    681,
      -365,   -246,   -152,    375,   -133,    -15,   -208,   -104,
        89,    128,   -135,     44,   -255,    549,  -2751,    -48,
       270,  -2584,   -549,   -631,    445,    182,   -198,    743,
      -215,    -60,   -400,   1383,    167,    -65,    250,    146,
       185,     22,   -484,   -161,     86,   1758,    964,    404,
     -2574,   1026,      6,   -516,   -724,    315,  -1891,    311,
         2,    339,    -39,    324,    299,   -497,    -12,    179,
     -1242,    364,   -185,   -197,  -1474,    232,   -490,   4042,
      -105,    887,     31,    539,    235,     75,   -112,   -200,
       -31,     74,    -76,    -16,    -20,     38,   -159,   -143,
       114,    -77,   -110,     28,    -18,    -84,    -27,    -53,
       -82,   -224,     75,      0,    -46,    -64,     44,   -112,
        84,    -85,  -6030,    -24,    661,   -474,   -178,      8,
     -1023,   -396,    199,    -19,    -50,    -93,    385,    209,
     -1227,   2492,   2163,    986,  -1359,    399,    848,    681,
      -829,    211,    696,   -599,  -1398,   1951,   -113,    374,
       -17,  -1113,  -1708,   1294,    666,   1774,    623,    259,
       105,    961,    -87,     43,   -463,     65,    155,    -26,
       -31,  -1477,   -508,   1091,  -1463,   -524,  -1853,   1354,
       434,     86,    893,   -871,    151,  -1887,    205,    423,
       857,    -55,    -11,    -39,    341,     61,   1158,   2650,
       899,  -2491,   -593,   -843,  -1399,    -15,   -713,   -171,
      -195,   -523,    -46,    243,    117,    241,     -8,    140,
      -149,   -191,     70,    134,  -1158,   1933,   1135,  -2284,
     -1049,   1717,    378,   -155,    -37,    171,   -692,   -280,
       918,   -786,   -123,    558,    571,     39,   -315,     62,
        27,     59,    708,   -134,   -200,   -168,   -134,    148,
      -142,     25,    164,   -282,    284,    -95,    -35,    376,
       165,    367,   -335,    271,    249,  -4520,    176,    -36,
      -216,  -1303,    375,     92,    602,   -889,   -390,    284,
        78,  -1318,   1259,   1865,   1498,   2063,   -234,   -840,
      -391,     88,    168,   -235,    -74,     31,   -239,   1221,
        71,  -1637,   1513,     68,   2201,   1513,  -1099,   -622,
       426,    343,   -330,   -648,    381,   -156,     27,    -31,
       -92,    133,    210,    103,   -155,   2061,   -366,  -1173,
       -31,   -274,   -713,   -471,    509,   1044,    208,    403,
       486,    -66,   -521,  -1883,   -180,   -537,   1283,    -98,
     -1464,   -456,    508,   -619,   -546,    685,    944,    -85,
       311,   1172,   -194,   1406,    -99,   -827,   1506,    396,
       196,  -1534,  -1181,   1588,   1250,     47,   1034,   -171,
     -1247,    -98,   -120,   1181,  -2195,   -384,    945,    627,
        26,   -248,   1372,   -671,    214,   -649,    -17,    -44,
      -500,   -559,    577,   -601,     32,    421,    531,    344,
     -1233,    145,    348,    614,   -560,   -244,   -357,   -202,
       814,   -494,  -2320,    308,  -2277,   -481,   -518,   -431,
      -851,     43,   -204,    -26,   -742,   1083,   -130,   2002,
      1642,  -1156,   1746,   -529,    937,   -544,    416,   -741,
       763,   -232,    509,    243,   -458,     78,   -130,    143,
      -123,     71,   -666,   -105,     31,  -1061,    441,    -48,
       411,  -1547,    155,   -730,    439,   1624,    873,   -611,
      -470,   2348,   -157,   1184,    678,   -174,    542,    -95,
       -12,   -405,    237,    322,  -1194,   1903,   1496,    357,
       -34,   -661,  -1024,   2236,    860,   -256,    617,    756,
      -485,   -273,   -589,    536,    214,   -286,    782,    418,
       346,   -462,    443,   1056,   -914,   -304,   -564,   -332,
      1823,   2079,     93,   -975,   -891,  -1089,   -720,  -1127,
       702,    300,    787,    374,    -78,   1070,    691,   1339,
      -797,     57,    482,    432,    748,   1538,    673,   1885,
      -504,   1913,   -190,   -135,    881,   -139,     84,    379,
      -176,   -129,   -331,    -34,   -690,    282,   -563,     51,
        71,   -714,   -103,   1074,   -651,   -582,   1388,   -320,
     -1115,   1547,  -1088,    -65,  -2634,   -201,   -653,    116,
      -238,   -218,    476,   1417,   1671,   1135,  -1025,    614,
      -662,    127,    863,   -117,    726,   -971,   1382,   -286,
       465,   1195,   -715,    862,  -1256,    105,     37,  -1190,
      -442,  -1777,     50,    162,   1577,    580,    762,    253,
        92,   -308,  -1238,   -161,    295,   -150,   1733,   1831,
      -527,   -527,    -28,     70,   -359,  -1590,    860,   -221,
        47,  -1201,   -254,     39,    780,   -326,   1097,  -1019,
       834,    362,    357,     41,    693,  -1099,  -2687,    614,
       270,   -128,   -322,  -1149,    631,    -46,   -343,   1495,
      -896,   -864,   1545,    200,   -922,  -1133,   -637,  -1231,
       484,   -796,   -743,   -371,    999,   1300,    173,    -19,
};

static const int16_t cb4432s0[] = {
     -2558,   2751,   -440,   1200,   1067,   -725,   -492,    588,
       234,   -209,   -108,   -230,    223,   -231,   -235,   -132,
       -51,     88,   -290,   -214,    -99,    -60,    175,   2546,
      -991,    907,    446,    635,    284,    707,    238,    220,
      -308,    259,      8,   -435,  -2207,  -1487,  -1579,     46,
       285,   -249,    154,   -370,     37,     42,   1524,  -1853,
      1393,   1204,    126,   1751,     82,    136,    363,  -2411,
      -782,   -128,   -818,   -232,    765,   -173,   -127,    732,
       260,   -101,    868,   -249,    290,     32,    645,     55,
     -1742,  -1077,    392,   -568,    629,   -920,   -243,    791,
      -604,   -363,    117,  -1360,    -15,   -245,  -3655,     54,
      -297,     10,    124,     11,  -1114,   -567,   3882,  -2042,
     -1120,    -42,   -114,   -914,    419,    307,     44,    277,
      -101,    429,    170,    187,   -528,   -705,    348,    -19,
       180,    -76,     91,  -1861,   -181,   -171,    804,   -730,
       222,   -184,    349,    191,   -125,     14,   4270,   -467,
      -272,     29,   -216,    212,    426,   -222,     11,    -16,
      -852,    101,    576,    178,    351,    647,     90,    179,
      -681,   -187,     77,   4115,   -976,   -726,    711,    763,
       572,  -1166,    -46,   -445,   -103,    135,    294,    300,
        10,    737,    386,   -399,   -349,    -52,   5393,   -107,
       -32,   -229,   -154,   -181,     82,    -68,    -13,    -77,
        48,     75,    117,    -50,    254,    233,     98,     75,
     -2218,  -2214,   1491,    832,    225,  -1057,    267,    539,
      1963,   -245,   -353,    454,   -430,    -54,   -747,    -58,
      -438,    -90,    -64,    277,    214,   -105,    -47,  -1301,
      -404,  -1179,    682,  -4093,    764,   -270,   -342,   -367,
     -1378,      6,    -83,    429,    398,     61,   -149,    180,
        31,    169,   -218,    152,    -71,    -38,   2605,    679,
      -175,   -533,   1787,    611,    484,   -322,    158,   -561,
       125,    -35,    -42,   -190,    529,    449,    157,  -3105,
       106,    168,     -8,    -66,    -80,   1463,   1136,   4793,
       -98,   -432,    538,   -145,    241,   -158,    105,   -372,
        39,   -160,     92,   -223,     81,    245,   -142,   -162,
      -167,   -297,    -49,    -98,    582,  -5178,   1130,   -271,
       567,   -251,     55,    487,   -303,     31,    -25,     87,
       -70,    154,    -23,   -221,     70,    208,     48,   -137,
        46,     59,     -9,  -1397,   -970,    224,    714,    161,
        24,   -307,   1295,   1467,   -155,   -505,   -521,   -244,
       503,    -25,   -989,   3664,   -148,     12,   -135,    218,
      -159,   -156,   -769,   -421,    553,    715,    697,   -181,
      1426,    425,    -39,   -103,  -4558,    171,    347,    161,
       170,    128,   -210,    -35,     31,    125,   -264,   -135,
      -100,   2685,   -230,   2062,   1618,    -99,   -874,    926,
       757,    380,    404,    -73,     30,     29,    462,    725,
      -389,   -246,     20,    150,   -234,    -58,   -183,     10,
       156,    482,   -232,    124,    115,    180,   -615,   -395,
       330,    -85,   -435,   3279,   1493,    686,   1157,    245,
     -1067,  -1953,     23,    796,   -540,    175,     56,  -1931,
        89,    705,   -342,    551,  -1999,   1951,  -2305,   -497,
      -266,    275,  -1503,    351,   -355,   -353,    236,   -358,
      -271,    -40,    136,    217,    -13,    -45,  -2091,   1141,
       730,  -1888,   1131,    660,   1271,    439,   2597,     92,
       319,    -91,     62,    316,    287,   -260,    121,    -33,
      -117,    -22,    -79,   -170,   -164,   1486,    134,    -62,
       -36,  -3367,   -235,   1221,   1239,     78,    -54,   -489,
       268,   -560,   -774,    851,   -973,    -62,   -174,   -138,
      -459,    390,    -22,    -42,     83,   1339,   1307,    462,
     -3768,    511,    300,   -525,   -787,    -89,    675,  -2074,
        37,    -48,    252,    598,   -332,     67,   -187,      2,
      -106,    -35,   -148,   -186,   -542,    799,   2363,   -155,
      -665,  -2867,   -209,   -200,    -80,   1682,   1082,      2,
       516,   -481,    276,     -1,   -220,     54,    -12,    259,
       161,   -148,    566,  -1489,   -731,   1262,    499,   -816,
       115,   4057,    -71,    701,     39,   -132,   -223,    -16,
       229,     -2,    -40,    -61,    234,    405,    108,    304,
       -62,   -396,   1369,  -1438,  -2045,   1954,    759,    969,
      -166,   -235,   -115,    -68,   1923,   1815,   -776,   -855,
        34,    -63,     17,     87,    223,   -145,   -130,    -16,
      -313,  -1704,   -458,   -332,    420,   1332,    676,    878,
     -3847,   -360,    427,    537,    651,   -167,   -451,   -197,
       277,    136,   -201,    517,     10,   -156,     35,   -927,
      1250,   -173,   1004,   -169,    322,   -140,   -559,  -4656,
      -343,   -264,    -61,    -12,    195,    -10,   -123,    -23,
       -20,     -6,   -367,   -102,   -215,     41,    838,   1513,
       552,  -1609,   -753,   -763,   -656,   -633,     14,     35,
       141,    117,   -121,    857,  -1494,    578,   2546,   1034,
      -676,    571,    817,   -218,   -111,   1424,    -51,    878,
     -2860,   -257,    104,   -526,    782,    708,   2350,   -500,
      -342,    219,   -406,    836,   -117,    288,   -415,    798,
        14,   -311,   -455,      3,   -410,   -144,    -30,   -977,
      -145,  -2466,   -957,   1370,  -3201,   -327,    -85,    149,
      -580,    198,    350,    140,   -104,    327,   -128,   -178,
        58,    294,     50,   1814,    581,   -909,    287,   -267,
     -3992,     61,   -860,    258,   -271,   -223,    237,   -291,
        -3,     66,    110,   -620,    319,    -62,    177,    364,
       110,   -163,   -921,   -863,    251,   4922,    280,    121,
       128,    209,   -126,    578,    -56,     41,    124,    350,
       245,   -465,    -67,      5,    651,    147,    200,      0,
        21,   -609,   -332,     -3,    247,   -412,    128,     42,
     -1405,   -301,   -341,   -484,   -491,    -55,    361,   -100,
       -30,   -405,    643,   4249,    -31,    -91,    -10,      6,
       425,   -350,  -1501,    817,  -1348,   -201,   -345,  -3643,
       235,    691,    332,    219,    199,   -398,    130,    -50,
      -190,     89,    -23,    100,   1327,   -200,    146,    482,
      -624,   -479,   -391,    188,    129,    614,   -335,   -564,
      1021,   -107,   -199,    145,    201,    571,   1276,   4253,
        58,    121,    295,     38,     26,     47,  -1333,   1138,
      3125,    357,    -72,    347,    276,   -272,    120,    -77,
       535,    247,    -71,  -2054,  -1860,    -73,    -62,    266,
       -30,    183,     17,    -46,     -7,   -140,    997,    526,
       -47,    -59,   1540,    373,    162,   -150,   -107,    -74,
      -278,    -37,   4268,    -21,   -269,    359,    111,   -115,
        -5,   -206,    -87,    -44,   -517,     54,  -2859,    189,
      -297,   -863,   -918,   -929,   -543,     25,  -2866,    -79,
     -1101,   -275,   -410,   -458,    -75,   -211,   -420,     96,
       467,    -66,    -15,   -580,   -420,   -586,     -7,    109,
       236,    227,   -488,    106,    258,     76,     78,     -8,
      -199,  -4888,   -134,   -205,    -33,   -243,    -19,    -10,
       157,    129,    120,   -928,    604,   -345,    -47,   -430,
      -257,    273,     81,   1949,    490,    272,   -205,   2460,
       -54,    103,  -2924,   -529,   -211,    -60,    279,    220,
       -57,    342,    209,    984,  -1410,  -3363,  -1028,  -1301,
     -1293,    227,   1142,  -1068,   -512,    758,    364,     46,
      -358,     16,    257,   -158,   -253,   -182,     -2,    181,
      1475,   1574,    215,   -968,    246,    369,   -273,   -717,
       546,     74,  -3872,    293,     98,    130,   -244,     41,
       143,    699,    -56,   -126,     67,     54,     -2,   -878,
      2334,    883,    215,  -1979,    246,   -759,    499,    248,
       751,   -202,    580,  -3018,    359,   -139,    210,    -47,
      -168,     89,   -659,    259,    -54,    -40,   -490,   -169,
      -769,    569,   -171,     64,   -845,    519,   1251,    -71,
      -459,  -4436,    257,   -334,   -826,   -183,    115,   -408,
       -77,    544,    173,   -258,     48,    331,   1735,   1035,
      2793,   1154,  -1901,    275,   -109,  -1185,   -403,   1332,
      -282,     36,   -367,     21,     27,    362,   -425,    217,
       150,   -304,    192,     53,  -1100,     27,    628,    698,
      -634,    -25,     84,      8,   -103,    533,   -301,    218,
      4350,    119,   -109,    309,     24,   -352,   -147,   -274,
       156,     85,      9,   1706,   -854,   2012,  -1573,    112,
      -673,  -1538,    -91,    415,  -1525,    866,   1493,   -621,
      -396,    277,   -604,   -363,    114,   -360,   -252,    -18,
       -31,    -77,   -591,   2483,    535,  -1520,  -1057,  -2189,
       -51,    798,    276,  -1426,     72,   -303,    402,    111,
       327,    272,     -8,   -216,    189,   1282,    152,    -45,
       -33,   1524,   2301,   -341,   1992,    939,   1678,   1011,
       114,    167,    586,   -500,     40,   -473,   -274,    596,
      1237,   -126,    205,    254,   -284,   -367,   -119,     64,
      1915,    437,   -585,      1,    402,   -271,   -984,    530,
       267,   3634,    495,   -219,   -728,    -67,  -1340,    983,
       122,      6,    110,   -166,    111,    102,   -139,  -2499,
       753,   1011,   1755,  -1252,    872,   -510,  -1844,   1388,
      -782,    287,    461,     36,     77,    437,   -361,   -216,
      -415,    158,    -77,   -123,     57,    -93,   3408,    504,
      -942,    434,   -648,   -251,   -420,   -387,   1373,   -229,
       236,   -191,      3,    204,    612,    393,   -285,    560,
      -164,   -199,    303,    146,     93,   1248,   2425,   1001,
      1261,   -239,   1085,  -1878,   -375,   -544,   -995,   -192,
      -319,    542,    280,   -716,  -1323,    -67,    -34,    252,
       -36,    206,   -126,    -28,     26,  -1135,   2799,    527,
       -47,  -2008,    509,   -232,   -953,    332,   -386,   -108,
       290,    507,    578,   -809,    375,    850,  -1413,    831,
      -137,    259,     25,  -1075,    407,   1784,  -1539,   1658,
      1450,   -969,    467,      4,    785,   -595,    912,     34,
        91,    286,   1035,   -524,    276,   -322,     11,    651,
       733,    243,     45,   -145,    357,    524,   -697,   -259,
      -757,  -1057,    181,   1324,    148,   -502,    -64,   -379,
      -746,   1385,    395,    184,   -749,   -197,  -3375,   -546,
        -4,    532,   -270,    687,    501,    285,    401,    431,
     -1888,   -639,    655,   -325,   1896,  -1883,     53,  -1018,
     -1475,    802,   -486,    -68,    232,   1337,    428,    232,
      1754,  -1687,   -518,   -372,    508,  -1269,    327,   -900,
      -468,   1127,   1397,   1597,    837,    659,   -617,     99,
       264,   -460,    296,     44,   -295,   -209,   -174,   1105,
       896,   1065,   -174,      5,    845,   1311,   1370,  -2548,
       351,   -660,    -24,  -1089,   -787,  -1312,    -22,   -585,
      -197,    749,    293,   -112,   -169,    -23,      3,   1151,
       529,   1173,    224,  -1517,    930,    -52,    268,  -1282,
      -559,    466,   -528,   1506,   -231,   -337,    993,  -1314,
      -250,  -3042,     57,     19,     15,   1812,    697,   -389,
      -201,    647,   -723,  -1098,   -177,   -225,  -2694,   -495,
      -431,   -238,    388,  -1731,    997,    227,   -765,   -222,
        94,   -611,     35,    187,   -935,  -1470,   1013,   1051,
      -378,    311,   -710,   -566,   -532,   -369,  -1599,    553,
       167,    450,  -1068,   2834,   -125,    601,   -113,   -503,
        40,     14,    -36,   -220,  -1543,    867,   -612,  -1834,
       888,  -1791,   1296,   -229,   -593,   -760,   -197,    428,
     -1290,    892,    -62,   1113,  -1228,   -965,    -90,   -300,
       288,   -133,    779,  -1211,   -627,    268,    180,    913,
      2230,   -413,   -146,   -217,    170,  -1157,  -1551,    877,
        75,   1784,   -174,   -230,   -757,   1243,    625,    -49,
       114,   -218,   -409,    195,  -1165,   1492,    213,   1100,
      -101,   -957,   1016,    663,   -704,    817,     94,   -279,
      -256,    469,    -75,   -123,  -2954,    948,   -407,    275,
};

static const int16_t cb4432s1[] = {
      5416,   -223,   -123,    156,    -33,    185,   -144,   -108,
      -199,    -68,    -36,     11,     37,    124,   -301,     58,
       -21,    155,     99,    -10,    -78,    -26,    -70,  -3160,
     -1037,     98,    155,   -373,    834,    652,   -277,   -429,
      -529,   -103,   -358,    187,   1161,   -157,    147,   -400,
       461,    156,    237,    481,    -67,     99,    939,   1179,
      -659,   1337,    578,   -489,   -481,   -427,   -622,    131,
      1826,   -734,   -995,     -5,   -461,    514,    -83,   -271,
     -2928,    -86,   -382,   -205,   -133,   -386,   -195,    -67,
       508,    586,    607,   -910,   -181,  -2046,   1212,   -179,
        23,    408,  -1929,   2044,   2160,   -879,     74,    179,
        72,   -164,     47,    162,   1497,    826,   2978,   -912,
       454,   -618,  -1907,   -501,   -494,   -299,     96,   -138,
      -114,    -51,   -171,    445,   1144,   -187,    217,    224,
       402,     13,     42,    -58,  -1692,   4162,   1272,    970,
      -278,    327,     88,    -31,   -182,    279,   -610,     78,
      -432,   -147,   -142,   -725,    -17,    -95,    388,    133,
       -61,     28,  -1365,   1441,    606,    411,    923,   -332,
      1843,   1934,  -1451,   -514,   -283,    768,    940,   -428,
        31,   1105,    248,    -78,  -1477,   -367,    404,     68,
      -178,     17,    691,   -265,   -105,   1681,   -476,  -1307,
     -3434,  -1700,   -524,   -871,    472,   -171,    237,    104,
      -142,   -231,   -292,   -285,    266,   -259,   -166,    -97,
      -432,   4003,   1220,   -356,   2110,   -220,   -465,    -48,
       117,   -178,    290,    -21,    205,    -19,    321,   -343,
      -328,    -57,    215,   -345,    304,      2,     10,  -2071,
       185,    433,    212,  -1165,    112,    242,   -294,   -162,
      1107,   1176,   -396,   1400,  -2600,   -434,   -640,    457,
       100,   -268,    809,    128,   -236,    -66,    -94,   -842,
        82,    163,    227,  -2641,   -485,    291,   -326,     42,
       234,   -648,   1355,   3016,  -1403,    -71,    188,    792,
        15,    -16,   -522,    -75,    106,   -824,   1133,    947,
       477,   -642,   -531,   -808,   4100,    -34,   -407,    133,
        33,     15,     63,     72,   -223,    -15,   -491,     38,
        47,    258,   -236,    192,   1628,    173,  -2116,    687,
       295,    -74,   -183,     95,    529,    149,   -372,    182,
      1317,     21,  -1424,  -3156,   -111,    -96,    580,    284,
      -274,     41,    145,   1314,     79,   1830,    262,   -325,
       -16,    169,   -245,  -2038,   1959,    892,    946,    303,
      -171,   -432,    883,     34,   -238,   2463,   -294,     25,
        24,   -106,    -45,    509,   -154,    496,    109,    115,
       169,    702,    396,    -97,    657,   -251,   -112,   -114,
      -144,   -230,    517,   -190,   4885,    -45,   -152,     -9,
      -170,  -2021,    541,   -905,  -2015,   2588,   -936,    -20,
      -300,    384,    433,   -123,    119,   -505,   -126,    295,
       526,  -1352,    450,    142,   -126,   -115,      1,   -140,
      -734,    672,   -147,   -660,   -747,    652,    161,   -163,
        51,   -616,  -1974,   1413,  -3145,    922,  -1289,    215,
       182,   -838,   -171,    107,   -333,     34,    216,   -307,
      -359,    496,   -343,   -325,  -2552,  -1573,    588,   -441,
      1296,  -3075,    119,   -131,     54,    206,    278,    106,
      -100,    112,    220,    -49,    -80,   -229,   1051,   3271,
     -1300,    324,    -31,  -1025,   1659,   1526,   -161,    669,
       -56,    430,    201,   -535,   -126,     -9,   -380,    222,
       212,   -345,   -282,    195,    -41,  -1235,   -593,   -593,
      1557,     71,   1023,   -831,    545,   -875,    161,   -772,
        99,   -190,   1616,    338,   -251,   -201,  -3104,   -774,
         4,   -121,    178,    -80,    652,  -1018,   -441,   -343,
      -236,   -240,   -244,    -26,   2192,     75,  -1348,   3771,
       -22,   -850,   -251,    316,    132,    -21,     63,    104,
       152,    185,    -40,    275,  -1356,    482,   3081,    571,
      -481,  -1387,    815,   1285,   -352,    -98,    -41,    573,
      -307,  -1879,    427,    196,    169,    -26,   -232,    -98,
      -411,   -231,  -2034,   -969,    271,   1421,  -1485,   -407,
      1404,   -343,    861,    888,    -11,    202,   -245,   -397,
       104,    229,    309,  -2757,    315,    416,    393,    194,
      -176,   -663,   -166,   -229,    244,   -152,    183,     24,
      -205,     97,   -255,   -299,    123,    -12,     53,    102,
      -362,    371,    223,     46,    132,  -5177,    157,    -92,
     -1114,    -28,    135,   -831,    627,   -428,  -1116,    421,
       761,    458,   3256,   -167,    355,   2045,    113,    234,
      -154,     20,    -39,     61,    -81,     63,     98,   -171,
      1727,  -1193,   2103,    416,   -421,   -575,   -636,   -114,
       700,   -260,   1610,   -336,    521,   2591,   -738,     43,
       103,    -63,   -335,    168,    110,     41,   1995,   3554,
      1443,    -53,   -206,    992,    767,   -372,    141,    -24,
       173,     60,   -237,     69,   -173,    -73,    137,    167,
      -164,   -159,    312,   -151,    -78,    619,   -192,    689,
       -69,  -2805,   -259,   -288,   -231,     28,  -1682,   2316,
      2298,   -336,   -131,     59,    542,   -218,   -281,   -214,
       -41,    116,    138,      8,   -297,    -45,   -215,   -167,
      1587,  -1061,  -1976,   -445,    401,  -2392,    -42,    581,
      -519,   -230,   1461,    542,    113,   -634,   1776,    332,
       191,      5,    174,   1939,    -26,   -242,    120,    230,
      -986,   3501,  -1125,    -89,      3,   -580,   -219,   -255,
        37,   -119,     94,    -17,   -297,   -176,   -434,   -234,
        55,    -63,  -1167,   -492,  -1753,  -3397,    185,   -794,
       689,    819,    -32,   -836,    335,   -133,    724,   -299,
      -318,    424,    558,   -654,    119,   -447,    140,   -100,
        72,   -872,  -1432,   -203,    -40,    -14,    -59,    550,
        85,    -53,   5007,    258,    401,   -184,   -313,   -170,
        66,   -185,    -82,    -61,    210,     48,   -204,    -96,
       130,   -562,  -1700,  -1037,  -3926,   -884,   1115,     -6,
      -100,    842,   -450,    877,     76,    568,   -623,     27,
        73,   -195,    328,     41,    -24,    124,    -77,   1499,
       540,  -1064,   4517,    -22,    -35,    839,    -48,    253,
      -259,     96,    409,     90,     26,   -177,    365,    -48,
      -324,    -26,    -23,    -83,    -77,    -80,   1599,   1486,
       266,    659,    236,    231,    -16,    359,   -163,    455,
      -999,  -1169,   2453,   -599,   -945,      4,  -2110,   -174,
      -736,    344,    232,    142,     32,    -99,    763,    133,
      -325,    -56,   1635,   -439,    843,      2,  -1704,    -13,
       771,   3680,    -89,    182,      4,     42,    394,    404,
        82,    312,     91,    141,  -1577,   1765,   3141,    625,
      -271,  -2122,    423,    353,    489,    606,   -290,   -190,
       486,   -131,    118,    236,    248,   -209,     -2,   -162,
       -95,     95,    170,    278,  -2233,    549,     34,   -846,
      3595,    445,   -400,    -65,    131,    -14,    -16,    611,
      -116,   1293,     98,   -680,    189,    217,    -15,   -549,
       131,      8,   -768,  -1082,    841,   -346,    129,    -33,
      -778,    322,  -2508,  -2128,  -1895,  -2021,    -27,    -42,
       -51,   -536,    239,     -1,     78,    105,     48,     79,
       207,    422,   -181,     18,    -94,   -152,   -181,  -5012,
      -187,     -3,   -118,   -397,    -84,    -49,    129,   -276,
       188,     45,   -146,   -235,   -109,     83,     32,    -79,
      2039,   -616,    257,  -1575,  -1756,  -2364,    222,    195,
     -1138,   -290,     58,   -641,   -252,    -11,    402,    -31,
     -1040,   -592,    676,   -118,   -231,     94,   -123,   1642,
      1404,   -334,   -728,  -3425,    382,    111,   -194,    677,
       177,   -182,    434,    860,  -1022,     84,   1214,   -733,
       300,     -2,   -259,    140,     35,     96,   1164,  -1476,
      -757,    -74,    239,   -203,   1796,   1207,   1732,  -3029,
      -610,    658,    490,   -465,    136,     56,   -614,   -612,
      -123,     93,   -151,    162,     56,    502,   1634,  -1825,
        45,   1033,   1554,  -2380,   1615,   1317,    786,    387,
      -255,   -423,    -44,   -246,   -213,   -149,    107,    -74,
       -94,     45,   -204,     13,  -1959,    936,   2023,   1000,
      1031,    112,    574,    323,    163,    947,   -657,    492,
     -2624,    -44,    739,   -305,    -31,    247,    270,    213,
       -46,    -90,     43,  -1504,    931,    -61,   4045,   -863,
       389,   -386,   -130,   -374,   -583,   -800,   -900,    158,
      -455,    169,    134,   -164,     54,   -117,   -185,    -90,
      -203,    -41,   -811,  -2082,    169,    287,   -378,    -15,
       231,     83,     89,   -187,    198,     18,    178,    -18,
       527,    -40,     94,     54,     79,  -4356,    248,    162,
       -94,  -1431,    -31,  -2048,    651,   1231,   -508,  -1089,
     -1255,    766,   1673,    357,     13,   -813,  -2403,    179,
      -470,     65,   -339,    154,      9,     56,    246,     66,
     -2308,   1443,   -947,   -744,  -2473,  -1248,   -113,   1017,
      -608,    149,   -182,     41,   -524,     16,    285,   -268,
      -781,    -57,   -346,    194,    256,    -51,    107,   -484,
      -190,   -125,   -645,    487,    314,     74,   -555,  -1012,
       325,     76,    233,   -205,   -189,    -48,  -4593,   -122,
        10,    121,    -91,    108,    -49,    254,  -1662,   2500,
        87,  -1540,   -200,    287,   -329,    -50,   -401,    182,
     -1300,    689,    915,   -224,   -768,    471,   -339,    133,
       407,   -344,     99,     96,    111,   1224,  -1431,   2069,
      -282,    127,    397,   -119,   1332,  -1299,    744,   -535,
       800,    327,    874,    700,   -424,  -1596,   1365,   -651,
      -151,    113,    102,    -24,    464,    125,    911,  -1583,
      -372,    747,      2,    429,    -47,    -64,     34,   1700,
      -741,    343,    728,   -226,   1889,     78,   -515,   2827,
        77,    -66,    108,    515,     90,   2227,   -678,   1301,
      -974,    122,   -983,   2357,     64,  -1479,    186,   1436,
      -245,    204,    460,    191,   -677,   -335,   -200,   -135,
      -106,   -101,   1112,  -2733,   -641,     73,   1265,  -1281,
     -1332,   -743,    675,    129,  -1144,  -1169,    331,   -143,
       -87,    809,   -891,   -848,    246,    243,     97,   -170,
        36,  -1109,    102,   1055,  -1395,   1384,   1155,    439,
     -1549,   -300,  -2069,   1014,    187,   -782,    980,   -971,
      -345,   -583,    -66,   -138,   -317,   -124,     48,   -152,
       -98,     92,   2446,    128,  -1232,   2148,   -337,   -615,
       467,   1573,   -613,    857,    303,    422,  -1340,   -420,
       305,   -626,     94,   -496,   -386,   -129,    243,     27,
      -200,  -1373,   1468,  -2040,    151,   -675,     65,   1464,
      -432,    545,    269,   -510,    584,  -1935,    970,   -319,
      1465,    490,    263,    555,   -256,    -49,    315,   -242,
      -394,   -312,    -88,    201,   -121,   -302,    172,     49,
       234,     59,    327,    155,    199,   -187,    -41,    -74,
        52,    -31,    -59,  -5574,   -121,    282,    343,   -125,
      -200,   -575,   1328,    155,  -1928,    250,    702,     21,
     -2718,   -153,   -102,   2131,    612,    432,  -1072,   -457,
       222,    427,    144,    149,   -433,  -1573,   1337,   -650,
       176,     13,  -1273,    280,   -751,   -236,    453,    204,
     -1595,  -2896,   -272,    233,    485,     82,   -139,   -528,
      -140,   -399,    -56,   -274,   -335,    176,   -756,    243,
      2250,   -305,    721,   1711,      7,  -1230,  -1590,  -1872,
      -137,   -714,    263,  -1643,    362,   -266,   -176,     64,
       -36,    -63,    687,   -483,  -1488,    709,    929,   1349,
     -1245,    645,  -1619,    735,   -651,   1850,   1031,    159,
      -625,    838,    242,   -396,   -397,    -41,   1237,    304,
        81,    -94,   -736,    578,   1279,   1064,     81,   1900,
      -179,    224,    266,   -429,    734,    500,    995,   -882,
      1563,   1813,   -519,    758,    532,    -27,     27,    453,
};

static const int16_t cb4432m0[] = {
     -6132,   -262,   -273,  -1250,   -577,    984,   -430,   -410,
      -464,    577,   -578,   -178,    -32,    369,   -624,    267,
       -68,    474,   -480,   -225,    166,   -409,    437,   4633,
        98,  -1560,   -464,   -869,    103,    193,    461,     72,
       292,   -245,   1102,    417,   -325,    461,     74,     43,
      -120,   -213,    333,    160,   -468,   -212,     31,    -81,
      6516,    182,    201,   -212,    -66,    -49,   -266,    148,
      -108,     98,    -46,    -11,    -59,    -20,    -20,   2332,
      -294,   -560,    198,   -647,    -47,   -638,  -3877,     11,
       834,    547,     47,   2541,   -126,     -5,   -366,    339,
         3,      2,    -66,     60,   -526,    914,    321,   -658,
      3605,     59,  -2392,   -655,    384,    775,    366,    327,
       356,    386,    751,   -375,     38,   -205,    -15,   -442,
      -212,  -1241,   1913,   -421,   -755,     45,  -1637,    -36,
     -2435,   1504,  -1248,   -763,   -664,    133,   -123,    814,
       241,   -243,   -446,     66,   -131,   -213,   2036,   1294,
     -2138,    677,  -1042,   -771,    294,    371,    474,     85,
      1403,  -2618,   -478,   -537,    275,   -826,    349,     84,
       264,   -272,    -61,   -705,    175,   -972,    868,     25,
      4183,    881,   -639,   -833,   -757,  -1063,   -991,   -257,
      -137,   -619,   -285,   -454,     77,   -169,    316,    -45,
      4362,   -203,  -2132,   -424,   -820,   -503,    340,    340,
      -612,    648,      2,   -342,     81,    630,  -1518,    235,
       216,    210,    665,    231,    130,   -879,     38,    675,
      -136,    -48,    540,   -234,   -152,   -169,  -5745,   -294,
       -24,      8,   -129,     -8,    308,    -14,    -16,    147,
        62,     70,    248,  -2014,     76,   -190,   -328,  -1899,
      -353,   -140,    836,   -365,   -112,  -3945,   -736,    467,
      -258,    601,    617,     74,     62,    394,    180,   1151,
      -810,     36,    457,    406,     75,     -8,  -5004,   2335,
      -108,   -123,    299,   -335,    112,   -499,   -268,   -185,
       461,    208,    -38,   -164,    764,   -504,    272,   4853,
       396,    265,  -1133,   -433,    769,   -458,   1005,    645,
        81,   -172,    385,    -56,   -130,   -393,    128,    -73,
        31,   2038,    127,   -436,    123,  -2525,    282,   -448,
      -489,   -295,    -14,     85,   -462,    -49,    262,    -93,
       238,   -148,  -3953,   -414,   -259,     33,   -892,    459,
     -2186,     60,    444,   -610,    844,   -486,   -299,    219,
      -433,     19,  -1183,    276,    -29,    388,   3327,    102,
      -914,   -221,    486,   -892,   -550,    190,    151,   -141,
      -336,    194,   -242,   -224,    405,    879,   1600,    349,
     -2082,    -38,   -514,     18,  -3574,    161,   -142,    -38,
     -1815,    540,    228,     33,    164,   1074,      4,   -278,
       -58,   4085,   -295,   -795,     31,    494,    555,   -250,
        22,   -202,   -312,     92,    109,   -238,   -448,   -622,
     -1511,  -4346,   -417,   -706,     37,   1157,    -96,   -199,
       -59,    285,    -43,   -217,    -22,    -95,    103,   2242,
       244,     45,    -74,     -7,    366,    -79,   -359,   -286,
       188,    -14,     34,     49,    245,   -108,    -84,     88,
      -333,   -216,    -79,     15,  -5710,    -36,   -102,   -552,
      -213,     -8,   -356,    515,    212,   -265,     80,    316,
     -1163,   -561,   -517,   -714,   -375,  -4176,     73,   -666,
      -363,    -28,   1248,    -68,    478,   2648,    642,   -710,
      -555,   -744,   -166,   -744,   -596,    138,    499,     59,
       453,   -583,   -290,    -11,    -48,   4174,   -252,    -74,
       -78,    -62,    449,   -265,   -818,   -357,    171,   -513,
        72,    106,    -45,    649,    145,   5558,    -60,   -136,
        69,   -172,   -134,    -66,    -68,    100,    683,   -427,
       795,   -407,    345,   4930,   -838,    361,    279,   -190,
       173,   -341,     -9,    722,    383,   -140,    123,   -269,
       154,     31,    335,   -465,    311,     46,   4535,   -131,
        90,    151,    287,    -11,   -526,   -614,  -2253,   -321,
       -93,   -550,   -128,     25,    303,   -139,     19,      0,
     -3255,   -161,    276,    103,   -245,   -515,    816,  -1042,
     -1449,   1693,   -627,   1287,   -837,   -727,    -80,   -478,
      -337,    116,      1,   -270,   -567,   -311,   -407,  -1656,
      -216,    196,   3004,   -285,   -521,   1510,   1818,   1392,
        42,    -44,   -244,   -349,    959,   -183,     25,     58,
        43,   -345,   -310,  -8192,    -84,    311,    -60,   -348,
       125,     33,    -79,   -138,     88,    138,   -121,    -37,
      -211,   -118,   -142,    -37,   -132,    181,    162,  -1423,
      1781,  -3453,   1261,    134,    670,   1218,    761,    292,
      -146,   -825,    672,    737,    293,    433,    245,   -392,
        46,    598,    257,   -234,  -1201,    718,  -4549,   -573,
      -696,   -224,    -85,     75,   -268,    244,   1817,    341,
      -166,    436,   -386,  -1247,     22,   -112,    -55,   -451,
       106,    388,    -32,   -254,  -2400,   -373,    892,    334,
     -4114,   -307,   -107,   -316,     41,   -214,   -403,    -56,
      -469,   -246,    120,   -237,    266,     43,   3257,  -3925,
       291,    239,    752,   -411,    162,    437,    159,    256,
        37,     71,    -79,   -136,   -475,    124,   -208,   -216,
      -245,     16,     40,   -459,  -4320,    340,  -1462,    914,
        10,    490,    436,    162,    271,   -238,    -38,   2219,
        25,   -141,    405,    107,    235,    282,    -55,     -7,
     -3429,    565,  -1095,   -678,   1979,    233,   -874,    592,
      -474,    680,    402,   -738,     21,    274,   -321,    655,
      -348,   -546,    510,     62,     23,   4722,    572,    423,
      -256,    473,   1240,   -997,   -899,    -53,    -73,    332,
      -902,   -771,   -335,      0,    769,   -587,    592,   -703,
      -600,    -77,    -94,   -207,    792,   -133,   -758,    500,
       -14,    330,     22,   -281,  -5460,    152,    607,    337,
       -39,   -118,    -80,    -51,    228,     65,     -6,    540,
     -3515,  -1712,   -449,   -157,   -164,   -195,  -1655,  -1285,
        90,   -517,   -116,     11,   1402,   -162,    -64,   -103,
        46,    302,     37,     71,   2903,   2952,    780,   -487,
      -297,   -426,   -369,    150,   -129,   -233,    813,   1639,
       190,    310,   -311,    320,     94,   -247,   1484,    -32,
        70,   -220,    560,    372,     54,    205,     96,  -3567,
      -680,   1683,  -2377,     17,    548,   -266,    257,    656,
       331,    205,   -121,   -814,    139,    326,   -370,    625,
      2035,    818,    775,  -1165,    -41,  -4258,     41,   1109,
       984,   -885,    -43,   -314,    204,    204,     95,    407,
      -351,    101,    133,   -929,    899,     -6,    384,   -177,
      -330,    240,     90,     78,   -318,   -455,     -5,   -365,
       -61,    -80,    -72,  -4850,   -338,   -384,     30,    181,
     -2721,   -767,   3217,    453,   -226,   -582,    283,    135,
      -103,    265,    494,  -1444,   -120,     70,   -976,    -67,
       -90,    660,    366,   -609,     32,    205,     73,     51,
       346,     -6,   -120,    -10,    300,     32,    270,    139,
       -55,    453,   5712,    353,   -145,    176,   -168,    216,
       205,    -30,   -304,   1085,    221,    464,   -426,   1662,
     -1397,  -1114,    301,  -1058,   3553,   -388,    743,    696,
      -893,   -296,    -57,   -254,   -251,   -178,    417,     82,
      -988,  -3566,   2171,  -1312,   -954,    -23,  -1349,    480,
       566,     24,   -643,   -292,    -68,    303,     73,    -81,
       296,      7,    371,     94,   1718,    498,   -774,    857,
      1014,    358,    436,    210,  -3481,   -202,   -416,     59,
      1987,    137,   -476,     32,   -627,    193,    368,     -3,
      -290,  -3035,   -352,   -455,   -609,   -175,     -5,   -600,
      -181,   -249,  -2551,    226,    105,   -249,   1851,    -86,
     -1203,    214,    -57,   -505,   -522,   -247,   -154,    -40,
       -17,   -523,    333,  -1777,   -354,  -1568,  -3492,   1032,
      1577,     90,    153,    534,   -106,   -538,    102,      3,
      -198,    -99,    -23,    835,   3495,  -1099,     44,    732,
      -350,    926,   -472,    533,   1529,     54,   -844,   1295,
       573,    414,    -23,    -71,    279,   -891,    287,    126,
      1456,    973,    456,   1608,   -646,  -1244,    452,    651,
       694,    855,   -235,   -503,    745,   -544,  -3512,   -138,
       678,    473,    220,   -273,     -9,    265,  -1874,    397,
      1196,    284,   -963,    298,    318,  -2309,   -162,    322,
     -1250,    -16,  -1004,     -5,   2800,    -64,     72,   -482,
      -162,   -412,  -2922,    774,   -335,    238,  -1144,   -134,
      1428,    558,   1969,   -659,    902,  -1698,    793,   -858,
      -613,    998,    253,   -336,   -348,    -80,   -117,   -264,
       355,    808,    784,   -559,   2030,   1952,   -244,  -1130,
      -986,   1883,   1171,   -493,   -326,   -880,   2588,   -243,
      -204,    194,   -172,    -65,   2026,    424,    587,   -317,
      2550,   -601,    203,   -669,    475,   -676,  -1492,     27,
        41,  -1078,   -299,   -630,    177,   -164,   -429,   -246,
      -357,   1191,   -867,  -1363,   1621,   -110,    916,    217,
     -1269,    622,   -434,  -1113,    888,    -41,   1020,  -1774,
        46,     80,   -483,   -892,    -61,   -472,    193,   -192,
      2000,   -103,    740,   -223,   2493,    422,   2508,   -331,
       470,  -1233,     47,    595,    795,   -465,   -320,   -163,
       128,      6,   -209,    603,    536,   -416,  -1455,    -87,
     -1191,    -98,   -281,   1003,   1421,    388,   1163,  -1146,
       -81,   -299,   2518,  -1072,    207,   -443,    506,   -220,
      -346,     98,   2119,   -416,  -2268,   -498,    109,  -1342,
      -335,   1125,   -712,    156,  -1088,  -2092,   1164,   -500,
       113,    -17,    551,   -199,    262,    -27,   -692,   -629,
       204,  -1448,  -1606,  -1554,    289,    382,   -691,   1229,
       414,  -1746,  -1198,   1113,   -386,    310,   1354,    -12,
      -284,   -569,     46,   -558,   1495,    172,   -899,    617,
       827,   -365,    100,   1008,    136,   2111,     10,   2320,
      -291,    364,   -401,   -408,   -528,   -612,    127,   1218,
      -384,    129,  -1603,    438,   1029,   2536,   -150,  -1432,
      -856,   1068,    773,   -762,   -808,    676,   -693,    404,
       145,      4,     27,   -148,   -318,  -1019,   -277,   1404,
       880,  -1135,    861,    903,    739,    303,    139,   1918,
      -952,    801,   -306,  -2439,     -3,    442,   -590,  -1034,
       178,    430,    153,   1853,   1997,    742,   1745,   -608,
      -237,    160,    523,    950,     82,  -1468,  -1592,    807,
       719,    618,    319,     57,    235,    287,   1344,    -50,
       324,   -182,   -365,   -381,   -377,   1989,    147,   -573,
      1246,   1769,   -473,   -178,    961,  -1297,   -750,  -1428,
     -1246,    789,    158,    612,     17,   -292,   -227,   -142,
        64,     51,    -16,   -301,   -287,    -60,   -404,   -267,
       109,   -108,    189,   -438,     48,     95,  -5059,    -42,
};

static const int16_t cb4432m1[] = {
      7567,    273,    268,    -74,    201,    274,   -149,   -146,
      -262,    243,   -273,     63,   -127,    135,   -160,    231,
       120,    209,    -91,   -218,    -38,  -1206,   -468,   -159,
       278,    536,   -995,    -60,     22,   1041,   -550,   -121,
      -241,   -664,    427,   -416,  -1395,   -732,    152,   3247,
       -67,   -154,  -2430,    421,   -405,   -558,    -73,  -2887,
      -272,    -60,    365,    745,    287,   -622,  -1103,    412,
       266,     82,     61,  -2172,   -379,    529,   -125,  -1482,
       319,    643,    222,   -508,   2451,   -970,     71,    237,
      -280,    202,    983,   -223,   -307,   -130,    217,   3209,
        49,    -30,    275,    -12,   -260,  -3959,   1219,   -104,
     -2700,   -201,     54,    851,   -590,    691,   -254,    408,
       296,    -48,   -364,    216,     16,    220,   -415,    218,
        83,     43,  -4032,  -1359,     25,     15,   -279,  -2092,
       794,   -433,   -195,   -162,    606,    166,     87,   -316,
       508,    242,   -359,    687,   -178,     14,  -2969,   -500,
     -1041,   3234,    679,    170,   -791,   -127,   -630,    -16,
       -19,    181,     -2,   -185,   -172,    -88,   -118,   -167,
       128,    121,    239,    321,   -125,    217,  -7260,   -157,
      -161,   -347,   -257,    102,  -1181,     71,   -379,   -205,
      -268,    144,   -174,   -106,    305,     23,    -47,    202,
      -110,    660,     54,  -2963,   -119,  -1371,  -2823,   1171,
      -726,    690,    534,    161,   -435,    753,     58,    227,
       241,    138,    -76,    473,    193,  -1926,  -2183,  -2526,
     -1428,    284,  -1270,    336,  -1458,    208,     41,   -356,
       345,    153,   -273,   -166,    500,     42,    120,    -35,
       -81,     56,   1747,  -3050,  -2029,   -764,   -947,    888,
       422,    374,    143,   -318,   -225,    604,    343,    -91,
      1626,     75,   -211,    160,   -667,   -195,     38,   -446,
     -1269,   -108,   -959,   -616,   -530,    554,   2865,   -156,
      -358,   -429,   -261,     23,    511,    340,   -548,   2347,
       105,     12,    -32,    164,    170,   -168,    268,   2587,
      3511,    612,    329,    159,    456,    273,   -452,    168,
      -394,    799,    -58,    160,   -480,   -257,    242,    167,
        46,  -1433,  -1631,     50,    852,    509,    864,   -381,
      -306,   -698,    261,   -702,    -19,   4113,    -38,   -153,
       -11,    405,   -441,   -120,    139,   -265,    225,    342,
       199,   2085,    237,    278,    252,   1537,    119,    182,
      -174,   -193,   2486,     87,   2903,   -311,   -304,    273,
      -217,   -256,   -264,   -675,   -819,   -188,   -615,  -1183,
       495,   -154,   -687,   2423,    197,    -63,   -146,   1151,
       896,  -1129,    -58,   1114,  -1644,   1219,   -648,    -71,
      -130,  -2643,    533,   -218,   3942,    -83,    208,   -724,
       198,   -643,    590,   -944,    -56,   -420,    115,     23,
      -414,   -144,    295,    219,    -36,    393,   -174,     91,
       290,  -7066,    158,   -275,    -70,   -119,     -1,    302,
      -262,    -73,    -61,    110,   -196,    -25,     87,   -446,
      -159,     -6,   -107,    115,  -7562,      5,    -33,    284,
      -106,     34,   -140,    160,   -304,   -272,   -169,     25,
        93,   -205,     28,    169,   -165,    -34,    -50,    343,
      2204,   1440,    817,  -1921,   -590,   -527,     81,   -364,
      -354,    163,  -1058,   1977,    244,    -75,   1201,   -207,
       293,   -289,   -105,   -121,   3588,    925,     -2,   -201,
      -860,    917,    100,    265,   -200,    -44,   -529,    351,
      -579,   -103,    186,  -3622,     52,    181,   -259,   -411,
        -4,   -328,    380,    517,    306,     57,    340,    -65,
      -263,   -311,    494,    326,  -6136,    747,   -141,    296,
       217,     -2,   -125,      8,    -88,    254,  -2934,   -259,
       946,   -905,    653,    436,   3393,   -147,   -157,     27,
       166,    299,      8,    -16,    643,    114,    217,     57,
       -21,   -298,     19,    129,   1721,   -134,   2337,    781,
      -483,   -748,    118,   -330,   -226,  -3762,    222,   -417,
      -154,    -24,    -13,   1138,    210,    357,   -122,    257,
      -369,    863,     13,   -320,   -439,   -433,   3469,   -869,
       116,  -2772,    202,   1065,   -130,   -287,    142,   -288,
        54,    318,    131,    -16,     84,    238,   -361,    934,
      1341,     37,    130,   -412,    146,   -724,     -3,   -823,
      2555,  -1263,     11,   -147,   3164,    -83,    -39,   -127,
       258,     26,  -1181,   3339,   -676,    -30,    -56,    691,
       867,    715,   -903,    293,   -205,   -392,    -22,    529,
       -76,   2201,    433,    134,   1338,    -18,     85,   3128,
        33,    924,    257,   1662,   -769,    321,   -449,   -374,
       -58,   -597,  -1670,     97,    222,   -998,    404,   -155,
       133,    358,   -250,   -125,    163,   6027,   -228,   -116,
       -61,   -878,   -693,    710,   -516,   -191,    -27,    443,
        83,   -174,   -695,   -117,   -107,    -53,   -142,     92,
      -145,   -114,    -62,   -710,  -3192,   -872,   3284,   -521,
       -36,   -948,    252,   -253,   -143,    260,    109,    -24,
       262,   -169,   -196,    195,    105,     27,   -135,   1722,
      1862,   -513,   -270,   -144,   -414,    -59,     91,   -288,
       -96,    -56,   -204,    273,    170,   -171,    -62,  -4993,
      -125,    -67,    -50,    226,   -275,    600,    105,   -217,
      -450,    -87,    -20,   -353,     24,    -74,    167,   1881,
     -4260,   -144,     48,     92,    187,    319,    341,     22,
        -4,    405,    147,    237,   -120,    122,   -237,     56,
      -515,   -153,    333,    834,    401,    210,  -5516,      7,
       127,    147,   -140,   -479,    -26,  -1669,    -21,   -147,
        60,    387,    565,   -140,  -5827,   -269,  -1119,   -324,
       118,   -199,    -11,    105,    -49,    150,   -148,    178,
       182,    162,    150,     68,   -227,      3,    221,   -330,
       -23,     65,   6262,     71,     48,    -41,    -10,     -1,
       -44,   -255,    -50,   -138,   -109,    -54,    -31,    492,
      -214,    239,   -194,     35,  -6348,   -148,      9,     25,
      -123,     84,   -448,    241,    148,    -35,     52,     35,
         7,     99,    -16,     57,    -43,   -256,   3336,    373,
       211,   -513,   2328,     86,   -274,    386,     74,   -174,
       624,  -1037,  -1154,     36,   -209,  -1028,   -101,   -412,
      -103,   -267,   -107,   -126,    163,   -394,  -1097,   -100,
     -1575,   -542,   3326,  -2149,    547,    626,   -278,   -414,
      -781,    486,   -186,   -159,    138,   -187,   -821,    419,
       393,  -4266,    828,    431,     86,    745,   1313,   1484,
       260,     52,    163,   -455,  -1071,    186,    522,    288,
       421,     18,     97,   1267,    200,   2637,   -189,    729,
       746,    203,   -639,   -843,   2164,    671,     84,  -2384,
       430,   -161,    404,    166,    -33,    -17,    591,   -227,
     -3849,   1579,    175,   -718,     99,   -410,   -844,   -239,
        32,    212,    163,    480,    843,   -379,   -621,   -317,
      -424,    113,   -262,     44,    -93,    529,    144,   -218,
       140,   3257,   -575,  -2697,    144,    -83,   -186,    -44,
       977,    153,   -230,  -1530,    234,    212,    212,    331,
       412,   -125,     -3,    422,   -329,  -2181,   1406,    363,
       -90,    -86,    329,   -267,  -4462,   -189,    -87,    154,
        66,   -200,     37,     80,   -109,   -199,    125,   1983,
       260,   -438,  -2417,   3259,   -974,    453,     41,    -77,
      -538,   1123,    119,    120,    254,   -239,   -134,     33,
      -384,   -407,     27,    465,   1810,   -910,    980,    -15,
     -1307,   -919,   1880,   -327,   -303,   -198,    149,    413,
      2176,   2269,   -707,    343,    360,    169,    148,    182,
       104,    163,    857,    291,   -153,    303,   -679,   -386,
      -868,   2283,   -320,    167,   3257,   1741,    338,    467,
       209,    207,    834,   -226,   -479,   -120,   1674,    -61,
       696,    -93,  -1327,   2176,    716,    402,   1688,   2219,
      -339,    779,    366,    358,    241,   -695,   -272,   -136,
       -48,     36,   -269,    862,   -616,   -118,  -2028,   1678,
      1971,    115,    290,     71,   -765,     31,  -2874,    122,
        13,   -424,   -281,   -320,    233,  -1032,     40,   -186,
      1208,    274,  -2310,  -1594,    289,    230,   1264,    962,
      -310,     23,   -548,     12,    -38,  -2734,    664,     37,
       346,   -620,    266,    -98,     82,   2369,    963,  -1391,
      -451,    833,     82,    175,    448,   1874,    345,   -440,
       155,    130,     94,    326,   3223,    234,   -163,   -384,
      -354,   -539,    827,     -9,    530,   -226,    -21,    332,
     -2298,   3221,   1470,   -282,   -800,    231,    314,   -998,
     -1051,   -648,   -434,    743,    -72,    119,     91,    414,
       379,   1370,   -637,   -998,    851,  -2904,   -266,  -1652,
     -1356,  -1339,  -1679,   -181,    245,    731,   -231,     -2,
       221,   -182,   -325,   -411,    346,    246,  -2629,   1736,
      -361,     24,    229,   1168,    747,    309,    425,   -128,
      -320,   -496,    109,   1496,    -70,   -797,     37,   -271,
       -39,    906,    -62,   -194,   1753,    311,    689,   1354,
     -1035,   -973,   -438,   1166,   2197,    -99,   -380,   -274,
     -1565,    447,    100,    349,    485,    653,    744,     50,
      -582,   -123,  -1396,    156,    -27,    349,  -1067,  -1382,
      1388,  -1061,   -554,    894,    -80,   -783,  -1500,   -736,
       897,   1158,  -1386,    -40,   -280,   -819,   -672,   -895,
       994,   -308,   -466,   -578,    455,  -1536,    879,   -448,
       542,   1508,    850,  -2465,    816,    641,   -427,    310,
      -168,    -41,   -908,   -302,   1513,    -29,  -1144,    588,
     -1703,   1144,   2623,     90,    284,    866,    335,   -351,
       419,   -745,    879,   -183,   -824,  -1713,    -34,    -15,
      -913,     37,   -460,    778,   2130,   -145,   -153,   1761,
      1420,   -243,    -32,   -877,    140,   -700,    612,  -2053,
       321,    -78,   -165,    200,    526,  -1002,   2176,  -1022,
      1436,    298,    -21,  -1378,    515,    304,    974,   1722,
      2054,    661,    425,    282,    471,    438,     70,    169,
      1587,  -2076,    -40,   -702,    264,   -146,  -1499,   -863,
     -1775,  -1059,   -490,     92,    631,  -1194,  -1031,    335,
       257,  -1299,    241,   -270,   -325,   -322,    -37,      0,
      -685,    897,    984,   -909,   1556,   1281,   1367,  -1269,
     -1591,    415,  -1156,   -374,   -110,   1552,   -695,     74,
      -167,   -473,   1421,   -611,    175,   1521,   1322,    436,
      1969,   -787,   1041,   -730,   -598,    188,   -794,   -531,
     -2198,   -317,    -11,     -8,   -407,    198,  -1180,  -1675,
       174,    981,    467,   -149,   -890,    263,   1030,   -121,
      2147,   -135,   1975,   -634,    431,   -238,   -695,   1338,
      -172,    110,    147,   -334,   -726,     65,   -873,    667,
       997,  -1118,   -339,    144,   -700,   1303,   -207,   -609,
     -1617,   -765,    839,    505,    -36,    -58,  -2894,    226,
};

static const int16_t cb4440sl0[] = {
     -3624,   -495,    158,   -246,   -529,   -813,    689,    504,
      -527,  -2216,   -198,   -323,   -690,   -591,    175,    262,
       243,  -3676,   2648,   -986,    166,    243,    301,   -700,
       324,   -324,     13,    362,    222,   -470,     30,     20,
       -46,   -147,   4050,    -97,   -560,    284,    317,  -1611,
       655,   -416,  -1582,   -675,    389,   -124,    150,    -27,
       325,    -84,     48,   7474,     97,    105,     19,     38,
       133,     19,     28,     25,     40,     34,    -59,     22,
        11,     27,     21,      5,  -1596,   -428,    439,    353,
      2288,    -18,    357,   -274,   2582,   -126,    -90,     71,
        -9,   -704,    205,     22,     44,   -120,    -43,    517,
       817,   1370,   2151,   2818,   -470,     90,    395,  -1243,
      -345,    959,     19,     -1,    123,   -108,    347,     25,
      -138,     15,    119,   -117,   -146,    142,    183,   -254,
      -276,   -174,   5980,    283,   -317,     70,     51,    -15,
     -2447,    -79,    234,    736,  -2600,   -641,  -1162,    376,
       959,   -250,    701,    -40,   -102,    204,    -38,    -24,
      -893,   -387,    339,   1338,    -91,   -655,   -864,     78,
       299,    228,  -2732,    234,   1995,  -1321,   -139,    500,
      -316,   -140,      2,    -80,    186,     11,     16,    -69,
     -7534,     85,   -263,    189,     -7,     -1,    -67,    -68,
         3,     24,    391,  -3299,  -2952,   -121,   -393,    103,
       -60,   -113,    141,    185,   -119,    240,    270,   -392,
      -105,      9,    -39,   2529,    -17,    353,   2966,   -855,
      1042,   1294,    132,   -257,   -257,   -496,    112,   -179,
       424,    486,    -63,     77,    275,   -198,   2026,   1657,
       913,   -255,   -147,  -1748,     -5,    418,    356,   2022,
       927,   -295,    194,    165,     28,    109,     13,    209,
      -133,  -2802,    420,  -1873,   -648,    309,  -1172,  -1825,
       -36,    840,    280,     44,   -118,    128,     34,    241,
     -1005,   1160,   -303,    318,    726,  -1716,   2625,   -950,
      -839,  -1257,   -901,   -238,   1123,    131,    252,      1,
       440,   1455,    -14,   -274,   -461,     87,   -515,  -2299,
       928,  -2867,   -804,   -215,    680,    147,     80,    215,
        15,   1339,    141,    -95,    134,    -35,    122,     53,
       429,    168,    476,    -45,    745,    236,   4229,    318,
       247,   -201,   -372,   2289,    161,    431,    337,   -707,
     -1024,    121,  -1773,   -795,  -1187,   -401,    394,  -1431,
      1526,    -35,    432,   2929,     90,   1880,    628,   1298,
      -552,   -498,    207,    -97,  -1431,   1105,     29,   -739,
       -56,     62,     94,    537,   -732,   1255,   -766,    200,
      -365,   2846,   2139,    435,     92,   -710,   -512,    360,
      -339,   1021,    474,   -132,    405,   -440,   3435,     75,
      -254,  -2443,   -880,    325,    343,    285,    230,   -431,
      -191,    215,    201,   -443,     93,    -81,   -131,   2981,
     -2986,   1003,    437,    434,   -386,     17,    222,     70,
       173,   -550,    267,   -121,    -43,    114,    -11,   -795,
       561,   -147,    187,   -198,  -4969,     50,     59,    674,
      -853,    163,     71,   -205,   -284,    -50,    -28,  -1412,
      -105,    262,    272,    565,   -824,   -541,   3381,    430,
       -81,    228,   -426,    978,   -294,    422,   -538,     13,
         9,    430,    180,   2329,   -564,  -1082,   1740,   1108,
     -2011,     11,    343,    868,    723,   -806,    342,    339,
      -141,   -173,    186,     50,    297,    705,    783,   -593,
      1609,    212,    528,  -2547,   -863,  -2457,   -876,    164,
       162,    365,     68,     30,     11,     48,     47,   -285,
       -64,    166,    -21,  -6880,   -191,   -226,     89,     -1,
        22,    -93,     -6,     44,    282,     52,    294,   -690,
      -147,    372,   2247,    804,   -637,     54,   2385,  -1799,
       315,   -929,    692,    -65,    -54,    218,   -752,   -519,
      2171,    177,    907,     22,   -778,  -2656,     62,   -418,
      -434,    307,   1906,   -280,    196,     76,     58,    -46,
        70,   -367,    -67,     50,    125,     77,   -547,   -287,
       -97,    -10,    -84,   -271,  -4856,     10,    490,   -560,
       -21,     66,  -2469,   -322,   1021,    936,    625,  -2520,
      1144,   -373,    270,    804,    603,    -91,    262,    659,
         9,   -324,     50,   -712,   2705,  -3016,    594,     87,
       -88,    697,   -205,   -799,   -128,     37,    504,     59,
      -274,    655,    672,    -20,   1294,   -221,  -2954,    198,
       674,  -1676,    863,    324,    968,    731,   1125,    -41,
      -149,   -303,    223,   1370,    -67,   -194,     -1,   -194,
       251,   -459,    -39,   4477,    113,    -74,   -386,    214,
       -72,    -77,  -1593,    511,   -461,    752,   -559,   -476,
       204,   -722,   1050,   2080,   2468,   -154,   -208,    964,
       103,    -58,    390,  -1863,    910,   -307,    209,    -32,
       663,    103,   -133,  -3137,   -423,    259,   -605,   -242,
       139,   -391,   -488,     77,   -266,  -1694,    397,   -659,
       237,   2068,     -3,   -867,    870,   1647,    645,   1848,
        68,    382,    455,   -551,    -87,    -99,  -2926,    372,
      2438,  -1166,     -6,    521,   -195,   1259,   -162,    917,
       140,    275,   -273,    133,    318,    -25,    252,   -119,
      -132,   3120,    397,    398,   -420,   1756,    666,   2176,
      -141,    271,    -51,     22,   -494,    -36,     57,    308,
       222,   3585,     16,   -265,   2628,    -24,    162,     13,
      -240,    -96,    620,    331,   -449,    710,   -123,   -105,
        23,   -170,     20,    256,  -5228,    398,   -186,    272,
       129,    175,    598,    -16,   -502,     11,   -215,     28,
      -110,   3570,     68,    199,  -2535,   -933,    781,   -762,
       325,     18,   -438,   -319,    473,   -677,    176,    290,
         0,     67,     -6,   -156,     31,     35,   -131,   -127,
        24,   -100,  -6826,   -117,    -53,    -40,     99,    -50,
       -93,     31,     34,   -251,    186,    487,   -203,   -662,
      -182,    -96,    239,    308,    338,    -86,  -4871,    264,
       -48,    314,    -66,    100,   -188,    151,     24,    198,
         4,   5046,    -47,   -654,    -43,     41,    109,    103,
      -262,     93,   -118,    -63,     58,   2088,    336,   -320,
      2326,    548,   -810,  -1315,   -864,    461,    171,     76,
     -1109,  -1510,   -874,   -620,     97,     88,     40,     -4,
     -7295,   -128,    -39,     23,   -100,     -9,    -74,    112,
      -151,     67,     21,     53,      2,    -29,    -33,     52,
      3287,  -2178,    626,    339,   -817,    349,  -1187,   -550,
      -390,     57,    -41,    295,    756,    185,   -215,     17,
         3,   7502,   -134,   -122,    -31,    -53,     91,   -170,
       -71,    133,    -34,     57,   -112,     -5,    -66,     17,
         1,   2328,   3714,    214,   -123,   -839,      9,    -62,
        54,     70,    -18,    817,    186,    -61,   -252,     37,
        98,      9,   2010,    738,  -1651,  -1924,   1106,   -624,
       143,   -548,    847,   -198,   -140,   -691,    478,   -758,
        56,     54,     -7,    209,  -2665,    109,   -127,   -134,
      2099,    333,   -602,  -2217,   -743,    346,     74,    216,
       579,    223,     61,    -30,     57,     94,    224,  -2595,
      -566,   -851,    246,    314,     65,   2857,    114,   -760,
        77,   -611,    119,    181,      4,  -2556,    127,    138,
      -164,   -219,   -116,    157,  -3143,    197,    -98,  -1040,
       235,   -332,   -424,   -152,   -338,    -33,   -220,    207,
       254,   5469,   -102,   -390,   -125,   -420,    113,   -233,
       329,    -34,    109,   -171,    103,     50,     58,     96,
      -500,  -2317,   -259,   2178,    109,  -2030,    759,   -780,
       448,    678,   -384,   -271,    213,    334,   -271,     23,
     -1121,    636,  -1103,   -482,  -3059,  -1200,   1160,    109,
      -232,    541,   -788,    130,   -166,   -300,    664,    233,
       -97,    -29,   -286,     33,   1272,   -298,   -382,   -242,
      -199,     47,    479,    224,  -1761,  -1904,   1780,   1439,
      -681,  -1973,   -118,    -90,   -148,    247,   -758,   1936,
       182,   1373,   2346,    120,   -758,   -476,   1789,   1177,
       611,   -394,    -14,    -39,   -994,   -674,   1049,    -41,
       836,   -391,    942,  -1040,  -1437,   1376,  -1916,   1129,
     -1018,   -653,   1284,    -72,   -166,    321,    194,   -142,
      -151,    -77,    251,   -162,    732,   -790,    107,   -292,
      -675,  -4248,    -51,    -86,   -299,   -495,    413,   -128,
      -455,   -105,   -842,    881,   -492,   1241,  -1432,  -1296,
       -52,   -430,   2533,  -1765,    838,     84,    -24,   -798,
      -428,   -154,   -658,     37,   -388,   -591,   -931,   -433,
     -1837,   1363,   -683,   -717,   3115,    104,      0,   1104,
       208,    148,    404,    101,     18,    217,     58,     49,
         4,    -49,   -195,    187,   -239,    -21,    294,   -138,
};

static const int16_t cb4440sl1[] = {
     -3057,   -853,   3212,   -334,      5,    224,     63,   -250,
      -345,   -102,   -289,   -115,     75,    -99,    206,     -8,
        19,     96,   -254,  -2566,    334,   2773,    136,    199,
     -1076,    347,   -187,    481,    -64,    654,     -9,  -1094,
       196,     40,    -95,      5,    163,   -135,    253,  -1053,
       316,   -231,     24,  -2307,   1480,  -2052,    -18,   -459,
      -550,  -1860,    -15,     98,  -1406,    -66,   -250,     21,
       497,   -404,    -54,   -228,   2477,   2011,   -145,  -1957,
      -426,   -906,    608,     15,   1453,    218,    -79,   -636,
     -1005,   -332,    304,   2338,   1356,     81,  -1201,   -170,
      -126,  -1177,  -1644,  -1046,     16,    182,   -328,   -347,
       346,    591,    418,    623,   -110,   -342,   -227,     10,
     -5055,   -411,    128,   -103,     87,    -28,   -133,    196,
       333,   1785,   -479,   -442,  -2892,    453,  -2292,    -19,
      -383,    -44,   -435,   -193,    503,    130,      4,    144,
      2184,   -245,     -7,    458,     82,    -76,   3052,   -375,
      1299,    -76,    364,   -145,    372,     36,     59,    -39,
        48,    385,   -230,   2764,   2956,   -741,   -372,    428,
      -504,   -220,   -821,    -47,    -49,    609,    -62,     56,
         6,    216,    376,    519,   -512,     54,   -318,   -183,
     -4563,    297,    795,   -182,    108,    234,    404,    218,
      -123,    -17,   -192,    170,    349,    134,    -91,     43,
      -135,    -24,     -6,    -32,  -6681,     50,   -138,    -89,
       -18,     15,     24,   -416,    356,    311,     83,   -267,
        81,    209,   -155,   -368,    396,    358,    232,   4696,
      -347,    724,    112,     10,    331,    358,    197,     54,
       824,    646,   -214,    113,  -4425,    184,    -11,    101,
      -313,    186,    253,    169,     78,     52,    -70,   -108,
      1669,    -22,    -18,  -2600,    -27,   2806,    288,   -106,
       506,    176,    616,   -299,     58,    -30,      1,   -220,
       400,   -177,    874,     70,    -36,   -274,   -139,   1148,
       372,     40,    236,    505,    619,  -4002,    -95,    -48,
     -2854,    114,    -69,  -2805,   -401,     -9,    203,  -1011,
       472,  -1066,    412,   -220,    245,   -183,    -27,     35,
      -762,    312,   -137,   -292,   -242,    896,    172,   -345,
       106,  -4490,    506,    569,    -11,   -352,   -108,    334,
      -165,   2389,   -895,   2761,    467,    201,    150,   -516,
        39,  -1105,      4,    587,   -152,   -764,   -184,    -15,
      -137,    -30,    -12,      7,    382,   -461,   1577,   3519,
      -173,   1370,     80,    499,    344,   -771,    123,    -13,
       288,    233,    111,  -2472,   3952,    771,    216,   -505,
      -446,    531,   -230,    103,    -72,     34,     61,    249,
      -175,    353,     83,     51,    169,    -97,    -60,   7827,
        95,     75,    -13,    201,    -27,    103,    -11,      1,
         3,    121,    -73,    -28,      7,   2908,   -209,   -987,
      -129,   -341,   2840,    889,   -147,   -521,    123,     95,
      -239,    552,   -738,    279,    -66,      0,     16,    116,
       -45,    -28,    -43,    -38,  -7627,     30,    -52,   -209,
       281,    -46,     23,    -24,     56,    -25,    -23,  -2534,
      -107,    -46,    -93,    -49,    238,    -25,     96,   -356,
      3483,   -459,   -414,    205,    102,    202,   -150,   -116,
      1785,   1399,    793,    543,    685,  -2837,    255,    362,
       -96,    410,    926,   1068,    416,    558,   -169,    246,
       138,   2136,     39,    -96,   -605,    279,   -130,  -2741,
     -1101,   -935,    -20,   -227,    453,   1261,    103,    275,
       358,     43,    197,    -23,   -251,    322,    -22,    233,
      2560,   -214,      2,   -101,    645,   2864,    287,   -479,
       904,    -65,     73,    224,   2418,    -95,    428,   -678,
      -278,     71,   -545,   -571,   -566,   -181,   -212,  -2947,
       222,    780,   -365,    124,  -2703,   -198,    -69,   -246,
     -3056,   -184,   -598,    -75,   -145,   -690,    380,    194,
       485,    214,   -484,     54,    163,    363,   -924,   1684,
       201,     34,    236,   -539,   2374,   -150,   -490,  -1313,
       -61,    317,   2123,    315,   -551,    -26,   -328,    207,
       253,  -3015,    166,    109,   -662,   2466,   -157,   -740,
       751,    254,   -788,   -369,     -6,    100,   -211,    107,
      -309,    -39,    -47,    279,   -126,    -91,     97,   -705,
       235,   -231,    182,    283,  -5097,    -68,    285,     49,
        50,    637,    111,     39,   -386,    923,    223,    115,
      1638,   1214,   -640,  -2168,    482,  -2228,    857,    172,
        15,  -2207,    -89,    335,    -18,    295,    718,   -956,
        26,    604,   -436,   2856,  -1131,     98,   -754,    243,
         9,     29,  -4028,  -1725,  -1741,    432,   -211,    -60,
      -535,    201,   -273,    111,    444,    607,   -250,    122,
        98,    159,     97,    281,   3071,   -412,  -2849,   -721,
       -14,    960,    -43,    794,   -427,    297,    478,    379,
       -47,    -22,     69,    -60,    -30,   -732,   2456,    170,
       142,      6,   2520,   -644,   -201,    -16,   1602,    -20,
      -293,    542,   -451,   -167,     -9,     14,   1052,   2707,
      2980,   -117,    479,   -202,    -92,     36,    904,    -66,
     -1088,    -31,     75,    -62,   -110,    -29,    112,   -102,
      5217,    -85,     14,   -191,   -202,   -175,    -71,    182,
      -231,    275,    144,     -1,   -202,    -13,    -29,    -19,
        70,     39,     46,     56,  -7608,    -53,   -104,    -61,
        44,     23,      1,   -157,     42,     12,     38,     37,
       331,   -609,  -2516,   -174,  -2491,    258,   -256,   -926,
       983,    100,     83,    173,   -965,    650,   -304,    -97,
        98,   -166,    534,   2570,   -611,    493,    103,    -98,
       148,   3081,   -131,    285,     13,   -367,    205,    -53,
        41,     29,   -154,  -2657,    -51,   -312,    134,     50,
     -1514,    634,    411,  -2885,   -391,    365,   -373,    -54,
       -74,   -151,     80,    152,    -91,    -64,   -209,   1134,
     -2921,    316,   -951,   1124,    713,      2,  -2212,     31,
       164,   -260,    103,     36,    229,    111,    -23,    -65,
       -37,   -220,   -108,    -30,     86,     17,     87,    205,
       163,     63,  -5763,    254,    178,    -18,   1760,   -380,
      1453,  -3151,    710,    106,     66,    387,    235,    463,
      -295,    688,   -124,    322,   -193,     82,   1012,  -2033,
      -656,   1362,    805,   -747,   2527,    470,     43,  -1001,
       100,    -83,    161,     74,  -1128,   -307,    -82,   -197,
     -5470,    226,   -327,    137,   -131,    471,   -432,    -16,
       243,    224,    168,   -164,    -58,    125,     23,     -2,
     -2752,    268,    -92,   -466,   2876,    874,    182,    540,
      -407,   -338,   -396,    562,   -376,    536,   -225,    160,
        44,  -1501,   -246,  -1062,   -378,    446,  -2448,   -124,
       499,  -2297,   -353,   -637,    395,    598,   -747,    418,
      -495,      5,  -1014,   2138,    289,    -75,    301,    944,
        66,   -457,   -459,   -253,     -2,    678,    367,    116,
     -2901,    436,   -239,   -303,   -973,    384,  -2574,      6,
      -225,   -164,   -440,    627,    388,  -3074,   -263,    156,
      -805,    381,     -9,   -112,  -1481,    536,   -711,   3770,
      -496,    908,    483,    474,    298,   -424,   -793,   -203,
      -334,    134,    -91,    208,    -73,   5440,   -316,   -304,
       249,     -1,    -98,   -214,    190,    242,    -57,    -38,
       244,   -219,     30,   -224,     66,    -30,     22,     24,
        24,   -109,  -7594,   -115,     90,   -147,    -83,     21,
      -257,    -52,    134,    -49,     92,   -117,     30,     -8,
      -636,   1551,   2207,    -66,  -1962,    212,    567,    969,
     -1595,   -562,    355,   -467,   -861,    937,   -148,     15,
       -68,  -1516,  -2118,   1477,    777,   1458,    976,    522,
       325,    957,   -130,   -132,   -918,    448,   1088,    102,
       142,   -644,   -284,    687,   -665,   -132,  -1870,   1387,
       733,    -84,    920,   -508,     53,  -2183,    254,    565,
      2056,     97,     57,    219,    688,   -344,    659,   2033,
       963,  -1717,   -290,   -934,  -2119,     57,  -1452,     24,
      -639,   -739,   -232,    170,     28,    359,   -312,    310,
      -103,  -1067,   -953,   1081,   -857,   1926,   1364,  -1719,
      -863,   1832,    786,     55,    166,    383,  -1373,   -347,
      1710,   -908,     91,   1257,   2013,   -592,  -1337,   1431,
       -90,    617,    549,   -356,    -68,    134,    -48,   -133,
      -176,    -18,    -65,     23,     84,    -23,    -36,     -4,
       230,    297,   -204,   -150,     86,  -4965,    742,     40,
        32,  -1070,    149,     38,    302,   -329,   -386,    -57,
        45,  -1622,   1425,   1817,   1568,   2202,      7,  -1192,
      -201,    -42,    -62,   -170,    -32,   -117,    -38,    229,
        44,   -226,    155,     70,    747,    259,   -261,   -120,
};

static const int16_t cb4440ss0[] = {
     -3021,   2048,   -450,   1147,   1487,   -796,   -657,    459,
       609,     63,   -153,  -1174,   -144,     37,   -176,   -160,
        43,    -31,  -2577,     88,   -797,   1179,   -707,   3154,
      -543,    875,    116,    -40,   -150,    326,    293,   -112,
       -73,    -34,     61,      8,  -2251,  -1551,  -2507,      6,
       -52,     -5,   -323,   -313,   1076,    920,   1116,  -1100,
      1103,    310,   -144,    904,    149,    -59,    636,  -1508,
      -378,    381,   -917,   -868,   1388,  -1225,    -68,   1491,
       685,   -220,   3253,     48,   -504,    192,    114,    -11,
     -1718,   -916,    660,   -240,    767,  -1061,    332,    591,
      -477,   -278,     25,  -1485,     55,    216,  -3238,    -19,
      -320,   -148,    273,   -876,     22,   -529,   3263,  -2535,
      -756,   -133,   -481,  -1024,     34,    418,   -415,    412,
       -92,    -90,    161,    -49,  -1699,  -2737,   2923,   -243,
       122,     87,    984,   -377,    -37,    128,    350,   -444,
       -98,    -52,     14,    -14,    -86,    255,   1997,  -1239,
        42,    247,    -15,     16,    405,    302,    -17,     84,
     -4033,    -12,    254,   -365,   -205,   -162,    329,     31,
     -1158,   -210,   -376,   3958,  -1601,  -1128,    737,    731,
       300,   -785,   -777,   -403,    463,   -226,   -109,   -277,
       -70,    -53,   -856,   -785,   -997,     71,   5565,    317,
       447,   -279,   -357,    254,     93,    -47,   -206,    133,
        88,    272,      7,     44,   2229,   1666,    234,    519,
     -1996,  -1195,    549,    449,    174,  -1010,    622,    425,
      2288,     -9,   -390,    612,    -40,     32,  -1867,   -673,
       -70,  -1174,    106,    134,    354,     61,   -144,   -290,
        82,   -604,    202,  -3954,    248,    -76,      7,    224,
     -1844,     99,   -146,    206,   -335,    243,     25,     60,
       186,    117,     67,   -137,    119,     46,   4563,     45,
       -46,     -2,    874,    533,    216,    -38,    185,   -540,
      -191,   -163,   -126,   -108,   -184,    193,    -39,  -4768,
       111,    -89,    -61,     17,   1064,   1678,    894,   4334,
       139,   -892,    317,   -351,    417,    -87,    -22,    195,
        20,    140,    234,   -197,   -268,     -5,  -1618,   -756,
      -119,  -1749,   -704,   -943,    421,  -3488,    871,   -468,
       656,    266,    -79,    325,   -303,     45,     -3,    -31,
      1140,   -707,  -1578,  -1434,    290,    327,  -1365,  -2913,
      1048,     38,   -136,   -871,   -572,    -30,    186,    343,
       -30,   -157,   1301,   1913,   -515,   -842,   -723,    -84,
      -340,    270,   -918,   3213,  -1530,   -394,   -184,    -60,
      -391,    -27,   -110,     84,    104,    419,   1201,   -810,
      1546,     39,   -914,   -334,  -4257,    427,    -95,   -426,
       -94,    256,   -148,    246,    -80,      9,   -462,  -1125,
       644,   3541,   -140,   2346,   1045,   -335,   -867,    809,
       432,    386,     -6,    159,     70,    -10,    218,     43,
     -2229,   -607,    537,   -924,  -3038,   -943,   -968,   1261,
        28,    197,   -285,     61,    137,     69,     -2,   -251,
       111,    -19,   -314,   2064,    960,   1529,   1056,    926,
      -319,  -1617,   1305,   1473,   -867,    684,   1357,   -834,
       -66,    477,     74,    -15,  -1769,   1925,  -2448,  -1777,
      -507,    264,  -1740,    176,   -518,    -58,     32,   -108,
       165,    -68,    189,     35,     40,    -85,  -1152,    255,
        36,  -1922,   1500,   1415,    841,    -92,   3305,   -110,
         3,   -219,    167,    573,    219,    310,     27,    195,
       359,   -244,    538,  -2042,    355,    656,     51,   -199,
      -204,  -3611,   -396,    839,    743,   -241,    -80,   -210,
      -101,     28,  -1399,   1062,   -955,     54,   -630,   -178,
      -376,    212,    237,   -219,     47,    805,    216,     26,
     -4334,    455,      4,      4,  -1587,     95,   1186,  -3101,
      -140,   -862,    916,   2063,    211,     96,    337,   -185,
      -195,    424,   1207,    -31,   -162,    206,   2485,    -46,
      -451,  -1778,    -40,    144,   -155,   2884,    803,    396,
      1196,   -635,    297,    -76,   -121,   -162,   -206,   -149,
     -2204,   1035,    232,   -815,    -49,   1006,    553,   -407,
       161,   3650,   -264,    370,   -418,    -28,    141,   -177,
      -113,    -90,   -315,    626,     62,   1392,  -1815,    336,
     -1276,   -402,    486,  -1060,  -1848,   2610,    826,    485,
      -250,     39,    208,     14,   2555,   2869,   -813,  -2074,
       337,    601,    855,   -655,    566,   -707,    189,    -77,
       137,   -510,   -282,     79,     42,     73,     62,    650,
     -4732,   -486,    354,    420,    828,   -645,   -492,    388,
       753,     18,      2,    766,   -212,    126,    -43,     45,
       447,   -283,    607,    251,   -166,    -10,     48,  -5850,
      -251,    128,   -205,    -95,     90,     90,     67,     24,
       -50,    -48,   -167,  -3231,  -2926,   1831,    199,    484,
       169,   -614,   -135,   -374,   -418,   -239,    -89,   -121,
        45,     75,    -11,     16,  -1058,    354,   1633,    589,
     -1223,   1218,    842,  -1146,   2186,    374,   -363,    216,
     -2153,   -429,    429,   -597,     93,    148,   1849,   -797,
      -162,     31,   -325,    343,   -323,    161,   -373,    684,
      -367,   -452,  -4306,    -88,     28,    -56,    -59,     43,
       -49,  -1998,   -956,   1331,  -4214,   -129,     30,     79,
       -90,   -129,    109,    130,   -160,    409,    105,    298,
       208,    178,   1724,    731,    773,    128,    817,   -425,
     -4046,    180,   -782,   -116,    191,   -259,    181,    -31,
       162,     43,    -41,    -69,   1463,  -1769,     -2,   -442,
      -636,   1495,   -218,   -123,    -58,   3616,    454,   -475,
       247,   -383,    304,    185,    155,     40,   1104,   1046,
        -8,   -736,  -1155,   -115,   3925,   -257,    -35,   -599,
      -437,   -135,   -256,     55,    214,    -88,    215,    -57,
     -1097,    183,   -501,   -608,   -135,    148,    405,    295,
        96,   -513,   1013,   4350,   -162,    -61,    427,    315,
        24,    -77,  -1278,   -167,  -1774,   -133,   -323,  -4339,
       732,    597,    -30,   -103,     79,   -241,    177,   -388,
         7,     44,    175,   -143,   5030,    277,     58,     42,
      -222,   -133,   -319,      6,    240,    217,   -238,   -198,
       218,    -43,    439,     49,     37,    106,   1123,   2196,
       158,    171,    458,   -932,   -435,  -2783,   -300,    444,
      2317,   -146,   -339,   -162,    157,   -216,      1,     66,
       987,   -190,   -728,  -3188,  -3167,    378,     -1,    158,
       459,     78,    -42,    386,   -133,    155,    294,    359,
       -29,     78,   1763,    780,   1019,   -330,    179,    -51,
      -393,    338,   4422,   -296,   -392,    170,      2,     52,
       253,    150,   -191,    139,   -371,    161,  -2202,    156,
        37,  -1004,   -384,   -466,     23,    183,  -3701,     97,
     -1293,   -355,    -83,    -63,    -26,     69,  -1817,    641,
      2996,    -16,   2011,   -406,   -647,   -652,    332,    788,
       484,    918,   -440,   1246,    165,     52,   -260,     31,
      -255,  -7237,     14,     90,   -135,    122,     14,    154,
         5,    -78,    111,   -254,    154,    -23,    -24,    -83,
        -9,     49,   -426,   1657,     99,    -36,   -191,   2625,
       655,    -20,  -2723,   -977,   -222,    -48,    155,     41,
        20,    194,    -73,    -26,  -1206,  -3517,   -471,   -815,
     -1144,   -371,   1353,  -1069,  -1238,    829,   -227,    487,
      -297,   -101,    914,    100,    -17,    115,   -806,   -798,
       585,   1097,     -1,   -792,    818,     29,   -256,   -417,
       942,     68,  -4165,     34,   -408,   -252,     55,    -77,
       246,   2055,     -4,   -313,   -661,   -836,    559,   -393,
      2043,    153,    286,  -2700,     98,   -177,   1201,     99,
       308,    -73,   1441,  -3902,    730,  -1610,    886,   -599,
      -126,    473,     43,   -252,     45,     95,   -291,    101,
      -307,    259,   -149,     26,   -510,    498,   1403,    -78,
     -1039,  -2551,    773,  -1176,  -1525,   -405,   -259,   -283,
       398,   2080,   -199,     62,    239,    -26,    960,    582,
      2516,    799,  -2127,    325,   -253,  -1652,   -965,   1413,
         8,   -119,    396,   -342,    277,    541,    186,   -142,
      1210,   -732,    798,    -47,   -557,    -12,     63,    537,
       148,   -128,    328,    290,    203,    361,   -328,    -64,
      4004,    197,   -640,    996,    -93,  -2314,     76,   -914,
      1437,   -964,  -1735,    984,   -578,   1389,  -1025,    -66,
      -120,  -1211,    -32,      5,  -1215,    771,   1621,   -934,
      -984,    148,  -1592,   -446,     19,   -976,  -1709,  -1113,
      -218,    191,   -279,   2183,     10,    -37,   -842,  -1582,
       -92,    558,    227,   -702,   -365,   -576,   -100,    670,
      -305,    285,     48,   -329,    253,   3878,    156,     70,
     -1008,    641,   1541,   -234,   1440,    421,   1088,    735,
      -206,    -83,    460,   -139,    107,  -1160,     -6,   2087,
      1894,   -117,    962,    113,   -990,     93,    -29,    579,
      1217,    -52,   -342,   -451,    670,    202,  -1070,    837,
      -132,   3507,    -59,   -114,   -691,    208,  -1170,   1089,
       305,   -200,    603,  -1301,   -942,  -1631,   1291,  -2727,
       414,     80,    815,   -443,     54,    -34,  -1141,   1301,
     -1199,    372,    102,   -257,     70,    450,    -55,     80,
      -227,    218,    264,    739,    -52,   -200,   3873,     83,
};

static const int16_t cb4440ss1[] = {
      6875,   -104,    -66,    161,     57,     24,     -4,     76,
      -122,   -100,     31,    188,   -119,    -50,   -244,     49,
         1,   -100,    555,    253,    433,    633,   -163,  -5345,
      -170,   -217,    -49,    -29,    331,    633,    -87,    -46,
       -29,     44,   -174,    -74,   2188,    434,    660,   -593,
      1548,    379,   1443,   1676,    -63,  -2125,    246,    534,
      -463,    872,   -169,    -12,     33,    211,   -409,    408,
      1514,   -189,   -277,    391,   -361,    -35,    145,   -362,
     -4669,    212,    -97,    -65,    387,    -81,     70,     36,
       448,    303,    332,  -1077,   -258,  -1353,   1185,    -50,
       -12,    -74,  -2101,   2429,   1817,   -939,    393,    169,
       -22,    -36,   1219,   3237,    816,    452,   1807,   -646,
       407,   -447,  -1778,   -370,   -528,   -127,    104,    416,
      -121,   -134,    -62,     20,   1751,   -640,   -222,    950,
      1603,    555,      9,    219,  -1272,   2724,   1004,   1237,
      -395,    356,   -453,    -98,    -24,     80,  -1621,    474,
     -1947,   -237,  -1059,  -2091,    780,   1211,    939,    268,
      -412,   1923,   -419,    851,    230,    567,    143,     48,
      1506,   2228,  -1226,   -453,    246,    469,    540,   -538,
       -96,    977,    508,    105,  -3150,   -142,    -37,    395,
         9,    -38,      1,   -135,   -391,   1702,   -179,  -1566,
     -3181,  -1679,    203,   -151,    387,    250,    563,    203,
       443,   -168,     82,     61,   1604,  -1878,    229,    -82,
       208,   2965,   1093,    251,   1592,   -432,   -532,    153,
       407,    157,    191,   -216,     52,    -58,    935,  -2161,
      -409,   -513,    977,   -113,   3247,  -1207,   -743,  -1178,
       136,    206,    184,   -885,    -64,     16,    -23,    -24,
       731,   1769,   -941,   1543,  -2386,   -669,   -958,    233,
       105,  -1124,    948,     97,  -1949,     59,   -152,    -65,
       114,     82,    387,  -1908,   -492,    129,   -624,     93,
       658,   -753,   1032,   2480,  -1776,    360,    -38,   1924,
       168,    -12,    -10,   -128,  -1712,   -446,    939,    465,
       605,   -586,   -299,   -393,   3878,    111,   -379,    146,
       186,    -50,   -279,    -30,     -3,     35,  -1941,    360,
       -79,   -111,  -4287,     -6,    671,   -214,   -792,    277,
        77,     58,      8,     16,    133,    161,     21,     33,
      1535,   -296,  -2668,  -3198,    -28,   -386,   1156,    144,
      -201,    256,   -411,    298,     67,    670,     11,   -227,
        -4,   -104,     12,  -1000,   1192,    860,    813,    360,
        25,     93,    792,   -350,     81,   4046,   -178,    122,
       332,     28,   -112,     -8,    288,    539,    -17,    -63,
         8,    231,     55,   -514,    105,   -344,    252,   -153,
        59,    -10,    -21,     51,   6793,     45,    259,    384,
       209,  -2010,    311,   -769,  -1957,   2791,   -463,   -293,
      -218,   1026,    897,   -798,     47,   -525,     31,    -42,
      2018,  -2767,   1658,    685,  -1947,     46,  -1468,    340,
      -272,    318,     21,   -421,   -396,    244,    -51,    290,
        45,      3,  -1530,   1359,  -3681,   1487,  -1689,    209,
       438,   -785,   -220,      2,    -55,   -483,    -35,     40,
         6,    189,   -200,      2,  -2026,  -1747,    838,   -880,
      1128,  -3108,    184,   -671,   -261,      8,    296,   -130,
       -78,   -268,   -100,     18,   -105,     -9,    448,   3184,
      -570,    656,   -376,   -969,   1682,   2635,   -277,    577,
       217,    281,    219,   -351,     31,     64,    101,     82,
       957,  -1885,    774,  -3536,   -168,   -431,   -106,   -479,
      1041,   -103,    774,   -142,    894,   -724,    -94,   -766,
       -58,    112,   2028,    566,   -346,   -139,  -2671,  -1907,
      1039,    189,    -33,   1690,    263,   -514,   -225,   -237,
       145,   -319,     38,    116,   2891,    -77,  -2065,   2559,
      -327,   -763,     86,   -172,   -283,   -147,    137,    245,
      -333,    220,     92,    194,   -176,    105,   3108,    329,
      -372,  -1188,    670,    773,   -235,     34,   -146,    876,
      -259,  -1580,    876,    105,    582,    259,    -63,    -99,
     -1558,   1122,  -1541,   -438,    227,   1221,  -1297,   -746,
      2698,    -29,   1169,    995,     -2,    201,    392,   -405,
       -22,    -36,    757,  -4039,    725,   1960,   1478,   -107,
        67,   -367,    -97,    -88,    154,    -80,      0,   -265,
      -163,     14,   -109,     33,    597,    115,    543,    468,
      -757,    826,    509,   -176,   -305,  -4959,   -118,   -464,
      -421,    -72,      1,   -187,    123,    -88,  -1086,     26,
       368,    610,   3394,   -337,    364,   2594,    491,    759,
      -309,    395,    152,    338,    249,    303,   -122,     63,
      1019,   -864,   1546,    196,     75,   -633,    -93,   -631,
       777,    -74,   1235,   -745,    377,   3113,   -174,   -282,
       -24,     89,   -920,   2124,    620,    566,   1290,   2977,
      1180,    278,    188,    750,    981,   -357,     80,     69,
        77,   -151,    150,    -15,    834,   -893,    818,   1655,
      -500,    237,    133,    243,    405,    239,     16,   -152,
       -70,  -3692,   -110,    145,     58,    -57,  -2527,   3072,
      2226,    218,   -824,    384,    -96,    119,   -228,   -194,
       136,    111,   -251,   -109,   -179,    -34,    143,    109,
      1157,   -216,  -1429,   -702,    323,  -1199,    -60,    632,
      -585,   -340,   1040,    471,    -32,   -380,   3432,    455,
      -138,    -39,  -2416,    652,   -253,    145,    281,    393,
      -671,   2841,  -1616,    -46,   -385,  -1417,   -273,   -168,
       318,   -263,     -2,    -69,   -638,   -137,  -2668,   -359,
       -86,     79,   -777,   -404,   -560,  -3533,    122,   -113,
       617,    497,    117,   -268,    110,     73,    752,  -1105,
      -521,    762,    695,   -587,   -147,  -1235,   1866,  -2250,
      -671,   -511,  -2178,   -820,   -619,    162,    -37,    102,
      -342,   -278,   6837,   -278,    185,     10,    361,    -52,
      -171,    246,    184,   -175,     19,    166,    -48,    -41,
        92,   -152,  -1227,   -983,  -3985,   -703,   1143,    204,
      -523,   1053,   -623,   1002,    231,     53,   -277,   -409,
       -67,    -56,    -90,    -47,    448,    754,    554,    972,
       505,   -331,   4946,   -193,     89,    530,    -24,   -172,
       254,    244,    140,    -10,     40,    -77,   1655,   -438,
     -2776,     51,   -553,    592,  -2902,    280,    804,    776,
       131,     69,   -207,    131,      7,    209,     93,    -19,
     -1148,   -733,   2674,  -1628,  -1243,   -506,  -2346,   -857,
     -1028,    666,    365,   -353,    105,    120,    210,    -85,
        37,    -40,   1027,     11,   1234,     -5,  -1976,    515,
       289,   3815,   -142,   -188,   -248,   -273,   -265,    593,
       205,    164,    -65,     70,   -992,   1586,   2130,    779,
        92,  -3067,    421,      1,   1172,    496,   -917,   -760,
       169,    -64,     14,    -40,   -247,    -95,   1769,   -145,
       712,   -794,   -571,    240,  -1774,    -38,   -129,   -836,
      3372,    887,   -451,     73,   -107,    182,    100,     14,
      -703,   2559,    490,   -839,   -333,    134,    804,  -3549,
        50,   -199,   -215,   -370,    453,    -86,    151,    -98,
       -58,    128,  -2624,  -1507,  -1623,  -2186,    -89,    -55,
      -472,   -667,      2,   -439,  -1453,   -262,    565,     56,
      -118,    288,    -56,     87,   -398,    729,     40,  -6015,
       219,   -212,    287,   -250,   -211,    -29,    -61,    -55,
      -120,    -92,     30,    129,   -122,    111,   2037,   1260,
       943,   -252,    -13,   -794,  -2570,  -1117,    297,    374,
     -1629,     -1,   -407,   -597,   -324,   -179,    408,     58,
      -902,  -1672,    611,   -198,    -61,    103,    366,    915,
       811,   -280,   -401,  -3849,   -111,    221,    353,    232,
         4,    -18,    673,   1792,  -2350,    132,   1979,  -2318,
      -417,   -689,    326,    768,   -377,   -522,    373,   -389,
      -105,   -103,     33,    -48,   1497,   1125,   1893,  -2744,
     -1219,    921,    472,   -165,   -438,   -129,   -682,   -783,
      -685,    167,   -715,    156,     64,     61,   1147,   -892,
       -72,    579,   1191,  -2759,   1831,   1895,    663,    816,
       -98,    -61,   -223,   -366,   -429,     31,   -129,   -121,
      -255,   1804,    138,    180,  -1063,    598,    763,    720,
       385,   -526,    143,     80,    168,    976,   -714,    236,
     -3204,     93,    874,    238,   -359,   1595,    191,    568,
      -182,     20,   -608,   -288,    602,   -224,   3874,   -308,
       -70,   -826,   -109,    -42,   -882,  -1421,  -1603,    625,
     -1206,     31,    782,   -106,   -700,   -246,   -571,   -124,
      -848,   -390,   -523,  -2903,     -9,     39,   -109,   -199,
       497,    -11,    377,      5,     25,   -115,    -61,    283,
        27,   -131,   -193,    280,    178,  -5439,     44,    -52,
     -1210,   -617,   -162,  -1097,     -3,    748,    -45,  -1197,
     -1058,    909,   1607,    693,     42,   -749,  -3001,    407,
       -62,     45,    214,   -312,  -1054,    498,   1291,   1189,
     -1268,   1083,   -757,   -319,  -2796,   -716,    310,   1583,
      -608,    319,    -84,   -119,  -1415,   -602,    628,    463,
     -1213,   -794,   -474,   2682,    931,    240,   2491,     76,
      -234,   -161,   -690,    359,     28,    -19,   -774,  -1023,
       738,    675,    248,     52,   -348,   -545,  -2715,   -599,
      -252,    660,   -387,   -104,   2316,    456,    -90,    100,
};

static const int16_t cb4440sm0[] = {
     -6448,    -59,    298,   -659,    -59,    329,   -569,    397,
      -224,    128,   -216,    153,   -100,    319,    -53,    -90,
        50,   3313,      4,   -215,    405,   -256,     78,   2890,
      -187,   -969,    195,  -1022,   -119,    214,    254,   -360,
      -222,     39,   2139,     91,   -290,    529,    -73,    -16,
      -318,    128,   -348,    565,  -1190,    202,   -185,   -234,
      3498,     48,     68,  -1917,   1694,    212,   -477,    239,
     -3301,   -489,    424,    418,    -82,    -61,    599,   1530,
      -200,   -252,    162,   -243,     43,   -534,  -2695,    255,
       317,    489,    279,   3337,    246,   -349,   -149,   -128,
      -146,    256,   -455,    137,    -75,    836,    209,   -349,
      3494,    255,  -1948,   -732,    367,   1373,   -211,    608,
       345,    -17,     43,    102,     19,   -219,    173,  -2361,
       130,   -862,    637,   -103,   -589,    219,  -1261,   -238,
     -2528,   1643,  -1587,   -690,   -166,      7,    -57,   1221,
       326,    103,   -830,    608,    196,  -3705,   1103,    568,
     -1602,    543,   -153,   -416,     74,    185,    156,     34,
      1329,   -798,   -214,   -515,    121,   -797,    749,    346,
       629,   -609,   -877,    -60,    184,   -157,    250,    193,
      4385,    369,   -181,   -191,   -308,   -314,   -395,   -173,
       -88,   -388,    -43,     46,      9,   -167,    189,   -192,
      6086,   -226,  -1795,    126,   -941,   -423,    397,    380,
       461,    319,    364,   -194,    433,   1214,  -3715,   -274,
         9,   -327,    212,   -375,    130,   -917,    -63,   1120,
      -651,   -211,    149,  -1128,    265,    -73,  -4630,    493,
       -83,    -20,   -314,    -91,    910,   -109,     -3,   -417,
      -109,    374,    357,  -2773,    253,   -234,   -306,  -3060,
      -762,     53,    476,   -299,    -89,  -2440,   -658,    -83,
      -854,   3770,    374,    552,    450,     51,    346,    887,
      -463,    189,    254,    182,     15,    -37,  -3263,   2594,
      -647,    -83,    404,    770,    691,   -654,   -301,     81,
       -13,    742,    371,     54,     31,    -83,    -59,   4196,
       653,    256,  -1075,   -539,   1084,  -1077,   1238,    259,
        20,   -191,    854,    179,    -47,  -1025,   -189,    281,
      2556,   1765,    106,    -79,    320,  -3066,    228,   -500,
         1,   -183,    -46,    220,   -233,    -50,    -98,   -261,
       -84,    -25,  -4378,   -428,  -1395,   -582,   -619,    443,
     -1456,    375,    144,    -32,    356,   -454,     28,    136,
         5,    247,  -1057,    709,   -362,    293,   3084,    545,
     -2804,   -625,     16,   -228,   -238,    164,   -201,   -114,
      -149,     58,    -74,    203,    271,    462,   1037,    159,
     -1652,   -591,   -846,   -166,  -3272,    710,    773,    824,
     -1138,    630,    -14,    209,    348,   1476,    322,   -371,
       241,   4133,   -877,   -476,   -391,    602,   1259,  -1204,
       352,     90,   -473,     43,   -152,   -439,   -131,   -217,
     -1559,  -5029,   -186,   -239,    -44,    750,     33,   -167,
      -211,    -67,    -91,   -143,    124,     32,    -16,   8192,
        68,   -102,    163,    -31,    458,     38,    249,     21,
       157,    -63,     36,     49,    -22,     89,      9,    153,
        46,     60,   -146,    -13,  -7506,   -104,    101,   -141,
        25,    165,    -84,    219,     53,   -182,    -94,     46,
     -1314,   -371,   -298,   -527,      6,  -1955,     52,   -714,
      -461,    174,   1450,   -298,    107,   2965,    250,    -65,
        46,   -171,    296,   -785,   -784,     35,     36,     29,
       915,   -891,   -391,    168,    509,   3763,  -1267,   -138,
       132,    424,    -53,   -669,  -1491,   -927,    712,   -638,
      -440,   -299,    522,   1593,    445,   3234,    547,    498,
       440,    145,   -135,   -188,   -296,   1080,    468,     77,
       176,   -315,    221,   4784,   -666,    274,    762,    -42,
       218,    -86,   -273,    116,    814,    -21,    402,   -266,
      -392,   -425,   1126,    -68,    142,    357,   5143,    363,
      -224,   -198,    115,   -221,   -262,   -736,  -2774,   -196,
      -208,   -613,    163,    696,    789,    132,    114,    121,
     -3138,    164,    172,   -189,    232,     53,    310,    -50,
      -407,   1207,   -474,    249,   -806,     21,     20,     72,
      -534,    101,    -47,   -223,  -4568,   -128,    -29,   -910,
      -254,    105,   3163,   -119,   -135,   1745,   1744,   1105,
       291,   -333,   -278,   -441,    660,    141,   -291,    314,
       149,    142,   -121,  -7878,   -240,   -204,    189,    376,
         3,   -129,     59,     46,    170,     82,   -150,    -34,
        67,   -110,    635,    148,    256,  -2939,    157,   -509,
      1439,  -2470,    794,   -298,    407,    980,    805,    349,
       208,    -35,   1009,   1180,   -114,    776,   -339,   -776,
       250,   1951,   -557,    172,   -395,    795,  -3075,   -348,
      -106,    122,    -47,     -9,     55,     40,   3002,    421,
       538,     -1,   -277,  -3062,    -15,    168,    461,    521,
      -525,    413,   -196,    159,  -3314,    -85,    983,    565,
     -3113,     38,     79,   -172,     20,   -228,   -520,    346,
        47,    485,   -177,     51,    175,    444,   3475,  -3416,
       -81,    118,    264,   -162,     20,   -192,   -219,   -111,
       -57,   -225,    159,   -218,    117,    -28,   -150,  -1100,
      -681,    444,    -54,    -11,  -4669,   -216,  -1151,    858,
       168,    -39,     52,    387,     74,    -39,   -154,   2767,
       307,   -132,    531,    175,    906,     14,   -129,     49,
     -3389,    476,   -127,   -329,    479,    118,    -85,    209,
         4,    227,    154,     -2,   -238,    263,    -24,    553,
      -231,     78,      2,   -183,     31,   5933,    117,     86,
       386,    359,    153,    101,   -784,   -553,    -13,    256,
      -347,  -1311,   -936,    -64,   1718,   -444,    168,   -590,
     -3252,   -194,   -243,   -269,   2096,   -994,  -1081,    309,
      1003,    290,    -66,    306,  -3239,    -25,    700,    365,
      -770,    144,      4,    259,   -185,   1493,   -158,    726,
     -3180,  -1683,   -119,     45,   -493,   -205,  -1728,  -1226,
      -235,    -87,    -88,    -87,   1966,      8,    142,    496,
       239,    828,     30,   -517,   3150,   2266,    402,   -315,
        74,   -312,   -414,    -16,    458,    381,    376,   1287,
      1093,   -410,   -967,     80,    382,   -106,   4419,    445,
       293,   -283,    282,    324,    -80,    -25,    115,  -1667,
      -756,   1893,  -2772,    395,      3,   -349,    138,   1094,
       406,    432,    214,  -1328,    632,   -132,   -100,    135,
      1627,   1062,   1026,  -1341,     24,  -3352,   -173,   1265,
       861,   -821,    -87,   -367,    278,    151,   -101,    -32,
       161,    387,   5778,   -564,    492,     83,    324,     29,
      -423,     91,   -132,    190,   -310,   -457,    -62,    -99,
       171,   -214,   -159,  -2500,   -693,  -1538,   -311,   -784,
     -2422,   -498,   1781,    342,   -467,    -78,    466,   -252,
       241,    197,    186,  -1039,   -190,    346,  -1881,   -240,
       -65,   1438,   1001,  -3009,    -52,    221,   -490,   1224,
       -63,    -39,     53,    169,    130,     86,    -56,    -90,
       116,      4,   7098,     -5,     61,   -172,    -65,    160,
       -94,    -30,   -111,    270,   -653,    521,   -426,   1084,
     -1169,  -1158,    584,  -2499,   2494,   -321,    695,    823,
      -429,     35,    529,   -280,    -45,   -286,   2997,    207,
      -633,  -2207,   1708,   -298,   -413,    673,  -1017,    292,
       493,     76,   -136,   -365,    -65,    266,    852,    512,
       791,   -129,   1364,  -1065,   1371,    383,   -524,    505,
       943,    147,    229,     39,  -2969,     70,   -295,     66,
      2759,    -16,   -435,   -474,  -1058,    762,     54,   -257,
       560,  -3167,   -572,   -418,   -478,    370,     72,    -20,
       296,     54,  -2683,    550,    -15,   -155,   2146,   -143,
     -1144,    463,   -117,  -1690,  -1917,     42,    249,   -278,
      -319,   -513,    544,  -2033,   -317,  -1955,  -2646,   1345,
       759,    268,    207,   1243,    256,    -32,    -45,   -750,
      -211,   -184,   2397,    473,   2572,   -489,    260,    389,
      -237,    602,   -463,    569,   1673,   -176,   -227,    964,
       203,    130,   -269,   -190,   1339,   -978,    973,   1986,
      1145,   1258,    272,   1779,   -436,  -1306,    652,    807,
       574,   1401,     53,   -183,   1612,   -828,  -3094,    -82,
      1061,   1042,   -200,   -891,   -126,    181,  -1324,    549,
       555,     -4,   -868,     79,    157,  -1533,     18,    230,
     -1096,   -335,   -669,   -166,   1853,   -310,   -340,    249,
      -954,   -594,  -2929,    415,      5,    135,  -1315,   -237,
      1868,    787,   1912,  -1100,   1139,  -1103,   -217,   -382,
      -654,   2078,    528,    133,   -115,    -56,    -41,   -207,
        69,    461,    465,   -396,   1725,   1306,   -443,   -720,
     -1600,   1176,    652,   -997,   -306,  -1040,   2258,    -75,
};

static const int16_t cb4440sm1[] = {
      8192,     96,    214,   -395,   -106,    291,   -401,    305,
      -102,    194,    -73,     31,     71,    -19,   -349,     65,
      -183,     26,    -21,   8154,    107,   -136,    -37,    -35,
        85,    127,   -202,     43,   -195,    225,    -51,    -69,
       -57,   -107,    141,   -120,   -284,   -227,     28,    680,
       218,     29,  -1800,    488,   -207,   -453,    -99,  -3680,
      -210,     39,    279,   1406,    278,    -37,  -1596,    232,
       376,     90,    234,  -3348,    242,   1765,    555,   -883,
       118,    115,     48,   -116,   2166,   -292,    136,    527,
      -236,    -18,    411,    -20,   -190,   -480,    665,   3332,
       378,   -287,    337,    199,     -5,  -3904,    311,   -297,
     -2720,   -193,    -17,    911,   -224,    457,    -48,    254,
       271,    -24,    -77,    165,     23,    182,  -1122,    122,
      -520,    309,  -3604,  -1013,   -405,   -647,   -145,  -1162,
      1019,   -190,   -278,     69,    362,   -185,    -78,   -245,
       472,    670,   -493,    620,     76,    717,  -2296,   -111,
      -454,   3224,     27,     47,   -351,   -154,   -293,    187,
       -93,     96,     87,   -453,   -132,      9,    125,   -209,
       -26,    284,   -552,    255,     87,    227,  -5445,    112,
       172,    -15,   -448,    475,  -5747,    367,    149,   -228,
      -797,    371,     67,   -102,   -118,   -418,    332,     38,
      -100,     90,   -183,  -3302,     15,  -1049,  -1560,   1299,
      -710,   1257,    698,    316,   -283,    955,    240,    182,
       269,     12,    -37,   1817,    649,  -1273,  -2071,  -1719,
      -765,    977,  -1159,    351,  -1583,    -85,   -771,   -215,
       123,    314,   -158,     32,    560,    208,    265,   -451,
      -413,     32,   1954,  -3598,  -1680,   -832,   -646,    761,
       272,    394,    213,    -35,    -44,    343,    309,    244,
      3041,   -399,    -50,   -126,  -2755,   -146,    243,   -367,
      -600,   -166,   -832,   -537,    269,    -48,   2419,   -526,
      -309,    -17,   -235,     73,    341,    351,   -840,   3241,
       -94,   -432,    404,   -588,    158,   -127,    -49,   3259,
      3543,    134,   -256,   -106,    622,    -45,   -170,   -109,
        68,    377,    -84,    210,   -250,   -267,    257,    -77,
         6,  -1109,  -1498,   -327,   1063,    992,    632,   -245,
      -656,  -1100,    -60,   -456,   -170,   3208,     -6,     13,
       -95,    606,   -594,  -2039,   -369,  -1743,    275,    -93,
       117,   2828,   -138,   -108,    206,   1819,     98,    -45,
        45,   -163,   2962,   -398,   3536,   -183,   -259,   -581,
        65,   -498,   -288,   -357,   -339,    -13,    -71,   -409,
        36,    -15,   -545,   1433,    135,   -220,     99,    752,
       177,   -455,   -251,   1172,  -1274,   1062,   -774,   -999,
       -63,  -2756,     99,    -86,   4695,   -171,   -129,   -856,
        26,   -543,    610,  -1350,     -2,    271,    455,   -150,
       358,    101,    536,    125,    101,     88,    -16,    -12,
       488,  -7479,    110,    264,    140,   -302,    110,    232,
         0,     15,     70,    -28,    -27,   -110,    -99,    201,
        78,    215,   -108,   -267,  -7548,     34,    312,    -86,
       197,    125,     80,    -75,   -117,     -2,    128,   -207,
      -131,   -513,    614,     33,  -4844,   -302,   -323,    160,
       808,    645,    243,   -603,     68,    -70,    158,   -131,
      -212,    -34,   -247,    625,    134,    -42,    525,    -89,
        31,    116,     -1,    508,   5021,    395,    111,    -86,
      -172,   1433,   -114,   -126,   -148,   -337,   -260,    233,
      -479,    275,   -247,  -5672,    386,   -110,    -99,   -142,
      -171,   -154,   -358,     30,   1028,    -78,    575,    523,
      -586,   -739,   1586,   1076,  -2519,   1572,  -1448,   -201,
       166,    -54,    137,   1268,   1157,   -411,  -2905,    195,
       489,   -740,    154,    522,   2276,   -604,    194,  -1112,
       192,    400,   -271,    250,    413,    273,    158,   -299,
      -874,   -228,  -2454,    162,    819,    457,   3401,    689,
      -208,   -298,   -461,   -360,    -70,  -2133,   -114,   -124,
        81,   -228,    625,   3525,    909,    254,   -234,   1316,
      -773,    531,    -30,    -16,   -164,    -84,   2360,  -1900,
       351,  -2979,    545,    653,    416,    273,    -79,   -825,
      -107,     71,    495,    223,   -176,    129,     40,    424,
      1627,    207,     47,     -8,   -273,   -715,     60,  -1253,
      1501,  -1199,   -248,     39,   2859,   -432,     89,    299,
       948,  -2608,   -896,   3468,     84,    511,     55,    151,
       733,    270,   -354,    470,   -219,   -115,   -105,     91,
      -259,   1941,    775,     12,   2764,    484,    557,   2288,
      -118,    294,    -32,    719,    -62,    -64,   -295,    -82,
      -145,   -285,   -492,     87,   -135,    -98,    194,   -288,
        -8,    263,   -475,    -53,   -388,   5621,     41,    -28,
        34,   -323,    138,   1935,  -1806,   -185,    340,   1380,
        48,   -542,  -2965,   -339,     88,    554,     41,      4,
      -151,    182,    -39,   -193,  -3355,   -312,   3106,   -203,
       442,   -110,    317,   -269,    225,     31,    -62,   -277,
       163,   -766,   -408,    210,    -58,    128,    161,   3308,
      3321,   -138,   -278,   -149,    216,    134,   -253,   -135,
      -154,   -123,    254,    200,     -2,    133,   -307,  -6253,
       310,     -6,    959,     26,    191,    315,    528,    -75,
      -230,   -203,    153,   -265,    -94,    -61,     -2,   2761,
     -4623,   -353,    -19,    102,   -139,     54,    438,    267,
       -73,    447,    226,     71,    -19,     75,    -40,    -32,
      -850,   -500,    422,   1237,   -688,    357,  -3158,   -468,
      -450,   -279,   -694,  -1109,    734,  -1602,   -117,    122,
       261,    979,    -20,    385,  -2929,    342,  -3164,   -146,
       252,   -104,     62,    469,    289,    249,   -214,    -38,
        73,     83,     -7,     18,   -394,     -5,   -140,   -267,
       331,   -147,   6540,    395,   -103,   -147,   -271,    -20,
       191,     73,   -155,    197,     71,    503,     19,    138,
      -129,    335,    209,     75,  -6207,    140,   -176,     -5,
        35,    -40,    -61,   -146,   1080,     58,    327,    -49,
      -842,   1431,    595,   3461,      1,    142,   2001,    297,
       -16,   -425,   1156,   -101,    -54,   1060,   -222,   -295,
       938,  -1212,  -2374,     73,   -272,  -3318,     -8,   -718,
       114,   -154,     85,     -9,     72,     86,  -1330,    226,
     -1414,   -521,   3161,  -1856,    133,    240,   -499,   -371,
      -745,    779,   -463,   -506,    463,   -229,   -226,    389,
       135,  -4137,    360,    735,   -318,    777,    593,    977,
      -174,    286,    187,    -95,  -1626,    245,     97,      9,
       277,    299,   1568,   1066,    375,   1342,   -390,    884,
       271,    185,   -258,  -1100,   2113,   -107,   -447,  -1917,
       -58,    -29,   1081,   -455,   -524,   -196,   1869,   -677,
     -3564,   1443,     29,   -425,    -28,   -370,   -342,    -28,
        30,   -118,     58,    607,    454,     45,   -120,    232,
        20,     21,   -175,   -112,   -236,    492,    411,     42,
       -42,   4041,     39,  -2579,    235,   -146,    122,     24,
      1301,    123,   -461,  -3264,    316,    -88,   -209,    140,
       387,   -430,     78,    508,    149,  -3588,   1107,    820,
      -140,    654,    812,   -566,  -2578,   -403,    -72,    120,
       355,   -136,   -121,    209,    240,    116,    231,   1630,
       208,   -178,  -3160,   2203,    -52,    451,     84,   -310,
     -1199,    596,     69,    285,    242,     15,     49,    341,
      -154,  -2286,   1206,   -109,   1048,   -647,   1127,     98,
     -1264,   -808,   1744,  -1597,     13,     26,   -216,    263,
      3276,   3192,   -105,   -390,    -31,    676,     73,    265,
        31,    101,    479,    -69,    123,    -24,    -49,     32,
      -653,   2253,     49,   -346,   1476,   1820,    396,    639,
      -219,    792,   1728,    147,   -765,   -140,   1181,     98,
       153,    -98,   -755,   2473,    452,    231,   2031,   2468,
      -416,    587,    724,    148,    500,   -933,   -229,     55,
       102,     74,   -164,    652,   -425,    100,  -2684,   1358,
      1626,   -350,    544,   -301,  -1589,   -305,  -1266,     11,
       243,   -125,   -330,    294,   1471,  -2922,   1581,   -546,
       582,    231,  -1407,   -877,    602,    219,    350,   1130,
       -86,    214,    -56,    201,   -181,  -2140,   1108,    493,
       456,   -542,   -113,   -852,   1647,   1897,    840,  -1178,
      -369,    788,    488,    256,    366,   2298,   1167,   -205,
       256,    585,   -555,    292,   2615,    748,   -247,  -1102,
     -1682,    226,    415,     20,     27,    100,      9,    436,
     -1746,   2621,   1583,   -211,   -833,    441,     54,  -1183,
      -826,   -916,   -707,    564,   -232,    -14,    147,    453,
        70,   1094,   -903,   -337,    450,  -1546,   -662,  -1047,
     -2345,   -811,  -1037,     96,    560,   1381,   -119,   -383,
};

static const int16_t cb4448sl0[] = {
     -3850,  -1289,   -449,    -36,  -1178,  -1175,    705,    -97,
        37,   -650,    426,   -477,   -145,    124,      6,    207,
       -96,  -3145,   2917,   -260,    349,    668,    -72,      6,
       157,    -62,   -128,     20,    -82,  -1357,   -707,   -619,
      -313,   -229,   3010,   -169,    -27,    738,    971,  -1450,
       246,    154,   -163,    -15,    -93,      5,    -35,    -42,
        24,     31,    -25,   6803,     33,    -32,    -68,    -68,
       -44,    317,     43,   -106,    608,   -999,   -699,    582,
        46,   1631,    830,  -1570,  -2645,    992,   2126,    132,
      2377,   1551,    247,   -247,   1508,    -34,    162,   -275,
       -81,   -654,   -625,    125,    -33,   -210,    309,    900,
       571,    726,   2691,   2821,   -698,     60,     46,   -483,
        14,   -210,   -295,    102,    214,    226,   2622,    -82,
      -390,   1436,    107,    554,    381,   1307,   2283,   -190,
        27,    -35,   5557,    283,    103,    180,    104,    -89,
      -186,   -319,   -225,   -141,     92,      1,  -1942,   1025,
       906,     32,     -3,  -1089,    182,   -799,    483,   -368,
     -1734,   -103,   1680,    474,   -133,  -1067,   -545,   -219,
      -118,   -635,  -2559,   1002,   2554,   -640,   -505,    179,
      -344,    -81,    107,    -61,     79,    -12,    -29,    -37,
     -7574,    -92,     64,     92,   -164,    -20,    -61,    -35,
      -312,   -159,    333,  -3401,  -2596,   -344,     88,    604,
       535,    -87,    365,    -13,    -77,    131,    127,    588,
       302,    -94,   -506,   2427,     99,    304,   2653,  -1104,
      1380,    976,   -530,   -120,   -105,    293,      9,   -826,
       388,    -66,    421,   -202,    605,    675,   4060,    978,
       143,    -94,     21,  -2444,    -30,    554,    695,   2878,
       657,   -104,   -435,   -326,    307,     20,     20,    159,
       106,  -3473,    326,  -1029,   -304,    670,  -2109,   -431,
       573,    704,    293,    -45,   -169,   -119,   -191,    599,
      -910,   1976,   -165,    581,   1209,  -1689,   2365,   -370,
      -601,   -696,    374,    202,   -114,    -61,      3,    -63,
        30,    369,   -158,   -128,    198,     52,    -98,    -44,
      -323,  -5118,  -1100,   -669,   2256,     32,    -66,    206,
        65,   2801,    783,   -470,   -973,    471,   -211,    -27,
      1879,    302,   -388,   -249,    301,    537,   2761,    321,
       571,     20,    337,   1336,    522,    231,    368,   -363,
     -2065,    -57,  -2565,   -584,   -611,     56,    814,   -382,
      1671,    408,    492,     12,   1201,   1513,    247,   2165,
      -592,  -1246,   -493,  -1012,  -1330,   1251,     75,   -100,
       182,     52,    -47,    710,  -1137,   2420,   -559,    266,
      -801,   2523,   1229,    736,   -409,    -49,    269,   -174,
      -179,    -24,    348,   -661,    251,  -1039,   2647,    283,
       728,  -1850,  -2088,    196,     39,    -72,    -35,    -94,
      -540,    266,    340,   -450,    763,     -5,    113,   2618,
     -2737,   1047,   -246,   -522,   -182,    376,   1068,    203,
      1238,   -938,    211,   -308,   -395,   -629,    596,  -2634,
      1452,  -1155,     83,    -89,  -3121,    419,     40,   2691,
      -306,   -343,      4,   -347,   -725,   -117,   -315,    115,
      -215,     26,    429,   1074,  -1831,  -1850,   2609,     72,
       467,    191,    432,    857,   -186,      0,   -443,    -24,
       500,    541,     30,   2324,  -1160,  -1153,   1783,   1282,
     -1992,    101,   -108,   -108,    556,  -2012,    506,    691,
       -65,   -610,    402,    610,   1941,   -121,    942,    589,
      1879,     58,    312,  -2218,  -2056,  -2284,   -350,   -453,
       306,     38,   -579,   -185,   -101,   -196,   -150,    156,
       126,    -44,   -143,  -7923,    126,   -120,   -138,   -233,
        97,    -20,   -121,   -175,     -8,    -13,   -123,   -365,
       251,    730,   2883,    667,   -418,   -208,   2170,  -1442,
       196,   -389,   -516,    252,    -98,    525,  -1819,   -647,
      1575,    768,   1124,   -428,  -1010,  -2027,    411,   -473,
       863,    210,    908,     40,    145,     37,    192,    189,
        52,   -217,   -168,     63,     -7,    -53,   -121,     13,
      -145,      0,    -37,     61,  -7979,   -142,     32,    118,
       190,     -7,    -13,    113,     36,     31,   1461,  -2088,
      2391,   -939,    -66,    822,    280,    246,   -157,   -183,
      -433,   -356,     88,   -101,   3969,  -3388,    -84,     84,
       130,     35,     74,     37,    181,   -195,    219,    -29,
       -23,    -32,     69,    625,   2328,   -192,  -2617,    287,
       543,  -1604,    823,   -547,   -277,    764,    276,    156,
       198,     17,     84,    346,    -27,   -129,    143,    217,
       212,   -249,     20,   6449,      7,     51,   -889,    -88,
       265,    282,  -1956,   1327,  -1025,   1338,  -1709,  -1008,
       372,     57,   1404,    234,   2621,    -18,    663,    301,
         0,    167,   -372,  -2534,   1945,   -191,    198,    359,
       -43,     92,     24,  -5498,    -63,    189,     36,   -369,
       352,    381,   -205,   -144,   -119,   -267,    -60,    -10,
       387,   2388,   -155,   -450,    465,   1529,   -216,   2673,
      -146,    118,     50,    290,    147,     11,  -2912,    863,
      2184,   -689,    -44,     59,   -663,    663,    675,    295,
      1331,   -115,    -10,    -54,     -1,     31,   1699,    127,
       215,   2966,    163,    416,  -1053,   1216,    356,   1428,
      -166,   -172,     -2,   -355,   -169,   -331,    -94,    -78,
      -123,   4875,    311,     67,   1145,    397,   -288,    212,
      -344,   -290,    126,     16,    176,    485,    551,   -526,
        11,    120,   -274,     83,  -5399,   -154,  -1611,    887,
       321,   -446,   1166,   -333,    652,    310,   -895,     62,
      -219,   2840,   -753,    -34,  -3203,  -3600,    464,   -249,
       336,    297,    -85,    316,    144,    306,   -249,    149,
       112,     73,    192,    -89,     18,    197,    116,     51,
        37,    212,  -7248,    163,     31,    -52,    -31,   -101,
     -1366,   -353,   -325,  -1335,   -440,   1193,    670,  -2635,
       872,   1400,    733,    395,    122,    130,  -4146,      0,
      -382,   1486,    308,   1179,   -412,    288,    701,    161,
       147,    959,     60,     77,   -123,     17,    193,    204,
      -226,    388,    272,   -588,   -157,   2823,    735,   -745,
      2368,    359,  -1088,  -2004,  -1293,   2018,    483,    320,
     -1014,   -806,   -479,    -68,    -51,    168,    873,     27,
     -7906,     57,     19,    -23,     27,     43,    -13,    -50,
        93,     16,     29,     31,    -26,     32,    -22,    453,
      2922,  -2560,    138,    923,  -1245,   -405,     10,    228,
      -270,    145,   -192,     83,     48,    101,     77,   -226,
        36,   7792,    126,   -275,    -37,    -36,      9,     45,
       -89,     13,    148,    125,     24,   -442,    111,    -12,
       540,   1794,   3008,   1620,   -185,  -1394,   -161,    -25,
      -313,   -317,    591,   2507,    134,   -369,     77,    527,
      -619,   -236,   2681,     87,  -1060,    -34,   1894,  -1123,
       373,   -628,   1934,  -1279,  -1689,   -609,   -472,   -598,
       405,    229,    414,     12,  -2923,    -33,   -435,    -49,
      2380,    -34,   -344,  -2171,   -284,    274,    226,   -287,
       -84,    -57,     -1,   -169,    -50,    479,    707,  -2774,
      -532,   -640,   -244,     44,    458,   2519,   -590,   -472,
};

static const int16_t cb4448sl1[] = {
     -2878,   -714,   3098,    -76,    -51,    232,    118,   -780,
      -691,   -267,   -309,    105,   -179,     -5,    -84,    -11,
      -120,   -379,    458,  -3161,     65,   2994,     64,    374,
      -440,     62,   -183,     28,   -561,     73,     59,  -2565,
       445,   -451,  -1026,    437,     10,   -173,   1243,  -2278,
      -481,   -395,   -154,  -2402,    945,  -2789,    117,  -1184,
        75,   -704,    527,    478,   -589,     17,    131,   -110,
       574,  -1055,   -628,   -277,   2798,   1483,   -657,  -1996,
      -248,    194,   -284,    822,    225,   -170,    -10,   -302,
      -427,  -1700,    -90,   2756,   2124,    -49,   -964,    372,
      -637,    443,     13,    -69,    -71,    196,  -1971,    110,
      1147,    698,   1333,   1369,    527,    165,    903,    577,
     -2134,     56,    -33,     34,    183,    247,   -342,    974,
      1079,   2478,    -26,     80,  -2377,    430,  -1422,    428,
     -2187,   -469,  -1280,   -326,    -40,    188,    911,    405,
      2772,    279,   -493,    265,    768,     45,   5778,     44,
       121,   -257,   -135,    124,    263,     15,    197,   -114,
         5,    -14,     -8,    -82,   3989,   -511,    197,   2446,
      -292,   -205,   -919,    162,   -121,    145,    -40,     71,
      -105,     72,   2035,    960,   -145,   -467,   -518,    167,
     -2988,    421,    860,    320,     40,   -446,    319,    160,
       140,    511,    -55,    213,   -148,   -527,   -666,    687,
         9,     23,    344,   -156,  -4646,   -125,   -220,      9,
       134,    -25,     16,  -1319,    763,     58,  -1586,   -438,
       301,   -411,   -337,  -3398,    358,    -68,   -111,   5483,
       -36,   -456,    -94,   -116,    204,     95,     84,    -73,
      -163,     69,   -190,     64,  -3716,   -326,   1815,   -843,
       312,   -498,    684,   -641,   -766,   -104,    606,     70,
      2630,     51,   -170,  -3584,    167,    461,   -162,    132,
       496,     91,    171,    255,     48,      2,   -120,  -1196,
       534,   -431,   2669,   -403,      8,    287,   -391,   2557,
       849,    167,   -275,   -184,    605,  -3570,    113,     22,
     -2586,    668,    294,   -910,     67,   -141,      0,    418,
       271,     75,     90,   -124,    446,   -142,   -635,    631,
      -956,   1566,     25,  -1982,    790,   2770,     33,   -520,
        23,  -7488,     67,    -73,     60,     64,    -46,    -36,
        76,      3,     22,    149,     61,     34,    255,   -380,
      -284,  -2531,  -1423,   1507,   -926,  -1074,   -929,  -1430,
      -141,    165,    -80,   -268,     21,   -767,   1542,   3197,
      -191,   2014,   -304,    595,    536,   -906,   -126,   -354,
       -76,   -162,   -125,  -3139,   3197,    934,    366,   -923,
      -330,    277,   -284,   -163,    -12,    402,     15,   -146,
        20,     83,    111,    196,     23,     71,     77,   7287,
      -175,    -13,   -227,    -59,    -56,    -28,      1,    163,
       -50,     59,    635,    150,     95,   2750,    775,  -2057,
       423,  -1078,   1749,     -3,   -655,   -365,   -357,    145,
       -76,      5,    -93,    224,    150,    108,    -34,    173,
       148,   -371,     34,     48,  -8037,     65,     50,    103,
       -42,    -10,    -96,    -90,     -3,     60,     92,    -79,
       -76,    386,    114,  -1947,    833,  -1279,   -484,    217,
      3156,    226,    485,   1191,    425,     88,    -59,   -243,
      2292,   1681,    671,     62,    899,  -2453,   -100,   1039,
       713,   -104,    554,    219,    356,    963,    741,   -102,
       455,   2067,   -324,    172,     28,    772,    752,  -2351,
     -1438,   -865,  -1668,    105,   1034,   1195,     14,   -350,
      -425,   -648,   2086,   -532,    634,   1537,    -33,   -598,
      2888,    -85,    184,    158,   -164,   3339,    237,   -284,
       -54,   -246,     46,   -254,    365,     55,   1928,   -346,
      -357,    331,    139,     16,    674,   -384,    -67,  -3399,
       165,     76,    215,    137,  -3187,   -146,   -264,   -165,
     -3039,    235,   -541,   -630,    -32,    -33,   -211,    160,
      -121,   -111,  -1296,    -47,   -128,    292,  -1523,   1540,
       771,   -166,   -509,    212,   2758,   -327,   -418,   -305,
        -9,    465,   2513,    195,    -70,   -209,    -66,    127,
      -147,  -3161,   -192,   -541,   -555,    131,   -858,  -1609,
       973,   -156,  -1877,     60,   1011,     66,   -348,    912,
     -1731,  -1296,    305,   -369,   -560,    470,     46,   -863,
      -124,    -37,     40,   -395,  -4886,    -20,    221,    228,
       177,    182,     98,   -151,   -195,    854,   -194,   -374,
       301,    586,     58,   -908,    -19,  -4198,   -171,    330,
        48,  -3312,   -164,   1913,   1183,    -42,   1287,   -353,
       757,    620,   -547,    251,   -520,     59,     43,   -179,
      -191,   -131,  -2951,   -944,  -2479,    344,   -813,    104,
      -697,    -44,   -270,    198,    245,   2866,    208,    178,
      -248,     38,     19,    577,   2812,   -765,   -855,   -439,
       -60,    -30,   -352,   1521,  -1069,    457,    415,    572,
      -749,   -144,    100,    515,   -794,  -1554,   2507,   -270,
        10,     62,   2507,  -1550,    -75,     70,   2530,    562,
       132,   -141,    251,    156,    835,    102,    717,   3226,
      3327,    172,     84,   -205,    -11,    208,   -310,    164,
       -27,     11,    281,     37,   -518,     20,    -76,     82,
      5436,   -543,   -301,    112,    359,   -140,    -94,     78,
       -18,     38,   -196,    -92,     13,   -111,    -23,     30,
       -15,    -94,    101,    142,  -6455,    321,    322,     50,
      -216,   -321,    -10,   -465,    101,     45,   -585,   -969,
      1248,   -456,  -2523,   -852,  -2129,   -889,     33,  -1424,
      1462,    583,    749,    527,  -1737,   1262,   -594,    414,
      -215,  -1184,    412,   1758,  -1836,   1248,    440,   -178,
       784,   3591,   -227,     43,   -493,   -766,   -270,    150,
       151,    -56,   -110,  -2832,    -73,   -166,    470,   -179,
      -681,     71,   -114,  -2743,   -806,   -560,     63,   -244,
       -90,    182,   -143,    995,    404,    -13,  -1343,   1524,
     -2472,   1718,   -957,   1229,    458,   -395,  -2817,   -579,
       -99,    340,   1538,    684,   -492,   1156,    -45,    -65,
      -305,  -1408,   -325,   -270,   -358,   -127,     92,    -97,
       415,     85,  -4749,    173,   -296,   -203,    331,    315,
       184,    -46,   1315,   -146,    -55,    427,     37,    255,
      -209,    272,    735,    506,    105,    103,    902,  -3449,
       116,   2304,    616,  -1564,   1508,    478,    320,  -2418,
       244,   -176,    -32,    238,     92,    290,   -168,    -78,
     -3464,    270,  -1902,      2,    696,     92,  -1610,   -206,
       -49,    178,    121,     27,    119,     72,   -253,   -398,
     -2720,    -81,   -162,   -550,   2595,   1445,    249,   -104,
       218,   -310,    -95,     18,   -473,   1908,    432,   -227,
      -168,  -2725,   -240,  -1830,    199,    437,  -1392,    304,
      1461,  -2394,   -603,   -540,    769,    340,   -104,   1569,
       -21,    338,   -874,   1533,    281,    -59,    487,   2120,
       179,   -140,   -328,    -57,     63,   -110,  -1330,   -485,
     -2427,   1159,    355,    -26,  -2055,    154,   -563,   -132,
        49,   -329,   -187,    -24,    -71,  -3970,    276,    158,
        92,   -202,      7,   -422,   -578,    186,   -407,   4960,
      -595,   1027,    417,    691,     69,    133,    123,   -147,
};

static const int16_t cb4448ss0[] = {
     -2680,   2499,   -328,   2212,   1288,    -57,   -727,     76,
      -210,   -218,     41,   -343,    -26,    -38,     43,    606,
      -619,   -531,  -2082,     87,  -1127,   1282,    -23,   2272,
     -1816,    104,    -31,     85,    -22,     60,   1293,    138,
       382,    432,    489,   -372,  -1649,  -2809,  -2556,    -98,
      -232,   -233,    169,    186,     79,   1157,   2113,   -942,
       636,    877,   -601,   2277,   1411,   1165,   1029,   -613,
      -348,    -38,    -19,     45,   1318,  -1980,     12,   2762,
      1519,    184,   1980,    -49,   -270,    361,   -172,   -601,
      -196,    186,    -67,   -124,   1503,  -1011,    263,    223,
      -384,    153,    -21,  -1063,   -239,   1171,  -3501,    512,
      -162,   -180,    139,   -680,    609,  -1919,   2969,  -2321,
      -183,    194,   -558,     26,     91,    340,    -25,    -31,
       127,    662,    182,    191,  -2201,  -2603,   2252,   -523,
       277,     50,    355,    295,    -65,    355,    207,     82,
      -489,   -143,   -218,     89,    666,   -359,   2716,  -2310,
     -1912,    417,    400,     43,    110,    -93,   -142,     61,
     -3000,    454,   -153,      0,   -413,    469,    339,    318,
      -197,     75,    -80,   2894,   -129,     82,   1431,   1183,
       429,  -1556,  -1339,  -1573,    -92,   -911,   -230,    -12,
        -4,   -145,   -388,   -419,     -5,   -241,   7120,    165,
      -125,   -122,    126,   -150,    109,   -146,    -61,    -49,
        47,     70,    -43,     40,   1867,   1473,  -1278,   1229,
     -2256,    -90,     10,   -744,   1196,   -109,    402,    258,
       690,    -74,     26,   1294,  -1079,    142,  -2384,   -324,
     -1696,  -2741,    321,     66,     83,   -127,   -131,    156,
       166,    135,   1812,  -3445,     10,    535,   -547,    481,
     -2243,    287,   -335,    218,    195,     -1,    -25,    -94,
       195,   1433,  -1428,  -1444,    520,    219,   3363,   -388,
      -807,   -454,    -29,    316,    125,    159,   -144,   -156,
      -317,    752,    256,    216,    340,    488,    147,  -5662,
        55,   -110,    387,   -102,   -211,    -66,    -26,   3688,
      -172,  -2366,   -244,     -5,    353,     11,    503,     88,
       227,     69,   -240,   -187,    -58,   -389,  -1783,  -1427,
        20,   -618,    544,  -1337,    628,  -3180,    708,   -538,
      -423,    115,     49,   -161,    184,   -682,   -223,    689,
      1299,   -891,  -1073,  -1228,   -305,     47,  -2221,  -1559,
       598,   -380,    166,    143,   -366,    287,   2122,    509,
       629,    235,   1523,   2900,   -640,   -425,   -462,   -231,
       -53,    -27,   -263,   2090,  -1892,  -1147,    -42,    866,
     -2301,    461,  -1082,   -625,    -85,    148,    229,    -25,
        85,     53,    259,    -81,  -4072,   2577,    -12,     -7,
       335,   -151,   -691,   -137,     98,    372,    -37,   -192,
       -17,   3318,   -558,   2064,    396,    258,  -1067,    229,
      1122,    298,    -25,     40,     27,   -134,   -166,   -247,
     -2010,   -440,   1066,  -1400,  -3454,   -289,    428,    629,
      -158,    126,    129,    183,    -12,   -171,   -120,    421,
      -445,     66,   -900,   3680,   1583,   1985,     25,    229,
      -535,     -1,     45,    207,    -54,    -30,   1581,   -938,
      -703,    405,    878,   -398,  -1069,   1748,  -2587,  -1419,
      -375,   -441,   -487,    109,     21,  -1399,    648,   -271,
      -701,    635,    115,   -138,   -458,   -600,  -1891,    585,
       420,  -1916,   1135,      7,   1584,    910,   4267,   1328,
       279,    395,    -35,    -99,   -168,    503,    216,   -126,
       211,    212,    193,  -2205,    491,    696,     41,    283,
       649,  -3425,   -999,    200,    625,   -261,   -378,    -47,
       -15,    -30,  -1262,   1700,  -2191,    196,  -1773,   -251,
        84,    498,   -261,    150,    451,     41,    336,     27,
       -56,    562,    -86,     -1,  -1073,   1461,   2148,  -2961,
      -326,   -257,    440,    -42,    -48,   -320,    122,     94,
     -1267,   -830,   2810,    -94,   -201,    990,   2415,   -740,
      -166,   -267,   -157,     68,    301,    290,     65,    931,
      1969,   -170,      6,    149,   -272,   -105,    542,    -11,
     -3888,    105,    305,    333,    -14,    -39,   1944,  -1164,
        88,   3829,  -1190,   -535,   -644,   -330,    509,    -93,
      -314,   -228,   -294,   -342,    -26,   1143,  -2371,   -400,
        74,    101,    -68,   -583,  -1091,   3367,   1146,   -638,
      -436,    136,     41,    -92,   1518,   2818,  -2214,  -2044,
       636,     -2,     79,   -508,    676,   -439,   -358,   -198,
       -69,    271,     59,   1638,    468,     97,    264,     -8,
     -5152,   -152,    152,    252,    401,   -375,    -17,   -132,
        51,     63,    633,   -180,    367,    111,    -18,     15,
       -52,    128,    -54,     11,     96,   -122,    -26,  -7257,
       -42,  -1221,   -688,    197,   -107,   -217,    141,   -289,
       141,    269,    439,   -747,  -3743,   2098,    226,    137,
        26,  -1645,  -1735,    -80,     43,   -216,    245,    544,
       157,     40,    238,    237,   -989,    379,     88,    639,
     -1335,   1542,   1147,   -510,   1008,   -134,   -626,    696,
     -3034,    334,   -689,    115,   -168,     39,   1750,   -649,
      -233,    -99,   -231,    515,    112,    -11,   -162,   -133,
      -138,   -486,  -4137,    204,   -102,    867,  -1030,    219,
      -254,  -2787,   -128,    961,  -2837,   -482,   -195,    691,
      -170,   -178,    164,    -54,  -2008,   -116,     74,    398,
       -96,   -472,    407,     27,    287,    628,     97,  -1425,
     -3923,      6,    117,  -1081,    930,    396,    452,     87,
      -441,   -155,   -738,   1089,   2128,  -3133,    -21,   -622,
       -48,   -127,    506,    985,   -200,   3361,    184,   -522,
        41,    503,    209,     14,    -96,    791,   1263,    289,
      -101,  -1728,  -1073,   -517,   4156,   -685,    214,   -721,
      -608,   -102,   -295,   -114,    126,   -340,    109,     88,
     -1588,     82,   -549,   -376,     76,     84,   -210,     59,
      -130,    321,    678,   4704,    564,     -1,    100,    325,
      -296,    256,   -936,   -886,  -1088,   -191,    476,  -3684,
      1359,     12,   -397,    -70,    -17,     58,    569,    353,
       821,    -77,    253,    153,   5697,   -171,    181,      3,
       -90,   -413,   -265,    142,     62,    959,    151,   -103,
       845,   -340,   -280,   -733,   -592,   -244,   2534,   3089,
       935,   -393,   -105,    145,   -666,  -2865,  -1532,    717,
      2867,    206,   -800,   -125,    -34,   -189,   -138,     42,
       189,   -141,    107,  -3030,  -3795,   -494,    108,   -149,
       382,    760,   -142,    337,   -844,    228,    124,    232,
       -23,     -1,   2298,    750,    636,   -353,    157,    676,
      -191,    812,   3434,    759,    543,    -17,   -213,    -95,
       316,   -693,   -604,  -1059,     32,   -496,  -3334,   -272,
      -104,   -495,   -130,    627,   -376,     74,   -599,     55,
     -2185,   -968,    517,   -343,     21,   -249,   -963,    268,
      3339,    239,    771,   -134,     42,    231,     75,   1633,
       331,   -125,   -414,    457,   -316,    111,   -475,    363,
      -687,  -4105,    469,    443,    113,     72,   1498,    406,
       915,   -229,    564,   -377,     89,    137,     39,      2,
       -29,   -416,   -149,   3598,   -253,     12,  -1015,   3016,
       916,   -726,  -2286,    -99,  -1085,   -238,    690,    -44,
       -51,   -115,     25,     56,   -905,  -3050,  -1121,    -24,
     -2160,  -1424,   1009,   -180,   -424,    188,   -417,    -66,
       -86,     74,    -28,   -225,   -937,    -90,    251,  -1850,
      1939,   1843,    833,  -1879,   -192,   -318,    103,   -363,
       -22,    -57,  -2833,   -118,   -277,    -98,    -85,   -495,
      -874,   3027,   -141,  -1490,   -172,   -266,    -32,    190,
       -12,   -364,   -380,  -2107,    249,   -217,    662,   -584,
        89,   -563,   1153,  -3091,   -656,    463,    144,    -26,
};

static const int16_t cb4448ss1[] = {
      6475,    -60,    162,     42,    -71,     50,    -85,   -278,
       -14,    -60,    -53,    132,     28,    -65,    -71,    -62,
         6,    119,    195,   -140,     28,     37,   -603,  -4956,
      -290,    700,   -241,     11,   -301,    297,  -1009,    468,
       885,    192,     40,    495,    846,    -28,    201,   -255,
       927,   -644,   2424,   2882,    -82,  -1764,   1077,    315,
       946,    843,    399,    176,    567,    546,    377,    283,
      2469,  -1815,    -65,     12,    422,   -368,   -639,   -493,
     -5606,     84,    122,    241,    267,     -8,   -257,    -23,
      -220,   -118,    139,  -1582,   -218,  -2436,   2539,   -270,
       146,   -262,   -489,   1551,    604,   -225,    363,    234,
      -110,   -166,   1058,   2342,   1950,     43,   2362,  -1189,
       492,    172,   -296,    159,   -430,   -311,   -135,   -182,
        77,   -444,  -1995,   -855,   2080,   -457,    389,    872,
      2549,    935,   -128,    519,   -374,    310,     96,    119,
      -263,   1981,  -1019,   -628,    212,   -173,  -2292,   1066,
     -1985,   -426,    115,   -746,    147,      3,     94,    195,
     -1762,   1713,   -337,   1884,   -123,   -480,     95,    777,
      1073,   2117,   -969,     16,     11,    123,    374,   -394,
     -1419,    829,   1657,   1294,  -2770,    286,    813,   -290,
      -115,    111,    312,     53,     44,    896,     34,  -2288,
     -3443,  -2053,     98,    293,    429,   -168,     74,    -58,
       221,   -383,    100,     63,   1925,  -1207,    199,     94,
       -94,   3060,   1825,    611,    292,   -141,    382,    141,
       105,   -151,      0,   1448,   -267,    206,    932,   -682,
       251,   -183,   1080,    161,   4334,   -397,    525,    -91,
       127,   -104,    921,  -2282,   -274,  -1070,    387,   -312,
      1380,   2769,   -554,   1501,   -921,    102,   -183,   -104,
       -66,  -1656,   2049,    122,  -2271,     84,   -276,   -204,
       353,    380,   -414,  -1757,  -1035,   -318,   -130,    -10,
       163,   -471,   2425,   2864,  -1892,    294,    817,    754,
       277,    -29,   -214,    -39,   -312,    -57,    -54,    986,
      2286,   -574,     34,   -641,   3783,    214,   -399,   -155,
        38,   -148,    -42,    -89,     97,    -17,  -2192,    729,
       272,   1168,  -3593,    150,     96,   -473,    211,    -60,
       136,    -26,    142,   -285,     93,    666,   -465,   -181,
      2016,   -338,  -2186,  -2608,   -449,    107,    -18,     45,
        24,    245,   -119,    244,    442,   1509,    158,    242,
       169,    -16,   -221,    104,    115,     16,   -217,     23,
       -25,    130,   4076,    662,   -315,   3068,    -35,     36,
      2785,   -223,   -528,   -157,     43,    186,   -514,   -240,
        15,   -245,    520,   -110,   -781,   -641,    294,    -20,
        64,    -44,    400,   -109,   4756,   1334,   -421,   -195,
       130,  -2182,     64,   -897,  -1423,   3081,   -523,    378,
      -164,    968,    593,   -192,     71,    114,   -143,    -10,
      1961,  -3141,   3173,    -39,   -110,    -57,    144,    -68,
      -429,     30,    -10,    467,    159,     40,     67,    260,
       814,   -168,   -836,   1073,  -3562,   1786,  -1205,   -148,
      -105,     94,      5,    143,    138,     18,  -1384,     20,
       635,   -126,    -71,    -87,   -320,   -407,    559,   -151,
      1312,  -4395,   -755,   -263,    -77,   1657,    699,    426,
       469,   -469,    253,    -80,    317,    -71,    268,   3592,
     -2051,    304,    157,     43,   1872,   3794,  -1537,   1226,
      -159,   -335,    340,   -385,   -253,   -195,     21,    106,
       -31,   -187,    -63,  -2771,    446,   -708,    202,   -186,
       548,    832,   1757,  -1274,   1234,   -756,   -160,     76,
       -82,     64,   2169,     13,   -849,    244,  -2486,  -2138,
       844,   -178,    270,    297,    150,    202,    -41,   -188,
       121,  -1272,    371,   -319,   2848,   -469,  -2059,   1290,
      -457,   -380,    690,    148,    -51,   -340,    113,     57,
     -1259,   -396,  -1404,    336,   -511,    576,   4441,    124,
       143,   -483,     85,    138,    196,     38,   -188,   1177,
      -764,  -2067,    820,   -264,    218,   -300,   -501,   -230,
     -2529,   1349,  -1606,   -199,     92,    -55,  -1324,   -702,
      2078,  -1269,    414,    -50,     29,     12,     87,   -593,
       217,    -82,     94,  -2392,    308,   2315,   2188,    768,
     -1103,    -77,    579,   1706,   -826,   -224,   -297,    145,
      -640,    570,    146,   -199,   1187,   -872,    327,   -310,
      -122,    -23,    -13,    808,   -139,  -4425,   -670,    412,
        -4,    -70,   -162,  -1056,    685,   -312,   -957,    339,
       893,   -252,   4040,   -105,     76,    993,    281,    -79,
      -139,    168,   -298,    795,  -1107,    395,    386,   -524,
      1052,  -2341,   2537,    474,    726,  -1028,   -357,    -52,
       115,     -9,   1349,  -2240,    785,   2751,     77,    922,
       385,   -539,   -148,    410,    251,    -70,    199,     51,
      1728,   -206,   1181,   1182,   1388,   -791,    121,     -3,
         8,   -147,    -95,    101,    886,  -2412,     19,   2401,
      -116,    718,   -592,   -221,    724,    -33,    690,   -180,
       868,  -3330,    377,   -336,    128,    267,  -2075,   2848,
      2994,   -300,      3,   -153,     41,   -456,     38,    -31,
       309,   -106,    -92,    -14,     96,    672,    634,    207,
      1556,    438,  -2147,    282,   2443,  -1662,    511,    457,
      -259,   -505,    173,   -204,   -858,   -117,   2751,    852,
       220,   -512,  -2576,   1542,    357,    -77,     -4,    165,
       -63,    189,    302,   -699,   -764,  -1559,     25,   -233,
       405,    173,    698,    -73,   -300,  -1442,  -2923,  -1326,
       -25,     98,   -196,  -2915,  -1169,  -3392,    691,    353,
      -196,     96,     41,    180,    198,    280,    207,   -158,
       -19,   1556,    991,   -523,   -280,  -1599,   1368,  -3247,
      -996,    159,   -136,   -469,    -48,      0,     30,     95,
      -765,     33,   6580,   -180,    316,   -176,    105,    -21,
        -9,    166,    148,    -52,    -49,     42,      2,    318,
       -55,    -91,  -1461,  -1474,  -3086,   -756,   1479,    -29,
      -668,   -255,    -51,    241,    249,   -212,    132,   -129,
      -410,    113,     17,    301,    185,     96,     10,    188,
        38,   -772,   5152,    -13,    -10,   1527,    806,    -23,
       -79,   1102,    -77,    329,    -99,   -404,   2276,   -873,
     -2681,   -765,     71,     20,  -2448,   -803,   1827,   1115,
      -160,    -15,    288,    -46,    573,    100,   -726,   -694,
      -406,    288,     61,  -2216,   -904,     77,  -2983,   -962,
     -1438,    809,    -38,    -79,     95,     52,   -231,    518,
       115,     41,    908,    780,    805,   -207,  -2161,    554,
       968,   3111,    133,   -158,    -13,    -34,   -182,    -60,
       105,    718,  -1245,    227,   -818,   1184,    903,    603,
      -988,  -2647,   1847,    141,    817,   -337,    131,    393,
      1653,    839,   -261,    466,    465,   -297,   1440,   -431,
      2058,  -1857,  -1416,    310,   -722,    -54,    203,   -266,
      3770,    172,   -593,    -73,   -508,    -61,   1110,   1261,
       275,   1681,    447,   -147,    -95,     33,   1281,  -3119,
        24,   -308,    366,   -468,    232,    358,    667,   -942,
       696,   -924,  -2059,    -62,    151,  -2102,    332,    258,
      -186,   -636,    685,    214,  -3174,  -1243,    573,   -276,
         9,   -262,    -20,    158,   -174,    -21,    593,  -6198,
      -266,   -270,    -63,   -203,     63,   -396,   -100,    191,
       212,     85,    120,   -791,     37,    -47,   2108,    652,
       519,    346,    106,  -1840,  -2566,   -563,     14,    266,
        10,    214,    504,  -1269,     50,    164,    120,   -105,
      -546,   -212,    -79,     41,   -171,    675,   -252,   4373,
       -16,  -1697,  -1491,  -3588,   -587,    623,     67,    269,
       484,    -25,   1067,    580,   -598,    195,     47,    -17,
};

static const int16_t cb4448sm0[] = {
     -5114,    166,   -785,    635,   -528,   -102,    269,    492,
      -185,   -614,    122,   -124,     85,    145,    270,   -154,
        39,   2524,     58,    -57,    119,      5,    343,   2873,
      -278,   -787,    137,     62,   -169,   2049,   1476,   -325,
       130,   -702,   2882,    -19,    310,   -258,   -135,     88,
      -268,     69,     69,    695,  -1935,    815,    678,     44,
      3085,    278,   -587,  -1326,    360,    145,    -17,     66,
     -2475,   -594,    132,    358,    406,   -369,   -237,   3363,
       329,   -424,     52,     49,    291,   -236,  -2332,   -261,
        49,    -27,    170,   3656,   -214,   -603,    264,     60,
       -87,    145,    116,    179,    190,    679,    339,   -340,
      3272,    641,  -2631,    484,    159,    305,    290,    208,
       226,     68,    102,   -145,   -356,    153,    647,  -2046,
       937,  -1666,   1093,    -29,  -1161,    749,  -2360,    171,
     -2185,    841,  -1406,  -1057,  -1764,   -300,   -205,    452,
      2168,   -214,   -153,    291,   -106,     79,   1717,    -20,
     -1771,    286,   -466,    686,    167,    137,      5,     43,
      1075,  -2601,    261,    -86,   -333,   -724,    162,    186,
         4,   -334,   -412,   -309,    888,   -114,    531,    297,
      4284,    297,  -1695,   -212,     75,   -263,  -2313,    102,
      -434,    352,  -1813,   -472,    114,   -185,      6,     66,
      8061,    414,   -577,    672,   -152,    152,      1,     38,
       -66,     48,    -35,     62,    -98,    -19,  -3762,     98,
       242,    114,    359,   -162,    115,  -3038,    340,    253,
      -526,   -144,     14,   -147,     28,   -352,  -5858,     46,
      -597,   -392,    226,    -54,    -70,    -47,    -45,     16,
        53,    137,    172,  -3017,    -22,   -163,   -267,  -3289,
       -31,   -174,    110,    794,    425,     67,     58,    -72,
      -156,   3937,   -585,   2116,     99,  -1115,   -257,    801,
       270,   -329,   -257,    -18,    122,   -369,  -2196,   1746,
      -305,    599,    800,    749,   1466,   -299,  -1519,   -255,
      -233,    217,   -117,   -256,    301,   -249,   -327,   5530,
        86,    135,   -784,   -137,    610,     -7,     55,     93,
      -106,    -50,    267,   -229,    -26,  -1070,     13,    -75,
      1733,   2929,   -130,   -713,     15,  -2144,    104,   -318,
       282,     -8,   -285,   -468,   -124,     59,    520,    -78,
      -332,   -654,  -5048,    212,   -388,     97,  -1523,    227,
     -2545,   2159,   -127,   1020,     79,   -664,    403,    -31,
      -356,     -1,   -436,    -86,     75,    610,   3048,    235,
     -3133,  -1189,    -44,    -23,   -324,    260,    469,   -113,
        22,     53,    525,    427,    469,   1016,    420,    493,
     -1229,   -238,  -2671,    361,  -2745,    193,   -253,    -59,
        15,     53,    -57,     36,   -144,    127,     25,     11,
       -34,   6560,    -12,    -80,    -72,     70,    654,  -1135,
       158,    279,    298,    746,   -190,  -1382,    138,    527,
     -1504,  -2753,   -106,    -55,    225,     54,    136,     53,
       506,    174,    268,   -533,    -43,   -416,   -196,   6266,
       -81,     22,   -158,    350,   1177,   -728,    594,     34,
      -368,   -226,   -584,    247,    804,  -1141,     78,   3923,
       -53,    309,     58,    -45,  -7634,    -73,     39,   -152,
        55,    -77,    -45,    -62,    -25,   -247,   -161,     28,
     -2629,   -401,   -295,   -687,    298,  -3240,      0,   -251,
         7,    -49,    494,   -198,    202,   2201,   -301,     83,
        45,   -964,    256,  -1499,  -2394,     24,   -267,   -599,
        46,    161,   -370,     81,    636,   3146,  -2077,   -964,
       322,    400,   -635,   -688,   -630,    -92,   -235,    104,
       -77,   -541,    511,   2722,    441,   2757,    952,    739,
      -257,   -254,   -438,   -122,   -151,     12,    578,    -92,
      -440,    -63,     93,   4971,   -499,    419,   1374,   -165,
      -417,     64,    -13,   -235,   1080,    -77,    536,     68,
      -842,   -772,   1627,   -471,  -1350,   -144,   2849,    219,
       114,     68,    -55,    350,    -11,  -1334,  -3042,   1166,
      -147,   -891,   -483,   1461,    339,    808,    362,   -101,
     -2807,    -24,   -377,    518,   -438,    194,   -110,    194,
      -826,   3380,    -81,    -30,    -43,    103,    -99,   1539,
      -614,    -13,  -1154,    196,  -3122,   -521,   1454,   -319,
       159,   -428,    722,   -208,    162,   1871,   2534,   2287,
       946,    261,   -483,   -645,     26,   -170,    -31,     17,
       164,    104,    -44,  -8192,    -20,     94,   -235,     56,
        68,    -58,    380,    -25,   -170,     17,     16,   -154,
        63,    477,   1280,    614,   -529,  -2347,   -360,    159,
      1967,  -2085,    485,    335,    378,    178,   1633,   -437,
       -46,     23,    640,   1465,    -91,   1279,  -1025,  -1007,
      -236,   2632,   -257,    262,    177,   3029,  -3149,  -1001,
       231,   -262,     87,   -243,    -68,   -597,    109,     62,
      -264,     37,   -463,  -3105,   -633,    881,   1026,    -86,
       417,    705,  -1144,    -68,  -2084,     46,    124,    -36,
     -2461,    -73,   -126,   -303,   1079,   -358,  -2764,   -761,
     -1454,   -245,    203,      0,   -179,   -117,   2571,  -4751,
       -20,    194,    298,    258,    390,    270,    -36,    182,
       152,    -56,    -97,    -47,    138,   -233,   -111,  -1490,
      -490,   -329,    662,   -320,  -4697,    443,     66,    352,
       203,   -114,   -119,    186,    649,   -106,     -5,   2280,
      1132,   -376,   1168,    919,   1858,    271,  -1741,   -130,
     -3388,    264,    618,  -2375,    260,   1279,    110,    732,
       128,   -373,     54,   -182,     99,   -131,      9,     30,
       -83,     27,    204,    109,   -306,   6903,    130,     -7,
      -115,     92,   -241,    119,   -640,   -871,    -40,    372,
       -68,   -147,  -1503,    -58,    920,   -466,    311,    144,
     -3648,   -121,   -357,      5,   1968,   -737,  -1491,    596,
       818,    122,    688,   -137,  -2415,   -368,    236,     71,
      -597,   -193,   -395,    795,    855,    657,    -49,    844,
     -3320,  -1921,    846,     17,   -293,    -17,  -1676,  -1826,
      -138,    897,   -207,     -3,   1838,   -901,     86,    275,
       964,    230,    510,    -10,   2879,   3949,    332,    289,
       109,   -229,     18,    238,    244,    287,     44,    103,
       367,     21,  -1134,   -378,   1338,   -828,   3500,      5,
      1027,    475,    208,    654,    589,    -92,    236,    -85,
      -115,   1095,  -2504,    827,   -885,   -806,   -155,   2112,
      -346,   1120,   -350,   -911,   -234,    231,     55,     87,
      1957,    601,    755,  -1248,    753,  -2726,   -481,   2038,
        96,   -363,    309,    150,    299,   -561,   -698,  -1030,
       118,   1224,   3240,  -1523,   1476,    342,   -688,    -76,
       192,     -8,   -319,    350,    149,   -331,    155,   -436,
       286,   -994,    160,  -2696,   -423,  -2798,   -135,   -108,
     -2846,   -254,   3590,    350,    130,   -810,    463,   -123,
        59,   -256,    251,   -750,    -76,     -8,  -1633,    150,
      -931,   1958,   1523,  -2527,    239,   -287,    172,    332,
       -13,    486,    247,    -26,    149,     59,    130,    265,
        19,    209,   7220,    -23,    -99,    -69,    -66,    -70,
       -54,    -75,     60,   -264,   -102,   1079,   -535,   1587,
      -557,  -1499,    241,  -2596,   1157,   -140,    270,     33,
};

static const int16_t cb4448sm1[] = {
      7894,   -331,    383,   -556,     63,   -371,    -23,     73,
        46,   -145,    105,     43,   -199,    -52,    -85,    -85,
        13,    -21,   -230,   7379,    268,   -243,   -460,    251,
        73,     12,    115,    -18,   -247,    433,    -90,   -518,
       962,      0,   -960,    184,   -305,  -2003,    276,   1696,
      2418,    270,  -2140,   -215,   -534,   -389,   -403,  -3500,
       416,    567,   -393,   -183,    253,   -100,   -285,   -107,
       100,    281,   -527,  -2944,    -86,   2652,    311,   -785,
      -811,   -283,    425,    -77,    393,    136,    170,   1290,
      -765,    108,    676,   -213,  -1226,   -470,    427,   3499,
       616,  -1211,   -226,    -37,     88,  -2792,    351,     78,
     -2975,     99,    192,   1390,   -338,     47,     -8,     58,
      -255,     50,    221,    -49,   -788,   -207,  -2122,   -167,
      -692,    379,  -3239,   -965,   -698,   -463,    -45,     34,
      1785,   1026,  -1107,    113,    124,   -258,   -277,   -714,
      2764,   -178,   -200,    907,    -45,   -213,  -2575,   -530,
      -112,   3616,   -128,     76,   -366,   -135,    -22,    -51,
       125,   -100,    -79,    142,     54,    107,     87,    493,
       -34,   -221,   -448,   -243,    994,    845,  -4656,   -105,
      -487,     41,   -112,    349,  -4328,    -72,    513,   -112,
      -685,   -470,   -138,   -541,    340,  -1505,    -24,     37,
       169,   -405,   -434,  -2994,    -42,   -416,  -1927,   1551,
     -1488,    420,    179,    -66,     14,     92,    147,    141,
       497,    404,   -412,   2301,    336,  -2877,  -1845,   -948,
      -784,    262,   -211,      6,  -1678,   -434,  -1433,   -727,
      1254,    542,  -1430,   -302,   1558,    107,    617,   -833,
      -369,   -178,   1682,  -2569,  -1232,  -1556,    -87,   -178,
       400,   -178,   -427,   -124,    -63,    142,   -221,     33,
      2880,   -227,   -356,   -466,  -3362,   -398,   -167,    164,
       126,     59,     -1,      5,    212,     25,   2062,   -462,
       -33,    -46,     45,   -201,    823,   -268,   -302,   3623,
       389,    382,    136,    -30,    -64,      2,   -600,   3114,
      2720,    273,   -588,   -235,   -313,   -141,     37,    -28,
       355,    184,   -433,   -110,   -576,    -56,    134,   -623,
      -271,  -2529,  -2753,    947,   1319,     -2,    620,     36,
      -412,  -1986,    221,   -404,    514,   3223,   -106,   1497,
      -368,   -167,   -142,   -366,   -125,     16,    142,   -435,
      -160,   2845,   -153,    470,    387,   3117,    -75,   -375,
       658,    259,    755,     -3,   3744,   -517,  -1446,   -667,
      1372,  -1692,    117,    -96,    195,   -201,   -134,    -76,
       179,     97,     71,   1887,    161,    365,    228,   1177,
       235,   -834,    -48,   1667,  -1123,   2217,   -209,    100,
      -219,  -2778,     81,   -579,   3421,   -326,   -492,   -233,
        78,     32,    117,    -74,    -80,     85,   -282,    453,
       500,    721,    800,     83,   -624,   1000,    165,    -20,
      -516,  -4193,   -334,    107,   1221,  -1507,    -10,    523,
        85,    -44,     21,     34,    199,   -106,  -2233,    525,
      2138,     40,    -55,    -63,  -8179,    326,    333,   -152,
       -27,    137,    212,    130,    -10,     76,    -61,   -113,
      -544,   -179,   -187,      0,  -5308,    322,   -326,    513,
       415,    375,    -92,   -354,     69,     77,     65,     93,
      -352,   -165,  -1837,   1790,    914,   -276,   2215,  -1418,
       343,    281,      4,    283,   4398,   1695,   -248,    153,
      -166,    751,    822,   -406,   -456,   -251,    185,   -251,
      -222,   -169,   -266,  -6323,    249,    -40,    -45,   -203,
        47,    -83,   -621,   -174,    327,     30,    114,    -29,
      -505,   -224,   1804,   1582,  -2292,   2102,   -746,   -421,
       170,    438,   -171,    153,     84,   -157,  -2937,   -123,
       -81,   -227,    -98,    263,   3531,     36,    105,   -479,
       -94,   -357,    -22,   -124,    279,   -116,    543,    201,
      -393,   -226,  -2255,   -133,   1613,   -123,   2687,     70,
       191,    240,   -996,   -676,    606,  -1245,   -306,    413,
      -272,   -539,    485,   3583,   -224,    432,    389,     31,
      -888,    318,   -149,   -228,    764,   -426,   1608,  -2656,
       254,  -2193,    252,    484,    -90,   -117,   -257,  -2210,
      -156,    553,    559,    680,    298,    -16,   -519,   1172,
      2172,   1288,   -113,    186,   -199,  -1415,    -83,  -1984,
       667,  -1013,    344,   -399,   2889,  -1175,   -908,    186,
       185,    -22,   -328,   3132,  -1166,    209,   -213,    386,
      2140,    552,   1023,    719,    529,   -169,    421,    196,
        76,   1995,    532,    -75,   2060,   -526,    396,   2974,
      -264,   -348,    149,    586,     22,     97,   -337,   -252,
       357,    103,  -2308,  -2578,  -1836,   -277,    346,   -314,
      -989,    185,   -314,    102,     56,   3779,   -265,  -1029,
       -12,   -126,   -431,    356,  -2493,    -86,    172,    116,
        61,   -146,  -2220,    211,   -165,    233,   -327,     73,
        -7,   -104,   -546,    253,  -2406,    361,   2252,    486,
       675,   -177,   2643,    603,    300,   1123,   -642,    361,
       684,  -2151,    569,  -1014,    120,    -50,    321,   3174,
      3080,   -733,   -427,    299,    169,   -123,   -140,    -13,
      -315,     21,   -120,    -24,    174,   -191,   -350,  -7842,
      -145,   -169,   -419,    -15,    150,   -130,    -73,    162,
        -9,     38,   -287,    109,    390,    147,    151,   1907,
     -4243,      7,   -207,   -147,   -230,   -343,   -117,   -111,
       107,    132,   1457,    -88,     -8,   -445,   -176,   -172,
     -1799,   -813,    486,   1150,  -3026,   -168,  -2620,   -584,
       178,   -543,  -1868,   -359,   -113,  -1783,    214,   -663,
       473,    866,   -136,    169,  -3324,   -129,  -3404,   -249,
       234,    422,    251,    340,   -343,    231,    134,    -42,
        32,     64,   -209,     12,    236,   -267,   -419,      1,
       260,   -109,   6508,    105,      7,   -273,   -123,   -107,
      -152,   -274,   -157,     75,     74,   -201,     46,     37,
       338,    -21,   -180,    208,  -6417,    794,    250,    -81,
      -585,      4,   -119,   -314,    529,    219,    159,   -132,
      -277,     76,   -613,   4933,     15,    213,   2461,    286,
       542,    177,   2767,    389,    136,    750,    559,   -994,
       684,    -12,  -2081,   -546,    -89,  -3733,    548,   -620,
       675,    118,   -121,    190,    -52,     19,    -19,     25,
     -1224,    344,   3094,  -2067,      7,    273,  -1268,   -375,
      -297,   -201,    271,   -191,    123,      6,   -260,   2284,
      -308,  -3062,    242,    668,   -221,   1146,   1218,    473,
      -133,     82,     57,    112,  -1677,     78,   -229,    354,
      -463,    763,   1628,   2243,   1386,   1630,   -145,    255,
       -60,    228,    195,   -864,   2539,   -466,    985,  -3075,
         2,    118,    221,   -395,   -450,   -256,   -158,    -32,
     -3829,   2012,    -50,   -465,    146,  -1091,   -318,    271,
       -12,    596,    160,    120,     92,   -209,   -335,    104,
       -28,    689,    305,   -548,   -849,   1617,    605,    185,
      -414,   3899,   -273,     51,    182,   -192,    121,    616,
      1219,    414,   -959,  -4219,   1319,     60,    246,   -468,
       -32,    225,    338,    -39,   1235,  -2079,   2250,    626,
       121,    296,   -137,   -339,  -1870,    -47,   -397,    124,
};

static const int16_t fcb8l[] = {
     -1239,  -1310,  -1240,  -1146,  -1337,   1303,   -482,   2215,
      2026,   2222,  -1144,  -1188,  -1209,   2535,  -1111,   -844,
      1485,    625,   1254,   1204,   5932,  -1116,  -1235,  -1208,
      -801,  -1020,   -558,   1387,   1513,  -1079,   3220,   -896,
     -1083,  -1166,   2246,  -1210,   -838,   -950,   -960,    764,
     13941,  -1307,   -817,  -1253,   1850,  -1320,  -1361,  -1218,
      -671,    780,   -839,  -1068,   -776,   2977,   -714,   -944,
      -823,   -580,    357,    591,    302,  -1078,   -895,  -1020,
      3116,  -1144,   1438,   -891,    -71,   1528,   -238,  -1297,
     -1020,   4616,  -1185,   -514,  -1154,  -1157,   1901,   2372,
     -1131,  -1289,  -1273,  -1289,  -1311,  -1331,  -1340,    439,
       455,   2395,   -537,  -1180,   2409,  -1084,   -580,   1937,
       846,    -51,    615,   1099,   3854,  -1177,   -912,  -1095,
       656,   -995,   -647,   3298,   -976,   -436,  12323,  -1291,
     -1187,  -1341,   4779,  -1368,  -1357,  -1317,   -985,   1407,
      -513,  -1387,  -1224,  -1069,  -1218,  -1117,   -181,  -1209,
      5376,   4256,    -22,  -1232,  -1173,   -834,  -1054,   -947,
      -611,   -822,   -206,   5572,   -988,   1067,   -837,    738,
      -332,    -38,    -59,    143,    248,    386,   -447,  -1233,
     -1258,  -1169,   3653,  -1045,   -657,   -926,   2004,   2201,
     -1164,   7042,  -1302,  -1313,   -812,    150,   -129,    305,
       442,    742,  -1185,  -1293,  -1220,   -872,  -1304,  -1260,
      -853,  -1293,   2962,   3011,   -178,  -1187,  -1087,   -896,
      -895,  -1053,   3788,     59,   -169,   1632,  -1201,  -1289,
      5263,   -896,    331,   -852,    218,    825,   1129,   1024,
       -39,  -1186,  -1054,   1862,  -1198,   2010,  -1075,  -1005,
       702,   1550,   4491,  -1055,   -890,   -645,   -987,   2465,
       529,    194,    -72,    370,   1547,   -968,   -849,  -1153,
      6459,  -1164,  -1061,  -1020,   -838,    125,   3698,  -1168,
     -1066,   1882,  -1159,   -439,  -1017,   -759,    744,   1302,
      -812,   -985,  -1002,  -1029,   -871,   3690,   -170,    604,
       623,   1272,   6135,  -1012,  -1231,  -1066,   -927,  -1082,
      2393,   -843,   1537,   1240,   -866,  -1161,   -866,   6639,
      -994,   -860,   -264,   -298,    469,   1184,   -868,  -1262,
      2167,  -1177,   2132,   -987,   -563,    969,   1145,   1508,
      -735,  -1232,  -1090,  -1204,   1507,  -1101,   -393,    755,
       975,   1246,   1944,  -1068,  -1169,  -1040,   -987,  -1301,
      5488,  -1057,   3150,   1890,  -1133,   2725,  -1123,   -963,
      1901,    260,   -484,    449,    564,   1144,    679,  -1118,
      -989,   -702,   -556,    162,    689,    712,    673,    443,
      -695,  -1247,  -1019,  -1065,   -406,  -1143,   1750,   -743,
      2644,   2402,  -1171,  -1157,  -1059,   -823,   -688,   1314,
      1458,    629,    857,    856,   -875,  -1316,   3470,  -1061,
      -846,   -761,   -712,   -955,    978,   1967,   -980,   3517,
      -994,   -953,   -903,     56,    228,    -30,    359,    560,
      9926,  -1178,  -1056,   -627,   -952,   -481,  -1168,   -268,
      -701,   -555,   -887,  -1212,   1768,  -1156,   -396,   -755,
      -119,   1594,    949,   1201,   -844,   1734,   1312,   -331,
      -500,   -280,   -125,   -219,   -139,    496,  -1121,  -1227,
     -1145,   -215,  -1123,   -765,   -173,   4055,   1086,   1465,
      -714,   -904,   -901,   -713,  -1073,   1233,   -797,    645,
        58,    897,   -518,   -624,   -441,   -554,   1139,    549,
       147,     72,    127,    428,  -1104,   -979,   2433,   1867,
      -237,   -745,   -280,    110,    794,    631,  -1049,   1141,
      -974,   -920,   -849,   -392,    634,    414,    614,    797,
     -1162,  -1344,  -1192,  -1259,  -1079,   -912,   2717,   2548,
      1847,   1920,  -1004,  -1091,  -1006,   -692,    -85,    -24,
      1014,   1427,    751,   -584,   6057,  -1206,  -1072,   -795,
      -921,  -1103,  -1157,   -623,   -818,   2641,   3121,  -1084,
     -1095,   -939,   -664,   -694,    884,    555,    144,    593,
      -874,  -1074,    417,  -1027,     -6,   -790,   1687,     80,
      1018,    738,   -527,   -958,   -701,   -377,     -4,    155,
       304,   -348,   -947,   -342,   2269,  -1040,   1124,   -494,
       -76,     76,      2,    114,   -194,    348,    904,    466,
      -577,   -717,    107,    -39,    -29,    158,    101,    149,
      -968,   -921,    558,   -264,   -445,    138,   -121,    -33,
       105,    243,   -478,  -1047,   -937,   -751,   -609,   -822,
      -709,   -976,  -1006,   2800,  -1108,  -1292,  -1055,  -1272,
     -1295,  -1152,    305,  -1144,    635,   2067,   -584,  -1135,
      -663,  -1130,   -754,  -1009,   -937,   -515,   1473,    841,
     -1235,  -1338,  -1305,  -1141,  -1109,  -1217,   -238,   1915,
      3550,   2306,   -963,   -985,   -874,    763,   -826,   -694,
        19,    391,    379,    776,   -582,  -1216,  -1285,  -1164,
     -1276,  -1305,  -1273,   2631,   -579,   2487,   1058,   -655,
      -808,   -878,   -910,  -1006,  -1122,   -590,   -663,    428,
      2185,  -1125,  -1032,  -1076,   -873,  -1139,  -1029,   -477,
      1720,   1238,  -1111,  -1311,  -1343,   1074,  -1328,  -1181,
      -970,   -386,   2359,   1777,  -1045,  -1189,  -1117,  -1053,
      -942,   -329,    501,   1237,    808,   1022,   -866,  -1048,
      -678,   1597,   1528,   -262,   -256,    231,    418,    728,
};

static const int16_t fcb8s[] = {
     -1022,   -858,   -773,    304,   -881,   -771,   -341,    937,
       270,    420,   -684,  -1000,   -795,   -903,   -671,   -575,
        14,   3327,    528,    893,    965,   -541,   -947,  -1027,
      4008,  -1081,   -743,   -991,   -808,    933,  -1406,  -1173,
      7513,   -824,   -213,   -797,   -648,    -40,    176,    217,
     -1298,   6743,   -755,   -232,   -440,   -680,   -269,    -60,
       -80,    -85,   -893,  -1044,   -726,   -733,   -834,   -641,
       231,   -779,   -501,   1832,  -1296,   2548,   2754,     19,
      -210,   -708,   -205,    -74,     18,     55,  -1225,  -1123,
     -1239,   6991,   -689,    272,   -290,     56,    356,    675,
      1623,  -1134,   -607,   1426,   -872,    511,  -1060,    408,
       253,    423,   1960,  -1337,  -1152,   -985,   -924,   2020,
      -398,    348,   4188,   1044,   -650,   -831,   2909,   2083,
      -457,     -5,  -1037,   -964,   -128,    -40,   6019,   -858,
      -937,   -559,   -624,   -601,   -411,    120,   -289,    412,
     -1271,  -1351,   3858,  -1214,   2224,   -325,   -165,    535,
       559,    386,   1868,    649,    269,    245,   -708,   -778,
      -179,    -12,    101,    -12,  -1235,   -892,   -829,   2570,
      -574,   -431,    170,    167,    492,    531,   -930,  -1093,
     -1037,  -1177,  -1151,   -912,   -466,    303,   1601,   4089,
     -1234,   3160,   -631,  -1090,   -741,   -274,    103,     13,
       356,    289,   2709,  -1115,  -1011,   -965,   -948,   -563,
      1939,    870,   1187,    550,  -1028,  -1217,   -726,   -954,
      -694,   -753,   3729,    141,    518,    854,  -1102,   1138,
      -947,   -620,   -379,   -436,     72,    449,    432,    428,
     -1112,   1276,    544,   -334,   -445,    179,    -32,    -37,
         9,     28,  -1252,   2983,   -963,   1256,    419,    -10,
        17,    211,    218,    191,    126,   -942,   -691,   -529,
      -533,   -193,   1216,    150,    389,    152,  -1191,   -987,
      -942,   -860,   -463,   -705,   -159,    184,   1893,   1080,
      1753,   -694,   -609,   -699,     61,    269,   -126,     93,
       236,    380,   -527,   -966,   -334,    163,   -662,   3295,
      -477,    591,    259,    638,    397,    181,   -598,   -129,
        35,    -51,   -122,     64,    -32,    -98,  -1351,  -1140,
      3372,   -753,   -776,    718,    513,    134,    420,    354,
     -1128,   -546,   -743,    297,   1819,    -77,    179,     17,
       181,    206,  -1028,  -1027,   -757,   -755,   -389,   1035,
       227,    249,    315,    395,   -931,   -881,   1207,   -777,
      -165,   -531,   -375,     73,    346,    332,  -1159,   -788,
      1196,    959,   -432,   -337,    243,    176,    321,     -7,
};

static const int16_t fcb8m[] = {
     -1379,  -1331,  -1277,  -1266,   -927,      0,   2552,   2575,
       425,     48,   2568,    -26,   -841,   -762,   -679,   -562,
      -420,    186,     68,     69,   -743,   -193,    266,     92,
      1714,   -241,   -357,    -93,   -252,   -222,   -884,   -385,
      2436,   -446,   -150,   -533,   -192,    -33,    226,      8,
      -756,  -1180,  -1238,  -1258,  -1250,  -1147,   -764,    141,
      3075,   4136,  -1255,  -1288,  -1202,  -1188,  -1222,  -1257,
      -500,   1989,   4062,   1328,   -300,   -186,   -399,   -329,
      -330,   -533,   -313,   2030,    193,   -128,   -933,  -1016,
        66,   1648,   -228,   -321,    236,    114,    356,    212,
      -677,   -826,   -784,   -670,   -484,   -423,   -188,    215,
      2476,    652,   3424,   1991,    940,   -576,   -942,  -1038,
     -1097,  -1161,  -1120,   -956,   -763,   -416,   2824,   1429,
      -693,   -755,   -455,   -670,   -535,   -225,   4814,    116,
      -940,   -953,  -1008,   -856,   -797,   -582,   -531,   -213,
      -412,   2479,   -156,   -218,   -319,   -168,   -236,   -248,
      -305,   -515,   -224,   -382,   -501,   -759,    139,   1789,
      -258,   -343,   -167,    721,  -1014,  -1092,   -975,  -1070,
     -1126,   -778,   -178,     36,    522,   5371,   -402,  -1351,
     -1577,  -1662,  -1642,  -1560,  -1249,   -870,    602,   8968,
     -1126,  -1102,  -1118,  -1072,   -946,   -511,    482,   1635,
      1108,   2471,   -935,   -748,   -302,   -445,   -810,   -359,
      1433,    -83,    336,   1834,   -712,   -773,   -752,   -609,
      -391,    625,   2550,    403,   -447,    -18,   -261,     91,
      5096,   -199,   -887,  -1018,   -728,   -930,   -921,   -684,
       -22,   2422,   2118,   -417,   -757,   -789,   -732,   -794,
      -785,   -664,   -627,    885,    471,    798,   -429,   -684,
      -454,   -185,    185,    -26,   -990,   -369,   1048,    -25,
       -98,    720,     41,    -60,     -3,    -92,   -790,   -147,
       846,   4007,   -346,   -907,   -849,   -730,   -639,   -842,
      9096,    617,  -1164,  -1275,  -1380,  -1396,  -1391,  -1364,
     -1342,  -1080,    655,   5687,    505,   -818,  -1134,  -1125,
     -1136,  -1123,  -1088,   -996,      3,     36,    -48,    -28,
       121,    -55,    172,    -43,     21,    -74,   1537,    -69,
       378,    -38,   -113,    159,   -149,   -609,   -693,   -796,
      -715,    588,    376,   -744,   -659,   -316,    145,    448,
       659,    320,    787,   -315,   -956,   -682,   -595,   -327,
       146,    348,    837,    577,  -1011,  -1014,   -647,   -159,
       679,    158,    294,    670,    507,    540,    418,    558,
        12,   -674,   -901,   -897,   -827,   -682,    323,   2580,
};

static const int16_t fcb8sl[] = {
     -1269,  -1637,  -1349,  -1672,  -1421,   2750,    212,   3563,
       -74,   1555,  -1495,  -1148,  -1172,   1351,   -484,   -473,
      1418,    557,    899,    635,   6124,  -1140,  -1154,    783,
     -1444,  -1509,  -1041,   1793,   4459,   1325,   2055,   -921,
      -794,   -713,   1625,    -50,     78,   -159,    361,    855,
     10282,  -1533,  -1105,  -1582,  -1704,  -1697,  -1440,  -1001,
       864,   2038,  -1347,   -847,  -1419,   1474,  -1369,  -1189,
     -1125,   -655,   -134,    950,  -1398,   -222,  -1498,  -1262,
      2597,    729,   2521,   -544,    457,   2058,   3821,  -1568,
     -1577,   2013,  -1717,  -1620,  -1292,   2771,   2559,   4942,
     -1497,  -1576,  -1724,  -1550,  -1775,  -1734,  -1097,   -635,
      1934,   2706,  -1399,   -994,   1685,  -1142,   -511,   1595,
      -275,    861,    484,    958,  -1374,   -764,  -1105,  -1493,
     -1678,  -1630,   -521,   5138,     53,   1331,   4909,  -1376,
      2134,  -1638,   1562,  -1565,  -1487,  -1625,   3232,   4742,
     -1017,  -1353,  -1212,  -1585,  -1309,  -1139,    -71,   -820,
      5928,   2987,   -641,  -1314,  -1198,  -1182,  -1005,   -542,
     -1287,  -1210,  -1103,   6865,  -1130,   1375,   -884,   1241,
      -532,   -173,    -68,     15,    309,    192,  -1128,  -1107,
      -849,  -1343,   2233,  -1281,   -535,   -679,   3878,   1865,
     -1427,   4508,  -1022,   -747,  -1117,  -1104,    -33,    669,
      1216,   1482,  -1360,  -1075,  -1483,  -1390,  -1366,   -754,
     -1042,   -766,   3467,   -624,   -968,  -1101,   -393,   -890,
      -447,   -995,   2346,   -909,   -784,    977,  -1141,  -1201,
      5256,  -1552,   -536,  -1419,      0,    596,    556,   1654,
     -1124,  -1225,   -830,   1267,   -719,   1791,   -546,   -297,
       978,    378,   2674,  -1261,  -1159,   -951,  -1027,   2537,
      -470,   -360,   -268,   1098,  -1154,  -1513,   -729,  -1455,
      5671,  -1236,   -800,   -874,   1630,   1273,   1909,   -623,
      -724,   1417,   -559,   -326,   -257,   -189,    265,    220,
      -284,  -1302,  -1272,  -1223,   -842,   4338,   -934,  -1001,
      -495,   2944,   4295,   -924,  -1004,  -1097,  -1024,   -328,
      1736,    106,    452,    158,  -1024,   -541,  -1296,   4376,
     -1117,  -1224,   -843,   1097,   1121,   1251,   -829,  -1374,
      2292,  -1505,   1850,  -1153,   -943,   -979,   -534,   1444,
     -1510,  -1494,  -1147,  -1397,   1535,   -794,    -21,   1313,
       638,   1015,  -1072,  -1275,  -1166,  -1602,  -1618,  -1379,
      4541,   -226,   2169,    888,  -1369,   2392,  -1087,   -948,
      1074,    674,    384,    124,    500,    749,    398,  -1091,
      -721,   -114,    -15,    413,    200,    135,    290,    189,
     -1185,  -1188,  -1339,  -1549,   -871,   -574,   2333,   -346,
       554,   3773,  -1247,  -1531,  -1408,  -1310,  -1007,   2861,
      2465,    608,   1080,   1224,  -1103,  -1477,   1884,  -1412,
      -904,  -1473,   -846,   -188,    782,   2049,  -1473,   1531,
     -1530,  -1459,  -1546,  -1260,   -856,   1191,    652,    933,
      5072,  -1456,  -1653,   3759,  -1751,   -531,  -1391,   4297,
      -374,   -751,  -1570,  -1242,   1461,  -1286,   -913,   -621,
      1768,   1246,   1291,    779,  -1360,   1641,   1122,   -629,
      -328,   -197,    241,    359,    560,    536,  -1474,   -506,
     -1523,    298,  -1551,  -1254,   -985,   3603,   4317,    958,
      -885,   -241,  -1159,   -930,  -1249,   1490,   -825,    274,
       347,    307,  -1060,  -1027,   -809,  -1063,   1554,   1708,
      -242,    -23,    424,    804,  -1317,   -853,   1571,   1898,
       239,   -556,    298,   -161,    777,    765,  -1464,   1053,
     -1198,  -1156,   -917,      0,   1460,    447,   1178,    629,
     -1455,  -1591,    296,  -1785,  -1694,  -1631,   3669,   3819,
      3437,   3274,   -956,   -666,   -874,   -284,   -858,   -202,
      -687,   1728,   -512,   -951,   4692,  -1360,  -1242,  -1188,
     -1513,   -449,  -1566,  -1515,  -1226,   3857,   1246,  -1225,
      -860,  -1068,   -748,    -27,    380,   1190,    591,    552,
     -1391,    194,   -763,   -463,    331,   -265,    702,    181,
       290,   -145,   -838,  -1359,  -1381,  -1569,  -1399,  -1088,
     -1357,  -1295,   -486,   -612,   1638,   -586,   1458,   -774,
      -223,   -620,   -104,    189,    344,    269,   1555,   1428,
      -867,   -621,   -294,   -206,     32,    235,    261,    161,
     -1021,   -105,    654,   -235,   -282,     -7,    189,   -159,
      -218,    113,  -1096,  -1318,  -1256,  -1335,   -931,   -476,
     -1041,  -1199,  -1134,   2781,  -1479,  -1222,  -1397,   -867,
      -815,   -661,    740,   -240,   1158,    735,  -1435,  -1003,
       351,   -990,   -245,    -72,   -347,    -72,   1408,    634,
     -1697,  -1727,  -1534,  -1716,  -1436,   -102,    402,   1518,
      1903,   1311,  -1477,   -930,   -355,    508,   -162,     21,
       -46,    454,    387,    173,  -1312,  -1284,  -1486,  -1172,
     -1356,   -965,  -1106,   1760,   -670,   2163,    -70,    417,
      -559,   -667,   -545,   -945,   -429,   -363,    157,   1280,
      2059,  -1319,  -1291,   -975,  -1354,  -1249,   -780,   -476,
      1410,   1252,  -1193,   -927,  -1462,    871,  -1281,  -1327,
      -900,   1540,   1531,   1227,  -1651,  -1334,  -1073,   -752,
      -154,    710,    830,    773,    279,    307,  -1294,   -796,
      -761,   1012,   1583,   -420,   -177,   -323,    154,    582,
};

static const int16_t fcb8ss[] = {
     -1481,  -1069,  -1082,   -726,   -818,   -550,   -417,    343,
       489,    275,   -814,   -510,   -712,   -933,   -558,   -236,
        32,   3051,    451,    301,   -414,   -237,   -683,   -599,
      3627,   -445,   -232,     56,     58,    112,  -1226,   -639,
      4096,   -644,   -226,    -23,     90,    162,    313,    104,
     -1385,   5607,   -428,   -860,   -447,   -265,   -145,   -132,
       115,   -200,  -1349,  -1280,  -1216,  -1046,   -657,     43,
      1333,    831,    675,   1174,  -1394,   2288,   1840,   -682,
      -497,   -256,     22,     22,    261,     70,  -1369,   -826,
      -975,   2286,   -329,   -267,    142,     36,    437,    313,
      1570,     52,   -470,    622,   -244,   -247,   -114,     22,
      -117,   -541,  -1167,   -596,   -809,   -929,   -669,   -327,
       102,    516,   2790,    597,  -1317,   -870,   1327,    987,
       -25,    391,    -48,    -82,    209,   -242,   4424,   -311,
      -396,   -765,   -382,   -336,   -365,   -414,    -74,    -13,
      1127,   -588,   1363,   -714,    368,   -450,   -390,   -364,
        84,    139,   1864,   1881,    -15,   -790,   -281,   -286,
        38,   -186,    -31,   -238,  -1249,    262,   -841,    731,
      -414,    -61,   -274,    280,    100,    557,   -841,   -775,
     -1007,  -1063,   -687,   -374,   -360,     31,   1048,   3471,
     -1385,   2464,   -840,  -1105,   -714,   -400,     56,    445,
       588,    427,   1785,  -1093,   -783,   -847,     41,    -23,
       465,    392,    382,    428,   -518,   -249,    -58,   -791,
      -689,   -581,   3146,   -183,    296,     66,  -1243,   1059,
     -1076,   -874,    416,    544,    253,     66,    168,    211,
     -1388,   1253,    138,   -727,   -509,    905,    319,   -297,
        67,   -525,  -1470,   2237,    -87,    547,    556,   -239,
        90,   -147,   -114,   -302,  -1017,   -824,   -585,     25,
         0,     62,   1422,   -155,    -41,   -320,  -1125,  -1069,
     -1134,   -783,   1129,     45,    183,     47,    716,    672,
       409,  -1169,   -910,   -447,    -34,     79,     95,    455,
       504,    381,    342,   -877,   -506,   -812,   -805,   3031,
      -249,   -518,    -69,    564,    243,    261,   -332,   -434,
      -173,    -37,     61,     45,     -5,      6,  -1433,  -1009,
      1428,   -951,   -582,    154,    143,    625,    383,    387,
     -1392,  -1222,   -578,    229,   1294,    218,   -142,    355,
      -149,    201,  -1341,  -1135,   -857,   -767,   -273,   2059,
       255,    578,    350,    315,  -1041,   -617,    254,   -504,
      -255,    -96,   -537,   -396,    363,   1074,  -1361,    484,
       538,   -789,   -704,   -447,    200,    521,    213,     90,
};

static const int16_t fcb8sm[] = {
     -1183,  -1170,   -867,   -948,   -746,    492,   1531,   1412,
       524,     82,    590,   -994,   -916,   -859,   -680,     12,
       742,    961,    230,    255,     34,     38,   -176,     -1,
      1880,   -240,   -769,   -531,    269,    -32,   -772,   -494,
       757,   -583,   -677,   -281,    717,    440,    561,     91,
     -1121,  -1054,  -1189,  -1100,   -745,   -417,    -61,    302,
      3079,   1817,  -1384,  -1479,  -1477,  -1509,  -1077,   -323,
       902,   2348,   1464,   1038,   -487,   -179,   -447,   -311,
      -296,   -439,   -172,   2166,    245,    -28,  -1050,   -390,
      -238,    633,    302,   -335,    843,    -52,    185,    230,
      -110,   -433,   -690,    148,     63,   -289,   -404,   -469,
      1948,    245,   2016,   1337,   -341,   -554,   -617,   -457,
      -436,   -459,   -400,   -520,   -661,     -7,   1078,    971,
      -326,   -332,    -23,   -749,     83,   -104,   2106,   -947,
      -867,   -883,   -705,   -433,    -35,    164,    427,    646,
      -924,   2196,   -656,   -798,   -282,    217,   -227,    134,
       446,    -15,   -584,     33,    185,   -571,   -159,   1852,
      -405,    -94,    -61,    -83,   -329,   -516,   -394,   -450,
      -173,   -140,    -54,   -156,    226,   1850,   -752,  -1304,
     -1378,  -1275,  -1017,   -680,   -337,    356,   1131,   4143,
     -1120,  -1253,  -1269,   -860,     90,    973,    152,    886,
       609,   1454,    -29,     36,   -117,   -815,   -651,   -346,
      2085,   -414,     24,    -93,   -235,  -1103,  -1132,   -758,
       -98,   1497,   1285,   -289,    -34,    402,   -646,    637,
      2147,   -677,   -350,   -266,   -232,    -61,   -199,   -359,
       167,   1546,    816,   -453,    -35,   -251,   -468,   -491,
      -371,   -593,   -878,   1445,   -795,    651,    108,   -155,
      -201,    -14,    250,   -271,   -732,    793,    154,   -288,
       -86,     16,    557,    642,   -592,   -587,    -87,   -365,
      -309,   1753,    -40,     95,   -529,    -87,   -214,   -234,
      4999,   -466,   -755,   -800,   -785,   -722,   -532,   -703,
      -526,   -465,    591,   3937,   -229,   -804,   -808,   -698,
      -576,   -613,   -506,   -725,     10,     13,   -117,    -55,
       101,     52,    125,    -76,    -25,    -28,   1469,   -245,
         8,    -25,     65,    -53,   -262,   -282,   -411,   -588,
      -667,   1374,    304,   -787,   -661,   -675,     55,    320,
       720,     -4,    366,   -103,   -136,   -332,   -314,   -293,
       -38,    127,    151,    380,  -1330,  -1338,   -618,    -40,
      1284,   1500,    466,   -515,    105,   -161,     19,    697,
      -417,   -559,   -317,   -712,   -756,   -567,    754,   1481,
};

static const int16_t fcb11l[] = {
     -1291,  -1237,  -1175,  -1186,  -1139,    524,   1225,   1464,
     -1042,   -721,   -901,     41,   -728,    822,   -657,   1078,
      -483,   1530,   -489,   1253,    926,   -326,    404,     89,
     -1191,  -1170,  -1237,   1633,   1493,   -465,    986,   1184,
      -857,   -832,   -300,   -811,   -936,   -667,   -254,    492,
      4044,  -1136,   -983,   -855,   -592,   -199,    383,    876,
      2076,  -1042,  -1019,   -729,   1435,    -25,     64,    845,
      -991,   -921,   -861,    916,   -402,   -551,    236,    429,
      5253,  -1233,  -1268,   -414,   1793,   -463,   -569,   1693,
     -1197,   6322,   -887,   -211,   -945,   -540,    626,    903,
      -993,   1500,   -490,   1445,   -764,   -136,    321,    548,
       462,   -228,    127,   -322,    481,   -183,     88,    155,
      -809,   -844,   -959,   4011,   -581,   -232,    330,    986,
      -900,   -916,  -1069,   -866,   -979,   -439,   4016,   1558,
     -1023,   2121,   1717,   -612,   -588,   -446,    223,    430,
      2567,   -972,   2118,  -1030,   -900,   -664,    180,    858,
      3232,   -991,  -1132,   2119,   -446,   -548,   -258,    895,
      -962,   -184,   2639,   1081,   -661,   -222,    292,    530,
      -952,   1767,   -213,   -701,   1079,     37,    131,    489,
      -875,   -749,   3167,   -776,   1247,   -109,    -83,    636,
     -1146,  -1070,  -1001,  -1064,   -942,   2891,   1137,   1585,
     -1314,   -632,  -1179,  -1105,   1101,     51,   2038,   2036,
      -926,   -727,    180,   1515,   -566,   1191,    101,    595,
      2247,   -364,   -315,   -105,   -130,    -79,    121,    210,
      7994,  -1302,   -898,   -785,   -758,   -777,     31,    415,
       744,   -652,    688,   1226,   -649,   -605,   -268,    314,
       611,    662,   -240,   -411,   -698,   -434,    377,    339,
       953,   -810,   -931,   1054,   -484,   -298,    721,    522,
       922,  -1046,   -952,   -871,   -618,   -270,    419,    635,
      1006,    129,   -838,   -724,    220,    481,    253,    329,
       205,   -456,   -724,    675,    598,    332,    -14,    291,
     -1016,   -695,    542,   1270,    498,   -456,   -113,    362,
      -547,  -1068,  -1178,  -1261,  -1161,   -905,    390,   2204,
     -1056,  -1102,   5611,  -1100,  -1076,   -902,    360,    978,
      -538,   -286,   1253,   -430,   -457,   -148,     -1,    -60,
     -1116,   -955,   2869,   -926,   -680,   1111,    706,    842,
     -1311,  -1275,  -1150,   -236,    675,    897,    758,    912,
      1886,  -1115,   -999,    -84,   -588,   2190,   -171,    739,
      -737,    150,   -902,   -854,   -917,    334,    557,    534,
      -851,    -39,    -25,    214,   -136,    -73,    263,    234,
     -1021,   1332,   -543,   -655,   -712,   -651,     80,    479,
      1555,   1933,   -707,   -485,   -206,    139,    312,    405,
      2472,  -1172,   -945,   -939,   -713,    568,   1421,    684,
        70,  -1263,  -1235,    586,   -195,  -1065,   -449,   3182,
     -1143,    529,   -926,   -558,    419,    390,    375,    563,
     -1090,   3370,   -688,   -528,   -346,    136,    317,    615,
      -803,   -977,  -1082,   -806,   3607,   -443,   -156,   1130,
     -1288,   1585,  -1218,  -1226,   -979,    359,   1555,   1402,
      -341,   -416,   -480,   -360,   -415,    542,   -148,   -322,
     -1095,  -1074,    762,   -864,   -634,   1770,    340,    466,
     -1040,   -834,   1508,   -707,    143,     74,   1418,    905,
     -1094,   -710,   -549,   -860,    373,   1492,   2024,    741,
      -938,   -910,   2661,  -1087,  -1105,   -901,    383,    906,
       755,   -819,    581,   -612,   -420,    305,    344,    363,
      -356,   -991,   -845,  -1051,   2112,   1738,    554,    954,
     -1028,   -943,   -892,   -896,   -236,   -674,   1076,    679,
      -611,  -1099,   -859,   -914,   -444,    910,    491,    709,
     -1063,    775,    496,   -669,   -304,    672,    261,    496,
     -1086,   -963,   1037,   -639,   -134,   -577,     33,    607,
     -1070,   -649,    730,   -748,   1884,    -18,    346,    627,
     -1089,  -1118,   -955,    751,   -690,    606,   1204,   1037,
     -1016,  -1095,    473,   -919,  -1036,   -685,   1744,   1216,
      -834,   -916,   -920,   -634,   1086,   -474,    161,    620,
      -997,   -899,    -25,   -499,    399,    405,    163,    401,
};

static const int16_t fcb11s[] = {
     -1148,  -1134,  -1000,   -585,    715,    774,    626,    650,
      2109,   -898,   -729,   -239,   -213,    847,     77,    371,
      -902,   -790,   1853,   -871,   -816,    163,    295,    377,
      1718,  -1070,   -840,   -791,   1612,   -129,    144,    450,
      -830,   1909,   -539,    803,   -411,   -188,    122,    148,
      1202,    705,   -696,   -578,   -213,    -25,    126,    142,
      3309,  -1083,   -865,   -771,   -470,   -237,    980,    521,
       428,   -995,  -1003,   3088,  -1000,   -455,    320,    503,
      -615,   1746,   -751,   -734,   1092,     31,     97,    225,
     -1175,   2287,   1278,   -421,   -315,     91,    130,    120,
     -1203,   4211,   -970,   -878,   -228,     71,    327,    288,
     -1012,   -850,   1471,   -732,   1228,    201,    146,    271,
      -868,   -528,   1196,    744,   -186,     85,     38,    153,
     -1081,   -895,   -742,   1014,   1110,     66,    237,    335,
     -1012,  -1137,   4357,  -1062,   -569,    377,    268,    445,
      1203,   -717,   1070,   -541,    -72,    -29,     91,    104,
      6448,  -1148,  -1069,   -810,   -659,    118,   -284,    300,
     -1085,   -940,   -214,   -621,   -781,   -622,   1789,    711,
     -1165,   1643,   -890,   -809,   -533,    148,    384,    373,
      -910,   -986,   -855,  -1032,   3647,   -478,   -132,    713,
        -3,   -674,  -1036,   -956,   -899,   2698,    629,    665,
      -764,  -1066,  -1173,  -1058,   -692,   -144,   1114,   3195,
     -1012,   -643,   -670,   1547,   -576,    351,    251,    273,
      -950,    563,   -742,    248,   -149,    514,    100,    185,
      -193,   -616,   -655,    255,   -364,   -323,    172,    256,
       308,    228,     16,   -187,   -243,    219,     88,     53,
     -1024,    664,    450,   -416,   -189,   -239,     43,    102,
       -64,   -499,   -159,   -400,    905,    -64,    -68,     46,
     -1055,    -77,   -813,   -661,     59,    -77,    226,    321,
      1224,   -553,   -436,    793,   -155,    -83,     -5,     72,
      -652,   -897,   -157,   -579,   -539,    846,    181,    318,
       782,   -967,   -802,   -569,     -6,    364,    540,    513,
};

static const int16_t fcb11m[] = {
      -453,  -1087,  -1133,  -1125,   -852,   -158,   1152,   3313,
      1015,   -444,   1085,   -465,   -317,   -298,   -471,   -238,
      -647,   1426,   -241,    149,   -300,   -169,    -19,   -228,
      3282,   -269,  -1025,  -1069,  -1097,  -1071,   -539,   1303,
      1111,   -933,   -741,   -801,   -553,     98,    393,   1031,
      -786,   -729,   -835,   -810,    -78,   1569,    631,    944,
      1031,    651,   -409,   -397,   -346,   -221,    -99,   -216,
       -88,   -211,   -419,    193,   1298,    196,   -221,   -879,
     -1036,  -1303,  -1282,  -1052,   -575,    283,   3110,   1337,
       489,   -463,   -640,    112,    341,   -322,    261,    266,
      1646,   -817,  -1256,  -1273,  -1217,  -1031,   -142,   3691,
      3012,   1564,   -289,   -830,   -970,  -1032,  -1075,   -989,
       556,     52,   -588,   -589,   -613,   -748,   -352,   2054,
       -69,   -785,   -718,   -499,   -141,    192,   1396,    446,
        -3,   -514,   -612,      3,    171,   1067,   -114,   -109,
      -812,   -893,   -776,   -342,   1428,    421,    438,    552,
      -933,  -1143,   -207,   1312,    791,    166,   -198,    -79,
      -632,   1122,   -537,   -620,    450,     97,    -85,    174,
      1760,    123,   -168,    485,    -77,   -567,   -776,   -952,
      -758,  -1176,  -1322,  -1355,  -1207,   -928,   -177,   6229,
      -413,    261,   -327,   -848,   -725,   -395,    849,   1533,
      -201,   -124,   2976,   -335,   -703,   -674,   -727,   -949,
      -521,    209,   1004,    838,     56,   -477,   -751,   -603,
      -922,   -615,   1832,   -448,   -329,   -148,     73,    467,
      4991,    -86,   -809,   -928,   -951,   -956,   -819,   -751,
      1841,   -790,   -712,   -116,   -113,    -91,      0,   -388,
      -729,   -196,    758,   -377,     68,     85,    428,    -35,
        -5,      2,     -9,     18,    -31,     53,    -23,     26,
      -896,   -445,   -188,    818,   -347,    -44,    502,    578,
       101,   2968,    269,   -724,   -702,   -747,   -719,   -673,
      7587,     68,  -1171,  -1377,  -1441,  -1455,  -1473,  -1178,
       699,    585,     15,   2257,   -503,   -940,  -1085,  -1288,
};

static const int16_t fcb11sl[] = {
     -1502,  -1463,  -1336,  -1177,   -367,     89,    475,    867,
       550,    820,   -805,   -580,   -803,    -89,   -817,   1691,
      -304,    120,     36,    564,    409,   -525,   -820,    362,
      -969,   -870,   -605,   1983,    993,    722,   1505,   1101,
      -842,   -848,   -918,   -379,    -71,    257,    499,    607,
      1619,   -956,  -1024,   -869,   -744,    -74,    795,    684,
       532,    634,  -1360,   -818,     49,   -981,    111,   -473,
      -718,   -477,    377,    710,  -1399,  -1105,  -1152,  -1024,
      2426,   -356,   -191,   1079,    911,   1164,   -809,   -791,
      -919,   2731,   -851,   -400,   -113,    242,    508,    847,
     -1229,   1199,   -910,   1127,   -686,   -383,     26,    352,
       536,    646,   -790,  -1243,  -1103,  -1170,  -1132,  -1065,
      -788,   -521,    161,   3842,  -1098,   -883,  -1052,      8,
     -1103,   -747,   -552,   -480,   -241,    820,   3392,   -770,
      -770,   -724,   -588,   -426,   -153,    426,    639,    724,
      1626,   -713,   1157,   -736,   -492,   -512,   -160,    461,
       569,    583,  -1351,   1332,  -1222,  -1358,    240,   1541,
      -724,    612,   1583,   1194,  -1061,   -990,   -671,   -969,
      -952,   2368,   -442,   -413,   1933,   1023,   -144,   -283,
      -992,   -940,    983,   -232,    818,    341,    502,    549,
     -1420,  -1268,  -1279,  -1213,   -621,   2019,    685,   1948,
      1264,   1200,  -1293,   -664,    392,   -848,    866,   1191,
      -220,     95,    450,    640,  -1334,   1098,   -751,   -701,
      1296,   -347,    -92,    233,    532,    599,   -952,   -694,
      3085,   -908,   -256,   -494,   -177,    123,    809,    941,
        18,  -1089,   -801,    303,   -761,     11,    632,    288,
       476,    518,   -241,  -1138,  -1068,   -869,    292,    121,
       -26,    -96,    457,    548,   -106,   -784,    930,   -700,
      1842,   -812,   -617,   -307,    430,    655,   -698,   1157,
       947,   -803,   -662,   -743,    -49,   1120,    348,    578,
       855,  -1049,   -753,    -67,    710,   -347,    -28,    694,
       411,    468,    -61,    239,     23,  -1072,   -757,    477,
      -658,   -362,    239,    576,  -1479,  -1279,  -1286,   -677,
      -939,   -722,   3217,    338,   1562,   1566,    925,    917,
      -697,   -708,    645,   -447,   -280,    714,    503,    552,
     -1050,  -1021,    889,   -956,   -934,    705,    457,    616,
       556,    667,  -1331,    -51,   -256,    -48,   -234,    240,
       757,    -74,    148,    356,  -1278,   1538,    234,   -372,
      -472,   -221,   -424,   -494,    170,    551,    216,    294,
      -885,    231,   -263,    334,    -64,    -54,    291,    350,
     -1140,  -1074,  -1199,  -1374,  -1278,   -845,   -547,    667,
      4544,   1922,   -899,   -930,   -954,  -1120,  -1092,   1156,
      1889,   -404,    259,   1114,   -956,   -836,    881,   -316,
      -977,   -860,    202,   -249,    121,    816,  -1188,   3644,
      -829,   -876,   -670,   -473,   -161,    420,    851,    886,
     -1014,   1191,   -938,   -958,   -864,    741,    241,    957,
       288,    629,  -1155,   -898,   1104,   -789,     28,   -867,
      -580,   2588,    836,   1234,   -953,   -749,    934,   1137,
      -310,   -177,   -113,    244,    532,    424,   -341,   -602,
      -880,  -1105,   -303,   -381,   -527,   1943,    126,    759,
     -1277,  -1037,     59,   -783,    485,   -589,   1341,    737,
       488,    709,  -1473,  -1208,  -1082,    589,    791,    735,
       447,    322,    835,    731,  -1116,   -681,   -592,    704,
       520,   -545,   -104,    -24,    263,    458,    632,   -721,
     -1086,  -1223,  -1150,   -866,   1537,   2815,    123,   1097,
     -1238,   -861,  -1217,  -1238,  -1261,   -914,   1165,    422,
       711,    883,  -1196,   -972,   -428,   -230,    171,      8,
      -448,   1195,    445,    440,   -413,   -139,   -375,   -568,
      -781,   -520,    611,   -586,    881,    589,   -724,    972,
      -907,   -794,   -819,   -641,   1650,     66,    254,    703,
     -1380,  -1168,   -967,    676,   -765,   -537,    578,   1542,
       687,    833,   1151,   -811,   -948,   -995,   -246,   1301,
      -377,    262,    632,    652,   1530,   -679,   -682,    993,
      -666,   -457,    -72,    -20,    317,    516,    861,   -528,
        24,   -579,   -386,     53,    526,    -76,     66,    345,
       -59,   -612,    165,   -181,    -98,    -34,    -66,    286,
        95,    108,  -1118,   -147,    643,  -1055,   -768,   -502,
      -587,     27,   2113,    811,  -1219,   -947,   -811,  -1188,
      1143,   -609,   -753,     88,   2844,   1424,  -1428,  -1082,
     -1273,   1086,  -1206,  -1171,    279,   -510,   2325,   1757,
     -1437,    654,  -1278,  -1267,  -1117,   -950,    779,   2205,
      1150,   1101,  -1484,  -1009,  -1199,  -1416,  -1215,    657,
      -737,    634,   1266,   1742,  -1445,  -1193,  -1358,  -1158,
     -1015,   -995,   -655,   4035,   1966,   1903,  -1069,    954,
     -1099,  -1171,  -1029,   -818,   -576,   -104,   1390,   1069,
       559,   -914,  -1034,  -1152,   -987,   -582,   -222,    394,
      1204,    775,  -1464,    -51,   -959,  -1005,   -452,    347,
       -94,      1,    525,    595,  -1324,  -1226,  -1102,   -825,
      -927,   -776,   -582,    175,   1675,    632,   -859,     28,
      -914,   -209,   -468,   -625,   -230,    646,    579,    446,
};

static const int16_t fcb11ss[] = {
     -1351,  -1229,  -1174,   -767,   1403,    182,    532,    445,
       415,    610,  -1095,   -771,  -1142,   3221,   -803,   -680,
      -302,    318,    441,    438,  -1188,   1145,   1552,   -528,
       887,   -547,   -429,    124,     99,    128,   -768,   1049,
      -562,   1121,   -593,    -96,   -105,    105,    251,    154,
      1684,   1598,   -635,   -685,   -177,   -211,   -268,    234,
      -118,    -49,   -719,   -873,  -1092,   -985,   -678,   -406,
      -234,    407,    653,   3195,    991,   -584,   -874,    -14,
      -683,   2964,   -769,   -450,    287,    350,    853,   -803,
      -574,   1761,   -410,    -60,   -230,    -78,    -21,     19,
     -1271,   4435,   -673,   -790,    110,   -243,    -81,    147,
       191,    145,   5571,   -611,   -634,   -699,   -195,   -281,
      -249,   -302,   -272,    -67,   -893,   -656,   -745,   -697,
      -550,   -639,   -409,   3085,    383,    798,   -311,   -340,
      -564,   -787,   3628,   -332,   -510,   -219,    465,    351,
      -747,  -1084,   -972,   -727,   -404,   -630,   -176,    437,
      3352,    978,   -886,   -751,   -767,   -580,   -693,   -942,
      -803,   -158,    -36,     -3,   -966,   -674,   3075,   -926,
      -172,     -9,    -40,    111,    169,    212,    181,   -811,
      -715,   -986,   -521,   -686,   3915,     18,    -58,    499,
       210,  -1187,   -903,   -915,   -522,   1038,    477,    788,
       290,    412,  -1010,   -791,   -700,   -710,     34,   1774,
      -256,     96,    131,    241,  -1251,   2086,     -5,   -765,
      -446,    141,     93,    160,     88,    129,  -1153,   1171,
     -1192,  -1073,   -391,   -187,    206,    416,    444,    648,
       707,   -542,   -504,   -750,   -623,   -648,    776,    692,
       165,    330,   1112,  -1199,   -876,   -428,    949,     65,
       250,    104,    108,    173,   2147,   -905,   -846,   -540,
      -376,   -131,   -113,    124,    314,    485,   1253,   -515,
      1435,   -527,     21,   -100,   -368,    -84,   -119,   -144,
     -1375,  -1189,  -1189,   -999,   -723,   -190,    796,    639,
       699,    816,  -1188,   -919,    683,    842,    177,    -62,
       -25,     71,     15,     16,    157,     80,   -331,   -343,
        12,    193,   -133,    -94,    -94,    -64,  -1306,    531,
      -917,   -142,   1274,    102,    -15,    184,    159,    148,
       -43,  -1103,   -581,   -419,    447,   -132,   -204,    187,
       631,    461,  -1302,  -1162,   -927,    896,    203,    164,
       -55,    287,    544,    485,  -1258,   -791,    677,   -945,
      -244,   -101,    423,    362,    298,    389,   -825,   -640,
      -646,    274,    -73,   -274,   1473,    -13,    132,    169,
};

static const int16_t fcb11sm[] = {
      -767,  -1179,  -1188,  -1069,   -690,   -172,    787,   1389,
      1623,    844,   -169,   -894,   -919,     51,     15,    426,
      -326,   1579,    182,     77,    202,   -417,   -357,    -17,
      2154,    -77,   -607,   -589,   -375,   -261,   -376,    175,
      -829,   -801,   -579,   -290,   -244,    533,   1307,    873,
      -877,  -1175,  -1157,   -726,    461,   1729,    433,    219,
       246,    606,   -791,   -827,    649,    891,    820,    720,
       407,   -641,   -727,   -708,   2498,    961,    -99,   -542,
      -530,   -507,   -536,   -608,   -642,   -622,    316,    195,
      -721,   -549,   -253,   1520,    171,    -81,   -372,   -333,
      1166,  -1072,  -1230,  -1123,  -1031,   -868,   -370,    209,
      1561,   1751,    113,   -367,    399,   -663,    -10,   -271,
       950,    118,   -335,   -272,   -863,     60,   -875,   1850,
      -242,   -276,    -38,   -106,    471,     30,    823,   -344,
      -752,   -714,   -309,   -419,     86,   1604,   -250,   -185,
      -839,   -703,   -561,   -281,   1813,    -57,    255,    266,
       -32,     99,    400,   2520,    315,   -372,   -306,   -511,
      -549,   -659,   -760,   -729,   -559,   -137,   -610,    174,
       924,   -310,   -705,   -307,    885,    512,   -611,  -1097,
     -1172,  -1072,   -758,   -527,   -192,    278,    740,   3398,
     -1136,    409,   -230,   -353,   -137,    322,    326,    365,
       133,    173,   2291,   -644,   -725,   -596,   -535,   -340,
       -88,    -65,    -53,    273,   -760,   -390,   -649,    119,
      -243,   -222,   1726,   -113,     44,    326,   -618,    311,
      2345,   -241,   -398,   -399,   -382,   -322,   -444,   -457,
      1873,   -454,   -505,     42,    481,    187,    -49,   -505,
      -634,   -754,   1052,   -597,   1315,    297,   -412,   -110,
      -205,   -552,   -682,   -524,  -1055,   -431,    971,   -363,
      -539,   -366,     39,    995,    181,    476,    662,    229,
      -445,   1682,   -205,   -181,   -273,   -497,   -685,   -628,
      6135,    -21,   -834,   -934,  -1002,  -1066,   -931,   -974,
      -902,   -643,   -820,   1891,   -706,   -288,   -252,   -231,
       -79,    126,     35,     37,     10,    -10,    -36,     -6,
        -9,    -47,     -7,      1,     11,     -2,    644,    315,
       145,   -353,   -396,   -428,   -357,    -60,    275,    109,
     -1179,   -952,   -698,    138,    286,    171,    394,    263,
       814,    495,   -490,    110,    369,    599,      9,    599,
      -431,   -233,   -328,    -69,    410,  -1002,   -462,     77,
        97,    196,    133,    -91,    512,     49,    621,   -436,
      -352,   -390,   -211,   -188,   -454,   -318,     44,   1424,
};

static const int16_t fcb16l[] = {
       -13,   -798,   -772,    235,    515,   -181,   -120,   -509,
      -392,  -1159,   -844,  -1041,   -881,  -1193,   1103,  -1080,
       214,   1615,   1819,   1510,   -914,  -1190,   -273,  -1099,
      -522,   -996,   -206,   3946,    996,   1678,  -1220,  -1201,
      2850,  -1022,   1101,   -814,   -188,    879,   1549,   1279,
     -1129,   1928,   1550,     38,   -356,   -574,   -157,    286,
       481,    475,  -1079,  -1176,   -861,   -548,   -657,   -381,
       538,    948,   -838,    779,  -1149,   -962,   1788,   -779,
      -742,   -311,    205,    299,    472,    715,    702,   -843,
      -931,   -790,   -624,   -332,    324,    778,    785,    670,
     -1137,  -1205,   -103,  -1182,  -1071,   -950,    101,    527,
      1596,   1004,    682,   -564,  -1053,   -844,  -1184,   1732,
      -862,   1994,   -988,   1131,  -1069,  -1276,  -1053,   6414,
     -1259,   -186,   -930,    118,    375,   1092,   6215,   -900,
      -920,   -935,   -981,   -970,   -766,   -902,   -334,   1629,
     -1094,  -1142,  -1155,   -779,  -1092,   1011,   -490,   1063,
      1569,   1340,   2242,  -1313,   6027,  -1319,  -1337,   -789,
     -1296,   -457,    819,   2276,  -1071,  -1065,   -715,    802,
      -996,    397,   2396,    -27,   1225,    935,   1400,   -862,
      -802,   1846,   -513,   -249,   -704,    515,    872,    662,
     -1141,   5876,   -691,   -404,   -603,   -148,    -57,    187,
       649,    788,  -1116,   -915,   -551,   3843,   -737,   -133,
       498,    155,    227,    718,   1798,   1397,   -868,   -716,
      -586,   -580,    -71,    -67,    311,    536,   2465,   -524,
      1837,   -231,   -210,    263,    231,    -10,   -164,   -324,
      -951,  -1130,   5206,   -525,   -603,   -401,    223,    438,
      1011,   1077,   -726,  -1102,  -1013,   -386,   -786,   4281,
      -329,    262,    550,   1292,   -629,   -943,   -976,    773,
      -867,    908,   -680,   -154,    362,   1056,  -1051,   -703,
     -1333,  -1424,  -1026,   -793,   -859,   -882,   -148,   9958,
     -1193,  -1156,  -1077,   1241,  -1013,   -726,   -139,    551,
      1150,   1019,   -733,   -997,   -651,   -625,    -54,    722,
        73,    -14,    361,    435,   4013,  -1260,  -1195,   1452,
     -1105,   1273,   -670,   1546,   1038,   1680,   -812,  -1060,
      -853,  -1058,   2094,   -801,   -457,   -320,    683,    960,
     -1019,  -1158,  -1118,  -1034,   -617,    404,   1376,    847,
      1014,    951,    -12,  -1004,  -1221,  -1131,    649,  -1052,
       442,   -167,   -859,   3868,  -1216,  -1298,  -1311,   2866,
     -1310,   -639,  -1079,   1576,   1760,   1837,    118,  -1080,
      -862,   -845,  -1065,  -1069,   2199,   -766,    495,   1309,
      -996,  -1040,   -741,   1357,   1726,    382,    264,     92,
       659,    665,   -781,  -1356,   2055,  -1198,     15,   2143,
       631,    569,    918,   1120,   -948,  -1253,  -1234,   2442,
     -1062,   2206,     48,    660,   1822,   1480,   -639,    627,
      -432,   -477,    845,    216,    228,    152,    157,    295,
      2444,   -908,   -465,   -768,    109,    251,     72,    -59,
       169,    405,   4395,   -837,   -931,   -839,   -215,   -564,
       655,    359,    503,    296,   3514,  -1082,  -1185,   -827,
      2879,  -1224,   -811,   -970,    804,    911,   3028,  -1284,
      -688,  -1226,  -1251,   -551,  -1247,   -275,   3441,   2322,
      -630,  -1213,   -108,  -1191,   1129,   -854,   2848,   1609,
      1048,   1535,   2784,  -1245,    772,  -1230,  -1298,   -686,
     -1293,   -639,    278,   2455,   9975,  -1077,  -1233,  -1055,
      -139,   -853,    -48,     24,   -720,    533,  -1191,   2809,
     -1015,   -899,    -28,   -765,   -147,    146,    592,    814,
     12493,  -1274,  -1072,  -1297,    877,  -1068,  -1179,  -1032,
      1023,  -1178,   -840,    930,   -660,   1216,   -366,   -406,
       -97,     77,    179,    340,   -973,   -993,   2280,   1775,
      -631,    -17,   -186,    507,    459,    645,   2095,  -1019,
     -1067,   -949,   -857,  -1202,   -904,    -48,   1156,   1273,
     -1230,  -1245,  -1203,  -1036,  -1150,   -955,   1193,   1943,
      1437,   1329,   -618,  -1055,   -730,  -1014,   4953,  -1125,
      1089,   1085,   1047,   1045,    813,  -1036,   1270,   -715,
      -684,    -96,   -131,    289,    782,    628,   -979,   1060,
      -975,   -964,   -811,    -14,    223,    422,    563,    696,
      -901,   -633,    496,   -136,     22,    -83,    -52,    264,
        24,    147,   -446,  -1197,  -1258,   -687,  -1239,   -795,
     -1066,  -1196,    147,   2653,  -1231,  -1275,  -1240,  -1041,
     -1260,  -1159,   1961,    -34,   2937,   2128,  -1318,  -1355,
     -1326,  -1300,  -1345,  -1326,   -870,   -298,   2014,   3890,
      -933,  -1014,   -859,  -1074,   -506,  -1163,   -954,   -819,
       440,    732,   -582,  -1268,  -1206,  -1037,  -1081,  -1255,
     -1150,   -835,   2360,   1469,  -1232,  -1384,  -1388,    542,
     -1359,   -606,  -1335,   1852,   2142,   3722,  -1218,  -1321,
     -1268,  -1207,  -1203,  -1316,   -954,   -696,   4730,   2920,
     -1225,  -1306,  -1131,  -1273,  -1276,  -1238,  -1040,   2079,
      2652,   1931,  -1167,  -1302,    659,   -532,   -650,   -560,
     -1028,    186,   1224,   2811,   -896,   -449,   -999,   -823,
       -81,   -876,    502,   -293,    680,    733,   -836,  -1111,
     -1132,   -865,  -1141,   -938,   -980,   1287,    581,   1438,
};

static const int16_t fcb16s[] = {
      1260,  -1427,  -1400,   -996,   -958,  -1195,   6261,     31,
       967,    752,   3776,   -975,   -840,   -707,   -696,   -555,
        45,   1159,      4,    358,   4718,  -1471,  -1464,  -1291,
     -1364,   -934,   -878,   5198,   -273,   1555,  -1438,  -1729,
     -1579,  -1470,  -1820,  -1436,  -1255,   -631,   4287,   4025,
      1233,   -684,   -748,   -742,   -547,   -229,    321,    126,
       794,    670,   6689,  -1041,  -1160,   -861,  -1002,   -976,
       147,   -668,    521,    940,  -1186,   2097,   -570,   1759,
      -251,   -442,    -92,     46,     99,     12,  -1336,  -1061,
      4427,   -945,   -861,   -460,   -306,    494,    481,    536,
     -1101,  -1105,   2695,    316,   -801,   -159,   1042,   -577,
       -78,    340,   2347,   1448,    135,   -381,   -688,   -493,
      -254,   -234,    -74,    -80,  -1047,  -1246,   -729,   -985,
      5399,  -1018,    643,    822,    889,    432,   -328,  -1386,
     -1420,   -702,  -1450,   6927,  -1107,    465,   1625,   1116,
     -1258,   2847,   -893,   -895,   -521,   -263,    112,    157,
       556,    500,    182,   -652,   -226,    258,   -638,   -566,
      -419,   -669,   -224,   -221,  -1197,   -227,   -582,     92,
      1914,   -184,    -11,    -18,    270,    166,  -1294,    -62,
      1536,   2470,   -413,   -619,   -399,     24,    106,     54,
     -1223,   2672,   2400,    -54,   -577,   -692,   -301,     -3,
       206,     89,  -1424,  -1491,   8425,  -1072,   -242,   -420,
      -194,     -1,    489,    331,   -938,  -1319,   2493,  -1355,
       551,   2297,    197,     -9,    717,    434,  -1237,   -773,
     -1021,   3945,   -566,    116,    246,    150,    510,    370,
     11804,   -457,  -1006,  -1231,  -1175,  -1086,  -1221,    589,
      -679,   -757,  -1183,   6502,   -584,   -454,   -629,   -570,
      -413,   -352,   -279,    -32,  -1236,   -946,   -760,   1535,
      -865,   -712,   -224,    343,    647,    613,  -1348,   -938,
      -961,   8273,  -1130,   -591,   -225,    210,    420,    140,
     -1247,  -1166,   -966,   -986,  -1120,   -907,   -181,    470,
      1888,   1161,  -1076,  -1298,   3479,  -1151,   2410,   -396,
         1,    -44,    357,    594,   -896,    745,    -33,   -422,
      -332,   -259,      0,     48,    143,    190,  -1009,   -837,
      -876,   -371,   -370,   1520,   -150,    251,    240,    448,
     -1024,  -1008,   -568,   -450,   -611,   -536,   1763,    -34,
       355,    454,   -769,   -599,   -639,   -737,   -912,   -725,
      -504,   -230,    532,   3294,  -1077,   -289,   -875,   -542,
      -574,   -604,   -339,   2511,    479,    742,  -1218,   -946,
      1321,   -522,   -544,   -950,   -765,    632,    639,    497,
};

static const int16_t fcb16m[] = {
      -940,  -1197,  -1190,  -1200,  -1192,   -960,   -718,    610,
      3300,   3253,  -1515,  -1689,  -1798,  -1798,  -1793,  -1764,
     -1616,     33,   2377,   7778,   -668,   1745,   1501,    785,
      -336,   -823,   -708,   -446,   -455,   -812,   8862,    159,
     -1141,  -1261,  -1323,  -1299,  -1261,  -1227,  -1214,  -1090,
      3584,   2092,    688,   -531,   -848,  -1000,  -1047,  -1192,
     -1104,   -887,   5163,   -347,  -1129,  -1285,  -1336,  -1291,
     -1249,  -1109,   -498,   2511,   -611,   -703,   -516,   -240,
       -68,    399,   1570,    252,     -5,     43,  -1163,  -1168,
     -1008,   -921,   -995,   -569,    925,   1511,   1001,   2023,
     12926,    135,  -1598,  -1778,  -1847,  -1850,  -1836,  -1734,
     -1695,  -1690,    621,   4647,    588,   -752,   -973,   -996,
      -953,  -1081,  -1060,   -672,   -868,    259,   4940,   -117,
      -718,   -907,   -828,   -776,   -606,   -981,  -1002,   -526,
      -385,    527,   1501,   -239,     38,     25,    112,    -77,
      1122,   -250,   -352,  -1113,  -1101,   -942,   -681,   5156,
      -800,   -636,   5814,   -160,   -777,   -825,   -844,   -747,
      -697,   -645,   -668,   -492,   -936,    491,   -280,   2573,
      -269,   -736,   -375,   -265,    -98,   -243,   -920,   -236,
       446,   1095,   -666,   -600,   -246,    783,    282,      0,
     -1064,   -116,   2271,   -118,   -482,   -240,   -187,   -271,
        36,     91,   -695,   -254,   -383,   -948,    745,   2722,
      -129,   -799,    238,   -379,   2872,   -516,   -868,   -623,
      -551,   -275,     22,    379,   -185,   -230,   1524,   -672,
     -1062,  -1164,  -1177,  -1137,  -1058,   -790,      6,   4928,
      -551,   -389,   -460,   -394,   -674,   -586,   -327,   -178,
       615,   2868,  -1467,  -1203,  -1316,  -1120,   -996,    747,
      -219,   2023,   1875,    254,   -871,   -992,  -1062,  -1110,
     -1149,   -992,   -492,     40,    528,   5374,     83,   -559,
      -862,   -760,   -541,     28,    207,    629,    502,   1260,
      -473,  -1110,  -1336,  -1390,  -1412,  -1379,  -1329,  -1081,
      -238,   9844,  -1332,  -1306,  -1275,   -881,  -1267,  -1249,
      -237,   2882,   3535,    584,    -13,     52,    -50,     -4,
         7,      5,     20,    -55,      5,     45,   1587,    350,
       191,    617,    153,   -236,   -336,   -649,   -798,  -1063,
      1451,    707,    253,   -733,   -923,   -859,   -621,   -738,
      -555,   1623,   1727,   -411,   -724,   -772,   -746,   -675,
      -688,   -209,    915,    622,  -1038,   -474,   -343,    -91,
      -173,   -104,    255,     96,   1547,    773,   -625,   2272,
       -90,   -509,   -527,   -247,   -147,   -234,    -45,    166,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
        0, 0, 0, 0, 0, 0, 0, 0,
};

static const int16_t fcb16sl[] = {
     -1337,  -1122,  -1559,  -1452,  -1353,   -973,   3858,   1145,
      1225,   2103,   -607,   -181,    557,   -429,     15,   -496,
      -444,   -523,  -1866,  -1134,  -1270,   3029,  -1110,   -798,
      -824,   -659,     44,    614,   1059,   1173,    714,   -932,
     -1095,  -1061,   -921,  -1034,   -873,      7,   -872,    660,
     -1335,  -1496,  -1623,  -1405,  -1070,   -680,    943,    134,
      -190,   2837,  -1034,   -221,   -337,   -540,   -571,   -173,
      -411,   2314,   -111,    970,  -1220,  -1036,  -1096,   -147,
      1087,    604,   -367,     83,    461,    679,  -1333,    194,
     -1292,  -1139,  -1097,   -570,   -508,   -109,     54,    962,
      2592,  -1112,   -944,   -636,   -521,     12,    230,    442,
       562,    624,  -1107,  -1190,   1554,   -981,   1507,  -1013,
      -394,    595,    823,   1094,  -1453,  -1298,    242,  -1185,
      -686,   -541,    858,    331,    695,   1197,  -1259,    968,
     -1180,  -1254,   -752,   1473,    222,    342,    973,   1029,
     -1631,  -1500,  -1619,  -1517,  -1299,   1683,   2203,   1163,
      1225,   1497,  -1189,   -937,   -931,   3193,   -977,   -708,
      -262,    549,    917,   1465,    704,   -565,   -708,    846,
      -130,   -322,   -257,    221,    367,    309,  -1416,  -1123,
     -1323,  -1260,   -405,   3303,   -210,    785,   1007,   1616,
     -1043,   -717,     44,    824,    419,   -492,   -579,   -604,
       -15,    676,  -1067,  -1079,   3897,  -1211,   -474,  -1020,
      -589,    114,    593,   1504,  -1481,  -1249,  -1036,  -1012,
      -719,    846,   -189,   -297,    -31,   1209,  -1761,  -1566,
     -1449,  -1645,  -1464,   1422,     24,   2153,   1377,   1948,
     -1480,    652,   -929,   -415,   -689,   -386,   1628,    489,
       487,    756,  -1424,   -805,   1241,    228,   -697,   -316,
       423,    660,    557,    587,   1248,   -777,   1088,   -848,
      -498,   -399,    -60,    169,    497,    689,   5679,   -778,
     -1109,  -1118,   -895,  -1042,   -504,    390,   1670,    469,
       977,   -929,  -1173,  -1058,   -999,   -696,   1912,     52,
      1297,   1081,  -1469,  -1243,  -1055,    385,   -529,    910,
        79,    508,   1225,    753,    656,  -1307,  -1239,  -1470,
     -1110,  -1255,   -362,   2351,    889,   1687,  -1566,  -1331,
     -1410,  -1385,    779,   -499,   -217,    936,   2064,   1493,
     -1499,  -1345,  -1162,    790,  -1115,   -673,   2083,   1010,
       588,   1265,  -1439,  -1168,  -1294,    752,  -1421,  -1234,
      -169,   -529,   1606,   2131,  -1556,  -1442,  -1444,    487,
     -1260,  -1139,    360,   2528,   1994,   1686,  -1548,  -1473,
      -563,  -1125,    967,   1490,   1503,    487,    991,   1024,
     -1430,  -1151,  -1215,   -729,   -746,   -762,   -472,    778,
       889,    774,  -1329,  -1129,   1383,  -1230,   -723,   1478,
       379,    161,   1266,   1238,  -1467,   -843,  -1277,  -1323,
      -715,     58,   -182,   5140,    762,   1723,  -1285,   1134,
     -1175,  -1057,   1294,     -4,   -417,    557,    939,   1182,
        39,    565,   -809,   -703,   -783,   -883,   -112,    412,
      1056,    691,   -273,  -1334,   -898,  -1345,  -1069,  -1247,
      -105,    638,   6811,   1157,    982,   -856,   -805,  -1093,
      1267,   -747,   -650,    311,    281,   1076,   1371,   1614,
      -891,   -886,   -396,   -246,    -65,     77,    472,    605,
      -943,    178,   -509,    112,   -142,    512,    -66,    109,
       144,     76,   2934,  -1203,  -1428,  -1525,  -1269,  -1618,
     -1129,   -184,   -225,   3157,   -249,  -1276,  -1055,   -439,
      -161,   -268,    284,    614,    778,    670,  -1243,   1682,
       919,   -468,   -479,   -341,     31,    468,    325,    606,
     -1081,   -723,     83,   -399,   -275,   -658,    240,    149,
      2746,    679,  -1573,  -1287,   -494,    775,    975,   -751,
       -47,   1758,    652,   1155,  -1465,  -1073,  -1087,  -1026,
       289,    340,    448,   1348,    351,    682,   2065,  -1183,
     -1313,  -1562,   -466,  -1546,  -1077,   -477,   3012,   2512,
     -1560,  -1532,  -1441,  -1229,    861,   -421,   1515,   2195,
      1163,   1418,  -1268,  -1103,   -804,  -1094,   3254,   -711,
      -558,    713,   1414,   1684,    542,   -781,   -827,   -814,
      -245,   1129,   -160,    210,    386,    618,  -1633,    488,
     -1584,  -1571,  -1349,   -662,    711,   1516,   1661,   1673,
     -1510,  -1530,   1013,  -1172,    425,  -1415,   -856,   2963,
      2258,   1919,   -744,  -1208,   -863,   -634,   -729,  -1068,
      -857,   -289,    701,   6703,  -1502,  -1353,  -1531,  -1372,
     -1388,  -1067,   1392,    100,   2570,   1703,  -1551,  -1500,
     -1587,  -1693,  -1753,  -1431,  -1048,   1162,   1308,   3073,
      -998,  -1575,   -517,  -1346,  -1293,  -1493,  -1375,  -1109,
      -803,   2972,  -1446,  -1316,  -1114,  -1405,  -1240,  -1057,
     -1109,   -589,   2623,   1626,  -1555,  -1026,  -1346,  -1467,
      -902,   1291,    176,    630,   4293,   1949,  -1233,  -1362,
      -930,  -1175,  -1118,  -1375,  -1172,   -967,   4896,   4195,
     -1744,  -1562,  -1797,  -1815,  -1577,  -1194,    371,   3326,
      3183,   3071,  -1425,  -1773,  -1562,  -1358,   -547,   -246,
        24,   -526,  -1502,  29376,   -860,   -614,   -857,   -795,
       793,   -616,   1691,   -125,    156,    559,  -1643,  -1462,
     -1523,  -1413,  -1251,   -592,   1014,   1888,    243,   1041,
};

static const int16_t fcb16ss[] = {
       308,   -532,   -811,   -974,   -641,   -431,   3409,    258,
       567,    641,   1315,   -723,   -738,   -502,    142,    678,
       -67,   -170,     73,    -65,   2717,   -804,   -958,   -878,
      -532,   -562,    238,    497,    548,    718,   -868,   -669,
      -932,  -1004,   -518,   -502,   -286,    405,   2987,   1420,
       174,   -779,   -748,   -575,   -153,    -40,    340,    413,
       275,    387,    965,     82,   -550,   -744,   -592,   -591,
      -604,   -163,    428,    843,  -1280,   1756,   -368,    777,
       -29,   -453,    -61,     43,     50,    137,    950,   -229,
      1504,   -491,   -353,   -167,   -285,   -158,    -94,   -185,
     -1431,    303,    673,   -758,   -610,   -308,   1247,    348,
        95,     31,   1631,   1963,   -624,   -770,   -466,   -150,
      -122,   -123,     34,   -141,   -883,   -374,   -948,   -629,
      3420,   -772,   -392,    -31,    603,    646,   -760,   -871,
      -936,   -948,   -727,   3563,   -376,    858,    699,    561,
     -1370,   2366,   -775,  -1241,  -1105,   -247,    177,    432,
       414,    379,  -1360,  -1057,   -945,   -848,   -568,   -779,
      -632,   -328,   -295,    425,   -349,    630,   -275,   -527,
       438,     47,   -194,    -96,   -239,   -545,  -1381,   -689,
      1644,   1165,   -437,   -153,   -193,    307,    183,     66,
     -1335,   2590,   2169,   -447,   -435,   -317,    -82,    204,
        45,   -145,  -1324,   -205,   4019,   -973,   -578,     28,
       175,    506,    235,    -98,   -908,   -294,   1443,   -850,
      -556,   1707,   -277,     58,    241,   -188,   -853,   -572,
      -577,   1258,   1007,   -190,      1,     -3,    103,    -49,
      5385,    137,   -707,   -834,   -510,   -517,   -392,   -390,
      -231,   -275,  -1249,   5229,   -812,   -893,   -353,   -663,
       -29,    187,     45,     10,  -1388,  -1171,  -1051,    412,
      -379,   -411,    240,    574,    632,    284,   -838,   -912,
      -924,   3062,   -695,   -409,   -224,    422,    293,    267,
     -1436,  -1237,  -1303,  -1305,   -914,   -243,    821,    839,
      1043,   1284,  -1178,   -496,   1594,   -736,   1752,   -601,
      -396,    330,    231,     48,  -1253,    808,   -896,   -967,
      -653,    -84,      4,    442,    363,    589,  -1005,   -672,
      -687,    -93,   -274,   1376,   -232,    -52,    399,    255,
     -1085,  -1214,  -1088,   -748,   1036,    414,    220,    509,
       436,    499,   -648,   -765,   -931,   -983,   -758,   -543,
      -379,   -115,    780,   3327,  -1086,   -893,   -773,   -881,
      -683,    -11,   -322,   3418,    739,    961,  -1363,   -929,
       899,  -1005,   -792,   -338,   -185,    702,    627,    638,
};

static const int16_t fcb16sm[] = {
     -1125,  -1385,  -1439,  -1387,  -1120,   -681,   -135,    616,
      3086,   2537,  -1440,  -1209,  -1027,  -1209,   -626,    173,
       662,    899,    861,   2180,    387,   1032,    936,    140,
      -353,   -302,   -290,   -330,   -551,  -1019,   3555,    -68,
      -441,   -539,   -500,    -27,   -423,   -506,   -522,   -415,
      2347,   1890,   -312,   -742,   -679,   -679,   -653,   -609,
      -433,   -472,   2709,   -755,  -1153,  -1066,  -1028,   -862,
      -826,   -315,     78,   1699,   -363,   -429,   -690,   -190,
      -358,   -667,   1909,     39,     -1,    138,  -1592,  -1559,
     -1357,  -1554,   -750,    813,   1676,   1537,    977,   -269,
      8320,   -602,  -1140,  -1153,  -1136,  -1174,  -1004,  -1091,
     -1388,  -1187,   -507,   3103,   -200,   -665,   -590,   -381,
      -365,    -40,   -295,   -591,   -963,    271,   2231,   -547,
       -65,   -270,    -64,    243,   -183,   -548,   -796,   -277,
        -7,   -168,   1575,   -361,     35,    -19,    192,   -154,
      -384,    144,   -426,   -528,   -598,   -778,   -297,   1847,
       564,    218,    864,   -654,   -485,   -435,     45,    709,
       630,    -11,   -691,   -111,   -775,   -356,   -522,   2247,
       -79,   -433,   -620,    594,     79,     60,   -828,   -475,
       768,    -79,   -655,    550,   -201,     77,    858,    -11,
      -803,   1173,   1027,   -971,   -656,   -648,    -40,     17,
       720,    176,  -1055,   -936,   -258,    550,   1086,   1065,
         0,   -473,   -364,     30,     53,     -6,    -54,    -24,
        21,    -81,    -88,    -45,    -14,     81,    674,  -1189,
     -1049,   -846,   -489,    -24,    -47,    165,    658,   1909,
      -241,   -390,   -387,   -454,   -319,   -549,   -307,   -112,
       778,   1486,   -314,     34,    -93,   -799,   -538,   2219,
      -445,     39,    -38,   -258,   -427,   -943,   -760,   -602,
      -575,   -450,    376,    668,    879,   1215,  -1216,   -784,
      -646,   -291,    275,   1019,    -77,    124,    256,   1166,
      -410,   -993,  -1145,  -1118,   -940,   -825,   -560,   -131,
      1006,   4878,  -1401,  -1286,  -1316,  -1394,    177,   -919,
       162,   2292,   1792,   1242,   -762,    937,   -168,   -900,
      -829,    203,   1225,    626,   -122,   -515,    992,   -198,
      -782,    -25,     74,   1019,   -606,   -364,   -350,     -5,
       451,    324,    265,  -1143,   -820,    382,   -362,     85,
      -797,    693,   1594,   -335,   -229,   -396,   -211,   -356,
       -97,   -115,     92,     49,   -476,  -1124,  -1084,   -594,
      -228,    728,     16,    589,   1213,    841,   -829,   1874,
      -907,  -1000,   1411,   -621,   -707,    356,    437,     37,
};

static const int16_t fcb22l[] = {
      2735,  -1224,  -1198,  -1073,  -1115,  -1054,   -713,   1693,
     -1106,  -1259,    722,  -1256,  -1223,   1686,   1589,   2003,
      -906,   2529,   2141,   -396,   -338,    -36,     52,    476,
       319,   -420,    561,   -492,   -526,   -359,   -221,   -254,
      -752,  -1136,   -690,   -896,   4307,   -363,    -42,   1363,
      -717,  -1036,   -874,   2315,   -952,   -872,    262,   1418,
       737,   1374,   -506,   -470,   -275,   -126,    242,    428,
      -678,   -681,   -581,   1016,   -553,   -509,   -485,   -408,
      9595,  -1015,  -1168,   -932,   -812,   -690,   -167,    753,
      -935,   -439,   2105,   -526,   -710,   -570,      9,    548,
       530,  -1308,  -1060,   -351,   -974,  -1038,     93,   5579,
      -737,  -1282,   1386,  -1284,  -1243,  -1105,    790,   2169,
      -701,   -660,   -555,   1317,   2805,    792,   2209,   -490,
      -758,  -1262,  -1083,  -1073,    930,   -810,   -170,   2326,
     -1213,  -1286,   3435,  -1135,  -1051,    220,   3040,   1999,
      -933,   -663,   -714,   -855,   -372,   -599,   -437,    373,
      5873,   -987,  -1081,  -1003,   -747,   -271,    582,   1069,
      -917,   -754,   5676,   -565,   -616,   -396,    177,    908,
      3106,   1459,   -678,   -543,   -340,     47,    336,    493,
     -1060,   1427,   -560,   -763,   -710,   -661,    193,    595,
      -996,   2488,   -588,   -752,   1306,    114,    292,    689,
     -1202,   2334,  -1173,  -1167,   -755,    353,   1711,   1572,
      -932,   -751,   2099,   2025,   -417,     62,    458,    611,
      -981,   4387,   -639,   -560,   -520,   -152,    262,    748,
      -828,   -818,   -682,   5250,   -640,   -270,    385,   1049,
     -1072,   -774,   1870,   -668,   1514,   -158,    283,    793,
     -1087,  -1150,   -899,   -875,   -188,   -184,   6656,   2311,
      -906,   1654,   -446,   1677,   -654,   -101,    364,    721,
     -1272,   7928,   -812,   -576,   -708,   -347,    397,   1128,
      3830,  -1034,  -1055,   2244,   -759,   -706,     79,    893,
      -922,  -1067,   2740,   -868,   -858,   1129,     34,   1096,
      2455,   -694,   1970,   -650,   -674,   -131,    370,    697,
     -1069,  -1137,   -948,  -1045,  -1087,   -964,    367,   1091,
      4096,   -960,   -921,   -870,   1397,   -511,   -190,    545,
      -657,  -1194,   -536,   -951,  -1094,    117,   -720,   2532,
     -1098,  -1147,  -1177,   1764,   -757,   -121,   2372,   2010,
      3662,   -952,   -995,   -894,   -625,    464,    731,    863,
      -607,   -505,    401,   -423,   -540,   2144,    755,   -430,
     -1499,  -1242,  -1202,  -1190,   -626,   1249,   3388,   2379,
      -983,  -1090,   -907,  -1021,  -1012,   -870,   2723,   1589,
      -913,    332,   -102,     99,    226,      6,    176,    354,
       156,    -36,   -829,   -774,   -685,    -15,    498,    503,
      2030,   -409,   -599,   -572,   -341,     -2,    111,    302,
       788,  -1002,   -978,   -929,  -1001,   -886,    578,    995,
      1237,   -747,   -696,   -653,   1143,     62,    506,    571,
       994,   -993,   -902,   -871,   -662,   1527,    370,    979,
       980,   -466,   -484,    787,   -261,     61,    250,    377,
      -112,   -676,   -535,   -344,    274,    363,    185,    334,
       -48,  -1144,  -1095,  -1011,   -552,    445,   1355,   1207,
     -1108,  -1128,  -1085,   -826,    -83,   2001,   1265,   1429,
     -1024,   1199,   -671,   -701,   -444,   1192,    187,    673,
     -1039,  -1056,   -953,   -732,    359,    714,    787,    935,
     -1187,  -1133,  -1112,   -971,   2158,   1720,    801,   2016,
     -1056,  -1068,   -889,   1808,    503,    892,    358,   1041,
     -1180,  -1184,  -1068,   -788,   1423,   -573,   2141,   1949,
     -1042,   -924,   -849,    512,   -629,   -272,    779,    815,
      1939,  -1069,  -1092,  -1027,   -770,     48,   1554,   1285,
     -1109,  -1148,  -1157,  -1033,   -934,    779,   1358,   1560,
     -1053,    222,  -1095,  -1001,   -681,    -26,   1112,   1035,
     -1168,  -1285,  -1169,  -1180,  -1085,  -1097,   1313,   3112,
      -928,   -655,   -811,   -618,   1555,   -480,     71,    467,
     -1220,  -1123,  -1008,   -577,   -845,   3854,    491,   1878,
     -1051,   -761,    617,   -650,   -453,     51,    784,    757,
      -993,   -883,   -905,   -708,   -869,    969,    -64,    655,
};

static const int16_t fcb22s[] = {
      9854,   -479,  -1163,  -1147,  -1316,  -1137,   -991,   -942,
       522,    739,  -1042,  -1306,  -1040,   -126,   1147,   3526,
      1880,   -477,   -483,   -328,   -899,   1063,   1243,   -610,
      -721,   -527,   -372,    171,     90,    196,   6615,  -1167,
     -1189,  -1079,   -954,   -817,   -833,   2246,    439,   1038,
     -1053,  -1136,   -938,   -805,  -1022,  -1041,   -717,   2021,
       341,    935,  -1164,  -1230,   -573,   1768,  11111,  -1113,
      -874,   -631,   -367,      7,  -1077,   -925,   1558,   -850,
      -918,   -755,   -512,    452,    260,    400,   -787,   -966,
      -690,   -584,   -843,   -802,   2092,    120,    103,    580,
      -746,   -512,   -241,   -621,   2771,   -486,   -268,    258,
       171,    232,  -1265,  -1253,  15128,  -1123,  -1037,   -885,
     -1109,   -664,   -659,   -240,   1558,   -909,  -1160,  -1247,
     -1223,  -1031,   -989,   -415,   3504,   1569,   -651,  -1241,
     -1145,  -1014,  -1322,  -1000,   -354,     59,    709,   4206,
     -1124,   -986,   -633,   -976,   -907,   -636,   -371,    255,
      1195,    876,   -145,  -1146,  -1018,   -992,   -480,   -762,
      6904,   -703,   -431,   1043,  -1048,   -638,   -142,    394,
      -852,   -730,   -533,   -361,    234,    221,  -1070,   -930,
      -764,   3210,   -780,   -256,   1777,    258,    307,    382,
     -1224,    987,   4894,   3525,   -412,   -558,   -819,   -863,
      -572,   -497,  -1175,  -1197,   7637,  -1109,   -748,   -116,
      -306,     27,    386,    630,  -1334,  -1378,  -1302,  12592,
     -1327,   -971,     89,   -731,    259,    201,  -1135,   -951,
      -585,    -64,   3489,   2765,     43,     75,   -527,   -162,
      2865,  -1344,  -1394,  -1391,  -1231,   -748,   -962,   5403,
       719,   1418,   -724,  -1101,   -955,   -743,   -937,  -1064,
     -1095,   -601,    -60,    411,  -1113,   -873,   -603,   2913,
      2512,   -339,    -36,     26,    -39,     78,   -757,   -998,
      -522,   -838,   5507,   -973,    796,    536,    250,    312,
     -1363,   -944,   6021,    -58,   5313,   -690,   -549,   -485,
       -66,   -133,  -1257,   6004,   6374,   1487,   -976,   -987,
      -969,   -803,  -1027,   -624,   -967,   1744,   3504,      6,
      -659,   -691,   -326,   -129,    -49,    148,  -1032,   -683,
      1819,   1804,   -491,   -452,   -295,     33,    -20,     42,
     -1226,  -1086,   -792,   6412,   -657,   -278,   -103,    -25,
       -82,    207,   2450,     -6,   2417,    251,   -622,   -593,
      -409,   -193,   -339,   -304,   -862,   -667,   2457,   -500,
      -438,   -504,   1408,    143,    203,    265,  -1128,  -1148,
      2791,   -373,   -951,   2129,   -842,   -278,     81,    307,
      -787,   -822,   2655,   -604,   2028,   -787,      4,    335,
       170,    219,    649,   -457,    972,   -607,   -359,   -470,
      -238,     68,    -57,    107,   2285,   -526,   -490,   -604,
       179,    -41,    230,     64,     20,     50,   -802,   1168,
      -235,   -264,   -316,   1469,   -499,    108,    183,    150,
     -1068,   -806,   -399,   1244,   -355,    487,    -57,    450,
       195,    248,  -1122,  -1096,   3327,   -956,   1084,   1306,
       247,    442,    169,    283,   3416,   -609,   -891,   -879,
      -853,   -573,   -285,   -147,    380,    608,   1271,   -874,
      -931,     40,   -989,   1432,   1981,    -34,    285,    190,
      -902,   -974,   4117,   -868,   -784,   -584,   -358,    200,
       261,    521,   -945,   -981,   -773,   3517,   -961,   2420,
         9,    318,    187,    322,  -1006,   -779,   -526,   2972,
      -712,   -578,   -576,    167,    156,    270,    460,    -74,
      -237,    939,   -440,   -515,    126,     63,     82,     67,
     -1069,  -1104,   -923,   -634,   -190,   1151,    526,   2920,
       125,    566,  -1144,   4199,   1314,   -458,   -568,   -336,
      -515,   -332,   -352,   -143,   -770,    283,   -770,   -785,
      -807,   -348,     93,    427,    181,    334,   -798,   -830,
      -300,   -509,   1257,   -554,   1341,      6,    242,    272,
     -1030,     62,   1293,    340,    752,   -493,     -6,    -34,
        33,     85,   -893,  -1202,    244,   -131,   -306,   7590,
      -832,    420,     80,    423,   -799,   -870,   -930,   -720,
      -640,   2390,   -409,   -177,     91,    370,   -864,   -949,
       838,   -574,   -234,    555,     46,     -9,    -83,    146,
      -825,   -478,   -664,    -57,    867,   -296,   -380,    -73,
        70,    171,  -1124,  10522,   -228,   -609,   -958,  -1025,
      -548,   -384,   -257,     55,   5414,    436,   -651,   -748,
      -671,   -525,    -25,   -273,   -264,     57,  -1129,   1974,
      -145,   1650,   -317,   -514,   -305,    -78,   -154,     59,
      1269,   1008,   -510,   -711,   -534,   -358,    194,    117,
       102,     57,   -837,   1260,   -126,   -494,     47,   -162,
       924,    -72,    130,     97,    742,   -803,   -711,   -755,
      -402,   -188,     24,    309,    187,    379,  -1092,   5862,
      -647,   -807,   -715,   -696,   -408,    -29,    104,    353,
      3298,   2193,   -263,   -772,   -908,   -754,   -449,   -164,
      -157,    -44,   -986,   2313,   -596,     56,   2057,   -478,
        74,    -51,     51,    121,   -899,   1793,   -595,   -669,
      -743,   -689,   -546,     71,    201,    382,  -1061,   3375,
      -776,   -876,   -648,   -407,    -44,    260,    258,    393,
};

static const int16_t fcb22m[] = {
     11522,    868,  -1444,  -1572,  -1674,  -1745,  -1844,  -1616,
     -1723,  -1508,     27,   -321,   -693,   -597,   -374,   -380,
       327,    209,    611,   1182,   -548,    176,   -544,   -485,
      -341,   -376,   -383,   1024,   1316,     -4,    192,   -649,
      -979,   -945,   -802,   -183,   3749,    812,   -416,   -527,
      -734,   1059,   -521,    924,   -462,   -631,    -76,    182,
       126,    100,   -653,   -643,  -1189,  -1264,  -1312,  -1311,
     -1212,  -1016,   -218,   8415,  -1005,    734,   1303,   -272,
      -397,   -521,   -245,    389,    242,   -234,    458,   -912,
     -1215,  -1228,  -1288,  -1131,   -845,   -404,    912,   5497,
       413,   3161,   -432,   -148,   1704,   -663,   -996,  -1009,
     -1419,   -929,    -36,   -471,   -640,   -571,   -197,   -573,
      -462,   2586,   -179,   -382,   -757,   -895,  -1096,  -1140,
     -1216,  -1051,   -688,    -44,   3311,   3518,   -474,   2530,
      1475,   -676,   -702,   -777,   -380,   -316,   -538,   -468,
      -708,    542,   -213,   -713,   -911,   -482,   -696,   -135,
      1282,   2006,   5707,    476,   -707,   -771,   -650,   -788,
      -778,   -853,   -962,   -926,     10,    -11,      3,      1,
       -12,    -14,     21,      7,    -13,    -10,  -1410,  -1712,
      1379,   5757,    218,  -1232,   -563,   -929,   -684,   -827,
      -261,   1040,   -154,   -309,    -99,     62,    856,    199,
      -614,   -926,   -626,   1568,   -258,    374,   1071,   -140,
      -250,   -332,   -832,   -706,   -863,   -714,   -749,   3081,
       498,   -695,   -395,   -600,   -279,    588,    245,   3122,
      -329,   -677,   -262,     67,     19,   -530,   -882,   -862,
     -1033,   -160,   1542,   1916,   -416,   -600,   -553,   -219,
      -130,   -497,   -699,   1719,    160,   3293,   -212,   -923,
     -1045,   -761,  -1238,  -1038,   1543,    738,   -548,   -541,
      -403,   -281,   -115,    -95,   -313,    -19,   -292,   1136,
      3592,    696,   -654,   -856,   -726,   -693,  -1057,  -1267,
      -722,   -381,   -683,   1364,    -30,    589,    454,    262,
       -57,  -1018,   -312,    846,   -139,   -587,   -127,   2482,
      -178,   -233,   -977,   -796,     -6,    250,    220,   1577,
      1141,   -251,   -649,   -809,  -1051,   -873,   -762,   -990,
     -1010,   -890,   -897,   -639,   -671,   1964,    788,   2310,
      6001,     20,  -1008,  -1159,  -1208,  -1208,  -1318,  -1227,
      -829,   1680,  -1023,   -998,  -1224,   -945,   -769,    -41,
      2033,    196,    917,   1615,   2026,   -654,  -1014,   -918,
      -750,   -675,   -839,   1541,    282,    430,  -1059,   -708,
      -507,   -522,   -169,    438,    196,    835,    778,    897,
       420,    526,   1239,    198,   -736,   -953,   -835,   -229,
      -348,    726,   -767,   1311,    248,   -353,   -550,   1017,
      -250,   -732,    256,   -175,   -638,    763,   -761,   -957,
      -554,    539,    252,    299,    431,    613,   4398,   -378,
     -1022,  -1020,   -990,   -757,   -621,    -83,    -34,    122,
      -476,     77,   -799,   -116,   4546,   -787,   -735,   -462,
      -875,   -907,  -1373,  -1354,  -1355,  -1220,  -1024,    -88,
      1298,   2844,    940,   1135,   2261,   2142,    181,   -735,
      -924,   -941,   -799,   -715,   -662,     86,   -719,   -521,
       115,   -576,   -699,   1052,   1295,    -57,     42,    230,
      2876,    501,   -294,   -158,    104,   -157,   -515,   -662,
      -987,  -1069,   -703,   -985,  -1061,   -946,   -878,   -267,
       397,    132,    534,   3642,   1298,   -560,   -701,   -526,
      -294,    197,    310,     75,     -3,    267,   -342,   2058,
      -328,   -427,   -709,   -688,     14,    -43,    237,    506,
      2822,   -337,   -900,   -818,   -638,   -192,    883,    -14,
      -271,   -559,   2822,   -165,   -988,   -933,   -917,   -603,
      -583,   -397,    467,   1092,  -1044,   -479,   2478,   -386,
      -535,   -253,     63,    -49,     79,     27,   -182,   -100,
       362,   -628,   -661,   -707,   1557,    136,    335,     89,
      -197,   5697,    220,   -473,   -472,  -1053,  -1023,  -1087,
     -1203,   -756,   -377,   -917,   -925,   -568,   -237,   1422,
       197,    -98,    614,    867,   -831,   -829,   -969,   -720,
       414,   1080,   1707,    828,   -121,   -757,  -1044,   -289,
       816,    284,    809,    -84,    -22,   -552,     -9,    193,
      -359,     66,   -582,   -674,   1992,    -31,     58,    427,
      -515,   -299,    932,   -608,  -1103,  -1068,  -1016,   -770,
       200,   1031,   1112,   1026,   -598,   -818,   -891,   -635,
      -828,   -866,   -650,   4795,   -407,    215,   -853,    373,
      -696,    159,    995,    465,   -509,    109,     60,     10,
      8455,    198,   -999,  -1131,  -1111,  -1195,  -1246,  -1192,
     -1181,   -934,   -365,   -764,   -689,   -589,   -734,   2479,
      -960,   1279,    104,   -209,  -1012,   -824,  -1059,   -921,
      -812,   -204,    199,    601,   3136,    637,   3021,   3851,
      -490,    -18,   -930,  -1081,  -1133,  -1182,  -1268,   -980,
      -864,   -945,   -278,    961,   -514,   -123,    562,    874,
      -130,    336,   3314,   -331,  -1112,  -1162,  -1227,  -1230,
     -1172,   -988,   -319,   3582,    890,     50,   -681,   -788,
      -906,   -876,   -829,   -827,    -41,   3416,   -740,   -913,
      -893,    404,   2059,   -651,   -474,    302,    516,    578,
};

static const int16_t fcb22sl[] = {
      1098,  -1107,  -1125,   -983,   -770,   -233,    201,    823,
     -1433,  -1294,    -17,  -1156,   -301,   1185,   1307,   1108,
     -1247,   1829,   1353,   -537,   -457,    116,    574,    712,
       159,   -489,    511,   -340,     54,    119,    213,    351,
     -1489,  -1256,  -1324,  -1132,   3710,    262,   1087,   1465,
     -1434,  -1027,  -1116,    825,   -662,   -428,   -109,   1045,
       229,    753,   -604,   -422,    122,   -220,    279,    375,
      -349,   -684,   -197,    490,   -160,   -116,   -120,    146,
      5195,   -895,   -974,   -758,   -524,     21,    761,   1016,
     -1216,    151,    864,   -602,   -715,   -591,   -347,    592,
     -1265,  -1328,  -1375,   -878,   -660,   -549,    143,   4302,
     -1433,  -1277,    360,  -1032,   -835,   -385,    337,   1111,
     -1345,  -1250,  -1156,    914,   1594,     22,    912,   1012,
     -1576,  -1411,  -1364,  -1153,    842,   -184,    240,   1302,
     -1486,  -1162,   1246,   -880,   -830,     14,   2487,   1607,
     -1384,   -158,   -572,   -977,     43,    -30,   -184,    572,
      2759,   -892,   -768,   -522,   -289,    -44,    351,    575,
     -1292,   -546,   3736,   -609,   -538,    -25,    514,    924,
      1772,   1639,   -903,   -595,   -263,    340,    579,    670,
     -1425,    770,  -1179,   -920,  -1158,   -675,    496,   1208,
     -1337,   1240,  -1030,  -1044,   1840,    312,    809,    908,
     -1457,   1410,  -1240,  -1083,   -541,    568,   2768,   1432,
     -1249,   -890,   1078,   1278,   -558,     63,    573,    778,
     -1285,   1932,  -1004,   -902,   -339,     59,     17,    659,
     -1352,   -935,   -877,   3421,   -455,    160,    820,   1230,
     -1326,   -978,    986,   -790,   1541,     41,    542,    743,
     -1491,  -1162,  -1389,  -1265,   -928,   -139,   5045,   2259,
     -1182,   1358,   -953,   1338,   -502,    122,    749,    839,
     -1284,   4389,  -1001,   -813,   -421,     44,    855,   1072,
      1658,   -881,   -821,   1409,   -299,      4,    453,    700,
     -1144,  -1112,   1230,   -790,   -421,   1250,    -12,    655,
      1545,   -872,   1199,   -632,   -365,     56,    415,    663,
     -1401,  -1189,  -1403,  -1189,  -1145,   -687,   -116,   1120,
      1768,  -1068,  -1024,   -629,   1440,     88,    578,    711,
     -1651,  -1561,  -1564,  -1430,  -1037,   1264,    -21,   1944,
     -1552,  -1336,  -1277,    916,   -412,     27,   2454,   1661,
      1996,  -1087,  -1223,   -924,   -393,   1673,    794,   1017,
     -1362,   -132,    151,    537,   -992,   1830,    777,    991,
     -1591,  -1355,  -1494,  -1420,   -666,   2407,   3210,   2092,
     -1114,   -624,  -1087,   -903,   -808,   -438,   1881,    654,
     -1140,    254,   -105,    212,    386,     49,    256,    314,
        83,     98,  -1128,   -901,   -578,    362,    702,    691,
      1191,   -204,   -335,   -226,   -102,    -44,     -5,    120,
        57,  -1110,   -403,   -651,   -806,   -202,    567,    690,
       349,   -908,  -1075,   -941,   1487,    464,    763,    782,
       387,  -1070,   -990,   -765,   -295,   1669,    341,    881,
       232,  -1013,  -1043,    723,   -311,    294,    646,    574,
        72,  -1191,   -546,   -183,    493,    161,    201,    465,
      -185,  -1434,  -1368,  -1051,     64,    385,    748,    986,
      -740,   -530,  -1199,   -562,    142,   1388,   1487,    715,
     -1359,    873,  -1187,   -923,   -455,   1914,    403,   1016,
     -1245,  -1223,   -624,   -495,    724,    652,    433,    585,
     -1499,  -1277,  -1381,  -1148,   1679,   2138,    995,   1424,
     -1345,  -1319,  -1296,    906,   -228,   1534,    506,   1024,
     -1628,  -1410,  -1422,  -1197,   1393,    -22,   2728,   1784,
     -1245,  -1056,   -942,      2,   -165,   -115,    840,    569,
      1016,  -1191,  -1091,   -862,   -457,     95,   2087,   1029,
     -1460,  -1486,  -1459,  -1104,   -571,    925,   1234,    935,
     -1568,    -49,  -1325,  -1255,    -64,    315,    838,    962,
     -1651,  -1562,  -1606,  -1571,  -1308,   -380,   1988,   2117,
      -848,   -412,   -987,   -370,   1224,   -304,     10,    498,
     -1523,  -1348,  -1373,   -959,   -772,   3767,    621,   1773,
      -931,   -628,    169,   -513,     61,   -306,    994,    476,
     -1116,   -879,   -875,   -484,   -795,    958,   -162,    444,
};

static const int16_t fcb22ss[] = {
      6765,   -638,  -1108,   -977,   -679,   -446,   -325,   -432,
      -127,     96,   -569,   -621,  -1050,   -841,   -800,   1474,
      1170,     60,    330,    223,  -1317,    855,    307,   -931,
      -648,   -549,   -148,    535,    642,    445,   3666,  -1146,
     -1167,   -944,   -584,    942,   -284,     25,    573,    472,
     -1041,  -1096,  -1209,  -1082,   -770,   -737,   -139,   2073,
       753,    832,    507,   -828,  -1112,  -1130,   4284,   -722,
      -261,    -57,    499,    300,  -1380,  -1130,    135,   -898,
      -816,   -395,    195,    453,    650,    537,   -953,  -1109,
     -1221,   -981,   -747,   -647,   2360,    467,    845,    684,
     -1177,   -792,  -1254,  -1148,   1344,   -745,   -323,    180,
       729,    739,  -1020,    183,   5226,   -638,   -358,    -86,
      -268,   -143,     84,   -115,    480,   -543,  -1229,  -1097,
      -594,   -983,   -792,   -391,   2637,   1405,   -761,   -866,
     -1186,   -973,   -792,   -640,   -220,   -102,   1165,   3159,
     -1241,  -1057,  -1322,  -1007,   -731,     44,    264,    668,
      2645,   1592,   2885,  -1155,  -1347,  -1209,   -309,  -1161,
      4216,    -64,    830,    616,   -688,   -638,   -596,    202,
      -665,   -623,   -499,   -248,    512,    749,  -1395,   -708,
     -1086,   1209,   -745,   -367,   1397,    279,    374,    259,
     -1357,   -254,   2310,   1839,   -147,     36,   -402,    300,
       -49,     47,  -1328,   -992,   3453,   -889,   -621,    135,
       437,     70,    663,    346,  -1339,  -1136,  -1275,   6675,
     -1309,   2285,   -869,   1154,    640,    617,   -505,  -1042,
      -984,   -702,   1283,   1573,   -168,    135,    249,    253,
      -783,  -1119,  -1342,   -975,  -1127,   1391,   -705,   4439,
      1160,    845,  -1283,  -1224,  -1286,  -1142,  -1019,   -901,
      -658,   -157,    231,    611,   -994,   -463,  -1017,   1082,
      1831,   -459,   -164,    114,      0,    108,  -1386,  -1079,
     -1318,  -1091,   2540,   -717,    762,   1414,    849,    576,
     -1405,   -566,   2704,   -996,   2133,   -678,    404,    281,
         4,    -32,  -1474,   3530,   2301,   -711,   -919,   -305,
      -125,    184,    450,     73,  -1132,   1567,   1620,   -551,
      -198,   -645,     19,      8,    190,    191,   -741,   -728,
       410,   1067,   -322,   -239,     86,     11,   -137,   -220,
      -489,   -607,   -963,   3630,   -624,   -478,    -12,    124,
       219,     63,   2040,     75,   1338,   -293,   -333,   -336,
      -330,   -246,   -360,   -344,   -953,   -393,   1550,   -701,
      -616,   -254,   1908,    211,    328,    -43,  -1089,   -299,
      1070,   -723,   -923,   2170,   -400,    -13,    -28,    108,
      -812,   -400,    876,   -650,   1308,   -772,   -256,   -200,
       117,    329,    649,   -639,    437,   -704,   -567,    -20,
      -211,    197,    330,    342,   1670,   -468,   -920,   -588,
       972,   -310,      9,    -46,     70,    -29,  -1313,   1684,
      -794,   -979,   -752,   1864,   -173,    108,    248,    292,
     -1247,  -1226,  -1059,    288,   -112,    189,     20,    540,
       454,    380,  -1035,   -803,   1267,   -767,    746,   1331,
       107,    317,    158,   -116,   2093,   -723,  -1064,   -906,
      -713,   -789,   -518,     48,    494,   1018,   1835,  -1353,
     -1303,  -1098,   -559,    800,    520,    662,    615,    574,
     -1282,   -526,   1829,  -1086,   -885,   -356,   -539,    -50,
       493,    402,   -777,   -374,   -754,   1721,   -701,   2086,
      -348,    218,    138,    109,  -1367,  -1226,  -1041,   1949,
      -433,   -291,   -363,    567,    613,    560,   1166,   -481,
      -737,   1193,   -479,   -163,    -69,      2,    133,    239,
     -1444,  -1448,  -1350,   -987,   -296,    606,    755,    543,
       741,    806,   -851,   2437,     23,   -681,   -670,   -271,
      -439,   -227,   -243,   -198,  -1307,    424,  -1212,   -987,
      -745,   -369,    162,    641,    915,    611,    -24,   -728,
     -1061,   -659,    808,   -532,   1241,   -233,    266,    353,
       175,    210,   -262,   -328,    101,   -238,     66,   -339,
      -472,   -415,    952,  -1490,  -1302,   -955,  -1270,   5776,
      -792,    777,   1097,    807,  -1334,  -1172,  -1211,   -924,
      -877,   2458,   -355,    593,    936,    699,   -336,   -700,
      -762,   -569,   -337,    642,     97,    441,   -188,   -533,
     -1062,    188,   -873,   -801,    418,   -167,    -57,    -29,
        79,    241,  -1110,   6430,   -816,   -807,   -462,   -601,
       -56,    -45,    188,     74,   2869,     43,  -1122,   -799,
      -772,   -847,   1394,    -36,    294,     13,  -1304,   2155,
      -534,   1545,   -315,   -325,    183,     31,    372,    187,
       873,   1376,  -1037,   -810,   -516,   -235,    485,     99,
       287,    327,  -1074,   1203,  -1089,   -882,   -515,   -544,
      2041,    -40,    208,    191,    597,  -1141,  -1274,   -885,
      -386,    106,    593,    394,    671,    678,  -1292,   3861,
     -1085,  -1150,   -748,   -218,    500,     55,    335,    469,
      3217,   2888,   -882,   -643,   -590,   -506,     43,   -459,
      -210,   -222,   -965,   2453,   -830,   -779,   1808,   -588,
       130,      4,    130,    -23,  -1269,   1374,  -1238,  -1148,
      -523,   -659,   -170,   -302,   1055,   1389,  -1467,   2505,
      -930,  -1181,   -842,   -516,    399,    886,    849,    738,
};

static const int16_t fcb22sm[] = {
      5761,   -398,   -743,   -948,   -944,   -845,   -883,   -896,
      -811,   -604,  -1142,  -1388,  -1190,   -685,   -118,   1498,
      1590,    293,    564,    352,    124,    851,   -131,   -652,
      -573,   -279,   -756,   -478,    833,    670,   2609,  -1138,
     -1107,  -1024,   -739,   -646,   -387,     33,    635,   1037,
      -717,   -990,  -1161,   -948,   -660,   -230,     69,   2510,
      1274,    841,    -49,   -872,   -764,   -211,   3046,    -30,
      -143,   -311,   -324,   -413,   -760,     67,    619,   -699,
      -725,    305,   -484,   1292,    472,   -156,   -568,  -1243,
     -1256,   -994,   -803,   -386,   1692,    596,   1325,   1290,
      -492,  -1007,   -732,   -788,   1136,   -610,     45,   1307,
       420,    649,   -534,  -1075,   -949,   -367,    219,    444,
      -120,    251,    476,   1806,    902,   -927,  -1151,   -879,
      -659,   -741,     -5,    298,   1861,    995,   -244,  -1031,
     -1142,  -1085,   -952,   -773,   -468,     -9,   1637,   3592,
      -971,  -1150,  -1199,   -985,   -689,   -317,    150,    540,
      2727,   1678,   -223,   -403,    102,   -902,   -773,   -223,
      3182,   -457,     75,   -188,   -291,   -428,   -101,   -365,
      -442,   -336,   -128,    -33,    781,   1242,    501,   -753,
      -846,    757,   -444,   -311,   1182,      4,     -8,   -122,
      1866,   -528,   -142,   1598,    -15,   -219,   -557,   -804,
      -916,   -965,    114,    130,   3672,    -19,   -873,   -280,
      -777,   -919,   -824,   -654,   1078,     39,    -50,    119,
      -411,   -311,   -359,    -57,   -137,      7,   -780,   -892,
      -767,   -167,   1302,   1693,   -205,    -51,   -174,    -71,
       838,   -220,  -1133,   -993,   -710,   -340,    650,   1341,
       191,     -5,    743,   -543,   -125,   -567,     70,    -42,
      -501,   -448,     47,   1151,    400,   -774,   -781,   1324,
      1089,     32,   -256,   -415,   -352,   -214,    912,  -1141,
      -988,   -638,   1349,    251,    124,     -4,     89,    -16,
      -678,   -569,   1502,    146,    114,    816,    -98,   -269,
      -622,   -808,   -634,   3319,   1218,   -323,   -750,   -548,
      -525,   -575,   -591,   -730,     35,    764,   1423,    574,
      -352,   -672,   -802,   -314,   -308,    -29,  -1040,   -717,
       469,    421,   -527,   -420,    589,    195,    556,    472,
      -626,   -864,   -133,   3531,   -667,   -460,   -523,    103,
        23,   -309,   2381,    136,   1197,   -399,   -399,   -501,
      -638,   -899,   -813,   -707,   -249,    719,    821,   -989,
      -629,   -568,    642,     -4,    297,     70,  -1105,    454,
       400,   -235,   -562,   1607,   -116,   -205,      1,   -490,
         7,   -523,    764,    329,    992,   -240,   -249,   -275,
      -366,   -265,    662,   -803,    393,   -567,   -501,    -32,
       178,    371,    126,   -146,   1748,   -516,   -634,   -395,
       268,    893,    154,    -36,   -620,   -999,    304,   1490,
      -512,   -821,   -479,   1922,   -610,   -481,   -482,   -805,
      -996,    -16,   -567,    542,    -22,    589,   -114,     69,
       322,    358,   -848,   1205,    509,   -527,     25,    111,
      -243,   -197,    -20,     62,   1500,   -977,   -974,   -391,
      -555,    448,   -256,     79,    392,    547,   1472,  -1276,
     -1203,   -987,   -315,    515,    855,    183,    231,     62,
     -1176,   -397,   2831,   -527,   -575,   -435,    174,   -337,
       723,    107,   -502,   -765,   -455,   1124,   -218,   1444,
        53,   -201,   -135,   -267,   -510,  -1058,   -869,   1130,
      -128,   -394,     16,    873,    597,    455,     16,      0,
       -11,     14,    -12,      9,      6,    -14,    -11,    -23,
      -453,  -1056,   -988,   -713,   -267,    794,    954,   1361,
       822,   -448,    379,   1163,    336,   -724,     55,    109,
       237,    -80,   -732,  -1017,   -264,    654,  -1043,  -1015,
      -654,     91,     17,    548,    504,    932,  -1057,  -1151,
      -964,   -130,   1171,   -146,    740,    134,    790,    539,
      -591,   -577,   -388,    154,    609,    341,    657,    838,
      -379,   -872,    711,   -665,   -818,   -549,   -151,   2501,
       -28,   -189,   -255,   -378,   -363,  -1157,   -929,   -887,
      -338,   1926,    -33,    -26,   1009,    765,    -79,    -98,
       -37,   -967,   -566,   1012,    905,   -245,     41,    322,
       194,   -148,   -220,   -171,   -239,   -242,   -147,    -14,
       221,    575,   1754,   3059,   -246,   -713,   -696,   -636,
      -640,   -843,   -841,   -755,   2554,   -504,   -568,   -318,
      -324,   -171,   -294,   -238,   -288,   -174,   -289,   1273,
      -231,   1053,   -284,   -338,   -394,   -227,   -303,   -226,
       966,    742,   -873,   -503,   -586,   -286,    119,    -59,
       339,    -38,   -843,    977,   -448,   -238,    227,    -77,
       729,      6,     45,   -493,    277,  -1385,  -1289,   -846,
      -117,    376,    763,    553,    769,    670,   -652,   3280,
      -762,   -882,   -396,   -299,    124,   -270,    -31,   -210,
      2413,    644,   -790,   -912,   -581,   -507,   -110,   -408,
       -54,    -30,    632,    969,   -632,   -206,    955,    -95,
      -578,   -337,   -377,   -467,   1264,     67,   -854,   -863,
      -909,   -751,   -616,   -479,    563,   2070,   -972,   1478,
      -450,   -715,   -859,   -689,    190,    736,    617,    530,
};

static const int16_t fcb44sl[] = {
      2433,   -925,  -1015,  -1009,   -875,   -276,    378,    464,
       694,    795,  -1044,   -601,   -658,    257,   -898,   -509,
      -346,   2160,    694,    952,  -1302,   -619,    502,   -378,
      -624,   -178,    349,   -100,    204,    546,  -1450,  -1127,
     -1302,  -1297,  -1051,   -840,   3426,   1346,   1577,   1723,
     -1267,   -710,   -872,    448,  -1023,   -728,   -521,   -134,
       874,    936,  -1134,   -549,    203,   -932,  -1051,    755,
      -608,   -199,    858,   1008,   1819,   -842,   -773,   -739,
       818,   -371,    289,    293,    656,    704,    308,  -1009,
      -959,  -1089,    466,   -468,    279,    897,    764,    797,
     -1433,  -1276,  -1253,  -1326,  -1182,   -992,    -85,   4339,
      2135,   2136,   1131,   -917,   -966,   -859,   -889,   1178,
        62,    659,    771,    882,   1844,   -607,   1184,   -766,
      -805,   -385,    -61,    502,    648,    732,  -1245,   1315,
      -818,   -827,    621,   -588,    193,    480,    649,    776,
     -1178,  -1202,  -1152,  -1088,   -857,   -191,    -49,    129,
      1950,   1237,  -1461,  -1290,  -1342,  -1401,  -1338,  -1213,
      -623,    224,   4086,   2517,  -1150,   -814,   -747,    916,
       807,   -288,    319,    436,    560,    718,    392,   -973,
      -988,    411,   -954,   -502,    214,    621,    856,    831,
     -1268,   4012,   -852,  -1002,  -1014,   -577,     32,    552,
       987,   1138,  -1205,  -1319,  -1145,   -928,     80,    371,
       277,    779,    859,    902,  -1141,   -991,   -957,    707,
      -892,   1098,    126,    381,    668,    870,  -1254,   -995,
     -1163,   -926,  -1149,   2572,    -17,    747,   1456,   1509,
     -1004,   -867,   1205,   -797,    938,   -657,    346,    520,
       782,    872,  -1328,  -1080,  -1111,  -1067,   2227,   -892,
       665,   1604,   1425,   1477,   1869,   -668,   -712,   1044,
      -800,   -139,      0,    355,    609,    717,  -1192,   -632,
      3546,   -780,   -870,   -501,    141,    504,    921,   1027,
     -1125,  -1087,   1154,   -660,   -987,    937,     82,   1390,
      1360,   1243,   1259,   -550,   -769,   -787,   -743,   -362,
       -12,    177,    321,    505,  -1147,   -899,   -947,   -849,
      1371,   -462,   -127,     16,    752,    954,  -1405,    448,
     -1181,  -1259,  -1204,   -868,   -468,    110,   1293,   1263,
     -1267,  -1180,  -1238,   -930,   -940,    916,   1793,    653,
      1070,   1137,   -216,   -997,   -845,   -659,   -699,   -174,
       758,    961,    417,    630,  -1123,   1691,   1229,   -732,
      -937,   -491,    -78,    265,    744,    864,   4771,   -856,
     -1005,  -1007,   -934,   -484,    -17,    579,    861,    959,
     -1264,     70,   -961,   -864,   -860,   -302,    314,    788,
       487,    686,  -1133,   -790,   -466,    561,   -812,   -256,
      2078,    -58,    757,    953,  -1133,   -286,   -655,   -476,
       -23,   -629,      7,    182,    426,    504,  -1110,    314,
       497,   -822,   -662,   -754,   1179,   1726,    696,    955,
      1793,  -1143,  -1268,  -1279,  -1207,   -873,   -183,   1546,
      1440,   1305,  -1278,   1396,   -779,    558,   -840,    -32,
       -18,    257,    616,    757,    265,   -906,    499,   -897,
      -846,   -435,    362,    434,    752,    732,    453,    150,
     -1029,  -1182,  -1195,   -940,   -297,    876,   1084,   1051,
     -1377,   1354,  -1148,  -1313,  -1211,   -937,   -366,   1942,
      1323,   1410,    311,   -270,    -81,   -159,     42,     42,
         7,    357,    255,    285,   1973,   1386,   -752,   -873,
      -916,   -466,    -39,    493,    638,    759,  -1338,   1107,
     -1081,  -1165,  -1038,   -484,   1722,    534,   1038,   1102,
     -1446,  -1212,  -1337,  -1452,  -1422,  -1291,   -690,   1634,
      1348,   1640,  -1044,   -184,   -757,   -683,   -100,   1044,
       369,    349,    432,    584,  -1137,   -528,   1425,   1294,
      -842,   -257,    -32,    289,    639,    796,  -1418,  -1229,
     -1282,  -1391,  -1421,  -1234,   -852,   -765,    737,   2076,
     -1104,   -928,   -936,  -1088,    378,   -765,   1603,    581,
       753,    925,  -1191,   -841,   -919,   2886,   -907,   -232,
       180,    543,    956,   1070,  -1314,   -843,    804,  -1094,
     -1209,  -1031,   -626,    698,   1049,   1152,    256,    831,
      -841,   -814,   -841,    -54,    134,    347,    535,    658,
       104,   -801,   -959,   -519,   -406,    156,     12,     13,
       380,    494,  -1144,  -1112,   -973,   -965,   -916,   -474,
      -225,    460,    402,    734,  -1448,  -1316,  -1278,    231,
     -1086,   -578,    584,   1115,   1275,   1260,  -1321,   -963,
     -1127,  -1288,     41,  -1102,    -31,   1331,   1003,   1145,
       112,  -1270,  -1343,  -1376,  -1114,   -778,    392,   1918,
      1165,   1246,  -1247,   -870,  -1232,  -1147,  -1075,    570,
       181,   1983,    971,   1216,  -1309,  -1199,    260,  -1136,
      -950,   -742,   1067,    703,   1150,   1144,  -1405,  -1533,
     -1564,  -1549,  -1264,   -737,   1085,   1706,   1806,   1785,
       282,  -1173,  -1128,  -1188,   -971,   -885,   -291,    254,
       841,    987,   -142,  -1068,  -1264,  -1232,  -1058,    138,
       546,    521,   1096,    987,    890,   -936,  -1020,  -1051,
      -871,   -521,   1686,    625,    930,    936,  -1343,   -924,
     -1231,  -1247,  -1052,   -951,   1110,    125,    826,   1116,
};

static const int16_t fcb44ss[] = {
      6575,   -881,  -1291,  -1258,  -1090,   -517,   -268,    -56,
       106,    295,   -303,  -1134,  -1113,   -650,   -508,   1843,
      -235,   -141,    454,    832,  -1212,    856,   -404,   -620,
      -682,   -487,    -69,    865,    341,     95,   3626,  -1037,
     -1366,  -1349,  -1126,   -558,    187,    343,    657,    765,
      -410,   -735,  -1046,  -1023,   -897,   -673,   -366,   3174,
      1264,    720,   -730,   -922,   -523,   -821,   4042,   -463,
        45,    329,    213,    -93,    301,  -1011,    277,   -840,
      -820,   -451,    417,    470,    739,    953,  -1219,  -1286,
     -1545,  -1426,  -1209,   -803,   1156,   1311,   1329,   1329,
      -643,  -1136,  -1200,   -912,   1221,   -695,    342,    910,
       905,    812,   -996,   -365,   4868,   -738,   -591,   -621,
        17,    -42,      0,    100,   2085,  -1214,  -1434,  -1432,
     -1243,   -577,   -626,    140,   1357,   1821,  -1064,  -1261,
     -1629,  -1525,  -1488,  -1101,   -631,    551,   3556,   3974,
      -635,   -846,  -1005,   -646,   -803,    123,   -151,    357,
      2137,    953,  -1168,  -1055,  -1115,  -1061,   -823,   -651,
      3842,    606,    491,    491,  -1297,  -1063,   -990,  -1051,
     -1202,   -983,   -468,    -47,    163,    336,  -1131,   -446,
      -683,    644,   -660,   -675,   1251,    373,    195,   -123,
     -1109,   -430,   1820,   1883,   -862,   -743,   -265,    119,
        66,    -41,  -1281,   -768,   1941,   -955,  -1054,   -856,
       528,    363,    488,    545,   -936,   -682,   -814,   5534,
      -826,   -347,     58,    -38,    168,     14,   1224,   -719,
      -300,   -766,   -407,    630,    269,     39,   -230,   -701,
      1601,   -958,   -945,   -955,   -734,   -487,    -20,   1392,
       544,    282,   -118,  -1133,  -1161,  -1065,   -939,   -213,
      -129,   -271,    451,   2570,   -895,   -805,   -536,   1455,
      1496,   -647,   -199,    114,     95,    -42,   2230,   -855,
      -715,   -819,   1762,   -699,    -50,   -109,    163,    207,
      -334,   -759,   3297,   -645,   2561,     77,   -239,   -259,
      -275,   -445,  -1304,   3536,   1610,   -526,   -926,   -582,
       -12,     44,   -180,    -69,   -804,   1107,   1451,   -868,
      -851,   -589,   -354,    -85,     88,    336,   -537,   -444,
        40,    231,   -715,   -523,   -351,   -379,   -123,    171,
      1223,   -328,   -567,   2182,   -291,   -352,     20,   -157,
      -338,   -635,   2194,   -476,   1624,   -802,   -762,   -585,
      -245,     48,     63,    -45,    -32,   -646,    847,   -556,
      -727,   -259,   1309,    239,   -128,   -755,  -1018,   -640,
       876,   -642,   -906,   1394,    -26,    338,    204,    148,
      -988,   -521,    135,   -807,   1065,   -525,    -80,   -248,
       383,    836,    521,     13,   -553,   -865,   -928,   -631,
      -137,    -83,    446,    221,   1924,     48,   -621,   -845,
      -782,   -544,   -531,   -418,    -79,    915,   -711,   1247,
      -938,   -766,   -995,   1459,     31,    199,    261,    190,
      -670,  -1207,  -1013,    108,   -670,    204,    407,    266,
       473,    998,   -606,   -923,   1845,  -1061,    910,   -774,
       268,    493,    178,     61,   1938,  -1237,  -1010,  -1097,
      -780,   -368,   1125,    354,    398,    550,   1032,  -1128,
     -1196,   -908,   -767,    529,   2326,    728,    227,    -13,
     -1113,   -367,    382,   -939,  -1094,   -896,   -463,    446,
       896,   1128,   -591,   -823,   -894,   3052,   -968,   2157,
      -153,    -71,    111,    118,  -1106,   -930,   -911,   1663,
      -905,   -691,   -226,    503,    665,    702,   2067,  -1149,
      -828,    990,   -850,   -426,   -159,    148,    379,    512,
     -1268,  -1390,  -1492,  -1343,  -1419,   2246,   -224,   2124,
      1523,   1338,    522,   1613,   -344,   -694,   -487,   -325,
       293,     96,   -374,   -679,   -364,    124,  -1201,  -1274,
     -1078,   -513,     15,   1045,    529,    680,    131,  -1067,
     -1030,   -888,   -806,   -122,   1002,   1302,    757,   -473,
      -530,   -538,   -821,   -373,     72,    797,    864,    265,
      -542,  -1090,   -241,  -1095,  -1205,   -991,  -1172,   5025,
      -420,    728,    461,    103,   2325,   -915,  -1012,   -854,
     -1117,   2018,   -377,    -35,    266,    443,   -949,  -1163,
     -1064,  -1057,   -802,    721,   1278,    470,    308,    263,
       474,   -773,  -1033,   -892,    227,    -30,     39,    101,
       456,    476,  -1263,   7275,   -946,  -1157,  -1304,   -922,
       248,    143,    -98,    312,   3419,   -402,   -649,   -629,
      -554,    -48,    487,     72,   -171,   -687,  -1167,   1869,
      -524,   1490,   -869,   -236,    111,     68,     77,    -85,
      1481,    906,  -1189,  -1321,  -1124,   -554,    429,    321,
       814,    699,  -1048,    486,   -858,  -1096,  -1072,   -744,
      1676,    -73,    593,    632,    779,  -1265,  -1470,  -1379,
     -1050,   -548,    781,    524,   1022,   1079,  -1149,   3719,
     -1064,  -1180,  -1159,   -775,   -211,    241,    492,    555,
      3025,   2828,   -849,  -1133,  -1063,   -567,    -70,   -142,
      -176,    -62,   -614,   1745,   -684,   -610,   1478,   -619,
      -235,   -361,    -84,    -44,  -1155,   1494,  -1183,  -1210,
     -1294,  -1017,   -330,    210,    931,   1368,  -1306,   2714,
     -1052,  -1128,  -1220,   -908,   2409,    441,    310,    318,
};

static const int16_t fcb44sm[] = {
      5619,   -163,  -1005,   -856,   -831,   -644,   -612,   -759,
      -770,   -456,    199,   -551,  -1348,    -80,    131,   -481,
       334,    202,    366,   1246,  -1245,    499,  -1454,   -396,
      -675,   -257,    525,   1001,    878,   1075,  -1004,  -1010,
     -1127,   -947,   -976,    332,   3533,   1315,    265,   -683,
     -1114,   1056,  -1009,   1154,   -728,   -212,    620,    169,
       102,   -110,   -658,   -902,  -1238,  -1213,  -1238,   -926,
      -735,   -455,   1130,   5139,  -1184,    190,   1590,   -604,
      -800,   -373,   -366,    251,    720,    571,     -6,    304,
     -1228,   -369,   -659,   -506,    -25,   -234,    313,   2366,
       623,   1473,   -315,    780,   1048,   -416,   -586,   -737,
     -1029,  -1094,    483,   -725,   -771,   -379,   -268,    -15,
       697,   1774,     -1,   -999,   -987,   -867,  -1339,  -1255,
     -1018,   -652,   -125,    643,   3006,   2417,   -543,   1629,
      1557,   -684,   -568,   -474,   -132,   -291,   -338,   -321,
     -1250,    641,   -158,   -935,   -575,   -575,    154,    415,
       798,   1421,   3147,   1903,   -335,   -767,   -729,   -627,
      -611,   -752,   -836,   -735,    678,    502,   -946,    556,
      -821,    -51,   -256,     94,    151,     70,   -808,   -324,
      -359,   3637,    286,    -90,   -365,   -613,   -782,   -871,
        75,   1051,   -780,   -487,     47,    273,   1768,   -102,
      -828,  -1267,  -1093,   1420,   -624,    225,   1307,     85,
       239,   -152,   -649,   -853,  -1072,   -796,   -644,   1383,
      1143,   -199,     94,    -25,     70,     52,  -1064,   2487,
      -844,   -607,   -587,    148,    726,    224,   -238,   -484,
      -957,   -729,   1517,   1334,   -475,   -317,   -253,   -186,
         1,     17,   -832,   1450,    423,   1408,   -576,   -825,
      -630,   -579,   -312,    314,    788,    382,  -1000,  -1060,
      -763,    968,   -135,     56,    143,    477,   -736,     30,
      4023,     68,   -266,   -420,   -538,   -751,   -893,   -879,
      -935,     59,    465,    887,   -351,   1396,    176,   -250,
      -684,  -1019,   -515,   -815,   -957,   -439,    188,   3794,
        86,    -98,   -245,   -829,   1894,   -386,   -865,   1513,
        24,   -506,   -281,   -615,   -476,   -364,  -1283,   -963,
      -339,   -133,   -161,   -480,     25,    230,   1364,   1815,
      1766,   -844,  -1423,  -1185,   -972,   -458,   -275,    138,
      1317,   1778,  -1295,   -874,  -1211,   -792,   -601,   -500,
      2301,    901,   1336,    842,   1355,   -426,  -1160,   -959,
      -801,   -433,   1852,    144,    284,    169,  -1122,   -851,
      -957,    272,   -393,    817,    862,    262,    333,    802,
       320,   -576,   1615,   -615,   -886,   -311,    108,     13,
         1,    320,  -1205,    962,   -483,   -791,   -749,   1158,
       677,    -57,    166,    279,   -860,   1237,   -971,  -1057,
      -598,   -285,    884,   1174,    657,   -303,   2254,   -706,
     -1113,   -655,    719,    234,   -124,   -199,   -135,   -360,
      -758,   -623,   -385,    -18,   3243,    470,   -139,   -286,
      -520,   -953,  -1193,  -1140,  -1297,  -1137,   -764,     25,
       235,   2217,   1501,   1369,   2024,    781,  -1353,   -835,
      -824,   -601,   -259,   -140,    387,    671,      3,   -974,
      -760,   -884,   -485,    709,   1505,    -95,    321,    739,
      1610,   -156,   1515,    -76,   -420,   -369,   -189,   -506,
      -705,   -907,  -1052,   -516,  -1048,   -996,   -471,   1195,
       212,    184,    800,   1665,    747,  -1029,  -1013,    789,
      -703,    559,   -139,    -98,    380,    523,   -355,   2047,
      -766,   -991,   -809,   -566,   -257,   -242,    485,   1322,
      1989,   -330,   -945,   -559,   -448,   1241,    811,     10,
      -767,  -1218,   1600,   -755,    428,   -729,   -355,   -665,
      -416,   -120,    381,    548,   -717,    -14,   1587,   -886,
        -9,    353,    839,    201,   -454,  -1112,  -1334,   -309,
       660,   -375,   -661,   -511,   1437,    540,    492,      0,
        95,   3911,   -237,   -301,   -562,   -483,   -569,   -799,
      -883,   -580,   -670,   -980,  -1056,   -896,   -797,   1551,
       267,   1000,   1617,     75,  -1132,   -403,   -988,   -830,
      -627,   1164,   1315,   1594,    310,   -564,  -1091,   -563,
      1195,   -442,   1086,   -344,   -176,   -258,    175,    476,
       923,    -37,   -629,   -919,   1278,   -610,    113,   -314,
       -81,    192,    731,   -944,  -1297,  -1108,   -934,   -259,
       640,   1164,   1326,    558,   -767,   -519,   -875,   -930,
      -817,   -533,    496,   2605,   1359,   -131,  -1010,    912,
     -1055,   -309,    768,   -198,   -166,    -76,    429,    640,
      3283,   -895,  -1229,   -853,   -853,   -399,    147,     44,
       237,    495,   -833,   -909,  -1004,   -811,   1039,   1627,
      -194,    295,    738,    290,   -771,    237,   -912,   -479,
      -648,   -518,   -226,    573,   2346,    419,   1013,   1510,
      -865,   -873,   -982,   -557,    598,     50,     81,    -81,
     -1150,   -640,  -1011,   1991,   -561,   -140,     42,    175,
       521,    799,   3231,    -46,  -1004,   -994,  -1140,  -1094,
      -957,   -860,      8,   2346,    212,   -499,    -55,   -997,
      -623,   -588,     38,    -58,    975,   1529,   -986,   -891,
     -1121,   -619,   1967,   -463,     -7,    632,    768,    953,
};

static const float lsp8[] = {
     0.2702,  0.5096,  0.6437,  0.7672,  0.9639,  1.0696,  1.2625,  1.5789,
     1.9285,  2.2383,  2.5129,  2.8470,  0.1740,  0.3677,  0.6082,  0.8387,
     1.1084,  1.3721,  1.6362,  1.8733,  2.0640,  2.3442,  2.6087,  2.8548,
     0.1536,  0.3279,  0.5143,  0.6859,  0.9763,  1.2744,  1.5605,  1.8566,
     2.1007,  2.3450,  2.6075,  2.8850,  0.2075,  0.4533,  0.7709,  1.0377,
     1.2953,  1.5132,  1.7826,  2.0351,  2.2590,  2.4996,  2.6795,  2.8748,
     0.1393,  0.2453,  0.3754,  0.5453,  0.8148,  1.1289,  1.4389,  1.7592,
     2.0353,  2.3215,  2.5934,  2.8588,  0.1250,  0.3627,  0.7613,  1.1380,
     1.4163,  1.5565,  1.6920,  1.8130,  1.8678,  2.0427,  2.4318,  2.8544,
     0.2256,  0.4223,  0.6452,  0.8599,  1.0673,  1.3118,  1.5486,  1.8366,
     2.0759,  2.3026,  2.5284,  2.8030,  0.2304,  0.4404,  0.6891,  0.8964,
     1.1510,  1.4202,  1.6483,  1.8580,  2.1181,  2.3686,  2.6078,  2.9128,
     0.2230,  0.3816,  0.5520,  0.6062,  0.7909,  1.0988,  1.4330,  1.7846,
     2.0713,  2.3457,  2.6048,  2.8708,  0.2447,  0.5800,  0.8249,  0.9905,
     1.1721,  1.3990,  1.6694,  1.9064,  2.1307,  2.4255,  2.6815,  2.9117,
     0.1974,  0.3812,  0.5802,  0.7759,  0.9280,  1.1547,  1.4170,  1.6369,
     1.8890,  2.2587,  2.5626,  2.8239,  0.1209,  0.2510,  0.4841,  0.8048,
     1.1197,  1.3563,  1.6073,  1.8926,  2.1350,  2.3669,  2.6291,  2.8985,
     0.2352,  0.4347,  0.6582,  0.8178,  0.9548,  1.1654,  1.4942,  1.8812,
     2.1703,  2.3779,  2.6412,  2.8871,  0.2091,  0.4084,  0.6730,  0.9151,
     1.1259,  1.3262,  1.5937,  1.8129,  2.0237,  2.3317,  2.5778,  2.8620,
     0.1167,  0.2406,  0.4520,  0.7298,  0.9848,  1.2448,  1.5137,  1.7874,
     2.0280,  2.3020,  2.5914,  2.8794,  0.3003,  0.4966,  0.6520,  0.8505,
     1.1600,  1.3981,  1.5805,  1.8346,  2.0757,  2.3102,  2.5760,  2.8499,
     0.2451,  0.4163,  0.5960,  0.7805,  0.9507,  1.2438,  1.5587,  1.8581,
     2.0735,  2.3198,  2.5704,  2.8220,  0.3112,  0.5517,  0.7032,  0.8528,
     1.1489,  1.4257,  1.6848,  1.9388,  2.1577,  2.4265,  2.6678,  2.9051,
     0.2249,  0.3897,  0.5559,  0.7473,  1.0158,  1.3581,  1.6914,  1.9930,
     2.1843,  2.3534,  2.5512,  2.8065,  0.2600,  0.4574,  0.7349,  0.9691,
     1.1696,  1.3848,  1.6335,  1.9021,  2.1174,  2.3481,  2.5902,  2.8390,
     0.2246,  0.3372,  0.4560,  0.5249,  0.7056,  1.0273,  1.3810,  1.7132,
     1.9819,  2.2574,  2.5410,  2.8491,  0.1419,  0.4834,  0.8835,  1.1453,
     1.2839,  1.4224,  1.5593,  1.7877,  2.1285,  2.4070,  2.6043,  2.8511,
     0.1886,  0.3677,  0.5617,  0.8099,  1.1277,  1.3841,  1.5804,  1.8136,
     2.0307,  2.2805,  2.5399,  2.8322,  0.2351,  0.4151,  0.6675,  0.8713,
     1.0464,  1.3292,  1.6586,  1.9281,  2.1355,  2.3495,  2.6222,  2.8782,
     0.2700,  0.4489,  0.6206,  0.7121,  0.7737,  0.9848,  1.3658,  1.7433,
     2.0139,  2.2243,  2.4806,  2.8175,  0.2479,  0.4425,  0.6490,  0.8745,
     1.1161,  1.3849,  1.6773,  1.9566,  2.1491,  2.3624,  2.5685,  2.8114,
     0.2035,  0.3701,  0.5567,  0.7953,  1.0082,  1.2758,  1.5373,  1.7822,
     2.0175,  2.2601,  2.4759,  2.7771,  0.1856,  0.3461,  0.5998,  0.9041,
     1.2383,  1.4612,  1.6667,  1.9305,  2.1617,  2.4107,  2.6477,  2.8656,
     0.2107,  0.3715,  0.5289,  0.6651,  0.8420,  1.1168,  1.4401,  1.7230,
     1.9901,  2.2687,  2.5452,  2.8655,  0.1218,  0.2999,  0.6348,  0.9482,
     1.2745,  1.5876,  1.9129,  2.2348,  2.4020,  2.4922,  2.6351,  2.8357,
     0.1617,  0.3483,  0.5869,  0.8163,  1.0366,  1.2344,  1.4609,  1.7029,
     1.9476,  2.2337,  2.5258,  2.8442,  0.2505,  0.4894,  0.7510,  0.9152,
     1.0845,  1.3657,  1.6528,  1.8346,  2.0160,  2.2811,  2.5338,  2.8136,
     0.0947,  0.1158,  0.0578, -0.0337, -0.0066,  0.0104, -0.0447, -0.0505,
    -0.0778, -0.0293,  0.0251, -0.0143,  0.0349, -0.0227, -0.0909,  0.0523,
     0.0325, -0.0410, -0.1045, -0.0899, -0.0009,  0.0075, -0.0575, -0.0855,
    -0.0129,  0.0575,  0.0597,  0.0391,  0.0371, -0.0184, -0.0083,  0.0287,
     0.0143,  0.0167,  0.0120, -0.0168,  0.0452,  0.0223, -0.0352,  0.0119,
    -0.0496, -0.0965, -0.0661, -0.0072,  0.1099,  0.0843, -0.0087, -0.0478,
    -0.0128, -0.0120, -0.0004,  0.0731,  0.1047,  0.0630,  0.0196, -0.0103,
    -0.0399, -0.0986, -0.0912, -0.0390, -0.0247, -0.0694, -0.0749, -0.0066,
     0.0223,  0.0634,  0.0343, -0.0134,  0.0727,  0.0241,  0.0066,  0.0437,
     0.0610,  0.0364,  0.0248, -0.0358, -0.0686, -0.0104,  0.0426,  0.0088,
    -0.0137, -0.0165,  0.0671,  0.0815, -0.0863, -0.0644, -0.0088,  0.0023,
     0.0482,  0.1174,  0.1270,  0.0594,  0.0165,  0.0949,  0.1098,  0.0137,
     0.4951,  0.4999,  0.4958,  0.4907,  0.4984,  0.4965,  0.4958,  0.4996,
     0.4987,  0.4958,  0.4986,  0.4977,  0.2841,  0.2186,  0.1474,  0.1687,
     0.2217,  0.2632,  0.2706,  0.2624,  0.2162,  0.2453,  0.2460,  0.2531,
};

static const float lsp8s[] = {
     0.2702,  0.5096,  0.6437,  0.7672,  0.9639,  1.0696,  1.2625,  1.5789,
     1.9285,  2.2383,  2.5129,  2.8470,  0.1740,  0.3677,  0.6082,  0.8387,
     1.1084,  1.3721,  1.6362,  1.8733,  2.0640,  2.3442,  2.6087,  2.8548,
     0.1536,  0.3279,  0.5143,  0.6859,  0.9763,  1.2744,  1.5605,  1.8566,
     2.1007,  2.3450,  2.6075,  2.8850,  0.2075,  0.4533,  0.7709,  1.0377,
     1.2953,  1.5132,  1.7826,  2.0351,  2.2590,  2.4996,  2.6795,  2.8748,
     0.1393,  0.2453,  0.3754,  0.5453,  0.8148,  1.1289,  1.4389,  1.7592,
     2.0353,  2.3215,  2.5934,  2.8588,  0.1250,  0.3627,  0.7613,  1.1380,
     1.4163,  1.5565,  1.6920,  1.8130,  1.8678,  2.0427,  2.4318,  2.8544,
     0.2256,  0.4223,  0.6452,  0.8599,  1.0673,  1.3118,  1.5486,  1.8366,
     2.0759,  2.3026,  2.5284,  2.8030,  0.2304,  0.4404,  0.6891,  0.8964,
     1.1510,  1.4202,  1.6483,  1.8580,  2.1181,  2.3686,  2.6078,  2.9128,
     0.2230,  0.3816,  0.5520,  0.6062,  0.7909,  1.0988,  1.4330,  1.7846,
     2.0713,  2.3457,  2.6048,  2.8708,  0.2447,  0.5800,  0.8249,  0.9905,
     1.1721,  1.3990,  1.6694,  1.9064,  2.1307,  2.4255,  2.6815,  2.9117,
     0.1974,  0.3812,  0.5802,  0.7759,  0.9280,  1.1547,  1.4170,  1.6369,
     1.8890,  2.2587,  2.5626,  2.8239,  0.1209,  0.2510,  0.4841,  0.8048,
     1.1197,  1.3563,  1.6073,  1.8926,  2.1350,  2.3669,  2.6291,  2.8985,
     0.2352,  0.4347,  0.6582,  0.8178,  0.9548,  1.1654,  1.4942,  1.8812,
     2.1703,  2.3779,  2.6412,  2.8871,  0.2091,  0.4084,  0.6730,  0.9151,
     1.1259,  1.3262,  1.5937,  1.8129,  2.0237,  2.3317,  2.5778,  2.8620,
     0.1167,  0.2406,  0.4520,  0.7298,  0.9848,  1.2448,  1.5137,  1.7874,
     2.0280,  2.3020,  2.5914,  2.8794,  0.3003,  0.4966,  0.6520,  0.8505,
     1.1600,  1.3981,  1.5805,  1.8346,  2.0757,  2.3102,  2.5760,  2.8499,
     0.2451,  0.4163,  0.5960,  0.7805,  0.9507,  1.2438,  1.5587,  1.8581,
     2.0735,  2.3198,  2.5704,  2.8220,  0.3112,  0.5517,  0.7032,  0.8528,
     1.1489,  1.4257,  1.6848,  1.9388,  2.1577,  2.4265,  2.6678,  2.9051,
     0.2249,  0.3897,  0.5559,  0.7473,  1.0158,  1.3581,  1.6914,  1.9930,
     2.1843,  2.3534,  2.5512,  2.8065,  0.2600,  0.4574,  0.7349,  0.9691,
     1.1696,  1.3848,  1.6335,  1.9021,  2.1174,  2.3481,  2.5902,  2.8390,
     0.2246,  0.3372,  0.4560,  0.5249,  0.7056,  1.0273,  1.3810,  1.7132,
     1.9819,  2.2574,  2.5410,  2.8491,  0.1419,  0.4834,  0.8835,  1.1453,
     1.2839,  1.4224,  1.5593,  1.7877,  2.1285,  2.4070,  2.6043,  2.8511,
     0.1886,  0.3677,  0.5617,  0.8099,  1.1277,  1.3841,  1.5804,  1.8136,
     2.0307,  2.2805,  2.5399,  2.8322,  0.2351,  0.4151,  0.6675,  0.8713,
     1.0464,  1.3292,  1.6586,  1.9281,  2.1355,  2.3495,  2.6222,  2.8782,
     0.2700,  0.4489,  0.6206,  0.7121,  0.7737,  0.9848,  1.3658,  1.7433,
     2.0139,  2.2243,  2.4806,  2.8175,  0.2479,  0.4425,  0.6490,  0.8745,
     1.1161,  1.3849,  1.6773,  1.9566,  2.1491,  2.3624,  2.5685,  2.8114,
     0.2035,  0.3701,  0.5567,  0.7953,  1.0082,  1.2758,  1.5373,  1.7822,
     2.0175,  2.2601,  2.4759,  2.7771,  0.1856,  0.3461,  0.5998,  0.9041,
     1.2383,  1.4612,  1.6667,  1.9305,  2.1617,  2.4107,  2.6477,  2.8656,
     0.2107,  0.3715,  0.5289,  0.6651,  0.8420,  1.1168,  1.4401,  1.7230,
     1.9901,  2.2687,  2.5452,  2.8655,  0.1218,  0.2999,  0.6348,  0.9482,
     1.2745,  1.5876,  1.9129,  2.2348,  2.4020,  2.4922,  2.6351,  2.8357,
     0.1617,  0.3483,  0.5869,  0.8163,  1.0366,  1.2344,  1.4609,  1.7029,
     1.9476,  2.2337,  2.5258,  2.8442,  0.2505,  0.4894,  0.7510,  0.9152,
     1.0845,  1.3657,  1.6528,  1.8346,  2.0160,  2.2811,  2.5338,  2.8136,
     0.0947,  0.1158,  0.0578, -0.0337, -0.0066,  0.0104, -0.0447, -0.0505,
    -0.0778, -0.0293,  0.0251, -0.0143,  0.0349, -0.0227, -0.0909,  0.0523,
     0.0325, -0.0410, -0.1045, -0.0899, -0.0009,  0.0075, -0.0575, -0.0855,
    -0.0129,  0.0575,  0.0597,  0.0391,  0.0371, -0.0184, -0.0083,  0.0287,
     0.0143,  0.0167,  0.0120, -0.0168,  0.0452,  0.0223, -0.0352,  0.0119,
    -0.0496, -0.0965, -0.0661, -0.0072,  0.1099,  0.0843, -0.0087, -0.0478,
    -0.0128, -0.0120, -0.0004,  0.0731,  0.1047,  0.0630,  0.0196, -0.0103,
    -0.0399, -0.0986, -0.0912, -0.0390, -0.0247, -0.0694, -0.0749, -0.0066,
     0.0223,  0.0634,  0.0343, -0.0134,  0.0727,  0.0241,  0.0066,  0.0437,
     0.0610,  0.0364,  0.0248, -0.0358, -0.0686, -0.0104,  0.0426,  0.0088,
    -0.0137, -0.0165,  0.0671,  0.0815, -0.0863, -0.0644, -0.0088,  0.0023,
     0.0482,  0.1174,  0.1270,  0.0594,  0.0165,  0.0949,  0.1098,  0.0137,
     0.4951,  0.4999,  0.4958,  0.4907,  0.4984,  0.4965,  0.4958,  0.4996,
     0.4987,  0.4958,  0.4986,  0.4977,  0.2841,  0.2186,  0.1474,  0.1687,
     0.2217,  0.2632,  0.2706,  0.2624,  0.2162,  0.2453,  0.2460,  0.2531,
};

static const float lsp11[] = {
     0.1103,  0.3862,  0.6863,  0.8447,  0.9231,  1.0261,  1.1248,  1.4057,
     1.6621,  1.8010,  1.8692,  2.0704,  2.3490,  2.6060,  2.7539,  2.8977,
     0.1273,  0.2407,  0.3812,  0.6004,  0.7767,  0.9383,  1.1344,  1.3351,
     1.5233,  1.7262,  1.9466,  2.1739,  2.3495,  2.5162,  2.7164,  2.9202,
     0.2010,  0.3330,  0.4488,  0.6465,  0.8046,  0.9889,  1.1479,  1.2964,
     1.4770,  1.6606,  1.8789,  2.1155,  2.3287,  2.5199,  2.7101,  2.9119,
     0.1168,  0.2197,  0.3279,  0.4691,  0.6268,  0.8251,  1.0533,  1.2714,
     1.4712,  1.6762,  1.8831,  2.1114,  2.3230,  2.5297,  2.7365,  2.9270,
     0.1405,  0.3109,  0.4986,  0.6891,  0.8634,  1.0583,  1.2594,  1.4349,
     1.6232,  1.8116,  1.9905,  2.1935,  2.3799,  2.5656,  2.7661,  2.9486,
     0.1703,  0.3057,  0.4403,  0.5225,  0.5969,  0.8110,  1.0729,  1.3215,
     1.5407,  1.7381,  1.9477,  2.1680,  2.3586,  2.5612,  2.7630,  2.9410,
     0.1128,  0.2628,  0.4523,  0.6495,  0.8176,  0.9816,  1.1746,  1.3710,
     1.5568,  1.7518,  1.9497,  2.1452,  2.3346,  2.5389,  2.7362,  2.9264,
     0.1809,  0.3287,  0.5205,  0.7264,  0.9298,  1.1217,  1.2970,  1.4894,
     1.6874,  1.8493,  2.0576,  2.2382,  2.4097,  2.6041,  2.7796,  2.9389,
     0.2502,  0.4709,  0.6892,  0.8346,  0.9209,  1.0455,  1.2399,  1.4616,
     1.6463,  1.8380,  2.0475,  2.2397,  2.4665,  2.6550,  2.7701,  2.8895,
     0.1040,  0.2340,  0.3964,  0.5740,  0.7764,  0.9941,  1.2000,  1.4014,
     1.6024,  1.7974,  1.9939,  2.1959,  2.3783,  2.5663,  2.7613,  2.9484,
     0.1912,  0.3393,  0.4743,  0.6313,  0.8014,  0.9879,  1.1855,  1.3922,
     1.5678,  1.7289,  1.9271,  2.1165,  2.3089,  2.5414,  2.7448,  2.9269,
     0.0965,  0.2025,  0.3398,  0.4990,  0.6934,  0.9386,  1.1730,  1.3766,
     1.5783,  1.7783,  1.9790,  2.1831,  2.3670,  2.5578,  2.7641,  2.9516,
     0.2126,  0.3652,  0.5545,  0.7170,  0.8674,  1.0640,  1.2558,  1.4061,
     1.5904,  1.8095,  1.9760,  2.1505,  2.3549,  2.5575,  2.7023,  2.8877,
     0.1827,  0.3426,  0.4894,  0.6488,  0.7960,  0.9535,  1.1217,  1.2798,
     1.4566,  1.6453,  1.8044,  2.0042,  2.2379,  2.4611,  2.6697,  2.8966,
     0.2034,  0.3822,  0.5231,  0.6960,  0.9200,  1.0394,  1.1616,  1.3772,
     1.5493,  1.7330,  1.9646,  2.1233,  2.3334,  2.5361,  2.7087,  2.9470,
     0.1050,  0.2060,  0.3705,  0.5998,  0.8337,  1.0577,  1.2559,  1.4327,
     1.6334,  1.8165,  1.9853,  2.2058,  2.4063,  2.5818,  2.7625,  2.9458,
     0.1419,  0.4053,  0.6660,  0.8911,  1.0405,  1.1547,  1.2506,  1.3926,
     1.5669,  1.7527,  1.9694,  2.2054,  2.3889,  2.5743,  2.7586,  2.9174,
     0.1514,  0.2825,  0.4309,  0.5772,  0.7470,  0.9703,  1.1462,  1.3316,
     1.5321,  1.7259,  1.9282,  2.1266,  2.3106,  2.5064,  2.7067,  2.9094,
     0.1693,  0.3156,  0.4878,  0.6635,  0.8206,  0.9569,  1.1154,  1.3064,
     1.5109,  1.7184,  1.9179,  2.1036,  2.2763,  2.4820,  2.6949,  2.9105,
     0.1432,  0.2718,  0.4241,  0.5564,  0.6939,  0.9011,  1.1582,  1.3948,
     1.6181,  1.8024,  1.9814,  2.1740,  2.3459,  2.5456,  2.7491,  2.9307,
     0.2294,  0.3857,  0.5590,  0.7434,  0.9189,  1.0941,  1.2740,  1.4456,
     1.6178,  1.7994,  1.9689,  2.1644,  2.3525,  2.5385,  2.7468,  2.9405,
     0.1667,  0.3109,  0.4612,  0.6032,  0.7375,  0.8866,  1.0840,  1.3053,
     1.4982,  1.7044,  1.9146,  2.1117,  2.2942,  2.4983,  2.7084,  2.9132,
     0.1810,  0.3205,  0.4696,  0.6231,  0.7641,  0.9959,  1.2427,  1.4361,
     1.5889,  1.7544,  1.9083,  2.0733,  2.2457,  2.4461,  2.6793,  2.9098,
     0.1164,  0.3753,  0.6068,  0.7503,  1.0100,  1.2131,  1.3793,  1.5302,
     1.6300,  1.7950,  1.9057,  2.1031,  2.3830,  2.5745,  2.6949,  2.8779,
     0.1571,  0.4378,  0.6735,  0.8312,  0.8944,  0.9818,  1.1622,  1.4094,
     1.6423,  1.8066,  1.9258,  2.1838,  2.4363,  2.6279,  2.7358,  2.8790,
     0.1398,  0.2686,  0.4248,  0.6156,  0.7870,  1.0035,  1.2012,  1.3689,
     1.5363,  1.7398,  1.9604,  2.1619,  2.3345,  2.5097,  2.7271,  2.9368,
     0.1913,  0.3338,  0.4987,  0.6446,  0.7852,  1.0163,  1.1886,  1.3610,
     1.5379,  1.7230,  1.8880,  2.0862,  2.2960,  2.4928,  2.7122,  2.9151,
     0.0908,  0.1752,  0.2899,  0.5365,  0.7761,  1.0100,  1.2124,  1.4060,
     1.6019,  1.8010,  1.9774,  2.1905,  2.3733,  2.5623,  2.7660,  2.9565,
     0.1773,  0.3179,  0.4925,  0.6864,  0.8452,  0.9897,  1.1860,  1.3722,
     1.5515,  1.7658,  1.9802,  2.1819,  2.3620,  2.5442,  2.7250,  2.9220,
     0.1286,  0.2341,  0.3689,  0.5364,  0.7176,  0.9350,  1.1083,  1.2943,
     1.4974,  1.7059,  1.9047,  2.1145,  2.3242,  2.5361,  2.7453,  2.9329,
     0.2273,  0.3834,  0.5565,  0.7192,  0.8431,  0.9962,  1.1763,  1.3571,
     1.5774,  1.7419,  1.9202,  2.1131,  2.2919,  2.4898,  2.6895,  2.9180,
     0.1775,  0.3058,  0.4274,  0.6023,  0.8151,  1.0734,  1.3211,  1.5178,
     1.6706,  1.8154,  1.9686,  2.1537,  2.3461,  2.5276,  2.7181,  2.9121,
     0.1653,  0.4304,  0.6361,  0.7824,  0.9183,  1.0452,  1.2071,  1.4077,
     1.6206,  1.8299,  2.0089,  2.1948,  2.3900,  2.5982,  2.7844,  2.9487,
     0.1492,  0.2609,  0.3820,  0.5485,  0.7243,  0.9319,  1.1538,  1.3579,
     1.5266,  1.7002,  1.8873,  2.1016,  2.3175,  2.5221,  2.7241,  2.9243,
     0.2074,  0.3781,  0.5209,  0.6869,  0.8577,  0.9875,  1.1849,  1.3568,
     1.4907,  1.7335,  1.8902,  2.1224,  2.3099,  2.4918,  2.7023,  2.8765,
     0.1359,  0.2254,  0.3286,  0.4432,  0.6586,  0.8964,  1.1125,  1.3523,
     1.5626,  1.7579,  1.9846,  2.1905,  2.3548,  2.5542,  2.7663,  2.9346,
     0.1430,  0.2966,  0.4685,  0.6493,  0.8315,  1.0304,  1.2220,  1.4082,
     1.5995,  1.7888,  1.9774,  2.1737,  2.3607,  2.5577,  2.7558,  2.9405,
     0.1477,  0.2694,  0.4056,  0.5626,  0.7051,  0.8647,  1.0491,  1.2488,
     1.4814,  1.7072,  1.9150,  2.1147,  2.3038,  2.5144,  2.7184,  2.9202,
     0.1690,  0.3033,  0.4580,  0.6686,  0.8536,  1.0293,  1.2124,  1.3998,
     1.5718,  1.7607,  1.9580,  2.1245,  2.2971,  2.4762,  2.6896,  2.9177,
     0.1092,  0.2779,  0.4853,  0.6880,  0.9011,  1.0953,  1.2752,  1.4618,
     1.6623,  1.8484,  2.0264,  2.2152,  2.4017,  2.5835,  2.7671,  2.9436,
     0.1497,  0.3637,  0.6014,  0.8032,  0.9963,  1.1835,  1.3741,  1.5698,
     1.7382,  1.9094,  2.0710,  2.2392,  2.4082,  2.5926,  2.7762,  2.9536,
     0.1434,  0.2492,  0.3966,  0.5934,  0.8033,  1.0657,  1.2796,  1.4276,
     1.5745,  1.7833,  1.9288,  2.1247,  2.3543,  2.5412,  2.7049,  2.8872,
     0.1612,  0.2926,  0.4574,  0.6387,  0.8265,  1.0180,  1.1808,  1.3526,
     1.5564,  1.7536,  1.9187,  2.1192,  2.3149,  2.5006,  2.7101,  2.9217,
     0.0828,  0.1863,  0.3235,  0.5050,  0.7250,  0.9867,  1.2093,  1.3941,
     1.5980,  1.7932,  1.9809,  2.1894,  2.3918,  2.5773,  2.7540,  2.9329,
     0.2001,  0.3655,  0.5290,  0.6761,  0.8027,  0.9972,  1.2090,  1.4255,
     1.6085,  1.7825,  1.9804,  2.1681,  2.3457,  2.5325,  2.7319,  2.9196,
     0.1505,  0.2767,  0.4254,  0.6054,  0.7821,  0.9567,  1.1294,  1.3080,
     1.4984,  1.6954,  1.8666,  2.0736,  2.2875,  2.4969,  2.7072,  2.9163,
     0.1589,  0.4151,  0.5749,  0.6651,  0.8061,  1.0470,  1.2616,  1.3690,
     1.4985,  1.7808,  1.9825,  2.1068,  2.2751,  2.5448,  2.7133,  2.8689,
     0.0916,  0.1846,  0.3788,  0.6329,  0.8774,  1.0687,  1.2653,  1.4561,
     1.6573,  1.8449,  2.0402,  2.2254,  2.3968,  2.5861,  2.7792,  2.9508,
     0.2282,  0.4159,  0.5834,  0.6899,  0.8108,  1.0321,  1.2795,  1.5262,
     1.6936,  1.8469,  2.0922,  2.2607,  2.3795,  2.5301,  2.7386,  2.9530,
     0.1651,  0.3004,  0.4555,  0.6179,  0.7891,  0.9584,  1.1372,  1.3707,
     1.5951,  1.7880,  1.9434,  2.1465,  2.3311,  2.5081,  2.6977,  2.8970,
     0.1279,  0.3828,  0.6330,  0.8323,  0.9652,  1.1175,  1.2319,  1.3511,
     1.5115,  1.6392,  1.7835,  1.9558,  2.2008,  2.4635,  2.6910,  2.9058,
     0.1193,  0.2185,  0.3521,  0.5311,  0.7378,  0.9239,  1.1105,  1.3217,
     1.5362,  1.7504,  1.9536,  2.1627,  2.3560,  2.5506,  2.7548,  2.9453,
     0.1806,  0.3432,  0.4981,  0.6948,  0.8928,  1.0527,  1.2467,  1.4140,
     1.6326,  1.7950,  1.9935,  2.1969,  2.3512,  2.5682,  2.7445,  2.9277,
     0.1846,  0.3112,  0.4568,  0.5891,  0.7317,  0.8493,  1.0204,  1.2022,
     1.3688,  1.6020,  1.8428,  2.0710,  2.2725,  2.4879,  2.7057,  2.9160,
     0.0880,  0.2514,  0.5332,  0.7272,  0.8906,  1.1354,  1.3199,  1.4941,
     1.6010,  1.7151,  1.8712,  2.0643,  2.2755,  2.5375,  2.7054,  2.8891,
     0.1382,  0.2833,  0.4658,  0.6897,  0.9071,  1.0716,  1.2469,  1.4143,
     1.5910,  1.7947,  1.9805,  2.1581,  2.3338,  2.5215,  2.7292,  2.9211,
     0.1061,  0.3494,  0.6327,  0.8570,  0.9748,  1.0560,  1.1529,  1.3250,
     1.6032,  1.8340,  1.9711,  2.1157,  2.3011,  2.5464,  2.8078,  2.9803,
     0.1603,  0.2839,  0.4307,  0.5980,  0.7980,  1.0399,  1.1971,  1.3524,
     1.5715,  1.7838,  1.9468,  2.1498,  2.3627,  2.5514,  2.7327,  2.9148,
     0.1691,  0.3117,  0.4796,  0.6895,  0.8732,  1.0164,  1.1916,  1.3707,
     1.5384,  1.7202,  1.8857,  2.0672,  2.2487,  2.4593,  2.6789,  2.8940,
     0.0965,  0.1702,  0.3191,  0.5721,  0.8100,  1.0241,  1.2272,  1.4196,
     1.6093,  1.8057,  1.9884,  2.2037,  2.3925,  2.5805,  2.7578,  2.9366,
     0.1950,  0.3519,  0.5272,  0.6973,  0.8732,  1.0656,  1.2112,  1.3959,
     1.6116,  1.7821,  1.9445,  2.1592,  2.3348,  2.5142,  2.7440,  2.9297,
     0.1388,  0.2557,  0.4120,  0.5727,  0.7354,  0.9196,  1.0985,  1.2805,
     1.4643,  1.6535,  1.8340,  2.0546,  2.2758,  2.4778,  2.6921,  2.9122,
     0.1823,  0.3336,  0.4957,  0.6771,  0.8563,  1.0137,  1.2299,  1.3849,
     1.5718,  1.7667,  1.9193,  2.1326,  2.3135,  2.5268,  2.7133,  2.8998,
     0.0790,  0.1901,  0.4083,  0.6456,  0.8463,  1.0285,  1.2297,  1.4181,
     1.6159,  1.8056,  1.9971,  2.1912,  2.3816,  2.5746,  2.7692,  2.9497,
     0.0049,  0.0116,  0.0045,  0.0039, -0.0010, -0.0122, -0.0205, -0.0034,
    -0.0140, -0.0041,  0.0191, -0.0322,  0.0002, -0.0124, -0.0269,  0.0059,
     0.0586,  0.0339, -0.0389, -0.0319, -0.0079, -0.0205, -0.0363, -0.0211,
     0.0241,  0.0595,  0.0469,  0.0283,  0.0176, -0.0183, -0.0173, -0.0004,
     0.0024,  0.0145,  0.0534,  0.0197, -0.0065, -0.0067,  0.0133,  0.0358,
    -0.0104, -0.0386, -0.0109, -0.0078,  0.0275,  0.0565,  0.0251, -0.0027,
    -0.0053,  0.0171,  0.0088,  0.0495,  0.0141,  0.0039, -0.0445, -0.0426,
    -0.0184, -0.0280, -0.0223,  0.0039, -0.0171, -0.0606, -0.0786, -0.0430,
     0.0544,  0.0595,  0.0320, -0.0012,  0.0108,  0.0185,  0.0066,  0.0408,
     0.0552, -0.0073, -0.0247, -0.0480, -0.0288,  0.0186,  0.0212, -0.0013,
     0.0403,  0.0598,  0.0690,  0.0516, -0.0298, -0.0177,  0.0278,  0.0168,
    -0.0106,  0.0251,  0.0386,  0.0331, -0.0052,  0.0133,  0.0291, -0.0158,
    -0.0329, -0.0367,  0.0287,  0.0462, -0.0176,  0.0049,  0.0242, -0.0034,
     0.0135,  0.0086, -0.0149,  0.0241,  0.0504,  0.0246, -0.0273, -0.0369,
    -0.0108, -0.0449, -0.0625, -0.0414, -0.0292, -0.0571, -0.0440, -0.0088,
     0.0098,  0.0009, -0.0004,  0.0007, -0.0314, -0.0208, -0.0138, -0.0277,
    -0.0044,  0.0522,  0.0315, -0.0270, -0.0277, -0.0256, -0.0103, -0.0201,
    -0.0287, -0.0279, -0.0182,  0.0472,  0.0613,  0.0450,  0.0413,  0.0333,
     0.0444,  0.0223,  0.0061,  0.0316,  0.0321,  0.0501,  0.0460,  0.0250,
     0.0227,  0.0235,  0.0099,  0.0185, -0.0347, -0.0684, -0.0189,  0.0242,
    -0.0190, -0.0273, -0.0012, -0.0253,  0.0293, -0.0231, -0.0219, -0.0010,
     0.0153,  0.0128, -0.0166, -0.0435, -0.0417, -0.0121, -0.0351, -0.0390,
     0.0077, -0.0278, -0.0355,  0.0092, -0.0063,  0.0005,  0.0216,  0.0461,
     0.0538,  0.0451,  0.0298, -0.0130,  0.0058,  0.0206,  0.0471,  0.0499,
     0.0280,  0.0086, -0.0007, -0.0317,  0.0259,  0.0176,  0.0043,  0.0212,
     0.0138,  0.0106,  0.0220, -0.0025,  0.0050,  0.0122, -0.0051, -0.0086,
    -0.0472, -0.0005,  0.0193,  0.0032,  0.0246,  0.0222,  0.0090, -0.0320,
    -0.0713, -0.0526, -0.0151, -0.0440, -0.0648, -0.0466, -0.0092,  0.0115,
    -0.0129,  0.0053, -0.0344, -0.0385,  0.0392,  0.0599,  0.0414,  0.0165,
    -0.0098, -0.0320, -0.0261, -0.0055, -0.0139, -0.0110,  0.0084,  0.0172,
    -0.0492, -0.0537, -0.0320, -0.0036,  0.0265,  0.0385,  0.0064, -0.0280,
    -0.0230,  0.0134,  0.0241,  0.0106,  0.0387,  0.0105,  0.0068,  0.0260,
     0.4940,  0.4911,  0.4849,  0.4820,  0.4837,  0.4839,  0.4824,  0.4799,
     0.4812,  0.4782,  0.4788,  0.4711,  0.4706,  0.4671,  0.4601,  0.4578,
     0.2954,  0.2121,  0.1859,  0.1958,  0.1474,  0.1086,  0.1351,  0.1362,
     0.1486,  0.1342,  0.1215,  0.1423,  0.1634,  0.1588,  0.1539,  0.1857,
};

static const float lsp11s[] = {
     0.1103,  0.3862,  0.6863,  0.8447,  0.9231,  1.0261,  1.1248,  1.4057,
     1.6621,  1.8010,  1.8692,  2.0704,  2.3490,  2.6060,  2.7539,  2.8977,
     0.1273,  0.2407,  0.3812,  0.6004,  0.7767,  0.9383,  1.1344,  1.3351,
     1.5233,  1.7262,  1.9466,  2.1739,  2.3495,  2.5162,  2.7164,  2.9202,
     0.2010,  0.3330,  0.4488,  0.6465,  0.8046,  0.9889,  1.1479,  1.2964,
     1.4770,  1.6606,  1.8789,  2.1155,  2.3287,  2.5199,  2.7101,  2.9119,
     0.1168,  0.2197,  0.3279,  0.4691,  0.6268,  0.8251,  1.0533,  1.2714,
     1.4712,  1.6762,  1.8831,  2.1114,  2.3230,  2.5297,  2.7365,  2.9270,
     0.1405,  0.3109,  0.4986,  0.6891,  0.8634,  1.0583,  1.2594,  1.4349,
     1.6232,  1.8116,  1.9905,  2.1935,  2.3799,  2.5656,  2.7661,  2.9486,
     0.1703,  0.3057,  0.4403,  0.5225,  0.5969,  0.8110,  1.0729,  1.3215,
     1.5407,  1.7381,  1.9477,  2.1680,  2.3586,  2.5612,  2.7630,  2.9410,
     0.1128,  0.2628,  0.4523,  0.6495,  0.8176,  0.9816,  1.1746,  1.3710,
     1.5568,  1.7518,  1.9497,  2.1452,  2.3346,  2.5389,  2.7362,  2.9264,
     0.1809,  0.3287,  0.5205,  0.7264,  0.9298,  1.1217,  1.2970,  1.4894,
     1.6874,  1.8493,  2.0576,  2.2382,  2.4097,  2.6041,  2.7796,  2.9389,
     0.2502,  0.4709,  0.6892,  0.8346,  0.9209,  1.0455,  1.2399,  1.4616,
     1.6463,  1.8380,  2.0475,  2.2397,  2.4665,  2.6550,  2.7701,  2.8895,
     0.1040,  0.2340,  0.3964,  0.5740,  0.7764,  0.9941,  1.2000,  1.4014,
     1.6024,  1.7974,  1.9939,  2.1959,  2.3783,  2.5663,  2.7613,  2.9484,
     0.1912,  0.3393,  0.4743,  0.6313,  0.8014,  0.9879,  1.1855,  1.3922,
     1.5678,  1.7289,  1.9271,  2.1165,  2.3089,  2.5414,  2.7448,  2.9269,
     0.0965,  0.2025,  0.3398,  0.4990,  0.6934,  0.9386,  1.1730,  1.3766,
     1.5783,  1.7783,  1.9790,  2.1831,  2.3670,  2.5578,  2.7641,  2.9516,
     0.2126,  0.3652,  0.5545,  0.7170,  0.8674,  1.0640,  1.2558,  1.4061,
     1.5904,  1.8095,  1.9760,  2.1505,  2.3549,  2.5575,  2.7023,  2.8877,
     0.1827,  0.3426,  0.4894,  0.6488,  0.7960,  0.9535,  1.1217,  1.2798,
     1.4566,  1.6453,  1.8044,  2.0042,  2.2379,  2.4611,  2.6697,  2.8966,
     0.2034,  0.3822,  0.5231,  0.6960,  0.9200,  1.0394,  1.1616,  1.3772,
     1.5493,  1.7330,  1.9646,  2.1233,  2.3334,  2.5361,  2.7087,  2.9470,
     0.1050,  0.2060,  0.3705,  0.5998,  0.8337,  1.0577,  1.2559,  1.4327,
     1.6334,  1.8165,  1.9853,  2.2058,  2.4063,  2.5818,  2.7625,  2.9458,
     0.1419,  0.4053,  0.6660,  0.8911,  1.0405,  1.1547,  1.2506,  1.3926,
     1.5669,  1.7527,  1.9694,  2.2054,  2.3889,  2.5743,  2.7586,  2.9174,
     0.1514,  0.2825,  0.4309,  0.5772,  0.7470,  0.9703,  1.1462,  1.3316,
     1.5321,  1.7259,  1.9282,  2.1266,  2.3106,  2.5064,  2.7067,  2.9094,
     0.1693,  0.3156,  0.4878,  0.6635,  0.8206,  0.9569,  1.1154,  1.3064,
     1.5109,  1.7184,  1.9179,  2.1036,  2.2763,  2.4820,  2.6949,  2.9105,
     0.1432,  0.2718,  0.4241,  0.5564,  0.6939,  0.9011,  1.1582,  1.3948,
     1.6181,  1.8024,  1.9814,  2.1740,  2.3459,  2.5456,  2.7491,  2.9307,
     0.2294,  0.3857,  0.5590,  0.7434,  0.9189,  1.0941,  1.2740,  1.4456,
     1.6178,  1.7994,  1.9689,  2.1644,  2.3525,  2.5385,  2.7468,  2.9405,
     0.1667,  0.3109,  0.4612,  0.6032,  0.7375,  0.8866,  1.0840,  1.3053,
     1.4982,  1.7044,  1.9146,  2.1117,  2.2942,  2.4983,  2.7084,  2.9132,
     0.1810,  0.3205,  0.4696,  0.6231,  0.7641,  0.9959,  1.2427,  1.4361,
     1.5889,  1.7544,  1.9083,  2.0733,  2.2457,  2.4461,  2.6793,  2.9098,
     0.1164,  0.3753,  0.6068,  0.7503,  1.0100,  1.2131,  1.3793,  1.5302,
     1.6300,  1.7950,  1.9057,  2.1031,  2.3830,  2.5745,  2.6949,  2.8779,
     0.1571,  0.4378,  0.6735,  0.8312,  0.8944,  0.9818,  1.1622,  1.4094,
     1.6423,  1.8066,  1.9258,  2.1838,  2.4363,  2.6279,  2.7358,  2.8790,
     0.1398,  0.2686,  0.4248,  0.6156,  0.7870,  1.0035,  1.2012,  1.3689,
     1.5363,  1.7398,  1.9604,  2.1619,  2.3345,  2.5097,  2.7271,  2.9368,
     0.1913,  0.3338,  0.4987,  0.6446,  0.7852,  1.0163,  1.1886,  1.3610,
     1.5379,  1.7230,  1.8880,  2.0862,  2.2960,  2.4928,  2.7122,  2.9151,
     0.0908,  0.1752,  0.2899,  0.5365,  0.7761,  1.0100,  1.2124,  1.4060,
     1.6019,  1.8010,  1.9774,  2.1905,  2.3733,  2.5623,  2.7660,  2.9565,
     0.1773,  0.3179,  0.4925,  0.6864,  0.8452,  0.9897,  1.1860,  1.3722,
     1.5515,  1.7658,  1.9802,  2.1819,  2.3620,  2.5442,  2.7250,  2.9220,
     0.1286,  0.2341,  0.3689,  0.5364,  0.7176,  0.9350,  1.1083,  1.2943,
     1.4974,  1.7059,  1.9047,  2.1145,  2.3242,  2.5361,  2.7453,  2.9329,
     0.2273,  0.3834,  0.5565,  0.7192,  0.8431,  0.9962,  1.1763,  1.3571,
     1.5774,  1.7419,  1.9202,  2.1131,  2.2919,  2.4898,  2.6895,  2.9180,
     0.1775,  0.3058,  0.4274,  0.6023,  0.8151,  1.0734,  1.3211,  1.5178,
     1.6706,  1.8154,  1.9686,  2.1537,  2.3461,  2.5276,  2.7181,  2.9121,
     0.1653,  0.4304,  0.6361,  0.7824,  0.9183,  1.0452,  1.2071,  1.4077,
     1.6206,  1.8299,  2.0089,  2.1948,  2.3900,  2.5982,  2.7844,  2.9487,
     0.1492,  0.2609,  0.3820,  0.5485,  0.7243,  0.9319,  1.1538,  1.3579,
     1.5266,  1.7002,  1.8873,  2.1016,  2.3175,  2.5221,  2.7241,  2.9243,
     0.2074,  0.3781,  0.5209,  0.6869,  0.8577,  0.9875,  1.1849,  1.3568,
     1.4907,  1.7335,  1.8902,  2.1224,  2.3099,  2.4918,  2.7023,  2.8765,
     0.1359,  0.2254,  0.3286,  0.4432,  0.6586,  0.8964,  1.1125,  1.3523,
     1.5626,  1.7579,  1.9846,  2.1905,  2.3548,  2.5542,  2.7663,  2.9346,
     0.1430,  0.2966,  0.4685,  0.6493,  0.8315,  1.0304,  1.2220,  1.4082,
     1.5995,  1.7888,  1.9774,  2.1737,  2.3607,  2.5577,  2.7558,  2.9405,
     0.1477,  0.2694,  0.4056,  0.5626,  0.7051,  0.8647,  1.0491,  1.2488,
     1.4814,  1.7072,  1.9150,  2.1147,  2.3038,  2.5144,  2.7184,  2.9202,
     0.1690,  0.3033,  0.4580,  0.6686,  0.8536,  1.0293,  1.2124,  1.3998,
     1.5718,  1.7607,  1.9580,  2.1245,  2.2971,  2.4762,  2.6896,  2.9177,
     0.1092,  0.2779,  0.4853,  0.6880,  0.9011,  1.0953,  1.2752,  1.4618,
     1.6623,  1.8484,  2.0264,  2.2152,  2.4017,  2.5835,  2.7671,  2.9436,
     0.1497,  0.3637,  0.6014,  0.8032,  0.9963,  1.1835,  1.3741,  1.5698,
     1.7382,  1.9094,  2.0710,  2.2392,  2.4082,  2.5926,  2.7762,  2.9536,
     0.1434,  0.2492,  0.3966,  0.5934,  0.8033,  1.0657,  1.2796,  1.4276,
     1.5745,  1.7833,  1.9288,  2.1247,  2.3543,  2.5412,  2.7049,  2.8872,
     0.1612,  0.2926,  0.4574,  0.6387,  0.8265,  1.0180,  1.1808,  1.3526,
     1.5564,  1.7536,  1.9187,  2.1192,  2.3149,  2.5006,  2.7101,  2.9217,
     0.0828,  0.1863,  0.3235,  0.5050,  0.7250,  0.9867,  1.2093,  1.3941,
     1.5980,  1.7932,  1.9809,  2.1894,  2.3918,  2.5773,  2.7540,  2.9329,
     0.2001,  0.3655,  0.5290,  0.6761,  0.8027,  0.9972,  1.2090,  1.4255,
     1.6085,  1.7825,  1.9804,  2.1681,  2.3457,  2.5325,  2.7319,  2.9196,
     0.1505,  0.2767,  0.4254,  0.6054,  0.7821,  0.9567,  1.1294,  1.3080,
     1.4984,  1.6954,  1.8666,  2.0736,  2.2875,  2.4969,  2.7072,  2.9163,
     0.1589,  0.4151,  0.5749,  0.6651,  0.8061,  1.0470,  1.2616,  1.3690,
     1.4985,  1.7808,  1.9825,  2.1068,  2.2751,  2.5448,  2.7133,  2.8689,
     0.0916,  0.1846,  0.3788,  0.6329,  0.8774,  1.0687,  1.2653,  1.4561,
     1.6573,  1.8449,  2.0402,  2.2254,  2.3968,  2.5861,  2.7792,  2.9508,
     0.2282,  0.4159,  0.5834,  0.6899,  0.8108,  1.0321,  1.2795,  1.5262,
     1.6936,  1.8469,  2.0922,  2.2607,  2.3795,  2.5301,  2.7386,  2.9530,
     0.1651,  0.3004,  0.4555,  0.6179,  0.7891,  0.9584,  1.1372,  1.3707,
     1.5951,  1.7880,  1.9434,  2.1465,  2.3311,  2.5081,  2.6977,  2.8970,
     0.1279,  0.3828,  0.6330,  0.8323,  0.9652,  1.1175,  1.2319,  1.3511,
     1.5115,  1.6392,  1.7835,  1.9558,  2.2008,  2.4635,  2.6910,  2.9058,
     0.1193,  0.2185,  0.3521,  0.5311,  0.7378,  0.9239,  1.1105,  1.3217,
     1.5362,  1.7504,  1.9536,  2.1627,  2.3560,  2.5506,  2.7548,  2.9453,
     0.1806,  0.3432,  0.4981,  0.6948,  0.8928,  1.0527,  1.2467,  1.4140,
     1.6326,  1.7950,  1.9935,  2.1969,  2.3512,  2.5682,  2.7445,  2.9277,
     0.1846,  0.3112,  0.4568,  0.5891,  0.7317,  0.8493,  1.0204,  1.2022,
     1.3688,  1.6020,  1.8428,  2.0710,  2.2725,  2.4879,  2.7057,  2.9160,
     0.0880,  0.2514,  0.5332,  0.7272,  0.8906,  1.1354,  1.3199,  1.4941,
     1.6010,  1.7151,  1.8712,  2.0643,  2.2755,  2.5375,  2.7054,  2.8891,
     0.1382,  0.2833,  0.4658,  0.6897,  0.9071,  1.0716,  1.2469,  1.4143,
     1.5910,  1.7947,  1.9805,  2.1581,  2.3338,  2.5215,  2.7292,  2.9211,
     0.1061,  0.3494,  0.6327,  0.8570,  0.9748,  1.0560,  1.1529,  1.3250,
     1.6032,  1.8340,  1.9711,  2.1157,  2.3011,  2.5464,  2.8078,  2.9803,
     0.1603,  0.2839,  0.4307,  0.5980,  0.7980,  1.0399,  1.1971,  1.3524,
     1.5715,  1.7838,  1.9468,  2.1498,  2.3627,  2.5514,  2.7327,  2.9148,
     0.1691,  0.3117,  0.4796,  0.6895,  0.8732,  1.0164,  1.1916,  1.3707,
     1.5384,  1.7202,  1.8857,  2.0672,  2.2487,  2.4593,  2.6789,  2.8940,
     0.0965,  0.1702,  0.3191,  0.5721,  0.8100,  1.0241,  1.2272,  1.4196,
     1.6093,  1.8057,  1.9884,  2.2037,  2.3925,  2.5805,  2.7578,  2.9366,
     0.1950,  0.3519,  0.5272,  0.6973,  0.8732,  1.0656,  1.2112,  1.3959,
     1.6116,  1.7821,  1.9445,  2.1592,  2.3348,  2.5142,  2.7440,  2.9297,
     0.1388,  0.2557,  0.4120,  0.5727,  0.7354,  0.9196,  1.0985,  1.2805,
     1.4643,  1.6535,  1.8340,  2.0546,  2.2758,  2.4778,  2.6921,  2.9122,
     0.1823,  0.3336,  0.4957,  0.6771,  0.8563,  1.0137,  1.2299,  1.3849,
     1.5718,  1.7667,  1.9193,  2.1326,  2.3135,  2.5268,  2.7133,  2.8998,
     0.0790,  0.1901,  0.4083,  0.6456,  0.8463,  1.0285,  1.2297,  1.4181,
     1.6159,  1.8056,  1.9971,  2.1912,  2.3816,  2.5746,  2.7692,  2.9497,
     0.0049,  0.0116,  0.0045,  0.0039, -0.0010, -0.0122, -0.0205, -0.0034,
    -0.0140, -0.0041,  0.0191, -0.0322,  0.0002, -0.0124, -0.0269,  0.0059,
     0.0586,  0.0339, -0.0389, -0.0319, -0.0079, -0.0205, -0.0363, -0.0211,
     0.0241,  0.0595,  0.0469,  0.0283,  0.0176, -0.0183, -0.0173, -0.0004,
     0.0024,  0.0145,  0.0534,  0.0197, -0.0065, -0.0067,  0.0133,  0.0358,
    -0.0104, -0.0386, -0.0109, -0.0078,  0.0275,  0.0565,  0.0251, -0.0027,
    -0.0053,  0.0171,  0.0088,  0.0495,  0.0141,  0.0039, -0.0445, -0.0426,
    -0.0184, -0.0280, -0.0223,  0.0039, -0.0171, -0.0606, -0.0786, -0.0430,
     0.0544,  0.0595,  0.0320, -0.0012,  0.0108,  0.0185,  0.0066,  0.0408,
     0.0552, -0.0073, -0.0247, -0.0480, -0.0288,  0.0186,  0.0212, -0.0013,
     0.0403,  0.0598,  0.0690,  0.0516, -0.0298, -0.0177,  0.0278,  0.0168,
    -0.0106,  0.0251,  0.0386,  0.0331, -0.0052,  0.0133,  0.0291, -0.0158,
    -0.0329, -0.0367,  0.0287,  0.0462, -0.0176,  0.0049,  0.0242, -0.0034,
     0.0135,  0.0086, -0.0149,  0.0241,  0.0504,  0.0246, -0.0273, -0.0369,
    -0.0108, -0.0449, -0.0625, -0.0414, -0.0292, -0.0571, -0.0440, -0.0088,
     0.0098,  0.0009, -0.0004,  0.0007, -0.0314, -0.0208, -0.0138, -0.0277,
    -0.0044,  0.0522,  0.0315, -0.0270, -0.0277, -0.0256, -0.0103, -0.0201,
    -0.0287, -0.0279, -0.0182,  0.0472,  0.0613,  0.0450,  0.0413,  0.0333,
     0.0444,  0.0223,  0.0061,  0.0316,  0.0321,  0.0501,  0.0460,  0.0250,
     0.0227,  0.0235,  0.0099,  0.0185, -0.0347, -0.0684, -0.0189,  0.0242,
    -0.0190, -0.0273, -0.0012, -0.0253,  0.0293, -0.0231, -0.0219, -0.0010,
     0.0153,  0.0128, -0.0166, -0.0435, -0.0417, -0.0121, -0.0351, -0.0390,
     0.0077, -0.0278, -0.0355,  0.0092, -0.0063,  0.0005,  0.0216,  0.0461,
     0.0538,  0.0451,  0.0298, -0.0130,  0.0058,  0.0206,  0.0471,  0.0499,
     0.0280,  0.0086, -0.0007, -0.0317,  0.0259,  0.0176,  0.0043,  0.0212,
     0.0138,  0.0106,  0.0220, -0.0025,  0.0050,  0.0122, -0.0051, -0.0086,
    -0.0472, -0.0005,  0.0193,  0.0032,  0.0246,  0.0222,  0.0090, -0.0320,
    -0.0713, -0.0526, -0.0151, -0.0440, -0.0648, -0.0466, -0.0092,  0.0115,
    -0.0129,  0.0053, -0.0344, -0.0385,  0.0392,  0.0599,  0.0414,  0.0165,
    -0.0098, -0.0320, -0.0261, -0.0055, -0.0139, -0.0110,  0.0084,  0.0172,
    -0.0492, -0.0537, -0.0320, -0.0036,  0.0265,  0.0385,  0.0064, -0.0280,
    -0.0230,  0.0134,  0.0241,  0.0106,  0.0387,  0.0105,  0.0068,  0.0260,
     0.4940,  0.4911,  0.4849,  0.4820,  0.4837,  0.4839,  0.4824,  0.4799,
     0.4812,  0.4782,  0.4788,  0.4711,  0.4706,  0.4671,  0.4601,  0.4578,
     0.2954,  0.2121,  0.1859,  0.1958,  0.1474,  0.1086,  0.1351,  0.1362,
     0.1486,  0.1342,  0.1215,  0.1423,  0.1634,  0.1588,  0.1539,  0.1857,
};

static const float lsp16[] = {
     0.1813,  0.3911,  0.6301,  0.8012,  1.0057,  1.2041,  1.4271,  1.6943,
     1.9402,  2.1733,  2.3521,  2.4989,  2.5839,  2.6846,  2.7634,  2.8950,
     0.1311,  0.3183,  0.4659,  0.5601,  0.6658,  0.7828,  1.0065,  1.2717,
     1.5185,  1.7339,  1.9530,  2.2189,  2.3739,  2.4991,  2.6984,  2.9256,
     0.1627,  0.4519,  0.6323,  0.7012,  0.7848,  0.9801,  1.1810,  1.3222,
     1.5413,  1.8129,  1.9338,  2.0809,  2.3180,  2.5189,  2.7066,  2.9514,
     0.1475,  0.2447,  0.4240,  0.5669,  0.7872,  0.9838,  1.1823,  1.3814,
     1.5358,  1.6820,  1.8794,  2.1419,  2.4132,  2.6112,  2.7911,  2.9511,
     0.1224,  0.2876,  0.5013,  0.6985,  0.8902,  1.0901,  1.2835,  1.4768,
     1.6596,  1.8538,  2.0467,  2.2304,  2.4124,  2.5942,  2.7729,  2.9531,
     0.1741,  0.3034,  0.4677,  0.5879,  0.7258,  0.9648,  1.1417,  1.3220,
     1.5081,  1.7151,  1.9212,  2.1286,  2.3208,  2.4938,  2.6765,  2.8891,
     0.1657,  0.3174,  0.4907,  0.6559,  0.8295,  1.0254,  1.2071,  1.3880,
     1.5737,  1.7845,  1.9027,  2.1139,  2.3323,  2.5157,  2.7323,  2.9015,
     0.1592,  0.2758,  0.4417,  0.6315,  0.8257,  0.9873,  1.1277,  1.2830,
     1.4337,  1.6315,  1.8899,  2.1356,  2.3572,  2.5632,  2.7468,  2.9420,
     0.1524,  0.4325,  0.5931,  0.7036,  0.7696,  0.8923,  1.1739,  1.4773,
     1.6609,  1.7911,  1.9666,  2.1972,  2.3754,  2.5045,  2.6613,  2.8882,
     0.2130,  0.3013,  0.3721,  0.4257,  0.5079,  0.7015,  0.9815,  1.2554,
     1.4648,  1.6966,  1.9138,  2.1075,  2.3318,  2.5292,  2.7453,  2.9347,
     0.1142,  0.3748,  0.6205,  0.7642,  0.8121,  0.9022,  0.9843,  1.1558,
     1.4467,  1.7422,  1.9574,  2.1302,  2.3812,  2.5898,  2.7720,  2.9583,
     0.1255,  0.2339,  0.3570,  0.5323,  0.7458,  1.0003,  1.1729,  1.3567,
     1.5217,  1.6977,  1.8924,  2.0942,  2.3145,  2.5408,  2.7553,  2.9337,
     0.1316,  0.2289,  0.4327,  0.6663,  0.8509,  0.9994,  1.1697,  1.3804,
     1.5609,  1.6903,  1.8572,  2.1019,  2.3687,  2.5789,  2.7715,  2.9472,
     0.1502,  0.2546,  0.3883,  0.5333,  0.6976,  0.9163,  1.1071,  1.3364,
     1.5420,  1.7525,  1.8948,  2.0839,  2.2819,  2.4651,  2.6875,  2.8987,
     0.1593,  0.3014,  0.4573,  0.6354,  0.8157,  0.9805,  1.1783,  1.3747,
     1.5678,  1.7326,  1.9286,  2.1340,  2.3253,  2.5280,  2.7180,  2.9298,
     0.1811,  0.3167,  0.4655,  0.6507,  0.8198,  1.0075,  1.1892,  1.3743,
     1.5227,  1.7090,  1.8849,  2.0743,  2.2750,  2.4830,  2.6896,  2.8953,
     0.1846,  0.3577,  0.5315,  0.7290,  0.9176,  1.1016,  1.2654,  1.4525,
     1.6315,  1.8268,  2.0238,  2.1934,  2.3868,  2.5753,  2.7682,  2.9469,
     0.0876,  0.1439,  0.2048,  0.3654,  0.6281,  0.8853,  1.0907,  1.2992,
     1.5227,  1.7373,  1.9395,  2.1419,  2.3488,  2.5486,  2.7466,  2.9348,
     0.1391,  0.4170,  0.6561,  0.7953,  0.8734,  0.9986,  1.1870,  1.4520,
     1.6042,  1.7910,  2.0135,  2.1870,  2.3358,  2.5066,  2.7409,  2.9955,
     0.0804,  0.1355,  0.2599,  0.4998,  0.7408,  0.9474,  1.1276,  1.3428,
     1.5556,  1.7712,  1.9699,  2.1535,  2.3605,  2.5548,  2.7489,  2.9325,
     0.1304,  0.3087,  0.4979,  0.6584,  0.8414,  1.0329,  1.2244,  1.4189,
     1.6118,  1.8200,  1.9985,  2.1893,  2.3915,  2.5794,  2.7647,  2.9344,
     0.1895,  0.2849,  0.3705,  0.4126,  0.6265,  0.9207,  1.1774,  1.3762,
     1.5757,  1.7728,  1.9568,  2.1662,  2.3615,  2.5575,  2.7561,  2.9416,
     0.1800,  0.3078,  0.4805,  0.6796,  0.8503,  1.0046,  1.1703,  1.3269,
     1.4862,  1.6502,  1.8454,  2.0873,  2.3175,  2.5356,  2.7516,  2.9469,
     0.1950,  0.3233,  0.4568,  0.5940,  0.7589,  0.9978,  1.1701,  1.3383,
     1.5017,  1.6565,  1.8243,  2.0605,  2.2938,  2.5147,  2.7419,  2.9396,
     0.2531,  0.4391,  0.5790,  0.7170,  0.8998,  1.1430,  1.3577,  1.5326,
     1.6328,  1.7627,  1.9726,  2.1762,  2.3563,  2.5478,  2.7385,  2.9067,
     0.1805,  0.2788,  0.3591,  0.3881,  0.5441,  0.8055,  1.0766,  1.3165,
     1.5316,  1.7508,  1.9477,  2.1374,  2.3438,  2.5484,  2.7501,  2.9410,
     0.2044,  0.3671,  0.5396,  0.7042,  0.8582,  0.9831,  1.1261,  1.3194,
     1.4769,  1.6979,  1.8717,  2.0463,  2.2620,  2.4739,  2.7054,  2.9208,
     0.1048,  0.2175,  0.4206,  0.5923,  0.7483,  0.9400,  1.1356,  1.3799,
     1.5958,  1.7320,  1.8984,  2.1296,  2.3594,  2.5492,  2.7387,  2.9305,
     0.0842,  0.1729,  0.3951,  0.6447,  0.8688,  1.0605,  1.2472,  1.4330,
     1.6232,  1.8144,  2.0216,  2.1915,  2.3878,  2.5763,  2.7685,  2.9464,
     0.1461,  0.2593,  0.4105,  0.5677,  0.7328,  0.8919,  1.0484,  1.2302,
     1.4386,  1.6635,  1.8873,  2.1024,  2.3116,  2.5268,  2.7273,  2.9269,
     0.1503,  0.3108,  0.4756,  0.6731,  0.8600,  1.0233,  1.2115,  1.3971,
     1.5915,  1.7892,  1.9517,  2.1603,  2.3487,  2.5460,  2.7308,  2.8998,
     0.2163,  0.3669,  0.5125,  0.6709,  0.8143,  0.9930,  1.2095,  1.4205,
     1.6176,  1.7112,  1.8398,  2.0896,  2.3513,  2.5290,  2.6667,  2.8960,
     0.2133,  0.4382,  0.6287,  0.8702,  1.1088,  1.3749,  1.6062,  1.7446,
     1.8333,  1.9122,  1.9614,  2.0669,  2.1789,  2.3449,  2.6038,  2.8849,
     0.1598,  0.2719,  0.3877,  0.4815,  0.5926,  0.7795,  1.0449,  1.3045,
     1.5210,  1.7391,  1.9462,  2.1397,  2.3553,  2.5458,  2.7540,  2.9392,
     0.2918,  0.5607,  0.6801,  0.7404,  0.8285,  0.9431,  1.1579,  1.4080,
     1.6332,  1.8472,  1.9738,  2.0771,  2.2890,  2.5178,  2.7445,  2.9830,
     0.1664,  0.2842,  0.3965,  0.5463,  0.8162,  1.0346,  1.1849,  1.3446,
     1.5122,  1.7563,  1.9960,  2.2002,  2.3796,  2.5689,  2.7712,  2.9550,
     0.0911,  0.2397,  0.5052,  0.7868,  1.0299,  1.1311,  1.2244,  1.3333,
     1.4395,  1.6790,  1.9369,  2.1717,  2.3689,  2.5538,  2.7340,  2.9326,
     0.1647,  0.2931,  0.3836,  0.4978,  0.6255,  0.9243,  1.1339,  1.3001,
     1.5269,  1.8010,  1.9715,  2.1419,  2.3784,  2.5503,  2.6719,  2.8745,
     0.2440,  0.3802,  0.4756,  0.6613,  0.8627,  1.0292,  1.2291,  1.4060,
     1.5198,  1.7354,  1.9044,  2.1010,  2.3147,  2.4996,  2.7171,  2.9041,
     0.1590,  0.2876,  0.4572,  0.5996,  0.7713,  0.9490,  1.1205,  1.2815,
     1.4516,  1.6385,  1.8179,  2.0457,  2.2759,  2.4785,  2.6861,  2.9080,
     0.2297,  0.4309,  0.5712,  0.6717,  0.8138,  1.0463,  1.2492,  1.4560,
     1.6796,  1.8458,  1.9642,  2.1452,  2.3636,  2.5395,  2.7456,  2.9495,
     0.2975,  0.4678,  0.4996,  0.5809,  0.6279,  0.6884,  0.8606,  1.1386,
     1.4412,  1.6876,  1.8760,  2.0932,  2.3178,  2.5166,  2.7345,  2.9280,
     0.1278,  0.3737,  0.6004,  0.7069,  0.8147,  1.0180,  1.2581,  1.3812,
     1.4855,  1.7268,  1.9970,  2.1258,  2.2936,  2.5702,  2.7563,  2.8983,
     0.1314,  0.2508,  0.3999,  0.5680,  0.7424,  0.9367,  1.1286,  1.3175,
     1.5336,  1.7404,  1.9317,  2.1404,  2.3514,  2.5562,  2.7510,  2.9402,
     0.1043,  0.2367,  0.4293,  0.6376,  0.8160,  0.9836,  1.1779,  1.3850,
     1.5835,  1.7875,  1.9765,  2.1593,  2.3654,  2.5577,  2.7465,  2.9398,
     0.1529,  0.2515,  0.3454,  0.4374,  0.7011,  0.9015,  1.0744,  1.3532,
     1.5699,  1.7545,  2.0021,  2.1259,  2.2278,  2.4546,  2.7264,  2.9425,
     0.1429,  0.2808,  0.4395,  0.6334,  0.8069,  0.9705,  1.1520,  1.3250,
     1.5109,  1.7285,  1.9356,  2.1469,  2.3479,  2.5554,  2.7512,  2.9348,
     0.1625,  0.3022,  0.4756,  0.6315,  0.8032,  0.9924,  1.1596,  1.3204,
     1.4994,  1.6929,  1.8955,  2.1090,  2.3025,  2.5018,  2.6908,  2.8980,
     0.1692,  0.3427,  0.5228,  0.7756,  0.9688,  1.0950,  1.3056,  1.4360,
     1.5675,  1.8049,  1.9376,  2.1151,  2.3407,  2.5012,  2.7192,  2.9258,
     0.0474,  0.1251,  0.1939,  0.3841,  0.6501,  0.9231,  1.1153,  1.3240,
     1.5478,  1.7599,  1.9651,  2.1510,  2.3645,  2.5552,  2.7542,  2.9393,
     0.2196,  0.4656,  0.7492,  0.9922,  1.1678,  1.2489,  1.3112,  1.3657,
     1.4223,  1.5302,  1.7212,  1.9996,  2.2523,  2.4844,  2.7036,  2.9145,
     0.1128,  0.2368,  0.3704,  0.5476,  0.7723,  0.9968,  1.1930,  1.3992,
     1.6013,  1.7957,  1.9888,  2.1857,  2.3825,  2.5705,  2.7616,  2.9434,
     0.1341,  0.2768,  0.4510,  0.6359,  0.8332,  1.0335,  1.2004,  1.3952,
     1.5762,  1.7681,  1.9815,  2.1735,  2.3657,  2.5552,  2.7514,  2.9498,
     0.1247,  0.2559,  0.3516,  0.4726,  0.6861,  0.9483,  1.1852,  1.3858,
     1.5851,  1.7815,  1.9778,  2.1737,  2.3729,  2.5664,  2.7620,  2.9429,
     0.1988,  0.3320,  0.4777,  0.6737,  0.8425,  1.0265,  1.1694,  1.3655,
     1.5463,  1.7135,  1.9385,  2.1650,  2.3529,  2.5367,  2.7545,  2.9585,
     0.1376,  0.2620,  0.4273,  0.6169,  0.7755,  0.9441,  1.1169,  1.3157,
     1.5179,  1.7020,  1.8931,  2.1059,  2.3112,  2.5136,  2.7169,  2.9198,
     0.2112,  0.4385,  0.6091,  0.7618,  0.9553,  1.1543,  1.3445,  1.5396,
     1.7153,  1.9192,  2.1263,  2.3593,  2.5958,  2.8171,  2.9394,  3.0409,
     0.1347,  0.2099,  0.2646,  0.3453,  0.5266,  0.7869,  1.0513,  1.2795,
     1.4880,  1.7181,  1.9294,  2.1332,  2.3362,  2.5442,  2.7433,  2.9362,
     0.3141,  0.5935,  0.7517,  0.8313,  0.8568,  0.9570,  1.0250,  1.1275,
     1.3422,  1.6303,  1.8577,  2.0705,  2.2957,  2.5095,  2.7244,  2.9262,
     0.0962,  0.2116,  0.3961,  0.5641,  0.7122,  0.8883,  1.1023,  1.3481,
     1.5623,  1.7554,  1.9618,  2.1675,  2.3706,  2.5556,  2.7430,  2.9337,
     0.0898,  0.1510,  0.3060,  0.5820,  0.8221,  1.0388,  1.2261,  1.4289,
     1.6054,  1.8103,  1.9941,  2.1844,  2.3742,  2.5711,  2.7632,  2.9474,
     0.1326,  0.2316,  0.3761,  0.5177,  0.6782,  0.8761,  1.0952,  1.3175,
     1.5078,  1.7034,  1.9051,  2.1245,  2.3424,  2.5484,  2.7444,  2.9389,
     0.1740,  0.3293,  0.5174,  0.6824,  0.8394,  1.0372,  1.2046,  1.3723,
     1.5656,  1.7444,  1.9442,  2.1386,  2.3139,  2.4960,  2.7071,  2.9297,
     0.2304,  0.3775,  0.4865,  0.6182,  0.7842,  0.9208,  1.1151,  1.2843,
     1.4641,  1.6988,  1.9209,  2.1260,  2.3099,  2.5229,  2.7414,  2.9276,
     0.0094,  0.0261, -0.0037,  0.0041, -0.0092, -0.0044, -0.0232, -0.0073,
    -0.0047, -0.0021,  0.0250, -0.0580, -0.0140, -0.0342, -0.0586,  0.0020,
     0.0449,  0.0155, -0.0523, -0.0279,  0.0299, -0.0183, -0.0736, -0.0639,
    -0.0017,  0.0336,  0.0209,  0.0046,  0.0077, -0.0148, -0.0114, -0.0120,
     0.0115, -0.0050,  0.0445,  0.0048,  0.0188, -0.0137, -0.0080,  0.0239,
    -0.0184, -0.0524, -0.0195, -0.0126,  0.0284,  0.0632,  0.0141, -0.0093,
    -0.0096,  0.0196,  0.0230,  0.0379,  0.0308,  0.0237, -0.0224, -0.0600,
    -0.0755, -0.1074, -0.0988, -0.0606, -0.1038, -0.1552, -0.1480, -0.0672,
     0.0504,  0.0676,  0.0336, -0.0042,  0.0729,  0.1013,  0.0868,  0.0846,
     0.0954,  0.0515, -0.0066, -0.0851, -0.0485,  0.0294,  0.0395,  0.0087,
     0.0078,  0.0446,  0.0881,  0.0672, -0.0384, -0.0025,  0.0415,  0.0353,
     0.0080,  0.0052,  0.0190,  0.0182,  0.0069,  0.0168,  0.0374,  0.0037,
    -0.0292, -0.0429,  0.0302,  0.0681, -0.0233, -0.0238, -0.0003, -0.0043,
     0.0054, -0.0029, -0.0149,  0.0642,  0.0622,  0.0341, -0.0232, -0.0461,
    -0.0082, -0.0469, -0.0618, -0.0326, -0.0452, -0.0649, -0.0597, -0.0398,
    -0.0318, -0.0116,  0.0011,  0.0009, -0.0384, -0.0384, -0.0156, -0.0260,
    -0.0007,  0.0473,  0.0111, -0.0358, -0.0484, -0.0204, -0.0029, -0.0090,
    -0.0285, -0.0495, -0.0376,  0.0917,  0.1192,  0.1026,  0.0745,  0.0397,
     0.0463,  0.0253,  0.0025,  0.0465,  0.0100,  0.0488,  0.0416,  0.0223,
     0.0263,  0.0072, -0.0053,  0.0595,  0.0060, -0.0518, -0.0316, -0.0043,
    -0.0133, -0.0233, -0.0075, -0.0251,  0.0277, -0.0067, -0.0136, -0.0004,
     0.0235,  0.0112, -0.0182, -0.0324, -0.0210, -0.0035, -0.0395, -0.0384,
     0.0005, -0.0150, -0.0356,  0.0127, -0.0033, -0.0034,  0.0205,  0.0747,
     0.1138,  0.1015,  0.0995, -0.0161, -0.0045,  0.0129,  0.0472,  0.0575,
     0.0222,  0.0091,  0.0037, -0.0471,  0.0371,  0.0132,  0.0208,  0.0247,
     0.0117,  0.0164,  0.0225,  0.0124, -0.0023,  0.0088, -0.0046,  0.0047,
    -0.0393,  0.0018,  0.0148,  0.0020,  0.0044,  0.0165,  0.0229, -0.0208,
    -0.0477, -0.0310, -0.0164, -0.0390, -0.0764, -0.0525, -0.0094,  0.0075,
    -0.0102, -0.0045, -0.0504, -0.0709,  0.0822,  0.0710,  0.0426,  0.0014,
    -0.0371, -0.0400, -0.0157, -0.0155, -0.0173, -0.0138, -0.0015,  0.0134,
    -0.0418, -0.0682, -0.0256,  0.0050,  0.0360,  0.0354,  0.0074, -0.0396,
    -0.0235,  0.0284,  0.0494,  0.0153,  0.0448,  0.0025, -0.0061,  0.0252,
     0.1000,  0.2260,  0.2158,  0.2116,  0.2198,  0.2055,  0.2110,  0.1873,
     0.1907,  0.2071,  0.2164,  0.2009,  0.2059,  0.2124,  0.2141,  0.2093,
     0.0875,  0.0981,  0.1177,  0.1071,  0.1033,  0.1248,  0.1048,  0.1238,
     0.1166,  0.1008,  0.1062,  0.0992,  0.0994,  0.1067,  0.0999,  0.1187,
     0.0750,  0.0794,  0.0828,  0.0854,  0.0859,  0.0801,  0.0891,  0.0933,
     0.0969,  0.0920,  0.0915,  0.0862,  0.0868,  0.0891,  0.0842,  0.0824,
     0.0625,  0.0930,  0.0815,  0.0853,  0.0898,  0.0828,  0.0822,  0.0910,
     0.0873,  0.0906,  0.0856,  0.0840,  0.0774,  0.0785,  0.0684,  0.0711,
     0.3319,  0.4219,  0.4588,  0.4090,  0.4092,  0.4014,  0.3548,  0.3353,
     0.3708,  0.3352,  0.3720,  0.3538,  0.4084,  0.4289,  0.4060,  0.4210,
     0.0588,  0.0209, -0.0082, -0.0115, -0.0343, -0.0621, -0.0541, -0.0346,
    -0.0346, -0.0366, -0.0220, -0.0265, -0.0102,  0.0374,  0.0306,  0.0404,
     0.0306,  0.0090, -0.0054,  0.0333,  0.0047,  0.0238,  0.0141,  0.0165,
     0.0306,  0.0420,  0.0159,  0.0124,  0.0414,  0.0158, -0.0237,  0.0141,
     0.0765,  0.0057, -0.0260, -0.0426, -0.0395, -0.0126, -0.0579, -0.0417,
    -0.0429, -0.0615, -0.0893, -0.0618, -0.0384, -0.0134, -0.0232, -0.0238,
};

static const float lsp22[] = {
     0.0664,  0.1875,  0.4300,  0.6730,  0.8793,  1.0640,  1.2563,  1.4433,
     1.6394,  1.8176,  2.0029,  2.1921,  2.3796,  2.5671,  2.7595,  2.9536,
     0.2128,  0.4052,  0.5311,  0.6404,  0.7875,  0.8775,  1.0974,  1.3261,
     1.5563,  1.6790,  1.8339,  2.1195,  2.3226,  2.4609,  2.6440,  2.8947,
     0.2024,  0.3362,  0.4834,  0.6784,  0.9088,  1.0850,  1.2188,  1.4054,
     1.6102,  1.7767,  1.9679,  2.1436,  2.3445,  2.5467,  2.7429,  2.9320,
     0.1181,  0.2279,  0.4413,  0.6114,  0.7710,  0.9427,  1.1142,  1.2707,
     1.4892,  1.7416,  1.9526,  2.1466,  2.3629,  2.5445,  2.7293,  2.9205,
     0.1155,  0.2720,  0.4886,  0.6812,  0.8594,  1.0422,  1.2315,  1.4116,
     1.6137,  1.8020,  1.9758,  2.1743,  2.3602,  2.5568,  2.7472,  2.9374,
     0.1110,  0.3312,  0.4735,  0.5612,  0.7129,  0.8146,  1.0233,  1.3155,
     1.5765,  1.7746,  1.9574,  2.1416,  2.3220,  2.5384,  2.7334,  2.9318,
     0.1656,  0.3350,  0.4215,  0.5609,  0.6759,  0.8503,  1.1405,  1.4094,
     1.6057,  1.6860,  1.7639,  2.0031,  2.2680,  2.5076,  2.7263,  2.9368,
     0.1466,  0.3638,  0.4587,  0.5674,  0.7381,  0.8669,  0.9619,  1.1658,
     1.4667,  1.7440,  1.9335,  2.1018,  2.3022,  2.5281,  2.7359,  2.9261,
     0.1061,  0.2566,  0.4739,  0.6751,  0.8711,  1.0704,  1.2720,  1.4655,
     1.6605,  1.8494,  2.0290,  2.2197,  2.4008,  2.5912,  2.7772,  2.9513,
     0.1116,  0.2364,  0.3971,  0.6316,  0.8583,  1.0335,  1.1686,  1.3302,
     1.5612,  1.7877,  1.9829,  2.2052,  2.3596,  2.5460,  2.7341,  2.9290,
     0.2661,  0.4186,  0.5126,  0.6477,  0.8818,  1.1045,  1.2852,  1.4128,
     1.5851,  1.7593,  1.9399,  2.1757,  2.3684,  2.5136,  2.6927,  2.9064,
     0.1495,  0.2749,  0.4391,  0.6304,  0.8239,  1.0181,  1.1995,  1.3759,
     1.5669,  1.7722,  1.9671,  2.1635,  2.3586,  2.5528,  2.7445,  2.9311,
     0.0912,  0.1759,  0.3066,  0.5660,  0.8005,  0.9568,  1.1832,  1.4504,
     1.6259,  1.7948,  2.0113,  2.2002,  2.3654,  2.5583,  2.7929,  2.9735,
     0.1353,  0.2747,  0.4078,  0.5977,  0.7658,  0.9124,  1.1081,  1.3630,
     1.5875,  1.7847,  1.9323,  2.1181,  2.3321,  2.5046,  2.7183,  2.9225,
     0.1938,  0.4063,  0.4982,  0.6002,  0.7702,  0.9071,  1.1631,  1.3885,
     1.6043,  1.8118,  1.9306,  2.0893,  2.2724,  2.4609,  2.6283,  2.8802,
     0.1857,  0.3351,  0.4381,  0.6101,  0.7561,  0.8555,  1.0384,  1.3171,
     1.5667,  1.6904,  1.7552,  1.9689,  2.2597,  2.5260,  2.7272,  2.9337,
     0.1037,  0.2159,  0.4188,  0.6174,  0.8035,  1.0285,  1.2256,  1.4230,
     1.6400,  1.8322,  2.0144,  2.1988,  2.3810,  2.5682,  2.7613,  2.9438,
     0.1625,  0.2776,  0.4225,  0.6001,  0.7879,  0.9087,  1.0801,  1.2759,
     1.4899,  1.7448,  1.9911,  2.1770,  2.3723,  2.5777,  2.7971,  2.9444,
     0.2111,  0.3640,  0.5839,  0.7290,  0.8051,  1.0023,  1.2315,  1.4143,
     1.5878,  1.7755,  1.9804,  2.1498,  2.3312,  2.5350,  2.7613,  2.9472,
     0.1423,  0.2646,  0.4136,  0.6350,  0.8070,  0.9514,  1.1168,  1.3213,
     1.5776,  1.7721,  1.9404,  2.1545,  2.3385,  2.5137,  2.7396,  2.9553,
     0.1132,  0.2386,  0.4103,  0.5931,  0.7808,  0.9881,  1.1840,  1.3860,
     1.6021,  1.7990,  1.9922,  2.1885,  2.3852,  2.5717,  2.7640,  2.9510,
     0.1267,  0.2602,  0.3913,  0.5944,  0.7598,  0.9198,  1.0781,  1.2715,
     1.5299,  1.7573,  1.9308,  2.1346,  2.3267,  2.5419,  2.7466,  2.9320,
     0.2023,  0.3417,  0.4392,  0.6141,  0.7439,  0.8593,  1.1096,  1.3543,
     1.5185,  1.6553,  1.7862,  2.0341,  2.2718,  2.4834,  2.7103,  2.9466,
     0.1113,  0.2470,  0.3677,  0.5686,  0.7700,  0.9356,  1.0806,  1.2452,
     1.4830,  1.7344,  1.9268,  2.1404,  2.3371,  2.5169,  2.7329,  2.9012,
     0.1664,  0.3554,  0.5573,  0.7471,  0.9245,  1.0998,  1.2787,  1.4655,
     1.6654,  1.8346,  2.0179,  2.2159,  2.4096,  2.5946,  2.7790,  2.9530,
     0.1313,  0.2625,  0.4731,  0.6444,  0.8110,  0.9878,  1.1493,  1.3212,
     1.5719,  1.8138,  1.9861,  2.1943,  2.3714,  2.5578,  2.7346,  2.9296,
     0.1186,  0.3035,  0.5049,  0.6860,  0.8670,  0.9975,  1.1364,  1.3471,
     1.5695,  1.7412,  1.9346,  2.1506,  2.3413,  2.5531,  2.7794,  2.9627,
     0.1108,  0.2697,  0.4787,  0.6344,  0.7909,  0.9586,  1.1440,  1.3511,
     1.5686,  1.7601,  1.9246,  2.1241,  2.3293,  2.5390,  2.7315,  2.9333,
     0.0985,  0.2302,  0.3544,  0.5759,  0.7620,  0.9651,  1.1497,  1.3080,
     1.5500,  1.7845,  1.9518,  2.1734,  2.3565,  2.5665,  2.7605,  2.9102,
     0.1208,  0.2727,  0.4381,  0.5736,  0.7382,  0.8390,  1.0102,  1.2648,
     1.5100,  1.7440,  1.9619,  2.1430,  2.3307,  2.5159,  2.7264,  2.9211,
     0.1582,  0.2777,  0.4475,  0.6551,  0.8591,  1.0084,  1.1414,  1.3291,
     1.5902,  1.7826,  1.9543,  2.1659,  2.3233,  2.5044,  2.6935,  2.9199,
     0.1360,  0.2873,  0.4585,  0.6295,  0.7592,  0.9089,  1.0492,  1.2733,
     1.5391,  1.7768,  1.9372,  2.1329,  2.3168,  2.5015,  2.6857,  2.8837,
     0.0886,  0.1829,  0.3696,  0.6126,  0.8334,  1.0135,  1.2303,  1.4674,
     1.6743,  1.8564,  2.0530,  2.2370,  2.3960,  2.5787,  2.7756,  2.9377,
     0.2005,  0.3537,  0.4700,  0.6249,  0.7385,  0.9097,  1.1759,  1.3811,
     1.5314,  1.6705,  1.8546,  2.1229,  2.3292,  2.5251,  2.7951,  2.9646,
     0.1999,  0.3112,  0.4722,  0.7146,  0.8908,  1.0028,  1.1831,  1.3903,
     1.6125,  1.7514,  1.9083,  2.1248,  2.3271,  2.5339,  2.6945,  2.8918,
     0.1243,  0.2606,  0.4382,  0.5850,  0.7705,  0.9727,  1.1214,  1.3059,
     1.5218,  1.7406,  1.9137,  2.1353,  2.3354,  2.5299,  2.7287,  2.9068,
     0.1039,  0.2426,  0.4265,  0.6284,  0.8152,  0.9941,  1.2004,  1.4038,
     1.5912,  1.7763,  1.9650,  2.1598,  2.3474,  2.5488,  2.7419,  2.9322,
     0.1364,  0.2420,  0.3886,  0.5864,  0.7663,  0.8844,  1.0860,  1.3242,
     1.5518,  1.7893,  2.0004,  2.1562,  2.3619,  2.5516,  2.7687,  2.9181,
     0.1483,  0.2851,  0.4479,  0.6312,  0.7924,  0.9821,  1.1705,  1.3386,
     1.5375,  1.7226,  1.9053,  2.0991,  2.2898,  2.4953,  2.7000,  2.9146,
     0.2332,  0.4561,  0.5407,  0.6212,  0.7524,  0.8215,  0.9522,  1.1685,
     1.5216,  1.7132,  1.8291,  2.0647,  2.2811,  2.4857,  2.7071,  2.9281,
     0.1348,  0.3126,  0.5179,  0.7192,  0.9227,  1.1363,  1.3223,  1.4756,
     1.6509,  1.8191,  1.9991,  2.1976,  2.3877,  2.5768,  2.7590,  2.9386,
     0.1093,  0.2211,  0.4763,  0.6703,  0.8282,  0.9536,  1.1202,  1.3796,
     1.6043,  1.8031,  1.9832,  2.1604,  2.3578,  2.5856,  2.7650,  2.9291,
     0.1865,  0.3027,  0.4580,  0.6719,  0.8400,  1.0082,  1.1901,  1.3782,
     1.5448,  1.6885,  1.9477,  2.1381,  2.2797,  2.5113,  2.7465,  2.9414,
     0.1575,  0.3124,  0.4649,  0.6262,  0.8095,  0.9858,  1.1676,  1.3602,
     1.5646,  1.7582,  1.9550,  2.1671,  2.3628,  2.5734,  2.7670,  2.9519,
     0.1174,  0.2777,  0.4663,  0.6333,  0.8169,  1.0096,  1.1885,  1.3847,
     1.5803,  1.7571,  1.9380,  2.1398,  2.3414,  2.5407,  2.7360,  2.9375,
     0.1073,  0.2264,  0.4083,  0.5973,  0.7474,  0.9514,  1.1349,  1.3337,
     1.5433,  1.7348,  1.9380,  2.1436,  2.3441,  2.5438,  2.7457,  2.9383,
     0.1472,  0.2880,  0.4793,  0.6268,  0.8015,  1.0063,  1.1715,  1.3644,
     1.5525,  1.7410,  1.9258,  2.1227,  2.3214,  2.5149,  2.7148,  2.9196,
     0.1414,  0.2565,  0.4349,  0.6111,  0.7695,  0.9496,  1.1212,  1.3265,
     1.5218,  1.7209,  1.9015,  2.0887,  2.3158,  2.5077,  2.7233,  2.9421,
     0.1252,  0.2667,  0.4454,  0.6431,  0.8371,  1.0124,  1.2110,  1.4160,
     1.6240,  1.8242,  2.0047,  2.1974,  2.3902,  2.5778,  2.7637,  2.9481,
     0.1321,  0.2565,  0.3846,  0.5847,  0.7578,  0.9259,  1.0637,  1.2239,
     1.4690,  1.7346,  1.9750,  2.1882,  2.3712,  2.5509,  2.7280,  2.8885,
     0.1437,  0.2930,  0.4428,  0.6156,  0.8045,  0.9638,  1.1450,  1.3138,
     1.5144,  1.7355,  1.9469,  2.1534,  2.3414,  2.5452,  2.7353,  2.9334,
     0.1692,  0.2770,  0.3831,  0.6100,  0.7825,  0.9302,  1.0690,  1.2481,
     1.4615,  1.6799,  1.9165,  2.1739,  2.3435,  2.5349,  2.7520,  2.9163,
     0.1235,  0.2489,  0.4354,  0.6343,  0.8236,  1.0066,  1.1908,  1.3474,
     1.5656,  1.8275,  2.0620,  2.2548,  2.4135,  2.5913,  2.7639,  2.9334,
     0.1090,  0.1961,  0.3854,  0.5701,  0.7024,  0.8843,  1.1393,  1.3785,
     1.5940,  1.7797,  1.9442,  2.1740,  2.3853,  2.5773,  2.7727,  2.9406,
     0.1560,  0.3477,  0.5011,  0.6287,  0.7612,  0.9896,  1.1510,  1.3420,
     1.5435,  1.6816,  1.8731,  2.0651,  2.2613,  2.4999,  2.7027,  2.8971,
     0.1459,  0.2416,  0.3833,  0.5450,  0.7916,  0.9223,  1.0662,  1.1953,
     1.4029,  1.6616,  1.9320,  2.1459,  2.3386,  2.5081,  2.6799,  2.9195,
     0.1546,  0.3854,  0.6184,  0.8460,  1.0599,  1.2428,  1.3906,  1.5550,
     1.7388,  1.8945,  2.0757,  2.2386,  2.4014,  2.5705,  2.7574,  2.9400,
     0.1080,  0.2307,  0.4112,  0.6067,  0.7725,  0.9467,  1.1285,  1.3205,
     1.5348,  1.7609,  1.9937,  2.1878,  2.3583,  2.5515,  2.7199,  2.9049,
     0.1482,  0.3178,  0.4983,  0.6342,  0.7783,  0.9880,  1.2019,  1.3404,
     1.5223,  1.7296,  1.9211,  2.0943,  2.2928,  2.5008,  2.7136,  2.9224,
     0.1145,  0.2910,  0.4891,  0.6492,  0.8126,  0.9530,  1.1180,  1.3155,
     1.5054,  1.6893,  1.8899,  2.1188,  2.3389,  2.5512,  2.7313,  2.9224,
     0.0939,  0.1689,  0.3250,  0.5792,  0.7698,  0.9245,  1.1574,  1.3865,
     1.5959,  1.7977,  1.9821,  2.1528,  2.3326,  2.5540,  2.7553,  2.9179,
     0.1243,  0.2474,  0.3923,  0.6199,  0.7908,  0.9379,  1.1497,  1.3734,
     1.5582,  1.7420,  1.9539,  2.1385,  2.3240,  2.5277,  2.7311,  2.9178,
     0.1961,  0.3748,  0.5176,  0.6387,  0.8169,  1.0477,  1.2124,  1.3869,
     1.5604,  1.7225,  1.8770,  2.0837,  2.2960,  2.5103,  2.6945,  2.8862,
     0.1295,  0.2403,  0.4149,  0.6189,  0.7913,  0.9130,  1.0832,  1.2787,
     1.4860,  1.7112,  1.9502,  2.1348,  2.2776,  2.4982,  2.7431,  2.9522,
     0.0160,  0.0362,  0.0097,  0.0057, -0.0014, -0.0073, -0.0046, -0.0064,
    -0.0121,  0.0019,  0.0149, -0.0440, -0.0479, -0.0382, -0.0480, -0.0182,
     0.0170,  0.0114, -0.0298, -0.0175, -0.0033, -0.0354, -0.0510, -0.0025,
     0.0307,  0.0351,  0.0338,  0.0420,  0.0138, -0.0175, -0.0102,  0.0053,
     0.0084, -0.0003,  0.0412, -0.0027,  0.0145, -0.0039,  0.0083,  0.0400,
     0.0001, -0.0262,  0.0055, -0.0082,  0.0348,  0.0433,  0.0137, -0.0024,
    -0.0055,  0.0262,  0.0521,  0.0349,  0.0185,  0.0076, -0.0319, -0.0561,
    -0.0460, -0.0253, -0.0097,  0.0163,  0.0184, -0.0037, -0.0480, -0.0371,
     0.0628,  0.0665,  0.0296, -0.0057,  0.0253,  0.0227,  0.0350,  0.0692,
     0.0545,  0.0218,  0.0094, -0.0449, -0.0372,  0.0005,  0.0258,  0.0118,
     0.0285,  0.0760,  0.0822,  0.0527, -0.0299, -0.0049,  0.0170,  0.0195,
     0.0136,  0.0286,  0.0289,  0.0139,  0.0054,  0.0152,  0.0244,  0.0028,
    -0.0056, -0.0260,  0.0307,  0.0572, -0.0087,  0.0088,  0.0062,  0.0000,
     0.0125,  0.0000, -0.0292,  0.0820,  0.0872,  0.0646,  0.0346,  0.0076,
    -0.0022, -0.0253, -0.0567, -0.0188, -0.0336, -0.0673, -0.0549, -0.0166,
    -0.0259, -0.0140,  0.0040, -0.0029, -0.0430, -0.0531, -0.0253, -0.0019,
    -0.0071,  0.0393,  0.0072, -0.0327, -0.0236, -0.0235, -0.0177, -0.0186,
    -0.0280, -0.0201, -0.0077,  0.0383,  0.0418,  0.0321,  0.0294,  0.0169,
     0.0468,  0.0301,  0.0133,  0.0363,  0.0516,  0.0937,  0.1240,  0.1404,
     0.1325,  0.1178,  0.0999,  0.0251, -0.0037, -0.0495, -0.0703, -0.0219,
    -0.0261, -0.0304, -0.0204, -0.0372,  0.0355,  0.0131, -0.0093, -0.0099,
    -0.0069, -0.0034, -0.0065, -0.0208, -0.0231, -0.0117, -0.0211, -0.0243,
     0.0046, -0.0107, -0.0070,  0.0123,  0.0230,  0.0152,  0.0164,  0.0412,
     0.0619,  0.0858,  0.0862, -0.0056,  0.0125,  0.0182,  0.0347,  0.0388,
     0.0456,  0.0407, -0.0249, -0.0460,  0.0206,  0.0299,  0.0253,  0.0207,
     0.0177,  0.0238,  0.0253,  0.0030,  0.0042,  0.0020, -0.0081, -0.0136,
    -0.0290, -0.0042,  0.0122,  0.0051,  0.0107,  0.0228,  0.0211, -0.0068,
    -0.0436, -0.0299, -0.0078, -0.0779, -0.1157, -0.0679,  0.0172,  0.0150,
    -0.0051,  0.0081, -0.0512, -0.0616,  0.0576,  0.0799,  0.0803,  0.0336,
     0.0001, -0.0298, -0.0747, -0.0115, -0.0101, -0.0170, -0.0050,  0.0174,
    -0.0290, -0.0601, -0.0150,  0.0121,  0.0165,  0.0230,  0.0028, -0.0317,
    -0.0165,  0.0356,  0.0451,  0.0120,  0.0321,  0.0084, -0.0058,  0.0122,
     0.1935,  0.1802,  0.2195,  0.2410,  0.2201,  0.1915,  0.1840,  0.1935,
     0.2213,  0.2079,  0.1858,  0.1974,  0.2239,  0.2173,  0.1840,  0.2120,
     0.4912,  0.4777,  0.4607,  0.4395,  0.4426,  0.4388,  0.4416,  0.4345,
     0.4239,  0.4331,  0.4522,  0.4423,  0.4475,  0.4387,  0.4525,  0.4446,
};

static const float lsp22s[] = {
     0.0664,  0.1875,  0.4300,  0.6730,  0.8793,  1.0640,  1.2563,  1.4433,
     1.6394,  1.8176,  2.0029,  2.1921,  2.3796,  2.5671,  2.7595,  2.9536,
     0.2128,  0.4052,  0.5311,  0.6404,  0.7875,  0.8775,  1.0974,  1.3261,
     1.5563,  1.6790,  1.8339,  2.1195,  2.3226,  2.4609,  2.6440,  2.8947,
     0.2024,  0.3362,  0.4834,  0.6784,  0.9088,  1.0850,  1.2188,  1.4054,
     1.6102,  1.7767,  1.9679,  2.1436,  2.3445,  2.5467,  2.7429,  2.9320,
     0.1181,  0.2279,  0.4413,  0.6114,  0.7710,  0.9427,  1.1142,  1.2707,
     1.4892,  1.7416,  1.9526,  2.1466,  2.3629,  2.5445,  2.7293,  2.9205,
     0.1155,  0.2720,  0.4886,  0.6812,  0.8594,  1.0422,  1.2315,  1.4116,
     1.6137,  1.8020,  1.9758,  2.1743,  2.3602,  2.5568,  2.7472,  2.9374,
     0.1110,  0.3312,  0.4735,  0.5612,  0.7129,  0.8146,  1.0233,  1.3155,
     1.5765,  1.7746,  1.9574,  2.1416,  2.3220,  2.5384,  2.7334,  2.9318,
     0.1656,  0.3350,  0.4215,  0.5609,  0.6759,  0.8503,  1.1405,  1.4094,
     1.6057,  1.6860,  1.7639,  2.0031,  2.2680,  2.5076,  2.7263,  2.9368,
     0.1466,  0.3638,  0.4587,  0.5674,  0.7381,  0.8669,  0.9619,  1.1658,
     1.4667,  1.7440,  1.9335,  2.1018,  2.3022,  2.5281,  2.7359,  2.9261,
     0.1061,  0.2566,  0.4739,  0.6751,  0.8711,  1.0704,  1.2720,  1.4655,
     1.6605,  1.8494,  2.0290,  2.2197,  2.4008,  2.5912,  2.7772,  2.9513,
     0.1116,  0.2364,  0.3971,  0.6316,  0.8583,  1.0335,  1.1686,  1.3302,
     1.5612,  1.7877,  1.9829,  2.2052,  2.3596,  2.5460,  2.7341,  2.9290,
     0.2661,  0.4186,  0.5126,  0.6477,  0.8818,  1.1045,  1.2852,  1.4128,
     1.5851,  1.7593,  1.9399,  2.1757,  2.3684,  2.5136,  2.6927,  2.9064,
     0.1495,  0.2749,  0.4391,  0.6304,  0.8239,  1.0181,  1.1995,  1.3759,
     1.5669,  1.7722,  1.9671,  2.1635,  2.3586,  2.5528,  2.7445,  2.9311,
     0.0912,  0.1759,  0.3066,  0.5660,  0.8005,  0.9568,  1.1832,  1.4504,
     1.6259,  1.7948,  2.0113,  2.2002,  2.3654,  2.5583,  2.7929,  2.9735,
     0.1353,  0.2747,  0.4078,  0.5977,  0.7658,  0.9124,  1.1081,  1.3630,
     1.5875,  1.7847,  1.9323,  2.1181,  2.3321,  2.5046,  2.7183,  2.9225,
     0.1938,  0.4063,  0.4982,  0.6002,  0.7702,  0.9071,  1.1631,  1.3885,
     1.6043,  1.8118,  1.9306,  2.0893,  2.2724,  2.4609,  2.6283,  2.8802,
     0.1857,  0.3351,  0.4381,  0.6101,  0.7561,  0.8555,  1.0384,  1.3171,
     1.5667,  1.6904,  1.7552,  1.9689,  2.2597,  2.5260,  2.7272,  2.9337,
     0.1037,  0.2159,  0.4188,  0.6174,  0.8035,  1.0285,  1.2256,  1.4230,
     1.6400,  1.8322,  2.0144,  2.1988,  2.3810,  2.5682,  2.7613,  2.9438,
     0.1625,  0.2776,  0.4225,  0.6001,  0.7879,  0.9087,  1.0801,  1.2759,
     1.4899,  1.7448,  1.9911,  2.1770,  2.3723,  2.5777,  2.7971,  2.9444,
     0.2111,  0.3640,  0.5839,  0.7290,  0.8051,  1.0023,  1.2315,  1.4143,
     1.5878,  1.7755,  1.9804,  2.1498,  2.3312,  2.5350,  2.7613,  2.9472,
     0.1423,  0.2646,  0.4136,  0.6350,  0.8070,  0.9514,  1.1168,  1.3213,
     1.5776,  1.7721,  1.9404,  2.1545,  2.3385,  2.5137,  2.7396,  2.9553,
     0.1132,  0.2386,  0.4103,  0.5931,  0.7808,  0.9881,  1.1840,  1.3860,
     1.6021,  1.7990,  1.9922,  2.1885,  2.3852,  2.5717,  2.7640,  2.9510,
     0.1267,  0.2602,  0.3913,  0.5944,  0.7598,  0.9198,  1.0781,  1.2715,
     1.5299,  1.7573,  1.9308,  2.1346,  2.3267,  2.5419,  2.7466,  2.9320,
     0.2023,  0.3417,  0.4392,  0.6141,  0.7439,  0.8593,  1.1096,  1.3543,
     1.5185,  1.6553,  1.7862,  2.0341,  2.2718,  2.4834,  2.7103,  2.9466,
     0.1113,  0.2470,  0.3677,  0.5686,  0.7700,  0.9356,  1.0806,  1.2452,
     1.4830,  1.7344,  1.9268,  2.1404,  2.3371,  2.5169,  2.7329,  2.9012,
     0.1664,  0.3554,  0.5573,  0.7471,  0.9245,  1.0998,  1.2787,  1.4655,
     1.6654,  1.8346,  2.0179,  2.2159,  2.4096,  2.5946,  2.7790,  2.9530,
     0.1313,  0.2625,  0.4731,  0.6444,  0.8110,  0.9878,  1.1493,  1.3212,
     1.5719,  1.8138,  1.9861,  2.1943,  2.3714,  2.5578,  2.7346,  2.9296,
     0.1186,  0.3035,  0.5049,  0.6860,  0.8670,  0.9975,  1.1364,  1.3471,
     1.5695,  1.7412,  1.9346,  2.1506,  2.3413,  2.5531,  2.7794,  2.9627,
     0.1108,  0.2697,  0.4787,  0.6344,  0.7909,  0.9586,  1.1440,  1.3511,
     1.5686,  1.7601,  1.9246,  2.1241,  2.3293,  2.5390,  2.7315,  2.9333,
     0.0985,  0.2302,  0.3544,  0.5759,  0.7620,  0.9651,  1.1497,  1.3080,
     1.5500,  1.7845,  1.9518,  2.1734,  2.3565,  2.5665,  2.7605,  2.9102,
     0.1208,  0.2727,  0.4381,  0.5736,  0.7382,  0.8390,  1.0102,  1.2648,
     1.5100,  1.7440,  1.9619,  2.1430,  2.3307,  2.5159,  2.7264,  2.9211,
     0.1582,  0.2777,  0.4475,  0.6551,  0.8591,  1.0084,  1.1414,  1.3291,
     1.5902,  1.7826,  1.9543,  2.1659,  2.3233,  2.5044,  2.6935,  2.9199,
     0.1360,  0.2873,  0.4585,  0.6295,  0.7592,  0.9089,  1.0492,  1.2733,
     1.5391,  1.7768,  1.9372,  2.1329,  2.3168,  2.5015,  2.6857,  2.8837,
     0.0886,  0.1829,  0.3696,  0.6126,  0.8334,  1.0135,  1.2303,  1.4674,
     1.6743,  1.8564,  2.0530,  2.2370,  2.3960,  2.5787,  2.7756,  2.9377,
     0.2005,  0.3537,  0.4700,  0.6249,  0.7385,  0.9097,  1.1759,  1.3811,
     1.5314,  1.6705,  1.8546,  2.1229,  2.3292,  2.5251,  2.7951,  2.9646,
     0.1999,  0.3112,  0.4722,  0.7146,  0.8908,  1.0028,  1.1831,  1.3903,
     1.6125,  1.7514,  1.9083,  2.1248,  2.3271,  2.5339,  2.6945,  2.8918,
     0.1243,  0.2606,  0.4382,  0.5850,  0.7705,  0.9727,  1.1214,  1.3059,
     1.5218,  1.7406,  1.9137,  2.1353,  2.3354,  2.5299,  2.7287,  2.9068,
     0.1039,  0.2426,  0.4265,  0.6284,  0.8152,  0.9941,  1.2004,  1.4038,
     1.5912,  1.7763,  1.9650,  2.1598,  2.3474,  2.5488,  2.7419,  2.9322,
     0.1364,  0.2420,  0.3886,  0.5864,  0.7663,  0.8844,  1.0860,  1.3242,
     1.5518,  1.7893,  2.0004,  2.1562,  2.3619,  2.5516,  2.7687,  2.9181,
     0.1483,  0.2851,  0.4479,  0.6312,  0.7924,  0.9821,  1.1705,  1.3386,
     1.5375,  1.7226,  1.9053,  2.0991,  2.2898,  2.4953,  2.7000,  2.9146,
     0.2332,  0.4561,  0.5407,  0.6212,  0.7524,  0.8215,  0.9522,  1.1685,
     1.5216,  1.7132,  1.8291,  2.0647,  2.2811,  2.4857,  2.7071,  2.9281,
     0.1348,  0.3126,  0.5179,  0.7192,  0.9227,  1.1363,  1.3223,  1.4756,
     1.6509,  1.8191,  1.9991,  2.1976,  2.3877,  2.5768,  2.7590,  2.9386,
     0.1093,  0.2211,  0.4763,  0.6703,  0.8282,  0.9536,  1.1202,  1.3796,
     1.6043,  1.8031,  1.9832,  2.1604,  2.3578,  2.5856,  2.7650,  2.9291,
     0.1865,  0.3027,  0.4580,  0.6719,  0.8400,  1.0082,  1.1901,  1.3782,
     1.5448,  1.6885,  1.9477,  2.1381,  2.2797,  2.5113,  2.7465,  2.9414,
     0.1575,  0.3124,  0.4649,  0.6262,  0.8095,  0.9858,  1.1676,  1.3602,
     1.5646,  1.7582,  1.9550,  2.1671,  2.3628,  2.5734,  2.7670,  2.9519,
     0.1174,  0.2777,  0.4663,  0.6333,  0.8169,  1.0096,  1.1885,  1.3847,
     1.5803,  1.7571,  1.9380,  2.1398,  2.3414,  2.5407,  2.7360,  2.9375,
     0.1073,  0.2264,  0.4083,  0.5973,  0.7474,  0.9514,  1.1349,  1.3337,
     1.5433,  1.7348,  1.9380,  2.1436,  2.3441,  2.5438,  2.7457,  2.9383,
     0.1472,  0.2880,  0.4793,  0.6268,  0.8015,  1.0063,  1.1715,  1.3644,
     1.5525,  1.7410,  1.9258,  2.1227,  2.3214,  2.5149,  2.7148,  2.9196,
     0.1414,  0.2565,  0.4349,  0.6111,  0.7695,  0.9496,  1.1212,  1.3265,
     1.5218,  1.7209,  1.9015,  2.0887,  2.3158,  2.5077,  2.7233,  2.9421,
     0.1252,  0.2667,  0.4454,  0.6431,  0.8371,  1.0124,  1.2110,  1.4160,
     1.6240,  1.8242,  2.0047,  2.1974,  2.3902,  2.5778,  2.7637,  2.9481,
     0.1321,  0.2565,  0.3846,  0.5847,  0.7578,  0.9259,  1.0637,  1.2239,
     1.4690,  1.7346,  1.9750,  2.1882,  2.3712,  2.5509,  2.7280,  2.8885,
     0.1437,  0.2930,  0.4428,  0.6156,  0.8045,  0.9638,  1.1450,  1.3138,
     1.5144,  1.7355,  1.9469,  2.1534,  2.3414,  2.5452,  2.7353,  2.9334,
     0.1692,  0.2770,  0.3831,  0.6100,  0.7825,  0.9302,  1.0690,  1.2481,
     1.4615,  1.6799,  1.9165,  2.1739,  2.3435,  2.5349,  2.7520,  2.9163,
     0.1235,  0.2489,  0.4354,  0.6343,  0.8236,  1.0066,  1.1908,  1.3474,
     1.5656,  1.8275,  2.0620,  2.2548,  2.4135,  2.5913,  2.7639,  2.9334,
     0.1090,  0.1961,  0.3854,  0.5701,  0.7024,  0.8843,  1.1393,  1.3785,
     1.5940,  1.7797,  1.9442,  2.1740,  2.3853,  2.5773,  2.7727,  2.9406,
     0.1560,  0.3477,  0.5011,  0.6287,  0.7612,  0.9896,  1.1510,  1.3420,
     1.5435,  1.6816,  1.8731,  2.0651,  2.2613,  2.4999,  2.7027,  2.8971,
     0.1459,  0.2416,  0.3833,  0.5450,  0.7916,  0.9223,  1.0662,  1.1953,
     1.4029,  1.6616,  1.9320,  2.1459,  2.3386,  2.5081,  2.6799,  2.9195,
     0.1546,  0.3854,  0.6184,  0.8460,  1.0599,  1.2428,  1.3906,  1.5550,
     1.7388,  1.8945,  2.0757,  2.2386,  2.4014,  2.5705,  2.7574,  2.9400,
     0.1080,  0.2307,  0.4112,  0.6067,  0.7725,  0.9467,  1.1285,  1.3205,
     1.5348,  1.7609,  1.9937,  2.1878,  2.3583,  2.5515,  2.7199,  2.9049,
     0.1482,  0.3178,  0.4983,  0.6342,  0.7783,  0.9880,  1.2019,  1.3404,
     1.5223,  1.7296,  1.9211,  2.0943,  2.2928,  2.5008,  2.7136,  2.9224,
     0.1145,  0.2910,  0.4891,  0.6492,  0.8126,  0.9530,  1.1180,  1.3155,
     1.5054,  1.6893,  1.8899,  2.1188,  2.3389,  2.5512,  2.7313,  2.9224,
     0.0939,  0.1689,  0.3250,  0.5792,  0.7698,  0.9245,  1.1574,  1.3865,
     1.5959,  1.7977,  1.9821,  2.1528,  2.3326,  2.5540,  2.7553,  2.9179,
     0.1243,  0.2474,  0.3923,  0.6199,  0.7908,  0.9379,  1.1497,  1.3734,
     1.5582,  1.7420,  1.9539,  2.1385,  2.3240,  2.5277,  2.7311,  2.9178,
     0.1961,  0.3748,  0.5176,  0.6387,  0.8169,  1.0477,  1.2124,  1.3869,
     1.5604,  1.7225,  1.8770,  2.0837,  2.2960,  2.5103,  2.6945,  2.8862,
     0.1295,  0.2403,  0.4149,  0.6189,  0.7913,  0.9130,  1.0832,  1.2787,
     1.4860,  1.7112,  1.9502,  2.1348,  2.2776,  2.4982,  2.7431,  2.9522,
     0.0160,  0.0362,  0.0097,  0.0057, -0.0014, -0.0073, -0.0046, -0.0064,
    -0.0121,  0.0019,  0.0149, -0.0440, -0.0479, -0.0382, -0.0480, -0.0182,
     0.0170,  0.0114, -0.0298, -0.0175, -0.0033, -0.0354, -0.0510, -0.0025,
     0.0307,  0.0351,  0.0338,  0.0420,  0.0138, -0.0175, -0.0102,  0.0053,
     0.0084, -0.0003,  0.0412, -0.0027,  0.0145, -0.0039,  0.0083,  0.0400,
     0.0001, -0.0262,  0.0055, -0.0082,  0.0348,  0.0433,  0.0137, -0.0024,
    -0.0055,  0.0262,  0.0521,  0.0349,  0.0185,  0.0076, -0.0319, -0.0561,
    -0.0460, -0.0253, -0.0097,  0.0163,  0.0184, -0.0037, -0.0480, -0.0371,
     0.0628,  0.0665,  0.0296, -0.0057,  0.0253,  0.0227,  0.0350,  0.0692,
     0.0545,  0.0218,  0.0094, -0.0449, -0.0372,  0.0005,  0.0258,  0.0118,
     0.0285,  0.0760,  0.0822,  0.0527, -0.0299, -0.0049,  0.0170,  0.0195,
     0.0136,  0.0286,  0.0289,  0.0139,  0.0054,  0.0152,  0.0244,  0.0028,
    -0.0056, -0.0260,  0.0307,  0.0572, -0.0087,  0.0088,  0.0062,  0.0000,
     0.0125,  0.0000, -0.0292,  0.0820,  0.0872,  0.0646,  0.0346,  0.0076,
    -0.0022, -0.0253, -0.0567, -0.0188, -0.0336, -0.0673, -0.0549, -0.0166,
    -0.0259, -0.0140,  0.0040, -0.0029, -0.0430, -0.0531, -0.0253, -0.0019,
    -0.0071,  0.0393,  0.0072, -0.0327, -0.0236, -0.0235, -0.0177, -0.0186,
    -0.0280, -0.0201, -0.0077,  0.0383,  0.0418,  0.0321,  0.0294,  0.0169,
     0.0468,  0.0301,  0.0133,  0.0363,  0.0516,  0.0937,  0.1240,  0.1404,
     0.1325,  0.1178,  0.0999,  0.0251, -0.0037, -0.0495, -0.0703, -0.0219,
    -0.0261, -0.0304, -0.0204, -0.0372,  0.0355,  0.0131, -0.0093, -0.0099,
    -0.0069, -0.0034, -0.0065, -0.0208, -0.0231, -0.0117, -0.0211, -0.0243,
     0.0046, -0.0107, -0.0070,  0.0123,  0.0230,  0.0152,  0.0164,  0.0412,
     0.0619,  0.0858,  0.0862, -0.0056,  0.0125,  0.0182,  0.0347,  0.0388,
     0.0456,  0.0407, -0.0249, -0.0460,  0.0206,  0.0299,  0.0253,  0.0207,
     0.0177,  0.0238,  0.0253,  0.0030,  0.0042,  0.0020, -0.0081, -0.0136,
    -0.0290, -0.0042,  0.0122,  0.0051,  0.0107,  0.0228,  0.0211, -0.0068,
    -0.0436, -0.0299, -0.0078, -0.0779, -0.1157, -0.0679,  0.0172,  0.0150,
    -0.0051,  0.0081, -0.0512, -0.0616,  0.0576,  0.0799,  0.0803,  0.0336,
     0.0001, -0.0298, -0.0747, -0.0115, -0.0101, -0.0170, -0.0050,  0.0174,
    -0.0290, -0.0601, -0.0150,  0.0121,  0.0165,  0.0230,  0.0028, -0.0317,
    -0.0165,  0.0356,  0.0451,  0.0120,  0.0321,  0.0084, -0.0058,  0.0122,
     0.1935,  0.1802,  0.2195,  0.2410,  0.2201,  0.1915,  0.1840,  0.1935,
     0.2213,  0.2079,  0.1858,  0.1974,  0.2239,  0.2173,  0.1840,  0.2120,
     0.4912,  0.4777,  0.4607,  0.4395,  0.4426,  0.4388,  0.4416,  0.4345,
     0.4239,  0.4331,  0.4522,  0.4423,  0.4475,  0.4387,  0.4525,  0.4446,
};

static const float lsp44s[] = {
     0.0927,  0.2291,  0.4059,  0.5779,  0.7288,  0.8821,  1.0377,  1.1915,
     1.3433,  1.4931,  1.6475,  1.7989,  1.9381,  2.0858,  2.2321,  2.3765,
     2.5187,  2.6530,  2.7895,  2.9354,  0.0944,  0.1974,  0.3046,  0.4714,
     0.6116,  0.7829,  0.9027,  1.0375,  1.1869,  1.3488,  1.5036,  1.6781,
     1.8276,  1.9983,  2.1449,  2.3089,  2.4534,  2.6113,  2.7553,  2.9062,
     0.1168,  0.2843,  0.4907,  0.6706,  0.8100,  0.9417,  1.0753,  1.2014,
     1.3151,  1.4496,  1.5832,  1.7379,  1.8642,  2.0230,  2.1681,  2.3250,
     2.4676,  2.6242,  2.7602,  2.9066,  0.1353,  0.2335,  0.3370,  0.4380,
     0.5819,  0.7353,  0.8671,  1.0160,  1.1435,  1.2977,  1.4860,  1.6739,
     1.8412,  2.0028,  2.1537,  2.3124,  2.4741,  2.6272,  2.7862,  2.9536,
     0.1003,  0.2226,  0.3584,  0.4971,  0.6291,  0.7710,  0.9157,  1.0669,
     1.2143,  1.3624,  1.5104,  1.6681,  1.8164,  1.9823,  2.1394,  2.3082,
     2.4677,  2.6306,  2.7909,  2.9382,  0.1056,  0.2027,  0.2956,  0.4005,
     0.5215,  0.6708,  0.8545,  1.0557,  1.2344,  1.4023,  1.5676,  1.7278,
     1.8808,  2.0381,  2.1846,  2.3376,  2.4887,  2.6377,  2.7878,  2.9504,
     0.1015,  0.2462,  0.4122,  0.5783,  0.7233,  0.8833,  1.0377,  1.1903,
     1.3341,  1.4727,  1.6138,  1.7582,  1.8912,  2.0370,  2.1701,  2.3125,
     2.4500,  2.6006,  2.7507,  2.9166,  0.1787,  0.2418,  0.3265,  0.5379,
     0.6584,  0.7681,  0.9545,  1.1050,  1.2125,  1.3528,  1.4763,  1.6705,
     1.8136,  1.9594,  2.0936,  2.2724,  2.4394,  2.5919,  2.7037,  2.8747,
     0.0859,  0.1600,  0.2980,  0.4933,  0.6696,  0.8285,  0.9958,  1.1545,
     1.3107,  1.4591,  1.6127,  1.7652,  1.9143,  2.0680,  2.2171,  2.3643,
     2.5141,  2.6611,  2.8143,  2.9691,  0.0910,  0.2110,  0.3364,  0.4718,
     0.5856,  0.7298,  0.8910,  1.0514,  1.1988,  1.3572,  1.5178,  1.6861,
     1.8399,  2.0099,  2.1639,  2.3225,  2.4774,  2.6321,  2.7863,  2.9412,
     0.1904,  0.2874,  0.3681,  0.4981,  0.6248,  0.7880,  0.9121,  1.0750,
     1.2185,  1.3809,  1.5296,  1.7007,  1.8592,  2.0470,  2.1913,  2.3250,
     2.4519,  2.5984,  2.7408,  2.9023,  0.0917,  0.2067,  0.3246,  0.4961,
     0.6310,  0.8024,  0.9438,  1.1008,  1.2362,  1.3892,  1.5407,  1.7033,
     1.8427,  2.0061,  2.1498,  2.3117,  2.4550,  2.6053,  2.7462,  2.9029,
     0.0989,  0.2193,  0.3756,  0.5410,  0.6929,  0.8368,  0.9801,  1.1250,
     1.2677,  1.4184,  1.5677,  1.7292,  1.8770,  2.0311,  2.1803,  2.3306,
     2.4836,  2.6339,  2.7943,  2.9549,  0.0861,  0.1943,  0.3057,  0.4867,
     0.6194,  0.7592,  0.9184,  1.1052,  1.2486,  1.4064,  1.5609,  1.7273,
     1.8703,  2.0291,  2.1686,  2.3225,  2.4628,  2.6115,  2.7471,  2.9005,
     0.0932,  0.2110,  0.3737,  0.5479,  0.7120,  0.8570,  0.9975,  1.1364,
     1.2772,  1.4220,  1.5612,  1.7089,  1.8410,  1.9827,  2.1263,  2.2859,
     2.4459,  2.6172,  2.7788,  2.9395,  0.1193,  0.2341,  0.3523,  0.5029,
     0.6437,  0.7803,  0.9367,  1.1007,  1.2392,  1.3869,  1.5425,  1.7168,
     1.8709,  2.0248,  2.1584,  2.2949,  2.4308,  2.5823,  2.7235,  2.9034,
     0.0834,  0.1988,  0.3557,  0.5261,  0.6767,  0.8427,  1.0029,  1.1683,
     1.3138,  1.4527,  1.6046,  1.7583,  1.9011,  2.0517,  2.1928,  2.3397,
     2.4839,  2.6291,  2.7771,  2.9329,  0.0938,  0.1967,  0.3213,  0.4675,
     0.6068,  0.7664,  0.9418,  1.1120,  1.2535,  1.3932,  1.5243,  1.6801,
     1.8346,  1.9931,  2.1376,  2.3035,  2.4636,  2.6244,  2.7829,  2.9371,
     0.1017,  0.2552,  0.4327,  0.6017,  0.7467,  0.8797,  1.0097,  1.1442,
     1.2628,  1.4049,  1.5541,  1.7090,  1.8461,  1.9982,  2.1486,  2.3029,
     2.4513,  2.6075,  2.7594,  2.9209,  0.1031,  0.2295,  0.3747,  0.5122,
     0.6596,  0.7935,  0.9345,  1.1050,  1.2384,  1.3543,  1.4739,  1.6136,
     1.7447,  1.8914,  2.0434,  2.1916,  2.3557,  2.5396,  2.7419,  2.9401,
     0.1007,  0.2374,  0.3715,  0.5173,  0.6465,  0.8069,  0.9553,  1.1145,
     1.2594,  1.4143,  1.5617,  1.7166,  1.8457,  2.0012,  2.1462,  2.2864,
     2.4258,  2.5910,  2.7372,  2.9018,  0.0808,  0.1726,  0.2849,  0.4592,
     0.6118,  0.7853,  0.9588,  1.1256,  1.2751,  1.4392,  1.5898,  1.7514,
     1.8977,  2.0554,  2.1937,  2.3430,  2.4831,  2.6249,  2.7601,  2.9155,
     0.1669,  0.2574,  0.3694,  0.5569,  0.6773,  0.8061,  1.0160,  1.1667,
     1.2791,  1.4041,  1.5452,  1.7207,  1.8524,  2.0038,  2.1414,  2.3338,
     2.4747,  2.6157,  2.7303,  2.8848,  0.1598,  0.2521,  0.3416,  0.5149,
     0.6703,  0.7941,  0.9408,  1.1164,  1.2017,  1.3293,  1.4908,  1.6783,
     1.8438,  1.9927,  2.1149,  2.2698,  2.4420,  2.6193,  2.7583,  2.9103,
     0.0902,  0.1978,  0.3265,  0.4578,  0.5878,  0.7439,  0.9110,  1.0906,
     1.2556,  1.4125,  1.5688,  1.7295,  1.8829,  2.0472,  2.2058,  2.3537,
     2.5075,  2.6548,  2.8058,  2.9538,  0.0818,  0.1695,  0.2794,  0.4470,
     0.6069,  0.7641,  0.9313,  1.0946,  1.2411,  1.4072,  1.5640,  1.7186,
     1.8651,  2.0254,  2.1726,  2.3286,  2.4784,  2.6287,  2.7750,  2.9339,
     0.1980,  0.3134,  0.4099,  0.4975,  0.6491,  0.8376,  0.9441,  1.0298,
     1.1795,  1.3866,  1.5784,  1.7209,  1.8137,  1.9271,  2.0863,  2.2930,
     2.4696,  2.6184,  2.7587,  2.9251,  0.1338,  0.2341,  0.3566,  0.4797,
     0.6129,  0.7580,  0.9093,  1.0491,  1.1911,  1.3313,  1.4841,  1.6503,
     1.8035,  1.9685,  2.1128,  2.2694,  2.4093,  2.5728,  2.7206,  2.8994,
     0.0937,  0.2034,  0.3447,  0.5032,  0.6370,  0.7993,  0.9674,  1.1323,
     1.2830,  1.4199,  1.5492,  1.7010,  1.8513,  2.0087,  2.1550,  2.3115,
     2.4643,  2.6237,  2.7812,  2.9392,  0.1085,  0.2152,  0.3126,  0.4569,
     0.5718,  0.7213,  0.8837,  1.0604,  1.2053,  1.3755,  1.5397,  1.7001,
     1.8409,  2.0039,  2.1498,  2.3080,  2.4535,  2.6063,  2.7505,  2.9110,
     0.0562,  0.2066,  0.4034,  0.5490,  0.6682,  0.7924,  0.9495,  1.0800,
     1.1869,  1.3156,  1.4834,  1.6619,  1.8404,  2.0199,  2.1509,  2.2755,
     2.4072,  2.5580,  2.6993,  2.8913,  0.0939,  0.2303,  0.3742,  0.5260,
     0.6662,  0.8294,  0.9769,  1.1315,  1.2792,  1.4153,  1.5436,  1.6701,
     1.8215,  1.9920,  2.1310,  2.3005,  2.4534,  2.5786,  2.7204,  2.9068,
     0.1005,  0.2442,  0.3898,  0.5398,  0.6958,  0.8474,  1.0008,  1.1556,
     1.3020,  1.4456,  1.5954,  1.7470,  1.8922,  2.0500,  2.2019,  2.3492,
     2.4963,  2.6412,  2.7890,  2.9423,  0.1022,  0.2031,  0.3213,  0.4402,
     0.5637,  0.7117,  0.8673,  1.0242,  1.1727,  1.3206,  1.4846,  1.6465,
     1.8015,  1.9655,  2.1233,  2.2873,  2.4464,  2.6074,  2.7685,  2.9409,
     0.1985,  0.3497,  0.4622,  0.5982,  0.7489,  0.8752,  0.9925,  1.1679,
     1.3288,  1.4606,  1.5820,  1.7492,  1.8922,  2.0511,  2.1780,  2.3373,
     2.4760,  2.6233,  2.7466,  2.8978,  0.1284,  0.2433,  0.3630,  0.4852,
     0.6117,  0.7460,  0.8904,  1.0360,  1.1738,  1.3142,  1.4696,  1.6185,
     1.7719,  1.9318,  2.0961,  2.2697,  2.4408,  2.6046,  2.7681,  2.9451,
     0.1042,  0.2286,  0.3598,  0.5064,  0.6438,  0.7899,  0.9350,  1.0891,
     1.2323,  1.3807,  1.5225,  1.6747,  1.8153,  1.9669,  2.1145,  2.2832,
     2.4430,  2.6085,  2.7748,  2.9346,  0.0780,  0.1724,  0.2440,  0.3489,
     0.5280,  0.7426,  0.9272,  1.0914,  1.2562,  1.4188,  1.5804,  1.7376,
     1.8909,  2.0473,  2.1946,  2.3457,  2.4950,  2.6424,  2.7926,  2.9549,
     0.1103,  0.2608,  0.4087,  0.5538,  0.6923,  0.8418,  0.9940,  1.1507,
     1.2919,  1.4406,  1.5802,  1.7262,  1.8638,  2.0085,  2.1572,  2.2975,
     2.4329,  2.5866,  2.7380,  2.9107,  0.1297,  0.2532,  0.4003,  0.5329,
     0.6733,  0.7950,  0.9557,  1.0859,  1.2235,  1.3538,  1.5037,  1.6389,
     1.7964,  1.9285,  2.0898,  2.2541,  2.4231,  2.5711,  2.6875,  2.8947,
     0.0871,  0.1968,  0.3425,  0.4949,  0.6424,  0.7959,  0.9534,  1.1132,
     1.2656,  1.4229,  1.5785,  1.7271,  1.8729,  2.0355,  2.1998,  2.3562,
     2.5151,  2.6663,  2.8145,  2.9534,  0.1038,  0.2204,  0.3248,  0.4566,
     0.5947,  0.7443,  0.8811,  1.0379,  1.2031,  1.3772,  1.5430,  1.7092,
     1.8625,  2.0322,  2.1904,  2.3417,  2.4960,  2.6458,  2.7979,  2.9485,
     0.1329,  0.2763,  0.3943,  0.5147,  0.6512,  0.8071,  0.9410,  1.0879,
     1.2298,  1.3850,  1.5282,  1.6674,  1.8137,  1.9993,  2.1344,  2.2749,
     2.4257,  2.5863,  2.7410,  2.9184,  0.1052,  0.2142,  0.3584,  0.5033,
     0.6387,  0.7804,  0.9320,  1.0780,  1.2172,  1.3764,  1.5421,  1.6887,
     1.8246,  1.9833,  2.1245,  2.2797,  2.4237,  2.5779,  2.7257,  2.9097,
     0.1092,  0.2676,  0.4071,  0.5355,  0.6661,  0.8142,  0.9621,  1.1173,
     1.2628,  1.4185,  1.5696,  1.7220,  1.8595,  2.0178,  2.1720,  2.3221,
     2.4718,  2.6259,  2.7775,  2.9334,  0.0929,  0.2017,  0.3073,  0.4570,
     0.5775,  0.7635,  0.9299,  1.0832,  1.2334,  1.3935,  1.5420,  1.7112,
     1.8601,  2.0309,  2.1735,  2.3230,  2.4543,  2.6034,  2.7418,  2.8988,
     0.0775,  0.2005,  0.3490,  0.5200,  0.6747,  0.8383,  0.9885,  1.1738,
     1.3141,  1.4236,  1.5892,  1.7402,  1.8474,  2.0210,  2.1593,  2.2730,
     2.4235,  2.5604,  2.7128,  2.9005,  0.1104,  0.2292,  0.3353,  0.4732,
     0.6152,  0.7675,  0.9164,  1.0907,  1.2594,  1.4064,  1.5218,  1.6426,
     1.8018,  1.9937,  2.1362,  2.2961,  2.4523,  2.6083,  2.7613,  2.9202,
     0.0826,  0.2000,  0.3384,  0.5144,  0.6694,  0.8377,  0.9870,  1.1461,
     1.2950,  1.4495,  1.5872,  1.7387,  1.8793,  2.0329,  2.1723,  2.3114,
     2.4415,  2.5908,  2.7354,  2.9028,  0.1063,  0.2268,  0.3442,  0.4735,
     0.6116,  0.7507,  0.9028,  1.0768,  1.2426,  1.4052,  1.5566,  1.7015,
     1.8243,  1.9742,  2.1276,  2.2824,  2.4262,  2.5953,  2.7627,  2.9290,
     0.1150,  0.2814,  0.4543,  0.6095,  0.7373,  0.8592,  0.9908,  1.1108,
     1.2339,  1.3590,  1.4864,  1.6168,  1.7392,  1.8752,  2.0212,  2.1688,
     2.3128,  2.4869,  2.7019,  2.9239,  0.0948,  0.2074,  0.3433,  0.4943,
     0.6346,  0.7645,  0.8809,  1.0610,  1.2307,  1.3487,  1.4655,  1.6186,
     1.7534,  1.8859,  2.0486,  2.2200,  2.3835,  2.5581,  2.7565,  2.9502,
     0.1062,  0.2239,  0.3683,  0.5197,  0.6704,  0.8184,  0.9642,  1.1127,
     1.2556,  1.3976,  1.5405,  1.6940,  1.8375,  1.9888,  2.1377,  2.2980,
     2.4555,  2.6184,  2.7849,  2.9452,  0.0888,  0.2005,  0.2847,  0.4322,
     0.5763,  0.7577,  0.9262,  1.1095,  1.2719,  1.4331,  1.5843,  1.7452,
     1.8845,  2.0385,  2.1805,  2.3345,  2.4750,  2.6217,  2.7555,  2.9013,
     0.1713,  0.2617,  0.3868,  0.5859,  0.7073,  0.8535,  1.0593,  1.1778,
     1.3109,  1.4508,  1.5910,  1.7463,  1.8911,  2.0651,  2.2035,  2.3355,
     2.4947,  2.6440,  2.7424,  2.8943,  0.1346,  0.2549,  0.4089,  0.5488,
     0.6949,  0.8394,  0.9810,  1.1145,  1.2528,  1.4044,  1.5423,  1.6872,
     1.8274,  1.9726,  2.1403,  2.2809,  2.4128,  2.5564,  2.6887,  2.8895,
     0.0776,  0.1621,  0.2553,  0.4191,  0.5988,  0.7921,  0.9651,  1.1350,
     1.2930,  1.4475,  1.6011,  1.7585,  1.9068,  2.0638,  2.2102,  2.3594,
     2.5096,  2.6581,  2.8099,  2.9654,  0.0864,  0.1778,  0.2854,  0.4235,
     0.5568,  0.7220,  0.8963,  1.0609,  1.2217,  1.3830,  1.5422,  1.7018,
     1.8551,  2.0206,  2.1783,  2.3328,  2.4869,  2.6366,  2.7923,  2.9539,
     0.1144,  0.2576,  0.4186,  0.5594,  0.6875,  0.8221,  0.9598,  1.0944,
     1.2273,  1.3713,  1.5152,  1.6628,  1.8070,  1.9525,  2.0965,  2.2535,
     2.4132,  2.5725,  2.7250,  2.9150,  0.1079,  0.2221,  0.3334,  0.4845,
     0.6083,  0.7516,  0.9018,  1.0594,  1.2060,  1.3673,  1.5212,  1.6880,
     1.8208,  1.9831,  2.1269,  2.2909,  2.4366,  2.6027,  2.7339,  2.8924,
     0.0994,  0.2233,  0.3634,  0.5145,  0.6568,  0.8131,  0.9746,  1.1296,
     1.2666,  1.4116,  1.5748,  1.7264,  1.8649,  2.0217,  2.1716,  2.3293,
     2.4900,  2.6455,  2.7818,  2.9362,  0.1120,  0.2079,  0.3128,  0.4124,
     0.5291,  0.6816,  0.8478,  1.0150,  1.1772,  1.3456,  1.5208,  1.6882,
     1.8458,  2.0078,  2.1627,  2.3198,  2.4733,  2.6251,  2.7796,  2.9489,
     0.0853,  0.2030,  0.3669,  0.5326,  0.6678,  0.8086,  0.9526,  1.1142,
     1.2551,  1.4158,  1.5694,  1.7073,  1.8431,  1.9686,  2.1153,  2.2376,
     2.3686,  2.5591,  2.7320,  2.9104,  0.0905,  0.2166,  0.3539,  0.5201,
     0.6700,  0.8346,  0.9883,  1.1457,  1.2714,  1.3845,  1.5172,  1.6688,
     1.8008,  1.9535,  2.1019,  2.2708,  2.4135,  2.5974,  2.7486,  2.9033,
     0.0084,  0.0374,  0.0164, -0.0153,  0.0288,  0.0107, -0.0255, -0.0242,
     0.0000, -0.0055, -0.0081, -0.0075, -0.0022, -0.0052, -0.0069, -0.0017,
     0.0003,  0.0091,  0.0028, -0.0027,  0.0085,  0.0043, -0.0235, -0.0411,
     0.0202,  0.0359,  0.0376,  0.0321,  0.0306, -0.0358, -0.0276, -0.0090,
     0.0032,  0.0048,  0.0309,  0.0332,  0.0284,  0.0237,  0.0051, -0.0101,
    -0.0233, -0.0428, -0.0585, -0.0387,  0.0039,  0.0081,  0.0029, -0.0017,
    -0.0006, -0.0068,  0.0044,  0.0182,  0.0376,  0.0387, -0.0334, -0.0269,
    -0.0182, -0.0069, -0.0026,  0.0035, -0.0049, -0.0212, -0.0408, -0.0245,
     0.0186,  0.0189,  0.0153,  0.0120,  0.0157,  0.0055, -0.0046,  0.0179,
     0.0284, -0.0032, -0.0261, -0.0205, -0.0039,  0.0174,  0.0299,  0.0207,
     0.0012, -0.0056,  0.0010,  0.0141, -0.0119,  0.0190,  0.0315,  0.0033,
    -0.0128,  0.0300,  0.0328,  0.0308,  0.0353,  0.0266,  0.0066, -0.0328,
    -0.0273,  0.0054,  0.0145,  0.0175,  0.0015, -0.0171,  0.0062, -0.0164,
     0.0045, -0.0071,  0.0025,  0.0278,  0.0283,  0.0117, -0.0026, -0.0285,
    -0.0408, -0.0366, -0.0059, -0.0208, -0.0354, -0.0334, -0.0263, -0.0064,
     0.0072, -0.0006, -0.0235, -0.0037, -0.0307, -0.0294, -0.0163, -0.0197,
    -0.0235,  0.0192,  0.0013, -0.0219, -0.0123, -0.0004, -0.0081, -0.0096,
    -0.0123, -0.0101,  0.0021,  0.0151,  0.0106,  0.0151,  0.0292,  0.0033,
     0.0283,  0.0124,  0.0058, -0.0017, -0.0038,  0.0152,  0.0141,  0.0132,
     0.0178,  0.0157,  0.0073,  0.0176,  0.0141,  0.0097, -0.0092, -0.0163,
    -0.0230, -0.0134, -0.0099, -0.0147,  0.0040, -0.0183, -0.0175, -0.0080,
    -0.0083, -0.0290, -0.0417, -0.0398, -0.0269, -0.0199, -0.0143, -0.0053,
    -0.0099, -0.0054, -0.0199, -0.0219, -0.0170,  0.0107,  0.0194,  0.0035,
     0.0437,  0.0406,  0.0215,  0.0120,  0.0053, -0.0028,  0.0238,  0.0337,
     0.0217,  0.0011,  0.0227,  0.0244,  0.0327,  0.0378,  0.0437,  0.0356,
    -0.0033,  0.0113,  0.0407,  0.0334, -0.0125, -0.0003, -0.0141, -0.0273,
    -0.0137, -0.0079, -0.0145, -0.0071,  0.0114,  0.0181,  0.0150,  0.0085,
    -0.0077, -0.0038, -0.0219, -0.0263, -0.0187, -0.0233,  0.0133,  0.0265,
    -0.0156, -0.0091, -0.0110, -0.0016,  0.0143,  0.0177,  0.0240,  0.0082,
    -0.0143, -0.0257, -0.0014,  0.0002,  0.0082,  0.0180,  0.0325,  0.0340,
    -0.0153, -0.0389, -0.0240,  0.0082,  0.0140,  0.0046, -0.0138, -0.0378,
    -0.0366,  0.0297,  0.0252,  0.0078,  0.0063,  0.0006,  0.0044,  0.0074,
     0.0094,  0.0113,  0.0105,  0.0137,  0.0438,  0.0262, -0.0078, -0.0185,
    -0.0215, -0.0407, -0.0435, -0.0208, -0.0004, -0.0144, -0.0205, -0.0248,
    -0.0159, -0.0069, -0.0153,  0.0132,  0.0355,  0.0298,  0.0120,  0.0072,
     0.0236,  0.0526,  0.0479,  0.0233, -0.0133, -0.0283, -0.0468, -0.0549,
    -0.0370,  0.0032,  0.0056,  0.0023,  0.0050,  0.0024,  0.0279,  0.0116,
    -0.0045, -0.0012,  0.0107,  0.0190,  0.0253,  0.0191,  0.0043,  0.0193,
    -0.0348, -0.0246,  0.0123,  0.0210,  0.0135, -0.0096, -0.0109, -0.0076,
    -0.0156, -0.0290,  0.0160,  0.0194,  0.0219,  0.0259,  0.0250,  0.0195,
     0.4948,  0.4961,  0.4940,  0.4878,  0.4849,  0.4727,  0.4571,  0.4551,
     0.4534,  0.4468,  0.4412,  0.4354,  0.4298,  0.4272,  0.4498,  0.4506,
     0.4560,  0.4592,  0.4758,  0.4941,  0.2476,  0.1771,  0.1974,  0.1881,
     0.1667,  0.1826,  0.2067,  0.2031,  0.1734,  0.1534,  0.1415,  0.1761,
     0.1897,  0.1772,  0.1651,  0.1247,  0.1041,  0.1231,  0.1809,  0.2234,
};

static const int16_t shape8[] = {
      2765,   1262,   6624,    867,    688,   1884,   3245,   1248,
     -2160,    593,    182,  -1004,  -1067,    687,   1021,   -920,
      1396,   -242,  -2817,  -1838,  -3351,   1000,   5995,   2459,
      -283,   1909,   1452,  -4569,    556,  -2004,    -42,  -3393,
       -50,   -385,    597,    983,    420,   6311,  -1572,  -1665,
      6128,  -1688,  -5191,   -337,  -4199,    371,   1032,    -84,
      2169,    931,   -392,   -250,    137,    831,   8194,   -489,
       -92,    209,    115,   1453,    246,   -647,    936,   1097,
      -400,    597,    392,     93,  -7709,   -711,   -724,   2051,
       497,   1919,   -876,   -769,   -172,   2972,    952,    555,
       151,   -617,    773,   4840,  -3671,    841,    244,   -661,
     -3424,    958,     81,    532,   -315,    796,   5491,   -516,
        -1,  -1371,   -531,  -5538,    313,  -1749,   2413,   -835,
     -3143,   -244,  -3470,   -850,  -4241,   -859,    -74,   2141,
     -1005,   4643,   -339,   4089,   -861,  -6612,    483,  -2888,
      -580,    -45,   3662,    918,   -317,   3596,   -741,    897,
     -2578,   -654,  -1628,  -1865,    629,   3219,    214,  -1898,
      1173,  -4509,   1682,  -2161,    697,   -147,   9839,    751,
     -1094,   -341,   -669,  -1322,    649,   -832,   -382,  -5467,
       -44,   3510,   1312,   3104,   -202,   1870,   -155,    601,
       719,    -22,   -350,    394,     81,    397,  -9185,   -174,
       351,  -4717,  -4450,   3672,   1163,   2351,   1720,   1048,
     -1221,   -280,    -18,    -15,    678,  -3931,   4707,    -99,
      1823,   -535,  -1836,    138,   1166,  -3031,   5515,   1362,
      1235,    455,    595,  -3671,   1102,   -163,     62,   1104,
       813,    870,   -295,  -1088,   -299,  -3976,    805,  -7468,
      -412,  -2109,    236,     46,  -5764,    615,  -1475,    853,
       790,  -6197,    312,    637,  -3923,   -422,  -1086,  -5647,
       878,  -1410,   2085,    -51,  -2941,   -769,    -63,    838,
       823,    741,   2785,    450,  -7003,   -121,   -915,     60,
       -41,      0,    -39,   8774,    647,   -521,    379,   -342,
      -344,    818,   1316,   1056,    182,   2765,   -467,   7886,
        45,    791,   -415,   3864,  -2428,   2255,   -661,    -64,
      1693,    144,   1784,  -1194,    -46,  -1856,   1208,   4131,
       914,   8028,    -17,   1939,  -1415,    533,    291,   -466,
       186,   -705,    668,   -614,   -253,  -2190,    287,   3929,
      1472,  -1561,      5,    889,  -2020,    158,    -14,  -1419,
      1338,   -353,    622,    -54,     87,  -1104,  -2911,    513,
      -632,   1533,   -267,     22,   6567,    295,    325,   6883,
       963,   -373,   -349,    183,    896,   1845,  -1157,    351,
      -367,   1171,   4362,    508,   5632,    704,  -1420,  -1886,
       686,   5230,     -9,   2422,    230,    264,   3738,   -270,
      -344,   -528,   -936,   2286,   -540,   4274,    337,   -665,
       737,   1639,  -1307,   5827,    592,  -1372,   -412,   1419,
      4579,    335,    223,  -1067,   -112,   -446,    149,   1375,
      -155,   -392,  -1980,    561,    -67,    341,   6957,    475,
     11449,     39,     81,    766,  -1880,    558,   -134,  -7940,
      -489,    249,   -886,   -358,   6850,   2794,  -2217,   1111,
     -1222,  -1130,   -818,   1076,  -1823,    865,  -2220,   1179,
      4492,    224,  -2073,   -338,  -5351,   -390,    133,    496,
       -42,    -16,     46,    437,    322,   -275,    -72,     48,
      -325,    313,   1108,  -1044,   -851,  -5030,   1035,   4316,
     -1281,   -913,  -1419,   -941,   1914,    960,   1242,    202,
      5109,    475,   1254,   1725,  -1504,     -4,   -269,   -421,
      -150,  -4409,   -610,  -1548,  -1684,   -817,   -210,     72,
      -679,   -106,  -3809,  -1137,      4,   7220,    -95,    810,
      2432,   -331,    492,    -81,    138,    -62,   -613,   -636,
       106,  10908,    912,    144,    192,   1251,  -3970,   -954,
      1145,   1175,  -1721,   5326,  -1721,   -569,  -3661,  -1166,
      6605,   -744,  -1494,    853,    134,   3259,   -504,  -1740,
       180,   -207,   -659,    196,    179,   -106,    118,    789,
      -834,  10339,   -420,  -3002,   -456,    113,   6435,    949,
       721,  -2709,  -1599,   -684,  -8068,    174,  -1416,    -58,
       974,    308,   -726,   1237,  -1594,    519,   -131,   -198,
     -1395,   1180,   -173,    338,  -5584,   -279,   -236,   6817,
        89,   -220,   3967,   -107,     65,   2479,    -22,    642,
      7179,   1179,   -229,   -202,   4948,  -5465,   1632,  -1285,
      2188,  -2037,   1763,    636,   4247,    995,   1176,      2,
     -2398,   1236,   -661,    382,  -1075,    130,    103,   -187,
       604,   -306,  -2635,  -2185,    157,    775,   6373,   -924,
      1758,  -3043,   1707,   2852,  -2148,   6779,    376,  -1018,
     -2374,   -989,    249,  -5393,    -32,    538,   -416,  -5108,
      -658,   1839,    419,   1153,  -3956,   -617,  -1925,   5434,
       626,   1488,  -3824,    140,    370,  -2230,  -7031,   1989,
      -581,    639,  -4249,   -216,   1225,   -776,   -973,   -542,
     -2922,  -1783,  -2430,  -3251,    958,   3313,    636,  -6277,
       119,   -866,   -406,   -156,  -4839,    966,   -469,   5559,
       193,    376,  -4810,   -870,    163,   4130,   2596,   2203,
      -114,   2423,   -622,   -424,   2935,    749,   2500,   4230,
      -162,  -1489,   2169,  -5156,    751,   2748,   2240,  -1549,
      4821,    175,   2274,    854,   2993,    838,    322,  -2663,
      -794,   -283,    -98,   1393,   -709,    362,    285,  -1085,
      1075,    374,   1062,   6512,  -3375,  -3138,   3939,   3628,
      3926,  -2442,   1989,   -583,  -1282,  -1882,  -3920,  -4593,
       540,   2667,   -155,    156,  -2428,   1229,   -436,   1754,
      2815,  -1634,  -2299,   1155,    990,   3689,  -1242,   3145,
      3951,     45,    186,  -1110,    257,   -335,   8929,    533,
      -173,    813,     21,   1584,    541,    -44,   1349,    108,
     -5163,   -684,   5522,   -868,  -5795,    769,    583,   2827,
      -818,  -5551,   1485,     37,   -631,   -262,  -4352,   -532,
        61,    434,   1775,   8974,   -112,   -852,  -1227,  -1645,
       260,    298,   -430,    863,  -3860,    -97,   6467,   -328,
     -2418,    -61,  -1253,   1575,     30,  -5683,   2113,    973,
      -371,    -51,   5355,    471,   -584,   -492,  -2187,   2799,
      -506,   4435,   1950,  -3415,   -363,   -404,    941,   2628,
      -146,    434,   2853,    889,    634,   5749,    -54,    126,
       189,  -1384,   -379,  -3205,   -540,   1720,    942,  -6300,
      -286,    -58,  -1083,   3782,    251,   -334,   4172,    631,
        17,     83,    707,   1322,   3273,   -573,   1024,  -6112,
      -540,   4916,    155,  -1209,    308,   -738,  -2150,    786,
      -168,     68,   -201,    -64,   -752,  -1595,  -9188,    320,
      -426,    111,  -2183,    886,   -737,    193,   -837,   3219,
      5936,   4022,    764,    -82,   3344,   -855,   3705,  -2652,
      1533,   -206,  -3673,   1235,   1163,  -1217,   3183,   1313,
      -745,   6554,   7019,   1302,   2129,    268,    -70,    110,
       412,   -155,  -1703,  -4945,    105,  -1705,    412,  -6588,
      2905,   1279,     73,  -2446,  -5635,   1168,   2974,    404,
      -650,    265,  -1773,  -1857,   -108,   -651,    657,   -824,
      3352,    177,    155,   1275,   2012,     31,     -7,  -1065,
      2062,    411,  -2325,   -208,  -6306,    683,   1037,  -1060,
       191,   -187,   -585,   6103,   -459,    571,   1640,   -693,
       922,  -2291,    537,   1934,    263,   3847,   -202,   7060,
       136,   4368,   2963,  -1032,     18,   1836,   -144,  -3853,
       474,   2005,   1298,   2396,    825,  -2274,     12,   3759,
      -394,    907,    490,   2997,   2180,  -1570,  -1000,   5982,
      -129,   -820,  -3001,   2684,  -1132,  -2908,   1101,   5044,
       393,  -1637,    393,   1343,  -1231,    404,   1817,   1463,
      -443,   1053,   -584,  -7756,     45,    499,  -4109,    214,
       535,  -3348,     54,  -1594,   6913,      0,    -94,   8772,
       500,     13,    734,      5,    798,  -1521,    853,    -82,
      -263,   -619,   1558,    456,   5911,  -1376,   1054,   -971,
     -1275,   -147,   -111,   4964,    321,     67,   7024,   -525,
       620,    883,  -1058,  -1132,  -3313,    630,    226,  -6201,
     -1011,   1111,   -820,   -295,    580,    636,   2452,   -638,
      6840,   -285,    655,   1502,  -1049,   -567,    329,    -33,
      -249,    570,    186,    167,    780,   1104,     42,    197,
     10034,  -1295,   -208,     32,  -1473,    716,    159,  -6672,
       -45,    519,  -4300,   -246,   3692,   5062,   4305,   -748,
      -548,    181,   -382,   -881,  -1968,    580,    964,   -420,
      -327,  -3397,  -1584,   2770,  -3501,   1659,  -1252,   2352,
         6,     30,      0,   -273,     27,   -204,   -485,   -432,
        -6,    176,   -428,   1562,    104,  -6511,  -1084,   2205,
       -11,  -5254,   -132,   -508,    -69,    373,  -1503,    208,
       -58,   5311,     92,   -966,  -6563,   -480,    -24,   1424,
     -1498,   -165,   4594,   -903,  -1787,   -353,  -7284,    142,
      1008,    875,  -6109,    -16,    162,   4895,     30,   -188,
      2099,   1581,    300,   -259,   -921,   -386,   -488,    140,
      -482,   7135,    -77,    494,   -196,   3207,   -250,   -102,
       318,    978,    161,   7292,     55,  -1347,  -2605,    898,
      1833,    602,  -1988,    630,   -145,   -102,   -414,   -133,
       417,   -603,    156,  -1151,   -395,    625,  -1676,     86,
       680,  13321,    322,  -5816,   -292,   -223,   4205,   -361,
       903,   -224,   1745,     95,  -6598,     79,   2323,    -24,
       263,    778,    146,   -939,   1814,   1945,    720,    367,
     -2987,    899,  -4409,    136,  -3185,   -342,  -3304,   1016,
       284,   -345,   2313,   -403,    389,  -1403,   1835,    151,
      -132,  -1702,   -339,  -5679,   2026,  -2990,     47,   -564,
       399,  -2167,   1392,   1384,   5094,  -2954,   4467,    -22,
       -23,    408,   1620,   1381,   2380,    805,    380,    -36,
      -803,    765,   -778,    905,   -200,   -669,   3942,    289,
       176,  -4767,   2015,  -3554,   1206,   6071,    180,   2057,
       -48,    365,    -48,  -2423,    585,   -109,  -1298,   2519,
      -525,   -589,    374,    976,   3667,   2091,  -2890,   1371,
      -726,   -216,  -1027,   -116,   2122,   -619,  -3826,   4649,
      1167,      0,   1237,   1538,   2505,   -548,  -3093,   1344,
      -558,  -1927,    199,   2462,   1327,   4597,    833,  -3660,
      -341,  -1010,    428,    148,  -1682,    130,   1569,   8785,
      -752,  -1032,  -2407,    353,   -379,   3311,    892,    893,
     -2596,   -217,   -835,  -2291,   1137,  -4339,    -58,   2759,
       991,   3527,   -281,  -6050,  -1251,   1802,      8,  -3916,
};

static const int16_t shape8s[] = {
      2639,    550,   6487,   2812,   1014,   1926,   2959,    757,
     -1452,   -111,    -45,   -409,    401,    545,   1545,  -1677,
        75,   -607,  -3658,   -368,  -4486,    272,   6017,   -468,
      1108,   1056,    606,  -3288,   1003,   -830,   -336,  -2940,
       247,    227,   1700,    338,   -161,   5694,    317,   -584,
      6278,  -2902,  -3862,    293,  -3400,    540,    177,   -840,
      -471,    963,   -243,   -289,     77,     39,   7626,    333,
       577,    327,   -359,    999,   -392,    107,   1410,    509,
      -983,     36,   -193,    -68,  -7612,   -775,   -178,   1415,
      1069,   1534,  -1276,   1204,    615,   2065,    499,    124,
       265,   -454,   1974,   6428,  -4028,   1102,  -1418,    -85,
      -816,    -64,    -46,    926,   -960,     78,   4823,    -41,
       -74,   -682,   -761,  -6598,   3084,  -1597,   2945,   -861,
     -3203,   -669,  -3717,   -310,  -2865,  -1447,     72,   1987,
       364,   4919,   -247,   3678,   -196,  -6807,   -127,   -965,
       233,   -133,   4000,    -76,   -182,   3825,     67,    700,
     -1934,    545,  -2467,  -1441,    629,   3409,    512,  -3333,
       539,  -4896,   3413,  -2083,    554,    574,   9430,    296,
       -88,   -533,   -321,  -1082,   2363,     42,    -50,  -5402,
      -123,   4458,   1130,   2737,    378,   1509,  -3267,    970,
       179,  -2114,    602,    479,   -438,    277,  -9389,   1144,
      2453,  -3705,  -3842,   3965,    482,   1230,   2211,   -281,
     -1833,  -1741,   1653,   -868,    485,  -3740,   5371,    989,
      1182,     10,  -1812,    233,   1028,  -3300,   4698,   1572,
      1580,    928,   -314,  -3452,    830,  -1511,  -1079,    554,
       641,   1383,    105,  -1101,   1549,  -3944,    902,  -6557,
       493,  -3117,    782,   -699,  -4806,    910,   -259,    -28,
      1713,  -7012,    570,  -1270,  -4698,     -8,    220,  -4295,
      1135,  -3905,    945,   -467,  -2164,   -651,    181,    212,
       159,    587,   1587,   1101,  -7153,   -309,  -1470,  -1135,
      -265,   -326,    172,   8840,    726,   -780,    170,  -1038,
       466,    216,    764,    231,   -547,   2456,   -420,   8132,
       486,    866,   -359,   3351,  -1829,   2018,   -352,  -1353,
       711,    645,   1149,     74,   -466,   -669,   1009,   3086,
       240,   7468,   -182,   1947,   -221,    496,   -448,    189,
      -113,   -752,    133,   -214,  -1310,   -144,  -1034,   5235,
     -1939,  -2664,    192,   1526,  -2320,    762,   -778,    357,
      1251,    424,   -225,  -1008,   -229,   -352,  -3559,   -271,
     -1069,   1274,   -175,    368,   6453,   -505,     31,   7678,
       165,   -418,   -112,   -649,   1421,    667,   -334,   1041,
      -353,    585,   4109,   1095,   5283,    685,   -687,  -1459,
      1054,   5048,   -194,   2220,     81,    244,   3789,     12,
      -923,  -1459,    319,   2378,    -53,   4097,   -662,  -1156,
       223,   2589,   -547,   4951,   -346,  -1812,   -111,    344,
      5247,    387,   -459,   -810,   1022,    234,    726,   1840,
      -545,   -888,    728,    106,   1027,   -497,    349,   -248,
     11173,   -311,    126,    479,  -2036,    265,  -1286,  -7196,
      -511,    128,  -1833,    496,   7620,   2539,  -1809,    962,
      -614,   -876,    857,   2178,    642,  -1180,  -2294,    911,
      3932,    711,  -1073,  -1381,  -5317,    237,   -414,    579,
       -78,    -27,    -78,    -14,    100,   -191,    142,     -1,
       430,   -182,    207,    -61,    -72,  -4866,    583,   5099,
      -704,  -1496,   1065,   -206,   2371,   1496,   1777,   -308,
      4802,  -1415,   1178,   2650,    312,   -338,   -250,    -64,
       -27,  -3163,   -561,  -1283,    952,   -902,    354,   1597,
       -74,   -685,  -3266,   -873,   -744,   7079,    732,    697,
       550,  -1362,    251,     34,   -742,      0,    105,   -608,
        -1,  10459,    854,   -103,   -419,   2286,  -3041,  -3278,
       -51,   -491,   -187,   4204,    857,  -1085,  -2501,  -1647,
      6740,    605,  -2079,   1748,    519,   3462,    106,   -699,
       220,   -615,   -406,    420,    786,    572,    679,    218,
      -888,  10283,    129,  -2286,   -705,    -78,   5072,    634,
       702,  -6315,   -551,   -307,  -7946,    177,  -1897,   -579,
      1620,    125,    116,    -89,   -308,  -1018,    142,   -506,
      -624,    917,   -779,    632,  -5103,    314,   -155,   5687,
        77,   -144,   2957,   -176,     30,   1347,   -426,    -51,
      7829,   1201,   -592,      1,   4617,  -5476,   2216,    414,
      1281,    -81,   -423,   -322,   3623,    447,    863,   -375,
      -489,    526,   -485,    159,   1090,    463,    401,   -131,
       223,   1630,  -2462,  -2261,    623,   1019,   6385,   -595,
      -654,  -2787,   2381,    328,  -2069,   5410,   -402,   -554,
     -1594,   -860,     83,  -5011,   -938,   1061,    163,  -3523,
     -1064,   1215,    761,   1604,  -4224,    904,  -2706,   4907,
     -1838,   3287,  -3118,   -464,   -217,  -1187,  -6792,   1748,
      -569,    613,  -3177,   -253,    164,   -845,    539,   -440,
     -1871,  -2010,  -2322,  -3026,    478,   2297,   -560,  -5813,
       768,  -1709,   -620,     66,  -4667,    805,   -215,   5366,
      -442,   -233,  -6732,    345,    106,   4483,   1720,   2725,
      -109,   2746,   -188,    204,   1905,   1225,    253,   3270,
      1912,  -1852,   -256,  -4131,    768,   3984,    473,  -1434,
      4380,    208,   2547,   1051,   3347,   -171,    629,  -2389,
      -722,   -759,    166,   2192,    325,   -193,   -289,   -945,
      -436,    931,   1352,   6918,  -2707,   -987,   2940,   3574,
      4135,  -3205,    351,    927,    128,  -1873,  -4894,  -4816,
      -461,    696,  -1618,    129,    -28,   2195,   2450,    585,
      2557,  -1308,  -2204,   -590,   2345,   3699,   -312,   4436,
      3422,   -611,   -106,  -2647,  -1752,    -73,   8914,   -673,
      1625,    850,    720,  -1182,   -245,   -113,    882,   -223,
     -4873,  -1009,   5643,    -97,  -4779,   -155,    444,   2894,
      -876,  -5534,   1268,   -132,   -881,   -389,  -4250,   -153,
       -44,    986,   1820,   8671,    662,   -344,   -198,  -1909,
      1083,    114,   -318,   1070,  -3293,   -375,   6621,    232,
     -2973,   -100,   -483,   -529,   -120,  -5312,   1702,    651,
      -631,    485,   5675,     50,   1132,   -465,  -1053,   2675,
     -1592,   5565,   1036,  -2808,    325,    999,    524,   2813,
      -265,    337,   4226,    514,    576,   6047,    175,    204,
      -514,   -617,    -94,  -2862,   -294,   1774,    978,  -7040,
      -169,    835,   -829,   2258,    -37,   -319,   2750,    138,
      -289,  -1092,     78,   1032,   4316,  -1201,    808,  -6243,
      -940,   4136,     89,  -1076,   -647,   -255,   -207,    227,
       -70,    -62,   -202,     66,     24,   -988,  -9542,   -225,
      -739,    161,  -2698,    117,   -608,    173,   -629,   1770,
      5037,   5145,   2530,  -1028,   3077,   -496,   4671,  -1859,
      2148,    447,  -4231,    170,    713,    323,    746,   1447,
     -1880,   5069,   7765,   -492,   -775,   -659,   -770,    -59,
      -258,    -92,  -1683,  -4639,  -1727,  -2128,    545,  -5060,
      2536,   1549,    492,  -1280,  -6034,    965,   3244,    475,
     -1208,    680,   -283,    295,   -357,   -257,   1753,   -362,
      3159,    106,   -181,   1805,    947,  -1002,   -136,    756,
      1189,    237,  -2427,   -263,  -5746,     13,   2171,  -1197,
      -319,   -372,  -1300,   5458,    955,   1224,    618,  -1087,
      2661,  -2026,    -20,   2137,    342,   4076,    482,   5441,
        -6,   2126,   -143,  -1596,    274,   1009,     94,  -3446,
       398,   1079,    289,   2042,    883,  -2005,   -320,   3848,
       395,    472,    615,   3245,    753,  -1881,   -216,   5670,
       -64,   -565,  -2560,   1574,    772,  -3824,    932,   4830,
      1182,  -1054,    390,    -40,   1833,   -350,    151,    149,
      -966,    -62,   -713,  -8794,   -593,     87,  -3523,   -243,
       560,  -3296,    244,   -775,   7174,    749,   -271,   8566,
        99,   1258,   1239,   -489,   -107,  -1699,   -611,   1046,
        65,   -509,    524,   -354,   6400,   -248,    148,   -682,
       -93,  -1584,    -61,   4509,    479,    110,   7116,   -295,
       480,   1545,      3,    127,  -2292,    894,   1261,  -6288,
       -45,   -410,   -402,   -356,   2649,    649,   1652,   -643,
      6587,    117,    876,    -33,    956,   -302,   1619,  -1023,
       -99,    386,    -86,   -498,    684,   1189,    146,    381,
      9832,    -97,    264,     91,  -1197,    461,    374,  -6788,
       427,    294,  -4776,      0,   2868,   5199,   4573,   -827,
     -1867,    623,  -1214,   -573,  -1099,  -1476,    306,   -701,
      -224,  -4261,  -1135,   2500,  -4758,   1469,   -101,   1812,
      -129,     15,    760,   -149,   -892,  -1417,    761,   1213,
      -417,   1569,    -98,   1675,   -139,  -7382,   -633,   2584,
      -519,  -5483,     29,    320,   -383,   -596,   -295,   -357,
      -416,   4054,   -457,   -355,  -5213,   -840,   -319,   1321,
      -424,   -129,   5225,    181,  -2696,   -174,  -7363,   -327,
       519,    860,  -5132,    275,   -141,   4943,    204,   -200,
      2989,    939,    390,   -461,   -333,   -394,   -174,    312,
      -129,   7257,   -402,    860,     -1,   2677,    901,    609,
       248,    935,   -493,   8147,   2081,  -1171,  -2145,   1560,
      1634,     55,  -1746,    561,   -747,    931,   -712,   -544,
       798,    -98,    580,   -829,   -546,    238,  -2052,   -197,
       802,  13067,    373,  -6438,   1159,   -845,   4313,     19,
       670,   -627,   -944,   1277,  -6997,   -609,   1913,    607,
      -454,    -89,    859,    -43,    -71,    494,    169,   -713,
     -2014,   1570,  -4712,    233,  -4113,    210,  -3689,   1019,
       200,     49,   1800,   -611,   -472,   1234,    579,    363,
      -134,    233,    101,  -5539,   1924,  -1734,   -982,   -928,
      -707,  -1238,   1586,   3676,   4741,  -2770,   3105,    942,
     -1933,   1363,    288,  -2528,    160,    485,    -38,     23,
       113,    -19,   -518,   -110,   -173,   -170,    589,   -473,
       296,  -3742,   1109,  -2977,   1349,   5899,     98,   3130,
       855,    499,      3,  -3111,   -592,    572,   -890,    687,
       697,    194,   -344,   1139,   3255,   1270,  -2451,   1958,
      -395,    267,   -951,  -2224,   2108,    -11,  -3357,   2602,
      2403,   1596,   -532,   2701,   2251,  -1217,  -2148,    691,
      -757,  -2051,    373,   1964,   1493,   4756,   1246,  -4345,
      -496,  -1333,    -20,    -84,  -1558,    305,   1183,   8148,
      -628,   -702,  -1730,    232,   -261,   2732,    245,    353,
     -3745,   1013,    186,  -2042,    810,  -3894,    351,   2501,
       852,   4162,   -425,  -4941,  -1536,   2237,   1348,  -4274,
};

static const int16_t shape11[] = {
       347,  -5391,    106,    156,   -182,    -36,    177,    401,
       700,    524,  -1343,   -402,  -6982,     63,    194,    -14,
        82,    -36,   -677,   -393,    187,   7364,   -507,  -1173,
      -759,  -3759,   -728,   2970,   1334,     32,  -1322,  -2965,
       156,   -839,    382,  -6382,   -149,    874,   1352,    -35,
      -499,     99,   -425,  -3118,    -32,  -1596,   5608,   -822,
       -41,   2974,   -592,    615,   1777,   2364,   5189,  -4171,
      -581,    936,   -527,    318,  -1606,   -551,   5350,   -448,
       -40,   7476,    189,    319,  -1390,     10,   -921,  10016,
       573,  -1065,    829,  -1190,    -22,  -4263,     87,  -1742,
      -325,    313,   -188,    540,  -5542,   -188,    511,   -168,
      -518,     17,    152,   1966,  -2568,   -860,   2735,  -1210,
       404,   -144,  -6873,   -129,    434,  -2978,   2829,    -48,
     -9196,  -1829, -11261,   1492,  -4938,   1802,     93,    384,
      1340,    236,  10066,    731,    861,   -195,  -7571,    -77,
      -481,   -700,   4694,   -734,  -6317,    281,   1773,    175,
     -5535,    532,     31,   7012,   -637,  -3586,   1096,   3596,
      -197,  -7837,   -611,   1825,    -26,   -259,   2307,     12,
       729,  -1958,    156,    262,   5494,     26,  -5792,  -3146,
       450,  -1075,    297,    509,    154,    668,    191,   -268,
     -1585,    369,   1314,   -693,    677,   1482,    198,    378,
     11088,    -83,   2321,   -193,  -1082,  -3053,     20,   -271,
     12975,    272,   1114,    476,   -798,   -309,   -159,   5406,
      -109,   -675,    621,  -2564,  11190,  -1342,    -88,    428,
      -465,  -4633,   -503,    106,  -9448,   -454,    -28,   -402,
      1271,  -7972,    754,   -207,  -2491,    518,  -3701,   -542,
     -1268,   -617,   -177,    467,   -130,    990,   4087,    857,
      -524,  -5822,    145,    217,  -7703,   -275,   6647,    -81,
       550,    887,   -433,   -802,    532,    643,    188,   1965,
      -920,   -284,   3711,   1196,  -8896,   -357,   -626,    908,
      -284,   -706,  -1582,    182,   7705,   -138,  -2372,   -158,
      -888,   4247,   4381,  -6722,  -1619,  -1810,    632,  -1176,
       -62,   4261,    -89,    265,   1405,  -1449,   -389,  -7068,
       258,   -244,   -272,  -8149,     37,   -457,  -8839,   3243,
     -4291,   -396,  -3935,    907,    -58,   2388,   -908,  -1209,
      -635,   -487,  -1717,   6989,  -4834,   2136,   -822,   -699,
      2187,    -96,  -9775,  -3464,    795,    634,   -823,   -669,
       146,   -843,     15,   -227,    671,   -707, -10004,    198,
        81,  -1611,    -34,  -2127,  -2385,   -689,    622,   1834,
       -63,  -4925,   -215,  -1181,   -514,   7701,    607,   2030,
      -264,   2479,    913,    178,   3625,   -194,    613,    877,
      -384,  -7732,   1008,   2117,    528,   -301,    540,    -80,
       559,     28,   7542,   -496,   1146,  -6573,  -1457,   7789,
      -227,  -1671,    -76,   -371,   -865,   -141,     42,     96,
       277,   -410,  -5606,    328,  -8954,   -222,  -1792,    981,
      -120,   -650,   2269,  -1412,   1038,   -186,  -8530,   -264,
      2284,   -727,   1511,  -4611,  -1653,   1985,    -50,  -8985,
      -245,  -3315,    407,   -915,    -23,    -70,     30,   -669,
      -303,    902,     84,    433,    217,  -8303,   7847,  -1865,
      -680,    254,    -38,    364,     16,     50,     90,   -534,
     -4649,   -800,    969,  -1081,    454,    147,    -62,   8797,
        84,   -912,   -518,   -351,     76,   -560,  -1438,    629,
     16384,    656,    151,    880,    396,    -90,    752,   -138,
      -861,   9605,    258,   -440,  -6441,    434,   5765,    282,
      1494,   -260,   -180,   -769,   7867,    -86,    536,   -262,
      -230,  -8956,   5857,   -591,   1533,    418,   -505,   -156,
      1165,    415,   -168,  -1504,   -336,   -667,    527,   5725,
        42,    429,   1691,      1,     85,   -196,   3681,     36,
       469,   -364,    559,    910,  -1848,    259,    249,  -1688,
       261,    -36,   -592,   -156,    -69,  -5938,   -180,   -294,
        22,   -903,   1389,   4853,    121,   5185,    970,   1210,
       561,    926,    472,   -183,   6623,    357,    -78,  -5877,
        91,   -188,  -6746,   -146,    342,  -5648,   3697,   1336,
       728,    -69,    398,   2667,  -2103,   1901,   -807,    258,
        72,   -137,    341,     71,   -169,   -104,    -83,    206,
      -420,   1187,    744,    120,  -5151,   -574,     72,  -8553,
      -312,    140,    -69,   6067,   5229,    202,  -1722,   -164,
        73,   1695,  -1064,    234,     24,   4881,   -849,   -460,
      8641,   -328,  -1217,   1666,   -283,    -76,   2772,    401,
       843,  -4756,    297,   8593,    367,   -732,   -225,   -198,
     -3936,    248,   -436,    473,    -19,   -441,    164,    220,
      -266,      3,    106,   -244,  -5814,    597,   -666,   -245,
     -9298,   -867,   -480,    280,    -40,   -139,  -6378,  -4972,
      -886,   3062,    747,  -1991,  -1668,   -423,    534,    866,
       -73,  -6501,   -195,    324,    -51,   -123,    298,    500,
       193,    278,  -8503,   -297,   1034,    -16,   -209,   7451,
       521,   -305,   -297,  -1537,  -3025,    689,    248,    319,
      5393,   1497,   2228,   -773,   -141,   2184,   1024,  -4535,
     -9160,   -600,   -932,  -2145,   -539,    460,  -1943,   4265,
     -2512,   4416,   -304,   1744,    489,   -362,    898,   2236,
     -2224,     49,   -192,    332,    366,   -143,    329,  -7747,
        -4,   1075,    116,    551,     19,     -7,   7090,   -169,
       837,    -71,   -371,    451,    -31,    474,    867,   -421,
     -4544,     78,   3208,   -549,   1984,   1386,  -2208,  -1402,
      1616,    189,    -37,  -6953,  -5733,   1589,  -1314,   1040,
     -1480,  -5608,   2627,   3517,    250,   7930,     94,   4687,
      1522,   5543,   -130,   -462,   7613,   -654,    647,  -6187,
       139,    342,   5069,   -729,    128,     17,    -49,    176,
       122,    826,    503,     76,   -196,  15583,  12884,    746,
     -3942,    814,  -1744,   1774,   -338,   3089,  -1694,    559,
     -5355,   2834,  -1448,    108,   -329,   -711,    350,    171,
       297,   -123,    672,    625,  -5884,   6822,    842,    276,
       242,  -2254,   -623,   -846,   2441,    887,  -2066,  -1019,
      1329,    107,    -83,    826,    -67,   -352,    549,    137,
     -1023,   -184,    -11,  13790,     48,    883,   3538,   -533,
     -5553,    861,    738,   -436,  -5259,    -66,   -405,   3777,
      -574,    738,    253,    363,    -76,    288,    324,   -337,
       157,   -119,    -97,    171,    514,  -1932,  -5171,    579,
       249,   1072,   -204,   -194,   -311,    655,  -6728,    186,
      -178,     99,   5749,   -329,    419,    924,  -1131,    598,
       -15,   -103,  -2277,    186,   -716,   -542,    153,   -226,
      5689,    219,     52,   3706,   -917,    140, -10576,   -151,
      1060,    645,    404,   1310,    331,    216,  -1413,  -6030,
     -5069,  -3992,   1366,    932,   1559,    -87,   7799,   3854,
      3762,  -1043,    474,   1184,    102,  -2775,  -1199,  -1079,
       358,    -63,   9784,    141,   3947,    194,   -132,   -332,
      -512,   -212,  -5839,   -227,   7759,    807,   -597,  -1782,
      -148,   -352,  -1225,   -692,    147,  -1970,   3508,   -947,
      3463,   -197,   4737,   -698,    578,   -172,   -775,   8167,
      3102,    883,   -914,     16,    827,    114,  -1916,   -909,
      -606,     87,   1036,   -435,    102,     96,   -370,   -204,
    -11952,     21,    477,   1285,   6281,    855,  -7717,   1155,
      -501,   -597,   5943,    145,   -630,  -3406,     13,  -4211,
       679,   6570,   -231,  -6042,   -503,   -194,   1437,   5640,
     -1222,   8181,    386,   -986,   -503,   1221,    839,    763,
      -277,  -1787,  -1491,      5,   -206,     42,   2800,   -332,
     -2841,   -143,   -456,    646,   -668,   -117,    883,     86,
      7111,   -270,    624,  -1133,   -308,   -479,  -9149,  -1424,
       242, -12048,      8,   2307,  -6530,   -529,    462,  -1346,
      -153,   4315,   -182,   -675,    -78,   -480,    -49,    398,
      -408,  -1440,   8196,    436,   -561,   -184,    175,   1799,
      -154,   -439,   -721,   2170,    322,   6555,   -539,  -1672,
      -629,  -2985,    239,    -37,   7544,  -1048,  -1241,   7241,
      -636,   2044,   -750,   1206,   1363,   -530,  -5960,    342,
     -7440,    616,    372,   4572,   -118,    343,   1086,    570,
      -164,    553,   -433,    562,     33,   8225,   -235,   -234,
      1230,    234,    906,    563,    -73,  10464,   -353,   -644,
     -1453,   1119,    237,    670,   -112,   7083,   -451,   3410,
      -105,   3244,  -1331,    102,    738,  -3602,     76,    413,
      -318,     10,  -5471,   1024,   -335,    246,  -7820,   -164,
      2515,  -1411,    673,   6022,     50,  -6715,    268,   2152,
      -951,    -60,    234,  -2085,    342,   3002,   -169,   2473,
      -667,  -6846,    870,   5467,    150,    -66,  -4294,   -299,
      -612,  -3859,    177,    353,  -4726,    547,    340,  -5646,
     -2022,    117,  -4949,   -303,    280,   -266,   -361,    673,
      -139,     -5,  -7123,   -264,    243,  -5245,    351,    656,
      5005,    682,   -107,    298,    -79,   1407,   -449,   -797,
      -669,   -552,   -242,  -8013,     56,   4092,   1583,  -3981,
       -49,  -7972,    390,    366,    -31,   1126,    272,   5120,
       -10,   1147,  -3682,   -155,    252,    163,    455,    358,
      -746,  -2719,   -431,    444,   -433,    432,   -357,   5370,
       328,     -3,   1748,    514,   7198,   -527,    172,    401,
       -59,  -3586,   1443,    534,   1029,    539,   3723,   5392,
     -6619,  -2559,   2344,    282,   -980,     97,   -317,   -786,
       475,  -8646,    307,    447,  -3107,    211,    -56,   3344,
     -1549,  -9223,    454,    352,    -27,    205,    503,    260,
      -372,   -631,  -1165,  -6543,    444,   1535,    404,  -1752,
       -43,  -9381,    754,    -94,  -7134,   2064,    170,   8222,
      -280,  -1250,   -347,   1688,  -1203,    239,  -1048,  -4570,
     -4720,   -434,  -1008,  -4151,  -2211,  -1414,   -506,  -5411,
      5379,    984,   4587,    -63,    143,    968,   -203,   5315,
       591,   -756,   1228,   -372,    703,   6829,    -76,   6935,
       467,   3119,     -2,  -3825,    175,  -4000,  -3012,  -7745,
      -832,  -2582,    173,   1992,   3768,    275,     39,    603,
      -536,   5851,    474,    254,    -72,   1286,   -836,   5576,
      1357,   3524,    406,  -9214,   -554,   3974,   -352,   1763,
      -482,    658,   1628,   3885,   1938,   6172,   1693,  -5183,
       150,  -6729,   1238,   1062, -10035,   -428,     48,    421,
      -185,    659,   -426,   -633,    131,   -741,    462,   -463,
      -391,   -193,   -270,   -682,   -343, -12130,    -86,   -148,
};

static const int16_t shape11s[] = {
        22,  -5296,   -415,   -206,    306,    265,    189,    376,
       721,  -1503,   -429,   -538,  -6008,    -97,   -385,   -570,
      -313,  -1469,   -219,  -1661,     10,   6256,  -1230,   -635,
       -28,  -4208,   -344,    394,    138,   1174,   -170,   -822,
       114,  -1087,   -101,  -7362,     84,    862,   1514,    341,
      -115,    320,   -120,  -1625,     55,   -719,   1443,   -733,
      -577,   7197,    148,     26,    120,   1969,   4940,  -3777,
      -607,   1675,     64,   -634,    -84,    334,   6882,   -644,
      -232,   5008,   -316,   -164,   -138,    -16,     15,   9441,
       -74,    -65,    262,    834,   1143,   -101,    434,   -329,
       123,   -204,    -45,    147,  -4586,   -742,    464,   1412,
       548,  -1602,    -56,   1356,   -771,    263,    709,   -481,
      -193,    345,  -8395,    -41,     36,  -1900,   -178,    816,
     -7590,     31,  -3011,   -371,  -2698,   2234,    -99,      0,
       714,   -845,   9357,    701,  -1269,   -187,  -4227,   -450,
       -73,  -1637,   4679,   -138,  -4470,    356,   1416,   1462,
     -3162,    453,    -61,   5243,   -241,  -2385,    438,   4919,
      -252,  -3781,    150,    335,     58,   -185,   1870,    179,
       192,  -2572,   -454,     77,   4819,   1891,  -4843,  -2106,
      -472,  -3842,    167,   1092,   -671,    194,   -870,    139,
      -115,   -455,    452,   -519,    299,   1024,    330,    -99,
     11189,     82,     57,   -849,    167,  -4190,    639,    768,
      7477,    626,     94,  -1259,   -303,    181,   -280,   2873,
      -589,   -461,   1591,    -29,   6940,  -1264,    120,   -282,
      -159,  -3755,     -4,    -61, -10172,    152,    -12,   -200,
       111,  -8471,   -243,    400,   -842,   1661,  -3099,    500,
      -451,   -423,   -193,    230,    423,    263,   5011,   1010,
      1044,  -4781,    707,     84,  -6091,   -213,   5193,    434,
       534,   1100,   -520,  -1590,     75,   -322,      2,   2008,
      -534,    153,   2641,   1510,  -6830,   -246,      4,    271,
        75,  -1308,  -1934,   -257,   6748,    589,   -301,    627,
      1197,   3708,   4450,  -5582,  -1312,  -2859,    881,    429,
       552,    738,   -882,    984,    488,   -868,   -464,  -6969,
       721,  -2078,    417,  -6121,   -184,   -128,  -7840,   2659,
     -2584,   -254,    176,   -790,   -727,    482,    357,    104,
      -441,   -158,   -980,   4563,  -4098,   1086,  -1217,   -562,
      2033,    512,  -8331,  -3506,    -73,    808,   -372,  -1602,
       748,    911,   -599,  -1499,     58,    309, -10000,   -115,
        70,   1603,    280,   -146,   -817,    517,     18,   1355,
      -121,  -4134,    152,  -1300,    247,   7258,    415,    130,
       -27,   2108,    337,   -816,   2480,    396,    533,     66,
      -171,  -6213,     47,   3081,   -648,   -930,   1810,   -233,
      -433,   -588,   5526,     58,    -18,  -3498,   -381,   8009,
         7,   1229,    152,   -410,   -567,    423,   -354,    463,
       -82,   -146,  -2868,    271,  -5773,   2694,  -1006,    150,
      -113,   -521,   2553,   -278,    593,    -69,  -6517,   -785,
       369,  -2483,   -216,  -3144,   -889,   1724,   -168,  -6303,
       171,  -1895,   -798,   -137,   -172,   -746,    -54,    162,
      -607,    409,    201,   -284,   -143, -10681,   7747,  -1148,
       303,     58,      4,    -96,   -485,   -146,   -286,   -577,
      -644,   -512,    236,    576,    421,     93,    293,  10284,
        -2,   -117,   -590,   -546,    350,    445,   -301,   -300,
     10823,   -224,    -96,   -551,   -148,   1042,   -125,    224,
      -706,   8583,   -195,     52,  -2732,    200,   4419,    390,
       870,    100,   -184,    233,   6179,   -317,   -472,   1964,
      -302,  -8722,   2509,   -644,    488,  -3101,    891,   -253,
       -38,    133,    -15,  -1365,   -779,   -612,    673,   5587,
       834,    377,    835,  -2018,     75,   -185,   3641,    121,
       693,     63,    503,    646,     -7,    348,    141,  -1311,
       532,   -513,     95,   -315,    -65,  -6478,    -16,   -848,
      -210,   -120,    676,   5125,    533,   4147,   -622,     -4,
      -150,  -1507,   -124,   -185,   5365,    267,   1073,  -4479,
       173,   -204,  -4164,   -952,    -23,  -4088,   1391,    205,
       712,   -473,   -373,    547,   -685,   4542,    -49,    -71,
        33,   -271,    132,    246,   -188,      6,   -309,    118,
        96,   1774,    158,    -83,  -3573,   1175,   -122,  -6619,
     -1677,  -1161,   -266,   4776,   3453,     62,   -346,   -450,
     -1380,    103,   -457,  -1260,    -71,   4271,   -338,  -1394,
      6462,    395,    647,   2430,   -735,    444,   1837,    403,
       144,  -5573,    211,   4608,    -15,    804,     70,   1969,
     -3451,   -138,   -352,   1176,   -171,   -518,   -114,    -88,
       335,   -308,    -64,   -428,  -4115,    318,   -205,   -126,
     -7854,   -609,    105,    144,    270,    266,  -4543,  -5246,
      -311,    587,    305,   -115,    372,    727,   -294,    414,
       877,  -7899,    411,   -538,    394,    535,    233,   -826,
       329,    491,  -4848,   -650,    331,   1026,   -140,   6474,
       194,   -457,     98,   -871,  -2293,    873,    353,    812,
      4510,   1102,    379,    651,   -214,   -110,     20,  -2749,
     -8040,    -96,    221,    221,    -39,    444,   -280,   2814,
      -536,   3509,    111,    830,    594,    553,     47,   2812,
     -1898,    203,   -353,    -60,    371,    181,    824,  -5448,
       297,    476,     42,   -133,     97,    425,   8586,   -317,
       121,    453,   1014,   -350,    175,    747,    -78,   -287,
     -5832,    625,   4170,   -308,   1853,   2846,     -3,   -876,
       535,    431,   -411,  -2139,  -6021,    374,    298,   1572,
        19,  -4069,   1567,    144,      3,   5541,   -438,    920,
        87,   1728,    230,    807,   5848,   -413,      7,  -6241,
       214,    205,   1312,   -675,     70,    264,    114,    -24,
      -482,    -72,   -296,    327,    249,  11047,  11070,     18,
      -937,    350,     22,    362,    555,    815,    130,   -125,
     -4545,   2662,    203,   -318,   -305,    323,    633,    416,
      -254,    301,     99,    407,  -4951,   4766,   -790,   1334,
       912,  -1046,   -350,   -135,   3744,     22,  -1647,   -422,
      -151,   -113,   -130,   -345,     -2,   -263,     18,    -24,
      -771,    -34,   -543,  10259,    183,      0,   1743,   1267,
     -2554,    320,    611,  -1064,  -1446,    875,   -808,   4865,
      -816,   3452,     68,    326,   -178,    177,    -10,   -138,
       -33,    -93,     65,    264,    185,   -157,  -5749,    110,
       407,   1240,   -698,    -61,    176,   1557,  -6012,   -606,
      -555,    458,   3226,   -939,    933,    153,    -32,    928,
        69,   -490,  -1543,    -87,    -20,   -196,   -327,    423,
      7911,   -189,    178,    335,   -194,    459, -10572,   -196,
       174,   -286,    502,  -1041,     12,     39,   -101,  -3983,
     -1650,  -2902,    386,   -151,   1051,   -619,   6854,   3408,
      1140,  -1854,   -755,    -40,  -1108,  -1502,    221,   -397,
       375,   1081,  10375,    389,    270,   -239,    311,   -212,
       384,   1237,  -2951,    199,   5281,    -56,     34,   -704,
       942,   1169,     33,   -310,     97,  -1216,   3023,   -836,
      3256,    404,   3951,   -257,   2139,    111,    179,   8255,
       611,   -240,   -252,   -367,   -251,   -296,  -2282,    957,
        61,   -265,    720,    232,     34,    146,    204,   -290,
     -9923,    529,     65,    696,   2958,    352,  -3852,   1248,
      -743,   -395,   5969,     92,   -132,  -1206,    314,  -4013,
       717,   5157,   -770,  -1878,  -1201,   -958,    525,   4028,
       116,   6772,    -45,  -1086,   -335,   5815,     51,     57,
       -85,  -2301,   -133,   -300,      7,    227,   3429,  -1075,
     -4353,   -832,     30,   1259,   -484,    451,    604,   -717,
      6765,    294,    118,   -410,    299,    592,  -3845,     66,
      -502,  -9088,    -74,    259,    450,    475,    202,  -1792,
        23,   4719,    709,   -398,  -1676,   -351,   -898,   -622,
       145,  -1392,   7305,   1014,    -80,    519,  -2065,   1531,
       860,  -1448,    134,   1683,    689,   7179,   -345,   -327,
      1004,  -2467,   -340,  -1302,   5825,    373,     50,   6796,
       314,     13,   -270,   -426,    702,    279,  -4392,   -508,
     -6521,     60,   -278,   2479,    847,   -360,    -68,  -1948,
        91,    969,    421,    459,   -341,   6020,   -550,    -77,
      -687,   -754,      5,    109,    410,  10860,   -183,   -317,
      -734,    -87,    501,   -601,    158,   5836,  -1057,   1236,
      -850,   2965,   -330,    547,   1249,  -2804,    127,    218,
      -455,   -805,  -4002,    108,   -569,    660,  -5356,  -1091,
       581,   -445,   -311,   6409,    510,  -6789,    519,   1607,
       296,    342,    368,  -1440,   -846,   1997,   -227,   2332,
     -2062,  -4657,   1030,   5322,    135,    131,  -3414,    320,
      1030,  -3341,   -256,   -373,  -4565,   1222,    171,  -4972,
     -1444,    303,  -5427,    435,    208,    251,    467,    539,
       136,    199,  -8876,   -195,   -771,  -3096,    740,    368,
      1047,   -490,     83,    485,    168,    531,   -635,   -801,
      -953,      4,    -95,  -7603,    -59,   2023,    739,   -702,
       263,  -9230,   -313,   -997,   -510,   -772,    156,   3986,
      -113,    398,  -2602,  -1079,    195,   -211,    128,   1917,
       221,   -965,     11,     71,   -101,    180,    -36,   7839,
      -144,   -722,    288,    429,   5704,   -984,   -510,    775,
       440,  -1849,  -1348,   1989,    300,     43,   1928,   4341,
     -3840,  -2427,   2025,   -660,   -293,     23,   -249,   -177,
      -327,  -7858,     33,    245,  -1334,    237,   -687,   2800,
        30,  -8807,   -404,     43,    183,    289,    528,    510,
      -197,    590,    -94,  -5423,    381,   1317,    141,  -1639,
      -432,  -7628,   -224,     56,  -7788,    113,    134,   6981,
      -636,    756,   -743,     97,    159,   1263,   -143,  -2941,
     -2680,   -479,   1395,  -1667,   -472,   -992,   -451,  -5708,
      4262,    334,   3053,     76,   -584,   -599,   -276,   3518,
       264,  -2118,    358,   -106,    911,   5053,    480,   4538,
       949,   5203,   -103,    -14,    177,  -3397,     55,  -6813,
       680,  -1788,    145,   2267,   1104,   -789,     54,    261,
       228,   5494,     15,   -224,    192,    740,      0,   7632,
       398,   2879,    430,  -8212,   -657,    815,   -228,   -488,
       -90,  -1296,    595,   2979,    -15,   4055,   -252,  -3883,
      -935,  -7654,    330,     97, -10200,    462,    223,  -1017,
      -309,   -342,   -124,  -1258,    211,    351,    316,    414,
       -91,    -18,   -202,    -74,    410, -11127,    326,    261,
};

static const int16_t shape16[] = {
      -855,   1549,  -4841,    629,    932,  -5896,    840,  -2041,
      -305,  -2574,    343,    -31,   -780,   -773,   -353,    403,
     -1907,  -2371,   -555,   -324,   -479,   6961,   -286,  -4290,
       626,   -953,    -14,  -1681,   -443,   1504,   -366,    513,
     -1206,    870,   9239,    112,   -213,    425,    381,   1802,
       750,    594,     61,   -152,  -2060,  -8997,   -752,    197,
      -493,   -176,   -389,   -591,   2988,    654,   2404,   -204,
       304,   -279,    202,     66,   -185,    415,    159,  -1514,
     -6775,    -37,  -2617,  -1246,  -4012,   1208,   -554,   3240,
      -655,   -394,  -1464,  -4448,    388,   1058,   -364,  -1760,
      1081,   -558,   -116,   -108,     99,   -925,    763,  -1301,
      -251,    258,    -33,    311,    555,    227,   -279,   -601,
      -135,   -675, -10615,   -937,    158,    503,  -2044,   1075,
      -114,   4278,  -9040,     67,  -1076,   -705,   -122,   -533,
      3299,  -1826,  -1316,    708,  -3840,   -740,   -370,  -1074,
        87,   -462,   2177,  -1177,     57,  -6311,   -170,   -777,
      -256,    435,    291,  10371,    -82,   -425,  -1757,   -196,
      3824,  -6289,     62,   4506,   -519,   -783,   1155,    878,
       295,  -2044,    305,    186,    263,  -1716,   -482,  -5678,
       415,   2709,    213,   7531,   1376,    813,   1803,    190,
       398,   6483,   1425,    235,   2713,    520,  -2892,  -1191,
      6074,    654,  -6535,    320,   -736,   -478,   2563,   -309,
     -3477,   -155,    275,   1024,    390,   -386,   -331,  14043,
       251,   -410,   1496,     24,   1272,   -816,    549,   -238,
     -2489,    158,    194,      1,   -306,  -3088,   -264,    200,
       -30,   -520,   -472,    -30,   -464,   -764,    440,   -659,
        88,    778,    -31,  -1794,  -3817,   -344,    887,   -551,
       115,   -763,  -5338,   2906,     50,    736,   5536,  -1101,
       330,   -405,    416,   1022,    -93,     71,  10034,   -200,
     -1258,  -3405,    480,    141,    399,    500,    311,   -503,
       301,   4398,    454,   -922,    975,   -101,   -775,    -81,
     -1723,   1077,    857,  -1682,    813,    847,    342,   -276,
      3582,   2991,   5571,    713,   1280,    596,  -1325,  -1087,
      -681,   1411,    391,  -1728,    492,    544,   1512,   -724,
     -7445,   -426,      6,   -534,  -3643,  -1598,   2650,   -834,
      2096,   -333,     67,   1746,  -1584,  -1003,   1272,   1710,
      1666,    176, -11716,    329,  -1829,    385,    802,   -382,
      2244,     -8,   -222,  -2351,    369,  -1067,  -9354,    293,
       -51,  -1849,   -500,  -2350,  -1824,   -826,   -450,  -2155,
       456,    245,   1796,    320,    -73,   -306,   -122,    290,
       118,   -298,   -675,   -180,   -828,     86,    -44,    165,
       435,  -8249,    769,    630,  -1670,   -762,    453,   5893,
       259,    -92,  -1003,   -358,    -32,  -1350,   -535,   -289,
       409,   -558,   -344,   -752,   6037,   -680,   2471,    581,
      -351,   1251,  -5827,    194,   -104,    815,   1257,   -619,
       243,    410,   4455,   -969,     50,   1286,  -1013,   -293,
     -7740,     73,    615,    523,   -149,   -824,   2235,   1571,
       970,    944,   4778,   -132,  -5082,     83,    129,   -820,
      -803,    694,   1615,   1163,    517,   -402,    -80,    762,
      -107,   -419,    142,   -294,  11298,    301,    484,   -513,
       105,    547,   1130,  -4253,   -742,    376,  -1545,   1076,
      4372,   2338,  -2847,    495,   -190,  -2444,    931,   6487,
       117,  -1273,   1488,    -75,   -322,   -487,  -2614,   -251,
      1233,   4111,   -321,   -219,  -7961,    -11,    107,   -808,
       450,    111,   4395,     89,    772,  -1878,  -1894,   1075,
      -544,  -9467,   -459,    637,    842,   -956,   -738,   4452,
       777,    -75,   -209,   -302,   -796,    785,  -7413,    321,
       649,    -55,    114,     43,  -1026,   -223,   -611,    209,
     -5543,   8206,    907,  -3358,   1452,   -543,  -3173,    525,
       -95,     35,   -475,   -525,   -705,   -569,    350,    206,
      -108,  -1523,   -680,   -283,  -2583,  -4992,    -59,   -968,
     -1719,  -2750,   5884,    455,     29,    436,    784,   -101,
      -216,    110,    612,   -511,    -12,     98,    -67,    177,
     -1210,    222,   -345,    243, -12670,   -472,    282,  -2149,
       687,  -2631,   4434,     77,   -521,   -404,   -934,    212,
      -695,   -369,   1138,   1348,   -905,    501,    299, -10467,
      1018,    818,   1941,     31,    257,   1219,    944,   -157,
      1968,  -1649,   -126,   -440,   -599,     -1,   6190,   2574,
      -332,    753,    195,   -131,   5972,   -297,    672,    -86,
      -143,   -303,      5,   -121,   -154,   -613,   5541,  -1516,
      -304,    962,     69,  -1857,   4142,   -134,    706,    896,
     -1226,   -135,   -310,  -9261,   1135,  -3437,    620,    802,
       -33,   -582,   1909,   1407,    242,   2599,  -1533,   -279,
       836,   8070,  -1207,   5745,    200,    -77,    162,    781,
      -466,  -1555,   3297,   -957,    225,   1290,      7,    677,
        41,   -549,  -2778,   1400,    379,  -3367,    369,    615,
     -6402,    527,     58,   5679,   -114,   -180,   2842,     88,
     -2611,    -50,    371,    161,   -444,   2062,    -38,    272,
     -8562,    769,     18,  -2593,   -226,   -503,   -959,  -1295,
       189,   -371,   -675,  -1528,    -98,    514,  -1236,    116,
       202,  13662,   1596,   -328,     61,   3567,   -486,  -3316,
     -8473,   -317,   2868,   -419,    -17,    535,   -965,   -503,
     -3848,   2222,    620,  -1740,      2,   6505,    473,   -297,
       -70,   3043,    -51,  -1520,    993,   1046,   1965,   3240,
      1971,    -60,   -650,    -53,   -248,  -4428,   -365,  -3723,
      1122,  -1681,   1629,   1358,    -17,   1136,   -256,   2344,
      -282,    156,    127,   -155,    318,  -1281,  -1066,     57,
      -889,   -253,  -1396,   -579,   -920,  -1006,  -9202,   -703,
       195,   5186,    241,   1742,    996,    118,   1431,   4415,
     -2452,   6837,  -1272,   -569,   3485,    328,    441,    832,
       553,     94,    648,     92,   -378,  11167,    775,    457,
      1712,    -24,    941,   5433,  -1645,   2166,    249,    -55,
     -1816,    383,    735,   -876,    443,   -568,    293,  -1266,
      6963,   -178,   -174,  -1186,   1119,   -208,    821,   1499,
     -1496,  -2171,   1434,    874,    133,  -7466,   -545,   2193,
      -775,  -1405,  -1205,   -575,  -1996,   -645,   -552,   -263,
      8861,   -517,     76,   -992,    278,   2417,  -1369,     35,
     -1461,  -1399,    517,    185,  -2895,    347,  -3871,   3644,
       284,   3284,    -12,   -169,  -1981,   1196,    -67,   2868,
       910,    134,   -530,    150,  -1328,   1902,   -746,    351,
      -222,    522,  -5702,    797,  -1900,    241,   2270,    764,
      -335,   1348,   -349,    784,  -1586,   -537,    148,   3211,
     -1692,     56,   1678,   -321,   -290,   7902,     69,     52,
       310,    337,    250,    596,   9998,    336,   1037,    163,
        64,   -441,   2894,  -1033,    730,   -718,  -1252,    459,
      -131,   7840,   -922,   -555,   5671,    299,    689,   1115,
      -646,   -505,   -263,    608,   -494,      0,    442,  -1802,
      -598,   -701,  -4184,     70,  -1319,    -90,   9155,   -339,
         0,    121,    462,    735,   -639,    481,    125,   6924,
      3379,    683,   3053,  -1219,   -499,   1067,   -148,  -2705,
       -11,    795,   1675,    898,    226,   1232,     49,   -572,
     -9309,   2223,    949,    767,   -821,    -91,   1075,   -352,
     -7829,    554,   -593,   1284,   -245,   1239,   1166,  -1157,
     -5274,    808,    871,  -1446,   7575,   -397,   -755,    752,
      4193,    179,   -205,    -37,   -750,  -2675,   -407,   -700,
       220,    -77,   1604,     63,    461,  -9994,   -645,  -1629,
       103,    576,    132,  10005,    -49,  -1005,     97,  -1608,
       515,    -10,   -146,  -1878,    880,    429,  -1271,    996,
      -365,     76,   -409,   2461,     29,   1159,    217,  -6240,
      -200,   -746,    118,  -1884,    457,   -816,   -608,   3215,
       244,    749,   2268,   -236,  -1276,   -278,   1392,  -1767,
      1255,  -1474,  -8136,   1388,   -770,    225,   -443,     10,
      -392,    659,  -1118,  -1651,   -514,   -935,   -111,   1112,
       973,   -247,   -235, -13010,   -737,     40,   -141,   5167,
      -910,    279,   -467,  -3762,    847,  -3935,   1018,   1922,
       830,    190,    253,  -1130,   -415,    371,    718,   3833,
      1036,  -5358,   -928,    866,   -514,   2724,   2354,    449,
       210,   1462,    680,  -1880,    -62,  10988,    809,   -602,
       145,   -536,    114,   -147,   -568,   3193,   -322,    892,
      -637,  -1381,    -65,    761,   1615,   5025,   -327,   4941,
      -631,  -5225,   1204,   3042,    998,  -1047,   -959,   -106,
      1610,   -151,    120,  -1152,    191,     30,  11963,    101,
        18,   -410,  -1288,    370,   -771,   1337,   -544,   -613,
       289,   -117,   1625,  -4506,   2582,  -1690,   -105,  -5324,
       -93,    285,  -1167,  -3564,   -729,  -4790,    595,    275,
      -216,   -217,  -6000,    682,   -171,   -875,    224,   -164,
      2919,    796,    -81,   1434,    186,   -375,  -4113,   -179,
       277,   1363,   -453,   2505,    388,  -1840,   -165,  -4800,
       -42,  -6632,     54,   -735,   -553,  -1679,    917,     -2,
      -632,    417,   -478,   -494,   -265,     73,   -372,   -360,
       179,   -448,    265,    299,   -152,   -211,  12730,    -77,
      1954,   -534,    773,    524,    438,   1901,  -4413,   -358,
      1552,   -248,  -1588,   -122,   -127,   5405,    226,   -849,
     -7495,   -357,    -89,    185,    746,    851,    669,    305,
      -247,   3457,   -193,   -161,    638,    600,    610,    855,
     -1292,    398,   1528,   2250,   1651,  -8414,    763,   1529,
      -346,   3769,   -111,  -6494,    347,   -742,   1941,   1967,
       582,  -5499,   -765,   -818,   1850,  -1604,   -243,   -943,
       -11,    884,  -2996,  -2375,   1010,   -374,   6605,   -287,
     -5073,    211,   -758,    703,  -2607,    747,   -130,   -429,
     -2481,   4894,   -457,   3225,    958,   8533,    542,   6177,
     -1069,  -1210,   -963,  -5943,    -86,   1424,   -567,    827,
      -510,  -6577,   -258,     -4,  -4430,    115,   5401,   1390,
       354,   1755,   -998,    852,    993,   -481,    218,   -987,
       779,   -417,    591,   6011,    528,    289,   -336,   -558,
        60,   9124,   -174,    235,   -239,   -144,   -260,  -3472,
       746,   4781,    652,  -4831,   -739,    -21,    864,  -2310,
       652,   7147,    116,   -318,    -50,  -3485,   -325,   -345,
     -5784,   1144,   2399,  -1443,    991,  -2318,   -785,   -281,
      -207,  -1448,    309,   1001,    952,   1472,  -5901,   -780,
     -2459,   1518,   9878,  -1229,    670,   -523,   1217,   -164,
       -55,    -95,    243,   7909,     86,  -4380,   -859,   -599,
      -183,  -2339,    774,  -1210,   -502,   -899,     53,   1039,
        34,  -7753,   -296,  -1951,  -4559,   1182,   -150,   2878,
     -4910,   2761,  -1481,   2048,   2600,   1808,  -2953,  -2257,
        62,    162,   1115,    214,  -4510,    926,  -6669,   1443,
      -124,    193,   -314,    302,    699,    -18,    745,    341,
       895,   -615,   -295,   -181,    143,   -427,   6528,   1074,
     -1126,    374,   -298,  -1274,     22,    887,   -511,  -1057,
      3228,    722,    607,    624,    -95,  11085,   1006,   -788,
      -285,    -92,   1342,   -325,   -828,     42,  -3588,   -631,
      -576,   4559,   -668,  -1294,   1739,   1697,   -647,   2336,
       376,   -120,   1350,    646,   -325,     95,   5974,    775,
       199,  -8557,    931,   -336,   -651,   -561,   -433,  -2266,
      -129,   -657,  -1184,     67,    577,    617,   1880,    552,
        90,   -617,   -273,  -1571,  -7481,    261,    -26,    -20,
      -459,  -1028,     57,  -8516,    -43,   2774,      1,  -4238,
       680,  -3310,    -56,   -152,    548,  -1983,    920,    899,
      2180,   -307,  -2230,  -1685,   -998,   2091,   -112,     21,
     -1551,   1182,   6649,   -326,    792,   1818,  -7596,    563,
      1076,   7422,   -908,   1524,   -223,   5798,   1318,  -3376,
       517,   4162,    756,  -4142,   1776,    390,    334,    -44,
       218,   5290,    792,     39,   1692,    542,    -62,   -595,
       590,     27,   8922,    989,    182,    725,    112,    458,
     -9170,  -1000,   1176,  -1290,  -1403,   -726,   5990,   -297,
      1234,  -1724,   -601,    528,   1072,    184,   -146,     61,
       685,   1208,    -88,   -211,    356,   9569,   -363,   -135,
      -159,  -1061,   -105,   -410,    -58,    335,  -9986,   -300,
      -211,    607,    443,   -410,  -1730,   -328,    275,    579,
       805,    899,   -464,    -18,    296,   -446,   2396,    -13,
       414,  -9662,   -385,   -808,  -1867,    154,   -572,   3351,
     -1839,    -80,   1157,   -326,    481,   8815,  -1039,   1065,
      2110,   1223,   -960,    -33,   -464,  -5660,    490,   -314,
       346,    730,   -387,  -1102,   6656,   -719,  -1173,    -57,
     -1186,   2394,  -1300,   -665,   -586,    -39,    -71,    155,
      1184,      4,  -3269,   -333,   -747,    580,    279,   -583,
      7164,   -185,    110,   2465,    428,    507,   4462,  -4461,
       199,    337,  -3597,   -249,    -70,   -680,  -5549,   1533,
       917,   -303,  -9230,   -431,   -124,  -1019,    369,    139,
      1367,    151,  -1047,   6820,   -151,    222,  -2934,   -817,
       971,  -7325,    556,   1035,  -1240,   3115,  -1326,   4012,
      2812,   1057,   2580,   -261,   3989,   1999,   1624,   2402,
      -310,    779,   -354,   -377,   -149,   1035,  -2363,    358,
      3666,   -246,  -1896,    375,   3919,  -1392,    683,    624,
     -5872,    644,    391,    288,   -198,   -237,     68,   -284,
        88,  -1016,    250,     32,   1188,   -243,   -608,   -320,
      -219, -11087,    543,    156,   1034,   -169,   -183,   -549,
       -66,    716,    996,   -928,   -309,   5577,    229,    125,
     -1328,   9027,   -698,   -485,  -1694,    839,    343,    449,
      1655,   1005,   1053,   -408,   9106,    186,    670,    774,
       314,    573,   3888,   -882,     26,   2518,   -533,   -195,
       555,    337,   -246, -10779,   -231,     31,   -314,   -941,
      1129,    333,  -7503,    168,   -551,    237,   -159,   4399,
       421,    693,    198,   -196,   -561,   1035,   -548,   1058,
       527,   3617,   -361,   1317,  -1975,  -2638,  -1966,   -120,
      -324,   5678,  -2252,   -663,    181,   -273,  -3073,   -282,
      -622,    363,     71,    184,   -776,    284,  -1516,   -430,
         3,    937,   8587,    258,  -1060,  -1555,   -830,   -338,
       318,  -9130,   -110,    459,   -572,     70,     93,    120,
      -534,   1296,   -168,     29,   -914,   -332,   -997,   -818,
       270,   -243,    523,     56, -11847,   -448,     11,   -154,
       164,   2115,    -13,   -635,    708,   -663,     43,   -248,
     -3244,    254,     19,  -1125,    508,    154,   8697,    191,
       595,   4393,  -2806,   -168,  -1916,    393,   3976,    897,
     -1716,    -35,   -180,    605,  -1057,  -1194,    100,   -384,
       -37,   -107,   2739,   -207,   6899,    176,     81,   -901,
      1280,  -1670,   -101,    281,   1147,     48,     21,   -151,
     -1236,    210,     98,   -114,   -573,   7940,   -153,   -302,
     -1331,    337,   -322,   6598,    477,    147,   -999,  -3166,
      -232,  -5104,   -799,  -1866,    -58,  -4213,   1376,    181,
       675,    562,    126,    235,   2260,  -5152,   -243,   -699,
     -1476,   4135,    569,    567,    737,  -4163,    613,  -1057,
      1778,    546,   -450,    -24,    325,    366,   2406,  -1319,
        60,  -5126,     49,    657,  -5937,   -194,    882,   3267,
       178,   -298,   1873,  12422,    459,    272,    195,  -1827,
       212,   -802,    730,    471,   1556,    422,    640,    236,
        71,    597,   5783,   5378,   -649,   1524,    829,    437,
      -351,   -122,  -1400,   2119,   -128,     75,  -1677,   -633,
      -322,  -6382,   -573,   -974,   1672,   -378,   -242,   3708,
        79,  -1325,    397,   -150,   1977,    442,    747,   -127,
};

static const int16_t shape16s[] = {
      -392,     96,  -7720,     99,    524,  -8272,    -20,    164,
      -434,    -85,   -428,   1362,    108,    223,   1053,    -11,
      -193,  -5140,   -191,   -159,    193,   8005,    -39,   -483,
      1764,  -1061,   -268,   -318,   -880,    474,     49,     -8,
      -223,    130,  11263,    165,     12,    -43,   -103,  -1145,
      -588,    -81,    299,     73,    444,  -7243,  -1411,   -640,
      -946,     16,   -881,    496,   2403,   -476,   1090,   -294,
        29,   -148,    109,    145,    -52,    247,   -545,   1115,
     -7451,   -491,  -1459,    397,  -8603,  -1022,   1494,    298,
     -5156,   -358,  -1097,  -2911,    423,    652,   -378,  -2357,
       -74,    415,   -367,    402,   2173,   -154,    122,    283,
      1352,    302,   -373,   -431,   -283,   -109,    -64,   -343,
      -108,     55, -14644,    241,     37,   -723,    -71,   -208,
      -126,   4061,  -9887,    494,   2273,   -505,  -4040,     66,
      -806,  -1121,  -1894,    783,  -1445,    426,   -820,  -1739,
       -11,    650,   -282,   -518,    124,  -7266,    -21,    160,
      -339,      5,   -208,  11712,    198,    -53,    921,     89,
      5987,  -4806,    176,   1884,     64,   -517,   2169,    108,
       297,   -111,   -389,   -840,    663,     75,   -485,  -4862,
      -177,   2663,   -229,   8120,   -219,    462,   3104,    955,
       384,   1310,    -73,   -504,    258,    170,  -1796,   -482,
      5691,   -437,  -8474,    583,  -1685,   -827,    292,    -65,
      1994,   -384,    105,    123,    256,    -82,   -367,  15204,
      -128,   -260,    -10,    169,    249,  -1286,   1055,    136,
       678,     61,   1420,   -159,    -15,   -221,   -250,    107,
       -21,    297,     54,    242,   -111,    468,    237,    -36,
      -159,     37,   -102,   -488,  -4577,     72,   1009,     -1,
      1218,   2023,   -640,   -437,    766,   -299,   6144,    184,
     -1023,    171,   -388,    884,  -1294,   -320,   8718,    896,
      -295,   -976,   -803,   3092,   1720,   -255,  -1354,   -665,
       -63,   4382,     41,   -121,   -157,    354,    127,    587,
      -599,   -231,    484,   -150,   -284,   -498,   -511,     79,
      5503,     13,   6537,    761,  -1619,   1164,  -2403,   3057,
     -4966,    724,   1076,  -1555,    889,   -365,     60,   -440,
     -7144,   -132,    283,   -305,   -126,  -1482,    125,    -52,
       -33,   1284,   -961,   1355,    953,  -1012,   -227,     86,
       731,    -14, -15977,    -56,   -875,  -1676,    127,    500,
      3390,    -14,   -319,   -644,    143,    249, -10752,     23,
        54,  -1075,   -111,    680,  -1714,    328,  -2092,   -852,
       622,    949,     61,      6,    -17,    144,    190,    216,
       130,    -65,     27,   -322,   -139,     43,     89,     76,
       -84, -10120,    -47,    367,   -261,     38,     50,   4233,
      -210,     14,     -1,     25,    762,   -299,   -132,    177,
       974,   -492,   -145,    -43,   5105,   -394,   -196,    -91,
       -25,    473,  -8358,   -476,    589,  -1372,   -254,  -2387,
      -293,   -304,   3828,   -254,   -193,    493,     54,   -108,
     -8789,   -262,   -233,   -821,   -222,    714,   1270,    -61,
       892,     13,   3952,    -36,  -1567,   -620,   -126,  -1056,
       587,    390,    -24,   2027,    267,    218,     15,    -56,
      -130,     40,    551,    -29,  14594,    -23,    106,    -14,
      -172,    279,    427,   -241,    303,    -20,   -748,     55,
      5187,    598,   -217,   2026,    643,    118,    911,   8023,
       296,    791,     39,  -2621,    655,    228,   -671,   -272,
      -176,   6644,   -166,   -264, -10429,     91,    -83,   -684,
      -169,   -344,   2123,   -102,   -333,   -317,   -826,    586,
       116,  -9311,    445,    141,  -1315,   -758,    144,   5620,
       363,     66,    142,   -161,   -684,    454,  -6584,   -205,
       577,    205,    305,  -1536,  -4109,   -318,    121,   -323,
     -1036,   8020,   1146,  -4004,    175,  -1568,  -1537,   -525,
      2284,     62,     11,    640,   1243,    260,   -104,   -344,
       102,   -624,    122,   -300,    266,  -6104,  -1149,    412,
     -1380,     22,   7561,    360,    564,    398,   -338,    174,
       -76,    131,     44,   -426,    -12,   -175,   -113,     78,
       293,   -120,    -92,    331, -16163,    -74,   -101,  -1198,
      -298,   -171,   4052,   -139,   -187,    131,    323,    370,
      -144,   -160,    131,   -284,   -190,     83,    878, -14817,
        14,    196,    198,    294,   -120,     40,    800,   1841,
       393,   -168,    337,   -540,   -356,    130,   9210,    880,
       304,  -2304,   -275,   1394,   9903,    673,    -62,  -4706,
      -130,    274,    528,     89,   -458,    -90,   6318,   -133,
       310,  -5953,    682,     37,   2937,   -371,    197,     77,
      -184,   1240,     22,  -7695,   -171,  -4874,   -676,  -1121,
      -842,   -642,   1160,  -1088,   -864,    352,   -790,    794,
       801,  10564,  -1777,   1095,   -441,   1718,    116,    982,
      -268,    199,  -2408,  -2042,    279,   -146,    645,  -1350,
         5,   -150,   -932,    113,     25,   -672,    153,    158,
     -6140,   -262,    142,   4815,     -1,   -424,    810,     63,
        88,   -510,   -236,   3964,    -66,   1229,    -16,   -758,
    -11023,  -1149,     48,  -1756,    167,   2308,    -96,   -654,
      -639,    369,   -221,     47,    202,    329,   -352,    -26,
       -19,  13198,   -383,    124,  -1211,   3879,   -344,  -1954,
     -8702,     32,    924,    472,   7953,    692,   -216,   -415,
     -3174,  -1959,    935,   4048,    155,   7521,    854,   -157,
       643,   3760,   -107,  -2536,    622,   -742,   1881,   2262,
       758,   -968,   -271,   -131,    385,  -5107,   -212,  -2548,
        29,   -132,   -506,   -190,  -1065,    314,    202,    332,
     -2274,    701,      4,    -22,   -439,    198,   -265,    -92,
      -143,    460,    -32,    189,    334,     87,  -7639,     45,
      -387,   4240,   1231,     92,   1032,   -333,   -280,   2061,
       296,    365,   2003,   -426,    -35,     96,    -62,    882,
      -784,    483,   -128,   -143,    474,  13740,   -166,    184,
      -714,    142,    278,   5622,    -67,    282,    647,   -130,
       -31,    300,    727,    728,    409,    178,   -601,     84,
      8305,   -446,    179,    115,    209,   -273,    -47,   1932,
      -255,  -3171,   -102,    461,   -119,  -8102,   -809,    108,
     -1680,  -3171,   -775,    324,   -246,    132,    -27,     84,
      8495,    -45,    153,     21,  -1384,    290,   -869,     38,
      -440,    133,   -257,    -22,  -3046,     12,  -2797,   4517,
       142,   1605,    423,    579,   -558,   -301,   -257,    701,
      -246,   -468,  -1946,    120,    321,    710,   -217,   -203,
       -50,    -44,  -5866,     80,    259,    488,    754,    124,
      -517,    703,   -197,    146,    576,   -717,    247,   4121,
        10,   -422,  -2686,    329,   1183,  14573,     72,    301,
      2043,   -125,  -1420,  -1263,  10340,   -678,  -1226,    330,
       -62,    173,   5885,    -56,   -178,  -1090,   -616,    953,
      -216,   8277,   -124,    411,   7758,    -78,   -326,    786,
        46,  -1365,   -555,    479,   -774,   -576,      8,    304,
       390,   -186,   -820,     72,    -67,   -585,  11070,   -213,
       -12,    344,   -399,   -748,   -150,   2719,    195,   5652,
      4626,    549,   2782,     -4,   1928,    482,   1008,  -6398,
       843,    457,   1843,    269,   1247,    350,   -661,    -35,
     -6477,   3727,   2313,   -424,   -907,    415,   1075,   3960,
     -1499,     61,    594,   -744,    110,   2486,    967,     27,
     -5263,   -618,   -578,    313,   7055,  -1081,    739,   -492,
     -2051,    317,    112,   -155,   -304,   -507,    150,    253,
       -42,    221,     92,   -275,   -355,  -8494,   -663,    109,
       282,   -836,   -271,   9316,    165,     63,   -171,     10,
       -38,   -180,   -219,   -250,   -924,   -573,   -241,    566,
      -175,     20,    454,    251,   -328,    236,   -215,  -5673,
         0,   -265,    225,    354,    113,   -488,    174,   -132,
       134,   -188,   1255,    -94,    -55,   -193,    404,    504,
       784,   -377,  -5731,    333,   -447,    222,    138,     72,
      -256,    -58,   -230,   -169,    728,   -481,     95,   -394,
       -74,   -489,   -253, -13770,     61,    184,    -36,   5025,
      -232,    321,    253,  -3414,    120,  -2512,    799,   -586,
      1186,  -1135,   -955,    -54,      7,     83,      0,   5259,
       466,  -6358,    254,    388,   -211,    207,   2449,    379,
       430,   -219,   -442,    228,    151,  11819,     67,   -101,
       239,   -282,    121,   -270,   1209,   -386,    553,   -108,
       789,   -518,    237,    -48,    497,   8986,     80,   8232,
       -89,   -359,   -803,    473,    995,   1132,    624,   1353,
      -305,    711,    -71,    -26,     18,    254,  13079,    -72,
       178,    -18,   -116,    293,    155,   -254,   -819,   -166,
      -808,   -190,    150,  -4328,    -33,    -14,    272,  -6417,
        78,     78,     67,    310,   -177,   -435,    225,    610,
       -15,      1,  -6706,     30,      1,   -189,    270,    -21,
       276,   -182,     77,   -231,     30,   -116,  -7713,    158,
       344,    560,   1466,   3575,    -84,  -4583,  -1260,    372,
      1395,  -5223,    284,  -1911,    315,  -2312,    -47,   -207,
       414,    129,     36,     85,    317,   -125,    -63,   -212,
       -76,    130,   -385,    157,    117,     12,  16140,   -171,
       375,   -721,    161,   -342,    950,   -667,   1011,     15,
       536,  -1203,   1039,   -242,   -159,   7664,   -429,   -264,
     -8221,   -109,    867,    -74,    -79,   -414,    544,    206,
       120,   1859,    -44,     73,    554,    121,   -160,   -127,
       -33,     44,    -24,    285,    589, -12514,     51,    464,
        17,    264,     58,  -6861,    367,   -672,    227,   2793,
       782,  -6286,   -420,   -808,  -1247,    895,    950,   1533,
     -1079,   -207,  -1927,  -4947,   -803,   -328,   7677,   -386,
     -4608,   -329,   -485,   2365,  -1492,  -1738,   -378,   -707,
     -1850,   9044,    314,   3530,     61,   2921,     79,   9508,
     -1102,  -3487,    814,  -2828,    550,   -929,   -712,   -274,
      -566,  -2521,    536,   -296,    -97,    951,  11352,   -614,
       106,   -342,  -1017,  -1183,   -157,   -457,    266,    109,
       545,   -313,   1015,   6961,     52,   -224,   2247,   -248,
      -180,  12367,    311,    514,   1218,   -561,  -2546,  -3275,
       218,   8281,    187,  -6550,    -96,  -1001,   1777,     89,
       916,   1042,    399,   -267,    -97,  -3552,    397,   1984,
     -6134,    784,   2136,  -1346,    619,  -1450,  -1022,  -1226,
       185,    306,   -274,   -122,    343,    129,  -4481,   -749,
      -759,   -496,   8785,   -178,    457,   -601,    875,   1040,
      -268,  -1592,   -531,   9667,    360,  -4978,    525,   -436,
       123,  -1566,    227,    820,     74,     -5,   1477,    154,
     -1589,  -9411,    248,   -485,  -3293,   -690,    175,     53,
       -21,    303,  -2376,    106,    515,   2688,   -401,  -1278,
       425,    540,   -353,    662,  -7461,   -397,  -7029,   -976,
       445,  -1648,    164,   -254,   -563,    556,    876,   -205,
       884,    214,    -92,   -509,     96,    -53,   5734,   -295,
      -136,    211,    168,    261,    -74,    411,     25,    -59,
      3596,    400,    320,    -69,    -21,  14062,   -510,    142,
      -232,   1597,     34,    240,   -476,    131,  -3836,   -186,
      2579,   2812,  -1501,    274,   2685,   2809,  -1100,   2696,
      -402,     67,    650,  -1804,    -11,   -216,   6751,    112,
       455,  -7210,   -251,  -1075,   -833,   -966,   1443,   -138,
       273,   -494,   1557,    -15,   -339,    -82,    402,    206,
        31,    -77,    -94,     78,  -5468,   -179,    -44,    421,
       163,   -386,   -133,  -6334,    427,    747,   -121,   -292,
       368,  -1087,   -338,  -1534,   3740,   -881,  -2012,  -1284,
       902,     97,  -3407,   -567,   -118,   1340,    -77,   -445,
       642,    184,    901,   -341,    -81,    595,  -6531,   -248,
      -167,   8740,    373,    408,     23,  10709,   -299,   -876,
      -584,  -1067,     20,  -4556,    295,  -1956,    990,   -132,
      -152,   4068,    -92,    142,  -1512,     23,   -815,    454,
       330,   -331,   9042,    120,   -100,     34,     96,    152,
    -11083,    345,   -567,   -498,    198,    -37,   9276,   -479,
       611,  -2788,    253,   -176,    617,   -224,    248,    390,
        39,     25,   -110,    127,    -13,   6675,    -84,    115,
       294,     84,   -366,   -405,    -32,   -109, -10469,     99,
        17,    -88,   -226,    316,   -133,   -203,    -60,    311,
       -87,   -331,    357,    -11,    158,     74,    562,      8,
       354, -10843,   -114,   -206,    699,   -617,   -141,    807,
        87,   -149,    174,    199,    -55,  10880,   -332,    182,
       544,    651,    -27,    261,   -190,   -655,     24,   -443,
      -630,    204,    207,  -4174,   3557,     89,   -386,   1754,
      -485,   -127,    -97,     40,  -1336,   -488,   -177,   -750,
        88,  -1040,  -2215,   -507,    169,   2908,     69,    -52,
      8458,    601,    174,   1635,    480,    181,   3004,  -3021,
      1868,   -364,  -2100,   -256,  -3065,    -33,  -7467,   -890,
     -1949,    -20,  -9472,   -230,   -847,   -634,   -377,    -40,
      1184,    242,    265,   7056,     42,     16,  -5070,    -71,
       300,  -1186,    187,    337,  -1331,     77,   -473,   3213,
      5738,    626,   2524,    531,   1001,   -803,   1231,  -1083,
      -564,    539,    191,   -498,    184,    603,  -1777,   -479,
      2298,   -604,  -2077,    634,   4682,  -1387,   -875,    498,
    -10011,   -173,    752,    109,    -70,    171,    -64,   -261,
       -79,     37,   -233,    128,    -66,    -70,    356,   -310,
       214, -14792,      6,    200,   -227,     59,   -241,    560,
      -230,    479,    403,    -22,    148,   7428,    110,   -177,
       110,   7518,  -2372,  -1277,    223,   -708,    731,    695,
      -702,  -2906,    256,  -1160,   4941,    121,  -1148,    -68,
      -424,  -1590,   4697,    705,    525,    684,   -451,   -246,
      -115,    556,    543,  -6658,    384,   -589,  -1505,     12,
       114,     82,  -5084,    164,    154,   -295,    106,   -271,
       -40,   -394,   -437,    397,   -279,  -3825,   -286,    632,
     -1041,   1137,    -93,     48,    192,  -5914,    -92,   -235,
       682,   5817,   -702,    180,   -243,   -219,   -910,   -174,
      -146,    142,     12,    -69,   -207,   -269,    -53,    567,
      -336,    114,   9601,   -272,   -270,    459,    610,   -258,
        97, -10950,    397,     57,     -7,    229,   1669,   -173,
      -173,    -92,   -347,   -133,   -357,     92,    132,   -609,
        60,   -124,    116,    -54, -15205,    142,    109,   1127,
       268,   -220,    336,   -743,   -238,    -29,   -902,     91,
     -3597,   -288,   1114,  -3797,  -1615,     32,  11481,     55,
       194,   3567,  -1857,  -2561,   -237,    -15,    -48,   -232,
       -58,    -21,     37,   -535,   -450,    857,   2001,     12,
        48,    840,    211,    126,   4833,    275,    176,   -111,
         9,   -112,   -403,    182,    296,    181,   -425,    -14,
       276,    118,   -240,    384,    139,   9183,   -230,    143,
      2412,    -70,    250,  10191,    809,    -15,   -257,  -1242,
      -163,  -4253,   -352,   -436,    264,  -4998,    -17,   -215,
      1412,   1592,    856,   -159,   4756,  -5032,    307,   -251,
       194,   6414,    -56,     -7,   -503,   -261,   -646,  -1050,
      -271,   -578,   -291,    614,    130,   -336,   -923,   -120,
       149,  -6012,    273,   -295,  -4586,    137,    206,   1246,
       498,    614,    991,  13776,    122,     52,   -660,    -76,
      -211,   -477,   -224,    196,    411,    398,   -590,    820,
      -441,    -35,   4394,   5010,   -902,    509,     45,    747,
      1035,   -455,   -579,    105,   1103,   -496,  -1249,   -248,
        46,  -5771,   -198,   -386,    736,     15,   -335,    -85,
      -624,   -124,    580,   -327,   -102,    -18,    866,    381,
};

static const int16_t shape22[] = {
      2560,   -127,   -137,   -385,  -1875,     90,   -240,    140,
      1290,    200,  -6762,    374,   1871,   8730,   -111,   -555,
     -1524,  -2175,  -4689,    521,   -179,    166,  -1573,   1056,
      -346,    247,    -92,   5713,    561,    233,   -360,    480,
      -741,  -7552,  -1508,    259,  -8746,   1604,   1385,    723,
      5678,   2243,    403,  12370,   3526,    574,   4982,    563,
      1713,  -1337,   1336,    -60,   -890,  -2184,   -563,   9347,
       775,   6318,   -883,   1476,   -335,    736,   -564,    635,
     -5557,    617,     54,    257,   -325,    -66,  -5689,   1061,
      -897,     90,   8394,   2004,   9456,   -222,  -2026,   -969,
        93,     -5,   -922,  -6491,   1496,  -1537,    651,   -277,
     -1038,   6072,  -8534,  -2526,   1645,   1459,    547,   2347,
       -85,   -761,  -7210,   -153,    414,   6096,    383,    320,
       370,   -902,    823,   3071,    499,   -731,     38,    473,
      1693,  -9456,    946,   1218,  -1054,     70,    367,   -469,
     -7861,   -913,    401,    198,    -83,    877,   -308,   8633,
       253,  -2025,   1925,   1412,   1351,   -360,   -948,  -7526,
      1089,  -7449,   1652,    141,    -43,  -2082,     44,    130,
     -7525, -15049,  -1345,    180,  -3009,  -4581,   -267,   2309,
     -1397,   -112,    -63,    307,   -746,    -13,     35,  -8800,
     -1947,  -1143,  -1096,  -2582,  -1210,   7683,   -743,  -1589,
      5699,    -80,  -1375,    -93,   -483,    129,   6076,  -6099,
       374,   -176,  -1150,   -416,    137,  -4309,  -1926,   3099,
        82,   -836,    392,   -655,    108,    428,   3361,    313,
       363,   7534,   1153,    334,   2262,   -367,    -69,   -813,
     -9702,   3074,  -5461,      0,  -1889,   1303,  -8306,   -113,
      -677,    692,  -2752,   1292,   -171,    430,   4609,  -2238,
       196,   1661,    -25,   -164,  -2590,  -4919,   -615,     -7,
      -753,   5104,   5197,    -66,   -310,    827,   -126,    615,
        70,   -456,    238,    682,   -639,   -561,    369,    183,
       113,    430,   -840,   -792,  -7282,  -7537,    619,   -445,
       588,     19,  -1061,    652,     46,    861,   9641,  -1251,
       -41,   -699,   -605,  -1389,    240, -10798,    733,    194,
     -1230,  -1092,   -520,   -219,      7,    518,   -181, -12062,
       651,    -40,   1128,   -390,   -220,   -438,    471,    510,
       632,   -321,   1393,   8827,  -3241,  -6683,    350,   1953,
      -246,   -582,  -5486,  -7576,   -157,    888,   2965,    -23,
       762,   6867,   3697,    -43,  -7905,   -938,   2119,    377,
       -25,    691,    136,   -725,   7643,   -730,   2024,  -6932,
       804,     53,    392,    440,    336,   6235,  -7037,  -5584,
     -1579,   1115,   1757,   1001,     32,   -294,   -592,    300,
      -764,  -8879,  -1612,   -845,   1722,   6968,    384,    267,
       862,  10830,   -364,  -1138,    -49,   1041,   -908, -14960,
       809,    628,  -1150,  -1348,   -437,    805,    877,    -64,
      1041,   5253,   -270,   2022,   1253,   -992,  11015,   2686,
        17,     80,  -1463,   4229,     80,   -834,  -9286,   1179,
        66,    -39,    -64,  -4057,   -423,    116,  -1441,  -1733,
       752,   1674,   1443,    757,  -3149,   9057,  -3522,   4007,
      -893,   1179,   -388,   6368,   -478,   4397,  13868,  -2996,
       790,    704,  -2299,  -6003,    449,  -5410,   1999,    181,
     -1807,   -362,    -57,    454,  -2371,   3658,   -485,   -212,
     11551,   1535,    478,  -1570,   -278,    584,    608,  -5211,
      6965,   1042,   -168,   -337,  -1071,     72,    451,   -204,
     -1000,  -1044,    689,    186,   -166,   -375,   9426,    363,
        93,   -717,    304,    107,   7853,  -1251,   1093,    692,
      -742,     33,    576,    447,    678,    452,    408,  -4813,
       711,   -595,   -516,  -1108,   1941,   3056,   -219,  -3413,
     10946,   1513,  -2375,     48,   -408,     49,   -399,  -5608,
       -58,    161,   4808,    436,     68,  -5675,    230,    832,
     -1228,   6382,   -588,  -1312,    772,   4337,   -405,  -5467,
      -222,   1382,   2158,    620,   -840,    810,  -3830,     48,
      -101,    529,  -2670,   -249,   1035,  -7620,  -1081,  -6646,
      1469,   1043,    743,   1553,   -556,   -274,     68,    238,
      1078,   -110,  -5163,    562,    735,  -8317,   1202,  -1325,
      -962,     61,   4280,    570,   7450,    265,  -1516,    696,
     -1567,   -681,      0,  -4064,   1548,  -2521,    657,    567,
     -8343,   1691,  -1430,   4827,    807,    905,  -2601,  -7415,
       921,  -1741,    363,    309,    211,   -521,   3013,   -797,
       648,  -3709,    961,    662,    403,   -386,   -719,  -5752,
      1355,   6717,    191,    591,   -371,  -1225,  -5125,    800,
      -252,  -5769,   1101,    657,   -141,   2377,  -1365,   -218,
      -114,    148,    276,    358,   -354,     18,    -31,  -9413,
     -5514,  -1458,   -220,    298,    666,    659,    359,    980,
     -1389,    101,   1500,   4661,    472,    264,  -7590,  -1469,
        41,     38,   -259,   -346,   -486,  -9949,    812,    422,
     -1354,  -2461,  -2057,   -253,   1806,   -107,    -41,  16384,
      -140,   -684,   5421,   1907,    -10,   -889,  -1877,  -6815,
      -818,  -5854,  -3196,   -895,  -1706,   -186,   7944,    100,
    -11260,  -4573,   -415,   4685,    395,  -6035,   5789,  -4566,
       624,  -2146,    570,    130,   -892,   1385,   -262,   6638,
     -2324,    348,   -288,    607,  -1574,   7119,  -1037,    -40,
     -4955,   -946,  -5215,  -1013,  -1232,   -875,    -78,   -399,
       231,   -173,  -5860,    189,   -755,  -8265,    745,    966,
       202,  -1858,    -26,   -658,     55,   1131,    -56,   3030,
       158,   3742,  -1261,    317,   6397,    521,   -508,   -522,
     -2040,   -747,  -6906,   -868,   -110,   -719,   2602,   2570,
     -1106,   -787,   -352,   9212,   -545,   7339, -10183,   -726,
      1104,  -1118,  -1655,    383,   1370,   1412,    528,  -4689,
      -398,  -3802,   -682, -11004,  -2310,   8011,   2301,  -5941,
      -512,   3813,    210,   1379, -15209,   1143,  -2344,   2459,
      2368,  -6484,  -2078,   -246,    383,   -204,   1449,   -453,
     -1539,    416,    508,  -7168,  -1930,   4279,    453,   -215,
      -296,   -346,   5691,   -200,   -855,    552,   5921,   -109,
       588,  -3049,   1312,   6767,    -78,  -7204,   1187,   -754,
     -1043,   -455,    412,   -490,   3124,   -273,   1468,   -546,
       552,   -306,    835,   -263,  -7234,    324,    318,  -1224,
       240,    198,    193,   -550,   -684, -12416,     85,  -1469,
      -463,   -301,    180,    290,   -928,  -6399,   -931,    176,
       310,   -692,   7964,   -204,    512,    975,  -6415,   -394,
       -30,   -120,   1638,  -1474,   -381,   5912,    156,   -830,
      -575,   -225,  -4079,   -787,   -957,   -801,    181,    575,
      1116,   -795,   -743,   -981,    434,   -365,  -9780,  -1814,
      1447,   1081,    153,    884,   8697,    259,    881,   -661,
     -1232,   -547,    464,    898,  -3988,   -476,    790,   7589,
      -525,   -809,  -2900,  -1271,    170,    223,  -5050,  -2554,
      1458,   -666,    537,  -6733,    212,    448,  -1556,   1459,
       802,  -2716,  -8785,  11020,   -258,   1229,   1138,    843,
       508,    103,   -657,   1273,   8140,    368,   -605,   6856,
       110,   -423,   5458,   -417,    993,    257,   5552,    -47,
      1401,   -119,  -1320,   6193,  -1196,     56,    -93,  -1604,
     -1491,   -897,    238,    823,   4213,    104,    145,  -1049,
     -9286,    -26,   -813,   -139,    499, -10351,   -466,   -515,
     -1166,   -412,   -746,    503,   1872,     17, -11941,  -3350,
      -108,  -7296,   -411,   4811,  -1870,    162,   5595,   -658,
       339,   -904,   6911,   -715,   -240,    -71,    377,   4747,
       -57,  -8920,    521,    753,   -375,  -1185,   1322,   -328,
         5,    525,   -610,    127,   1519,    791,    784, -16384,
       116,  -1007,   -352,    486,  -7871,    202,  -3684,   -387,
       676,  -8942,   -713,   -447,   -557,   1159,    974,   -380,
     -1183,   1049,     -9,    838,   -932,   -139,    371,   1688,
     -7617,   1192,   2350,   -220,  -4558,   2681,   1568,    102,
      1274,   -446,   -351,   1551,   1101,  -8995,  -5276,  -4416,
      3411,    221,   -429,    412,   1625,  -4575,    254,   -631,
       310,   -378,   9743,    859,    934,    142,  -1400,  -6921,
      6466,  -4068,   2664,    418,     70,    284,   -903,    -23,
      -502,   4354,  -5993,    125,    -34,  -1246,  -1946,   -204,
      1002,  -7454,    -88,  -8628,   2449,  13715,    318,  -8759,
       294,  -2212,    138,   -761,    285,  -1686,    291,    606,
       180,    761,   -359,  -1467,    299,   -417,   -361,   -895,
     -5692,    127,   -951,    165,      1,    396,   -819,  -5508,
       280,    760,   -411,  -1025,   -649,  -1688,  -6290,    272,
       -17,  -7595,      9,    307,    128,  -3995,   -119,    481,
     -3100,   -255,    651,    139,  -3492,     -6,  -4471,    452,
       -71,    139,   1255,  -6128,   1191,    326,     28,   -238,
      1374,   -334,   -457,   -836, -10390,    185,   -616,   3366,
       -39,    183,    -21,   6240,   1141,    341,   -348,    738,
       121,    -65,   -386,    -27,   -548,    337,     -4,   -126,
       571,   2263,   4936,  -1093,   -397,    961,  -5886,   -734,
      1509,   -660,    -61,    170,   -783,  -4197,  -1459,    906,
       -31,    400,   -481,    561,      6,    489,  -5397,  -1666,
        41,   -536,   -116,   6713,   1288,   -157,   -116,   4256,
      1895,   6671,   1837,   -544,   1276,   2031,    345,   6471,
       -84,   1868,  -2006,  -1304,  -7792,    702,  -1189,    105,
     -4869,   -282,   -790,   7083,   -628,  -1273,    252,   -179,
};

static const int16_t shape22s[] = {
       493,     -2,   -310,   -109,  -1218,   -193,   -267,    -11,
      -466,    -34,  -2492,    287,    241,   3621,   -537,    458,
       869,   -915,   -290,    782,     65,    -90,   -635,   1836,
        80,    519,    868,   1359,    550,    -92,   -704,    110,
      -210,  -4337,   -376,   -200,  -2693,      6,    381,    688,
       556,    883,    -88,   1698,   1081,    133,   1130,    -78,
       853,   -424,    -39,   -909,  -1579,  -2774,   -372,   3604,
      -519,   3777,    -66,   1330,  -1055,   1135,   -995,    220,
     -3124,    122,     83,   1045,   -701,   -120,  -6800,   -269,
       195,   1197,   5500,   -490,   5453,   -201,    411,    823,
      -146,     46,    252,  -2724,    606,   -924,  -1538,    394,
      -420,   6405,  -5632,   -941,   -402,   -137,    984,    -24,
       594,    -40,   -140,    -20,    204,   1211,    290,   -680,
       103,   -434,   -294,   1646,   -159,  -2296,   -237,    507,
       -67,  -8999,    -97,    403,  -1473,   -111,     22,   -257,
     -2203,   -600,    577,   -117,     48,   2216,   -170,   1192,
       700,   -477,   1678,    979,   2395,    -69,  -1746,  -2139,
      -294,  -4210,    181,   -372,    320,   -180,   -503,   -550,
     -3994,  -6315,    502,   -804,   -432,   -112,   -457,  -1016,
       637,    297,    932,    533,    798,    229,  -1001,  -2780,
     -4009,   1176,    189,  -1575,     21,   3512,   -348,  -1450,
      2488,    463,    611,    -46,     85,     94,   3319,  -3041,
      -362,   -261,  -1534,  -1900,      7,   -519,    -52,   1166,
      -174,   -152,   -189,   -415,    641,     27,   1764,    280,
      -301,   2976,    146,   -632,   4022,  -1994,    -84,    -61,
     -1633,    285,   -439,    781,   -592,    399,  -4794,    203,
      -295,     32,  -1423,    216,  -2773,     -9,   3589,  -3952,
      -195,    161,   -223,  -2240,  -1886,  -2643,    978,    113,
     -1019,   1645,   1493,   -851,   1417,    -74,    717,    411,
       887,  -1384,     73,    117,    -65,     -7,    133,     18,
        69,     11,    -98,     45,  -1751,  -2710,     11,   -140,
        29,    185,    327,    705,     56,    152,   8202,   -117,
       157,   -478,     36,   -564,    996,  -9359,   -707,    674,
      1169,    270,    156,   -679,     15,    720,    -38,  -4952,
      -196,    183,   -356,  -1004,    185,   -148,    -61,    151,
      -229,   -161,     23,   4350,   -650,  -4384,    -21,    909,
       105,   -271,  -2538,  -4018,  -1268,    351,    396,   -190,
      -135,    970,   3159,   -935,  -6968,   -131,  -1031,     53,
      -430,    242,   -219,    384,   2832,   -151,    152,  -6891,
      1444,    -63,    -46,     72,    653,   3955,  -4187,   -321,
      -298,    678,   -471,    664,    -42,    -30,    825,    195,
     -1147,  -2728,   -178,  -2305,    680,   1980,   -147,    320,
      -348,   4307,    806,   -263,    -60,   -102,      8, -10085,
       626,   -130,    267,   -621,     45,   -157,    438,    190,
        78,   1608,   -246,   -386,    256,   -255,   5651,   -449,
       -13,    198,  -3193,    329,   -500,  -1368,  -6647,    609,
      -507,    -96,    222,  -1196,    171,    -12,   -299,  -1423,
       442,     47,     -5,   -282,    -18,   4969,  -1764,    231,
      -471,   5044,    412,   1496,   -146,     35,   5083,   -228,
       355,   -482,  -1063,   1265,     80,  -1278,   1225,    826,
     -1914,    779,    439,   -511,  -4177,    425,    -38,    -55,
      9786,   1005,   -538,   -664,   -641,    638,    125,  -2811,
      2308,     28,  -1157,   -229,   -624,     45,    354,   -368,
     -1661,     90,    778,   -328,    272,   -223,   9558,    822,
      -167,    -12,  -1020,   2962,   2372,   -932,   1961,   1398,
      2660,      3,    235,    421,    114,   -283,    371,  -1652,
       329,   -435,   -113,  -1296,   -501,   -686,    297,   -384,
     10328,    472,    614,    139,   -765,   -309,    180,  -2009,
      -171,   -175,   3571,    146,     46,  -1356,   -134,    -15,
      -166,   2046,    108,    119,   -281,    971,   -471,  -1134,
        34,   -104,    219,    746,   -223,    245,   -181,     12,
      -165,    216,   -792,     86,    562,  -1807,   -116,  -1324,
       590,   -320,    -80,   1863,   -420,  -1066,   -698,  -2879,
        -6,    182,  -2325,    575,     97,  -2616,   2938,   -673,
      -693,   -116,   1905,   -430,   4739,    -12,  -3307,    693,
      -227,    223,   -111,  -1498,      5,   1751,    -36,    234,
     -4584,    838,   -370,   -296,   -818,    337,    -46,  -8921,
       875,   -423,    496,  -1196,    -24,  -1014,    969,    294,
       237,  -1733,     27,   2543,   1494,    190,    457,  -1391,
      1209,   5651,    548,    504,    686,  -2889,   -151,    725,
       486,  -3716,   -285,    830,     31,   5132,    770,    -24,
      -482,   -369,   -126,  -1552,   -347,   -272,   -387,  -9485,
     -1547,  -1189,    369,    812,    311,    536,    391,    361,
     -1708,   -288,    -94,   2053,    557,   -611,  -4551,  -2368,
       173,    472,    160,  -1849,     96,  -7569,    183,    484,
      -393,   -346,   -309,    -13,     -7,      2,   -239,  10395,
      -587,   -115,   1282,   -634,     81,     90,   -725,  -2685,
     -1214,  -4455,  -1897,  -2903,   -827,    124,   2215,    696,
     -1225,  -1353,   -371,    343,    421,   -640,   1480,  -1174,
        76,   -835,   -716,   -625,   -547,   1250,  -2696,   2132,
      -548,    439,   -607,    408,   -221,   5026,    352,   -344,
     -1339,   -602,  -1650,   -404,   -458,   -502,     61,   -164,
        53,    -26,  -2652,   -209,     64,  -4068,    713,    193,
      -117,  -1290,     95,    -86,   -515,   1336,   -492,   1654,
     -2963,   3663,  -4231,     -1,   3017,    371,    276,     -7,
      -289,    -33,  -5942,    237,     30,    586,   -264,   -493,
       435,   -388,   -165,  10434,    192,   3897,  -5414,    361,
       845,   -259,    481,    331,    650,   -232,     23,  -1789,
        27,  -4065,   1020,  -4261,   -651,   3174,    951,  -3363,
       577,   -112,    642,  -1177,  -1707,    492,   -250,  -1236,
        24,  -1394,  -1807,   -853,   1681,    -69,    851,   -959,
     -5759,   -202,     30,  -3466,   -593,   5414,     65,    141,
      -319,    674,   1183,   -155,   -312,    372,   2829,    -75,
       -60,  -2618,   -240,   2944,   -631,  -4221,    -16,    467,
       211,    -58,     55,   -527,    -51,   -160,    642,   -305,
       388,    413,    210,    -81,  -3383,   -120,    144,   -220,
      -672,   1352,   -630,  -2324,   -423,  -8053,   -131,   -912,
      -260,   -380,    470,    154,  -1346,  -2417,   -426,   -403,
      -137,   -160,   2823,    609,   -216,   -173,   -585,   -514,
        95,   -202,    222,     16,    136,   1751,    237,  -1089,
       957,   -144,   -518,    416,   -347,    -60,    207,    277,
       512,  -1133,    166,   1423,   -883,   -194,  -7016,  -1938,
       417,   2302,   -992,   -179,    738,    -74,    411,   -462,
      -413,     67,    234,   -322,   -164,    -47,    -89,   1409,
       390,  -1180,  -2888,    655,   1958,      0,  -1826,   -471,
     -1247,    307,    104,  -8502,   -198,   -222,    191,    281,
      -868,     47,  -4553,   2434,    174,    263,   2844,    -72,
      -597,  -1183,   -374,    -93,   3348,     13,    173,   6285,
       -32,   -213,   1882,    411,   -608,   -562,   2998,    293,
        54,   -147,   -120,    822,    -93,    679,    206,  -3229,
      -767,  -1603,   -259,   -310,   4306,    548,     -9,    -99,
     -5722,   -328,   -176,    453,    338,  -9687,    -63,    844,
       322,    615,  -1075,   -370,    159,    -33,  -6213,  -1375,
       741,   -801,  -1319,   1513,   1331,    -69,   2702,   -458,
      -203,    103,   4696,   -284,    465,    -62,    -40,   3184,
       238,  -6131,    546,   1713,   -365,    -24,    116,    -33,
       304,    807,   -231,    291,    903,    749,   -254, -12215,
       115,    -35,    -95,   -166,  -3776,   -170,  -4517,   -151,
        67,  -7725,    666,   -573,   -744,   -719,     37,     31,
       373,    148,   -125,     15,   -150,   -905,    -42,    272,
     -5223,    650,   5233,    109,  -1235,    991,    211,   1522,
      -555,   -328,    -52,   5335,    -22,  -5476,  -3102,   -637,
       986,    468,    -37,   -164,   -264,  -1290,    754,   -940,
      -685,   -862,   7270,   -279,   -441,    472,   -153,  -2515,
      3899,    -95,    360,    762,     14,    434,    619,    185,
      -230,   1233,  -1330,   1360,   -756,    361,  -1391,   -247,
       120,  -3573,    293,    375,    806,   5526,    536,    137,
       486,   -484,     13,    -37,     12,     -4,     81,     43,
        10,     43,    -38,   -371,    -64,  -1167,   -117,   -371,
     -1958,   -166,    543,    -97,    -83,    391,    -59,  -1631,
       302,   1077,   -128,   -641,    -64,     21,  -2562,   -235,
       342,  -7121,   -646,    -49,   -961,   -141,   -210,   -555,
     -1596,   -988,    723,   -209,  -3585,     10,    -35,   1051,
         0,    138,    941,  -5002,    805,   3009,     35,    -70,
       513,    -21,   -432,   -224, -10628,   -167,  -1045,   2603,
       336,    360,    515,    683,    981,   3028,    492,   -543,
     -1844,     23,    -30,     52,    -40,    447,     11,    363,
       -95,   1609,   2613,    -13,   -400,    719,  -4513,   -676,
      -290,    456,   -332,    -11,   -261,   -455,     89,   -301,
       285,    287,    202,    281,     87,   -202,  -1482,   -535,
       874,   -478,   -201,   4715,    824,   -204,    145,   2882,
       404,   3376,    363,    -18,   -127,    764,    106,   1626,
       178,    185,     22,   -637,  -6216,   1399,   -961,    -88,
      -553,    -91,     98,   1831,      9,   -583,   1253,  -1741,
};

static const int16_t shape44s[] = {
       -20,   -140,    683,   -586,  -1742,    177,   -538,   1900,
      2193,    -17,  -2096,    261,    645,    339,     77,   1136,
      -521,    537,   -924,   -156,   -261,    195,   1049,    -39,
       236,   -137,      0,   3199,    225,     46,     86,   -215,
       557,  -5394,     17,    911,  -1690,    -48,    -48,   -175,
       -11,   -631,   -153,   4474,   -347,    -39,   1759,    154,
       170,   -180,   -273,    603,   -590,  -5195,    -74,   1789,
       240,   -212,    431,   2447,    368,    -76,   -313,     11,
     -2926,     19,    -71,    208,    -51,   -728,  -6412,    -61,
       141,   -112,   5280,    -76,   4435,   -402,    -25,     46,
       210,   -104,    172,  -3830,   -366,    -23,    239,   -112,
       137,   6692,  -6288,   -720,   -132,   -136,    552,  -1688,
      -345,   -289,   -485,    149,    174,    180,    361,   -236,
        92,    407,      6,   2373,    380,   -167,    845,    444,
      -834,  -9358,    413,  -1302,    460,     77,     34,     56,
     -1516,   -143,    207,    -43,    -31,   -106,    -52,    403,
      -309,    298,    -88,   1552,   -240,   -776,    624,  -4181,
      -342,  -4804,     57,    -23,    160,    -44,    469,    -17,
     -3997,  -5079,   -263,     72,    181,   1085,    538,   -611,
      -368,     59,   -204,   -195,    -40,   -201,   -803,  -5093,
     -3216,    480,     46,   -729,    244,   3320,    185,    503,
      2979,   -416,    110,     25,    140,   -502,   2236,  -4420,
       -36,   -238,   -278,     60,    -82,   -597,    218,     69,
       -95,  -2102,  -2138,  -2308,  -3796,     20,   -211,   -229,
       297,   3665,     81,    148,   1315,  -4537,    -38,    186,
     -3106,   -526,     90,    -35,   -193,   -302,  -5860,    276,
      -308,    206,    645,      1,   -242,    580,   3025,  -2583,
       -90,    511,   -315,   -137,  -2033,  -4313,    693,    485,
      -211,   1486,   1180,    181,   -136,    204,     23,    383,
      1479,   -213,     42,     32,    -64,   -136,    -91,   -146,
       434,    231,     36,    -58,  -3254,  -2647,    -18,    345,
       171,    -60,     84,    209,    246,   -587,   9447,    -67,
      -187,   -108,   -226,   -458,   -519, -11089,   -422,   -502,
       132,     79,    298,   -475,   -412,    196,   -164,  -7347,
       185,   -131,    369,     18,   -500,    644,   -334,     93,
       -77,     71,    341,   3566,   -281,  -4191,   -145,     87,
        37,    306,  -3482,  -5739,    161,   -245,    293,    208,
       380,   2888,     31,    -23,  -2061,   -597,    -56,    350,
      -105,   1167,     64,    342,   3638,    -79,   -106,    148,
      5422,   -719,   -232,      8,   -395,   3249,  -5093,   -222,
      -707,    241,    318,    735,    376,     78,   -166,  -1614,
        -9,  -3373,    330,  -1540,   2028,   3400,     -9,    317,
         9,   4903,    262,     62,    222,    -95,   -208, -13376,
      -101,    121,    298,      5,    172,    406,   -164,     79,
       172,   1993,    235,    229,   1193,   -274,   5944,   -918,
       -15,   1304,    307,   1150,   -385,   -794,  -3467,    660,
      2143,    147,   -279,   -751,   -305,   1052,    205,   -108,
       572,   -212,     29,    -50,      6,   3749,    238,  -2016,
     -1118,  -1329,   -971,   2633,    519,    194,   3545,    -11,
        77,    -92,   1215,   -439,    152,   -863,   1604,    180,
      -514,    252,    308,   -131,   -938,    133,    378,     11,
     12153,     51,    486,     71,   -476,   -599,     57,   -127,
      2685,   -173,   -182,    468,  -3469,   -594,   -380,    265,
      -879,   -352,   -278,   -309,    575,    124,  10814,   -765,
       -64,    710,   -105,    296,   2562,     98,   -358,    556,
      2921,   -133,     -5,   -406,     42,    496,  -1053,  -1957,
       701,    266,    260,   -441,     43,   -192,     -1,  -2174,
      9894,    -90,   -181,     29,     50,   -858,     59,   -190,
        49,   -282,   1632,   1525,    100,  -3659,     13,    173,
      -240,   5304,   -383,    263,   -311,   1747,    169,  -2203,
       -29,   -106,    342,   -301,     66,     49,     23,    857,
      -607,    698,  -1198,   -191,   -450,  -1875,   -329,  -2156,
       156,     95,    145,    129,   -321,     88,   1049,   3980,
       -14,    321,  -1484,    895,    -30,  -2174,    289,    933,
      -933,     15,   2631,     68,   3054,    221,    -87,    175,
       200,    937,    -87,  -2032,    348,    146,   -372,     60,
     -2566,   3497,    -98,    313,    536,   -299,    -58,  -8949,
       323,   -524,   -331,    713,    -47,    360,    155,    168,
       687,  -1391,   1973,    670,    788,   -202,   -129,  -5113,
        54,   1178,   1218,    172,    630,   -154,  -1047,    840,
        71,   -337,     91,    214,   -474,    624,   -773,     16,
      -126,    340,   -631,   -482,   -155,    419,     50, -10976,
      -742,   -781,    169,    149,     33,   -169,     44,    354,
        26,    129,   -179,   1401,    776,   -155,  -3996,   -813,
       594,    238,    -61,    168,   -383,  -9261,    294,    470,
      -322,   -190,   -956,   -290,     27,   -438,   -254,  12571,
       344,   -393,   -568,     56,     81,    171,   -115,  -4370,
        49,   -322,   -237,   -692,    -55,    -49,   4317,     -6,
     -4837,   -156,    179,    247,   -338,    -48,    952,  -1061,
       -33,   -934,    250,   -256,  -1622,   1039,   -738,   2719,
       -20,   -190,    249,   -119,   -235,   6080,    123,   -502,
     -1443,     86,  -1684,   -177,   -128,    -58,   -237,   -641,
      -177,     64,  -2416,     15,   -116,  -6465,   -412,    161,
       419,    768,     36,    113,   -944,   -241,  -1424,    -95,
       635,   1798,  -2257,    -18,   3046,    173,    -33,   -207,
       -52,   -831,  -5730,    -54,   -199,    194,   -255,    467,
      -211,   -853,   -512,  11619,    148,   3681,  -4603,   -282,
       129,   -205,   -606,    167,    306,    464,    485,   -959,
      -203,    254,    151,  -6880,   -262,   5180,    658,  -1378,
      1174,    -53,    -59,    -33,  -3077,   -127,   -223,    -17,
       -31,  -2190,     23,    317,   -169,    203,   -223,   -222,
     -5295,    116,     80,  -2757,   -666,   3377,   -476,     85,
      -630,   -147,   1740,   -175,   -115,    207,    240,   -248,
       -95,  -1016,   3966,   3998,   -343,  -4751,    187,   -113,
      -250,    111,   -510,   -203,    130,     89,    311,    608,
      -221,   -381,   -253,   -359,  -2254,     45,    224,   -141,
        45,    -19,    480,  -5074,    797,  -4580,   -163,    110,
      -234,    337,      6,    707,    492,  -5493,  -2750,    -94,
      -363,    113,   2345,    344,    379,    464,  -3222,    -56,
      -269,   -262,    -10,   -609,    324,   3043,    209,   3092,
      -600,     42,   -615,    -17,    -53,     30,   1123,    224,
       593,    632,    -90,    428,   1117,  -1429,  -6741,    -95,
      -293,   -103,  -2784,    251,   1688,    621,   -349,   1059,
     -1093,   -148,    447,    149,     88,     92,    687,   1249,
        80,    289,  -1841,    221,    -10,    -92,  -1736,    118,
       136,    138,   -162,  -4162,   -111,     62,     95,    166,
      -172,   -695,  -3685,   5694,   -527,   2032,   -549,     43,
      -101,    221,    181,   -479,   7697,   2007,   -127,    805,
       -83,   -535,   1354,   -383,    253,   -622,   2910,   1249,
       782,     13,     42,    994,   -545,     75,   -485,    330,
       -16,    343,    272,   -781,    360,    -97,    -25,   -875,
    -12689,   -623,   -307,    195,   -256, -11644,    229,    180,
       -42,   -361,   -124,    -81,    -23,   -460,  -1993,    212,
      -634,   -847,   1616,   -546,   -583,     99,   3800,     10,
       177,    366,   6106,   -173,    265,   -213,     10,   1108,
      -288,  -1690,   -237,   -312,     38,  -2272,    431,    -26,
      -178,   -764,    507,    355,    677,   -214,   -816, -12411,
        47,     12,    294,   -295,  -3916,   -677,  -4885,   -250,
      -453,  -7716,    478,    231,     17,   -248,    147,   1064,
       637,    -80,    -41,    265,   -383,    142,    116,   2991,
     -3060,    809,   2056,   -119,   -866,    -22,   -660,    233,
       306,  -1873,  -1141,   6995,    186,  -8678,   -109,    -39,
      -105,    730,     18,   -846,    273,  -2922,    210,     26,
      -174,   -142,    990,    131,   -436,   1422,   -217,  -3152,
      3224,     35,    315,    -47,     48,   -221,    568,     44,
       182,   1696,  -1755,   -193,    527,    158,   -555,  -3485,
       171,  -4552,    -47,  -4680,     95,   -112,    184,     80,
       -36,   -915,     87,     24,   -259,  -1743,     68,   -117,
       405,     11,     40,   -320,    -17,   -158,   -134,   -186,
     -1206,   -466,   1262,    133,   -254,   -100,    210,  -1735,
      -636,    319,   -978,     69,    197,   -521,  -5503,    -78,
      -544,  -1011,    101,   -489,   -371,    -79,   -196,    -18,
      -839,   1091,    682,  -1441,  -2375,  -1127,     54,    829,
      -306,   -255,    641,  -3665,    473,   3504,  -1035,   -160,
      -467,   -275,   -437,     79, -13513,    326,    132,     82,
       188,    362,    -74,   1406,    -46,   2864,    351,   -558,
     -1277,    108,    -92,    -53,     72,    -41,    -31,    -97,
       353,     73,   1864,   -207,    106,    -81,  -3930,    173,
        41, 