Name      : jfsutils
Version   : 1.0.18
Release   : 1
Group     : System/Kernel

Summary   : IBM JFS utility programs

Copyright : GPL
Packager  : JFS/Linux team <linuxjfs@us.ibm.com>
URL       : http://oss.software.ibm.com/jfs

Buildroot : %{_tmppath}/%{name}-%{version}
Source    : %{name}-%{version}.tar.gz


%Description
Utilities for managing IBM's Journaled File System (JFS) under Linux.  The
following utilities are available: fsck.jfs - initiate replay of the JFS
transaction log, and check and repair a JFS formatted device. logdump -
dump a JFS formatted device's journal log. logredo - "replay" a JFS
formatted device's journal log.  mkfs.jfs - create a JFS formatted
partition. xchkdmp - dump the contents of a JFS fsck log file created with
xchklog.  xchklog - extract a log from the JFS fsck workspace into a
file.  xpeek - shell-type JFS file system editor.


%Prep
%setup -q

%Build
CFLAGS="${RPM_OPT_FLAGS}" ./configure --mandir=/usr/share/man/en/
make

%Install
make install DESTDIR=${RPM_BUILD_ROOT}

%Clean
rm -rf ${RPM_BUILD_ROOT}

%Files
%defattr(-,root,root)
/sbin/*
%{_mandir}/en/man8/*
%doc AUTHORS COPYING INSTALL NEWS README ChangeLog
