<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"
    "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<!--Traduction anglais 1.7 -->

<html xmlns="http://www.w3.org/1999/xhtml">
  <head>
    <meta name="generator" content="HTML Tidy, see www.w3.org" />
    <meta http-equiv="Content-Type"
    content="text/html; charset=iso-8859-1" />

    <title>Modification de PATH_INFO dans l'environnement
    CGI</title>
  </head>
  <!-- Background white, links blue (unvisited), navy (visited), red (active) -->

  <body bgcolor="#FFFFFF" text="#000000" link="#0000FF"
  vlink="#000080" alink="#FF0000">
        <div align="CENTER">
      <img src="images/sub.gif" alt="[APACHE DOCUMENTATION]" /> 

      <h3>Apache HTTP Server</h3>
    </div>



    <h1 align="CENTER">Modification de PATH_INFO dans
    l'environnement CGI</h1>
    <hr />

    <h2><a id="over" name="over">Vue d'ensemble</a></h2>

    <p>Telle qu'elle &eacute;tait impl&eacute;ment&eacute;e dans
    les versions ant&eacute;rieures &agrave; la version 1.1.1
    d'Apache (comprise), la m&eacute;thode utilis&eacute;e par
    Apache pour cr&eacute;er la variable PATH_INFO dans
    l'environnement CGI &eacute;tait loin d'&ecirc;tre intuitive,
    et pouvait conduire &agrave; certaines d&eacute;faillances dans
    certains cas. A partir de la version 1.2 d'Apache, cette
    m&eacute;thode a &eacute;t&eacute; modifi&eacute;e. Bien que
    ces modifications puissent conduire &agrave; certaines
    incompatibilit&eacute;s avec certaines applications CGI, le
    comportement d'Apache 1.2 reste toujours compatible avec la
    sp&eacute;cification CGI/1.1, et les scripts CGI restent
    facilement modifiables (<a href="#compat">voir
    ci-dessous</a>).</p>

    <h2><a id="prob" name="prob">Le Probl&egrave;me</a></h2>

    <p>Les versions d'Apache jusqu'&agrave; 1.1.1 construisaient
    les variables d'environnement CGI PATH_INFO et SCRIPT_NAME en
    inspectant les noms de fichiers, et non les URL. Bien que cette
    technique conduise &agrave; des valeurs correctes dans la
    plupart des cas, il pouvait arriver que le chemin d&eacute;fini
    par le syst&egrave;me de fichiers soit surcharg&eacute; par une
    red&eacute;finition, laquelle conduisait &agrave; une mauvaise
    interpr&eacute;tation lors de la constitution des variables.
    Par exemple, si la ligne suivante apparaissait dans un fichier
    de configuration :</p>
<pre>
     Alias /cgi-ralph /usr/local/httpd/cgi-bin/user.cgi/ralph
</pre>

    <p>Dans ce cas, <code>user.cgi</code> d&eacute;signe le script
    CGI, la cha&icirc;ne "/ralph" est une information &agrave;
    passer au CGI. Si cette configuration &eacute;tait en place, et
    qu'une requ&ecirc;te vers "<code>/cgi-ralph/script/</code>"
    &eacute;tait re&ccedil;ue, le code du serveur aurait
    constitu&eacute; une variable PATH_INFO de valeur
    "<code>/ralph/script</code>", et SCRIPT_NAME de valeur
    "<code>/cgi-</code>". Il est &eacute;vident de constater que la
    deuxi&egrave;me variable est fausse. Dans certains cas, cela
    aurait m&ecirc;me pu conduire &agrave; un arr&ecirc;t du
    serveur.</p>

    <h2><a id="solution" name="solution">La Solution</a></h2>

    <p>Les versions post&eacute;rieures &agrave; 1.2 d'Apache
    d&eacute;finissent maintenant les variables SCRIPT_NAME et
    PATH_INFO en inspectant directement l'URL, et en
    d&eacute;terminant quelle portion de l'URL est modifiable par
    le client. PATH_INFO est initialis&eacute; &agrave; cette
    partie modifiable. Pour r&eacute;exploiter l'exemple ci-dessus,
    PATH_INFO prendrait maintenant la valeur
    "<code>/script</code>", et SCRIPT_NAME la valeur correcte
    "<code>/cgi-ralph</code>". Il n'y a plus de probl&egrave;me de
    comportement du serveur dans ce cas. Cela permet en outre de
    garantir l'accessibilit&eacute; de l'URL
    <code>http://$SERVER_NAME:$SERVER_PORT$SCRIPT_NAME$PATH_INFO</code>"
    laquelle pointe sur le script courant. Ce n'&eacute;tait pas
    n&eacute;cesairement vrai dans les versions
    pr&eacute;c&eacute;dentes d'Apache.</p>

    <p>Toutefois, l'information "<code>/ralph</code>" de la
    directive <code>Alias</code> est perdue. Nous pensions que
    l'utilisation du syst&egrave;me de fichiers pour faire passer
    ce genre d'information n'&eacute;tait pas une m&eacute;thode
    recommand&eacute;e, et un script utilisant ce principe
    &eacute;tait de toutes fa&ccedil;ons &agrave; &eacute;viter.
    Nous avons ajout&eacute; malgr&eacute; tout &agrave; partir de
    la version 1.2b3 d'Apache une fa&ccedil;on de <a
    href="#compat">contourner</a> cette restriction.</p>

    <h2><a id="compat" name="compat">Compatibilit&eacute; avec des
    serveurs plus anciens</a></h2>

    <p>Il se peut que certains scripts &eacute;crits pour des
    versions ant&eacute;rieures d'Apache ou pour d'autres serveurs
    aient besoin d'exploiter les informations donn&eacute;es dans
    l'ancien mod&egrave;le de variable PATH_INFO. A cet effet, la
    version 1.2 d'Apache (1.2b3 et post&eacute;rieures) proposent
    une variable suppl&eacute;mentaire, appel&eacute;e
    FILEPATH_INFO. Cette nouvelle variable d'environnement contient
    la valeur qui &eacute;tait pr&eacute;c&eacute;demment inscrite
    dans PATH_INFO par la version 1.1.1 d'Apache.</p>

    <p>Un script d&eacute;sirant &ecirc;tre compatible avec toutes
    les versions d'Apache peut simplement tester l'existence de la
    variable FILEPATH_INFO, et utiliser cette variable si besoin
    est. Autrement, il r&eacute;cup&eacute;rera ses informations
    dans la variable PATH_INFO. Par exemple, en Perl, on pourra
    &eacute;crire :</p>
<pre>
    $path_info = $ENV{'FILEPATH_INFO'} || $ENV{'PATH_INFO'};
</pre>

    <p>Par cette &eacute;criture, un script fonctionnera avec tous
    les serveurs conformes &agrave; la sp&eacute;cification
    CGI/1.1, incluant par l&agrave; m&ecirc;me toutes les versions
    d'Apache.</p>
        <hr />

    <h3 align="CENTER">Apache HTTP Server</h3>
    <a href="./"><img src="images/index.gif" alt="Index" /></a>

  </body>
</html>

