/* Copyright (C) EPSON SOFTWARE DEVELOPMENT LABORATORY 1999, 2000
                            Maintenance by EPSON KOWA

   Ghostscript printer driver for EPSON ESC/Page-Color

   This software is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY.  No author or distributor accepts responsibility
   to anyone for the consequences of using it or for whether it serves any
   particular purpose or works at all, unless he says so in writing.  Refer
   to the GNU General Public License for full details.

   Everyone is granted permission to copy, modify and redistribute
   this software, but only under the conditions described in the GNU
   General Public License.  A copy of this license is supposed to have been
   given to you along with this software so you can know your rights and
   responsibilities.  It should be in a file named COPYING.  Among other
   things, the copyright notice and this notice must be preserved on all
   copies.
 */

/*$Id: gdevescv.h,v 1.3 2002/07/12 21:55:11 tillkamppeter Exp $ */
/* Common header file for ESC/Page-Color driver */

#define TRUE		1
#define FALSE		0

#define	GS		(0x1d)
#define	ESC_GS		"\035"
#define	ESC_FF		"\014"
#define	ESC_CR		"\015"
#define	ESC_LF		"\012"
#define	ESC_BS		"\010"

#define	POINT					72
#define	MMETER_PER_INCH				25.4

#define	ESCPAGE_DEFAULT_WIDTH			(4840)
#define	ESCPAGE_DEFAULT_HEIGHT			(6896)

#if 0
#define	ESCPAGE_DEFAULT_WIDTH			(4720 + 5. / (MMETER_PER_INCH / POINT))
#define	ESCPAGE_DEFAULT_HEIGHT			(6772 + 5. / (MMETER_PER_INCH / POINT))

#define	ESCPAGE_DEFAULT_WIDTH			(4960 - 5. / (MMETER_PER_INCH / POINT))
#define	ESCPAGE_DEFAULT_HEIGHT			(7016 - 5. / (MMETER_PER_INCH / POINT))
#endif

#define	ESCPAGE_LEFT_MARGIN_DEFAULT		5. / (MMETER_PER_INCH / POINT)
#define	ESCPAGE_BOTTOM_MARGIN_DEFAULT		5. / (MMETER_PER_INCH / POINT)
#define	ESCPAGE_RIGHT_MARGIN_DEFAULT		5. / (MMETER_PER_INCH / POINT)
#define	ESCPAGE_TOP_MARGIN_DEFAULT		5. / (MMETER_PER_INCH / POINT)

struct node {
    long		byte;
    char		*buf;
    struct node		*next;
};  


#define		BUFCHECK(x)		\
	if (strlen(obuf) > x) {		\
	    (void)fprintf(stderr, "overflow %d : LINE %d\n", strlen(obuf), __LINE__); \
	}



#define ESCPAGE_OPTION_MANUALFEED		"ManualFeed"		/* ѻȥ쥤 */
#define ESCPAGE_OPTION_CASSETFEED		"Casset"		/* ȥ쥤 */
#define ESCPAGE_OPTION_FACEUP			"FaceUp"		/* ӻȥ쥤 */
#define ESCPAGE_OPTION_DUPLEX			"Duplex"		/* ξ̰ */
#define ESCPAGE_OPTION_DUPLEX_TUMBLE		"Tumble"		/* Ȥ */
#define ESCPAGE_OPTION_MEDIATYPE		"MediaType"		/*  */
#define	ESCPAGE_OPTION_RIT			"RITOff"		/* RIT */
#define	ESCPAGE_OPTION_LANDSCAPE		"Landscape"		/* LANDSCAPE */
#define ESCPAGE_OPTION_TONERDENSITY		"TonerDensity"		/* ȥʡǻ */
#define ESCPAGE_OPTION_TONERSAVING		"TonerSaving"		/* ȥʡ */
#define ESCPAGE_OPTION_COLLATE			"Collate"		/*  */

#define ESCPAGE_TUMBLE_DEFAULT			FALSE			/* Long age */
#define ESCPAGE_RIT_DEFAULT			FALSE
#define ESCPAGE_FACEUP_DEFAULT			FALSE
#define ESCPAGE_FACEUP_DEFAULT			FALSE

#define ESCPAGE_MEDIATYPE_DEFAULT		0			/* NORMAL */
#define ESCPAGE_MEDIACHAR_MAX			32

#define ESCPAGE_MANUALFEED_DEFAULT		FALSE
#define ESCPAGE_CASSETFEED_DEFAULT		0

#define	ESCPAGE_DPI_MIN				60
#define	ESCPAGE_DPI_MAX				600
#define	ESCPAGE_DPI_SUPERFINE			1200

#define ESCPAGE_A3_HEIGHT			1190
#define ESCPAGE_A3_WIDTH			842
#define ESCPAGE_POSTCARD_HEIGHT			419
#define ESCPAGE_POSTCARD_WIDTH			284
#define ESCPAGE_LETTER_HEIGHT			792
#define ESCPAGE_LETTER_WIDTH			612
#define ESCPAGE_LEDGER_HEIGHT			1224
#define ESCPAGE_LEDGER_WIDTH			ESCPAGE_LETTER_HEIGHT

#define ESCPAGE_HEIGHT_MAX			ESCPAGE_A3_HEIGHT
#define ESCPAGE_WIDTH_MAX			ESCPAGE_A3_WIDTH
#define ESCPAGE_HEIGHT_MIN			ESCPAGE_POSTCARD_HEIGHT
#define ESCPAGE_WIDTH_MIN			ESCPAGE_POSTCARD_WIDTH

#define EP_COMPRESS5				(5 << 16)
#define EP_COMPRESS20				(20 << 16)
#define EP_COMPRESS30				(30 << 16)

#define RES1200					ESCPAGE_DPI_SUPERFINE
#define RES600					ESCPAGE_DPI_MAX
#define JPN					TRUE
#define ENG					FALSE
