/*
 * Copyright 2025 LunarG, Inc.
 * Copyright 2025 Google LLC
 * SPDX-License-Identifier: MIT
 */
#ifndef MTL_FORMAT_H
#define MTL_FORMAT_H 1

/* TODO_KOSMICKRISP Haven't modified all
 * Slightly modified naming so they match to enum pipe_format for convenience
 */
enum mtl_pixel_format {
   MTL_PIXEL_FORMAT_INVALID = 0,

   /* Normal 8 bit formats */
   MTL_PIXEL_FORMAT_A8_UNORM = 1,

   MTL_PIXEL_FORMAT_R8_UNORM = 10,
   MTL_PIXEL_FORMAT_R8_SRGB = 11,
   MTL_PIXEL_FORMAT_R8_SNORM = 12,
   MTL_PIXEL_FORMAT_R8_UINT = 13,
   MTL_PIXEL_FORMAT_R8_SINT = 14,

   /* Normal 16 bit formats */
   MTL_PIXEL_FORMAT_R16_UNORM = 20,
   MTL_PIXEL_FORMAT_R16_SNORM = 22,
   MTL_PIXEL_FORMAT_R16_UINT = 23,
   MTL_PIXEL_FORMAT_R16_SINT = 24,
   MTL_PIXEL_FORMAT_R16_FLOAT = 25,

   MTL_PIXEL_FORMAT_R8G8_UNORM = 30,
   MTL_PIXEL_FORMAT_R8G8_SRGB = 31,
   MTL_PIXEL_FORMAT_R8G8_SNORM = 32,
   MTL_PIXEL_FORMAT_R8G8_UINT = 33,
   MTL_PIXEL_FORMAT_R8G8_SINT = 34,

   /* Packed 16 bit formats */
   MTL_PIXEL_FORMAT_B5G6R5_UNORM = 40,
   MTL_PIXEL_FORMAT_A1B5G5R5_UNORM = 41,
   MTL_PIXEL_FORMAT_A4B4G4R4_UNORM = 42,
   MTL_PIXEL_FORMAT_B5G5R5A1_UNORM = 43,

   /* Normal 32 bit formats */
   MTL_PIXEL_FORMAT_R32_UINT = 53,
   MTL_PIXEL_FORMAT_R32_SINT = 54,
   MTL_PIXEL_FORMAT_R32_FLOAT = 55,

   MTL_PIXEL_FORMAT_R16G16_UNORM = 60,
   MTL_PIXEL_FORMAT_R16G16_SNORM = 62,
   MTL_PIXEL_FORMAT_R16G16_UINT = 63,
   MTL_PIXEL_FORMAT_R16G16_SINT = 64,
   MTL_PIXEL_FORMAT_R16G16_FLOAT = 65,

   MTL_PIXEL_FORMAT_R8G8B8A8_UNORM = 70,
   MTL_PIXEL_FORMAT_R8G8B8A8_SRGB = 71,
   MTL_PIXEL_FORMAT_R8G8B8A8_SNORM = 72,
   MTL_PIXEL_FORMAT_R8G8B8A8_UINT = 73,
   MTL_PIXEL_FORMAT_R8G8B8A8_SINT = 74,

   MTL_PIXEL_FORMAT_B8G8R8A8_UNORM = 80,
   MTL_PIXEL_FORMAT_B8G8R8A8_SRGB = 81,

   /* Packed 32 bit formats */
   MTL_PIXEL_FORMAT_R10G10B10A2_UNORM = 90,
   MTL_PIXEL_FORMAT_R10G10B10A2_UINT = 91,

   MTL_PIXEL_FORMAT_R11G11B10_FLOAT = 92,
   MTL_PIXEL_FORMAT_R9G9B9E5_FLOAT = 93,

   MTL_PIXEL_FORMAT_B10G10R10A2_UNORM = 94,

   MTL_PIXEL_FORMAT_BGR10_XR = 554,
   MTL_PIXEL_FORMAT_BGR10_XR_SRGB = 555,

   /* Normal 64 bit formats */
   MTL_PIXEL_FORMAT_R32G32_UINT = 103,
   MTL_PIXEL_FORMAT_R32G32_SINT = 104,
   MTL_PIXEL_FORMAT_R32G32_FLOAT = 105,

   MTL_PIXEL_FORMAT_R16G16B16A16_UNORM = 110,
   MTL_PIXEL_FORMAT_R16G16B16A16_SNORM = 112,
   MTL_PIXEL_FORMAT_R16G16B16A16_UINT = 113,
   MTL_PIXEL_FORMAT_R16G16B16A16_SINT = 114,
   MTL_PIXEL_FORMAT_R16G16B16A16_FLOAT = 115,

   MTL_PIXEL_FORMAT_BGRA10_XR = 552,
   MTL_PIXEL_FORMAT_BGRA10_XR_SRGB = 553,

   /* Normal 128 bit formats */
   MTL_PIXEL_FORMAT_R32G32B32A32_UINT = 123,
   MTL_PIXEL_FORMAT_R32G32B32A32_SINT = 124,
   MTL_PIXEL_FORMAT_R32G32B32A32_FLOAT = 125,

   /* Compressed formats. */

   /* S3TC/DXT */
   MTL_PIXEL_FORMAT_DXT1_RGBA = 130,
   MTL_PIXEL_FORMAT_DXT1_SRGBA = 131,
   MTL_PIXEL_FORMAT_DXT3_RGBA = 132,
   MTL_PIXEL_FORMAT_DXT3_SRGBA = 133,
   MTL_PIXEL_FORMAT_DXT5_RGBA = 134,
   MTL_PIXEL_FORMAT_DXT5_SRGBA = 135,

   /* RGTC */
   MTL_PIXEL_FORMAT_RGTC1_UNORM = 140,
   MTL_PIXEL_FORMAT_RGTC1_SNORM = 141,
   MTL_PIXEL_FORMAT_RGTC2_UNORM = 142,
   MTL_PIXEL_FORMAT_RGTC2_SNORM = 143,

   /* BPTC */
   MTL_PIXEL_FORMAT_BPTC_RGB_FLOAT = 150,
   MTL_PIXEL_FORMAT_BPTC_RGB_UFLOAT = 151,
   MTL_PIXEL_FORMAT_BPTC_RGBA_UNORM = 152,
   MTL_PIXEL_FORMAT_BPTC_SRGBA = 153,

   /* PVRTC */
   MTL_PIXEL_FORMAT_PVRTC_RGB_2BPP = 160,
   MTL_PIXEL_FORMAT_PVRTC_RGB_2BPP_SRGB = 161,
   MTL_PIXEL_FORMAT_PVRTC_RGB_4BPP = 162,
   MTL_PIXEL_FORMAT_PVRTC_RGB_4BPP_SRGB = 163,
   MTL_PIXEL_FORMAT_PVRTC_RGBA_2BPP = 164,
   MTL_PIXEL_FORMAT_PVRTC_RGBA_2BPP_SRGB = 165,
   MTL_PIXEL_FORMAT_PVRTC_RGBA_4BPP = 166,
   MTL_PIXEL_FORMAT_PVRTC_RGBA_4BPP_SRGB = 167,

   /* ETC2 */
   MTL_PIXEL_FORMAT_ETC2_R11_UNORM = 170,
   MTL_PIXEL_FORMAT_ETC2_R11_SNORM = 172,
   MTL_PIXEL_FORMAT_ETC2_RG11_UNORM = 174,
   MTL_PIXEL_FORMAT_ETC2_RG11_SNORM = 176,
   MTL_PIXEL_FORMAT_ETC2_RGBA8 = 178,
   MTL_PIXEL_FORMAT_ETC2_SRGBA8 = 179,

   MTL_PIXEL_FORMAT_ETC2_RGB8 = 180,
   MTL_PIXEL_FORMAT_ETC2_SRGB8 = 181,
   MTL_PIXEL_FORMAT_ETC2_RGB8A1 = 182,
   MTL_PIXEL_FORMAT_ETC2_SRGB8A1 = 183,

   /* ASTC */
   MTL_PIXEL_FORMAT_ASTC_4x4_SRGB = 186,
   MTL_PIXEL_FORMAT_ASTC_5x4_SRGB = 187,
   MTL_PIXEL_FORMAT_ASTC_5x5_SRGB = 188,
   MTL_PIXEL_FORMAT_ASTC_6x5_SRGB = 189,
   MTL_PIXEL_FORMAT_ASTC_6x6_SRGB = 190,
   MTL_PIXEL_FORMAT_ASTC_8x5_SRGB = 192,
   MTL_PIXEL_FORMAT_ASTC_8x6_SRGB = 193,
   MTL_PIXEL_FORMAT_ASTC_8x8_SRGB = 194,
   MTL_PIXEL_FORMAT_ASTC_10x5_SRGB = 195,
   MTL_PIXEL_FORMAT_ASTC_10x6_SRGB = 196,
   MTL_PIXEL_FORMAT_ASTC_10x8_SRGB = 197,
   MTL_PIXEL_FORMAT_ASTC_10x10_SRGB = 198,
   MTL_PIXEL_FORMAT_ASTC_12x10_SRGB = 199,
   MTL_PIXEL_FORMAT_ASTC_12x12_SRGB = 200,

   MTL_PIXEL_FORMAT_ASTC_4x4 = 204,
   MTL_PIXEL_FORMAT_ASTC_5x4 = 205,
   MTL_PIXEL_FORMAT_ASTC_5x5 = 206,
   MTL_PIXEL_FORMAT_ASTC_6x5 = 207,
   MTL_PIXEL_FORMAT_ASTC_6x6 = 208,
   MTL_PIXEL_FORMAT_ASTC_8x5 = 210,
   MTL_PIXEL_FORMAT_ASTC_8x6 = 211,
   MTL_PIXEL_FORMAT_ASTC_8x8 = 212,
   MTL_PIXEL_FORMAT_ASTC_10x5 = 213,
   MTL_PIXEL_FORMAT_ASTC_10x6 = 214,
   MTL_PIXEL_FORMAT_ASTC_10x8 = 215,
   MTL_PIXEL_FORMAT_ASTC_10x10 = 216,
   MTL_PIXEL_FORMAT_ASTC_12x10 = 217,
   MTL_PIXEL_FORMAT_ASTC_12x12 = 218,

   /* ASTC HDR (High Dynamic Range) */
   MTL_PIXEL_FORMAT_ASTC_4x4_FLOAT = 222,
   MTL_PIXEL_FORMAT_ASTC_5x4_FLOAT = 223,
   MTL_PIXEL_FORMAT_ASTC_5x5_FLOAT = 224,
   MTL_PIXEL_FORMAT_ASTC_6x5_FLOAT = 225,
   MTL_PIXEL_FORMAT_ASTC_6x6_FLOAT = 226,
   MTL_PIXEL_FORMAT_ASTC_8x5_FLOAT = 228,
   MTL_PIXEL_FORMAT_ASTC_8x6_FLOAT = 229,
   MTL_PIXEL_FORMAT_ASTC_8x8_FLOAT = 230,
   MTL_PIXEL_FORMAT_ASTC_10x5_FLOAT = 231,
   MTL_PIXEL_FORMAT_ASTC_10x6_FLOAT = 232,
   MTL_PIXEL_FORMAT_ASTC_10x8_FLOAT = 233,
   MTL_PIXEL_FORMAT_ASTC_10x10_FLOAT = 234,
   MTL_PIXEL_FORMAT_ASTC_12x10_FLOAT = 235,
   MTL_PIXEL_FORMAT_ASTC_12x12_FLOAT = 236,

   /* YUV */
   MTL_PIXEL_FORMAT_GBGR422 = 240,
   MTL_PIXEL_FORMAT_BGRG422 = 241,

   /* DEPTH */
   MTL_PIXEL_FORMAT_Z16_UNORM = 250,
   MTL_PIXEL_FORMAT_Z32_FLOAT = 252,

   /* STENCIL */
   MTL_PIXEL_FORMAT_S8_UINT = 253,

   /* DEPTH STENCIL */
   MTL_PIXEL_FORMAT_Z24_UNORM_S8_UINT = 255,
   MTL_PIXEL_FORMAT_Z32_FLOAT_S8X24_UINT = 260,

   MTL_PIXEL_FORMAT_X32_S8X24_UINT = 261,
   MTL_PIXEL_FORMAT_X24_S8_UINT = 262,
};

#endif /* MTL_FORMAT_H */
