/* Any copyright is dedicated to the Public Domain.
 * http://creativecommons.org/publicdomain/zero/1.0/ */

"use strict";

async function checkOCSP(url, shouldBeRendered) {
  await BrowserTestUtils.withNewTab(url, async function(browser) {
    await SpecialPowers.spawn(browser, [shouldBeRendered], async function(
      shouldBeRendered
    ) {
      let certificateSection = await ContentTaskUtils.waitForCondition(() => {
        return content.document.querySelector("certificate-section");
      }, "Certificate section found");
      let OCSPSection = certificateSection.shadowRoot.querySelector(
        ".ocsp-stapling"
      );
      if (!shouldBeRendered) {
        Assert.equal(OCSPSection, null, "OCSPSection found");
        return;
      }
      Assert.ok(OCSPSection, "OCSPSection found");
      let item = OCSPSection.shadowRoot.querySelector("info-item");
      Assert.ok(item, "item found");
      let info = item.shadowRoot.querySelector(".info").textContent;
      Assert.equal(info, "Yes", "OCSP is required");
    });
  });
}

add_task(async function test() {
  let tests = [
    {
      url:
        "about:certificate?cert=MIIE1jCCA76gAwIBAgISA8ud4ZkTgHyRgFEI060JNN%2FFMA0GCSqGSIb3DQEBCwUAMEoxCzAJBgNVBAYTAlVTMRYwFAYDVQQKEw1MZXQncyBFbmNyeXB0MSMwIQYDVQQDExpMZXQncyBFbmNyeXB0IEF1dGhvcml0eSBYMzAeFw0xOTEwMjAwODUzMTFaFw0yMDAxMTgwODUzMTFaMB0xGzAZBgNVBAMTEmRtNHByb2R1Y3Rpb25zLmNvbTB2MBAGByqGSM49AgEGBSuBBAAiA2IABAaBrphEFb0WufNLet5XJDrjo3UYUnEhNJZ5LKbbdaMeRHU%2BamVcM%2B%2Fyddoeq56%2FbeZF0p8oKptxg0TQpeVz4b5ZONe17S6Bp17DN0HLqeX6FXLKyVqRTfoesv7XR1KtW6OCAo8wggKLMA4GA1UdDwEB%2FwQEAwIHgDAdBgNVHSUEFjAUBggrBgEFBQcDAQYIKwYBBQUHAwIwDAYDVR0TAQH%2FBAIwADAdBgNVHQ4EFgQUNXKbW53h63%2Bz%2FBCOyd4pilpoFc8wHwYDVR0jBBgwFoAUqEpqYwR93brm0Tm3pkVl7%2FOo7KEwbwYIKwYBBQUHAQEEYzBhMC4GCCsGAQUFBzABhiJodHRwOi8vb2NzcC5pbnQteDMubGV0c2VuY3J5cHQub3JnMC8GCCsGAQUFBzAChiNodHRwOi8vY2VydC5pbnQteDMubGV0c2VuY3J5cHQub3JnLzAzBgNVHREELDAqghQqLmRtNHByb2R1Y3Rpb25zLmNvbYISZG00cHJvZHVjdGlvbnMuY29tMBEGCCsGAQUFBwEYBAUwAwIBBTBMBgNVHSAERTBDMAgGBmeBDAECATA3BgsrBgEEAYLfEwEBATAoMCYGCCsGAQUFBwIBFhpodHRwOi8vY3BzLmxldHNlbmNyeXB0Lm9yZzCCAQMGCisGAQQB1nkCBAIEgfQEgfEA7wB1ALIeBcyLos2KIE6HZvkruYolIGdr2vpw57JJUy3vi5BeAAABbeiVw3YAAAQDAEYwRAIgHUJgZEK9S5grlRSnDiZMZUWllQ1Ki10T2ldH1XgRfuUCICfKCcvcMas9Wb09athc6kPrD9WxVCi%2FTPfOWVmFv4EdAHYAb1N2rDHwMRnYmQCkURX%2FdxUcEdkCwQApBo2yCJo32RMAAAFt6JXE7wAABAMARzBFAiEAm4lY7Jsj1c%2F%2FzAES61A7hi9jJ5bqQpE1x9KCALQqd4sCIAablaGWv6L3uksVpDH1KDxj1Df9iDPGO2CJSzKjSKdNMA0GCSqGSIb3DQEBCwUAA4IBAQBjP5pR%2Fnj%2FCOZy3Z2LfqN7z%2Fcb87rz0CY7iR5p6PvdvwOs0JPq%2F1pVf4V3JTPmEduP7Z4cYIAoOp2%2BFBE0kZar0zzhp6uXcoBagrlxanG9KvgeWr1hfyJjYbnsteake8Z3vqfjdnlhB5ZFmQudHQh7QAoxtswNbdxjy%2FNwBIR5pKIDxleebVwe%2FneH%2BtokDYSPmH2vsmto0z72VM1KlFjgXC79XDIKMl83R2U%2F1B9wq23EHeFFY38cBUFKEjO67eC9q1Xxsv%2FpYAKrXVkdwwsvHfoY7evFRu%2Fj%2BsS3fWcf8uPrApaoqqJgjxpJ2jHjcXniad47iTffJUmwHqmyeigZ&cert=MIIEkjCCA3qgAwIBAgIQCgFBQgAAAVOFc2oLheynCDANBgkqhkiG9w0BAQsFADA%2FMSQwIgYDVQQKExtEaWdpdGFsIFNpZ25hdHVyZSBUcnVzdCBDby4xFzAVBgNVBAMTDkRTVCBSb290IENBIFgzMB4XDTE2MDMxNzE2NDA0NloXDTIxMDMxNzE2NDA0NlowSjELMAkGA1UEBhMCVVMxFjAUBgNVBAoTDUxldCdzIEVuY3J5cHQxIzAhBgNVBAMTGkxldCdzIEVuY3J5cHQgQXV0aG9yaXR5IFgzMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAnNMM8FrlLke3cl03g7NoYzDq1zUmGSXhvb418XCSL7e4S0EFq6meNQhY7LEqxGiHC6PjdeTm86dicbp5gWAf15Gan%2FPQeGdxyGkOlZHP%2FuaZ6WA8SMx%2Byk13EiSdRxta67nsHjcAHJyse6cF6s5K671B5TaYucv9bTyWaN8jKkKQDIZ0Z8h%2FpZq4UmEUEz9l6YKHy9v6Dlb2honzhT%2BXhq%2Bw3Brvaw2VFn3EK6BlspkENnWAa6xK8xuQSXgvopZPKiAlKQTGdMDQMc2PMTiVFrqoM7hD8bEfwzB%2FonkxEz0tNvjj%2FPIzark5McWvxI0NHWQWM6r6hCm21AvA2H3DkwIDAQABo4IBfTCCAXkwEgYDVR0TAQH%2FBAgwBgEB%2FwIBADAOBgNVHQ8BAf8EBAMCAYYwfwYIKwYBBQUHAQEEczBxMDIGCCsGAQUFBzABhiZodHRwOi8vaXNyZy50cnVzdGlkLm9jc3AuaWRlbnRydXN0LmNvbTA7BggrBgEFBQcwAoYvaHR0cDovL2FwcHMuaWRlbnRydXN0LmNvbS9yb290cy9kc3Ryb290Y2F4My5wN2MwHwYDVR0jBBgwFoAUxKexpHsscfrb4UuQdf%2FEFWCFiRAwVAYDVR0gBE0wSzAIBgZngQwBAgEwPwYLKwYBBAGC3xMBAQEwMDAuBggrBgEFBQcCARYiaHR0cDovL2Nwcy5yb290LXgxLmxldHNlbmNyeXB0Lm9yZzA8BgNVHR8ENTAzMDGgL6AthitodHRwOi8vY3JsLmlkZW50cnVzdC5jb20vRFNUUk9PVENBWDNDUkwuY3JsMB0GA1UdDgQWBBSoSmpjBH3duubRObemRWXv86jsoTANBgkqhkiG9w0BAQsFAAOCAQEA3TPXEfNjWDjdGBX7CVW%2Bdla5cEilaUcne8IkCJLxWh9KEik3JHRRHGJouM2VcGfl96S8TihRzZvoroed6ti6WqEBmtzw3Wodatg%2BVyOeph4EYpr%2F1wXKtx8%2FwApIvJSwtmVi4MFU5aMqrSDE6ea73Mj2tcMyo5jMd6jmeWUHK8so%2FjoWUoHOUgwuX4Po1QYz%2B3dszkDqMp4fklxBwXRsW10KXzPMTZ%2BsOPAveyxindmjkW8lGy%2BQsRlGPfZ%2BG6Z6h7mjem0Y%2BiWlkYcV4PIWL1iwBi8saCbGS5jN2p8M%2BX%2BQ7UNKEkROb3N6KOqkqm57TH2H3eDJAkSnh6%2FDNFu0Qg%3D%3D&cert=MIIDSjCCAjKgAwIBAgIQRK%2BwgNajJ7qJMDmGLvhAazANBgkqhkiG9w0BAQUFADA%2FMSQwIgYDVQQKExtEaWdpdGFsIFNpZ25hdHVyZSBUcnVzdCBDby4xFzAVBgNVBAMTDkRTVCBSb290IENBIFgzMB4XDTAwMDkzMDIxMTIxOVoXDTIxMDkzMDE0MDExNVowPzEkMCIGA1UEChMbRGlnaXRhbCBTaWduYXR1cmUgVHJ1c3QgQ28uMRcwFQYDVQQDEw5EU1QgUm9vdCBDQSBYMzCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAN%2Bv6ZdQCINXtMxiZfaQguzH0yxrMMpb7NnDfcdAwRgUi%2BDoM3ZJKuM%2FIUmTrE4Orz5Iy2Xu%2FNMhD2XSKtkyj4zl93ewEnu1lcCJo6m67XMuegwGMoOifooUMM0RoOEqOLl5CjH9UL2AZd%2B3UWODyOKIYepLYYHsUmu5ouJLGiifSKOeDNoJjj4XLh7dIN9bxiqKqy69cK3FCxolkHRyxXtqqzTWMIn%2F5WgTe1QLyNau7Fqckh49ZLOMxt%2B%2FyUFw7BZy1SbsOFU5Q9D8%2FRhcQPGX69Wam40dutolucbY38EVAjqr2m7xPi71XAicPNaDaeQQmxkqtilX4%2BU9m5%2FwAl0CAwEAAaNCMEAwDwYDVR0TAQH%2FBAUwAwEB%2FzAOBgNVHQ8BAf8EBAMCAQYwHQYDVR0OBBYEFMSnsaR7LHH62%2BFLkHX%2FxBVghYkQMA0GCSqGSIb3DQEBBQUAA4IBAQCjGiybFwBcqR7uKGY3Or%2BDxz9LwwmglSBd49lZRNI%2BDT69ikugdB%2FOEIKcdBodfpga3csTS7MgROSR6cz8faXbauX%2B5v3gTt23ADq1cEmv8uXrAvHRAosZy5Q6XkjEGB5YGV8eAlrwDPGxrancWYaLbumR9YbK%2BrlmM6pZW87ipxZzR8srzJmwN0jP41ZL9c8PDHIyh8bwRLtTcm1D9SZImlJnt1ir%2Fmd2cXjbDaJWFBM5JDGFoqgCWjBH4d1QB7wCCZAA62RjYJsWvIjJEubSfZGL%2BT0yjWW06XyxV3bqxbYoOb8VZRzI9neWagqNdwvYkQsEjgfbKbYK7p2CNTUQ",
      shouldBeRendered: true,
    },
    {
      url:
        "about:certificate?cert=MIIE0DCCBHegAwIBAgIQCP0zdXA01ESx6eTjfitzfzAKBggqhkjOPQQDAjBvMQswCQYDVQQGEwJVUzELMAkGA1UECBMCQ0ExFjAUBgNVBAcTDVNhbiBGcmFuY2lzY28xGTAXBgNVBAoTEENsb3VkRmxhcmUsIEluYy4xIDAeBgNVBAMTF0Nsb3VkRmxhcmUgSW5jIEVDQyBDQS0yMB4XDTE5MDUwMzAwMDAwMFoXDTIwMDUwMzEyMDAwMFowaDELMAkGA1UEBhMCVVMxCzAJBgNVBAgTAkNBMRYwFAYDVQQHEw1TYW4gRnJhbmNpc2NvMRkwFwYDVQQKExBDbG91ZEZsYXJlLCBJbmMuMRkwFwYDVQQDExBzY290dGhlbG1lLmNvLnVrMFkwEwYHKoZIzj0CAQYIKoZIzj0DAQcDQgAEYQYIOYOkA0SNAxlrsvTnr7BIOoNmUaBFG2oXXyKfphkc%2F5wXXMU1Ez1%2BpqjFHSwaAtCkgTzTNEEOxkuDicJLqKOCAvowggL2MB8GA1UdIwQYMBaAFD50LR%2FPRXUEfj%2FAooc%2BTEODURPGMB0GA1UdDgQWBBSlm2TM83mhbWzqLL2SZRmdHbh%2FWDAvBgNVHREEKDAmghBzY290dGhlbG1lLmNvLnVrghIqLnNjb3R0aGVsbWUuY28udWswDgYDVR0PAQH%2FBAQDAgeAMB0GA1UdJQQWMBQGCCsGAQUFBwMBBggrBgEFBQcDAjB5BgNVHR8EcjBwMDagNKAyhjBodHRwOi8vY3JsMy5kaWdpY2VydC5jb20vQ2xvdWRGbGFyZUluY0VDQ0NBMi5jcmwwNqA0oDKGMGh0dHA6Ly9jcmw0LmRpZ2ljZXJ0LmNvbS9DbG91ZEZsYXJlSW5jRUNDQ0EyLmNybDBMBgNVHSAERTBDMDcGCWCGSAGG%2FWwBATAqMCgGCCsGAQUFBwIBFhxodHRwczovL3d3dy5kaWdpY2VydC5jb20vQ1BTMAgGBmeBDAECAjB2BggrBgEFBQcBAQRqMGgwJAYIKwYBBQUHMAGGGGh0dHA6Ly9vY3NwLmRpZ2ljZXJ0LmNvbTBABggrBgEFBQcwAoY0aHR0cDovL2NhY2VydHMuZGlnaWNlcnQuY29tL0Nsb3VkRmxhcmVJbmNFQ0NDQS0yLmNydDAMBgNVHRMBAf8EAjAAMIIBAwYKKwYBBAHWeQIEAgSB9ASB8QDvAHUA7ku9t3XOYLrhQmkfq%2BGeZqMPfl%2BwctiDAMR7iXqo%2FcsAAAFqfaV7eQAABAMARjBEAiAcD2ch9qAysZxlIFqrYjElyv%2B6fPbwBZ%2BCFSgJW7d4cgIgUnpOdauBy9OXIeQerY0ElxqlPDFo0qTx34NBoPmfyOYAdgBep3P531bA57U2SH3QSeAyepGaDIShEhKEGHWWgXFFWAAAAWp9pXsQAAAEAwBHMEUCIQDlDcpBkwV225tooGiDmWX4bwvpko6nmXnQ8RBeSltUGAIgXUCskAznLKPcqf7e55eEj9xwago28rJZny6stP9NqakwCgYIKoZIzj0EAwIDRwAwRAIfVXERnB1UkKpq73xsv0H3o0SC%2FVGdyuIizTc1HHeP6gIhAKSIp4zfgOLP3l46y2yHzir9PdeCc%2BRGUVg4P4IgAANv&cert=MIIDozCCAougAwIBAgIQD%2FPmFjmqPRoSZfQfizTltjANBgkqhkiG9w0BAQsFADBaMQswCQYDVQQGEwJJRTESMBAGA1UEChMJQmFsdGltb3JlMRMwEQYDVQQLEwpDeWJlclRydXN0MSIwIAYDVQQDExlCYWx0aW1vcmUgQ3liZXJUcnVzdCBSb290MB4XDTE1MTAxNDEyMDAwMFoXDTIwMTAwOTEyMDAwMFowbzELMAkGA1UEBhMCVVMxCzAJBgNVBAgTAkNBMRYwFAYDVQQHEw1TYW4gRnJhbmNpc2NvMRkwFwYDVQQKExBDbG91ZEZsYXJlLCBJbmMuMSAwHgYDVQQDExdDbG91ZEZsYXJlIEluYyBFQ0MgQ0EtMjBZMBMGByqGSM49AgEGCCqGSM49AwEHA0IABNFW9Jy25DGg9aRSz%2BOaeob%2F8oayXsy1WcwRx07dZP1VnGDjoEvZeFT%2FSFC6ouGhWHWPx2A3RBZNVZns7tQzeiOjggEZMIIBFTASBgNVHRMBAf8ECDAGAQH%2FAgEAMA4GA1UdDwEB%2FwQEAwIBhjA0BggrBgEFBQcBAQQoMCYwJAYIKwYBBQUHMAGGGGh0dHA6Ly9vY3NwLmRpZ2ljZXJ0LmNvbTA6BgNVHR8EMzAxMC%2BgLaArhilodHRwOi8vY3JsMy5kaWdpY2VydC5jb20vT21uaXJvb3QyMDI1LmNybDA9BgNVHSAENjA0MDIGBFUdIAAwKjAoBggrBgEFBQcCARYcaHR0cHM6Ly93d3cuZGlnaWNlcnQuY29tL0NQUzAdBgNVHQ4EFgQUPnQtH89FdQR%2BP8Cihz5MQ4NRE8YwHwYDVR0jBBgwFoAU5Z1ZMIJHWMys%2BghUNoZ7OrUETfAwDQYJKoZIhvcNAQELBQADggEBADhfp%2F%2F8hfJzMuTVo4mZlmCvMsEDs2Xfvh4DyqXthbKPr0uMc48qjKkADgEkF%2FfsUoV2yOUcecrDF4dQtgQzNp4qnhgXljISr0PMVxje28fYiCWD5coGJTH9vV1IO1EB3SwUx8FgUemVAdiyM1YOR2aNbM2v%2BYXZ6xxHR4g06PD6wqtPaU4JWdRXxszByOPmGcFYOFLi4oOF3iI03D%2Bm968kvOBvwKtoLVLHawVXLEIbLUiHAwyQq0hIqSi%2BNIr7uu30YJkdFXgRqtltU39pKLy3ayB2f6BVA3F59WensKAKF1eyAKmtz%2F9njD4m5ackvMJvEOiJxnCl0h%2BA7Q0%2FJxM%3D&cert=MIIDdzCCAl%2BgAwIBAgIEAgAAuTANBgkqhkiG9w0BAQUFADBaMQswCQYDVQQGEwJJRTESMBAGA1UEChMJQmFsdGltb3JlMRMwEQYDVQQLEwpDeWJlclRydXN0MSIwIAYDVQQDExlCYWx0aW1vcmUgQ3liZXJUcnVzdCBSb290MB4XDTAwMDUxMjE4NDYwMFoXDTI1MDUxMjIzNTkwMFowWjELMAkGA1UEBhMCSUUxEjAQBgNVBAoTCUJhbHRpbW9yZTETMBEGA1UECxMKQ3liZXJUcnVzdDEiMCAGA1UEAxMZQmFsdGltb3JlIEN5YmVyVHJ1c3QgUm9vdDCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAKMEuyKrmD1X6CZymrV51Cni4eiVgLGw41uOKymaZN%2BhXe2wCQVt2yguzmKiYv60iNoS6zjrIZ3AQSsBUnuId9Mcj8e6uYi1agnnc%2BgRQKfRzMpijS3ljwumUNKoUMMo6vWrJYeKmpYcqWe4PwzV9%2FlSEy%2FCG9VwcPCPwBLKBsua4dnKM3p31vjsufFoREJIE9LAwqSuXmD%2BtqYF%2FLTdB1kC1FkYmGP1pWPgkAx9XbIGevOF6uvUA65ehD5f%2FxXtabz5OTZydc93Uk3zyZAsuT3lySNTPx8kmCFcB5kpvcY67Oduhjprl3RjM71oGDHweI12v%2Fyejl0qhqdNkNwnGjkCAwEAAaNFMEMwHQYDVR0OBBYEFOWdWTCCR1jMrPoIVDaGezq1BE3wMBIGA1UdEwEB%2FwQIMAYBAf8CAQMwDgYDVR0PAQH%2FBAQDAgEGMA0GCSqGSIb3DQEBBQUAA4IBAQCFDF2O5G9RaEIFoN27TyclhAO992T9Ldcw46QQF%2BvaKSm2eT929hkTI7gQCvlYpNRhcL0EYWoSihfVCr3FvDB81ukMJY2GQE%2FszKN%2BOMY3EU%2Ft3WgxjkzSswF07r51XgdIGn9w%2FxZchMB5hbgF%2FX%2B%2BZRGjD8ACtPhSNzkE1akxehi%2FoCr0Epn3o0WC4zxe9Z2etciefC7IpJ5OCBRLbf1wbWsaY71k5h%2B3zvDyny67G7fyUIhzksLi4xaNmjICq44Y3ekQEe5%2BNauQrz4wlHrQMz2nZQ%2F1%2FI6eYs9HRCwBXbsdtTLSR9I4LtD%2Bgdwyah617jzV%2FOeBHRnDJELqYzmp",
      shouldBeRendered: false,
    },
  ];

  for (let test of tests) {
    await checkOCSP(test.url, test.shouldBeRendered);
  }
});
