// *** THIS FILE IS GENERATED - DO NOT EDIT ***
// See dispatch_vector_generator.py for modifications

/***************************************************************************
 *
 * Copyright (c) 2015-2025 The Khronos Group Inc.
 * Copyright (c) 2015-2025 Valve Corporation
 * Copyright (c) 2015-2025 LunarG, Inc.
 * Copyright (c) 2015-2024 Google Inc.
 * Copyright (c) 2023-2024 RasterGrid Kft.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 ****************************************************************************/

// NOLINTBEGIN

#pragma once

// This source code creates dispatch vectors for each chassis api intercept,
// i.e., PreCallValidateFoo, PreCallRecordFoo, PostCallRecordFoo, etc., ensuring that
// each vector contains only the validation objects that override that particular base
// class virtual function. Preventing non-overridden calls from reaching the default
// functions saved about 5% in multithreaded applications.

typedef enum InterceptId {
    InterceptIdPreCallValidateGetDeviceQueue,
    InterceptIdPreCallRecordGetDeviceQueue,
    InterceptIdPostCallRecordGetDeviceQueue,
    InterceptIdPreCallValidateQueueSubmit,
    InterceptIdPreCallRecordQueueSubmit,
    InterceptIdPostCallRecordQueueSubmit,
    InterceptIdPreCallValidateQueueWaitIdle,
    InterceptIdPreCallRecordQueueWaitIdle,
    InterceptIdPostCallRecordQueueWaitIdle,
    InterceptIdPreCallValidateDeviceWaitIdle,
    InterceptIdPreCallRecordDeviceWaitIdle,
    InterceptIdPostCallRecordDeviceWaitIdle,
    InterceptIdPreCallValidateAllocateMemory,
    InterceptIdPreCallRecordAllocateMemory,
    InterceptIdPostCallRecordAllocateMemory,
    InterceptIdPreCallValidateFreeMemory,
    InterceptIdPreCallRecordFreeMemory,
    InterceptIdPostCallRecordFreeMemory,
    InterceptIdPreCallValidateMapMemory,
    InterceptIdPreCallRecordMapMemory,
    InterceptIdPostCallRecordMapMemory,
    InterceptIdPreCallValidateUnmapMemory,
    InterceptIdPreCallRecordUnmapMemory,
    InterceptIdPostCallRecordUnmapMemory,
    InterceptIdPreCallValidateFlushMappedMemoryRanges,
    InterceptIdPreCallRecordFlushMappedMemoryRanges,
    InterceptIdPostCallRecordFlushMappedMemoryRanges,
    InterceptIdPreCallValidateInvalidateMappedMemoryRanges,
    InterceptIdPreCallRecordInvalidateMappedMemoryRanges,
    InterceptIdPostCallRecordInvalidateMappedMemoryRanges,
    InterceptIdPreCallValidateGetDeviceMemoryCommitment,
    InterceptIdPreCallRecordGetDeviceMemoryCommitment,
    InterceptIdPostCallRecordGetDeviceMemoryCommitment,
    InterceptIdPreCallValidateBindBufferMemory,
    InterceptIdPreCallRecordBindBufferMemory,
    InterceptIdPostCallRecordBindBufferMemory,
    InterceptIdPreCallValidateBindImageMemory,
    InterceptIdPreCallRecordBindImageMemory,
    InterceptIdPostCallRecordBindImageMemory,
    InterceptIdPreCallValidateGetBufferMemoryRequirements,
    InterceptIdPreCallRecordGetBufferMemoryRequirements,
    InterceptIdPostCallRecordGetBufferMemoryRequirements,
    InterceptIdPreCallValidateGetImageMemoryRequirements,
    InterceptIdPreCallRecordGetImageMemoryRequirements,
    InterceptIdPostCallRecordGetImageMemoryRequirements,
    InterceptIdPreCallValidateGetImageSparseMemoryRequirements,
    InterceptIdPreCallRecordGetImageSparseMemoryRequirements,
    InterceptIdPostCallRecordGetImageSparseMemoryRequirements,
    InterceptIdPreCallValidateQueueBindSparse,
    InterceptIdPreCallRecordQueueBindSparse,
    InterceptIdPostCallRecordQueueBindSparse,
    InterceptIdPreCallValidateCreateFence,
    InterceptIdPreCallRecordCreateFence,
    InterceptIdPostCallRecordCreateFence,
    InterceptIdPreCallValidateDestroyFence,
    InterceptIdPreCallRecordDestroyFence,
    InterceptIdPostCallRecordDestroyFence,
    InterceptIdPreCallValidateResetFences,
    InterceptIdPreCallRecordResetFences,
    InterceptIdPostCallRecordResetFences,
    InterceptIdPreCallValidateGetFenceStatus,
    InterceptIdPreCallRecordGetFenceStatus,
    InterceptIdPostCallRecordGetFenceStatus,
    InterceptIdPreCallValidateWaitForFences,
    InterceptIdPreCallRecordWaitForFences,
    InterceptIdPostCallRecordWaitForFences,
    InterceptIdPreCallValidateCreateSemaphore,
    InterceptIdPreCallRecordCreateSemaphore,
    InterceptIdPostCallRecordCreateSemaphore,
    InterceptIdPreCallValidateDestroySemaphore,
    InterceptIdPreCallRecordDestroySemaphore,
    InterceptIdPostCallRecordDestroySemaphore,
    InterceptIdPreCallValidateCreateEvent,
    InterceptIdPreCallRecordCreateEvent,
    InterceptIdPostCallRecordCreateEvent,
    InterceptIdPreCallValidateDestroyEvent,
    InterceptIdPreCallRecordDestroyEvent,
    InterceptIdPostCallRecordDestroyEvent,
    InterceptIdPreCallValidateGetEventStatus,
    InterceptIdPreCallRecordGetEventStatus,
    InterceptIdPostCallRecordGetEventStatus,
    InterceptIdPreCallValidateSetEvent,
    InterceptIdPreCallRecordSetEvent,
    InterceptIdPostCallRecordSetEvent,
    InterceptIdPreCallValidateResetEvent,
    InterceptIdPreCallRecordResetEvent,
    InterceptIdPostCallRecordResetEvent,
    InterceptIdPreCallValidateCreateQueryPool,
    InterceptIdPreCallRecordCreateQueryPool,
    InterceptIdPostCallRecordCreateQueryPool,
    InterceptIdPreCallValidateDestroyQueryPool,
    InterceptIdPreCallRecordDestroyQueryPool,
    InterceptIdPostCallRecordDestroyQueryPool,
    InterceptIdPreCallValidateGetQueryPoolResults,
    InterceptIdPreCallRecordGetQueryPoolResults,
    InterceptIdPostCallRecordGetQueryPoolResults,
    InterceptIdPreCallValidateCreateBuffer,
    InterceptIdPostCallRecordCreateBuffer,
    InterceptIdPreCallValidateDestroyBuffer,
    InterceptIdPreCallRecordDestroyBuffer,
    InterceptIdPostCallRecordDestroyBuffer,
    InterceptIdPreCallValidateCreateBufferView,
    InterceptIdPreCallRecordCreateBufferView,
    InterceptIdPostCallRecordCreateBufferView,
    InterceptIdPreCallValidateDestroyBufferView,
    InterceptIdPreCallRecordDestroyBufferView,
    InterceptIdPostCallRecordDestroyBufferView,
    InterceptIdPreCallValidateCreateImage,
    InterceptIdPreCallRecordCreateImage,
    InterceptIdPostCallRecordCreateImage,
    InterceptIdPreCallValidateDestroyImage,
    InterceptIdPreCallRecordDestroyImage,
    InterceptIdPostCallRecordDestroyImage,
    InterceptIdPreCallValidateGetImageSubresourceLayout,
    InterceptIdPreCallRecordGetImageSubresourceLayout,
    InterceptIdPostCallRecordGetImageSubresourceLayout,
    InterceptIdPreCallValidateCreateImageView,
    InterceptIdPreCallRecordCreateImageView,
    InterceptIdPostCallRecordCreateImageView,
    InterceptIdPreCallValidateDestroyImageView,
    InterceptIdPreCallRecordDestroyImageView,
    InterceptIdPostCallRecordDestroyImageView,
    InterceptIdPreCallValidateDestroyShaderModule,
    InterceptIdPreCallRecordDestroyShaderModule,
    InterceptIdPostCallRecordDestroyShaderModule,
    InterceptIdPreCallValidateCreatePipelineCache,
    InterceptIdPreCallRecordCreatePipelineCache,
    InterceptIdPostCallRecordCreatePipelineCache,
    InterceptIdPreCallValidateDestroyPipelineCache,
    InterceptIdPreCallRecordDestroyPipelineCache,
    InterceptIdPostCallRecordDestroyPipelineCache,
    InterceptIdPreCallValidateGetPipelineCacheData,
    InterceptIdPreCallRecordGetPipelineCacheData,
    InterceptIdPostCallRecordGetPipelineCacheData,
    InterceptIdPreCallValidateMergePipelineCaches,
    InterceptIdPreCallRecordMergePipelineCaches,
    InterceptIdPostCallRecordMergePipelineCaches,
    InterceptIdPreCallValidateDestroyPipeline,
    InterceptIdPreCallRecordDestroyPipeline,
    InterceptIdPostCallRecordDestroyPipeline,
    InterceptIdPreCallValidateCreatePipelineLayout,
    InterceptIdPostCallRecordCreatePipelineLayout,
    InterceptIdPreCallValidateDestroyPipelineLayout,
    InterceptIdPreCallRecordDestroyPipelineLayout,
    InterceptIdPostCallRecordDestroyPipelineLayout,
    InterceptIdPreCallValidateCreateSampler,
    InterceptIdPreCallRecordCreateSampler,
    InterceptIdPostCallRecordCreateSampler,
    InterceptIdPreCallValidateDestroySampler,
    InterceptIdPreCallRecordDestroySampler,
    InterceptIdPostCallRecordDestroySampler,
    InterceptIdPreCallValidateCreateDescriptorSetLayout,
    InterceptIdPreCallRecordCreateDescriptorSetLayout,
    InterceptIdPostCallRecordCreateDescriptorSetLayout,
    InterceptIdPreCallValidateDestroyDescriptorSetLayout,
    InterceptIdPreCallRecordDestroyDescriptorSetLayout,
    InterceptIdPostCallRecordDestroyDescriptorSetLayout,
    InterceptIdPreCallValidateCreateDescriptorPool,
    InterceptIdPreCallRecordCreateDescriptorPool,
    InterceptIdPostCallRecordCreateDescriptorPool,
    InterceptIdPreCallValidateDestroyDescriptorPool,
    InterceptIdPreCallRecordDestroyDescriptorPool,
    InterceptIdPostCallRecordDestroyDescriptorPool,
    InterceptIdPreCallValidateResetDescriptorPool,
    InterceptIdPreCallRecordResetDescriptorPool,
    InterceptIdPostCallRecordResetDescriptorPool,
    InterceptIdPreCallRecordAllocateDescriptorSets,
    InterceptIdPreCallValidateFreeDescriptorSets,
    InterceptIdPreCallRecordFreeDescriptorSets,
    InterceptIdPostCallRecordFreeDescriptorSets,
    InterceptIdPreCallValidateUpdateDescriptorSets,
    InterceptIdPreCallRecordUpdateDescriptorSets,
    InterceptIdPostCallRecordUpdateDescriptorSets,
    InterceptIdPreCallValidateCreateFramebuffer,
    InterceptIdPreCallRecordCreateFramebuffer,
    InterceptIdPostCallRecordCreateFramebuffer,
    InterceptIdPreCallValidateDestroyFramebuffer,
    InterceptIdPreCallRecordDestroyFramebuffer,
    InterceptIdPostCallRecordDestroyFramebuffer,
    InterceptIdPreCallValidateCreateRenderPass,
    InterceptIdPreCallRecordCreateRenderPass,
    InterceptIdPostCallRecordCreateRenderPass,
    InterceptIdPreCallValidateDestroyRenderPass,
    InterceptIdPreCallRecordDestroyRenderPass,
    InterceptIdPostCallRecordDestroyRenderPass,
    InterceptIdPreCallValidateGetRenderAreaGranularity,
    InterceptIdPreCallRecordGetRenderAreaGranularity,
    InterceptIdPostCallRecordGetRenderAreaGranularity,
    InterceptIdPreCallValidateCreateCommandPool,
    InterceptIdPreCallRecordCreateCommandPool,
    InterceptIdPostCallRecordCreateCommandPool,
    InterceptIdPreCallValidateDestroyCommandPool,
    InterceptIdPreCallRecordDestroyCommandPool,
    InterceptIdPostCallRecordDestroyCommandPool,
    InterceptIdPreCallValidateResetCommandPool,
    InterceptIdPreCallRecordResetCommandPool,
    InterceptIdPostCallRecordResetCommandPool,
    InterceptIdPreCallValidateAllocateCommandBuffers,
    InterceptIdPreCallRecordAllocateCommandBuffers,
    InterceptIdPostCallRecordAllocateCommandBuffers,
    InterceptIdPreCallValidateFreeCommandBuffers,
    InterceptIdPreCallRecordFreeCommandBuffers,
    InterceptIdPostCallRecordFreeCommandBuffers,
    InterceptIdPreCallValidateBeginCommandBuffer,
    InterceptIdPreCallRecordBeginCommandBuffer,
    InterceptIdPostCallRecordBeginCommandBuffer,
    InterceptIdPreCallValidateEndCommandBuffer,
    InterceptIdPreCallRecordEndCommandBuffer,
    InterceptIdPostCallRecordEndCommandBuffer,
    InterceptIdPreCallValidateResetCommandBuffer,
    InterceptIdPreCallRecordResetCommandBuffer,
    InterceptIdPostCallRecordResetCommandBuffer,
    InterceptIdPreCallValidateCmdBindPipeline,
    InterceptIdPreCallRecordCmdBindPipeline,
    InterceptIdPostCallRecordCmdBindPipeline,
    InterceptIdPreCallValidateCmdSetViewport,
    InterceptIdPreCallRecordCmdSetViewport,
    InterceptIdPostCallRecordCmdSetViewport,
    InterceptIdPreCallValidateCmdSetScissor,
    InterceptIdPreCallRecordCmdSetScissor,
    InterceptIdPostCallRecordCmdSetScissor,
    InterceptIdPreCallValidateCmdSetLineWidth,
    InterceptIdPreCallRecordCmdSetLineWidth,
    InterceptIdPostCallRecordCmdSetLineWidth,
    InterceptIdPreCallValidateCmdSetDepthBias,
    InterceptIdPreCallRecordCmdSetDepthBias,
    InterceptIdPostCallRecordCmdSetDepthBias,
    InterceptIdPreCallValidateCmdSetBlendConstants,
    InterceptIdPreCallRecordCmdSetBlendConstants,
    InterceptIdPostCallRecordCmdSetBlendConstants,
    InterceptIdPreCallValidateCmdSetDepthBounds,
    InterceptIdPreCallRecordCmdSetDepthBounds,
    InterceptIdPostCallRecordCmdSetDepthBounds,
    InterceptIdPreCallValidateCmdSetStencilCompareMask,
    InterceptIdPreCallRecordCmdSetStencilCompareMask,
    InterceptIdPostCallRecordCmdSetStencilCompareMask,
    InterceptIdPreCallValidateCmdSetStencilWriteMask,
    InterceptIdPreCallRecordCmdSetStencilWriteMask,
    InterceptIdPostCallRecordCmdSetStencilWriteMask,
    InterceptIdPreCallValidateCmdSetStencilReference,
    InterceptIdPreCallRecordCmdSetStencilReference,
    InterceptIdPostCallRecordCmdSetStencilReference,
    InterceptIdPreCallValidateCmdBindDescriptorSets,
    InterceptIdPreCallRecordCmdBindDescriptorSets,
    InterceptIdPostCallRecordCmdBindDescriptorSets,
    InterceptIdPreCallValidateCmdBindIndexBuffer,
    InterceptIdPreCallRecordCmdBindIndexBuffer,
    InterceptIdPostCallRecordCmdBindIndexBuffer,
    InterceptIdPreCallValidateCmdBindVertexBuffers,
    InterceptIdPreCallRecordCmdBindVertexBuffers,
    InterceptIdPostCallRecordCmdBindVertexBuffers,
    InterceptIdPreCallValidateCmdDraw,
    InterceptIdPreCallRecordCmdDraw,
    InterceptIdPostCallRecordCmdDraw,
    InterceptIdPreCallValidateCmdDrawIndexed,
    InterceptIdPreCallRecordCmdDrawIndexed,
    InterceptIdPostCallRecordCmdDrawIndexed,
    InterceptIdPreCallValidateCmdDrawIndirect,
    InterceptIdPreCallRecordCmdDrawIndirect,
    InterceptIdPostCallRecordCmdDrawIndirect,
    InterceptIdPreCallValidateCmdDrawIndexedIndirect,
    InterceptIdPreCallRecordCmdDrawIndexedIndirect,
    InterceptIdPostCallRecordCmdDrawIndexedIndirect,
    InterceptIdPreCallValidateCmdDispatch,
    InterceptIdPreCallRecordCmdDispatch,
    InterceptIdPostCallRecordCmdDispatch,
    InterceptIdPreCallValidateCmdDispatchIndirect,
    InterceptIdPreCallRecordCmdDispatchIndirect,
    InterceptIdPostCallRecordCmdDispatchIndirect,
    InterceptIdPreCallValidateCmdCopyBuffer,
    InterceptIdPreCallRecordCmdCopyBuffer,
    InterceptIdPostCallRecordCmdCopyBuffer,
    InterceptIdPreCallValidateCmdCopyImage,
    InterceptIdPreCallRecordCmdCopyImage,
    InterceptIdPostCallRecordCmdCopyImage,
    InterceptIdPreCallValidateCmdBlitImage,
    InterceptIdPreCallRecordCmdBlitImage,
    InterceptIdPostCallRecordCmdBlitImage,
    InterceptIdPreCallValidateCmdCopyBufferToImage,
    InterceptIdPreCallRecordCmdCopyBufferToImage,
    InterceptIdPostCallRecordCmdCopyBufferToImage,
    InterceptIdPreCallValidateCmdCopyImageToBuffer,
    InterceptIdPreCallRecordCmdCopyImageToBuffer,
    InterceptIdPostCallRecordCmdCopyImageToBuffer,
    InterceptIdPreCallValidateCmdUpdateBuffer,
    InterceptIdPreCallRecordCmdUpdateBuffer,
    InterceptIdPostCallRecordCmdUpdateBuffer,
    InterceptIdPreCallValidateCmdFillBuffer,
    InterceptIdPreCallRecordCmdFillBuffer,
    InterceptIdPostCallRecordCmdFillBuffer,
    InterceptIdPreCallValidateCmdClearColorImage,
    InterceptIdPreCallRecordCmdClearColorImage,
    InterceptIdPostCallRecordCmdClearColorImage,
    InterceptIdPreCallValidateCmdClearDepthStencilImage,
    InterceptIdPreCallRecordCmdClearDepthStencilImage,
    InterceptIdPostCallRecordCmdClearDepthStencilImage,
    InterceptIdPreCallValidateCmdClearAttachments,
    InterceptIdPreCallRecordCmdClearAttachments,
    InterceptIdPostCallRecordCmdClearAttachments,
    InterceptIdPreCallValidateCmdResolveImage,
    InterceptIdPreCallRecordCmdResolveImage,
    InterceptIdPostCallRecordCmdResolveImage,
    InterceptIdPreCallValidateCmdSetEvent,
    InterceptIdPreCallRecordCmdSetEvent,
    InterceptIdPostCallRecordCmdSetEvent,
    InterceptIdPreCallValidateCmdResetEvent,
    InterceptIdPreCallRecordCmdResetEvent,
    InterceptIdPostCallRecordCmdResetEvent,
    InterceptIdPreCallValidateCmdWaitEvents,
    InterceptIdPreCallRecordCmdWaitEvents,
    InterceptIdPostCallRecordCmdWaitEvents,
    InterceptIdPreCallValidateCmdPipelineBarrier,
    InterceptIdPreCallRecordCmdPipelineBarrier,
    InterceptIdPostCallRecordCmdPipelineBarrier,
    InterceptIdPreCallValidateCmdBeginQuery,
    InterceptIdPreCallRecordCmdBeginQuery,
    InterceptIdPostCallRecordCmdBeginQuery,
    InterceptIdPreCallValidateCmdEndQuery,
    InterceptIdPreCallRecordCmdEndQuery,
    InterceptIdPostCallRecordCmdEndQuery,
    InterceptIdPreCallValidateCmdResetQueryPool,
    InterceptIdPreCallRecordCmdResetQueryPool,
    InterceptIdPostCallRecordCmdResetQueryPool,
    InterceptIdPreCallValidateCmdWriteTimestamp,
    InterceptIdPreCallRecordCmdWriteTimestamp,
    InterceptIdPostCallRecordCmdWriteTimestamp,
    InterceptIdPreCallValidateCmdCopyQueryPoolResults,
    InterceptIdPreCallRecordCmdCopyQueryPoolResults,
    InterceptIdPostCallRecordCmdCopyQueryPoolResults,
    InterceptIdPreCallValidateCmdPushConstants,
    InterceptIdPreCallRecordCmdPushConstants,
    InterceptIdPostCallRecordCmdPushConstants,
    InterceptIdPreCallValidateCmdBeginRenderPass,
    InterceptIdPreCallRecordCmdBeginRenderPass,
    InterceptIdPostCallRecordCmdBeginRenderPass,
    InterceptIdPreCallValidateCmdNextSubpass,
    InterceptIdPreCallRecordCmdNextSubpass,
    InterceptIdPostCallRecordCmdNextSubpass,
    InterceptIdPreCallValidateCmdEndRenderPass,
    InterceptIdPreCallRecordCmdEndRenderPass,
    InterceptIdPostCallRecordCmdEndRenderPass,
    InterceptIdPreCallValidateCmdExecuteCommands,
    InterceptIdPreCallRecordCmdExecuteCommands,
    InterceptIdPostCallRecordCmdExecuteCommands,
    InterceptIdPreCallValidateBindBufferMemory2,
    InterceptIdPreCallRecordBindBufferMemory2,
    InterceptIdPostCallRecordBindBufferMemory2,
    InterceptIdPreCallValidateBindImageMemory2,
    InterceptIdPreCallRecordBindImageMemory2,
    InterceptIdPostCallRecordBindImageMemory2,
    InterceptIdPreCallValidateGetDeviceGroupPeerMemoryFeatures,
    InterceptIdPreCallRecordGetDeviceGroupPeerMemoryFeatures,
    InterceptIdPostCallRecordGetDeviceGroupPeerMemoryFeatures,
    InterceptIdPreCallValidateCmdSetDeviceMask,
    InterceptIdPreCallRecordCmdSetDeviceMask,
    InterceptIdPostCallRecordCmdSetDeviceMask,
    InterceptIdPreCallValidateCmdDispatchBase,
    InterceptIdPreCallRecordCmdDispatchBase,
    InterceptIdPostCallRecordCmdDispatchBase,
    InterceptIdPreCallValidateGetImageMemoryRequirements2,
    InterceptIdPreCallRecordGetImageMemoryRequirements2,
    InterceptIdPostCallRecordGetImageMemoryRequirements2,
    InterceptIdPreCallValidateGetBufferMemoryRequirements2,
    InterceptIdPreCallRecordGetBufferMemoryRequirements2,
    InterceptIdPostCallRecordGetBufferMemoryRequirements2,
    InterceptIdPreCallValidateGetImageSparseMemoryRequirements2,
    InterceptIdPreCallRecordGetImageSparseMemoryRequirements2,
    InterceptIdPostCallRecordGetImageSparseMemoryRequirements2,
    InterceptIdPreCallValidateTrimCommandPool,
    InterceptIdPreCallRecordTrimCommandPool,
    InterceptIdPostCallRecordTrimCommandPool,
    InterceptIdPreCallValidateGetDeviceQueue2,
    InterceptIdPreCallRecordGetDeviceQueue2,
    InterceptIdPostCallRecordGetDeviceQueue2,
    InterceptIdPreCallValidateCreateSamplerYcbcrConversion,
    InterceptIdPreCallRecordCreateSamplerYcbcrConversion,
    InterceptIdPostCallRecordCreateSamplerYcbcrConversion,
    InterceptIdPreCallValidateDestroySamplerYcbcrConversion,
    InterceptIdPreCallRecordDestroySamplerYcbcrConversion,
    InterceptIdPostCallRecordDestroySamplerYcbcrConversion,
    InterceptIdPreCallValidateCreateDescriptorUpdateTemplate,
    InterceptIdPreCallRecordCreateDescriptorUpdateTemplate,
    InterceptIdPostCallRecordCreateDescriptorUpdateTemplate,
    InterceptIdPreCallValidateDestroyDescriptorUpdateTemplate,
    InterceptIdPreCallRecordDestroyDescriptorUpdateTemplate,
    InterceptIdPostCallRecordDestroyDescriptorUpdateTemplate,
    InterceptIdPreCallValidateUpdateDescriptorSetWithTemplate,
    InterceptIdPreCallRecordUpdateDescriptorSetWithTemplate,
    InterceptIdPostCallRecordUpdateDescriptorSetWithTemplate,
    InterceptIdPreCallValidateGetDescriptorSetLayoutSupport,
    InterceptIdPreCallRecordGetDescriptorSetLayoutSupport,
    InterceptIdPostCallRecordGetDescriptorSetLayoutSupport,
    InterceptIdPreCallValidateCmdDrawIndirectCount,
    InterceptIdPreCallRecordCmdDrawIndirectCount,
    InterceptIdPostCallRecordCmdDrawIndirectCount,
    InterceptIdPreCallValidateCmdDrawIndexedIndirectCount,
    InterceptIdPreCallRecordCmdDrawIndexedIndirectCount,
    InterceptIdPostCallRecordCmdDrawIndexedIndirectCount,
    InterceptIdPreCallValidateCreateRenderPass2,
    InterceptIdPreCallRecordCreateRenderPass2,
    InterceptIdPostCallRecordCreateRenderPass2,
    InterceptIdPreCallValidateCmdBeginRenderPass2,
    InterceptIdPreCallRecordCmdBeginRenderPass2,
    InterceptIdPostCallRecordCmdBeginRenderPass2,
    InterceptIdPreCallValidateCmdNextSubpass2,
    InterceptIdPreCallRecordCmdNextSubpass2,
    InterceptIdPostCallRecordCmdNextSubpass2,
    InterceptIdPreCallValidateCmdEndRenderPass2,
    InterceptIdPreCallRecordCmdEndRenderPass2,
    InterceptIdPostCallRecordCmdEndRenderPass2,
    InterceptIdPreCallValidateResetQueryPool,
    InterceptIdPreCallRecordResetQueryPool,
    InterceptIdPostCallRecordResetQueryPool,
    InterceptIdPreCallValidateGetSemaphoreCounterValue,
    InterceptIdPreCallRecordGetSemaphoreCounterValue,
    InterceptIdPostCallRecordGetSemaphoreCounterValue,
    InterceptIdPreCallValidateWaitSemaphores,
    InterceptIdPreCallRecordWaitSemaphores,
    InterceptIdPostCallRecordWaitSemaphores,
    InterceptIdPreCallValidateSignalSemaphore,
    InterceptIdPreCallRecordSignalSemaphore,
    InterceptIdPostCallRecordSignalSemaphore,
    InterceptIdPreCallValidateGetBufferDeviceAddress,
    InterceptIdPreCallRecordGetBufferDeviceAddress,
    InterceptIdPostCallRecordGetBufferDeviceAddress,
    InterceptIdPreCallValidateGetBufferOpaqueCaptureAddress,
    InterceptIdPreCallRecordGetBufferOpaqueCaptureAddress,
    InterceptIdPostCallRecordGetBufferOpaqueCaptureAddress,
    InterceptIdPreCallValidateGetDeviceMemoryOpaqueCaptureAddress,
    InterceptIdPreCallRecordGetDeviceMemoryOpaqueCaptureAddress,
    InterceptIdPostCallRecordGetDeviceMemoryOpaqueCaptureAddress,
    InterceptIdPreCallValidateCreatePrivateDataSlot,
    InterceptIdPreCallRecordCreatePrivateDataSlot,
    InterceptIdPostCallRecordCreatePrivateDataSlot,
    InterceptIdPreCallValidateDestroyPrivateDataSlot,
    InterceptIdPreCallRecordDestroyPrivateDataSlot,
    InterceptIdPostCallRecordDestroyPrivateDataSlot,
    InterceptIdPreCallValidateSetPrivateData,
    InterceptIdPreCallRecordSetPrivateData,
    InterceptIdPostCallRecordSetPrivateData,
    InterceptIdPreCallValidateGetPrivateData,
    InterceptIdPreCallRecordGetPrivateData,
    InterceptIdPostCallRecordGetPrivateData,
    InterceptIdPreCallValidateCmdSetEvent2,
    InterceptIdPreCallRecordCmdSetEvent2,
    InterceptIdPostCallRecordCmdSetEvent2,
    InterceptIdPreCallValidateCmdResetEvent2,
    InterceptIdPreCallRecordCmdResetEvent2,
    InterceptIdPostCallRecordCmdResetEvent2,
    InterceptIdPreCallValidateCmdWaitEvents2,
    InterceptIdPreCallRecordCmdWaitEvents2,
    InterceptIdPostCallRecordCmdWaitEvents2,
    InterceptIdPreCallValidateCmdPipelineBarrier2,
    InterceptIdPreCallRecordCmdPipelineBarrier2,
    InterceptIdPostCallRecordCmdPipelineBarrier2,
    InterceptIdPreCallValidateCmdWriteTimestamp2,
    InterceptIdPreCallRecordCmdWriteTimestamp2,
    InterceptIdPostCallRecordCmdWriteTimestamp2,
    InterceptIdPreCallValidateQueueSubmit2,
    InterceptIdPreCallRecordQueueSubmit2,
    InterceptIdPostCallRecordQueueSubmit2,
    InterceptIdPreCallValidateCmdCopyBuffer2,
    InterceptIdPreCallRecordCmdCopyBuffer2,
    InterceptIdPostCallRecordCmdCopyBuffer2,
    InterceptIdPreCallValidateCmdCopyImage2,
    InterceptIdPreCallRecordCmdCopyImage2,
    InterceptIdPostCallRecordCmdCopyImage2,
    InterceptIdPreCallValidateCmdCopyBufferToImage2,
    InterceptIdPreCallRecordCmdCopyBufferToImage2,
    InterceptIdPostCallRecordCmdCopyBufferToImage2,
    InterceptIdPreCallValidateCmdCopyImageToBuffer2,
    InterceptIdPreCallRecordCmdCopyImageToBuffer2,
    InterceptIdPostCallRecordCmdCopyImageToBuffer2,
    InterceptIdPreCallValidateCmdBlitImage2,
    InterceptIdPreCallRecordCmdBlitImage2,
    InterceptIdPostCallRecordCmdBlitImage2,
    InterceptIdPreCallValidateCmdResolveImage2,
    InterceptIdPreCallRecordCmdResolveImage2,
    InterceptIdPostCallRecordCmdResolveImage2,
    InterceptIdPreCallValidateCmdBeginRendering,
    InterceptIdPreCallRecordCmdBeginRendering,
    InterceptIdPostCallRecordCmdBeginRendering,
    InterceptIdPreCallValidateCmdEndRendering,
    InterceptIdPreCallRecordCmdEndRendering,
    InterceptIdPostCallRecordCmdEndRendering,
    InterceptIdPreCallValidateCmdSetCullMode,
    InterceptIdPreCallRecordCmdSetCullMode,
    InterceptIdPostCallRecordCmdSetCullMode,
    InterceptIdPreCallValidateCmdSetFrontFace,
    InterceptIdPreCallRecordCmdSetFrontFace,
    InterceptIdPostCallRecordCmdSetFrontFace,
    InterceptIdPreCallValidateCmdSetPrimitiveTopology,
    InterceptIdPreCallRecordCmdSetPrimitiveTopology,
    InterceptIdPostCallRecordCmdSetPrimitiveTopology,
    InterceptIdPreCallValidateCmdSetViewportWithCount,
    InterceptIdPreCallRecordCmdSetViewportWithCount,
    InterceptIdPostCallRecordCmdSetViewportWithCount,
    InterceptIdPreCallValidateCmdSetScissorWithCount,
    InterceptIdPreCallRecordCmdSetScissorWithCount,
    InterceptIdPostCallRecordCmdSetScissorWithCount,
    InterceptIdPreCallValidateCmdBindVertexBuffers2,
    InterceptIdPreCallRecordCmdBindVertexBuffers2,
    InterceptIdPostCallRecordCmdBindVertexBuffers2,
    InterceptIdPreCallValidateCmdSetDepthTestEnable,
    InterceptIdPreCallRecordCmdSetDepthTestEnable,
    InterceptIdPostCallRecordCmdSetDepthTestEnable,
    InterceptIdPreCallValidateCmdSetDepthWriteEnable,
    InterceptIdPreCallRecordCmdSetDepthWriteEnable,
    InterceptIdPostCallRecordCmdSetDepthWriteEnable,
    InterceptIdPreCallValidateCmdSetDepthCompareOp,
    InterceptIdPreCallRecordCmdSetDepthCompareOp,
    InterceptIdPostCallRecordCmdSetDepthCompareOp,
    InterceptIdPreCallValidateCmdSetDepthBoundsTestEnable,
    InterceptIdPreCallRecordCmdSetDepthBoundsTestEnable,
    InterceptIdPostCallRecordCmdSetDepthBoundsTestEnable,
    InterceptIdPreCallValidateCmdSetStencilTestEnable,
    InterceptIdPreCallRecordCmdSetStencilTestEnable,
    InterceptIdPostCallRecordCmdSetStencilTestEnable,
    InterceptIdPreCallValidateCmdSetStencilOp,
    InterceptIdPreCallRecordCmdSetStencilOp,
    InterceptIdPostCallRecordCmdSetStencilOp,
    InterceptIdPreCallValidateCmdSetRasterizerDiscardEnable,
    InterceptIdPreCallRecordCmdSetRasterizerDiscardEnable,
    InterceptIdPostCallRecordCmdSetRasterizerDiscardEnable,
    InterceptIdPreCallValidateCmdSetDepthBiasEnable,
    InterceptIdPreCallRecordCmdSetDepthBiasEnable,
    InterceptIdPostCallRecordCmdSetDepthBiasEnable,
    InterceptIdPreCallValidateCmdSetPrimitiveRestartEnable,
    InterceptIdPreCallRecordCmdSetPrimitiveRestartEnable,
    InterceptIdPostCallRecordCmdSetPrimitiveRestartEnable,
    InterceptIdPreCallValidateGetDeviceBufferMemoryRequirements,
    InterceptIdPreCallRecordGetDeviceBufferMemoryRequirements,
    InterceptIdPostCallRecordGetDeviceBufferMemoryRequirements,
    InterceptIdPreCallValidateGetDeviceImageMemoryRequirements,
    InterceptIdPreCallRecordGetDeviceImageMemoryRequirements,
    InterceptIdPostCallRecordGetDeviceImageMemoryRequirements,
    InterceptIdPreCallValidateGetDeviceImageSparseMemoryRequirements,
    InterceptIdPreCallRecordGetDeviceImageSparseMemoryRequirements,
    InterceptIdPostCallRecordGetDeviceImageSparseMemoryRequirements,
    InterceptIdPreCallValidateCmdSetLineStipple,
    InterceptIdPreCallRecordCmdSetLineStipple,
    InterceptIdPostCallRecordCmdSetLineStipple,
    InterceptIdPreCallValidateMapMemory2,
    InterceptIdPreCallRecordMapMemory2,
    InterceptIdPostCallRecordMapMemory2,
    InterceptIdPreCallValidateUnmapMemory2,
    InterceptIdPreCallRecordUnmapMemory2,
    InterceptIdPostCallRecordUnmapMemory2,
    InterceptIdPreCallValidateCmdBindIndexBuffer2,
    InterceptIdPreCallRecordCmdBindIndexBuffer2,
    InterceptIdPostCallRecordCmdBindIndexBuffer2,
    InterceptIdPreCallValidateGetRenderingAreaGranularity,
    InterceptIdPreCallRecordGetRenderingAreaGranularity,
    InterceptIdPostCallRecordGetRenderingAreaGranularity,
    InterceptIdPreCallValidateGetDeviceImageSubresourceLayout,
    InterceptIdPreCallRecordGetDeviceImageSubresourceLayout,
    InterceptIdPostCallRecordGetDeviceImageSubresourceLayout,
    InterceptIdPreCallValidateGetImageSubresourceLayout2,
    InterceptIdPreCallRecordGetImageSubresourceLayout2,
    InterceptIdPostCallRecordGetImageSubresourceLayout2,
    InterceptIdPreCallValidateCmdPushDescriptorSet,
    InterceptIdPreCallRecordCmdPushDescriptorSet,
    InterceptIdPostCallRecordCmdPushDescriptorSet,
    InterceptIdPreCallValidateCmdPushDescriptorSetWithTemplate,
    InterceptIdPreCallRecordCmdPushDescriptorSetWithTemplate,
    InterceptIdPostCallRecordCmdPushDescriptorSetWithTemplate,
    InterceptIdPreCallValidateCmdSetRenderingAttachmentLocations,
    InterceptIdPreCallRecordCmdSetRenderingAttachmentLocations,
    InterceptIdPostCallRecordCmdSetRenderingAttachmentLocations,
    InterceptIdPreCallValidateCmdSetRenderingInputAttachmentIndices,
    InterceptIdPreCallRecordCmdSetRenderingInputAttachmentIndices,
    InterceptIdPostCallRecordCmdSetRenderingInputAttachmentIndices,
    InterceptIdPreCallValidateCmdBindDescriptorSets2,
    InterceptIdPreCallRecordCmdBindDescriptorSets2,
    InterceptIdPostCallRecordCmdBindDescriptorSets2,
    InterceptIdPreCallValidateCmdPushConstants2,
    InterceptIdPreCallRecordCmdPushConstants2,
    InterceptIdPostCallRecordCmdPushConstants2,
    InterceptIdPreCallValidateCmdPushDescriptorSet2,
    InterceptIdPreCallRecordCmdPushDescriptorSet2,
    InterceptIdPostCallRecordCmdPushDescriptorSet2,
    InterceptIdPreCallValidateCmdPushDescriptorSetWithTemplate2,
    InterceptIdPreCallRecordCmdPushDescriptorSetWithTemplate2,
    InterceptIdPostCallRecordCmdPushDescriptorSetWithTemplate2,
    InterceptIdPreCallValidateCopyMemoryToImage,
    InterceptIdPreCallRecordCopyMemoryToImage,
    InterceptIdPostCallRecordCopyMemoryToImage,
    InterceptIdPreCallValidateCopyImageToMemory,
    InterceptIdPreCallRecordCopyImageToMemory,
    InterceptIdPostCallRecordCopyImageToMemory,
    InterceptIdPreCallValidateCopyImageToImage,
    InterceptIdPreCallRecordCopyImageToImage,
    InterceptIdPostCallRecordCopyImageToImage,
    InterceptIdPreCallValidateTransitionImageLayout,
    InterceptIdPreCallRecordTransitionImageLayout,
    InterceptIdPostCallRecordTransitionImageLayout,
    InterceptIdPreCallValidateCreateSwapchainKHR,
    InterceptIdPreCallRecordCreateSwapchainKHR,
    InterceptIdPostCallRecordCreateSwapchainKHR,
    InterceptIdPreCallValidateDestroySwapchainKHR,
    InterceptIdPreCallRecordDestroySwapchainKHR,
    InterceptIdPostCallRecordDestroySwapchainKHR,
    InterceptIdPreCallValidateGetSwapchainImagesKHR,
    InterceptIdPreCallRecordGetSwapchainImagesKHR,
    InterceptIdPostCallRecordGetSwapchainImagesKHR,
    InterceptIdPreCallValidateAcquireNextImageKHR,
    InterceptIdPreCallRecordAcquireNextImageKHR,
    InterceptIdPostCallRecordAcquireNextImageKHR,
    InterceptIdPreCallValidateQueuePresentKHR,
    InterceptIdPreCallRecordQueuePresentKHR,
    InterceptIdPostCallRecordQueuePresentKHR,
    InterceptIdPreCallValidateGetDeviceGroupPresentCapabilitiesKHR,
    InterceptIdPreCallRecordGetDeviceGroupPresentCapabilitiesKHR,
    InterceptIdPostCallRecordGetDeviceGroupPresentCapabilitiesKHR,
    InterceptIdPreCallValidateGetDeviceGroupSurfacePresentModesKHR,
    InterceptIdPreCallRecordGetDeviceGroupSurfacePresentModesKHR,
    InterceptIdPostCallRecordGetDeviceGroupSurfacePresentModesKHR,
    InterceptIdPreCallValidateAcquireNextImage2KHR,
    InterceptIdPreCallRecordAcquireNextImage2KHR,
    InterceptIdPostCallRecordAcquireNextImage2KHR,
    InterceptIdPreCallValidateCreateSharedSwapchainsKHR,
    InterceptIdPreCallRecordCreateSharedSwapchainsKHR,
    InterceptIdPostCallRecordCreateSharedSwapchainsKHR,
    InterceptIdPreCallValidateCreateVideoSessionKHR,
    InterceptIdPreCallRecordCreateVideoSessionKHR,
    InterceptIdPostCallRecordCreateVideoSessionKHR,
    InterceptIdPreCallValidateDestroyVideoSessionKHR,
    InterceptIdPreCallRecordDestroyVideoSessionKHR,
    InterceptIdPostCallRecordDestroyVideoSessionKHR,
    InterceptIdPreCallValidateGetVideoSessionMemoryRequirementsKHR,
    InterceptIdPreCallRecordGetVideoSessionMemoryRequirementsKHR,
    InterceptIdPostCallRecordGetVideoSessionMemoryRequirementsKHR,
    InterceptIdPreCallValidateBindVideoSessionMemoryKHR,
    InterceptIdPreCallRecordBindVideoSessionMemoryKHR,
    InterceptIdPostCallRecordBindVideoSessionMemoryKHR,
    InterceptIdPreCallValidateCreateVideoSessionParametersKHR,
    InterceptIdPreCallRecordCreateVideoSessionParametersKHR,
    InterceptIdPostCallRecordCreateVideoSessionParametersKHR,
    InterceptIdPreCallValidateUpdateVideoSessionParametersKHR,
    InterceptIdPreCallRecordUpdateVideoSessionParametersKHR,
    InterceptIdPostCallRecordUpdateVideoSessionParametersKHR,
    InterceptIdPreCallValidateDestroyVideoSessionParametersKHR,
    InterceptIdPreCallRecordDestroyVideoSessionParametersKHR,
    InterceptIdPostCallRecordDestroyVideoSessionParametersKHR,
    InterceptIdPreCallValidateCmdBeginVideoCodingKHR,
    InterceptIdPreCallRecordCmdBeginVideoCodingKHR,
    InterceptIdPostCallRecordCmdBeginVideoCodingKHR,
    InterceptIdPreCallValidateCmdEndVideoCodingKHR,
    InterceptIdPreCallRecordCmdEndVideoCodingKHR,
    InterceptIdPostCallRecordCmdEndVideoCodingKHR,
    InterceptIdPreCallValidateCmdControlVideoCodingKHR,
    InterceptIdPreCallRecordCmdControlVideoCodingKHR,
    InterceptIdPostCallRecordCmdControlVideoCodingKHR,
    InterceptIdPreCallValidateCmdDecodeVideoKHR,
    InterceptIdPreCallRecordCmdDecodeVideoKHR,
    InterceptIdPostCallRecordCmdDecodeVideoKHR,
    InterceptIdPreCallValidateCmdBeginRenderingKHR,
    InterceptIdPreCallRecordCmdBeginRenderingKHR,
    InterceptIdPostCallRecordCmdBeginRenderingKHR,
    InterceptIdPreCallValidateCmdEndRenderingKHR,
    InterceptIdPreCallRecordCmdEndRenderingKHR,
    InterceptIdPostCallRecordCmdEndRenderingKHR,
    InterceptIdPreCallValidateGetDeviceGroupPeerMemoryFeaturesKHR,
    InterceptIdPreCallRecordGetDeviceGroupPeerMemoryFeaturesKHR,
    InterceptIdPostCallRecordGetDeviceGroupPeerMemoryFeaturesKHR,
    InterceptIdPreCallValidateCmdSetDeviceMaskKHR,
    InterceptIdPreCallRecordCmdSetDeviceMaskKHR,
    InterceptIdPostCallRecordCmdSetDeviceMaskKHR,
    InterceptIdPreCallValidateCmdDispatchBaseKHR,
    InterceptIdPreCallRecordCmdDispatchBaseKHR,
    InterceptIdPostCallRecordCmdDispatchBaseKHR,
    InterceptIdPreCallValidateTrimCommandPoolKHR,
    InterceptIdPreCallRecordTrimCommandPoolKHR,
    InterceptIdPostCallRecordTrimCommandPoolKHR,
    InterceptIdPreCallValidateGetMemoryWin32HandleKHR,
    InterceptIdPreCallRecordGetMemoryWin32HandleKHR,
    InterceptIdPostCallRecordGetMemoryWin32HandleKHR,
    InterceptIdPreCallValidateGetMemoryWin32HandlePropertiesKHR,
    InterceptIdPreCallRecordGetMemoryWin32HandlePropertiesKHR,
    InterceptIdPostCallRecordGetMemoryWin32HandlePropertiesKHR,
    InterceptIdPreCallValidateGetMemoryFdKHR,
    InterceptIdPreCallRecordGetMemoryFdKHR,
    InterceptIdPostCallRecordGetMemoryFdKHR,
    InterceptIdPreCallValidateGetMemoryFdPropertiesKHR,
    InterceptIdPreCallRecordGetMemoryFdPropertiesKHR,
    InterceptIdPostCallRecordGetMemoryFdPropertiesKHR,
    InterceptIdPreCallValidateImportSemaphoreWin32HandleKHR,
    InterceptIdPreCallRecordImportSemaphoreWin32HandleKHR,
    InterceptIdPostCallRecordImportSemaphoreWin32HandleKHR,
    InterceptIdPreCallValidateGetSemaphoreWin32HandleKHR,
    InterceptIdPreCallRecordGetSemaphoreWin32HandleKHR,
    InterceptIdPostCallRecordGetSemaphoreWin32HandleKHR,
    InterceptIdPreCallValidateImportSemaphoreFdKHR,
    InterceptIdPreCallRecordImportSemaphoreFdKHR,
    InterceptIdPostCallRecordImportSemaphoreFdKHR,
    InterceptIdPreCallValidateGetSemaphoreFdKHR,
    InterceptIdPreCallRecordGetSemaphoreFdKHR,
    InterceptIdPostCallRecordGetSemaphoreFdKHR,
    InterceptIdPreCallValidateCmdPushDescriptorSetKHR,
    InterceptIdPreCallRecordCmdPushDescriptorSetKHR,
    InterceptIdPostCallRecordCmdPushDescriptorSetKHR,
    InterceptIdPreCallValidateCmdPushDescriptorSetWithTemplateKHR,
    InterceptIdPreCallRecordCmdPushDescriptorSetWithTemplateKHR,
    InterceptIdPostCallRecordCmdPushDescriptorSetWithTemplateKHR,
    InterceptIdPreCallValidateCreateDescriptorUpdateTemplateKHR,
    InterceptIdPreCallRecordCreateDescriptorUpdateTemplateKHR,
    InterceptIdPostCallRecordCreateDescriptorUpdateTemplateKHR,
    InterceptIdPreCallValidateDestroyDescriptorUpdateTemplateKHR,
    InterceptIdPreCallRecordDestroyDescriptorUpdateTemplateKHR,
    InterceptIdPostCallRecordDestroyDescriptorUpdateTemplateKHR,
    InterceptIdPreCallValidateUpdateDescriptorSetWithTemplateKHR,
    InterceptIdPreCallRecordUpdateDescriptorSetWithTemplateKHR,
    InterceptIdPostCallRecordUpdateDescriptorSetWithTemplateKHR,
    InterceptIdPreCallValidateCreateRenderPass2KHR,
    InterceptIdPreCallRecordCreateRenderPass2KHR,
    InterceptIdPostCallRecordCreateRenderPass2KHR,
    InterceptIdPreCallValidateCmdBeginRenderPass2KHR,
    InterceptIdPreCallRecordCmdBeginRenderPass2KHR,
    InterceptIdPostCallRecordCmdBeginRenderPass2KHR,
    InterceptIdPreCallValidateCmdNextSubpass2KHR,
    InterceptIdPreCallRecordCmdNextSubpass2KHR,
    InterceptIdPostCallRecordCmdNextSubpass2KHR,
    InterceptIdPreCallValidateCmdEndRenderPass2KHR,
    InterceptIdPreCallRecordCmdEndRenderPass2KHR,
    InterceptIdPostCallRecordCmdEndRenderPass2KHR,
    InterceptIdPreCallValidateGetSwapchainStatusKHR,
    InterceptIdPreCallRecordGetSwapchainStatusKHR,
    InterceptIdPostCallRecordGetSwapchainStatusKHR,
    InterceptIdPreCallValidateImportFenceWin32HandleKHR,
    InterceptIdPreCallRecordImportFenceWin32HandleKHR,
    InterceptIdPostCallRecordImportFenceWin32HandleKHR,
    InterceptIdPreCallValidateGetFenceWin32HandleKHR,
    InterceptIdPreCallRecordGetFenceWin32HandleKHR,
    InterceptIdPostCallRecordGetFenceWin32HandleKHR,
    InterceptIdPreCallValidateImportFenceFdKHR,
    InterceptIdPreCallRecordImportFenceFdKHR,
    InterceptIdPostCallRecordImportFenceFdKHR,
    InterceptIdPreCallValidateGetFenceFdKHR,
    InterceptIdPreCallRecordGetFenceFdKHR,
    InterceptIdPostCallRecordGetFenceFdKHR,
    InterceptIdPreCallValidateAcquireProfilingLockKHR,
    InterceptIdPreCallRecordAcquireProfilingLockKHR,
    InterceptIdPostCallRecordAcquireProfilingLockKHR,
    InterceptIdPreCallValidateReleaseProfilingLockKHR,
    InterceptIdPreCallRecordReleaseProfilingLockKHR,
    InterceptIdPostCallRecordReleaseProfilingLockKHR,
    InterceptIdPreCallValidateGetImageMemoryRequirements2KHR,
    InterceptIdPreCallRecordGetImageMemoryRequirements2KHR,
    InterceptIdPostCallRecordGetImageMemoryRequirements2KHR,
    InterceptIdPreCallValidateGetBufferMemoryRequirements2KHR,
    InterceptIdPreCallRecordGetBufferMemoryRequirements2KHR,
    InterceptIdPostCallRecordGetBufferMemoryRequirements2KHR,
    InterceptIdPreCallValidateGetImageSparseMemoryRequirements2KHR,
    InterceptIdPreCallRecordGetImageSparseMemoryRequirements2KHR,
    InterceptIdPostCallRecordGetImageSparseMemoryRequirements2KHR,
    InterceptIdPreCallValidateCreateSamplerYcbcrConversionKHR,
    InterceptIdPreCallRecordCreateSamplerYcbcrConversionKHR,
    InterceptIdPostCallRecordCreateSamplerYcbcrConversionKHR,
    InterceptIdPreCallValidateDestroySamplerYcbcrConversionKHR,
    InterceptIdPreCallRecordDestroySamplerYcbcrConversionKHR,
    InterceptIdPostCallRecordDestroySamplerYcbcrConversionKHR,
    InterceptIdPreCallValidateBindBufferMemory2KHR,
    InterceptIdPreCallRecordBindBufferMemory2KHR,
    InterceptIdPostCallRecordBindBufferMemory2KHR,
    InterceptIdPreCallValidateBindImageMemory2KHR,
    InterceptIdPreCallRecordBindImageMemory2KHR,
    InterceptIdPostCallRecordBindImageMemory2KHR,
    InterceptIdPreCallValidateGetDescriptorSetLayoutSupportKHR,
    InterceptIdPreCallRecordGetDescriptorSetLayoutSupportKHR,
    InterceptIdPostCallRecordGetDescriptorSetLayoutSupportKHR,
    InterceptIdPreCallValidateCmdDrawIndirectCountKHR,
    InterceptIdPreCallRecordCmdDrawIndirectCountKHR,
    InterceptIdPostCallRecordCmdDrawIndirectCountKHR,
    InterceptIdPreCallValidateCmdDrawIndexedIndirectCountKHR,
    InterceptIdPreCallRecordCmdDrawIndexedIndirectCountKHR,
    InterceptIdPostCallRecordCmdDrawIndexedIndirectCountKHR,
    InterceptIdPreCallValidateGetSemaphoreCounterValueKHR,
    InterceptIdPreCallRecordGetSemaphoreCounterValueKHR,
    InterceptIdPostCallRecordGetSemaphoreCounterValueKHR,
    InterceptIdPreCallValidateWaitSemaphoresKHR,
    InterceptIdPreCallRecordWaitSemaphoresKHR,
    InterceptIdPostCallRecordWaitSemaphoresKHR,
    InterceptIdPreCallValidateSignalSemaphoreKHR,
    InterceptIdPreCallRecordSignalSemaphoreKHR,
    InterceptIdPostCallRecordSignalSemaphoreKHR,
    InterceptIdPreCallValidateCmdSetFragmentShadingRateKHR,
    InterceptIdPreCallRecordCmdSetFragmentShadingRateKHR,
    InterceptIdPostCallRecordCmdSetFragmentShadingRateKHR,
    InterceptIdPreCallValidateCmdSetRenderingAttachmentLocationsKHR,
    InterceptIdPreCallRecordCmdSetRenderingAttachmentLocationsKHR,
    InterceptIdPostCallRecordCmdSetRenderingAttachmentLocationsKHR,
    InterceptIdPreCallValidateCmdSetRenderingInputAttachmentIndicesKHR,
    InterceptIdPreCallRecordCmdSetRenderingInputAttachmentIndicesKHR,
    InterceptIdPostCallRecordCmdSetRenderingInputAttachmentIndicesKHR,
    InterceptIdPreCallValidateWaitForPresentKHR,
    InterceptIdPreCallRecordWaitForPresentKHR,
    InterceptIdPostCallRecordWaitForPresentKHR,
    InterceptIdPreCallValidateGetBufferDeviceAddressKHR,
    InterceptIdPreCallRecordGetBufferDeviceAddressKHR,
    InterceptIdPostCallRecordGetBufferDeviceAddressKHR,
    InterceptIdPreCallValidateGetBufferOpaqueCaptureAddressKHR,
    InterceptIdPreCallRecordGetBufferOpaqueCaptureAddressKHR,
    InterceptIdPostCallRecordGetBufferOpaqueCaptureAddressKHR,
    InterceptIdPreCallValidateGetDeviceMemoryOpaqueCaptureAddressKHR,
    InterceptIdPreCallRecordGetDeviceMemoryOpaqueCaptureAddressKHR,
    InterceptIdPostCallRecordGetDeviceMemoryOpaqueCaptureAddressKHR,
    InterceptIdPreCallValidateCreateDeferredOperationKHR,
    InterceptIdPreCallRecordCreateDeferredOperationKHR,
    InterceptIdPostCallRecordCreateDeferredOperationKHR,
    InterceptIdPreCallValidateDestroyDeferredOperationKHR,
    InterceptIdPreCallRecordDestroyDeferredOperationKHR,
    InterceptIdPostCallRecordDestroyDeferredOperationKHR,
    InterceptIdPreCallValidateGetDeferredOperationMaxConcurrencyKHR,
    InterceptIdPreCallRecordGetDeferredOperationMaxConcurrencyKHR,
    InterceptIdPostCallRecordGetDeferredOperationMaxConcurrencyKHR,
    InterceptIdPreCallValidateGetDeferredOperationResultKHR,
    InterceptIdPreCallRecordGetDeferredOperationResultKHR,
    InterceptIdPostCallRecordGetDeferredOperationResultKHR,
    InterceptIdPreCallValidateDeferredOperationJoinKHR,
    InterceptIdPreCallRecordDeferredOperationJoinKHR,
    InterceptIdPostCallRecordDeferredOperationJoinKHR,
    InterceptIdPreCallValidateGetPipelineExecutablePropertiesKHR,
    InterceptIdPreCallRecordGetPipelineExecutablePropertiesKHR,
    InterceptIdPostCallRecordGetPipelineExecutablePropertiesKHR,
    InterceptIdPreCallValidateGetPipelineExecutableStatisticsKHR,
    InterceptIdPreCallRecordGetPipelineExecutableStatisticsKHR,
    InterceptIdPostCallRecordGetPipelineExecutableStatisticsKHR,
    InterceptIdPreCallValidateGetPipelineExecutableInternalRepresentationsKHR,
    InterceptIdPreCallRecordGetPipelineExecutableInternalRepresentationsKHR,
    InterceptIdPostCallRecordGetPipelineExecutableInternalRepresentationsKHR,
    InterceptIdPreCallValidateMapMemory2KHR,
    InterceptIdPreCallRecordMapMemory2KHR,
    InterceptIdPostCallRecordMapMemory2KHR,
    InterceptIdPreCallValidateUnmapMemory2KHR,
    InterceptIdPreCallRecordUnmapMemory2KHR,
    InterceptIdPostCallRecordUnmapMemory2KHR,
    InterceptIdPreCallValidateGetEncodedVideoSessionParametersKHR,
    InterceptIdPreCallRecordGetEncodedVideoSessionParametersKHR,
    InterceptIdPostCallRecordGetEncodedVideoSessionParametersKHR,
    InterceptIdPreCallValidateCmdEncodeVideoKHR,
    InterceptIdPreCallRecordCmdEncodeVideoKHR,
    InterceptIdPostCallRecordCmdEncodeVideoKHR,
    InterceptIdPreCallValidateCmdSetEvent2KHR,
    InterceptIdPreCallRecordCmdSetEvent2KHR,
    InterceptIdPostCallRecordCmdSetEvent2KHR,
    InterceptIdPreCallValidateCmdResetEvent2KHR,
    InterceptIdPreCallRecordCmdResetEvent2KHR,
    InterceptIdPostCallRecordCmdResetEvent2KHR,
    InterceptIdPreCallValidateCmdWaitEvents2KHR,
    InterceptIdPreCallRecordCmdWaitEvents2KHR,
    InterceptIdPostCallRecordCmdWaitEvents2KHR,
    InterceptIdPreCallValidateCmdPipelineBarrier2KHR,
    InterceptIdPreCallRecordCmdPipelineBarrier2KHR,
    InterceptIdPostCallRecordCmdPipelineBarrier2KHR,
    InterceptIdPreCallValidateCmdWriteTimestamp2KHR,
    InterceptIdPreCallRecordCmdWriteTimestamp2KHR,
    InterceptIdPostCallRecordCmdWriteTimestamp2KHR,
    InterceptIdPreCallValidateQueueSubmit2KHR,
    InterceptIdPreCallRecordQueueSubmit2KHR,
    InterceptIdPostCallRecordQueueSubmit2KHR,
    InterceptIdPreCallValidateCmdCopyBuffer2KHR,
    InterceptIdPreCallRecordCmdCopyBuffer2KHR,
    InterceptIdPostCallRecordCmdCopyBuffer2KHR,
    InterceptIdPreCallValidateCmdCopyImage2KHR,
    InterceptIdPreCallRecordCmdCopyImage2KHR,
    InterceptIdPostCallRecordCmdCopyImage2KHR,
    InterceptIdPreCallValidateCmdCopyBufferToImage2KHR,
    InterceptIdPreCallRecordCmdCopyBufferToImage2KHR,
    InterceptIdPostCallRecordCmdCopyBufferToImage2KHR,
    InterceptIdPreCallValidateCmdCopyImageToBuffer2KHR,
    InterceptIdPreCallRecordCmdCopyImageToBuffer2KHR,
    InterceptIdPostCallRecordCmdCopyImageToBuffer2KHR,
    InterceptIdPreCallValidateCmdBlitImage2KHR,
    InterceptIdPreCallRecordCmdBlitImage2KHR,
    InterceptIdPostCallRecordCmdBlitImage2KHR,
    InterceptIdPreCallValidateCmdResolveImage2KHR,
    InterceptIdPreCallRecordCmdResolveImage2KHR,
    InterceptIdPostCallRecordCmdResolveImage2KHR,
    InterceptIdPreCallValidateCmdTraceRaysIndirect2KHR,
    InterceptIdPreCallRecordCmdTraceRaysIndirect2KHR,
    InterceptIdPostCallRecordCmdTraceRaysIndirect2KHR,
    InterceptIdPreCallValidateGetDeviceBufferMemoryRequirementsKHR,
    InterceptIdPreCallRecordGetDeviceBufferMemoryRequirementsKHR,
    InterceptIdPostCallRecordGetDeviceBufferMemoryRequirementsKHR,
    InterceptIdPreCallValidateGetDeviceImageMemoryRequirementsKHR,
    InterceptIdPreCallRecordGetDeviceImageMemoryRequirementsKHR,
    InterceptIdPostCallRecordGetDeviceImageMemoryRequirementsKHR,
    InterceptIdPreCallValidateGetDeviceImageSparseMemoryRequirementsKHR,
    InterceptIdPreCallRecordGetDeviceImageSparseMemoryRequirementsKHR,
    InterceptIdPostCallRecordGetDeviceImageSparseMemoryRequirementsKHR,
    InterceptIdPreCallValidateCmdBindIndexBuffer2KHR,
    InterceptIdPreCallRecordCmdBindIndexBuffer2KHR,
    InterceptIdPostCallRecordCmdBindIndexBuffer2KHR,
    InterceptIdPreCallValidateGetRenderingAreaGranularityKHR,
    InterceptIdPreCallRecordGetRenderingAreaGranularityKHR,
    InterceptIdPostCallRecordGetRenderingAreaGranularityKHR,
    InterceptIdPreCallValidateGetDeviceImageSubresourceLayoutKHR,
    InterceptIdPreCallRecordGetDeviceImageSubresourceLayoutKHR,
    InterceptIdPostCallRecordGetDeviceImageSubresourceLayoutKHR,
    InterceptIdPreCallValidateGetImageSubresourceLayout2KHR,
    InterceptIdPreCallRecordGetImageSubresourceLayout2KHR,
    InterceptIdPostCallRecordGetImageSubresourceLayout2KHR,
    InterceptIdPreCallValidateCreatePipelineBinariesKHR,
    InterceptIdPreCallRecordCreatePipelineBinariesKHR,
    InterceptIdPostCallRecordCreatePipelineBinariesKHR,
    InterceptIdPreCallValidateDestroyPipelineBinaryKHR,
    InterceptIdPreCallRecordDestroyPipelineBinaryKHR,
    InterceptIdPostCallRecordDestroyPipelineBinaryKHR,
    InterceptIdPreCallValidateGetPipelineKeyKHR,
    InterceptIdPreCallRecordGetPipelineKeyKHR,
    InterceptIdPostCallRecordGetPipelineKeyKHR,
    InterceptIdPreCallValidateGetPipelineBinaryDataKHR,
    InterceptIdPreCallRecordGetPipelineBinaryDataKHR,
    InterceptIdPostCallRecordGetPipelineBinaryDataKHR,
    InterceptIdPreCallValidateReleaseCapturedPipelineDataKHR,
    InterceptIdPreCallRecordReleaseCapturedPipelineDataKHR,
    InterceptIdPostCallRecordReleaseCapturedPipelineDataKHR,
    InterceptIdPreCallValidateCmdSetLineStippleKHR,
    InterceptIdPreCallRecordCmdSetLineStippleKHR,
    InterceptIdPostCallRecordCmdSetLineStippleKHR,
    InterceptIdPreCallValidateGetCalibratedTimestampsKHR,
    InterceptIdPreCallRecordGetCalibratedTimestampsKHR,
    InterceptIdPostCallRecordGetCalibratedTimestampsKHR,
    InterceptIdPreCallValidateCmdBindDescriptorSets2KHR,
    InterceptIdPreCallRecordCmdBindDescriptorSets2KHR,
    InterceptIdPostCallRecordCmdBindDescriptorSets2KHR,
    InterceptIdPreCallValidateCmdPushConstants2KHR,
    InterceptIdPreCallRecordCmdPushConstants2KHR,
    InterceptIdPostCallRecordCmdPushConstants2KHR,
    InterceptIdPreCallValidateCmdPushDescriptorSet2KHR,
    InterceptIdPreCallRecordCmdPushDescriptorSet2KHR,
    InterceptIdPostCallRecordCmdPushDescriptorSet2KHR,
    InterceptIdPreCallValidateCmdPushDescriptorSetWithTemplate2KHR,
    InterceptIdPreCallRecordCmdPushDescriptorSetWithTemplate2KHR,
    InterceptIdPostCallRecordCmdPushDescriptorSetWithTemplate2KHR,
    InterceptIdPreCallValidateCmdSetDescriptorBufferOffsets2EXT,
    InterceptIdPreCallRecordCmdSetDescriptorBufferOffsets2EXT,
    InterceptIdPostCallRecordCmdSetDescriptorBufferOffsets2EXT,
    InterceptIdPreCallValidateCmdBindDescriptorBufferEmbeddedSamplers2EXT,
    InterceptIdPreCallRecordCmdBindDescriptorBufferEmbeddedSamplers2EXT,
    InterceptIdPostCallRecordCmdBindDescriptorBufferEmbeddedSamplers2EXT,
    InterceptIdPreCallValidateDebugMarkerSetObjectTagEXT,
    InterceptIdPreCallRecordDebugMarkerSetObjectTagEXT,
    InterceptIdPostCallRecordDebugMarkerSetObjectTagEXT,
    InterceptIdPreCallValidateDebugMarkerSetObjectNameEXT,
    InterceptIdPreCallRecordDebugMarkerSetObjectNameEXT,
    InterceptIdPostCallRecordDebugMarkerSetObjectNameEXT,
    InterceptIdPreCallValidateCmdDebugMarkerBeginEXT,
    InterceptIdPreCallRecordCmdDebugMarkerBeginEXT,
    InterceptIdPostCallRecordCmdDebugMarkerBeginEXT,
    InterceptIdPreCallValidateCmdDebugMarkerEndEXT,
    InterceptIdPreCallRecordCmdDebugMarkerEndEXT,
    InterceptIdPostCallRecordCmdDebugMarkerEndEXT,
    InterceptIdPreCallValidateCmdDebugMarkerInsertEXT,
    InterceptIdPreCallRecordCmdDebugMarkerInsertEXT,
    InterceptIdPostCallRecordCmdDebugMarkerInsertEXT,
    InterceptIdPreCallValidateCmdBindTransformFeedbackBuffersEXT,
    InterceptIdPreCallRecordCmdBindTransformFeedbackBuffersEXT,
    InterceptIdPostCallRecordCmdBindTransformFeedbackBuffersEXT,
    InterceptIdPreCallValidateCmdBeginTransformFeedbackEXT,
    InterceptIdPreCallRecordCmdBeginTransformFeedbackEXT,
    InterceptIdPostCallRecordCmdBeginTransformFeedbackEXT,
    InterceptIdPreCallValidateCmdEndTransformFeedbackEXT,
    InterceptIdPreCallRecordCmdEndTransformFeedbackEXT,
    InterceptIdPostCallRecordCmdEndTransformFeedbackEXT,
    InterceptIdPreCallValidateCmdBeginQueryIndexedEXT,
    InterceptIdPreCallRecordCmdBeginQueryIndexedEXT,
    InterceptIdPostCallRecordCmdBeginQueryIndexedEXT,
    InterceptIdPreCallValidateCmdEndQueryIndexedEXT,
    InterceptIdPreCallRecordCmdEndQueryIndexedEXT,
    InterceptIdPostCallRecordCmdEndQueryIndexedEXT,
    InterceptIdPreCallValidateCmdDrawIndirectByteCountEXT,
    InterceptIdPreCallRecordCmdDrawIndirectByteCountEXT,
    InterceptIdPostCallRecordCmdDrawIndirectByteCountEXT,
    InterceptIdPreCallValidateCreateCuModuleNVX,
    InterceptIdPreCallRecordCreateCuModuleNVX,
    InterceptIdPostCallRecordCreateCuModuleNVX,
    InterceptIdPreCallValidateCreateCuFunctionNVX,
    InterceptIdPreCallRecordCreateCuFunctionNVX,
    InterceptIdPostCallRecordCreateCuFunctionNVX,
    InterceptIdPreCallValidateDestroyCuModuleNVX,
    InterceptIdPreCallRecordDestroyCuModuleNVX,
    InterceptIdPostCallRecordDestroyCuModuleNVX,
    InterceptIdPreCallValidateDestroyCuFunctionNVX,
    InterceptIdPreCallRecordDestroyCuFunctionNVX,
    InterceptIdPostCallRecordDestroyCuFunctionNVX,
    InterceptIdPreCallValidateCmdCuLaunchKernelNVX,
    InterceptIdPreCallRecordCmdCuLaunchKernelNVX,
    InterceptIdPostCallRecordCmdCuLaunchKernelNVX,
    InterceptIdPreCallValidateGetImageViewHandleNVX,
    InterceptIdPreCallRecordGetImageViewHandleNVX,
    InterceptIdPostCallRecordGetImageViewHandleNVX,
    InterceptIdPreCallValidateGetImageViewHandle64NVX,
    InterceptIdPreCallRecordGetImageViewHandle64NVX,
    InterceptIdPostCallRecordGetImageViewHandle64NVX,
    InterceptIdPreCallValidateGetImageViewAddressNVX,
    InterceptIdPreCallRecordGetImageViewAddressNVX,
    InterceptIdPostCallRecordGetImageViewAddressNVX,
    InterceptIdPreCallValidateCmdDrawIndirectCountAMD,
    InterceptIdPreCallRecordCmdDrawIndirectCountAMD,
    InterceptIdPostCallRecordCmdDrawIndirectCountAMD,
    InterceptIdPreCallValidateCmdDrawIndexedIndirectCountAMD,
    InterceptIdPreCallRecordCmdDrawIndexedIndirectCountAMD,
    InterceptIdPostCallRecordCmdDrawIndexedIndirectCountAMD,
    InterceptIdPreCallValidateGetShaderInfoAMD,
    InterceptIdPreCallRecordGetShaderInfoAMD,
    InterceptIdPostCallRecordGetShaderInfoAMD,
    InterceptIdPreCallValidateGetMemoryWin32HandleNV,
    InterceptIdPreCallRecordGetMemoryWin32HandleNV,
    InterceptIdPostCallRecordGetMemoryWin32HandleNV,
    InterceptIdPreCallValidateCmdBeginConditionalRenderingEXT,
    InterceptIdPreCallRecordCmdBeginConditionalRenderingEXT,
    InterceptIdPostCallRecordCmdBeginConditionalRenderingEXT,
    InterceptIdPreCallValidateCmdEndConditionalRenderingEXT,
    InterceptIdPreCallRecordCmdEndConditionalRenderingEXT,
    InterceptIdPostCallRecordCmdEndConditionalRenderingEXT,
    InterceptIdPreCallValidateCmdSetViewportWScalingNV,
    InterceptIdPreCallRecordCmdSetViewportWScalingNV,
    InterceptIdPostCallRecordCmdSetViewportWScalingNV,
    InterceptIdPreCallValidateDisplayPowerControlEXT,
    InterceptIdPreCallRecordDisplayPowerControlEXT,
    InterceptIdPostCallRecordDisplayPowerControlEXT,
    InterceptIdPreCallValidateRegisterDeviceEventEXT,
    InterceptIdPreCallRecordRegisterDeviceEventEXT,
    InterceptIdPostCallRecordRegisterDeviceEventEXT,
    InterceptIdPreCallValidateRegisterDisplayEventEXT,
    InterceptIdPreCallRecordRegisterDisplayEventEXT,
    InterceptIdPostCallRecordRegisterDisplayEventEXT,
    InterceptIdPreCallValidateGetSwapchainCounterEXT,
    InterceptIdPreCallRecordGetSwapchainCounterEXT,
    InterceptIdPostCallRecordGetSwapchainCounterEXT,
    InterceptIdPreCallValidateGetRefreshCycleDurationGOOGLE,
    InterceptIdPreCallRecordGetRefreshCycleDurationGOOGLE,
    InterceptIdPostCallRecordGetRefreshCycleDurationGOOGLE,
    InterceptIdPreCallValidateGetPastPresentationTimingGOOGLE,
    InterceptIdPreCallRecordGetPastPresentationTimingGOOGLE,
    InterceptIdPostCallRecordGetPastPresentationTimingGOOGLE,
    InterceptIdPreCallValidateCmdSetDiscardRectangleEXT,
    InterceptIdPreCallRecordCmdSetDiscardRectangleEXT,
    InterceptIdPostCallRecordCmdSetDiscardRectangleEXT,
    InterceptIdPreCallValidateCmdSetDiscardRectangleEnableEXT,
    InterceptIdPreCallRecordCmdSetDiscardRectangleEnableEXT,
    InterceptIdPostCallRecordCmdSetDiscardRectangleEnableEXT,
    InterceptIdPreCallValidateCmdSetDiscardRectangleModeEXT,
    InterceptIdPreCallRecordCmdSetDiscardRectangleModeEXT,
    InterceptIdPostCallRecordCmdSetDiscardRectangleModeEXT,
    InterceptIdPreCallValidateSetHdrMetadataEXT,
    InterceptIdPreCallRecordSetHdrMetadataEXT,
    InterceptIdPostCallRecordSetHdrMetadataEXT,
    InterceptIdPreCallValidateSetDebugUtilsObjectNameEXT,
    InterceptIdPreCallRecordSetDebugUtilsObjectNameEXT,
    InterceptIdPostCallRecordSetDebugUtilsObjectNameEXT,
    InterceptIdPreCallValidateSetDebugUtilsObjectTagEXT,
    InterceptIdPreCallRecordSetDebugUtilsObjectTagEXT,
    InterceptIdPostCallRecordSetDebugUtilsObjectTagEXT,
    InterceptIdPreCallValidateQueueBeginDebugUtilsLabelEXT,
    InterceptIdPreCallRecordQueueBeginDebugUtilsLabelEXT,
    InterceptIdPostCallRecordQueueBeginDebugUtilsLabelEXT,
    InterceptIdPreCallValidateQueueEndDebugUtilsLabelEXT,
    InterceptIdPreCallRecordQueueEndDebugUtilsLabelEXT,
    InterceptIdPostCallRecordQueueEndDebugUtilsLabelEXT,
    InterceptIdPreCallValidateQueueInsertDebugUtilsLabelEXT,
    InterceptIdPreCallRecordQueueInsertDebugUtilsLabelEXT,
    InterceptIdPostCallRecordQueueInsertDebugUtilsLabelEXT,
    InterceptIdPreCallValidateCmdBeginDebugUtilsLabelEXT,
    InterceptIdPreCallRecordCmdBeginDebugUtilsLabelEXT,
    InterceptIdPostCallRecordCmdBeginDebugUtilsLabelEXT,
    InterceptIdPreCallValidateCmdEndDebugUtilsLabelEXT,
    InterceptIdPreCallRecordCmdEndDebugUtilsLabelEXT,
    InterceptIdPostCallRecordCmdEndDebugUtilsLabelEXT,
    InterceptIdPreCallValidateCmdInsertDebugUtilsLabelEXT,
    InterceptIdPreCallRecordCmdInsertDebugUtilsLabelEXT,
    InterceptIdPostCallRecordCmdInsertDebugUtilsLabelEXT,
    InterceptIdPreCallValidateGetAndroidHardwareBufferPropertiesANDROID,
    InterceptIdPreCallRecordGetAndroidHardwareBufferPropertiesANDROID,
    InterceptIdPostCallRecordGetAndroidHardwareBufferPropertiesANDROID,
    InterceptIdPreCallValidateGetMemoryAndroidHardwareBufferANDROID,
    InterceptIdPreCallRecordGetMemoryAndroidHardwareBufferANDROID,
    InterceptIdPostCallRecordGetMemoryAndroidHardwareBufferANDROID,
    InterceptIdPreCallValidateCreateExecutionGraphPipelinesAMDX,
    InterceptIdPreCallRecordCreateExecutionGraphPipelinesAMDX,
    InterceptIdPostCallRecordCreateExecutionGraphPipelinesAMDX,
    InterceptIdPreCallValidateGetExecutionGraphPipelineScratchSizeAMDX,
    InterceptIdPreCallRecordGetExecutionGraphPipelineScratchSizeAMDX,
    InterceptIdPostCallRecordGetExecutionGraphPipelineScratchSizeAMDX,
    InterceptIdPreCallValidateGetExecutionGraphPipelineNodeIndexAMDX,
    InterceptIdPreCallRecordGetExecutionGraphPipelineNodeIndexAMDX,
    InterceptIdPostCallRecordGetExecutionGraphPipelineNodeIndexAMDX,
    InterceptIdPreCallValidateCmdInitializeGraphScratchMemoryAMDX,
    InterceptIdPreCallRecordCmdInitializeGraphScratchMemoryAMDX,
    InterceptIdPostCallRecordCmdInitializeGraphScratchMemoryAMDX,
    InterceptIdPreCallValidateCmdDispatchGraphAMDX,
    InterceptIdPreCallRecordCmdDispatchGraphAMDX,
    InterceptIdPostCallRecordCmdDispatchGraphAMDX,
    InterceptIdPreCallValidateCmdDispatchGraphIndirectAMDX,
    InterceptIdPreCallRecordCmdDispatchGraphIndirectAMDX,
    InterceptIdPostCallRecordCmdDispatchGraphIndirectAMDX,
    InterceptIdPreCallValidateCmdDispatchGraphIndirectCountAMDX,
    InterceptIdPreCallRecordCmdDispatchGraphIndirectCountAMDX,
    InterceptIdPostCallRecordCmdDispatchGraphIndirectCountAMDX,
    InterceptIdPreCallValidateCmdSetSampleLocationsEXT,
    InterceptIdPreCallRecordCmdSetSampleLocationsEXT,
    InterceptIdPostCallRecordCmdSetSampleLocationsEXT,
    InterceptIdPreCallValidateGetImageDrmFormatModifierPropertiesEXT,
    InterceptIdPreCallRecordGetImageDrmFormatModifierPropertiesEXT,
    InterceptIdPostCallRecordGetImageDrmFormatModifierPropertiesEXT,
    InterceptIdPreCallValidateCmdBindShadingRateImageNV,
    InterceptIdPreCallRecordCmdBindShadingRateImageNV,
    InterceptIdPostCallRecordCmdBindShadingRateImageNV,
    InterceptIdPreCallValidateCmdSetViewportShadingRatePaletteNV,
    InterceptIdPreCallRecordCmdSetViewportShadingRatePaletteNV,
    InterceptIdPostCallRecordCmdSetViewportShadingRatePaletteNV,
    InterceptIdPreCallValidateCmdSetCoarseSampleOrderNV,
    InterceptIdPreCallRecordCmdSetCoarseSampleOrderNV,
    InterceptIdPostCallRecordCmdSetCoarseSampleOrderNV,
    InterceptIdPreCallValidateCreateAccelerationStructureNV,
    InterceptIdPreCallRecordCreateAccelerationStructureNV,
    InterceptIdPostCallRecordCreateAccelerationStructureNV,
    InterceptIdPreCallValidateDestroyAccelerationStructureNV,
    InterceptIdPreCallRecordDestroyAccelerationStructureNV,
    InterceptIdPostCallRecordDestroyAccelerationStructureNV,
    InterceptIdPreCallValidateGetAccelerationStructureMemoryRequirementsNV,
    InterceptIdPreCallRecordGetAccelerationStructureMemoryRequirementsNV,
    InterceptIdPostCallRecordGetAccelerationStructureMemoryRequirementsNV,
    InterceptIdPreCallValidateBindAccelerationStructureMemoryNV,
    InterceptIdPreCallRecordBindAccelerationStructureMemoryNV,
    InterceptIdPostCallRecordBindAccelerationStructureMemoryNV,
    InterceptIdPreCallValidateCmdBuildAccelerationStructureNV,
    InterceptIdPreCallRecordCmdBuildAccelerationStructureNV,
    InterceptIdPostCallRecordCmdBuildAccelerationStructureNV,
    InterceptIdPreCallValidateCmdCopyAccelerationStructureNV,
    InterceptIdPreCallRecordCmdCopyAccelerationStructureNV,
    InterceptIdPostCallRecordCmdCopyAccelerationStructureNV,
    InterceptIdPreCallValidateCmdTraceRaysNV,
    InterceptIdPreCallRecordCmdTraceRaysNV,
    InterceptIdPostCallRecordCmdTraceRaysNV,
    InterceptIdPreCallValidateGetRayTracingShaderGroupHandlesKHR,
    InterceptIdPreCallRecordGetRayTracingShaderGroupHandlesKHR,
    InterceptIdPostCallRecordGetRayTracingShaderGroupHandlesKHR,
    InterceptIdPreCallValidateGetRayTracingShaderGroupHandlesNV,
    InterceptIdPreCallRecordGetRayTracingShaderGroupHandlesNV,
    InterceptIdPostCallRecordGetRayTracingShaderGroupHandlesNV,
    InterceptIdPreCallValidateGetAccelerationStructureHandleNV,
    InterceptIdPreCallRecordGetAccelerationStructureHandleNV,
    InterceptIdPostCallRecordGetAccelerationStructureHandleNV,
    InterceptIdPreCallValidateCmdWriteAccelerationStructuresPropertiesNV,
    InterceptIdPreCallRecordCmdWriteAccelerationStructuresPropertiesNV,
    InterceptIdPostCallRecordCmdWriteAccelerationStructuresPropertiesNV,
    InterceptIdPreCallValidateCompileDeferredNV,
    InterceptIdPreCallRecordCompileDeferredNV,
    InterceptIdPostCallRecordCompileDeferredNV,
    InterceptIdPreCallValidateGetMemoryHostPointerPropertiesEXT,
    InterceptIdPreCallRecordGetMemoryHostPointerPropertiesEXT,
    InterceptIdPostCallRecordGetMemoryHostPointerPropertiesEXT,
    InterceptIdPreCallValidateCmdWriteBufferMarkerAMD,
    InterceptIdPreCallRecordCmdWriteBufferMarkerAMD,
    InterceptIdPostCallRecordCmdWriteBufferMarkerAMD,
    InterceptIdPreCallValidateCmdWriteBufferMarker2AMD,
    InterceptIdPreCallRecordCmdWriteBufferMarker2AMD,
    InterceptIdPostCallRecordCmdWriteBufferMarker2AMD,
    InterceptIdPreCallValidateGetCalibratedTimestampsEXT,
    InterceptIdPreCallRecordGetCalibratedTimestampsEXT,
    InterceptIdPostCallRecordGetCalibratedTimestampsEXT,
    InterceptIdPreCallValidateCmdDrawMeshTasksNV,
    InterceptIdPreCallRecordCmdDrawMeshTasksNV,
    InterceptIdPostCallRecordCmdDrawMeshTasksNV,
    InterceptIdPreCallValidateCmdDrawMeshTasksIndirectNV,
    InterceptIdPreCallRecordCmdDrawMeshTasksIndirectNV,
    InterceptIdPostCallRecordCmdDrawMeshTasksIndirectNV,
    InterceptIdPreCallValidateCmdDrawMeshTasksIndirectCountNV,
    InterceptIdPreCallRecordCmdDrawMeshTasksIndirectCountNV,
    InterceptIdPostCallRecordCmdDrawMeshTasksIndirectCountNV,
    InterceptIdPreCallValidateCmdSetExclusiveScissorEnableNV,
    InterceptIdPreCallRecordCmdSetExclusiveScissorEnableNV,
    InterceptIdPostCallRecordCmdSetExclusiveScissorEnableNV,
    InterceptIdPreCallValidateCmdSetExclusiveScissorNV,
    InterceptIdPreCallRecordCmdSetExclusiveScissorNV,
    InterceptIdPostCallRecordCmdSetExclusiveScissorNV,
    InterceptIdPreCallValidateCmdSetCheckpointNV,
    InterceptIdPreCallRecordCmdSetCheckpointNV,
    InterceptIdPostCallRecordCmdSetCheckpointNV,
    InterceptIdPreCallValidateGetQueueCheckpointDataNV,
    InterceptIdPreCallRecordGetQueueCheckpointDataNV,
    InterceptIdPostCallRecordGetQueueCheckpointDataNV,
    InterceptIdPreCallValidateGetQueueCheckpointData2NV,
    InterceptIdPreCallRecordGetQueueCheckpointData2NV,
    InterceptIdPostCallRecordGetQueueCheckpointData2NV,
    InterceptIdPreCallValidateInitializePerformanceApiINTEL,
    InterceptIdPreCallRecordInitializePerformanceApiINTEL,
    InterceptIdPostCallRecordInitializePerformanceApiINTEL,
    InterceptIdPreCallValidateUninitializePerformanceApiINTEL,
    InterceptIdPreCallRecordUninitializePerformanceApiINTEL,
    InterceptIdPostCallRecordUninitializePerformanceApiINTEL,
    InterceptIdPreCallValidateCmdSetPerformanceMarkerINTEL,
    InterceptIdPreCallRecordCmdSetPerformanceMarkerINTEL,
    InterceptIdPostCallRecordCmdSetPerformanceMarkerINTEL,
    InterceptIdPreCallValidateCmdSetPerformanceStreamMarkerINTEL,
    InterceptIdPreCallRecordCmdSetPerformanceStreamMarkerINTEL,
    InterceptIdPostCallRecordCmdSetPerformanceStreamMarkerINTEL,
    InterceptIdPreCallValidateCmdSetPerformanceOverrideINTEL,
    InterceptIdPreCallRecordCmdSetPerformanceOverrideINTEL,
    InterceptIdPostCallRecordCmdSetPerformanceOverrideINTEL,
    InterceptIdPreCallValidateAcquirePerformanceConfigurationINTEL,
    InterceptIdPreCallRecordAcquirePerformanceConfigurationINTEL,
    InterceptIdPostCallRecordAcquirePerformanceConfigurationINTEL,
    InterceptIdPreCallValidateReleasePerformanceConfigurationINTEL,
    InterceptIdPreCallRecordReleasePerformanceConfigurationINTEL,
    InterceptIdPostCallRecordReleasePerformanceConfigurationINTEL,
    InterceptIdPreCallValidateQueueSetPerformanceConfigurationINTEL,
    InterceptIdPreCallRecordQueueSetPerformanceConfigurationINTEL,
    InterceptIdPostCallRecordQueueSetPerformanceConfigurationINTEL,
    InterceptIdPreCallValidateGetPerformanceParameterINTEL,
    InterceptIdPreCallRecordGetPerformanceParameterINTEL,
    InterceptIdPostCallRecordGetPerformanceParameterINTEL,
    InterceptIdPreCallValidateSetLocalDimmingAMD,
    InterceptIdPreCallRecordSetLocalDimmingAMD,
    InterceptIdPostCallRecordSetLocalDimmingAMD,
    InterceptIdPreCallValidateGetBufferDeviceAddressEXT,
    InterceptIdPreCallRecordGetBufferDeviceAddressEXT,
    InterceptIdPostCallRecordGetBufferDeviceAddressEXT,
    InterceptIdPreCallValidateAcquireFullScreenExclusiveModeEXT,
    InterceptIdPreCallRecordAcquireFullScreenExclusiveModeEXT,
    InterceptIdPostCallRecordAcquireFullScreenExclusiveModeEXT,
    InterceptIdPreCallValidateReleaseFullScreenExclusiveModeEXT,
    InterceptIdPreCallRecordReleaseFullScreenExclusiveModeEXT,
    InterceptIdPostCallRecordReleaseFullScreenExclusiveModeEXT,
    InterceptIdPreCallValidateGetDeviceGroupSurfacePresentModes2EXT,
    InterceptIdPreCallRecordGetDeviceGroupSurfacePresentModes2EXT,
    InterceptIdPostCallRecordGetDeviceGroupSurfacePresentModes2EXT,
    InterceptIdPreCallValidateCmdSetLineStippleEXT,
    InterceptIdPreCallRecordCmdSetLineStippleEXT,
    InterceptIdPostCallRecordCmdSetLineStippleEXT,
    InterceptIdPreCallValidateResetQueryPoolEXT,
    InterceptIdPreCallRecordResetQueryPoolEXT,
    InterceptIdPostCallRecordResetQueryPoolEXT,
    InterceptIdPreCallValidateCmdSetCullModeEXT,
    InterceptIdPreCallRecordCmdSetCullModeEXT,
    InterceptIdPostCallRecordCmdSetCullModeEXT,
    InterceptIdPreCallValidateCmdSetFrontFaceEXT,
    InterceptIdPreCallRecordCmdSetFrontFaceEXT,
    InterceptIdPostCallRecordCmdSetFrontFaceEXT,
    InterceptIdPreCallValidateCmdSetPrimitiveTopologyEXT,
    InterceptIdPreCallRecordCmdSetPrimitiveTopologyEXT,
    InterceptIdPostCallRecordCmdSetPrimitiveTopologyEXT,
    InterceptIdPreCallValidateCmdSetViewportWithCountEXT,
    InterceptIdPreCallRecordCmdSetViewportWithCountEXT,
    InterceptIdPostCallRecordCmdSetViewportWithCountEXT,
    InterceptIdPreCallValidateCmdSetScissorWithCountEXT,
    InterceptIdPreCallRecordCmdSetScissorWithCountEXT,
    InterceptIdPostCallRecordCmdSetScissorWithCountEXT,
    InterceptIdPreCallValidateCmdBindVertexBuffers2EXT,
    InterceptIdPreCallRecordCmdBindVertexBuffers2EXT,
    InterceptIdPostCallRecordCmdBindVertexBuffers2EXT,
    InterceptIdPreCallValidateCmdSetDepthTestEnableEXT,
    InterceptIdPreCallRecordCmdSetDepthTestEnableEXT,
    InterceptIdPostCallRecordCmdSetDepthTestEnableEXT,
    InterceptIdPreCallValidateCmdSetDepthWriteEnableEXT,
    InterceptIdPreCallRecordCmdSetDepthWriteEnableEXT,
    InterceptIdPostCallRecordCmdSetDepthWriteEnableEXT,
    InterceptIdPreCallValidateCmdSetDepthCompareOpEXT,
    InterceptIdPreCallRecordCmdSetDepthCompareOpEXT,
    InterceptIdPostCallRecordCmdSetDepthCompareOpEXT,
    InterceptIdPreCallValidateCmdSetDepthBoundsTestEnableEXT,
    InterceptIdPreCallRecordCmdSetDepthBoundsTestEnableEXT,
    InterceptIdPostCallRecordCmdSetDepthBoundsTestEnableEXT,
    InterceptIdPreCallValidateCmdSetStencilTestEnableEXT,
    InterceptIdPreCallRecordCmdSetStencilTestEnableEXT,
    InterceptIdPostCallRecordCmdSetStencilTestEnableEXT,
    InterceptIdPreCallValidateCmdSetStencilOpEXT,
    InterceptIdPreCallRecordCmdSetStencilOpEXT,
    InterceptIdPostCallRecordCmdSetStencilOpEXT,
    InterceptIdPreCallValidateCopyMemoryToImageEXT,
    InterceptIdPreCallRecordCopyMemoryToImageEXT,
    InterceptIdPostCallRecordCopyMemoryToImageEXT,
    InterceptIdPreCallValidateCopyImageToMemoryEXT,
    InterceptIdPreCallRecordCopyImageToMemoryEXT,
    InterceptIdPostCallRecordCopyImageToMemoryEXT,
    InterceptIdPreCallValidateCopyImageToImageEXT,
    InterceptIdPreCallRecordCopyImageToImageEXT,
    InterceptIdPostCallRecordCopyImageToImageEXT,
    InterceptIdPreCallValidateTransitionImageLayoutEXT,
    InterceptIdPreCallRecordTransitionImageLayoutEXT,
    InterceptIdPostCallRecordTransitionImageLayoutEXT,
    InterceptIdPreCallValidateGetImageSubresourceLayout2EXT,
    InterceptIdPreCallRecordGetImageSubresourceLayout2EXT,
    InterceptIdPostCallRecordGetImageSubresourceLayout2EXT,
    InterceptIdPreCallValidateReleaseSwapchainImagesEXT,
    InterceptIdPreCallRecordReleaseSwapchainImagesEXT,
    InterceptIdPostCallRecordReleaseSwapchainImagesEXT,
    InterceptIdPreCallValidateGetGeneratedCommandsMemoryRequirementsNV,
    InterceptIdPreCallRecordGetGeneratedCommandsMemoryRequirementsNV,
    InterceptIdPostCallRecordGetGeneratedCommandsMemoryRequirementsNV,
    InterceptIdPreCallValidateCmdPreprocessGeneratedCommandsNV,
    InterceptIdPreCallRecordCmdPreprocessGeneratedCommandsNV,
    InterceptIdPostCallRecordCmdPreprocessGeneratedCommandsNV,
    InterceptIdPreCallValidateCmdExecuteGeneratedCommandsNV,
    InterceptIdPreCallRecordCmdExecuteGeneratedCommandsNV,
    InterceptIdPostCallRecordCmdExecuteGeneratedCommandsNV,
    InterceptIdPreCallValidateCmdBindPipelineShaderGroupNV,
    InterceptIdPreCallRecordCmdBindPipelineShaderGroupNV,
    InterceptIdPostCallRecordCmdBindPipelineShaderGroupNV,
    InterceptIdPreCallValidateCreateIndirectCommandsLayoutNV,
    InterceptIdPreCallRecordCreateIndirectCommandsLayoutNV,
    InterceptIdPostCallRecordCreateIndirectCommandsLayoutNV,
    InterceptIdPreCallValidateDestroyIndirectCommandsLayoutNV,
    InterceptIdPreCallRecordDestroyIndirectCommandsLayoutNV,
    InterceptIdPostCallRecordDestroyIndirectCommandsLayoutNV,
    InterceptIdPreCallValidateCmdSetDepthBias2EXT,
    InterceptIdPreCallRecordCmdSetDepthBias2EXT,
    InterceptIdPostCallRecordCmdSetDepthBias2EXT,
    InterceptIdPreCallValidateCreatePrivateDataSlotEXT,
    InterceptIdPreCallRecordCreatePrivateDataSlotEXT,
    InterceptIdPostCallRecordCreatePrivateDataSlotEXT,
    InterceptIdPreCallValidateDestroyPrivateDataSlotEXT,
    InterceptIdPreCallRecordDestroyPrivateDataSlotEXT,
    InterceptIdPostCallRecordDestroyPrivateDataSlotEXT,
    InterceptIdPreCallValidateSetPrivateDataEXT,
    InterceptIdPreCallRecordSetPrivateDataEXT,
    InterceptIdPostCallRecordSetPrivateDataEXT,
    InterceptIdPreCallValidateGetPrivateDataEXT,
    InterceptIdPreCallRecordGetPrivateDataEXT,
    InterceptIdPostCallRecordGetPrivateDataEXT,
    InterceptIdPreCallValidateCreateCudaModuleNV,
    InterceptIdPreCallRecordCreateCudaModuleNV,
    InterceptIdPostCallRecordCreateCudaModuleNV,
    InterceptIdPreCallValidateGetCudaModuleCacheNV,
    InterceptIdPreCallRecordGetCudaModuleCacheNV,
    InterceptIdPostCallRecordGetCudaModuleCacheNV,
    InterceptIdPreCallValidateCreateCudaFunctionNV,
    InterceptIdPreCallRecordCreateCudaFunctionNV,
    InterceptIdPostCallRecordCreateCudaFunctionNV,
    InterceptIdPreCallValidateDestroyCudaModuleNV,
    InterceptIdPreCallRecordDestroyCudaModuleNV,
    InterceptIdPostCallRecordDestroyCudaModuleNV,
    InterceptIdPreCallValidateDestroyCudaFunctionNV,
    InterceptIdPreCallRecordDestroyCudaFunctionNV,
    InterceptIdPostCallRecordDestroyCudaFunctionNV,
    InterceptIdPreCallValidateCmdCudaLaunchKernelNV,
    InterceptIdPreCallRecordCmdCudaLaunchKernelNV,
    InterceptIdPostCallRecordCmdCudaLaunchKernelNV,
    InterceptIdPreCallValidateCmdDispatchTileQCOM,
    InterceptIdPreCallRecordCmdDispatchTileQCOM,
    InterceptIdPostCallRecordCmdDispatchTileQCOM,
    InterceptIdPreCallValidateCmdBeginPerTileExecutionQCOM,
    InterceptIdPreCallRecordCmdBeginPerTileExecutionQCOM,
    InterceptIdPostCallRecordCmdBeginPerTileExecutionQCOM,
    InterceptIdPreCallValidateCmdEndPerTileExecutionQCOM,
    InterceptIdPreCallRecordCmdEndPerTileExecutionQCOM,
    InterceptIdPostCallRecordCmdEndPerTileExecutionQCOM,
    InterceptIdPreCallValidateExportMetalObjectsEXT,
    InterceptIdPreCallRecordExportMetalObjectsEXT,
    InterceptIdPostCallRecordExportMetalObjectsEXT,
    InterceptIdPreCallValidateGetDescriptorSetLayoutSizeEXT,
    InterceptIdPreCallRecordGetDescriptorSetLayoutSizeEXT,
    InterceptIdPostCallRecordGetDescriptorSetLayoutSizeEXT,
    InterceptIdPreCallValidateGetDescriptorSetLayoutBindingOffsetEXT,
    InterceptIdPreCallRecordGetDescriptorSetLayoutBindingOffsetEXT,
    InterceptIdPostCallRecordGetDescriptorSetLayoutBindingOffsetEXT,
    InterceptIdPreCallValidateGetDescriptorEXT,
    InterceptIdPreCallRecordGetDescriptorEXT,
    InterceptIdPostCallRecordGetDescriptorEXT,
    InterceptIdPreCallValidateCmdBindDescriptorBuffersEXT,
    InterceptIdPreCallRecordCmdBindDescriptorBuffersEXT,
    InterceptIdPostCallRecordCmdBindDescriptorBuffersEXT,
    InterceptIdPreCallValidateCmdSetDescriptorBufferOffsetsEXT,
    InterceptIdPreCallRecordCmdSetDescriptorBufferOffsetsEXT,
    InterceptIdPostCallRecordCmdSetDescriptorBufferOffsetsEXT,
    InterceptIdPreCallValidateCmdBindDescriptorBufferEmbeddedSamplersEXT,
    InterceptIdPreCallRecordCmdBindDescriptorBufferEmbeddedSamplersEXT,
    InterceptIdPostCallRecordCmdBindDescriptorBufferEmbeddedSamplersEXT,
    InterceptIdPreCallValidateGetBufferOpaqueCaptureDescriptorDataEXT,
    InterceptIdPreCallRecordGetBufferOpaqueCaptureDescriptorDataEXT,
    InterceptIdPostCallRecordGetBufferOpaqueCaptureDescriptorDataEXT,
    InterceptIdPreCallValidateGetImageOpaqueCaptureDescriptorDataEXT,
    InterceptIdPreCallRecordGetImageOpaqueCaptureDescriptorDataEXT,
    InterceptIdPostCallRecordGetImageOpaqueCaptureDescriptorDataEXT,
    InterceptIdPreCallValidateGetImageViewOpaqueCaptureDescriptorDataEXT,
    InterceptIdPreCallRecordGetImageViewOpaqueCaptureDescriptorDataEXT,
    InterceptIdPostCallRecordGetImageViewOpaqueCaptureDescriptorDataEXT,
    InterceptIdPreCallValidateGetSamplerOpaqueCaptureDescriptorDataEXT,
    InterceptIdPreCallRecordGetSamplerOpaqueCaptureDescriptorDataEXT,
    InterceptIdPostCallRecordGetSamplerOpaqueCaptureDescriptorDataEXT,
    InterceptIdPreCallValidateGetAccelerationStructureOpaqueCaptureDescriptorDataEXT,
    InterceptIdPreCallRecordGetAccelerationStructureOpaqueCaptureDescriptorDataEXT,
    InterceptIdPostCallRecordGetAccelerationStructureOpaqueCaptureDescriptorDataEXT,
    InterceptIdPreCallValidateCmdSetFragmentShadingRateEnumNV,
    InterceptIdPreCallRecordCmdSetFragmentShadingRateEnumNV,
    InterceptIdPostCallRecordCmdSetFragmentShadingRateEnumNV,
    InterceptIdPreCallValidateGetDeviceFaultInfoEXT,
    InterceptIdPreCallRecordGetDeviceFaultInfoEXT,
    InterceptIdPostCallRecordGetDeviceFaultInfoEXT,
    InterceptIdPreCallValidateCmdSetVertexInputEXT,
    InterceptIdPreCallRecordCmdSetVertexInputEXT,
    InterceptIdPostCallRecordCmdSetVertexInputEXT,
    InterceptIdPreCallValidateGetMemoryZirconHandleFUCHSIA,
    InterceptIdPreCallRecordGetMemoryZirconHandleFUCHSIA,
    InterceptIdPostCallRecordGetMemoryZirconHandleFUCHSIA,
    InterceptIdPreCallValidateGetMemoryZirconHandlePropertiesFUCHSIA,
    InterceptIdPreCallRecordGetMemoryZirconHandlePropertiesFUCHSIA,
    InterceptIdPostCallRecordGetMemoryZirconHandlePropertiesFUCHSIA,
    InterceptIdPreCallValidateImportSemaphoreZirconHandleFUCHSIA,
    InterceptIdPreCallRecordImportSemaphoreZirconHandleFUCHSIA,
    InterceptIdPostCallRecordImportSemaphoreZirconHandleFUCHSIA,
    InterceptIdPreCallValidateGetSemaphoreZirconHandleFUCHSIA,
    InterceptIdPreCallRecordGetSemaphoreZirconHandleFUCHSIA,
    InterceptIdPostCallRecordGetSemaphoreZirconHandleFUCHSIA,
    InterceptIdPreCallValidateCreateBufferCollectionFUCHSIA,
    InterceptIdPreCallRecordCreateBufferCollectionFUCHSIA,
    InterceptIdPostCallRecordCreateBufferCollectionFUCHSIA,
    InterceptIdPreCallValidateSetBufferCollectionImageConstraintsFUCHSIA,
    InterceptIdPreCallRecordSetBufferCollectionImageConstraintsFUCHSIA,
    InterceptIdPostCallRecordSetBufferCollectionImageConstraintsFUCHSIA,
    InterceptIdPreCallValidateSetBufferCollectionBufferConstraintsFUCHSIA,
    InterceptIdPreCallRecordSetBufferCollectionBufferConstraintsFUCHSIA,
    InterceptIdPostCallRecordSetBufferCollectionBufferConstraintsFUCHSIA,
    InterceptIdPreCallValidateDestroyBufferCollectionFUCHSIA,
    InterceptIdPreCallRecordDestroyBufferCollectionFUCHSIA,
    InterceptIdPostCallRecordDestroyBufferCollectionFUCHSIA,
    InterceptIdPreCallValidateGetBufferCollectionPropertiesFUCHSIA,
    InterceptIdPreCallRecordGetBufferCollectionPropertiesFUCHSIA,
    InterceptIdPostCallRecordGetBufferCollectionPropertiesFUCHSIA,
    InterceptIdPreCallValidateGetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI,
    InterceptIdPreCallRecordGetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI,
    InterceptIdPostCallRecordGetDeviceSubpassShadingMaxWorkgroupSizeHUAWEI,
    InterceptIdPreCallValidateCmdSubpassShadingHUAWEI,
    InterceptIdPreCallRecordCmdSubpassShadingHUAWEI,
    InterceptIdPostCallRecordCmdSubpassShadingHUAWEI,
    InterceptIdPreCallValidateCmdBindInvocationMaskHUAWEI,
    InterceptIdPreCallRecordCmdBindInvocationMaskHUAWEI,
    InterceptIdPostCallRecordCmdBindInvocationMaskHUAWEI,
    InterceptIdPreCallValidateGetMemoryRemoteAddressNV,
    InterceptIdPreCallRecordGetMemoryRemoteAddressNV,
    InterceptIdPostCallRecordGetMemoryRemoteAddressNV,
    InterceptIdPreCallValidateGetPipelinePropertiesEXT,
    InterceptIdPreCallRecordGetPipelinePropertiesEXT,
    InterceptIdPostCallRecordGetPipelinePropertiesEXT,
    InterceptIdPreCallValidateCmdSetPatchControlPointsEXT,
    InterceptIdPreCallRecordCmdSetPatchControlPointsEXT,
    InterceptIdPostCallRecordCmdSetPatchControlPointsEXT,
    InterceptIdPreCallValidateCmdSetRasterizerDiscardEnableEXT,
    InterceptIdPreCallRecordCmdSetRasterizerDiscardEnableEXT,
    InterceptIdPostCallRecordCmdSetRasterizerDiscardEnableEXT,
    InterceptIdPreCallValidateCmdSetDepthBiasEnableEXT,
    InterceptIdPreCallRecordCmdSetDepthBiasEnableEXT,
    InterceptIdPostCallRecordCmdSetDepthBiasEnableEXT,
    InterceptIdPreCallValidateCmdSetLogicOpEXT,
    InterceptIdPreCallRecordCmdSetLogicOpEXT,
    InterceptIdPostCallRecordCmdSetLogicOpEXT,
    InterceptIdPreCallValidateCmdSetPrimitiveRestartEnableEXT,
    InterceptIdPreCallRecordCmdSetPrimitiveRestartEnableEXT,
    InterceptIdPostCallRecordCmdSetPrimitiveRestartEnableEXT,
    InterceptIdPreCallValidateCmdSetColorWriteEnableEXT,
    InterceptIdPreCallRecordCmdSetColorWriteEnableEXT,
    InterceptIdPostCallRecordCmdSetColorWriteEnableEXT,
    InterceptIdPreCallValidateCmdDrawMultiEXT,
    InterceptIdPreCallRecordCmdDrawMultiEXT,
    InterceptIdPostCallRecordCmdDrawMultiEXT,
    InterceptIdPreCallValidateCmdDrawMultiIndexedEXT,
    InterceptIdPreCallRecordCmdDrawMultiIndexedEXT,
    InterceptIdPostCallRecordCmdDrawMultiIndexedEXT,
    InterceptIdPreCallValidateCreateMicromapEXT,
    InterceptIdPreCallRecordCreateMicromapEXT,
    InterceptIdPostCallRecordCreateMicromapEXT,
    InterceptIdPreCallValidateDestroyMicromapEXT,
    InterceptIdPreCallRecordDestroyMicromapEXT,
    InterceptIdPostCallRecordDestroyMicromapEXT,
    InterceptIdPreCallValidateCmdBuildMicromapsEXT,
    InterceptIdPreCallRecordCmdBuildMicromapsEXT,
    InterceptIdPostCallRecordCmdBuildMicromapsEXT,
    InterceptIdPreCallValidateBuildMicromapsEXT,
    InterceptIdPreCallRecordBuildMicromapsEXT,
    InterceptIdPostCallRecordBuildMicromapsEXT,
    InterceptIdPreCallValidateCopyMicromapEXT,
    InterceptIdPreCallRecordCopyMicromapEXT,
    InterceptIdPostCallRecordCopyMicromapEXT,
    InterceptIdPreCallValidateCopyMicromapToMemoryEXT,
    InterceptIdPreCallRecordCopyMicromapToMemoryEXT,
    InterceptIdPostCallRecordCopyMicromapToMemoryEXT,
    InterceptIdPreCallValidateCopyMemoryToMicromapEXT,
    InterceptIdPreCallRecordCopyMemoryToMicromapEXT,
    InterceptIdPostCallRecordCopyMemoryToMicromapEXT,
    InterceptIdPreCallValidateWriteMicromapsPropertiesEXT,
    InterceptIdPreCallRecordWriteMicromapsPropertiesEXT,
    InterceptIdPostCallRecordWriteMicromapsPropertiesEXT,
    InterceptIdPreCallValidateCmdCopyMicromapEXT,
    InterceptIdPreCallRecordCmdCopyMicromapEXT,
    InterceptIdPostCallRecordCmdCopyMicromapEXT,
    InterceptIdPreCallValidateCmdCopyMicromapToMemoryEXT,
    InterceptIdPreCallRecordCmdCopyMicromapToMemoryEXT,
    InterceptIdPostCallRecordCmdCopyMicromapToMemoryEXT,
    InterceptIdPreCallValidateCmdCopyMemoryToMicromapEXT,
    InterceptIdPreCallRecordCmdCopyMemoryToMicromapEXT,
    InterceptIdPostCallRecordCmdCopyMemoryToMicromapEXT,
    InterceptIdPreCallValidateCmdWriteMicromapsPropertiesEXT,
    InterceptIdPreCallRecordCmdWriteMicromapsPropertiesEXT,
    InterceptIdPostCallRecordCmdWriteMicromapsPropertiesEXT,
    InterceptIdPreCallValidateGetDeviceMicromapCompatibilityEXT,
    InterceptIdPreCallRecordGetDeviceMicromapCompatibilityEXT,
    InterceptIdPostCallRecordGetDeviceMicromapCompatibilityEXT,
    InterceptIdPreCallValidateGetMicromapBuildSizesEXT,
    InterceptIdPreCallRecordGetMicromapBuildSizesEXT,
    InterceptIdPostCallRecordGetMicromapBuildSizesEXT,
    InterceptIdPreCallValidateCmdDrawClusterHUAWEI,
    InterceptIdPreCallRecordCmdDrawClusterHUAWEI,
    InterceptIdPostCallRecordCmdDrawClusterHUAWEI,
    InterceptIdPreCallValidateCmdDrawClusterIndirectHUAWEI,
    InterceptIdPreCallRecordCmdDrawClusterIndirectHUAWEI,
    InterceptIdPostCallRecordCmdDrawClusterIndirectHUAWEI,
    InterceptIdPreCallValidateSetDeviceMemoryPriorityEXT,
    InterceptIdPreCallRecordSetDeviceMemoryPriorityEXT,
    InterceptIdPostCallRecordSetDeviceMemoryPriorityEXT,
    InterceptIdPreCallValidateGetDescriptorSetLayoutHostMappingInfoVALVE,
    InterceptIdPreCallRecordGetDescriptorSetLayoutHostMappingInfoVALVE,
    InterceptIdPostCallRecordGetDescriptorSetLayoutHostMappingInfoVALVE,
    InterceptIdPreCallValidateGetDescriptorSetHostMappingVALVE,
    InterceptIdPreCallRecordGetDescriptorSetHostMappingVALVE,
    InterceptIdPostCallRecordGetDescriptorSetHostMappingVALVE,
    InterceptIdPreCallValidateCmdCopyMemoryIndirectNV,
    InterceptIdPreCallRecordCmdCopyMemoryIndirectNV,
    InterceptIdPostCallRecordCmdCopyMemoryIndirectNV,
    InterceptIdPreCallValidateCmdCopyMemoryToImageIndirectNV,
    InterceptIdPreCallRecordCmdCopyMemoryToImageIndirectNV,
    InterceptIdPostCallRecordCmdCopyMemoryToImageIndirectNV,
    InterceptIdPreCallValidateCmdDecompressMemoryNV,
    InterceptIdPreCallRecordCmdDecompressMemoryNV,
    InterceptIdPostCallRecordCmdDecompressMemoryNV,
    InterceptIdPreCallValidateCmdDecompressMemoryIndirectCountNV,
    InterceptIdPreCallRecordCmdDecompressMemoryIndirectCountNV,
    InterceptIdPostCallRecordCmdDecompressMemoryIndirectCountNV,
    InterceptIdPreCallValidateGetPipelineIndirectMemoryRequirementsNV,
    InterceptIdPreCallRecordGetPipelineIndirectMemoryRequirementsNV,
    InterceptIdPostCallRecordGetPipelineIndirectMemoryRequirementsNV,
    InterceptIdPreCallValidateCmdUpdatePipelineIndirectBufferNV,
    InterceptIdPreCallRecordCmdUpdatePipelineIndirectBufferNV,
    InterceptIdPostCallRecordCmdUpdatePipelineIndirectBufferNV,
    InterceptIdPreCallValidateGetPipelineIndirectDeviceAddressNV,
    InterceptIdPreCallRecordGetPipelineIndirectDeviceAddressNV,
    InterceptIdPostCallRecordGetPipelineIndirectDeviceAddressNV,
    InterceptIdPreCallValidateCmdSetDepthClampEnableEXT,
    InterceptIdPreCallRecordCmdSetDepthClampEnableEXT,
    InterceptIdPostCallRecordCmdSetDepthClampEnableEXT,
    InterceptIdPreCallValidateCmdSetPolygonModeEXT,
    InterceptIdPreCallRecordCmdSetPolygonModeEXT,
    InterceptIdPostCallRecordCmdSetPolygonModeEXT,
    InterceptIdPreCallValidateCmdSetRasterizationSamplesEXT,
    InterceptIdPreCallRecordCmdSetRasterizationSamplesEXT,
    InterceptIdPostCallRecordCmdSetRasterizationSamplesEXT,
    InterceptIdPreCallValidateCmdSetSampleMaskEXT,
    InterceptIdPreCallRecordCmdSetSampleMaskEXT,
    InterceptIdPostCallRecordCmdSetSampleMaskEXT,
    InterceptIdPreCallValidateCmdSetAlphaToCoverageEnableEXT,
    InterceptIdPreCallRecordCmdSetAlphaToCoverageEnableEXT,
    InterceptIdPostCallRecordCmdSetAlphaToCoverageEnableEXT,
    InterceptIdPreCallValidateCmdSetAlphaToOneEnableEXT,
    InterceptIdPreCallRecordCmdSetAlphaToOneEnableEXT,
    InterceptIdPostCallRecordCmdSetAlphaToOneEnableEXT,
    InterceptIdPreCallValidateCmdSetLogicOpEnableEXT,
    InterceptIdPreCallRecordCmdSetLogicOpEnableEXT,
    InterceptIdPostCallRecordCmdSetLogicOpEnableEXT,
    InterceptIdPreCallValidateCmdSetColorBlendEnableEXT,
    InterceptIdPreCallRecordCmdSetColorBlendEnableEXT,
    InterceptIdPostCallRecordCmdSetColorBlendEnableEXT,
    InterceptIdPreCallValidateCmdSetColorBlendEquationEXT,
    InterceptIdPreCallRecordCmdSetColorBlendEquationEXT,
    InterceptIdPostCallRecordCmdSetColorBlendEquationEXT,
    InterceptIdPreCallValidateCmdSetColorWriteMaskEXT,
    InterceptIdPreCallRecordCmdSetColorWriteMaskEXT,
    InterceptIdPostCallRecordCmdSetColorWriteMaskEXT,
    InterceptIdPreCallValidateCmdSetTessellationDomainOriginEXT,
    InterceptIdPreCallRecordCmdSetTessellationDomainOriginEXT,
    InterceptIdPostCallRecordCmdSetTessellationDomainOriginEXT,
    InterceptIdPreCallValidateCmdSetRasterizationStreamEXT,
    InterceptIdPreCallRecordCmdSetRasterizationStreamEXT,
    InterceptIdPostCallRecordCmdSetRasterizationStreamEXT,
    InterceptIdPreCallValidateCmdSetConservativeRasterizationModeEXT,
    InterceptIdPreCallRecordCmdSetConservativeRasterizationModeEXT,
    InterceptIdPostCallRecordCmdSetConservativeRasterizationModeEXT,
    InterceptIdPreCallValidateCmdSetExtraPrimitiveOverestimationSizeEXT,
    InterceptIdPreCallRecordCmdSetExtraPrimitiveOverestimationSizeEXT,
    InterceptIdPostCallRecordCmdSetExtraPrimitiveOverestimationSizeEXT,
    InterceptIdPreCallValidateCmdSetDepthClipEnableEXT,
    InterceptIdPreCallRecordCmdSetDepthClipEnableEXT,
    InterceptIdPostCallRecordCmdSetDepthClipEnableEXT,
    InterceptIdPreCallValidateCmdSetSampleLocationsEnableEXT,
    InterceptIdPreCallRecordCmdSetSampleLocationsEnableEXT,
    InterceptIdPostCallRecordCmdSetSampleLocationsEnableEXT,
    InterceptIdPreCallValidateCmdSetColorBlendAdvancedEXT,
    InterceptIdPreCallRecordCmdSetColorBlendAdvancedEXT,
    InterceptIdPostCallRecordCmdSetColorBlendAdvancedEXT,
    InterceptIdPreCallValidateCmdSetProvokingVertexModeEXT,
    InterceptIdPreCallRecordCmdSetProvokingVertexModeEXT,
    InterceptIdPostCallRecordCmdSetProvokingVertexModeEXT,
    InterceptIdPreCallValidateCmdSetLineRasterizationModeEXT,
    InterceptIdPreCallRecordCmdSetLineRasterizationModeEXT,
    InterceptIdPostCallRecordCmdSetLineRasterizationModeEXT,
    InterceptIdPreCallValidateCmdSetLineStippleEnableEXT,
    InterceptIdPreCallRecordCmdSetLineStippleEnableEXT,
    InterceptIdPostCallRecordCmdSetLineStippleEnableEXT,
    InterceptIdPreCallValidateCmdSetDepthClipNegativeOneToOneEXT,
    InterceptIdPreCallRecordCmdSetDepthClipNegativeOneToOneEXT,
    InterceptIdPostCallRecordCmdSetDepthClipNegativeOneToOneEXT,
    InterceptIdPreCallValidateCmdSetViewportWScalingEnableNV,
    InterceptIdPreCallRecordCmdSetViewportWScalingEnableNV,
    InterceptIdPostCallRecordCmdSetViewportWScalingEnableNV,
    InterceptIdPreCallValidateCmdSetViewportSwizzleNV,
    InterceptIdPreCallRecordCmdSetViewportSwizzleNV,
    InterceptIdPostCallRecordCmdSetViewportSwizzleNV,
    InterceptIdPreCallValidateCmdSetCoverageToColorEnableNV,
    InterceptIdPreCallRecordCmdSetCoverageToColorEnableNV,
    InterceptIdPostCallRecordCmdSetCoverageToColorEnableNV,
    InterceptIdPreCallValidateCmdSetCoverageToColorLocationNV,
    InterceptIdPreCallRecordCmdSetCoverageToColorLocationNV,
    InterceptIdPostCallRecordCmdSetCoverageToColorLocationNV,
    InterceptIdPreCallValidateCmdSetCoverageModulationModeNV,
    InterceptIdPreCallRecordCmdSetCoverageModulationModeNV,
    InterceptIdPostCallRecordCmdSetCoverageModulationModeNV,
    InterceptIdPreCallValidateCmdSetCoverageModulationTableEnableNV,
    InterceptIdPreCallRecordCmdSetCoverageModulationTableEnableNV,
    InterceptIdPostCallRecordCmdSetCoverageModulationTableEnableNV,
    InterceptIdPreCallValidateCmdSetCoverageModulationTableNV,
    InterceptIdPreCallRecordCmdSetCoverageModulationTableNV,
    InterceptIdPostCallRecordCmdSetCoverageModulationTableNV,
    InterceptIdPreCallValidateCmdSetShadingRateImageEnableNV,
    InterceptIdPreCallRecordCmdSetShadingRateImageEnableNV,
    InterceptIdPostCallRecordCmdSetShadingRateImageEnableNV,
    InterceptIdPreCallValidateCmdSetRepresentativeFragmentTestEnableNV,
    InterceptIdPreCallRecordCmdSetRepresentativeFragmentTestEnableNV,
    InterceptIdPostCallRecordCmdSetRepresentativeFragmentTestEnableNV,
    InterceptIdPreCallValidateCmdSetCoverageReductionModeNV,
    InterceptIdPreCallRecordCmdSetCoverageReductionModeNV,
    InterceptIdPostCallRecordCmdSetCoverageReductionModeNV,
    InterceptIdPreCallValidateGetShaderModuleIdentifierEXT,
    InterceptIdPreCallRecordGetShaderModuleIdentifierEXT,
    InterceptIdPostCallRecordGetShaderModuleIdentifierEXT,
    InterceptIdPreCallValidateGetShaderModuleCreateInfoIdentifierEXT,
    InterceptIdPreCallRecordGetShaderModuleCreateInfoIdentifierEXT,
    InterceptIdPostCallRecordGetShaderModuleCreateInfoIdentifierEXT,
    InterceptIdPreCallValidateCreateOpticalFlowSessionNV,
    InterceptIdPreCallRecordCreateOpticalFlowSessionNV,
    InterceptIdPostCallRecordCreateOpticalFlowSessionNV,
    InterceptIdPreCallValidateDestroyOpticalFlowSessionNV,
    InterceptIdPreCallRecordDestroyOpticalFlowSessionNV,
    InterceptIdPostCallRecordDestroyOpticalFlowSessionNV,
    InterceptIdPreCallValidateBindOpticalFlowSessionImageNV,
    InterceptIdPreCallRecordBindOpticalFlowSessionImageNV,
    InterceptIdPostCallRecordBindOpticalFlowSessionImageNV,
    InterceptIdPreCallValidateCmdOpticalFlowExecuteNV,
    InterceptIdPreCallRecordCmdOpticalFlowExecuteNV,
    InterceptIdPostCallRecordCmdOpticalFlowExecuteNV,
    InterceptIdPreCallValidateAntiLagUpdateAMD,
    InterceptIdPreCallRecordAntiLagUpdateAMD,
    InterceptIdPostCallRecordAntiLagUpdateAMD,
    InterceptIdPreCallValidateDestroyShaderEXT,
    InterceptIdPreCallRecordDestroyShaderEXT,
    InterceptIdPostCallRecordDestroyShaderEXT,
    InterceptIdPreCallValidateGetShaderBinaryDataEXT,
    InterceptIdPostCallRecordGetShaderBinaryDataEXT,
    InterceptIdPreCallValidateCmdBindShadersEXT,
    InterceptIdPreCallRecordCmdBindShadersEXT,
    InterceptIdPostCallRecordCmdBindShadersEXT,
    InterceptIdPreCallValidateCmdSetDepthClampRangeEXT,
    InterceptIdPreCallRecordCmdSetDepthClampRangeEXT,
    InterceptIdPostCallRecordCmdSetDepthClampRangeEXT,
    InterceptIdPreCallValidateGetFramebufferTilePropertiesQCOM,
    InterceptIdPreCallRecordGetFramebufferTilePropertiesQCOM,
    InterceptIdPostCallRecordGetFramebufferTilePropertiesQCOM,
    InterceptIdPreCallValidateGetDynamicRenderingTilePropertiesQCOM,
    InterceptIdPreCallRecordGetDynamicRenderingTilePropertiesQCOM,
    InterceptIdPostCallRecordGetDynamicRenderingTilePropertiesQCOM,
    InterceptIdPreCallValidateConvertCooperativeVectorMatrixNV,
    InterceptIdPreCallRecordConvertCooperativeVectorMatrixNV,
    InterceptIdPostCallRecordConvertCooperativeVectorMatrixNV,
    InterceptIdPreCallValidateCmdConvertCooperativeVectorMatrixNV,
    InterceptIdPreCallRecordCmdConvertCooperativeVectorMatrixNV,
    InterceptIdPostCallRecordCmdConvertCooperativeVectorMatrixNV,
    InterceptIdPreCallValidateSetLatencySleepModeNV,
    InterceptIdPreCallRecordSetLatencySleepModeNV,
    InterceptIdPostCallRecordSetLatencySleepModeNV,
    InterceptIdPreCallValidateLatencySleepNV,
    InterceptIdPreCallRecordLatencySleepNV,
    InterceptIdPostCallRecordLatencySleepNV,
    InterceptIdPreCallValidateSetLatencyMarkerNV,
    InterceptIdPreCallRecordSetLatencyMarkerNV,
    InterceptIdPostCallRecordSetLatencyMarkerNV,
    InterceptIdPreCallValidateGetLatencyTimingsNV,
    InterceptIdPreCallRecordGetLatencyTimingsNV,
    InterceptIdPostCallRecordGetLatencyTimingsNV,
    InterceptIdPreCallValidateQueueNotifyOutOfBandNV,
    InterceptIdPreCallRecordQueueNotifyOutOfBandNV,
    InterceptIdPostCallRecordQueueNotifyOutOfBandNV,
    InterceptIdPreCallValidateCmdSetAttachmentFeedbackLoopEnableEXT,
    InterceptIdPreCallRecordCmdSetAttachmentFeedbackLoopEnableEXT,
    InterceptIdPostCallRecordCmdSetAttachmentFeedbackLoopEnableEXT,
    InterceptIdPreCallValidateGetScreenBufferPropertiesQNX,
    InterceptIdPreCallRecordGetScreenBufferPropertiesQNX,
    InterceptIdPostCallRecordGetScreenBufferPropertiesQNX,
    InterceptIdPreCallValidateCmdBindTileMemoryQCOM,
    InterceptIdPreCallRecordCmdBindTileMemoryQCOM,
    InterceptIdPostCallRecordCmdBindTileMemoryQCOM,
    InterceptIdPreCallValidateCreateExternalComputeQueueNV,
    InterceptIdPreCallRecordCreateExternalComputeQueueNV,
    InterceptIdPostCallRecordCreateExternalComputeQueueNV,
    InterceptIdPreCallValidateDestroyExternalComputeQueueNV,
    InterceptIdPreCallRecordDestroyExternalComputeQueueNV,
    InterceptIdPostCallRecordDestroyExternalComputeQueueNV,
    InterceptIdPreCallValidateGetExternalComputeQueueDataNV,
    InterceptIdPreCallRecordGetExternalComputeQueueDataNV,
    InterceptIdPostCallRecordGetExternalComputeQueueDataNV,
    InterceptIdPreCallValidateGetClusterAccelerationStructureBuildSizesNV,
    InterceptIdPreCallRecordGetClusterAccelerationStructureBuildSizesNV,
    InterceptIdPostCallRecordGetClusterAccelerationStructureBuildSizesNV,
    InterceptIdPreCallValidateCmdBuildClusterAccelerationStructureIndirectNV,
    InterceptIdPreCallRecordCmdBuildClusterAccelerationStructureIndirectNV,
    InterceptIdPostCallRecordCmdBuildClusterAccelerationStructureIndirectNV,
    InterceptIdPreCallValidateGetPartitionedAccelerationStructuresBuildSizesNV,
    InterceptIdPreCallRecordGetPartitionedAccelerationStructuresBuildSizesNV,
    InterceptIdPostCallRecordGetPartitionedAccelerationStructuresBuildSizesNV,
    InterceptIdPreCallValidateCmdBuildPartitionedAccelerationStructuresNV,
    InterceptIdPreCallRecordCmdBuildPartitionedAccelerationStructuresNV,
    InterceptIdPostCallRecordCmdBuildPartitionedAccelerationStructuresNV,
    InterceptIdPreCallValidateGetGeneratedCommandsMemoryRequirementsEXT,
    InterceptIdPreCallRecordGetGeneratedCommandsMemoryRequirementsEXT,
    InterceptIdPostCallRecordGetGeneratedCommandsMemoryRequirementsEXT,
    InterceptIdPreCallValidateCmdPreprocessGeneratedCommandsEXT,
    InterceptIdPreCallRecordCmdPreprocessGeneratedCommandsEXT,
    InterceptIdPostCallRecordCmdPreprocessGeneratedCommandsEXT,
    InterceptIdPreCallValidateCmdExecuteGeneratedCommandsEXT,
    InterceptIdPreCallRecordCmdExecuteGeneratedCommandsEXT,
    InterceptIdPostCallRecordCmdExecuteGeneratedCommandsEXT,
    InterceptIdPreCallValidateCreateIndirectCommandsLayoutEXT,
    InterceptIdPreCallRecordCreateIndirectCommandsLayoutEXT,
    InterceptIdPostCallRecordCreateIndirectCommandsLayoutEXT,
    InterceptIdPreCallValidateDestroyIndirectCommandsLayoutEXT,
    InterceptIdPreCallRecordDestroyIndirectCommandsLayoutEXT,
    InterceptIdPostCallRecordDestroyIndirectCommandsLayoutEXT,
    InterceptIdPreCallValidateCreateIndirectExecutionSetEXT,
    InterceptIdPreCallRecordCreateIndirectExecutionSetEXT,
    InterceptIdPostCallRecordCreateIndirectExecutionSetEXT,
    InterceptIdPreCallValidateDestroyIndirectExecutionSetEXT,
    InterceptIdPreCallRecordDestroyIndirectExecutionSetEXT,
    InterceptIdPostCallRecordDestroyIndirectExecutionSetEXT,
    InterceptIdPreCallValidateUpdateIndirectExecutionSetPipelineEXT,
    InterceptIdPreCallRecordUpdateIndirectExecutionSetPipelineEXT,
    InterceptIdPostCallRecordUpdateIndirectExecutionSetPipelineEXT,
    InterceptIdPreCallValidateUpdateIndirectExecutionSetShaderEXT,
    InterceptIdPreCallRecordUpdateIndirectExecutionSetShaderEXT,
    InterceptIdPostCallRecordUpdateIndirectExecutionSetShaderEXT,
    InterceptIdPreCallValidateGetMemoryMetalHandleEXT,
    InterceptIdPreCallRecordGetMemoryMetalHandleEXT,
    InterceptIdPostCallRecordGetMemoryMetalHandleEXT,
    InterceptIdPreCallValidateGetMemoryMetalHandlePropertiesEXT,
    InterceptIdPreCallRecordGetMemoryMetalHandlePropertiesEXT,
    InterceptIdPostCallRecordGetMemoryMetalHandlePropertiesEXT,
    InterceptIdPreCallValidateCmdEndRendering2EXT,
    InterceptIdPreCallRecordCmdEndRendering2EXT,
    InterceptIdPostCallRecordCmdEndRendering2EXT,
    InterceptIdPreCallValidateCreateAccelerationStructureKHR,
    InterceptIdPreCallRecordCreateAccelerationStructureKHR,
    InterceptIdPostCallRecordCreateAccelerationStructureKHR,
    InterceptIdPreCallValidateDestroyAccelerationStructureKHR,
    InterceptIdPreCallRecordDestroyAccelerationStructureKHR,
    InterceptIdPostCallRecordDestroyAccelerationStructureKHR,
    InterceptIdPreCallValidateCmdBuildAccelerationStructuresKHR,
    InterceptIdPreCallRecordCmdBuildAccelerationStructuresKHR,
    InterceptIdPostCallRecordCmdBuildAccelerationStructuresKHR,
    InterceptIdPreCallValidateCmdBuildAccelerationStructuresIndirectKHR,
    InterceptIdPreCallRecordCmdBuildAccelerationStructuresIndirectKHR,
    InterceptIdPostCallRecordCmdBuildAccelerationStructuresIndirectKHR,
    InterceptIdPreCallValidateBuildAccelerationStructuresKHR,
    InterceptIdPreCallRecordBuildAccelerationStructuresKHR,
    InterceptIdPostCallRecordBuildAccelerationStructuresKHR,
    InterceptIdPreCallValidateCopyAccelerationStructureKHR,
    InterceptIdPreCallRecordCopyAccelerationStructureKHR,
    InterceptIdPostCallRecordCopyAccelerationStructureKHR,
    InterceptIdPreCallValidateCopyAccelerationStructureToMemoryKHR,
    InterceptIdPreCallRecordCopyAccelerationStructureToMemoryKHR,
    InterceptIdPostCallRecordCopyAccelerationStructureToMemoryKHR,
    InterceptIdPreCallValidateCopyMemoryToAccelerationStructureKHR,
    InterceptIdPreCallRecordCopyMemoryToAccelerationStructureKHR,
    InterceptIdPostCallRecordCopyMemoryToAccelerationStructureKHR,
    InterceptIdPreCallValidateWriteAccelerationStructuresPropertiesKHR,
    InterceptIdPreCallRecordWriteAccelerationStructuresPropertiesKHR,
    InterceptIdPostCallRecordWriteAccelerationStructuresPropertiesKHR,
    InterceptIdPreCallValidateCmdCopyAccelerationStructureKHR,
    InterceptIdPreCallRecordCmdCopyAccelerationStructureKHR,
    InterceptIdPostCallRecordCmdCopyAccelerationStructureKHR,
    InterceptIdPreCallValidateCmdCopyAccelerationStructureToMemoryKHR,
    InterceptIdPreCallRecordCmdCopyAccelerationStructureToMemoryKHR,
    InterceptIdPostCallRecordCmdCopyAccelerationStructureToMemoryKHR,
    InterceptIdPreCallValidateCmdCopyMemoryToAccelerationStructureKHR,
    InterceptIdPreCallRecordCmdCopyMemoryToAccelerationStructureKHR,
    InterceptIdPostCallRecordCmdCopyMemoryToAccelerationStructureKHR,
    InterceptIdPreCallValidateGetAccelerationStructureDeviceAddressKHR,
    InterceptIdPreCallRecordGetAccelerationStructureDeviceAddressKHR,
    InterceptIdPostCallRecordGetAccelerationStructureDeviceAddressKHR,
    InterceptIdPreCallValidateCmdWriteAccelerationStructuresPropertiesKHR,
    InterceptIdPreCallRecordCmdWriteAccelerationStructuresPropertiesKHR,
    InterceptIdPostCallRecordCmdWriteAccelerationStructuresPropertiesKHR,
    InterceptIdPreCallValidateGetDeviceAccelerationStructureCompatibilityKHR,
    InterceptIdPreCallRecordGetDeviceAccelerationStructureCompatibilityKHR,
    InterceptIdPostCallRecordGetDeviceAccelerationStructureCompatibilityKHR,
    InterceptIdPreCallValidateGetAccelerationStructureBuildSizesKHR,
    InterceptIdPreCallRecordGetAccelerationStructureBuildSizesKHR,
    InterceptIdPostCallRecordGetAccelerationStructureBuildSizesKHR,
    InterceptIdPreCallValidateCmdTraceRaysKHR,
    InterceptIdPreCallRecordCmdTraceRaysKHR,
    InterceptIdPostCallRecordCmdTraceRaysKHR,
    InterceptIdPreCallValidateGetRayTracingCaptureReplayShaderGroupHandlesKHR,
    InterceptIdPreCallRecordGetRayTracingCaptureReplayShaderGroupHandlesKHR,
    InterceptIdPostCallRecordGetRayTracingCaptureReplayShaderGroupHandlesKHR,
    InterceptIdPreCallValidateCmdTraceRaysIndirectKHR,
    InterceptIdPreCallRecordCmdTraceRaysIndirectKHR,
    InterceptIdPostCallRecordCmdTraceRaysIndirectKHR,
    InterceptIdPreCallValidateGetRayTracingShaderGroupStackSizeKHR,
    InterceptIdPreCallRecordGetRayTracingShaderGroupStackSizeKHR,
    InterceptIdPostCallRecordGetRayTracingShaderGroupStackSizeKHR,
    InterceptIdPreCallValidateCmdSetRayTracingPipelineStackSizeKHR,
    InterceptIdPreCallRecordCmdSetRayTracingPipelineStackSizeKHR,
    InterceptIdPostCallRecordCmdSetRayTracingPipelineStackSizeKHR,
    InterceptIdPreCallValidateCmdDrawMeshTasksEXT,
    InterceptIdPreCallRecordCmdDrawMeshTasksEXT,
    InterceptIdPostCallRecordCmdDrawMeshTasksEXT,
    InterceptIdPreCallValidateCmdDrawMeshTasksIndirectEXT,
    InterceptIdPreCallRecordCmdDrawMeshTasksIndirectEXT,
    InterceptIdPostCallRecordCmdDrawMeshTasksIndirectEXT,
    InterceptIdPreCallValidateCmdDrawMeshTasksIndirectCountEXT,
    InterceptIdPreCallRecordCmdDrawMeshTasksIndirectCountEXT,
    InterceptIdPostCallRecordCmdDrawMeshTasksIndirectCountEXT,
    InterceptIdCount,
} InterceptId;

// NOLINTEND
