#ifndef __WLAPI_H__
#define __WLAPI_H__

/* Uncomment the line, if you would like to debug API */
/* #define WLAPI_DEBUG */

/* Uncomment the line, if the driver runs unstablely on notebook */
#define WL_SLOWDOWN_IO

#  define  LINUX_DRIVER
#  include <linux/netdevice.h>          /* for enet_statistics */
#  include <linux/kernel.h>
#  include <linux/string.h>
#  include <asm/io.h>
#  ifdef WL_PCMCIA
#    include <pcmcia/version.h>
#    include <pcmcia/cs_types.h>
#    include <pcmcia/cs.h>
#    include <pcmcia/cistpl.h>
#    include <pcmcia/ds.h>
#  endif /* End of WL_PCMCIA */

#  define ETHER_MIN_LEN             64
#  define ETHER_MAX_LEN             1518
#  define SLOW_DOWN_IO              __SLOW_DOWN_IO

   /* inb(), and outb() are defined within include/asm/io.h */
#  ifdef  WL_SLOWDOWN_IO
#    define InB(port)                 inb(port)
#    define OutB(data, port)          { outb((data), (port)); SLOW_DOWN_IO; }
#    define OutB_P(data, port)        { outb_p((data), (port)); SLOW_DOWN_IO; }
#    define OutSB(port, addr, size)   { outsb((port), (addr), (size)); SLOW_DOWN_IO; }
#  else
#    define InB(port)                 inb(port)
#    define OutB(data, port)          outb((data), (port))
#    define OutB_P(data, port)        outb_p((data), (port))
#    define OutSB(port, addr, size)   outsb((port), (addr), (size))
#  endif

typedef unsigned long           DWORD;
typedef unsigned short          WORD;
typedef unsigned char           BYTE;
typedef int                     BOOL;

/*----------------------- WLAPI_DEBUG definition-----------------------*/
#define wl_debug(level, format, a...) {if (level < 4) printk(format, ##a);}
#ifdef  WLAPI_DEBUG
#  define WL_DBG_API            0x00000001L
#  define WL_DBG_INIT           0x00000002L
#  define WL_DBG_EXCEPT         0x00000004L
#  define WL_DBG_ROAM           0x00000008L
#  define WL_DBG_PNP            0x00000100L

#  define WL_STAT_API_FUNC      0x000000FFL
#  define WL_STAT_INIT          0x00000001L
#  define WL_STAT_TX_PKT        0x00000002L
#  define WL_STAT_RX_LOOK       0x00000004L
#  define WL_STAT_RX_RECV       0x00000008L
#  define WL_STAT_RX_DONE       0x00000010L

#  define WL_STAT_LOCK_FUNC     0x00000F00L
#  define WL_STAT_LOCK_SUTRO    0x00000100L
#  define WL_STAT_UNLOCK_SUTRO  0x00000200L

#  define WL_STAT_MIB_FUNC      0x0000F000L
#  define WL_STAT_GET_MIB       0x00001000L
#  define WL_STAT_SET_MIB       0x00002000L

#  define WL_STAT_TRIVIAL_FUNC  0x00FF0000L
#  define WL_STAT_BLK_INTR      0x00010000L
#  define WL_STAT_UNBLK_INTR    0x00020000L
#  define WL_STAT_INT_WLA       0x00040000L
#  define WL_STAT_SET_WLA       0x00080000L
#  define WL_STAT_GET_WLA       0x00100000L
#  define WL_STAT_FLASH_READ    0x00200000L
#  define WL_STAT_PNP_PROBE     0x00400000L
#  define WL_STAT_PNP_SET       0x00800000L

   extern DWORD WL_DbFlag;
#  define TRACE_API(format, args...)  \
            { if (WL_DbFlag & WL_DBG_API) printk(format , ## args); }
#  define TRACE_INIT(format, args...)  \
            { if (WL_DbFlag & WL_DBG_INIT) printk(format , ## args); }
#  define TRACE_EXCEPT(format, args...)  \
            { if (WL_DbFlag & WL_DBG_EXCEPT) printk(format , ## args); }
#  define TRACE_ROAM(format, args...)  \
            { if (WL_DbFlag & WL_DBG_ROAM) printk(format , ## args); }
#  define TRACE_PNP(format, args...)  \
            { if (WL_DbFlag & WL_DBG_PNP) printk(format , ## args); }
#  define TRACE(format, args...)    printk(format , ## args);
#  define ASSERT(x) \
            { if (!(x)) printk("FILE:%s LINE:%d, ASSERT FAILED\n", __FILE__, __LINE__); }
#  define WHEN_WLAPI_DEBUG(x) x
#  define ASSERT_STAT(x) \
            { (x) ? 0 : printk("FILE:%s LINE:%d, ASSERT FAILED! STAT=0x%lx\n", __FILE__, __LINE__, pAdaptor->ulDbgStat); }
#else
#  define TRACE_API(format, args...)
#  define TRACE_INIT(format, args...)
#  define TRACE_EXCEPT(format, args...)
#  define TRACE_ROAM(format, args...)
#  define TRACE_PNP(format, args...)
#  define TRACE(format, args...)
#  define ASSERT(x)
#  define WHEN_WLAPI_DEBUG(x)
#  define ASSERT_STAT(x)
#endif

/* For rough constant delay */
/* #define NOPLOOP(n)     { int x=0; while(x++<n) SLOW_DOWN_IO; } */
#define NOPLOOP(n)     { int x=0; while(x++<n); }

/**************************************************************************/
/* !!!!!!!        All structures must be tight alignmented        !!!!!!!!*/
/**************************************************************************/
#pragma pack (1)

/* Ethernet MAC Address, BSS_ID, or ESS_ID */
/* With this, we may simply write "x=y;" instead of "memcpy(x, y, 6);" */
/* It's more efficiency with compiler's optimization and more clearly  */
typedef struct _MADDR {
    BYTE    b0;
    BYTE    b1;
    BYTE    b2;
    BYTE    b3;
    BYTE    b4;
    BYTE    b5;
} MADDR;

/* Instead of calling memcmp(), use those macro to speed up! */
/* To port to platforms that care alignment, I do not do DWORD comparing */
#define MA_ISEQUAL(x, y)   ( (x).b0 == (y).b0 && \
                             (x).b1 == (y).b1 && \
                             (x).b2 == (y).b2 && \
                             (x).b3 == (y).b3 && \
                             (x).b4 == (y).b4 && \
                             (x).b5 == (y).b5 )

#define MA_ISZERO(x)       ( (x).b0 == 0 && \
                             (x).b1 == 0 && \
                             (x).b2 == 0 && \
                             (x).b3 == 0 && \
                             (x).b4 == 0 && \
                             (x).b5 == 0 )

#ifndef TRUE
#  define  FALSE  0
#  define  TRUE   (!FALSE)
#endif

/* */
/* Definitions for supporting clone adapters. */
/* */

/* Max TX_DESC reserved */
#define MAX_TX_DESC_RESERVED    20

/* Timeout for beacon (unit: ms.) */
#define BEACON_TIMEOUT          1000

/* */
/* Valid value ranges for the IoBaseAddress. */
/* */
#define MIN_IOBASEADDR 0x0100
#define MAX_IOBASEADDR 0xffc0

#define WL_IO_REGION            0x10

/* */
/* Default value for Adapter->IoBaseAddr */
/* */
#define DEFAULT_IOBASEADDR (PVOID)0x280

/* */
/* Default value for Adapter->InterruptNumber */
/* */
#define DEFAULT_INTERRUPTNUMBER 11


/* System Interface Registers (SIR space) */
#define NIC_GCR     ((BYTE)0x00)   /* SIR0 - General Configuration Register */
#define NIC_BSS     ((BYTE)0x01)   /* SIR1 - Bank Switching Select Register */
#define NIC_LMAL    ((BYTE)0x02)   /* SIR2 - Local Memory Address Register [7:0] */
#define NIC_LMAH    ((BYTE)0x03)   /* SIR3 - Local Memory Address Register [14:8] */
#define NIC_IODPA   ((BYTE)0x04)   /* SIR4 - I/O Data Port A */
#define NIC_IODPB   ((BYTE)0x05)   /* SIR5 - I/O Data Port B */
#define NIC_IODPC   ((BYTE)0x06)   /* SIR6 - I/O Data Port C */
#define NIC_IODPD   ((BYTE)0x07)   /* SIR7 - I/O Data Port D */


/* Bits in GCR */
#define GCR_SWRESET     ((BYTE)0x80)
#define GCR_CORESET     ((BYTE)0x40)
#define GCR_DISPWDN     ((BYTE)0x20)
#define GCR_ECWAIT      ((BYTE)0x10)
#define GCR_ECINT       ((BYTE)0x08)
#define GCR_INT2EC      ((BYTE)0x04)
#define GCR_ENECINT     ((BYTE)0x02)
#define GCR_DAM         ((BYTE)0x01)


/* Bits in BSS (Bank Switching Select Register) */
#define BSS_FPAGE0      ((BYTE)0x20)   /* Flash memory page0 */
#define BSS_FPAGE1      ((BYTE)0x28)
#define BSS_FPAGE2      ((BYTE)0x30)
#define BSS_FPAGE3      ((BYTE)0x38)
#define BSS_SPAGE0      ((BYTE)0x00)   /* SRAM page0 */
#define BSS_SPAGE1      ((BYTE)0x08)
#define BSS_SPAGE2      ((BYTE)0x10)
#define BSS_SPAGE3      ((BYTE)0x18)


/**************************************************************** */
/* Define Driver Interface */
/**************************************************************** */

/* */
/* Command Block (offset in SRAM) */
/* */
#define Command_Block               ((WORD) 0x4A0)
#define CB_Command                  (Command_Block + (WORD) 0x00)
#define CB_Command_Status           (Command_Block + (WORD) 0x01)
#define CB_Error_Offset             (Command_Block + (WORD) 0x02)
#define CB_Reserved                 (Command_Block + (WORD) 0x03)
#define CB_Command_Parameters       (Command_Block + (WORD) 0x04)

/* */
/* define command byte */
/* */
#define CMD_Test_Interface          ((BYTE) 0x01)
#define CMD_Set_MIB_Variables       ((BYTE) 0x02)
#define CMD_Init_Tx                 ((BYTE) 0x03)
#define CMD_Flush_Tx                ((BYTE) 0x04)
#define CMD_Enable_Receiver         ((BYTE) 0x05)
#define CMD_Disable_Receiver        ((BYTE) 0x06)
#define CMD_Reserved1               ((BYTE) 0x07)
#define CMD_Reserved2               ((BYTE) 0x08)
#define CMD_Get_MIB_Variables       ((BYTE) 0x09)
#define CMD_Scan                    ((BYTE) 0x0a)
#define CMD_Sync                    ((BYTE) 0x0b)

/* */
/* Control Status Block (offset in SRAM) */
/* */
#define Control_Status_Block        ((WORD) 0x4F0)
#define CSB_Self_Test_Status        (Control_Status_Block + (WORD) 00)
#define CSB_STA_State               (Control_Status_Block + (WORD) 01)
#define CSB_Rsvd_For_User_Rtn       (Control_Status_Block + (WORD) 02)
#define CSB_Interrupt_Status        (Control_Status_Block + (WORD) 03)
#define CSB_Interrupt_Mask          (Control_Status_Block + (WORD) 04)
#define CSB_Lockout_SUTRO           (Control_Status_Block + (WORD) 05)
#define CSB_Lockout_Host            (Control_Status_Block + (WORD) 06)
#define CSB_Interrupt_Status2       (Control_Status_Block + (WORD) 07)
#define CSB_Last_Completed_Tx_Desc  (Control_Status_Block + (WORD) 08)
#define CSB_Reserved                (Control_Status_Block + (WORD) 12)
#define CSB_Interrupt_Mask2         (Control_Status_Block + (WORD) 13)
#define CSB_Stop_Driver             (Control_Status_Block + (WORD) 14)
#define CSB_Restart_Driver          (Control_Status_Block + (WORD) 15)


/* */
/* define bits in interrupt status */
/* */
#define ISR_Cmnd            ((BYTE) 0x01)
#define ISR_Rx              ((BYTE) 0x02)
#define ISR_Tx              ((BYTE) 0x04)
#define ISR_Scan_Cmplt      ((BYTE) 0x08)
#define ISR_CFP_Starting    ((BYTE) 0x10)
#define ISR_DTIM            ((BYTE) 0x20)
#define ISR_RestartDriver   ((BYTE) 0x40)
#define ISR_StopDriver      ((BYTE) 0x80)

/* */
/* define bits in interrupt Mask */
/* */
#define IMR_Cmnd            ((BYTE) 0x01)
#define IMR_Rx              ((BYTE) 0x02)
#define IMR_Tx              ((BYTE) 0x04)
#define IMR_Scan_Cmplt      ((BYTE) 0x08)
#define IMR_CFP_Starting    ((BYTE) 0x10)
#define IMR_DTIM            ((BYTE) 0x20)

/* */
/* define bits in interrupt status2 */
/* */
#define ISR2_TxData         ((BYTE) 0x01)
#define ISR2_TxBcast        ((BYTE) 0x02)
#define ISR2_TxPSPoll       ((BYTE) 0x04)
#define ISR2_TxCFPoll       ((BYTE) 0x08)
#define ISR2_TxMgmt         ((BYTE) 0x10)
#define ISR2_Reserved       ((BYTE) 0x20)
#define ISR2_RxData         ((BYTE) 0x40)
#define ISR2_RxMgmt         ((BYTE) 0x80)


/* */
/*--------- Define MIB Group ------------ */
/* */
#define TYPE_LOCAL_MIB                  0
#define TYPE_MAC_ADDRESS_STATUS_GRP     2
#define TYPE_MAC_MIB                    3
#define TYPE_MAC_STATISTIC_MIB          4
#define TYPE_MAC_MGMT_MIB               5
#define TYPE_DRVR_MAC_MGMT_MIB          6
#define TYPE_PHY_MIB                    7
#define TYPE_EXTRA_MIB                  8

/* --------- LOCAL MIB index ---------- */
#define IDX_FRAGMENTATION_DIS           0
#define IDX_ADD_PLCP_DIS                1
#define IDX_MAC_HDR_PSRV                2
#define IDX_RX_MGMT_QUE_EN              3

#define IDX_RE_ASSEMBLY_DIS             4
#define IDX_STRIP_PLCP_DIS              5
#define IDX_RX_ERROR_DIS                6
#define IDX_POWER_SAVING_MODE_DIS       7
#define IDX_ACCEPT_ALL_MULTICAST_DIS    8
#define IDX_CHECK_SEQ_CNTL_DIS          9

#define IDX_RESERVED_LOCAL2             10
#define IDX_NETWORK_MODE                11
#define IDX_PWD_LVL                     12
#define IDX_CFP_ENABLE                  13

#define IDX_TX_BUFFER_OFFSET            14
#define IDX_TX_BUFFER_SIZE              18
#define IDX_RX_BUFFER_OFFSET            22
#define IDX_RX_BUFFER_SIZE              26

#define IDX_ACTING_AS_AP                27
#define IDX_FILL_CFP                    28


/* ----- MAC Address Status Index ----- */
#define IDX_MAC_ADDR                    0
#define IDX_GROUP_ADDR                  1
#define IDX_TRANSMIT_ENABLE             2
#define IDX_PROMISCUOUS                 3

typedef struct _Extra_MIB {
    BYTE    Channel;
    BYTE    CCR;
    BYTE    SecurityEnable;
    BYTE    SecurityKey[4];
    BYTE    RoamingEnable;
    MADDR   ESS_ID;
    MADDR   BSS_ID;
    BYTE    ApName[6];
    BYTE    Speed;
    BYTE    FreqDomain;
    BYTE    ReceiveMode;
    WORD    LocalMib;
    WORD    MacAddrStatusGrpMib;
    WORD    MacMib;
    WORD    MacStatisticMib;
    WORD    MacMgmtMib;
    WORD    DriverMacMgmtMib;
    WORD    PhyMib;
    WORD    ExtraMib;
} EXT_MIB, *PEXT_MIB;

/* ---------- EXTRA MIB index --------- */
#define IDX_CHANNEL                     0
#define IDX_CCR                         1
#define IDX_SECURITYENABLE              2
#define IDX_SECURITYKEY                 3
#define IDX_ROAMINGENABLE               7
#define IDX_ESSID                       8
#define IDX_BSSID                       14
#define IDX_APNAME                      20
#define IDX_SPEED                       26
#define IDX_FREQDOMAIN                  27
#define IDX_RECEIVEMODE                 28

/* ------ define CCR in EXTRA MIB ----- */
#define CCR_AP                          0
#define CCR_INFRA                       1
#define CCR_ADHOC                       2
#define CCR_IAP                         3

/* */
/* define roaming state */
/* */
#define RoamingState0                   0
#define RoamingState1                   1
#define RoamingState2                   2


/* */
/* define byte of Receive Mode in EXTRA MIB */
/* */
#define RMR_UNICAST                 ((BYTE) 0x01)
#define RMR_PROMISCUOUS             ((BYTE) 0x02)
#define RMR_ALL_MULTICAST           ((BYTE) 0x04)
#define RMR_BROADCAST               ((BYTE) 0x08)


/*
 * Refer IEEE 802.11
 */
 
/* */
/* Tx packet header, include PLCP and MPDU */
/* */

/*
 * Tx PLCP Header
 */
typedef struct _TX_PLCP_HDR {
    BYTE    SYNC[16];
    WORD    SFD;
    BYTE    SIGNAL;
    BYTE    SERVICE;
    WORD    LENGTH;
    WORD    CRC16;
} TX_PLCP_HDR, *PTX_PLCP_HDR;
 
/*
 * Data Frame MAC Header (IEEE 802.11)
 */
typedef struct _DATA_MAC_HDR {
    WORD    FrameControl;
    WORD    DurationID;
    MADDR   Address1;
    MADDR   Address2;
    MADDR   Address3;
    WORD    SequenceControl;
    MADDR   Address4;
} DATA_MAC_HDR, *PDATA_MAC_HDR;

typedef struct _TX_HEADER{
    TX_PLCP_HDR     PlcpHdr;
    DATA_MAC_HDR    MacHdr;
} TX_HEADER, * PTX_HEADER;

#define FRAME_CTRL_INFRA    ((WORD) 0x0108)
#define FRAME_CTRL_ADHOC    ((WORD) 0x0008)
#define FRAME_CTRL_AP       ((WORD) 0x0208)
#define FRAME_CTRL_IAP      ((WORD) 0x0308)
#define FRAME_CTRL_BEACON_LO   ((BYTE) 0x80)

/*
 * Management Frame MAC Header (IEEE 802.11)
 */
typedef struct _MGNT_MAC_HDR {
    WORD    FrameControl;
    WORD    DurationID;
    MADDR   DestAddr;
    MADDR   SrcAddr;
    MADDR   BSSID;
    WORD    SequenceControl;
} MGNT_MAC_HDR, *PMGNT_MAC_HDR;

/*
 * Beacon Frame Format (IEEE 802.11)
 */
typedef struct _BEACON_FRAME {
    DWORD   Timestamp[2];
    WORD    BeaconInterval;
    WORD    Capability;
    BYTE    SSID_ElementID;
    BYTE    SSID_Length;                /* should be equal to 6 */
    MADDR   SSID;
    BYTE    SupportedRates_ElementID;
    BYTE    SupportedRates_Length;      /* should be equal to 2 */
    BYTE    SupportedRates[2];
    BYTE    DS_ElementID;
    BYTE    DS_Length;                  /* should be equal to 0 */
    BYTE    DS_CurrentChannel;
} BEACON_FRAME, *PBEACON_FRAME;

/*
 * A Beacon Packet
 */
typedef struct _BEACON_PKT {
    MGNT_MAC_HDR    MacHdr;
    BEACON_FRAME    Frame;
    DWORD           CRC32;
} BEACON_PKT, *PBEACON_PKT;
 
#define DS_ELEMENT_ID   3

/* */
/* Tx Descriptor */
/* */
typedef struct _TX_DESC {
    DWORD   Tx_Start_of_Frame;
    DWORD   Next_Descriptor;
    WORD    Tx_Length;
    BYTE    Tx_State;
    BYTE    Tx_Rate;
    DWORD   Driver;
    DWORD   Reserved1;
    BYTE    Num_RTS_Attempts;
    BYTE    Num_Data_Attempts;
    BYTE    Control;
    BYTE    Reserved2;
} TX_DESC, * PTX_DESC;

#define TXD_Tx_Start_of_Frame       ((WORD) 0x00)
#define TXD_Next_Descriptor         ((WORD) sizeof(DWORD))
#define TXD_Tx_Length               ((WORD) (TXD_Next_Descriptor + sizeof(DWORD)))

/* Tx_State Flags */
#define TX_STATE_OWN_BY_SUTRO       ((BYTE) 0x80)
#define TX_STATE_DONE               ((BYTE) 0x40)
#define TX_STATE_REJECTED           ((BYTE) 0x20)
#define TX_STATE_TIMEOUT            ((BYTE) 0x10)
#define TX_STATE_ABORT              ((BYTE) 0x08)
#define TX_STATE_FIFO_UNDERFLOW     ((BYTE) 0x04)
#define TX_STATE_MAX_RETRIED        ((BYTE) 0x02)
#define TX_STATE_TX_ERROR           ((BYTE) 0x01)

/* Null of Next_Descriptor */
#define NULL_DESC                   ((DWORD) 0x80000000)

/* */
/* Rx Descriptor */
/* */
typedef struct _RX_DESC{
    DWORD   Reserved1;
    DWORD   Next_Descriptor;
    BYTE    Reserved2;
    BYTE    Rx_State;
    BYTE    RSSI;
    BYTE    Index;
    DWORD   Local_Time;
    DWORD   Rx_Start_Of_Frame;
    WORD    Rx_Length;
    BYTE    Rate;
    BYTE    Reserved3;
} RX_DESC, * PRX_DESC;

#define RXD_Reserved1               ((WORD) 0x00)
#define RXD_Next_Descriptor         ((WORD) sizeof(DWORD))
#define RXD_Reserved2               ((WORD) (RXD_Next_Descriptor + sizeof(DWORD)))
#define RXD_Rx_State                ((WORD) (RXD_Reserved2 + sizeof(BYTE)))
#define RXD_RSSI                    ((WORD) (RXD_Rx_State + sizeof(BYTE)))
#define RXD_Index                   ((WORD) (RXD_RSSI + sizeof(BYTE)))
#define RXD_Local_Time              ((WORD) (RXD_Index + sizeof(BYTE)))
#define RXD_Rx_Start_Of_Frame       ((WORD) (RXD_Local_Time + sizeof(DWORD)))
#define RXD_Rx_Length               ((WORD) (RXD_Rx_Start_Of_Frame + sizeof(DWORD)))
#define RXD_Rate                    ((WORD) (RXD_Rx_Length + sizeof(WORD)))

/* Rx_State Flags */
#define RX_STATE_OWN_BY_SUTRO       ((BYTE) 0x80)
#define RX_STATE_CONSUMED_BY_DRIVER ((BYTE) 0x40)
#define RX_STATE_LAST_FRAGMENT      ((BYTE) 0x20)
#define RX_STATE_RESERVED1          ((BYTE) 0x10)
#define RX_STATE_CRC_ERROR          ((BYTE) 0x08)
#define RX_STATE_RESERVED2          ((BYTE) 0x04)
#define RX_STATE_BUFFER_OVERFLOW    ((BYTE) 0x02)
#define RX_STATE_RX_ERROR           ((BYTE) 0x01)

typedef enum _RX_Q_TYPE {
    DATA_Q = 0,
    MGNT_Q = 1
} RX_Q_TYPE;

/* */
/* Command Block */
/* */
typedef struct _CMD_BLOCK {
    BYTE    Command;
    BYTE    Command_Status;
    BYTE    Error_Offset;
    BYTE    Reserved;
    BYTE    Command_Parameters[76];
} CMD_BLOCK, *PCMD_BLOCK;



#define EMPTY   ((BYTE)0xBB)
#define FULL    ((BYTE)0x02)

typedef struct _CSB_BLOCK {
    BYTE  Self_Test_Status;
    BYTE  STA_State;
    BYTE  Rsvd_For_User_Rtn;
    BYTE  Interrupt_Status;
    BYTE  Interrupt_Mask;
    BYTE  Lockout_SUTRO;
    BYTE  Lockout_Host;
    BYTE  Interrupt_Status2;
    DWORD Last_Completed_Tx_Desc;
    BYTE  Reserved;
    BYTE  Interrupt_Mask2;
    BYTE  Stop_Driver;
    BYTE  Restart_Driver;
} CSB_BLOCK, *PCSB_BLOCK;

/* */
/* Type of an interrupt. */
/* */

typedef enum {
    RECEIVE    = 0x01,
    TRANSMIT   = 0x02,
    OVERFLOW   = 0x04,
    COUNTER    = 0x08,
    UNKNOWN    = 0x10
} INTERRUPT_TYPE;

/* */
/* Result of Ne2000IndicatePacket(). */
/* */
typedef enum {
    INDICATE_OK,
    SKIPPED,
    ABORT,
    CARD_BAD
} INDICATE_STATUS;

/* TxQueue */
typedef struct _TX_Q {
    WORD    TxQHead;
    WORD    TxQTail;
} TX_Q, *PTX_Q;

/*
 * For linking allocated buffer
 */
typedef struct _TX_BUFFER_LINK {
    DWORD   ulNextBuf;
    DWORD   ulConsumed;
} TX_BUFFER_LINK, *PTX_BUFFER_LINK;


/**************************************************************************/
/* !!!!!!!              Restore old alignment setup               !!!!!!!!*/
/**************************************************************************/
#pragma pack ()


/*

   Reserve the beginning Tx space for descriptor use.


   TxBlockOffset -->  *----*----*----*----* \
    (TxFreeDesc)      |  0 |  1 |  2 |  3 |  \
                      |  4 |  5 |  6 |  7 |   |
                      |  8 |  9 | 10 | 11 |   TX_DESC * 20
                      | 12 | 13 | 14 | 15 |   |
                      | 16 | 17 | 18 | 19 |  /
   TxBufferBegin -->  *----*----*----*----* /
   (TxBufferHead)     |                   |
   (TxBufferTail)     |                   |
                      |    Send Buffer    |
                      |                   |
                      |                   |
                      *-------------------*
   TxBufferEnd -------------------------/      

*/

typedef struct _WL_Monitor {
    MADDR   MAddr;      /* Ethernet MAC address to monitor */
    WORD    RSSI;       /* Receive Signal Strength Indication */
    DWORD   TimeStamp;  /* 10 ms per unit */
} WL_Monitor, *PWL_Monitor;
   
typedef struct _WL_Adaptor {
    int     nBaseAddr;
    DWORD   ulTxBlockOffset;
    DWORD   ulTxBlockSize;
    MADDR   MacAddress;
    WORD    uTxFreeDesc;
    WORD    uTxBufferBegin;
    WORD    uTxBufferEnd;
    WORD    uTxBufferHead;
    WORD    uTxBufferTail;
    WORD    uTxSequence;
    TX_Q    qData;
    TX_Q    qManagement;
    TX_Q    qBroadcast;
    TX_Q    qPsPoll;
    TX_Q    qCfPoll;
    WORD    uRxDataQueue;
    WORD    uRxManagementQueue;
    EXT_MIB mibExtra;
    MADDR   CurrentBSSID;
    MADDR   KeepBSSID;
    DWORD   ulLastBeaconTime;
    WORD    uRoamingState;
    WL_Monitor  Monitor;
#ifdef LINUX_DRIVER
    struct  net_device_stats stat;   /* linux/if_ether.h */
#   ifdef WL_PCMCIA
        dev_node_t node;            /* PCMCIA only */
#   endif /* End of WL_PCMCIA */
#endif /* End of LINUX_DRIVER */

    WHEN_WLAPI_DEBUG(DWORD  ulDbgStat);
} WL_Adaptor, *PWL_Adaptor;

/*
 * API for accessing WL24xx SUTRO
 */
int  TraceNothing(const char *cpszFormat, ...);
void TraceBuf(void *pBuf, int nSize);
BOOL WL_GetFlashMacAddress(WL_Adaptor *pAdaptor);
void WL_FlashOutB(WL_Adaptor *pAdaptor, WORD uPage, WORD uAddr, BYTE cData);
BYTE WL_FlashInB(WL_Adaptor *pAdaptor, WORD uPage, WORD uAddr);
void WL_FlashInSB(WL_Adaptor *pAdaptor, WORD uPage, WORD uSrc, void *pDest, int nSize);
WORD WL_GetFlashID(WL_Adaptor *pAdaptor);
BOOL WL_FlashWriteOk(WL_Adaptor *pAdaptor);
BOOL WL_FlashEraseSector(WL_Adaptor *pAdaptor, WORD uSector);
BOOL WL_FlashWriteByte(WL_Adaptor *pAdaptor, WORD uPage, WORD uAddr, BYTE cData);
BOOL WL_SetMibInFlash(WL_Adaptor *pAdaptor);
BOOL WL_BlockInterrupt(WL_Adaptor *pAdaptor);
BOOL WL_UnBlockInterrupt(WL_Adaptor *pAdaptor);
BOOL WL_HoldSutro(WL_Adaptor *pAdaptor);
BOOL WL_UnHoldSutro(WL_Adaptor *pAdaptor);
void WL_InteruptWla(WL_Adaptor *pAdaptor);
void WL_SetToWla(WL_Adaptor *pAdaptor, WORD uDest, void *pSrc, int nSize);
void WL_GetFromWla(WL_Adaptor *pAdaptor, WORD uSrc, void *pDest, int nSize);
void WL_SetDescNext(WL_Adaptor *pAdaptor, WORD uDesc, DWORD ulNext);
DWORD WL_GetDescNext(WL_Adaptor *pAdaptor, WORD uDesc);
WORD WL_GetTxDesc(WL_Adaptor *pAdaptor);
void WL_FreeTxDesc(WL_Adaptor *pAdaptor, WORD uDesc);
BOOL WL_LockSutro(WL_Adaptor *pAdaptor);
void WL_UnlockSutro(WL_Adaptor *pAdaptor);
WORD WL_GetTxBuffer(WL_Adaptor *pAdaptor, WORD uDataLen);
void WL_FreeTxBuffer(WL_Adaptor *pAdaptor, WORD uPtr);
void WL_PurgeTxQueue(WL_Adaptor *pAdaptor, TX_Q *pTxQ);
BOOL WL_EnableReceiver(WL_Adaptor *pAdaptor);
BOOL WL_InitTx(WL_Adaptor *pAdaptor);
BOOL WL_GetMibValue(WL_Adaptor *pAdaptor, BYTE cGroup, BYTE cIndex, void *pDest, BYTE cSize);
BOOL WL_SetMibValue(WL_Adaptor *pAdaptor, BYTE cGroup, BYTE cIndex, void *pSrc, BYTE cSize);
BOOL WL_ResetBoard(WL_Adaptor *pAdaptor);
BOOL WL_InitFirmware(WL_Adaptor *pAdaptor);
BOOL WL_SendPkt(WL_Adaptor *pAdaptor, BYTE *pData, WORD uLen, BYTE cRate);
int  WL_ReceiveLook(WL_Adaptor *pAdaptor, RX_Q_TYPE uQueueType);
WORD WL_Receive(WL_Adaptor *pAdaptor, RX_Q_TYPE uQueueType, WORD uOffset, 
        BYTE *pBuf, WORD uSize, DWORD *plTimeStamp);
BOOL WL_ReceiveDone(WL_Adaptor *pAdaptor, RX_Q_TYPE uQueueType);
int  WL_ReceiveDataLook(WL_Adaptor *pAdaptor);
WORD WL_ReceiveData(WL_Adaptor *pAdaptor, WORD uOffset, BYTE *pBuf, WORD uSize);
BOOL WL_ReceiveDataDone(WL_Adaptor *pAdaptor);
void WL_Roaming(WL_Adaptor *pAdaptor);

#endif /* __WLAPI_H__ */
