#include <linux/ioctl.h>

/* ioctl's */
#define PROCINFO_IOCTL_BASE 250

#define PROCINFO_IOC_GET_PARAMS _IOR(PROCINFO_IOCTL_BASE, 0x01, int)
#define PROCINFO_IOC_SET_PARAMS _IOW(PROCINFO_IOCTL_BASE, 0x02, int)
#define PROCINFO_IOC_ADD_FILTER _IOW(PROCINFO_IOCTL_BASE, 0x03, int)
#define PROCINFO_IOC_RESET_FILTERS _IOW(PROCINFO_IOCTL_BASE, 0x04, int)

struct procinfo_params {
        int reclen;
        int cmdline_len;
        int env_len;
        unsigned long flags;
};


/* filters */
#define PROCINFO_FLT_COMM   0
#define PROCINFO_FLT_RGID   1
#define PROCINFO_FLT_RUID   2
#define PROCINFO_FLT_SID    3
#define PROCINFO_FLT_PID    4
#define PROCINFO_FLT_TTY    5
#define PROCINFO_FLT_EUID   6
#define PROCINFO_FLT_EGID   7

#define PROCINFO_FLT_MAX    7

struct procinfo_filter {
        unsigned char type;
        unsigned char flags;
        union {
                char comm[17];
                unsigned short uint16;
                unsigned long uint32;
        } arg;
};


/* flags */
#define PI_GET_VM_INFO       1
#define PI_GET_PAGE_INFO     2
#define PI_GET_ENV_INFO      4
#define PI_GET_CMDLINE_INFO  8
#define PI_GET_SIGNAL_INFO  16
#define PI_AND_FILTER       32
#define PI_NEGATE_FILTER    64
#define PI_RUN_FILTER      128


#ifndef NGROUPS
#define NGROUPS 32
#endif


struct procinfo_process {
	long state;
	unsigned long flags;
	unsigned long ptrace;
	long nice;
        long priority;
	int pid;
        int ppid;
	int pgrp;
	int session;
	int tgid;	
	int leader; /* boolean value for session group leader */
	unsigned long rt_priority;        
	unsigned long start_time;
        long utime, stime;
        
        /* mm fault and swap info: this can arguably be seen as either mm-specific or thread-specific */
	unsigned long min_flt, maj_flt, nswap, cmin_flt, cmaj_flt, cnswap;

        unsigned long it_real_value;
        unsigned long rss_lim;
        
        /* process credentials */
	unsigned short uid,euid,suid,fsuid;
	unsigned short gid,egid,sgid,fsgid;
        
	int ngroups;
	unsigned short groups[NGROUPS];

        unsigned long eip, esp, stack, wchan;
        
	char comm[16];
        
	unsigned short tty; /* NULL if no tty */
        
	unsigned long blocked;
	unsigned long pending;
        unsigned long catch;
        unsigned long ignored;

        /* VM data */
        unsigned long vmsize; /* in KBs */
        unsigned long vmlocked;
        unsigned long vmrss;
        unsigned long vmdata;
        unsigned long vmstack;
        unsigned long vmexec;
        unsigned long vmlib;

        int cmdline_len;
        int env_len;
};

#ifndef offsetof
#define offsetof(TYPE, MEMBER) ((size_t) &((TYPE *)0)->MEMBER)
#endif


#define VMDATA_OFFSET (offsetof(struct procinfo_process,vmsize))
#define VMDATA_SIZE   ((offsetof(struct procinfo_process,vmlib)) - (offsetof(struct procinfo_process,vmsize)) + sizeof (unsigned long))
